import{s as jn,o as wn,n as cn}from"../chunks/scheduler.cd324960.js";import{S as Un,i as rn,e as p,s as a,c as i,h as un,a as M,d as t,b as n,f as Tn,g as J,j as y,k as la,l as hn,m as s,n as m,t as T,o as j,p as w}from"../chunks/index.d5c3adcc.js";import{T as dn}from"../chunks/Tip.889bec11.js";import{C as fn,H as u,E as on}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.14d935fa.js";import{C as c}from"../chunks/CodeBlock.77426a60.js";function bn(Be){let U,o=`В нашем примере мы будем использовать около 40 часов обучающих данных. Если вы хотите повторить этот процесс, используя бесплатный тарифный план Google Colab,
необходимо уменьшить объем обучающих данных примерно до 10-15 часов и сократить количество шагов обучения.`;return{c(){U=p("p"),U.textContent=o},l(r){U=M(r,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1ywpoki"&&(U.textContent=o)},m(r,_e){s(r,U,_e)},p:cn,d(r){r&&t(U)}}}function Cn(Be){let U,o,r,_e,b,We,C,ve,I,ea=`Теперь, когда вы знакомы с задачей преобразования текста в речь и внутренним устройством модели SpeechT5, которая была предварительно обучена
на англоязычных данных, давайте посмотрим, как мы можем дообучить ее для другого языка.`,Xe,$,Ee,Z,ta="Если вы хотите воспроизвести этот пример, убедитесь, что у вас есть графический процессор. В блокноте это можно проверить с помощью следующей команды:",Ye,k,Ne,h,De,R,sa="Вам также понадобятся некоторые дополнительные зависимости:",ze,x,Fe,A,aa="Наконец, не забудьте войти в свою учетную запись Hugging Face, чтобы загрузить свою модель и поделиться ею с сообществом:",He,Q,Se,g,qe,V,na=`В данном примере мы возьмем подмножество голландского (<code>nl</code>) языка из датасета <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a>.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> - это обширный многоязычный речевой корпус, состоящий из данных,
полученных из записей мероприятий Европейского парламента 2009-2020 гг. Он содержит маркированные данные аудио-транскрипций для 15 европейских языков.
Хотя мы будем использовать подмножество голландского языка, вы можете выбрать другое подмножество.`,Le,_,pa=`Это набор данных автоматического распознавания речи (ASR), поэтому, как уже говорилось, он не является наиболее подходящим
вариантом для обучения TTS-моделей. Однако для данного упражнения этого будет вполне достаточно.`,Pe,G,Ma="Давайте загрузим данные:",Ke,B,Oe,W,ya="<strong>Output:</strong>",lt,v,et,X,ia=`20968 примеров должно быть достаточно для дообучения. Для SpeechT5 требуется, чтобы частота дискретизации аудиоданных составляла 16 кГц, поэтому
убедимся, что примеры в наборе данных соответствуют этому требованию:`,tt,E,st,Y,at,N,Ja=`Начнем с определения используемой контрольной точки модели и загрузки соответствующего процессора, содержащего как токенизатор,
так и экстрактор признаков, которые понадобятся нам для подготовки данных к обучению:`,nt,D,pt,z,Mt,F,ma="Во-первых, для подготовки текста нам понадобится часть процессора - токенизатор, поэтому возьмем его:",yt,H,it,S,Ta="Рассмотрим пример:",Jt,q,mt,L,ja="<strong>Output:</strong>",Tt,P,jt,K,wa=`Можно заметить, что примеры из датасета содержат признаки <code>raw_text</code> и <code>normalized_text</code>. При выборе признака
в качестве входного текста важно знать, что в токенизаторе SpeechT5 нет токенов для чисел. В <code>normalized_text</code>
числа записываются в виде текста. Таким образом, он лучше подходит, и в качестве входного текста следует использовать <code>normalized_text</code>.`,wt,O,ca=`Поскольку SpeechT5 обучалась на английском языке, она может не распознать некоторые символы в голландском наборе данных. Если
оставить все как есть, то эти символы будут преобразованы в токены <code>&lt;unk&gt;</code>. Однако в голландском языке некоторые символы, например <code>à</code>, используются
для выделения слогов. Чтобы сохранить смысл текста, можно заменить этот символ на обычное <code>a</code>.`,ct,ll,Ua=`Чтобы выявить неподдерживаемые токены, извлечем все уникальные символы из датасета с помощью <code>SpeechT5Tokenizer</code>, который
работает с символами как с токенами. Для этого напишем функцию отображения <code>extract_all_chars</code>, которая объединяет
транскрипции из всех примеров в одну строку и преобразует ее в набор символов. [NL]
Обязательно задайте <code>batched=True</code> и <code>batch_size=-1</code> в <code>dataset.map()</code>, чтобы все транскрипции были доступны сразу для
функции отображения.`,Ut,el,rt,tl,ra=`Теперь у вас есть два набора символов: один со словарем из датасета, другой - со словарем из токенизатора.
Для выявления неподдерживаемых символов в наборе данных можно взять разность между этими двумя наборами. Полученный набор
будет содержать символы, которые есть в наборе данных, но отсутствуют в токенизаторе.`,ut,sl,ht,al,ua="<strong>Output:</strong>",dt,nl,ft,pl,ha=`Для работы с неподдерживаемыми символами, выявленными на предыдущем этапе, можно определить функцию, которая сопоставляет эти символы с допустимыми токенами.
Заметим, что пробелы уже заменены на <code>▁</code> в токенизаторе и не нуждаются в отдельной обработке.`,ot,Ml,bt,yl,da="Теперь, когда мы разобрались со специальными символами в тексте, пришло время переключить внимание на аудио данные.",Ct,il,It,Jl,fa=`Набор данных VoxPopuli включает речь нескольких дикторов, но сколько дикторов представлено в наборе? Чтобы
определить это, мы можем подсчитать количество уникальных дикторов и количество примеров, которые каждый диктор вносит в набор данных.
Учитывая, что всего в наборе данных 20 968 примеров, эта информация позволит нам лучше понять распределение
дикторов и примеров в данных.`,$t,ml,Zt,Tl,oa="Построив гистограмму, можно получить представление о том, сколько данных имеется для каждого диктора.",kt,jl,Rt,d,ba='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',xt,wl,Ca=`Гистограмма показывает, что примерно треть дикторов в наборе данных имеет менее 100 примеров, в то время как
около десяти дикторов имеют более 500 примеров. Чтобы повысить эффективность обучения и сбалансировать набор данных, мы можем ограничить
данные дикторами, имеющими от 100 до 400 примеров.`,At,cl,Qt,Ul,Ia="Проверим, сколько осталось дикторов:",gt,rl,Vt,ul,$a="<strong>Output:</strong>",_t,hl,Gt,dl,Za="Посмотрим, сколько осталось примеров:",Bt,fl,Wt,ol,ka="<strong>Output:</strong>",vt,bl,Xt,Cl,Ra="В результате вы получаете чуть менее 10 000 примеров из примерно 40 уникальных дикторов, что должно быть вполне достаточно.",Et,Il,xa=`Отметим, что некоторые дикторы с небольшим количеством примеров могут иметь больше аудиофайлов, если примеры длинные. Однако
определение общего объема аудиозаписей для каждого диктора требует сканирования всего датасета, что является
трудоемким процессом, включающим загрузку и декодирование каждого аудиофайла. Поэтому в данном случае мы решили пропустить этот этап.`,Yt,$l,Nt,Zl,Aa=`Для того чтобы модель TTS могла различать несколько дикторов, необходимо создать эмбеддинги диктора для каждого примера.
Эмбеддинги дикторов - это дополнительный вход для модели, который фиксирует характеристики голоса конкретного диктора.
Для создания эмбеддингов диктора используется предварительно обученная модель <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
от SpeechBrain.`,Dt,kl,Qa=`Создадим функцию <code>create_speaker_embedding()</code>, которая принимает входную волновую форму звука и выдает 512-элементный вектор,
содержащий соответствующие эмбеддинги диктора.`,zt,Rl,Ft,xl,ga=`Важно отметить, что модель <code>speechbrain/spkrec-xvect-voxceleb</code> была обучена на английской речи из датасета VoxCeleb,
в то время как учебные примеры в данном руководстве представлены на голландском языке. Хотя мы считаем, что данная модель все равно будет генерировать разумные эмбеддинги диктора
для нашего голландского датасета, это предположение может быть справедливо не во всех случаях.`,Ht,Al,Va=`Для получения оптимальных результатов необходимо сначала обучить модель X-вектора на целевой речи. Это позволит модели
лучше улавливать уникальные речевые особенности, присущие голландскому языку. Если вы хотите обучить свою собственную X-векторную модель,
то в качестве примера можно использовать <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">этот скрипт</a>.`,St,Ql,qt,gl,_a=`Наконец, обработаем данные в тот формат, который ожидает модель. Создадим функцию <code>prepare_dataset</code>, которая принимает
один пример и использует объект <code>SpeechT5Processor</code> для токенизации входного текста и загрузки целевого аудио в лог-мел спектрограмму.
Она также должна добавлять эмбеддинги диктора в качестве дополнительного входного сигнала.`,Lt,Vl,Pt,_l,Ga="Проверить правильность обработки можно на одном из примеров:",Kt,Gl,Ot,Bl,Ba="<strong>Output:</strong>",ls,Wl,es,vl,Wa="Эмбеддинги диктора должны представлять собой 512-элементный вектор:",ts,Xl,ss,El,va="<strong>Output:</strong>",as,Yl,ns,Nl,Xa="Метки должны представлять собой лог-мел спектрограмму с 80 мел бинами.",ps,Dl,Ms,f,Ea='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',ys,zl,Ya=`Примечание: Если данная спектрограмма кажется вам непонятной, то это может быть связано с тем, что вы привыкли располагать низкие частоты
внизу, а высокие - вверху графика. Однако при построении спектрограмм в виде изображения с помощью библиотеки matplotlib ось y
переворачивается, и спектрограммы выглядят перевернутыми.`,is,Fl,Na="Теперь необходимо применить функцию препроцессинга ко всему набору данных. Это займет от 5 до 10 минут.",Js,Hl,ms,Sl,Da=`Появится предупреждение о том, что длина некоторых примеров в датасете превышает максимальную длину входных данных, которую может обработать модель (600 лексем).
Удалите эти примеры из датасета. Здесь мы идем еще дальше и для того, чтобы увеличить размер батча, удаляем все, что превышает 200 токенов.`,Ts,ql,js,Ll,za="<strong>Output:</strong>",ws,Pl,cs,Kl,Fa="Затем создадим базовое разделение на тренировочную и тестовую части:",Us,Ol,rs,le,us,ee,Ha=`Для того чтобы объединить несколько примеров в батч, необходимо определить пользовательский коллатор данных. Этот коллатор будет дополнять более короткие последовательности токенами,
гарантируя, что все примеры будут иметь одинаковую длину. Для меток спектрограммы дополняемая части заменяются на специальное значение <code>-100</code>.
Это специальное значение указывает модели игнорировать эту часть спектрограммы при расчете потерь спектрограммы.`,hs,te,ds,se,Sa=`В SpeechT5 входная информация для декодера уменьшается в 2 раза. Другими словами, отбрасывается каждый второй
временной шаг из целевой последовательности.Затем декодер предсказывает последовательность, которая в два раза длиннее. Поскольку исходная длина
целевой последовательности [NL] может быть нечетной, коллатор данных обязательно округляет максимальную длину батча до значения [NL], кратного 2.`,fs,ae,os,ne,bs,pe,qa="Загрузите предварительно обученную модель из той же контрольной точки, которая использовалась для загрузки процессора:",Cs,Me,Is,ye,La=`Опция <code>use_cache=True</code> несовместима с использованием градиентных контрольных точек. Отключите ее для обучения и снова включите кэш для генерации,
чтобы ускорить  инференс:`,$s,ie,Zs,Je,Pa=`Определим аргументы обучения. Здесь мы не вычисляем никаких оценочных метрик в процессе обучения,
мы поговорим об оценке позже в этой главе. Вместо этого мы будем рассматривать только потери:`,ks,me,Rs,Te,Ka="Инстанцируем объект <code>Trainer</code> и передаем ему модель, набор данных и коллатор данных.",xs,je,As,we,Oa=`И с этим мы готовы приступить к обучению! Обучение займет несколько часов. В зависимости от используемого GPU
возможно, что при начале обучения возникнет ошибка CUDA “out-of-memory”. В этом случае можно уменьшить
размер <code>per_device_train_batch_size</code> постепенно в 2 раза и увеличить <code>gradient_accumulation_steps</code> в 2 раза, чтобы компенсировать это.`,Qs,ce,gs,Ue,ln="Push the final model to the 🤗 Hub:",Vs,re,_s,ue,Gs,he,en=`После того как модель дообучена, ее можно использовать для инференса! Загрузите модель из 🤗 Hub (убедитесь, что в
следующем фрагменте кода используется имя вашей учетной записи):`,Bs,de,Ws,fe,tn="Выберем пример, здесь мы возьмем пример из тестового набора данных. Получаем эмбеддинги диктора.",vs,oe,Xs,be,sn="Определим некоторый входной текст и токенизируем его.",Es,Ce,Ys,Ie,an="Выполним препроцессинг входного текста:",Ns,$e,Ds,Ze,nn="Инстанцируем вокодер и сгенерируем речь:",zs,ke,Fs,Re,pn="Готовы послушать результат?",Hs,xe,Ss,Ae,Mn=`Получение удовлетворительных результатов с помощью этой модели на новом языке может оказаться непростой задачей. Качество эмбеддингов диктора
может быть существенным фактором. Поскольку SpeechT5 была предварительно обучена на английских x-векторах, она показывает наилучшие результаты
при использовании эмбеддингов английских дикторов. Если синтезированная речь звучит плохо, попробуйте использовать другие эмбеддинги диктора.`,qs,Qe,yn=`Увеличение продолжительности обучения, вероятно, также повысит качество результатов. Несмотря на это, речь явно голландская, а не английская, и в ней
передаются особенности голоса говорящего (сравните с оригинальным аудио в примере).
Еще один момент, с которым можно поэкспериментировать, - это настройка модели. Например, попробуйте использовать <code>config.reduction_factor = 1</code>, чтобы
посмотреть, улучшит ли это результаты.`,Ls,ge,Jn="В следующем разделе мы расскажем о том, как мы оцениваем модели преобразования текста в речь.",Ps,Ve,Ks,Ge,Os;return b=new fn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new u({props:{title:"Дообучение SpeechT5",local:"дообучение-speecht5",headingTag:"h1"}}),$=new u({props:{title:"House-keeping",local:"house-keeping",headingTag:"h2"}}),k=new c({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),h=new dn({props:{warning:!0,$$slots:{default:[bn]},$$scope:{ctx:Be}}}),x=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),Q=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),g=new u({props:{title:"Набор данных",local:"набор-данных",headingTag:"h2"}}),B=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),v=new c({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),E=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),Y=new u({props:{title:"Препроцессинг данных",local:"препроцессинг-данных",headingTag:"h2"}}),D=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),z=new u({props:{title:"Очистка текста для токенизации SpeechT5",local:"очистка-текста-для-токенизации-speecht5",headingTag:"h3"}}),H=new c({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),q=new c({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),P=new c({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),el=new c({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),sl=new c({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),nl=new c({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),Ml=new c({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),il=new u({props:{title:"Дикторы",local:"дикторы",headingTag:"h3"}}),ml=new c({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),jl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),cl=new c({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),rl=new c({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),hl=new c({props:{code:"NDI=",highlighted:"42",wrap:!1}}),fl=new c({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),bl=new c({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),$l=new u({props:{title:"Эмбеддинги диктора",local:"эмбеддинги-диктора",headingTag:"h3"}}),Rl=new c({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),Ql=new u({props:{title:"Обработка датасета",local:"обработка-датасета",headingTag:"h3"}}),Vl=new c({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Gl=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Wl=new c({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),Xl=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),Yl=new c({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),Dl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),Hl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),ql=new c({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Pl=new c({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Ol=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),le=new u({props:{title:"Коллатор данных",local:"коллатор-данных",headingTag:"h3"}}),te=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># not used during fine-tuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># also add in the speaker embeddings</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ae=new c({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),ne=new u({props:{title:"Обучение модели",local:"обучение-модели",headingTag:"h2"}}),Me=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),ie=new c({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjAlRDAlQkUlRDElODIlRDAlQkElRDAlQkIlRDElOEUlRDElODclRDAlQjglRDElODIlRDElOEMlMjAlRDAlQkElRDElOEQlRDElODglMjAlRDAlQjIlRDAlQkUlMjAlRDAlQjIlRDElODAlRDAlQjUlRDAlQkMlRDElOEYlMjAlRDAlQkUlRDAlQjElRDElODMlRDElODclRDAlQjUlRDAlQkQlRDAlQjglRDElOEYlMkMlMjAlRDElODIlRDAlQjAlRDAlQkElMjAlRDAlQkElRDAlQjAlRDAlQkElMjAlRDAlQkUlRDAlQkQlMjAlRDAlQkQlRDAlQjUlRDElODElRDAlQkUlRDAlQjIlRDAlQkMlRDAlQjUlRDElODElRDElODIlRDAlQjglRDAlQkMlMjAlRDElODElMjAlRDAlQjMlRDElODAlRDAlQjAlRDAlQjQlRDAlQjglRDAlQjUlRDAlQkQlRDElODIlRDAlQkQlRDElOEIlRDAlQkMlRDAlQjglMjAlRDAlQkElRDAlQkUlRDAlQkQlRDElODIlRDElODAlRDAlQkUlRDAlQkIlRDElOEMlRDAlQkQlRDElOEIlRDAlQkMlRDAlQjglMjAlRDElODIlRDAlQkUlRDElODclRDAlQkElRDAlQjAlRDAlQkMlRDAlQjglMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjAlRDAlQjclRDAlQjAlRDAlQjQlRDAlQjAlRDAlQkQlRDAlQjglRDAlQkMlMjAlRDElOEYlRDAlQjclRDElOEIlRDAlQkElMjAlRDAlQjglMjAlRDAlQjclRDAlQjAlRDAlQjQlRDAlQjAlRDElODclRDElODMlMjAlRDAlQjQlRDAlQkIlRDElOEYlMjAlRDAlQjMlRDAlQjUlRDAlQkQlRDAlQjUlRDElODAlRDAlQjAlRDElODYlRDAlQjglRDAlQjglMjAlRDAlQjglMjAlRDElODElRDAlQkQlRDAlQkUlRDAlQjIlRDAlQjAlMjAlRDAlQjIlRDAlQkElRDAlQkIlRDElOEUlRDElODclRDAlQjglRDAlQkMlMjAlRDAlQkElRDElOEQlRDElODglMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># отключить кэш во время обучения, так как он несовместим с градиентными контрольными точками</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># заданим язык и задачу для генерации и снова включим кэш</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),je=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),ce=new c({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),re=new c({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),ue=new u({props:{title:"Инференс",local:"инференс",headingTag:"h2"}}),de=new c({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),oe=new c({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Ce=new c({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),$e=new c({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ke=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),xe=new c({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Ve=new on({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter6/fine-tuning.mdx"}}),{c(){U=p("meta"),o=a(),r=p("p"),_e=a(),i(b.$$.fragment),We=a(),i(C.$$.fragment),ve=a(),I=p("p"),I.textContent=ea,Xe=a(),i($.$$.fragment),Ee=a(),Z=p("p"),Z.textContent=ta,Ye=a(),i(k.$$.fragment),Ne=a(),i(h.$$.fragment),De=a(),R=p("p"),R.textContent=sa,ze=a(),i(x.$$.fragment),Fe=a(),A=p("p"),A.textContent=aa,He=a(),i(Q.$$.fragment),Se=a(),i(g.$$.fragment),qe=a(),V=p("p"),V.innerHTML=na,Le=a(),_=p("p"),_.textContent=pa,Pe=a(),G=p("p"),G.textContent=Ma,Ke=a(),i(B.$$.fragment),Oe=a(),W=p("p"),W.innerHTML=ya,lt=a(),i(v.$$.fragment),et=a(),X=p("p"),X.textContent=ia,tt=a(),i(E.$$.fragment),st=a(),i(Y.$$.fragment),at=a(),N=p("p"),N.textContent=Ja,nt=a(),i(D.$$.fragment),pt=a(),i(z.$$.fragment),Mt=a(),F=p("p"),F.textContent=ma,yt=a(),i(H.$$.fragment),it=a(),S=p("p"),S.textContent=Ta,Jt=a(),i(q.$$.fragment),mt=a(),L=p("p"),L.innerHTML=ja,Tt=a(),i(P.$$.fragment),jt=a(),K=p("p"),K.innerHTML=wa,wt=a(),O=p("p"),O.innerHTML=ca,ct=a(),ll=p("p"),ll.innerHTML=Ua,Ut=a(),i(el.$$.fragment),rt=a(),tl=p("p"),tl.textContent=ra,ut=a(),i(sl.$$.fragment),ht=a(),al=p("p"),al.innerHTML=ua,dt=a(),i(nl.$$.fragment),ft=a(),pl=p("p"),pl.innerHTML=ha,ot=a(),i(Ml.$$.fragment),bt=a(),yl=p("p"),yl.textContent=da,Ct=a(),i(il.$$.fragment),It=a(),Jl=p("p"),Jl.textContent=fa,$t=a(),i(ml.$$.fragment),Zt=a(),Tl=p("p"),Tl.textContent=oa,kt=a(),i(jl.$$.fragment),Rt=a(),d=p("div"),d.innerHTML=ba,xt=a(),wl=p("p"),wl.textContent=Ca,At=a(),i(cl.$$.fragment),Qt=a(),Ul=p("p"),Ul.textContent=Ia,gt=a(),i(rl.$$.fragment),Vt=a(),ul=p("p"),ul.innerHTML=$a,_t=a(),i(hl.$$.fragment),Gt=a(),dl=p("p"),dl.textContent=Za,Bt=a(),i(fl.$$.fragment),Wt=a(),ol=p("p"),ol.innerHTML=ka,vt=a(),i(bl.$$.fragment),Xt=a(),Cl=p("p"),Cl.textContent=Ra,Et=a(),Il=p("p"),Il.textContent=xa,Yt=a(),i($l.$$.fragment),Nt=a(),Zl=p("p"),Zl.innerHTML=Aa,Dt=a(),kl=p("p"),kl.innerHTML=Qa,zt=a(),i(Rl.$$.fragment),Ft=a(),xl=p("p"),xl.innerHTML=ga,Ht=a(),Al=p("p"),Al.innerHTML=Va,St=a(),i(Ql.$$.fragment),qt=a(),gl=p("p"),gl.innerHTML=_a,Lt=a(),i(Vl.$$.fragment),Pt=a(),_l=p("p"),_l.textContent=Ga,Kt=a(),i(Gl.$$.fragment),Ot=a(),Bl=p("p"),Bl.innerHTML=Ba,ls=a(),i(Wl.$$.fragment),es=a(),vl=p("p"),vl.textContent=Wa,ts=a(),i(Xl.$$.fragment),ss=a(),El=p("p"),El.innerHTML=va,as=a(),i(Yl.$$.fragment),ns=a(),Nl=p("p"),Nl.textContent=Xa,ps=a(),i(Dl.$$.fragment),Ms=a(),f=p("div"),f.innerHTML=Ea,ys=a(),zl=p("p"),zl.textContent=Ya,is=a(),Fl=p("p"),Fl.textContent=Na,Js=a(),i(Hl.$$.fragment),ms=a(),Sl=p("p"),Sl.textContent=Da,Ts=a(),i(ql.$$.fragment),js=a(),Ll=p("p"),Ll.innerHTML=za,ws=a(),i(Pl.$$.fragment),cs=a(),Kl=p("p"),Kl.textContent=Fa,Us=a(),i(Ol.$$.fragment),rs=a(),i(le.$$.fragment),us=a(),ee=p("p"),ee.innerHTML=Ha,hs=a(),i(te.$$.fragment),ds=a(),se=p("p"),se.textContent=Sa,fs=a(),i(ae.$$.fragment),os=a(),i(ne.$$.fragment),bs=a(),pe=p("p"),pe.textContent=qa,Cs=a(),i(Me.$$.fragment),Is=a(),ye=p("p"),ye.innerHTML=La,$s=a(),i(ie.$$.fragment),Zs=a(),Je=p("p"),Je.textContent=Pa,ks=a(),i(me.$$.fragment),Rs=a(),Te=p("p"),Te.innerHTML=Ka,xs=a(),i(je.$$.fragment),As=a(),we=p("p"),we.innerHTML=Oa,Qs=a(),i(ce.$$.fragment),gs=a(),Ue=p("p"),Ue.textContent=ln,Vs=a(),i(re.$$.fragment),_s=a(),i(ue.$$.fragment),Gs=a(),he=p("p"),he.textContent=en,Bs=a(),i(de.$$.fragment),Ws=a(),fe=p("p"),fe.textContent=tn,vs=a(),i(oe.$$.fragment),Xs=a(),be=p("p"),be.textContent=sn,Es=a(),i(Ce.$$.fragment),Ys=a(),Ie=p("p"),Ie.textContent=an,Ns=a(),i($e.$$.fragment),Ds=a(),Ze=p("p"),Ze.textContent=nn,zs=a(),i(ke.$$.fragment),Fs=a(),Re=p("p"),Re.textContent=pn,Hs=a(),i(xe.$$.fragment),Ss=a(),Ae=p("p"),Ae.textContent=Mn,qs=a(),Qe=p("p"),Qe.innerHTML=yn,Ls=a(),ge=p("p"),ge.textContent=Jn,Ps=a(),i(Ve.$$.fragment),Ks=a(),Ge=p("p"),this.h()},l(l){const e=un("svelte-u9bgzb",document.head);U=M(e,"META",{name:!0,content:!0}),e.forEach(t),o=n(l),r=M(l,"P",{}),Tn(r).forEach(t),_e=n(l),J(b.$$.fragment,l),We=n(l),J(C.$$.fragment,l),ve=n(l),I=M(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-8bltl"&&(I.textContent=ea),Xe=n(l),J($.$$.fragment,l),Ee=n(l),Z=M(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-izsfon"&&(Z.textContent=ta),Ye=n(l),J(k.$$.fragment,l),Ne=n(l),J(h.$$.fragment,l),De=n(l),R=M(l,"P",{"data-svelte-h":!0}),y(R)!=="svelte-xcyd0c"&&(R.textContent=sa),ze=n(l),J(x.$$.fragment,l),Fe=n(l),A=M(l,"P",{"data-svelte-h":!0}),y(A)!=="svelte-1n5cqib"&&(A.textContent=aa),He=n(l),J(Q.$$.fragment,l),Se=n(l),J(g.$$.fragment,l),qe=n(l),V=M(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1wrmkii"&&(V.innerHTML=na),Le=n(l),_=M(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-wlzddh"&&(_.textContent=pa),Pe=n(l),G=M(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-tndgny"&&(G.textContent=Ma),Ke=n(l),J(B.$$.fragment,l),Oe=n(l),W=M(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1mvdyro"&&(W.innerHTML=ya),lt=n(l),J(v.$$.fragment,l),et=n(l),X=M(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1qhkgx9"&&(X.textContent=ia),tt=n(l),J(E.$$.fragment,l),st=n(l),J(Y.$$.fragment,l),at=n(l),N=M(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-hacnda"&&(N.textContent=Ja),nt=n(l),J(D.$$.fragment,l),pt=n(l),J(z.$$.fragment,l),Mt=n(l),F=M(l,"P",{"data-svelte-h":!0}),y(F)!=="svelte-pxsz1o"&&(F.textContent=ma),yt=n(l),J(H.$$.fragment,l),it=n(l),S=M(l,"P",{"data-svelte-h":!0}),y(S)!=="svelte-hhmg0u"&&(S.textContent=Ta),Jt=n(l),J(q.$$.fragment,l),mt=n(l),L=M(l,"P",{"data-svelte-h":!0}),y(L)!=="svelte-1mvdyro"&&(L.innerHTML=ja),Tt=n(l),J(P.$$.fragment,l),jt=n(l),K=M(l,"P",{"data-svelte-h":!0}),y(K)!=="svelte-4zb4lk"&&(K.innerHTML=wa),wt=n(l),O=M(l,"P",{"data-svelte-h":!0}),y(O)!=="svelte-okgqir"&&(O.innerHTML=ca),ct=n(l),ll=M(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-1ysmakp"&&(ll.innerHTML=Ua),Ut=n(l),J(el.$$.fragment,l),rt=n(l),tl=M(l,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-1frt52r"&&(tl.textContent=ra),ut=n(l),J(sl.$$.fragment,l),ht=n(l),al=M(l,"P",{"data-svelte-h":!0}),y(al)!=="svelte-1mvdyro"&&(al.innerHTML=ua),dt=n(l),J(nl.$$.fragment,l),ft=n(l),pl=M(l,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-fg573h"&&(pl.innerHTML=ha),ot=n(l),J(Ml.$$.fragment,l),bt=n(l),yl=M(l,"P",{"data-svelte-h":!0}),y(yl)!=="svelte-138gm4p"&&(yl.textContent=da),Ct=n(l),J(il.$$.fragment,l),It=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),y(Jl)!=="svelte-t1t9qy"&&(Jl.textContent=fa),$t=n(l),J(ml.$$.fragment,l),Zt=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),y(Tl)!=="svelte-7t0xxj"&&(Tl.textContent=oa),kt=n(l),J(jl.$$.fragment,l),Rt=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),y(d)!=="svelte-1uufiik"&&(d.innerHTML=ba),xt=n(l),wl=M(l,"P",{"data-svelte-h":!0}),y(wl)!=="svelte-15je7j5"&&(wl.textContent=Ca),At=n(l),J(cl.$$.fragment,l),Qt=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),y(Ul)!=="svelte-u7eqkn"&&(Ul.textContent=Ia),gt=n(l),J(rl.$$.fragment,l),Vt=n(l),ul=M(l,"P",{"data-svelte-h":!0}),y(ul)!=="svelte-1mvdyro"&&(ul.innerHTML=$a),_t=n(l),J(hl.$$.fragment,l),Gt=n(l),dl=M(l,"P",{"data-svelte-h":!0}),y(dl)!=="svelte-z9bfhb"&&(dl.textContent=Za),Bt=n(l),J(fl.$$.fragment,l),Wt=n(l),ol=M(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-1mvdyro"&&(ol.innerHTML=ka),vt=n(l),J(bl.$$.fragment,l),Xt=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),y(Cl)!=="svelte-1ps1iiz"&&(Cl.textContent=Ra),Et=n(l),Il=M(l,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-139qbcw"&&(Il.textContent=xa),Yt=n(l),J($l.$$.fragment,l),Nt=n(l),Zl=M(l,"P",{"data-svelte-h":!0}),y(Zl)!=="svelte-p3m4km"&&(Zl.innerHTML=Aa),Dt=n(l),kl=M(l,"P",{"data-svelte-h":!0}),y(kl)!=="svelte-taqkhq"&&(kl.innerHTML=Qa),zt=n(l),J(Rl.$$.fragment,l),Ft=n(l),xl=M(l,"P",{"data-svelte-h":!0}),y(xl)!=="svelte-e3airu"&&(xl.innerHTML=ga),Ht=n(l),Al=M(l,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-1i0w5jk"&&(Al.innerHTML=Va),St=n(l),J(Ql.$$.fragment,l),qt=n(l),gl=M(l,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-12dg9zu"&&(gl.innerHTML=_a),Lt=n(l),J(Vl.$$.fragment,l),Pt=n(l),_l=M(l,"P",{"data-svelte-h":!0}),y(_l)!=="svelte-vyoyt2"&&(_l.textContent=Ga),Kt=n(l),J(Gl.$$.fragment,l),Ot=n(l),Bl=M(l,"P",{"data-svelte-h":!0}),y(Bl)!=="svelte-1mvdyro"&&(Bl.innerHTML=Ba),ls=n(l),J(Wl.$$.fragment,l),es=n(l),vl=M(l,"P",{"data-svelte-h":!0}),y(vl)!=="svelte-2nvf42"&&(vl.textContent=Wa),ts=n(l),J(Xl.$$.fragment,l),ss=n(l),El=M(l,"P",{"data-svelte-h":!0}),y(El)!=="svelte-1mvdyro"&&(El.innerHTML=va),as=n(l),J(Yl.$$.fragment,l),ns=n(l),Nl=M(l,"P",{"data-svelte-h":!0}),y(Nl)!=="svelte-1ycajx1"&&(Nl.textContent=Xa),ps=n(l),J(Dl.$$.fragment,l),Ms=n(l),f=M(l,"DIV",{class:!0,"data-svelte-h":!0}),y(f)!=="svelte-j4o1b8"&&(f.innerHTML=Ea),ys=n(l),zl=M(l,"P",{"data-svelte-h":!0}),y(zl)!=="svelte-12yxndm"&&(zl.textContent=Ya),is=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),y(Fl)!=="svelte-1cx65z4"&&(Fl.textContent=Na),Js=n(l),J(Hl.$$.fragment,l),ms=n(l),Sl=M(l,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-4c0nlh"&&(Sl.textContent=Da),Ts=n(l),J(ql.$$.fragment,l),js=n(l),Ll=M(l,"P",{"data-svelte-h":!0}),y(Ll)!=="svelte-1mvdyro"&&(Ll.innerHTML=za),ws=n(l),J(Pl.$$.fragment,l),cs=n(l),Kl=M(l,"P",{"data-svelte-h":!0}),y(Kl)!=="svelte-12kqf3u"&&(Kl.textContent=Fa),Us=n(l),J(Ol.$$.fragment,l),rs=n(l),J(le.$$.fragment,l),us=n(l),ee=M(l,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-av8zr0"&&(ee.innerHTML=Ha),hs=n(l),J(te.$$.fragment,l),ds=n(l),se=M(l,"P",{"data-svelte-h":!0}),y(se)!=="svelte-100fe39"&&(se.textContent=Sa),fs=n(l),J(ae.$$.fragment,l),os=n(l),J(ne.$$.fragment,l),bs=n(l),pe=M(l,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-1xuk540"&&(pe.textContent=qa),Cs=n(l),J(Me.$$.fragment,l),Is=n(l),ye=M(l,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-1tqkg0a"&&(ye.innerHTML=La),$s=n(l),J(ie.$$.fragment,l),Zs=n(l),Je=M(l,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-1haaffx"&&(Je.textContent=Pa),ks=n(l),J(me.$$.fragment,l),Rs=n(l),Te=M(l,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-1pvbr9r"&&(Te.innerHTML=Ka),xs=n(l),J(je.$$.fragment,l),As=n(l),we=M(l,"P",{"data-svelte-h":!0}),y(we)!=="svelte-1uviv04"&&(we.innerHTML=Oa),Qs=n(l),J(ce.$$.fragment,l),gs=n(l),Ue=M(l,"P",{"data-svelte-h":!0}),y(Ue)!=="svelte-hefgo2"&&(Ue.textContent=ln),Vs=n(l),J(re.$$.fragment,l),_s=n(l),J(ue.$$.fragment,l),Gs=n(l),he=M(l,"P",{"data-svelte-h":!0}),y(he)!=="svelte-jls05p"&&(he.textContent=en),Bs=n(l),J(de.$$.fragment,l),Ws=n(l),fe=M(l,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-18xrhu4"&&(fe.textContent=tn),vs=n(l),J(oe.$$.fragment,l),Xs=n(l),be=M(l,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1vadpfy"&&(be.textContent=sn),Es=n(l),J(Ce.$$.fragment,l),Ys=n(l),Ie=M(l,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-sfvde1"&&(Ie.textContent=an),Ns=n(l),J($e.$$.fragment,l),Ds=n(l),Ze=M(l,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-1otseb5"&&(Ze.textContent=nn),zs=n(l),J(ke.$$.fragment,l),Fs=n(l),Re=M(l,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-eothhd"&&(Re.textContent=pn),Hs=n(l),J(xe.$$.fragment,l),Ss=n(l),Ae=M(l,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-188hwef"&&(Ae.textContent=Mn),qs=n(l),Qe=M(l,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-ygi586"&&(Qe.innerHTML=yn),Ls=n(l),ge=M(l,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-s2kks0"&&(ge.textContent=Jn),Ps=n(l),J(Ve.$$.fragment,l),Ks=n(l),Ge=M(l,"P",{}),Tn(Ge).forEach(t),this.h()},h(){la(U,"name","hf:doc:metadata"),la(U,"content",In),la(d,"class","flex justify-center"),la(f,"class","flex justify-center")},m(l,e){hn(document.head,U),s(l,o,e),s(l,r,e),s(l,_e,e),m(b,l,e),s(l,We,e),m(C,l,e),s(l,ve,e),s(l,I,e),s(l,Xe,e),m($,l,e),s(l,Ee,e),s(l,Z,e),s(l,Ye,e),m(k,l,e),s(l,Ne,e),m(h,l,e),s(l,De,e),s(l,R,e),s(l,ze,e),m(x,l,e),s(l,Fe,e),s(l,A,e),s(l,He,e),m(Q,l,e),s(l,Se,e),m(g,l,e),s(l,qe,e),s(l,V,e),s(l,Le,e),s(l,_,e),s(l,Pe,e),s(l,G,e),s(l,Ke,e),m(B,l,e),s(l,Oe,e),s(l,W,e),s(l,lt,e),m(v,l,e),s(l,et,e),s(l,X,e),s(l,tt,e),m(E,l,e),s(l,st,e),m(Y,l,e),s(l,at,e),s(l,N,e),s(l,nt,e),m(D,l,e),s(l,pt,e),m(z,l,e),s(l,Mt,e),s(l,F,e),s(l,yt,e),m(H,l,e),s(l,it,e),s(l,S,e),s(l,Jt,e),m(q,l,e),s(l,mt,e),s(l,L,e),s(l,Tt,e),m(P,l,e),s(l,jt,e),s(l,K,e),s(l,wt,e),s(l,O,e),s(l,ct,e),s(l,ll,e),s(l,Ut,e),m(el,l,e),s(l,rt,e),s(l,tl,e),s(l,ut,e),m(sl,l,e),s(l,ht,e),s(l,al,e),s(l,dt,e),m(nl,l,e),s(l,ft,e),s(l,pl,e),s(l,ot,e),m(Ml,l,e),s(l,bt,e),s(l,yl,e),s(l,Ct,e),m(il,l,e),s(l,It,e),s(l,Jl,e),s(l,$t,e),m(ml,l,e),s(l,Zt,e),s(l,Tl,e),s(l,kt,e),m(jl,l,e),s(l,Rt,e),s(l,d,e),s(l,xt,e),s(l,wl,e),s(l,At,e),m(cl,l,e),s(l,Qt,e),s(l,Ul,e),s(l,gt,e),m(rl,l,e),s(l,Vt,e),s(l,ul,e),s(l,_t,e),m(hl,l,e),s(l,Gt,e),s(l,dl,e),s(l,Bt,e),m(fl,l,e),s(l,Wt,e),s(l,ol,e),s(l,vt,e),m(bl,l,e),s(l,Xt,e),s(l,Cl,e),s(l,Et,e),s(l,Il,e),s(l,Yt,e),m($l,l,e),s(l,Nt,e),s(l,Zl,e),s(l,Dt,e),s(l,kl,e),s(l,zt,e),m(Rl,l,e),s(l,Ft,e),s(l,xl,e),s(l,Ht,e),s(l,Al,e),s(l,St,e),m(Ql,l,e),s(l,qt,e),s(l,gl,e),s(l,Lt,e),m(Vl,l,e),s(l,Pt,e),s(l,_l,e),s(l,Kt,e),m(Gl,l,e),s(l,Ot,e),s(l,Bl,e),s(l,ls,e),m(Wl,l,e),s(l,es,e),s(l,vl,e),s(l,ts,e),m(Xl,l,e),s(l,ss,e),s(l,El,e),s(l,as,e),m(Yl,l,e),s(l,ns,e),s(l,Nl,e),s(l,ps,e),m(Dl,l,e),s(l,Ms,e),s(l,f,e),s(l,ys,e),s(l,zl,e),s(l,is,e),s(l,Fl,e),s(l,Js,e),m(Hl,l,e),s(l,ms,e),s(l,Sl,e),s(l,Ts,e),m(ql,l,e),s(l,js,e),s(l,Ll,e),s(l,ws,e),m(Pl,l,e),s(l,cs,e),s(l,Kl,e),s(l,Us,e),m(Ol,l,e),s(l,rs,e),m(le,l,e),s(l,us,e),s(l,ee,e),s(l,hs,e),m(te,l,e),s(l,ds,e),s(l,se,e),s(l,fs,e),m(ae,l,e),s(l,os,e),m(ne,l,e),s(l,bs,e),s(l,pe,e),s(l,Cs,e),m(Me,l,e),s(l,Is,e),s(l,ye,e),s(l,$s,e),m(ie,l,e),s(l,Zs,e),s(l,Je,e),s(l,ks,e),m(me,l,e),s(l,Rs,e),s(l,Te,e),s(l,xs,e),m(je,l,e),s(l,As,e),s(l,we,e),s(l,Qs,e),m(ce,l,e),s(l,gs,e),s(l,Ue,e),s(l,Vs,e),m(re,l,e),s(l,_s,e),m(ue,l,e),s(l,Gs,e),s(l,he,e),s(l,Bs,e),m(de,l,e),s(l,Ws,e),s(l,fe,e),s(l,vs,e),m(oe,l,e),s(l,Xs,e),s(l,be,e),s(l,Es,e),m(Ce,l,e),s(l,Ys,e),s(l,Ie,e),s(l,Ns,e),m($e,l,e),s(l,Ds,e),s(l,Ze,e),s(l,zs,e),m(ke,l,e),s(l,Fs,e),s(l,Re,e),s(l,Hs,e),m(xe,l,e),s(l,Ss,e),s(l,Ae,e),s(l,qs,e),s(l,Qe,e),s(l,Ls,e),s(l,ge,e),s(l,Ps,e),m(Ve,l,e),s(l,Ks,e),s(l,Ge,e),Os=!0},p(l,[e]){const mn={};e&2&&(mn.$$scope={dirty:e,ctx:l}),h.$set(mn)},i(l){Os||(T(b.$$.fragment,l),T(C.$$.fragment,l),T($.$$.fragment,l),T(k.$$.fragment,l),T(h.$$.fragment,l),T(x.$$.fragment,l),T(Q.$$.fragment,l),T(g.$$.fragment,l),T(B.$$.fragment,l),T(v.$$.fragment,l),T(E.$$.fragment,l),T(Y.$$.fragment,l),T(D.$$.fragment,l),T(z.$$.fragment,l),T(H.$$.fragment,l),T(q.$$.fragment,l),T(P.$$.fragment,l),T(el.$$.fragment,l),T(sl.$$.fragment,l),T(nl.$$.fragment,l),T(Ml.$$.fragment,l),T(il.$$.fragment,l),T(ml.$$.fragment,l),T(jl.$$.fragment,l),T(cl.$$.fragment,l),T(rl.$$.fragment,l),T(hl.$$.fragment,l),T(fl.$$.fragment,l),T(bl.$$.fragment,l),T($l.$$.fragment,l),T(Rl.$$.fragment,l),T(Ql.$$.fragment,l),T(Vl.$$.fragment,l),T(Gl.$$.fragment,l),T(Wl.$$.fragment,l),T(Xl.$$.fragment,l),T(Yl.$$.fragment,l),T(Dl.$$.fragment,l),T(Hl.$$.fragment,l),T(ql.$$.fragment,l),T(Pl.$$.fragment,l),T(Ol.$$.fragment,l),T(le.$$.fragment,l),T(te.$$.fragment,l),T(ae.$$.fragment,l),T(ne.$$.fragment,l),T(Me.$$.fragment,l),T(ie.$$.fragment,l),T(me.$$.fragment,l),T(je.$$.fragment,l),T(ce.$$.fragment,l),T(re.$$.fragment,l),T(ue.$$.fragment,l),T(de.$$.fragment,l),T(oe.$$.fragment,l),T(Ce.$$.fragment,l),T($e.$$.fragment,l),T(ke.$$.fragment,l),T(xe.$$.fragment,l),T(Ve.$$.fragment,l),Os=!0)},o(l){j(b.$$.fragment,l),j(C.$$.fragment,l),j($.$$.fragment,l),j(k.$$.fragment,l),j(h.$$.fragment,l),j(x.$$.fragment,l),j(Q.$$.fragment,l),j(g.$$.fragment,l),j(B.$$.fragment,l),j(v.$$.fragment,l),j(E.$$.fragment,l),j(Y.$$.fragment,l),j(D.$$.fragment,l),j(z.$$.fragment,l),j(H.$$.fragment,l),j(q.$$.fragment,l),j(P.$$.fragment,l),j(el.$$.fragment,l),j(sl.$$.fragment,l),j(nl.$$.fragment,l),j(Ml.$$.fragment,l),j(il.$$.fragment,l),j(ml.$$.fragment,l),j(jl.$$.fragment,l),j(cl.$$.fragment,l),j(rl.$$.fragment,l),j(hl.$$.fragment,l),j(fl.$$.fragment,l),j(bl.$$.fragment,l),j($l.$$.fragment,l),j(Rl.$$.fragment,l),j(Ql.$$.fragment,l),j(Vl.$$.fragment,l),j(Gl.$$.fragment,l),j(Wl.$$.fragment,l),j(Xl.$$.fragment,l),j(Yl.$$.fragment,l),j(Dl.$$.fragment,l),j(Hl.$$.fragment,l),j(ql.$$.fragment,l),j(Pl.$$.fragment,l),j(Ol.$$.fragment,l),j(le.$$.fragment,l),j(te.$$.fragment,l),j(ae.$$.fragment,l),j(ne.$$.fragment,l),j(Me.$$.fragment,l),j(ie.$$.fragment,l),j(me.$$.fragment,l),j(je.$$.fragment,l),j(ce.$$.fragment,l),j(re.$$.fragment,l),j(ue.$$.fragment,l),j(de.$$.fragment,l),j(oe.$$.fragment,l),j(Ce.$$.fragment,l),j($e.$$.fragment,l),j(ke.$$.fragment,l),j(xe.$$.fragment,l),j(Ve.$$.fragment,l),Os=!1},d(l){l&&(t(o),t(r),t(_e),t(We),t(ve),t(I),t(Xe),t(Ee),t(Z),t(Ye),t(Ne),t(De),t(R),t(ze),t(Fe),t(A),t(He),t(Se),t(qe),t(V),t(Le),t(_),t(Pe),t(G),t(Ke),t(Oe),t(W),t(lt),t(et),t(X),t(tt),t(st),t(at),t(N),t(nt),t(pt),t(Mt),t(F),t(yt),t(it),t(S),t(Jt),t(mt),t(L),t(Tt),t(jt),t(K),t(wt),t(O),t(ct),t(ll),t(Ut),t(rt),t(tl),t(ut),t(ht),t(al),t(dt),t(ft),t(pl),t(ot),t(bt),t(yl),t(Ct),t(It),t(Jl),t($t),t(Zt),t(Tl),t(kt),t(Rt),t(d),t(xt),t(wl),t(At),t(Qt),t(Ul),t(gt),t(Vt),t(ul),t(_t),t(Gt),t(dl),t(Bt),t(Wt),t(ol),t(vt),t(Xt),t(Cl),t(Et),t(Il),t(Yt),t(Nt),t(Zl),t(Dt),t(kl),t(zt),t(Ft),t(xl),t(Ht),t(Al),t(St),t(qt),t(gl),t(Lt),t(Pt),t(_l),t(Kt),t(Ot),t(Bl),t(ls),t(es),t(vl),t(ts),t(ss),t(El),t(as),t(ns),t(Nl),t(ps),t(Ms),t(f),t(ys),t(zl),t(is),t(Fl),t(Js),t(ms),t(Sl),t(Ts),t(js),t(Ll),t(ws),t(cs),t(Kl),t(Us),t(rs),t(us),t(ee),t(hs),t(ds),t(se),t(fs),t(os),t(bs),t(pe),t(Cs),t(Is),t(ye),t($s),t(Zs),t(Je),t(ks),t(Rs),t(Te),t(xs),t(As),t(we),t(Qs),t(gs),t(Ue),t(Vs),t(_s),t(Gs),t(he),t(Bs),t(Ws),t(fe),t(vs),t(Xs),t(be),t(Es),t(Ys),t(Ie),t(Ns),t(Ds),t(Ze),t(zs),t(Fs),t(Re),t(Hs),t(Ss),t(Ae),t(qs),t(Qe),t(Ls),t(ge),t(Ps),t(Ks),t(Ge)),t(U),w(b,l),w(C,l),w($,l),w(k,l),w(h,l),w(x,l),w(Q,l),w(g,l),w(B,l),w(v,l),w(E,l),w(Y,l),w(D,l),w(z,l),w(H,l),w(q,l),w(P,l),w(el,l),w(sl,l),w(nl,l),w(Ml,l),w(il,l),w(ml,l),w(jl,l),w(cl,l),w(rl,l),w(hl,l),w(fl,l),w(bl,l),w($l,l),w(Rl,l),w(Ql,l),w(Vl,l),w(Gl,l),w(Wl,l),w(Xl,l),w(Yl,l),w(Dl,l),w(Hl,l),w(ql,l),w(Pl,l),w(Ol,l),w(le,l),w(te,l),w(ae,l),w(ne,l),w(Me,l),w(ie,l),w(me,l),w(je,l),w(ce,l),w(re,l),w(ue,l),w(de,l),w(oe,l),w(Ce,l),w($e,l),w(ke,l),w(xe,l),w(Ve,l)}}}const In='{"title":"Дообучение SpeechT5","local":"дообучение-speecht5","sections":[{"title":"House-keeping","local":"house-keeping","sections":[],"depth":2},{"title":"Набор данных","local":"набор-данных","sections":[],"depth":2},{"title":"Препроцессинг данных","local":"препроцессинг-данных","sections":[{"title":"Очистка текста для токенизации SpeechT5","local":"очистка-текста-для-токенизации-speecht5","sections":[],"depth":3},{"title":"Дикторы","local":"дикторы","sections":[],"depth":3},{"title":"Эмбеддинги диктора","local":"эмбеддинги-диктора","sections":[],"depth":3},{"title":"Обработка датасета","local":"обработка-датасета","sections":[],"depth":3},{"title":"Коллатор данных","local":"коллатор-данных","sections":[],"depth":3}],"depth":2},{"title":"Обучение модели","local":"обучение-модели","sections":[],"depth":2},{"title":"Инференс","local":"инференс","sections":[],"depth":2}],"depth":1}';function $n(Be){return wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qn extends Un{constructor(U){super(),rn(this,U,$n,Cn,jn,{})}}export{Qn as component};
