import{s as Ts,o as Us}from"../chunks/scheduler.a045fce0.js";import{S as ws,i as bs,e as i,s as n,c as o,h as gs,a as r,d as t,b as a,f as Js,g as p,j as u,k as De,l as vs,m as l,n as d,t as c,o as M,p as m,q as Cs,r as Is}from"../chunks/index.5135b896.js";import{T as qs}from"../chunks/Tip.872c1b89.js";import{C as As,H as Se,E as $s}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f3c27615.js";import{C as y}from"../chunks/CodeBlock.02980897.js";function xs(ie){let j;return{c(){j=Cs(`💡 Quelques informations sur le rééchantillonnage: Si un signal audio a été échantillonné à 8 kHz, de sorte qu'il a 8000 lectures d'échantillon par seconde, nous savons que l'audio ne contient aucune fréquence supérieure à 4 kHz. 
Ceci est garanti par le théorème d'échantillonnage de Nyquist. Pour cette raison, nous pouvons être certains qu'entre les points d'échantillonnage, le signal continu d'origine fait toujours une courbe lisse.
L'augmentation du prélèvement vers un taux d'échantillonnage plus élevé consiste alors à calculer des valeurs d'échantillonnage supplémentaires qui se situent entre les valeurs existantes, en approximant cette courbe. 
Le sous-échantillonnage, cependant, nécessite que nous filtrons d'abord toutes les fréquences qui seraient supérieures à la nouvelle limite de Nyquist, avant d'estimer les nouveaux points d'échantillonnage. 
En d'autres termes, vous ne pouvez pas sous-échantillonner d'un facteur 2x en jetant simplement tous les autres échantillons - cela créera des distorsions dans le signal appelées alias. 
Faire un rééchantillonnage correct est délicat et mieux laissé à des bibliothèques bien testées telles que librosa ou 🤗 *Datasets*.`)},l(f){j=Is(f,`💡 Quelques informations sur le rééchantillonnage: Si un signal audio a été échantillonné à 8 kHz, de sorte qu'il a 8000 lectures d'échantillon par seconde, nous savons que l'audio ne contient aucune fréquence supérieure à 4 kHz. 
Ceci est garanti par le théorème d'échantillonnage de Nyquist. Pour cette raison, nous pouvons être certains qu'entre les points d'échantillonnage, le signal continu d'origine fait toujours une courbe lisse.
L'augmentation du prélèvement vers un taux d'échantillonnage plus élevé consiste alors à calculer des valeurs d'échantillonnage supplémentaires qui se situent entre les valeurs existantes, en approximant cette courbe. 
Le sous-échantillonnage, cependant, nécessite que nous filtrons d'abord toutes les fréquences qui seraient supérieures à la nouvelle limite de Nyquist, avant d'estimer les nouveaux points d'échantillonnage. 
En d'autres termes, vous ne pouvez pas sous-échantillonner d'un facteur 2x en jetant simplement tous les autres échantillons - cela créera des distorsions dans le signal appelées alias. 
Faire un rééchantillonnage correct est délicat et mieux laissé à des bibliothèques bien testées telles que librosa ou 🤗 *Datasets*.`)},m(f,T){l(f,j,T)},d(f){f&&t(j)}}}function Bs(ie){let j,f,T,re,U,ue,w,oe,b,Pe=`Le chargement d’un jeu de données avec 🤗 <em>Datasets</em> n’est que la moitié du plaisir.
Si vous prévoyez de l’utiliser pour entraîner un modèle ou pour exécuter l’inférence, vous devrez d’abord prétraiter les données. En général, cela impliquera les étapes suivantes:`,pe,g,Oe="<li>Rééchantillonnage des données audio</li> <li>Filtrage du jeu de données</li> <li>Conversion des données audio en entrée attendue du modèle</li>",de,v,ce,C,Ke=`La fonction <code>load_dataset</code> télécharge des exemples audio avec le taux d’échantillonnage avec lequel ils ont été publiés.
Ce n’est pas toujours le taux d’échantillonnage attendu par un modèle que vous prévoyez d’entraîner ou d’utiliser pour l’inférence.
S’il existe un écart entre les taux d’échantillonnage, vous pouvez rééchantillonner l’audio à la fréquence d’échantillonnage attendue du modèle.
La plupart des modèles pré-entraînés disponibles ont été pré-entraînés sur des jeux de données audio à une fréquence d’échantillonnage de 16 kHz.
Lorsque nous avons exploré le jeu de données MINDS-14, vous avez peut-être remarqué qu’il est échantillonné à 8 kHz, ce qui signifie que nous devrons probablement le suréchantillonner.
Pour ce faire, utilisez la méthode <code>cast_column</code> de 🤗 Datasets.
Cette opération ne modifie pas l’audio sur place, mais plutôt les signaux aux jeux de données pour rééchantillonner les exemples audio à la volée lorsqu’ils sont chargés.
Le code suivant définira la fréquence d’échantillonnage à 16 kHz :`,Me,I,me,q,es="Rechargez le premier exemple audio dans le jeu de données MINDS-14 et vérifiez qu’il a été rééchantillonné à la « fréquence d’échantillonnage » souhaitée :",je,A,ye,$,ss="<strong>Sortie :</strong>",fe,x,he,B,ts="Vous remarquerez peut-être que les valeurs de tableau sont maintenant également différentes. C’est parce que nous avons maintenant deux fois plus de valeurs d’amplitude pour chacune d’entre elles que nous avions auparavant.",Je,h,Te,z,Ue,G,ls=`Vous devrez peut-être filtrer les données en fonction de certains critères. L’un des cas courants consiste à limiter les exemples audio à une certaine durée.
Par exemple, nous pourrions vouloir filtrer tous les exemples de plus de 20 secondes pour éviter les erreurs de mémoire insuffisante lors de l’entraînement d’un modèle.
Nous pouvons le faire en utilisant la  méthode <code>filter</code> de 🤗 <em>Datasets</em> et en lui passant une fonction avec une logique de filtrage. Commençons par écrire une fonction qui indique quels exemples conserver et lesquels rejeter.
Cette fonction, <code>is_audio_length_in_range&#39;, renvoie </code>True<code>si un échantillon est inférieur à 20s et</code>False\` s’il est plus long que 20s.`,we,R,be,_,ns=`La fonction de filtrage peut être appliquée à la colonne d’un jeu de données, mais nous n’avons pas de colonne avec une durée de piste audio dans ce jeu de données.
Cependant, nous pouvons en créer un, filtrer en fonction des valeurs de cette colonne, puis le supprimer.`,ge,Z,ve,k,as="<strong>Sortie :</strong>",Ce,V,Ie,W,is="Nous pouvons vérifier que le jeu de données a été filtré de 654 exemples à 624.",qe,N,Ae,H,rs=`L’un des aspects les plus difficiles de l’utilisation d’ensembles de données audio consiste à préparer les données dans le bon format pour la formation des modèles.
Comme vous l’avez vu, les données audio brutes se présentent sous la forme d’un tableau de valeurs d’échantillon.
Cependant, les modèles pré-entraînés, que vous les utilisiez pour l’inférence ou que vous souhaitiez les finetuner pour votre tâche, s’attendent à ce que les données brutes soient converties en fonctionnalités d’entrée.
Les exigences pour les caractéristiques d’entrée peuvent varier d’un modèle à l’autre. Elles dépendent de l’architecture du modèle et des données avec lesquelles il a été pré-entraîné.
La bonne nouvelle est que, pour chaque modèle audio pris en charge, 🤗 <em>Transformers</em> offrent une classe d’extracteur de caractéristiques qui peut convertir les données audio brutes en caractéristiques d’entrée attendues par le modèle.`,$e,X,us=`Alors, que fait un extracteur de caractéristiques avec les données audio brutes ? Jetons un coup d’œil à l’extracteur de caractéristiques de <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper</a> pour comprendre certaines transformations d’extraction de caractéristiques courantes.
Whisper est un modèle pré-entraîné pour la reconnaissance vocale automatique (ASR) publié en septembre 2022 par Alec Radford et al. d’OpenAI.
Tout d’abord, l’extracteur de fonction Whisper pave / tronque un batch d’exemples audio de sorte que tous les exemples ont une longueur d’entrée de 30s.
Les exemples plus courts sont complétés à 30s en ajoutant des zéros à la fin de la séquence (les zéros dans un signal audio correspondent à l’absence de signal ou au silence). Les exemples de plus de 30 ans sont tronqués à 30 s.
Étant donné que tous les éléments du batch sont rembourrés/tronqués à une longueur maximale dans l’espace d’entrée, il n’y a pas besoin d’un masque d’attention.
Whisper est unique à cet égard, la plupart des autres modèles audio nécessitent un masque d’attention qui détaille où les séquences ont été rembourrées, et donc où elles doivent être ignorées dans le mécanisme d’auto-attention.
Whisper est entraîné pour fonctionner sans masque d’attention et déduire directement des signaux vocaux où ignorer les entrées.
La deuxième opération effectuée par l’extracteur de fonctions Whisper consiste à convertir les matrices audio rembourrées en spectrogrammes log-mel.
Ces spectrogrammes décrivent comment les fréquences d’un signal changent au fil du temps, exprimées sur l’échelle mel et mesurées en décibels (la partie log) pour rendre les fréquences et les amplitudes plus représentatives de l’audition humaine.
Toutes ces transformations peuvent être appliquées à vos données audio brutes avec quelques lignes de code.
Allons de l’avant et chargeons l’extracteur de caractéristiques à partir du <em>checkpoint</em> de Whisper pré-entraîné pour être prêt pour nos données audio:`,xe,E,Be,Y,os="Ensuite, vous pouvez écrire une fonction pour pré-traiter un seul exemple audio en le faisant passer par le <code>feature_extractor</code>.",ze,Q,Ge,L,ps="Nous pouvons appliquer la fonction de préparation des données à tous nos exemples d’entraînement en utilisant la méthode <code>map</code> de 🤗 <em>Datasets</em> :",Re,F,_e,S,ds="<strong>Sortie :</strong>",Ze,D,ke,P,cs=`Aussi simple que cela, nous avons maintenant des spectrogrammes log-mel comme <code>input_features</code> dans le jeu de données.
Visualisons-le pour l’un des exemples de <code>minds</code> :`,Ve,O,We,J,Ms='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',Ne,K,ms="Vous pouvez maintenant voir à quoi ressemble l’entrée audio du modèle Whisper après le prétraitement.",He,ee,js=`La classe d’extracteur de caractéristiques du modèle se charge de transformer les données audio brutes au format attendu par le modèle. Cependant, de nombreuses tâches impliquant l’audio sont multimodales, par exemple la reconnaissance vocale.
Dans de tels cas, 🤗 <em>Transformers</em> offrent également des tokeniseurs spécifiques au modèle pour traiter les entrées de texte. Pour une plongée approfondie dans les tokeniseurs, veuillez vous référer à notre <a href="https://huggingface.co/learn/nlp-course/fr/chapter2/4" rel="nofollow">cours de NLP</a>.`,Xe,se,ys=`Vous pouvez charger séparément l’extracteur de caractéristiques et le tokeniseur pour Whisper et d’autres modèles multimodaux, ou vous pouvez charger les deux via un processeur.
Pour rendre les choses encore plus simples, utilisez <code>AutoProcessor</code> pour charger l’extracteur de caractéristiques et le processeur d’un modèle à partir d’un <em>checkpoint</em>, comme ceci :`,Ee,te,Ye,le,fs=`Nous avons illustré ici les étapes fondamentales de préparation des données. Bien entendu, les données personnalisées peuvent nécessiter un prétraitement plus complexe.
Dans ce cas, vous pouvez étendre la fonction <code>prepare_dataset</code> pour effectuer n’importe quel type de transformations de données personnalisées.
Avec 🤗 <em>Datasets</em>, si vous pouvez l’écrire en tant que fonction Python, vous pouvez l’appliquer à votre jeu de données !`,Qe,ne,Le,ae,Fe;return U=new As({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Se({props:{title:"Prétraitement d’un jeu de données audio",local:"prétraitement-dun-jeu-de-données-audio",headingTag:"h1"}}),v=new Se({props:{title:"Rééchantillonnage des données audio",local:"rééchantillonnage-des-données-audio",headingTag:"h2"}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),A=new y({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),x=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RCUwQQ==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}
`,wrap:!1}}),h=new qs({props:{$$slots:{default:[xs]},$$scope:{ctx:ie}}}),z=new Se({props:{title:"Filtrage du jeu de données",local:"filtrage-du-jeu-de-données",headingTag:"h2"}}),R=new y({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),Z=new y({props:{code:"JTIzJTIwVXRpbGlzZXolMjBsaWJyb3NhJTIwcG91ciUyMG9idGVuaXIlMjBsYSUyMGR1ciVDMyVBOWUlMjBkZSUyMGwnZXhlbXBsZSUyMCVDMyVBMCUyMHBhcnRpciUyMGR1JTIwZmljaGllciUyMGF1ZGlvJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKHBhdGglM0R4KSUyMGZvciUyMHglMjBpbiUyMG1pbmRzJTVCJTIycGF0aCUyMiU1RCU1RCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuYWRkX2NvbHVtbiglMjJkdXJhdGlvbiUyMiUyQyUyMG5ld19jb2x1bW4pJTBBJTBBJTIzJTIwdXRpbGlzZXIlMjBsYSUyMG0lQzMlQTl0aG9kZSUyMCU2MGZpbHRlciU2MCUyMGRlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMlMjBwb3VyJTIwYXBwbGlxdWVyJTIwbGElMjBmb25jdGlvbiUyMGRlJTIwZmlsdHJhZ2UlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmZpbHRlcihpc19hdWRpb19sZW5ndGhfaW5fcmFuZ2UlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBJTBBJTIzJTIwc3VwcHJpbWVyJTIwbGElMjBjb2xvbm5lJTIwZCdhc3Npc3RhbmNlJTIwdGVtcG9yYWlyZSUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># Utilisez librosa pour obtenir la durée de l&#x27;exemple à partir du fichier audio</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># utiliser la méthode \`filter\` de 🤗 Datasets pour appliquer la fonction de filtrage</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># supprimer la colonne d&#x27;assistance temporaire</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),V=new y({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),N=new Se({props:{title:"Prétraitement des données audio",local:"prétraitement-des-données-audio",headingTag:"h2"}}),E=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),Q=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),F=new y({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),D=new y({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),O=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),te=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),ne=new $s({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter1/preprocessing.mdx"}}),{c(){j=i("meta"),f=n(),T=i("p"),re=n(),o(U.$$.fragment),ue=n(),o(w.$$.fragment),oe=n(),b=i("p"),b.innerHTML=Pe,pe=n(),g=i("ul"),g.innerHTML=Oe,de=n(),o(v.$$.fragment),ce=n(),C=i("p"),C.innerHTML=Ke,Me=n(),o(I.$$.fragment),me=n(),q=i("p"),q.textContent=es,je=n(),o(A.$$.fragment),ye=n(),$=i("p"),$.innerHTML=ss,fe=n(),o(x.$$.fragment),he=n(),B=i("p"),B.textContent=ts,Je=n(),o(h.$$.fragment),Te=n(),o(z.$$.fragment),Ue=n(),G=i("p"),G.innerHTML=ls,we=n(),o(R.$$.fragment),be=n(),_=i("p"),_.textContent=ns,ge=n(),o(Z.$$.fragment),ve=n(),k=i("p"),k.innerHTML=as,Ce=n(),o(V.$$.fragment),Ie=n(),W=i("p"),W.textContent=is,qe=n(),o(N.$$.fragment),Ae=n(),H=i("p"),H.innerHTML=rs,$e=n(),X=i("p"),X.innerHTML=us,xe=n(),o(E.$$.fragment),Be=n(),Y=i("p"),Y.innerHTML=os,ze=n(),o(Q.$$.fragment),Ge=n(),L=i("p"),L.innerHTML=ps,Re=n(),o(F.$$.fragment),_e=n(),S=i("p"),S.innerHTML=ds,Ze=n(),o(D.$$.fragment),ke=n(),P=i("p"),P.innerHTML=cs,Ve=n(),o(O.$$.fragment),We=n(),J=i("div"),J.innerHTML=Ms,Ne=n(),K=i("p"),K.textContent=ms,He=n(),ee=i("p"),ee.innerHTML=js,Xe=n(),se=i("p"),se.innerHTML=ys,Ee=n(),o(te.$$.fragment),Ye=n(),le=i("p"),le.innerHTML=fs,Qe=n(),o(ne.$$.fragment),Le=n(),ae=i("p"),this.h()},l(e){const s=gs("svelte-u9bgzb",document.head);j=r(s,"META",{name:!0,content:!0}),s.forEach(t),f=a(e),T=r(e,"P",{}),Js(T).forEach(t),re=a(e),p(U.$$.fragment,e),ue=a(e),p(w.$$.fragment,e),oe=a(e),b=r(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-mdqbw0"&&(b.innerHTML=Pe),pe=a(e),g=r(e,"UL",{"data-svelte-h":!0}),u(g)!=="svelte-yk9hcg"&&(g.innerHTML=Oe),de=a(e),p(v.$$.fragment,e),ce=a(e),C=r(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-ivzlq3"&&(C.innerHTML=Ke),Me=a(e),p(I.$$.fragment,e),me=a(e),q=r(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-538ngx"&&(q.textContent=es),je=a(e),p(A.$$.fragment,e),ye=a(e),$=r(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-dbzevp"&&($.innerHTML=ss),fe=a(e),p(x.$$.fragment,e),he=a(e),B=r(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-164hhon"&&(B.textContent=ts),Je=a(e),p(h.$$.fragment,e),Te=a(e),p(z.$$.fragment,e),Ue=a(e),G=r(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-mbvv6"&&(G.innerHTML=ls),we=a(e),p(R.$$.fragment,e),be=a(e),_=r(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-8vpyeu"&&(_.textContent=ns),ge=a(e),p(Z.$$.fragment,e),ve=a(e),k=r(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-dbzevp"&&(k.innerHTML=as),Ce=a(e),p(V.$$.fragment,e),Ie=a(e),W=r(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-tdnd34"&&(W.textContent=is),qe=a(e),p(N.$$.fragment,e),Ae=a(e),H=r(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-9jm202"&&(H.innerHTML=rs),$e=a(e),X=r(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-18oi0yw"&&(X.innerHTML=us),xe=a(e),p(E.$$.fragment,e),Be=a(e),Y=r(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-iag9pm"&&(Y.innerHTML=os),ze=a(e),p(Q.$$.fragment,e),Ge=a(e),L=r(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1le6nsz"&&(L.innerHTML=ps),Re=a(e),p(F.$$.fragment,e),_e=a(e),S=r(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-dbzevp"&&(S.innerHTML=ds),Ze=a(e),p(D.$$.fragment,e),ke=a(e),P=r(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-ojjqz9"&&(P.innerHTML=cs),Ve=a(e),p(O.$$.fragment,e),We=a(e),J=r(e,"DIV",{class:!0,"data-svelte-h":!0}),u(J)!=="svelte-csckl"&&(J.innerHTML=Ms),Ne=a(e),K=r(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-y12i6c"&&(K.textContent=ms),He=a(e),ee=r(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-19a55if"&&(ee.innerHTML=js),Xe=a(e),se=r(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1sqx47z"&&(se.innerHTML=ys),Ee=a(e),p(te.$$.fragment,e),Ye=a(e),le=r(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-172ihj8"&&(le.innerHTML=fs),Qe=a(e),p(ne.$$.fragment,e),Le=a(e),ae=r(e,"P",{}),Js(ae).forEach(t),this.h()},h(){De(j,"name","hf:doc:metadata"),De(j,"content",zs),De(J,"class","flex justify-center")},m(e,s){vs(document.head,j),l(e,f,s),l(e,T,s),l(e,re,s),d(U,e,s),l(e,ue,s),d(w,e,s),l(e,oe,s),l(e,b,s),l(e,pe,s),l(e,g,s),l(e,de,s),d(v,e,s),l(e,ce,s),l(e,C,s),l(e,Me,s),d(I,e,s),l(e,me,s),l(e,q,s),l(e,je,s),d(A,e,s),l(e,ye,s),l(e,$,s),l(e,fe,s),d(x,e,s),l(e,he,s),l(e,B,s),l(e,Je,s),d(h,e,s),l(e,Te,s),d(z,e,s),l(e,Ue,s),l(e,G,s),l(e,we,s),d(R,e,s),l(e,be,s),l(e,_,s),l(e,ge,s),d(Z,e,s),l(e,ve,s),l(e,k,s),l(e,Ce,s),d(V,e,s),l(e,Ie,s),l(e,W,s),l(e,qe,s),d(N,e,s),l(e,Ae,s),l(e,H,s),l(e,$e,s),l(e,X,s),l(e,xe,s),d(E,e,s),l(e,Be,s),l(e,Y,s),l(e,ze,s),d(Q,e,s),l(e,Ge,s),l(e,L,s),l(e,Re,s),d(F,e,s),l(e,_e,s),l(e,S,s),l(e,Ze,s),d(D,e,s),l(e,ke,s),l(e,P,s),l(e,Ve,s),d(O,e,s),l(e,We,s),l(e,J,s),l(e,Ne,s),l(e,K,s),l(e,He,s),l(e,ee,s),l(e,Xe,s),l(e,se,s),l(e,Ee,s),d(te,e,s),l(e,Ye,s),l(e,le,s),l(e,Qe,s),d(ne,e,s),l(e,Le,s),l(e,ae,s),Fe=!0},p(e,[s]){const hs={};s&2&&(hs.$$scope={dirty:s,ctx:e}),h.$set(hs)},i(e){Fe||(c(U.$$.fragment,e),c(w.$$.fragment,e),c(v.$$.fragment,e),c(I.$$.fragment,e),c(A.$$.fragment,e),c(x.$$.fragment,e),c(h.$$.fragment,e),c(z.$$.fragment,e),c(R.$$.fragment,e),c(Z.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c(E.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),Fe=!0)},o(e){M(U.$$.fragment,e),M(w.$$.fragment,e),M(v.$$.fragment,e),M(I.$$.fragment,e),M(A.$$.fragment,e),M(x.$$.fragment,e),M(h.$$.fragment,e),M(z.$$.fragment,e),M(R.$$.fragment,e),M(Z.$$.fragment,e),M(V.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(Q.$$.fragment,e),M(F.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),Fe=!1},d(e){e&&(t(f),t(T),t(re),t(ue),t(oe),t(b),t(pe),t(g),t(de),t(ce),t(C),t(Me),t(me),t(q),t(je),t(ye),t($),t(fe),t(he),t(B),t(Je),t(Te),t(Ue),t(G),t(we),t(be),t(_),t(ge),t(ve),t(k),t(Ce),t(Ie),t(W),t(qe),t(Ae),t(H),t($e),t(X),t(xe),t(Be),t(Y),t(ze),t(Ge),t(L),t(Re),t(_e),t(S),t(Ze),t(ke),t(P),t(Ve),t(We),t(J),t(Ne),t(K),t(He),t(ee),t(Xe),t(se),t(Ee),t(Ye),t(le),t(Qe),t(Le),t(ae)),t(j),m(U,e),m(w,e),m(v,e),m(I,e),m(A,e),m(x,e),m(h,e),m(z,e),m(R,e),m(Z,e),m(V,e),m(N,e),m(E,e),m(Q,e),m(F,e),m(D,e),m(O,e),m(te,e),m(ne,e)}}}const zs='{"title":"Prétraitement d’un jeu de données audio","local":"prétraitement-dun-jeu-de-données-audio","sections":[{"title":"Rééchantillonnage des données audio","local":"rééchantillonnage-des-données-audio","sections":[],"depth":2},{"title":"Filtrage du jeu de données","local":"filtrage-du-jeu-de-données","sections":[],"depth":2},{"title":"Prétraitement des données audio","local":"prétraitement-des-données-audio","sections":[],"depth":2}],"depth":1}';function Gs(ie){return Us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ws extends ws{constructor(j){super(),bs(this,j,Gs,Bs,Ts,{})}}export{Ws as component};
