import{s as Ye,n as Ne,o as He}from"../chunks/scheduler.a045fce0.js";import{S as Xe,i as Ve,e as M,s as n,c as u,h as Le,a as i,d as s,b as a,f as Se,g as p,j as o,k as ge,l as De,m as t,n as r,t as c,o as d,p as j}from"../chunks/index.5135b896.js";import{C as Pe,H as Ke,E as Oe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f3c27615.js";import{C as m}from"../chunks/CodeBlock.02980897.js";function el(Ie){let y,V,H,L,h,D,J,P,T,$e=`Dans ce cours, nous utiliserons la bibliothèque 🤗 <em>Datasets</em> pour travailler avec des jeux de données audio.
🤗 <em>Datasets</em> est une bibliothèque open-source permettant de télécharger et de préparer des jeux de données à partir de toutes les modalités, y compris l’audio.
La bibliothèque offre un accès facile à une sélection inégalée de jeux de données d’apprentissage automatique accessibles sur Hugging Face Hub.
De plus, 🤗 <em>Datasets</em> comprend de multiples fonctionnalités adaptées aux jeux de données audio simplifiant le travail avec de tels jeux de données pour les chercheurs et les praticiens.
Pour commencer à utiliser des jeux de données audio, assurez-vous que la 🤗 <em>Datasets</em> est installée :`,K,w,O,b,qe=`L’une des principales caractéristiques déterminantes de 🤗 <em>Datasets</em>  est la possibilité de télécharger et de préparer un jeu de données en une seule ligne de code Python à l’aide de la fonction <code>load_dataset()</code>.
Chargeons et explorons un jeu de données audio appelé <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, qui contient des enregistrements de personnes posant des questions à un système bancaire électronique dans plusieurs langues et dialectes.
Pour charger le jeu de données MINDS-14, nous devons copier l’identifiant du jeu de données sur le Hub (<code>PolyAI/minds14</code>) et le transmettre à la fonction <code>load_dataset</code>.
Nous préciserons également que nous ne nous intéressons qu’au sous-ensemble australien (‘en-AU’) des données, et le limiterons à la division de l’entraînement :`,ee,f,le,A,ve="<strong>Sortie :</strong>",se,C,te,g,Ge=`Le jeu de données contient 654 fichiers audio, chacun étant accompagné d’une transcription, d’une traduction en anglais et d’une étiquette indiquant l’intention derrière la requête de la personne.
La colonne audio contient les données audio brutes. Examinons de plus près l’un des exemples:`,ne,I,ae,$,ke="<strong>Sortie :</strong>",Me,q,ie,v,xe="Vous remarquerez peut-être que la colonne audio contient plusieurs caractéristiques :",oe,G,Ze=`<li><code>path</code> : le chemin d’accès au fichier audio (<code>*.wav</code> dans ce cas).</li> <li><code>array</code>: les données audio décodées, représentées sous la forme d’un tableau NumPy à 1 dimension.</li> <li><code>sampling_rate</code> : taux d’échantillonnage du fichier audio (8 000 Hz dans cet exemple).
Le <code>intent_class</code> est une catégorie de classification de l’enregistrement audio. Pour convertir ce nombre en une chaîne significative, nous pouvons utiliser la méthode <code>int2str()</code>:</li>`,ue,k,pe,x,Ee="<strong>Sortie :</strong>",re,Z,ce,E,Be=`Si vous regardez la fonction de transcription, vous pouvez voir que le fichier audio a effectivement enregistré une personne posant une question sur le paiement d’une facture.
Si vous envisagez d’entraîner un classifieur audio sur ce sous-ensemble de données, vous n’aurez pas nécessairement besoin de toutes les caractéristiques.
Par exemple, le <code>lang_id</code> aura la même valeur pour tous les exemples et ne sera pas utile.
Les <code>english_transcription</code> dupliqueront probablement la <code>transcription</code> de ce sous-ensemble, afin que nous puissions les supprimer en toute sécurité.`,de,B,Qe="Vous pouvez facilement supprimer les caractéristiques non pertinentes à l’aide de la méthode <code>remove_columns</code> de 🤗 <em>Datasets</em> :",je,Q,me,W,We="<strong>Sortie :</strong>",ye,_,Ue,z,_e="Maintenant que nous avons chargé et inspecté le contenu brut du jeu de données, écoutons quelques exemples ! Nous utiliserons les fonctionnalités <code>Blocs</code> et <code>Audio</code> de <em>Gradio</em> pour décoder quelques échantillons aléatoires du jeu de données:",he,R,Je,F,ze="Si vous le souhaitez, vous pouvez également visualiser certains des exemples. Traçons la forme d’onde pour le premier exemple.",Te,S,we,U,Re='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',be,Y,Fe=`Essayez ! Téléchargez un autre dialecte ou une autre langue du jeu de données MINDS-14, écoutez et visualisez quelques exemples pour avoir une idée des variations du jeu de données.
Vous pouvez trouver la liste complète des langues disponibles <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">ici</a>.`,fe,N,Ae,X,Ce;return h=new Pe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new Ke({props:{title:"Charger et explorer un jeu de données audio",local:"charger-et-explorer-un-jeu-de-données-audio",headingTag:"h1"}}),w=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),f=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),C=new m({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),I=new m({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),q=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),k=new m({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),Z=new m({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),Q=new m({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),_=new m({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),R=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new m({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),N=new Oe({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter1/load_and_explore.mdx"}}),{c(){y=M("meta"),V=n(),H=M("p"),L=n(),u(h.$$.fragment),D=n(),u(J.$$.fragment),P=n(),T=M("p"),T.innerHTML=$e,K=n(),u(w.$$.fragment),O=n(),b=M("p"),b.innerHTML=qe,ee=n(),u(f.$$.fragment),le=n(),A=M("p"),A.innerHTML=ve,se=n(),u(C.$$.fragment),te=n(),g=M("p"),g.textContent=Ge,ne=n(),u(I.$$.fragment),ae=n(),$=M("p"),$.innerHTML=ke,Me=n(),u(q.$$.fragment),ie=n(),v=M("p"),v.textContent=xe,oe=n(),G=M("ul"),G.innerHTML=Ze,ue=n(),u(k.$$.fragment),pe=n(),x=M("p"),x.innerHTML=Ee,re=n(),u(Z.$$.fragment),ce=n(),E=M("p"),E.innerHTML=Be,de=n(),B=M("p"),B.innerHTML=Qe,je=n(),u(Q.$$.fragment),me=n(),W=M("p"),W.innerHTML=We,ye=n(),u(_.$$.fragment),Ue=n(),z=M("p"),z.innerHTML=_e,he=n(),u(R.$$.fragment),Je=n(),F=M("p"),F.textContent=ze,Te=n(),u(S.$$.fragment),we=n(),U=M("div"),U.innerHTML=Re,be=n(),Y=M("p"),Y.innerHTML=Fe,fe=n(),u(N.$$.fragment),Ae=n(),X=M("p"),this.h()},l(e){const l=Le("svelte-u9bgzb",document.head);y=i(l,"META",{name:!0,content:!0}),l.forEach(s),V=a(e),H=i(e,"P",{}),Se(H).forEach(s),L=a(e),p(h.$$.fragment,e),D=a(e),p(J.$$.fragment,e),P=a(e),T=i(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-18l4dc2"&&(T.innerHTML=$e),K=a(e),p(w.$$.fragment,e),O=a(e),b=i(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-19ww6hu"&&(b.innerHTML=qe),ee=a(e),p(f.$$.fragment,e),le=a(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-dbzevp"&&(A.innerHTML=ve),se=a(e),p(C.$$.fragment,e),te=a(e),g=i(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1dg8v72"&&(g.textContent=Ge),ne=a(e),p(I.$$.fragment,e),ae=a(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-dbzevp"&&($.innerHTML=ke),Me=a(e),p(q.$$.fragment,e),ie=a(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1p7dink"&&(v.textContent=xe),oe=a(e),G=i(e,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-1hxtpp7"&&(G.innerHTML=Ze),ue=a(e),p(k.$$.fragment,e),pe=a(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-dbzevp"&&(x.innerHTML=Ee),re=a(e),p(Z.$$.fragment,e),ce=a(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-19cohpx"&&(E.innerHTML=Be),de=a(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-hekgx8"&&(B.innerHTML=Qe),je=a(e),p(Q.$$.fragment,e),me=a(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-dbzevp"&&(W.innerHTML=We),ye=a(e),p(_.$$.fragment,e),Ue=a(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-rbxail"&&(z.innerHTML=_e),he=a(e),p(R.$$.fragment,e),Je=a(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-11t53jt"&&(F.textContent=ze),Te=a(e),p(S.$$.fragment,e),we=a(e),U=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1ym6zda"&&(U.innerHTML=Re),be=a(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-big3u0"&&(Y.innerHTML=Fe),fe=a(e),p(N.$$.fragment,e),Ae=a(e),X=i(e,"P",{}),Se(X).forEach(s),this.h()},h(){ge(y,"name","hf:doc:metadata"),ge(y,"content",ll),ge(U,"class","flex justify-center")},m(e,l){De(document.head,y),t(e,V,l),t(e,H,l),t(e,L,l),r(h,e,l),t(e,D,l),r(J,e,l),t(e,P,l),t(e,T,l),t(e,K,l),r(w,e,l),t(e,O,l),t(e,b,l),t(e,ee,l),r(f,e,l),t(e,le,l),t(e,A,l),t(e,se,l),r(C,e,l),t(e,te,l),t(e,g,l),t(e,ne,l),r(I,e,l),t(e,ae,l),t(e,$,l),t(e,Me,l),r(q,e,l),t(e,ie,l),t(e,v,l),t(e,oe,l),t(e,G,l),t(e,ue,l),r(k,e,l),t(e,pe,l),t(e,x,l),t(e,re,l),r(Z,e,l),t(e,ce,l),t(e,E,l),t(e,de,l),t(e,B,l),t(e,je,l),r(Q,e,l),t(e,me,l),t(e,W,l),t(e,ye,l),r(_,e,l),t(e,Ue,l),t(e,z,l),t(e,he,l),r(R,e,l),t(e,Je,l),t(e,F,l),t(e,Te,l),r(S,e,l),t(e,we,l),t(e,U,l),t(e,be,l),t(e,Y,l),t(e,fe,l),r(N,e,l),t(e,Ae,l),t(e,X,l),Ce=!0},p:Ne,i(e){Ce||(c(h.$$.fragment,e),c(J.$$.fragment,e),c(w.$$.fragment,e),c(f.$$.fragment,e),c(C.$$.fragment,e),c(I.$$.fragment,e),c(q.$$.fragment,e),c(k.$$.fragment,e),c(Z.$$.fragment,e),c(Q.$$.fragment,e),c(_.$$.fragment,e),c(R.$$.fragment,e),c(S.$$.fragment,e),c(N.$$.fragment,e),Ce=!0)},o(e){d(h.$$.fragment,e),d(J.$$.fragment,e),d(w.$$.fragment,e),d(f.$$.fragment,e),d(C.$$.fragment,e),d(I.$$.fragment,e),d(q.$$.fragment,e),d(k.$$.fragment,e),d(Z.$$.fragment,e),d(Q.$$.fragment,e),d(_.$$.fragment,e),d(R.$$.fragment,e),d(S.$$.fragment,e),d(N.$$.fragment,e),Ce=!1},d(e){e&&(s(V),s(H),s(L),s(D),s(P),s(T),s(K),s(O),s(b),s(ee),s(le),s(A),s(se),s(te),s(g),s(ne),s(ae),s($),s(Me),s(ie),s(v),s(oe),s(G),s(ue),s(pe),s(x),s(re),s(ce),s(E),s(de),s(B),s(je),s(me),s(W),s(ye),s(Ue),s(z),s(he),s(Je),s(F),s(Te),s(we),s(U),s(be),s(Y),s(fe),s(Ae),s(X)),s(y),j(h,e),j(J,e),j(w,e),j(f,e),j(C,e),j(I,e),j(q,e),j(k,e),j(Z,e),j(Q,e),j(_,e),j(R,e),j(S,e),j(N,e)}}}const ll='{"title":"Charger et explorer un jeu de données audio","local":"charger-et-explorer-un-jeu-de-données-audio","sections":[],"depth":1}';function sl(Ie){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Xe{constructor(y){super(),Ve(this,y,sl,el,Ye,{})}}export{il as component};
