# Check your understanding of the course material

### 1. What units is the sampling rate measured in?

<Question
	choices={[
		{
			text: "dB",
			explain: "No, the amplitude is measured in decibels (dB)."
		},
		{
			text: "Hz",
			explain: "The sampling rate is the number of samples taken in one second and is measured in hertz (Hz).",
			correct: true
		},
		{
			text: "bit",
			explain: "Bits are used to describe bit depth, which refers to the number of bits of information used to represent each sample of an audio signal.",
		}
	]}
/>

### 2. When streaming a large audio dataset, how soon can you start using it?

<Question
	choices={[
		{
			text: "As soon as the full dataset is downloaded.",
			explain: "The goal of streaming data is to be able to work with it without having to fully download a dataset."
		},
		{
			text: "As soon as the first 16 examples are downloaded.",
			explain: "Try again!"
		},
		{
			text: "As soon as the first example is downloaded.",
			explain: "",
			correct: true
		}
	]}
/>

### 3. What is a spectrogram?

<Question
	choices={[
		{
			text: "A device used to digitize the audio that is first captured by a microphone, which converts the sound waves into an electrical signal.",
			explain: "A device used to digitize such electrical signal is called Analog-to-Digital Converter. Try again!"
		},
		{
			text: "A plot that shows how the amplitude of an audio signal change over time. It is also known as the *time domain* representation of sound.",
			explain: "The description above refers to waveform, not spectrogram."
		},
		{
			text: "A visual representation of the frequency spectrum of a signal as it varies with time.",
			explain: "",
			correct: true
		}
	]}
/>

### 4. What is the easiest way to convert raw audio data into log-mel spectrogram expected by Whisper?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()` creates a power spectrogram."
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "Dataset does not prepare features for Transformer models, this is done by the model's preprocessor."
		}
	]}
/>

### 5. How do you load a dataset from 🤗 Hub?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "The best way is to use the 🤗 Datasets library.",
			correct: true
		},
		{
			text: "B",
			explain: "Librosa.load is useful to load an individual audio file from a path into a tuple with audio time series and a sampling rate, but not an entire dataset with many examples and multiple features. "
		},
		{
			text: "C",
			explain: "load_dataset method comes in the 🤗 Datasets library, not in 🤗 Transformers."
		}
	]}
/>

### 6. Your custom dataset contains high-quality audio with 32 kHz sampling rate. You want to train a speech recognition model that expects the audio examples to have a 16 kHz sampling rate. What should you do?

<Question
	choices={[
		{
			text: "Use the examples as is, the model will easily generalize to higher quality audio examples.",
			explain: "Due to reliance on attention mechanisms, it is challenging for models to generalize between sampling rates."
		},
		{
			text: "Use Audio module from the 🤗 Datasets library to downsample the examples in the custom dataset",
			explain: "",
			correct: true
		},
		{
			text: "Downsample by a factor 2x by throwing away every other sample.",
			explain: "This will create distortions in the signal called aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or 🤗 Datasets."
		}
	]}
/>

### 7. How can you convert a spectrogram generated by a machine learning model into a waveform?

<Question
	choices={[
		{
			text: "We can use a neural network called a vocoder to reconstruct a waveform from the spectrogram.",
			explain: "Since the phase information is missing in this case, we need to use a vocoder, or the classic Griffin-Lim algorithm to reconstruct the waveform.",
			correct: true
		},
		{
			text: "We can use the inverse STFT to convert the generated spectrogram into a waveform",
			explain: "A generated spectrogram is missing phase information that is required to use the inverse STFT."
		},
		{
			text: "You can't convert a spectrogram generated by a machine learning model into a waveform.",
			explain: "Try again!"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/quiz.mdx" />