import{s as hn,o as yn,n as un}from"../chunks/scheduler.cd324960.js";import{S as dn,i as wn,e as p,s as a,c as M,h as Jn,a as i,d as l,b as n,f as mn,g as o,j as r,k as ea,l as Tn,m as s,n as c,t as m,o as h,p as y}from"../chunks/index.d5c3adcc.js";import{T as fn}from"../chunks/Tip.889bec11.js";import{C as Un,H as J,E as jn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.92ea4747.js";import{C as u}from"../chunks/CodeBlock.bef85339.js";function bn(Xt){let d,j=`In our example we will be using approximately 40 hours of training data. If you’d like to follow along using the Google Colab free tier GPU,
you will need to reduce the amount of training data to approximately 10-15 hours, and reduce the number of training steps.`;return{c(){d=p("p"),d.textContent=j},l(w){d=i(w,"P",{"data-svelte-h":!0}),r(d)!=="svelte-jn3a6r"&&(d.textContent=j)},m(w,Wt){s(w,d,Wt)},p:un,d(w){w&&l(d)}}}function Cn(Xt){let d,j,w,Wt,b,Rt,C,Yt,I,ta=`Now that you are familiar with the text-to-speech task and internal workings of the SpeechT5 model that was pre-trained
on English language data, let’s see how we can fine-tune it to another language.`,Qt,g,Nt,$,la="Make sure that you have a GPU if you want to reproduce this example. In a notebook, you can check with the following command:",At,k,zt,T,Ft,x,sa="You’ll also need some additional dependencies:",Et,Z,Ht,v,aa="Finally, don’t forget to log in to your Hugging Face account so that you could upload and share your model with the community:",qt,G,St,V,Dt,B,na=`For this example we’ll take the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. While we will be using the Dutch language subset, feel free to pick another subset.`,Lt,W,pa=`This is an automated speech recognition (ASR) dataset, so, as mentioned before, it is not the most suitable
option for training TTS models. However, it will be good enough for this exercise.`,Pt,_,ia="Let’s load the data:",Kt,X,Ot,R,ra="<strong>Output:</strong>",el,Y,tl,Q,Ma=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,ll,N,sl,A,al,z,oa=`Let’s begin by defining the model checkpoint to use and loading the appropriate processor that contains both tokenizer,
and feature extractor that we will need to prepare the data for training:`,nl,F,pl,E,il,H,ca="First, for preparing the text, we’ll need the tokenizer part of the processor, so let’s get it:",rl,q,Ml,S,ma="Let’s take a look at an example:",ol,D,cl,L,ha="<strong>Output:</strong>",ml,P,hl,K,ya=`What you may notice is that the dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which
feature to use as the text input, it will be important to know that the SpeechT5 tokenizer doesn’t have any tokens for
numbers. In <code>normalized_text</code> the numbers are written out as text. Thus, it is a better fit, and we should use <code>normalized_text</code>
as input text.`,yl,O,ua=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,ul,ee,da=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, we’ll write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,dl,te,wl,le,wa=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,Jl,se,Tl,ae,Ja="<strong>Output:</strong>",fl,ne,Ul,pe,Ta=`To handle the unsupported characters identified in the previous step, we can define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,jl,ie,bl,re,fa="Now that we have dealt with special characters in the text, it’s time to shift the focus to the audio data.",Cl,Me,Il,oe,Ua=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,gl,ce,$l,me,ja="By plotting a histogram you can get a sense of how much data there is for each speaker.",kl,he,xl,f,ba='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',Zl,ye,Ca=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,vl,ue,Gl,de,Ia="Let’s check how many speakers remain:",Vl,we,Bl,Je,ga="<strong>Output:</strong>",Wl,Te,_l,fe,$a="Let’s see how many examples are left:",Xl,Ue,Rl,je,ka="<strong>Output:</strong>",Yl,be,Ql,Ce,xa="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",Nl,Ie,Za=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,Al,ge,zl,$e,va=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,Fl,ke,Ga=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,El,xe,Hl,Ze,Va=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,ql,ve,Ba=`For optimal results, we would need to train an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language. If you’d like to train your own
X-vector model, you can use <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">this script</a>
as an example.`,Sl,Ge,Dl,Ve,Wa=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,Ll,Be,Pl,We,_a="Verify the processing is correct by looking at a single example:",Kl,_e,Ol,Xe,Xa="<strong>Output:</strong>",es,Re,ts,Ye,Ra="Speaker embeddings should be a 512-element vector:",ls,Qe,ss,Ne,Ya="<strong>Output:</strong>",as,Ae,ns,ze,Qa="The labels should be a log-mel spectrogram with 80 mel bins.",ps,Fe,is,U,Na='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',rs,Ee,Aa=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,Ms,He,za="Now we need to apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",os,qe,cs,Se,Fa=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,ms,De,hs,Le,Ea="<strong>Output:</strong>",ys,Pe,us,Ke,Ha="Next, create a basic train/test split:",ds,Oe,ws,et,Js,tt,qa=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with
the special value <code>-100</code>. This special value instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,Ts,lt,fs,st,Sa=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,Us,at,js,nt,bs,pt,Da="Load the pre-trained model from the same checkpoint as you used for loading the processor:",Cs,it,Is,rt,La=`The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training, and re-enable cache for
generation to speed-up inference time:`,gs,Mt,$s,ot,Pa=`Define the training arguments. Here we are not computing any evaluation metrics during the training process,
we’ll talk about evaluation later in this chapter. Instead, we’ll only look at the loss:`,ks,ct,xs,mt,Ka="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",Zs,ht,vs,yt,Oa=`And with that, we’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,Gs,ut,Vs,dt,en="Push the final model to the 🤗 Hub:",Bs,wt,Ws,Jt,_s,Tt,tn=`Once you have fine-tuned a model, you can use it for inference! Load the model from the 🤗 Hub (make sure to use your
account name in the following code snippet):`,Xs,ft,Rs,Ut,ln="Pick an example, here we’ll take one from the test dataset. Obtain a speaker embedding.",Ys,jt,Qs,bt,sn="Define some input text and tokenize it.",Ns,Ct,As,It,an="Preprocess the input text:",zs,gt,Fs,$t,nn="Instantiate a vocoder and generate speech:",Es,kt,Hs,xt,pn="Ready to listen to the result?",qs,Zt,Ss,vt,rn=`Obtaining satisfactory results from this model on a new language can be challenging. The quality of the speaker
embeddings can be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,Ds,Gt,Mn=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,Ls,Vt,on="In the next section, we’ll talk about how we evaluate text-to-speech models.",Ps,Bt,Ks,_t,Os;return b=new Un({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new J({props:{title:"Fine-tuning SpeechT5",local:"fine-tuning-speecht5",headingTag:"h1"}}),g=new J({props:{title:"House-keeping",local:"house-keeping",headingTag:"h2"}}),k=new u({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),T=new fn({props:{warning:!0,$$slots:{default:[bn]},$$scope:{ctx:Xt}}}),Z=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),G=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),V=new J({props:{title:"The dataset",local:"the-dataset",headingTag:"h2"}}),X=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Y=new u({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),N=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),A=new J({props:{title:"Preprocessing the data",local:"preprocessing-the-data",headingTag:"h2"}}),F=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),E=new J({props:{title:"Text cleanup for SpeechT5 tokenization",local:"text-cleanup-for-speecht5-tokenization",headingTag:"h3"}}),q=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),D=new u({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),P=new u({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),te=new u({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),se=new u({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),ne=new u({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),ie=new u({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),Me=new J({props:{title:"Speakers",local:"speakers",headingTag:"h3"}}),ce=new u({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),he=new u({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),ue=new u({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),we=new u({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),Te=new u({props:{code:"NDI=",highlighted:"42",wrap:!1}}),Ue=new u({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),be=new u({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),ge=new J({props:{title:"Speaker embeddings",local:"speaker-embeddings",headingTag:"h3"}}),xe=new u({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),Ge=new J({props:{title:"Processing the dataset",local:"processing-the-dataset",headingTag:"h3"}}),Be=new u({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),_e=new u({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Re=new u({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),Qe=new u({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),Ae=new u({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),Fe=new u({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),qe=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),De=new u({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Pe=new u({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Oe=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),et=new J({props:{title:"Data collator",local:"data-collator",headingTag:"h3"}}),lt=new u({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMEFueSUyQyUyMERpY3QlMkMlMjBMaXN0JTJDJTIwVW5pb24lMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nJTNBJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29yJTNBJTIwQW55JTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUyMGZlYXR1cmVzJTNBJTIwTGlzdCU1QkRpY3QlNUJzdHIlMkMlMjBVbmlvbiU1Qkxpc3QlNUJpbnQlNUQlMkMlMjB0b3JjaC5UZW5zb3IlNUQlNUQlNUQlMEElMjAlMjAlMjAlMjApJTIwLSUzRSUyMERpY3QlNUJzdHIlMkMlMjB0b3JjaC5UZW5zb3IlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlMjAlM0QlMjAlNUIlN0IlMjJpbnB1dF9pZHMlMjIlM0ElMjBmZWF0dXJlJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTdEJTIwZm9yJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbF9mZWF0dXJlcyUyMCUzRCUyMCU1QiU3QiUyMmlucHV0X3ZhbHVlcyUyMiUzQSUyMGZlYXR1cmUlNUIlMjJsYWJlbHMlMjIlNUQlN0QlMjBmb3IlMjBmZWF0dXJlJTIwaW4lMjBmZWF0dXJlcyU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZmVhdHVyZXMlMjAlM0QlMjAlNUJmZWF0dXJlJTVCJTIyc3BlYWtlcl9lbWJlZGRpbmdzJTIyJTVEJTIwZm9yJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMlNUQlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBjb2xsYXRlJTIwdGhlJTIwaW5wdXRzJTIwYW5kJTIwdGFyZ2V0cyUyMGludG8lMjBhJTIwYmF0Y2glMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHByb2Nlc3Nvci5wYWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEbGFiZWxfZmVhdHVyZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHJlcGxhY2UlMjBwYWRkaW5nJTIwd2l0aCUyMC0xMDAlMjB0byUyMGlnbm9yZSUyMGxvc3MlMjBjb3JyZWN0bHklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVELm1hc2tlZF9maWxsKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoLmRlY29kZXJfYXR0ZW50aW9uX21hc2sudW5zcXVlZXplKC0xKS5uZSgxKSUyQyUyMC0xMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbm90JTIwdXNlZCUyMGR1cmluZyUyMGZpbmUtdHVuaW5nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVsJTIwYmF0Y2glNUIlMjJkZWNvZGVyX2F0dGVudGlvbl9tYXNrJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcm91bmQlMjBkb3duJTIwdGFyZ2V0JTIwbGVuZ3RocyUyMHRvJTIwbXVsdGlwbGUlMjBvZiUyMHJlZHVjdGlvbiUyMGZhY3RvciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbW9kZWwuY29uZmlnLnJlZHVjdGlvbl9mYWN0b3IlMjAlM0UlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0X2xlbmd0aHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCbGVuKGZlYXR1cmUlNUIlMjJpbnB1dF92YWx1ZXMlMjIlNUQpJTIwZm9yJTIwZmVhdHVyZSUyMGluJTIwbGFiZWxfZmVhdHVyZXMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0X2xlbmd0aHMlMjAlM0QlMjB0YXJnZXRfbGVuZ3Rocy5uZXcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGVuZ3RoJTIwLSUyMGxlbmd0aCUyMCUyNSUyMG1vZGVsLmNvbmZpZy5yZWR1Y3Rpb25fZmFjdG9yJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwbGVuZ3RoJTIwaW4lMjB0YXJnZXRfbGVuZ3RocyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTIwJTNEJTIwbWF4KHRhcmdldF9sZW5ndGhzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQlNUIlM0ElMkMlMjAlM0FtYXhfbGVuZ3RoJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwYWxzbyUyMGFkZCUyMGluJTIwdGhlJTIwc3BlYWtlciUyMGVtYmVkZGluZ3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMHRvcmNoLnRlbnNvcihzcGVha2VyX2ZlYXR1cmVzKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># not used during fine-tuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># also add in the speaker embeddings</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),at=new u({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),nt=new J({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),it=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),Mt=new u({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkaXNhYmxlJTIwY2FjaGUlMjBkdXJpbmclMjB0cmFpbmluZyUyMHNpbmNlJTIwaXQncyUyMGluY29tcGF0aWJsZSUyMHdpdGglMjBncmFkaWVudCUyMGNoZWNrcG9pbnRpbmclMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBzZXQlMjBsYW5ndWFnZSUyMGFuZCUyMHRhc2slMjBmb3IlMjBnZW5lcmF0aW9uJTIwYW5kJTIwcmUtZW5hYmxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># disable cache during training since it&#x27;s incompatible with gradient checkpointing</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># set language and task for generation and re-enable cache</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),ct=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ht=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),ut=new u({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),wt=new u({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),Jt=new J({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ft=new u({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),jt=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Ct=new u({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),gt=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),kt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),Zt=new u({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Bt=new jn({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter6/fine-tuning.mdx"}}),{c(){d=p("meta"),j=a(),w=p("p"),Wt=a(),M(b.$$.fragment),Rt=a(),M(C.$$.fragment),Yt=a(),I=p("p"),I.textContent=ta,Qt=a(),M(g.$$.fragment),Nt=a(),$=p("p"),$.textContent=la,At=a(),M(k.$$.fragment),zt=a(),M(T.$$.fragment),Ft=a(),x=p("p"),x.textContent=sa,Et=a(),M(Z.$$.fragment),Ht=a(),v=p("p"),v.textContent=aa,qt=a(),M(G.$$.fragment),St=a(),M(V.$$.fragment),Dt=a(),B=p("p"),B.innerHTML=na,Lt=a(),W=p("p"),W.textContent=pa,Pt=a(),_=p("p"),_.textContent=ia,Kt=a(),M(X.$$.fragment),Ot=a(),R=p("p"),R.innerHTML=ra,el=a(),M(Y.$$.fragment),tl=a(),Q=p("p"),Q.textContent=Ma,ll=a(),M(N.$$.fragment),sl=a(),M(A.$$.fragment),al=a(),z=p("p"),z.textContent=oa,nl=a(),M(F.$$.fragment),pl=a(),M(E.$$.fragment),il=a(),H=p("p"),H.textContent=ca,rl=a(),M(q.$$.fragment),Ml=a(),S=p("p"),S.textContent=ma,ol=a(),M(D.$$.fragment),cl=a(),L=p("p"),L.innerHTML=ha,ml=a(),M(P.$$.fragment),hl=a(),K=p("p"),K.innerHTML=ya,yl=a(),O=p("p"),O.innerHTML=ua,ul=a(),ee=p("p"),ee.innerHTML=da,dl=a(),M(te.$$.fragment),wl=a(),le=p("p"),le.textContent=wa,Jl=a(),M(se.$$.fragment),Tl=a(),ae=p("p"),ae.innerHTML=Ja,fl=a(),M(ne.$$.fragment),Ul=a(),pe=p("p"),pe.innerHTML=Ta,jl=a(),M(ie.$$.fragment),bl=a(),re=p("p"),re.textContent=fa,Cl=a(),M(Me.$$.fragment),Il=a(),oe=p("p"),oe.textContent=Ua,gl=a(),M(ce.$$.fragment),$l=a(),me=p("p"),me.textContent=ja,kl=a(),M(he.$$.fragment),xl=a(),f=p("div"),f.innerHTML=ba,Zl=a(),ye=p("p"),ye.textContent=Ca,vl=a(),M(ue.$$.fragment),Gl=a(),de=p("p"),de.textContent=Ia,Vl=a(),M(we.$$.fragment),Bl=a(),Je=p("p"),Je.innerHTML=ga,Wl=a(),M(Te.$$.fragment),_l=a(),fe=p("p"),fe.textContent=$a,Xl=a(),M(Ue.$$.fragment),Rl=a(),je=p("p"),je.innerHTML=ka,Yl=a(),M(be.$$.fragment),Ql=a(),Ce=p("p"),Ce.textContent=xa,Nl=a(),Ie=p("p"),Ie.textContent=Za,Al=a(),M(ge.$$.fragment),zl=a(),$e=p("p"),$e.innerHTML=va,Fl=a(),ke=p("p"),ke.innerHTML=Ga,El=a(),M(xe.$$.fragment),Hl=a(),Ze=p("p"),Ze.innerHTML=Va,ql=a(),ve=p("p"),ve.innerHTML=Ba,Sl=a(),M(Ge.$$.fragment),Dl=a(),Ve=p("p"),Ve.innerHTML=Wa,Ll=a(),M(Be.$$.fragment),Pl=a(),We=p("p"),We.textContent=_a,Kl=a(),M(_e.$$.fragment),Ol=a(),Xe=p("p"),Xe.innerHTML=Xa,es=a(),M(Re.$$.fragment),ts=a(),Ye=p("p"),Ye.textContent=Ra,ls=a(),M(Qe.$$.fragment),ss=a(),Ne=p("p"),Ne.innerHTML=Ya,as=a(),M(Ae.$$.fragment),ns=a(),ze=p("p"),ze.textContent=Qa,ps=a(),M(Fe.$$.fragment),is=a(),U=p("div"),U.innerHTML=Na,rs=a(),Ee=p("p"),Ee.textContent=Aa,Ms=a(),He=p("p"),He.textContent=za,os=a(),M(qe.$$.fragment),cs=a(),Se=p("p"),Se.textContent=Fa,ms=a(),M(De.$$.fragment),hs=a(),Le=p("p"),Le.innerHTML=Ea,ys=a(),M(Pe.$$.fragment),us=a(),Ke=p("p"),Ke.textContent=Ha,ds=a(),M(Oe.$$.fragment),ws=a(),M(et.$$.fragment),Js=a(),tt=p("p"),tt.innerHTML=qa,Ts=a(),M(lt.$$.fragment),fs=a(),st=p("p"),st.textContent=Sa,Us=a(),M(at.$$.fragment),js=a(),M(nt.$$.fragment),bs=a(),pt=p("p"),pt.textContent=Da,Cs=a(),M(it.$$.fragment),Is=a(),rt=p("p"),rt.innerHTML=La,gs=a(),M(Mt.$$.fragment),$s=a(),ot=p("p"),ot.textContent=Pa,ks=a(),M(ct.$$.fragment),xs=a(),mt=p("p"),mt.innerHTML=Ka,Zs=a(),M(ht.$$.fragment),vs=a(),yt=p("p"),yt.innerHTML=Oa,Gs=a(),M(ut.$$.fragment),Vs=a(),dt=p("p"),dt.textContent=en,Bs=a(),M(wt.$$.fragment),Ws=a(),M(Jt.$$.fragment),_s=a(),Tt=p("p"),Tt.textContent=tn,Xs=a(),M(ft.$$.fragment),Rs=a(),Ut=p("p"),Ut.textContent=ln,Ys=a(),M(jt.$$.fragment),Qs=a(),bt=p("p"),bt.textContent=sn,Ns=a(),M(Ct.$$.fragment),As=a(),It=p("p"),It.textContent=an,zs=a(),M(gt.$$.fragment),Fs=a(),$t=p("p"),$t.textContent=nn,Es=a(),M(kt.$$.fragment),Hs=a(),xt=p("p"),xt.textContent=pn,qs=a(),M(Zt.$$.fragment),Ss=a(),vt=p("p"),vt.textContent=rn,Ds=a(),Gt=p("p"),Gt.innerHTML=Mn,Ls=a(),Vt=p("p"),Vt.textContent=on,Ps=a(),M(Bt.$$.fragment),Ks=a(),_t=p("p"),this.h()},l(e){const t=Jn("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),j=n(e),w=i(e,"P",{}),mn(w).forEach(l),Wt=n(e),o(b.$$.fragment,e),Rt=n(e),o(C.$$.fragment,e),Yt=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-6isf2f"&&(I.textContent=ta),Qt=n(e),o(g.$$.fragment,e),Nt=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1pl1dgp"&&($.textContent=la),At=n(e),o(k.$$.fragment,e),zt=n(e),o(T.$$.fragment,e),Ft=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-9u3xmt"&&(x.textContent=sa),Et=n(e),o(Z.$$.fragment,e),Ht=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1lsy5mj"&&(v.textContent=aa),qt=n(e),o(G.$$.fragment,e),St=n(e),o(V.$$.fragment,e),Dt=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ixb96o"&&(B.innerHTML=na),Lt=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1p30ok7"&&(W.textContent=pa),Pt=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1soaqfm"&&(_.textContent=ia),Kt=n(e),o(X.$$.fragment,e),Ot=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1mvdyro"&&(R.innerHTML=ra),el=n(e),o(Y.$$.fragment,e),tl=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1xdebij"&&(Q.textContent=Ma),ll=n(e),o(N.$$.fragment,e),sl=n(e),o(A.$$.fragment,e),al=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1k7tad6"&&(z.textContent=oa),nl=n(e),o(F.$$.fragment,e),pl=n(e),o(E.$$.fragment,e),il=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-a1pl49"&&(H.textContent=ca),rl=n(e),o(q.$$.fragment,e),Ml=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-17epgem"&&(S.textContent=ma),ol=n(e),o(D.$$.fragment,e),cl=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1mvdyro"&&(L.innerHTML=ha),ml=n(e),o(P.$$.fragment,e),hl=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-y5gqfm"&&(K.innerHTML=ya),yl=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1qiuc1m"&&(O.innerHTML=ua),ul=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-19dff1r"&&(ee.innerHTML=da),dl=n(e),o(te.$$.fragment,e),wl=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-fefaym"&&(le.textContent=wa),Jl=n(e),o(se.$$.fragment,e),Tl=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1mvdyro"&&(ae.innerHTML=Ja),fl=n(e),o(ne.$$.fragment,e),Ul=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-akzhx6"&&(pe.innerHTML=Ta),jl=n(e),o(ie.$$.fragment,e),bl=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-hhu8o3"&&(re.textContent=fa),Cl=n(e),o(Me.$$.fragment,e),Il=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1edo483"&&(oe.textContent=Ua),gl=n(e),o(ce.$$.fragment,e),$l=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1hah56a"&&(me.textContent=ja),kl=n(e),o(he.$$.fragment,e),xl=n(e),f=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-1uufiik"&&(f.innerHTML=ba),Zl=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1ujf40"&&(ye.textContent=Ca),vl=n(e),o(ue.$$.fragment,e),Gl=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-g2dd32"&&(de.textContent=Ia),Vl=n(e),o(we.$$.fragment,e),Bl=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1mvdyro"&&(Je.innerHTML=ga),Wl=n(e),o(Te.$$.fragment,e),_l=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-hbes5t"&&(fe.textContent=$a),Xl=n(e),o(Ue.$$.fragment,e),Rl=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1mvdyro"&&(je.innerHTML=ka),Yl=n(e),o(be.$$.fragment,e),Ql=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-oizlk1"&&(Ce.textContent=xa),Nl=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1n0u7fp"&&(Ie.textContent=Za),Al=n(e),o(ge.$$.fragment,e),zl=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1xdfpy2"&&($e.innerHTML=va),Fl=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-7nncma"&&(ke.innerHTML=Ga),El=n(e),o(xe.$$.fragment,e),Hl=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1mtxkxr"&&(Ze.innerHTML=Va),ql=n(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-15ol8sg"&&(ve.innerHTML=Ba),Sl=n(e),o(Ge.$$.fragment,e),Dl=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1tlidee"&&(Ve.innerHTML=Wa),Ll=n(e),o(Be.$$.fragment,e),Pl=n(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-17mzfft"&&(We.textContent=_a),Kl=n(e),o(_e.$$.fragment,e),Ol=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1mvdyro"&&(Xe.innerHTML=Xa),es=n(e),o(Re.$$.fragment,e),ts=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1mqg4ck"&&(Ye.textContent=Ra),ls=n(e),o(Qe.$$.fragment,e),ss=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1mvdyro"&&(Ne.innerHTML=Ya),as=n(e),o(Ae.$$.fragment,e),ns=n(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-f7g58h"&&(ze.textContent=Qa),ps=n(e),o(Fe.$$.fragment,e),is=n(e),U=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-j4o1b8"&&(U.innerHTML=Na),rs=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1t9vz0y"&&(Ee.textContent=Aa),Ms=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-7crb3r"&&(He.textContent=za),os=n(e),o(qe.$$.fragment,e),cs=n(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-wvyh3r"&&(Se.textContent=Fa),ms=n(e),o(De.$$.fragment,e),hs=n(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1mvdyro"&&(Le.innerHTML=Ea),ys=n(e),o(Pe.$$.fragment,e),us=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-12gx63x"&&(Ke.textContent=Ha),ds=n(e),o(Oe.$$.fragment,e),ws=n(e),o(et.$$.fragment,e),Js=n(e),tt=i(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-rsy2my"&&(tt.innerHTML=qa),Ts=n(e),o(lt.$$.fragment,e),fs=n(e),st=i(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-u623yc"&&(st.textContent=Sa),Us=n(e),o(at.$$.fragment,e),js=n(e),o(nt.$$.fragment,e),bs=n(e),pt=i(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1kkriue"&&(pt.textContent=Da),Cs=n(e),o(it.$$.fragment,e),Is=n(e),rt=i(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1fpvhw6"&&(rt.innerHTML=La),gs=n(e),o(Mt.$$.fragment,e),$s=n(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1af5qye"&&(ot.textContent=Pa),ks=n(e),o(ct.$$.fragment,e),xs=n(e),mt=i(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1yq1u47"&&(mt.innerHTML=Ka),Zs=n(e),o(ht.$$.fragment,e),vs=n(e),yt=i(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-98ddde"&&(yt.innerHTML=Oa),Gs=n(e),o(ut.$$.fragment,e),Vs=n(e),dt=i(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-hefgo2"&&(dt.textContent=en),Bs=n(e),o(wt.$$.fragment,e),Ws=n(e),o(Jt.$$.fragment,e),_s=n(e),Tt=i(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-vqys4o"&&(Tt.textContent=tn),Xs=n(e),o(ft.$$.fragment,e),Rs=n(e),Ut=i(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-kiuzrb"&&(Ut.textContent=ln),Ys=n(e),o(jt.$$.fragment,e),Qs=n(e),bt=i(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1sn5mu7"&&(bt.textContent=sn),Ns=n(e),o(Ct.$$.fragment,e),As=n(e),It=i(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1sf6bxe"&&(It.textContent=an),zs=n(e),o(gt.$$.fragment,e),Fs=n(e),$t=i(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1kfdmvn"&&($t.textContent=nn),Es=n(e),o(kt.$$.fragment,e),Hs=n(e),xt=i(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-jp0xjb"&&(xt.textContent=pn),qs=n(e),o(Zt.$$.fragment,e),Ss=n(e),vt=i(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-yji0sl"&&(vt.textContent=rn),Ds=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-6lmfh0"&&(Gt.innerHTML=Mn),Ls=n(e),Vt=i(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-bv2cz9"&&(Vt.textContent=on),Ps=n(e),o(Bt.$$.fragment,e),Ks=n(e),_t=i(e,"P",{}),mn(_t).forEach(l),this.h()},h(){ea(d,"name","hf:doc:metadata"),ea(d,"content",In),ea(f,"class","flex justify-center"),ea(U,"class","flex justify-center")},m(e,t){Tn(document.head,d),s(e,j,t),s(e,w,t),s(e,Wt,t),c(b,e,t),s(e,Rt,t),c(C,e,t),s(e,Yt,t),s(e,I,t),s(e,Qt,t),c(g,e,t),s(e,Nt,t),s(e,$,t),s(e,At,t),c(k,e,t),s(e,zt,t),c(T,e,t),s(e,Ft,t),s(e,x,t),s(e,Et,t),c(Z,e,t),s(e,Ht,t),s(e,v,t),s(e,qt,t),c(G,e,t),s(e,St,t),c(V,e,t),s(e,Dt,t),s(e,B,t),s(e,Lt,t),s(e,W,t),s(e,Pt,t),s(e,_,t),s(e,Kt,t),c(X,e,t),s(e,Ot,t),s(e,R,t),s(e,el,t),c(Y,e,t),s(e,tl,t),s(e,Q,t),s(e,ll,t),c(N,e,t),s(e,sl,t),c(A,e,t),s(e,al,t),s(e,z,t),s(e,nl,t),c(F,e,t),s(e,pl,t),c(E,e,t),s(e,il,t),s(e,H,t),s(e,rl,t),c(q,e,t),s(e,Ml,t),s(e,S,t),s(e,ol,t),c(D,e,t),s(e,cl,t),s(e,L,t),s(e,ml,t),c(P,e,t),s(e,hl,t),s(e,K,t),s(e,yl,t),s(e,O,t),s(e,ul,t),s(e,ee,t),s(e,dl,t),c(te,e,t),s(e,wl,t),s(e,le,t),s(e,Jl,t),c(se,e,t),s(e,Tl,t),s(e,ae,t),s(e,fl,t),c(ne,e,t),s(e,Ul,t),s(e,pe,t),s(e,jl,t),c(ie,e,t),s(e,bl,t),s(e,re,t),s(e,Cl,t),c(Me,e,t),s(e,Il,t),s(e,oe,t),s(e,gl,t),c(ce,e,t),s(e,$l,t),s(e,me,t),s(e,kl,t),c(he,e,t),s(e,xl,t),s(e,f,t),s(e,Zl,t),s(e,ye,t),s(e,vl,t),c(ue,e,t),s(e,Gl,t),s(e,de,t),s(e,Vl,t),c(we,e,t),s(e,Bl,t),s(e,Je,t),s(e,Wl,t),c(Te,e,t),s(e,_l,t),s(e,fe,t),s(e,Xl,t),c(Ue,e,t),s(e,Rl,t),s(e,je,t),s(e,Yl,t),c(be,e,t),s(e,Ql,t),s(e,Ce,t),s(e,Nl,t),s(e,Ie,t),s(e,Al,t),c(ge,e,t),s(e,zl,t),s(e,$e,t),s(e,Fl,t),s(e,ke,t),s(e,El,t),c(xe,e,t),s(e,Hl,t),s(e,Ze,t),s(e,ql,t),s(e,ve,t),s(e,Sl,t),c(Ge,e,t),s(e,Dl,t),s(e,Ve,t),s(e,Ll,t),c(Be,e,t),s(e,Pl,t),s(e,We,t),s(e,Kl,t),c(_e,e,t),s(e,Ol,t),s(e,Xe,t),s(e,es,t),c(Re,e,t),s(e,ts,t),s(e,Ye,t),s(e,ls,t),c(Qe,e,t),s(e,ss,t),s(e,Ne,t),s(e,as,t),c(Ae,e,t),s(e,ns,t),s(e,ze,t),s(e,ps,t),c(Fe,e,t),s(e,is,t),s(e,U,t),s(e,rs,t),s(e,Ee,t),s(e,Ms,t),s(e,He,t),s(e,os,t),c(qe,e,t),s(e,cs,t),s(e,Se,t),s(e,ms,t),c(De,e,t),s(e,hs,t),s(e,Le,t),s(e,ys,t),c(Pe,e,t),s(e,us,t),s(e,Ke,t),s(e,ds,t),c(Oe,e,t),s(e,ws,t),c(et,e,t),s(e,Js,t),s(e,tt,t),s(e,Ts,t),c(lt,e,t),s(e,fs,t),s(e,st,t),s(e,Us,t),c(at,e,t),s(e,js,t),c(nt,e,t),s(e,bs,t),s(e,pt,t),s(e,Cs,t),c(it,e,t),s(e,Is,t),s(e,rt,t),s(e,gs,t),c(Mt,e,t),s(e,$s,t),s(e,ot,t),s(e,ks,t),c(ct,e,t),s(e,xs,t),s(e,mt,t),s(e,Zs,t),c(ht,e,t),s(e,vs,t),s(e,yt,t),s(e,Gs,t),c(ut,e,t),s(e,Vs,t),s(e,dt,t),s(e,Bs,t),c(wt,e,t),s(e,Ws,t),c(Jt,e,t),s(e,_s,t),s(e,Tt,t),s(e,Xs,t),c(ft,e,t),s(e,Rs,t),s(e,Ut,t),s(e,Ys,t),c(jt,e,t),s(e,Qs,t),s(e,bt,t),s(e,Ns,t),c(Ct,e,t),s(e,As,t),s(e,It,t),s(e,zs,t),c(gt,e,t),s(e,Fs,t),s(e,$t,t),s(e,Es,t),c(kt,e,t),s(e,Hs,t),s(e,xt,t),s(e,qs,t),c(Zt,e,t),s(e,Ss,t),s(e,vt,t),s(e,Ds,t),s(e,Gt,t),s(e,Ls,t),s(e,Vt,t),s(e,Ps,t),c(Bt,e,t),s(e,Ks,t),s(e,_t,t),Os=!0},p(e,[t]){const cn={};t&2&&(cn.$$scope={dirty:t,ctx:e}),T.$set(cn)},i(e){Os||(m(b.$$.fragment,e),m(C.$$.fragment,e),m(g.$$.fragment,e),m(k.$$.fragment,e),m(T.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(A.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(Me.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(be.$$.fragment,e),m(ge.$$.fragment,e),m(xe.$$.fragment,e),m(Ge.$$.fragment,e),m(Be.$$.fragment,e),m(_e.$$.fragment,e),m(Re.$$.fragment,e),m(Qe.$$.fragment,e),m(Ae.$$.fragment,e),m(Fe.$$.fragment,e),m(qe.$$.fragment,e),m(De.$$.fragment,e),m(Pe.$$.fragment,e),m(Oe.$$.fragment,e),m(et.$$.fragment,e),m(lt.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(it.$$.fragment,e),m(Mt.$$.fragment,e),m(ct.$$.fragment,e),m(ht.$$.fragment,e),m(ut.$$.fragment,e),m(wt.$$.fragment,e),m(Jt.$$.fragment,e),m(ft.$$.fragment,e),m(jt.$$.fragment,e),m(Ct.$$.fragment,e),m(gt.$$.fragment,e),m(kt.$$.fragment,e),m(Zt.$$.fragment,e),m(Bt.$$.fragment,e),Os=!0)},o(e){h(b.$$.fragment,e),h(C.$$.fragment,e),h(g.$$.fragment,e),h(k.$$.fragment,e),h(T.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(A.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(P.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(Me.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ue.$$.fragment,e),h(be.$$.fragment,e),h(ge.$$.fragment,e),h(xe.$$.fragment,e),h(Ge.$$.fragment,e),h(Be.$$.fragment,e),h(_e.$$.fragment,e),h(Re.$$.fragment,e),h(Qe.$$.fragment,e),h(Ae.$$.fragment,e),h(Fe.$$.fragment,e),h(qe.$$.fragment,e),h(De.$$.fragment,e),h(Pe.$$.fragment,e),h(Oe.$$.fragment,e),h(et.$$.fragment,e),h(lt.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(it.$$.fragment,e),h(Mt.$$.fragment,e),h(ct.$$.fragment,e),h(ht.$$.fragment,e),h(ut.$$.fragment,e),h(wt.$$.fragment,e),h(Jt.$$.fragment,e),h(ft.$$.fragment,e),h(jt.$$.fragment,e),h(Ct.$$.fragment,e),h(gt.$$.fragment,e),h(kt.$$.fragment,e),h(Zt.$$.fragment,e),h(Bt.$$.fragment,e),Os=!1},d(e){e&&(l(j),l(w),l(Wt),l(Rt),l(Yt),l(I),l(Qt),l(Nt),l($),l(At),l(zt),l(Ft),l(x),l(Et),l(Ht),l(v),l(qt),l(St),l(Dt),l(B),l(Lt),l(W),l(Pt),l(_),l(Kt),l(Ot),l(R),l(el),l(tl),l(Q),l(ll),l(sl),l(al),l(z),l(nl),l(pl),l(il),l(H),l(rl),l(Ml),l(S),l(ol),l(cl),l(L),l(ml),l(hl),l(K),l(yl),l(O),l(ul),l(ee),l(dl),l(wl),l(le),l(Jl),l(Tl),l(ae),l(fl),l(Ul),l(pe),l(jl),l(bl),l(re),l(Cl),l(Il),l(oe),l(gl),l($l),l(me),l(kl),l(xl),l(f),l(Zl),l(ye),l(vl),l(Gl),l(de),l(Vl),l(Bl),l(Je),l(Wl),l(_l),l(fe),l(Xl),l(Rl),l(je),l(Yl),l(Ql),l(Ce),l(Nl),l(Ie),l(Al),l(zl),l($e),l(Fl),l(ke),l(El),l(Hl),l(Ze),l(ql),l(ve),l(Sl),l(Dl),l(Ve),l(Ll),l(Pl),l(We),l(Kl),l(Ol),l(Xe),l(es),l(ts),l(Ye),l(ls),l(ss),l(Ne),l(as),l(ns),l(ze),l(ps),l(is),l(U),l(rs),l(Ee),l(Ms),l(He),l(os),l(cs),l(Se),l(ms),l(hs),l(Le),l(ys),l(us),l(Ke),l(ds),l(ws),l(Js),l(tt),l(Ts),l(fs),l(st),l(Us),l(js),l(bs),l(pt),l(Cs),l(Is),l(rt),l(gs),l($s),l(ot),l(ks),l(xs),l(mt),l(Zs),l(vs),l(yt),l(Gs),l(Vs),l(dt),l(Bs),l(Ws),l(_s),l(Tt),l(Xs),l(Rs),l(Ut),l(Ys),l(Qs),l(bt),l(Ns),l(As),l(It),l(zs),l(Fs),l($t),l(Es),l(Hs),l(xt),l(qs),l(Ss),l(vt),l(Ds),l(Gt),l(Ls),l(Vt),l(Ps),l(Ks),l(_t)),l(d),y(b,e),y(C,e),y(g,e),y(k,e),y(T,e),y(Z,e),y(G,e),y(V,e),y(X,e),y(Y,e),y(N,e),y(A,e),y(F,e),y(E,e),y(q,e),y(D,e),y(P,e),y(te,e),y(se,e),y(ne,e),y(ie,e),y(Me,e),y(ce,e),y(he,e),y(ue,e),y(we,e),y(Te,e),y(Ue,e),y(be,e),y(ge,e),y(xe,e),y(Ge,e),y(Be,e),y(_e,e),y(Re,e),y(Qe,e),y(Ae,e),y(Fe,e),y(qe,e),y(De,e),y(Pe,e),y(Oe,e),y(et,e),y(lt,e),y(at,e),y(nt,e),y(it,e),y(Mt,e),y(ct,e),y(ht,e),y(ut,e),y(wt,e),y(Jt,e),y(ft,e),y(jt,e),y(Ct,e),y(gt,e),y(kt,e),y(Zt,e),y(Bt,e)}}}const In='{"title":"Fine-tuning SpeechT5","local":"fine-tuning-speecht5","sections":[{"title":"House-keeping","local":"house-keeping","sections":[],"depth":2},{"title":"The dataset","local":"the-dataset","sections":[],"depth":2},{"title":"Preprocessing the data","local":"preprocessing-the-data","sections":[{"title":"Text cleanup for SpeechT5 tokenization","local":"text-cleanup-for-speecht5-tokenization","sections":[],"depth":3},{"title":"Speakers","local":"speakers","sections":[],"depth":3},{"title":"Speaker embeddings","local":"speaker-embeddings","sections":[],"depth":3},{"title":"Processing the dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Data collator","local":"data-collator","sections":[],"depth":3}],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function gn(Xt){return yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gn extends dn{constructor(d){super(),wn(this,d,gn,Cn,hn,{})}}export{Gn as component};
