import{s as Cl,n as xl,o as El}from"../chunks/scheduler.cd324960.js";import{S as Gl,i as Rl,e as i,s as l,c as p,q as J,H as pa,h as $l,a as o,d as s,b as n,f as ua,g as h,j as r,r as b,u as ha,k as ct,l as T,m as a,n as c,t as d,o as m,p as M}from"../chunks/index.d5c3adcc.js";import{C as Vl,H as dt,E as Hl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.92ea4747.js";import{C as u}from"../chunks/CodeBlock.bef85339.js";function Wl(ya){let U,mt,pt,Mt,j,ut,I,yt,k,wa=`In this section, we’ll cover how to use the <code>pipeline()</code> to leverage pre-trained models for speech recognition. In <a href="../chapter2/asr_pipeline">Unit 2</a>,
we introduced the <code>pipeline()</code> as an easy way of running speech recognition tasks, with all pre- and post-processing handled under-the-hood
and the flexibility to quickly experiment with any pre-trained checkpoint on the Hugging Face Hub. In this Unit, we’ll go a
level deeper and explore the different attributes of speech recognition models and how we can use them to tackle a range
of different tasks.`,wt,v,Ta="As detailed in Unit 3, speech recognition model broadly fall into one of two categories:",Tt,S,Ua="<li>Connectionist Temporal Classification (CTC): <em>encoder-only</em> models with a linear classification (CTC) head on top</li> <li>Sequence-to-sequence (Seq2Seq): <em>encoder-decoder</em> models, with a cross-attention mechanism between the encoder and decoder</li>",Ut,B,fa=`Prior to 2022, CTC was the more popular of the two architectures, with encoder-only models such as Wav2Vec2, HuBERT and XLSR achieving
breakthoughs in the pre-training / fine-tuning paradigm for speech. Big corporations, such as Meta and Microsoft, pre-trained
the encoder on vast amounts of unlabelled audio data for many days or weeks. Users could then take a pre-trained checkpoint, and
fine-tune it with a CTC head on as little as <strong>10 minutes</strong> of labelled speech data to achieve strong performance on a downstream
speech recognition task.`,ft,C,ga=`However, CTC models have their shortcomings. Appending a simple linear layer to an encoder gives a small, fast overall model, but can
be prone to phonetic spelling errors. We’ll demonstrate this for the Wav2Vec2 model below.`,gt,x,Jt,E,Ja=`Let’s load a small excerpt of the <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> dataset to demonstrate
Wav2Vec2’s speech transcription capabilities:`,bt,G,jt,R,ba="<strong>Output:</strong>",It,$,kt,V,ja="We can pick one of the 73 audio samples and inspect the audio sample as well as the transcription:",vt,H,St,W,Ia="<strong>Output:</strong>",Bt,F,Ct,Z,ka=`Alright! Christmas and roast beef, sounds great! 🎄 Having chosen a data sample, we now load a fine-tuned checkpoint into
the <code>pipeline()</code>. For this, we’ll use the official <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a> checkpoint fine-tuned on
100 hours of LibriSpeech data:`,xt,N,Et,_,va=`Next, we’ll take an example from the dataset and pass its raw data to the pipeline. Since the <code>pipeline</code> <em>consumes</em> any
dictionary that we pass it (meaning it cannot be re-used), we’ll pass a copy of the data. This way, we can safely re-use
the same audio sample in the following examples:`,Gt,Y,Rt,L,Sa="<strong>Output:</strong>",$t,Q,Vt,q,Ba=`We can see that the Wav2Vec2 model does a pretty good job at transcribing this sample - at a first glance it looks generally correct.
Let’s put the target and prediction side-by-side and highlight the differences:`,Ht,A,Wt,X,Ca="Comparing the target text to the predicted transcription, we can see that all words <em>sound</em> correct, but some are not spelled accurately. For example:",Ft,z,xa="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",Zt,P,Ea=`This highlights the shortcoming of a CTC model. A CTC model is essentially an ‘acoustic-only’ model: it consists of an encoder
which forms hidden-state representations from the audio inputs, and a linear layer which maps the hidden-states to characters:`,Nt,O,Ga=`This means that the system almost entirely bases its prediction on the acoustic input it was given (the phonetic sounds of the audio),
and so has a tendency to transcribe the audio in a phonetic way (e.g. <em>CHRISTMAUS</em>). It gives less importance to the
language modelling context of previous and successive letters, and so is prone to phonetic spelling errors. A more intelligent model
would identify that <em>CHRISTMAUS</em> is not a valid word in the English vocabulary, and correct it to <em>CHRISTMAS</em> when making
its predictions. We’re also missing two big features in our prediction - casing and punctuation - which limits the usefulness of
the model’s transcriptions to real-world applications.`,_t,D,Yt,K,Ra=`Cue Seq2Seq models! As outlined in Unit 3, Seq2Seq models are formed of an encoder and decoder linked via a cross-attention
mechanism. The encoder plays the same role as before, computing hidden-state representations of the audio inputs, while the decoder
plays the role of a <strong>language model</strong>. The decoder processes the entire sequence of hidden-state representations
from the encoder and generates the corresponding text transcriptions. With global context of the audio input, the decoder
is able to use language modelling context as it makes its predictions, correcting for spelling mistakes on-the-fly and thus
circumventing the issue of phonetic predictions.`,Lt,ee,$a="There are two downsides to Seq2Seq models:",Qt,te,Va="<li>They are inherently slower at decoding, since the decoding process happens one step at a time, rather than all at once</li> <li>They are more data hungry, requiring significantly more training data to reach convergence</li>",qt,se,Ha=`In particular, the need for large amounts of training data has been a bottleneck in the advancement of Seq2Seq architectures for
speech. Labelled speech data is difficult to come by, with the largest annotated datasets at the time clocking in at just
10,000 hours. This all changed in 2022 upon the release of <strong>Whisper</strong>. Whisper is a pre-trained model for speech recognition
published in <a href="https://openai.com/blog/whisper/" rel="nofollow">September 2022</a> by the authors Alec Radford et al. from OpenAI. Unlike
its CTC predecessors, which were pre-trained entirely on <strong>un-labelled</strong> audio data, Whisper is pre-trained on a vast quantity of
<strong>labelled</strong> audio-transcription data, 680,000 hours to be precise.`,At,ae,Wa=`This is an order of magnitude more data than the un-labelled audio data used to train Wav2Vec 2.0 (60,000 hours). What is
more, 117,000 hours of this pre-training data is multilingual (or “non-English”) data. This results in checkpoints that can be applied to
over 96 languages, many of which are considered <em>low-resource</em>, meaning the language lacks a large corpus of data suitable for training.`,Xt,le,Fa=`When scaled to 680,000 hours of labelled pre-training data, Whisper models demonstrate a strong ability to generalise to
many datasets and domains. The pre-trained checkpoints achieve competitive results to state-of-the-art pipe systems, with
near 3% word error rate (WER) on the test-clean subset of LibriSpeech pipe and a new state-of-the-art on TED-LIUM with
4.7% WER (<em>c.f.</em> Table 8 of the <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,zt,ne,Za=`Of particular importance is Whisper’s ability to handle long-form audio samples, its robustness to input noise and ability
to predict cased and punctuated transcriptions. This makes it a viable candidate for real-world speech recognition systems.`,Pt,ie,Na=`The remainder of this section will show you how to use the pre-trained Whisper models for speech recognition using 🤗
Transformers. In many situations, the pre-trained Whisper checkpoints are extremely performant and give great results,
thus we encourage you to try using the pre-trained checkpoints as a first step to solving any speech recognition problem.
Through fine-tuning, the pre-trained checkpoints can be adapted for specific datasets and languages to further improve
upon these results. We’ll demonstrate how to do this in the upcoming subsection on <a href="fine-tuning">fine-tuning</a>.`,Ot,oe,_a=`The Whisper checkpoints come in five configurations of varying model sizes. The smallest four are trained on either
English-only or multilingual data. The largest checkpoint is multilingual only. All nine of the pre-trained checkpoints
are available on the <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. The checkpoints are
summarised in the following table with links to the models on the Hub. “VRAM” denotes the required GPU memory to run the
model with the minimum batch size of 1. “Rel Speed” is the relative speed of a checkpoint compared to the largest model.
Based on this information, you can select a checkpoint that is best suited to your hardware.`,Dt,re,Ya='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Kt,pe,La=`Let’s load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which is of comparable size to the
Wav2Vec2 checkpoint we used previously. Preempting our move to multilingual speech recognition, we’ll load the multilingual
variant of the base checkpoint. We’ll also load the model on the GPU if available, or CPU otherwise. The <code>pipeline()</code> will
subsequently take care of moving all inputs / outputs from the CPU to the GPU as required:`,es,he,ts,ce,Qa=`Great! Now let’s transcribe the audio as before. The only change we make is passing an extra argument, <code>max_new_tokens</code>,
which tells the model the maximum number of tokens to generate when making its prediction:`,ss,de,as,me,qa="<strong>Output:</strong>",ls,Me,ns,ue,Aa=`Easy enough! The first thing you’ll notice is the presence of both casing and punctuation. Immediately this makes the
transcription easier to read compared to the un-cased and un-punctuated transcription from Wav2Vec2. Let’s put the transcription
side-by-side with the target:`,is,ye,os,we,Xa=`Whisper has done a great job at correcting the phonetic errors we saw from Wav2Vec2 - both <em>Christmas</em> and <em>roast</em> are
spelled correctly. We see that the model still struggles with <em>SIMILES</em>, being incorrectly transcribed as <em>similarly</em>, but
this time the prediction is a valid word from the English vocabulary. Using a larger Whisper checkpoint can help further
reduce transcription errors, at the expense of requiring more compute and a longer transcription time.`,rs,Te,za=`We’ve been promised a model that can handle 96 languages, so lets leave English speech recognition for now and go global 🌎!
The <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) dataset is
the multilingual equivalent of the LibriSpeech dataset, with labelled audio data in six languages. We’ll load one sample
from the Spanish split of the MLS dataset, making use of <em>streaming</em> mode so that we don’t have to download the entire dataset:`,ps,Ue,hs,fe,Pa="Again, we’ll inspect the text transcription and take a listen to the audio segment:",cs,ge,ds,Je,Oa="<strong>Output:</strong>",ms,be,Ms,je,Da=`This is the target text that we’re aiming for with our Whisper transcription. Although we now know that we can
probably do better this, since our model is also going to predict punctuation and casing, neither of which are present in the
reference. Let’s forward the audio sample to the pipeline to get our text prediction. One thing to note is that the
pipeline <em>consumes</em> the dictionary of audio inputs that we input, meaning the dictionary can’t be re-used. To circumvent
this, we’ll pass a <em>copy</em> of the audio sample, so that we can re-use the same audio sample in the proceeding code examples:`,us,Ie,ys,ke,Ka="<strong>Output:</strong>",ws,ve,Ts,Se,el=`Great - this looks very similar to our reference text (arguably better since it has punctuation and casing!). You’ll notice
that we forwarded the <code>&quot;task&quot;</code> as a <em>generate key-word argument</em> (generate kwarg). Setting the <code>&quot;task&quot;</code> to <code>&quot;transcribe&quot;</code>
forces Whisper to perform the task of <em>speech recognition</em>, where the audio is transcribed in the same language that the
speech was spoken in. Whisper is also capable of performing the closely related task of <em>speech translation</em>, where the
audio in Spanish can be translated to text in English. To achieve this, we set the <code>&quot;task&quot;</code> to <code>&quot;translate&quot;</code>:`,Us,Be,fs,Ce,tl="<strong>Output:</strong>",gs,xe,Js,Ee,sl=`Now that we know we can toggle between speech recognition and speech translation, we can pick our task depending on our
needs. Either we recognise from audio in language X to text in the same language X (e.g. Spanish audio to Spanish text),
or we translate from audio in any language X to text in English (e.g. Spanish audio to English text).`,bs,Ge,al=`To read more about how the <code>&quot;task&quot;</code> argument is used to control the properties of the generated text, refer to the
<a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">model card</a> for the Whisper base model.`,js,Re,Is,$e,ll=`So far, we’ve focussed on transcribing short audio samples of less than 30 seconds. We mentioned that one of the appeals
of Whisper was its ability to work on long audio samples. We’ll tackle this task here!`,ks,Ve,nl=`Let’s create a long audio file by concatenating sequential samples from the MLS dataset. Since the MLS dataset is
curated by splitting long audiobook recordings into shorter segments, concatenating samples is one way of reconstructing
longer audiobook passages. Consequently, the resulting audio should be coherent across the entire sample.`,vs,He,il="We’ll set our target audio length to 5 minutes, and stop concatenating samples once we hit this value:",Ss,We,Bs,Fe,ol="<strong>Output:</strong>",Cs,Ze,xs,Ne,rl=`Alright! 5 minutes and 17 seconds of audio to transcribe. There are two problems with forwarding this long audio sample
directly to the model:`,Es,_e,pl="<li>Whisper is inherently designed to work with 30 second samples: anything shorter than 30s is padded to 30s with silence, anything longer than 30s is truncated to 30s by cutting of the extra audio, so if we pass our audio directly we’ll only get the transcription for the first 30s</li> <li>Memory in a transformer network scales with the sequence length squared: doubling the input length quadruples the memory requirement, so passing super long audio files is bound to lead to an out-of-memory (OOM) error</li>",Gs,Ye,hl=`The way long-form transcription works in 🤗 Transformers is by <em>chunking</em> the input audio into smaller, more manageable segments.
Each segment has a small amount of overlap with the previous one. This allows us to accurately stitch the segments back together
at the boundaries, since we can find the overlap between segments and merge the transcriptions accordingly:`,Rs,f,cl='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',$s,y,ca,Vs,kl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Hs,Ws,vl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Fs,ot,dl="stateless",da,Zs,Sl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Ns,_s,Bl='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Ys,rt,ml="batch",ma,g,Ml="blog post",Ma,Ls,Le,ul=`To activate long-form transcriptions, we have to add one additional argument when we call the pipeline. This argument,
<code>chunk_length_s</code>, controls the length of the chunked segments in seconds. For Whisper, 30 second chunks are optimal,
since this matches the input length Whisper expects.`,Qs,Qe,yl=`To activate batching, we need to pass the argument <code>batch_size</code> to the pipeline. Putting it all together, we can transcribe the
long audio sample with chunking and batching as follows:`,qs,qe,As,Ae,wl="<strong>Output:</strong>",Xs,Xe,zs,ze,Tl=`We won’t print the entire output here since it’s pretty long (312 words total)! On a 16GB V100 GPU, you can expect the above
line to take approximately 3.45 seconds to run, which is pretty good for a 317 second audio sample. On a CPU, expect
closer to 30 seconds.`,Ps,Pe,Ul=`Whisper is also able to predict segment-level <em>timestamps</em> for the audio data. These timestamps indicate the start and end
time for a short passage of audio, and are particularly useful for aligning a transcription with the input audio. Suppose
we want to provide closed captions for a video - we need these timestamps to know which part of the transcription corresponds
to a certain segment of video, in order to display the correct transcription for that time.`,Os,Oe,fl=`Activating timestamp prediction is straightforward, we just need to set the argument <code>return_timestamps=True</code>. Timestamps
are compatible with both the chunking and batching methods we used previously, so we can simply append the timestamp
argument to our previous call:`,Ds,De,Ks,Ke,gl="<strong>Output:</strong>",ea,et,ta,tt,Jl="And voila! We have our predicted text as well as corresponding timestamps.",sa,st,aa,at,bl=`Whisper is a strong pre-trained model for speech recognition and translation. Compared to Wav2Vec2, it has higher
transcription accuracy, with outputs that contain punctuation and casing. It can be used to transcribe speech in English
as well as 96 other languages, both on short audio segments and longer ones through <em>chunking</em>. These attributes make it
a viable model for many speech recognition and translation tasks without the need for fine-tuning. The <code>pipeline()</code> method
provides an easy way of running inference in one-line API calls with control over the generated predictions.`,la,lt,jl=`While the Whisper model performs extremely well on many high-resource languages, it has lower transcription and translation
accuracy on low-resource languages, i.e. those with less readily available training data. There is also varying performance
across different accents and dialects of certain languages, including lower accuracy for speakers of different genders,
races, ages or other demographic criteria (<em>c.f.</em> <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper paper</a>).`,na,nt,Il=`To boost the performance on low-resource languages, accents or dialects, we can take the pre-trained Whisper model and
train it on a small corpus of appropriately selected data, in a process called <em>fine-tuning</em>. We’ll show that with
as little as ten hours of additional data, we can improve the performance of the Whisper model by over 100% on a low-resource
language. In the next section, we’ll cover the process behind selecting a dataset for fine-tuning.`,ia,it,oa,ht,ra;return j=new Vl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new dt({props:{title:"Pre-trained models for automatic speech recognition",local:"pre-trained-models-for-automatic-speech-recognition",headingTag:"h1"}}),x=new dt({props:{title:"Probing CTC Models",local:"probing-ctc-models",headingTag:"h2"}}),G=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),$=new u({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),H=new u({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),F=new u({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),N=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),Y=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),Q=new u({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),A=new u({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),D=new dt({props:{title:"Graduation to Seq2Seq",local:"graduation-to-seq2seq",headingTag:"h2"}}),he=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),de=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),Me=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),ye=new u({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),Ue=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),ge=new u({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),be=new u({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),Ie=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),ve=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),Be=new u({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),xe=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),Re=new dt({props:{title:"Long-Form Transcription and Timestamps",local:"long-form-transcription-and-timestamps",headingTag:"h2"}}),We=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBmcm9tJTIwbWludXRlcyUyMHRvJTIwc2Vjb25kcyUyMCgqJTIwNjApJTIwdG8lMjBudW0lMjBzYW1wbGVzJTIwKColMjBzYW1wbGluZyUyMHJhdGUpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMHBpcGUuZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUwQXRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUyMCUzRCUyMHRhcmdldF9sZW5ndGhfaW5fbSUyMColMjA2MCUyMColMjBzYW1wbGluZ19yYXRlJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMG92ZXIlMjBvdXIlMjBzdHJlYW1pbmclMjBkYXRhc2V0JTJDJTIwY29uY2F0ZW5hdGluZyUyMHNhbXBsZXMlMjB1bnRpbCUyMHdlJTIwaGl0JTIwb3VyJTIwdGFyZ2V0JTBBbG9uZ19hdWRpbyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMHNhbXBsZSUyMGluJTIwZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMGxvbmdfYXVkaW8uZXh0ZW5kKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4obG9uZ19hdWRpbyklMjAlM0UlMjB0YXJnZXRfbGVuZ3RoX2luX3NhbXBsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUwQWxvbmdfYXVkaW8lMjAlM0QlMjBucC5hc2FycmF5KGxvbmdfYXVkaW8pJTBBJTBBJTIzJTIwaG93JTIwZGlkJTIwd2UlMjBkbyUzRiUwQXNlY29uZHMlMjAlM0QlMjBsZW4obG9uZ19hdWRpbyklMjAlMkYlMjAxNjAwMCUwQW1pbnV0ZXMlMkMlMjBzZWNvbmRzJTIwJTNEJTIwZGl2bW9kKHNlY29uZHMlMkMlMjA2MCklMEFwcmludChmJTIyTGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwJTdCbWludXRlcyU3RCUyMG1pbnV0ZXMlMjAlN0JzZWNvbmRzJTNBLjJmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># convert from minutes to seconds (* 60) to num samples (* sampling rate)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># iterate over our streaming dataset, concatenating samples until we hit our target</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># how did we do?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Ze=new u({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),qe=new u({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),Xe=new u({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),De=new u({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),et=new u({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),st=new dt({props:{title:"Summary",local:"summary",headingTag:"h2"}}),it=new Hl({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/asr_models.mdx"}}),{c(){U=i("meta"),mt=l(),pt=i("p"),Mt=l(),p(j.$$.fragment),ut=l(),p(I.$$.fragment),yt=l(),k=i("p"),k.innerHTML=wa,wt=l(),v=i("p"),v.textContent=Ta,Tt=l(),S=i("ol"),S.innerHTML=Ua,Ut=l(),B=i("p"),B.innerHTML=fa,ft=l(),C=i("p"),C.textContent=ga,gt=l(),p(x.$$.fragment),Jt=l(),E=i("p"),E.innerHTML=Ja,bt=l(),p(G.$$.fragment),jt=l(),R=i("p"),R.innerHTML=ba,It=l(),p($.$$.fragment),kt=l(),V=i("p"),V.textContent=ja,vt=l(),p(H.$$.fragment),St=l(),W=i("p"),W.innerHTML=Ia,Bt=l(),p(F.$$.fragment),Ct=l(),Z=i("p"),Z.innerHTML=ka,xt=l(),p(N.$$.fragment),Et=l(),_=i("p"),_.innerHTML=va,Gt=l(),p(Y.$$.fragment),Rt=l(),L=i("p"),L.innerHTML=Sa,$t=l(),p(Q.$$.fragment),Vt=l(),q=i("p"),q.textContent=Ba,Ht=l(),p(A.$$.fragment),Wt=l(),X=i("p"),X.innerHTML=Ca,Ft=l(),z=i("ul"),z.innerHTML=xa,Zt=l(),P=i("p"),P.textContent=Ea,Nt=l(),O=i("p"),O.innerHTML=Ga,_t=l(),p(D.$$.fragment),Yt=l(),K=i("p"),K.innerHTML=Ra,Lt=l(),ee=i("p"),ee.textContent=$a,Qt=l(),te=i("ol"),te.innerHTML=Va,qt=l(),se=i("p"),se.innerHTML=Ha,At=l(),ae=i("p"),ae.innerHTML=Wa,Xt=l(),le=i("p"),le.innerHTML=Fa,zt=l(),ne=i("p"),ne.textContent=Za,Pt=l(),ie=i("p"),ie.innerHTML=Na,Ot=l(),oe=i("p"),oe.innerHTML=_a,Dt=l(),re=i("table"),re.innerHTML=Ya,Kt=l(),pe=i("p"),pe.innerHTML=La,es=l(),p(he.$$.fragment),ts=l(),ce=i("p"),ce.innerHTML=Qa,ss=l(),p(de.$$.fragment),as=l(),me=i("p"),me.innerHTML=qa,ls=l(),p(Me.$$.fragment),ns=l(),ue=i("p"),ue.textContent=Aa,is=l(),p(ye.$$.fragment),os=l(),we=i("p"),we.innerHTML=Xa,rs=l(),Te=i("p"),Te.innerHTML=za,ps=l(),p(Ue.$$.fragment),hs=l(),fe=i("p"),fe.textContent=Pa,cs=l(),p(ge.$$.fragment),ds=l(),Je=i("p"),Je.innerHTML=Oa,ms=l(),p(be.$$.fragment),Ms=l(),je=i("p"),je.innerHTML=Da,us=l(),p(Ie.$$.fragment),ys=l(),ke=i("p"),ke.innerHTML=Ka,ws=l(),p(ve.$$.fragment),Ts=l(),Se=i("p"),Se.innerHTML=el,Us=l(),p(Be.$$.fragment),fs=l(),Ce=i("p"),Ce.innerHTML=tl,gs=l(),p(xe.$$.fragment),Js=l(),Ee=i("p"),Ee.textContent=sl,bs=l(),Ge=i("p"),Ge.innerHTML=al,js=l(),p(Re.$$.fragment),Is=l(),$e=i("p"),$e.textContent=ll,ks=l(),Ve=i("p"),Ve.textContent=nl,vs=l(),He=i("p"),He.textContent=il,Ss=l(),p(We.$$.fragment),Bs=l(),Fe=i("p"),Fe.innerHTML=ol,Cs=l(),p(Ze.$$.fragment),xs=l(),Ne=i("p"),Ne.textContent=rl,Es=l(),_e=i("ol"),_e.innerHTML=pl,Gs=l(),Ye=i("p"),Ye.innerHTML=hl,Rs=l(),f=i("div"),f.innerHTML=cl,$s=l(),y=i("p"),ca=J("The advantage of chunking the samples is that we don’t need the result of chunk"),Vs=new pa(!1),Hs=J(` to transcribe the subsequent
chunk`),Ws=new pa(!1),Fs=J(`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),ot=i("strong"),ot.textContent=dl,da=J(", so we can even do chunk"),Zs=new pa(!1),Ns=J(`
at the same time as chunk`),_s=new pa(!1),Ys=J("! This allows us to "),rt=i("em"),rt.textContent=ml,ma=J(` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),g=i("a"),g.textContent=Ml,Ma=J("."),Ls=l(),Le=i("p"),Le.innerHTML=ul,Qs=l(),Qe=i("p"),Qe.innerHTML=yl,qs=l(),p(qe.$$.fragment),As=l(),Ae=i("p"),Ae.innerHTML=wl,Xs=l(),p(Xe.$$.fragment),zs=l(),ze=i("p"),ze.textContent=Tl,Ps=l(),Pe=i("p"),Pe.innerHTML=Ul,Os=l(),Oe=i("p"),Oe.innerHTML=fl,Ds=l(),p(De.$$.fragment),Ks=l(),Ke=i("p"),Ke.innerHTML=gl,ea=l(),p(et.$$.fragment),ta=l(),tt=i("p"),tt.textContent=Jl,sa=l(),p(st.$$.fragment),aa=l(),at=i("p"),at.innerHTML=bl,la=l(),lt=i("p"),lt.innerHTML=jl,na=l(),nt=i("p"),nt.innerHTML=Il,ia=l(),p(it.$$.fragment),oa=l(),ht=i("p"),this.h()},l(e){const t=$l("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(s),mt=n(e),pt=o(e,"P",{}),ua(pt).forEach(s),Mt=n(e),h(j.$$.fragment,e),ut=n(e),h(I.$$.fragment,e),yt=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-qu6ugv"&&(k.innerHTML=wa),wt=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1lo7cg7"&&(v.textContent=Ta),Tt=n(e),S=o(e,"OL",{"data-svelte-h":!0}),r(S)!=="svelte-4r9go5"&&(S.innerHTML=Ua),Ut=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-7bh989"&&(B.innerHTML=fa),ft=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1y7wlps"&&(C.textContent=ga),gt=n(e),h(x.$$.fragment,e),Jt=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-6p3rx4"&&(E.innerHTML=Ja),bt=n(e),h(G.$$.fragment,e),jt=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1mvdyro"&&(R.innerHTML=ba),It=n(e),h($.$$.fragment,e),kt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1f14qa5"&&(V.textContent=ja),vt=n(e),h(H.$$.fragment,e),St=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1mvdyro"&&(W.innerHTML=Ia),Bt=n(e),h(F.$$.fragment,e),Ct=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-zwb92k"&&(Z.innerHTML=ka),xt=n(e),h(N.$$.fragment,e),Et=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-160y70r"&&(_.innerHTML=va),Gt=n(e),h(Y.$$.fragment,e),Rt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1mvdyro"&&(L.innerHTML=Sa),$t=n(e),h(Q.$$.fragment,e),Vt=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1n1tyml"&&(q.textContent=Ba),Ht=n(e),h(A.$$.fragment,e),Wt=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-fjdtrw"&&(X.innerHTML=Ca),Ft=n(e),z=o(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-11mc7qy"&&(z.innerHTML=xa),Zt=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-18hr596"&&(P.textContent=Ea),Nt=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-mwf7be"&&(O.innerHTML=Ga),_t=n(e),h(D.$$.fragment,e),Yt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-55oy83"&&(K.innerHTML=Ra),Lt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-969zyv"&&(ee.textContent=$a),Qt=n(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-osi73t"&&(te.innerHTML=Va),qt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1bn96on"&&(se.innerHTML=Ha),At=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-zyrdbw"&&(ae.innerHTML=Wa),Xt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-em8jox"&&(le.innerHTML=Fa),zt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1g5392c"&&(ne.textContent=Za),Pt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-5h4os6"&&(ie.innerHTML=Na),Ot=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-uy2cuy"&&(oe.innerHTML=_a),Dt=n(e),re=o(e,"TABLE",{"data-svelte-h":!0}),r(re)!=="svelte-leifmh"&&(re.innerHTML=Ya),Kt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-efpzbz"&&(pe.innerHTML=La),es=n(e),h(he.$$.fragment,e),ts=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1feq0tt"&&(ce.innerHTML=Qa),ss=n(e),h(de.$$.fragment,e),as=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1mvdyro"&&(me.innerHTML=qa),ls=n(e),h(Me.$$.fragment,e),ns=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-18db65j"&&(ue.textContent=Aa),is=n(e),h(ye.$$.fragment,e),os=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-mm1pes"&&(we.innerHTML=Xa),rs=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1ol57p5"&&(Te.innerHTML=za),ps=n(e),h(Ue.$$.fragment,e),hs=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1f9nh4o"&&(fe.textContent=Pa),cs=n(e),h(ge.$$.fragment,e),ds=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1mvdyro"&&(Je.innerHTML=Oa),ms=n(e),h(be.$$.fragment,e),Ms=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-75q7fw"&&(je.innerHTML=Da),us=n(e),h(Ie.$$.fragment,e),ys=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1mvdyro"&&(ke.innerHTML=Ka),ws=n(e),h(ve.$$.fragment,e),Ts=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-uzlabu"&&(Se.innerHTML=el),Us=n(e),h(Be.$$.fragment,e),fs=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1mvdyro"&&(Ce.innerHTML=tl),gs=n(e),h(xe.$$.fragment,e),Js=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-joibr"&&(Ee.textContent=sl),bs=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1aecqb1"&&(Ge.innerHTML=al),js=n(e),h(Re.$$.fragment,e),Is=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-ad6ien"&&($e.textContent=ll),ks=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1atykwj"&&(Ve.textContent=nl),vs=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-8fkb86"&&(He.textContent=il),Ss=n(e),h(We.$$.fragment,e),Bs=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1mvdyro"&&(Fe.innerHTML=ol),Cs=n(e),h(Ze.$$.fragment,e),xs=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-rlobar"&&(Ne.textContent=rl),Es=n(e),_e=o(e,"OL",{"data-svelte-h":!0}),r(_e)!=="svelte-xow7at"&&(_e.innerHTML=pl),Gs=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1kl6cah"&&(Ye.innerHTML=hl),Rs=n(e),f=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-dbmn5s"&&(f.innerHTML=cl),$s=n(e),y=o(e,"P",{});var w=ua(y);ca=b(w,"The advantage of chunking the samples is that we don’t need the result of chunk"),Vs=ha(w,!1),Hs=b(w,` to transcribe the subsequent
chunk`),Ws=ha(w,!1),Fs=b(w,`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),ot=o(w,"STRONG",{"data-svelte-h":!0}),r(ot)!=="svelte-1caf2ri"&&(ot.textContent=dl),da=b(w,", so we can even do chunk"),Zs=ha(w,!1),Ns=b(w,`
at the same time as chunk`),_s=ha(w,!1),Ys=b(w,"! This allows us to "),rt=o(w,"EM",{"data-svelte-h":!0}),r(rt)!=="svelte-1swb9sm"&&(rt.textContent=ml),ma=b(w,` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),g=o(w,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(g)!=="svelte-1d46t8h"&&(g.textContent=Ml),Ma=b(w,"."),w.forEach(s),Ls=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1bfrg8c"&&(Le.innerHTML=ul),Qs=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1ldveni"&&(Qe.innerHTML=yl),qs=n(e),h(qe.$$.fragment,e),As=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1mvdyro"&&(Ae.innerHTML=wl),Xs=n(e),h(Xe.$$.fragment,e),zs=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-wy7qyj"&&(ze.textContent=Tl),Ps=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1pdqzp1"&&(Pe.innerHTML=Ul),Os=n(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1kodbk1"&&(Oe.innerHTML=fl),Ds=n(e),h(De.$$.fragment,e),Ks=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1mvdyro"&&(Ke.innerHTML=gl),ea=n(e),h(et.$$.fragment,e),ta=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-7n3xc4"&&(tt.textContent=Jl),sa=n(e),h(st.$$.fragment,e),aa=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1t35nks"&&(at.innerHTML=bl),la=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1eiih7q"&&(lt.innerHTML=jl),na=n(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-a24nm6"&&(nt.innerHTML=Il),ia=n(e),h(it.$$.fragment,e),oa=n(e),ht=o(e,"P",{}),ua(ht).forEach(s),this.h()},h(){ct(U,"name","hf:doc:metadata"),ct(U,"content",Fl),ct(f,"class","flex justify-center"),Vs.a=Hs,Ws.a=Fs,Zs.a=Ns,_s.a=Ys,ct(g,"href","https://huggingface.co/blog/asr-chunking"),ct(g,"rel","nofollow")},m(e,t){T(document.head,U),a(e,mt,t),a(e,pt,t),a(e,Mt,t),c(j,e,t),a(e,ut,t),c(I,e,t),a(e,yt,t),a(e,k,t),a(e,wt,t),a(e,v,t),a(e,Tt,t),a(e,S,t),a(e,Ut,t),a(e,B,t),a(e,ft,t),a(e,C,t),a(e,gt,t),c(x,e,t),a(e,Jt,t),a(e,E,t),a(e,bt,t),c(G,e,t),a(e,jt,t),a(e,R,t),a(e,It,t),c($,e,t),a(e,kt,t),a(e,V,t),a(e,vt,t),c(H,e,t),a(e,St,t),a(e,W,t),a(e,Bt,t),c(F,e,t),a(e,Ct,t),a(e,Z,t),a(e,xt,t),c(N,e,t),a(e,Et,t),a(e,_,t),a(e,Gt,t),c(Y,e,t),a(e,Rt,t),a(e,L,t),a(e,$t,t),c(Q,e,t),a(e,Vt,t),a(e,q,t),a(e,Ht,t),c(A,e,t),a(e,Wt,t),a(e,X,t),a(e,Ft,t),a(e,z,t),a(e,Zt,t),a(e,P,t),a(e,Nt,t),a(e,O,t),a(e,_t,t),c(D,e,t),a(e,Yt,t),a(e,K,t),a(e,Lt,t),a(e,ee,t),a(e,Qt,t),a(e,te,t),a(e,qt,t),a(e,se,t),a(e,At,t),a(e,ae,t),a(e,Xt,t),a(e,le,t),a(e,zt,t),a(e,ne,t),a(e,Pt,t),a(e,ie,t),a(e,Ot,t),a(e,oe,t),a(e,Dt,t),a(e,re,t),a(e,Kt,t),a(e,pe,t),a(e,es,t),c(he,e,t),a(e,ts,t),a(e,ce,t),a(e,ss,t),c(de,e,t),a(e,as,t),a(e,me,t),a(e,ls,t),c(Me,e,t),a(e,ns,t),a(e,ue,t),a(e,is,t),c(ye,e,t),a(e,os,t),a(e,we,t),a(e,rs,t),a(e,Te,t),a(e,ps,t),c(Ue,e,t),a(e,hs,t),a(e,fe,t),a(e,cs,t),c(ge,e,t),a(e,ds,t),a(e,Je,t),a(e,ms,t),c(be,e,t),a(e,Ms,t),a(e,je,t),a(e,us,t),c(Ie,e,t),a(e,ys,t),a(e,ke,t),a(e,ws,t),c(ve,e,t),a(e,Ts,t),a(e,Se,t),a(e,Us,t),c(Be,e,t),a(e,fs,t),a(e,Ce,t),a(e,gs,t),c(xe,e,t),a(e,Js,t),a(e,Ee,t),a(e,bs,t),a(e,Ge,t),a(e,js,t),c(Re,e,t),a(e,Is,t),a(e,$e,t),a(e,ks,t),a(e,Ve,t),a(e,vs,t),a(e,He,t),a(e,Ss,t),c(We,e,t),a(e,Bs,t),a(e,Fe,t),a(e,Cs,t),c(Ze,e,t),a(e,xs,t),a(e,Ne,t),a(e,Es,t),a(e,_e,t),a(e,Gs,t),a(e,Ye,t),a(e,Rs,t),a(e,f,t),a(e,$s,t),a(e,y,t),T(y,ca),Vs.m(kl,y),T(y,Hs),Ws.m(vl,y),T(y,Fs),T(y,ot),T(y,da),Zs.m(Sl,y),T(y,Ns),_s.m(Bl,y),T(y,Ys),T(y,rt),T(y,ma),T(y,g),T(y,Ma),a(e,Ls,t),a(e,Le,t),a(e,Qs,t),a(e,Qe,t),a(e,qs,t),c(qe,e,t),a(e,As,t),a(e,Ae,t),a(e,Xs,t),c(Xe,e,t),a(e,zs,t),a(e,ze,t),a(e,Ps,t),a(e,Pe,t),a(e,Os,t),a(e,Oe,t),a(e,Ds,t),c(De,e,t),a(e,Ks,t),a(e,Ke,t),a(e,ea,t),c(et,e,t),a(e,ta,t),a(e,tt,t),a(e,sa,t),c(st,e,t),a(e,aa,t),a(e,at,t),a(e,la,t),a(e,lt,t),a(e,na,t),a(e,nt,t),a(e,ia,t),c(it,e,t),a(e,oa,t),a(e,ht,t),ra=!0},p:xl,i(e){ra||(d(j.$$.fragment,e),d(I.$$.fragment,e),d(x.$$.fragment,e),d(G.$$.fragment,e),d($.$$.fragment,e),d(H.$$.fragment,e),d(F.$$.fragment,e),d(N.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(A.$$.fragment,e),d(D.$$.fragment,e),d(he.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(ye.$$.fragment,e),d(Ue.$$.fragment,e),d(ge.$$.fragment,e),d(be.$$.fragment,e),d(Ie.$$.fragment,e),d(ve.$$.fragment,e),d(Be.$$.fragment,e),d(xe.$$.fragment,e),d(Re.$$.fragment,e),d(We.$$.fragment,e),d(Ze.$$.fragment,e),d(qe.$$.fragment,e),d(Xe.$$.fragment,e),d(De.$$.fragment,e),d(et.$$.fragment,e),d(st.$$.fragment,e),d(it.$$.fragment,e),ra=!0)},o(e){m(j.$$.fragment,e),m(I.$$.fragment,e),m(x.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(H.$$.fragment,e),m(F.$$.fragment,e),m(N.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(A.$$.fragment,e),m(D.$$.fragment,e),m(he.$$.fragment,e),m(de.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(Ue.$$.fragment,e),m(ge.$$.fragment,e),m(be.$$.fragment,e),m(Ie.$$.fragment,e),m(ve.$$.fragment,e),m(Be.$$.fragment,e),m(xe.$$.fragment,e),m(Re.$$.fragment,e),m(We.$$.fragment,e),m(Ze.$$.fragment,e),m(qe.$$.fragment,e),m(Xe.$$.fragment,e),m(De.$$.fragment,e),m(et.$$.fragment,e),m(st.$$.fragment,e),m(it.$$.fragment,e),ra=!1},d(e){e&&(s(mt),s(pt),s(Mt),s(ut),s(yt),s(k),s(wt),s(v),s(Tt),s(S),s(Ut),s(B),s(ft),s(C),s(gt),s(Jt),s(E),s(bt),s(jt),s(R),s(It),s(kt),s(V),s(vt),s(St),s(W),s(Bt),s(Ct),s(Z),s(xt),s(Et),s(_),s(Gt),s(Rt),s(L),s($t),s(Vt),s(q),s(Ht),s(Wt),s(X),s(Ft),s(z),s(Zt),s(P),s(Nt),s(O),s(_t),s(Yt),s(K),s(Lt),s(ee),s(Qt),s(te),s(qt),s(se),s(At),s(ae),s(Xt),s(le),s(zt),s(ne),s(Pt),s(ie),s(Ot),s(oe),s(Dt),s(re),s(Kt),s(pe),s(es),s(ts),s(ce),s(ss),s(as),s(me),s(ls),s(ns),s(ue),s(is),s(os),s(we),s(rs),s(Te),s(ps),s(hs),s(fe),s(cs),s(ds),s(Je),s(ms),s(Ms),s(je),s(us),s(ys),s(ke),s(ws),s(Ts),s(Se),s(Us),s(fs),s(Ce),s(gs),s(Js),s(Ee),s(bs),s(Ge),s(js),s(Is),s($e),s(ks),s(Ve),s(vs),s(He),s(Ss),s(Bs),s(Fe),s(Cs),s(xs),s(Ne),s(Es),s(_e),s(Gs),s(Ye),s(Rs),s(f),s($s),s(y),s(Ls),s(Le),s(Qs),s(Qe),s(qs),s(As),s(Ae),s(Xs),s(zs),s(ze),s(Ps),s(Pe),s(Os),s(Oe),s(Ds),s(Ks),s(Ke),s(ea),s(ta),s(tt),s(sa),s(aa),s(at),s(la),s(lt),s(na),s(nt),s(ia),s(oa),s(ht)),s(U),M(j,e),M(I,e),M(x,e),M(G,e),M($,e),M(H,e),M(F,e),M(N,e),M(Y,e),M(Q,e),M(A,e),M(D,e),M(he,e),M(de,e),M(Me,e),M(ye,e),M(Ue,e),M(ge,e),M(be,e),M(Ie,e),M(ve,e),M(Be,e),M(xe,e),M(Re,e),M(We,e),M(Ze,e),M(qe,e),M(Xe,e),M(De,e),M(et,e),M(st,e),M(it,e)}}}const Fl='{"title":"Pre-trained models for automatic speech recognition","local":"pre-trained-models-for-automatic-speech-recognition","sections":[{"title":"Probing CTC Models","local":"probing-ctc-models","sections":[],"depth":2},{"title":"Graduation to Seq2Seq","local":"graduation-to-seq2seq","sections":[],"depth":2},{"title":"Long-Form Transcription and Timestamps","local":"long-form-transcription-and-timestamps","sections":[],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function Zl(ya){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ql extends Gl{constructor(U){super(),Rl(this,U,Zl,Wl,Cl,{})}}export{Ql as component};
