import{s as Ss,n as bs,o as Qs}from"../chunks/scheduler.cd324960.js";import{S as Ds,i as Bs,e as n,s as a,c as T,h as Ns,a as y,d as t,b as e,f as fs,g as i,j as U,k as Es,l as ks,m as l,n as J,t as w,o as C,p}from"../chunks/index.d5c3adcc.js";import{C as vs,H as xs,E as Vs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.92ea4747.js";import{C as _}from"../chunks/CodeBlock.bef85339.js";function Zs(Js){let o,z,V,R,j,$,r,F,u,ws=`One of the biggest challenges faced with audio datasets is their sheer size. A single minute of uncompressed CD-quality audio (44.1kHz, 16-bit)
takes up  a bit more than 5 MB of storage. Typically, an audio dataset would contains hours of recordings.`,W,I,Cs=`In the previous sections we used a very small subset of MINDS-14 audio dataset, however, typical audio datasets are much larger.
For example, the <code>xs</code> (smallest) configuration of <a href="https://huggingface.co/datasets/speechcolab/gigaspeech" rel="nofollow">GigaSpeech from SpeechColab</a>
contains only 10 hours of training data, but takes over 13GB of storage space for download and preparation. So what
happens when we want to train on a larger split? The full <code>xl</code> configuration of the same dataset contains 10,000 hours of
training data, requiring over 1TB of storage space. For most of us, this well exceeds the specifications of a typical
hard drive disk. Do we need to fork out and buy additional storage? Or is there a way we can train on these datasets with no disk space constraints?`,Y,A,ps=`🤗 Datasets comes to the rescue by offering the <a href="https://huggingface.co/docs/datasets/stream" rel="nofollow">streaming mode</a>. Streaming allows us to load the data progressively as
we iterate over the dataset. Rather than downloading the whole dataset at once, we load the dataset one example at a time.
We iterate over the dataset, loading and preparing examples on the fly when they are needed. This way, we only ever
load the examples that we’re using, and not the ones that we’re not!
Once we’re done with an example sample, we continue iterating over the dataset and load the next one.`,G,h,js="Streaming mode has three primary advantages over downloading the entire dataset at once:",L,c,rs=`<li>Disk space: examples are loaded to memory one-by-one as we iterate over the dataset. Since the data is not downloaded
locally, there are no disk space requirements, so you can use datasets of arbitrary size.</li> <li>Download and processing time: audio datasets are large and need a significant amount of time to download and process.
With streaming, loading and processing is done on the fly, meaning you can start using the dataset as soon as the first
example is ready.</li> <li>Easy experimentation: you can experiment on a handful of examples to check that your script works without having to
download the entire dataset.</li>`,X,d,us=`There is one caveat to streaming mode. When downloading a full dataset without streaming, both the raw data and processed
data are saved locally to disk. If we want to re-use this dataset, we can directly load the processed data from disk,
skipping the download and processing steps.  Consequently, we only have to perform the downloading and processing
operations once, after which we can re-use the prepared data.`,O,m,Is=`With streaming mode, the data is not downloaded to disk. Thus, neither the downloaded nor pre-processed data are cached.
If we want to re-use the dataset, the streaming steps must be repeated, with the audio files loaded and processed on
the fly again. For this reason, it is advised to download datasets that you are likely to use multiple times.`,H,g,As=`How can you enable streaming mode? Easy! Just set <code>streaming=True</code> when you load your dataset. The rest will be taken
care for you:`,P,q,K,f,hs=`Just like we applied preprocessing steps to a downloaded subset of MINDS-14, you can do the same preprocessing with a
streaming dataset in the exactly the same manner.`,ss,E,cs=`The only difference is that you can no longer access individual samples using Python indexing (i.e. <code>gigaspeech[&quot;train&quot;][sample_idx]</code>).
Instead, you have to iterate over the dataset. Here’s how you can access an example when streaming a dataset:`,Ms,S,ts,b,ds="<strong>Output:</strong>",ls,Q,as,D,ms=`If you’d like to preview several examples from a large dataset, use the <code>take()</code> to get the first n elements. Let’s grab
the first two examples in the gigaspeech dataset:`,es,B,ns,N,gs="<strong>Output:</strong>",ys,k,Us,v,qs=`Streaming mode can take your research to the next level: not only are the biggest datasets accessible to you, but you
can easily evaluate systems over multiple datasets in one go without worrying about your disk space. Compared to
evaluating on a single dataset, multi-dataset evaluation gives a better metric for the generalisation abilities of a
speech recognition system (c.f. End-to-end Speech Benchmark (ESB)).`,os,x,Ts,Z,is;return j=new vs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),r=new xs({props:{title:"Streaming audio data",local:"streaming-audio-data",headingTag:"h1"}}),q=new _({props:{code:"Z2lnYXNwZWVjaCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzcGVlY2hjb2xhYiUyRmdpZ2FzcGVlY2glMjIlMkMlMjAlMjJ4cyUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUp",highlighted:'gigaspeech = load_dataset(<span class="hljs-string">&quot;speechcolab/gigaspeech&quot;</span>, <span class="hljs-string">&quot;xs&quot;</span>, streaming=<span class="hljs-literal">True</span>)',wrap:!1}}),S=new _({props:{code:"bmV4dChpdGVyKGdpZ2FzcGVlY2glNUIlMjJ0cmFpbiUyMiU1RCkp",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(gigaspeech[<span class="hljs-string">&quot;train&quot;</span>]))',wrap:!1}}),Q=new _({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc2VnbWVudF9pZCUyMiUzQSUyMCUyMllPVTAwMDAwMDAzMTVfUzAwMDA2NjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzcGVha2VyJTIyJTNBJTIwJTIyTiUyRkElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyQVMlMjBUSEVZJ1JFJTIwTEVBVklORyUyMCUzQ0NPTU1BJTNFJTIwQ0FOJTIwS0FTSCUyMFBVTEwlMjBaQUhSQSUyMEFTSURFJTIwUkVBTExZJTIwUVVJQ0tMWSUyMCUzQ1FVRVNUSU9OTUFSSyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMnhzX2NodW5rc18wMDAwJTJGWU9VMDAwMDAwMDMxNV9TMDAwMDY2MC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhcnJheSUyMiUzQSUyMGFycmF5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjAuMDAwNTE4OCUyQyUyMDAuMDAwODU0NDklMkMlMjAwLjAwMDEyMjA3JTJDJTIwLi4uJTJDJTIwMC4wMDEyNTEyMiUyQyUyMDAuMDAwNzYyOTQlMkMlMjAwLjAwMDM2NjIxJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmJlZ2luX3RpbWUlMjIlM0ElMjAyOTQxLjg5JTJDJTBBJTIwJTIwJTIwJTIwJTIyZW5kX3RpbWUlMjIlM0ElMjAyOTQ1LjA3JTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW9faWQlMjIlM0ElMjAlMjJZT1UwMDAwMDAwMzE1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJSZXR1cm4lMjB0byUyMFZhc3NlbGhlaW0lMjAlN0MlMjBDcml0aWNhbCUyMFJvbGUlM0ElMjBWT1glMjBNQUNISU5BJTIwJTdDJTIwRXBpc29kZSUyMDQzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cueW91dHViZS5jb20lMkZ3YXRjaCUzRnYlM0R6cjJuMWZMVmFzVSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnNvdXJjZSUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMDI0JTJDJTBBJTIwJTIwJTIwJTIwJTIyb3JpZ2luYWxfZnVsbF9wYXRoJTIyJTNBJTIwJTIyYXVkaW8lMkZ5b3V0dWJlJTJGUDAwMDQlMkZZT1UwMDAwMDAwMzE1Lm9wdXMlMjIlMkMlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315_S0000660&quot;</span>,
    <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;AS THEY&#x27;RE LEAVING &lt;COMMA&gt; CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY &lt;QUESTIONMARK&gt;&quot;</span>,
    <span class="hljs-string">&quot;audio&quot;</span>: {
        <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/YOU0000000315_S0000660.wav&quot;</span>,
        <span class="hljs-string">&quot;array&quot;</span>: <span class="hljs-built_in">array</span>(
            <span class="hljs-selector-attr">[0.0005188, 0.00085449, 0.00012207, ..., 0.00125122, 0.00076294, 0.00036621]</span>
        ),
        <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">2941.89</span>,
    <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">2945.07</span>,
    <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315&quot;</span>,
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43&quot;</span>,
    <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.youtube.com/watch?v=zr2n1fLVasU&quot;</span>,
    <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">24</span>,
    <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/youtube/P0004/YOU0000000315.opus&quot;</span>,
}`,wrap:!1}}),B=new _({props:{code:"Z2lnYXNwZWVjaF9oZWFkJTIwJTNEJTIwZ2lnYXNwZWVjaCU1QiUyMnRyYWluJTIyJTVELnRha2UoMiklMEFsaXN0KGdpZ2FzcGVlY2hfaGVhZCk=",highlighted:`gigaspeech_head = gigaspeech[<span class="hljs-string">&quot;train&quot;</span>].take(<span class="hljs-number">2</span>)
<span class="hljs-built_in">list</span>(gigaspeech_head)`,wrap:!1}}),k=new _({props:{code:"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",highlighted:`[
    {
        <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315_S0000660&quot;</span>,
        <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;AS THEY&#x27;RE LEAVING &lt;COMMA&gt; CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY &lt;QUESTIONMARK&gt;&quot;</span>,
        <span class="hljs-string">&quot;audio&quot;</span>: {
            <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/YOU0000000315_S0000660.wav&quot;</span>,
            <span class="hljs-string">&quot;array&quot;</span>: array(
                [
                    <span class="hljs-number">0.0005188</span>,
                    <span class="hljs-number">0.00085449</span>,
                    <span class="hljs-number">0.00012207</span>,
                    ...,
                    <span class="hljs-number">0.00125122</span>,
                    <span class="hljs-number">0.00076294</span>,
                    <span class="hljs-number">0.00036621</span>,
                ]
            ),
            <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
        },
        <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">2941.89</span>,
        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">2945.07</span>,
        <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;YOU0000000315&quot;</span>,
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43&quot;</span>,
        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.youtube.com/watch?v=zr2n1fLVasU&quot;</span>,
        <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">2</span>,
        <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">24</span>,
        <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/youtube/P0004/YOU0000000315.opus&quot;</span>,
    },
    {
        <span class="hljs-string">&quot;segment_id&quot;</span>: <span class="hljs-string">&quot;AUD0000001043_S0000775&quot;</span>,
        <span class="hljs-string">&quot;speaker&quot;</span>: <span class="hljs-string">&quot;N/A&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;SIX TOMATOES &lt;PERIOD&gt;&quot;</span>,
        <span class="hljs-string">&quot;audio&quot;</span>: {
            <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;xs_chunks_0000/AUD0000001043_S0000775.wav&quot;</span>,
            <span class="hljs-string">&quot;array&quot;</span>: array(
                [
                    <span class="hljs-number">1.43432617</span>e-03,
                    <span class="hljs-number">1.37329102</span>e-03,
                    <span class="hljs-number">1.31225586</span>e-03,
                    ...,
                    <span class="hljs-number">-6.10351562</span>e-05,
                    <span class="hljs-number">-1.22070312</span>e-04,
                    <span class="hljs-number">-1.83105469</span>e-04,
                ]
            ),
            <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
        },
        <span class="hljs-string">&quot;begin_time&quot;</span>: <span class="hljs-number">3673.96</span>,
        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-number">3675.26</span>,
        <span class="hljs-string">&quot;audio_id&quot;</span>: <span class="hljs-string">&quot;AUD0000001043&quot;</span>,
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Asteroid of Fear&quot;</span>,
        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http//www.archive.org/download/asteroid_of_fear_1012_librivox/asteroid_of_fear_1012_librivox_64kb_mp3.zip&quot;</span>,
        <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-number">0</span>,
        <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-number">28</span>,
        <span class="hljs-string">&quot;original_full_path&quot;</span>: <span class="hljs-string">&quot;audio/audiobook/P0011/AUD0000001043.opus&quot;</span>,
    },
]`,wrap:!1}}),x=new Vs({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/streaming.mdx"}}),{c(){o=n("meta"),z=a(),V=n("p"),R=a(),T(j.$$.fragment),$=a(),T(r.$$.fragment),F=a(),u=n("p"),u.textContent=ws,W=a(),I=n("p"),I.innerHTML=Cs,Y=a(),A=n("p"),A.innerHTML=ps,G=a(),h=n("p"),h.textContent=js,L=a(),c=n("ul"),c.innerHTML=rs,X=a(),d=n("p"),d.textContent=us,O=a(),m=n("p"),m.textContent=Is,H=a(),g=n("p"),g.innerHTML=As,P=a(),T(q.$$.fragment),K=a(),f=n("p"),f.textContent=hs,ss=a(),E=n("p"),E.innerHTML=cs,Ms=a(),T(S.$$.fragment),ts=a(),b=n("p"),b.innerHTML=ds,ls=a(),T(Q.$$.fragment),as=a(),D=n("p"),D.innerHTML=ms,es=a(),T(B.$$.fragment),ns=a(),N=n("p"),N.innerHTML=gs,ys=a(),T(k.$$.fragment),Us=a(),v=n("p"),v.textContent=qs,os=a(),T(x.$$.fragment),Ts=a(),Z=n("p"),this.h()},l(s){const M=Ns("svelte-u9bgzb",document.head);o=y(M,"META",{name:!0,content:!0}),M.forEach(t),z=e(s),V=y(s,"P",{}),fs(V).forEach(t),R=e(s),i(j.$$.fragment,s),$=e(s),i(r.$$.fragment,s),F=e(s),u=y(s,"P",{"data-svelte-h":!0}),U(u)!=="svelte-n8v3tf"&&(u.textContent=ws),W=e(s),I=y(s,"P",{"data-svelte-h":!0}),U(I)!=="svelte-nayksx"&&(I.innerHTML=Cs),Y=e(s),A=y(s,"P",{"data-svelte-h":!0}),U(A)!=="svelte-1cmn14y"&&(A.innerHTML=ps),G=e(s),h=y(s,"P",{"data-svelte-h":!0}),U(h)!=="svelte-1doba0z"&&(h.textContent=js),L=e(s),c=y(s,"UL",{"data-svelte-h":!0}),U(c)!=="svelte-dy12ia"&&(c.innerHTML=rs),X=e(s),d=y(s,"P",{"data-svelte-h":!0}),U(d)!=="svelte-dhhyuw"&&(d.textContent=us),O=e(s),m=y(s,"P",{"data-svelte-h":!0}),U(m)!=="svelte-1b0tiu9"&&(m.textContent=Is),H=e(s),g=y(s,"P",{"data-svelte-h":!0}),U(g)!=="svelte-16vl0hj"&&(g.innerHTML=As),P=e(s),i(q.$$.fragment,s),K=e(s),f=y(s,"P",{"data-svelte-h":!0}),U(f)!=="svelte-182p0qe"&&(f.textContent=hs),ss=e(s),E=y(s,"P",{"data-svelte-h":!0}),U(E)!=="svelte-1e6b0ye"&&(E.innerHTML=cs),Ms=e(s),i(S.$$.fragment,s),ts=e(s),b=y(s,"P",{"data-svelte-h":!0}),U(b)!=="svelte-1mvdyro"&&(b.innerHTML=ds),ls=e(s),i(Q.$$.fragment,s),as=e(s),D=y(s,"P",{"data-svelte-h":!0}),U(D)!=="svelte-k3iau9"&&(D.innerHTML=ms),es=e(s),i(B.$$.fragment,s),ns=e(s),N=y(s,"P",{"data-svelte-h":!0}),U(N)!=="svelte-1mvdyro"&&(N.innerHTML=gs),ys=e(s),i(k.$$.fragment,s),Us=e(s),v=y(s,"P",{"data-svelte-h":!0}),U(v)!=="svelte-1jjur40"&&(v.textContent=qs),os=e(s),i(x.$$.fragment,s),Ts=e(s),Z=y(s,"P",{}),fs(Z).forEach(t),this.h()},h(){Es(o,"name","hf:doc:metadata"),Es(o,"content",_s)},m(s,M){ks(document.head,o),l(s,z,M),l(s,V,M),l(s,R,M),J(j,s,M),l(s,$,M),J(r,s,M),l(s,F,M),l(s,u,M),l(s,W,M),l(s,I,M),l(s,Y,M),l(s,A,M),l(s,G,M),l(s,h,M),l(s,L,M),l(s,c,M),l(s,X,M),l(s,d,M),l(s,O,M),l(s,m,M),l(s,H,M),l(s,g,M),l(s,P,M),J(q,s,M),l(s,K,M),l(s,f,M),l(s,ss,M),l(s,E,M),l(s,Ms,M),J(S,s,M),l(s,ts,M),l(s,b,M),l(s,ls,M),J(Q,s,M),l(s,as,M),l(s,D,M),l(s,es,M),J(B,s,M),l(s,ns,M),l(s,N,M),l(s,ys,M),J(k,s,M),l(s,Us,M),l(s,v,M),l(s,os,M),J(x,s,M),l(s,Ts,M),l(s,Z,M),is=!0},p:bs,i(s){is||(w(j.$$.fragment,s),w(r.$$.fragment,s),w(q.$$.fragment,s),w(S.$$.fragment,s),w(Q.$$.fragment,s),w(B.$$.fragment,s),w(k.$$.fragment,s),w(x.$$.fragment,s),is=!0)},o(s){C(j.$$.fragment,s),C(r.$$.fragment,s),C(q.$$.fragment,s),C(S.$$.fragment,s),C(Q.$$.fragment,s),C(B.$$.fragment,s),C(k.$$.fragment,s),C(x.$$.fragment,s),is=!1},d(s){s&&(t(z),t(V),t(R),t($),t(F),t(u),t(W),t(I),t(Y),t(A),t(G),t(h),t(L),t(c),t(X),t(d),t(O),t(m),t(H),t(g),t(P),t(K),t(f),t(ss),t(E),t(Ms),t(ts),t(b),t(ls),t(as),t(D),t(es),t(ns),t(N),t(ys),t(Us),t(v),t(os),t(Ts),t(Z)),t(o),p(j,s),p(r,s),p(q,s),p(S,s),p(Q,s),p(B,s),p(k,s),p(x,s)}}}const _s='{"title":"Streaming audio data","local":"streaming-audio-data","sections":[],"depth":1}';function zs(Js){return Qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends Ds{constructor(o){super(),Bs(this,o,zs,Zs,Ss,{})}}export{Ys as component};
