import{s as el,f as tl,n as al,o as ol}from"../chunks/scheduler.a2b4ca8e.js";import{S as nl,i as ll,g as r,s as n,r as m,A as rl,h as s,f as a,c as l,j as b,u as c,x as d,k as M,l as sl,y as i,a as o,v as h,d as u,t as f,w as g}from"../chunks/index.f6e1d51d.js";import{D as v}from"../chunks/Docstring.e7c4afb2.js";import{C as Nt}from"../chunks/CodeBlock.9607aa3b.js";import{H as y,E as il}from"../chunks/EditOnGithub.d27dc01b.js";function dl(Ro){let j,Ft,kt,qt,E,Bt,R,Zo='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',Lt,Z,Wo="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",Et,W,Rt,H,Ho="Fine-tuning a language model via DPO consists of two steps and is easier than PPO:",Zt,Q,Qo="<li><strong>Data collection</strong>: Gather a preference dataset with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>",Wt,z,zo='DPO-compatible datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>.',Ht,G,Go='This process is illustrated in the sketch below (from <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">figure 1 of the original paper</a>):',Qt,I,So,zt,S,Xo='Read more about DPO algorithm in the <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">original paper</a>.',Gt,X,St,Y,Yo='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',Xt,$,Vo='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',Yt,V,Ko="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",Vt,K,en="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Kt,ee,tn="for example:",ea,te,ta,ae,an="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",aa,oe,oa,ne,on="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",na,le,la,re,nn="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",ra,se,sa,ie,ln="After this one can then call:",ia,de,da,pe,rn="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",pa,me,ma,ce,sn="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",ca,he,dn='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',ha,ue,pn='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',ua,fe,mn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Pass the <code>label_smoothing</code> argument to the trainer to use it (default is 0).',fa,ge,cn='The <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> authors propose an unbiased estimate of the DPO loss that is robust to preference noise in the data. Like in cDPO, assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5). Use <code>loss_type=&quot;robust&quot;</code> to the trainer to use it.',ga,_e,hn='The <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">KTO</a> authors directly maximize the utility of LLM generations instead of the log-likelihood of preferences. To use preference data with KTO, we recommend breaking up the n preferences into 2n examples and using <a href="kto_trainer"><code>KTOTrainer</code></a> (i.e., treating the data like an unpaired feedback dataset). Although it is possible to pass in <code>loss_type=&quot;kto_pair&quot;</code> into DPOTrainer, this is a highly simplified version of KTO that we <em>do not recommend</em> in most cases. Please use <a href="kto_trainer"><code>KTOTrainer</code></a> when possible.',_a,Me,un='The <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;bco_pair&quot;</code> argument.',Ma,be,fn='The <a href="https://arxiv.org/abs/2405.00675" rel="nofollow">SPPO</a> authors claim that SPPO is capable of solving the Nash equilibrium iteratively by pushing the chosen rewards to be as large as 1/2 and the rejected rewards to be as small as -1/2 and can alleviate data sparsity issues. The implementation using loss_type=“sppo_hard” approximates this algorithm by employing hard label probabilities, assigning 1 to the winner and 0 to the loser.',ba,ve,gn='The <a href="https://arxiv.org/abs/2402.05369" rel="nofollow">NCA</a> authors shows that NCA optimizes the absolute likelihood for each response rather than the relative likelihood.',va,ye,_n='The <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper suggests syncing the reference model weights after every <code>ref_model_sync_steps</code> steps of SGD with weight <code>ref_model_mixup_alpha</code> during DPO training. To toggle this callback use the <code>sync_ref_model</code> flag in the <code>DPOConfig</code>.',ya,Te,Mn='The <a href="https://arxiv.org/abs/2404.19733" rel="nofollow">RPO</a> paper implements an iterative preference tuning algorithm using a loss related to the RPO loss in this <a href="https://arxiv.org/abs/2405.16436" rel="nofollow">paper</a> that essentially consists of the SFT loss on the chosen preferences together with a weighted DPO loss. To use this loss set the <code>rpo_alpha</code> in the <code>DPOConfig</code> to an appropriate value.',Ta,we,bn='The <a href="https://arxiv.org/abs/2406.05882" rel="nofollow">AOT</a> authors propose to use Distributional Preference Alignment Via Optimal Transport. Traditionally, the alignment algorithms use paired preferences at a sample level, which does not ensure alignment on the distributional level. AOT, on the other hand, can align LLMs on paired or unpaired preference data by making the reward distribution of the positive samples stochastically dominant in the first order on the distribution of negative samples. Specifically, <code>loss_type=&quot;aot&quot;</code> is appropriate for  paired datasets, where each prompt has both chosen and rejected responses; <code>loss_type=&quot;aot_pair&quot;</code> is for unpaired datasets. Note that <code>loss_type=&quot;aot_pair&quot;</code> is similar in spirit to <code>loss_type=&quot;kto_pair&quot;</code> that applies unpaired alignment methodology on paired dataset. In a nutshell, <code>loss_type=&quot;aot&quot;</code> ensures that the log-likelihood ratio of chosen to rejected of the aligned model has higher quantiles than that ratio for the reference model. <code>loss_type=&quot;aot_pair&quot;</code> ensures that the chosen reward is higher on all quantiles than the rejected reward. Note that in both cases quantiles are obtained via sorting. To fully leverage the advantages of the AOT algorithm, it is important to maximize the per-GPU batch size.',wa,Je,Ja,Ue,vn="While training and evaluating we record the following reward metrics:",Ua,Ce,yn="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Ca,je,ja,xe,Tn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',xa,Ie,wn="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",Ia,$e,Jn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',$a,Oe,Oa,Pe,Un='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Pa,De,Da,ke,Cn="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",ka,Ae,jn="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>model_ref</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",Aa,Ne,Na,Fe,xn='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',Fa,qe,In="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",qa,Be,Ba,Le,$n="To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in DPOTrainer.",La,Ee,On="For example:",Ea,Re,Ra,Ze,Za,p,We,lo,it,Pn="Initialize DPOTrainer.",ro,O,He,so,dt,Dn=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,io,P,Qe,po,pt,kn="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",mo,w,ze,co,mt,An="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",ho,ct,Nn="We do this to avoid doing two forward passes, because it’s faster for FSDP.",uo,D,Ge,fo,ht,Fn="Concatenate the chosen and rejected inputs into a single tensor.",go,k,Se,_o,ut,qn="Compute the DPO loss for a batch of policy and reference model log probabilities.",Mo,J,Xe,bo,ft,Bn=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,vo,gt,Ln="Works both with or without labels.",yo,A,Ye,To,_t,En="Compute the log probabilities of the given labels under the given logits.",wo,N,Ve,Jo,Mt,Rn="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Uo,F,Ke,Co,bt,Zn="Generate samples from the model and reference model for the given batch of inputs.",jo,U,et,xo,vt,Wn="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Io,yt,Hn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",$o,C,tt,Oo,Tt,Qn="Returns the training <code>~torch.utils.data.DataLoader</code>.",Po,wt,zn="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Do,q,at,ko,Jt,Gn="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ao,B,ot,No,Ut,Sn="Context manager for handling null reference model (that is, peft adapter manipulation).",Fo,T,nt,qo,Ct,Xn="Tokenize a single row from a DPO specific dataset.",Bo,jt,Yn=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Lo,xt,Vn=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,Wa,lt,Ha,x,rt,Eo,It,Kn="Initialize DPOConfig.",Qa,st,za,At,Ga;return E=new y({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),W=new y({props:{title:"How DPO works",local:"how-dpo-works",headingTag:"h2"}}),X=new y({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),te=new Nt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),oe=new y({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),le=new y({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),se=new Nt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQWRwb190cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args = DPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)
dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),de=new Nt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),me=new y({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),Je=new y({props:{title:"Logging",local:"logging",headingTag:"h2"}}),je=new y({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Oe=new Nt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = DPOConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    beta=<span class="hljs-number">0.1</span>,
)

dpo_trainer = DPOTrainer(
    model,
    ref_model=<span class="hljs-literal">None</span>,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),De=new y({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Ne=new y({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),Be=new y({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),Re=new Nt({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),Ze=new y({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),We=new v({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L68"}}),He=new v({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L678"}}),Qe=new v({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L891"}}),ze=new v({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L1151"}}),Ge=new v({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L917",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Se=new v({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L979",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Xe=new v({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L1404"}}),Ye=new v({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L1118",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A Tuple of two tensor of shape ((batch_size,), (batch_size,)) containing the sum of log probabilities of the given labels under the given logits in the first tensor and the number of non-masked tokens in the second tensor.</p>
`}}),Ve=new v({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L1218"}}),Ke=new v({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L1314"}}),et=new v({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L626"}}),tt=new v({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L583"}}),at=new v({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L1454"}}),ot=new v({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L879"}}),nt=new v({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_trainer.py#L728"}}),lt=new y({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),rt=new v({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"},{name:"sync_ref_model",val:": bool = False"},{name:"ref_model_mixup_alpha",val:": float = 0.9"},{name:"ref_model_sync_steps",val:": int = 64"},{name:"rpo_alpha",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report and <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> paper that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper,
<code>&quot;kto_pair&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>, <code>&quot;bco_pair&quot;</code> from <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> paper or <code>&quot;robust&quot;</code> from <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> paper,
&#x201C;aot&#x201D; and &#x201C;aot_pair&#x201D; from alignment via optimal transport`,name:"loss_type"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code> defaults to <code>False</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"},{anchor:"trl.DPOConfig.sync_ref_model",description:`<strong>sync_ref_model</strong> (&#x2018;bool&#x2019;, defaults to <code>False</code>) &#x2014;
The flag for syncing reference model during training from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"sync_ref_model"},{anchor:"trl.DPOConfig.ref_model_mixup_alpha",description:`<strong>ref_model_mixup_alpha</strong> (&#x2018;float&#x2019;, defaults to 1.0) &#x2014;
The alpha parameter from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_mixup_alpha"},{anchor:"trl.DPOConfig.ref_model_sync_steps",description:`<strong>ref_model_sync_steps</strong> (&#x2018;int&#x2019;, defaults to 2) &#x2014;
The tau parameter from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_sync_steps"},{anchor:"trl.DPOConfig.rpo_alpha",description:`<strong>rpo_alpha</strong> (&#x2018;float&#x2019;, defaults to <code>None</code>) &#x2014;
The alpha parameter from the <a href="https://arxiv.org/pdf/2404.19733" rel="nofollow">RPO</a> paper. If None, no weighting is applied and the loss is the same as the DPO loss.`,name:"rpo_alpha"}],source:"https://github.com/huggingface/trl/blob/vr_1748/trl/trainer/dpo_config.py#L20"}}),st=new il({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){j=r("meta"),Ft=n(),kt=r("p"),qt=n(),m(E.$$.fragment),Bt=n(),R=r("p"),R.innerHTML=Zo,Lt=n(),Z=r("p"),Z.textContent=Wo,Et=n(),m(W.$$.fragment),Rt=n(),H=r("p"),H.textContent=Ho,Zt=n(),Q=r("ol"),Q.innerHTML=Qo,Wt=n(),z=r("p"),z.innerHTML=zo,Ht=n(),G=r("p"),G.innerHTML=Go,Qt=n(),I=r("img"),zt=n(),S=r("p"),S.innerHTML=Xo,Gt=n(),m(X.$$.fragment),St=n(),Y=r("p"),Y.innerHTML=Yo,Xt=n(),$=r("div"),$.innerHTML=Vo,Yt=n(),V=r("p"),V.innerHTML=Ko,Vt=n(),K=r("ul"),K.innerHTML=en,Kt=n(),ee=r("p"),ee.textContent=tn,ea=n(),m(te.$$.fragment),ta=n(),ae=r("p"),ae.innerHTML=an,aa=n(),m(oe.$$.fragment),oa=n(),ne=r("p"),ne.innerHTML=on,na=n(),m(le.$$.fragment),la=n(),re=r("p"),re.innerHTML=nn,ra=n(),m(se.$$.fragment),sa=n(),ie=r("p"),ie.textContent=ln,ia=n(),m(de.$$.fragment),da=n(),pe=r("p"),pe.innerHTML=rn,pa=n(),m(me.$$.fragment),ma=n(),ce=r("p"),ce.innerHTML=sn,ca=n(),he=r("p"),he.innerHTML=dn,ha=n(),ue=r("p"),ue.innerHTML=pn,ua=n(),fe=r("p"),fe.innerHTML=mn,fa=n(),ge=r("p"),ge.innerHTML=cn,ga=n(),_e=r("p"),_e.innerHTML=hn,_a=n(),Me=r("p"),Me.innerHTML=un,Ma=n(),be=r("p"),be.innerHTML=fn,ba=n(),ve=r("p"),ve.innerHTML=gn,va=n(),ye=r("p"),ye.innerHTML=_n,ya=n(),Te=r("p"),Te.innerHTML=Mn,Ta=n(),we=r("p"),we.innerHTML=bn,wa=n(),m(Je.$$.fragment),Ja=n(),Ue=r("p"),Ue.textContent=vn,Ua=n(),Ce=r("ul"),Ce.innerHTML=yn,Ca=n(),m(je.$$.fragment),ja=n(),xe=r("p"),xe.innerHTML=Tn,xa=n(),Ie=r("table"),Ie.innerHTML=wn,Ia=n(),$e=r("p"),$e.innerHTML=Jn,$a=n(),m(Oe.$$.fragment),Oa=n(),Pe=r("p"),Pe.innerHTML=Un,Pa=n(),m(De.$$.fragment),Da=n(),ke=r("p"),ke.textContent=Cn,ka=n(),Ae=r("ol"),Ae.innerHTML=jn,Aa=n(),m(Ne.$$.fragment),Na=n(),Fe=r("p"),Fe.innerHTML=xn,Fa=n(),qe=r("p"),qe.textContent=In,qa=n(),m(Be.$$.fragment),Ba=n(),Le=r("p"),Le.textContent=$n,La=n(),Ee=r("p"),Ee.textContent=On,Ea=n(),m(Re.$$.fragment),Ra=n(),m(Ze.$$.fragment),Za=n(),p=r("div"),m(We.$$.fragment),lo=n(),it=r("p"),it.textContent=Pn,ro=n(),O=r("div"),m(He.$$.fragment),so=n(),dt=r("p"),dt.innerHTML=Dn,io=n(),P=r("div"),m(Qe.$$.fragment),po=n(),pt=r("p"),pt.textContent=kn,mo=n(),w=r("div"),m(ze.$$.fragment),co=n(),mt=r("p"),mt.textContent=An,ho=n(),ct=r("p"),ct.textContent=Nn,uo=n(),D=r("div"),m(Ge.$$.fragment),fo=n(),ht=r("p"),ht.textContent=Fn,go=n(),k=r("div"),m(Se.$$.fragment),_o=n(),ut=r("p"),ut.textContent=qn,Mo=n(),J=r("div"),m(Xe.$$.fragment),bo=n(),ft=r("p"),ft.innerHTML=Bn,vo=n(),gt=r("p"),gt.textContent=Ln,yo=n(),A=r("div"),m(Ye.$$.fragment),To=n(),_t=r("p"),_t.textContent=En,wo=n(),N=r("div"),m(Ve.$$.fragment),Jo=n(),Mt=r("p"),Mt.textContent=Rn,Uo=n(),F=r("div"),m(Ke.$$.fragment),Co=n(),bt=r("p"),bt.textContent=Zn,jo=n(),U=r("div"),m(et.$$.fragment),xo=n(),vt=r("p"),vt.innerHTML=Wn,Io=n(),yt=r("p"),yt.innerHTML=Hn,$o=n(),C=r("div"),m(tt.$$.fragment),Oo=n(),Tt=r("p"),Tt.innerHTML=Qn,Po=n(),wt=r("p"),wt.innerHTML=zn,Do=n(),q=r("div"),m(at.$$.fragment),ko=n(),Jt=r("p"),Jt.innerHTML=Gn,Ao=n(),B=r("div"),m(ot.$$.fragment),No=n(),Ut=r("p"),Ut.textContent=Sn,Fo=n(),T=r("div"),m(nt.$$.fragment),qo=n(),Ct=r("p"),Ct.textContent=Xn,Bo=n(),jt=r("p"),jt.textContent=Yn,Lo=n(),xt=r("p"),xt.textContent=Vn,Wa=n(),m(lt.$$.fragment),Ha=n(),x=r("div"),m(rt.$$.fragment),Eo=n(),It=r("p"),It.textContent=Kn,Qa=n(),m(st.$$.fragment),za=n(),At=r("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);j=s(t,"META",{name:!0,content:!0}),t.forEach(a),Ft=l(e),kt=s(e,"P",{}),b(kt).forEach(a),qt=l(e),c(E.$$.fragment,e),Bt=l(e),R=s(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-5p7twb"&&(R.innerHTML=Zo),Lt=l(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-xh4sh7"&&(Z.textContent=Wo),Et=l(e),c(W.$$.fragment,e),Rt=l(e),H=s(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-e9zjgv"&&(H.textContent=Ho),Zt=l(e),Q=s(e,"OL",{"data-svelte-h":!0}),d(Q)!=="svelte-1fzn07o"&&(Q.innerHTML=Qo),Wt=l(e),z=s(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-11tyi92"&&(z.innerHTML=zo),Ht=l(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-lms3te"&&(G.innerHTML=Go),Qt=l(e),I=s(e,"IMG",{width:!0,alt:!0,src:!0}),zt=l(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1yw8azb"&&(S.innerHTML=Xo),Gt=l(e),c(X.$$.fragment,e),St=l(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-dcawbe"&&(Y.innerHTML=Yo),Xt=l(e),$=s(e,"DIV",{style:!0,"data-svelte-h":!0}),d($)!=="svelte-z15c7z"&&($.innerHTML=Vo),Yt=l(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-cb9b0v"&&(V.innerHTML=Ko),Vt=l(e),K=s(e,"UL",{"data-svelte-h":!0}),d(K)!=="svelte-17vxuta"&&(K.innerHTML=en),Kt=l(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1gl9mvz"&&(ee.textContent=tn),ea=l(e),c(te.$$.fragment,e),ta=l(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1a8oxjk"&&(ae.innerHTML=an),aa=l(e),c(oe.$$.fragment,e),oa=l(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-174yw9s"&&(ne.innerHTML=on),na=l(e),c(le.$$.fragment,e),la=l(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1wn9xrv"&&(re.innerHTML=nn),ra=l(e),c(se.$$.fragment,e),sa=l(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1lg6q1l"&&(ie.textContent=ln),ia=l(e),c(de.$$.fragment,e),da=l(e),pe=s(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1ac5mum"&&(pe.innerHTML=rn),pa=l(e),c(me.$$.fragment,e),ma=l(e),ce=s(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-7nvktz"&&(ce.innerHTML=sn),ca=l(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-bl9wh7"&&(he.innerHTML=dn),ha=l(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1quvcuu"&&(ue.innerHTML=pn),ua=l(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-kuakol"&&(fe.innerHTML=mn),fa=l(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-17kcyul"&&(ge.innerHTML=cn),ga=l(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-m3f292"&&(_e.innerHTML=hn),_a=l(e),Me=s(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-nj941x"&&(Me.innerHTML=un),Ma=l(e),be=s(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1nc29ji"&&(be.innerHTML=fn),ba=l(e),ve=s(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-f69fd8"&&(ve.innerHTML=gn),va=l(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1jgk22r"&&(ye.innerHTML=_n),ya=l(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1r1f45a"&&(Te.innerHTML=Mn),Ta=l(e),we=s(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1lknj7x"&&(we.innerHTML=bn),wa=l(e),c(Je.$$.fragment,e),Ja=l(e),Ue=s(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-132s7j9"&&(Ue.textContent=vn),Ua=l(e),Ce=s(e,"UL",{"data-svelte-h":!0}),d(Ce)!=="svelte-1oji3mm"&&(Ce.innerHTML=yn),Ca=l(e),c(je.$$.fragment,e),ja=l(e),xe=s(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-2145zu"&&(xe.innerHTML=Tn),xa=l(e),Ie=s(e,"TABLE",{"data-svelte-h":!0}),d(Ie)!=="svelte-435mua"&&(Ie.innerHTML=wn),Ia=l(e),$e=s(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1p74c9x"&&($e.innerHTML=Jn),$a=l(e),c(Oe.$$.fragment,e),Oa=l(e),Pe=s(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1o18rwj"&&(Pe.innerHTML=Un),Pa=l(e),c(De.$$.fragment,e),Da=l(e),ke=s(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-4infz6"&&(ke.textContent=Cn),ka=l(e),Ae=s(e,"OL",{"data-svelte-h":!0}),d(Ae)!=="svelte-1p7od7"&&(Ae.innerHTML=jn),Aa=l(e),c(Ne.$$.fragment,e),Na=l(e),Fe=s(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-rqj7uy"&&(Fe.innerHTML=xn),Fa=l(e),qe=s(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1xhv3st"&&(qe.textContent=In),qa=l(e),c(Be.$$.fragment,e),Ba=l(e),Le=s(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-a0kxee"&&(Le.textContent=$n),La=l(e),Ee=s(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1gkqha7"&&(Ee.textContent=On),Ea=l(e),c(Re.$$.fragment,e),Ra=l(e),c(Ze.$$.fragment,e),Za=l(e),p=s(e,"DIV",{class:!0});var _=b(p);c(We.$$.fragment,_),lo=l(_),it=s(_,"P",{"data-svelte-h":!0}),d(it)!=="svelte-n6cc8y"&&(it.textContent=Pn),ro=l(_),O=s(_,"DIV",{class:!0});var Sa=b(O);c(He.$$.fragment,Sa),so=l(Sa),dt=s(Sa,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-mcz8nm"&&(dt.innerHTML=Dn),Sa.forEach(a),io=l(_),P=s(_,"DIV",{class:!0});var Xa=b(P);c(Qe.$$.fragment,Xa),po=l(Xa),pt=s(Xa,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-10t1062"&&(pt.textContent=kn),Xa.forEach(a),mo=l(_),w=s(_,"DIV",{class:!0});var $t=b(w);c(ze.$$.fragment,$t),co=l($t),mt=s($t,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-16i1nac"&&(mt.textContent=An),ho=l($t),ct=s($t,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-tgti68"&&(ct.textContent=Nn),$t.forEach(a),uo=l(_),D=s(_,"DIV",{class:!0});var Ya=b(D);c(Ge.$$.fragment,Ya),fo=l(Ya),ht=s(Ya,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1cvsgkk"&&(ht.textContent=Fn),Ya.forEach(a),go=l(_),k=s(_,"DIV",{class:!0});var Va=b(k);c(Se.$$.fragment,Va),_o=l(Va),ut=s(Va,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-ymgxq7"&&(ut.textContent=qn),Va.forEach(a),Mo=l(_),J=s(_,"DIV",{class:!0});var Ot=b(J);c(Xe.$$.fragment,Ot),bo=l(Ot),ft=s(Ot,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-8qlty5"&&(ft.innerHTML=Bn),vo=l(Ot),gt=s(Ot,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1tyo99t"&&(gt.textContent=Ln),Ot.forEach(a),yo=l(_),A=s(_,"DIV",{class:!0});var Ka=b(A);c(Ye.$$.fragment,Ka),To=l(Ka),_t=s(Ka,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-4nmimv"&&(_t.textContent=En),Ka.forEach(a),wo=l(_),N=s(_,"DIV",{class:!0});var eo=b(N);c(Ve.$$.fragment,eo),Jo=l(eo),Mt=s(eo,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-11q8u7l"&&(Mt.textContent=Rn),eo.forEach(a),Uo=l(_),F=s(_,"DIV",{class:!0});var to=b(F);c(Ke.$$.fragment,to),Co=l(to),bt=s(to,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-18uwvbi"&&(bt.textContent=Zn),to.forEach(a),jo=l(_),U=s(_,"DIV",{class:!0});var Pt=b(U);c(et.$$.fragment,Pt),xo=l(Pt),vt=s(Pt,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-xesobz"&&(vt.innerHTML=Wn),Io=l(Pt),yt=s(Pt,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-qg43tm"&&(yt.innerHTML=Hn),Pt.forEach(a),$o=l(_),C=s(_,"DIV",{class:!0});var Dt=b(C);c(tt.$$.fragment,Dt),Oo=l(Dt),Tt=s(Dt,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-dkae9b"&&(Tt.innerHTML=Qn),Po=l(Dt),wt=s(Dt,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-hmd5cw"&&(wt.innerHTML=zn),Dt.forEach(a),Do=l(_),q=s(_,"DIV",{class:!0});var ao=b(q);c(at.$$.fragment,ao),ko=l(ao),Jt=s(ao,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-nqksfz"&&(Jt.innerHTML=Gn),ao.forEach(a),Ao=l(_),B=s(_,"DIV",{class:!0});var oo=b(B);c(ot.$$.fragment,oo),No=l(oo),Ut=s(oo,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-17kjsy4"&&(Ut.textContent=Sn),oo.forEach(a),Fo=l(_),T=s(_,"DIV",{class:!0});var L=b(T);c(nt.$$.fragment,L),qo=l(L),Ct=s(L,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-1861yti"&&(Ct.textContent=Xn),Bo=l(L),jt=s(L,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1mn1gnw"&&(jt.textContent=Yn),Lo=l(L),xt=s(L,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-1xvpyih"&&(xt.textContent=Vn),L.forEach(a),_.forEach(a),Wa=l(e),c(lt.$$.fragment,e),Ha=l(e),x=s(e,"DIV",{class:!0});var no=b(x);c(rt.$$.fragment,no),Eo=l(no),It=s(no,"P",{"data-svelte-h":!0}),d(It)!=="svelte-1va94c9"&&(It.textContent=Kn),no.forEach(a),Qa=l(e),c(st.$$.fragment,e),za=l(e),At=s(e,"P",{}),b(At).forEach(a),this.h()},h(){M(j,"name","hf:doc:metadata"),M(j,"content",pl),M(I,"width","835"),M(I,"alt","Screenshot 2024-03-19 at 12 39 41"),tl(I.src,So="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d")||M(I,"src",So),sl($,"text-align","center"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,j),o(e,Ft,t),o(e,kt,t),o(e,qt,t),h(E,e,t),o(e,Bt,t),o(e,R,t),o(e,Lt,t),o(e,Z,t),o(e,Et,t),h(W,e,t),o(e,Rt,t),o(e,H,t),o(e,Zt,t),o(e,Q,t),o(e,Wt,t),o(e,z,t),o(e,Ht,t),o(e,G,t),o(e,Qt,t),o(e,I,t),o(e,zt,t),o(e,S,t),o(e,Gt,t),h(X,e,t),o(e,St,t),o(e,Y,t),o(e,Xt,t),o(e,$,t),o(e,Yt,t),o(e,V,t),o(e,Vt,t),o(e,K,t),o(e,Kt,t),o(e,ee,t),o(e,ea,t),h(te,e,t),o(e,ta,t),o(e,ae,t),o(e,aa,t),h(oe,e,t),o(e,oa,t),o(e,ne,t),o(e,na,t),h(le,e,t),o(e,la,t),o(e,re,t),o(e,ra,t),h(se,e,t),o(e,sa,t),o(e,ie,t),o(e,ia,t),h(de,e,t),o(e,da,t),o(e,pe,t),o(e,pa,t),h(me,e,t),o(e,ma,t),o(e,ce,t),o(e,ca,t),o(e,he,t),o(e,ha,t),o(e,ue,t),o(e,ua,t),o(e,fe,t),o(e,fa,t),o(e,ge,t),o(e,ga,t),o(e,_e,t),o(e,_a,t),o(e,Me,t),o(e,Ma,t),o(e,be,t),o(e,ba,t),o(e,ve,t),o(e,va,t),o(e,ye,t),o(e,ya,t),o(e,Te,t),o(e,Ta,t),o(e,we,t),o(e,wa,t),h(Je,e,t),o(e,Ja,t),o(e,Ue,t),o(e,Ua,t),o(e,Ce,t),o(e,Ca,t),h(je,e,t),o(e,ja,t),o(e,xe,t),o(e,xa,t),o(e,Ie,t),o(e,Ia,t),o(e,$e,t),o(e,$a,t),h(Oe,e,t),o(e,Oa,t),o(e,Pe,t),o(e,Pa,t),h(De,e,t),o(e,Da,t),o(e,ke,t),o(e,ka,t),o(e,Ae,t),o(e,Aa,t),h(Ne,e,t),o(e,Na,t),o(e,Fe,t),o(e,Fa,t),o(e,qe,t),o(e,qa,t),h(Be,e,t),o(e,Ba,t),o(e,Le,t),o(e,La,t),o(e,Ee,t),o(e,Ea,t),h(Re,e,t),o(e,Ra,t),h(Ze,e,t),o(e,Za,t),o(e,p,t),h(We,p,null),i(p,lo),i(p,it),i(p,ro),i(p,O),h(He,O,null),i(O,so),i(O,dt),i(p,io),i(p,P),h(Qe,P,null),i(P,po),i(P,pt),i(p,mo),i(p,w),h(ze,w,null),i(w,co),i(w,mt),i(w,ho),i(w,ct),i(p,uo),i(p,D),h(Ge,D,null),i(D,fo),i(D,ht),i(p,go),i(p,k),h(Se,k,null),i(k,_o),i(k,ut),i(p,Mo),i(p,J),h(Xe,J,null),i(J,bo),i(J,ft),i(J,vo),i(J,gt),i(p,yo),i(p,A),h(Ye,A,null),i(A,To),i(A,_t),i(p,wo),i(p,N),h(Ve,N,null),i(N,Jo),i(N,Mt),i(p,Uo),i(p,F),h(Ke,F,null),i(F,Co),i(F,bt),i(p,jo),i(p,U),h(et,U,null),i(U,xo),i(U,vt),i(U,Io),i(U,yt),i(p,$o),i(p,C),h(tt,C,null),i(C,Oo),i(C,Tt),i(C,Po),i(C,wt),i(p,Do),i(p,q),h(at,q,null),i(q,ko),i(q,Jt),i(p,Ao),i(p,B),h(ot,B,null),i(B,No),i(B,Ut),i(p,Fo),i(p,T),h(nt,T,null),i(T,qo),i(T,Ct),i(T,Bo),i(T,jt),i(T,Lo),i(T,xt),o(e,Wa,t),h(lt,e,t),o(e,Ha,t),o(e,x,t),h(rt,x,null),i(x,Eo),i(x,It),o(e,Qa,t),h(st,e,t),o(e,za,t),o(e,At,t),Ga=!0},p:al,i(e){Ga||(u(E.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Oe.$$.fragment,e),u(De.$$.fragment,e),u(Ne.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(He.$$.fragment,e),u(Qe.$$.fragment,e),u(ze.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(Ye.$$.fragment,e),u(Ve.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(lt.$$.fragment,e),u(rt.$$.fragment,e),u(st.$$.fragment,e),Ga=!0)},o(e){f(E.$$.fragment,e),f(W.$$.fragment,e),f(X.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(le.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(Je.$$.fragment,e),f(je.$$.fragment,e),f(Oe.$$.fragment,e),f(De.$$.fragment,e),f(Ne.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(Ze.$$.fragment,e),f(We.$$.fragment,e),f(He.$$.fragment,e),f(Qe.$$.fragment,e),f(ze.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Xe.$$.fragment,e),f(Ye.$$.fragment,e),f(Ve.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(lt.$$.fragment,e),f(rt.$$.fragment,e),f(st.$$.fragment,e),Ga=!1},d(e){e&&(a(Ft),a(kt),a(qt),a(Bt),a(R),a(Lt),a(Z),a(Et),a(Rt),a(H),a(Zt),a(Q),a(Wt),a(z),a(Ht),a(G),a(Qt),a(I),a(zt),a(S),a(Gt),a(St),a(Y),a(Xt),a($),a(Yt),a(V),a(Vt),a(K),a(Kt),a(ee),a(ea),a(ta),a(ae),a(aa),a(oa),a(ne),a(na),a(la),a(re),a(ra),a(sa),a(ie),a(ia),a(da),a(pe),a(pa),a(ma),a(ce),a(ca),a(he),a(ha),a(ue),a(ua),a(fe),a(fa),a(ge),a(ga),a(_e),a(_a),a(Me),a(Ma),a(be),a(ba),a(ve),a(va),a(ye),a(ya),a(Te),a(Ta),a(we),a(wa),a(Ja),a(Ue),a(Ua),a(Ce),a(Ca),a(ja),a(xe),a(xa),a(Ie),a(Ia),a($e),a($a),a(Oa),a(Pe),a(Pa),a(Da),a(ke),a(ka),a(Ae),a(Aa),a(Na),a(Fe),a(Fa),a(qe),a(qa),a(Ba),a(Le),a(La),a(Ee),a(Ea),a(Ra),a(Za),a(p),a(Wa),a(Ha),a(x),a(Qa),a(za),a(At)),a(j),g(E,e),g(W,e),g(X,e),g(te,e),g(oe,e),g(le,e),g(se,e),g(de,e),g(me,e),g(Je,e),g(je,e),g(Oe,e),g(De,e),g(Ne,e),g(Be,e),g(Re,e),g(Ze,e),g(We),g(He),g(Qe),g(ze),g(Ge),g(Se),g(Xe),g(Ye),g(Ve),g(Ke),g(et),g(tt),g(at),g(ot),g(nt),g(lt,e),g(rt),g(st,e)}}}const pl='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"How DPO works","local":"how-dpo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2}],"depth":1}';function ml(Ro){return ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends nl{constructor(j){super(),ll(this,j,ml,dl,el,{})}}export{_l as component};
