import{s as ht,o as yt,n as wt}from"../chunks/scheduler.f6b352c8.js";import{S as Mt,i as jt,g as p,s as l,r as o,A as It,h as i,f as n,c as e,j as Jt,u,x as m,k as mt,y as ft,a,v as c,d as r,t as T,w as J}from"../chunks/index.b90df637.js";import{T as dt}from"../chunks/Tip.366d2e6e.js";import{C as M}from"../chunks/CodeBlock.e5718f9d.js";import{H as w,E as Ut}from"../chunks/getInferenceSnippets.1e3ae0bf.js";function $t(is){let h,I='If you have any questions or need help, please reach out on <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord</a>.';return{c(){h=p("p"),h.innerHTML=I},l(y){h=i(y,"P",{"data-svelte-h":!0}),m(h)!=="svelte-aht5b3"&&(h.innerHTML=I)},m(y,es){a(y,h,es)},p:wt,d(y){y&&n(h)}}}function Ct(is){let h,I,y,es,f,os,d,Ys="This guide explains how to use the <code>gym_hil</code> simulation environments as an alternative to real robots when working with the LeRobot framework for Human-In-the-Loop (HIL) reinforcement learning.",us,U,zs="<code>gym_hil</code> is a package that provides Gymnasium-compatible simulation environments specifically designed for Human-In-the-Loop reinforcement learning. These environments allow you to:",cs,$,Ds="<li><p>Train policies in simulation to test the RL stack before training on real robots</p></li> <li><p>Collect demonstrations in sim using external devices like gamepads or keyboards</p></li> <li><p>Perform human interventions during policy learning</p></li>",rs,C,Fs="Currently, the main environment is a Franka Panda robot simulation based on MuJoCo, with tasks like picking up a cube.",Ts,g,Js,b,Ks="First, install the <code>gym_hil</code> package within the LeRobot environment:",ms,v,hs,B,ys,q,Os="<li>A gamepad or keyboard to control the robot</li> <li>A Nvidia GPU</li>",ws,_,Ms,k,st='To use <code>gym_hil</code> with LeRobot, you need to create a configuration file. An example is provided <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/gym_hil_env.json" rel="nofollow">here</a>. Key configuration sections include:',js,x,Is,L,fs,H,tt="Available tasks:",ds,W,nt="<li><code>PandaPickCubeBase-v0</code>: Basic environment</li> <li><code>PandaPickCubeGamepad-v0</code>: With gamepad control</li> <li><code>PandaPickCubeKeyboard-v0</code>: With keyboard control</li>",Us,Q,$s,Z,Cs,A,at="Important parameters:",gs,G,lt="<li><code>gripper.gripper_penalty</code>: Penalty for excessive gripper movement</li> <li><code>gripper.use_gripper</code>: Whether to enable gripper control</li> <li><code>inverse_kinematics.end_effector_step_sizes</code>: Size of the steps in the x,y,z axes of the end-effector</li> <li><code>control_mode</code>: Set to <code>&quot;gamepad&quot;</code> to use a gamepad controller</li>",bs,S,vs,E,Bs,R,et="To run the environment, set mode to null:",qs,N,_s,X,ks,P,pt="To collect a dataset, set the mode to <code>record</code> whilst defining the repo_id and number of episodes to record:",xs,V,Ls,Y,Hs,z,Ws,D,it='To train a policy, checkout the configuration example available <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/train_gym_hil_env.json" rel="nofollow">here</a> and run the actor and learner servers:',Qs,F,Zs,K,ot="In a different terminal, run the learner server:",As,O,Gs,ss,ut="The simulation environment provides a safe and repeatable way to develop and test your Human-In-the-Loop reinforcement learning components before deploying to real robots.",Ss,ts,ct="Congrats 🎉, you have finished this tutorial!",Es,j,Rs,ns,rt="Paper citation:",Ns,as,Xs,ls,Ps,ps,Vs;return f=new w({props:{title:"Train RL in Simulation",local:"train-rl-in-simulation",headingTag:"h1"}}),g=new w({props:{title:"Installation",local:"installation",headingTag:"h2"}}),v=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmhpbHNlcmwlNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[hilserl]&quot;</span>',wrap:!1}}),B=new w({props:{title:"What do I need?",local:"what-do-i-need",headingTag:"h2"}}),_=new w({props:{title:"Configuration",local:"configuration",headingTag:"h2"}}),x=new w({props:{title:"Environment Type and Task",local:"environment-type-and-task",headingTag:"h3"}}),L=new M({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmd5bV9tYW5pcHVsYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJneW1faGlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMlBhbmRhUGlja0N1YmVHYW1lcGFkLXYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnBzJTIyJTNBJTIwMTAlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_hil&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;PandaPickCubeGamepad-v0&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Q=new w({props:{title:"Processor Configuration",local:"processor-configuration",headingTag:"h3"}}),Z=new M({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udHJvbF9tb2RlJTIyJTNBJTIwJTIyZ2FtZXBhZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmdyaXBwZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJncmlwcGVyX3BlbmFsdHklMjIlM0ElMjAtMC4wMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2V0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udHJvbF90aW1lX3MlMjIlM0ElMjAxNS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZml4ZWRfcmVzZXRfam9pbnRfcG9zaXRpb25zJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMC4wJTJDJTIwMC4xOTUlMkMlMjAwLjAlMkMlMjAtMi40MyUyQyUyMDAuMCUyQyUyMDIuNjIlMkMlMjAwLjc4NSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmludmVyc2Vfa2luZW1hdGljcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuZF9lZmZlY3Rvcl9zdGVwX3NpemVzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeCUyMiUzQSUyMDAuMDI1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeSUyMiUzQSUyMDAuMDI1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDI1JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;gripper_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">-0.02</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;control_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15.0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;fixed_reset_joint_positions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
          <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.195</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-2.43</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span> <span class="hljs-number">2.62</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.785</span>
        <span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;inverse_kinematics&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;end_effector_step_sizes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;x&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.025</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;y&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.025</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;z&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.025</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),S=new w({props:{title:"Running with HIL RL of LeRobot",local:"running-with-hil-rl-of-lerobot",headingTag:"h2"}}),E=new w({props:{title:"Basic Usage",local:"basic-usage",headingTag:"h3"}}),N=new M({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHBhdGglMkZ0byUyRmd5bV9oaWxfZW52Lmpzb24=",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path path/to/gym_hil_env.json",wrap:!1}}),X=new w({props:{title:"Recording a Dataset",local:"recording-a-dataset",headingTag:"h3"}}),V=new M({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmd5bV9tYW5pcHVsYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJneW1faGlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMlBhbmRhUGlja0N1YmVHYW1lcGFkLXYwJTIyJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyZGF0YXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjAlMjJ1c2VybmFtZSUyRnNpbV9kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF9yb290JTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJwaWNrX2N1YmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fZXBpc29kZXMlMjIlM0ElMjAxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMmVwaXNvZGUlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIycHVzaF90b19odWIlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIybW9kZSUyMiUzQSUyMCUyMnJlY29yZCUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_hil&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;PandaPickCubeGamepad-v0&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;username/sim_dataset&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pick_cube&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Y=new M({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHBhdGglMkZ0byUyRmd5bV9oaWxfZW52Lmpzb24=",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path path/to/gym_hil_env.json",wrap:!1}}),z=new w({props:{title:"Training a Policy",local:"training-a-policy",headingTag:"h3"}}),F=new M({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuYWN0b3IlMjAtLWNvbmZpZ19wYXRoJTIwcGF0aCUyRnRvJTJGdHJhaW5fZ3ltX2hpbF9lbnYuanNvbg==",highlighted:"python -m lerobot.scripts.rl.actor --config_path path/to/train_gym_hil_env.json",wrap:!1}}),O=new M({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwubGVhcm5lciUyMC0tY29uZmlnX3BhdGglMjBwYXRoJTJGdG8lMkZ0cmFpbl9neW1faGlsX2Vudi5qc29u",highlighted:"python -m lerobot.scripts.rl.learner --config_path path/to/train_gym_hil_env.json",wrap:!1}}),j=new dt({props:{warning:!1,$$slots:{default:[$t]},$$scope:{ctx:is}}}),as=new M({props:{code:"JTQwYXJ0aWNsZSU3Qmx1bzIwMjRwcmVjaXNlJTJDJTBBJTIwJTIwdGl0bGUlM0QlN0JQcmVjaXNlJTIwYW5kJTIwRGV4dGVyb3VzJTIwUm9ib3RpYyUyME1hbmlwdWxhdGlvbiUyMHZpYSUyMEh1bWFuLWluLXRoZS1Mb29wJTIwUmVpbmZvcmNlbWVudCUyMExlYXJuaW5nJTdEJTJDJTBBJTIwJTIwYXV0aG9yJTNEJTdCTHVvJTJDJTIwSmlhbmxhbiUyMGFuZCUyMFh1JTJDJTIwQ2hhcmxlcyUyMGFuZCUyMFd1JTJDJTIwSmVmZnJleSUyMGFuZCUyMExldmluZSUyQyUyMFNlcmdleSU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlM0QlN0JhclhpdiUyMHByZXByaW50JTIwYXJYaXYlM0EyNDEwLjIxODQ1JTdEJTJDJTBBJTIwJTIweWVhciUzRCU3QjIwMjQlN0QlMEElN0Q=",highlighted:`@article{luo2024precise,
  title={Precise <span class="hljs-keyword">and </span>Dexterous Robotic Manipulation via Human-in-the-Loop Reinforcement Learning},
  author={Luo, <span class="hljs-keyword">Jianlan </span><span class="hljs-keyword">and </span>Xu, Charles <span class="hljs-keyword">and </span>Wu, <span class="hljs-keyword">Jeffrey </span><span class="hljs-keyword">and </span>Levine, Sergey},
  <span class="hljs-keyword">journal={arXiv </span>preprint arXiv:<span class="hljs-number">2410</span>.<span class="hljs-number">21845</span>},
  year={<span class="hljs-number">2024</span>}
}`,wrap:!1}}),ls=new Ut({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/hilserl_sim.mdx"}}),{c(){h=p("meta"),I=l(),y=p("p"),es=l(),o(f.$$.fragment),os=l(),d=p("p"),d.innerHTML=Ys,us=l(),U=p("p"),U.innerHTML=zs,cs=l(),$=p("ul"),$.innerHTML=Ds,rs=l(),C=p("p"),C.textContent=Fs,Ts=l(),o(g.$$.fragment),Js=l(),b=p("p"),b.innerHTML=Ks,ms=l(),o(v.$$.fragment),hs=l(),o(B.$$.fragment),ys=l(),q=p("ul"),q.innerHTML=Os,ws=l(),o(_.$$.fragment),Ms=l(),k=p("p"),k.innerHTML=st,js=l(),o(x.$$.fragment),Is=l(),o(L.$$.fragment),fs=l(),H=p("p"),H.textContent=tt,ds=l(),W=p("ul"),W.innerHTML=nt,Us=l(),o(Q.$$.fragment),$s=l(),o(Z.$$.fragment),Cs=l(),A=p("p"),A.textContent=at,gs=l(),G=p("ul"),G.innerHTML=lt,bs=l(),o(S.$$.fragment),vs=l(),o(E.$$.fragment),Bs=l(),R=p("p"),R.textContent=et,qs=l(),o(N.$$.fragment),_s=l(),o(X.$$.fragment),ks=l(),P=p("p"),P.innerHTML=pt,xs=l(),o(V.$$.fragment),Ls=l(),o(Y.$$.fragment),Hs=l(),o(z.$$.fragment),Ws=l(),D=p("p"),D.innerHTML=it,Qs=l(),o(F.$$.fragment),Zs=l(),K=p("p"),K.textContent=ot,As=l(),o(O.$$.fragment),Gs=l(),ss=p("p"),ss.textContent=ut,Ss=l(),ts=p("p"),ts.textContent=ct,Es=l(),o(j.$$.fragment),Rs=l(),ns=p("p"),ns.textContent=rt,Ns=l(),o(as.$$.fragment),Xs=l(),o(ls.$$.fragment),Ps=l(),ps=p("p"),this.h()},l(s){const t=It("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(n),I=e(s),y=i(s,"P",{}),Jt(y).forEach(n),es=e(s),u(f.$$.fragment,s),os=e(s),d=i(s,"P",{"data-svelte-h":!0}),m(d)!=="svelte-399pbz"&&(d.innerHTML=Ys),us=e(s),U=i(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-z2t1g3"&&(U.innerHTML=zs),cs=e(s),$=i(s,"UL",{"data-svelte-h":!0}),m($)!=="svelte-19bnmv0"&&($.innerHTML=Ds),rs=e(s),C=i(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1n86ema"&&(C.textContent=Fs),Ts=e(s),u(g.$$.fragment,s),Js=e(s),b=i(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-19ylgus"&&(b.innerHTML=Ks),ms=e(s),u(v.$$.fragment,s),hs=e(s),u(B.$$.fragment,s),ys=e(s),q=i(s,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-37t4vf"&&(q.innerHTML=Os),ws=e(s),u(_.$$.fragment,s),Ms=e(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-w2ilb8"&&(k.innerHTML=st),js=e(s),u(x.$$.fragment,s),Is=e(s),u(L.$$.fragment,s),fs=e(s),H=i(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1gmfvxn"&&(H.textContent=tt),ds=e(s),W=i(s,"UL",{"data-svelte-h":!0}),m(W)!=="svelte-tdrsar"&&(W.innerHTML=nt),Us=e(s),u(Q.$$.fragment,s),$s=e(s),u(Z.$$.fragment,s),Cs=e(s),A=i(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1i1dja0"&&(A.textContent=at),gs=e(s),G=i(s,"UL",{"data-svelte-h":!0}),m(G)!=="svelte-mizygd"&&(G.innerHTML=lt),bs=e(s),u(S.$$.fragment,s),vs=e(s),u(E.$$.fragment,s),Bs=e(s),R=i(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1pcnjlb"&&(R.textContent=et),qs=e(s),u(N.$$.fragment,s),_s=e(s),u(X.$$.fragment,s),ks=e(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-18bmi0"&&(P.innerHTML=pt),xs=e(s),u(V.$$.fragment,s),Ls=e(s),u(Y.$$.fragment,s),Hs=e(s),u(z.$$.fragment,s),Ws=e(s),D=i(s,"P",{"data-svelte-h":!0}),m(D)!=="svelte-c4xqkg"&&(D.innerHTML=it),Qs=e(s),u(F.$$.fragment,s),Zs=e(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-xj4a2z"&&(K.textContent=ot),As=e(s),u(O.$$.fragment,s),Gs=e(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-rhp9uh"&&(ss.textContent=ut),Ss=e(s),ts=i(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-kg8fpw"&&(ts.textContent=ct),Es=e(s),u(j.$$.fragment,s),Rs=e(s),ns=i(s,"P",{"data-svelte-h":!0}),m(ns)!=="svelte-k8021v"&&(ns.textContent=rt),Ns=e(s),u(as.$$.fragment,s),Xs=e(s),u(ls.$$.fragment,s),Ps=e(s),ps=i(s,"P",{}),Jt(ps).forEach(n),this.h()},h(){mt(h,"name","hf:doc:metadata"),mt(h,"content",gt)},m(s,t){ft(document.head,h),a(s,I,t),a(s,y,t),a(s,es,t),c(f,s,t),a(s,os,t),a(s,d,t),a(s,us,t),a(s,U,t),a(s,cs,t),a(s,$,t),a(s,rs,t),a(s,C,t),a(s,Ts,t),c(g,s,t),a(s,Js,t),a(s,b,t),a(s,ms,t),c(v,s,t),a(s,hs,t),c(B,s,t),a(s,ys,t),a(s,q,t),a(s,ws,t),c(_,s,t),a(s,Ms,t),a(s,k,t),a(s,js,t),c(x,s,t),a(s,Is,t),c(L,s,t),a(s,fs,t),a(s,H,t),a(s,ds,t),a(s,W,t),a(s,Us,t),c(Q,s,t),a(s,$s,t),c(Z,s,t),a(s,Cs,t),a(s,A,t),a(s,gs,t),a(s,G,t),a(s,bs,t),c(S,s,t),a(s,vs,t),c(E,s,t),a(s,Bs,t),a(s,R,t),a(s,qs,t),c(N,s,t),a(s,_s,t),c(X,s,t),a(s,ks,t),a(s,P,t),a(s,xs,t),c(V,s,t),a(s,Ls,t),c(Y,s,t),a(s,Hs,t),c(z,s,t),a(s,Ws,t),a(s,D,t),a(s,Qs,t),c(F,s,t),a(s,Zs,t),a(s,K,t),a(s,As,t),c(O,s,t),a(s,Gs,t),a(s,ss,t),a(s,Ss,t),a(s,ts,t),a(s,Es,t),c(j,s,t),a(s,Rs,t),a(s,ns,t),a(s,Ns,t),c(as,s,t),a(s,Xs,t),c(ls,s,t),a(s,Ps,t),a(s,ps,t),Vs=!0},p(s,[t]){const Tt={};t&2&&(Tt.$$scope={dirty:t,ctx:s}),j.$set(Tt)},i(s){Vs||(r(f.$$.fragment,s),r(g.$$.fragment,s),r(v.$$.fragment,s),r(B.$$.fragment,s),r(_.$$.fragment,s),r(x.$$.fragment,s),r(L.$$.fragment,s),r(Q.$$.fragment,s),r(Z.$$.fragment,s),r(S.$$.fragment,s),r(E.$$.fragment,s),r(N.$$.fragment,s),r(X.$$.fragment,s),r(V.$$.fragment,s),r(Y.$$.fragment,s),r(z.$$.fragment,s),r(F.$$.fragment,s),r(O.$$.fragment,s),r(j.$$.fragment,s),r(as.$$.fragment,s),r(ls.$$.fragment,s),Vs=!0)},o(s){T(f.$$.fragment,s),T(g.$$.fragment,s),T(v.$$.fragment,s),T(B.$$.fragment,s),T(_.$$.fragment,s),T(x.$$.fragment,s),T(L.$$.fragment,s),T(Q.$$.fragment,s),T(Z.$$.fragment,s),T(S.$$.fragment,s),T(E.$$.fragment,s),T(N.$$.fragment,s),T(X.$$.fragment,s),T(V.$$.fragment,s),T(Y.$$.fragment,s),T(z.$$.fragment,s),T(F.$$.fragment,s),T(O.$$.fragment,s),T(j.$$.fragment,s),T(as.$$.fragment,s),T(ls.$$.fragment,s),Vs=!1},d(s){s&&(n(I),n(y),n(es),n(os),n(d),n(us),n(U),n(cs),n($),n(rs),n(C),n(Ts),n(Js),n(b),n(ms),n(hs),n(ys),n(q),n(ws),n(Ms),n(k),n(js),n(Is),n(fs),n(H),n(ds),n(W),n(Us),n($s),n(Cs),n(A),n(gs),n(G),n(bs),n(vs),n(Bs),n(R),n(qs),n(_s),n(ks),n(P),n(xs),n(Ls),n(Hs),n(Ws),n(D),n(Qs),n(Zs),n(K),n(As),n(Gs),n(ss),n(Ss),n(ts),n(Es),n(Rs),n(ns),n(Ns),n(Xs),n(Ps),n(ps)),n(h),J(f,s),J(g,s),J(v,s),J(B,s),J(_,s),J(x,s),J(L,s),J(Q,s),J(Z,s),J(S,s),J(E,s),J(N,s),J(X,s),J(V,s),J(Y,s),J(z,s),J(F,s),J(O,s),J(j,s),J(as,s),J(ls,s)}}}const gt='{"title":"Train RL in Simulation","local":"train-rl-in-simulation","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"What do I need?","local":"what-do-i-need","sections":[],"depth":2},{"title":"Configuration","local":"configuration","sections":[{"title":"Environment Type and Task","local":"environment-type-and-task","sections":[],"depth":3},{"title":"Processor Configuration","local":"processor-configuration","sections":[],"depth":3}],"depth":2},{"title":"Running with HIL RL of LeRobot","local":"running-with-hil-rl-of-lerobot","sections":[{"title":"Basic Usage","local":"basic-usage","sections":[],"depth":3},{"title":"Recording a Dataset","local":"recording-a-dataset","sections":[],"depth":3},{"title":"Training a Policy","local":"training-a-policy","sections":[],"depth":3}],"depth":2}],"depth":1}';function bt(is){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends Mt{constructor(h){super(),jt(this,h,bt,Ct,ht,{})}}export{xt as component};
