import{s as hc,o as Jc,n as mc}from"../chunks/scheduler.f6b352c8.js";import{S as wc,i as dc,g as p,s as e,r as c,m as Uc,A as Ic,h as i,f as l,c as a,j as x,u as r,x as o,n as fc,k as d,y as J,a as n,v as M,d as u,t as j,w as y}from"../chunks/index.b90df637.js";import{T as Cc}from"../chunks/Tip.366d2e6e.js";import{C as T}from"../chunks/CodeBlock.e5718f9d.js";import{H as h,E as bc}from"../chunks/getInferenceSnippets.1e3ae0bf.js";function gc(on){let m,Q='If you have any questions or need help, please reach out on <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord</a>.';return{c(){m=p("p"),m.innerHTML=Q},l(U){m=i(U,"P",{"data-svelte-h":!0}),o(m)!=="svelte-aht5b3"&&(m.innerHTML=Q)},m(U,Ol){n(U,m,Ol)},p:mc,d(U){U&&l(m)}}}function vc(on){let m,Q,U,Ol,k,cn,H,Rp="In this tutorial you will go through the full Human-in-the-Loop Sample-Efficient Reinforcement Learning (HIL-SERL) workflow using LeRobot. You will master training a policy with RL on a real robot in just a few hours.",rn,W,Sp="HIL-SERL is a sample-efficient reinforcement learning algorithm that combines human demonstrations with online learning and human interventions. The approach starts from a small set of human demonstrations, uses them to train a reward classifier, and then employs an actor-learner architecture where humans can intervene during policy execution to guide exploration and correct unsafe behaviors. In this tutorial, you’ll use a gamepad to provide interventions and control the robot during the learning process.",Mn,L,Gp="It combines three key ingredients:",un,X,zp="<li><p><strong>Offline demonstrations &amp; reward classifier:</strong> a handful of human-teleop episodes plus a vision-based success detector give the policy a shaped starting point.</p></li> <li><p><strong>On-robot actor / learner loop with human interventions:</strong> a distributed Soft Actor Critic (SAC) learner updates the policy while an actor explores on the physical robot; the human can jump in at any time to correct dangerous or unproductive behaviour.</p></li> <li><p><strong>Safety &amp; efficiency tools:</strong> joint/end-effector (EE) bounds, crop region of interest (ROI) preprocessing and WandB monitoring keep the data useful and the hardware safe.</p></li>",jn,R,Vp="Together these elements let HIL-SERL reach near-perfect task success and faster cycle times than imitation-only baselines.",yn,C,Yp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hilserl-main-figure.png" alt="HIL-SERL workflow" title="HIL-SERL workflow" width="100%"/>',Tn,b,Fp="<i>HIL-SERL workflow, Luo et al. 2024</i>",hn,S,Pp="This guide provides step-by-step instructions for training a robot policy using LeRobot’s HilSerl implementation to train on a real robot.",Jn,G,mn,z,Dp="<li>A gamepad (recommended) or keyboard to control the robot</li> <li>A Nvidia GPU</li> <li>A real robot with a follower and leader arm (optional if you use the keyboard or the gamepad)</li> <li>A URDF file for the robot for the kinematics package (check <code>lerobot/model/kinematics.py</code>)</li>",wn,V,dn,Y,Op="One can use HIL-SERL to train on a variety of manipulation tasks. Some recommendations:",Un,F,Kp="<li>Start with a simple task to understand how the system works.<ul><li>Push cube to a goal region</li> <li>Pick and lift cube with the gripper</li></ul></li> <li>Avoid extremely long horizon tasks. Focus on tasks that can be completed in 5-10 seconds.</li> <li>Once you have a good idea of how the system works, you can try more complex tasks and longer horizons.<ul><li>Pick and place cube</li> <li>Bimanual tasks to pick objects with two arms</li> <li>Hand-over tasks to transfer objects from one arm to another</li> <li>Go crazy!</li></ul></li>",In,P,fn,D,si="To install LeRobot with HIL-SERL, you need to install the <code>hilserl</code> extra.",Cn,O,bn,K,gn,ss,vn,ts,ti="The training process begins with proper configuration for the HILSerl environment. The main configuration class is <code>GymManipulatorConfig</code> in <code>lerobot/scripts/rl/gym_manipulator.py</code>, which contains nested <code>HILSerlRobotEnvConfig</code> and <code>DatasetConfig</code>. The configuration is organized into focused, nested sub-configs:",An,ls,Bn,ns,_n,es,li="HIL-SERL uses a modular processor pipeline architecture that processes robot observations and actions through a series of composable steps. The pipeline is divided into two main components:",Zn,as,En,ps,ni="The environment processor (<code>env_processor</code>) handles incoming observations and environment state:",Nn,is,ei="<li><strong>VanillaObservationProcessor</strong>: Converts raw robot observations into standardized format</li> <li><strong>JointVelocityProcessor</strong> (optional): Adds joint velocity information to observations</li> <li><strong>MotorCurrentProcessor</strong> (optional): Adds motor current readings to observations</li> <li><strong>ForwardKinematicsJointsToEE</strong> (optional): Computes end-effector pose from joint positions</li> <li><strong>ImageCropResizeProcessor</strong> (optional): Crops and resizes camera images</li> <li><strong>TimeLimitProcessor</strong> (optional): Enforces episode time limits</li> <li><strong>GripperPenaltyProcessor</strong> (optional): Applies penalties for inappropriate gripper usage</li> <li><strong>RewardClassifierProcessor</strong> (optional): Automated reward detection using vision models</li> <li><strong>ToBatchProcessor</strong>: Converts data to batch format for neural network processing</li> <li><strong>DeviceProcessor</strong>: Moves data to the specified compute device (CPU/GPU)</li>",$n,os,qn,cs,ai="The action processor (<code>action_processor</code>) handles outgoing actions and human interventions:",xn,rs,pi="<li><strong>AddTeleopActionAsComplimentaryData</strong>: Captures teleoperator actions for logging</li> <li><strong>AddTeleopEventsAsInfo</strong>: Records intervention events and episode control signals</li> <li><strong>AddRobotObservationAsComplimentaryData</strong>: Stores raw robot state for processing</li> <li><strong>InterventionActionProcessor</strong>: Handles human interventions and episode termination</li> <li><strong>Inverse Kinematics Pipeline</strong> (when enabled):<ul><li><strong>MapDeltaActionToRobotAction</strong>: Converts delta actions to robot action format</li> <li><strong>EEReferenceAndDelta</strong>: Computes end-effector reference and delta movements</li> <li><strong>EEBoundsAndSafety</strong>: Enforces workspace safety bounds</li> <li><strong>InverseKinematicsEEToJoints</strong>: Converts end-effector actions to joint targets</li> <li><strong>GripperVelocityToJoint</strong>: Handles gripper control commands</li></ul></li>",Qn,Ms,kn,us,ii="<strong>Basic Observation Processing</strong>:",Hn,js,Wn,ys,oi="<strong>Image Processing</strong>:",Ln,Ts,Xn,hs,ci="<strong>Inverse Kinematics Setup</strong>:",Rn,Js,Sn,ms,Gn,ws,ri="The HIL-SERL framework supports additional observation processing features that can improve policy learning:",zn,ds,Vn,Us,Mi="Enable joint velocity estimation to provide the policy with motion information:",Yn,Is,Fn,fs,ui="This processor:",Pn,Cs,ji="<li>Estimates joint velocities using finite differences between consecutive joint position readings</li> <li>Adds velocity information to the observation state vector</li> <li>Useful for policies that need motion awareness for dynamic tasks</li>",Dn,bs,On,gs,yi="Monitor motor currents to detect contact forces and load conditions:",Kn,vs,se,As,Ti="This processor:",te,Bs,hi="<li>Reads motor current values from the robot’s control system</li> <li>Adds current measurements to the observation state vector</li> <li>Helps detect contact events, object weights, and mechanical resistance</li> <li>Useful for contact-rich manipulation tasks</li>",le,_s,ne,Zs,Ji="You can enable multiple observation processing features simultaneously:",ee,Es,ae,Ns,mi="<strong>Note</strong>: Enabling additional observation features increases the state space dimensionality, which may require adjusting your policy network architecture and potentially collecting more training data.",pe,$s,ie,qs,wi="Before collecting demonstrations, you need to determine the appropriate operational bounds for your robot.",oe,xs,di="This helps simplify the problem of learning on the real robot in two ways: 1) by limiting the robot’s operational space to a specific region that solves the task and avoids unnecessary or unsafe exploration, and 2) by allowing training in end-effector space rather than joint space. Empirically, learning in joint space for reinforcement learning in manipulation is often a harder problem - some tasks are nearly impossible to learn in joint space but become learnable when the action space is transformed to end-effector coordinates.",ce,Qs,Ui="<strong>Using find_joint_limits.py</strong>",re,ks,Ii=`This script helps you find the safe operational bounds for your robot’s end-effector. Given that you have a follower and leader arm, you can use the script to find the bounds for the follower arm that will be applied during training.
Bounding the action space will reduce the redundant exploration of the agent and guarantees safety.`,Me,Hs,ue,Ws,fi="<strong>Workflow</strong>",je,I,Kl,Ci="Run the script and move the robot through the space that solves the task",Np,sn,$p,Ls,qp,tn,bi="Use these values in the configuration of your teleoperation device (TeleoperatorConfig) under the <code>end_effector_bounds</code> field",ye,Xs,gi="<strong>Example Configuration</strong>",Te,Rs,he,Ss,Je,Gs,vi="With the bounds defined, you can safely collect demonstrations for training. Training RL with off-policy algorithm allows us to use offline datasets collected in order to improve the efficiency of the learning process.",me,zs,Ai="<strong>Setting Up Record Mode</strong>",we,Vs,Bi='Create a configuration file for recording demonstrations (or edit an existing one like <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">env_config_so100.json</a>):',de,Ys,_i="<li>Set <code>mode</code> to <code>&quot;record&quot;</code> at the root level</li> <li>Specify a unique <code>repo_id</code> for your dataset in the <code>dataset</code> section (e.g., “username/task_name”)</li> <li>Set <code>num_episodes</code> in the <code>dataset</code> section to the number of demonstrations you want to collect</li> <li>Set <code>env.processor.image_preprocessing.crop_params_dict</code> to <code>{}</code> initially (we’ll determine crops later)</li> <li>Configure <code>env.robot</code>, <code>env.teleop</code>, and other hardware settings in the <code>env</code> section</li>",Ue,Fs,Zi="Example configuration section:",Ie,Ps,fe,Ds,Ce,Os,Ei=`Along with your robot, you will need a teleoperation device to control it in order to collect datasets of your task and perform interventions during the online training.
We support using a gamepad or a keyboard or the leader arm of the robot.`,be,Ks,Ni="HIL-Serl learns actions in the end-effector space of the robot. Therefore, the teleoperation will control the end-effector’s x,y,z displacements.",ge,st,$i="For that we need to define a version of the robot that takes actions in the end-effector space. Check the robot class <code>SO100FollowerEndEffector</code> and its configuration <code>SO100FollowerEndEffectorConfig</code> for the default parameters related to the end-effector space.",ve,tt,Ae,lt,qi="The <code>Teleoperator</code> defines the teleoperation device. You can check the list of available teleoperators in <code>lerobot/teleoperators</code>.",Be,nt,xi="<strong>Setting up the Gamepad</strong>",_e,et,Qi="The gamepad provides a very convenient way to control the robot and the episode state.",Ze,at,ki="To setup the gamepad, you need to set the <code>control_mode</code> to <code>&quot;gamepad&quot;</code> and define the <code>teleop</code> section in the configuration file.",Ee,pt,Ne,g,Hi='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/gamepad_guide.jpg?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',$e,v,Wi="<i>Gamepad button mapping for robot control and episode management</i>",qe,it,Li="<strong>Setting up the SO101 leader</strong>",xe,ot,Xi="The SO101 leader arm has reduced gears that allows it to move and track the follower arm during exploration. Therefore, taking over is much smoother than the gearless SO100.",Qe,ct,Ri="To setup the SO101 leader, you need to set the <code>control_mode</code> to <code>&quot;leader&quot;</code> and define the <code>teleop</code> section in the configuration file.",ke,rt,He,Mt,Si=`In order to annotate the success/failure of the episode, <strong>you will need</strong> to use a keyboard to press <code>s</code> for success, <code>esc</code> for failure.
During the online training, press <code>space</code> to take over the policy and <code>space</code> again to give the control back to the policy.`,We,ut,Gi='<summary><strong>Video: SO101 leader teleoperation</strong></summary> <div class="video-container"><video controls="" width="600"><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/so101_leader_tutorial.mp4" type="video/mp4"/></video></div> <p align="center"><i>SO101 leader teleoperation example, the leader tracks the follower, press `space` to intervene</i></p>',Le,jt,zi="<strong>Recording Demonstrations</strong>",Xe,yt,Vi='Start the recording process, an example of the config file can be found <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">here</a>:',Re,Tt,Se,ht,Yi="During recording:",Ge,Jt,Fi="<li>The robot will reset to the initial position defined in the configuration file <code>env.processor.reset.fixed_reset_joint_positions</code></li> <li>Complete the task successfully</li> <li>The episode ends with a reward of 1 when you press the “success” button</li> <li>If the time limit is reached, or the fail button is pressed, the episode ends with a reward of 0</li> <li>You can rerecord an episode by pressing the “rerecord” button</li> <li>The process automatically continues to the next episode</li> <li>After recording all episodes, the dataset is pushed to the Hugging Face Hub (optional) and saved locally</li>",ze,mt,Ve,wt,Pi=`After collecting demonstrations, process them to determine optimal camera crops.
Reinforcement learning is sensitive to background distractions, so it is important to crop the images to the relevant workspace area.`,Ye,dt,Di="Visual RL algorithms learn directly from pixel inputs, making them vulnerable to irrelevant visual information. Background elements like changing lighting, shadows, people moving, or objects outside the workspace can confuse the learning process. Good ROI selection should:",Fe,Ut,Oi="<li>Include only the essential workspace where the task happens</li> <li>Capture the robot’s end-effector and all objects involved in the task</li> <li>Exclude unnecessary background elements and distractions</li>",Pe,It,Ki="Note: If you already know the crop parameters, you can skip this step and just set the <code>crop_params_dict</code> in the configuration file during recording.",De,ft,so="<strong>Determining Crop Parameters</strong>",Oe,Ct,to="Use the <code>crop_dataset_roi.py</code> script to interactively select regions of interest in your camera images:",Ke,bt,sa,gt,lo="<li>For each camera view, the script will display the first frame</li> <li>Draw a rectangle around the relevant workspace area</li> <li>Press ‘c’ to confirm the selection</li> <li>Repeat for all camera views</li> <li>The script outputs cropping parameters and creates a new cropped dataset</li>",ta,vt,no="Example output:",la,At,na,A,eo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/crop_dataset.gif" width="600"/>',ea,B,ao="<i>Interactive cropping tool for selecting regions of interest</i>",aa,Bt,po="<strong>Updating Configuration</strong>",pa,_t,io="Add these crop parameters to your training configuration:",ia,Zt,oa,Et,oo="<strong>Recommended image resolution</strong>",ca,Nt,co="Most vision-based policies have been validated on square inputs of either <strong>128×128</strong> (default) or <strong>64×64</strong> pixels. We therefore advise setting the resize_size parameter to [128, 128] – or [64, 64] if you need to save GPU memory and bandwidth. Other resolutions are possible but have not been extensively tested.",ra,$t,Ma,qt,ro="The reward classifier plays an important role in the HIL-SERL workflow by automating reward assignment and automatically detecting episode success. Instead of manually defining reward functions or relying on human feedback for every timestep, the reward classifier learns to predict success/failure from visual observations. This enables the RL algorithm to learn efficiently by providing consistent and automated reward signals based on the robot’s camera inputs.",ua,xt,Mo="This guide explains how to train a reward classifier for human-in-the-loop reinforcement learning implementation of LeRobot. Reward classifiers learn to predict the reward value given a state which can be used in an RL setup to train a policy.",ja,Qt,uo="<strong>Note</strong>: Training a reward classifier is optional. You can start the first round of RL experiments by annotating the success manually with your gamepad or keyboard device.",ya,kt,jo="The reward classifier implementation in <code>modeling_classifier.py</code> uses a pretrained vision model to process the images. It can output either a single value for binary rewards to predict success/fail cases or multiple values for multi-class settings.",Ta,Ht,yo="<strong>Collecting a Dataset for the reward classifier</strong>",ha,Wt,To="Before training, you need to collect a dataset with labeled examples. The <code>record_dataset</code> function in <code>gym_manipulator.py</code> enables the process of collecting a dataset of observations, actions, and rewards.",Ja,Lt,ho="To collect a dataset, you need to modify some parameters in the environment configuration based on HILSerlRobotEnvConfig.",ma,Xt,wa,Rt,Jo="<strong>Key Parameters for Data Collection</strong>",da,St,mo="<li><strong>mode</strong>: set it to <code>&quot;record&quot;</code> to collect a dataset (at root level)</li> <li><strong>dataset.repo_id</strong>: <code>&quot;hf_username/dataset_name&quot;</code>, name of the dataset and repo on the hub</li> <li><strong>dataset.num_episodes</strong>: Number of episodes to record</li> <li><strong>env.processor.reset.terminate_on_success</strong>: Whether to automatically terminate episodes when success is detected (default: <code>true</code>)</li> <li><strong>env.fps</strong>: Number of frames per second to record</li> <li><strong>dataset.push_to_hub</strong>: Whether to push the dataset to the hub</li>",Ua,Gt,wo="The <code>env.processor.reset.terminate_on_success</code> parameter allows you to control episode termination behavior. When set to <code>false</code>, episodes will continue even after success is detected, allowing you to collect more positive examples with the reward=1 label. This is crucial for training reward classifiers as it provides more success state examples in your dataset. When set to <code>true</code> (default), episodes terminate immediately upon success detection.",Ia,zt,Uo="<strong>Important</strong>: For reward classifier training, set <code>terminate_on_success: false</code> to collect sufficient positive examples. For regular HIL-SERL training, keep it as <code>true</code> to enable automatic episode termination when the task is completed successfully.",fa,Vt,Io="Example configuration section for data collection:",Ca,Yt,ba,Ft,fo="<strong>Reward Classifier Configuration</strong>",ga,Pt,Co="The reward classifier is configured using <code>configuration_classifier.py</code>. Here are the key parameters:",va,Dt,bo="<li><strong>model_name</strong>: Base model architecture (e.g., we mainly use <code>&quot;helper2424/resnet10&quot;</code>)</li> <li><strong>model_type</strong>: <code>&quot;cnn&quot;</code> or <code>&quot;transformer&quot;</code></li> <li><strong>num_cameras</strong>: Number of camera inputs</li> <li><strong>num_classes</strong>: Number of output classes (typically 2 for binary success/failure)</li> <li><strong>hidden_dim</strong>: Size of hidden representation</li> <li><strong>dropout_rate</strong>: Regularization parameter</li> <li><strong>learning_rate</strong>: Learning rate for optimizer</li>",Aa,Ot,go='Example configuration for training the <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/reward_classifier_train_config.json" rel="nofollow">reward classifier</a>:',Ba,Kt,_a,sl,vo="<strong>Training the Classifier</strong>",Za,tl,Ao="To train the classifier, use the <code>train.py</code> script with your configuration:",Ea,ll,Na,nl,Bo="<strong>Deploying and Testing the Model</strong>",$a,el,_o="To use your trained reward classifier, configure the <code>HILSerlRobotEnvConfig</code> to use your model:",qa,al,xa,pl,Zo="or set the argument in the json config file.",Qa,il,ka,ol,Eo="Run <code>gym_manipulator.py</code> to test the model.",Ha,cl,Wa,rl,No="The reward classifier will automatically provide rewards based on the visual input from the robot’s cameras.",La,Ml,$o="<strong>Example Workflow for training the reward classifier</strong>",Xa,w,ln,qo=`<p><strong>Create the configuration files</strong>:
Create the necessary json configuration files for the reward classifier and the environment. Check the examples <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/tree/main" rel="nofollow">here</a>.</p>`,xp,ul,nn,xo="<strong>Collect a dataset</strong>:",Qp,jl,kp,yl,en,Qo="<strong>Train the classifier</strong>:",Hp,Tl,Wp,hl,an,ko="<strong>Test the classifier</strong>:",Lp,Jl,Ra,ml,Sa,wl,Ho="The LeRobot system uses a distributed actor-learner architecture for training. This architecture decouples robot interactions from the learning process, allowing them to run concurrently without blocking each other. The actor server handles robot observations and actions, sending interaction data to the learner server. The learner server performs gradient descent and periodically updates the actor’s policy weights. You will need to start two processes: a learner and an actor.",Ga,dl,Wo="<strong>Configuration Setup</strong>",za,Ul,Lo='Create a training configuration file (example available <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/train_config_hilserl_so100.json" rel="nofollow">here</a>). The training config is based on the main <code>TrainRLServerPipelineConfig</code> class in <code>lerobot/configs/train.py</code>.',Va,Il,Xo='<li>Configure the policy settings (<code>type=&quot;sac&quot;</code>, <code>device</code>, etc.)</li> <li>Set <code>dataset</code> to your cropped dataset</li> <li>Configure environment settings with crop parameters</li> <li>Check the other parameters related to SAC in <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/policies/sac/configuration_sac.py#L79" rel="nofollow">configuration_sac.py</a>.</li> <li>Verify that the <code>policy</code> config is correct with the right <code>input_features</code> and <code>output_features</code> for your task.</li>',Ya,fl,Ro="<strong>Starting the Learner</strong>",Fa,Cl,So="First, start the learner server process:",Pa,bl,Da,gl,Go="The learner:",Oa,vl,zo="<li>Initializes the policy network</li> <li>Prepares replay buffers</li> <li>Opens a <code>gRPC</code> server to communicate with actors</li> <li>Processes transitions and updates the policy</li>",Ka,Al,Vo="<strong>Starting the Actor</strong>",sp,Bl,Yo="In a separate terminal, start the actor process with the same configuration:",tp,_l,lp,Zl,Fo="The actor:",np,El,Po="<li>Connects to the learner via <code>gRPC</code></li> <li>Initializes the environment</li> <li>Execute rollouts of the policy to collect experience</li> <li>Sends transitions to the learner</li> <li>Receives updated policy parameters</li>",ep,Nl,Do="<strong>Training Flow</strong>",ap,$l,Oo="The training proceeds automatically:",pp,ql,Ko="<li>The actor executes the policy in the environment</li> <li>Transitions are collected and sent to the learner</li> <li>The learner updates the policy based on these transitions</li> <li>Updated policy parameters are sent back to the actor</li> <li>The process continues until the specified step limit is reached</li>",ip,xl,sc="<strong>Human in the Loop</strong>",op,Ql,tc="<li>The key to learning efficiently is to have human interventions to provide corrective feedback and completing the task to aide the policy learning and exploration.</li> <li>To perform human interventions, you can press the upper right trigger button on the gamepad (or the <code>space</code> key on the keyboard). This will pause the policy actions and allow you to take over.</li> <li>A successful experiment is one where the human has to intervene at the start but then reduces the amount of interventions as the policy improves. You can monitor the intervention rate in the <code>wandb</code> dashboard.</li>",cp,_,lc='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hil_effect.png?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',rp,Z,nc="<i>Example showing how human interventions help guide policy learning over time</i>",Mp,kl,ec="<li>The figure shows the plot of the episodic reward over interaction step. The figure shows the effect of human interventions on the policy learning.</li> <li>The orange curve is an experiment without any human interventions. While the pink and blue curves are experiments with human interventions.</li> <li>We can observe that the number of steps where the policy starts achieving the maximum reward is cut by a quarter when human interventions are present.</li>",up,Hl,ac="<strong>Monitoring and Debugging</strong>",jp,Wl,pc='If you have <code>wandb.enable</code> set to <code>true</code> in your configuration, you can monitor training progress in real-time through the <a href="https://wandb.ai/site/" rel="nofollow">Weights &amp; Biases</a> dashboard.',yp,Ll,Tp,Xl,ic="The learning process is very sensitive to the intervention strategy. It will takes a few runs to understand how to intervene effectively. Some tips and hints:",hp,Rl,oc="<li>Allow the policy to explore for a few episodes at the start of training.</li> <li>Avoid intervening for long periods of time. Try to intervene in situation to correct the robot’s behaviour when it goes off track.</li> <li>Once the policy starts achieving the task, even if its not perfect, you can limit your interventions to simple quick actions like a simple grasping commands.</li>",Jp,Sl,cc="The ideal behaviour is that your intervention rate should drop gradually during training as shown in the figure below.",mp,E,rc='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/intervention_rate_tutorial_rl.png?raw=true" alt="Intervention rate" title="Intervention rate during training" width="100%"/>',wp,N,Mc=`<i>Plot of the intervention rate during a training run on a pick and lift cube
    task</i>`,dp,Gl,Up,zl,uc="Some configuration values have a disproportionate impact on training stability and speed:",Ip,Vl,jc="<li><strong><code>temperature_init</code></strong> (<code>policy.temperature_init</code>) – initial entropy temperature in SAC. Higher values encourage more exploration; lower values make the policy more deterministic early on. A good starting point is <code>1e-2</code>. We observed that setting it too high can make human interventions ineffective and slow down learning.</li> <li><strong><code>policy_parameters_push_frequency</code></strong> (<code>policy.actor_learner_config.policy_parameters_push_frequency</code>) – interval in <em>seconds</em> between two weight pushes from the learner to the actor. The default is <code>4 s</code>. Decrease to <strong>1-2 s</strong> to provide fresher weights (at the cost of more network traffic); increase only if your connection is slow, as this will reduce sample efficiency.</li> <li><strong><code>storage_device</code></strong> (<code>policy.storage_device</code>) – device on which the learner keeps the policy parameters. If you have spare GPU memory, set this to <code>&quot;cuda&quot;</code> (instead of the default <code>&quot;cpu&quot;</code>). Keeping the weights on-GPU removes CPU→GPU transfer overhead and can significantly increase the number of learner updates per second.</li>",fp,Yl,yc="Congrats 🎉, you have finished this tutorial!",Cp,$,bp,Fl,Tc="Paper citation:",gp,Pl,vp,Dl,Ap,pn,Bp;return k=new h({props:{title:"HIL-SERL Real Robot Training Workflow Guide",local:"hil-serl-real-robot-training-workflow-guide",headingTag:"h1"}}),G=new h({props:{title:"What do I need?",local:"what-do-i-need",headingTag:"h2"}}),V=new h({props:{title:"What kind of tasks can I train?",local:"what-kind-of-tasks-can-i-train",headingTag:"h2"}}),P=new h({props:{title:"Install LeRobot with HIL-SERL",local:"install-lerobot-with-hil-serl",headingTag:"h2"}}),O=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmhpbHNlcmwlNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[hilserl]&quot;</span>',wrap:!1}}),K=new h({props:{title:"Real Robot Training Workflow",local:"real-robot-training-workflow",headingTag:"h2"}}),ss=new h({props:{title:"Understanding Configuration",local:"understanding-configuration",headingTag:"h3"}}),ls=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GymManipulatorConfig</span>:
    env: HILSerlRobotEnvConfig    <span class="hljs-comment"># Environment configuration (nested)</span>
    dataset: DatasetConfig    <span class="hljs-comment"># Dataset recording/replay configuration (nested)</span>
    mode: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># &quot;record&quot;, &quot;replay&quot;, or None (for training)</span>
    device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>    <span class="hljs-comment"># Compute device</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HILSerlRobotEnvConfig</span>(<span class="hljs-title class_ inherited__">EnvConfig</span>):
    robot: RobotConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Main robot agent (defined in \`lerobot/robots\`)</span>
    teleop: TeleoperatorConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Teleoperator agent, e.g., gamepad or leader arm</span>
    processor: HILSerlProcessorConfig    <span class="hljs-comment"># Processing pipeline configuration (nested)</span>
    name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;real_robot&quot;</span>    <span class="hljs-comment"># Environment name</span>
    task: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Task identifier</span>
    fps: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>    <span class="hljs-comment"># Control frequency</span>

<span class="hljs-comment"># Nested processor configuration</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">HILSerlProcessorConfig</span>:
    control_mode: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;gamepad&quot;</span>    <span class="hljs-comment"># Control mode</span>
    observation: ObservationConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Observation processing settings</span>
    image_preprocessing: ImagePreprocessingConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Image crop/resize settings</span>
    gripper: GripperConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Gripper control and penalty settings</span>
    reset: ResetConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Environment reset and timing settings</span>
    inverse_kinematics: InverseKinematicsConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># IK processing settings</span>
    reward_classifier: RewardClassifierConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Reward classifier settings</span>
    max_gripper_pos: <span class="hljs-built_in">float</span> | <span class="hljs-literal">None</span> = <span class="hljs-number">100.0</span>    <span class="hljs-comment"># Maximum gripper position</span>

<span class="hljs-comment"># Sub-configuration classes</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ObservationConfig</span>:
    add_joint_velocity_to_observation: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Add joint velocities to state</span>
    add_current_to_observation: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Add motor currents to state</span>
    add_ee_pose_to_observation: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Add end-effector pose to state</span>
    display_cameras: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Display camera feeds during execution</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImagePreprocessingConfig</span>:
    crop_params_dict: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">tuple</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>]] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Image cropping parameters</span>
    resize_size: <span class="hljs-built_in">tuple</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Target image size</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">GripperConfig</span>:
    use_gripper: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>    <span class="hljs-comment"># Enable gripper control</span>
    gripper_penalty: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.0</span>    <span class="hljs-comment"># Penalty for inappropriate gripper usage</span>
    gripper_penalty_in_reward: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Include gripper penalty in reward</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResetConfig</span>:
    fixed_reset_joint_positions: <span class="hljs-type">Any</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Joint positions for reset</span>
    reset_time_s: <span class="hljs-built_in">float</span> = <span class="hljs-number">5.0</span>    <span class="hljs-comment"># Time to wait during reset</span>
    control_time_s: <span class="hljs-built_in">float</span> = <span class="hljs-number">20.0</span>    <span class="hljs-comment"># Maximum episode duration</span>
    terminate_on_success: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>    <span class="hljs-comment"># Whether to terminate episodes on success detection</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">InverseKinematicsConfig</span>:
    urdf_path: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Path to robot URDF file</span>
    target_frame_name: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># End-effector frame name</span>
    end_effector_bounds: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># EE workspace bounds</span>
    end_effector_step_sizes: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">float</span>] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># EE step sizes per axis</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RewardClassifierConfig</span>:
    pretrained_path: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Path to pretrained reward classifier</span>
    success_threshold: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.5</span>    <span class="hljs-comment"># Success detection threshold</span>
    success_reward: <span class="hljs-built_in">float</span> = <span class="hljs-number">1.0</span>    <span class="hljs-comment"># Reward value for successful episodes</span>

<span class="hljs-comment"># Dataset configuration</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DatasetConfig</span>:
    repo_id: <span class="hljs-built_in">str</span>    <span class="hljs-comment"># LeRobot dataset repository ID</span>
    dataset_root: <span class="hljs-built_in">str</span>    <span class="hljs-comment"># Local dataset root directory</span>
    task: <span class="hljs-built_in">str</span>    <span class="hljs-comment"># Task identifier</span>
    num_episodes: <span class="hljs-built_in">int</span>    <span class="hljs-comment"># Number of episodes for recording</span>
    episode: <span class="hljs-built_in">int</span>    <span class="hljs-comment"># Episode index for replay</span>
    push_to_hub: <span class="hljs-built_in">bool</span>    <span class="hljs-comment"># Whether to push datasets to Hub</span>`,wrap:!1}}),ns=new h({props:{title:"Processor Pipeline Architecture",local:"processor-pipeline-architecture",headingTag:"h3"}}),as=new h({props:{title:"Environment Processor Pipeline",local:"environment-processor-pipeline",headingTag:"h4"}}),os=new h({props:{title:"Action Processor Pipeline",local:"action-processor-pipeline",headingTag:"h4"}}),Ms=new h({props:{title:"Configuration Examples",local:"configuration-examples",headingTag:"h4"}}),js=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRfam9pbnRfdmVsb2NpdHlfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWRkX2N1cnJlbnRfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRpc3BsYXlfY2FtZXJhcyUyMiUzQSUyMGZhbHNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;add_joint_velocity_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;add_current_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;display_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ts=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfcHJlcHJvY2Vzc2luZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNyb3BfcGFyYW1zX2RpY3QlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuZnJvbnQlMjIlM0ElMjAlNUIxODAlMkMlMjAyNTAlMkMlMjAxMjAlMkMlMjAxNTAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2l6ZV9zaXplJTIyJTNBJTIwJTVCMTI4JTJDJTIwMTI4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;image_preprocessing&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">250</span><span class="hljs-punctuation">,</span> <span class="hljs-number">120</span><span class="hljs-punctuation">,</span> <span class="hljs-number">150</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">207</span><span class="hljs-punctuation">,</span> <span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">200</span><span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Js=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW52ZXJzZV9raW5lbWF0aWNzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXJkZl9wYXRoJTIyJTNBJTIwJTIycGF0aCUyRnRvJTJGcm9ib3QudXJkZiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRhcmdldF9mcmFtZV9uYW1lJTIyJTNBJTIwJTIyZW5kX2VmZmVjdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5kX2VmZmVjdG9yX2JvdW5kcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbiUyMiUzQSUyMCU1QjAuMTYlMkMlMjAtMC4wOCUyQyUyMDAuMDMlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXglMjIlM0ElMjAlNUIwLjI0JTJDJTIwMC4yJTJDJTIwMC4xJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5kX2VmZmVjdG9yX3N0ZXBfc2l6ZXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ4JTIyJTNBJTIwMC4wMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnklMjIlM0ElMjAwLjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;inverse_kinematics&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;urdf_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;path/to/robot.urdf&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;target_frame_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;end_effector&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;end_effector_bounds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;min&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.16</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-0.08</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.03</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;max&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.24</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.2</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.1</span><span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;end_effector_step_sizes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;x&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.02</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;y&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.02</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;z&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.02</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ms=new h({props:{title:"Advanced Observation Processing",local:"advanced-observation-processing",headingTag:"h3"}}),ds=new h({props:{title:"Joint Velocity Processing",local:"joint-velocity-processing",headingTag:"h4"}}),Is=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRfam9pbnRfdmVsb2NpdHlfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;add_joint_velocity_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),bs=new h({props:{title:"Motor Current Processing",local:"motor-current-processing",headingTag:"h4"}}),vs=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRfY3VycmVudF90b19vYnNlcnZhdGlvbiUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;add_current_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_s=new h({props:{title:"Combined Observation Processing",local:"combined-observation-processing",headingTag:"h4"}}),Es=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRfam9pbnRfdmVsb2NpdHlfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWRkX2N1cnJlbnRfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWRkX2VlX3Bvc2VfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRpc3BsYXlfY2FtZXJhcyUyMiUzQSUyMGZhbHNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;add_joint_velocity_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;add_current_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;add_ee_pose_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;display_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$s=new h({props:{title:"Finding Robot Workspace Bounds",local:"finding-robot-workspace-bounds",headingTag:"h3"}}),Hs=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMuZmluZF9qb2ludF9saW1pdHMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJvYm90LnR5cGUlM0RzbzEwMF9mb2xsb3dlciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9ib3QucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NzYwNDMxNTQxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yb2JvdC5pZCUzRGJsYWNrJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZWxlb3AudHlwZSUzRHNvMTAwX2xlYWRlciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLnBvcnQlM0QlMkZkZXYlMkZ0dHkudXNibW9kZW01ODc2MDQzMTU1MSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLmlkJTNEYmx1ZQ==",highlighted:`python -m lerobot.scripts.find_joint_limits \\
    --robot.type=so100_follower \\
    --robot.port=/dev/tty.usbmodem58760431541 \\
    --robot.id=black \\
    --teleop.type=so100_leader \\
    --teleop.port=/dev/tty.usbmodem58760431551 \\
    --teleop.id=blue`,wrap:!1}}),Ls=new T({props:{code:"TWF4JTIwZWUlMjBwb3NpdGlvbiUyMCU1QjAuMjQxNyUyMDAuMjAxMiUyMDAuMTAyNyU1RCUwQU1pbiUyMGVlJTIwcG9zaXRpb24lMjAlNUIwLjE2NjMlMjAtMC4wODIzJTIwMC4wMzM2JTVEJTBBTWF4JTIwam9pbnQlMjBwb3NpdGlvbnMlMjAlNUItMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlMkMlMjAtMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlNUQlMEFNaW4lMjBqb2ludCUyMHBvc2l0aW9ucyUyMCU1QjUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCUyQyUyMDUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCU1RA==",highlighted:`Max ee position [0.2417 0.2012 0.1027]
Min ee position [0.1663 <span class="hljs-string">-0</span>.0823 0.0336]
Max joint positions [<span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0]
Min joint positions [50.0, 50.0, 50.0, 50.0, 50.0, 50.0]`,wrap:!1}}),Rs=new T({props:{code:"JTIyZW5kX2VmZmVjdG9yX2JvdW5kcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1heCUyMiUzQSUyMCU1QjAuMjQlMkMlMjAwLjIwJTJDJTIwMC4xMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1pbiUyMiUzQSUyMCU1QjAuMTYlMkMlMjAtMC4wOCUyQyUyMDAuMDMlNUQlMEElN0Q=",highlighted:`<span class="hljs-attr">&quot;end_effector_bounds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;max&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.24</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.20</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.10</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;min&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.16</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-0.08</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.03</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ss=new h({props:{title:"Collecting Demonstrations",local:"collecting-demonstrations",headingTag:"h3"}}),Ps=new T({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;real_robot&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;display_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;image_preprocessing&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;gripper_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;reset_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5.0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;control_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20.0</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;robot&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-comment">// ... robot configuration ...</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-comment">// ... teleoperator configuration ...</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;username/pick_lift_cube&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pick_and_lift&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ds=new h({props:{title:"Using a Teleoperation Device",local:"using-a-teleoperation-device",headingTag:"h3"}}),tt=new T({props:{code:"Y2xhc3MlMjBTTzEwMEZvbGxvd2VyRW5kRWZmZWN0b3JDb25maWcoU08xMDBGb2xsb3dlckNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDb25maWd1cmF0aW9uJTIwZm9yJTIwdGhlJTIwU08xMDBGb2xsb3dlckVuZEVmZmVjdG9yJTIwcm9ib3QuJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRGVmYXVsdCUyMGJvdW5kcyUyMGZvciUyMHRoZSUyMGVuZC1lZmZlY3RvciUyMHBvc2l0aW9uJTIwKGluJTIwbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9ib3VuZHMlM0ElMjBkaWN0JTVCc3RyJTJDJTIwbGlzdCU1QmZsb2F0JTVEJTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwYm91bmRzJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtaW4lMjIlM0ElMjAlNUItMS4wJTJDJTIwLTEuMCUyQyUyMC0xLjAlNUQlMkMlMjAlMjAlMjMlMjBtaW4lMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXglMjIlM0ElMjAlNUIxLjAlMkMlMjAxLjAlMkMlMjAxLjAlNUQlMkMlMjAlMjAlMjMlMjBtYXglMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwbWF4X2dyaXBwZXJfcG9zJTNBJTIwZmxvYXQlMjAlM0QlMjA1MCUyMCUyMyUyMG1heGltdW0lMjBncmlwcGVyJTIwcG9zaXRpb24lMjB0aGF0JTIwdGhlJTIwZ3JpcHBlciUyMHdpbGwlMjBiZSUyMG9wZW4lMjBhdCUwQSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9zdGVwX3NpemVzJTNBJTIwZGljdCU1QnN0ciUyQyUyMGZsb2F0JTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwbWF4aW11bSUyMHN0ZXAlMjBzaXplJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ4JTIyJTNBJTIwMC4wMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnklMjIlM0ElMjAwLjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SO100FollowerEndEffectorConfig</span>(<span class="hljs-title class_ inherited__">SO100FollowerConfig</span>):
    <span class="hljs-string">&quot;&quot;&quot;Configuration for the SO100FollowerEndEffector robot.&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Default bounds for the end-effector position (in meters)</span>
    end_effector_bounds: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]] = field( <span class="hljs-comment"># bounds for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;min&quot;</span>: [-<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>],  <span class="hljs-comment"># min x, y, z</span>
            <span class="hljs-string">&quot;max&quot;</span>: [<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>],  <span class="hljs-comment"># max x, y, z</span>
        }
    )

    max_gripper_pos: <span class="hljs-built_in">float</span> = <span class="hljs-number">50</span> <span class="hljs-comment"># maximum gripper position that the gripper will be open at</span>

    end_effector_step_sizes: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">float</span>] = field( <span class="hljs-comment"># maximum step size for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;x&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;y&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;z&quot;</span>: <span class="hljs-number">0.02</span>,
        }
    )`,wrap:!1}}),pt=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmdhbWVwYWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJwcm9jZXNzb3IlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250cm9sX21vZGUlMjIlM0ElMjAlMjJnYW1lcGFkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ3JpcHBlciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVzZV9ncmlwcGVyJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),rt=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnNvMTAxX2xlYWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnBvcnQlMjIlM0ElMjAlMjIlMkZkZXYlMkZ0dHkudXNibW9kZW01ODVBMDA3NzkyMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnVzZV9kZWdyZWVzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnByb2Nlc3NvciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRyb2xfbW9kZSUyMiUzQSUyMCUyMmxlYWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmdyaXBwZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;so101_leader&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;port&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/dev/tty.usbmodem585A0077921&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;use_degrees&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;leader&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Tt=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZ19zbzEwMC5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config_so100.json",wrap:!1}}),mt=new h({props:{title:"Processing the Dataset",local:"processing-the-dataset",headingTag:"h3"}}),bt=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuY3JvcF9kYXRhc2V0X3JvaSUyMC0tcmVwby1pZCUyMHVzZXJuYW1lJTJGcGlja19saWZ0X2N1YmU=",highlighted:"python -m lerobot.scripts.rl.crop_dataset_roi --repo-id username/pick_lift_cube",wrap:!1}}),At=new T({props:{code:"U2VsZWN0ZWQlMjBSZWN0YW5ndWxhciUyMFJlZ2lvbnMlMjBvZiUyMEludGVyZXN0JTIwKHRvcCUyQyUyMGxlZnQlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklM0ElMEFvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUwQW9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUzQSUyMCU1QjE4MCUyQyUyMDI1MCUyQyUyMDEyMCUyQyUyMDE1MCU1RA==",highlighted:`Selected Rectangular Regions of Interest (<span class="hljs-attribute">top</span>, left, height, width):
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.side</span>: <span class="hljs-selector-attr">[180, 207, 180, 200]</span>
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.front</span>: <span class="hljs-selector-attr">[180, 250, 120, 150]</span>`,wrap:!1}}),Zt=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfcHJlcHJvY2Vzc2luZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNyb3BfcGFyYW1zX2RpY3QlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUyMiUzQSUyMCU1QjE4MCUyQyUyMDI1MCUyQyUyMDEyMCUyQyUyMDE1MCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2l6ZV9zaXplJTIyJTNBJTIwJTVCMTI4JTJDJTIwMTI4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;image_preprocessing&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">207</span><span class="hljs-punctuation">,</span> <span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">200</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">250</span><span class="hljs-punctuation">,</span> <span class="hljs-number">120</span><span class="hljs-punctuation">,</span> <span class="hljs-number">150</span><span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$t=new h({props:{title:"Training a Reward Classifier",local:"training-a-reward-classifier",headingTag:"h3"}}),Xt=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGcmV3YXJkX2NsYXNzaWZpZXJfdHJhaW5fY29uZmlnLmpzb24=",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),Yt=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmd5bV9tYW5pcHVsYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJyZWFsX3JvYm90JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnBzJTIyJTNBJTIwMTAlMkMlMEElMjAlMjAlMjAlMjAlMjJwcm9jZXNzb3IlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2V0X3RpbWVfcyUyMiUzQSUyMDUuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRyb2xfdGltZV9zJTIyJTNBJTIwMjAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlcm1pbmF0ZV9vbl9zdWNjZXNzJTIyJTNBJTIwZmFsc2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJncmlwcGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXNlX2dyaXBwZXIlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIycm9ib3QlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjAuLi4lMjByb2JvdCUyMGNvbmZpZ3VyYXRpb24lMjAuLi4lMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZWxlb3AlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjAuLi4lMjB0ZWxlb3BlcmF0b3IlMjBjb25maWd1cmF0aW9uJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyZGF0YXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjAlMjJoZl91c2VybmFtZSUyRmRhdGFzZXRfbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmRhdGFzZXRfcm9vdCUyMiUzQSUyMCUyMmRhdGElMkZ5b3VyX2RhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTIycmV3YXJkX2NsYXNzaWZpZXJfdGFzayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV9lcGlzb2RlcyUyMiUzQSUyMDIwJTJDJTBBJTIwJTIwJTIwJTIwJTIyZXBpc29kZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJwdXNoX3RvX2h1YiUyMiUzQSUyMHRydWUlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJtb2RlJTIyJTNBJTIwJTIycmVjb3JkJTIyJTJDJTBBJTIwJTIwJTIyZGV2aWNlJTIyJTNBJTIwJTIyY3B1JTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;real_robot&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;reset_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5.0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;control_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20.0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;terminate_on_success&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;robot&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-comment">// ... robot configuration ...</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-comment">// ... teleoperator configuration ...</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;hf_username/dataset_name&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;data/your_dataset&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;reward_classifier_task&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Kt=new T({props:{code:"JTdCJTBBJTIwJTIwJTIycG9saWN5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnJld2FyZF9jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMmhlbHBlcjI0MjQlMkZyZXNuZXQxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX3R5cGUlMjIlM0ElMjAlMjJjbm4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2FtZXJhcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2xhc3NlcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJoaWRkZW5fZGltJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIyZHJvcG91dF9yYXRlJTIyJTNBJTIwMC4xJTJDJTBBJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXNlX2FtcCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;policy&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;reward_classifier&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;helper2424/resnet10&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cnn&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_classes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;hidden_dim&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dropout_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;learning_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-4</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cuda&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;use_amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;input_features&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ll=new T({props:{code:"bGVyb2JvdC10cmFpbiUyMC0tY29uZmlnX3BhdGglMjBwYXRoJTJGdG8lMkZyZXdhcmRfY2xhc3NpZmllcl90cmFpbl9jb25maWcuanNvbg==",highlighted:"lerobot-train --config_path path/to/reward_classifier_train_config.json",wrap:!1}}),al=new T({props:{code:"Y29uZmlnJTIwJTNEJTIwR3ltTWFuaXB1bGF0b3JDb25maWcoJTBBJTIwJTIwJTIwJTIwZW52JTNESElMU2VybFJvYm90RW52Q29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2Nlc3NvciUzREhJTFNlcmxQcm9jZXNzb3JDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkX2NsYXNzaWZpZXIlM0RSZXdhcmRDbGFzc2lmaWVyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXRyYWluZWRfcGF0aCUzRCUyMnBhdGhfdG9feW91cl9wcmV0cmFpbmVkX3RyYWluZWRfbW9kZWwlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME90aGVyJTIwZW52aXJvbm1lbnQlMjBwYXJhbWV0ZXJzJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0REYXRhc2V0Q29uZmlnKC4uLiklMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNETm9uZSUyMCUyMCUyMyUyMEZvciUyMHRyYWluaW5nJTBBKQ==",highlighted:`config = GymManipulatorConfig(
    env=HILSerlRobotEnvConfig(
        processor=HILSerlProcessorConfig(
            reward_classifier=RewardClassifierConfig(
                pretrained_path=<span class="hljs-string">&quot;path_to_your_pretrained_trained_model&quot;</span>
            )
        ),
        <span class="hljs-comment"># Other environment parameters</span>
    ),
    dataset=DatasetConfig(...),
    mode=<span class="hljs-literal">None</span>  <span class="hljs-comment"># For training</span>
)`,wrap:!1}}),il=new T({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmV3YXJkX2NsYXNzaWZpZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwcmV0cmFpbmVkX3BhdGglMjIlM0ElMjAlMjJwYXRoX3RvX3lvdXJfcHJldHJhaW5lZF9tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN1Y2Nlc3NfdGhyZXNob2xkJTIyJTNBJTIwMC43JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VjY2Vzc19yZXdhcmQlMjIlM0ElMjAxLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlcm1pbmF0ZV9vbl9zdWNjZXNzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;reward_classifier&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;pretrained_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;path_to_your_pretrained_model&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;success_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;success_reward&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;terminate_on_success&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),cl=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHBhdGglMkZ0byUyRmVudl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path path/to/env_config.json",wrap:!1}}),jl=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZy5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),Tl=new T({props:{code:"bGVyb2JvdC10cmFpbiUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRnJld2FyZF9jbGFzc2lmaWVyX3RyYWluX2NvbmZpZy5qc29u",highlighted:"lerobot-train --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),Jl=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZy5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),ml=new h({props:{title:"Training with Actor-Learner",local:"training-with-actor-learner",headingTag:"h3"}}),bl=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwubGVhcm5lciUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRnRyYWluX2NvbmZpZ19oaWxzZXJsX3NvMTAwLmpzb24=",highlighted:"python -m lerobot.scripts.rl.learner --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),_l=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuYWN0b3IlMjAtLWNvbmZpZ19wYXRoJTIwc3JjJTJGbGVyb2JvdCUyRmNvbmZpZ3MlMkZ0cmFpbl9jb25maWdfaGlsc2VybF9zbzEwMC5qc29u",highlighted:"python -m lerobot.scripts.rl.actor --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),Ll=new h({props:{title:"Guide to Human Interventions",local:"guide-to-human-interventions",headingTag:"h3"}}),Gl=new h({props:{title:"Key hyperparameters to tune",local:"key-hyperparameters-to-tune",headingTag:"h3"}}),$=new Cc({props:{warning:!1,$$slots:{default:[gc]},$$scope:{ctx:on}}}),Pl=new T({props:{code:"JTQwYXJ0aWNsZSU3Qmx1bzIwMjRwcmVjaXNlJTJDJTBBJTIwJTIwdGl0bGUlM0QlN0JQcmVjaXNlJTIwYW5kJTIwRGV4dGVyb3VzJTIwUm9ib3RpYyUyME1hbmlwdWxhdGlvbiUyMHZpYSUyMEh1bWFuLWluLXRoZS1Mb29wJTIwUmVpbmZvcmNlbWVudCUyMExlYXJuaW5nJTdEJTJDJTBBJTIwJTIwYXV0aG9yJTNEJTdCTHVvJTJDJTIwSmlhbmxhbiUyMGFuZCUyMFh1JTJDJTIwQ2hhcmxlcyUyMGFuZCUyMFd1JTJDJTIwSmVmZnJleSUyMGFuZCUyMExldmluZSUyQyUyMFNlcmdleSU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlM0QlN0JhclhpdiUyMHByZXByaW50JTIwYXJYaXYlM0EyNDEwLjIxODQ1JTdEJTJDJTBBJTIwJTIweWVhciUzRCU3QjIwMjQlN0QlMEElN0Q=",highlighted:`@article{luo2024precise,
  title={Precise <span class="hljs-keyword">and </span>Dexterous Robotic Manipulation via Human-in-the-Loop Reinforcement Learning},
  author={Luo, <span class="hljs-keyword">Jianlan </span><span class="hljs-keyword">and </span>Xu, Charles <span class="hljs-keyword">and </span>Wu, <span class="hljs-keyword">Jeffrey </span><span class="hljs-keyword">and </span>Levine, Sergey},
  <span class="hljs-keyword">journal={arXiv </span>preprint arXiv:<span class="hljs-number">2410</span>.<span class="hljs-number">21845</span>},
  year={<span class="hljs-number">2024</span>}
}`,wrap:!1}}),Dl=new bc({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/hilserl.mdx"}}),{c(){m=p("meta"),Q=e(),U=p("p"),Ol=e(),c(k.$$.fragment),cn=e(),H=p("p"),H.textContent=Rp,rn=e(),W=p("p"),W.textContent=Sp,Mn=e(),L=p("p"),L.textContent=Gp,un=e(),X=p("ol"),X.innerHTML=zp,jn=e(),R=p("p"),R.textContent=Vp,yn=e(),C=p("p"),C.innerHTML=Yp,Tn=e(),b=p("p"),b.innerHTML=Fp,hn=e(),S=p("p"),S.textContent=Pp,Jn=e(),c(G.$$.fragment),mn=e(),z=p("ul"),z.innerHTML=Dp,wn=e(),c(V.$$.fragment),dn=e(),Y=p("p"),Y.textContent=Op,Un=e(),F=p("ul"),F.innerHTML=Kp,In=e(),c(P.$$.fragment),fn=e(),D=p("p"),D.innerHTML=si,Cn=e(),c(O.$$.fragment),bn=e(),c(K.$$.fragment),gn=e(),c(ss.$$.fragment),vn=e(),ts=p("p"),ts.innerHTML=ti,An=e(),c(ls.$$.fragment),Bn=e(),c(ns.$$.fragment),_n=e(),es=p("p"),es.textContent=li,Zn=e(),c(as.$$.fragment),En=e(),ps=p("p"),ps.innerHTML=ni,Nn=e(),is=p("ol"),is.innerHTML=ei,$n=e(),c(os.$$.fragment),qn=e(),cs=p("p"),cs.innerHTML=ai,xn=e(),rs=p("ol"),rs.innerHTML=pi,Qn=e(),c(Ms.$$.fragment),kn=e(),us=p("p"),us.innerHTML=ii,Hn=e(),c(js.$$.fragment),Wn=e(),ys=p("p"),ys.innerHTML=oi,Ln=e(),c(Ts.$$.fragment),Xn=e(),hs=p("p"),hs.innerHTML=ci,Rn=e(),c(Js.$$.fragment),Sn=e(),c(ms.$$.fragment),Gn=e(),ws=p("p"),ws.textContent=ri,zn=e(),c(ds.$$.fragment),Vn=e(),Us=p("p"),Us.textContent=Mi,Yn=e(),c(Is.$$.fragment),Fn=e(),fs=p("p"),fs.textContent=ui,Pn=e(),Cs=p("ul"),Cs.innerHTML=ji,Dn=e(),c(bs.$$.fragment),On=e(),gs=p("p"),gs.textContent=yi,Kn=e(),c(vs.$$.fragment),se=e(),As=p("p"),As.textContent=Ti,te=e(),Bs=p("ul"),Bs.innerHTML=hi,le=e(),c(_s.$$.fragment),ne=e(),Zs=p("p"),Zs.textContent=Ji,ee=e(),c(Es.$$.fragment),ae=e(),Ns=p("p"),Ns.innerHTML=mi,pe=e(),c($s.$$.fragment),ie=e(),qs=p("p"),qs.textContent=wi,oe=e(),xs=p("p"),xs.textContent=di,ce=e(),Qs=p("p"),Qs.innerHTML=Ui,re=e(),ks=p("p"),ks.textContent=Ii,Me=e(),c(Hs.$$.fragment),ue=e(),Ws=p("p"),Ws.innerHTML=fi,je=e(),I=p("ol"),Kl=p("li"),Kl.textContent=Ci,Np=e(),sn=p("li"),$p=Uc(`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),c(Ls.$$.fragment),qp=e(),tn=p("li"),tn.innerHTML=bi,ye=e(),Xs=p("p"),Xs.innerHTML=gi,Te=e(),c(Rs.$$.fragment),he=e(),c(Ss.$$.fragment),Je=e(),Gs=p("p"),Gs.textContent=vi,me=e(),zs=p("p"),zs.innerHTML=Ai,we=e(),Vs=p("p"),Vs.innerHTML=Bi,de=e(),Ys=p("ol"),Ys.innerHTML=_i,Ue=e(),Fs=p("p"),Fs.textContent=Zi,Ie=e(),c(Ps.$$.fragment),fe=e(),c(Ds.$$.fragment),Ce=e(),Os=p("p"),Os.textContent=Ei,be=e(),Ks=p("p"),Ks.textContent=Ni,ge=e(),st=p("p"),st.innerHTML=$i,ve=e(),c(tt.$$.fragment),Ae=e(),lt=p("p"),lt.innerHTML=qi,Be=e(),nt=p("p"),nt.innerHTML=xi,_e=e(),et=p("p"),et.textContent=Qi,Ze=e(),at=p("p"),at.innerHTML=ki,Ee=e(),c(pt.$$.fragment),Ne=e(),g=p("p"),g.innerHTML=Hi,$e=e(),v=p("p"),v.innerHTML=Wi,qe=e(),it=p("p"),it.innerHTML=Li,xe=e(),ot=p("p"),ot.textContent=Xi,Qe=e(),ct=p("p"),ct.innerHTML=Ri,ke=e(),c(rt.$$.fragment),He=e(),Mt=p("p"),Mt.innerHTML=Si,We=e(),ut=p("details"),ut.innerHTML=Gi,Le=e(),jt=p("p"),jt.innerHTML=zi,Xe=e(),yt=p("p"),yt.innerHTML=Vi,Re=e(),c(Tt.$$.fragment),Se=e(),ht=p("p"),ht.textContent=Yi,Ge=e(),Jt=p("ol"),Jt.innerHTML=Fi,ze=e(),c(mt.$$.fragment),Ve=e(),wt=p("p"),wt.textContent=Pi,Ye=e(),dt=p("p"),dt.textContent=Di,Fe=e(),Ut=p("ul"),Ut.innerHTML=Oi,Pe=e(),It=p("p"),It.innerHTML=Ki,De=e(),ft=p("p"),ft.innerHTML=so,Oe=e(),Ct=p("p"),Ct.innerHTML=to,Ke=e(),c(bt.$$.fragment),sa=e(),gt=p("ol"),gt.innerHTML=lo,ta=e(),vt=p("p"),vt.textContent=no,la=e(),c(At.$$.fragment),na=e(),A=p("p"),A.innerHTML=eo,ea=e(),B=p("p"),B.innerHTML=ao,aa=e(),Bt=p("p"),Bt.innerHTML=po,pa=e(),_t=p("p"),_t.textContent=io,ia=e(),c(Zt.$$.fragment),oa=e(),Et=p("p"),Et.innerHTML=oo,ca=e(),Nt=p("p"),Nt.innerHTML=co,ra=e(),c($t.$$.fragment),Ma=e(),qt=p("p"),qt.textContent=ro,ua=e(),xt=p("p"),xt.textContent=Mo,ja=e(),Qt=p("p"),Qt.innerHTML=uo,ya=e(),kt=p("p"),kt.innerHTML=jo,Ta=e(),Ht=p("p"),Ht.innerHTML=yo,ha=e(),Wt=p("p"),Wt.innerHTML=To,Ja=e(),Lt=p("p"),Lt.textContent=ho,ma=e(),c(Xt.$$.fragment),wa=e(),Rt=p("p"),Rt.innerHTML=Jo,da=e(),St=p("ul"),St.innerHTML=mo,Ua=e(),Gt=p("p"),Gt.innerHTML=wo,Ia=e(),zt=p("p"),zt.innerHTML=Uo,fa=e(),Vt=p("p"),Vt.textContent=Io,Ca=e(),c(Yt.$$.fragment),ba=e(),Ft=p("p"),Ft.innerHTML=fo,ga=e(),Pt=p("p"),Pt.innerHTML=Co,va=e(),Dt=p("ul"),Dt.innerHTML=bo,Aa=e(),Ot=p("p"),Ot.innerHTML=go,Ba=e(),c(Kt.$$.fragment),_a=e(),sl=p("p"),sl.innerHTML=vo,Za=e(),tl=p("p"),tl.innerHTML=Ao,Ea=e(),c(ll.$$.fragment),Na=e(),nl=p("p"),nl.innerHTML=Bo,$a=e(),el=p("p"),el.innerHTML=_o,qa=e(),c(al.$$.fragment),xa=e(),pl=p("p"),pl.textContent=Zo,Qa=e(),c(il.$$.fragment),ka=e(),ol=p("p"),ol.innerHTML=Eo,Ha=e(),c(cl.$$.fragment),Wa=e(),rl=p("p"),rl.textContent=No,La=e(),Ml=p("p"),Ml.innerHTML=$o,Xa=e(),w=p("ol"),ln=p("li"),ln.innerHTML=qo,xp=e(),ul=p("li"),nn=p("p"),nn.innerHTML=xo,Qp=e(),c(jl.$$.fragment),kp=e(),yl=p("li"),en=p("p"),en.innerHTML=Qo,Hp=e(),c(Tl.$$.fragment),Wp=e(),hl=p("li"),an=p("p"),an.innerHTML=ko,Lp=e(),c(Jl.$$.fragment),Ra=e(),c(ml.$$.fragment),Sa=e(),wl=p("p"),wl.textContent=Ho,Ga=e(),dl=p("p"),dl.innerHTML=Wo,za=e(),Ul=p("p"),Ul.innerHTML=Lo,Va=e(),Il=p("ol"),Il.innerHTML=Xo,Ya=e(),fl=p("p"),fl.innerHTML=Ro,Fa=e(),Cl=p("p"),Cl.textContent=So,Pa=e(),c(bl.$$.fragment),Da=e(),gl=p("p"),gl.textContent=Go,Oa=e(),vl=p("ul"),vl.innerHTML=zo,Ka=e(),Al=p("p"),Al.innerHTML=Vo,sp=e(),Bl=p("p"),Bl.textContent=Yo,tp=e(),c(_l.$$.fragment),lp=e(),Zl=p("p"),Zl.textContent=Fo,np=e(),El=p("ul"),El.innerHTML=Po,ep=e(),Nl=p("p"),Nl.innerHTML=Do,ap=e(),$l=p("p"),$l.textContent=Oo,pp=e(),ql=p("ol"),ql.innerHTML=Ko,ip=e(),xl=p("p"),xl.innerHTML=sc,op=e(),Ql=p("ul"),Ql.innerHTML=tc,cp=e(),_=p("p"),_.innerHTML=lc,rp=e(),Z=p("p"),Z.innerHTML=nc,Mp=e(),kl=p("ul"),kl.innerHTML=ec,up=e(),Hl=p("p"),Hl.innerHTML=ac,jp=e(),Wl=p("p"),Wl.innerHTML=pc,yp=e(),c(Ll.$$.fragment),Tp=e(),Xl=p("p"),Xl.textContent=ic,hp=e(),Rl=p("ul"),Rl.innerHTML=oc,Jp=e(),Sl=p("p"),Sl.textContent=cc,mp=e(),E=p("p"),E.innerHTML=rc,wp=e(),N=p("p"),N.innerHTML=Mc,dp=e(),c(Gl.$$.fragment),Up=e(),zl=p("p"),zl.textContent=uc,Ip=e(),Vl=p("ul"),Vl.innerHTML=jc,fp=e(),Yl=p("p"),Yl.textContent=yc,Cp=e(),c($.$$.fragment),bp=e(),Fl=p("p"),Fl.textContent=Tc,gp=e(),c(Pl.$$.fragment),vp=e(),c(Dl.$$.fragment),Ap=e(),pn=p("p"),this.h()},l(s){const t=Ic("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),Q=a(s),U=i(s,"P",{}),x(U).forEach(l),Ol=a(s),r(k.$$.fragment,s),cn=a(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-tip1wc"&&(H.textContent=Rp),rn=a(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-85x4lc"&&(W.textContent=Sp),Mn=a(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-orvej0"&&(L.textContent=Gp),un=a(s),X=i(s,"OL",{"data-svelte-h":!0}),o(X)!=="svelte-1x8sf4s"&&(X.innerHTML=zp),jn=a(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-6ttl9o"&&(R.textContent=Vp),yn=a(s),C=i(s,"P",{align:!0,"data-svelte-h":!0}),o(C)!=="svelte-2ozfa6"&&(C.innerHTML=Yp),Tn=a(s),b=i(s,"P",{align:!0,"data-svelte-h":!0}),o(b)!=="svelte-agh7op"&&(b.innerHTML=Fp),hn=a(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-kh48rx"&&(S.textContent=Pp),Jn=a(s),r(G.$$.fragment,s),mn=a(s),z=i(s,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-st8mkn"&&(z.innerHTML=Dp),wn=a(s),r(V.$$.fragment,s),dn=a(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-12wjggm"&&(Y.textContent=Op),Un=a(s),F=i(s,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-1xew5vn"&&(F.innerHTML=Kp),In=a(s),r(P.$$.fragment,s),fn=a(s),D=i(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-punxaj"&&(D.innerHTML=si),Cn=a(s),r(O.$$.fragment,s),bn=a(s),r(K.$$.fragment,s),gn=a(s),r(ss.$$.fragment,s),vn=a(s),ts=i(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-i4i1db"&&(ts.innerHTML=ti),An=a(s),r(ls.$$.fragment,s),Bn=a(s),r(ns.$$.fragment,s),_n=a(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-t3kexy"&&(es.textContent=li),Zn=a(s),r(as.$$.fragment,s),En=a(s),ps=i(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-12gy7f5"&&(ps.innerHTML=ni),Nn=a(s),is=i(s,"OL",{"data-svelte-h":!0}),o(is)!=="svelte-tlxv27"&&(is.innerHTML=ei),$n=a(s),r(os.$$.fragment,s),qn=a(s),cs=i(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1asy0ii"&&(cs.innerHTML=ai),xn=a(s),rs=i(s,"OL",{"data-svelte-h":!0}),o(rs)!=="svelte-1tb8at8"&&(rs.innerHTML=pi),Qn=a(s),r(Ms.$$.fragment,s),kn=a(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-knexnm"&&(us.innerHTML=ii),Hn=a(s),r(js.$$.fragment,s),Wn=a(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-wdd8kr"&&(ys.innerHTML=oi),Ln=a(s),r(Ts.$$.fragment,s),Xn=a(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-c3vsy6"&&(hs.innerHTML=ci),Rn=a(s),r(Js.$$.fragment,s),Sn=a(s),r(ms.$$.fragment,s),Gn=a(s),ws=i(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-gdmfb"&&(ws.textContent=ri),zn=a(s),r(ds.$$.fragment,s),Vn=a(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-14792dc"&&(Us.textContent=Mi),Yn=a(s),r(Is.$$.fragment,s),Fn=a(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-8sqcpy"&&(fs.textContent=ui),Pn=a(s),Cs=i(s,"UL",{"data-svelte-h":!0}),o(Cs)!=="svelte-s07ppm"&&(Cs.innerHTML=ji),Dn=a(s),r(bs.$$.fragment,s),On=a(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-1p9befs"&&(gs.textContent=yi),Kn=a(s),r(vs.$$.fragment,s),se=a(s),As=i(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-8sqcpy"&&(As.textContent=Ti),te=a(s),Bs=i(s,"UL",{"data-svelte-h":!0}),o(Bs)!=="svelte-1t8tsrc"&&(Bs.innerHTML=hi),le=a(s),r(_s.$$.fragment,s),ne=a(s),Zs=i(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-1mm601g"&&(Zs.textContent=Ji),ee=a(s),r(Es.$$.fragment,s),ae=a(s),Ns=i(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-1mkidii"&&(Ns.innerHTML=mi),pe=a(s),r($s.$$.fragment,s),ie=a(s),qs=i(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-qhx7nb"&&(qs.textContent=wi),oe=a(s),xs=i(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-13zpkl7"&&(xs.textContent=di),ce=a(s),Qs=i(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-1xbrdof"&&(Qs.innerHTML=Ui),re=a(s),ks=i(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-12g0x8n"&&(ks.textContent=Ii),Me=a(s),r(Hs.$$.fragment,s),ue=a(s),Ws=i(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-133252y"&&(Ws.innerHTML=fi),je=a(s),I=i(s,"OL",{});var f=x(I);Kl=i(f,"LI",{"data-svelte-h":!0}),o(Kl)!=="svelte-jwhws7"&&(Kl.textContent=Ci),Np=a(f),sn=i(f,"LI",{});var Xp=x(sn);$p=fc(Xp,`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),r(Ls.$$.fragment,Xp),Xp.forEach(l),qp=a(f),tn=i(f,"LI",{"data-svelte-h":!0}),o(tn)!=="svelte-1o9aezs"&&(tn.innerHTML=bi),f.forEach(l),ye=a(s),Xs=i(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-9e4z7l"&&(Xs.innerHTML=gi),Te=a(s),r(Rs.$$.fragment,s),he=a(s),r(Ss.$$.fragment,s),Je=a(s),Gs=i(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-1xayq1k"&&(Gs.textContent=vi),me=a(s),zs=i(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-1b1oyiu"&&(zs.innerHTML=Ai),we=a(s),Vs=i(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-1fm14qo"&&(Vs.innerHTML=Bi),de=a(s),Ys=i(s,"OL",{"data-svelte-h":!0}),o(Ys)!=="svelte-1sxmjct"&&(Ys.innerHTML=_i),Ue=a(s),Fs=i(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-gur1fh"&&(Fs.textContent=Zi),Ie=a(s),r(Ps.$$.fragment,s),fe=a(s),r(Ds.$$.fragment,s),Ce=a(s),Os=i(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-1k55eio"&&(Os.textContent=Ei),be=a(s),Ks=i(s,"P",{"data-svelte-h":!0}),o(Ks)!=="svelte-1gu8vct"&&(Ks.textContent=Ni),ge=a(s),st=i(s,"P",{"data-svelte-h":!0}),o(st)!=="svelte-lkgt27"&&(st.innerHTML=$i),ve=a(s),r(tt.$$.fragment,s),Ae=a(s),lt=i(s,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-12kabho"&&(lt.innerHTML=qi),Be=a(s),nt=i(s,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-123qamy"&&(nt.innerHTML=xi),_e=a(s),et=i(s,"P",{"data-svelte-h":!0}),o(et)!=="svelte-q27m3q"&&(et.textContent=Qi),Ze=a(s),at=i(s,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1458spy"&&(at.innerHTML=ki),Ee=a(s),r(pt.$$.fragment,s),Ne=a(s),g=i(s,"P",{align:!0,"data-svelte-h":!0}),o(g)!=="svelte-l7xw97"&&(g.innerHTML=Hi),$e=a(s),v=i(s,"P",{align:!0,"data-svelte-h":!0}),o(v)!=="svelte-i8xgvo"&&(v.innerHTML=Wi),qe=a(s),it=i(s,"P",{"data-svelte-h":!0}),o(it)!=="svelte-17w4vys"&&(it.innerHTML=Li),xe=a(s),ot=i(s,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-1n513na"&&(ot.textContent=Xi),Qe=a(s),ct=i(s,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-fnzfno"&&(ct.innerHTML=Ri),ke=a(s),r(rt.$$.fragment,s),He=a(s),Mt=i(s,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-u9lwpw"&&(Mt.innerHTML=Si),We=a(s),ut=i(s,"DETAILS",{"data-svelte-h":!0}),o(ut)!=="svelte-1raqgp9"&&(ut.innerHTML=Gi),Le=a(s),jt=i(s,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1lumdn2"&&(jt.innerHTML=zi),Xe=a(s),yt=i(s,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-303oat"&&(yt.innerHTML=Vi),Re=a(s),r(Tt.$$.fragment,s),Se=a(s),ht=i(s,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1e9jl8o"&&(ht.textContent=Yi),Ge=a(s),Jt=i(s,"OL",{"data-svelte-h":!0}),o(Jt)!=="svelte-an135w"&&(Jt.innerHTML=Fi),ze=a(s),r(mt.$$.fragment,s),Ve=a(s),wt=i(s,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1muq6i8"&&(wt.textContent=Pi),Ye=a(s),dt=i(s,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1q8tlhb"&&(dt.textContent=Di),Fe=a(s),Ut=i(s,"UL",{"data-svelte-h":!0}),o(Ut)!=="svelte-b0vrwx"&&(Ut.innerHTML=Oi),Pe=a(s),It=i(s,"P",{"data-svelte-h":!0}),o(It)!=="svelte-tevvdp"&&(It.innerHTML=Ki),De=a(s),ft=i(s,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-98970x"&&(ft.innerHTML=so),Oe=a(s),Ct=i(s,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1eej4ha"&&(Ct.innerHTML=to),Ke=a(s),r(bt.$$.fragment,s),sa=a(s),gt=i(s,"OL",{"data-svelte-h":!0}),o(gt)!=="svelte-xydyib"&&(gt.innerHTML=lo),ta=a(s),vt=i(s,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-c9hbnf"&&(vt.textContent=no),la=a(s),r(At.$$.fragment,s),na=a(s),A=i(s,"P",{align:!0,"data-svelte-h":!0}),o(A)!=="svelte-1kgsj1n"&&(A.innerHTML=eo),ea=a(s),B=i(s,"P",{align:!0,"data-svelte-h":!0}),o(B)!=="svelte-m2u5tt"&&(B.innerHTML=ao),aa=a(s),Bt=i(s,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1fvonll"&&(Bt.innerHTML=po),pa=a(s),_t=i(s,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-1u063o4"&&(_t.textContent=io),ia=a(s),r(Zt.$$.fragment,s),oa=a(s),Et=i(s,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-gm91yt"&&(Et.innerHTML=oo),ca=a(s),Nt=i(s,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1xu368l"&&(Nt.innerHTML=co),ra=a(s),r($t.$$.fragment,s),Ma=a(s),qt=i(s,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-1s4360z"&&(qt.textContent=ro),ua=a(s),xt=i(s,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1gn06z5"&&(xt.textContent=Mo),ja=a(s),Qt=i(s,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-a5qxyo"&&(Qt.innerHTML=uo),ya=a(s),kt=i(s,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-d4pith"&&(kt.innerHTML=jo),Ta=a(s),Ht=i(s,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-1v0tk6u"&&(Ht.innerHTML=yo),ha=a(s),Wt=i(s,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-972ybh"&&(Wt.innerHTML=To),Ja=a(s),Lt=i(s,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-1najbyj"&&(Lt.textContent=ho),ma=a(s),r(Xt.$$.fragment,s),wa=a(s),Rt=i(s,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-6lst9n"&&(Rt.innerHTML=Jo),da=a(s),St=i(s,"UL",{"data-svelte-h":!0}),o(St)!=="svelte-5r6e9k"&&(St.innerHTML=mo),Ua=a(s),Gt=i(s,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-17ktvqg"&&(Gt.innerHTML=wo),Ia=a(s),zt=i(s,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1817pj8"&&(zt.innerHTML=Uo),fa=a(s),Vt=i(s,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-17ipf62"&&(Vt.textContent=Io),Ca=a(s),r(Yt.$$.fragment,s),ba=a(s),Ft=i(s,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-1g8qm4r"&&(Ft.innerHTML=fo),ga=a(s),Pt=i(s,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-1k00g85"&&(Pt.innerHTML=Co),va=a(s),Dt=i(s,"UL",{"data-svelte-h":!0}),o(Dt)!=="svelte-299w4m"&&(Dt.innerHTML=bo),Aa=a(s),Ot=i(s,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-164cgkl"&&(Ot.innerHTML=go),Ba=a(s),r(Kt.$$.fragment,s),_a=a(s),sl=i(s,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-gncodb"&&(sl.innerHTML=vo),Za=a(s),tl=i(s,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-1i92i25"&&(tl.innerHTML=Ao),Ea=a(s),r(ll.$$.fragment,s),Na=a(s),nl=i(s,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-t7wvp3"&&(nl.innerHTML=Bo),$a=a(s),el=i(s,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1373v1s"&&(el.innerHTML=_o),qa=a(s),r(al.$$.fragment,s),xa=a(s),pl=i(s,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-1dg5zv5"&&(pl.textContent=Zo),Qa=a(s),r(il.$$.fragment,s),ka=a(s),ol=i(s,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-ufcypw"&&(ol.innerHTML=Eo),Ha=a(s),r(cl.$$.fragment,s),Wa=a(s),rl=i(s,"P",{"data-svelte-h":!0}),o(rl)!=="svelte-kwp5x9"&&(rl.textContent=No),La=a(s),Ml=i(s,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-164odnw"&&(Ml.innerHTML=$o),Xa=a(s),w=i(s,"OL",{});var q=x(w);ln=i(q,"LI",{"data-svelte-h":!0}),o(ln)!=="svelte-1ea113g"&&(ln.innerHTML=qo),xp=a(q),ul=i(q,"LI",{});var _p=x(ul);nn=i(_p,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-uug10y"&&(nn.innerHTML=xo),Qp=a(_p),r(jl.$$.fragment,_p),_p.forEach(l),kp=a(q),yl=i(q,"LI",{});var Zp=x(yl);en=i(Zp,"P",{"data-svelte-h":!0}),o(en)!=="svelte-1bu8h49"&&(en.innerHTML=Qo),Hp=a(Zp),r(Tl.$$.fragment,Zp),Zp.forEach(l),Wp=a(q),hl=i(q,"LI",{});var Ep=x(hl);an=i(Ep,"P",{"data-svelte-h":!0}),o(an)!=="svelte-9fejhf"&&(an.innerHTML=ko),Lp=a(Ep),r(Jl.$$.fragment,Ep),Ep.forEach(l),q.forEach(l),Ra=a(s),r(ml.$$.fragment,s),Sa=a(s),wl=i(s,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-ielnui"&&(wl.textContent=Ho),Ga=a(s),dl=i(s,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-1nzvpp6"&&(dl.innerHTML=Wo),za=a(s),Ul=i(s,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-itmw1a"&&(Ul.innerHTML=Lo),Va=a(s),Il=i(s,"OL",{"data-svelte-h":!0}),o(Il)!=="svelte-46iinu"&&(Il.innerHTML=Xo),Ya=a(s),fl=i(s,"P",{"data-svelte-h":!0}),o(fl)!=="svelte-a4qqfr"&&(fl.innerHTML=Ro),Fa=a(s),Cl=i(s,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-3hlmw"&&(Cl.textContent=So),Pa=a(s),r(bl.$$.fragment,s),Da=a(s),gl=i(s,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1j61g44"&&(gl.textContent=Go),Oa=a(s),vl=i(s,"UL",{"data-svelte-h":!0}),o(vl)!=="svelte-1a6gefp"&&(vl.innerHTML=zo),Ka=a(s),Al=i(s,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-mqduir"&&(Al.innerHTML=Vo),sp=a(s),Bl=i(s,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-1fri2t1"&&(Bl.textContent=Yo),tp=a(s),r(_l.$$.fragment,s),lp=a(s),Zl=i(s,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-1pg0b4o"&&(Zl.textContent=Fo),np=a(s),El=i(s,"UL",{"data-svelte-h":!0}),o(El)!=="svelte-1a3rfwc"&&(El.innerHTML=Po),ep=a(s),Nl=i(s,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-1gfkg27"&&(Nl.innerHTML=Do),ap=a(s),$l=i(s,"P",{"data-svelte-h":!0}),o($l)!=="svelte-16xa10t"&&($l.textContent=Oo),pp=a(s),ql=i(s,"OL",{"data-svelte-h":!0}),o(ql)!=="svelte-xvk7zd"&&(ql.innerHTML=Ko),ip=a(s),xl=i(s,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-1t6xdcm"&&(xl.innerHTML=sc),op=a(s),Ql=i(s,"UL",{"data-svelte-h":!0}),o(Ql)!=="svelte-1lrs7nq"&&(Ql.innerHTML=tc),cp=a(s),_=i(s,"P",{align:!0,"data-svelte-h":!0}),o(_)!=="svelte-gebtxy"&&(_.innerHTML=lc),rp=a(s),Z=i(s,"P",{align:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1nilrco"&&(Z.innerHTML=nc),Mp=a(s),kl=i(s,"UL",{"data-svelte-h":!0}),o(kl)!=="svelte-ya9pqf"&&(kl.innerHTML=ec),up=a(s),Hl=i(s,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-5yw35g"&&(Hl.innerHTML=ac),jp=a(s),Wl=i(s,"P",{"data-svelte-h":!0}),o(Wl)!=="svelte-67cyg"&&(Wl.innerHTML=pc),yp=a(s),r(Ll.$$.fragment,s),Tp=a(s),Xl=i(s,"P",{"data-svelte-h":!0}),o(Xl)!=="svelte-rqagvd"&&(Xl.textContent=ic),hp=a(s),Rl=i(s,"UL",{"data-svelte-h":!0}),o(Rl)!=="svelte-sb7wdj"&&(Rl.innerHTML=oc),Jp=a(s),Sl=i(s,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-1ezclbk"&&(Sl.textContent=cc),mp=a(s),E=i(s,"P",{align:!0,"data-svelte-h":!0}),o(E)!=="svelte-mocte1"&&(E.innerHTML=rc),wp=a(s),N=i(s,"P",{align:!0,"data-svelte-h":!0}),o(N)!=="svelte-15kockq"&&(N.innerHTML=Mc),dp=a(s),r(Gl.$$.fragment,s),Up=a(s),zl=i(s,"P",{"data-svelte-h":!0}),o(zl)!=="svelte-1h575sh"&&(zl.textContent=uc),Ip=a(s),Vl=i(s,"UL",{"data-svelte-h":!0}),o(Vl)!=="svelte-1t7hhz6"&&(Vl.innerHTML=jc),fp=a(s),Yl=i(s,"P",{"data-svelte-h":!0}),o(Yl)!=="svelte-kg8fpw"&&(Yl.textContent=yc),Cp=a(s),r($.$$.fragment,s),bp=a(s),Fl=i(s,"P",{"data-svelte-h":!0}),o(Fl)!=="svelte-k8021v"&&(Fl.textContent=Tc),gp=a(s),r(Pl.$$.fragment,s),vp=a(s),r(Dl.$$.fragment,s),Ap=a(s),pn=i(s,"P",{}),x(pn).forEach(l),this.h()},h(){d(m,"name","hf:doc:metadata"),d(m,"content",Ac),d(C,"align","center"),d(b,"align","center"),d(g,"align","center"),d(v,"align","center"),d(A,"align","center"),d(B,"align","center"),d(_,"align","center"),d(Z,"align","center"),d(E,"align","center"),d(N,"align","center")},m(s,t){J(document.head,m),n(s,Q,t),n(s,U,t),n(s,Ol,t),M(k,s,t),n(s,cn,t),n(s,H,t),n(s,rn,t),n(s,W,t),n(s,Mn,t),n(s,L,t),n(s,un,t),n(s,X,t),n(s,jn,t),n(s,R,t),n(s,yn,t),n(s,C,t),n(s,Tn,t),n(s,b,t),n(s,hn,t),n(s,S,t),n(s,Jn,t),M(G,s,t),n(s,mn,t),n(s,z,t),n(s,wn,t),M(V,s,t),n(s,dn,t),n(s,Y,t),n(s,Un,t),n(s,F,t),n(s,In,t),M(P,s,t),n(s,fn,t),n(s,D,t),n(s,Cn,t),M(O,s,t),n(s,bn,t),M(K,s,t),n(s,gn,t),M(ss,s,t),n(s,vn,t),n(s,ts,t),n(s,An,t),M(ls,s,t),n(s,Bn,t),M(ns,s,t),n(s,_n,t),n(s,es,t),n(s,Zn,t),M(as,s,t),n(s,En,t),n(s,ps,t),n(s,Nn,t),n(s,is,t),n(s,$n,t),M(os,s,t),n(s,qn,t),n(s,cs,t),n(s,xn,t),n(s,rs,t),n(s,Qn,t),M(Ms,s,t),n(s,kn,t),n(s,us,t),n(s,Hn,t),M(js,s,t),n(s,Wn,t),n(s,ys,t),n(s,Ln,t),M(Ts,s,t),n(s,Xn,t),n(s,hs,t),n(s,Rn,t),M(Js,s,t),n(s,Sn,t),M(ms,s,t),n(s,Gn,t),n(s,ws,t),n(s,zn,t),M(ds,s,t),n(s,Vn,t),n(s,Us,t),n(s,Yn,t),M(Is,s,t),n(s,Fn,t),n(s,fs,t),n(s,Pn,t),n(s,Cs,t),n(s,Dn,t),M(bs,s,t),n(s,On,t),n(s,gs,t),n(s,Kn,t),M(vs,s,t),n(s,se,t),n(s,As,t),n(s,te,t),n(s,Bs,t),n(s,le,t),M(_s,s,t),n(s,ne,t),n(s,Zs,t),n(s,ee,t),M(Es,s,t),n(s,ae,t),n(s,Ns,t),n(s,pe,t),M($s,s,t),n(s,ie,t),n(s,qs,t),n(s,oe,t),n(s,xs,t),n(s,ce,t),n(s,Qs,t),n(s,re,t),n(s,ks,t),n(s,Me,t),M(Hs,s,t),n(s,ue,t),n(s,Ws,t),n(s,je,t),n(s,I,t),J(I,Kl),J(I,Np),J(I,sn),J(sn,$p),M(Ls,sn,null),J(I,qp),J(I,tn),n(s,ye,t),n(s,Xs,t),n(s,Te,t),M(Rs,s,t),n(s,he,t),M(Ss,s,t),n(s,Je,t),n(s,Gs,t),n(s,me,t),n(s,zs,t),n(s,we,t),n(s,Vs,t),n(s,de,t),n(s,Ys,t),n(s,Ue,t),n(s,Fs,t),n(s,Ie,t),M(Ps,s,t),n(s,fe,t),M(Ds,s,t),n(s,Ce,t),n(s,Os,t),n(s,be,t),n(s,Ks,t),n(s,ge,t),n(s,st,t),n(s,ve,t),M(tt,s,t),n(s,Ae,t),n(s,lt,t),n(s,Be,t),n(s,nt,t),n(s,_e,t),n(s,et,t),n(s,Ze,t),n(s,at,t),n(s,Ee,t),M(pt,s,t),n(s,Ne,t),n(s,g,t),n(s,$e,t),n(s,v,t),n(s,qe,t),n(s,it,t),n(s,xe,t),n(s,ot,t),n(s,Qe,t),n(s,ct,t),n(s,ke,t),M(rt,s,t),n(s,He,t),n(s,Mt,t),n(s,We,t),n(s,ut,t),n(s,Le,t),n(s,jt,t),n(s,Xe,t),n(s,yt,t),n(s,Re,t),M(Tt,s,t),n(s,Se,t),n(s,ht,t),n(s,Ge,t),n(s,Jt,t),n(s,ze,t),M(mt,s,t),n(s,Ve,t),n(s,wt,t),n(s,Ye,t),n(s,dt,t),n(s,Fe,t),n(s,Ut,t),n(s,Pe,t),n(s,It,t),n(s,De,t),n(s,ft,t),n(s,Oe,t),n(s,Ct,t),n(s,Ke,t),M(bt,s,t),n(s,sa,t),n(s,gt,t),n(s,ta,t),n(s,vt,t),n(s,la,t),M(At,s,t),n(s,na,t),n(s,A,t),n(s,ea,t),n(s,B,t),n(s,aa,t),n(s,Bt,t),n(s,pa,t),n(s,_t,t),n(s,ia,t),M(Zt,s,t),n(s,oa,t),n(s,Et,t),n(s,ca,t),n(s,Nt,t),n(s,ra,t),M($t,s,t),n(s,Ma,t),n(s,qt,t),n(s,ua,t),n(s,xt,t),n(s,ja,t),n(s,Qt,t),n(s,ya,t),n(s,kt,t),n(s,Ta,t),n(s,Ht,t),n(s,ha,t),n(s,Wt,t),n(s,Ja,t),n(s,Lt,t),n(s,ma,t),M(Xt,s,t),n(s,wa,t),n(s,Rt,t),n(s,da,t),n(s,St,t),n(s,Ua,t),n(s,Gt,t),n(s,Ia,t),n(s,zt,t),n(s,fa,t),n(s,Vt,t),n(s,Ca,t),M(Yt,s,t),n(s,ba,t),n(s,Ft,t),n(s,ga,t),n(s,Pt,t),n(s,va,t),n(s,Dt,t),n(s,Aa,t),n(s,Ot,t),n(s,Ba,t),M(Kt,s,t),n(s,_a,t),n(s,sl,t),n(s,Za,t),n(s,tl,t),n(s,Ea,t),M(ll,s,t),n(s,Na,t),n(s,nl,t),n(s,$a,t),n(s,el,t),n(s,qa,t),M(al,s,t),n(s,xa,t),n(s,pl,t),n(s,Qa,t),M(il,s,t),n(s,ka,t),n(s,ol,t),n(s,Ha,t),M(cl,s,t),n(s,Wa,t),n(s,rl,t),n(s,La,t),n(s,Ml,t),n(s,Xa,t),n(s,w,t),J(w,ln),J(w,xp),J(w,ul),J(ul,nn),J(ul,Qp),M(jl,ul,null),J(w,kp),J(w,yl),J(yl,en),J(yl,Hp),M(Tl,yl,null),J(w,Wp),J(w,hl),J(hl,an),J(hl,Lp),M(Jl,hl,null),n(s,Ra,t),M(ml,s,t),n(s,Sa,t),n(s,wl,t),n(s,Ga,t),n(s,dl,t),n(s,za,t),n(s,Ul,t),n(s,Va,t),n(s,Il,t),n(s,Ya,t),n(s,fl,t),n(s,Fa,t),n(s,Cl,t),n(s,Pa,t),M(bl,s,t),n(s,Da,t),n(s,gl,t),n(s,Oa,t),n(s,vl,t),n(s,Ka,t),n(s,Al,t),n(s,sp,t),n(s,Bl,t),n(s,tp,t),M(_l,s,t),n(s,lp,t),n(s,Zl,t),n(s,np,t),n(s,El,t),n(s,ep,t),n(s,Nl,t),n(s,ap,t),n(s,$l,t),n(s,pp,t),n(s,ql,t),n(s,ip,t),n(s,xl,t),n(s,op,t),n(s,Ql,t),n(s,cp,t),n(s,_,t),n(s,rp,t),n(s,Z,t),n(s,Mp,t),n(s,kl,t),n(s,up,t),n(s,Hl,t),n(s,jp,t),n(s,Wl,t),n(s,yp,t),M(Ll,s,t),n(s,Tp,t),n(s,Xl,t),n(s,hp,t),n(s,Rl,t),n(s,Jp,t),n(s,Sl,t),n(s,mp,t),n(s,E,t),n(s,wp,t),n(s,N,t),n(s,dp,t),M(Gl,s,t),n(s,Up,t),n(s,zl,t),n(s,Ip,t),n(s,Vl,t),n(s,fp,t),n(s,Yl,t),n(s,Cp,t),M($,s,t),n(s,bp,t),n(s,Fl,t),n(s,gp,t),M(Pl,s,t),n(s,vp,t),M(Dl,s,t),n(s,Ap,t),n(s,pn,t),Bp=!0},p(s,[t]){const f={};t&2&&(f.$$scope={dirty:t,ctx:s}),$.$set(f)},i(s){Bp||(u(k.$$.fragment,s),u(G.$$.fragment,s),u(V.$$.fragment,s),u(P.$$.fragment,s),u(O.$$.fragment,s),u(K.$$.fragment,s),u(ss.$$.fragment,s),u(ls.$$.fragment,s),u(ns.$$.fragment,s),u(as.$$.fragment,s),u(os.$$.fragment,s),u(Ms.$$.fragment,s),u(js.$$.fragment,s),u(Ts.$$.fragment,s),u(Js.$$.fragment,s),u(ms.$$.fragment,s),u(ds.$$.fragment,s),u(Is.$$.fragment,s),u(bs.$$.fragment,s),u(vs.$$.fragment,s),u(_s.$$.fragment,s),u(Es.$$.fragment,s),u($s.$$.fragment,s),u(Hs.$$.fragment,s),u(Ls.$$.fragment,s),u(Rs.$$.fragment,s),u(Ss.$$.fragment,s),u(Ps.$$.fragment,s),u(Ds.$$.fragment,s),u(tt.$$.fragment,s),u(pt.$$.fragment,s),u(rt.$$.fragment,s),u(Tt.$$.fragment,s),u(mt.$$.fragment,s),u(bt.$$.fragment,s),u(At.$$.fragment,s),u(Zt.$$.fragment,s),u($t.$$.fragment,s),u(Xt.$$.fragment,s),u(Yt.$$.fragment,s),u(Kt.$$.fragment,s),u(ll.$$.fragment,s),u(al.$$.fragment,s),u(il.$$.fragment,s),u(cl.$$.fragment,s),u(jl.$$.fragment,s),u(Tl.$$.fragment,s),u(Jl.$$.fragment,s),u(ml.$$.fragment,s),u(bl.$$.fragment,s),u(_l.$$.fragment,s),u(Ll.$$.fragment,s),u(Gl.$$.fragment,s),u($.$$.fragment,s),u(Pl.$$.fragment,s),u(Dl.$$.fragment,s),Bp=!0)},o(s){j(k.$$.fragment,s),j(G.$$.fragment,s),j(V.$$.fragment,s),j(P.$$.fragment,s),j(O.$$.fragment,s),j(K.$$.fragment,s),j(ss.$$.fragment,s),j(ls.$$.fragment,s),j(ns.$$.fragment,s),j(as.$$.fragment,s),j(os.$$.fragment,s),j(Ms.$$.fragment,s),j(js.$$.fragment,s),j(Ts.$$.fragment,s),j(Js.$$.fragment,s),j(ms.$$.fragment,s),j(ds.$$.fragment,s),j(Is.$$.fragment,s),j(bs.$$.fragment,s),j(vs.$$.fragment,s),j(_s.$$.fragment,s),j(Es.$$.fragment,s),j($s.$$.fragment,s),j(Hs.$$.fragment,s),j(Ls.$$.fragment,s),j(Rs.$$.fragment,s),j(Ss.$$.fragment,s),j(Ps.$$.fragment,s),j(Ds.$$.fragment,s),j(tt.$$.fragment,s),j(pt.$$.fragment,s),j(rt.$$.fragment,s),j(Tt.$$.fragment,s),j(mt.$$.fragment,s),j(bt.$$.fragment,s),j(At.$$.fragment,s),j(Zt.$$.fragment,s),j($t.$$.fragment,s),j(Xt.$$.fragment,s),j(Yt.$$.fragment,s),j(Kt.$$.fragment,s),j(ll.$$.fragment,s),j(al.$$.fragment,s),j(il.$$.fragment,s),j(cl.$$.fragment,s),j(jl.$$.fragment,s),j(Tl.$$.fragment,s),j(Jl.$$.fragment,s),j(ml.$$.fragment,s),j(bl.$$.fragment,s),j(_l.$$.fragment,s),j(Ll.$$.fragment,s),j(Gl.$$.fragment,s),j($.$$.fragment,s),j(Pl.$$.fragment,s),j(Dl.$$.fragment,s),Bp=!1},d(s){s&&(l(Q),l(U),l(Ol),l(cn),l(H),l(rn),l(W),l(Mn),l(L),l(un),l(X),l(jn),l(R),l(yn),l(C),l(Tn),l(b),l(hn),l(S),l(Jn),l(mn),l(z),l(wn),l(dn),l(Y),l(Un),l(F),l(In),l(fn),l(D),l(Cn),l(bn),l(gn),l(vn),l(ts),l(An),l(Bn),l(_n),l(es),l(Zn),l(En),l(ps),l(Nn),l(is),l($n),l(qn),l(cs),l(xn),l(rs),l(Qn),l(kn),l(us),l(Hn),l(Wn),l(ys),l(Ln),l(Xn),l(hs),l(Rn),l(Sn),l(Gn),l(ws),l(zn),l(Vn),l(Us),l(Yn),l(Fn),l(fs),l(Pn),l(Cs),l(Dn),l(On),l(gs),l(Kn),l(se),l(As),l(te),l(Bs),l(le),l(ne),l(Zs),l(ee),l(ae),l(Ns),l(pe),l(ie),l(qs),l(oe),l(xs),l(ce),l(Qs),l(re),l(ks),l(Me),l(ue),l(Ws),l(je),l(I),l(ye),l(Xs),l(Te),l(he),l(Je),l(Gs),l(me),l(zs),l(we),l(Vs),l(de),l(Ys),l(Ue),l(Fs),l(Ie),l(fe),l(Ce),l(Os),l(be),l(Ks),l(ge),l(st),l(ve),l(Ae),l(lt),l(Be),l(nt),l(_e),l(et),l(Ze),l(at),l(Ee),l(Ne),l(g),l($e),l(v),l(qe),l(it),l(xe),l(ot),l(Qe),l(ct),l(ke),l(He),l(Mt),l(We),l(ut),l(Le),l(jt),l(Xe),l(yt),l(Re),l(Se),l(ht),l(Ge),l(Jt),l(ze),l(Ve),l(wt),l(Ye),l(dt),l(Fe),l(Ut),l(Pe),l(It),l(De),l(ft),l(Oe),l(Ct),l(Ke),l(sa),l(gt),l(ta),l(vt),l(la),l(na),l(A),l(ea),l(B),l(aa),l(Bt),l(pa),l(_t),l(ia),l(oa),l(Et),l(ca),l(Nt),l(ra),l(Ma),l(qt),l(ua),l(xt),l(ja),l(Qt),l(ya),l(kt),l(Ta),l(Ht),l(ha),l(Wt),l(Ja),l(Lt),l(ma),l(wa),l(Rt),l(da),l(St),l(Ua),l(Gt),l(Ia),l(zt),l(fa),l(Vt),l(Ca),l(ba),l(Ft),l(ga),l(Pt),l(va),l(Dt),l(Aa),l(Ot),l(Ba),l(_a),l(sl),l(Za),l(tl),l(Ea),l(Na),l(nl),l($a),l(el),l(qa),l(xa),l(pl),l(Qa),l(ka),l(ol),l(Ha),l(Wa),l(rl),l(La),l(Ml),l(Xa),l(w),l(Ra),l(Sa),l(wl),l(Ga),l(dl),l(za),l(Ul),l(Va),l(Il),l(Ya),l(fl),l(Fa),l(Cl),l(Pa),l(Da),l(gl),l(Oa),l(vl),l(Ka),l(Al),l(sp),l(Bl),l(tp),l(lp),l(Zl),l(np),l(El),l(ep),l(Nl),l(ap),l($l),l(pp),l(ql),l(ip),l(xl),l(op),l(Ql),l(cp),l(_),l(rp),l(Z),l(Mp),l(kl),l(up),l(Hl),l(jp),l(Wl),l(yp),l(Tp),l(Xl),l(hp),l(Rl),l(Jp),l(Sl),l(mp),l(E),l(wp),l(N),l(dp),l(Up),l(zl),l(Ip),l(Vl),l(fp),l(Yl),l(Cp),l(bp),l(Fl),l(gp),l(vp),l(Ap),l(pn)),l(m),y(k,s),y(G,s),y(V,s),y(P,s),y(O,s),y(K,s),y(ss,s),y(ls,s),y(ns,s),y(as,s),y(os,s),y(Ms,s),y(js,s),y(Ts,s),y(Js,s),y(ms,s),y(ds,s),y(Is,s),y(bs,s),y(vs,s),y(_s,s),y(Es,s),y($s,s),y(Hs,s),y(Ls),y(Rs,s),y(Ss,s),y(Ps,s),y(Ds,s),y(tt,s),y(pt,s),y(rt,s),y(Tt,s),y(mt,s),y(bt,s),y(At,s),y(Zt,s),y($t,s),y(Xt,s),y(Yt,s),y(Kt,s),y(ll,s),y(al,s),y(il,s),y(cl,s),y(jl),y(Tl),y(Jl),y(ml,s),y(bl,s),y(_l,s),y(Ll,s),y(Gl,s),y($,s),y(Pl,s),y(Dl,s)}}}const Ac='{"title":"HIL-SERL Real Robot Training Workflow Guide","local":"hil-serl-real-robot-training-workflow-guide","sections":[{"title":"What do I need?","local":"what-do-i-need","sections":[],"depth":2},{"title":"What kind of tasks can I train?","local":"what-kind-of-tasks-can-i-train","sections":[],"depth":2},{"title":"Install LeRobot with HIL-SERL","local":"install-lerobot-with-hil-serl","sections":[],"depth":2},{"title":"Real Robot Training Workflow","local":"real-robot-training-workflow","sections":[{"title":"Understanding Configuration","local":"understanding-configuration","sections":[],"depth":3},{"title":"Processor Pipeline Architecture","local":"processor-pipeline-architecture","sections":[{"title":"Environment Processor Pipeline","local":"environment-processor-pipeline","sections":[],"depth":4},{"title":"Action Processor Pipeline","local":"action-processor-pipeline","sections":[],"depth":4},{"title":"Configuration Examples","local":"configuration-examples","sections":[],"depth":4}],"depth":3},{"title":"Advanced Observation Processing","local":"advanced-observation-processing","sections":[{"title":"Joint Velocity Processing","local":"joint-velocity-processing","sections":[],"depth":4},{"title":"Motor Current Processing","local":"motor-current-processing","sections":[],"depth":4},{"title":"Combined Observation Processing","local":"combined-observation-processing","sections":[],"depth":4}],"depth":3},{"title":"Finding Robot Workspace Bounds","local":"finding-robot-workspace-bounds","sections":[],"depth":3},{"title":"Collecting Demonstrations","local":"collecting-demonstrations","sections":[],"depth":3},{"title":"Using a Teleoperation Device","local":"using-a-teleoperation-device","sections":[],"depth":3},{"title":"Processing the Dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Training a Reward Classifier","local":"training-a-reward-classifier","sections":[],"depth":3},{"title":"Training with Actor-Learner","local":"training-with-actor-learner","sections":[],"depth":3},{"title":"Guide to Human Interventions","local":"guide-to-human-interventions","sections":[],"depth":3},{"title":"Key hyperparameters to tune","local":"key-hyperparameters-to-tune","sections":[],"depth":3}],"depth":2}],"depth":1}';function Bc(on){return Jc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qc extends wc{constructor(m){super(),dc(this,m,Bc,vc,hc,{})}}export{qc as component};
