import{s as $s,o as Zs,n as wn}from"../chunks/scheduler.bdbef820.js";import{S as Bs,i as Cs,g as o,s as t,r as g,A as Is,h as r,f as i,c as s,j as w,u,x as m,k as v,y as n,a as p,v as f,d as h,t as b,w as _}from"../chunks/index.33f81d56.js";import{T as Gs}from"../chunks/Tip.34194030.js";import{D as x}from"../chunks/Docstring.64554317.js";import{C as Lt}from"../chunks/CodeBlock.362b34a4.js";import{E as Dt}from"../chunks/ExampleCodeBlock.4f2252c6.js";import{H as jn,E as Vs}from"../chunks/EditOnGithub.a9246e21.js";function Ws(V){let l,k="Examples:",M,d,y;return d=new Lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbmVyYXRpb25Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQSUyMyUyMEUuZy4lMjBjb25maWclMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRiUyMiklMEElMEElMjMlMjBZb3UlMjBjYW4lMjBhbHNvJTIwc3BlY2lmeSUyMGNvbmZpZ3VyYXRpb24lMjBuYW1lcyUyMHRvJTIweW91ciUyMGdlbmVyYXRpb24lMjBjb25maWd1cmF0aW9uJTIwZmlsZSUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyJTJDJTIwY29uZmlnX2ZpbGVfbmFtZSUzRCUyMm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMkMlMjAlMjJteV9jb25maWd1cmF0aW9uLmpzb24lMjIpJTBBJTBBJTIzJTIwSWYlMjB5b3UnZCUyMGxpa2UlMjB0byUyMHRyeSUyMGElMjBtaW5vciUyMHZhcmlhdGlvbiUyMHRvJTIwYW4lMjBleGlzdGluZyUyMGNvbmZpZ3VyYXRpb24lMkMlMjB5b3UlMjBjYW4lMjBhbHNvJTIwcGFzcyUyMGdlbmVyYXRpb24lMEElMjMlMjBhcmd1bWVudHMlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoKSU2MC4lMjBCZSUyMG1pbmRmdWwlMjB0aGF0JTIwdHlwb3MlMjBhbmQlMjB1bnVzZWQlMjBhcmd1bWVudHMlMjB3aWxsJTIwYmUlMjBpZ25vcmVkJTBBZ2VuZXJhdGlvbl9jb25maWclMkMlMjB1bnVzZWRfa3dhcmdzJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjB0b3BfayUzRDElMkMlMjBmb28lM0RGYWxzZSUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBZ2VuZXJhdGlvbl9jb25maWcudG9wX2slMEElMEF1bnVzZWRfa3dhcmdz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, do_sample=<span class="hljs-literal">True</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,M=t(),g(d.$$.fragment)},l(a){l=r(a,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=k),M=s(a),u(d.$$.fragment,a)},m(a,T){p(a,l,T),p(a,M,T),f(d,a,T),y=!0},p:wn,i(a){y||(h(d.$$.fragment,a),y=!0)},o(a){b(d.$$.fragment,a),y=!1},d(a){a&&(i(l),i(M)),_(d,a)}}}function Hs(V){let l,k=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,M,d,y=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){l=o("p"),l.innerHTML=k,M=t(),d=o("p"),d.innerHTML=y},l(a){l=r(a,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1c5u34l"&&(l.innerHTML=k),M=s(a),d=r(a,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fvlq1g"&&(d.innerHTML=y)},m(a,T){p(a,l,T),p(a,M,T),p(a,d,T)},p:wn,d(a){a&&(i(l),i(M),i(d))}}}function Xs(V){let l,k="Examples:",M,d,y;return d=new Lt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | log probability | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 1: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 2: the output length does NOT include the input length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,M=t(),g(d.$$.fragment)},l(a){l=r(a,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=k),M=s(a),u(d.$$.fragment,a)},m(a,T){p(a,l,T),p(a,M,T),f(d,a,T),y=!0},p:wn,i(a){y||(h(d.$$.fragment,a),y=!0)},o(a){b(d.$$.fragment,a),y=!1},d(a){a&&(i(l),i(M)),_(d,a)}}}function zs(V){let l,k=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate, e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,M,d,y=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){l=o("p"),l.innerHTML=k,M=t(),d=o("p"),d.innerHTML=y},l(a){l=r(a,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1pahvb2"&&(l.innerHTML=k),M=s(a),d=r(a,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fvlq1g"&&(d.innerHTML=y)},m(a,T){p(a,l,T),p(a,M,T),p(a,d,T)},p:wn,d(a){a&&(i(l),i(M),i(d))}}}function Rs(V){let l,k="Examples:",M,d,y;return d=new Lt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){l=o("p"),l.textContent=k,M=t(),g(d.$$.fragment)},l(a){l=r(a,"P",{"data-svelte-h":!0}),m(l)!=="svelte-kvfsh7"&&(l.textContent=k),M=s(a),u(d.$$.fragment,a)},m(a,T){p(a,l,T),p(a,M,T),f(d,a,T),y=!0},p:wn,i(a){y||(h(d.$$.fragment,a),y=!0)},o(a){b(d.$$.fragment,a),y=!1},d(a){a&&(i(l),i(M)),_(d,a)}}}function Fs(V){let l,k,M,d,y,a,T,Yt="각 프레임워크에는 해당하는 <code>GenerationMixin</code> 클래스에서 구현된 텍스트 생성을 위한 generate 메소드가 있습니다:",vn,oe,Qt='<li>PyTorch에서는 <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>가 <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationMixin">GenerationMixin</a>에 구현되어 있습니다.</li> <li>TensorFlow에서는 <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a>가 <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.TFGenerationMixin">TFGenerationMixin</a>에 구현되어 있습니다.</li> <li>Flax/JAX에서는 <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a>가 <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.FlaxGenerationMixin">FlaxGenerationMixin</a>에 구현되어 있습니다.</li>',xn,re,qt='사용하는 프레임워크에 상관없이, generate 메소드는 <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> 클래스 인스턴스로 매개변수화 할 수 있습니다. generate 메소드의 동작을 제어하는 모든 생성 매개변수 목록을 확인하려면 이 클래스를 참조하세요.',kn,ie,At='모델의 생성 설정을 어떻게 확인하고, 기본값이 무엇인지, 매개변수를 어떻게 임시로 변경하는지, 그리고 사용자 지정 생성 설정을 만들고 저장하는 방법을 배우려면 <a href="../generation_strategies">텍스트 생성 전략 가이드</a>를 참조하세요. 이 가이드는 토큰 스트리밍과 같은 관련 기능을 사용하는 방법도 설명합니다.',Jn,le,Un,J,ce,Ln,H,de,Yn,He,Ot='Instantiate a <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a generation configuration file.',Qn,S,qn,D,me,An,Xe,Pt=`Instantiates a <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a <a href="/docs/transformers/pr_30803/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. This function is useful to convert legacy
<a href="/docs/transformers/pr_30803/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> objects, which may contain generation parameters, into a stand-alone <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>.`,On,L,pe,Pn,ze,Kt=`Save a generation configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">from_pretrained()</a> class method.`,Kn,Y,ge,et,Re,es=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,nt,X,ue,tt,Fe,ns=`Validates the values of the attributes of the <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> instance. Raises exceptions in the presence
of parameterization that can be detected as incorrect from the configuration instance alone.`,st,Ne,ts=`Note that some parameters not validated here are best validated at generate runtime, as they may depend on
other inputs and/or the model, such as parameters related to the generation length.`,at,Q,fe,ot,Ee,ss='Returns the generation mode triggered by the <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> instance.',Gn,j,he,rt,Se,as=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details on the arguments.`,it,De,os="Accepts the following keys:",lt,Le,rs=`<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of “green” tokens used to the vocabulary size. Defaults to 0.25.</li> <li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected “green” tokens’ logits. Defaults to 2.0.</li> <li>hashing_key (<code>int</code>):
Hashing key used for watermarking. Defaults to 15485863 (the millionth prime).</li> <li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul><li>“lefthash” (default): “green” tokens selection depend on the last token (Algorithm 2 from the paper)</li> <li>“selfhash”: “green” tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than “lefthash”.</li></ul></li> <li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>`,ct,q,be,dt,Ye,is="Constructs a WatermarkingConfig instance from a dictionary of parameters.",mt,A,_e,pt,Qe,ls="Serializes this instance to a Python dictionary.",gt,O,Me,ut,qe,cs="Save this instance to a JSON file.",ft,P,ye,ht,Ae,ds="Serializes this instance to a JSON formatted string.",bt,K,Te,_t,Oe,ms="Update the configuration attributes with new values.",$n,je,Zn,U,we,Mt,Pe,ps='A class containing all functions for auto-regressive text generation, to be used as a mixin in <a href="/docs/transformers/pr_30803/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.',yt,Ke,gs='The class exposes <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, which can be used for:',Tt,en,us="<li><em>greedy decoding</em> if <code>num_beams=1</code> and <code>do_sample=False</code></li> <li><em>contrastive search</em> if <code>penalty_alpha&gt;0</code> and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> if <code>num_beams=1</code> and <code>do_sample=True</code></li> <li><em>beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> if <code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> if <code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> if <code>assistant_model</code> or <code>prompt_lookup_num_tokens</code> is passed to <code>.generate()</code></li>",jt,nn,fs='To learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.',wt,z,ve,vt,tn,hs="Generates sequences of token ids for models with a language modeling head.",xt,ee,kt,R,xe,Jt,sn,bs=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,Ut,ne,Bn,ke,Cn,G,Je,Gt,an,_s='A class containing all of the functions supporting generation, to be used as a mixin in <a href="/docs/transformers/pr_30803/ko/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>.',$t,on,Ms='The class exposes <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a>, which can be used for:',Zt,rn,ys=`<li><em>greedy decoding</em> by calling <code>greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>contrastive search</em> by calling <code>contrastive_search()</code> if <code>penalty_alpha&gt;0</code> and
<code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> by calling <code>sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>beam_search()</code> if <code>num_beams&gt;1</code></li>`,Bt,ln,Ts=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Ct,F,Ue,It,cn,js="Generates sequences of token ids for models with a language modeling head.",Vt,te,Wt,N,Ge,Ht,dn,ws=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,Xt,se,In,$e,Vn,Z,Ze,zt,mn,vs=`A class containing all functions for auto-regressive text generation, to be used as a mixin in
<a href="/docs/transformers/pr_30803/ko/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>.`,Rt,pn,xs='The class exposes <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a>, which can be used for:',Ft,gn,ks=`<li><em>greedy decoding</em> by calling <code>_greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>multinomial sampling</em> by calling <code>_sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>_beam_search()</code> if <code>num_beams&gt;1</code> and
<code>do_sample=False</code></li>`,Nt,un,Js=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Et,ae,Be,St,fn,Us="Generates sequences of token ids for models with a language modeling head.",Wn,Ce,Hn,Tn,Xn;return y=new jn({props:{title:"생성",local:"generation",headingTag:"h1"}}),le=new jn({props:{title:"GenerationConfig",local:"transformers.GenerationConfig ][ transformers.GenerationConfig",headingTag:"h2"}}),ce=new x({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L94"}}),de=new x({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": Union"},{name:"config_file_name",val:": Union = None"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible.
Will be removed in v5 of Transformers.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass <code>revision=&quot;refs/pr/&lt;pr_number&gt;&quot;</code>.</p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L879",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),S=new Dt({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[Ws]},$$scope:{ctx:V}}}),me=new x({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1219",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from those parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),pe=new x({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"config_file_name",val:": Union = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.GenerationConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/pr_30803/ko/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L801"}}),ge=new x({props:{name:"update",anchor:"transformers.GenerationConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),ue=new x({props:{name:"validate",anchor:"transformers.GenerationConfig.validate",parameters:[{name:"is_init",val:" = False"}],parametersDescription:[{anchor:"transformers.GenerationConfig.validate.is_init",description:`<strong>is_init</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the validation is performed during the initialization of the instance.`,name:"is_init"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L560"}}),fe=new x({props:{name:"get_generation_mode",anchor:"transformers.GenerationConfig.get_generation_mode",parameters:[{name:"assistant_model",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.GenerationConfig.get_generation_mode.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
The assistant model to be used for assisted generation. If set, the generation mode will be
assisted generation.`,name:"assistant_model"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L502",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generation mode triggered by the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>GenerationMode</code></p>
`}}),he=new x({props:{name:"class transformers.WatermarkingConfig",anchor:"transformers.WatermarkingConfig",parameters:[{name:"greenlist_ratio",val:": Optional = 0.25"},{name:"bias",val:": Optional = 2.0"},{name:"hashing_key",val:": Optional = 15485863"},{name:"seeding_scheme",val:": Optional = 'lefthash'"},{name:"context_width",val:": Optional = 1"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1289"}}),be=new x({props:{name:"from_dict",anchor:"transformers.WatermarkingConfig.from_dict",parameters:[{name:"config_dict",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.WatermarkingConfig.from_dict.config_dict",description:`<strong>config_dict</strong> (Dict[str, Any]) &#x2014; Dictionary containing configuration parameters.
**kwargs &#x2014; Additional keyword arguments to override dictionary values.`,name:"config_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1325",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of WatermarkingConfig constructed from the dictionary.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>WatermarkingConfig</p>
`}}),_e=new x({props:{name:"to_dict",anchor:"transformers.WatermarkingConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1360",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dict[str, Any]</p>
`}}),Me=new x({props:{name:"to_json_file",anchor:"transformers.WatermarkingConfig.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.WatermarkingConfig.to_json_file.json_file_path",description:"<strong>json_file_path</strong> (Union[str, os.PathLike]) &#x2014; Path to the JSON file in which this configuration instance&#x2019;s parameters will be saved.",name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1347"}}),ye=new x({props:{name:"to_json_string",anchor:"transformers.WatermarkingConfig.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1377",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>JSON formatted string representing the configuration instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`}}),Te=new x({props:{name:"update",anchor:"transformers.WatermarkingConfig.update",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/configuration_utils.py#L1386"}}),je=new jn({props:{title:"GenerationMixin",local:"transformers.GenerationMixin ][ transformers.GenerationMixin",headingTag:"h2"}}),we=new x({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/utils.py#L332"}}),ve=new x({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"stopping_criteria",val:": Optional = None"},{name:"prefix_allowed_tokens_fn",val:": Optional = None"},{name:"synced_gpus",val:": Optional = None"},{name:"assistant_model",val:": Optional = None"},{name:"streamer",val:": Optional = None"},{name:"negative_prompt_ids",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden, this flag will be set
to <code>True</code> if using <code>FullyShardedDataParallel</code> or DeepSpeed ZeRO Stage 3 with multiple GPUs to avoid
deadlocking if one GPU finishes generating before other GPUs. Otherwise, defaults to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.GenerationMixin.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.GenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/utils.py#L1860",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),ee=new Gs({props:{warning:!0,$$slots:{default:[Hs]},$$scope:{ctx:V}}}),xe=new x({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": Tuple"},{name:"beam_indices",val:": Optional = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/utils.py#L1131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),ne=new Dt({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[Xs]},$$scope:{ctx:V}}}),ke=new jn({props:{title:"TFGenerationMixin",local:"transformers.TFGenerationMixin ][ transformers.TFGenerationMixin",headingTag:"h2"}}),Je=new x({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L444"}}),Ue=new x({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.`,name:"seed"},{anchor:"transformers.TFGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.TFGreedySearchDecoderOnlyOutput"
>TFGreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.TFSampleDecoderOnlyOutput"
>TFSampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.TFBeamSearchDecoderOnlyOutput"
>TFBeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.TFBeamSampleDecoderOnlyOutput"
>TFBeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.TFGreedySearchEncoderDecoderOutput"
>TFGreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.TFSampleEncoderDecoderOutput"
>TFSampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.TFBeamSearchEncoderDecoderOutput"
>TFBeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30803/ko/internal/generation_utils#transformers.generation.TFBeamSampleEncoderDecoderOutput"
>TFBeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),te=new Gs({props:{warning:!0,$$slots:{default:[zs]},$$scope:{ctx:V}}}),Ge=new x({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": Tuple"},{name:"beam_indices",val:": Optional = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/tf_utils.py#L477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code></p>
`}}),se=new Dt({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[Rs]},$$scope:{ctx:V}}}),$e=new jn({props:{title:"FlaxGenerationMixin",local:"transformers.FlaxGenerationMixin ][ transformers.FlaxGenerationMixin",headingTag:"h2"}}),Ze=new x({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_utils.py#L130"}}),Be=new x({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": Array"},{name:"generation_config",val:": Optional = None"},{name:"prng_key",val:": Optional = None"},{name:"trace",val:": bool = True"},{name:"params",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_30803/ko/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.FlaxGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/generation/flax_utils.py#L268",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30803/ko/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),Ce=new Vs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/main_classes/text_generation.md"}}),{c(){l=o("meta"),k=t(),M=o("p"),d=t(),g(y.$$.fragment),a=t(),T=o("p"),T.innerHTML=Yt,vn=t(),oe=o("ul"),oe.innerHTML=Qt,xn=t(),re=o("p"),re.innerHTML=qt,kn=t(),ie=o("p"),ie.innerHTML=At,Jn=t(),g(le.$$.fragment),Un=t(),J=o("div"),g(ce.$$.fragment),Ln=t(),H=o("div"),g(de.$$.fragment),Yn=t(),He=o("p"),He.innerHTML=Ot,Qn=t(),g(S.$$.fragment),qn=t(),D=o("div"),g(me.$$.fragment),An=t(),Xe=o("p"),Xe.innerHTML=Pt,On=t(),L=o("div"),g(pe.$$.fragment),Pn=t(),ze=o("p"),ze.innerHTML=Kt,Kn=t(),Y=o("div"),g(ge.$$.fragment),et=t(),Re=o("p"),Re.innerHTML=es,nt=t(),X=o("div"),g(ue.$$.fragment),tt=t(),Fe=o("p"),Fe.innerHTML=ns,st=t(),Ne=o("p"),Ne.textContent=ts,at=t(),Q=o("div"),g(fe.$$.fragment),ot=t(),Ee=o("p"),Ee.innerHTML=ss,Gn=t(),j=o("div"),g(he.$$.fragment),rt=t(),Se=o("p"),Se.innerHTML=as,it=t(),De=o("p"),De.textContent=os,lt=t(),Le=o("ul"),Le.innerHTML=rs,ct=t(),q=o("div"),g(be.$$.fragment),dt=t(),Ye=o("p"),Ye.textContent=is,mt=t(),A=o("div"),g(_e.$$.fragment),pt=t(),Qe=o("p"),Qe.textContent=ls,gt=t(),O=o("div"),g(Me.$$.fragment),ut=t(),qe=o("p"),qe.textContent=cs,ft=t(),P=o("div"),g(ye.$$.fragment),ht=t(),Ae=o("p"),Ae.textContent=ds,bt=t(),K=o("div"),g(Te.$$.fragment),_t=t(),Oe=o("p"),Oe.textContent=ms,$n=t(),g(je.$$.fragment),Zn=t(),U=o("div"),g(we.$$.fragment),Mt=t(),Pe=o("p"),Pe.innerHTML=ps,yt=t(),Ke=o("p"),Ke.innerHTML=gs,Tt=t(),en=o("ul"),en.innerHTML=us,jt=t(),nn=o("p"),nn.innerHTML=fs,wt=t(),z=o("div"),g(ve.$$.fragment),vt=t(),tn=o("p"),tn.textContent=hs,xt=t(),g(ee.$$.fragment),kt=t(),R=o("div"),g(xe.$$.fragment),Jt=t(),sn=o("p"),sn.textContent=bs,Ut=t(),g(ne.$$.fragment),Bn=t(),g(ke.$$.fragment),Cn=t(),G=o("div"),g(Je.$$.fragment),Gt=t(),an=o("p"),an.innerHTML=_s,$t=t(),on=o("p"),on.innerHTML=Ms,Zt=t(),rn=o("ul"),rn.innerHTML=ys,Bt=t(),ln=o("p"),ln.innerHTML=Ts,Ct=t(),F=o("div"),g(Ue.$$.fragment),It=t(),cn=o("p"),cn.textContent=js,Vt=t(),g(te.$$.fragment),Wt=t(),N=o("div"),g(Ge.$$.fragment),Ht=t(),dn=o("p"),dn.textContent=ws,Xt=t(),g(se.$$.fragment),In=t(),g($e.$$.fragment),Vn=t(),Z=o("div"),g(Ze.$$.fragment),zt=t(),mn=o("p"),mn.innerHTML=vs,Rt=t(),pn=o("p"),pn.innerHTML=xs,Ft=t(),gn=o("ul"),gn.innerHTML=ks,Nt=t(),un=o("p"),un.innerHTML=Js,Et=t(),ae=o("div"),g(Be.$$.fragment),St=t(),fn=o("p"),fn.textContent=Us,Wn=t(),g(Ce.$$.fragment),Hn=t(),Tn=o("p"),this.h()},l(e){const c=Is("svelte-u9bgzb",document.head);l=r(c,"META",{name:!0,content:!0}),c.forEach(i),k=s(e),M=r(e,"P",{}),w(M).forEach(i),d=s(e),u(y.$$.fragment,e),a=s(e),T=r(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-15l0uin"&&(T.innerHTML=Yt),vn=s(e),oe=r(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-xkuvka"&&(oe.innerHTML=Qt),xn=s(e),re=r(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1pyujes"&&(re.innerHTML=qt),kn=s(e),ie=r(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-76uueu"&&(ie.innerHTML=At),Jn=s(e),u(le.$$.fragment,e),Un=s(e),J=r(e,"DIV",{class:!0});var B=w(J);u(ce.$$.fragment,B),Ln=s(B),H=r(B,"DIV",{class:!0});var E=w(H);u(de.$$.fragment,E),Yn=s(E),He=r(E,"P",{"data-svelte-h":!0}),m(He)!=="svelte-bk1mlm"&&(He.innerHTML=Ot),Qn=s(E),u(S.$$.fragment,E),E.forEach(i),qn=s(B),D=r(B,"DIV",{class:!0});var Ie=w(D);u(me.$$.fragment,Ie),An=s(Ie),Xe=r(Ie,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-9pzhyj"&&(Xe.innerHTML=Pt),Ie.forEach(i),On=s(B),L=r(B,"DIV",{class:!0});var Ve=w(L);u(pe.$$.fragment,Ve),Pn=s(Ve),ze=r(Ve,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-lsj2g5"&&(ze.innerHTML=Kt),Ve.forEach(i),Kn=s(B),Y=r(B,"DIV",{class:!0});var We=w(Y);u(ge.$$.fragment,We),et=s(We),Re=r(We,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-n0rwld"&&(Re.innerHTML=es),We.forEach(i),nt=s(B),X=r(B,"DIV",{class:!0});var hn=w(X);u(ue.$$.fragment,hn),tt=s(hn),Fe=r(hn,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-1knmg7u"&&(Fe.innerHTML=ns),st=s(hn),Ne=r(hn,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1rsok5m"&&(Ne.textContent=ts),hn.forEach(i),at=s(B),Q=r(B,"DIV",{class:!0});var zn=w(Q);u(fe.$$.fragment,zn),ot=s(zn),Ee=r(zn,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-457x3v"&&(Ee.innerHTML=ss),zn.forEach(i),B.forEach(i),Gn=s(e),j=r(e,"DIV",{class:!0});var $=w(j);u(he.$$.fragment,$),rt=s($),Se=r($,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-8pa9bo"&&(Se.innerHTML=as),it=s($),De=r($,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1wzt57b"&&(De.textContent=os),lt=s($),Le=r($,"UL",{"data-svelte-h":!0}),m(Le)!=="svelte-vgskhd"&&(Le.innerHTML=rs),ct=s($),q=r($,"DIV",{class:!0});var Rn=w(q);u(be.$$.fragment,Rn),dt=s(Rn),Ye=r(Rn,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1y8m4uy"&&(Ye.textContent=is),Rn.forEach(i),mt=s($),A=r($,"DIV",{class:!0});var Fn=w(A);u(_e.$$.fragment,Fn),pt=s(Fn),Qe=r(Fn,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1ww3wqq"&&(Qe.textContent=ls),Fn.forEach(i),gt=s($),O=r($,"DIV",{class:!0});var Nn=w(O);u(Me.$$.fragment,Nn),ut=s(Nn),qe=r(Nn,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1g70y32"&&(qe.textContent=cs),Nn.forEach(i),ft=s($),P=r($,"DIV",{class:!0});var En=w(P);u(ye.$$.fragment,En),ht=s(En),Ae=r(En,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1nsuc3n"&&(Ae.textContent=ds),En.forEach(i),bt=s($),K=r($,"DIV",{class:!0});var Sn=w(K);u(Te.$$.fragment,Sn),_t=s(Sn),Oe=r(Sn,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-83t3pb"&&(Oe.textContent=ms),Sn.forEach(i),$.forEach(i),$n=s(e),u(je.$$.fragment,e),Zn=s(e),U=r(e,"DIV",{class:!0});var C=w(U);u(we.$$.fragment,C),Mt=s(C),Pe=r(C,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-1p3iq7z"&&(Pe.innerHTML=ps),yt=s(C),Ke=r(C,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-1b9vz4i"&&(Ke.innerHTML=gs),Tt=s(C),en=r(C,"UL",{"data-svelte-h":!0}),m(en)!=="svelte-1655ho"&&(en.innerHTML=us),jt=s(C),nn=r(C,"P",{"data-svelte-h":!0}),m(nn)!=="svelte-1gtazd5"&&(nn.innerHTML=fs),wt=s(C),z=r(C,"DIV",{class:!0});var bn=w(z);u(ve.$$.fragment,bn),vt=s(bn),tn=r(bn,"P",{"data-svelte-h":!0}),m(tn)!=="svelte-s5ko3x"&&(tn.textContent=hs),xt=s(bn),u(ee.$$.fragment,bn),bn.forEach(i),kt=s(C),R=r(C,"DIV",{class:!0});var _n=w(R);u(xe.$$.fragment,_n),Jt=s(_n),sn=r(_n,"P",{"data-svelte-h":!0}),m(sn)!=="svelte-1om47tb"&&(sn.textContent=bs),Ut=s(_n),u(ne.$$.fragment,_n),_n.forEach(i),C.forEach(i),Bn=s(e),u(ke.$$.fragment,e),Cn=s(e),G=r(e,"DIV",{class:!0});var I=w(G);u(Je.$$.fragment,I),Gt=s(I),an=r(I,"P",{"data-svelte-h":!0}),m(an)!=="svelte-ypz1rp"&&(an.innerHTML=_s),$t=s(I),on=r(I,"P",{"data-svelte-h":!0}),m(on)!=="svelte-1rbl6go"&&(on.innerHTML=Ms),Zt=s(I),rn=r(I,"UL",{"data-svelte-h":!0}),m(rn)!=="svelte-fx738d"&&(rn.innerHTML=ys),Bt=s(I),ln=r(I,"P",{"data-svelte-h":!0}),m(ln)!=="svelte-13kczdy"&&(ln.innerHTML=Ts),Ct=s(I),F=r(I,"DIV",{class:!0});var Mn=w(F);u(Ue.$$.fragment,Mn),It=s(Mn),cn=r(Mn,"P",{"data-svelte-h":!0}),m(cn)!=="svelte-s5ko3x"&&(cn.textContent=js),Vt=s(Mn),u(te.$$.fragment,Mn),Mn.forEach(i),Wt=s(I),N=r(I,"DIV",{class:!0});var yn=w(N);u(Ge.$$.fragment,yn),Ht=s(yn),dn=r(yn,"P",{"data-svelte-h":!0}),m(dn)!=="svelte-1om47tb"&&(dn.textContent=ws),Xt=s(yn),u(se.$$.fragment,yn),yn.forEach(i),I.forEach(i),In=s(e),u($e.$$.fragment,e),Vn=s(e),Z=r(e,"DIV",{class:!0});var W=w(Z);u(Ze.$$.fragment,W),zt=s(W),mn=r(W,"P",{"data-svelte-h":!0}),m(mn)!=="svelte-1fxu2l9"&&(mn.innerHTML=vs),Rt=s(W),pn=r(W,"P",{"data-svelte-h":!0}),m(pn)!=="svelte-gsf5fz"&&(pn.innerHTML=xs),Ft=s(W),gn=r(W,"UL",{"data-svelte-h":!0}),m(gn)!=="svelte-ffjx8e"&&(gn.innerHTML=ks),Nt=s(W),un=r(W,"P",{"data-svelte-h":!0}),m(un)!=="svelte-13kczdy"&&(un.innerHTML=Js),Et=s(W),ae=r(W,"DIV",{class:!0});var Dn=w(ae);u(Be.$$.fragment,Dn),St=s(Dn),fn=r(Dn,"P",{"data-svelte-h":!0}),m(fn)!=="svelte-s5ko3x"&&(fn.textContent=Us),Dn.forEach(i),W.forEach(i),Wn=s(e),u(Ce.$$.fragment,e),Hn=s(e),Tn=r(e,"P",{}),w(Tn).forEach(i),this.h()},h(){v(l,"name","hf:doc:metadata"),v(l,"content",Ns),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,l),p(e,k,c),p(e,M,c),p(e,d,c),f(y,e,c),p(e,a,c),p(e,T,c),p(e,vn,c),p(e,oe,c),p(e,xn,c),p(e,re,c),p(e,kn,c),p(e,ie,c),p(e,Jn,c),f(le,e,c),p(e,Un,c),p(e,J,c),f(ce,J,null),n(J,Ln),n(J,H),f(de,H,null),n(H,Yn),n(H,He),n(H,Qn),f(S,H,null),n(J,qn),n(J,D),f(me,D,null),n(D,An),n(D,Xe),n(J,On),n(J,L),f(pe,L,null),n(L,Pn),n(L,ze),n(J,Kn),n(J,Y),f(ge,Y,null),n(Y,et),n(Y,Re),n(J,nt),n(J,X),f(ue,X,null),n(X,tt),n(X,Fe),n(X,st),n(X,Ne),n(J,at),n(J,Q),f(fe,Q,null),n(Q,ot),n(Q,Ee),p(e,Gn,c),p(e,j,c),f(he,j,null),n(j,rt),n(j,Se),n(j,it),n(j,De),n(j,lt),n(j,Le),n(j,ct),n(j,q),f(be,q,null),n(q,dt),n(q,Ye),n(j,mt),n(j,A),f(_e,A,null),n(A,pt),n(A,Qe),n(j,gt),n(j,O),f(Me,O,null),n(O,ut),n(O,qe),n(j,ft),n(j,P),f(ye,P,null),n(P,ht),n(P,Ae),n(j,bt),n(j,K),f(Te,K,null),n(K,_t),n(K,Oe),p(e,$n,c),f(je,e,c),p(e,Zn,c),p(e,U,c),f(we,U,null),n(U,Mt),n(U,Pe),n(U,yt),n(U,Ke),n(U,Tt),n(U,en),n(U,jt),n(U,nn),n(U,wt),n(U,z),f(ve,z,null),n(z,vt),n(z,tn),n(z,xt),f(ee,z,null),n(U,kt),n(U,R),f(xe,R,null),n(R,Jt),n(R,sn),n(R,Ut),f(ne,R,null),p(e,Bn,c),f(ke,e,c),p(e,Cn,c),p(e,G,c),f(Je,G,null),n(G,Gt),n(G,an),n(G,$t),n(G,on),n(G,Zt),n(G,rn),n(G,Bt),n(G,ln),n(G,Ct),n(G,F),f(Ue,F,null),n(F,It),n(F,cn),n(F,Vt),f(te,F,null),n(G,Wt),n(G,N),f(Ge,N,null),n(N,Ht),n(N,dn),n(N,Xt),f(se,N,null),p(e,In,c),f($e,e,c),p(e,Vn,c),p(e,Z,c),f(Ze,Z,null),n(Z,zt),n(Z,mn),n(Z,Rt),n(Z,pn),n(Z,Ft),n(Z,gn),n(Z,Nt),n(Z,un),n(Z,Et),n(Z,ae),f(Be,ae,null),n(ae,St),n(ae,fn),p(e,Wn,c),f(Ce,e,c),p(e,Hn,c),p(e,Tn,c),Xn=!0},p(e,[c]){const B={};c&2&&(B.$$scope={dirty:c,ctx:e}),S.$set(B);const E={};c&2&&(E.$$scope={dirty:c,ctx:e}),ee.$set(E);const Ie={};c&2&&(Ie.$$scope={dirty:c,ctx:e}),ne.$set(Ie);const Ve={};c&2&&(Ve.$$scope={dirty:c,ctx:e}),te.$set(Ve);const We={};c&2&&(We.$$scope={dirty:c,ctx:e}),se.$set(We)},i(e){Xn||(h(y.$$.fragment,e),h(le.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(S.$$.fragment,e),h(me.$$.fragment,e),h(pe.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),h(be.$$.fragment,e),h(_e.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(je.$$.fragment,e),h(we.$$.fragment,e),h(ve.$$.fragment,e),h(ee.$$.fragment,e),h(xe.$$.fragment,e),h(ne.$$.fragment,e),h(ke.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(te.$$.fragment,e),h(Ge.$$.fragment,e),h(se.$$.fragment,e),h($e.$$.fragment,e),h(Ze.$$.fragment,e),h(Be.$$.fragment,e),h(Ce.$$.fragment,e),Xn=!0)},o(e){b(y.$$.fragment,e),b(le.$$.fragment,e),b(ce.$$.fragment,e),b(de.$$.fragment,e),b(S.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(ge.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(he.$$.fragment,e),b(be.$$.fragment,e),b(_e.$$.fragment,e),b(Me.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(je.$$.fragment,e),b(we.$$.fragment,e),b(ve.$$.fragment,e),b(ee.$$.fragment,e),b(xe.$$.fragment,e),b(ne.$$.fragment,e),b(ke.$$.fragment,e),b(Je.$$.fragment,e),b(Ue.$$.fragment,e),b(te.$$.fragment,e),b(Ge.$$.fragment,e),b(se.$$.fragment,e),b($e.$$.fragment,e),b(Ze.$$.fragment,e),b(Be.$$.fragment,e),b(Ce.$$.fragment,e),Xn=!1},d(e){e&&(i(k),i(M),i(d),i(a),i(T),i(vn),i(oe),i(xn),i(re),i(kn),i(ie),i(Jn),i(Un),i(J),i(Gn),i(j),i($n),i(Zn),i(U),i(Bn),i(Cn),i(G),i(In),i(Vn),i(Z),i(Wn),i(Hn),i(Tn)),i(l),_(y,e),_(le,e),_(ce),_(de),_(S),_(me),_(pe),_(ge),_(ue),_(fe),_(he),_(be),_(_e),_(Me),_(ye),_(Te),_(je,e),_(we),_(ve),_(ee),_(xe),_(ne),_(ke,e),_(Je),_(Ue),_(te),_(Ge),_(se),_($e,e),_(Ze),_(Be),_(Ce,e)}}}const Ns='{"title":"생성","local":"generation","sections":[{"title":"GenerationConfig","local":"transformers.GenerationConfig ][ transformers.GenerationConfig","sections":[],"depth":2},{"title":"GenerationMixin","local":"transformers.GenerationMixin ][ transformers.GenerationMixin","sections":[],"depth":2},{"title":"TFGenerationMixin","local":"transformers.TFGenerationMixin ][ transformers.TFGenerationMixin","sections":[],"depth":2},{"title":"FlaxGenerationMixin","local":"transformers.FlaxGenerationMixin ][ transformers.FlaxGenerationMixin","sections":[],"depth":2}],"depth":1}';function Es(V){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Os extends Bs{constructor(l){super(),Cs(this,l,Es,Fs,$s,{})}}export{Os as component};
