import{s as we,n as he,o as de}from"../chunks/scheduler.25b97de1.js";import{S as ge,i as Ie,g as M,s as a,r,A as Ce,h as i,f as l,c as n,j as Te,u as p,x as o,k as Ft,y as fe,a as s,v as y,d as m,t as c,w as j}from"../chunks/index.d9030fc9.js";import{C as U}from"../chunks/CodeBlock.e6cd0d95.js";import{D as be}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as zt,E as Ae}from"../chunks/EditOnGithub.91d95064.js";function Ze(Yt){let J,at,lt,nt,w,Mt,h,it,d,Lt="Image-text-to-text models, also known as vision language models (VLMs), are language models that take an image input. These models can tackle various tasks, from visual question answering to image segmentation. This task shares many similarities with image-to-text, but with some overlapping use cases like image captioning. Image-to-text models only take image inputs and often accomplish a specific task, whereas VLMs take open-ended text and image inputs and are more generalist models.",ot,g,Pt="In this guide, we provide a brief overview of VLMs and show how to use them with Transformers for inference.",rt,I,Dt="To begin with, there are multiple types of VLMs:",pt,C,Kt="<li>base models used for fine-tuning</li> <li>chat fine-tuned models for conversation</li> <li>instruction fine-tuned models</li>",yt,f,Ot="This guide focuses on inference with an instruction-tuned model.",mt,b,te="Let’s begin installing the dependencies.",ct,A,jt,Z,ee="Let’s initialize the model and the processor.",Ut,_,Jt,x,le='This model has a <a href="./chat_templating">chat template</a> that helps user parse chat outputs. Moreover, the model can also accept multiple images as input in a single conversation or message. We will now prepare the inputs.',ut,B,se="The image inputs look like the following.",Tt,u,ae='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png" alt="Two cats sitting on a net"/>',wt,T,ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="A bee on a pink flower"/>',ht,v,dt,W,Me="Below is an example of the chat template. We can feed conversation turns and the last message as an input by appending it at the end of the template.",gt,k,It,Q,ie='We will now call the processors’ <a href="/docs/transformers/pr_30803/en/main_classes/processors#transformers.ProcessorMixin.apply_chat_template">apply_chat_template()</a> method to preprocess its output along with the image inputs.',Ct,E,ft,R,oe="We can now pass the preprocessed inputs to the model.",bt,V,At,X,Zt,$,re='We can use <a href="./generation_strategies#streaming">text streaming</a> for a better generation experience. Transformers supports streaming with the <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TextStreamer">TextStreamer</a> or <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> classes. We will use the <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> with IDEFICS-8B.',_t,G,pe='Assume we have an application that keeps chat history and takes in the new user input. We will preprocess the inputs as usual and initialize <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> to handle the generation in a separate thread. This allows you to stream the generated text tokens in real-time. Any generation arguments can be passed to <a href="/docs/transformers/pr_30803/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a>.',xt,q,Bt,N,ye="Now let’s call the <code>model_inference</code> function we created and stream the values.",vt,H,Wt,S,kt,F,me='VLMs are often large and need to be optimized to fit on smaller hardware. Transformers supports many model quantization libraries, and here we will only show int8 quantization with <a href="./quantization/quanto#quanto">Quanto</a>. int8 quantization offers memory improvements up to 75 percent (if all weights are quantized). However it is no free lunch, since 8-bit is not a CUDA-native precision, the weights are quantized back and forth on the fly, which adds up to latency.',Qt,z,ce="First, install dependencies.",Et,Y,Rt,L,je='To quantize a model during loading, we need to first create <a href="/docs/transformers/pr_30803/en/main_classes/quantization#transformers.QuantoConfig">QuantoConfig</a>. Then load the model as usual, but pass <code>quantization_config</code> during model initialization.',Vt,P,Xt,D,Ue="And that’s it, we can use the model the same way with no changes.",$t,K,Gt,O,Je="Here are some more resources for the image-text-to-text task.",qt,tt,ue='<li><a href="https://huggingface.co/tasks/image-text-to-text" rel="nofollow">Image-text-to-text task page</a> covers model types, use cases, datasets, and more.</li> <li><a href="https://huggingface.co/blog/vlms" rel="nofollow">Vision Language Models Explained</a> is a blog post that covers everything about vision language models and supervised fine-tuning using <a href="https://huggingface.co/docs/trl/en/index" rel="nofollow">TRL</a>.</li>',Nt,et,Ht,st,St;return w=new zt({props:{title:"Image-text-to-text",local:"image-text-to-text",headingTag:"h1"}}),h=new be({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_text_to_text.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_text_to_text.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_text_to_text.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_text_to_text.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_text_to_text.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_text_to_text.ipynb"}]}}),A=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGZsYXNoX2F0dG4=",highlighted:"pip install -q transformers accelerate flash_attn",wrap:!1}}),_=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljczItOGIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50byhkZXZpY2UpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MyLThiJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
model = AutoModelForImageTextToText.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(device)

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>)`,wrap:!1}}),v=new U({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJscyUyMCUzRCU1QiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiU1RCUwQWltYWdlcyUyMCUzRCUyMCU1QkltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmxzJTVCMCU1RCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChpbWdfdXJscyU1QjElNUQlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTVE",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_urls =[<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>,
           <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>]
images = [Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">0</span>], stream=<span class="hljs-literal">True</span>).raw),
          Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">1</span>], stream=<span class="hljs-literal">True</span>).raw)]`,wrap:!1}}),k=new U({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JTIwZG8lMjB3ZSUyMHNlZSUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJJbiUyMHRoaXMlMjBpbWFnZSUyMHdlJTIwY2FuJTIwc2VlJTIwdHdvJTIwY2F0cyUyMG9uJTIwdGhlJTIwbmV0cy4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJBbmQlMjBob3clMjBhYm91dCUyMHRoaXMlMjBpbWFnZSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RA==",highlighted:`messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What do we see in this image?&quot;</span>},
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;In this image we can see two cats on the nets.&quot;</span>},
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;And how about this image?&quot;</span>},
        ]
    },
]`,wrap:!1}}),E=new U({props:{code:"cHJvbXB0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwaW1hZ2VzJTNEJTVCaW1hZ2VzJTVCMCU1RCUyQyUyMGltYWdlcyU1QjElNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2Up",highlighted:`prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(text=prompt, images=[images[<span class="hljs-number">0</span>], images[<span class="hljs-number">1</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)`,wrap:!1}}),V=new U({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTAwKSUwQWdlbmVyYXRlZF90ZXh0cyUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQXByaW50KGdlbmVyYXRlZF90ZXh0cyklMEElMjMlMjMlMjAlNUInVXNlciUzQSUyMFdoYXQlMjBkbyUyMHdlJTIwc2VlJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUNuQXNzaXN0YW50JTNBJTIwSW4lMjB0aGlzJTIwaW1hZ2UlMjB3ZSUyMGNhbiUyMHNlZSUyMHR3byUyMGNhdHMlMjBvbiUyMHRoZSUyMG5ldHMuJTIwJTVDblVzZXIlM0ElMjBBbmQlMjBob3clMjBhYm91dCUyMHRoaXMlMjBpbWFnZSUzRiUyMCU1Q25Bc3Npc3RhbnQlM0ElMjBJbiUyMHRoaXMlMjBpbWFnZSUyMHdlJTIwY2FuJTIwc2VlJTIwZmxvd2VycyUyQyUyMHBsYW50cyUyMGFuZCUyMGluc2VjdC4nJTVE",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">500</span>)
generated_texts = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-built_in">print</span>(generated_texts)
<span class="hljs-comment">## [&#x27;User: What do we see in this image? \\nAssistant: In this image we can see two cats on the nets. \\nUser: And how about this image? \\nAssistant: In this image we can see flowers, plants and insect.&#x27;]</span>`,wrap:!1}}),X=new zt({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),q=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TextIteratorStreamer
<span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_inference</span>(<span class="hljs-params">
    user_prompt,
    chat_history,
    max_new_tokens,
    images
</span>):
    user_prompt = {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: user_prompt},
        ]
    }
    chat_history.append(user_prompt)
    streamer = TextIteratorStreamer(
        processor.tokenizer,
        skip_prompt=<span class="hljs-literal">True</span>,
        timeout=<span class="hljs-number">5.0</span>,
    )

    generation_args = {
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: max_new_tokens,
        <span class="hljs-string">&quot;streamer&quot;</span>: streamer,
        <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">False</span>
    }

    <span class="hljs-comment"># add_generation_prompt=True makes model generate bot response</span>
    prompt = processor.apply_chat_template(chat_history, add_generation_prompt=<span class="hljs-literal">True</span>)
    inputs = processor(
        text=prompt,
        images=images,
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    ).to(device)
    generation_args.update(inputs)

    thread = Thread(
        target=model.generate,
        kwargs=generation_args,
    )
    thread.start()

    acc_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> text_token <span class="hljs-keyword">in</span> streamer:
        time.sleep(<span class="hljs-number">0.04</span>)
        acc_text += text_token
        <span class="hljs-keyword">if</span> acc_text.endswith(<span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>):
            acc_text = acc_text[:-<span class="hljs-number">18</span>]
        <span class="hljs-keyword">yield</span> acc_text

    thread.join()`,wrap:!1}}),H=new U({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwbW9kZWxfaW5mZXJlbmNlKCUwQSUyMCUyMCUyMCUyMHVzZXJfcHJvbXB0JTNEJTIyQW5kJTIwd2hhdCUyMGlzJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBjaGF0X2hpc3RvcnklM0RtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEaW1hZ2VzJTBBKSUwQSUwQWZvciUyMHZhbHVlJTIwaW4lMjBnZW5lcmF0b3IlM0ElMEElMjAlMjBwcmludCh2YWx1ZSklMEElMEElMjMlMjBJbiUwQSUyMyUyMEluJTIwdGhpcyUwQSUyMyUyMEluJTIwdGhpcyUyMGltYWdlJTIwLi4u",highlighted:`generator = model_inference(
    user_prompt=<span class="hljs-string">&quot;And what is in this image?&quot;</span>,
    chat_history=messages,
    max_new_tokens=<span class="hljs-number">100</span>,
    images=images
)

<span class="hljs-keyword">for</span> value <span class="hljs-keyword">in</span> generator:
  <span class="hljs-built_in">print</span>(value)

<span class="hljs-comment"># In</span>
<span class="hljs-comment"># In this</span>
<span class="hljs-comment"># In this image ...</span>`,wrap:!1}}),S=new zt({props:{title:"Fit models in smaller hardware",local:"fit-models-in-smaller-hardware",headingTag:"h2"}}),Y=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwcXVhbnRvJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U quanto bitsandbytes",wrap:!1}}),P=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MyLThiJTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzJTNEJTIyaW50OCUyMiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, QuantoConfig

model_id = <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>
quantization_config = QuantoConfig(weights=<span class="hljs-string">&quot;int8&quot;</span>)
quantized_model = AutoModelForImageTextToText.from_pretrained(
    model_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, quantization_config=quantization_config
)`,wrap:!1}}),K=new zt({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),et=new Ae({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_text_to_text.md"}}),{c(){J=M("meta"),at=a(),lt=M("p"),nt=a(),r(w.$$.fragment),Mt=a(),r(h.$$.fragment),it=a(),d=M("p"),d.textContent=Lt,ot=a(),g=M("p"),g.textContent=Pt,rt=a(),I=M("p"),I.textContent=Dt,pt=a(),C=M("ul"),C.innerHTML=Kt,yt=a(),f=M("p"),f.textContent=Ot,mt=a(),b=M("p"),b.textContent=te,ct=a(),r(A.$$.fragment),jt=a(),Z=M("p"),Z.textContent=ee,Ut=a(),r(_.$$.fragment),Jt=a(),x=M("p"),x.innerHTML=le,ut=a(),B=M("p"),B.textContent=se,Tt=a(),u=M("div"),u.innerHTML=ae,wt=a(),T=M("div"),T.innerHTML=ne,ht=a(),r(v.$$.fragment),dt=a(),W=M("p"),W.textContent=Me,gt=a(),r(k.$$.fragment),It=a(),Q=M("p"),Q.innerHTML=ie,Ct=a(),r(E.$$.fragment),ft=a(),R=M("p"),R.textContent=oe,bt=a(),r(V.$$.fragment),At=a(),r(X.$$.fragment),Zt=a(),$=M("p"),$.innerHTML=re,_t=a(),G=M("p"),G.innerHTML=pe,xt=a(),r(q.$$.fragment),Bt=a(),N=M("p"),N.innerHTML=ye,vt=a(),r(H.$$.fragment),Wt=a(),r(S.$$.fragment),kt=a(),F=M("p"),F.innerHTML=me,Qt=a(),z=M("p"),z.textContent=ce,Et=a(),r(Y.$$.fragment),Rt=a(),L=M("p"),L.innerHTML=je,Vt=a(),r(P.$$.fragment),Xt=a(),D=M("p"),D.textContent=Ue,$t=a(),r(K.$$.fragment),Gt=a(),O=M("p"),O.textContent=Je,qt=a(),tt=M("ul"),tt.innerHTML=ue,Nt=a(),r(et.$$.fragment),Ht=a(),st=M("p"),this.h()},l(t){const e=Ce("svelte-u9bgzb",document.head);J=i(e,"META",{name:!0,content:!0}),e.forEach(l),at=n(t),lt=i(t,"P",{}),Te(lt).forEach(l),nt=n(t),p(w.$$.fragment,t),Mt=n(t),p(h.$$.fragment,t),it=n(t),d=i(t,"P",{"data-svelte-h":!0}),o(d)!=="svelte-16zti1"&&(d.textContent=Lt),ot=n(t),g=i(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1fk5u1j"&&(g.textContent=Pt),rt=n(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-ql8pa"&&(I.textContent=Dt),pt=n(t),C=i(t,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-1vpzkb0"&&(C.innerHTML=Kt),yt=n(t),f=i(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1m8dinx"&&(f.textContent=Ot),mt=n(t),b=i(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-5jp6fp"&&(b.textContent=te),ct=n(t),p(A.$$.fragment,t),jt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1rw69r9"&&(Z.textContent=ee),Ut=n(t),p(_.$$.fragment,t),Jt=n(t),x=i(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-sa4wix"&&(x.innerHTML=le),ut=n(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-5oehs9"&&(B.textContent=se),Tt=n(t),u=i(t,"DIV",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-z5b734"&&(u.innerHTML=ae),wt=n(t),T=i(t,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-vw53ct"&&(T.innerHTML=ne),ht=n(t),p(v.$$.fragment,t),dt=n(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-it4u80"&&(W.textContent=Me),gt=n(t),p(k.$$.fragment,t),It=n(t),Q=i(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1fd9oec"&&(Q.innerHTML=ie),Ct=n(t),p(E.$$.fragment,t),ft=n(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1c12q4j"&&(R.textContent=oe),bt=n(t),p(V.$$.fragment,t),At=n(t),p(X.$$.fragment,t),Zt=n(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1ep3n0b"&&($.innerHTML=re),_t=n(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1ij5pg8"&&(G.innerHTML=pe),xt=n(t),p(q.$$.fragment,t),Bt=n(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1or0ggk"&&(N.innerHTML=ye),vt=n(t),p(H.$$.fragment,t),Wt=n(t),p(S.$$.fragment,t),kt=n(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1qxdmp"&&(F.innerHTML=me),Qt=n(t),z=i(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1kehp8k"&&(z.textContent=ce),Et=n(t),p(Y.$$.fragment,t),Rt=n(t),L=i(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-ll06i"&&(L.innerHTML=je),Vt=n(t),p(P.$$.fragment,t),Xt=n(t),D=i(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1174nfw"&&(D.textContent=Ue),$t=n(t),p(K.$$.fragment,t),Gt=n(t),O=i(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-n9r3vs"&&(O.textContent=Je),qt=n(t),tt=i(t,"UL",{"data-svelte-h":!0}),o(tt)!=="svelte-30a4e"&&(tt.innerHTML=ue),Nt=n(t),p(et.$$.fragment,t),Ht=n(t),st=i(t,"P",{}),Te(st).forEach(l),this.h()},h(){Ft(J,"name","hf:doc:metadata"),Ft(J,"content",_e),Ft(u,"class","flex justify-center"),Ft(T,"class","flex justify-center")},m(t,e){fe(document.head,J),s(t,at,e),s(t,lt,e),s(t,nt,e),y(w,t,e),s(t,Mt,e),y(h,t,e),s(t,it,e),s(t,d,e),s(t,ot,e),s(t,g,e),s(t,rt,e),s(t,I,e),s(t,pt,e),s(t,C,e),s(t,yt,e),s(t,f,e),s(t,mt,e),s(t,b,e),s(t,ct,e),y(A,t,e),s(t,jt,e),s(t,Z,e),s(t,Ut,e),y(_,t,e),s(t,Jt,e),s(t,x,e),s(t,ut,e),s(t,B,e),s(t,Tt,e),s(t,u,e),s(t,wt,e),s(t,T,e),s(t,ht,e),y(v,t,e),s(t,dt,e),s(t,W,e),s(t,gt,e),y(k,t,e),s(t,It,e),s(t,Q,e),s(t,Ct,e),y(E,t,e),s(t,ft,e),s(t,R,e),s(t,bt,e),y(V,t,e),s(t,At,e),y(X,t,e),s(t,Zt,e),s(t,$,e),s(t,_t,e),s(t,G,e),s(t,xt,e),y(q,t,e),s(t,Bt,e),s(t,N,e),s(t,vt,e),y(H,t,e),s(t,Wt,e),y(S,t,e),s(t,kt,e),s(t,F,e),s(t,Qt,e),s(t,z,e),s(t,Et,e),y(Y,t,e),s(t,Rt,e),s(t,L,e),s(t,Vt,e),y(P,t,e),s(t,Xt,e),s(t,D,e),s(t,$t,e),y(K,t,e),s(t,Gt,e),s(t,O,e),s(t,qt,e),s(t,tt,e),s(t,Nt,e),y(et,t,e),s(t,Ht,e),s(t,st,e),St=!0},p:he,i(t){St||(m(w.$$.fragment,t),m(h.$$.fragment,t),m(A.$$.fragment,t),m(_.$$.fragment,t),m(v.$$.fragment,t),m(k.$$.fragment,t),m(E.$$.fragment,t),m(V.$$.fragment,t),m(X.$$.fragment,t),m(q.$$.fragment,t),m(H.$$.fragment,t),m(S.$$.fragment,t),m(Y.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(et.$$.fragment,t),St=!0)},o(t){c(w.$$.fragment,t),c(h.$$.fragment,t),c(A.$$.fragment,t),c(_.$$.fragment,t),c(v.$$.fragment,t),c(k.$$.fragment,t),c(E.$$.fragment,t),c(V.$$.fragment,t),c(X.$$.fragment,t),c(q.$$.fragment,t),c(H.$$.fragment,t),c(S.$$.fragment,t),c(Y.$$.fragment,t),c(P.$$.fragment,t),c(K.$$.fragment,t),c(et.$$.fragment,t),St=!1},d(t){t&&(l(at),l(lt),l(nt),l(Mt),l(it),l(d),l(ot),l(g),l(rt),l(I),l(pt),l(C),l(yt),l(f),l(mt),l(b),l(ct),l(jt),l(Z),l(Ut),l(Jt),l(x),l(ut),l(B),l(Tt),l(u),l(wt),l(T),l(ht),l(dt),l(W),l(gt),l(It),l(Q),l(Ct),l(ft),l(R),l(bt),l(At),l(Zt),l($),l(_t),l(G),l(xt),l(Bt),l(N),l(vt),l(Wt),l(kt),l(F),l(Qt),l(z),l(Et),l(Rt),l(L),l(Vt),l(Xt),l(D),l($t),l(Gt),l(O),l(qt),l(tt),l(Nt),l(Ht),l(st)),l(J),j(w,t),j(h,t),j(A,t),j(_,t),j(v,t),j(k,t),j(E,t),j(V,t),j(X,t),j(q,t),j(H,t),j(S,t),j(Y,t),j(P,t),j(K,t),j(et,t)}}}const _e='{"title":"Image-text-to-text","local":"image-text-to-text","sections":[{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Fit models in smaller hardware","local":"fit-models-in-smaller-hardware","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function xe(Yt){return de(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends ge{constructor(J){super(),Ie(this,J,xe,Ze,we,{})}}export{Ee as component};
