import{s as oa,f as aa,o as sa,n as st}from"../chunks/scheduler.25b97de1.js";import{S as na,i as la,g as r,s,r as d,A as ra,h as i,f as o,c as n,j as Z,u as m,x as f,k as j,y as M,a,v as p,d as h,t as g,w as u}from"../chunks/index.d9030fc9.js";import{T as vo}from"../chunks/Tip.baa67368.js";import{D as Y}from"../chunks/Docstring.ffac8efa.js";import{C as L}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ta}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as x,E as ia}from"../chunks/EditOnGithub.91d95064.js";function ca(C){let l,J="<li>Llava-Next uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){l=r("ul"),l.innerHTML=J},l(T){l=i(T,"UL",{"data-svelte-h":!0}),f(l)!=="svelte-17g7vjy"&&(l.innerHTML=J)},m(T,y){a(T,l,y)},p:st,d(T){T&&o(l)}}}function da(C){let l,J='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',T,y,_='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){l=r("p"),l.innerHTML=J,T=s(),y=r("p"),y.innerHTML=_},l(c){l=i(c,"P",{"data-svelte-h":!0}),f(l)!=="svelte-nz63kd"&&(l.innerHTML=J),T=n(c),y=i(c,"P",{"data-svelte-h":!0}),f(y)!=="svelte-aze40l"&&(y.innerHTML=_)},m(c,v){a(c,l,v),a(c,T,v),a(c,y,v)},p:st,d(c){c&&(o(l),o(T),o(y))}}}function ma(C){let l,J="Example:",T,y,_;return y=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMExsYXZhTmV4dENvbmZpZyUyQyUyMENMSVBWaXNpb25Db25maWclMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQLXZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBDTElQVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhbWElMjBjb25maWclMEF0ZXh0X2NvbmZpZyUyMCUzRCUyMExsYW1hQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhdmEtTmV4dCUyMGxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYXZhTmV4dENvbmZpZyh2aXNpb25fY29uZmlnJTJDJTIwdGV4dF9jb25maWcpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU5leHRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextForConditionalGeneration, LlavaNextConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava-Next llava-hf/llava-v1.6-mistral-7b-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaNextConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-hf/llava-v1.6-mistral-7b-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=r("p"),l.textContent=J,T=s(),d(y.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),f(l)!=="svelte-11lpom8"&&(l.textContent=J),T=n(c),m(y.$$.fragment,c)},m(c,v){a(c,l,v),a(c,T,v),p(y,c,v),_=!0},p:st,i(c){_||(h(y.$$.fragment,c),_=!0)},o(c){g(y.$$.fragment,c),_=!1},d(c){c&&(o(l),o(T)),u(y,c)}}}function pa(C){let l,J=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=J},l(T){l=i(T,"P",{"data-svelte-h":!0}),f(l)!=="svelte-fincs2"&&(l.innerHTML=J)},m(T,y){a(T,l,y)},p:st,d(T){T&&o(l)}}}function ha(C){let l,J="Example:",T,y,_;return y=new L({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMExsYXZhTmV4dEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhdmFOZXh0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLXYxLjYtbWlzdHJhbC03Yi1oZiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLXYxLjYtbWlzdHJhbC03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlNUJJTlNUJTVEJTIwJTNDaW1hZ2UlM0UlNUNuV2hhdCUyMGlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUyMCU1QiUyRklOU1QlNUQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaNextForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat is shown in this image? [/INST]&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;[INST]  \\nWhat is shown in this image? [/INST] The image appears to be a radar chart, which is a type of multi-dimensional plot (...)&quot;</span>`,wrap:!1}}),{c(){l=r("p"),l.textContent=J,T=s(),d(y.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),f(l)!=="svelte-11lpom8"&&(l.textContent=J),T=n(c),m(y.$$.fragment,c)},m(c,v){a(c,l,v),a(c,T,v),p(y,c,v),_=!0},p:st,i(c){_||(h(y.$$.fragment,c),_=!0)},o(c){g(y.$$.fragment,c),_=!1},d(c){c&&(o(l),o(T)),u(y,c)}}}function ga(C){let l,J,T,y,_,c,v,nt,E,wo='The LLaVA-NeXT model was proposed in <a href="https://llava-vl.github.io/blog/2024-01-30-llava-next/" rel="nofollow">LLaVA-NeXT: Improved reasoning, OCR, and world knowledge</a> by Haotian Liu, Chunyuan Li, Yuheng Li, Bo Li, Yuanhan Zhang, Sheng Shen, Yong Jae Lee. LLaVa-NeXT (also called LLaVa-1.6) improves upon <a href="llava">LLaVa</a> by increasing the input image resolution and training on an improved visual instruction tuning dataset to improve OCR and common sense reasoning.',lt,S,bo="The introduction from the blog is the following:",rt,P,Uo="*In October 2023, we released LLaVA-1.5 with a simple and efficient design along with great performance on a benchmark suite of 12 datasets. It has since served as the foundation of many comprehensive studies of data, model, and capabilities of large multimodal models (LMM), and has enabled various new applications.",it,A,Io="Today, we are thrilled to present LLaVA-NeXT, with improved reasoning, OCR, and world knowledge. LLaVA-NeXT even exceeds Gemini Pro on several benchmarks.",ct,D,jo="Compared with LLaVA-1.5, LLaVA-NeXT has several improvements:",dt,O,xo=`Increasing the input image resolution to 4x more pixels. This allows it to grasp more visual details. It supports three aspect ratios, up to 672x672, 336x1344, 1344x336 resolution.
Better visual reasoning and OCR capability with an improved visual instruction tuning data mixture.
Better visual conversation for more scenarios, covering different applications. Better world knowledge and logical reasoning.
Efficient deployment and inference with SGLang.
Along with performance improvements, LLaVA-NeXT maintains the minimalist design and data efficiency of LLaVA-1.5. It re-uses the pretrained connector of LLaVA-1.5, and still uses less than 1M visual instruction tuning samples. The largest 34B variant finishes training in ~1 day with 32 A100s.*`,mt,B,Co,pt,K,No='LLaVa-NeXT incorporates a higher input resolution by encoding various patches of the input image. Taken from the <a href="https://arxiv.org/abs/2310.03744">original paper.</a>',ht,ee,Lo=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/haotian-liu/LLaVA/tree/main" rel="nofollow">here</a>.`,gt,te,ut,oe,zo="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",ft,k,Tt,ae,$o="<li>Note that each checkpoint has been trained with a specific prompt format, depending on which large language model (LLM) was used. You can use the processor’s <code>apply_chat_template</code> to format your prompts correctly. For that you have to construct a conversation history, passing a plain string will not format your prompt. Each message in the conversation history for chat templates is a dictionary with keys “role” and “content”. The “content” should be a list of dictionaries, for “text” and “image” modalities. Below is an example of how to do that and the list of formats accepted by each checkpoint.</li>",yt,se,Zo='We will use <a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-v1.6-mistral-7b-hf</a> and a conversation history of text and image. Each content field has to be a list of dicts, as follows:',Mt,ne,_t,le,Wo=`<li>If you want to construct a chat prompt yourself, below is a list of possible formats
.
<a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-v1.6-mistral-7b-hf</a> requires the following format:</li>`,Jt,re,vt,ie,Bo='<a href="https://huggingface.co/llava-hf/llava-v1.6-vicuna-7b-hf" rel="nofollow">llava-v1.6-vicuna-7b-hf</a> and <a href="https://huggingface.co/llava-hf/llava-v1.6-vicuna-13b-hf" rel="nofollow">llava-v1.6-vicuna-13b-hf</a> require the following format:',wt,ce,bt,de,ko='<a href="https://huggingface.co/llava-hf/llava-v1.6-34b-hf" rel="nofollow">llava-v1.6-34b-hf</a> requires the following format:',Ut,me,It,pe,qo='<a href="https://huggingface.co/llava-hf/llava-next-8b-hf" rel="nofollow">llama3-llava-next-8b-hf</a> requires the following format:',jt,he,xt,ge,Go='<a href="https://huggingface.co/llava-hf/llava-next-72b-hf" rel="nofollow">llava-next-72b-hf</a> and <a href="https://huggingface.co/llava-hf/llava-next-110b-hf" rel="nofollow">llava-next-110b-hf</a> require the following format:',Ct,ue,Nt,fe,Lt,Te,zt,ye,Vo="Here’s how to load the model and perform inference in half-precision (<code>torch.float16</code>):",$t,Me,Zt,_e,Wt,Je,Ro="LLaVa-Next can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). Here is how you can do it:",Bt,ve,kt,we,qt,be,Gt,Ue,Xo="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code>, and to have access to a GPU/accelerator that is supported by the library.",Vt,q,Rt,Ie,Fo="Simply change the snippet above with:",Xt,je,Ft,xe,Qt,Ce,Qo='First make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository of Flash Attention</a> regarding that package installation. Simply change the snippet above with:',Ht,Ne,Yt,Le,Et,b,ze,so,He,Ho=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-hf/llava-v1.6-mistral-7b-hf</a>
model.`,no,Ye,Yo=`Configuration objects inherit from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,lo,G,St,$e,Pt,z,Ze,ro,Ee,Eo=`Constructs a LLaVa-NeXT image processor. Based on <a href="/docs/transformers/pr_30803/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> with incorporation of additional techniques
for processing high resolution images as explained in the <a href="https://arxiv.org/abs/2310.03744" rel="nofollow">LLaVa paper</a>.`,io,Se,We,At,Be,Dt,w,ke,co,Pe,So="Constructs a LLaVa-NeXT processor which wraps a LLaVa-NeXT image processor and a LLaMa tokenizer into a single processor.",mo,Ae,Po=`<a href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextProcessor">LlavaNextProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> and <a href="/docs/transformers/pr_30803/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextProcessor.decode">decode()</a> for more information.`,po,V,qe,ho,De,Ao=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,go,R,Ge,uo,Oe,Do=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Ot,Ve,Kt,U,Re,fo,Ke,Oo=`The LLAVA-NeXT model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,To,et,Ko=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,yo,N,Xe,Mo,tt,ea='The <a href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',_o,X,Jo,F,eo,Fe,to,ot,oo;return _=new x({props:{title:"LLaVA-NeXT",local:"llava-next",headingTag:"h1"}}),v=new x({props:{title:"Overview",local:"overview",headingTag:"h2"}}),te=new x({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),k=new vo({props:{warning:!0,$$slots:{default:[ca]},$$scope:{ctx:C}}}),ne=new L({props:{code:"JTBBJTBBJTBBJTBBJTBBJTIyJTVCSU5TVCU1RCUyMCUzQ2ltYWdlJTNFJTVDbldoYXQncyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUIlMkZJTlNUJTVEJTIwVGhpcyUyMGltYWdlJTIwc2hvd3MlMjBhJTIwcmVkJTIwc3RvcCUyMHNpZ24uJTIwJTVCSU5TVCU1RCUyMERlc2NyaWJlJTIwdGhlJTIwaW1hZ2UlMjBpbiUyMG1vcmUlMjBkZXRhaWxzLiUyMCU1QiUyRklOU1QlNUQlMjI=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextProcessor

processor = LlavaNextProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
        ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat&#x27;s shown in this image? [/INST] This image shows a red stop sign. [INST] Describe the image in more details. [/INST]&quot;</span>`,wrap:!1}}),re=new L({props:{code:"JTIyJTVCSU5TVCU1RCUyMCUzQ2ltYWdlJTNFJTVDbldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUIlMkZJTlNUJTVEJTIy",highlighted:'<span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat is shown in this image? [/INST]&quot;</span>',wrap:!1}}),ce=new L({props:{code:"JTIyQSUyMGNoYXQlMjBiZXR3ZWVuJTIwYSUyMGN1cmlvdXMlMjBodW1hbiUyMGFuZCUyMGFuJTIwYXJ0aWZpY2lhbCUyMGludGVsbGlnZW5jZSUyMGFzc2lzdGFudC4lMjBUaGUlMjBhc3Npc3RhbnQlMjBnaXZlcyUyMGhlbHBmdWwlMkMlMjBkZXRhaWxlZCUyQyUyMGFuZCUyMHBvbGl0ZSUyMGFuc3dlcnMlMjB0byUyMHRoZSUyMGh1bWFuJ3MlMjBxdWVzdGlvbnMuJTIwVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjBBU1NJU1RBTlQlM0ElMjI=",highlighted:'<span class="hljs-string">&quot;A chat between a curious human and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the human&#x27;s questions. USER: &lt;image&gt;\\nWhat is shown in this image? ASSISTANT:&quot;</span>',wrap:!1}}),me=new L({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lNUNuQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb25zLiUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJTIy",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;system\\nAnswer the questions.&lt;|im_end|&gt;&lt;|im_start|&gt;user\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;&lt;|im_start|&gt;assistant\\n&quot;</span>',wrap:!1}}),he=new L({props:{code:"JTIyJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFc3lzdGVtJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBsYW5ndWFnZSUyMGFuZCUyMHZpc2lvbiUyMGFzc2lzdGFudC4lMjBZb3UlMjBhcmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwdGhlJTIwdmlzdWFsJTIwY29udGVudCUyMHRoYXQlMjB0aGUlMjB1c2VyJTIwcHJvdmlkZXMlMkMlMjBhbmQlMjBhc3Npc3QlMjB0aGUlMjB1c2VyJTIwd2l0aCUyMGElMjB2YXJpZXR5JTIwb2YlMjB0YXNrcyUyMHVzaW5nJTIwbmF0dXJhbCUyMGxhbmd1YWdlLiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuJTIy",highlighted:'<span class="hljs-string">&quot;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are a helpful language and vision assistant. You are able to understand the visual content that the user provides, and assist the user with a variety of tasks using natural language.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>',wrap:!1}}),ue=new L({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lNUNuWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&quot;</span>',wrap:!1}}),fe=new x({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Te=new x({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),Me=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextProcessor, LlavaNextForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = LlavaNextProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

model = LlavaNextForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)
model.to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt, using the appropriate prompt template</span>
url = <span class="hljs-string">&quot;https://github.com/haotian-liu/LLaVA/blob/1a91fc274d7c35a9b50b3cb29c4247ae5837ce39/images/llava_v1_5_radar.jpg?raw=true&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(image, prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)

<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),_e=new x({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),ve=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-comment"># Load the model in half-precision</span>
model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batch of two prompts, where the first one is a multi-turn conversation and the second is not</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a red stop sign in the image.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What about this image? How many cats do you see?&quot;</span>},
            ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
]

prompt_1 = processor.apply_chat_template(conversation_1, add_generation_prompt=<span class="hljs-literal">True</span>)
prompt_2 = processor.apply_chat_template(conversation_2, add_generation_prompt=<span class="hljs-literal">True</span>)
prompts = [prompt_1, prompt_2]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
<span class="hljs-comment"># Each &quot;&lt;image&gt;&quot; token uses one image leaving the next for the subsequent &quot;&lt;image&gt;&quot; tokens</span>
inputs = processor(images=[image_stop, image_cats, image_snowman], text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)`,wrap:!1}}),we=new x({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),be=new x({props:{title:"Quantization using Bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),q=new vo({props:{$$slots:{default:[da]},$$scope:{ctx:C}}}),je=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQSUyMyUyMHNwZWNpZnklMjBob3clMjB0byUyMHF1YW50aXplJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),xe=new x({props:{title:"Use Flash-Attention 2 to further speed-up generation",local:"use-flash-attention-2-to-further-speed-up-generation",headingTag:"h3"}}),Ne=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGxvd19jcHVfbWVtX3VzYWdlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9mbGFzaF9hdHRlbnRpb25fMiUzRFRydWUlMEEpLnRvKDAp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText

model = AutoModelForImageTextToText.from_pretrained(
    model_id,
    torch_dtype=torch.float16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Le=new x({props:{title:"LlavaNextConfig",local:"transformers.LlavaNextConfig",headingTag:"h2"}}),ze=new Y({props:{name:"class transformers.LlavaNextConfig",anchor:"transformers.LlavaNextConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"ignore_index",val:" = -100"},{name:"image_token_index",val:" = 32000"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"image_seq_length",val:" = 576"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaNextConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaNextConfig.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to -100) &#x2014;
The ignore index for the loss function.`,name:"ignore_index"},{anchor:"transformers.LlavaNextConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaNextConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaNextConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[[336, 672], [672, 336], [672, 672], [1008, 336], [336, 1008]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaNextConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/llava_next/configuration_llava_next.py#L24"}}),G=new ta({props:{anchor:"transformers.LlavaNextConfig.example",$$slots:{default:[ma]},$$scope:{ctx:C}}}),$e=new x({props:{title:"LlavaNextImageProcessor",local:"transformers.LlavaNextImageProcessor",headingTag:"h2"}}),Ze=new Y({props:{name:"class transformers.LlavaNextImageProcessor",anchor:"transformers.LlavaNextImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"image_grid_pinpoints",val:": List = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = True"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaNextImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/llava_next/image_processing_llava_next.py#L142"}}),We=new Y({props:{name:"preprocess",anchor:"transformers.LlavaNextImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"image_grid_pinpoints",val:": List = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>self.image_grid_pinpoints</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is
selected based on the original size of the image.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/llava_next/image_processing_llava_next.py#L581"}}),Be=new x({props:{title:"LlavaNextProcessor",local:"transformers.LlavaNextProcessor",headingTag:"h2"}}),ke=new Y({props:{name:"class transformers.LlavaNextProcessor",anchor:"transformers.LlavaNextProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaNextProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaNextProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.LlavaNextProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaNextProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/llava_next/processing_llava_next.py#L43"}}),qe=new Y({props:{name:"batch_decode",anchor:"transformers.LlavaNextProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/llava_next/processing_llava_next.py#L210"}}),Ge=new Y({props:{name:"decode",anchor:"transformers.LlavaNextProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/llava_next/processing_llava_next.py#L218"}}),Ve=new x({props:{title:"LlavaNextForConditionalGeneration",local:"transformers.LlavaNextForConditionalGeneration",headingTag:"h2"}}),Re=new Y({props:{name:"class transformers.LlavaNextForConditionalGeneration",anchor:"transformers.LlavaNextForConditionalGeneration",parameters:[{name:"config",val:": LlavaNextConfig"}],parametersDescription:[{anchor:"transformers.LlavaNextForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextConfig">LlavaNextConfig</a> or <code>LlavaNextVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/llava_next/modeling_llava_next.py#L349"}}),Xe=new Y({props:{name:"forward",anchor:"transformers.LlavaNextForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"vision_feature_layer",val:": Optional = None"},{name:"vision_feature_select_strategy",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"},{name:"num_logits_to_keep",val:": int = 0"}],parametersDescription:[{anchor:"transformers.LlavaNextForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30803/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">LlavaNextImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/pr_30803/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/llava_next/modeling_llava_next.py#L717",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_next.modeling_llava_next.LlavaNextCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30803/en/model_doc/llava_next#transformers.LlavaNextConfig"
>LlavaNextConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size * num_patches, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_next.modeling_llava_next.LlavaNextCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new vo({props:{$$slots:{default:[pa]},$$scope:{ctx:C}}}),F=new ta({props:{anchor:"transformers.LlavaNextForConditionalGeneration.forward.example",$$slots:{default:[ha]},$$scope:{ctx:C}}}),Fe=new ia({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_next.md"}}),{c(){l=r("meta"),J=s(),T=r("p"),y=s(),d(_.$$.fragment),c=s(),d(v.$$.fragment),nt=s(),E=r("p"),E.innerHTML=wo,lt=s(),S=r("p"),S.textContent=bo,rt=s(),P=r("p"),P.textContent=Uo,it=s(),A=r("p"),A.textContent=Io,ct=s(),D=r("p"),D.textContent=jo,dt=s(),O=r("p"),O.textContent=xo,mt=s(),B=r("img"),pt=s(),K=r("small"),K.innerHTML=No,ht=s(),ee=r("p"),ee.innerHTML=Lo,gt=s(),d(te.$$.fragment),ut=s(),oe=r("ul"),oe.innerHTML=zo,ft=s(),d(k.$$.fragment),Tt=s(),ae=r("ul"),ae.innerHTML=$o,yt=s(),se=r("p"),se.innerHTML=Zo,Mt=s(),d(ne.$$.fragment),_t=s(),le=r("ul"),le.innerHTML=Wo,Jt=s(),d(re.$$.fragment),vt=s(),ie=r("p"),ie.innerHTML=Bo,wt=s(),d(ce.$$.fragment),bt=s(),de=r("p"),de.innerHTML=ko,Ut=s(),d(me.$$.fragment),It=s(),pe=r("p"),pe.innerHTML=qo,jt=s(),d(he.$$.fragment),xt=s(),ge=r("p"),ge.innerHTML=Go,Ct=s(),d(ue.$$.fragment),Nt=s(),d(fe.$$.fragment),Lt=s(),d(Te.$$.fragment),zt=s(),ye=r("p"),ye.innerHTML=Vo,$t=s(),d(Me.$$.fragment),Zt=s(),d(_e.$$.fragment),Wt=s(),Je=r("p"),Je.textContent=Ro,Bt=s(),d(ve.$$.fragment),kt=s(),d(we.$$.fragment),qt=s(),d(be.$$.fragment),Gt=s(),Ue=r("p"),Ue.innerHTML=Xo,Vt=s(),d(q.$$.fragment),Rt=s(),Ie=r("p"),Ie.textContent=Fo,Xt=s(),d(je.$$.fragment),Ft=s(),d(xe.$$.fragment),Qt=s(),Ce=r("p"),Ce.innerHTML=Qo,Ht=s(),d(Ne.$$.fragment),Yt=s(),d(Le.$$.fragment),Et=s(),b=r("div"),d(ze.$$.fragment),so=s(),He=r("p"),He.innerHTML=Ho,no=s(),Ye=r("p"),Ye.innerHTML=Yo,lo=s(),d(G.$$.fragment),St=s(),d($e.$$.fragment),Pt=s(),z=r("div"),d(Ze.$$.fragment),ro=s(),Ee=r("p"),Ee.innerHTML=Eo,io=s(),Se=r("div"),d(We.$$.fragment),At=s(),d(Be.$$.fragment),Dt=s(),w=r("div"),d(ke.$$.fragment),co=s(),Pe=r("p"),Pe.textContent=So,mo=s(),Ae=r("p"),Ae.innerHTML=Po,po=s(),V=r("div"),d(qe.$$.fragment),ho=s(),De=r("p"),De.innerHTML=Ao,go=s(),R=r("div"),d(Ge.$$.fragment),uo=s(),Oe=r("p"),Oe.innerHTML=Do,Ot=s(),d(Ve.$$.fragment),Kt=s(),U=r("div"),d(Re.$$.fragment),fo=s(),Ke=r("p"),Ke.innerHTML=Oo,To=s(),et=r("p"),et.innerHTML=Ko,yo=s(),N=r("div"),d(Xe.$$.fragment),Mo=s(),tt=r("p"),tt.innerHTML=ea,_o=s(),d(X.$$.fragment),Jo=s(),d(F.$$.fragment),eo=s(),d(Fe.$$.fragment),to=s(),ot=r("p"),this.h()},l(e){const t=ra("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),J=n(e),T=i(e,"P",{}),Z(T).forEach(o),y=n(e),m(_.$$.fragment,e),c=n(e),m(v.$$.fragment,e),nt=n(e),E=i(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-5h5la5"&&(E.innerHTML=wo),lt=n(e),S=i(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-1fhv1nu"&&(S.textContent=bo),rt=n(e),P=i(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-1o8aykc"&&(P.textContent=Uo),it=n(e),A=i(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-106g2gs"&&(A.textContent=Io),ct=n(e),D=i(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-o65l2n"&&(D.textContent=jo),dt=n(e),O=i(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-qaxeu7"&&(O.textContent=xo),mt=n(e),B=i(e,"IMG",{src:!0,alt:!0,width:!0}),pt=n(e),K=i(e,"SMALL",{"data-svelte-h":!0}),f(K)!=="svelte-1ueeg46"&&(K.innerHTML=No),ht=n(e),ee=i(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-10gvx7f"&&(ee.innerHTML=Lo),gt=n(e),m(te.$$.fragment,e),ut=n(e),oe=i(e,"UL",{"data-svelte-h":!0}),f(oe)!=="svelte-b32abk"&&(oe.innerHTML=zo),ft=n(e),m(k.$$.fragment,e),Tt=n(e),ae=i(e,"UL",{"data-svelte-h":!0}),f(ae)!=="svelte-1eljsgq"&&(ae.innerHTML=$o),yt=n(e),se=i(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-n4fgvk"&&(se.innerHTML=Zo),Mt=n(e),m(ne.$$.fragment,e),_t=n(e),le=i(e,"UL",{"data-svelte-h":!0}),f(le)!=="svelte-uiv36d"&&(le.innerHTML=Wo),Jt=n(e),m(re.$$.fragment,e),vt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-7fncpd"&&(ie.innerHTML=Bo),wt=n(e),m(ce.$$.fragment,e),bt=n(e),de=i(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-5xtfcu"&&(de.innerHTML=ko),Ut=n(e),m(me.$$.fragment,e),It=n(e),pe=i(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-ia69dt"&&(pe.innerHTML=qo),jt=n(e),m(he.$$.fragment,e),xt=n(e),ge=i(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-cihbm7"&&(ge.innerHTML=Go),Ct=n(e),m(ue.$$.fragment,e),Nt=n(e),m(fe.$$.fragment,e),Lt=n(e),m(Te.$$.fragment,e),zt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-19yw9ck"&&(ye.innerHTML=Vo),$t=n(e),m(Me.$$.fragment,e),Zt=n(e),m(_e.$$.fragment,e),Wt=n(e),Je=i(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-1py9or5"&&(Je.textContent=Ro),Bt=n(e),m(ve.$$.fragment,e),kt=n(e),m(we.$$.fragment,e),qt=n(e),m(be.$$.fragment,e),Gt=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-bd1tou"&&(Ue.innerHTML=Xo),Vt=n(e),m(q.$$.fragment,e),Rt=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-gwf9h7"&&(Ie.textContent=Fo),Xt=n(e),m(je.$$.fragment,e),Ft=n(e),m(xe.$$.fragment,e),Qt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-ujer0t"&&(Ce.innerHTML=Qo),Ht=n(e),m(Ne.$$.fragment,e),Yt=n(e),m(Le.$$.fragment,e),Et=n(e),b=i(e,"DIV",{class:!0});var $=Z(b);m(ze.$$.fragment,$),so=n($),He=i($,"P",{"data-svelte-h":!0}),f(He)!=="svelte-pk333p"&&(He.innerHTML=Ho),no=n($),Ye=i($,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-ur2kjj"&&(Ye.innerHTML=Yo),lo=n($),m(G.$$.fragment,$),$.forEach(o),St=n(e),m($e.$$.fragment,e),Pt=n(e),z=i(e,"DIV",{class:!0});var W=Z(z);m(Ze.$$.fragment,W),ro=n(W),Ee=i(W,"P",{"data-svelte-h":!0}),f(Ee)!=="svelte-heewtr"&&(Ee.innerHTML=Eo),io=n(W),Se=i(W,"DIV",{class:!0});var at=Z(Se);m(We.$$.fragment,at),at.forEach(o),W.forEach(o),At=n(e),m(Be.$$.fragment,e),Dt=n(e),w=i(e,"DIV",{class:!0});var I=Z(w);m(ke.$$.fragment,I),co=n(I),Pe=i(I,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-qcp8uy"&&(Pe.textContent=So),mo=n(I),Ae=i(I,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-nvg1ku"&&(Ae.innerHTML=Po),po=n(I),V=i(I,"DIV",{class:!0});var Qe=Z(V);m(qe.$$.fragment,Qe),ho=n(Qe),De=i(Qe,"P",{"data-svelte-h":!0}),f(De)!=="svelte-jzda4i"&&(De.innerHTML=Ao),Qe.forEach(o),go=n(I),R=i(I,"DIV",{class:!0});var ao=Z(R);m(Ge.$$.fragment,ao),uo=n(ao),Oe=i(ao,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-mjg3jc"&&(Oe.innerHTML=Do),ao.forEach(o),I.forEach(o),Ot=n(e),m(Ve.$$.fragment,e),Kt=n(e),U=i(e,"DIV",{class:!0});var Q=Z(U);m(Re.$$.fragment,Q),fo=n(Q),Ke=i(Q,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-d23z9v"&&(Ke.innerHTML=Oo),To=n(Q),et=i(Q,"P",{"data-svelte-h":!0}),f(et)!=="svelte-hswkmf"&&(et.innerHTML=Ko),yo=n(Q),N=i(Q,"DIV",{class:!0});var H=Z(N);m(Xe.$$.fragment,H),Mo=n(H),tt=i(H,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-780uyd"&&(tt.innerHTML=ea),_o=n(H),m(X.$$.fragment,H),Jo=n(H),m(F.$$.fragment,H),H.forEach(o),Q.forEach(o),eo=n(e),m(Fe.$$.fragment,e),to=n(e),ot=i(e,"P",{}),Z(ot).forEach(o),this.h()},h(){j(l,"name","hf:doc:metadata"),j(l,"content",ua),aa(B.src,Co="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava_next_overview.png")||j(B,"src",Co),j(B,"alt","drawing"),j(B,"width","600"),j(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){M(document.head,l),a(e,J,t),a(e,T,t),a(e,y,t),p(_,e,t),a(e,c,t),p(v,e,t),a(e,nt,t),a(e,E,t),a(e,lt,t),a(e,S,t),a(e,rt,t),a(e,P,t),a(e,it,t),a(e,A,t),a(e,ct,t),a(e,D,t),a(e,dt,t),a(e,O,t),a(e,mt,t),a(e,B,t),a(e,pt,t),a(e,K,t),a(e,ht,t),a(e,ee,t),a(e,gt,t),p(te,e,t),a(e,ut,t),a(e,oe,t),a(e,ft,t),p(k,e,t),a(e,Tt,t),a(e,ae,t),a(e,yt,t),a(e,se,t),a(e,Mt,t),p(ne,e,t),a(e,_t,t),a(e,le,t),a(e,Jt,t),p(re,e,t),a(e,vt,t),a(e,ie,t),a(e,wt,t),p(ce,e,t),a(e,bt,t),a(e,de,t),a(e,Ut,t),p(me,e,t),a(e,It,t),a(e,pe,t),a(e,jt,t),p(he,e,t),a(e,xt,t),a(e,ge,t),a(e,Ct,t),p(ue,e,t),a(e,Nt,t),p(fe,e,t),a(e,Lt,t),p(Te,e,t),a(e,zt,t),a(e,ye,t),a(e,$t,t),p(Me,e,t),a(e,Zt,t),p(_e,e,t),a(e,Wt,t),a(e,Je,t),a(e,Bt,t),p(ve,e,t),a(e,kt,t),p(we,e,t),a(e,qt,t),p(be,e,t),a(e,Gt,t),a(e,Ue,t),a(e,Vt,t),p(q,e,t),a(e,Rt,t),a(e,Ie,t),a(e,Xt,t),p(je,e,t),a(e,Ft,t),p(xe,e,t),a(e,Qt,t),a(e,Ce,t),a(e,Ht,t),p(Ne,e,t),a(e,Yt,t),p(Le,e,t),a(e,Et,t),a(e,b,t),p(ze,b,null),M(b,so),M(b,He),M(b,no),M(b,Ye),M(b,lo),p(G,b,null),a(e,St,t),p($e,e,t),a(e,Pt,t),a(e,z,t),p(Ze,z,null),M(z,ro),M(z,Ee),M(z,io),M(z,Se),p(We,Se,null),a(e,At,t),p(Be,e,t),a(e,Dt,t),a(e,w,t),p(ke,w,null),M(w,co),M(w,Pe),M(w,mo),M(w,Ae),M(w,po),M(w,V),p(qe,V,null),M(V,ho),M(V,De),M(w,go),M(w,R),p(Ge,R,null),M(R,uo),M(R,Oe),a(e,Ot,t),p(Ve,e,t),a(e,Kt,t),a(e,U,t),p(Re,U,null),M(U,fo),M(U,Ke),M(U,To),M(U,et),M(U,yo),M(U,N),p(Xe,N,null),M(N,Mo),M(N,tt),M(N,_o),p(X,N,null),M(N,Jo),p(F,N,null),a(e,eo,t),p(Fe,e,t),a(e,to,t),a(e,ot,t),oo=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),k.$set($);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),q.$set(W);const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),G.$set(at);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),X.$set(I);const Qe={};t&2&&(Qe.$$scope={dirty:t,ctx:e}),F.$set(Qe)},i(e){oo||(h(_.$$.fragment,e),h(v.$$.fragment,e),h(te.$$.fragment,e),h(k.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(be.$$.fragment,e),h(q.$$.fragment,e),h(je.$$.fragment,e),h(xe.$$.fragment,e),h(Ne.$$.fragment,e),h(Le.$$.fragment,e),h(ze.$$.fragment,e),h(G.$$.fragment,e),h($e.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(ke.$$.fragment,e),h(qe.$$.fragment,e),h(Ge.$$.fragment,e),h(Ve.$$.fragment,e),h(Re.$$.fragment,e),h(Xe.$$.fragment,e),h(X.$$.fragment,e),h(F.$$.fragment,e),h(Fe.$$.fragment,e),oo=!0)},o(e){g(_.$$.fragment,e),g(v.$$.fragment,e),g(te.$$.fragment,e),g(k.$$.fragment,e),g(ne.$$.fragment,e),g(re.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(be.$$.fragment,e),g(q.$$.fragment,e),g(je.$$.fragment,e),g(xe.$$.fragment,e),g(Ne.$$.fragment,e),g(Le.$$.fragment,e),g(ze.$$.fragment,e),g(G.$$.fragment,e),g($e.$$.fragment,e),g(Ze.$$.fragment,e),g(We.$$.fragment,e),g(Be.$$.fragment,e),g(ke.$$.fragment,e),g(qe.$$.fragment,e),g(Ge.$$.fragment,e),g(Ve.$$.fragment,e),g(Re.$$.fragment,e),g(Xe.$$.fragment,e),g(X.$$.fragment,e),g(F.$$.fragment,e),g(Fe.$$.fragment,e),oo=!1},d(e){e&&(o(J),o(T),o(y),o(c),o(nt),o(E),o(lt),o(S),o(rt),o(P),o(it),o(A),o(ct),o(D),o(dt),o(O),o(mt),o(B),o(pt),o(K),o(ht),o(ee),o(gt),o(ut),o(oe),o(ft),o(Tt),o(ae),o(yt),o(se),o(Mt),o(_t),o(le),o(Jt),o(vt),o(ie),o(wt),o(bt),o(de),o(Ut),o(It),o(pe),o(jt),o(xt),o(ge),o(Ct),o(Nt),o(Lt),o(zt),o(ye),o($t),o(Zt),o(Wt),o(Je),o(Bt),o(kt),o(qt),o(Gt),o(Ue),o(Vt),o(Rt),o(Ie),o(Xt),o(Ft),o(Qt),o(Ce),o(Ht),o(Yt),o(Et),o(b),o(St),o(Pt),o(z),o(At),o(Dt),o(w),o(Ot),o(Kt),o(U),o(eo),o(to),o(ot)),o(l),u(_,e),u(v,e),u(te,e),u(k,e),u(ne,e),u(re,e),u(ce,e),u(me,e),u(he,e),u(ue,e),u(fe,e),u(Te,e),u(Me,e),u(_e,e),u(ve,e),u(we,e),u(be,e),u(q,e),u(je,e),u(xe,e),u(Ne,e),u(Le,e),u(ze),u(G),u($e,e),u(Ze),u(We),u(Be,e),u(ke),u(qe),u(Ge),u(Ve,e),u(Re),u(Xe),u(X),u(F),u(Fe,e)}}}const ua='{"title":"LLaVA-NeXT","local":"llava-next","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 to further speed-up generation","local":"use-flash-attention-2-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaNextConfig","local":"transformers.LlavaNextConfig","sections":[],"depth":2},{"title":"LlavaNextImageProcessor","local":"transformers.LlavaNextImageProcessor","sections":[],"depth":2},{"title":"LlavaNextProcessor","local":"transformers.LlavaNextProcessor","sections":[],"depth":2},{"title":"LlavaNextForConditionalGeneration","local":"transformers.LlavaNextForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function fa(C){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ba extends na{constructor(l){super(),la(this,l,fa,ga,oa,{})}}export{ba as component};
