import{s as St,f as Qt,o as Kt,n as qe}from"../chunks/scheduler.25b97de1.js";import{S as eo,i as to,g as l,s as n,r as h,A as oo,h as c,f as o,c as a,j as q,u as f,x as D,k,y as d,a as i,v as g,d as u,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as Lt}from"../chunks/Tip.baa67368.js";import{D as G}from"../chunks/Docstring.ffac8efa.js";import{C as Re}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Ct}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as Je,E as no}from"../chunks/EditOnGithub.91d95064.js";function ao($){let s,w="Examples:",m,p,y;return p=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhYkRldHJDb25maWclMkMlMjBEYWJEZXRyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwREFCLURFVFIlMjBJREVBLVJlc2VhcmNoJTJGZGFiX2RldHItYmFzZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEYWJEZXRyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMElERUEtUmVzZWFyY2glMkZkYWJfZGV0ci1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEYWJEZXRyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DabDetrConfig, DabDetrModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DAB-DETR IDEA-Research/dab_detr-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DabDetrConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the IDEA-Research/dab_detr-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DabDetrModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=n(),h(p.$$.fragment)},l(r){s=c(r,"P",{"data-svelte-h":!0}),D(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(r),f(p.$$.fragment,r)},m(r,v){i(r,s,v),i(r,m,v),g(p,r,v),y=!0},p:qe,i(r){y||(u(p.$$.fragment,r),y=!0)},o(r){_(p.$$.fragment,r),y=!1},d(r){r&&(o(s),o(m)),b(p,r)}}}function so($){let s,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=w},l(m){s=c(m,"P",{"data-svelte-h":!0}),D(s)!=="svelte-fincs2"&&(s.innerHTML=w)},m(m,p){i(m,s,p)},p:qe,d(m){m&&o(s)}}}function ro($){let s,w="Examples:",m,p,y;return p=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmRhYl9kZXRyLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMklERUEtUmVzZWFyY2glMkZkYWJfZGV0ci1iYXNlJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBmb3J3YXJkJTIwcGFzcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEElMjMlMjB0aGUlMjBsYXN0JTIwaGlkZGVuJTIwc3RhdGVzJTIwYXJlJTIwdGhlJTIwZmluYWwlMjBxdWVyeSUyMGVtYmVkZGluZ3MlMjBvZiUyMHRoZSUyMFRyYW5zZm9ybWVyJTIwZGVjb2RlciUwQSUyMyUyMHRoZXNlJTIwYXJlJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMlMkMlMjBoaWRkZW5fc2l6ZSklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab_detr-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab_detr-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the last hidden states are the final query embeddings of the Transformer decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># these are of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">300</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=n(),h(p.$$.fragment)},l(r){s=c(r,"P",{"data-svelte-h":!0}),D(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(r),f(p.$$.fragment,r)},m(r,v){i(r,s,v),i(r,m,v),g(p,r,v),y=!0},p:qe,i(r){y||(u(p.$$.fragment,r),y=!0)},o(r){_(p.$$.fragment,r),y=!1},d(r){r&&(o(s),o(m)),b(p,r)}}}function io($){let s,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=w},l(m){s=c(m,"P",{"data-svelte-h":!0}),D(s)!=="svelte-fincs2"&&(s.innerHTML=w)},m(m,p){i(m,s,p)},p:qe,d(m){m&&o(s)}}}function lo($){let s,w="Examples:",m,p,y;return p=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmRhYl9kZXRyLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMklERUEtUmVzZWFyY2glMkZkYWJfZGV0ci1iYXNlJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEElMjMlMjBjb252ZXJ0JTIwb3V0cHV0cyUyMChib3VuZGluZyUyMGJveGVzJTIwYW5kJTIwY2xhc3MlMjBsb2dpdHMpJTIwdG8lMjBQYXNjYWwlMjBWT0MlMjBmb3JtYXQlMjAoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMEF0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCklMEFyZXN1bHRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19vYmplY3RfZGV0ZWN0aW9uKG91dHB1dHMlMkMlMjB0aHJlc2hvbGQlM0QwLjUlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RCUwQWZvciUyMHNjb3JlJTJDJTIwbGFiZWwlMkMlMjBib3glMjBpbiUyMHppcChyZXN1bHRzJTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmxhYmVscyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjAlNUJyb3VuZChpJTJDJTIwMiklMjBmb3IlMjBpJTIwaW4lMjBib3gudG9saXN0KCklNUQlMEElMjAlMjAlMjAlMjBwcmludCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyRGV0ZWN0ZWQlMjAlN0Jtb2RlbC5jb25maWcuaWQybGFiZWwlNUJsYWJlbC5pdGVtKCklNUQlN0QlMjB3aXRoJTIwY29uZmlkZW5jZSUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlN0Jyb3VuZChzY29yZS5pdGVtKCklMkMlMjAzKSU3RCUyMGF0JTIwbG9jYXRpb24lMjAlN0Jib3glN0QlMjIlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab_detr-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab_detr-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">&gt;&gt;&gt; </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([(image.height, image.width)])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.833</span> at location [<span class="hljs-number">38.31</span>, <span class="hljs-number">72.1</span>, <span class="hljs-number">177.63</span>, <span class="hljs-number">118.45</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.831</span> at location [<span class="hljs-number">9.2</span>, <span class="hljs-number">51.38</span>, <span class="hljs-number">321.13</span>, <span class="hljs-number">469.0</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.804</span> at location [<span class="hljs-number">340.3</span>, <span class="hljs-number">16.85</span>, <span class="hljs-number">642.93</span>, <span class="hljs-number">370.95</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.683</span> at location [<span class="hljs-number">334.48</span>, <span class="hljs-number">73.49</span>, <span class="hljs-number">366.37</span>, <span class="hljs-number">190.01</span>]
Detected couch <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.535</span> at location [<span class="hljs-number">0.52</span>, <span class="hljs-number">1.19</span>, <span class="hljs-number">640.35</span>, <span class="hljs-number">475.1</span>]`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=n(),h(p.$$.fragment)},l(r){s=c(r,"P",{"data-svelte-h":!0}),D(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(r),f(p.$$.fragment,r)},m(r,v){i(r,s,v),i(r,m,v),g(p,r,v),y=!0},p:qe,i(r){y||(u(p.$$.fragment,r),y=!0)},o(r){_(p.$$.fragment,r),y=!1},d(r){r&&(o(s),o(m)),b(p,r)}}}function co($){let s,w,m,p,y,r,v,Fe,H,kt=`The DAB-DETR model was proposed in <a href="https://arxiv.org/abs/2201.12329" rel="nofollow">DAB-DETR: Dynamic Anchor Boxes are Better Queries for DETR</a> by Shilong Liu, Feng Li, Hao Zhang, Xiao Yang, Xianbiao Qi, Hang Su, Jun Zhu, Lei Zhang.
DAB-DETR is an enhanced variant of Conditional DETR. It utilizes dynamically updated anchor boxes to provide both a reference query point (x, y) and a reference anchor size (w, h), improving cross-attention computation. This new approach achieves 45.7% AP when trained for 50 epochs with a single ResNet-50 model as the backbone.`,Ee,F,$t,Ze,X,zt="The abstract from the paper is the following:",We,V,It=`<em>We present in this paper a novel query formulation using dynamic anchor boxes
for DETR (DEtection TRansformer) and offer a deeper understanding of the role
of queries in DETR. This new formulation directly uses box coordinates as queries
in Transformer decoders and dynamically updates them layer-by-layer. Using box
coordinates not only helps using explicit positional priors to improve the query-to-feature similarity and eliminate the slow training convergence issue in DETR,
but also allows us to modulate the positional attention map using the box width
and height information. Such a design makes it clear that queries in DETR can be
implemented as performing soft ROI pooling layer-by-layer in a cascade manner.
As a result, it leads to the best performance on MS-COCO benchmark among
the DETR-like detection models under the same setting, e.g., AP 45.7% using
ResNet50-DC5 as backbone trained in 50 epochs. We also conducted extensive
experiments to confirm our analysis and verify the effectiveness of our methods.</em>`,Ne,L,Jt=`This model was contributed by <a href="https://huggingface.co/davidhajdu" rel="nofollow">davidhajdu</a>.
The original code can be found <a href="https://github.com/IDEA-Research/DAB-DETR" rel="nofollow">here</a>.`,Pe,S,Rt="There are three ways to instantiate a DAB-DETR model (depending on what you prefer):",Be,Q,Ut="Option 1: Instantiate DAB-DETR with pre-trained weights for entire model",Ae,K,Oe,ee,qt="Option 2: Instantiate DAB-DETR with randomly initialized weights for Transformer, but pre-trained weights for backbone",Ye,te,Ge,oe,Ft="Option 3: Instantiate DAB-DETR with randomly initialized weights for backbone + Transformer",He,ne,Xe,ae,Ve,x,se,st,De,Et=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrModel">DabDetrModel</a>. It is used to instantiate
a DAB-DETR model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the DAB-DETR
<a href="https://huggingface.co/IDEA-Research/dab_detr-base" rel="nofollow">IDEA-Research/dab_detr-base</a> architecture.`,rt,ye,Zt=`Configuration objects inherit from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,it,E,Le,re,Se,j,ie,dt,we,Wt="Constructs a Conditional Detr image processor.",lt,Z,de,ct,ve,Nt="Preprocess an image or a batch of images so that it can be used by the model.",mt,W,le,pt,Te,Pt=`Converts the raw output of <a href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrForObjectDetection">DabDetrForObjectDetection</a> into final bounding boxes in (top_left_x,
top_left_y, bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Qe,ce,Ke,T,me,ht,Me,Bt=`The bare DAB-DETR Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states, intermediate hidden states, reference points, output coordinates without any specific head on top.`,ft,xe,At=`This model inherits from <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gt,je,Ot=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ut,z,pe,_t,Ce,Yt='The <a href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrModel">DabDetrModel</a> forward method, overrides the <code>__call__</code> special method.',bt,N,Dt,P,et,he,tt,M,fe,yt,ke,Gt=`DAB_DETR Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on
top, for tasks such as COCO detection.`,wt,$e,Ht=`This model inherits from <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vt,ze,Xt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Tt,I,ge,Mt,Ie,Vt='The <a href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrForObjectDetection">DabDetrForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',xt,B,jt,A,ot,ue,nt,Ue,at;return y=new Je({props:{title:"DAB-DETR",local:"dab-detr",headingTag:"h1"}}),v=new Je({props:{title:"Overview",local:"overview",headingTag:"h2"}}),K=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhYkRldHJGb3JPYmplY3REZXRlY3Rpb24lMEElMEFtb2RlbCUyMCUzRCUyMERhYkRldHJGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMklERUEtUmVzZWFyY2glMkZkYWJfZGV0cl9yZXNuZXQ1MCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DabDetrForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = DabDetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab_detr_resnet50&quot;</span>)`,wrap:!1}}),te=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhYkRldHJDb25maWclMkMlMjBEYWJEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uJTBBJTBBY29uZmlnJTIwJTNEJTIwRGFiRGV0ckNvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBEYWJEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DabDetrConfig, DabDetrForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>config = DabDetrConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DabDetrForObjectDetection(config)`,wrap:!1}}),ne=new Re({props:{code:"Y29uZmlnJTIwJTNEJTIwRGFiRGV0ckNvbmZpZyh1c2VfcHJldHJhaW5lZF9iYWNrYm9uZSUzREZhbHNlKSUwQW1vZGVsJTIwJTNEJTIwRGFiRGV0ckZvck9iamVjdERldGVjdGlvbihjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>config = DabDetrConfig(use_pretrained_backbone=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DabDetrForObjectDetection(config)`,wrap:!1}}),ae=new Je({props:{title:"DabDetrConfig",local:"transformers.DabDetrConfig",headingTag:"h2"}}),se=new G({props:{name:"class transformers.DabDetrConfig",anchor:"transformers.DabDetrConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"backbone_kwargs",val:" = None"},{name:"num_queries",val:" = 300"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'prelu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"auxiliary_loss",val:" = False"},{name:"dilation",val:" = False"},{name:"class_cost",val:" = 2"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"cls_loss_coefficient",val:" = 2"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"focal_alpha",val:" = 0.25"},{name:"temperature_height",val:" = 20"},{name:"temperature_width",val:" = 20"},{name:"query_dim",val:" = 4"},{name:"random_refpoints_xy",val:" = False"},{name:"keep_query_pos",val:" = False"},{name:"num_patterns",val:" = 0"},{name:"normalize_before",val:" = False"},{name:"sine_position_embedding_scale",val:" = None"},{name:"initializer_bias_prior_prob",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DabDetrConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/pr_30803/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DabDetrConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.DabDetrConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;resnet50&quot;</code>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DabDetrConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DabDetrConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DabDetrConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrModel">DabDetrModel</a> can detect in a single image. For COCO, we recommend 100 queries.`,name:"num_queries"},{anchor:"transformers.DabDetrConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.DabDetrConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in encoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.DabDetrConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.DabDetrConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.DabDetrConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.DabDetrConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.DabDetrConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Indicates whether the transformer model architecture is an encoder-decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.DabDetrConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;prelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.DabDetrConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
This parameter is a general dimension parameter, defining dimensions for components such as the encoder layer and projection parameters in the decoder layer, among others.`,name:"d_model"},{anchor:"transformers.DabDetrConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.DabDetrConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.DabDetrConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.DabDetrConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.DabDetrConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.DabDetrConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.DabDetrConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when <code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.DabDetrConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.DabDetrConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.DabDetrConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.DabDetrConfig.cls_loss_coefficient",description:`<strong>cls_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the classification loss in the object detection loss function.`,name:"cls_loss_coefficient"},{anchor:"transformers.DabDetrConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.DabDetrConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.DabDetrConfig.focal_alpha",description:`<strong>focal_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Alpha parameter in the focal loss.`,name:"focal_alpha"},{anchor:"transformers.DabDetrConfig.temperature_height",description:`<strong>temperature_height</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Temperature parameter to tune the flatness of positional attention (HEIGHT)`,name:"temperature_height"},{anchor:"transformers.DabDetrConfig.temperature_width",description:`<strong>temperature_width</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Temperature parameter to tune the flatness of positional attention (WIDTH)`,name:"temperature_width"},{anchor:"transformers.DabDetrConfig.query_dim",description:`<strong>query_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Query dimension parameter represents the size of the output vector.`,name:"query_dim"},{anchor:"transformers.DabDetrConfig.random_refpoints_xy",description:`<strong>random_refpoints_xy</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fix the x and y coordinates of the anchor boxes with random initialization.`,name:"random_refpoints_xy"},{anchor:"transformers.DabDetrConfig.keep_query_pos",description:`<strong>keep_query_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the projected positional embedding from the object query into the original query (key) in every decoder layer.`,name:"keep_query_pos"},{anchor:"transformers.DabDetrConfig.num_patterns",description:`<strong>num_patterns</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of pattern embeddings.`,name:"num_patterns"},{anchor:"transformers.DabDetrConfig.normalize_before",description:`<strong>normalize_before</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether we use a normalization layer in the Encoder or not.`,name:"normalize_before"},{anchor:"transformers.DabDetrConfig.sine_position_embedding_scale",description:`<strong>sine_position_embedding_scale</strong> (<code>float</code>, <em>optional</em>, defaults to &#x2018;None&#x2019;) &#x2014;
Scaling factor applied to the normalized positional encodings.`,name:"sine_position_embedding_scale"},{anchor:"transformers.DabDetrConfig.initializer_bias_prior_prob",description:`<strong>initializer_bias_prior_prob</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The prior probability used by the bias initializer to initialize biases for <code>enc_score_head</code> and <code>class_embed</code>.
If <code>None</code>, <code>prior_prob</code> computed as <code>prior_prob = 1 / (num_labels + 1)</code> while initializing model weights.`,name:"initializer_bias_prior_prob"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/dab_detr/configuration_dab_detr.py#L26"}}),E=new Ct({props:{anchor:"transformers.DabDetrConfig.example",$$slots:{default:[ao]},$$scope:{ctx:$}}}),re=new Je({props:{title:"DabDetrImageProcessor",local:"transformers.DabDetrImageProcessor",headingTag:"h2"}}),ie=new G({props:{name:"class transformers.DabDetrImageProcessor",anchor:"transformers.DabDetrImageProcessor",parameters:[{name:"format",val:": Union = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DabDetrImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.DabDetrImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DabDetrImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.DabDetrImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.DabDetrImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DabDetrImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DabDetrImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.DabDetrImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DabDetrImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.DabDetrImageProcessor.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.DabDetrImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.DabDetrImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/dab_detr/image_processing_dab_detr.py#L716"}}),de=new G({props:{name:"preprocess",anchor:"transformers.DabDetrImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"annotations",val:": Union = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": Union = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Union = None"},{name:"do_normalize",val:": Optional = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = None"},{name:"format",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"pad_size",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DabDetrImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DabDetrImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.DabDetrImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.DabDetrImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.DabDetrImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DabDetrImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.DabDetrImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.DabDetrImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DabDetrImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.DabDetrImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DabDetrImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.DabDetrImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.DabDetrImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.DabDetrImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code>, padding will be applied to the bottom and right of
the image with zeros. If <code>pad_size</code> is provided, the image will be padded to the specified
dimensions. Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.DabDetrImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.DabDetrImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.DabDetrImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DabDetrImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.DabDetrImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/dab_detr/image_processing_dab_detr.py#L1175"}}),le=new G({props:{name:"post_process_object_detection",anchor:"transformers.DabDetrImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"},{name:"top_k",val:": int = 100"}],parametersDescription:[{anchor:"transformers.DabDetrImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DabDetrImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DabDetrImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
(height, width) of each image in the batch. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DabDetrImageProcessor.post_process_object_detection.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Keep only top k bounding boxes before filtering by thresholding.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/dab_detr/image_processing_dab_detr.py#L1441",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ce=new Je({props:{title:"DabDetrModel",local:"transformers.DabDetrModel",headingTag:"h2"}}),me=new G({props:{name:"class transformers.DabDetrModel",anchor:"transformers.DabDetrModel",parameters:[{name:"config",val:": DabDetrConfig"}],parametersDescription:[{anchor:"transformers.DabDetrModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrConfig">DabDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/dab_detr/modeling_dab_detr.py#L1365"}}),pe=new G({props:{name:"forward",anchor:"transformers.DabDetrModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DabDetrModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30803/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">DabDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DabDetrModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DabDetrModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DabDetrModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DabDetrModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DabDetrModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DabDetrModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DabDetrModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DabDetrModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/dab_detr/modeling_dab_detr.py#L1428",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.dab_detr.modeling_dab_detr.DabDetrModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrConfig"
>DabDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
<li><strong>reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, num_queries, 2 (anchor points))</code>) — Reference points (reference points of each layer of the decoder).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.dab_detr.modeling_dab_detr.DabDetrModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new Lt({props:{$$slots:{default:[so]},$$scope:{ctx:$}}}),P=new Ct({props:{anchor:"transformers.DabDetrModel.forward.example",$$slots:{default:[ro]},$$scope:{ctx:$}}}),he=new Je({props:{title:"DabDetrForObjectDetection",local:"transformers.DabDetrForObjectDetection",headingTag:"h2"}}),fe=new G({props:{name:"class transformers.DabDetrForObjectDetection",anchor:"transformers.DabDetrForObjectDetection",parameters:[{name:"config",val:": DabDetrConfig"}],parametersDescription:[{anchor:"transformers.DabDetrForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrConfig">DabDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/dab_detr/modeling_dab_detr.py#L2054"}}),ge=new G({props:{name:"forward",anchor:"transformers.DabDetrForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DabDetrForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30803/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">DabDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DabDetrForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DabDetrForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DabDetrForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DabDetrForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DabDetrForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DabDetrForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DabDetrForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DabDetrForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DabDetrForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/dab_detr/modeling_dab_detr.py#L2098",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.dab_detr.modeling_dab_detr.DabDetrObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrConfig"
>DabDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/pr_30803/en/model_doc/dab-detr#transformers.DabDetrImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.dab_detr.modeling_dab_detr.DabDetrObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new Lt({props:{$$slots:{default:[io]},$$scope:{ctx:$}}}),A=new Ct({props:{anchor:"transformers.DabDetrForObjectDetection.forward.example",$$slots:{default:[lo]},$$scope:{ctx:$}}}),ue=new no({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/dab-detr.md"}}),{c(){s=l("meta"),w=n(),m=l("p"),p=n(),h(y.$$.fragment),r=n(),h(v.$$.fragment),Fe=n(),H=l("p"),H.innerHTML=kt,Ee=n(),F=l("img"),Ze=n(),X=l("p"),X.textContent=zt,We=n(),V=l("p"),V.innerHTML=It,Ne=n(),L=l("p"),L.innerHTML=Jt,Pe=n(),S=l("p"),S.textContent=Rt,Be=n(),Q=l("p"),Q.textContent=Ut,Ae=n(),h(K.$$.fragment),Oe=n(),ee=l("p"),ee.textContent=qt,Ye=n(),h(te.$$.fragment),Ge=n(),oe=l("p"),oe.textContent=Ft,He=n(),h(ne.$$.fragment),Xe=n(),h(ae.$$.fragment),Ve=n(),x=l("div"),h(se.$$.fragment),st=n(),De=l("p"),De.innerHTML=Et,rt=n(),ye=l("p"),ye.innerHTML=Zt,it=n(),h(E.$$.fragment),Le=n(),h(re.$$.fragment),Se=n(),j=l("div"),h(ie.$$.fragment),dt=n(),we=l("p"),we.textContent=Wt,lt=n(),Z=l("div"),h(de.$$.fragment),ct=n(),ve=l("p"),ve.textContent=Nt,mt=n(),W=l("div"),h(le.$$.fragment),pt=n(),Te=l("p"),Te.innerHTML=Pt,Qe=n(),h(ce.$$.fragment),Ke=n(),T=l("div"),h(me.$$.fragment),ht=n(),Me=l("p"),Me.textContent=Bt,ft=n(),xe=l("p"),xe.innerHTML=At,gt=n(),je=l("p"),je.innerHTML=Ot,ut=n(),z=l("div"),h(pe.$$.fragment),_t=n(),Ce=l("p"),Ce.innerHTML=Yt,bt=n(),h(N.$$.fragment),Dt=n(),h(P.$$.fragment),et=n(),h(he.$$.fragment),tt=n(),M=l("div"),h(fe.$$.fragment),yt=n(),ke=l("p"),ke.textContent=Gt,wt=n(),$e=l("p"),$e.innerHTML=Ht,vt=n(),ze=l("p"),ze.innerHTML=Xt,Tt=n(),I=l("div"),h(ge.$$.fragment),Mt=n(),Ie=l("p"),Ie.innerHTML=Vt,xt=n(),h(B.$$.fragment),jt=n(),h(A.$$.fragment),ot=n(),h(ue.$$.fragment),nt=n(),Ue=l("p"),this.h()},l(e){const t=oo("svelte-u9bgzb",document.head);s=c(t,"META",{name:!0,content:!0}),t.forEach(o),w=a(e),m=c(e,"P",{}),q(m).forEach(o),p=a(e),f(y.$$.fragment,e),r=a(e),f(v.$$.fragment,e),Fe=a(e),H=c(e,"P",{"data-svelte-h":!0}),D(H)!=="svelte-9auo1u"&&(H.innerHTML=kt),Ee=a(e),F=c(e,"IMG",{src:!0,alt:!0,width:!0}),Ze=a(e),X=c(e,"P",{"data-svelte-h":!0}),D(X)!=="svelte-vfdo9a"&&(X.textContent=zt),We=a(e),V=c(e,"P",{"data-svelte-h":!0}),D(V)!=="svelte-ct3tl8"&&(V.innerHTML=It),Ne=a(e),L=c(e,"P",{"data-svelte-h":!0}),D(L)!=="svelte-yd6iz"&&(L.innerHTML=Jt),Pe=a(e),S=c(e,"P",{"data-svelte-h":!0}),D(S)!=="svelte-y7spqf"&&(S.textContent=Rt),Be=a(e),Q=c(e,"P",{"data-svelte-h":!0}),D(Q)!=="svelte-1m4ojtg"&&(Q.textContent=Ut),Ae=a(e),f(K.$$.fragment,e),Oe=a(e),ee=c(e,"P",{"data-svelte-h":!0}),D(ee)!=="svelte-fa3upe"&&(ee.textContent=qt),Ye=a(e),f(te.$$.fragment,e),Ge=a(e),oe=c(e,"P",{"data-svelte-h":!0}),D(oe)!=="svelte-1m4gpgg"&&(oe.textContent=Ft),He=a(e),f(ne.$$.fragment,e),Xe=a(e),f(ae.$$.fragment,e),Ve=a(e),x=c(e,"DIV",{class:!0});var J=q(x);f(se.$$.fragment,J),st=a(J),De=c(J,"P",{"data-svelte-h":!0}),D(De)!=="svelte-f640o4"&&(De.innerHTML=Et),rt=a(J),ye=c(J,"P",{"data-svelte-h":!0}),D(ye)!=="svelte-ur2kjj"&&(ye.innerHTML=Zt),it=a(J),f(E.$$.fragment,J),J.forEach(o),Le=a(e),f(re.$$.fragment,e),Se=a(e),j=c(e,"DIV",{class:!0});var R=q(j);f(ie.$$.fragment,R),dt=a(R),we=c(R,"P",{"data-svelte-h":!0}),D(we)!=="svelte-17j4jp9"&&(we.textContent=Wt),lt=a(R),Z=c(R,"DIV",{class:!0});var _e=q(Z);f(de.$$.fragment,_e),ct=a(_e),ve=c(_e,"P",{"data-svelte-h":!0}),D(ve)!=="svelte-jgz2ra"&&(ve.textContent=Nt),_e.forEach(o),mt=a(R),W=c(R,"DIV",{class:!0});var be=q(W);f(le.$$.fragment,be),pt=a(be),Te=c(be,"P",{"data-svelte-h":!0}),D(Te)!=="svelte-1k9qsd6"&&(Te.innerHTML=Pt),be.forEach(o),R.forEach(o),Qe=a(e),f(ce.$$.fragment,e),Ke=a(e),T=c(e,"DIV",{class:!0});var C=q(T);f(me.$$.fragment,C),ht=a(C),Me=c(C,"P",{"data-svelte-h":!0}),D(Me)!=="svelte-19gfwdg"&&(Me.textContent=Bt),ft=a(C),xe=c(C,"P",{"data-svelte-h":!0}),D(xe)!=="svelte-jmt3ug"&&(xe.innerHTML=At),gt=a(C),je=c(C,"P",{"data-svelte-h":!0}),D(je)!=="svelte-hswkmf"&&(je.innerHTML=Ot),ut=a(C),z=c(C,"DIV",{class:!0});var O=q(z);f(pe.$$.fragment,O),_t=a(O),Ce=c(O,"P",{"data-svelte-h":!0}),D(Ce)!=="svelte-cheg78"&&(Ce.innerHTML=Yt),bt=a(O),f(N.$$.fragment,O),Dt=a(O),f(P.$$.fragment,O),O.forEach(o),C.forEach(o),et=a(e),f(he.$$.fragment,e),tt=a(e),M=c(e,"DIV",{class:!0});var U=q(M);f(fe.$$.fragment,U),yt=a(U),ke=c(U,"P",{"data-svelte-h":!0}),D(ke)!=="svelte-13cvp2k"&&(ke.textContent=Gt),wt=a(U),$e=c(U,"P",{"data-svelte-h":!0}),D($e)!=="svelte-jmt3ug"&&($e.innerHTML=Ht),vt=a(U),ze=c(U,"P",{"data-svelte-h":!0}),D(ze)!=="svelte-hswkmf"&&(ze.innerHTML=Xt),Tt=a(U),I=c(U,"DIV",{class:!0});var Y=q(I);f(ge.$$.fragment,Y),Mt=a(Y),Ie=c(Y,"P",{"data-svelte-h":!0}),D(Ie)!=="svelte-5f0jre"&&(Ie.innerHTML=Vt),xt=a(Y),f(B.$$.fragment,Y),jt=a(Y),f(A.$$.fragment,Y),Y.forEach(o),U.forEach(o),ot=a(e),f(ue.$$.fragment,e),nt=a(e),Ue=c(e,"P",{}),q(Ue).forEach(o),this.h()},h(){k(s,"name","hf:doc:metadata"),k(s,"content",mo),Qt(F.src,$t="https://github.com/conditionedstimulus/hf_media/blob/main/dab_detr_convergence_plot.png")||k(F,"src",$t),k(F,"alt","drawing"),k(F,"width","600"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,s),i(e,w,t),i(e,m,t),i(e,p,t),g(y,e,t),i(e,r,t),g(v,e,t),i(e,Fe,t),i(e,H,t),i(e,Ee,t),i(e,F,t),i(e,Ze,t),i(e,X,t),i(e,We,t),i(e,V,t),i(e,Ne,t),i(e,L,t),i(e,Pe,t),i(e,S,t),i(e,Be,t),i(e,Q,t),i(e,Ae,t),g(K,e,t),i(e,Oe,t),i(e,ee,t),i(e,Ye,t),g(te,e,t),i(e,Ge,t),i(e,oe,t),i(e,He,t),g(ne,e,t),i(e,Xe,t),g(ae,e,t),i(e,Ve,t),i(e,x,t),g(se,x,null),d(x,st),d(x,De),d(x,rt),d(x,ye),d(x,it),g(E,x,null),i(e,Le,t),g(re,e,t),i(e,Se,t),i(e,j,t),g(ie,j,null),d(j,dt),d(j,we),d(j,lt),d(j,Z),g(de,Z,null),d(Z,ct),d(Z,ve),d(j,mt),d(j,W),g(le,W,null),d(W,pt),d(W,Te),i(e,Qe,t),g(ce,e,t),i(e,Ke,t),i(e,T,t),g(me,T,null),d(T,ht),d(T,Me),d(T,ft),d(T,xe),d(T,gt),d(T,je),d(T,ut),d(T,z),g(pe,z,null),d(z,_t),d(z,Ce),d(z,bt),g(N,z,null),d(z,Dt),g(P,z,null),i(e,et,t),g(he,e,t),i(e,tt,t),i(e,M,t),g(fe,M,null),d(M,yt),d(M,ke),d(M,wt),d(M,$e),d(M,vt),d(M,ze),d(M,Tt),d(M,I),g(ge,I,null),d(I,Mt),d(I,Ie),d(I,xt),g(B,I,null),d(I,jt),g(A,I,null),i(e,ot,t),g(ue,e,t),i(e,nt,t),i(e,Ue,t),at=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),E.$set(J);const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),N.$set(R);const _e={};t&2&&(_e.$$scope={dirty:t,ctx:e}),P.$set(_e);const be={};t&2&&(be.$$scope={dirty:t,ctx:e}),B.$set(be);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),A.$set(C)},i(e){at||(u(y.$$.fragment,e),u(v.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(E.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(le.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(N.$$.fragment,e),u(P.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(ue.$$.fragment,e),at=!0)},o(e){_(y.$$.fragment,e),_(v.$$.fragment,e),_(K.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(E.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(N.$$.fragment,e),_(P.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(B.$$.fragment,e),_(A.$$.fragment,e),_(ue.$$.fragment,e),at=!1},d(e){e&&(o(w),o(m),o(p),o(r),o(Fe),o(H),o(Ee),o(F),o(Ze),o(X),o(We),o(V),o(Ne),o(L),o(Pe),o(S),o(Be),o(Q),o(Ae),o(Oe),o(ee),o(Ye),o(Ge),o(oe),o(He),o(Xe),o(Ve),o(x),o(Le),o(Se),o(j),o(Qe),o(Ke),o(T),o(et),o(tt),o(M),o(ot),o(nt),o(Ue)),o(s),b(y,e),b(v,e),b(K,e),b(te,e),b(ne,e),b(ae,e),b(se),b(E),b(re,e),b(ie),b(de),b(le),b(ce,e),b(me),b(pe),b(N),b(P),b(he,e),b(fe),b(ge),b(B),b(A),b(ue,e)}}}const mo='{"title":"DAB-DETR","local":"dab-detr","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"DabDetrConfig","local":"transformers.DabDetrConfig","sections":[],"depth":2},{"title":"DabDetrImageProcessor","local":"transformers.DabDetrImageProcessor","sections":[],"depth":2},{"title":"DabDetrModel","local":"transformers.DabDetrModel","sections":[],"depth":2},{"title":"DabDetrForObjectDetection","local":"transformers.DabDetrForObjectDetection","sections":[],"depth":2}],"depth":1}';function po($){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yo extends eo{constructor(s){super(),to(this,s,po,co,St,{})}}export{yo as component};
