import{s as We,n as Se,o as Be}from"../chunks/scheduler.c59d9fbb.js";import{S as Re,i as He,g as d,s as l,r as i,A as Ne,h,f as s,c as n,j as ke,u as p,x as g,k as Ge,y as qe,a,v as r,d as o,t as m,w as c}from"../chunks/index.a47918e3.js";import{C as u}from"../chunks/CodeBlock.936db8cd.js";import{D as Qe}from"../chunks/DocNotebookDropdown.c0ce911f.js";import{H as M,E as ze}from"../chunks/EditOnGithub.813e7c73.js";function Ye(ce){let f,gt,dt,ut,y,ft,b,Mt,w,de='This quickstart is intended for developers who are ready to dive into the code and see an example of how to train and use 🤗 SetFit models. We recommend starting with this quickstart, and then proceeding to the <a href="./tutorials/overview">tutorials</a> or <a href="./how_to/overview">how-to guides</a> for additional material. Additionally, the <a href="./conceptual_guides/setfit">conceptual guides</a> help explain exactly how SetFit works.',yt,j,he="Start by installing 🤗 SetFit:",bt,J,wt,T,ge='If you have a CUDA-capable graphics card, then it is recommended to <a href="https://pytorch.org/get-started/locally/" rel="nofollow">install <code>torch</code> with CUDA support</a> to train and performing inference much more quickly:',jt,$,Jt,U,Tt,v,ue="SetFit is an efficient framework to train low-latency text classification models using little training data. In this Quickstart, you’ll learn how to train a SetFit model, how to perform inference with it, and how to save it to the Hugging Face Hub.",$t,x,Ut,Z,fe='In this section, you’ll load a <a href="https://huggingface.co/models?library=sentence-transformers" rel="nofollow">Sentence Transformer model</a> and further finetune it for classifying movie reviews as positive or negative. To train a model, we will need to prepare the following three: 1) a <strong>model</strong>, 2) a <strong>dataset</strong>, and 3) <strong>training arguments</strong>.',vt,I,Me='<strong>1</strong>. Initialize a SetFit model using a Sentence Transformer model of our choice. Consider using the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> to guide your decision on which Sentence Transformer model to choose. We will use <a href="https://huggingface.co/BAAI/bge-small-en-v1.5" rel="nofollow">BAAI/bge-small-en-v1.5</a>, a small but performant model.',xt,C,Zt,F,ye='<strong>2a</strong>. Next, load both the “train” and “test” splits of the <a href="https://huggingface.co/datasets/sst2" rel="nofollow">SetFit/sst2</a> dataset. Note that the dataset has <code>&quot;text&quot;</code> and <code>&quot;label&quot;</code> columns: this is exactly the format that 🤗 SetFit expects. If your dataset has different columns, then you can use the column_mapping argument of the <a href="/docs/setfit/pr_573/en/reference/trainer#setfit.Trainer">Trainer</a> in step 4 to map the column names to <code>&quot;text&quot;</code> and <code>&quot;label&quot;</code>.',It,_,Ct,X,be="<strong>2b</strong>. In real world scenarios it is very uncommon to have ~7.000 high quality labeled training samples, so we will heavily shrink the training dataset to give a better idea of how 🤗 SetFit would work in real settings. To be specific, the <code>sample_dataset</code> function will sample only 8 samples for each class. The testing set is left unaffected for better evaluation.",Ft,k,_t,G,Xt,W,we="<strong>2c</strong>. We can apply the labels from the dataset on the model, so the predictions output readable classes. You can also provide the labels directly to <code>SetFitModel.from_pretrained()</code>.",kt,S,Gt,B,je='<strong>3</strong>. Prepare the <a href="/docs/setfit/pr_573/en/reference/trainer#setfit.TrainingArguments">TrainingArguments</a> for training. Note that training with 🤗 SetFit consists of two phases behind the scenes: <strong>finetuning embeddings</strong> and <strong>training a classification head</strong>. As a result, some of the training arguments can be tuples, where the two values are used for each of the two phases, respectively.',Wt,R,Je="The <code>num_epochs</code> and <code>max_steps</code> arguments are frequently used to increase and decrease the number of total training steps. Consider that with SetFit, better performance is reached with <strong>more data, not more training</strong>! Don’t be afraid to train for less than 1 epoch if you have a lot of data.",St,H,Bt,N,Te='<strong>4</strong>. Initialize the <a href="/docs/setfit/pr_573/en/reference/trainer#setfit.Trainer">Trainer</a> and perform training.',Rt,q,Ht,Q,Nt,z,$e="<strong>5</strong>. Perform evaluation using the provided testing dataset.",qt,Y,Qt,L,Ue="Feel free to experiment with increasing the number of samples per class to observe the improvements in accuracy. As a challenge, you can play with the samples per class, learning rate, number of epochs, maximum number of steps, and the base Sentence Transformer model to try and improve the accuracy over 90% using very little data.",zt,E,Yt,V,ve="After training, you can save a 🤗 SetFit model to your local filesystem or to the Hugging Face Hub. Save a model to a local directory using <code>SetFitModel.save_pretrained()</code> by providing a <code>save_directory</code>:",Lt,A,Et,P,xe="Alternatively, push a model to the Hugging Face Hub using <code>SetFitModel.push_to_hub()</code> by providing a <code>repo_id</code>:",Vt,D,At,K,Pt,O,Ze="A 🤗 SetFit model can be loaded using <code>SetFitModel.from_pretrained()</code> by providing 1) a <code>repo_id</code> from the Hugging Face Hub or 2) a path to a local directory:",Dt,tt,Kt,et,Ot,st,Ie='Once a 🤗 SetFit model has been trained, then it can be used for inference to classify reviews using <a href="/docs/setfit/pr_573/en/reference/main#setfit.SetFitModel.predict">SetFitModel.predict()</a> or <a href="/docs/setfit/pr_573/en/reference/main#setfit.SetFitModel.__call__">SetFitModel.<strong>call</strong>()</a>:',te,at,ee,lt,Ce="These predictions rely on the <code>model.labels</code>. If not set, it will return predictions in the format that was used during training, e.g. <code>tensor([1, 0, 0])</code>.",se,nt,ae,it,Fe="You’ve completed the 🤗 SetFit quickstart! You can train, save, load and perform inference with 🤗 SetFit models!",le,pt,_e='For your next steps, take a look at our <a href="./how_to/overview">How-to guides</a> and learn how to do more specific things like hyperparameter search, knowledge distillation, or zero-shot text classification. If you’re interested in learning more about how 🤗 SetFit works, grab a cup of coffee and read our <a href="./conceptual_guides/setfit">Conceptual Guides</a>!',ne,rt,ie,ot,Xe="This snippet shows the entire quickstart in an end-to-end example:",pe,mt,re,ct,oe,ht,me;return y=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),b=new Qe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/quickstart.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/quickstart.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/quickstart.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/quickstart.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/quickstart.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/quickstart.ipynb"}]}}),J=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNldGZpdA==",highlighted:"pip install setfit",wrap:!1}}),$=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRvcmNoJTIwLS1pbmRleC11cmwlMjBodHRwcyUzQSUyRiUyRmRvd25sb2FkLnB5dG9yY2gub3JnJTJGd2hsJTJGY3UxMTg=",highlighted:"pip install torch --index-url https://download.pytorch.org/whl/cu118",wrap:!1}}),U=new M({props:{title:"SetFit",local:"setfit",headingTag:"h2"}}),x=new M({props:{title:"Training",local:"training",headingTag:"h3"}}),C=new u({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)`,wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJTZXRGaXQlMkZzc3QyJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">6920</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">1821</span>
    })
    validation: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">872</span>
    })
})`,wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMHNhbXBsZV9kYXRhc2V0JTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNhbXBsZV9kYXRhc2V0KGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMGxhYmVsX2NvbHVtbiUzRCUyMmxhYmVsJTIyJTJDJTIwbnVtX3NhbXBsZXMlM0Q4KSUwQXRyYWluX2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> sample_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
    num_rows: <span class="hljs-number">16</span>
})`,wrap:!1}}),G=new u({props:{code:"dGVzdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEF0ZXN0X2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
    num_rows: <span class="hljs-number">1821</span>
})`,wrap:!1}}),S=new u({props:{code:"bW9kZWwubGFiZWxzJTIwJTNEJTIwJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.labels = [<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>]',wrap:!1}}),H=new u({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9lcG9jaHMlM0QxMCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>args = TrainingArguments(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">32</span>,
<span class="hljs-meta">... </span>    num_epochs=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new u({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=args,
<span class="hljs-meta">... </span>    train_dataset=train_dataset,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new u({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()
***** Running training *****
  Num examples = <span class="hljs-number">5</span>
  Num epochs = <span class="hljs-number">10</span>
  Total optimization steps = <span class="hljs-number">50</span>
  Total train batch size = <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2077</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">4.000000000000001e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.2</span>}                                                                                                                
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0097</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.0</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">10.0</span>}                                                                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">14.705</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">108.807</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">3.4</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">10.0</span>}
<span class="hljs-number">100</span>%|██████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">50</span>/<span class="hljs-number">50</span> [<span class="hljs-number">00</span>:08&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">5.70</span>it/s]`,wrap:!1}}),Y=new u({props:{code:"dHJhaW5lci5ldmFsdWF0ZSh0ZXN0X2RhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.evaluate(test_dataset)
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8511806699615596</span>}`,wrap:!1}}),E=new M({props:{title:"Saving a 🤗 SetFit model",local:"saving-a--setfit-model",headingTag:"h3"}}),A=new u({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnNldGZpdC1iZ2Utc21hbGwtdjEuNS1zc3QyLTgtc2hvdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)',wrap:!1}}),D=new u({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIydG9tYWFyc2VuJTJGc2V0Zml0LWJnZS1zbWFsbC12MS41LXNzdDItOC1zaG90JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;tomaarsen/setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)',wrap:!1}}),K=new M({props:{title:"Loading a 🤗 SetFit model",local:"loading-a--setfit-model",headingTag:"h3"}}),tt=new u({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydG9tYWFyc2VuJTJGc2V0Zml0LWJnZS1zbWFsbC12MS41LXNzdDItOC1zaG90JTIyKSUyMCUyMyUyMExvYWQlMjBmcm9tJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMEElMEFtb2RlbCUyMCUzRCUyMFNldEZpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzZXRmaXQtYmdlLXNtYWxsLXYxLjUtc3N0Mi04LXNob3QlMjIpJTIwJTIzJTIwTG9hZCUyMGZyb20lMjBhJTIwbG9jYWwlMjBkaXJlY3Rvcnk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;tomaarsen/setfit-bge-small-v1.5-sst2-8-shot&quot;</span>) <span class="hljs-comment"># Load from the Hugging Face Hub</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>) <span class="hljs-comment"># Load from a local directory</span>`,wrap:!1}}),et=new M({props:{title:"Inference",local:"inference",headingTag:"h3"}}),at=new u({props:{code:"cHJlZHMlMjAlM0QlMjBtb2RlbC5wcmVkaWN0KCU1QiUwQSUyMCUyMCUyMCUyMCUyMkl0J3MlMjBhJTIwY2hhcm1pbmclMjBhbmQlMjBvZnRlbiUyMGFmZmVjdGluZyUyMGpvdXJuZXkuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySXQncyUyMHNsb3clMjAtLSUyMHZlcnklMkMlMjB2ZXJ5JTIwc2xvdy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwc29tZXRpbWVzJTIwdGVkaW91cyUyMGZpbG0uJTIyJTJDJTBBJTVEKSUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>preds = model.predict([
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
<span class="hljs-meta">... </span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[<span class="hljs-string">&#x27;positive&#x27;</span> <span class="hljs-string">&#x27;negative&#x27;</span> <span class="hljs-string">&#x27;negative&#x27;</span>]`,wrap:!1}}),nt=new M({props:{title:"What’s next?",local:"whats-next",headingTag:"h2"}}),rt=new M({props:{title:"End-to-end",local:"end-to-end",headingTag:"h2"}}),mt=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, TrainingArguments, sample_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Initializing a new SetFit model</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, labels=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])

<span class="hljs-comment"># Preparing the dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

<span class="hljs-comment"># Preparing the training arguments</span>
args = TrainingArguments(
    batch_size=<span class="hljs-number">32</span>,
    num_epochs=<span class="hljs-number">10</span>,
)

<span class="hljs-comment"># Preparing the trainer</span>
trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
)
trainer.train()

<span class="hljs-comment"># Evaluating</span>
metrics = trainer.evaluate(test_dataset)
<span class="hljs-built_in">print</span>(metrics)
<span class="hljs-comment"># =&gt; {&#x27;accuracy&#x27;: 0.8511806699615596}</span>

<span class="hljs-comment"># Saving the trained model</span>
model.save_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)
<span class="hljs-comment"># or</span>
model.push_to_hub(<span class="hljs-string">&quot;tomaarsen/setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)

<span class="hljs-comment"># Loading a trained model</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;tomaarsen/setfit-bge-small-v1.5-sst2-8-shot&quot;</span>) <span class="hljs-comment"># Load from the Hugging Face Hub</span>
<span class="hljs-comment"># or</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>) <span class="hljs-comment"># Load from a local directory</span>

<span class="hljs-comment"># Performing inference</span>
preds = model.predict([
    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
])
<span class="hljs-built_in">print</span>(preds)
<span class="hljs-comment"># =&gt; [&quot;positive&quot;, &quot;negative&quot;, &quot;negative&quot;]</span>`,wrap:!1}}),ct=new ze({props:{source:"https://github.com/huggingface/setfit/blob/main/docs/source/en/quickstart.mdx"}}),{c(){f=d("meta"),gt=l(),dt=d("p"),ut=l(),i(y.$$.fragment),ft=l(),i(b.$$.fragment),Mt=l(),w=d("p"),w.innerHTML=de,yt=l(),j=d("p"),j.textContent=he,bt=l(),i(J.$$.fragment),wt=l(),T=d("p"),T.innerHTML=ge,jt=l(),i($.$$.fragment),Jt=l(),i(U.$$.fragment),Tt=l(),v=d("p"),v.textContent=ue,$t=l(),i(x.$$.fragment),Ut=l(),Z=d("p"),Z.innerHTML=fe,vt=l(),I=d("p"),I.innerHTML=Me,xt=l(),i(C.$$.fragment),Zt=l(),F=d("p"),F.innerHTML=ye,It=l(),i(_.$$.fragment),Ct=l(),X=d("p"),X.innerHTML=be,Ft=l(),i(k.$$.fragment),_t=l(),i(G.$$.fragment),Xt=l(),W=d("p"),W.innerHTML=we,kt=l(),i(S.$$.fragment),Gt=l(),B=d("p"),B.innerHTML=je,Wt=l(),R=d("p"),R.innerHTML=Je,St=l(),i(H.$$.fragment),Bt=l(),N=d("p"),N.innerHTML=Te,Rt=l(),i(q.$$.fragment),Ht=l(),i(Q.$$.fragment),Nt=l(),z=d("p"),z.innerHTML=$e,qt=l(),i(Y.$$.fragment),Qt=l(),L=d("p"),L.textContent=Ue,zt=l(),i(E.$$.fragment),Yt=l(),V=d("p"),V.innerHTML=ve,Lt=l(),i(A.$$.fragment),Et=l(),P=d("p"),P.innerHTML=xe,Vt=l(),i(D.$$.fragment),At=l(),i(K.$$.fragment),Pt=l(),O=d("p"),O.innerHTML=Ze,Dt=l(),i(tt.$$.fragment),Kt=l(),i(et.$$.fragment),Ot=l(),st=d("p"),st.innerHTML=Ie,te=l(),i(at.$$.fragment),ee=l(),lt=d("p"),lt.innerHTML=Ce,se=l(),i(nt.$$.fragment),ae=l(),it=d("p"),it.textContent=Fe,le=l(),pt=d("p"),pt.innerHTML=_e,ne=l(),i(rt.$$.fragment),ie=l(),ot=d("p"),ot.textContent=Xe,pe=l(),i(mt.$$.fragment),re=l(),i(ct.$$.fragment),oe=l(),ht=d("p"),this.h()},l(t){const e=Ne("svelte-u9bgzb",document.head);f=h(e,"META",{name:!0,content:!0}),e.forEach(s),gt=n(t),dt=h(t,"P",{}),ke(dt).forEach(s),ut=n(t),p(y.$$.fragment,t),ft=n(t),p(b.$$.fragment,t),Mt=n(t),w=h(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-yf6m1a"&&(w.innerHTML=de),yt=n(t),j=h(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-14v6c2i"&&(j.textContent=he),bt=n(t),p(J.$$.fragment,t),wt=n(t),T=h(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-zdbrrm"&&(T.innerHTML=ge),jt=n(t),p($.$$.fragment,t),Jt=n(t),p(U.$$.fragment,t),Tt=n(t),v=h(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-yv05pn"&&(v.textContent=ue),$t=n(t),p(x.$$.fragment,t),Ut=n(t),Z=h(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-55wyuo"&&(Z.innerHTML=fe),vt=n(t),I=h(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-b5pnqy"&&(I.innerHTML=Me),xt=n(t),p(C.$$.fragment,t),Zt=n(t),F=h(t,"P",{"data-svelte-h":!0}),g(F)!=="svelte-tq1eo0"&&(F.innerHTML=ye),It=n(t),p(_.$$.fragment,t),Ct=n(t),X=h(t,"P",{"data-svelte-h":!0}),g(X)!=="svelte-10w3ory"&&(X.innerHTML=be),Ft=n(t),p(k.$$.fragment,t),_t=n(t),p(G.$$.fragment,t),Xt=n(t),W=h(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1x016ab"&&(W.innerHTML=we),kt=n(t),p(S.$$.fragment,t),Gt=n(t),B=h(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-16rcvd2"&&(B.innerHTML=je),Wt=n(t),R=h(t,"P",{"data-svelte-h":!0}),g(R)!=="svelte-1z01zd6"&&(R.innerHTML=Je),St=n(t),p(H.$$.fragment,t),Bt=n(t),N=h(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kh5mu4"&&(N.innerHTML=Te),Rt=n(t),p(q.$$.fragment,t),Ht=n(t),p(Q.$$.fragment,t),Nt=n(t),z=h(t,"P",{"data-svelte-h":!0}),g(z)!=="svelte-4ybstn"&&(z.innerHTML=$e),qt=n(t),p(Y.$$.fragment,t),Qt=n(t),L=h(t,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1svsu67"&&(L.textContent=Ue),zt=n(t),p(E.$$.fragment,t),Yt=n(t),V=h(t,"P",{"data-svelte-h":!0}),g(V)!=="svelte-1jhyq77"&&(V.innerHTML=ve),Lt=n(t),p(A.$$.fragment,t),Et=n(t),P=h(t,"P",{"data-svelte-h":!0}),g(P)!=="svelte-1hpf3g"&&(P.innerHTML=xe),Vt=n(t),p(D.$$.fragment,t),At=n(t),p(K.$$.fragment,t),Pt=n(t),O=h(t,"P",{"data-svelte-h":!0}),g(O)!=="svelte-1di90ms"&&(O.innerHTML=Ze),Dt=n(t),p(tt.$$.fragment,t),Kt=n(t),p(et.$$.fragment,t),Ot=n(t),st=h(t,"P",{"data-svelte-h":!0}),g(st)!=="svelte-1bu2eyy"&&(st.innerHTML=Ie),te=n(t),p(at.$$.fragment,t),ee=n(t),lt=h(t,"P",{"data-svelte-h":!0}),g(lt)!=="svelte-yxp1nk"&&(lt.innerHTML=Ce),se=n(t),p(nt.$$.fragment,t),ae=n(t),it=h(t,"P",{"data-svelte-h":!0}),g(it)!=="svelte-153smf1"&&(it.textContent=Fe),le=n(t),pt=h(t,"P",{"data-svelte-h":!0}),g(pt)!=="svelte-1h8ndzm"&&(pt.innerHTML=_e),ne=n(t),p(rt.$$.fragment,t),ie=n(t),ot=h(t,"P",{"data-svelte-h":!0}),g(ot)!=="svelte-1lco45x"&&(ot.textContent=Xe),pe=n(t),p(mt.$$.fragment,t),re=n(t),p(ct.$$.fragment,t),oe=n(t),ht=h(t,"P",{}),ke(ht).forEach(s),this.h()},h(){Ge(f,"name","hf:doc:metadata"),Ge(f,"content",Le)},m(t,e){qe(document.head,f),a(t,gt,e),a(t,dt,e),a(t,ut,e),r(y,t,e),a(t,ft,e),r(b,t,e),a(t,Mt,e),a(t,w,e),a(t,yt,e),a(t,j,e),a(t,bt,e),r(J,t,e),a(t,wt,e),a(t,T,e),a(t,jt,e),r($,t,e),a(t,Jt,e),r(U,t,e),a(t,Tt,e),a(t,v,e),a(t,$t,e),r(x,t,e),a(t,Ut,e),a(t,Z,e),a(t,vt,e),a(t,I,e),a(t,xt,e),r(C,t,e),a(t,Zt,e),a(t,F,e),a(t,It,e),r(_,t,e),a(t,Ct,e),a(t,X,e),a(t,Ft,e),r(k,t,e),a(t,_t,e),r(G,t,e),a(t,Xt,e),a(t,W,e),a(t,kt,e),r(S,t,e),a(t,Gt,e),a(t,B,e),a(t,Wt,e),a(t,R,e),a(t,St,e),r(H,t,e),a(t,Bt,e),a(t,N,e),a(t,Rt,e),r(q,t,e),a(t,Ht,e),r(Q,t,e),a(t,Nt,e),a(t,z,e),a(t,qt,e),r(Y,t,e),a(t,Qt,e),a(t,L,e),a(t,zt,e),r(E,t,e),a(t,Yt,e),a(t,V,e),a(t,Lt,e),r(A,t,e),a(t,Et,e),a(t,P,e),a(t,Vt,e),r(D,t,e),a(t,At,e),r(K,t,e),a(t,Pt,e),a(t,O,e),a(t,Dt,e),r(tt,t,e),a(t,Kt,e),r(et,t,e),a(t,Ot,e),a(t,st,e),a(t,te,e),r(at,t,e),a(t,ee,e),a(t,lt,e),a(t,se,e),r(nt,t,e),a(t,ae,e),a(t,it,e),a(t,le,e),a(t,pt,e),a(t,ne,e),r(rt,t,e),a(t,ie,e),a(t,ot,e),a(t,pe,e),r(mt,t,e),a(t,re,e),r(ct,t,e),a(t,oe,e),a(t,ht,e),me=!0},p:Se,i(t){me||(o(y.$$.fragment,t),o(b.$$.fragment,t),o(J.$$.fragment,t),o($.$$.fragment,t),o(U.$$.fragment,t),o(x.$$.fragment,t),o(C.$$.fragment,t),o(_.$$.fragment,t),o(k.$$.fragment,t),o(G.$$.fragment,t),o(S.$$.fragment,t),o(H.$$.fragment,t),o(q.$$.fragment,t),o(Q.$$.fragment,t),o(Y.$$.fragment,t),o(E.$$.fragment,t),o(A.$$.fragment,t),o(D.$$.fragment,t),o(K.$$.fragment,t),o(tt.$$.fragment,t),o(et.$$.fragment,t),o(at.$$.fragment,t),o(nt.$$.fragment,t),o(rt.$$.fragment,t),o(mt.$$.fragment,t),o(ct.$$.fragment,t),me=!0)},o(t){m(y.$$.fragment,t),m(b.$$.fragment,t),m(J.$$.fragment,t),m($.$$.fragment,t),m(U.$$.fragment,t),m(x.$$.fragment,t),m(C.$$.fragment,t),m(_.$$.fragment,t),m(k.$$.fragment,t),m(G.$$.fragment,t),m(S.$$.fragment,t),m(H.$$.fragment,t),m(q.$$.fragment,t),m(Q.$$.fragment,t),m(Y.$$.fragment,t),m(E.$$.fragment,t),m(A.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(et.$$.fragment,t),m(at.$$.fragment,t),m(nt.$$.fragment,t),m(rt.$$.fragment,t),m(mt.$$.fragment,t),m(ct.$$.fragment,t),me=!1},d(t){t&&(s(gt),s(dt),s(ut),s(ft),s(Mt),s(w),s(yt),s(j),s(bt),s(wt),s(T),s(jt),s(Jt),s(Tt),s(v),s($t),s(Ut),s(Z),s(vt),s(I),s(xt),s(Zt),s(F),s(It),s(Ct),s(X),s(Ft),s(_t),s(Xt),s(W),s(kt),s(Gt),s(B),s(Wt),s(R),s(St),s(Bt),s(N),s(Rt),s(Ht),s(Nt),s(z),s(qt),s(Qt),s(L),s(zt),s(Yt),s(V),s(Lt),s(Et),s(P),s(Vt),s(At),s(Pt),s(O),s(Dt),s(Kt),s(Ot),s(st),s(te),s(ee),s(lt),s(se),s(ae),s(it),s(le),s(pt),s(ne),s(ie),s(ot),s(pe),s(re),s(oe),s(ht)),s(f),c(y,t),c(b,t),c(J,t),c($,t),c(U,t),c(x,t),c(C,t),c(_,t),c(k,t),c(G,t),c(S,t),c(H,t),c(q,t),c(Q,t),c(Y,t),c(E,t),c(A,t),c(D,t),c(K,t),c(tt,t),c(et,t),c(at,t),c(nt,t),c(rt,t),c(mt,t),c(ct,t)}}}const Le='{"title":"Quickstart","local":"quickstart","sections":[{"title":"SetFit","local":"setfit","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Saving a 🤗 SetFit model","local":"saving-a--setfit-model","sections":[],"depth":3},{"title":"Loading a 🤗 SetFit model","local":"loading-a--setfit-model","sections":[],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"What’s next?","local":"whats-next","sections":[],"depth":2},{"title":"End-to-end","local":"end-to-end","sections":[],"depth":2}],"depth":1}';function Ee(ce){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Re{constructor(f){super(),He(this,f,Ee,Ye,We,{})}}export{Oe as component};
