import{s as ds,f as ws,o as ms,n as ml}from"../chunks/scheduler.f6319a2a.js";import{S as hs,i as Us,g as i,s as n,r,A as Is,h as o,f as l,c as a,j as Ts,u as c,x as p,k as Le,y as js,a as s,v as u,d as y,t as J,w}from"../chunks/index.85aa684c.js";import{T as dl}from"../chunks/Tip.3d397a88.js";import{C as Z}from"../chunks/CodeBlock.3400fc53.js";import{D as bs}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as h,E as gs}from"../chunks/getInferenceSnippets.143b82cc.js";function Cs(j){let M,U='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){M=i("p"),M.innerHTML=U},l(T){M=o(T,"P",{"data-svelte-h":!0}),p(M)!=="svelte-1p1d9vw"&&(M.innerHTML=U)},m(T,m){s(T,M,m)},p:ml,d(T){T&&l(M)}}}function fs(j){let M,U="It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.",T,m,b="For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.",C,I,k="Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.";return{c(){M=i("p"),M.textContent=U,T=n(),m=i("p"),m.innerHTML=b,C=n(),I=i("p"),I.textContent=k},l(d){M=o(d,"P",{"data-svelte-h":!0}),p(M)!=="svelte-13ohzr"&&(M.textContent=U),T=a(d),m=o(d,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1wfid17"&&(m.innerHTML=b),C=a(d),I=o(d,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1zo76k"&&(I.textContent=k)},m(d,g){s(d,M,g),s(d,T,g),s(d,m,g),s(d,C,g),s(d,I,g)},p:ml,d(d){d&&(l(M),l(T),l(m),l(C),l(I))}}}function xs(j){let M,U=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the E2B sandbox is cleaned up immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=U},l(T){M=o(T,"P",{"data-svelte-h":!0}),p(M)!=="svelte-h2lp0n"&&(M.innerHTML=U)},m(T,m){s(T,M,m)},p:ml,d(T){T&&l(M)}}}function Bs(j){let M,U=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the Docker container is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=U},l(T){M=o(T,"P",{"data-svelte-h":!0}),p(M)!=="svelte-hvigp3"&&(M.innerHTML=U)},m(T,m){s(T,M,m)},p:ml,d(T){T&&l(M)}}}function vs(j){let M,U,T,m,b,C,I,k,d,g,W,Pe,A,hl='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',De,$,Ul="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",Ke,G,Il="Code is just a better way to express actions on a computer. It has better:",Oe,E,jl="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",et,V,bl='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',tt,ze,gl,lt,R,Cl="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",st,N,nt,_,fl="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",at,S,xl="This is inherently risky, LLM-generated code could be harmful to your environment.",it,Q,Bl="Malicious code execution can occur in several ways:",ot,Y,vl=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,pt,H,Zl='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',Mt,X,kl="So you need to be very mindful of security.",rt,z,Wl="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",ct,q,Al="We advise you to keep in mind that no solution will be 100% safe.",ut,qe,$l,yt,F,Jt,L,Gl=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,wt,P,El="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",Tt,D,Vl="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",dt,K,Rl="You could try these safeguards as follows:",mt,O,ht,ee,Nl=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,Ut,f,It,te,_l=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,jt,le,bt,se,Sl="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",gt,ne,Ql='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/remote_execution.png" alt="Sandbox approaches comparison"/>',Ct,ae,Yl="<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>",ft,ie,Hl="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",xt,oe,Bt,pe,vt,Me,Xl='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Zt,re,kt,ce,Wt,ue,zl="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",At,ye,$t,x,Gt,Je,ql=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,Et,we,Fl="This is illustrated in the figure below.",Vt,B,Ll='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',Rt,Te,Pl=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,Nt,de,_t,me,Dl="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",St,he,Kl="Here is how to do it:",Qt,Ue,Yt,Ie,Ht,je,Xt,be,Ol='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',zt,ge,qt,Ce,Ft,fe,es="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",Lt,xe,Pt,v,Dt,Be,Kt,ve,ts="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",Ot,Ze,ls="Here is how to setup the a Dockerfile:",el,ke,tl,We,ss="Create a sandbox manager to run code:",ll,Ae,sl,$e,nl,Ge,ns="These key practices apply to both E2B and Docker sandboxes:",al,Ee,as="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",il,Ve,is="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",ol,Re,pl,Ne,os="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",Ml,_e,rl,Se,ps="<li><strong>Pros</strong>: <ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>",cl,Qe,ul,Ye,Ms="<li><strong>Pros</strong>:<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>",yl,He,rs="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",Jl,Xe,wl,Fe,Tl;return b=new h({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),I=new bs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),d=new dl({props:{warning:!1,$$slots:{default:[Cs]},$$scope:{ctx:j}}}),W=new h({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),N=new h({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),F=new h({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),O=new Z({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),f=new dl({props:{warning:!0,$$slots:{default:[fs]},$$scope:{ctx:j}}}),le=new h({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),oe=new h({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),pe=new h({props:{title:"Installation",local:"installation",headingTag:"h4"}}),re=new Z({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),ce=new h({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),ye=new Z({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMmUyYiUyMiklMEElMEF3aXRoJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>)

<span class="hljs-keyword">with</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),x=new dl({props:{warning:!1,$$slots:{default:[xs]},$$scope:{ctx:j}}}),de=new h({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),Ue=new Z({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),Ie=new h({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),je=new h({props:{title:"Installation",local:"installation",headingTag:"h4"}}),ge=new Z({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),Ce=new h({props:{title:"Running your agent in Docker: quick start",local:"running-your-agent-in-docker-quick-start",headingTag:"h4"}}),xe=new Z({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMmRvY2tlciUyMiklMEElMEF3aXRoJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>)

<span class="hljs-keyword">with</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),v=new dl({props:{warning:!1,$$slots:{default:[Bs]},$$scope:{ctx:j}}}),Be=new h({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),ke=new Z({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),Ae=new Z({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),$e=new h({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),Re=new h({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),_e=new h({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),Qe=new h({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),Xe=new gs({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.md"}}),{c(){M=i("meta"),U=n(),T=i("p"),m=n(),r(b.$$.fragment),C=n(),r(I.$$.fragment),k=n(),r(d.$$.fragment),g=n(),r(W.$$.fragment),Pe=n(),A=i("p"),A.innerHTML=hl,De=n(),$=i("p"),$.textContent=Ul,Ke=n(),G=i("p"),G.textContent=Il,Oe=n(),E=i("ul"),E.innerHTML=jl,et=n(),V=i("p"),V.innerHTML=bl,tt=n(),ze=i("img"),lt=n(),R=i("p"),R.textContent=Cl,st=n(),r(N.$$.fragment),nt=n(),_=i("p"),_.innerHTML=fl,at=n(),S=i("p"),S.textContent=xl,it=n(),Q=i("p"),Q.textContent=Bl,ot=n(),Y=i("ul"),Y.innerHTML=vl,pt=n(),H=i("p"),H.innerHTML=Zl,Mt=n(),X=i("p"),X.textContent=kl,rt=n(),z=i("p"),z.textContent=Wl,ct=n(),q=i("p"),q.textContent=Al,ut=n(),qe=i("img"),yt=n(),r(F.$$.fragment),Jt=n(),L=i("p"),L.innerHTML=Gl,wt=n(),P=i("p"),P.textContent=El,Tt=n(),D=i("ul"),D.innerHTML=Vl,dt=n(),K=i("p"),K.textContent=Rl,mt=n(),r(O.$$.fragment),ht=n(),ee=i("p"),ee.textContent=Nl,Ut=n(),r(f.$$.fragment),It=n(),te=i("p"),te.textContent=_l,jt=n(),r(le.$$.fragment),bt=n(),se=i("p"),se.textContent=Sl,gt=n(),ne=i("p"),ne.innerHTML=Ql,Ct=n(),ae=i("ol"),ae.innerHTML=Yl,ft=n(),ie=i("p"),ie.textContent=Hl,xt=n(),r(oe.$$.fragment),Bt=n(),r(pe.$$.fragment),vt=n(),Me=i("ol"),Me.innerHTML=Xl,Zt=n(),r(re.$$.fragment),kt=n(),r(ce.$$.fragment),Wt=n(),ue=i("p"),ue.innerHTML=zl,At=n(),r(ye.$$.fragment),$t=n(),r(x.$$.fragment),Gt=n(),Je=i("p"),Je.innerHTML=ql,Et=n(),we=i("p"),we.textContent=Fl,Vt=n(),B=i("p"),B.innerHTML=Ll,Rt=n(),Te=i("p"),Te.innerHTML=Pl,Nt=n(),r(de.$$.fragment),_t=n(),me=i("p"),me.textContent=Dl,St=n(),he=i("p"),he.textContent=Kl,Qt=n(),r(Ue.$$.fragment),Yt=n(),r(Ie.$$.fragment),Ht=n(),r(je.$$.fragment),Xt=n(),be=i("ol"),be.innerHTML=Ol,zt=n(),r(ge.$$.fragment),qt=n(),r(Ce.$$.fragment),Ft=n(),fe=i("p"),fe.innerHTML=es,Lt=n(),r(xe.$$.fragment),Pt=n(),r(v.$$.fragment),Dt=n(),r(Be.$$.fragment),Kt=n(),ve=i("p"),ve.textContent=ts,Ot=n(),Ze=i("p"),Ze.textContent=ls,el=n(),r(ke.$$.fragment),tl=n(),We=i("p"),We.textContent=ss,ll=n(),r(Ae.$$.fragment),sl=n(),r($e.$$.fragment),nl=n(),Ge=i("p"),Ge.textContent=ns,al=n(),Ee=i("ul"),Ee.innerHTML=as,il=n(),Ve=i("p"),Ve.textContent=is,ol=n(),r(Re.$$.fragment),pl=n(),Ne=i("p"),Ne.textContent=os,Ml=n(),r(_e.$$.fragment),rl=n(),Se=i("ul"),Se.innerHTML=ps,cl=n(),r(Qe.$$.fragment),ul=n(),Ye=i("ul"),Ye.innerHTML=Ms,yl=n(),He=i("p"),He.textContent=rs,Jl=n(),r(Xe.$$.fragment),wl=n(),Fe=i("p"),this.h()},l(e){const t=Is("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(l),U=a(e),T=o(e,"P",{}),Ts(T).forEach(l),m=a(e),c(b.$$.fragment,e),C=a(e),c(I.$$.fragment,e),k=a(e),c(d.$$.fragment,e),g=a(e),c(W.$$.fragment,e),Pe=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1nor5c0"&&(A.innerHTML=hl),De=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1b2f48c"&&($.textContent=Ul),Ke=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1jp5kiv"&&(G.textContent=Il),Oe=a(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-a7ou7n"&&(E.innerHTML=jl),et=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ugtxvn"&&(V.innerHTML=bl),tt=a(e),ze=o(e,"IMG",{src:!0}),lt=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1lbgv3o"&&(R.textContent=Cl),st=a(e),c(N.$$.fragment,e),nt=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-19p3p3d"&&(_.innerHTML=fl),at=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-y55i8i"&&(S.textContent=xl),it=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-y4kupg"&&(Q.textContent=Bl),ot=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1b6z7ic"&&(Y.innerHTML=vl),pt=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-uopq3c"&&(H.innerHTML=Zl),Mt=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-gfolx1"&&(X.textContent=kl),rt=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1j1i1cv"&&(z.textContent=Wl),ct=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1ghwkh9"&&(q.textContent=Al),ut=a(e),qe=o(e,"IMG",{src:!0}),yt=a(e),c(F.$$.fragment,e),Jt=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-845rka"&&(L.innerHTML=Gl),wt=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-180snho"&&(P.textContent=El),Tt=a(e),D=o(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-19qb8ke"&&(D.innerHTML=Vl),dt=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1wz8jbt"&&(K.textContent=Rl),mt=a(e),c(O.$$.fragment,e),ht=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1gk7uki"&&(ee.textContent=Nl),Ut=a(e),c(f.$$.fragment,e),It=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-whkli4"&&(te.textContent=_l),jt=a(e),c(le.$$.fragment,e),bt=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-grnb59"&&(se.textContent=Sl),gt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-ahtq0i"&&(ne.innerHTML=Ql),Ct=a(e),ae=o(e,"OL",{"data-svelte-h":!0}),p(ae)!=="svelte-1vlvy45"&&(ae.innerHTML=Yl),ft=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1h3g1zs"&&(ie.textContent=Hl),xt=a(e),c(oe.$$.fragment,e),Bt=a(e),c(pe.$$.fragment,e),vt=a(e),Me=o(e,"OL",{"data-svelte-h":!0}),p(Me)!=="svelte-uvtwg2"&&(Me.innerHTML=Xl),Zt=a(e),c(re.$$.fragment,e),kt=a(e),c(ce.$$.fragment,e),Wt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-r3242t"&&(ue.innerHTML=zl),At=a(e),c(ye.$$.fragment,e),$t=a(e),c(x.$$.fragment,e),Gt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-jrgx8f"&&(Je.innerHTML=ql),Et=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-8sir7q"&&(we.textContent=Fl),Vt=a(e),B=o(e,"P",{align:!0,"data-svelte-h":!0}),p(B)!=="svelte-11rtdvt"&&(B.innerHTML=Ll),Rt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-ofpo9r"&&(Te.innerHTML=Pl),Nt=a(e),c(de.$$.fragment,e),_t=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-geglm0"&&(me.textContent=Dl),St=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1iycphr"&&(he.textContent=Kl),Qt=a(e),c(Ue.$$.fragment,e),Yt=a(e),c(Ie.$$.fragment,e),Ht=a(e),c(je.$$.fragment,e),Xt=a(e),be=o(e,"OL",{"data-svelte-h":!0}),p(be)!=="svelte-19h0avy"&&(be.innerHTML=Ol),zt=a(e),c(ge.$$.fragment,e),qt=a(e),c(Ce.$$.fragment,e),Ft=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1j9zoi1"&&(fe.innerHTML=es),Lt=a(e),c(xe.$$.fragment,e),Pt=a(e),c(v.$$.fragment,e),Dt=a(e),c(Be.$$.fragment,e),Kt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-t1it0d"&&(ve.textContent=ts),Ot=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1lygj8"&&(Ze.textContent=ls),el=a(e),c(ke.$$.fragment,e),tl=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-8mtm8c"&&(We.textContent=ss),ll=a(e),c(Ae.$$.fragment,e),sl=a(e),c($e.$$.fragment,e),nl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-5fyo5r"&&(Ge.textContent=ns),al=a(e),Ee=o(e,"UL",{"data-svelte-h":!0}),p(Ee)!=="svelte-162p62u"&&(Ee.innerHTML=as),il=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1hbg2e4"&&(Ve.textContent=is),ol=a(e),c(Re.$$.fragment,e),pl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-i4top7"&&(Ne.textContent=os),Ml=a(e),c(_e.$$.fragment,e),rl=a(e),Se=o(e,"UL",{"data-svelte-h":!0}),p(Se)!=="svelte-8oe7h4"&&(Se.innerHTML=ps),cl=a(e),c(Qe.$$.fragment,e),ul=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-1nt0hab"&&(Ye.innerHTML=Ms),yl=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-l1ns7z"&&(He.textContent=rs),Jl=a(e),c(Xe.$$.fragment,e),wl=a(e),Fe=o(e,"P",{}),Ts(Fe).forEach(l),this.h()},h(){Le(M,"name","hf:doc:metadata"),Le(M,"content",Zs),ws(ze.src,gl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||Le(ze,"src",gl),ws(qe.src,$l="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||Le(qe,"src",$l),Le(B,"align","center")},m(e,t){js(document.head,M),s(e,U,t),s(e,T,t),s(e,m,t),u(b,e,t),s(e,C,t),u(I,e,t),s(e,k,t),u(d,e,t),s(e,g,t),u(W,e,t),s(e,Pe,t),s(e,A,t),s(e,De,t),s(e,$,t),s(e,Ke,t),s(e,G,t),s(e,Oe,t),s(e,E,t),s(e,et,t),s(e,V,t),s(e,tt,t),s(e,ze,t),s(e,lt,t),s(e,R,t),s(e,st,t),u(N,e,t),s(e,nt,t),s(e,_,t),s(e,at,t),s(e,S,t),s(e,it,t),s(e,Q,t),s(e,ot,t),s(e,Y,t),s(e,pt,t),s(e,H,t),s(e,Mt,t),s(e,X,t),s(e,rt,t),s(e,z,t),s(e,ct,t),s(e,q,t),s(e,ut,t),s(e,qe,t),s(e,yt,t),u(F,e,t),s(e,Jt,t),s(e,L,t),s(e,wt,t),s(e,P,t),s(e,Tt,t),s(e,D,t),s(e,dt,t),s(e,K,t),s(e,mt,t),u(O,e,t),s(e,ht,t),s(e,ee,t),s(e,Ut,t),u(f,e,t),s(e,It,t),s(e,te,t),s(e,jt,t),u(le,e,t),s(e,bt,t),s(e,se,t),s(e,gt,t),s(e,ne,t),s(e,Ct,t),s(e,ae,t),s(e,ft,t),s(e,ie,t),s(e,xt,t),u(oe,e,t),s(e,Bt,t),u(pe,e,t),s(e,vt,t),s(e,Me,t),s(e,Zt,t),u(re,e,t),s(e,kt,t),u(ce,e,t),s(e,Wt,t),s(e,ue,t),s(e,At,t),u(ye,e,t),s(e,$t,t),u(x,e,t),s(e,Gt,t),s(e,Je,t),s(e,Et,t),s(e,we,t),s(e,Vt,t),s(e,B,t),s(e,Rt,t),s(e,Te,t),s(e,Nt,t),u(de,e,t),s(e,_t,t),s(e,me,t),s(e,St,t),s(e,he,t),s(e,Qt,t),u(Ue,e,t),s(e,Yt,t),u(Ie,e,t),s(e,Ht,t),u(je,e,t),s(e,Xt,t),s(e,be,t),s(e,zt,t),u(ge,e,t),s(e,qt,t),u(Ce,e,t),s(e,Ft,t),s(e,fe,t),s(e,Lt,t),u(xe,e,t),s(e,Pt,t),u(v,e,t),s(e,Dt,t),u(Be,e,t),s(e,Kt,t),s(e,ve,t),s(e,Ot,t),s(e,Ze,t),s(e,el,t),u(ke,e,t),s(e,tl,t),s(e,We,t),s(e,ll,t),u(Ae,e,t),s(e,sl,t),u($e,e,t),s(e,nl,t),s(e,Ge,t),s(e,al,t),s(e,Ee,t),s(e,il,t),s(e,Ve,t),s(e,ol,t),u(Re,e,t),s(e,pl,t),s(e,Ne,t),s(e,Ml,t),u(_e,e,t),s(e,rl,t),s(e,Se,t),s(e,cl,t),u(Qe,e,t),s(e,ul,t),s(e,Ye,t),s(e,yl,t),s(e,He,t),s(e,Jl,t),u(Xe,e,t),s(e,wl,t),s(e,Fe,t),Tl=!0},p(e,[t]){const cs={};t&2&&(cs.$$scope={dirty:t,ctx:e}),d.$set(cs);const us={};t&2&&(us.$$scope={dirty:t,ctx:e}),f.$set(us);const ys={};t&2&&(ys.$$scope={dirty:t,ctx:e}),x.$set(ys);const Js={};t&2&&(Js.$$scope={dirty:t,ctx:e}),v.$set(Js)},i(e){Tl||(y(b.$$.fragment,e),y(I.$$.fragment,e),y(d.$$.fragment,e),y(W.$$.fragment,e),y(N.$$.fragment,e),y(F.$$.fragment,e),y(O.$$.fragment,e),y(f.$$.fragment,e),y(le.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(x.$$.fragment,e),y(de.$$.fragment,e),y(Ue.$$.fragment,e),y(Ie.$$.fragment,e),y(je.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(xe.$$.fragment,e),y(v.$$.fragment,e),y(Be.$$.fragment,e),y(ke.$$.fragment,e),y(Ae.$$.fragment,e),y($e.$$.fragment,e),y(Re.$$.fragment,e),y(_e.$$.fragment,e),y(Qe.$$.fragment,e),y(Xe.$$.fragment,e),Tl=!0)},o(e){J(b.$$.fragment,e),J(I.$$.fragment,e),J(d.$$.fragment,e),J(W.$$.fragment,e),J(N.$$.fragment,e),J(F.$$.fragment,e),J(O.$$.fragment,e),J(f.$$.fragment,e),J(le.$$.fragment,e),J(oe.$$.fragment,e),J(pe.$$.fragment,e),J(re.$$.fragment,e),J(ce.$$.fragment,e),J(ye.$$.fragment,e),J(x.$$.fragment,e),J(de.$$.fragment,e),J(Ue.$$.fragment,e),J(Ie.$$.fragment,e),J(je.$$.fragment,e),J(ge.$$.fragment,e),J(Ce.$$.fragment,e),J(xe.$$.fragment,e),J(v.$$.fragment,e),J(Be.$$.fragment,e),J(ke.$$.fragment,e),J(Ae.$$.fragment,e),J($e.$$.fragment,e),J(Re.$$.fragment,e),J(_e.$$.fragment,e),J(Qe.$$.fragment,e),J(Xe.$$.fragment,e),Tl=!1},d(e){e&&(l(U),l(T),l(m),l(C),l(k),l(g),l(Pe),l(A),l(De),l($),l(Ke),l(G),l(Oe),l(E),l(et),l(V),l(tt),l(ze),l(lt),l(R),l(st),l(nt),l(_),l(at),l(S),l(it),l(Q),l(ot),l(Y),l(pt),l(H),l(Mt),l(X),l(rt),l(z),l(ct),l(q),l(ut),l(qe),l(yt),l(Jt),l(L),l(wt),l(P),l(Tt),l(D),l(dt),l(K),l(mt),l(ht),l(ee),l(Ut),l(It),l(te),l(jt),l(bt),l(se),l(gt),l(ne),l(Ct),l(ae),l(ft),l(ie),l(xt),l(Bt),l(vt),l(Me),l(Zt),l(kt),l(Wt),l(ue),l(At),l($t),l(Gt),l(Je),l(Et),l(we),l(Vt),l(B),l(Rt),l(Te),l(Nt),l(_t),l(me),l(St),l(he),l(Qt),l(Yt),l(Ht),l(Xt),l(be),l(zt),l(qt),l(Ft),l(fe),l(Lt),l(Pt),l(Dt),l(Kt),l(ve),l(Ot),l(Ze),l(el),l(tl),l(We),l(ll),l(sl),l(nl),l(Ge),l(al),l(Ee),l(il),l(Ve),l(ol),l(pl),l(Ne),l(Ml),l(rl),l(Se),l(cl),l(ul),l(Ye),l(yl),l(He),l(Jl),l(wl),l(Fe)),l(M),w(b,e),w(I,e),w(d,e),w(W,e),w(N,e),w(F,e),w(O,e),w(f,e),w(le,e),w(oe,e),w(pe,e),w(re,e),w(ce,e),w(ye,e),w(x,e),w(de,e),w(Ue,e),w(Ie,e),w(je,e),w(ge,e),w(Ce,e),w(xe,e),w(v,e),w(Be,e),w(ke,e),w(Ae,e),w($e,e),w(Re,e),w(_e,e),w(Qe,e),w(Xe,e)}}}const Zs='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Docker: quick start","local":"running-your-agent-in-docker-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function ks(j){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends hs{constructor(M){super(),Us(this,M,ks,vs,ds,{})}}export{Rs as component};
