import{s as Os,n as Ds,o as Ks}from"../chunks/scheduler.f7e1785c.js";import{S as ea,i as ta,g,s as n,r as a,A as la,h as f,f as l,c as s,j as Es,u as o,x as c,k as qs,y as ia,a as i,v as m,d as r,t as p,w as u}from"../chunks/index.d8354395.js";import{C as d}from"../chunks/CodeBlock.191e5103.js";import{H as $,E as na}from"../chunks/getInferenceSnippets.0844f5df.js";function sa(Pn){let M,el,Dt,tl,T,ll,w,il,h,Vn="This walkthrough guides you through the complete solution for Unit 3’s Pull Request Agent - an MCP server that helps developers create better pull requests by analyzing code changes, monitoring CI/CD pipelines, and automating team communications. The solution demonstrates all three MCP primitives (Tools, Resources, and Prompts) working together in a real-world workflow.",nl,y,sl,U,_n="The PR Agent consists of interconnected modules that progressively build a complete automation system:",al,C,zn="<li><strong>Build MCP Server</strong> - Basic server with Tools for PR template suggestions</li> <li><strong>Smart File Analysis</strong> - Enhanced analysis using Resources for project context</li> <li><strong>GitHub Actions Integration</strong> - CI/CD monitoring with standardized Prompts</li> <li><strong>Hugging Face Hub Integration</strong> - Model deployment and dataset PR workflows</li> <li><strong>Slack Notification</strong> - Team communication integrating all MCP primitives</li>",ol,v,ml,J,rl,b,Zn="A minimal MCP server that analyzes file changes and suggests appropriate PR templates using MCP Tools.",pl,j,ul,I,gl,x,fl,k,Fn="The server uses the MCP SDK to expose these tools to Claude Code, allowing it to gather information and make intelligent decisions about which PR template to use.",$l,R,cl,H,Xn="The <code>analyze_file_changes</code> tool examines the git diff to identify:",dl,L,Yn="<li>File types and extensions</li> <li>Number of files changed</li> <li>Lines added/removed</li> <li>Common patterns (tests, configs, docs)</li>",Ml,B,Nn="This structured data enables Claude to understand the nature of the changes without hard-coding decision logic.",Tl,S,wl,G,Qn="Templates are stored as markdown files in the <code>templates/</code> directory:",hl,W,An="<li><code>bug.md</code> - For bug fixes</li> <li><code>feature.md</code> - For new features</li> <li><code>docs.md</code> - For documentation updates</li> <li><code>refactor.md</code> - For code refactoring</li>",yl,P,En="Each template includes placeholders that Claude can fill based on the analysis.",Ul,V,Cl,_,qn="<li>Claude calls <code>analyze_file_changes</code> to understand what changed</li> <li>Uses <code>get_pr_templates</code> to see available options</li> <li>Calls <code>suggest_template</code> with the analysis data</li> <li>Receives a recommendation with reasoning</li> <li>Can customize the template based on specific changes</li>",vl,z,Jl,Z,On="<li>Understanding tool registration and schemas</li> <li>Letting Claude make decisions with structured data</li> <li>Separation of data gathering from decision logic</li>",bl,F,jl,X,Il,Y,Dn="Enhanced file analysis using MCP Resources to provide project context and team guidelines.",xl,N,kl,Q,Rl,A,Kn="The server exposes four types of resources:",Hl,E,Ll,q,Bl,O,es="The <code>project-context/</code> directory contains:",Sl,D,ts="<li><code>coding-standards.md</code> - Language-specific conventions</li> <li><code>review-guidelines.md</code> - What reviewers look for</li> <li><code>architecture.md</code> - System design patterns</li> <li><code>dependencies.md</code> - Third-party library policies</li>",Gl,K,ls="Claude can read these to understand project-specific requirements.",Wl,ee,Pl,te,is="The <code>git://recent-changes/</code> resource provides:",Vl,le,ns="<li>Recent commit messages and patterns</li> <li>Common PR titles and descriptions</li> <li>Team member contribution patterns</li> <li>Historical template usage</li>",_l,ie,ss="This helps Claude suggest templates consistent with team practices.",zl,ne,Zl,se,as="<li>Reads <code>team://guidelines/review-process.md</code> to understand PR requirements</li> <li>Accesses <code>file://project-context/coding-standards.md</code> for style guides</li> <li>Analyzes <code>git://recent-changes/</code> to match team patterns</li> <li>Combines this context with file analysis for better suggestions</li>",Fl,ae,Xl,oe,os="With resources, Claude can now:",Yl,me,ms="<li>Suggest templates matching team conventions</li> <li>Include project-specific requirements in PRs</li> <li>Reference coding standards in descriptions</li> <li>Align with historical team practices</li>",Nl,re,Ql,pe,rs="<li>Resource URI design and schemas</li> <li>Making project knowledge accessible to AI</li> <li>Context-aware decision making</li> <li>Balancing automation with team standards</li>",Al,ue,El,ge,ql,fe,ps="Real-time CI/CD monitoring using webhooks and standardized prompts for consistent team communication.",Ol,$e,Dl,ce,Kl,de,us="Uses Cloudflare Tunnel to receive GitHub Actions events:",ei,Me,ti,Te,li,we,gs="Four standardized prompts ensure consistency:",ii,he,fs="<li><strong>“Analyze CI Results”</strong> - Process test failures and build errors</li> <li><strong>“Generate Status Summary”</strong> - Create human-readable status updates</li> <li><strong>“Create Follow-up Tasks”</strong> - Suggest next steps based on results</li> <li><strong>“Draft Team Notification”</strong> - Format updates for different audiences</li>",ni,ye,si,Ue,$s="<li>Receive webhook from GitHub</li> <li>Parse event data and extract relevant information</li> <li>Use appropriate prompt based on event type</li> <li>Generate standardized response</li> <li>Store for team notification</li>",ai,Ce,oi,ve,cs="Example prompt usage:",mi,Je,ri,be,pi,je,ds="Prompts ensure that regardless of who’s working:",ui,Ie,Ms="<li>CI failures are analyzed consistently</li> <li>Status updates follow team formats</li> <li>Follow-up actions align with processes</li> <li>Notifications contain required information</li>",gi,xe,fi,ke,Ts="<li>Webhook integration patterns</li> <li>Prompt engineering for consistency</li> <li>Event-driven architectures</li> <li>Standardizing team workflows</li>",$i,Re,ci,He,di,Le,ws="Integration with Hugging Face Hub for LLM and dataset PRs, adding specialized workflows for teams working with language models.",Mi,Be,Ti,Se,wi,Ge,hi,We,yi,Pe,Ui,Ve,Ci,_e,vi,ze,Ji,Ze,hs="When a PR modifies LLM files:",bi,Fe,ys="<li><strong>Tool</strong>: <code>analyze_model_changes</code> detects model architecture changes</li> <li><strong>Resource</strong>: Reads <code>hub://model-cards/llm-template.md</code></li> <li><strong>Prompt</strong>: “Generate Benchmark Summary” creates evaluation section</li> <li><strong>Tool</strong>: <code>generate_model_card</code> updates documentation</li> <li><strong>Resource</strong>: Checks <code>hub://license-info/</code> for compatibility</li>",ji,Xe,Ii,Ye,Us="For training data updates:",xi,Ne,Cs="<li>Validates format consistency</li> <li>Checks data quality metrics</li> <li>Updates dataset cards</li> <li>Suggests appropriate reviewers</li>",ki,Qe,Ri,Ae,vs="<li>Hugging Face Hub API integration</li> <li>LLM-specific PR workflows</li> <li>Model and dataset documentation</li> <li>Community standards compliance</li>",Hi,Ee,Li,qe,Bi,Oe,Js="Automated team notifications combining Tools, Resources, and Prompts for complete workflow automation.",Si,De,Gi,Ke,Wi,et,Pi,tt,Vi,lt,_i,it,zi,nt,Zi,st,Fi,at,bs="When CI fails on a critical PR:",Xi,ot,js="<li><strong>Tool</strong>: <code>get_team_members</code> identifies the PR author and reviewers</li> <li><strong>Resource</strong>: <code>team://members/{user}/preferences</code> checks notification settings</li> <li><strong>Prompt</strong>: “Format Team Update” creates appropriate message</li> <li><strong>Tool</strong>: <code>send_slack_message</code> delivers to right channel</li> <li><strong>Resource</strong>: <code>notification://templates/ci-failure</code> ensures consistent format</li> <li><strong>Prompt</strong>: “Escalate if Critical” determines if additional alerts needed</li>",Yi,mt,Ni,rt,Is="The system considers:",Qi,pt,xs="<li>Team member availability (from calendar resources)</li> <li>Notification preferences (email vs Slack)</li> <li>Message urgency (based on PR labels)</li> <li>Time zones and working hours</li>",Ai,ut,Ei,gt,ks="<li>Primitive integration patterns</li> <li>Complex workflow orchestration</li> <li>Balancing automation with human needs</li> <li>Production-ready error handling</li>",qi,ft,Oi,$t,Rs="Here’s how all components work together for a typical PR:",Di,ct,Hs="<li><p><strong>Developer creates PR</strong></p> <ul><li>GitHub webhook triggers the server</li> <li>Tool: <code>analyze_file_changes</code> examines the diff</li> <li>Resource: Reads team guidelines and project context</li> <li>Prompt: Suggests optimal PR template</li></ul></li> <li><p><strong>CI/CD Pipeline Runs</strong></p> <ul><li>Webhook receives workflow events</li> <li>Prompt: “Analyze CI Results” processes outcomes</li> <li>Resource: Checks team escalation policies</li> <li>Tool: Updates PR status in GitHub</li></ul></li> <li><p><strong>Hugging Face Hub Integration</strong></p> <ul><li>Tool: Detects LLM/dataset changes</li> <li>Resource: Reads Hub guidelines</li> <li>Prompt: Generates model card updates</li> <li>Tool: Validates against Hub standards</li></ul></li> <li><p><strong>Team Notification</strong></p> <ul><li>Tool: Identifies relevant team members</li> <li>Resource: Reads notification preferences</li> <li>Prompt: Formats appropriate message</li> <li>Tool: Sends via Slack channels</li></ul></li> <li><p><strong>Follow-up Actions</strong></p> <ul><li>Prompt: “Create Follow-up Tasks” generates next steps</li> <li>Tool: Creates GitHub issues if needed</li> <li>Resource: Links to documentation</li> <li>All primitives work together seamlessly</li></ul></li>",Ki,dt,en,Mt,tn,Tt,Ls="Each module includes comprehensive unit tests:",ln,wt,Bs="<li>Tool schema validation</li> <li>Resource URI parsing</li> <li>Prompt template rendering</li> <li>Integration scenarios</li>",nn,ht,sn,yt,Ss="End-to-end tests cover:",an,Ut,Gs="<li>Complete PR workflow</li> <li>Error recovery scenarios</li> <li>Performance under load</li> <li>Security validation</li>",on,Ct,mn,vt,rn,Jt,pn,bt,un,jt,Ws="<li><strong>Start the MCP server</strong>: <code>python server.py</code></li> <li><strong>Configure Claude Code</strong>: Add server to MCP settings</li> <li><strong>Set up Cloudflare Tunnel</strong>: <code>cloudflared tunnel --url http://localhost:3000</code></li> <li><strong>Configure webhooks</strong>: Add tunnel URL to GitHub repository</li> <li><strong>Test the workflow</strong>: Create a PR and watch the automation</li>",gn,It,fn,xt,Ps="Simple file-based configuration for easy setup:",$n,kt,Vs="<li>GitHub tokens in <code>.env</code> file</li> <li>Slack webhooks in config</li> <li>Template customization in <code>templates/</code></li> <li>All settings in one place</li>",cn,Rt,dn,Ht,Mn,Lt,_s="<li>Keep tools focused and single-purpose</li> <li>Return structured data for AI interpretation</li> <li>Include comprehensive error messages</li> <li>Version your tool schemas</li>",Tn,Bt,wn,St,zs="<li>Use clear URI hierarchies</li> <li>Implement resource discovery</li> <li>Cache frequently accessed resources</li> <li>Version control all resources</li>",hn,Gt,yn,Wt,Zs="<li>Make prompts specific but flexible</li> <li>Include context and examples</li> <li>Test with various inputs</li> <li>Maintain prompt libraries</li>",Un,Pt,Cn,Vt,Fs="<li>Use events for loose coupling</li> <li>Implement circuit breakers</li> <li>Add retries with backoff</li> <li>Monitor all external calls</li>",vn,_t,Jn,zt,bn,Zt,Xs="<li><p><strong>Webhook not receiving events</strong></p> <ul><li>Check Cloudflare Tunnel is running</li> <li>Verify GitHub webhook configuration</li> <li>Confirm secret matches</li></ul></li> <li><p><strong>Tools not appearing in Claude</strong></p> <ul><li>Validate tool schemas</li> <li>Check server registration</li> <li>Review MCP connection</li></ul></li> <li><p><strong>Resources not accessible</strong></p> <ul><li>Verify file permissions</li> <li>Check URI formatting</li> <li>Confirm resource registration</li></ul></li> <li><p><strong>Prompts producing inconsistent results</strong></p> <ul><li>Review prompt templates</li> <li>Check context provided</li> <li>Validate input formatting</li></ul></li>",jn,Ft,In,Xt,xn,Yt,Ys="<li>Add more code analysis tools (complexity, security)</li> <li>Integrate with more communication platforms</li> <li>Add custom workflow definitions</li> <li>Implement PR auto-merge capabilities</li>",kn,Nt,Rn,Qt,Ns="<li><strong>Next</strong>: Unit 4 - Deploy this server remotely</li> <li><strong>Advanced</strong>: Custom MCP protocol extensions</li> <li><strong>Expert</strong>: Multi-server orchestration</li>",Hn,At,Ln,Et,Qs="This PR Agent demonstrates the power of MCP’s three primitives working together. Tools provide capabilities, Resources offer context, and Prompts ensure consistency. Combined, they create an intelligent automation system that enhances developer productivity while maintaining team standards.",Bn,qt,As="The modular architecture ensures each component can be understood, tested, and extended independently, while the integration showcases real-world patterns you’ll use in production MCP servers.",Sn,Ot,Gn,Kt,Wn;return T=new $({props:{title:"Unit 3 Solution Walkthrough: Building a Pull Request Agent with MCP",local:"unit-3-solution-walkthrough-building-a-pull-request-agent-with-mcp",headingTag:"h1"}}),w=new $({props:{title:"Overview",local:"overview",headingTag:"h2"}}),y=new $({props:{title:"Architecture Overview",local:"architecture-overview",headingTag:"h2"}}),v=new $({props:{title:"Module 1: Build MCP Server",local:"module-1-build-mcp-server",headingTag:"h2"}}),J=new $({props:{title:"What We’re Building",local:"what-were-building",headingTag:"h3"}}),j=new $({props:{title:"Key Components",local:"key-components",headingTag:"h3"}}),I=new $({props:{title:"1. Server Initialization ( server.py )",local:"1-server-initialization--serverpy-",headingTag:"h4"}}),x=new d({props:{code:"JTIzJTIwVGhlJTIwc2VydmVyJTIwcmVnaXN0ZXJzJTIwdGhyZWUlMjBlc3NlbnRpYWwlMjB0b29scyUzQSUwQSUyMyUyMC0lMjBhbmFseXplX2ZpbGVfY2hhbmdlcyUzQSUyMFJldHVybnMlMjBzdHJ1Y3R1cmVkJTIwZGF0YSUyMGFib3V0JTIwY2hhbmdlZCUyMGZpbGVzJTBBJTIzJTIwLSUyMGdldF9wcl90ZW1wbGF0ZXMlM0ElMjBMaXN0cyUyMGF2YWlsYWJsZSUyMHRlbXBsYXRlcyUyMHdpdGglMjBtZXRhZGF0YSUwQSUyMyUyMC0lMjBzdWdnZXN0X3RlbXBsYXRlJTNBJTIwUHJvdmlkZXMlMjBpbnRlbGxpZ2VudCUyMHRlbXBsYXRlJTIwcmVjb21tZW5kYXRpb25z",highlighted:`<span class="hljs-comment"># The server registers three essential tools:</span>
<span class="hljs-comment"># - analyze_file_changes: Returns structured data about changed files</span>
<span class="hljs-comment"># - get_pr_templates: Lists available templates with metadata</span>
<span class="hljs-comment"># - suggest_template: Provides intelligent template recommendations</span>`,wrap:!1}}),R=new $({props:{title:"2. File Analysis Tool",local:"2-file-analysis-tool",headingTag:"h4"}}),S=new $({props:{title:"3. Template Management",local:"3-template-management",headingTag:"h4"}}),V=new $({props:{title:"How Claude Uses These Tools",local:"how-claude-uses-these-tools",headingTag:"h3"}}),z=new $({props:{title:"Learning Outcomes",local:"learning-outcomes",headingTag:"h3"}}),F=new $({props:{title:"Module 2: Smart File Analysis",local:"module-2-smart-file-analysis",headingTag:"h2"}}),X=new $({props:{title:"What We’re Building",local:"what-were-building",headingTag:"h3"}}),N=new $({props:{title:"Key Components",local:"key-components",headingTag:"h3"}}),Q=new $({props:{title:"1. Resource Registration",local:"1-resource-registration",headingTag:"h4"}}),E=new d({props:{code:"JTIzJTIwUmVzb3VyY2VzJTIwcHJvdmlkZSUyMHJlYWQtb25seSUyMGFjY2VzcyUyMHRvJTNBJTBBJTIzJTIwLSUyMGZpbGUlM0ElMkYlMkZ0ZW1wbGF0ZXMlMkYlMjAtJTIwUFIlMjB0ZW1wbGF0ZSUyMGZpbGVzJTBBJTIzJTIwLSUyMGZpbGUlM0ElMkYlMkZwcm9qZWN0LWNvbnRleHQlMkYlMjAtJTIwQ29kaW5nJTIwc3RhbmRhcmRzJTJDJTIwY29udmVudGlvbnMlMEElMjMlMjAtJTIwZ2l0JTNBJTJGJTJGcmVjZW50LWNoYW5nZXMlMkYlMjAtJTIwQ29tbWl0JTIwaGlzdG9yeSUyMGFuZCUyMHBhdHRlcm5zJTBBJTIzJTIwLSUyMHRlYW0lM0ElMkYlMkZndWlkZWxpbmVzJTJGJTIwLSUyMFJldmlldyUyMHByb2Nlc3NlcyUyMGFuZCUyMHN0YW5kYXJkcw==",highlighted:`<span class="hljs-comment"># Resources provide read-only access to:</span>
<span class="hljs-comment"># - file://templates/ - PR template files</span>
<span class="hljs-comment"># - file://project-context/ - Coding standards, conventions</span>
<span class="hljs-comment"># - git://recent-changes/ - Commit history and patterns</span>
<span class="hljs-comment"># - team://guidelines/ - Review processes and standards</span>`,wrap:!1}}),q=new $({props:{title:"2. Project Context Resources",local:"2-project-context-resources",headingTag:"h4"}}),ee=new $({props:{title:"3. Git History Analysis",local:"3-git-history-analysis",headingTag:"h4"}}),ne=new $({props:{title:"How Claude Uses Resources",local:"how-claude-uses-resources",headingTag:"h3"}}),ae=new $({props:{title:"Enhanced Decision Making",local:"enhanced-decision-making",headingTag:"h3"}}),re=new $({props:{title:"Learning Outcomes",local:"learning-outcomes",headingTag:"h3"}}),ue=new $({props:{title:"Module 3: GitHub Actions Integration",local:"module-3-github-actions-integration",headingTag:"h2"}}),ge=new $({props:{title:"What We’re Building",local:"what-were-building",headingTag:"h3"}}),$e=new $({props:{title:"Key Components",local:"key-components",headingTag:"h3"}}),ce=new $({props:{title:"1. Webhook Server",local:"1-webhook-server",headingTag:"h4"}}),Me=new d({props:{code:"JTIzJTIwV2ViaG9vayUyMGVuZHBvaW50JTIwaGFuZGxlcyUzQSUwQSUyMyUyMC0lMjB3b3JrZmxvd19ydW4lMjBldmVudHMlMEElMjMlMjAtJTIwY2hlY2tfcnVuJTIwZXZlbnRzJTIwJTIwJTBBJTIzJTIwLSUyMHB1bGxfcmVxdWVzdCUyMHN0YXR1cyUyMHVwZGF0ZXMlMEElMjMlMjAtJTIwZGVwbG95bWVudCUyMG5vdGlmaWNhdGlvbnM=",highlighted:`<span class="hljs-comment"># Webhook endpoint handles:</span>
<span class="hljs-comment"># - workflow_run events</span>
<span class="hljs-comment"># - check_run events  </span>
<span class="hljs-comment"># - pull_request status updates</span>
<span class="hljs-comment"># - deployment notifications</span>`,wrap:!1}}),Te=new $({props:{title:"2. Prompt Templates",local:"2-prompt-templates",headingTag:"h4"}}),ye=new $({props:{title:"3. Event Processing Pipeline",local:"3-event-processing-pipeline",headingTag:"h4"}}),Ce=new $({props:{title:"How Claude Uses Prompts",local:"how-claude-uses-prompts",headingTag:"h3"}}),Je=new d({props:{code:"JTIzJTIwV2hlbiUyMHRlc3RzJTIwZmFpbCUyQyUyMENsYXVkZSUyMHVzZXMlMjB0aGUlMjAlMjJBbmFseXplJTIwQ0klMjBSZXN1bHRzJTIyJTIwcHJvbXB0JTNBJTBBcHJvbXB0X2RhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJldmVudF90eXBlJTIyJTNBJTIwJTIyd29ya2Zsb3dfcnVuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIyZmFpbHVyZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmZhaWxlZF9qb2JzJTIyJTNBJTIwJTVCJTIydW5pdC10ZXN0cyUyMiUyQyUyMCUyMmxpbnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJlcnJvcl9sb2dzJTIyJTNBJTIwJTIyLi4uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycHJfY29udGV4dCUyMiUzQSUyMCU3Qi4uLiU3RCUwQSU3RCUwQSUwQSUyMyUyMENsYXVkZSUyMGdlbmVyYXRlcyUzQSUwQSUyMyUyMC0lMjBSb290JTIwY2F1c2UlMjBhbmFseXNpcyUwQSUyMyUyMC0lMjBTdWdnZXN0ZWQlMjBmaXhlcyUwQSUyMyUyMC0lMjBJbXBhY3QlMjBhc3Nlc3NtZW50JTBBJTIzJTIwLSUyME5leHQlMjBzdGVwcw==",highlighted:`<span class="hljs-comment"># When tests fail, Claude uses the &quot;Analyze CI Results&quot; prompt:</span>
prompt_data = {
    <span class="hljs-string">&quot;event_type&quot;</span>: <span class="hljs-string">&quot;workflow_run&quot;</span>,
    <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;failure&quot;</span>,
    <span class="hljs-string">&quot;failed_jobs&quot;</span>: [<span class="hljs-string">&quot;unit-tests&quot;</span>, <span class="hljs-string">&quot;lint&quot;</span>],
    <span class="hljs-string">&quot;error_logs&quot;</span>: <span class="hljs-string">&quot;...&quot;</span>,
    <span class="hljs-string">&quot;pr_context&quot;</span>: {...}
}

<span class="hljs-comment"># Claude generates:</span>
<span class="hljs-comment"># - Root cause analysis</span>
<span class="hljs-comment"># - Suggested fixes</span>
<span class="hljs-comment"># - Impact assessment</span>
<span class="hljs-comment"># - Next steps</span>`,wrap:!1}}),be=new $({props:{title:"Standardized Workflows",local:"standardized-workflows",headingTag:"h3"}}),xe=new $({props:{title:"Learning Outcomes",local:"learning-outcomes",headingTag:"h3"}}),Re=new $({props:{title:"Module 4: Hugging Face Hub Integration",local:"module-4-hugging-face-hub-integration",headingTag:"h2"}}),He=new $({props:{title:"What We’re Building",local:"what-were-building",headingTag:"h3"}}),Be=new $({props:{title:"Key Components",local:"key-components",headingTag:"h3"}}),Se=new $({props:{title:"1. Hub-Specific Tools",local:"1-hub-specific-tools",headingTag:"h4"}}),Ge=new d({props:{code:"JTIzJTIwVG9vbHMlMjBmb3IlMjBIdWdnaW5nJTIwRmFjZSUyMHdvcmtmbG93cyUzQSUwQSUyMyUyMC0lMjBhbmFseXplX21vZGVsX2NoYW5nZXMlM0ElMjBEZXRlY3QlMjBMTE0lMjBmaWxlJTIwbW9kaWZpY2F0aW9ucyUwQSUyMyUyMC0lMjB2YWxpZGF0ZV9kYXRhc2V0X2Zvcm1hdCUzQSUyMENoZWNrJTIwdHJhaW5pbmclMjBkYXRhJTIwY29tcGxpYW5jZSUwQSUyMyUyMC0lMjBnZW5lcmF0ZV9tb2RlbF9jYXJkJTNBJTIwQ3JlYXRlJTJGdXBkYXRlJTIwbW9kZWwlMjBkb2N1bWVudGF0aW9uJTBBJTIzJTIwLSUyMHN1Z2dlc3RfaHViX3RlbXBsYXRlJTNBJTIwUFIlMjB0ZW1wbGF0ZXMlMjBmb3IlMjBMTE1zJTJGZGF0YXNldHM=",highlighted:`<span class="hljs-comment"># Tools for Hugging Face workflows:</span>
<span class="hljs-comment"># - analyze_model_changes: Detect LLM file modifications</span>
<span class="hljs-comment"># - validate_dataset_format: Check training data compliance</span>
<span class="hljs-comment"># - generate_model_card: Create/update model documentation</span>
<span class="hljs-comment"># - suggest_hub_template: PR templates for LLMs/datasets</span>`,wrap:!1}}),We=new $({props:{title:"2. Hub Resources",local:"2-hub-resources",headingTag:"h4"}}),Pe=new d({props:{code:"JTIzJTIwUmVzb3VyY2VzJTIwZm9yJTIwSHViJTIwY29udGV4dCUzQSUwQSUyMyUyMC0lMjBodWIlM0ElMkYlMkZtb2RlbC1jYXJkcyUyRiUyMC0lMjBMTE0lMjBjYXJkJTIwdGVtcGxhdGVzJTIwYW5kJTIwZXhhbXBsZXMlMEElMjMlMjAtJTIwaHViJTNBJTJGJTJGZGF0YXNldC1mb3JtYXRzJTJGJTIwLSUyMFRyYWluaW5nJTIwZGF0YSUyMHNwZWNpZmljYXRpb25zJTBBJTIzJTIwLSUyMGh1YiUzQSUyRiUyRmNvbW11bml0eS1zdGFuZGFyZHMlMkYlMjAtJTIwSHViJTIwY29tbXVuaXR5JTIwZ3VpZGVsaW5lcyUwQSUyMyUyMC0lMjBodWIlM0ElMkYlMkZsaWNlbnNlLWluZm8lMkYlMjAtJTIwTGljZW5zZSUyMGNvbXBhdGliaWxpdHklMjBjaGVja3M=",highlighted:`<span class="hljs-comment"># Resources for Hub context:</span>
<span class="hljs-comment"># - hub://model-cards/ - LLM card templates and examples</span>
<span class="hljs-comment"># - hub://dataset-formats/ - Training data specifications</span>
<span class="hljs-comment"># - hub://community-standards/ - Hub community guidelines</span>
<span class="hljs-comment"># - hub://license-info/ - License compatibility checks</span>`,wrap:!1}}),Ve=new $({props:{title:"3. LLM-Specific Prompts",local:"3-llm-specific-prompts",headingTag:"h4"}}),_e=new d({props:{code:"JTIzJTIwUHJvbXB0cyUyMGZvciUyMExMTSUyMHdvcmtmbG93cyUzQSUwQSUyMyUyMC0lMjAlMjJBbmFseXplJTIwTW9kZWwlMjBDaGFuZ2VzJTIyJTIwLSUyMFVuZGVyc3RhbmQlMjBMTE0lMjB1cGRhdGVzJTBBJTIzJTIwLSUyMCUyMkdlbmVyYXRlJTIwQmVuY2htYXJrJTIwU3VtbWFyeSUyMiUyMC0lMjBDcmVhdGUlMjBldmFsdWF0aW9uJTIwbWV0cmljcyUwQSUyMyUyMC0lMjAlMjJDaGVjayUyMERhdGFzZXQlMjBRdWFsaXR5JTIyJTIwLSUyMFZhbGlkYXRlJTIwdHJhaW5pbmclMjBkYXRhJTBBJTIzJTIwLSUyMCUyMkRyYWZ0JTIwTW9kZWwlMjBDYXJkJTIwVXBkYXRlJTIyJTIwLSUyMFVwZGF0ZSUyMGRvY3VtZW50YXRpb24=",highlighted:`<span class="hljs-comment"># Prompts for LLM workflows:</span>
<span class="hljs-comment"># - &quot;Analyze Model Changes&quot; - Understand LLM updates</span>
<span class="hljs-comment"># - &quot;Generate Benchmark Summary&quot; - Create evaluation metrics</span>
<span class="hljs-comment"># - &quot;Check Dataset Quality&quot; - Validate training data</span>
<span class="hljs-comment"># - &quot;Draft Model Card Update&quot; - Update documentation</span>`,wrap:!1}}),ze=new $({props:{title:"Hub-Specific Workflows",local:"hub-specific-workflows",headingTag:"h3"}}),Xe=new $({props:{title:"Dataset PR Handling",local:"dataset-pr-handling",headingTag:"h3"}}),Qe=new $({props:{title:"Learning Outcomes",local:"learning-outcomes",headingTag:"h3"}}),Ee=new $({props:{title:"Module 5: Slack Notification",local:"module-5-slack-notification",headingTag:"h2"}}),qe=new $({props:{title:"What We’re Building",local:"what-were-building",headingTag:"h3"}}),De=new $({props:{title:"Key Components",local:"key-components",headingTag:"h3"}}),Ke=new $({props:{title:"1. Communication Tools",local:"1-communication-tools",headingTag:"h4"}}),et=new d({props:{code:"JTIzJTIwVGhyZWUlMjB0b29scyUyMGZvciUyMHRlYW0lMjB1cGRhdGVzJTNBJTBBJTIzJTIwLSUyMHNlbmRfc2xhY2tfbWVzc2FnZSUzQSUyMFBvc3QlMjB0byUyMHRlYW0lMjBjaGFubmVscyUwQSUyMyUyMC0lMjBnZXRfdGVhbV9tZW1iZXJzJTNBJTIwSWRlbnRpZnklMjB3aG8lMjB0byUyMG5vdGlmeSUwQSUyMyUyMC0lMjB0cmFja19ub3RpZmljYXRpb25fc3RhdHVzJTNBJTIwTW9uaXRvciUyMGRlbGl2ZXJ5",highlighted:`<span class="hljs-comment"># Three tools for team updates:</span>
<span class="hljs-comment"># - send_slack_message: Post to team channels</span>
<span class="hljs-comment"># - get_team_members: Identify who to notify</span>
<span class="hljs-comment"># - track_notification_status: Monitor delivery</span>`,wrap:!1}}),tt=new $({props:{title:"2. Team Resources",local:"2-team-resources",headingTag:"h4"}}),lt=new d({props:{code:"JTIzJTIwUmVzb3VyY2VzJTIwZm9yJTIwdGVhbSUyMGRhdGElM0ElMEElMjMlMjAtJTIwdGVhbSUzQSUyRiUyRm1lbWJlcnMlMkYlMjAtJTIwRGV2ZWxvcGVyJTIwcHJvZmlsZXMlMjBhbmQlMjBwcmVmZXJlbmNlcyUwQSUyMyUyMC0lMjBzbGFjayUzQSUyRiUyRmNoYW5uZWxzJTJGJTIwLSUyMENoYW5uZWwlMjBjb25maWd1cmF0aW9ucyUwQSUyMyUyMC0lMjBub3RpZmljYXRpb24lM0ElMkYlMkZ0ZW1wbGF0ZXMlMkYlMjAtJTIwTWVzc2FnZSUyMGZvcm1hdHM=",highlighted:`<span class="hljs-comment"># Resources for team data:</span>
<span class="hljs-comment"># - team://members/ - Developer profiles and preferences</span>
<span class="hljs-comment"># - slack://channels/ - Channel configurations</span>
<span class="hljs-comment"># - notification://templates/ - Message formats</span>`,wrap:!1}}),it=new $({props:{title:"3. Notification Prompts",local:"3-notification-prompts",headingTag:"h4"}}),nt=new d({props:{code:"JTIzJTIwUHJvbXB0cyUyMGZvciUyMGNvbW11bmljYXRpb24lM0ElMEElMjMlMjAtJTIwJTIyRm9ybWF0JTIwVGVhbSUyMFVwZGF0ZSUyMiUyMC0lMjBTdHlsZSUyMG1lc3NhZ2VzJTIwYXBwcm9wcmlhdGVseSUwQSUyMyUyMC0lMjAlMjJDaG9vc2UlMjBDb21tdW5pY2F0aW9uJTIwQ2hhbm5lbCUyMiUyMC0lMjBTZWxlY3QlMjByaWdodCUyMGF1ZGllbmNlJTBBJTIzJTIwLSUyMCUyMkVzY2FsYXRlJTIwaWYlMjBDcml0aWNhbCUyMiUyMC0lMjBIYW5kbGUlMjB1cmdlbnQlMjBpc3N1ZXM=",highlighted:`<span class="hljs-comment"># Prompts for communication:</span>
<span class="hljs-comment"># - &quot;Format Team Update&quot; - Style messages appropriately</span>
<span class="hljs-comment"># - &quot;Choose Communication Channel&quot; - Select right audience</span>
<span class="hljs-comment"># - &quot;Escalate if Critical&quot; - Handle urgent issues</span>`,wrap:!1}}),st=new $({props:{title:"Integration Example",local:"integration-example",headingTag:"h3"}}),mt=new $({props:{title:"Intelligent Routing",local:"intelligent-routing",headingTag:"h3"}}),ut=new $({props:{title:"Learning Outcomes",local:"learning-outcomes",headingTag:"h3"}}),ft=new $({props:{title:"Complete Workflow Example",local:"complete-workflow-example",headingTag:"h2"}}),dt=new $({props:{title:"Testing Strategy",local:"testing-strategy",headingTag:"h2"}}),Mt=new $({props:{title:"Unit Tests",local:"unit-tests",headingTag:"h3"}}),ht=new $({props:{title:"Integration Tests",local:"integration-tests",headingTag:"h3"}}),Ct=new $({props:{title:"Test Structure",local:"test-structure",headingTag:"h3"}}),vt=new d({props:{code:"dGVzdHMlMkYlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB1bml0JTJGJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwdGVzdF90b29scy5weSUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHRlc3RfcmVzb3VyY2VzLnB5JTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwdGVzdF9wcm9tcHRzLnB5JTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwdGVzdF9pbnRlZ3JhdGlvbi5weSUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGludGVncmF0aW9uJTJGJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwdGVzdF93b3JrZmxvdy5weSUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHRlc3Rfd2ViaG9va3MucHklMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjB0ZXN0X25vdGlmaWNhdGlvbnMucHklMEElRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBmaXh0dXJlcyUyRiUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNhbXBsZV9ldmVudHMuanNvbiUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMG1vY2tfcmVzcG9uc2VzLmpzb24=",highlighted:`tests/
├── unit/
│   ├── test_tools<span class="hljs-selector-class">.py</span>
│   ├── test_resources<span class="hljs-selector-class">.py</span>
│   ├── test_prompts<span class="hljs-selector-class">.py</span>
│   └── test_integration<span class="hljs-selector-class">.py</span>
├── integration/
│   ├── test_workflow<span class="hljs-selector-class">.py</span>
│   ├── test_webhooks<span class="hljs-selector-class">.py</span>
│   └── test_notifications<span class="hljs-selector-class">.py</span>
└── fixtures/
    ├── sample_events<span class="hljs-selector-class">.json</span>
    └── mock_responses.json`,wrap:!1}}),Jt=new $({props:{title:"Running the Solution",local:"running-the-solution",headingTag:"h2"}}),bt=new $({props:{title:"Local Development Setup",local:"local-development-setup",headingTag:"h3"}}),It=new $({props:{title:"Configuration",local:"configuration",headingTag:"h3"}}),Rt=new $({props:{title:"Common Patterns and Best Practices",local:"common-patterns-and-best-practices",headingTag:"h2"}}),Ht=new $({props:{title:"Tool Design",local:"tool-design",headingTag:"h3"}}),Bt=new $({props:{title:"Resource Organization",local:"resource-organization",headingTag:"h3"}}),Gt=new $({props:{title:"Prompt Engineering",local:"prompt-engineering",headingTag:"h3"}}),Pt=new $({props:{title:"Integration Patterns",local:"integration-patterns",headingTag:"h3"}}),_t=new $({props:{title:"Troubleshooting Guide",local:"troubleshooting-guide",headingTag:"h2"}}),zt=new $({props:{title:"Common Issues",local:"common-issues",headingTag:"h3"}}),Ft=new $({props:{title:"Next Steps and Extensions",local:"next-steps-and-extensions",headingTag:"h2"}}),Xt=new $({props:{title:"Potential Enhancements",local:"potential-enhancements",headingTag:"h3"}}),Nt=new $({props:{title:"Learning Path",local:"learning-path",headingTag:"h3"}}),At=new $({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Ot=new na({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3/build-mcp-server-solution-walkthrough.mdx"}}),{c(){M=g("meta"),el=n(),Dt=g("p"),tl=n(),a(T.$$.fragment),ll=n(),a(w.$$.fragment),il=n(),h=g("p"),h.textContent=Vn,nl=n(),a(y.$$.fragment),sl=n(),U=g("p"),U.textContent=_n,al=n(),C=g("ol"),C.innerHTML=zn,ol=n(),a(v.$$.fragment),ml=n(),a(J.$$.fragment),rl=n(),b=g("p"),b.textContent=Zn,pl=n(),a(j.$$.fragment),ul=n(),a(I.$$.fragment),gl=n(),a(x.$$.fragment),fl=n(),k=g("p"),k.textContent=Fn,$l=n(),a(R.$$.fragment),cl=n(),H=g("p"),H.innerHTML=Xn,dl=n(),L=g("ul"),L.innerHTML=Yn,Ml=n(),B=g("p"),B.textContent=Nn,Tl=n(),a(S.$$.fragment),wl=n(),G=g("p"),G.innerHTML=Qn,hl=n(),W=g("ul"),W.innerHTML=An,yl=n(),P=g("p"),P.textContent=En,Ul=n(),a(V.$$.fragment),Cl=n(),_=g("ol"),_.innerHTML=qn,vl=n(),a(z.$$.fragment),Jl=n(),Z=g("ul"),Z.innerHTML=On,bl=n(),a(F.$$.fragment),jl=n(),a(X.$$.fragment),Il=n(),Y=g("p"),Y.textContent=Dn,xl=n(),a(N.$$.fragment),kl=n(),a(Q.$$.fragment),Rl=n(),A=g("p"),A.textContent=Kn,Hl=n(),a(E.$$.fragment),Ll=n(),a(q.$$.fragment),Bl=n(),O=g("p"),O.innerHTML=es,Sl=n(),D=g("ul"),D.innerHTML=ts,Gl=n(),K=g("p"),K.textContent=ls,Wl=n(),a(ee.$$.fragment),Pl=n(),te=g("p"),te.innerHTML=is,Vl=n(),le=g("ul"),le.innerHTML=ns,_l=n(),ie=g("p"),ie.textContent=ss,zl=n(),a(ne.$$.fragment),Zl=n(),se=g("ol"),se.innerHTML=as,Fl=n(),a(ae.$$.fragment),Xl=n(),oe=g("p"),oe.textContent=os,Yl=n(),me=g("ul"),me.innerHTML=ms,Nl=n(),a(re.$$.fragment),Ql=n(),pe=g("ul"),pe.innerHTML=rs,Al=n(),a(ue.$$.fragment),El=n(),a(ge.$$.fragment),ql=n(),fe=g("p"),fe.textContent=ps,Ol=n(),a($e.$$.fragment),Dl=n(),a(ce.$$.fragment),Kl=n(),de=g("p"),de.textContent=us,ei=n(),a(Me.$$.fragment),ti=n(),a(Te.$$.fragment),li=n(),we=g("p"),we.textContent=gs,ii=n(),he=g("ul"),he.innerHTML=fs,ni=n(),a(ye.$$.fragment),si=n(),Ue=g("ol"),Ue.innerHTML=$s,ai=n(),a(Ce.$$.fragment),oi=n(),ve=g("p"),ve.textContent=cs,mi=n(),a(Je.$$.fragment),ri=n(),a(be.$$.fragment),pi=n(),je=g("p"),je.textContent=ds,ui=n(),Ie=g("ul"),Ie.innerHTML=Ms,gi=n(),a(xe.$$.fragment),fi=n(),ke=g("ul"),ke.innerHTML=Ts,$i=n(),a(Re.$$.fragment),ci=n(),a(He.$$.fragment),di=n(),Le=g("p"),Le.textContent=ws,Mi=n(),a(Be.$$.fragment),Ti=n(),a(Se.$$.fragment),wi=n(),a(Ge.$$.fragment),hi=n(),a(We.$$.fragment),yi=n(),a(Pe.$$.fragment),Ui=n(),a(Ve.$$.fragment),Ci=n(),a(_e.$$.fragment),vi=n(),a(ze.$$.fragment),Ji=n(),Ze=g("p"),Ze.textContent=hs,bi=n(),Fe=g("ol"),Fe.innerHTML=ys,ji=n(),a(Xe.$$.fragment),Ii=n(),Ye=g("p"),Ye.textContent=Us,xi=n(),Ne=g("ul"),Ne.innerHTML=Cs,ki=n(),a(Qe.$$.fragment),Ri=n(),Ae=g("ul"),Ae.innerHTML=vs,Hi=n(),a(Ee.$$.fragment),Li=n(),a(qe.$$.fragment),Bi=n(),Oe=g("p"),Oe.textContent=Js,Si=n(),a(De.$$.fragment),Gi=n(),a(Ke.$$.fragment),Wi=n(),a(et.$$.fragment),Pi=n(),a(tt.$$.fragment),Vi=n(),a(lt.$$.fragment),_i=n(),a(it.$$.fragment),zi=n(),a(nt.$$.fragment),Zi=n(),a(st.$$.fragment),Fi=n(),at=g("p"),at.textContent=bs,Xi=n(),ot=g("ol"),ot.innerHTML=js,Yi=n(),a(mt.$$.fragment),Ni=n(),rt=g("p"),rt.textContent=Is,Qi=n(),pt=g("ul"),pt.innerHTML=xs,Ai=n(),a(ut.$$.fragment),Ei=n(),gt=g("ul"),gt.innerHTML=ks,qi=n(),a(ft.$$.fragment),Oi=n(),$t=g("p"),$t.textContent=Rs,Di=n(),ct=g("ol"),ct.innerHTML=Hs,Ki=n(),a(dt.$$.fragment),en=n(),a(Mt.$$.fragment),tn=n(),Tt=g("p"),Tt.textContent=Ls,ln=n(),wt=g("ul"),wt.innerHTML=Bs,nn=n(),a(ht.$$.fragment),sn=n(),yt=g("p"),yt.textContent=Ss,an=n(),Ut=g("ul"),Ut.innerHTML=Gs,on=n(),a(Ct.$$.fragment),mn=n(),a(vt.$$.fragment),rn=n(),a(Jt.$$.fragment),pn=n(),a(bt.$$.fragment),un=n(),jt=g("ol"),jt.innerHTML=Ws,gn=n(),a(It.$$.fragment),fn=n(),xt=g("p"),xt.textContent=Ps,$n=n(),kt=g("ul"),kt.innerHTML=Vs,cn=n(),a(Rt.$$.fragment),dn=n(),a(Ht.$$.fragment),Mn=n(),Lt=g("ul"),Lt.innerHTML=_s,Tn=n(),a(Bt.$$.fragment),wn=n(),St=g("ul"),St.innerHTML=zs,hn=n(),a(Gt.$$.fragment),yn=n(),Wt=g("ul"),Wt.innerHTML=Zs,Un=n(),a(Pt.$$.fragment),Cn=n(),Vt=g("ul"),Vt.innerHTML=Fs,vn=n(),a(_t.$$.fragment),Jn=n(),a(zt.$$.fragment),bn=n(),Zt=g("ol"),Zt.innerHTML=Xs,jn=n(),a(Ft.$$.fragment),In=n(),a(Xt.$$.fragment),xn=n(),Yt=g("ol"),Yt.innerHTML=Ys,kn=n(),a(Nt.$$.fragment),Rn=n(),Qt=g("ul"),Qt.innerHTML=Ns,Hn=n(),a(At.$$.fragment),Ln=n(),Et=g("p"),Et.textContent=Qs,Bn=n(),qt=g("p"),qt.textContent=As,Sn=n(),a(Ot.$$.fragment),Gn=n(),Kt=g("p"),this.h()},l(e){const t=la("svelte-u9bgzb",document.head);M=f(t,"META",{name:!0,content:!0}),t.forEach(l),el=s(e),Dt=f(e,"P",{}),Es(Dt).forEach(l),tl=s(e),o(T.$$.fragment,e),ll=s(e),o(w.$$.fragment,e),il=s(e),h=f(e,"P",{"data-svelte-h":!0}),c(h)!=="svelte-1l32ei2"&&(h.textContent=Vn),nl=s(e),o(y.$$.fragment,e),sl=s(e),U=f(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1jjuy0q"&&(U.textContent=_n),al=s(e),C=f(e,"OL",{"data-svelte-h":!0}),c(C)!=="svelte-19bsi0"&&(C.innerHTML=zn),ol=s(e),o(v.$$.fragment,e),ml=s(e),o(J.$$.fragment,e),rl=s(e),b=f(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-va0l8h"&&(b.textContent=Zn),pl=s(e),o(j.$$.fragment,e),ul=s(e),o(I.$$.fragment,e),gl=s(e),o(x.$$.fragment,e),fl=s(e),k=f(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-lm6krz"&&(k.textContent=Fn),$l=s(e),o(R.$$.fragment,e),cl=s(e),H=f(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-e1cfq6"&&(H.innerHTML=Xn),dl=s(e),L=f(e,"UL",{"data-svelte-h":!0}),c(L)!=="svelte-1lsqc8d"&&(L.innerHTML=Yn),Ml=s(e),B=f(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-oi6kgl"&&(B.textContent=Nn),Tl=s(e),o(S.$$.fragment,e),wl=s(e),G=f(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1j0e0ua"&&(G.innerHTML=Qn),hl=s(e),W=f(e,"UL",{"data-svelte-h":!0}),c(W)!=="svelte-8d3afm"&&(W.innerHTML=An),yl=s(e),P=f(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-97mybz"&&(P.textContent=En),Ul=s(e),o(V.$$.fragment,e),Cl=s(e),_=f(e,"OL",{"data-svelte-h":!0}),c(_)!=="svelte-13q6n19"&&(_.innerHTML=qn),vl=s(e),o(z.$$.fragment,e),Jl=s(e),Z=f(e,"UL",{"data-svelte-h":!0}),c(Z)!=="svelte-1052dg8"&&(Z.innerHTML=On),bl=s(e),o(F.$$.fragment,e),jl=s(e),o(X.$$.fragment,e),Il=s(e),Y=f(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-niccp0"&&(Y.textContent=Dn),xl=s(e),o(N.$$.fragment,e),kl=s(e),o(Q.$$.fragment,e),Rl=s(e),A=f(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1tif8q"&&(A.textContent=Kn),Hl=s(e),o(E.$$.fragment,e),Ll=s(e),o(q.$$.fragment,e),Bl=s(e),O=f(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-124brfs"&&(O.innerHTML=es),Sl=s(e),D=f(e,"UL",{"data-svelte-h":!0}),c(D)!=="svelte-pvsrvr"&&(D.innerHTML=ts),Gl=s(e),K=f(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-kb32f0"&&(K.textContent=ls),Wl=s(e),o(ee.$$.fragment,e),Pl=s(e),te=f(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-pgbvzi"&&(te.innerHTML=is),Vl=s(e),le=f(e,"UL",{"data-svelte-h":!0}),c(le)!=="svelte-171y8c3"&&(le.innerHTML=ns),_l=s(e),ie=f(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-10g3cdo"&&(ie.textContent=ss),zl=s(e),o(ne.$$.fragment,e),Zl=s(e),se=f(e,"OL",{"data-svelte-h":!0}),c(se)!=="svelte-1ckdbfg"&&(se.innerHTML=as),Fl=s(e),o(ae.$$.fragment,e),Xl=s(e),oe=f(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-ldxl2l"&&(oe.textContent=os),Yl=s(e),me=f(e,"UL",{"data-svelte-h":!0}),c(me)!=="svelte-2utry8"&&(me.innerHTML=ms),Nl=s(e),o(re.$$.fragment,e),Ql=s(e),pe=f(e,"UL",{"data-svelte-h":!0}),c(pe)!=="svelte-1rjsqok"&&(pe.innerHTML=rs),Al=s(e),o(ue.$$.fragment,e),El=s(e),o(ge.$$.fragment,e),ql=s(e),fe=f(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-gsusc9"&&(fe.textContent=ps),Ol=s(e),o($e.$$.fragment,e),Dl=s(e),o(ce.$$.fragment,e),Kl=s(e),de=f(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-4a010u"&&(de.textContent=us),ei=s(e),o(Me.$$.fragment,e),ti=s(e),o(Te.$$.fragment,e),li=s(e),we=f(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-rtzo9g"&&(we.textContent=gs),ii=s(e),he=f(e,"UL",{"data-svelte-h":!0}),c(he)!=="svelte-prhoa1"&&(he.innerHTML=fs),ni=s(e),o(ye.$$.fragment,e),si=s(e),Ue=f(e,"OL",{"data-svelte-h":!0}),c(Ue)!=="svelte-xpk9nr"&&(Ue.innerHTML=$s),ai=s(e),o(Ce.$$.fragment,e),oi=s(e),ve=f(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-1y6ssvb"&&(ve.textContent=cs),mi=s(e),o(Je.$$.fragment,e),ri=s(e),o(be.$$.fragment,e),pi=s(e),je=f(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-13bq9d2"&&(je.textContent=ds),ui=s(e),Ie=f(e,"UL",{"data-svelte-h":!0}),c(Ie)!=="svelte-17sk07z"&&(Ie.innerHTML=Ms),gi=s(e),o(xe.$$.fragment,e),fi=s(e),ke=f(e,"UL",{"data-svelte-h":!0}),c(ke)!=="svelte-12vp7eg"&&(ke.innerHTML=Ts),$i=s(e),o(Re.$$.fragment,e),ci=s(e),o(He.$$.fragment,e),di=s(e),Le=f(e,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-alxjnx"&&(Le.textContent=ws),Mi=s(e),o(Be.$$.fragment,e),Ti=s(e),o(Se.$$.fragment,e),wi=s(e),o(Ge.$$.fragment,e),hi=s(e),o(We.$$.fragment,e),yi=s(e),o(Pe.$$.fragment,e),Ui=s(e),o(Ve.$$.fragment,e),Ci=s(e),o(_e.$$.fragment,e),vi=s(e),o(ze.$$.fragment,e),Ji=s(e),Ze=f(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-1oyqn47"&&(Ze.textContent=hs),bi=s(e),Fe=f(e,"OL",{"data-svelte-h":!0}),c(Fe)!=="svelte-1078o55"&&(Fe.innerHTML=ys),ji=s(e),o(Xe.$$.fragment,e),Ii=s(e),Ye=f(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-7anju1"&&(Ye.textContent=Us),xi=s(e),Ne=f(e,"UL",{"data-svelte-h":!0}),c(Ne)!=="svelte-4b8mvc"&&(Ne.innerHTML=Cs),ki=s(e),o(Qe.$$.fragment,e),Ri=s(e),Ae=f(e,"UL",{"data-svelte-h":!0}),c(Ae)!=="svelte-x4qlib"&&(Ae.innerHTML=vs),Hi=s(e),o(Ee.$$.fragment,e),Li=s(e),o(qe.$$.fragment,e),Bi=s(e),Oe=f(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-n6pugt"&&(Oe.textContent=Js),Si=s(e),o(De.$$.fragment,e),Gi=s(e),o(Ke.$$.fragment,e),Wi=s(e),o(et.$$.fragment,e),Pi=s(e),o(tt.$$.fragment,e),Vi=s(e),o(lt.$$.fragment,e),_i=s(e),o(it.$$.fragment,e),zi=s(e),o(nt.$$.fragment,e),Zi=s(e),o(st.$$.fragment,e),Fi=s(e),at=f(e,"P",{"data-svelte-h":!0}),c(at)!=="svelte-js0vja"&&(at.textContent=bs),Xi=s(e),ot=f(e,"OL",{"data-svelte-h":!0}),c(ot)!=="svelte-zk4kaw"&&(ot.innerHTML=js),Yi=s(e),o(mt.$$.fragment,e),Ni=s(e),rt=f(e,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-r2xrqi"&&(rt.textContent=Is),Qi=s(e),pt=f(e,"UL",{"data-svelte-h":!0}),c(pt)!=="svelte-rp6x72"&&(pt.innerHTML=xs),Ai=s(e),o(ut.$$.fragment,e),Ei=s(e),gt=f(e,"UL",{"data-svelte-h":!0}),c(gt)!=="svelte-xlrbue"&&(gt.innerHTML=ks),qi=s(e),o(ft.$$.fragment,e),Oi=s(e),$t=f(e,"P",{"data-svelte-h":!0}),c($t)!=="svelte-1662a64"&&($t.textContent=Rs),Di=s(e),ct=f(e,"OL",{"data-svelte-h":!0}),c(ct)!=="svelte-1patukr"&&(ct.innerHTML=Hs),Ki=s(e),o(dt.$$.fragment,e),en=s(e),o(Mt.$$.fragment,e),tn=s(e),Tt=f(e,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-bixid"&&(Tt.textContent=Ls),ln=s(e),wt=f(e,"UL",{"data-svelte-h":!0}),c(wt)!=="svelte-1cw1jmn"&&(wt.innerHTML=Bs),nn=s(e),o(ht.$$.fragment,e),sn=s(e),yt=f(e,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-9ggjc3"&&(yt.textContent=Ss),an=s(e),Ut=f(e,"UL",{"data-svelte-h":!0}),c(Ut)!=="svelte-101jyhx"&&(Ut.innerHTML=Gs),on=s(e),o(Ct.$$.fragment,e),mn=s(e),o(vt.$$.fragment,e),rn=s(e),o(Jt.$$.fragment,e),pn=s(e),o(bt.$$.fragment,e),un=s(e),jt=f(e,"OL",{"data-svelte-h":!0}),c(jt)!=="svelte-bdff0e"&&(jt.innerHTML=Ws),gn=s(e),o(It.$$.fragment,e),fn=s(e),xt=f(e,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-36jvac"&&(xt.textContent=Ps),$n=s(e),kt=f(e,"UL",{"data-svelte-h":!0}),c(kt)!=="svelte-1pjvvdg"&&(kt.innerHTML=Vs),cn=s(e),o(Rt.$$.fragment,e),dn=s(e),o(Ht.$$.fragment,e),Mn=s(e),Lt=f(e,"UL",{"data-svelte-h":!0}),c(Lt)!=="svelte-ogxpxw"&&(Lt.innerHTML=_s),Tn=s(e),o(Bt.$$.fragment,e),wn=s(e),St=f(e,"UL",{"data-svelte-h":!0}),c(St)!=="svelte-w5i9n6"&&(St.innerHTML=zs),hn=s(e),o(Gt.$$.fragment,e),yn=s(e),Wt=f(e,"UL",{"data-svelte-h":!0}),c(Wt)!=="svelte-1p2mja4"&&(Wt.innerHTML=Zs),Un=s(e),o(Pt.$$.fragment,e),Cn=s(e),Vt=f(e,"UL",{"data-svelte-h":!0}),c(Vt)!=="svelte-1vciavt"&&(Vt.innerHTML=Fs),vn=s(e),o(_t.$$.fragment,e),Jn=s(e),o(zt.$$.fragment,e),bn=s(e),Zt=f(e,"OL",{"data-svelte-h":!0}),c(Zt)!=="svelte-1424vmb"&&(Zt.innerHTML=Xs),jn=s(e),o(Ft.$$.fragment,e),In=s(e),o(Xt.$$.fragment,e),xn=s(e),Yt=f(e,"OL",{"data-svelte-h":!0}),c(Yt)!=="svelte-1iyasv"&&(Yt.innerHTML=Ys),kn=s(e),o(Nt.$$.fragment,e),Rn=s(e),Qt=f(e,"UL",{"data-svelte-h":!0}),c(Qt)!=="svelte-g2917a"&&(Qt.innerHTML=Ns),Hn=s(e),o(At.$$.fragment,e),Ln=s(e),Et=f(e,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-had7z2"&&(Et.textContent=Qs),Bn=s(e),qt=f(e,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-9s9cgy"&&(qt.textContent=As),Sn=s(e),o(Ot.$$.fragment,e),Gn=s(e),Kt=f(e,"P",{}),Es(Kt).forEach(l),this.h()},h(){qs(M,"name","hf:doc:metadata"),qs(M,"content",aa)},m(e,t){ia(document.head,M),i(e,el,t),i(e,Dt,t),i(e,tl,t),m(T,e,t),i(e,ll,t),m(w,e,t),i(e,il,t),i(e,h,t),i(e,nl,t),m(y,e,t),i(e,sl,t),i(e,U,t),i(e,al,t),i(e,C,t),i(e,ol,t),m(v,e,t),i(e,ml,t),m(J,e,t),i(e,rl,t),i(e,b,t),i(e,pl,t),m(j,e,t),i(e,ul,t),m(I,e,t),i(e,gl,t),m(x,e,t),i(e,fl,t),i(e,k,t),i(e,$l,t),m(R,e,t),i(e,cl,t),i(e,H,t),i(e,dl,t),i(e,L,t),i(e,Ml,t),i(e,B,t),i(e,Tl,t),m(S,e,t),i(e,wl,t),i(e,G,t),i(e,hl,t),i(e,W,t),i(e,yl,t),i(e,P,t),i(e,Ul,t),m(V,e,t),i(e,Cl,t),i(e,_,t),i(e,vl,t),m(z,e,t),i(e,Jl,t),i(e,Z,t),i(e,bl,t),m(F,e,t),i(e,jl,t),m(X,e,t),i(e,Il,t),i(e,Y,t),i(e,xl,t),m(N,e,t),i(e,kl,t),m(Q,e,t),i(e,Rl,t),i(e,A,t),i(e,Hl,t),m(E,e,t),i(e,Ll,t),m(q,e,t),i(e,Bl,t),i(e,O,t),i(e,Sl,t),i(e,D,t),i(e,Gl,t),i(e,K,t),i(e,Wl,t),m(ee,e,t),i(e,Pl,t),i(e,te,t),i(e,Vl,t),i(e,le,t),i(e,_l,t),i(e,ie,t),i(e,zl,t),m(ne,e,t),i(e,Zl,t),i(e,se,t),i(e,Fl,t),m(ae,e,t),i(e,Xl,t),i(e,oe,t),i(e,Yl,t),i(e,me,t),i(e,Nl,t),m(re,e,t),i(e,Ql,t),i(e,pe,t),i(e,Al,t),m(ue,e,t),i(e,El,t),m(ge,e,t),i(e,ql,t),i(e,fe,t),i(e,Ol,t),m($e,e,t),i(e,Dl,t),m(ce,e,t),i(e,Kl,t),i(e,de,t),i(e,ei,t),m(Me,e,t),i(e,ti,t),m(Te,e,t),i(e,li,t),i(e,we,t),i(e,ii,t),i(e,he,t),i(e,ni,t),m(ye,e,t),i(e,si,t),i(e,Ue,t),i(e,ai,t),m(Ce,e,t),i(e,oi,t),i(e,ve,t),i(e,mi,t),m(Je,e,t),i(e,ri,t),m(be,e,t),i(e,pi,t),i(e,je,t),i(e,ui,t),i(e,Ie,t),i(e,gi,t),m(xe,e,t),i(e,fi,t),i(e,ke,t),i(e,$i,t),m(Re,e,t),i(e,ci,t),m(He,e,t),i(e,di,t),i(e,Le,t),i(e,Mi,t),m(Be,e,t),i(e,Ti,t),m(Se,e,t),i(e,wi,t),m(Ge,e,t),i(e,hi,t),m(We,e,t),i(e,yi,t),m(Pe,e,t),i(e,Ui,t),m(Ve,e,t),i(e,Ci,t),m(_e,e,t),i(e,vi,t),m(ze,e,t),i(e,Ji,t),i(e,Ze,t),i(e,bi,t),i(e,Fe,t),i(e,ji,t),m(Xe,e,t),i(e,Ii,t),i(e,Ye,t),i(e,xi,t),i(e,Ne,t),i(e,ki,t),m(Qe,e,t),i(e,Ri,t),i(e,Ae,t),i(e,Hi,t),m(Ee,e,t),i(e,Li,t),m(qe,e,t),i(e,Bi,t),i(e,Oe,t),i(e,Si,t),m(De,e,t),i(e,Gi,t),m(Ke,e,t),i(e,Wi,t),m(et,e,t),i(e,Pi,t),m(tt,e,t),i(e,Vi,t),m(lt,e,t),i(e,_i,t),m(it,e,t),i(e,zi,t),m(nt,e,t),i(e,Zi,t),m(st,e,t),i(e,Fi,t),i(e,at,t),i(e,Xi,t),i(e,ot,t),i(e,Yi,t),m(mt,e,t),i(e,Ni,t),i(e,rt,t),i(e,Qi,t),i(e,pt,t),i(e,Ai,t),m(ut,e,t),i(e,Ei,t),i(e,gt,t),i(e,qi,t),m(ft,e,t),i(e,Oi,t),i(e,$t,t),i(e,Di,t),i(e,ct,t),i(e,Ki,t),m(dt,e,t),i(e,en,t),m(Mt,e,t),i(e,tn,t),i(e,Tt,t),i(e,ln,t),i(e,wt,t),i(e,nn,t),m(ht,e,t),i(e,sn,t),i(e,yt,t),i(e,an,t),i(e,Ut,t),i(e,on,t),m(Ct,e,t),i(e,mn,t),m(vt,e,t),i(e,rn,t),m(Jt,e,t),i(e,pn,t),m(bt,e,t),i(e,un,t),i(e,jt,t),i(e,gn,t),m(It,e,t),i(e,fn,t),i(e,xt,t),i(e,$n,t),i(e,kt,t),i(e,cn,t),m(Rt,e,t),i(e,dn,t),m(Ht,e,t),i(e,Mn,t),i(e,Lt,t),i(e,Tn,t),m(Bt,e,t),i(e,wn,t),i(e,St,t),i(e,hn,t),m(Gt,e,t),i(e,yn,t),i(e,Wt,t),i(e,Un,t),m(Pt,e,t),i(e,Cn,t),i(e,Vt,t),i(e,vn,t),m(_t,e,t),i(e,Jn,t),m(zt,e,t),i(e,bn,t),i(e,Zt,t),i(e,jn,t),m(Ft,e,t),i(e,In,t),m(Xt,e,t),i(e,xn,t),i(e,Yt,t),i(e,kn,t),m(Nt,e,t),i(e,Rn,t),i(e,Qt,t),i(e,Hn,t),m(At,e,t),i(e,Ln,t),i(e,Et,t),i(e,Bn,t),i(e,qt,t),i(e,Sn,t),m(Ot,e,t),i(e,Gn,t),i(e,Kt,t),Wn=!0},p:Ds,i(e){Wn||(r(T.$$.fragment,e),r(w.$$.fragment,e),r(y.$$.fragment,e),r(v.$$.fragment,e),r(J.$$.fragment,e),r(j.$$.fragment,e),r(I.$$.fragment,e),r(x.$$.fragment,e),r(R.$$.fragment,e),r(S.$$.fragment,e),r(V.$$.fragment,e),r(z.$$.fragment,e),r(F.$$.fragment,e),r(X.$$.fragment,e),r(N.$$.fragment,e),r(Q.$$.fragment,e),r(E.$$.fragment,e),r(q.$$.fragment,e),r(ee.$$.fragment,e),r(ne.$$.fragment,e),r(ae.$$.fragment,e),r(re.$$.fragment,e),r(ue.$$.fragment,e),r(ge.$$.fragment,e),r($e.$$.fragment,e),r(ce.$$.fragment,e),r(Me.$$.fragment,e),r(Te.$$.fragment,e),r(ye.$$.fragment,e),r(Ce.$$.fragment,e),r(Je.$$.fragment,e),r(be.$$.fragment,e),r(xe.$$.fragment,e),r(Re.$$.fragment,e),r(He.$$.fragment,e),r(Be.$$.fragment,e),r(Se.$$.fragment,e),r(Ge.$$.fragment,e),r(We.$$.fragment,e),r(Pe.$$.fragment,e),r(Ve.$$.fragment,e),r(_e.$$.fragment,e),r(ze.$$.fragment,e),r(Xe.$$.fragment,e),r(Qe.$$.fragment,e),r(Ee.$$.fragment,e),r(qe.$$.fragment,e),r(De.$$.fragment,e),r(Ke.$$.fragment,e),r(et.$$.fragment,e),r(tt.$$.fragment,e),r(lt.$$.fragment,e),r(it.$$.fragment,e),r(nt.$$.fragment,e),r(st.$$.fragment,e),r(mt.$$.fragment,e),r(ut.$$.fragment,e),r(ft.$$.fragment,e),r(dt.$$.fragment,e),r(Mt.$$.fragment,e),r(ht.$$.fragment,e),r(Ct.$$.fragment,e),r(vt.$$.fragment,e),r(Jt.$$.fragment,e),r(bt.$$.fragment,e),r(It.$$.fragment,e),r(Rt.$$.fragment,e),r(Ht.$$.fragment,e),r(Bt.$$.fragment,e),r(Gt.$$.fragment,e),r(Pt.$$.fragment,e),r(_t.$$.fragment,e),r(zt.$$.fragment,e),r(Ft.$$.fragment,e),r(Xt.$$.fragment,e),r(Nt.$$.fragment,e),r(At.$$.fragment,e),r(Ot.$$.fragment,e),Wn=!0)},o(e){p(T.$$.fragment,e),p(w.$$.fragment,e),p(y.$$.fragment,e),p(v.$$.fragment,e),p(J.$$.fragment,e),p(j.$$.fragment,e),p(I.$$.fragment,e),p(x.$$.fragment,e),p(R.$$.fragment,e),p(S.$$.fragment,e),p(V.$$.fragment,e),p(z.$$.fragment,e),p(F.$$.fragment,e),p(X.$$.fragment,e),p(N.$$.fragment,e),p(Q.$$.fragment,e),p(E.$$.fragment,e),p(q.$$.fragment,e),p(ee.$$.fragment,e),p(ne.$$.fragment,e),p(ae.$$.fragment,e),p(re.$$.fragment,e),p(ue.$$.fragment,e),p(ge.$$.fragment,e),p($e.$$.fragment,e),p(ce.$$.fragment,e),p(Me.$$.fragment,e),p(Te.$$.fragment,e),p(ye.$$.fragment,e),p(Ce.$$.fragment,e),p(Je.$$.fragment,e),p(be.$$.fragment,e),p(xe.$$.fragment,e),p(Re.$$.fragment,e),p(He.$$.fragment,e),p(Be.$$.fragment,e),p(Se.$$.fragment,e),p(Ge.$$.fragment,e),p(We.$$.fragment,e),p(Pe.$$.fragment,e),p(Ve.$$.fragment,e),p(_e.$$.fragment,e),p(ze.$$.fragment,e),p(Xe.$$.fragment,e),p(Qe.$$.fragment,e),p(Ee.$$.fragment,e),p(qe.$$.fragment,e),p(De.$$.fragment,e),p(Ke.$$.fragment,e),p(et.$$.fragment,e),p(tt.$$.fragment,e),p(lt.$$.fragment,e),p(it.$$.fragment,e),p(nt.$$.fragment,e),p(st.$$.fragment,e),p(mt.$$.fragment,e),p(ut.$$.fragment,e),p(ft.$$.fragment,e),p(dt.$$.fragment,e),p(Mt.$$.fragment,e),p(ht.$$.fragment,e),p(Ct.$$.fragment,e),p(vt.$$.fragment,e),p(Jt.$$.fragment,e),p(bt.$$.fragment,e),p(It.$$.fragment,e),p(Rt.$$.fragment,e),p(Ht.$$.fragment,e),p(Bt.$$.fragment,e),p(Gt.$$.fragment,e),p(Pt.$$.fragment,e),p(_t.$$.fragment,e),p(zt.$$.fragment,e),p(Ft.$$.fragment,e),p(Xt.$$.fragment,e),p(Nt.$$.fragment,e),p(At.$$.fragment,e),p(Ot.$$.fragment,e),Wn=!1},d(e){e&&(l(el),l(Dt),l(tl),l(ll),l(il),l(h),l(nl),l(sl),l(U),l(al),l(C),l(ol),l(ml),l(rl),l(b),l(pl),l(ul),l(gl),l(fl),l(k),l($l),l(cl),l(H),l(dl),l(L),l(Ml),l(B),l(Tl),l(wl),l(G),l(hl),l(W),l(yl),l(P),l(Ul),l(Cl),l(_),l(vl),l(Jl),l(Z),l(bl),l(jl),l(Il),l(Y),l(xl),l(kl),l(Rl),l(A),l(Hl),l(Ll),l(Bl),l(O),l(Sl),l(D),l(Gl),l(K),l(Wl),l(Pl),l(te),l(Vl),l(le),l(_l),l(ie),l(zl),l(Zl),l(se),l(Fl),l(Xl),l(oe),l(Yl),l(me),l(Nl),l(Ql),l(pe),l(Al),l(El),l(ql),l(fe),l(Ol),l(Dl),l(Kl),l(de),l(ei),l(ti),l(li),l(we),l(ii),l(he),l(ni),l(si),l(Ue),l(ai),l(oi),l(ve),l(mi),l(ri),l(pi),l(je),l(ui),l(Ie),l(gi),l(fi),l(ke),l($i),l(ci),l(di),l(Le),l(Mi),l(Ti),l(wi),l(hi),l(yi),l(Ui),l(Ci),l(vi),l(Ji),l(Ze),l(bi),l(Fe),l(ji),l(Ii),l(Ye),l(xi),l(Ne),l(ki),l(Ri),l(Ae),l(Hi),l(Li),l(Bi),l(Oe),l(Si),l(Gi),l(Wi),l(Pi),l(Vi),l(_i),l(zi),l(Zi),l(Fi),l(at),l(Xi),l(ot),l(Yi),l(Ni),l(rt),l(Qi),l(pt),l(Ai),l(Ei),l(gt),l(qi),l(Oi),l($t),l(Di),l(ct),l(Ki),l(en),l(tn),l(Tt),l(ln),l(wt),l(nn),l(sn),l(yt),l(an),l(Ut),l(on),l(mn),l(rn),l(pn),l(un),l(jt),l(gn),l(fn),l(xt),l($n),l(kt),l(cn),l(dn),l(Mn),l(Lt),l(Tn),l(wn),l(St),l(hn),l(yn),l(Wt),l(Un),l(Cn),l(Vt),l(vn),l(Jn),l(bn),l(Zt),l(jn),l(In),l(xn),l(Yt),l(kn),l(Rn),l(Qt),l(Hn),l(Ln),l(Et),l(Bn),l(qt),l(Sn),l(Gn),l(Kt)),l(M),u(T,e),u(w,e),u(y,e),u(v,e),u(J,e),u(j,e),u(I,e),u(x,e),u(R,e),u(S,e),u(V,e),u(z,e),u(F,e),u(X,e),u(N,e),u(Q,e),u(E,e),u(q,e),u(ee,e),u(ne,e),u(ae,e),u(re,e),u(ue,e),u(ge,e),u($e,e),u(ce,e),u(Me,e),u(Te,e),u(ye,e),u(Ce,e),u(Je,e),u(be,e),u(xe,e),u(Re,e),u(He,e),u(Be,e),u(Se,e),u(Ge,e),u(We,e),u(Pe,e),u(Ve,e),u(_e,e),u(ze,e),u(Xe,e),u(Qe,e),u(Ee,e),u(qe,e),u(De,e),u(Ke,e),u(et,e),u(tt,e),u(lt,e),u(it,e),u(nt,e),u(st,e),u(mt,e),u(ut,e),u(ft,e),u(dt,e),u(Mt,e),u(ht,e),u(Ct,e),u(vt,e),u(Jt,e),u(bt,e),u(It,e),u(Rt,e),u(Ht,e),u(Bt,e),u(Gt,e),u(Pt,e),u(_t,e),u(zt,e),u(Ft,e),u(Xt,e),u(Nt,e),u(At,e),u(Ot,e)}}}const aa='{"title":"Unit 3 Solution Walkthrough: Building a Pull Request Agent with MCP","local":"unit-3-solution-walkthrough-building-a-pull-request-agent-with-mcp","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Architecture Overview","local":"architecture-overview","sections":[],"depth":2},{"title":"Module 1: Build MCP Server","local":"module-1-build-mcp-server","sections":[{"title":"What We’re Building","local":"what-were-building","sections":[],"depth":3},{"title":"Key Components","local":"key-components","sections":[{"title":"1. Server Initialization ( server.py )","local":"1-server-initialization--serverpy-","sections":[],"depth":4},{"title":"2. File Analysis Tool","local":"2-file-analysis-tool","sections":[],"depth":4},{"title":"3. Template Management","local":"3-template-management","sections":[],"depth":4}],"depth":3},{"title":"How Claude Uses These Tools","local":"how-claude-uses-these-tools","sections":[],"depth":3},{"title":"Learning Outcomes","local":"learning-outcomes","sections":[],"depth":3}],"depth":2},{"title":"Module 2: Smart File Analysis","local":"module-2-smart-file-analysis","sections":[{"title":"What We’re Building","local":"what-were-building","sections":[],"depth":3},{"title":"Key Components","local":"key-components","sections":[{"title":"1. Resource Registration","local":"1-resource-registration","sections":[],"depth":4},{"title":"2. Project Context Resources","local":"2-project-context-resources","sections":[],"depth":4},{"title":"3. Git History Analysis","local":"3-git-history-analysis","sections":[],"depth":4}],"depth":3},{"title":"How Claude Uses Resources","local":"how-claude-uses-resources","sections":[],"depth":3},{"title":"Enhanced Decision Making","local":"enhanced-decision-making","sections":[],"depth":3},{"title":"Learning Outcomes","local":"learning-outcomes","sections":[],"depth":3}],"depth":2},{"title":"Module 3: GitHub Actions Integration","local":"module-3-github-actions-integration","sections":[{"title":"What We’re Building","local":"what-were-building","sections":[],"depth":3},{"title":"Key Components","local":"key-components","sections":[{"title":"1. Webhook Server","local":"1-webhook-server","sections":[],"depth":4},{"title":"2. Prompt Templates","local":"2-prompt-templates","sections":[],"depth":4},{"title":"3. Event Processing Pipeline","local":"3-event-processing-pipeline","sections":[],"depth":4}],"depth":3},{"title":"How Claude Uses Prompts","local":"how-claude-uses-prompts","sections":[],"depth":3},{"title":"Standardized Workflows","local":"standardized-workflows","sections":[],"depth":3},{"title":"Learning Outcomes","local":"learning-outcomes","sections":[],"depth":3}],"depth":2},{"title":"Module 4: Hugging Face Hub Integration","local":"module-4-hugging-face-hub-integration","sections":[{"title":"What We’re Building","local":"what-were-building","sections":[],"depth":3},{"title":"Key Components","local":"key-components","sections":[{"title":"1. Hub-Specific Tools","local":"1-hub-specific-tools","sections":[],"depth":4},{"title":"2. Hub Resources","local":"2-hub-resources","sections":[],"depth":4},{"title":"3. LLM-Specific Prompts","local":"3-llm-specific-prompts","sections":[],"depth":4}],"depth":3},{"title":"Hub-Specific Workflows","local":"hub-specific-workflows","sections":[],"depth":3},{"title":"Dataset PR Handling","local":"dataset-pr-handling","sections":[],"depth":3},{"title":"Learning Outcomes","local":"learning-outcomes","sections":[],"depth":3}],"depth":2},{"title":"Module 5: Slack Notification","local":"module-5-slack-notification","sections":[{"title":"What We’re Building","local":"what-were-building","sections":[],"depth":3},{"title":"Key Components","local":"key-components","sections":[{"title":"1. Communication Tools","local":"1-communication-tools","sections":[],"depth":4},{"title":"2. Team Resources","local":"2-team-resources","sections":[],"depth":4},{"title":"3. Notification Prompts","local":"3-notification-prompts","sections":[],"depth":4}],"depth":3},{"title":"Integration Example","local":"integration-example","sections":[],"depth":3},{"title":"Intelligent Routing","local":"intelligent-routing","sections":[],"depth":3},{"title":"Learning Outcomes","local":"learning-outcomes","sections":[],"depth":3}],"depth":2},{"title":"Complete Workflow Example","local":"complete-workflow-example","sections":[],"depth":2},{"title":"Testing Strategy","local":"testing-strategy","sections":[{"title":"Unit Tests","local":"unit-tests","sections":[],"depth":3},{"title":"Integration Tests","local":"integration-tests","sections":[],"depth":3},{"title":"Test Structure","local":"test-structure","sections":[],"depth":3}],"depth":2},{"title":"Running the Solution","local":"running-the-solution","sections":[{"title":"Local Development Setup","local":"local-development-setup","sections":[],"depth":3},{"title":"Configuration","local":"configuration","sections":[],"depth":3}],"depth":2},{"title":"Common Patterns and Best Practices","local":"common-patterns-and-best-practices","sections":[{"title":"Tool Design","local":"tool-design","sections":[],"depth":3},{"title":"Resource Organization","local":"resource-organization","sections":[],"depth":3},{"title":"Prompt Engineering","local":"prompt-engineering","sections":[],"depth":3},{"title":"Integration Patterns","local":"integration-patterns","sections":[],"depth":3}],"depth":2},{"title":"Troubleshooting Guide","local":"troubleshooting-guide","sections":[{"title":"Common Issues","local":"common-issues","sections":[],"depth":3}],"depth":2},{"title":"Next Steps and Extensions","local":"next-steps-and-extensions","sections":[{"title":"Potential Enhancements","local":"potential-enhancements","sections":[],"depth":3},{"title":"Learning Path","local":"learning-path","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function oa(Pn){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ga extends ea{constructor(M){super(),ta(this,M,oa,sa,Os,{})}}export{ga as component};
