import{s as ys,f as ms,o as hs,n as Ul}from"../chunks/scheduler.f6319a2a.js";import{S as bs,i as ws,g as a,s as o,r as M,A as Us,h as i,f as l,c as n,j as ds,u,x as r,k as bl,y as Ts,a as s,v as c,d as m,t as d,w as y}from"../chunks/index.85aa684c.js";import{T as wl}from"../chunks/Tip.3d397a88.js";import{C as T}from"../chunks/CodeBlock.3400fc53.js";import{D as fs}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as J,E as Js}from"../chunks/getInferenceSnippets.4ff3f544.js";function js(j){let p,U='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=a("p"),p.innerHTML=U},l(h){p=i(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p1d9vw"&&(p.innerHTML=U)},m(h,w){s(h,p,w)},p:Ul,d(h){h&&l(p)}}}function gs(j){let p,U="<strong>Security Warning:</strong> Using MCP servers comes with security risks:",h,w,g="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers</strong> while the remote MCP servers will not be able to execute code on your machine, still proceed with caution.</li>",C,f,W="Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.";return{c(){p=a("p"),p.innerHTML=U,h=o(),w=a("ul"),w.innerHTML=g,C=o(),f=a("p"),f.textContent=W},l(b){p=i(b,"P",{"data-svelte-h":!0}),r(p)!=="svelte-936g9o"&&(p.innerHTML=U),h=n(b),w=i(b,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-17a5h6o"&&(w.innerHTML=g),C=n(b),f=i(b,"P",{"data-svelte-h":!0}),r(f)!=="svelte-57pqg4"&&(f.textContent=W)},m(b,v){s(b,p,v),s(b,h,v),s(b,w,v),s(b,C,v),s(b,f,v)},p:Ul,d(b){b&&(l(p),l(h),l(w),l(C),l(f))}}}function Cs(j){let p,U="<strong>Security Warning:</strong> The same security warnings mentioned for <code>ToolCollection.from_mcp</code> apply when using <code>MCPClient</code> directly.";return{c(){p=a("p"),p.innerHTML=U},l(h){p=i(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1dxey55"&&(p.innerHTML=U)},m(h,w){s(h,p,w)},p:Ul,d(h){h&&l(p)}}}function vs(j){let p,U="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){p=a("p"),p.textContent=U},l(h){p=i(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-h9mzfm"&&(p.textContent=U)},m(h,w){s(h,p,w)},p:Ul,d(h){h&&l(p)}}}function Is(j){let p,U,h,w,g,C,f,W,b,v="Here, we’re going to see advanced tool usage.",Pe,I,Le,_,Tl='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#use-tools-from-an-mcp-server">Use tools from an MCP server</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',De,G,Ke,Q,fl="A tool is mostly a function that an LLM can use in an agentic system.",Oe,k,Jl="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",et,H,jl="So it cannot be only a function. It should be a class.",tt,x,gl="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",lt,V,Cl="Here’s how it looks:",st,R,ot,N,vl='The custom tool subclasses <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',nt,E,Il='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',at,S,Zl="And that’s all it needs to be used in an agent!",it,q,$l='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',rt,A,Bl='In this case, you can build your tool by subclassing <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.Tool">Tool</a> as described above.',pt,X,Mt,Y,Wl='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',ut,z,ct,F,_l="For the push to Hub to work, your tool will need to respect some rules:",mt,P,Gl='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',dt,L,Ql='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',yt,D,kl='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',ht,K,Hl=`Then you can load the tool with <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,bt,O,wt,ee,Ut,te,xl="Here are the different ways to leverage tools served by an MCP server.",Tt,le,ft,se,Vl='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Jt,Z,jt,oe,Rl='The MCP servers tools can be loaded with <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',gt,ne,Nl="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Ct,ae,vt,ie,El="For Streamable HTTP-based MCP servers, simply pass a dict with parameters to <code>mcp.client.streamable_http.streamablehttp_client</code> and add the key <code>transport</code> with the value <code>&quot;streamable-http&quot;</code>:",It,re,Zt,pe,$t,Me,Sl="You can also work with MCP tools by using the <code>MCPClient</code> directly, which gives you more control over the connection and tool management:",Bt,ue,ql="For stdio-based MCP servers:",Wt,ce,_t,me,Al="For Streamable HTTP-based MCP servers:",Gt,de,Qt,ye,Xl="You can also manually manage the connection lifecycle with the try…finally pattern:",kt,he,Ht,be,Yl="You can also connect to multiple MCP servers at once by passing a list of server parameters:",xt,we,Vt,$,Rt,Ue,Nt,Te,zl='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',Et,fe,Fl='You only need to provide the id of the Space on the Hub, its name, and a description that will help your agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',St,Je,Pl='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',qt,je,At,ge,Ll="And voilà, here’s your image! 🏖️",Xt,Ye,Dl,Yt,Ce,Kl="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",zt,ve,Ft,Ie,Pt,ze,Ol,Lt,Ze,es="How cool is this? 🤩",Dt,$e,Kt,Be,ts=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,Ot,We,ls=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,el,_e,tl,Ge,ll,Qe,ss="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",sl,ke,os="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",ol,He,nl,xe,ns="Now we can leverage the new tool:",al,Ve,il,B,rl,Re,pl,Ne,as='You can leverage tool collections by using <a href="/docs/smolagents/pr_1393/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',Ml,Ee,ul,Se,is=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,cl,qe,ml,Ae,rs="To speed up the start, tools are loaded only if called by the agent.",dl,Xe,yl,Fe,hl;return g=new J({props:{title:"Tools",local:"tools",headingTag:"h1"}}),f=new fs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),I=new wl({props:{warning:!1,$$slots:{default:[js]},$$scope:{ctx:j}}}),G=new J({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),R=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),X=new J({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),z=new T({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),O=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),ee=new J({props:{title:"Use tools from an MCP server",local:"use-tools-from-an-mcp-server",headingTag:"h3"}}),le=new J({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),Z=new wl({props:{warning:!0,$$slots:{default:[gs]},$$scope:{ctx:j}}}),ae=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),re=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRm1jcCUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnN0cmVhbWFibGUtaHR0cCUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),pe=new J({props:{title:"Use MCP tools with MCPClient directly",local:"use-mcp-tools-with-mcpclient-directly",headingTag:"h4"}}),ce=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTIwJTIwJTIzJTIwVXNpbmclMjB1dnglMjBlbnN1cmVzJTIwZGVwZW5kZW5jaWVzJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyME1DUENsaWVudChzZXJ2ZXJfcGFyYW1ldGVycyklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMG9uJTIwQ09WSUQtMTklMjB0cmVhdG1lbnQuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,  <span class="hljs-comment"># Using uvx ensures dependencies are available</span>
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find the latest research on COVID-19 treatment.&quot;</span>)`,wrap:!1}}),de=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEF3aXRoJTIwTUNQQ2xpZW50KCU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGbWNwJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3RyZWFtYWJsZS1odHRwJTIyJTdEKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRHRvb2xzJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-keyword">with</span> MCPClient({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),he=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEElMjMlMjBJbml0aWFsaXplJTIwc2VydmVyJTIwcGFyYW1ldGVycyUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKCUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ1dnglMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEElMjMlMjBNYW51YWxseSUyMG1hbmFnZSUyMHRoZSUyMGNvbm5lY3Rpb24lMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50JTIwJTNEJTIwTUNQQ2xpZW50KHNlcnZlcl9wYXJhbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMHRvb2xzJTIwJTNEJTIwbWNwX2NsaWVudC5nZXRfdG9vbHMoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHRvb2xzJTIwd2l0aCUyMHlvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwYXJlJTIwdGhlJTIwcmVjZW50JTIwdGhlcmFwZXV0aWMlMjBhcHByb2FjaGVzJTIwZm9yJTIwQWx6aGVpbWVyJ3MlMjBkaXNlYXNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjByZXN1bHQlMjBhcyUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBZ2VudCUyMHJlc3BvbnNlJTNBJTIwJTdCcmVzdWx0JTdEJTIyKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBlbnN1cmUlMjB0aGUlMjBjb25uZWN0aW9uJTIwaXMlMjBwcm9wZXJseSUyMGNsb3NlZCUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQuZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Initialize server parameters</span>
server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-comment"># Manually manage the connection</span>
<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(server_parameters)
    tools = mcp_client.get_tools()

    <span class="hljs-comment"># Use the tools with your agent</span>
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    result = agent.run(<span class="hljs-string">&quot;What are the recent therapeutic approaches for Alzheimer&#x27;s disease?&quot;</span>)

    <span class="hljs-comment"># Process the result as needed</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Agent response: <span class="hljs-subst">{result}</span>&quot;</span>)
<span class="hljs-keyword">finally</span>:
    <span class="hljs-comment"># Always ensure the connection is properly closed</span>
    mcp_client.disconnect()`,wrap:!1}}),we=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1zMSUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBc2VydmVyX3BhcmFtczIlMjAlM0QlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTVCc2VydmVyX3BhcmFtczElMkMlMjBzZXJ2ZXJfcGFyYW1zMiU1RCklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGFuYWx5emUlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMGFuZCUyMHN1Z2dlc3QlMjByZW1lZGllcyUyMGZvciUyMGhlYWRhY2hlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_params1 = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

server_params2 = {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}

<span class="hljs-keyword">with</span> MCPClient([server_params1, server_params2]) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please analyze the latest research and suggest remedies for headaches.&quot;</span>)`,wrap:!1}}),$=new wl({props:{warning:!0,$$slots:{default:[Cs]},$$scope:{ctx:j}}}),Ue=new J({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),je=new T({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ve=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),Ie=new T({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),$e=new J({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),_e=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),Ge=new J({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),He=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),Ve=new T({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),B=new wl({props:{warning:!1,$$slots:{default:[vs]},$$scope:{ctx:j}}}),Re=new J({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),Ee=new J({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),qe=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),Xe=new Js({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.mdx"}}),{c(){p=a("meta"),U=o(),h=a("p"),w=o(),M(g.$$.fragment),C=o(),M(f.$$.fragment),W=o(),b=a("p"),b.textContent=v,Pe=o(),M(I.$$.fragment),Le=o(),_=a("ul"),_.innerHTML=Tl,De=o(),M(G.$$.fragment),Ke=o(),Q=a("p"),Q.textContent=fl,Oe=o(),k=a("p"),k.textContent=Jl,et=o(),H=a("p"),H.textContent=jl,tt=o(),x=a("p"),x.textContent=gl,lt=o(),V=a("p"),V.textContent=Cl,st=o(),M(R.$$.fragment),ot=o(),N=a("p"),N.innerHTML=vl,nt=o(),E=a("ul"),E.innerHTML=Il,at=o(),S=a("p"),S.textContent=Zl,it=o(),q=a("p"),q.innerHTML=$l,rt=o(),A=a("p"),A.innerHTML=Bl,pt=o(),M(X.$$.fragment),Mt=o(),Y=a("p"),Y.innerHTML=Wl,ut=o(),M(z.$$.fragment),ct=o(),F=a("p"),F.textContent=_l,mt=o(),P=a("ul"),P.innerHTML=Gl,dt=o(),L=a("p"),L.innerHTML=Ql,yt=o(),D=a("p"),D.innerHTML=kl,ht=o(),K=a("p"),K.innerHTML=Hl,bt=o(),M(O.$$.fragment),wt=o(),M(ee.$$.fragment),Ut=o(),te=a("p"),te.textContent=xl,Tt=o(),M(le.$$.fragment),ft=o(),se=a("p"),se.innerHTML=Vl,Jt=o(),M(Z.$$.fragment),jt=o(),oe=a("p"),oe.innerHTML=Rl,gt=o(),ne=a("p"),ne.innerHTML=Nl,Ct=o(),M(ae.$$.fragment),vt=o(),ie=a("p"),ie.innerHTML=El,It=o(),M(re.$$.fragment),Zt=o(),M(pe.$$.fragment),$t=o(),Me=a("p"),Me.innerHTML=Sl,Bt=o(),ue=a("p"),ue.textContent=ql,Wt=o(),M(ce.$$.fragment),_t=o(),me=a("p"),me.textContent=Al,Gt=o(),M(de.$$.fragment),Qt=o(),ye=a("p"),ye.textContent=Xl,kt=o(),M(he.$$.fragment),Ht=o(),be=a("p"),be.textContent=Yl,xt=o(),M(we.$$.fragment),Vt=o(),M($.$$.fragment),Rt=o(),M(Ue.$$.fragment),Nt=o(),Te=a("p"),Te.innerHTML=zl,Et=o(),fe=a("p"),fe.innerHTML=Fl,St=o(),Je=a("p"),Je.innerHTML=Pl,qt=o(),M(je.$$.fragment),At=o(),ge=a("p"),ge.textContent=Ll,Xt=o(),Ye=a("img"),Yt=o(),Ce=a("p"),Ce.innerHTML=Kl,zt=o(),M(ve.$$.fragment),Ft=o(),M(Ie.$$.fragment),Pt=o(),ze=a("img"),Lt=o(),Ze=a("p"),Ze.textContent=es,Dt=o(),M($e.$$.fragment),Kt=o(),Be=a("p"),Be.innerHTML=ts,Ot=o(),We=a("p"),We.innerHTML=ls,el=o(),M(_e.$$.fragment),tl=o(),M(Ge.$$.fragment),ll=o(),Qe=a("p"),Qe.innerHTML=ss,sl=o(),ke=a("p"),ke.innerHTML=os,ol=o(),M(He.$$.fragment),nl=o(),xe=a("p"),xe.textContent=ns,al=o(),M(Ve.$$.fragment),il=o(),M(B.$$.fragment),rl=o(),M(Re.$$.fragment),pl=o(),Ne=a("p"),Ne.innerHTML=as,Ml=o(),M(Ee.$$.fragment),ul=o(),Se=a("p"),Se.textContent=is,cl=o(),M(qe.$$.fragment),ml=o(),Ae=a("p"),Ae.textContent=rs,dl=o(),M(Xe.$$.fragment),yl=o(),Fe=a("p"),this.h()},l(e){const t=Us("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),U=n(e),h=i(e,"P",{}),ds(h).forEach(l),w=n(e),u(g.$$.fragment,e),C=n(e),u(f.$$.fragment,e),W=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-8951oz"&&(b.textContent=v),Pe=n(e),u(I.$$.fragment,e),Le=n(e),_=i(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1798l7p"&&(_.innerHTML=Tl),De=n(e),u(G.$$.fragment,e),Ke=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-50z9h0"&&(Q.textContent=fl),Oe=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1llqfcr"&&(k.textContent=Jl),et=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-eilpgu"&&(H.textContent=jl),tt=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-suz7fy"&&(x.textContent=gl),lt=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-x18ywb"&&(V.textContent=Cl),st=n(e),u(R.$$.fragment,e),ot=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1utr7qj"&&(N.innerHTML=vl),nt=n(e),E=i(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-xqgwuf"&&(E.innerHTML=Il),at=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-220ayw"&&(S.textContent=Zl),it=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1jyqj35"&&(q.innerHTML=$l),rt=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-qqjtut"&&(A.innerHTML=Bl),pt=n(e),u(X.$$.fragment,e),Mt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-29hm6c"&&(Y.innerHTML=Wl),ut=n(e),u(z.$$.fragment,e),ct=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-hoocvd"&&(F.textContent=_l),mt=n(e),P=i(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-1a0ab5h"&&(P.innerHTML=Gl),dt=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-4n5s3c"&&(L.innerHTML=Ql),yt=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1knl8v8"&&(D.innerHTML=kl),ht=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1oz5vb8"&&(K.innerHTML=Hl),bt=n(e),u(O.$$.fragment,e),wt=n(e),u(ee.$$.fragment,e),Ut=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-pgsz7r"&&(te.textContent=xl),Tt=n(e),u(le.$$.fragment,e),ft=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1q39vf"&&(se.innerHTML=Vl),Jt=n(e),u(Z.$$.fragment,e),jt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-531xzc"&&(oe.innerHTML=Rl),gt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-s0gh2b"&&(ne.innerHTML=Nl),Ct=n(e),u(ae.$$.fragment,e),vt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-j0i0xh"&&(ie.innerHTML=El),It=n(e),u(re.$$.fragment,e),Zt=n(e),u(pe.$$.fragment,e),$t=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-9674bn"&&(Me.innerHTML=Sl),Bt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1en3ihe"&&(ue.textContent=ql),Wt=n(e),u(ce.$$.fragment,e),_t=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ro6hjz"&&(me.textContent=Al),Gt=n(e),u(de.$$.fragment,e),Qt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1and4a8"&&(ye.textContent=Xl),kt=n(e),u(he.$$.fragment,e),Ht=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-7q6kbi"&&(be.textContent=Yl),xt=n(e),u(we.$$.fragment,e),Vt=n(e),u($.$$.fragment,e),Rt=n(e),u(Ue.$$.fragment,e),Nt=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-qrb4h1"&&(Te.innerHTML=zl),Et=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-17wa58l"&&(fe.innerHTML=Fl),St=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1gucs20"&&(Je.innerHTML=Pl),qt=n(e),u(je.$$.fragment,e),At=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-sgspwr"&&(ge.textContent=Ll),Xt=n(e),Ye=i(e,"IMG",{src:!0}),Yt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1y8rl57"&&(Ce.innerHTML=Kl),zt=n(e),u(ve.$$.fragment,e),Ft=n(e),u(Ie.$$.fragment,e),Pt=n(e),ze=i(e,"IMG",{src:!0}),Lt=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-i5dtbz"&&(Ze.textContent=es),Dt=n(e),u($e.$$.fragment,e),Kt=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1rq40pf"&&(Be.innerHTML=ts),Ot=n(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1g7jkvd"&&(We.innerHTML=ls),el=n(e),u(_e.$$.fragment,e),tl=n(e),u(Ge.$$.fragment,e),ll=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-69p3x"&&(Qe.innerHTML=ss),sl=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-ocb8u2"&&(ke.innerHTML=os),ol=n(e),u(He.$$.fragment,e),nl=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-o3ledg"&&(xe.textContent=ns),al=n(e),u(Ve.$$.fragment,e),il=n(e),u(B.$$.fragment,e),rl=n(e),u(Re.$$.fragment,e),pl=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-vczxbe"&&(Ne.innerHTML=as),Ml=n(e),u(Ee.$$.fragment,e),ul=n(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-qubpc6"&&(Se.textContent=is),cl=n(e),u(qe.$$.fragment,e),ml=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-6r1jgt"&&(Ae.textContent=rs),dl=n(e),u(Xe.$$.fragment,e),yl=n(e),Fe=i(e,"P",{}),ds(Fe).forEach(l),this.h()},h(){bl(p,"name","hf:doc:metadata"),bl(p,"content",Zs),ms(Ye.src,Dl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||bl(Ye,"src",Dl),ms(ze.src,Ol="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||bl(ze,"src",Ol)},m(e,t){Ts(document.head,p),s(e,U,t),s(e,h,t),s(e,w,t),c(g,e,t),s(e,C,t),c(f,e,t),s(e,W,t),s(e,b,t),s(e,Pe,t),c(I,e,t),s(e,Le,t),s(e,_,t),s(e,De,t),c(G,e,t),s(e,Ke,t),s(e,Q,t),s(e,Oe,t),s(e,k,t),s(e,et,t),s(e,H,t),s(e,tt,t),s(e,x,t),s(e,lt,t),s(e,V,t),s(e,st,t),c(R,e,t),s(e,ot,t),s(e,N,t),s(e,nt,t),s(e,E,t),s(e,at,t),s(e,S,t),s(e,it,t),s(e,q,t),s(e,rt,t),s(e,A,t),s(e,pt,t),c(X,e,t),s(e,Mt,t),s(e,Y,t),s(e,ut,t),c(z,e,t),s(e,ct,t),s(e,F,t),s(e,mt,t),s(e,P,t),s(e,dt,t),s(e,L,t),s(e,yt,t),s(e,D,t),s(e,ht,t),s(e,K,t),s(e,bt,t),c(O,e,t),s(e,wt,t),c(ee,e,t),s(e,Ut,t),s(e,te,t),s(e,Tt,t),c(le,e,t),s(e,ft,t),s(e,se,t),s(e,Jt,t),c(Z,e,t),s(e,jt,t),s(e,oe,t),s(e,gt,t),s(e,ne,t),s(e,Ct,t),c(ae,e,t),s(e,vt,t),s(e,ie,t),s(e,It,t),c(re,e,t),s(e,Zt,t),c(pe,e,t),s(e,$t,t),s(e,Me,t),s(e,Bt,t),s(e,ue,t),s(e,Wt,t),c(ce,e,t),s(e,_t,t),s(e,me,t),s(e,Gt,t),c(de,e,t),s(e,Qt,t),s(e,ye,t),s(e,kt,t),c(he,e,t),s(e,Ht,t),s(e,be,t),s(e,xt,t),c(we,e,t),s(e,Vt,t),c($,e,t),s(e,Rt,t),c(Ue,e,t),s(e,Nt,t),s(e,Te,t),s(e,Et,t),s(e,fe,t),s(e,St,t),s(e,Je,t),s(e,qt,t),c(je,e,t),s(e,At,t),s(e,ge,t),s(e,Xt,t),s(e,Ye,t),s(e,Yt,t),s(e,Ce,t),s(e,zt,t),c(ve,e,t),s(e,Ft,t),c(Ie,e,t),s(e,Pt,t),s(e,ze,t),s(e,Lt,t),s(e,Ze,t),s(e,Dt,t),c($e,e,t),s(e,Kt,t),s(e,Be,t),s(e,Ot,t),s(e,We,t),s(e,el,t),c(_e,e,t),s(e,tl,t),c(Ge,e,t),s(e,ll,t),s(e,Qe,t),s(e,sl,t),s(e,ke,t),s(e,ol,t),c(He,e,t),s(e,nl,t),s(e,xe,t),s(e,al,t),c(Ve,e,t),s(e,il,t),c(B,e,t),s(e,rl,t),c(Re,e,t),s(e,pl,t),s(e,Ne,t),s(e,Ml,t),c(Ee,e,t),s(e,ul,t),s(e,Se,t),s(e,cl,t),c(qe,e,t),s(e,ml,t),s(e,Ae,t),s(e,dl,t),c(Xe,e,t),s(e,yl,t),s(e,Fe,t),hl=!0},p(e,[t]){const ps={};t&2&&(ps.$$scope={dirty:t,ctx:e}),I.$set(ps);const Ms={};t&2&&(Ms.$$scope={dirty:t,ctx:e}),Z.$set(Ms);const us={};t&2&&(us.$$scope={dirty:t,ctx:e}),$.$set(us);const cs={};t&2&&(cs.$$scope={dirty:t,ctx:e}),B.$set(cs)},i(e){hl||(m(g.$$.fragment,e),m(f.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(R.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(Z.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(we.$$.fragment,e),m($.$$.fragment,e),m(Ue.$$.fragment,e),m(je.$$.fragment,e),m(ve.$$.fragment,e),m(Ie.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(Ge.$$.fragment,e),m(He.$$.fragment,e),m(Ve.$$.fragment,e),m(B.$$.fragment,e),m(Re.$$.fragment,e),m(Ee.$$.fragment,e),m(qe.$$.fragment,e),m(Xe.$$.fragment,e),hl=!0)},o(e){d(g.$$.fragment,e),d(f.$$.fragment,e),d(I.$$.fragment,e),d(G.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(Z.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(we.$$.fragment,e),d($.$$.fragment,e),d(Ue.$$.fragment,e),d(je.$$.fragment,e),d(ve.$$.fragment,e),d(Ie.$$.fragment,e),d($e.$$.fragment,e),d(_e.$$.fragment,e),d(Ge.$$.fragment,e),d(He.$$.fragment,e),d(Ve.$$.fragment,e),d(B.$$.fragment,e),d(Re.$$.fragment,e),d(Ee.$$.fragment,e),d(qe.$$.fragment,e),d(Xe.$$.fragment,e),hl=!1},d(e){e&&(l(U),l(h),l(w),l(C),l(W),l(b),l(Pe),l(Le),l(_),l(De),l(Ke),l(Q),l(Oe),l(k),l(et),l(H),l(tt),l(x),l(lt),l(V),l(st),l(ot),l(N),l(nt),l(E),l(at),l(S),l(it),l(q),l(rt),l(A),l(pt),l(Mt),l(Y),l(ut),l(ct),l(F),l(mt),l(P),l(dt),l(L),l(yt),l(D),l(ht),l(K),l(bt),l(wt),l(Ut),l(te),l(Tt),l(ft),l(se),l(Jt),l(jt),l(oe),l(gt),l(ne),l(Ct),l(vt),l(ie),l(It),l(Zt),l($t),l(Me),l(Bt),l(ue),l(Wt),l(_t),l(me),l(Gt),l(Qt),l(ye),l(kt),l(Ht),l(be),l(xt),l(Vt),l(Rt),l(Nt),l(Te),l(Et),l(fe),l(St),l(Je),l(qt),l(At),l(ge),l(Xt),l(Ye),l(Yt),l(Ce),l(zt),l(Ft),l(Pt),l(ze),l(Lt),l(Ze),l(Dt),l(Kt),l(Be),l(Ot),l(We),l(el),l(tl),l(ll),l(Qe),l(sl),l(ke),l(ol),l(nl),l(xe),l(al),l(il),l(rl),l(pl),l(Ne),l(Ml),l(ul),l(Se),l(cl),l(ml),l(Ae),l(dl),l(yl),l(Fe)),l(p),y(g,e),y(f,e),y(I,e),y(G,e),y(R,e),y(X,e),y(z,e),y(O,e),y(ee,e),y(le,e),y(Z,e),y(ae,e),y(re,e),y(pe,e),y(ce,e),y(de,e),y(he,e),y(we,e),y($,e),y(Ue,e),y(je,e),y(ve,e),y(Ie,e),y($e,e),y(_e,e),y(Ge,e),y(He,e),y(Ve,e),y(B,e),y(Re,e),y(Ee,e),y(qe,e),y(Xe,e)}}}const Zs='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Use tools from an MCP server","local":"use-tools-from-an-mcp-server","sections":[{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4},{"title":"Use MCP tools with MCPClient directly","local":"use-mcp-tools-with-mcpclient-directly","sections":[],"depth":4}],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4}],"depth":3}],"depth":1}';function $s(j){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends bs{constructor(p){super(),ws(this,p,$s,Is,ys,{})}}export{Hs as component};
