import{s as dd,o as cd,n as k}from"../chunks/scheduler.7da89386.js";import{S as ud,i as gd,g as p,s as l,r as u,A as hd,h as d,f as i,c as r,j as v,u as g,x as $,k as j,y as a,a as c,v as h,d as f,t as M,w as b}from"../chunks/index.20910acc.js";import{T as C}from"../chunks/Tip.53e22153.js";import{D as J}from"../chunks/Docstring.95501267.js";import{C as U}from"../chunks/CodeBlock.143bd81e.js";import{E as R}from"../chunks/ExampleCodeBlock.457e33ac.js";import{H as x}from"../chunks/getInferenceSnippets.eb0ed38b.js";function fd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Md(w){let n,y="Example of text generation:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1bvu0cy"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function bd(w){let n,y="Example using <code>transformers.pipelines</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1da1qsq"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Td(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function yd(w){let n,y="Example of feature extraction:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-12vwt80"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function _d(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function $d(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function wd(w){let n,y="Example of text generation:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1bvu0cy"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function vd(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function jd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Jd(w){let n,y="Example of single-label classification:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-ykxpe4"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function kd(w){let n,y="Example using <code>transformers.pipelines</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1da1qsq"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function xd(w){let n,y="Example using zero-shot-classification <code>transformers.pipelines</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1vtj8d2"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Rd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Ud(w){let n,y="Example of token classification:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-rtgw80"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Zd(w){let n,y="Example using <code>transformers.pipelines</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1da1qsq"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Wd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Cd(w){let n,y="Example of mutliple choice:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-lfckvi"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Fd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Id(w){let n,y="Example of question answering:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1ml1brl"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Gd(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Nd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Vd(w){let n,y="Example of image classification:",o,s,T;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1nh3zco"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Xd(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function zd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Sd(w){let n,y="Example of semantic segmentation:",o,s,T;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1wzzaup"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Bd(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function qd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Ed(w){let n,y="Example of audio classification:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1mp8f15"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Hd(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Ld(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Od(w){let n,y="Example of audio frame classification:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-12boqdm"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Qd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Yd(w){let n,y="Example of CTC:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-mdyxnj"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Ad(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Pd(w){let n,y="Example of text generation:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1bvu0cy"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Dd(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function Kd(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function ec(w){let n,y="Example of Audio XVector:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1kzdm5c"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function tc(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function nc(w){let n,y="Example of text generation:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1bvu0cy"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function sc(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function oc(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function ac(w){let n,y="Example of pix2struct:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-11ikyn3"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function lc(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function rc(w){let n,y="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-6kynse"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function ic(w){let n,y="Example using <code>transformers.pipelines</code>(only if the task is supported):",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-xxeb0k"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function mc(w){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=y},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function pc(w){let n,y="Example of feature extraction:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=p("p"),n.textContent=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-12vwt80"&&(n.textContent=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function dc(w){let n,y="Example using <code>transformers.pipeline</code>:",o,s,T;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=p("p"),n.innerHTML=y,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=y),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),T=!0},p:k,i(t){T||(f(s.$$.fragment,t),T=!0)},o(t){M(s.$$.fragment,t),T=!1},d(t){t&&(i(n),i(o)),b(s,t)}}}function cc(w){let n,y,o,s,T,t,_,Za,cn,Nm="The following ORT classes are available for instantiating a base model class without a specific head.",Wa,un,Ca,Z,gn,Ll,ro,Vm="Base class for implementing models using ONNX Runtime.",Ol,io,Xm=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,Ql,mo,zm="Class attributes:",Yl,po,Sm=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,Al,rt,hn,Pl,co,Bm="Returns whether this model can generate sequences with <code>.generate()</code>.",Dl,W,fn,Kl,uo,qm="Instantiate a pretrained model from a pre-trained model configuration.",er,go,Em=`provider (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>):
ONNX Runtime provider to use for loading the model.
See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for possible providers.
providers (<code>Optional[Sequence[str]]</code>, defaults to <code>None</code>):
List of execution providers to use for loading the model.
This argument takes precedence over the <code>provider</code> argument.
provider_options (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>):
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .
session_options (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>),:
ONNX Runtime session options to use for loading the model.
use_io_binding (<code>Optional[bool]</code>, defaults to <code>None</code>):
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.
kwargs (<code>Dict[str, Any]</code>):
Will be passed to the underlying model loading methods.`,tr,ho,Hm="<p>Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)</p>",nr,fo,Lm=`use_cache (<code>Optional[bool]</code>, defaults to <code>True</code>):
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,sr,Mo,Om="<p>Parameters for ORTModelForCausalLM</p>",or,bo,Qm=`use_merged (<code>Optional[bool]</code>, defaults to <code>None</code>):
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,Fa,Mn,Ia,bn,Ym="The following ORT classes are available for the following natural language processing tasks.",Ga,Tn,Na,ee,yn,ar,To,Am=`ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt-bigcode, gpt_neo, gpt_neox, gptj, llama.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,lr,yo,Pm='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',rr,B,_n,ir,_o,Dm="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",mr,it,pr,mt,dr,pt,Va,$n,Xa,te,wn,cr,$o,Km=`ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ur,wo,ep='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',gr,q,vn,hr,vo,tp="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",fr,dt,Mr,ct,br,ut,za,jn,Sa,ne,Jn,Tr,jo,np=`Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot-small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,yr,Jo,sp="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",_r,E,kn,$r,ko,op="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",wr,gt,vr,ht,jr,ft,Ba,xn,qa,N,Rn,Jr,xo,ap=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,kr,Ro,lp=`This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,xr,Uo,rp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Rr,G,Un,Ur,Zo,ip="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",Zr,Mt,Wr,bt,Cr,Tt,Fr,yt,Ea,Zn,Ha,V,Wn,Ir,Wo,mp=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Gr,Co,pp=`This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Nr,Fo,dp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Vr,H,Cn,Xr,Io,cp="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",zr,_t,Sr,$t,Br,wt,La,Fn,Oa,X,In,qr,Go,up=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Er,No,gp=`This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Hr,Vo,hp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Lr,Ue,Gn,Or,Xo,fp="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",Qr,vt,Yr,jt,Qa,Nn,Ya,se,Vn,Ar,zo,Mp=`ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Pr,So,bp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Dr,L,Xn,Kr,Bo,Tp="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",ei,Jt,ti,kt,ni,xt,Aa,zn,Pa,Sn,yp="The following ORT classes are available for the following computer vision tasks.",Da,Bn,Ka,oe,qn,si,qo,_p=`ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec-vision, deit, dinov2, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, swinv2, vit.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,oi,Eo,$p='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ai,O,En,li,Ho,wp="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",ri,Rt,ii,Ut,mi,Zt,el,Hn,tl,ae,Ln,pi,Lo,vp=`ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports maskformer, segformer.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,di,Oo,jp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ci,Q,On,ui,Qo,Jp="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",gi,Wt,hi,Ct,fi,Ft,nl,Qn,sl,Yn,kp="The following ORT classes are available for the following audio tasks.",ol,An,al,z,Pn,Mi,Yo,xp=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,bi,Ao,Rp=`This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ti,Po,Up='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',yi,Y,Dn,_i,Do,Zp="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",$i,It,wi,Gt,vi,Nt,ll,Kn,rl,le,es,ji,Ko,Wp=`ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ji,ea,Cp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ki,Ze,ts,xi,ta,Fp="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",Ri,Vt,Ui,Xt,il,ns,ml,re,ss,Zi,na,Ip=`ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Wi,sa,Gp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ci,We,os,Fi,oa,Np="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",Ii,zt,Gi,St,pl,as,dl,ie,ls,Ni,aa,Vp=`Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Vi,la,Xp="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",Xi,A,rs,zi,ra,zp="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",Si,Bt,Bi,qt,qi,Et,cl,is,ul,me,ms,Ei,ia,Sp=`ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Hi,ma,Bp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Li,Ce,ps,Oi,pa,qp="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",Qi,Ht,Yi,Lt,gl,ds,hl,cs,Ep="The following ORT classes are available for the following multimodal tasks.",fl,us,Ml,pe,gs,Ai,da,Hp=`VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Pi,ca,Lp="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",Di,P,hs,Ki,ua,Op="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",em,Ot,tm,Qt,nm,Yt,bl,fs,Tl,de,Ms,sm,ga,Qp=`Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,om,ha,Yp="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",am,Fe,bs,lm,fa,Ap="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",rm,At,im,Pt,yl,Ts,_l,ys,Pp="The following ORT classes are available for the following custom tasks.",$l,_s,wl,ce,$s,mm,Ma,Dp=`ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,pm,ba,Kp='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',dm,D,ws,cm,Ta,ed="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",um,Dt,gm,Kt,hm,en,vl,vs,jl,ue,js,fm,ya,td=`ONNX Model for feature-extraction task.
This model inherits from <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Mm,_a,nd='This class should be initialized using the <a href="/docs/optimum/pr_35/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',bm,K,Js,Tm,$a,sd="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",ym,tn,_m,nn,$m,sn,Jl,ks,kl,xs,xl,et,Rs,wm,on,Us,vm,wa,od="Call self as a function.",Rl,Zs,Ul,tt,Ws,jm,an,Cs,Jm,va,ad="Call self as a function.",Zl,Fs,Wl,nt,Is,km,ln,Gs,xm,ja,ld="Call self as a function.",Cl,Ns,Fl,st,Vs,Rm,rn,Xs,Um,Ja,rd="Call self as a function.",Il,zs,Gl,ot,Ss,Zm,mn,Bs,Wm,ka,id="Call self as a function.",Nl,qs,Vl,at,Es,Cm,pn,Hs,Fm,xa,md="Call self as a function.",Xl,Ls,zl,lt,Os,Im,dn,Qs,Gm,Ra,pd="Call self as a function.",Sl,Ua,Bl;return T=new x({props:{title:"Models",local:"models",headingTag:"h1"}}),_=new x({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),un=new x({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),gn=new J({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.-",description:'<strong>-</strong> config (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> &#x2014; The configuration of the model. &#x2014;',name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> session (<code>~onnxruntime.InferenceSession</code>) &#x2014; The ONNX Runtime InferenceSession that is running the model. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to use I/O bindings with **ONNX Runtime &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.with",description:"<strong>with</strong> the CUDAExecutionProvider**, this can significantly speedup inference depending on the task. &#x2014;",name:"with"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> model_save_dir (<code>Path</code>) &#x2014; The directory where the model exported to ONNX is saved. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.By",description:"<strong>By</strong> defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the &#x2014;",name:"By"},{anchor:"optimum.onnxruntime.ORTModel.cache",description:"<strong>cache</strong> directory is used. &#x2014;",name:"cache"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L128"}}),hn=new J({props:{name:"can_generate",anchor:"optimum.onnxruntime.ORTModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L569"}}),fn=new J({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": str | Path"},{name:"config",val:": PretrainedConfig | None = None"},{name:"export",val:": bool = False"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": str = 'main'"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"trust_remote_code",val:": bool = False"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": bool | str | None = None"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"providers",val:": Sequence[str] | None = None"},{name:"provider_options",val:": Sequence[dict[str, Any]] | dict[str, Any] | None = None"},{name:"session_options",val:": SessionOptions | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.export",description:`<strong>export</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> needs to be exported to the targeted format.`,name:"export"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
Deprecated. Please use the <code>token</code> argument instead.`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L441",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`}}),Mn=new x({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Tn=new x({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),yn=new J({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"generation_config",val:": GenerationConfig | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_decoder.py#L124"}}),_n=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": torch.LongTensor"},{name:"attention_mask",val:": torch.LongTensor | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"position_ids",val:": torch.LongTensor | None = None"},{name:"use_cache",val:": bool | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_decoder.py#L258"}}),it=new C({props:{$$slots:{default:[fd]},$$scope:{ctx:w}}}),mt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[Md]},$$scope:{ctx:w}}}),pt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[bd]},$$scope:{ctx:w}}}),$n=new x({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),wn=new J({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L755"}}),vn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L762"}}),dt=new C({props:{$$slots:{default:[Td]},$$scope:{ctx:w}}}),ct=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[yd]},$$scope:{ctx:w}}}),ut=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[_d]},$$scope:{ctx:w}}}),jn=new x({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),Jn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": InferenceSession | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"generation_config",val:": GenerationConfig | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_seq2seq.py#L1288"}}),kn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": torch.LongTensor = None"},{name:"attention_mask",val:": torch.FloatTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_seq2seq.py#L1295"}}),gt=new C({props:{$$slots:{default:[$d]},$$scope:{ctx:w}}}),ht=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[wd]},$$scope:{ctx:w}}}),ft=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[vd]},$$scope:{ctx:w}}}),xn=new x({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),Rn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L973"}}),Un=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L982"}}),Mt=new C({props:{$$slots:{default:[jd]},$$scope:{ctx:w}}}),bt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[Jd]},$$scope:{ctx:w}}}),Tt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[kd]},$$scope:{ctx:w}}}),yt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[xd]},$$scope:{ctx:w}}}),Zn=new x({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),Wn=new J({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1075"}}),Cn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1085"}}),_t=new C({props:{$$slots:{default:[Rd]},$$scope:{ctx:w}}}),$t=new R({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[Ud]},$$scope:{ctx:w}}}),wt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[Zd]},$$scope:{ctx:w}}}),Fn=new x({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),In=new J({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1172"}}),Gn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1181"}}),vt=new C({props:{$$slots:{default:[Wd]},$$scope:{ctx:w}}}),jt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[Cd]},$$scope:{ctx:w}}}),Nn=new x({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Vn=new J({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L856"}}),Xn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L863"}}),Jt=new C({props:{$$slots:{default:[Fd]},$$scope:{ctx:w}}}),kt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[Id]},$$scope:{ctx:w}}}),xt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[Gd]},$$scope:{ctx:w}}}),zn=new x({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),Bn=new x({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),qn=new J({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1278"}}),En=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": torch.Tensor | np.ndarray"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1284"}}),Rt=new C({props:{$$slots:{default:[Nd]},$$scope:{ctx:w}}}),Ut=new R({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[Vd]},$$scope:{ctx:w}}}),Zt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[Xd]},$$scope:{ctx:w}}}),Hn=new x({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),Ln=new J({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1374"}}),On=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": torch.Tensor | np.ndarray"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1380"}}),Wt=new C({props:{$$slots:{default:[zd]},$$scope:{ctx:w}}}),Ct=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[Sd]},$$scope:{ctx:w}}}),Ft=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[Bd]},$$scope:{ctx:w}}}),Qn=new x({props:{title:"Audio",local:"audio",headingTag:"h2"}}),An=new x({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),Pn=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1474"}}),Dn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"input_features",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1483"}}),It=new C({props:{$$slots:{default:[qd]},$$scope:{ctx:w}}}),Gt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[Ed]},$$scope:{ctx:w}}}),Nt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[Hd]},$$scope:{ctx:w}}}),Kn=new x({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),es=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1764"}}),ts=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1771"}}),Vt=new C({props:{$$slots:{default:[Ld]},$$scope:{ctx:w}}}),Xt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[Od]},$$scope:{ctx:w}}}),ns=new x({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),ss=new J({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1573"}}),os=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1580"}}),zt=new C({props:{$$slots:{default:[Qd]},$$scope:{ctx:w}}}),St=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[Yd]},$$scope:{ctx:w}}}),as=new x({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),ls=new J({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_seq2seq.py#L1383"}}),rs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": torch.FloatTensor | None = None"},{name:"attention_mask",val:": torch.LongTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"cache_position",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_seq2seq.py#L1404"}}),Bt=new C({props:{$$slots:{default:[Ad]},$$scope:{ctx:w}}}),qt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[Pd]},$$scope:{ctx:w}}}),Et=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[Dd]},$$scope:{ctx:w}}}),is=new x({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),ms=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1676"}}),ps=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1683"}}),Ht=new C({props:{$$slots:{default:[Kd]},$$scope:{ctx:w}}}),Lt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[ec]},$$scope:{ctx:w}}}),ds=new x({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),us=new x({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),gs=new J({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": InferenceSession | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"generation_config",val:": GenerationConfig | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_seq2seq.py#L1515"}}),hs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": torch.FloatTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_seq2seq.py#L1524"}}),Ot=new C({props:{$$slots:{default:[tc]},$$scope:{ctx:w}}}),Qt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[nc]},$$scope:{ctx:w}}}),Yt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[sc]},$$scope:{ctx:w}}}),fs=new x({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),Ms=new J({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": InferenceSession | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"generation_config",val:": GenerationConfig | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_seq2seq.py#L1609"}}),bs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": torch.FloatTensor | None = None"},{name:"attention_mask",val:": torch.LongTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"decoder_attention_mask",val:": torch.BoolTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_seq2seq.py#L1619"}}),At=new C({props:{$$slots:{default:[oc]},$$scope:{ctx:w}}}),Pt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[ac]},$$scope:{ctx:w}}}),Ts=new x({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),_s=new x({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),$s=new J({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1945"}}),ws=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**model_inputs",val:": torch.Tensor | np.ndarray"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L1949"}}),Dt=new C({props:{$$slots:{default:[lc]},$$scope:{ctx:w}}}),Kt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[rc]},$$scope:{ctx:w}}}),en=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[ic]},$$scope:{ctx:w}}}),vs=new x({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),js=new J({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L622"}}),Js=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"position_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"pixel_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"visual_embeds",val:": torch.Tensor | np.ndarray | None = None"},{name:"visual_attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"visual_token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"input_features",val:": torch.Tensor | np.ndarray | None = None"},{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/onnxruntime/modeling_ort.py#L629"}}),tn=new C({props:{$$slots:{default:[mc]},$$scope:{ctx:w}}}),nn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[pc]},$$scope:{ctx:w}}}),sn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[dc]},$$scope:{ctx:w}}}),ks=new x({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),xs=new x({props:{title:"ORTDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",headingTag:"h4"}}),Rs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/utils/dummy_diffusers_objects.py#L18"}}),Us=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Zs=new x({props:{title:"ORTStableDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",headingTag:"h4"}}),Ws=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/utils/dummy_diffusers_objects.py#L62"}}),Cs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Fs=new x({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Is=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/utils/dummy_diffusers_objects.py#L73"}}),Gs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ns=new x({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Vs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/utils/dummy_diffusers_objects.py#L84"}}),Xs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),zs=new x({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),Ss=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/utils/dummy_diffusers_objects.py#L95"}}),Bs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),qs=new x({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),Es=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/utils/dummy_diffusers_objects.py#L106"}}),Hs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ls=new x({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),Os=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_35/optimum/utils/dummy_diffusers_objects.py#L128"}}),Qs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),{c(){n=p("meta"),y=l(),o=p("p"),s=l(),u(T.$$.fragment),t=l(),u(_.$$.fragment),Za=l(),cn=p("p"),cn.textContent=Nm,Wa=l(),u(un.$$.fragment),Ca=l(),Z=p("div"),u(gn.$$.fragment),Ll=l(),ro=p("p"),ro.textContent=Vm,Ol=l(),io=p("p"),io.innerHTML=Xm,Ql=l(),mo=p("p"),mo.textContent=zm,Yl=l(),po=p("ul"),po.innerHTML=Sm,Al=l(),rt=p("div"),u(hn.$$.fragment),Pl=l(),co=p("p"),co.innerHTML=Bm,Dl=l(),W=p("div"),u(fn.$$.fragment),Kl=l(),uo=p("p"),uo.textContent=qm,er=l(),go=p("p"),go.innerHTML=Em,tr=l(),ho=p("blockquote"),ho.innerHTML=Hm,nr=l(),fo=p("p"),fo.innerHTML=Lm,sr=l(),Mo=p("blockquote"),Mo.innerHTML=Om,or=l(),bo=p("p"),bo.innerHTML=Qm,Fa=l(),u(Mn.$$.fragment),Ia=l(),bn=p("p"),bn.textContent=Ym,Ga=l(),u(Tn.$$.fragment),Na=l(),ee=p("div"),u(yn.$$.fragment),ar=l(),To=p("p"),To.innerHTML=Am,lr=l(),yo=p("p"),yo.innerHTML=Pm,rr=l(),B=p("div"),u(_n.$$.fragment),ir=l(),_o=p("p"),_o.innerHTML=Dm,mr=l(),u(it.$$.fragment),pr=l(),u(mt.$$.fragment),dr=l(),u(pt.$$.fragment),Va=l(),u($n.$$.fragment),Xa=l(),te=p("div"),u(wn.$$.fragment),cr=l(),$o=p("p"),$o.innerHTML=Km,ur=l(),wo=p("p"),wo.innerHTML=ep,gr=l(),q=p("div"),u(vn.$$.fragment),hr=l(),vo=p("p"),vo.innerHTML=tp,fr=l(),u(dt.$$.fragment),Mr=l(),u(ct.$$.fragment),br=l(),u(ut.$$.fragment),za=l(),u(jn.$$.fragment),Sa=l(),ne=p("div"),u(Jn.$$.fragment),Tr=l(),jo=p("p"),jo.innerHTML=np,yr=l(),Jo=p("p"),Jo.innerHTML=sp,_r=l(),E=p("div"),u(kn.$$.fragment),$r=l(),ko=p("p"),ko.innerHTML=op,wr=l(),u(gt.$$.fragment),vr=l(),u(ht.$$.fragment),jr=l(),u(ft.$$.fragment),Ba=l(),u(xn.$$.fragment),qa=l(),N=p("div"),u(Rn.$$.fragment),Jr=l(),xo=p("p"),xo.textContent=ap,kr=l(),Ro=p("p"),Ro.innerHTML=lp,xr=l(),Uo=p("p"),Uo.innerHTML=rp,Rr=l(),G=p("div"),u(Un.$$.fragment),Ur=l(),Zo=p("p"),Zo.innerHTML=ip,Zr=l(),u(Mt.$$.fragment),Wr=l(),u(bt.$$.fragment),Cr=l(),u(Tt.$$.fragment),Fr=l(),u(yt.$$.fragment),Ea=l(),u(Zn.$$.fragment),Ha=l(),V=p("div"),u(Wn.$$.fragment),Ir=l(),Wo=p("p"),Wo.textContent=mp,Gr=l(),Co=p("p"),Co.innerHTML=pp,Nr=l(),Fo=p("p"),Fo.innerHTML=dp,Vr=l(),H=p("div"),u(Cn.$$.fragment),Xr=l(),Io=p("p"),Io.innerHTML=cp,zr=l(),u(_t.$$.fragment),Sr=l(),u($t.$$.fragment),Br=l(),u(wt.$$.fragment),La=l(),u(Fn.$$.fragment),Oa=l(),X=p("div"),u(In.$$.fragment),qr=l(),Go=p("p"),Go.textContent=up,Er=l(),No=p("p"),No.innerHTML=gp,Hr=l(),Vo=p("p"),Vo.innerHTML=hp,Lr=l(),Ue=p("div"),u(Gn.$$.fragment),Or=l(),Xo=p("p"),Xo.innerHTML=fp,Qr=l(),u(vt.$$.fragment),Yr=l(),u(jt.$$.fragment),Qa=l(),u(Nn.$$.fragment),Ya=l(),se=p("div"),u(Vn.$$.fragment),Ar=l(),zo=p("p"),zo.innerHTML=Mp,Pr=l(),So=p("p"),So.innerHTML=bp,Dr=l(),L=p("div"),u(Xn.$$.fragment),Kr=l(),Bo=p("p"),Bo.innerHTML=Tp,ei=l(),u(Jt.$$.fragment),ti=l(),u(kt.$$.fragment),ni=l(),u(xt.$$.fragment),Aa=l(),u(zn.$$.fragment),Pa=l(),Sn=p("p"),Sn.textContent=yp,Da=l(),u(Bn.$$.fragment),Ka=l(),oe=p("div"),u(qn.$$.fragment),si=l(),qo=p("p"),qo.innerHTML=_p,oi=l(),Eo=p("p"),Eo.innerHTML=$p,ai=l(),O=p("div"),u(En.$$.fragment),li=l(),Ho=p("p"),Ho.innerHTML=wp,ri=l(),u(Rt.$$.fragment),ii=l(),u(Ut.$$.fragment),mi=l(),u(Zt.$$.fragment),el=l(),u(Hn.$$.fragment),tl=l(),ae=p("div"),u(Ln.$$.fragment),pi=l(),Lo=p("p"),Lo.innerHTML=vp,di=l(),Oo=p("p"),Oo.innerHTML=jp,ci=l(),Q=p("div"),u(On.$$.fragment),ui=l(),Qo=p("p"),Qo.innerHTML=Jp,gi=l(),u(Wt.$$.fragment),hi=l(),u(Ct.$$.fragment),fi=l(),u(Ft.$$.fragment),nl=l(),u(Qn.$$.fragment),sl=l(),Yn=p("p"),Yn.textContent=kp,ol=l(),u(An.$$.fragment),al=l(),z=p("div"),u(Pn.$$.fragment),Mi=l(),Yo=p("p"),Yo.textContent=xp,bi=l(),Ao=p("p"),Ao.innerHTML=Rp,Ti=l(),Po=p("p"),Po.innerHTML=Up,yi=l(),Y=p("div"),u(Dn.$$.fragment),_i=l(),Do=p("p"),Do.innerHTML=Zp,$i=l(),u(It.$$.fragment),wi=l(),u(Gt.$$.fragment),vi=l(),u(Nt.$$.fragment),ll=l(),u(Kn.$$.fragment),rl=l(),le=p("div"),u(es.$$.fragment),ji=l(),Ko=p("p"),Ko.innerHTML=Wp,Ji=l(),ea=p("p"),ea.innerHTML=Cp,ki=l(),Ze=p("div"),u(ts.$$.fragment),xi=l(),ta=p("p"),ta.innerHTML=Fp,Ri=l(),u(Vt.$$.fragment),Ui=l(),u(Xt.$$.fragment),il=l(),u(ns.$$.fragment),ml=l(),re=p("div"),u(ss.$$.fragment),Zi=l(),na=p("p"),na.innerHTML=Ip,Wi=l(),sa=p("p"),sa.innerHTML=Gp,Ci=l(),We=p("div"),u(os.$$.fragment),Fi=l(),oa=p("p"),oa.innerHTML=Np,Ii=l(),u(zt.$$.fragment),Gi=l(),u(St.$$.fragment),pl=l(),u(as.$$.fragment),dl=l(),ie=p("div"),u(ls.$$.fragment),Ni=l(),aa=p("p"),aa.innerHTML=Vp,Vi=l(),la=p("p"),la.innerHTML=Xp,Xi=l(),A=p("div"),u(rs.$$.fragment),zi=l(),ra=p("p"),ra.innerHTML=zp,Si=l(),u(Bt.$$.fragment),Bi=l(),u(qt.$$.fragment),qi=l(),u(Et.$$.fragment),cl=l(),u(is.$$.fragment),ul=l(),me=p("div"),u(ms.$$.fragment),Ei=l(),ia=p("p"),ia.innerHTML=Sp,Hi=l(),ma=p("p"),ma.innerHTML=Bp,Li=l(),Ce=p("div"),u(ps.$$.fragment),Oi=l(),pa=p("p"),pa.innerHTML=qp,Qi=l(),u(Ht.$$.fragment),Yi=l(),u(Lt.$$.fragment),gl=l(),u(ds.$$.fragment),hl=l(),cs=p("p"),cs.textContent=Ep,fl=l(),u(us.$$.fragment),Ml=l(),pe=p("div"),u(gs.$$.fragment),Ai=l(),da=p("p"),da.innerHTML=Hp,Pi=l(),ca=p("p"),ca.innerHTML=Lp,Di=l(),P=p("div"),u(hs.$$.fragment),Ki=l(),ua=p("p"),ua.innerHTML=Op,em=l(),u(Ot.$$.fragment),tm=l(),u(Qt.$$.fragment),nm=l(),u(Yt.$$.fragment),bl=l(),u(fs.$$.fragment),Tl=l(),de=p("div"),u(Ms.$$.fragment),sm=l(),ga=p("p"),ga.innerHTML=Qp,om=l(),ha=p("p"),ha.innerHTML=Yp,am=l(),Fe=p("div"),u(bs.$$.fragment),lm=l(),fa=p("p"),fa.innerHTML=Ap,rm=l(),u(At.$$.fragment),im=l(),u(Pt.$$.fragment),yl=l(),u(Ts.$$.fragment),_l=l(),ys=p("p"),ys.textContent=Pp,$l=l(),u(_s.$$.fragment),wl=l(),ce=p("div"),u($s.$$.fragment),mm=l(),Ma=p("p"),Ma.innerHTML=Dp,pm=l(),ba=p("p"),ba.innerHTML=Kp,dm=l(),D=p("div"),u(ws.$$.fragment),cm=l(),Ta=p("p"),Ta.innerHTML=ed,um=l(),u(Dt.$$.fragment),gm=l(),u(Kt.$$.fragment),hm=l(),u(en.$$.fragment),vl=l(),u(vs.$$.fragment),jl=l(),ue=p("div"),u(js.$$.fragment),fm=l(),ya=p("p"),ya.innerHTML=td,Mm=l(),_a=p("p"),_a.innerHTML=nd,bm=l(),K=p("div"),u(Js.$$.fragment),Tm=l(),$a=p("p"),$a.innerHTML=sd,ym=l(),u(tn.$$.fragment),_m=l(),u(nn.$$.fragment),$m=l(),u(sn.$$.fragment),Jl=l(),u(ks.$$.fragment),kl=l(),u(xs.$$.fragment),xl=l(),et=p("div"),u(Rs.$$.fragment),wm=l(),on=p("div"),u(Us.$$.fragment),vm=l(),wa=p("p"),wa.textContent=od,Rl=l(),u(Zs.$$.fragment),Ul=l(),tt=p("div"),u(Ws.$$.fragment),jm=l(),an=p("div"),u(Cs.$$.fragment),Jm=l(),va=p("p"),va.textContent=ad,Zl=l(),u(Fs.$$.fragment),Wl=l(),nt=p("div"),u(Is.$$.fragment),km=l(),ln=p("div"),u(Gs.$$.fragment),xm=l(),ja=p("p"),ja.textContent=ld,Cl=l(),u(Ns.$$.fragment),Fl=l(),st=p("div"),u(Vs.$$.fragment),Rm=l(),rn=p("div"),u(Xs.$$.fragment),Um=l(),Ja=p("p"),Ja.textContent=rd,Il=l(),u(zs.$$.fragment),Gl=l(),ot=p("div"),u(Ss.$$.fragment),Zm=l(),mn=p("div"),u(Bs.$$.fragment),Wm=l(),ka=p("p"),ka.textContent=id,Nl=l(),u(qs.$$.fragment),Vl=l(),at=p("div"),u(Es.$$.fragment),Cm=l(),pn=p("div"),u(Hs.$$.fragment),Fm=l(),xa=p("p"),xa.textContent=md,Xl=l(),u(Ls.$$.fragment),zl=l(),lt=p("div"),u(Os.$$.fragment),Im=l(),dn=p("div"),u(Qs.$$.fragment),Gm=l(),Ra=p("p"),Ra.textContent=pd,Sl=l(),Ua=p("p"),this.h()},l(e){const m=hd("svelte-u9bgzb",document.head);n=d(m,"META",{name:!0,content:!0}),m.forEach(i),y=r(e),o=d(e,"P",{}),v(o).forEach(i),s=r(e),g(T.$$.fragment,e),t=r(e),g(_.$$.fragment,e),Za=r(e),cn=d(e,"P",{"data-svelte-h":!0}),$(cn)!=="svelte-uyecg"&&(cn.textContent=Nm),Wa=r(e),g(un.$$.fragment,e),Ca=r(e),Z=d(e,"DIV",{class:!0});var F=v(Z);g(gn.$$.fragment,F),Ll=r(F),ro=d(F,"P",{"data-svelte-h":!0}),$(ro)!=="svelte-12yueui"&&(ro.textContent=Vm),Ol=r(F),io=d(F,"P",{"data-svelte-h":!0}),$(io)!=="svelte-zarm0s"&&(io.innerHTML=Xm),Ql=r(F),mo=d(F,"P",{"data-svelte-h":!0}),$(mo)!=="svelte-wz8va1"&&(mo.textContent=zm),Yl=r(F),po=d(F,"UL",{"data-svelte-h":!0}),$(po)!=="svelte-qpxha0"&&(po.innerHTML=Sm),Al=r(F),rt=d(F,"DIV",{class:!0});var Ys=v(rt);g(hn.$$.fragment,Ys),Pl=r(Ys),co=d(Ys,"P",{"data-svelte-h":!0}),$(co)!=="svelte-1r2xt0l"&&(co.innerHTML=Bm),Ys.forEach(i),Dl=r(F),W=d(F,"DIV",{class:!0});var I=v(W);g(fn.$$.fragment,I),Kl=r(I),uo=d(I,"P",{"data-svelte-h":!0}),$(uo)!=="svelte-18vxhwp"&&(uo.textContent=qm),er=r(I),go=d(I,"P",{"data-svelte-h":!0}),$(go)!=="svelte-1mrbn81"&&(go.innerHTML=Em),tr=r(I),ho=d(I,"BLOCKQUOTE",{"data-svelte-h":!0}),$(ho)!=="svelte-1uv5y3f"&&(ho.innerHTML=Hm),nr=r(I),fo=d(I,"P",{"data-svelte-h":!0}),$(fo)!=="svelte-vzi3zk"&&(fo.innerHTML=Lm),sr=r(I),Mo=d(I,"BLOCKQUOTE",{"data-svelte-h":!0}),$(Mo)!=="svelte-xq6lc5"&&(Mo.innerHTML=Om),or=r(I),bo=d(I,"P",{"data-svelte-h":!0}),$(bo)!=="svelte-111jrpf"&&(bo.innerHTML=Qm),I.forEach(i),F.forEach(i),Fa=r(e),g(Mn.$$.fragment,e),Ia=r(e),bn=d(e,"P",{"data-svelte-h":!0}),$(bn)!=="svelte-1tlroh"&&(bn.textContent=Ym),Ga=r(e),g(Tn.$$.fragment,e),Na=r(e),ee=d(e,"DIV",{class:!0});var Ie=v(ee);g(yn.$$.fragment,Ie),ar=r(Ie),To=d(Ie,"P",{"data-svelte-h":!0}),$(To)!=="svelte-3ve1fa"&&(To.innerHTML=Am),lr=r(Ie),yo=d(Ie,"P",{"data-svelte-h":!0}),$(yo)!=="svelte-1dzzafk"&&(yo.innerHTML=Pm),rr=r(Ie),B=d(Ie,"DIV",{class:!0});var ge=v(B);g(_n.$$.fragment,ge),ir=r(ge),_o=d(ge,"P",{"data-svelte-h":!0}),$(_o)!=="svelte-1ox9av6"&&(_o.innerHTML=Dm),mr=r(ge),g(it.$$.fragment,ge),pr=r(ge),g(mt.$$.fragment,ge),dr=r(ge),g(pt.$$.fragment,ge),ge.forEach(i),Ie.forEach(i),Va=r(e),g($n.$$.fragment,e),Xa=r(e),te=d(e,"DIV",{class:!0});var Ge=v(te);g(wn.$$.fragment,Ge),cr=r(Ge),$o=d(Ge,"P",{"data-svelte-h":!0}),$($o)!=="svelte-zm5njp"&&($o.innerHTML=Km),ur=r(Ge),wo=d(Ge,"P",{"data-svelte-h":!0}),$(wo)!=="svelte-1dzzafk"&&(wo.innerHTML=ep),gr=r(Ge),q=d(Ge,"DIV",{class:!0});var he=v(q);g(vn.$$.fragment,he),hr=r(he),vo=d(he,"P",{"data-svelte-h":!0}),$(vo)!=="svelte-1xqof9m"&&(vo.innerHTML=tp),fr=r(he),g(dt.$$.fragment,he),Mr=r(he),g(ct.$$.fragment,he),br=r(he),g(ut.$$.fragment,he),he.forEach(i),Ge.forEach(i),za=r(e),g(jn.$$.fragment,e),Sa=r(e),ne=d(e,"DIV",{class:!0});var Ne=v(ne);g(Jn.$$.fragment,Ne),Tr=r(Ne),jo=d(Ne,"P",{"data-svelte-h":!0}),$(jo)!=="svelte-1r520uu"&&(jo.innerHTML=np),yr=r(Ne),Jo=d(Ne,"P",{"data-svelte-h":!0}),$(Jo)!=="svelte-10uuk2l"&&(Jo.innerHTML=sp),_r=r(Ne),E=d(Ne,"DIV",{class:!0});var fe=v(E);g(kn.$$.fragment,fe),$r=r(fe),ko=d(fe,"P",{"data-svelte-h":!0}),$(ko)!=="svelte-n65k7h"&&(ko.innerHTML=op),wr=r(fe),g(gt.$$.fragment,fe),vr=r(fe),g(ht.$$.fragment,fe),jr=r(fe),g(ft.$$.fragment,fe),fe.forEach(i),Ne.forEach(i),Ba=r(e),g(xn.$$.fragment,e),qa=r(e),N=d(e,"DIV",{class:!0});var Me=v(N);g(Rn.$$.fragment,Me),Jr=r(Me),xo=d(Me,"P",{"data-svelte-h":!0}),$(xo)!=="svelte-1fcejq5"&&(xo.textContent=ap),kr=r(Me),Ro=d(Me,"P",{"data-svelte-h":!0}),$(Ro)!=="svelte-1dtx0v5"&&(Ro.innerHTML=lp),xr=r(Me),Uo=d(Me,"P",{"data-svelte-h":!0}),$(Uo)!=="svelte-1dzzafk"&&(Uo.innerHTML=rp),Rr=r(Me),G=d(Me,"DIV",{class:!0});var S=v(G);g(Un.$$.fragment,S),Ur=r(S),Zo=d(S,"P",{"data-svelte-h":!0}),$(Zo)!=="svelte-1plx9t"&&(Zo.innerHTML=ip),Zr=r(S),g(Mt.$$.fragment,S),Wr=r(S),g(bt.$$.fragment,S),Cr=r(S),g(Tt.$$.fragment,S),Fr=r(S),g(yt.$$.fragment,S),S.forEach(i),Me.forEach(i),Ea=r(e),g(Zn.$$.fragment,e),Ha=r(e),V=d(e,"DIV",{class:!0});var be=v(V);g(Wn.$$.fragment,be),Ir=r(be),Wo=d(be,"P",{"data-svelte-h":!0}),$(Wo)!=="svelte-1uwjkkt"&&(Wo.textContent=mp),Gr=r(be),Co=d(be,"P",{"data-svelte-h":!0}),$(Co)!=="svelte-1dtx0v5"&&(Co.innerHTML=pp),Nr=r(be),Fo=d(be,"P",{"data-svelte-h":!0}),$(Fo)!=="svelte-1dzzafk"&&(Fo.innerHTML=dp),Vr=r(be),H=d(be,"DIV",{class:!0});var Te=v(H);g(Cn.$$.fragment,Te),Xr=r(Te),Io=d(Te,"P",{"data-svelte-h":!0}),$(Io)!=="svelte-xk2xch"&&(Io.innerHTML=cp),zr=r(Te),g(_t.$$.fragment,Te),Sr=r(Te),g($t.$$.fragment,Te),Br=r(Te),g(wt.$$.fragment,Te),Te.forEach(i),be.forEach(i),La=r(e),g(Fn.$$.fragment,e),Oa=r(e),X=d(e,"DIV",{class:!0});var ye=v(X);g(In.$$.fragment,ye),qr=r(ye),Go=d(ye,"P",{"data-svelte-h":!0}),$(Go)!=="svelte-dcahwi"&&(Go.textContent=up),Er=r(ye),No=d(ye,"P",{"data-svelte-h":!0}),$(No)!=="svelte-1dtx0v5"&&(No.innerHTML=gp),Hr=r(ye),Vo=d(ye,"P",{"data-svelte-h":!0}),$(Vo)!=="svelte-1dzzafk"&&(Vo.innerHTML=hp),Lr=r(ye),Ue=d(ye,"DIV",{class:!0});var Ve=v(Ue);g(Gn.$$.fragment,Ve),Or=r(Ve),Xo=d(Ve,"P",{"data-svelte-h":!0}),$(Xo)!=="svelte-qesv8n"&&(Xo.innerHTML=fp),Qr=r(Ve),g(vt.$$.fragment,Ve),Yr=r(Ve),g(jt.$$.fragment,Ve),Ve.forEach(i),ye.forEach(i),Qa=r(e),g(Nn.$$.fragment,e),Ya=r(e),se=d(e,"DIV",{class:!0});var Xe=v(se);g(Vn.$$.fragment,Xe),Ar=r(Xe),zo=d(Xe,"P",{"data-svelte-h":!0}),$(zo)!=="svelte-qu1442"&&(zo.innerHTML=Mp),Pr=r(Xe),So=d(Xe,"P",{"data-svelte-h":!0}),$(So)!=="svelte-1dzzafk"&&(So.innerHTML=bp),Dr=r(Xe),L=d(Xe,"DIV",{class:!0});var _e=v(L);g(Xn.$$.fragment,_e),Kr=r(_e),Bo=d(_e,"P",{"data-svelte-h":!0}),$(Bo)!=="svelte-1dng7rw"&&(Bo.innerHTML=Tp),ei=r(_e),g(Jt.$$.fragment,_e),ti=r(_e),g(kt.$$.fragment,_e),ni=r(_e),g(xt.$$.fragment,_e),_e.forEach(i),Xe.forEach(i),Aa=r(e),g(zn.$$.fragment,e),Pa=r(e),Sn=d(e,"P",{"data-svelte-h":!0}),$(Sn)!=="svelte-1h2y3wu"&&(Sn.textContent=yp),Da=r(e),g(Bn.$$.fragment,e),Ka=r(e),oe=d(e,"DIV",{class:!0});var ze=v(oe);g(qn.$$.fragment,ze),si=r(ze),qo=d(ze,"P",{"data-svelte-h":!0}),$(qo)!=="svelte-1i7vo92"&&(qo.innerHTML=_p),oi=r(ze),Eo=d(ze,"P",{"data-svelte-h":!0}),$(Eo)!=="svelte-1dzzafk"&&(Eo.innerHTML=$p),ai=r(ze),O=d(ze,"DIV",{class:!0});var $e=v(O);g(En.$$.fragment,$e),li=r($e),Ho=d($e,"P",{"data-svelte-h":!0}),$(Ho)!=="svelte-1azuqx"&&(Ho.innerHTML=wp),ri=r($e),g(Rt.$$.fragment,$e),ii=r($e),g(Ut.$$.fragment,$e),mi=r($e),g(Zt.$$.fragment,$e),$e.forEach(i),ze.forEach(i),el=r(e),g(Hn.$$.fragment,e),tl=r(e),ae=d(e,"DIV",{class:!0});var Se=v(ae);g(Ln.$$.fragment,Se),pi=r(Se),Lo=d(Se,"P",{"data-svelte-h":!0}),$(Lo)!=="svelte-1kp8iw0"&&(Lo.innerHTML=vp),di=r(Se),Oo=d(Se,"P",{"data-svelte-h":!0}),$(Oo)!=="svelte-1dzzafk"&&(Oo.innerHTML=jp),ci=r(Se),Q=d(Se,"DIV",{class:!0});var we=v(Q);g(On.$$.fragment,we),ui=r(we),Qo=d(we,"P",{"data-svelte-h":!0}),$(Qo)!=="svelte-1s27jle"&&(Qo.innerHTML=Jp),gi=r(we),g(Wt.$$.fragment,we),hi=r(we),g(Ct.$$.fragment,we),fi=r(we),g(Ft.$$.fragment,we),we.forEach(i),Se.forEach(i),nl=r(e),g(Qn.$$.fragment,e),sl=r(e),Yn=d(e,"P",{"data-svelte-h":!0}),$(Yn)!=="svelte-liyjdz"&&(Yn.textContent=kp),ol=r(e),g(An.$$.fragment,e),al=r(e),z=d(e,"DIV",{class:!0});var ve=v(z);g(Pn.$$.fragment,ve),Mi=r(ve),Yo=d(ve,"P",{"data-svelte-h":!0}),$(Yo)!=="svelte-1uwrr47"&&(Yo.textContent=xp),bi=r(ve),Ao=d(ve,"P",{"data-svelte-h":!0}),$(Ao)!=="svelte-1dtx0v5"&&(Ao.innerHTML=Rp),Ti=r(ve),Po=d(ve,"P",{"data-svelte-h":!0}),$(Po)!=="svelte-1dzzafk"&&(Po.innerHTML=Up),yi=r(ve),Y=d(ve,"DIV",{class:!0});var je=v(Y);g(Dn.$$.fragment,je),_i=r(je),Do=d(je,"P",{"data-svelte-h":!0}),$(Do)!=="svelte-p67kxo"&&(Do.innerHTML=Zp),$i=r(je),g(It.$$.fragment,je),wi=r(je),g(Gt.$$.fragment,je),vi=r(je),g(Nt.$$.fragment,je),je.forEach(i),ve.forEach(i),ll=r(e),g(Kn.$$.fragment,e),rl=r(e),le=d(e,"DIV",{class:!0});var Be=v(le);g(es.$$.fragment,Be),ji=r(Be),Ko=d(Be,"P",{"data-svelte-h":!0}),$(Ko)!=="svelte-163uzqh"&&(Ko.innerHTML=Wp),Ji=r(Be),ea=d(Be,"P",{"data-svelte-h":!0}),$(ea)!=="svelte-1dzzafk"&&(ea.innerHTML=Cp),ki=r(Be),Ze=d(Be,"DIV",{class:!0});var qe=v(Ze);g(ts.$$.fragment,qe),xi=r(qe),ta=d(qe,"P",{"data-svelte-h":!0}),$(ta)!=="svelte-18aced7"&&(ta.innerHTML=Fp),Ri=r(qe),g(Vt.$$.fragment,qe),Ui=r(qe),g(Xt.$$.fragment,qe),qe.forEach(i),Be.forEach(i),il=r(e),g(ns.$$.fragment,e),ml=r(e),re=d(e,"DIV",{class:!0});var Ee=v(re);g(ss.$$.fragment,Ee),Zi=r(Ee),na=d(Ee,"P",{"data-svelte-h":!0}),$(na)!=="svelte-1n1niop"&&(na.innerHTML=Ip),Wi=r(Ee),sa=d(Ee,"P",{"data-svelte-h":!0}),$(sa)!=="svelte-1dzzafk"&&(sa.innerHTML=Gp),Ci=r(Ee),We=d(Ee,"DIV",{class:!0});var He=v(We);g(os.$$.fragment,He),Fi=r(He),oa=d(He,"P",{"data-svelte-h":!0}),$(oa)!=="svelte-1szjv6u"&&(oa.innerHTML=Np),Ii=r(He),g(zt.$$.fragment,He),Gi=r(He),g(St.$$.fragment,He),He.forEach(i),Ee.forEach(i),pl=r(e),g(as.$$.fragment,e),dl=r(e),ie=d(e,"DIV",{class:!0});var Le=v(ie);g(ls.$$.fragment,Le),Ni=r(Le),aa=d(Le,"P",{"data-svelte-h":!0}),$(aa)!=="svelte-1ermegf"&&(aa.innerHTML=Vp),Vi=r(Le),la=d(Le,"P",{"data-svelte-h":!0}),$(la)!=="svelte-10uuk2l"&&(la.innerHTML=Xp),Xi=r(Le),A=d(Le,"DIV",{class:!0});var Je=v(A);g(rs.$$.fragment,Je),zi=r(Je),ra=d(Je,"P",{"data-svelte-h":!0}),$(ra)!=="svelte-1e3zkhy"&&(ra.innerHTML=zp),Si=r(Je),g(Bt.$$.fragment,Je),Bi=r(Je),g(qt.$$.fragment,Je),qi=r(Je),g(Et.$$.fragment,Je),Je.forEach(i),Le.forEach(i),cl=r(e),g(is.$$.fragment,e),ul=r(e),me=d(e,"DIV",{class:!0});var Oe=v(me);g(ms.$$.fragment,Oe),Ei=r(Oe),ia=d(Oe,"P",{"data-svelte-h":!0}),$(ia)!=="svelte-aib78x"&&(ia.innerHTML=Sp),Hi=r(Oe),ma=d(Oe,"P",{"data-svelte-h":!0}),$(ma)!=="svelte-1dzzafk"&&(ma.innerHTML=Bp),Li=r(Oe),Ce=d(Oe,"DIV",{class:!0});var Qe=v(Ce);g(ps.$$.fragment,Qe),Oi=r(Qe),pa=d(Qe,"P",{"data-svelte-h":!0}),$(pa)!=="svelte-1fuxgrl"&&(pa.innerHTML=qp),Qi=r(Qe),g(Ht.$$.fragment,Qe),Yi=r(Qe),g(Lt.$$.fragment,Qe),Qe.forEach(i),Oe.forEach(i),gl=r(e),g(ds.$$.fragment,e),hl=r(e),cs=d(e,"P",{"data-svelte-h":!0}),$(cs)!=="svelte-1gk58z"&&(cs.textContent=Ep),fl=r(e),g(us.$$.fragment,e),Ml=r(e),pe=d(e,"DIV",{class:!0});var Ye=v(pe);g(gs.$$.fragment,Ye),Ai=r(Ye),da=d(Ye,"P",{"data-svelte-h":!0}),$(da)!=="svelte-1yey1ie"&&(da.innerHTML=Hp),Pi=r(Ye),ca=d(Ye,"P",{"data-svelte-h":!0}),$(ca)!=="svelte-10uuk2l"&&(ca.innerHTML=Lp),Di=r(Ye),P=d(Ye,"DIV",{class:!0});var ke=v(P);g(hs.$$.fragment,ke),Ki=r(ke),ua=d(ke,"P",{"data-svelte-h":!0}),$(ua)!=="svelte-11xalzp"&&(ua.innerHTML=Op),em=r(ke),g(Ot.$$.fragment,ke),tm=r(ke),g(Qt.$$.fragment,ke),nm=r(ke),g(Yt.$$.fragment,ke),ke.forEach(i),Ye.forEach(i),bl=r(e),g(fs.$$.fragment,e),Tl=r(e),de=d(e,"DIV",{class:!0});var Ae=v(de);g(Ms.$$.fragment,Ae),sm=r(Ae),ga=d(Ae,"P",{"data-svelte-h":!0}),$(ga)!=="svelte-1eubaty"&&(ga.innerHTML=Qp),om=r(Ae),ha=d(Ae,"P",{"data-svelte-h":!0}),$(ha)!=="svelte-10uuk2l"&&(ha.innerHTML=Yp),am=r(Ae),Fe=d(Ae,"DIV",{class:!0});var Pe=v(Fe);g(bs.$$.fragment,Pe),lm=r(Pe),fa=d(Pe,"P",{"data-svelte-h":!0}),$(fa)!=="svelte-eywb10"&&(fa.innerHTML=Ap),rm=r(Pe),g(At.$$.fragment,Pe),im=r(Pe),g(Pt.$$.fragment,Pe),Pe.forEach(i),Ae.forEach(i),yl=r(e),g(Ts.$$.fragment,e),_l=r(e),ys=d(e,"P",{"data-svelte-h":!0}),$(ys)!=="svelte-1n8n3ms"&&(ys.textContent=Pp),$l=r(e),g(_s.$$.fragment,e),wl=r(e),ce=d(e,"DIV",{class:!0});var De=v(ce);g($s.$$.fragment,De),mm=r(De),Ma=d(De,"P",{"data-svelte-h":!0}),$(Ma)!=="svelte-1aixd86"&&(Ma.innerHTML=Dp),pm=r(De),ba=d(De,"P",{"data-svelte-h":!0}),$(ba)!=="svelte-1dzzafk"&&(ba.innerHTML=Kp),dm=r(De),D=d(De,"DIV",{class:!0});var xe=v(D);g(ws.$$.fragment,xe),cm=r(xe),Ta=d(xe,"P",{"data-svelte-h":!0}),$(Ta)!=="svelte-1usnw5b"&&(Ta.innerHTML=ed),um=r(xe),g(Dt.$$.fragment,xe),gm=r(xe),g(Kt.$$.fragment,xe),hm=r(xe),g(en.$$.fragment,xe),xe.forEach(i),De.forEach(i),vl=r(e),g(vs.$$.fragment,e),jl=r(e),ue=d(e,"DIV",{class:!0});var Ke=v(ue);g(js.$$.fragment,Ke),fm=r(Ke),ya=d(Ke,"P",{"data-svelte-h":!0}),$(ya)!=="svelte-c8z7n1"&&(ya.innerHTML=td),Mm=r(Ke),_a=d(Ke,"P",{"data-svelte-h":!0}),$(_a)!=="svelte-1dzzafk"&&(_a.innerHTML=nd),bm=r(Ke),K=d(Ke,"DIV",{class:!0});var Re=v(K);g(Js.$$.fragment,Re),Tm=r(Re),$a=d(Re,"P",{"data-svelte-h":!0}),$($a)!=="svelte-iqwqsz"&&($a.innerHTML=sd),ym=r(Re),g(tn.$$.fragment,Re),_m=r(Re),g(nn.$$.fragment,Re),$m=r(Re),g(sn.$$.fragment,Re),Re.forEach(i),Ke.forEach(i),Jl=r(e),g(ks.$$.fragment,e),kl=r(e),g(xs.$$.fragment,e),xl=r(e),et=d(e,"DIV",{class:!0});var As=v(et);g(Rs.$$.fragment,As),wm=r(As),on=d(As,"DIV",{class:!0});var Ps=v(on);g(Us.$$.fragment,Ps),vm=r(Ps),wa=d(Ps,"P",{"data-svelte-h":!0}),$(wa)!=="svelte-1eed40t"&&(wa.textContent=od),Ps.forEach(i),As.forEach(i),Rl=r(e),g(Zs.$$.fragment,e),Ul=r(e),tt=d(e,"DIV",{class:!0});var Ds=v(tt);g(Ws.$$.fragment,Ds),jm=r(Ds),an=d(Ds,"DIV",{class:!0});var Ks=v(an);g(Cs.$$.fragment,Ks),Jm=r(Ks),va=d(Ks,"P",{"data-svelte-h":!0}),$(va)!=="svelte-1eed40t"&&(va.textContent=ad),Ks.forEach(i),Ds.forEach(i),Zl=r(e),g(Fs.$$.fragment,e),Wl=r(e),nt=d(e,"DIV",{class:!0});var eo=v(nt);g(Is.$$.fragment,eo),km=r(eo),ln=d(eo,"DIV",{class:!0});var to=v(ln);g(Gs.$$.fragment,to),xm=r(to),ja=d(to,"P",{"data-svelte-h":!0}),$(ja)!=="svelte-1eed40t"&&(ja.textContent=ld),to.forEach(i),eo.forEach(i),Cl=r(e),g(Ns.$$.fragment,e),Fl=r(e),st=d(e,"DIV",{class:!0});var no=v(st);g(Vs.$$.fragment,no),Rm=r(no),rn=d(no,"DIV",{class:!0});var so=v(rn);g(Xs.$$.fragment,so),Um=r(so),Ja=d(so,"P",{"data-svelte-h":!0}),$(Ja)!=="svelte-1eed40t"&&(Ja.textContent=rd),so.forEach(i),no.forEach(i),Il=r(e),g(zs.$$.fragment,e),Gl=r(e),ot=d(e,"DIV",{class:!0});var oo=v(ot);g(Ss.$$.fragment,oo),Zm=r(oo),mn=d(oo,"DIV",{class:!0});var ao=v(mn);g(Bs.$$.fragment,ao),Wm=r(ao),ka=d(ao,"P",{"data-svelte-h":!0}),$(ka)!=="svelte-1eed40t"&&(ka.textContent=id),ao.forEach(i),oo.forEach(i),Nl=r(e),g(qs.$$.fragment,e),Vl=r(e),at=d(e,"DIV",{class:!0});var lo=v(at);g(Es.$$.fragment,lo),Cm=r(lo),pn=d(lo,"DIV",{class:!0});var ql=v(pn);g(Hs.$$.fragment,ql),Fm=r(ql),xa=d(ql,"P",{"data-svelte-h":!0}),$(xa)!=="svelte-1eed40t"&&(xa.textContent=md),ql.forEach(i),lo.forEach(i),Xl=r(e),g(Ls.$$.fragment,e),zl=r(e),lt=d(e,"DIV",{class:!0});var El=v(lt);g(Os.$$.fragment,El),Im=r(El),dn=d(El,"DIV",{class:!0});var Hl=v(dn);g(Qs.$$.fragment,Hl),Gm=r(Hl),Ra=d(Hl,"P",{"data-svelte-h":!0}),$(Ra)!=="svelte-1eed40t"&&(Ra.textContent=pd),Hl.forEach(i),El.forEach(i),Sl=r(e),Ua=d(e,"P",{}),v(Ua).forEach(i),this.h()},h(){j(n,"name","hf:doc:metadata"),j(n,"content",uc),j(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,m){a(document.head,n),c(e,y,m),c(e,o,m),c(e,s,m),h(T,e,m),c(e,t,m),h(_,e,m),c(e,Za,m),c(e,cn,m),c(e,Wa,m),h(un,e,m),c(e,Ca,m),c(e,Z,m),h(gn,Z,null),a(Z,Ll),a(Z,ro),a(Z,Ol),a(Z,io),a(Z,Ql),a(Z,mo),a(Z,Yl),a(Z,po),a(Z,Al),a(Z,rt),h(hn,rt,null),a(rt,Pl),a(rt,co),a(Z,Dl),a(Z,W),h(fn,W,null),a(W,Kl),a(W,uo),a(W,er),a(W,go),a(W,tr),a(W,ho),a(W,nr),a(W,fo),a(W,sr),a(W,Mo),a(W,or),a(W,bo),c(e,Fa,m),h(Mn,e,m),c(e,Ia,m),c(e,bn,m),c(e,Ga,m),h(Tn,e,m),c(e,Na,m),c(e,ee,m),h(yn,ee,null),a(ee,ar),a(ee,To),a(ee,lr),a(ee,yo),a(ee,rr),a(ee,B),h(_n,B,null),a(B,ir),a(B,_o),a(B,mr),h(it,B,null),a(B,pr),h(mt,B,null),a(B,dr),h(pt,B,null),c(e,Va,m),h($n,e,m),c(e,Xa,m),c(e,te,m),h(wn,te,null),a(te,cr),a(te,$o),a(te,ur),a(te,wo),a(te,gr),a(te,q),h(vn,q,null),a(q,hr),a(q,vo),a(q,fr),h(dt,q,null),a(q,Mr),h(ct,q,null),a(q,br),h(ut,q,null),c(e,za,m),h(jn,e,m),c(e,Sa,m),c(e,ne,m),h(Jn,ne,null),a(ne,Tr),a(ne,jo),a(ne,yr),a(ne,Jo),a(ne,_r),a(ne,E),h(kn,E,null),a(E,$r),a(E,ko),a(E,wr),h(gt,E,null),a(E,vr),h(ht,E,null),a(E,jr),h(ft,E,null),c(e,Ba,m),h(xn,e,m),c(e,qa,m),c(e,N,m),h(Rn,N,null),a(N,Jr),a(N,xo),a(N,kr),a(N,Ro),a(N,xr),a(N,Uo),a(N,Rr),a(N,G),h(Un,G,null),a(G,Ur),a(G,Zo),a(G,Zr),h(Mt,G,null),a(G,Wr),h(bt,G,null),a(G,Cr),h(Tt,G,null),a(G,Fr),h(yt,G,null),c(e,Ea,m),h(Zn,e,m),c(e,Ha,m),c(e,V,m),h(Wn,V,null),a(V,Ir),a(V,Wo),a(V,Gr),a(V,Co),a(V,Nr),a(V,Fo),a(V,Vr),a(V,H),h(Cn,H,null),a(H,Xr),a(H,Io),a(H,zr),h(_t,H,null),a(H,Sr),h($t,H,null),a(H,Br),h(wt,H,null),c(e,La,m),h(Fn,e,m),c(e,Oa,m),c(e,X,m),h(In,X,null),a(X,qr),a(X,Go),a(X,Er),a(X,No),a(X,Hr),a(X,Vo),a(X,Lr),a(X,Ue),h(Gn,Ue,null),a(Ue,Or),a(Ue,Xo),a(Ue,Qr),h(vt,Ue,null),a(Ue,Yr),h(jt,Ue,null),c(e,Qa,m),h(Nn,e,m),c(e,Ya,m),c(e,se,m),h(Vn,se,null),a(se,Ar),a(se,zo),a(se,Pr),a(se,So),a(se,Dr),a(se,L),h(Xn,L,null),a(L,Kr),a(L,Bo),a(L,ei),h(Jt,L,null),a(L,ti),h(kt,L,null),a(L,ni),h(xt,L,null),c(e,Aa,m),h(zn,e,m),c(e,Pa,m),c(e,Sn,m),c(e,Da,m),h(Bn,e,m),c(e,Ka,m),c(e,oe,m),h(qn,oe,null),a(oe,si),a(oe,qo),a(oe,oi),a(oe,Eo),a(oe,ai),a(oe,O),h(En,O,null),a(O,li),a(O,Ho),a(O,ri),h(Rt,O,null),a(O,ii),h(Ut,O,null),a(O,mi),h(Zt,O,null),c(e,el,m),h(Hn,e,m),c(e,tl,m),c(e,ae,m),h(Ln,ae,null),a(ae,pi),a(ae,Lo),a(ae,di),a(ae,Oo),a(ae,ci),a(ae,Q),h(On,Q,null),a(Q,ui),a(Q,Qo),a(Q,gi),h(Wt,Q,null),a(Q,hi),h(Ct,Q,null),a(Q,fi),h(Ft,Q,null),c(e,nl,m),h(Qn,e,m),c(e,sl,m),c(e,Yn,m),c(e,ol,m),h(An,e,m),c(e,al,m),c(e,z,m),h(Pn,z,null),a(z,Mi),a(z,Yo),a(z,bi),a(z,Ao),a(z,Ti),a(z,Po),a(z,yi),a(z,Y),h(Dn,Y,null),a(Y,_i),a(Y,Do),a(Y,$i),h(It,Y,null),a(Y,wi),h(Gt,Y,null),a(Y,vi),h(Nt,Y,null),c(e,ll,m),h(Kn,e,m),c(e,rl,m),c(e,le,m),h(es,le,null),a(le,ji),a(le,Ko),a(le,Ji),a(le,ea),a(le,ki),a(le,Ze),h(ts,Ze,null),a(Ze,xi),a(Ze,ta),a(Ze,Ri),h(Vt,Ze,null),a(Ze,Ui),h(Xt,Ze,null),c(e,il,m),h(ns,e,m),c(e,ml,m),c(e,re,m),h(ss,re,null),a(re,Zi),a(re,na),a(re,Wi),a(re,sa),a(re,Ci),a(re,We),h(os,We,null),a(We,Fi),a(We,oa),a(We,Ii),h(zt,We,null),a(We,Gi),h(St,We,null),c(e,pl,m),h(as,e,m),c(e,dl,m),c(e,ie,m),h(ls,ie,null),a(ie,Ni),a(ie,aa),a(ie,Vi),a(ie,la),a(ie,Xi),a(ie,A),h(rs,A,null),a(A,zi),a(A,ra),a(A,Si),h(Bt,A,null),a(A,Bi),h(qt,A,null),a(A,qi),h(Et,A,null),c(e,cl,m),h(is,e,m),c(e,ul,m),c(e,me,m),h(ms,me,null),a(me,Ei),a(me,ia),a(me,Hi),a(me,ma),a(me,Li),a(me,Ce),h(ps,Ce,null),a(Ce,Oi),a(Ce,pa),a(Ce,Qi),h(Ht,Ce,null),a(Ce,Yi),h(Lt,Ce,null),c(e,gl,m),h(ds,e,m),c(e,hl,m),c(e,cs,m),c(e,fl,m),h(us,e,m),c(e,Ml,m),c(e,pe,m),h(gs,pe,null),a(pe,Ai),a(pe,da),a(pe,Pi),a(pe,ca),a(pe,Di),a(pe,P),h(hs,P,null),a(P,Ki),a(P,ua),a(P,em),h(Ot,P,null),a(P,tm),h(Qt,P,null),a(P,nm),h(Yt,P,null),c(e,bl,m),h(fs,e,m),c(e,Tl,m),c(e,de,m),h(Ms,de,null),a(de,sm),a(de,ga),a(de,om),a(de,ha),a(de,am),a(de,Fe),h(bs,Fe,null),a(Fe,lm),a(Fe,fa),a(Fe,rm),h(At,Fe,null),a(Fe,im),h(Pt,Fe,null),c(e,yl,m),h(Ts,e,m),c(e,_l,m),c(e,ys,m),c(e,$l,m),h(_s,e,m),c(e,wl,m),c(e,ce,m),h($s,ce,null),a(ce,mm),a(ce,Ma),a(ce,pm),a(ce,ba),a(ce,dm),a(ce,D),h(ws,D,null),a(D,cm),a(D,Ta),a(D,um),h(Dt,D,null),a(D,gm),h(Kt,D,null),a(D,hm),h(en,D,null),c(e,vl,m),h(vs,e,m),c(e,jl,m),c(e,ue,m),h(js,ue,null),a(ue,fm),a(ue,ya),a(ue,Mm),a(ue,_a),a(ue,bm),a(ue,K),h(Js,K,null),a(K,Tm),a(K,$a),a(K,ym),h(tn,K,null),a(K,_m),h(nn,K,null),a(K,$m),h(sn,K,null),c(e,Jl,m),h(ks,e,m),c(e,kl,m),h(xs,e,m),c(e,xl,m),c(e,et,m),h(Rs,et,null),a(et,wm),a(et,on),h(Us,on,null),a(on,vm),a(on,wa),c(e,Rl,m),h(Zs,e,m),c(e,Ul,m),c(e,tt,m),h(Ws,tt,null),a(tt,jm),a(tt,an),h(Cs,an,null),a(an,Jm),a(an,va),c(e,Zl,m),h(Fs,e,m),c(e,Wl,m),c(e,nt,m),h(Is,nt,null),a(nt,km),a(nt,ln),h(Gs,ln,null),a(ln,xm),a(ln,ja),c(e,Cl,m),h(Ns,e,m),c(e,Fl,m),c(e,st,m),h(Vs,st,null),a(st,Rm),a(st,rn),h(Xs,rn,null),a(rn,Um),a(rn,Ja),c(e,Il,m),h(zs,e,m),c(e,Gl,m),c(e,ot,m),h(Ss,ot,null),a(ot,Zm),a(ot,mn),h(Bs,mn,null),a(mn,Wm),a(mn,ka),c(e,Nl,m),h(qs,e,m),c(e,Vl,m),c(e,at,m),h(Es,at,null),a(at,Cm),a(at,pn),h(Hs,pn,null),a(pn,Fm),a(pn,xa),c(e,Xl,m),h(Ls,e,m),c(e,zl,m),c(e,lt,m),h(Os,lt,null),a(lt,Im),a(lt,dn),h(Qs,dn,null),a(dn,Gm),a(dn,Ra),c(e,Sl,m),c(e,Ua,m),Bl=!0},p(e,[m]){const F={};m&2&&(F.$$scope={dirty:m,ctx:e}),it.$set(F);const Ys={};m&2&&(Ys.$$scope={dirty:m,ctx:e}),mt.$set(Ys);const I={};m&2&&(I.$$scope={dirty:m,ctx:e}),pt.$set(I);const Ie={};m&2&&(Ie.$$scope={dirty:m,ctx:e}),dt.$set(Ie);const ge={};m&2&&(ge.$$scope={dirty:m,ctx:e}),ct.$set(ge);const Ge={};m&2&&(Ge.$$scope={dirty:m,ctx:e}),ut.$set(Ge);const he={};m&2&&(he.$$scope={dirty:m,ctx:e}),gt.$set(he);const Ne={};m&2&&(Ne.$$scope={dirty:m,ctx:e}),ht.$set(Ne);const fe={};m&2&&(fe.$$scope={dirty:m,ctx:e}),ft.$set(fe);const Me={};m&2&&(Me.$$scope={dirty:m,ctx:e}),Mt.$set(Me);const S={};m&2&&(S.$$scope={dirty:m,ctx:e}),bt.$set(S);const be={};m&2&&(be.$$scope={dirty:m,ctx:e}),Tt.$set(be);const Te={};m&2&&(Te.$$scope={dirty:m,ctx:e}),yt.$set(Te);const ye={};m&2&&(ye.$$scope={dirty:m,ctx:e}),_t.$set(ye);const Ve={};m&2&&(Ve.$$scope={dirty:m,ctx:e}),$t.$set(Ve);const Xe={};m&2&&(Xe.$$scope={dirty:m,ctx:e}),wt.$set(Xe);const _e={};m&2&&(_e.$$scope={dirty:m,ctx:e}),vt.$set(_e);const ze={};m&2&&(ze.$$scope={dirty:m,ctx:e}),jt.$set(ze);const $e={};m&2&&($e.$$scope={dirty:m,ctx:e}),Jt.$set($e);const Se={};m&2&&(Se.$$scope={dirty:m,ctx:e}),kt.$set(Se);const we={};m&2&&(we.$$scope={dirty:m,ctx:e}),xt.$set(we);const ve={};m&2&&(ve.$$scope={dirty:m,ctx:e}),Rt.$set(ve);const je={};m&2&&(je.$$scope={dirty:m,ctx:e}),Ut.$set(je);const Be={};m&2&&(Be.$$scope={dirty:m,ctx:e}),Zt.$set(Be);const qe={};m&2&&(qe.$$scope={dirty:m,ctx:e}),Wt.$set(qe);const Ee={};m&2&&(Ee.$$scope={dirty:m,ctx:e}),Ct.$set(Ee);const He={};m&2&&(He.$$scope={dirty:m,ctx:e}),Ft.$set(He);const Le={};m&2&&(Le.$$scope={dirty:m,ctx:e}),It.$set(Le);const Je={};m&2&&(Je.$$scope={dirty:m,ctx:e}),Gt.$set(Je);const Oe={};m&2&&(Oe.$$scope={dirty:m,ctx:e}),Nt.$set(Oe);const Qe={};m&2&&(Qe.$$scope={dirty:m,ctx:e}),Vt.$set(Qe);const Ye={};m&2&&(Ye.$$scope={dirty:m,ctx:e}),Xt.$set(Ye);const ke={};m&2&&(ke.$$scope={dirty:m,ctx:e}),zt.$set(ke);const Ae={};m&2&&(Ae.$$scope={dirty:m,ctx:e}),St.$set(Ae);const Pe={};m&2&&(Pe.$$scope={dirty:m,ctx:e}),Bt.$set(Pe);const De={};m&2&&(De.$$scope={dirty:m,ctx:e}),qt.$set(De);const xe={};m&2&&(xe.$$scope={dirty:m,ctx:e}),Et.$set(xe);const Ke={};m&2&&(Ke.$$scope={dirty:m,ctx:e}),Ht.$set(Ke);const Re={};m&2&&(Re.$$scope={dirty:m,ctx:e}),Lt.$set(Re);const As={};m&2&&(As.$$scope={dirty:m,ctx:e}),Ot.$set(As);const Ps={};m&2&&(Ps.$$scope={dirty:m,ctx:e}),Qt.$set(Ps);const Ds={};m&2&&(Ds.$$scope={dirty:m,ctx:e}),Yt.$set(Ds);const Ks={};m&2&&(Ks.$$scope={dirty:m,ctx:e}),At.$set(Ks);const eo={};m&2&&(eo.$$scope={dirty:m,ctx:e}),Pt.$set(eo);const to={};m&2&&(to.$$scope={dirty:m,ctx:e}),Dt.$set(to);const no={};m&2&&(no.$$scope={dirty:m,ctx:e}),Kt.$set(no);const so={};m&2&&(so.$$scope={dirty:m,ctx:e}),en.$set(so);const oo={};m&2&&(oo.$$scope={dirty:m,ctx:e}),tn.$set(oo);const ao={};m&2&&(ao.$$scope={dirty:m,ctx:e}),nn.$set(ao);const lo={};m&2&&(lo.$$scope={dirty:m,ctx:e}),sn.$set(lo)},i(e){Bl||(f(T.$$.fragment,e),f(_.$$.fragment,e),f(un.$$.fragment,e),f(gn.$$.fragment,e),f(hn.$$.fragment,e),f(fn.$$.fragment,e),f(Mn.$$.fragment,e),f(Tn.$$.fragment,e),f(yn.$$.fragment,e),f(_n.$$.fragment,e),f(it.$$.fragment,e),f(mt.$$.fragment,e),f(pt.$$.fragment,e),f($n.$$.fragment,e),f(wn.$$.fragment,e),f(vn.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(ut.$$.fragment,e),f(jn.$$.fragment,e),f(Jn.$$.fragment,e),f(kn.$$.fragment,e),f(gt.$$.fragment,e),f(ht.$$.fragment,e),f(ft.$$.fragment,e),f(xn.$$.fragment,e),f(Rn.$$.fragment,e),f(Un.$$.fragment,e),f(Mt.$$.fragment,e),f(bt.$$.fragment,e),f(Tt.$$.fragment,e),f(yt.$$.fragment,e),f(Zn.$$.fragment,e),f(Wn.$$.fragment,e),f(Cn.$$.fragment,e),f(_t.$$.fragment,e),f($t.$$.fragment,e),f(wt.$$.fragment,e),f(Fn.$$.fragment,e),f(In.$$.fragment,e),f(Gn.$$.fragment,e),f(vt.$$.fragment,e),f(jt.$$.fragment,e),f(Nn.$$.fragment,e),f(Vn.$$.fragment,e),f(Xn.$$.fragment,e),f(Jt.$$.fragment,e),f(kt.$$.fragment,e),f(xt.$$.fragment,e),f(zn.$$.fragment,e),f(Bn.$$.fragment,e),f(qn.$$.fragment,e),f(En.$$.fragment,e),f(Rt.$$.fragment,e),f(Ut.$$.fragment,e),f(Zt.$$.fragment,e),f(Hn.$$.fragment,e),f(Ln.$$.fragment,e),f(On.$$.fragment,e),f(Wt.$$.fragment,e),f(Ct.$$.fragment,e),f(Ft.$$.fragment,e),f(Qn.$$.fragment,e),f(An.$$.fragment,e),f(Pn.$$.fragment,e),f(Dn.$$.fragment,e),f(It.$$.fragment,e),f(Gt.$$.fragment,e),f(Nt.$$.fragment,e),f(Kn.$$.fragment,e),f(es.$$.fragment,e),f(ts.$$.fragment,e),f(Vt.$$.fragment,e),f(Xt.$$.fragment,e),f(ns.$$.fragment,e),f(ss.$$.fragment,e),f(os.$$.fragment,e),f(zt.$$.fragment,e),f(St.$$.fragment,e),f(as.$$.fragment,e),f(ls.$$.fragment,e),f(rs.$$.fragment,e),f(Bt.$$.fragment,e),f(qt.$$.fragment,e),f(Et.$$.fragment,e),f(is.$$.fragment,e),f(ms.$$.fragment,e),f(ps.$$.fragment,e),f(Ht.$$.fragment,e),f(Lt.$$.fragment,e),f(ds.$$.fragment,e),f(us.$$.fragment,e),f(gs.$$.fragment,e),f(hs.$$.fragment,e),f(Ot.$$.fragment,e),f(Qt.$$.fragment,e),f(Yt.$$.fragment,e),f(fs.$$.fragment,e),f(Ms.$$.fragment,e),f(bs.$$.fragment,e),f(At.$$.fragment,e),f(Pt.$$.fragment,e),f(Ts.$$.fragment,e),f(_s.$$.fragment,e),f($s.$$.fragment,e),f(ws.$$.fragment,e),f(Dt.$$.fragment,e),f(Kt.$$.fragment,e),f(en.$$.fragment,e),f(vs.$$.fragment,e),f(js.$$.fragment,e),f(Js.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(sn.$$.fragment,e),f(ks.$$.fragment,e),f(xs.$$.fragment,e),f(Rs.$$.fragment,e),f(Us.$$.fragment,e),f(Zs.$$.fragment,e),f(Ws.$$.fragment,e),f(Cs.$$.fragment,e),f(Fs.$$.fragment,e),f(Is.$$.fragment,e),f(Gs.$$.fragment,e),f(Ns.$$.fragment,e),f(Vs.$$.fragment,e),f(Xs.$$.fragment,e),f(zs.$$.fragment,e),f(Ss.$$.fragment,e),f(Bs.$$.fragment,e),f(qs.$$.fragment,e),f(Es.$$.fragment,e),f(Hs.$$.fragment,e),f(Ls.$$.fragment,e),f(Os.$$.fragment,e),f(Qs.$$.fragment,e),Bl=!0)},o(e){M(T.$$.fragment,e),M(_.$$.fragment,e),M(un.$$.fragment,e),M(gn.$$.fragment,e),M(hn.$$.fragment,e),M(fn.$$.fragment,e),M(Mn.$$.fragment,e),M(Tn.$$.fragment,e),M(yn.$$.fragment,e),M(_n.$$.fragment,e),M(it.$$.fragment,e),M(mt.$$.fragment,e),M(pt.$$.fragment,e),M($n.$$.fragment,e),M(wn.$$.fragment,e),M(vn.$$.fragment,e),M(dt.$$.fragment,e),M(ct.$$.fragment,e),M(ut.$$.fragment,e),M(jn.$$.fragment,e),M(Jn.$$.fragment,e),M(kn.$$.fragment,e),M(gt.$$.fragment,e),M(ht.$$.fragment,e),M(ft.$$.fragment,e),M(xn.$$.fragment,e),M(Rn.$$.fragment,e),M(Un.$$.fragment,e),M(Mt.$$.fragment,e),M(bt.$$.fragment,e),M(Tt.$$.fragment,e),M(yt.$$.fragment,e),M(Zn.$$.fragment,e),M(Wn.$$.fragment,e),M(Cn.$$.fragment,e),M(_t.$$.fragment,e),M($t.$$.fragment,e),M(wt.$$.fragment,e),M(Fn.$$.fragment,e),M(In.$$.fragment,e),M(Gn.$$.fragment,e),M(vt.$$.fragment,e),M(jt.$$.fragment,e),M(Nn.$$.fragment,e),M(Vn.$$.fragment,e),M(Xn.$$.fragment,e),M(Jt.$$.fragment,e),M(kt.$$.fragment,e),M(xt.$$.fragment,e),M(zn.$$.fragment,e),M(Bn.$$.fragment,e),M(qn.$$.fragment,e),M(En.$$.fragment,e),M(Rt.$$.fragment,e),M(Ut.$$.fragment,e),M(Zt.$$.fragment,e),M(Hn.$$.fragment,e),M(Ln.$$.fragment,e),M(On.$$.fragment,e),M(Wt.$$.fragment,e),M(Ct.$$.fragment,e),M(Ft.$$.fragment,e),M(Qn.$$.fragment,e),M(An.$$.fragment,e),M(Pn.$$.fragment,e),M(Dn.$$.fragment,e),M(It.$$.fragment,e),M(Gt.$$.fragment,e),M(Nt.$$.fragment,e),M(Kn.$$.fragment,e),M(es.$$.fragment,e),M(ts.$$.fragment,e),M(Vt.$$.fragment,e),M(Xt.$$.fragment,e),M(ns.$$.fragment,e),M(ss.$$.fragment,e),M(os.$$.fragment,e),M(zt.$$.fragment,e),M(St.$$.fragment,e),M(as.$$.fragment,e),M(ls.$$.fragment,e),M(rs.$$.fragment,e),M(Bt.$$.fragment,e),M(qt.$$.fragment,e),M(Et.$$.fragment,e),M(is.$$.fragment,e),M(ms.$$.fragment,e),M(ps.$$.fragment,e),M(Ht.$$.fragment,e),M(Lt.$$.fragment,e),M(ds.$$.fragment,e),M(us.$$.fragment,e),M(gs.$$.fragment,e),M(hs.$$.fragment,e),M(Ot.$$.fragment,e),M(Qt.$$.fragment,e),M(Yt.$$.fragment,e),M(fs.$$.fragment,e),M(Ms.$$.fragment,e),M(bs.$$.fragment,e),M(At.$$.fragment,e),M(Pt.$$.fragment,e),M(Ts.$$.fragment,e),M(_s.$$.fragment,e),M($s.$$.fragment,e),M(ws.$$.fragment,e),M(Dt.$$.fragment,e),M(Kt.$$.fragment,e),M(en.$$.fragment,e),M(vs.$$.fragment,e),M(js.$$.fragment,e),M(Js.$$.fragment,e),M(tn.$$.fragment,e),M(nn.$$.fragment,e),M(sn.$$.fragment,e),M(ks.$$.fragment,e),M(xs.$$.fragment,e),M(Rs.$$.fragment,e),M(Us.$$.fragment,e),M(Zs.$$.fragment,e),M(Ws.$$.fragment,e),M(Cs.$$.fragment,e),M(Fs.$$.fragment,e),M(Is.$$.fragment,e),M(Gs.$$.fragment,e),M(Ns.$$.fragment,e),M(Vs.$$.fragment,e),M(Xs.$$.fragment,e),M(zs.$$.fragment,e),M(Ss.$$.fragment,e),M(Bs.$$.fragment,e),M(qs.$$.fragment,e),M(Es.$$.fragment,e),M(Hs.$$.fragment,e),M(Ls.$$.fragment,e),M(Os.$$.fragment,e),M(Qs.$$.fragment,e),Bl=!1},d(e){e&&(i(y),i(o),i(s),i(t),i(Za),i(cn),i(Wa),i(Ca),i(Z),i(Fa),i(Ia),i(bn),i(Ga),i(Na),i(ee),i(Va),i(Xa),i(te),i(za),i(Sa),i(ne),i(Ba),i(qa),i(N),i(Ea),i(Ha),i(V),i(La),i(Oa),i(X),i(Qa),i(Ya),i(se),i(Aa),i(Pa),i(Sn),i(Da),i(Ka),i(oe),i(el),i(tl),i(ae),i(nl),i(sl),i(Yn),i(ol),i(al),i(z),i(ll),i(rl),i(le),i(il),i(ml),i(re),i(pl),i(dl),i(ie),i(cl),i(ul),i(me),i(gl),i(hl),i(cs),i(fl),i(Ml),i(pe),i(bl),i(Tl),i(de),i(yl),i(_l),i(ys),i($l),i(wl),i(ce),i(vl),i(jl),i(ue),i(Jl),i(kl),i(xl),i(et),i(Rl),i(Ul),i(tt),i(Zl),i(Wl),i(nt),i(Cl),i(Fl),i(st),i(Il),i(Gl),i(ot),i(Nl),i(Vl),i(at),i(Xl),i(zl),i(lt),i(Sl),i(Ua)),i(n),b(T,e),b(_,e),b(un,e),b(gn),b(hn),b(fn),b(Mn,e),b(Tn,e),b(yn),b(_n),b(it),b(mt),b(pt),b($n,e),b(wn),b(vn),b(dt),b(ct),b(ut),b(jn,e),b(Jn),b(kn),b(gt),b(ht),b(ft),b(xn,e),b(Rn),b(Un),b(Mt),b(bt),b(Tt),b(yt),b(Zn,e),b(Wn),b(Cn),b(_t),b($t),b(wt),b(Fn,e),b(In),b(Gn),b(vt),b(jt),b(Nn,e),b(Vn),b(Xn),b(Jt),b(kt),b(xt),b(zn,e),b(Bn,e),b(qn),b(En),b(Rt),b(Ut),b(Zt),b(Hn,e),b(Ln),b(On),b(Wt),b(Ct),b(Ft),b(Qn,e),b(An,e),b(Pn),b(Dn),b(It),b(Gt),b(Nt),b(Kn,e),b(es),b(ts),b(Vt),b(Xt),b(ns,e),b(ss),b(os),b(zt),b(St),b(as,e),b(ls),b(rs),b(Bt),b(qt),b(Et),b(is,e),b(ms),b(ps),b(Ht),b(Lt),b(ds,e),b(us,e),b(gs),b(hs),b(Ot),b(Qt),b(Yt),b(fs,e),b(Ms),b(bs),b(At),b(Pt),b(Ts,e),b(_s,e),b($s),b(ws),b(Dt),b(Kt),b(en),b(vs,e),b(js),b(Js),b(tn),b(nn),b(sn),b(ks,e),b(xs,e),b(Rs),b(Us),b(Zs,e),b(Ws),b(Cs),b(Fs,e),b(Is),b(Gs),b(Ns,e),b(Vs),b(Xs),b(zs,e),b(Ss),b(Bs),b(qs,e),b(Es),b(Hs),b(Ls,e),b(Os),b(Qs)}}}const uc='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function gc(w){return cd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $c extends ud{constructor(n){super(),gd(this,n,gc,cc,dd,{})}}export{$c as component};
