import{s as gh,n as Ph,o as Rh}from"../chunks/scheduler.0219f8bd.js";import{S as Uh,i as Eh,g as i,s,r as a,A as kh,h as d,f as l,c as n,j as h,u as m,x as r,k as u,y as jh,a as o,v as p,d as c,t as f,w as T}from"../chunks/index.f61edf3b.js";import{C as hc}from"../chunks/CodeBlock.38e566ae.js";import{H as _,E as Jh}from"../chunks/EditOnGithub.48fa589f.js";function Dh(_c){let $,dn,sn,rn,v,un,b,an,y,$c="Helper module for <code>Tensor</code> processing.",mn,M,vc=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,pn,x,bc='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, k)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',cn,fn,Tn,C,hn,H,_n,L,yc='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',$n,w,Mc='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',vn,bn,yn,A,Mn,z,xn,g,xc="Create a new Tensor or copy an existing Tensor.",Cn,P,Cc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Hn,Ln,wn,R,An,U,zn,E,Hc="Dimensions of the tensor.",gn,k,Lc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Pn,Rn,Un,j,En,J,kn,D,wc="Type of the tensor.",jn,q,Ac='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Jn,Dn,qn,I,In,K,Kn,B,zc="The data stored in the tensor.",Bn,N,gc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Nn,Vn,Qn,V,Sn,Q,On,S,Pc="The number of elements in the tensor.",Fn,O,Rc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Yn,Wn,Gn,F,Xn,Y,Zn,W,Uc="The location of the tensor data.",ei,G,Ec='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ti,li,oi,X,si,Z,ni,ee,kc=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,ii,te,jc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',di,ri,ui,le,ai,oe,mi,se,Jc="Index into a Tensor object.",pi,ne,Dc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',ci,ie,qc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",fi,Ti,hi,de,_i,re,$i,ue,Ic='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',vi,ae,Kc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",bi,yi,Mi,me,xi,pe,Ci,ce,Bc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Hi,fe,Nc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",Li,wi,Ai,Te,zi,he,gi,_e,Vc=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Pi,$e,Qc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',Ri,ve,Sc="<li><code>Error</code> If the tensor has more than one element.</li>",Ui,Ei,ki,be,ji,ye,Ji,Me,Oc="Convert tensor data to a n-dimensional JS list",Di,xe,Fc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',qi,Ii,Ki,Ce,Bi,He,Ni,Le,Yc="Return a new Tensor with the sigmoid function applied to each element.",Vi,we,Wc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Qi,Si,Oi,Ae,Fi,ze,Yi,ge,Gc="Applies the sigmoid function to the tensor in place.",Wi,Pe,Xc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Gi,Xi,Zi,Re,ed,Ue,td,Ee,Zc="Return a new Tensor with every element multiplied by a constant.",ld,ke,ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',od,je,tf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",sd,nd,id,Je,dd,De,rd,qe,lf="Multiply the tensor by a constant in place.",ud,Ie,of='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',ad,Ke,sf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",md,pd,cd,Be,fd,Ne,Td,Ve,nf="Return a new Tensor with every element divided by a constant.",hd,Qe,df='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',_d,Se,rf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",$d,vd,bd,Oe,yd,Fe,Md,Ye,uf="Divide the tensor by a constant in place.",xd,We,af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Cd,Ge,mf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",Hd,Ld,wd,Xe,Ad,Ze,zd,et,pf="Return a new Tensor with every element added by a constant.",gd,tt,cf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Pd,lt,ff="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Rd,Ud,Ed,ot,kd,st,jd,nt,Tf="Add the tensor by a constant in place.",Jd,it,hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Dd,dt,_f="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",qd,Id,Kd,rt,Bd,ut,Nd,at,$f="Return a new Tensor with every element subtracted by a constant.",Vd,mt,vf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Qd,pt,bf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",Sd,Od,Fd,ct,Yd,ft,Wd,Tt,yf="Subtract the tensor by a constant in place.",Gd,ht,Mf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Xd,_t,xf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",Zd,er,tr,$t,lr,vt,or,bt,Cf="Return a permuted version of this Tensor, according to the provided dimensions.",sr,yt,Hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',nr,Mt,Lf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",ir,dr,rr,xt,ur,Ct,ar,Ht,wf="Returns the sum of each row of the input tensor in the given dimension dim.",mr,Lt,Af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',pr,wt,zf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",cr,fr,Tr,At,hr,zt,_r,gt,gf="Returns the matrix norm or vector norm of a given tensor.",$r,Pt,Pf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',vr,Rt,Rf=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,br,yr,Mr,Ut,xr,Et,Cr,kt,Uf="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Hr,jt,Ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Lr,Jt,kf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",wr,Ar,zr,Dt,gr,qt,Pr,It,jf="Performs <code>L_p</code> normalization of inputs over specified dimension.",Rr,Kt,Jf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',Ur,Bt,Df="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Er,kr,jr,Nt,Jr,Vt,Dr,Qt,qf=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,qr,St,If='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',Ir,Kr,Br,Ot,Nr,Ft,Vr,Yt,Kf="Returns a tensor with all specified dimensions of input of size 1 removed.",Qr,Wt,Bf=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,Sr,Gt,Nf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The squeezed tensor',Or,Xt,Vf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",Fr,Yr,Wr,Zt,Gr,el,Xr,tl,Qf='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',Zr,ll,Sf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',eu,tu,lu,ol,ou,sl,su,nl,Of="Returns a new tensor with a dimension of size one inserted at the specified position.",nu,il,Ff="NOTE: The returned tensor shares the same underlying data with this tensor.",iu,dl,Yf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The unsqueezed tensor',du,rl,Wf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",ru,uu,au,ul,mu,al,pu,ml,Gf='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',cu,pl,Xf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',fu,Tu,hu,cl,_u,fl,$u,Tl,Zf='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',vu,hl,eT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',bu,yu,Mu,_l,xu,$l,Cu,vl,tT=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Hu,bl,lT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The flattened tensor.',Lu,yl,oT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",wu,Au,zu,Ml,gu,xl,Pu,Cl,sT="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Ru,Hl,nT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',Uu,Ll,iT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",Eu,ku,ju,wl,Ju,Al,Du,zl,dT='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',qu,gl,rT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Iu,Ku,Bu,Pl,Nu,Rl,Vu,Ul,uT="Clamps all elements in input into the range [ min, max ]",Qu,El,aT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',Su,kl,mT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",Ou,Fu,Yu,jl,Wu,Jl,Gu,Dl,pT='In-place version of @see <a href="Tensor.round">Tensor.round</a>',Xu,ql,cT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Zu,ea,ta,Il,la,Kl,oa,Bl,fT="Rounds elements of input to the nearest integer.",sa,Nl,TT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',na,ia,da,Vl,ra,Ql,ua,Sl,hT="Performs Tensor dtype conversion.",aa,Ol,_T='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',ma,Fl,$T='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',pa,ca,fa,Yl,Ta,Wl,ha,Gl,vT="Permutes a tensor according to the provided axes.",_a,Xl,bT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',$a,Zl,yT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",va,ba,ya,eo,Ma,to,xa,lo,MT="Interpolates an Tensor to the given size.",Ca,oo,xT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Ha,so,CT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",La,wa,Aa,no,za,io,ga,ro,HT=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,Pa,uo,LT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The interpolated tensor.',Ra,ao,wT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>",Ua,Ea,ka,mo,ja,po,Ja,co,AT=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,Da,fo,zT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The matrix product of the two tensors.',qa,To,gT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code>Tensor</code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code>Tensor</code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>",Ia,Ka,Ba,ho,Na,_o,Va,$o,PT=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,Qa,vo,RT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - the output tensor.',Sa,bo,UT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code>Tensor</code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>",Oa,Fa,Ya,yo,Wa,Mo,Ga,xo,ET=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,Xa,Co,kT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',Za,Ho,jT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the input tensor</p></td> </tr><tr><td>k</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>",em,tm,lm,Lo,om,wo,sm,Ao,JT="Perform mean pooling of the last hidden state followed by a normalization step.",nm,zo,DT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',im,go,qT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",dm,rm,um,Po,am,Ro,mm,Uo,IT="Apply Layer Normalization for last certain number of dimensions.",pm,Eo,KT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',cm,ko,BT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>",fm,Tm,hm,jo,_m,Jo,$m,Do,NT="Concatenates an array of tensors along a specified dimension.",vm,qo,VT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',bm,Io,QT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",ym,Mm,xm,Ko,Cm,Bo,Hm,No,ST="Stack an array of tensors along a specified dimension.",Lm,Vo,OT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',wm,Qo,FT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",Am,zm,gm,So,Pm,Oo,Rm,Fo,YT="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",Um,Yo,WT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',Em,Wo,GT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",km,jm,Jm,Go,Dm,Xo,qm,Zo,XT="Returns the mean value of each row of the input tensor in the given dimension dim.",Im,es,ZT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new tensor with means taken along the specified dimension.',Km,ts,eh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",Bm,Nm,Vm,ls,Qm,os,Sm,ss,th="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",Om,ns,lh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The filled tensor.',Fm,is,oh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",Ym,Wm,Gm,ds,Xm,rs,Zm,us,sh="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",ep,as,nh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',tp,ms,ih="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",lp,op,sp,ps,np,cs,ip,fs,dh="Returns a tensor filled with the scalar value 1, with the same size as input.",dp,Ts,rh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',rp,hs,uh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",up,ap,mp,_s,pp,$s,cp,vs,ah="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",fp,bs,mh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',Tp,ys,ph="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",hp,_p,$p,Ms,vp,xs,bp,Cs,ch="Returns a tensor filled with the scalar value 0, with the same size as input.",yp,Hs,fh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',Mp,Ls,Th="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",xp,Cp,Hp,ws,Lp,As,wp,zs,hh="Quantizes the embeddings tensor to binary or unsigned binary precision.",Ap,gs,_h='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The quantized tensor.',zp,Ps,$h="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>",gp,Pp,Rp,Rs,Up,Us,Ep,Es,vh='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',kp,jp,Jp,ks,Dp,js,qp,Js,bh="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",Ip,Ds,yh='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',Kp,qs,Mh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",Bp,Is,xh="<strong>Example</strong>",Np,Ks,Vp,Qp,Sp,Bs,Op,Ns,Fp,Vs,Ch='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',Yp,Wp,Gp,Qs,Xp,Ss,Zp,Os,Hh='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',ec,tc,lc,Fs,oc,Ys,sc,Ws,Lh="This creates a nested array of a given type and depth (see examples).",nc,Gs,wh='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',ic,Xs,dc,Zs,Ah="<strong>Example</strong>",rc,en,uc,tn,zh="<strong>Example</strong>",ac,ln,mc,pc,cc,on,fc,nn,Tc;return b=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),z=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),U=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),J=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),Q=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),oe=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),re=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),ye=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ze=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),Ue=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),st=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),ut=new _({props:{title:"tensor.sub(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),ft=new _({props:{title:"tensor.sub_(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),vt=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),zt=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),Et=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),qt=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Ft=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),el=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),sl=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),al=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),fl=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),$l=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),xl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),Al=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),Rl=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),Jl=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),Kl=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),Ql=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Wl=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),to=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),io=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),po=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),_o=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),Mo=new _({props:{title:"utils/tensor.topk(x, k) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),wo=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Ro=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),Jo=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Bo=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Oo=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),Xo=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),os=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),rs=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),cs=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),$s=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),xs=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),As=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),Us=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),js=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Ks=new hc({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),Ns=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),Ss=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Ys=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Xs=new hc({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),en=new hc({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),ln=new hc({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),on=new Jh({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=i("meta"),dn=s(),sn=i("p"),rn=s(),v=i("a"),un=s(),a(b.$$.fragment),an=s(),y=i("p"),y.innerHTML=$c,mn=s(),M=i("p"),M.textContent=vc,pn=s(),x=i("ul"),x.innerHTML=bc,cn=s(),fn=i("hr"),Tn=s(),C=i("a"),hn=s(),a(H.$$.fragment),_n=s(),L=i("p"),L.innerHTML=yc,$n=s(),w=i("ul"),w.innerHTML=Mc,vn=s(),bn=i("hr"),yn=s(),A=i("a"),Mn=s(),a(z.$$.fragment),xn=s(),g=i("p"),g.textContent=xc,Cn=s(),P=i("table"),P.innerHTML=Cc,Hn=s(),Ln=i("hr"),wn=s(),R=i("a"),An=s(),a(U.$$.fragment),zn=s(),E=i("p"),E.textContent=Hc,gn=s(),k=i("p"),k.innerHTML=Lc,Pn=s(),Rn=i("hr"),Un=s(),j=i("a"),En=s(),a(J.$$.fragment),kn=s(),D=i("p"),D.textContent=wc,jn=s(),q=i("p"),q.innerHTML=Ac,Jn=s(),Dn=i("hr"),qn=s(),I=i("a"),In=s(),a(K.$$.fragment),Kn=s(),B=i("p"),B.textContent=zc,Bn=s(),N=i("p"),N.innerHTML=gc,Nn=s(),Vn=i("hr"),Qn=s(),V=i("a"),Sn=s(),a(Q.$$.fragment),On=s(),S=i("p"),S.textContent=Pc,Fn=s(),O=i("p"),O.innerHTML=Rc,Yn=s(),Wn=i("hr"),Gn=s(),F=i("a"),Xn=s(),a(Y.$$.fragment),Zn=s(),W=i("p"),W.textContent=Uc,ei=s(),G=i("p"),G.innerHTML=Ec,ti=s(),li=i("hr"),oi=s(),X=i("a"),si=s(),a(Z.$$.fragment),ni=s(),ee=i("p"),ee.textContent=kc,ii=s(),te=i("p"),te.innerHTML=jc,di=s(),ri=i("hr"),ui=s(),le=i("a"),ai=s(),a(oe.$$.fragment),mi=s(),se=i("p"),se.textContent=Jc,pi=s(),ne=i("p"),ne.innerHTML=Dc,ci=s(),ie=i("table"),ie.innerHTML=qc,fi=s(),Ti=i("hr"),hi=s(),de=i("a"),_i=s(),a(re.$$.fragment),$i=s(),ue=i("p"),ue.innerHTML=Ic,vi=s(),ae=i("table"),ae.innerHTML=Kc,bi=s(),yi=i("hr"),Mi=s(),me=i("a"),xi=s(),a(pe.$$.fragment),Ci=s(),ce=i("p"),ce.innerHTML=Bc,Hi=s(),fe=i("table"),fe.innerHTML=Nc,Li=s(),wi=i("hr"),Ai=s(),Te=i("a"),zi=s(),a(he.$$.fragment),gi=s(),_e=i("p"),_e.innerHTML=Vc,Pi=s(),$e=i("p"),$e.innerHTML=Qc,Ri=s(),ve=i("ul"),ve.innerHTML=Sc,Ui=s(),Ei=i("hr"),ki=s(),be=i("a"),ji=s(),a(ye.$$.fragment),Ji=s(),Me=i("p"),Me.textContent=Oc,Di=s(),xe=i("p"),xe.innerHTML=Fc,qi=s(),Ii=i("hr"),Ki=s(),Ce=i("a"),Bi=s(),a(He.$$.fragment),Ni=s(),Le=i("p"),Le.textContent=Yc,Vi=s(),we=i("p"),we.innerHTML=Wc,Qi=s(),Si=i("hr"),Oi=s(),Ae=i("a"),Fi=s(),a(ze.$$.fragment),Yi=s(),ge=i("p"),ge.textContent=Gc,Wi=s(),Pe=i("p"),Pe.innerHTML=Xc,Gi=s(),Xi=i("hr"),Zi=s(),Re=i("a"),ed=s(),a(Ue.$$.fragment),td=s(),Ee=i("p"),Ee.textContent=Zc,ld=s(),ke=i("p"),ke.innerHTML=ef,od=s(),je=i("table"),je.innerHTML=tf,sd=s(),nd=i("hr"),id=s(),Je=i("a"),dd=s(),a(De.$$.fragment),rd=s(),qe=i("p"),qe.textContent=lf,ud=s(),Ie=i("p"),Ie.innerHTML=of,ad=s(),Ke=i("table"),Ke.innerHTML=sf,md=s(),pd=i("hr"),cd=s(),Be=i("a"),fd=s(),a(Ne.$$.fragment),Td=s(),Ve=i("p"),Ve.textContent=nf,hd=s(),Qe=i("p"),Qe.innerHTML=df,_d=s(),Se=i("table"),Se.innerHTML=rf,$d=s(),vd=i("hr"),bd=s(),Oe=i("a"),yd=s(),a(Fe.$$.fragment),Md=s(),Ye=i("p"),Ye.textContent=uf,xd=s(),We=i("p"),We.innerHTML=af,Cd=s(),Ge=i("table"),Ge.innerHTML=mf,Hd=s(),Ld=i("hr"),wd=s(),Xe=i("a"),Ad=s(),a(Ze.$$.fragment),zd=s(),et=i("p"),et.textContent=pf,gd=s(),tt=i("p"),tt.innerHTML=cf,Pd=s(),lt=i("table"),lt.innerHTML=ff,Rd=s(),Ud=i("hr"),Ed=s(),ot=i("a"),kd=s(),a(st.$$.fragment),jd=s(),nt=i("p"),nt.textContent=Tf,Jd=s(),it=i("p"),it.innerHTML=hf,Dd=s(),dt=i("table"),dt.innerHTML=_f,qd=s(),Id=i("hr"),Kd=s(),rt=i("a"),Bd=s(),a(ut.$$.fragment),Nd=s(),at=i("p"),at.textContent=$f,Vd=s(),mt=i("p"),mt.innerHTML=vf,Qd=s(),pt=i("table"),pt.innerHTML=bf,Sd=s(),Od=i("hr"),Fd=s(),ct=i("a"),Yd=s(),a(ft.$$.fragment),Wd=s(),Tt=i("p"),Tt.textContent=yf,Gd=s(),ht=i("p"),ht.innerHTML=Mf,Xd=s(),_t=i("table"),_t.innerHTML=xf,Zd=s(),er=i("hr"),tr=s(),$t=i("a"),lr=s(),a(vt.$$.fragment),or=s(),bt=i("p"),bt.textContent=Cf,sr=s(),yt=i("p"),yt.innerHTML=Hf,nr=s(),Mt=i("table"),Mt.innerHTML=Lf,ir=s(),dr=i("hr"),rr=s(),xt=i("a"),ur=s(),a(Ct.$$.fragment),ar=s(),Ht=i("p"),Ht.textContent=wf,mr=s(),Lt=i("p"),Lt.innerHTML=Af,pr=s(),wt=i("table"),wt.innerHTML=zf,cr=s(),fr=i("hr"),Tr=s(),At=i("a"),hr=s(),a(zt.$$.fragment),_r=s(),gt=i("p"),gt.textContent=gf,$r=s(),Pt=i("p"),Pt.innerHTML=Pf,vr=s(),Rt=i("table"),Rt.innerHTML=Rf,br=s(),yr=i("hr"),Mr=s(),Ut=i("a"),xr=s(),a(Et.$$.fragment),Cr=s(),kt=i("p"),kt.innerHTML=Uf,Hr=s(),jt=i("p"),jt.innerHTML=Ef,Lr=s(),Jt=i("table"),Jt.innerHTML=kf,wr=s(),Ar=i("hr"),zr=s(),Dt=i("a"),gr=s(),a(qt.$$.fragment),Pr=s(),It=i("p"),It.innerHTML=jf,Rr=s(),Kt=i("p"),Kt.innerHTML=Jf,Ur=s(),Bt=i("table"),Bt.innerHTML=Df,Er=s(),kr=i("hr"),jr=s(),Nt=i("a"),Jr=s(),a(Vt.$$.fragment),Dr=s(),Qt=i("p"),Qt.textContent=qf,qr=s(),St=i("p"),St.innerHTML=If,Ir=s(),Kr=i("hr"),Br=s(),Ot=i("a"),Nr=s(),a(Ft.$$.fragment),Vr=s(),Yt=i("p"),Yt.textContent=Kf,Qr=s(),Wt=i("p"),Wt.innerHTML=Bf,Sr=s(),Gt=i("p"),Gt.innerHTML=Nf,Or=s(),Xt=i("table"),Xt.innerHTML=Vf,Fr=s(),Yr=i("hr"),Wr=s(),Zt=i("a"),Gr=s(),a(el.$$.fragment),Xr=s(),tl=i("p"),tl.innerHTML=Qf,Zr=s(),ll=i("p"),ll.innerHTML=Sf,eu=s(),tu=i("hr"),lu=s(),ol=i("a"),ou=s(),a(sl.$$.fragment),su=s(),nl=i("p"),nl.textContent=Of,nu=s(),il=i("p"),il.textContent=Ff,iu=s(),dl=i("p"),dl.innerHTML=Yf,du=s(),rl=i("table"),rl.innerHTML=Wf,ru=s(),uu=i("hr"),au=s(),ul=i("a"),mu=s(),a(al.$$.fragment),pu=s(),ml=i("p"),ml.innerHTML=Gf,cu=s(),pl=i("p"),pl.innerHTML=Xf,fu=s(),Tu=i("hr"),hu=s(),cl=i("a"),_u=s(),a(fl.$$.fragment),$u=s(),Tl=i("p"),Tl.innerHTML=Zf,vu=s(),hl=i("p"),hl.innerHTML=eT,bu=s(),yu=i("hr"),Mu=s(),_l=i("a"),xu=s(),a($l.$$.fragment),Cu=s(),vl=i("p"),vl.innerHTML=tT,Hu=s(),bl=i("p"),bl.innerHTML=lT,Lu=s(),yl=i("table"),yl.innerHTML=oT,wu=s(),Au=i("hr"),zu=s(),Ml=i("a"),gu=s(),a(xl.$$.fragment),Pu=s(),Cl=i("p"),Cl.innerHTML=sT,Ru=s(),Hl=i("p"),Hl.innerHTML=nT,Uu=s(),Ll=i("table"),Ll.innerHTML=iT,Eu=s(),ku=i("hr"),ju=s(),wl=i("a"),Ju=s(),a(Al.$$.fragment),Du=s(),zl=i("p"),zl.innerHTML=dT,qu=s(),gl=i("p"),gl.innerHTML=rT,Iu=s(),Ku=i("hr"),Bu=s(),Pl=i("a"),Nu=s(),a(Rl.$$.fragment),Vu=s(),Ul=i("p"),Ul.textContent=uT,Qu=s(),El=i("p"),El.innerHTML=aT,Su=s(),kl=i("table"),kl.innerHTML=mT,Ou=s(),Fu=i("hr"),Yu=s(),jl=i("a"),Wu=s(),a(Jl.$$.fragment),Gu=s(),Dl=i("p"),Dl.innerHTML=pT,Xu=s(),ql=i("p"),ql.innerHTML=cT,Zu=s(),ea=i("hr"),ta=s(),Il=i("a"),la=s(),a(Kl.$$.fragment),oa=s(),Bl=i("p"),Bl.textContent=fT,sa=s(),Nl=i("p"),Nl.innerHTML=TT,na=s(),ia=i("hr"),da=s(),Vl=i("a"),ra=s(),a(Ql.$$.fragment),ua=s(),Sl=i("p"),Sl.textContent=hT,aa=s(),Ol=i("p"),Ol.innerHTML=_T,ma=s(),Fl=i("table"),Fl.innerHTML=$T,pa=s(),ca=i("hr"),fa=s(),Yl=i("a"),Ta=s(),a(Wl.$$.fragment),ha=s(),Gl=i("p"),Gl.textContent=vT,_a=s(),Xl=i("p"),Xl.innerHTML=bT,$a=s(),Zl=i("table"),Zl.innerHTML=yT,va=s(),ba=i("hr"),ya=s(),eo=i("a"),Ma=s(),a(to.$$.fragment),xa=s(),lo=i("p"),lo.textContent=MT,Ca=s(),oo=i("p"),oo.innerHTML=xT,Ha=s(),so=i("table"),so.innerHTML=CT,La=s(),wa=i("hr"),Aa=s(),no=i("a"),za=s(),a(io.$$.fragment),ga=s(),ro=i("p"),ro.innerHTML=HT,Pa=s(),uo=i("p"),uo.innerHTML=LT,Ra=s(),ao=i("table"),ao.innerHTML=wT,Ua=s(),Ea=i("hr"),ka=s(),mo=i("a"),ja=s(),a(po.$$.fragment),Ja=s(),co=i("p"),co.innerHTML=AT,Da=s(),fo=i("p"),fo.innerHTML=zT,qa=s(),To=i("table"),To.innerHTML=gT,Ia=s(),Ka=i("hr"),Ba=s(),ho=i("a"),Na=s(),a(_o.$$.fragment),Va=s(),$o=i("p"),$o.innerHTML=PT,Qa=s(),vo=i("p"),vo.innerHTML=RT,Sa=s(),bo=i("table"),bo.innerHTML=UT,Oa=s(),Fa=i("hr"),Ya=s(),yo=i("a"),Wa=s(),a(Mo.$$.fragment),Ga=s(),xo=i("p"),xo.innerHTML=ET,Xa=s(),Co=i("p"),Co.innerHTML=kT,Za=s(),Ho=i("table"),Ho.innerHTML=jT,em=s(),tm=i("hr"),lm=s(),Lo=i("a"),om=s(),a(wo.$$.fragment),sm=s(),Ao=i("p"),Ao.textContent=JT,nm=s(),zo=i("p"),zo.innerHTML=DT,im=s(),go=i("table"),go.innerHTML=qT,dm=s(),rm=i("hr"),um=s(),Po=i("a"),am=s(),a(Ro.$$.fragment),mm=s(),Uo=i("p"),Uo.textContent=IT,pm=s(),Eo=i("p"),Eo.innerHTML=KT,cm=s(),ko=i("table"),ko.innerHTML=BT,fm=s(),Tm=i("hr"),hm=s(),jo=i("a"),_m=s(),a(Jo.$$.fragment),$m=s(),Do=i("p"),Do.textContent=NT,vm=s(),qo=i("p"),qo.innerHTML=VT,bm=s(),Io=i("table"),Io.innerHTML=QT,ym=s(),Mm=i("hr"),xm=s(),Ko=i("a"),Cm=s(),a(Bo.$$.fragment),Hm=s(),No=i("p"),No.textContent=ST,Lm=s(),Vo=i("p"),Vo.innerHTML=OT,wm=s(),Qo=i("table"),Qo.innerHTML=FT,Am=s(),zm=i("hr"),gm=s(),So=i("a"),Pm=s(),a(Oo.$$.fragment),Rm=s(),Fo=i("p"),Fo.innerHTML=YT,Um=s(),Yo=i("p"),Yo.innerHTML=WT,Em=s(),Wo=i("table"),Wo.innerHTML=GT,km=s(),jm=i("hr"),Jm=s(),Go=i("a"),Dm=s(),a(Xo.$$.fragment),qm=s(),Zo=i("p"),Zo.textContent=XT,Im=s(),es=i("p"),es.innerHTML=ZT,Km=s(),ts=i("table"),ts.innerHTML=eh,Bm=s(),Nm=i("hr"),Vm=s(),ls=i("a"),Qm=s(),a(os.$$.fragment),Sm=s(),ss=i("p"),ss.textContent=th,Om=s(),ns=i("p"),ns.innerHTML=lh,Fm=s(),is=i("table"),is.innerHTML=oh,Ym=s(),Wm=i("hr"),Gm=s(),ds=i("a"),Xm=s(),a(rs.$$.fragment),Zm=s(),us=i("p"),us.textContent=sh,ep=s(),as=i("p"),as.innerHTML=nh,tp=s(),ms=i("table"),ms.innerHTML=ih,lp=s(),op=i("hr"),sp=s(),ps=i("a"),np=s(),a(cs.$$.fragment),ip=s(),fs=i("p"),fs.textContent=dh,dp=s(),Ts=i("p"),Ts.innerHTML=rh,rp=s(),hs=i("table"),hs.innerHTML=uh,up=s(),ap=i("hr"),mp=s(),_s=i("a"),pp=s(),a($s.$$.fragment),cp=s(),vs=i("p"),vs.textContent=ah,fp=s(),bs=i("p"),bs.innerHTML=mh,Tp=s(),ys=i("table"),ys.innerHTML=ph,hp=s(),_p=i("hr"),$p=s(),Ms=i("a"),vp=s(),a(xs.$$.fragment),bp=s(),Cs=i("p"),Cs.textContent=ch,yp=s(),Hs=i("p"),Hs.innerHTML=fh,Mp=s(),Ls=i("table"),Ls.innerHTML=Th,xp=s(),Cp=i("hr"),Hp=s(),ws=i("a"),Lp=s(),a(As.$$.fragment),wp=s(),zs=i("p"),zs.textContent=hh,Ap=s(),gs=i("p"),gs.innerHTML=_h,zp=s(),Ps=i("table"),Ps.innerHTML=$h,gp=s(),Pp=i("hr"),Rp=s(),Rs=i("a"),Up=s(),a(Us.$$.fragment),Ep=s(),Es=i("p"),Es.innerHTML=vh,kp=s(),jp=i("hr"),Jp=s(),ks=i("a"),Dp=s(),a(js.$$.fragment),qp=s(),Js=i("p"),Js.textContent=bh,Ip=s(),Ds=i("p"),Ds.innerHTML=yh,Kp=s(),qs=i("table"),qs.innerHTML=Mh,Bp=s(),Is=i("p"),Is.innerHTML=xh,Np=s(),a(Ks.$$.fragment),Vp=s(),Qp=i("hr"),Sp=s(),Bs=i("a"),Op=s(),a(Ns.$$.fragment),Fp=s(),Vs=i("p"),Vs.innerHTML=Ch,Yp=s(),Wp=i("hr"),Gp=s(),Qs=i("a"),Xp=s(),a(Ss.$$.fragment),Zp=s(),Os=i("p"),Os.innerHTML=Hh,ec=s(),tc=i("hr"),lc=s(),Fs=i("a"),oc=s(),a(Ys.$$.fragment),sc=s(),Ws=i("p"),Ws.textContent=Lh,nc=s(),Gs=i("p"),Gs.innerHTML=wh,ic=s(),a(Xs.$$.fragment),dc=s(),Zs=i("p"),Zs.innerHTML=Ah,rc=s(),a(en.$$.fragment),uc=s(),tn=i("p"),tn.innerHTML=zh,ac=s(),a(ln.$$.fragment),mc=s(),pc=i("hr"),cc=s(),a(on.$$.fragment),fc=s(),nn=i("p"),this.h()},l(e){const t=kh("svelte-u9bgzb",document.head);$=d(t,"META",{name:!0,content:!0}),t.forEach(l),dn=n(e),sn=d(e,"P",{}),h(sn).forEach(l),rn=n(e),v=d(e,"A",{id:!0,class:!0}),h(v).forEach(l),un=n(e),m(b.$$.fragment,e),an=n(e),y=d(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-uw4y1m"&&(y.innerHTML=$c),mn=n(e),M=d(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-il3kl8"&&(M.textContent=vc),pn=n(e),x=d(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-mri3hp"&&(x.innerHTML=bc),cn=n(e),fn=d(e,"HR",{}),Tn=n(e),C=d(e,"A",{id:!0,class:!0}),h(C).forEach(l),hn=n(e),m(H.$$.fragment,e),_n=n(e),L=d(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ugrfrw"&&(L.innerHTML=yc),$n=n(e),w=d(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-jyrd06"&&(w.innerHTML=Mc),vn=n(e),bn=d(e,"HR",{}),yn=n(e),A=d(e,"A",{id:!0,class:!0}),h(A).forEach(l),Mn=n(e),m(z.$$.fragment,e),xn=n(e),g=d(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-55wecd"&&(g.textContent=xc),Cn=n(e),P=d(e,"TABLE",{"data-svelte-h":!0}),r(P)!=="svelte-ee7emz"&&(P.innerHTML=Cc),Hn=n(e),Ln=d(e,"HR",{}),wn=n(e),R=d(e,"A",{id:!0,class:!0}),h(R).forEach(l),An=n(e),m(U.$$.fragment,e),zn=n(e),E=d(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1gc2rt4"&&(E.textContent=Hc),gn=n(e),k=d(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-10qzguj"&&(k.innerHTML=Lc),Pn=n(e),Rn=d(e,"HR",{}),Un=n(e),j=d(e,"A",{id:!0,class:!0}),h(j).forEach(l),En=n(e),m(J.$$.fragment,e),kn=n(e),D=d(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-81y0bb"&&(D.textContent=wc),jn=n(e),q=d(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-10qzguj"&&(q.innerHTML=Ac),Jn=n(e),Dn=d(e,"HR",{}),qn=n(e),I=d(e,"A",{id:!0,class:!0}),h(I).forEach(l),In=n(e),m(K.$$.fragment,e),Kn=n(e),B=d(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1eqabt7"&&(B.textContent=zc),Bn=n(e),N=d(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-10qzguj"&&(N.innerHTML=gc),Nn=n(e),Vn=d(e,"HR",{}),Qn=n(e),V=d(e,"A",{id:!0,class:!0}),h(V).forEach(l),Sn=n(e),m(Q.$$.fragment,e),On=n(e),S=d(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-krrt97"&&(S.textContent=Pc),Fn=n(e),O=d(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-10qzguj"&&(O.innerHTML=Rc),Yn=n(e),Wn=d(e,"HR",{}),Gn=n(e),F=d(e,"A",{id:!0,class:!0}),h(F).forEach(l),Xn=n(e),m(Y.$$.fragment,e),Zn=n(e),W=d(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1iaptgl"&&(W.textContent=Uc),ei=n(e),G=d(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-10qzguj"&&(G.innerHTML=Ec),ti=n(e),li=d(e,"HR",{}),oi=n(e),X=d(e,"A",{id:!0,class:!0}),h(X).forEach(l),si=n(e),m(Z.$$.fragment,e),ni=n(e),ee=d(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1adn56z"&&(ee.textContent=kc),ii=n(e),te=d(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1gxgvk6"&&(te.innerHTML=jc),di=n(e),ri=d(e,"HR",{}),ui=n(e),le=d(e,"A",{id:!0,class:!0}),h(le).forEach(l),ai=n(e),m(oe.$$.fragment,e),mi=n(e),se=d(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1u97xg1"&&(se.textContent=Jc),pi=n(e),ne=d(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1afa2dz"&&(ne.innerHTML=Dc),ci=n(e),ie=d(e,"TABLE",{"data-svelte-h":!0}),r(ie)!=="svelte-1kq04ga"&&(ie.innerHTML=qc),fi=n(e),Ti=d(e,"HR",{}),hi=n(e),de=d(e,"A",{id:!0,class:!0}),h(de).forEach(l),_i=n(e),m(re.$$.fragment,e),$i=n(e),ue=d(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1cg22af"&&(ue.innerHTML=Ic),vi=n(e),ae=d(e,"TABLE",{"data-svelte-h":!0}),r(ae)!=="svelte-1hful42"&&(ae.innerHTML=Kc),bi=n(e),yi=d(e,"HR",{}),Mi=n(e),me=d(e,"A",{id:!0,class:!0}),h(me).forEach(l),xi=n(e),m(pe.$$.fragment,e),Ci=n(e),ce=d(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=Bc),Hi=n(e),fe=d(e,"TABLE",{"data-svelte-h":!0}),r(fe)!=="svelte-153ftfy"&&(fe.innerHTML=Nc),Li=n(e),wi=d(e,"HR",{}),Ai=n(e),Te=d(e,"A",{id:!0,class:!0}),h(Te).forEach(l),zi=n(e),m(he.$$.fragment,e),gi=n(e),_e=d(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=Vc),Pi=n(e),$e=d(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-11rv1mu"&&($e.innerHTML=Qc),Ri=n(e),ve=d(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-5t2sg3"&&(ve.innerHTML=Sc),Ui=n(e),Ei=d(e,"HR",{}),ki=n(e),be=d(e,"A",{id:!0,class:!0}),h(be).forEach(l),ji=n(e),m(ye.$$.fragment,e),Ji=n(e),Me=d(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-87xdyr"&&(Me.textContent=Oc),Di=n(e),xe=d(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=Fc),qi=n(e),Ii=d(e,"HR",{}),Ki=n(e),Ce=d(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Bi=n(e),m(He.$$.fragment,e),Ni=n(e),Le=d(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-2wti2w"&&(Le.textContent=Yc),Vi=n(e),we=d(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-kpq7mo"&&(we.innerHTML=Wc),Qi=n(e),Si=d(e,"HR",{}),Oi=n(e),Ae=d(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),Fi=n(e),m(ze.$$.fragment,e),Yi=n(e),ge=d(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1edu6c8"&&(ge.textContent=Gc),Wi=n(e),Pe=d(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1hc4oxa"&&(Pe.innerHTML=Xc),Gi=n(e),Xi=d(e,"HR",{}),Zi=n(e),Re=d(e,"A",{id:!0,class:!0}),h(Re).forEach(l),ed=n(e),m(Ue.$$.fragment,e),td=n(e),Ee=d(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-xg80lg"&&(Ee.textContent=Zc),ld=n(e),ke=d(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1aygav2"&&(ke.innerHTML=ef),od=n(e),je=d(e,"TABLE",{"data-svelte-h":!0}),r(je)!=="svelte-1tbtmqd"&&(je.innerHTML=tf),sd=n(e),nd=d(e,"HR",{}),id=n(e),Je=d(e,"A",{id:!0,class:!0}),h(Je).forEach(l),dd=n(e),m(De.$$.fragment,e),rd=n(e),qe=d(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1i12x1s"&&(qe.textContent=lf),ud=n(e),Ie=d(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1hc4oxa"&&(Ie.innerHTML=of),ad=n(e),Ke=d(e,"TABLE",{"data-svelte-h":!0}),r(Ke)!=="svelte-1tbtmqd"&&(Ke.innerHTML=sf),md=n(e),pd=d(e,"HR",{}),cd=n(e),Be=d(e,"A",{id:!0,class:!0}),h(Be).forEach(l),fd=n(e),m(Ne.$$.fragment,e),Td=n(e),Ve=d(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-45kvaw"&&(Ve.textContent=nf),hd=n(e),Qe=d(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1aygav2"&&(Qe.innerHTML=df),_d=n(e),Se=d(e,"TABLE",{"data-svelte-h":!0}),r(Se)!=="svelte-46t58i"&&(Se.innerHTML=rf),$d=n(e),vd=d(e,"HR",{}),bd=n(e),Oe=d(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),yd=n(e),m(Fe.$$.fragment,e),Md=n(e),Ye=d(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-6s524n"&&(Ye.textContent=uf),xd=n(e),We=d(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1hc4oxa"&&(We.innerHTML=af),Cd=n(e),Ge=d(e,"TABLE",{"data-svelte-h":!0}),r(Ge)!=="svelte-46t58i"&&(Ge.innerHTML=mf),Hd=n(e),Ld=d(e,"HR",{}),wd=n(e),Xe=d(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),Ad=n(e),m(Ze.$$.fragment,e),zd=n(e),et=d(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1hl64jn"&&(et.textContent=pf),gd=n(e),tt=d(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1aygav2"&&(tt.innerHTML=cf),Pd=n(e),lt=d(e,"TABLE",{"data-svelte-h":!0}),r(lt)!=="svelte-1p5444"&&(lt.innerHTML=ff),Rd=n(e),Ud=d(e,"HR",{}),Ed=n(e),ot=d(e,"A",{id:!0,class:!0}),h(ot).forEach(l),kd=n(e),m(st.$$.fragment,e),jd=n(e),nt=d(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-bbf4x3"&&(nt.textContent=Tf),Jd=n(e),it=d(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1hc4oxa"&&(it.innerHTML=hf),Dd=n(e),dt=d(e,"TABLE",{"data-svelte-h":!0}),r(dt)!=="svelte-1p5444"&&(dt.innerHTML=_f),qd=n(e),Id=d(e,"HR",{}),Kd=n(e),rt=d(e,"A",{id:!0,class:!0}),h(rt).forEach(l),Bd=n(e),m(ut.$$.fragment,e),Nd=n(e),at=d(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-wbrx6g"&&(at.textContent=$f),Vd=n(e),mt=d(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1aygav2"&&(mt.innerHTML=vf),Qd=n(e),pt=d(e,"TABLE",{"data-svelte-h":!0}),r(pt)!=="svelte-flm2g1"&&(pt.innerHTML=bf),Sd=n(e),Od=d(e,"HR",{}),Fd=n(e),ct=d(e,"A",{id:!0,class:!0}),h(ct).forEach(l),Yd=n(e),m(ft.$$.fragment,e),Wd=n(e),Tt=d(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-wqxtec"&&(Tt.textContent=yf),Gd=n(e),ht=d(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1hc4oxa"&&(ht.innerHTML=Mf),Xd=n(e),_t=d(e,"TABLE",{"data-svelte-h":!0}),r(_t)!=="svelte-flm2g1"&&(_t.innerHTML=xf),Zd=n(e),er=d(e,"HR",{}),tr=n(e),$t=d(e,"A",{id:!0,class:!0}),h($t).forEach(l),lr=n(e),m(vt.$$.fragment,e),or=n(e),bt=d(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1g8ouql"&&(bt.textContent=Cf),sr=n(e),yt=d(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1scc4l4"&&(yt.innerHTML=Hf),nr=n(e),Mt=d(e,"TABLE",{"data-svelte-h":!0}),r(Mt)!=="svelte-1p49qvp"&&(Mt.innerHTML=Lf),ir=n(e),dr=d(e,"HR",{}),rr=n(e),xt=d(e,"A",{id:!0,class:!0}),h(xt).forEach(l),ur=n(e),m(Ct.$$.fragment,e),ar=n(e),Ht=d(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-yjryb1"&&(Ht.textContent=wf),mr=n(e),Lt=d(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-xtr8tc"&&(Lt.innerHTML=Af),pr=n(e),wt=d(e,"TABLE",{"data-svelte-h":!0}),r(wt)!=="svelte-6xvdso"&&(wt.innerHTML=zf),cr=n(e),fr=d(e,"HR",{}),Tr=n(e),At=d(e,"A",{id:!0,class:!0}),h(At).forEach(l),hr=n(e),m(zt.$$.fragment,e),_r=n(e),gt=d(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1okfsqx"&&(gt.textContent=gf),$r=n(e),Pt=d(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1t556pk"&&(Pt.innerHTML=Pf),vr=n(e),Rt=d(e,"TABLE",{"data-svelte-h":!0}),r(Rt)!=="svelte-13m2wni"&&(Rt.innerHTML=Rf),br=n(e),yr=d(e,"HR",{}),Mr=n(e),Ut=d(e,"A",{id:!0,class:!0}),h(Ut).forEach(l),xr=n(e),m(Et.$$.fragment,e),Cr=n(e),kt=d(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1htpbrk"&&(kt.innerHTML=Uf),Hr=n(e),jt=d(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1t0m8l6"&&(jt.innerHTML=Ef),Lr=n(e),Jt=d(e,"TABLE",{"data-svelte-h":!0}),r(Jt)!=="svelte-1qi99pl"&&(Jt.innerHTML=kf),wr=n(e),Ar=d(e,"HR",{}),zr=n(e),Dt=d(e,"A",{id:!0,class:!0}),h(Dt).forEach(l),gr=n(e),m(qt.$$.fragment,e),Pr=n(e),It=d(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1ztgqp"&&(It.innerHTML=jf),Rr=n(e),Kt=d(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-mvb39p"&&(Kt.innerHTML=Jf),Ur=n(e),Bt=d(e,"TABLE",{"data-svelte-h":!0}),r(Bt)!=="svelte-1qi99pl"&&(Bt.innerHTML=Df),Er=n(e),kr=d(e,"HR",{}),jr=n(e),Nt=d(e,"A",{id:!0,class:!0}),h(Nt).forEach(l),Jr=n(e),m(Vt.$$.fragment,e),Dr=n(e),Qt=d(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1a7u185"&&(Qt.textContent=qf),qr=n(e),St=d(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1eu3doh"&&(St.innerHTML=If),Ir=n(e),Kr=d(e,"HR",{}),Br=n(e),Ot=d(e,"A",{id:!0,class:!0}),h(Ot).forEach(l),Nr=n(e),m(Ft.$$.fragment,e),Vr=n(e),Yt=d(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-qls17b"&&(Yt.textContent=Kf),Qr=n(e),Wt=d(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-5nabmy"&&(Wt.innerHTML=Bf),Sr=n(e),Gt=d(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-muvb5c"&&(Gt.innerHTML=Nf),Or=n(e),Xt=d(e,"TABLE",{"data-svelte-h":!0}),r(Xt)!=="svelte-52pnzr"&&(Xt.innerHTML=Vf),Fr=n(e),Yr=d(e,"HR",{}),Wr=n(e),Zt=d(e,"A",{id:!0,class:!0}),h(Zt).forEach(l),Gr=n(e),m(el.$$.fragment,e),Xr=n(e),tl=d(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-19w0pic"&&(tl.innerHTML=Qf),Zr=n(e),ll=d(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1mr58c3"&&(ll.innerHTML=Sf),eu=n(e),tu=d(e,"HR",{}),lu=n(e),ol=d(e,"A",{id:!0,class:!0}),h(ol).forEach(l),ou=n(e),m(sl.$$.fragment,e),su=n(e),nl=d(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-18ws76n"&&(nl.textContent=Of),nu=n(e),il=d(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-1tnr5gm"&&(il.textContent=Ff),iu=n(e),dl=d(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-1si6y4t"&&(dl.innerHTML=Yf),du=n(e),rl=d(e,"TABLE",{"data-svelte-h":!0}),r(rl)!=="svelte-1u9lyxp"&&(rl.innerHTML=Wf),ru=n(e),uu=d(e,"HR",{}),au=n(e),ul=d(e,"A",{id:!0,class:!0}),h(ul).forEach(l),mu=n(e),m(al.$$.fragment,e),pu=n(e),ml=d(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-1b9ygao"&&(ml.innerHTML=Gf),cu=n(e),pl=d(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-1mr58c3"&&(pl.innerHTML=Xf),fu=n(e),Tu=d(e,"HR",{}),hu=n(e),cl=d(e,"A",{id:!0,class:!0}),h(cl).forEach(l),_u=n(e),m(fl.$$.fragment,e),$u=n(e),Tl=d(e,"P",{"data-svelte-h":!0}),r(Tl)!=="svelte-1vkr5xo"&&(Tl.innerHTML=Zf),vu=n(e),hl=d(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-1mr58c3"&&(hl.innerHTML=eT),bu=n(e),yu=d(e,"HR",{}),Mu=n(e),_l=d(e,"A",{id:!0,class:!0}),h(_l).forEach(l),xu=n(e),m($l.$$.fragment,e),Cu=n(e),vl=d(e,"P",{"data-svelte-h":!0}),r(vl)!=="svelte-1gguudf"&&(vl.innerHTML=tT),Hu=n(e),bl=d(e,"P",{"data-svelte-h":!0}),r(bl)!=="svelte-6vkfxj"&&(bl.innerHTML=lT),Lu=n(e),yl=d(e,"TABLE",{"data-svelte-h":!0}),r(yl)!=="svelte-z6whez"&&(yl.innerHTML=oT),wu=n(e),Au=d(e,"HR",{}),zu=n(e),Ml=d(e,"A",{id:!0,class:!0}),h(Ml).forEach(l),gu=n(e),m(xl.$$.fragment,e),Pu=n(e),Cl=d(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-d6gvut"&&(Cl.innerHTML=sT),Ru=n(e),Hl=d(e,"P",{"data-svelte-h":!0}),r(Hl)!=="svelte-18n9ux4"&&(Hl.innerHTML=nT),Uu=n(e),Ll=d(e,"TABLE",{"data-svelte-h":!0}),r(Ll)!=="svelte-jj58dd"&&(Ll.innerHTML=iT),Eu=n(e),ku=d(e,"HR",{}),ju=n(e),wl=d(e,"A",{id:!0,class:!0}),h(wl).forEach(l),Ju=n(e),m(Al.$$.fragment,e),Du=n(e),zl=d(e,"P",{"data-svelte-h":!0}),r(zl)!=="svelte-1adolpg"&&(zl.innerHTML=dT),qu=n(e),gl=d(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-1mr58c3"&&(gl.innerHTML=rT),Iu=n(e),Ku=d(e,"HR",{}),Bu=n(e),Pl=d(e,"A",{id:!0,class:!0}),h(Pl).forEach(l),Nu=n(e),m(Rl.$$.fragment,e),Vu=n(e),Ul=d(e,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-1hm8vtj"&&(Ul.textContent=uT),Qu=n(e),El=d(e,"P",{"data-svelte-h":!0}),r(El)!=="svelte-1ywpke5"&&(El.innerHTML=aT),Su=n(e),kl=d(e,"TABLE",{"data-svelte-h":!0}),r(kl)!=="svelte-9ff0sy"&&(kl.innerHTML=mT),Ou=n(e),Fu=d(e,"HR",{}),Yu=n(e),jl=d(e,"A",{id:!0,class:!0}),h(jl).forEach(l),Wu=n(e),m(Jl.$$.fragment,e),Gu=n(e),Dl=d(e,"P",{"data-svelte-h":!0}),r(Dl)!=="svelte-1e6kzks"&&(Dl.innerHTML=pT),Xu=n(e),ql=d(e,"P",{"data-svelte-h":!0}),r(ql)!=="svelte-1mr58c3"&&(ql.innerHTML=cT),Zu=n(e),ea=d(e,"HR",{}),ta=n(e),Il=d(e,"A",{id:!0,class:!0}),h(Il).forEach(l),la=n(e),m(Kl.$$.fragment,e),oa=n(e),Bl=d(e,"P",{"data-svelte-h":!0}),r(Bl)!=="svelte-t5k6jp"&&(Bl.textContent=fT),sa=n(e),Nl=d(e,"P",{"data-svelte-h":!0}),r(Nl)!=="svelte-1ywpke5"&&(Nl.innerHTML=TT),na=n(e),ia=d(e,"HR",{}),da=n(e),Vl=d(e,"A",{id:!0,class:!0}),h(Vl).forEach(l),ra=n(e),m(Ql.$$.fragment,e),ua=n(e),Sl=d(e,"P",{"data-svelte-h":!0}),r(Sl)!=="svelte-avw2a1"&&(Sl.textContent=hT),aa=n(e),Ol=d(e,"P",{"data-svelte-h":!0}),r(Ol)!=="svelte-16q99cu"&&(Ol.innerHTML=_T),ma=n(e),Fl=d(e,"TABLE",{"data-svelte-h":!0}),r(Fl)!=="svelte-jj5vaa"&&(Fl.innerHTML=$T),pa=n(e),ca=d(e,"HR",{}),fa=n(e),Yl=d(e,"A",{id:!0,class:!0}),h(Yl).forEach(l),Ta=n(e),m(Wl.$$.fragment,e),ha=n(e),Gl=d(e,"P",{"data-svelte-h":!0}),r(Gl)!=="svelte-167n5bd"&&(Gl.textContent=vT),_a=n(e),Xl=d(e,"P",{"data-svelte-h":!0}),r(Xl)!=="svelte-1pz529g"&&(Xl.innerHTML=bT),$a=n(e),Zl=d(e,"TABLE",{"data-svelte-h":!0}),r(Zl)!=="svelte-1oyadc3"&&(Zl.innerHTML=yT),va=n(e),ba=d(e,"HR",{}),ya=n(e),eo=d(e,"A",{id:!0,class:!0}),h(eo).forEach(l),Ma=n(e),m(to.$$.fragment,e),xa=n(e),lo=d(e,"P",{"data-svelte-h":!0}),r(lo)!=="svelte-fju8tm"&&(lo.textContent=MT),Ca=n(e),oo=d(e,"P",{"data-svelte-h":!0}),r(oo)!=="svelte-13s6o0v"&&(oo.innerHTML=xT),Ha=n(e),so=d(e,"TABLE",{"data-svelte-h":!0}),r(so)!=="svelte-8i278m"&&(so.innerHTML=CT),La=n(e),wa=d(e,"HR",{}),Aa=n(e),no=d(e,"A",{id:!0,class:!0}),h(no).forEach(l),za=n(e),m(io.$$.fragment,e),ga=n(e),ro=d(e,"P",{"data-svelte-h":!0}),r(ro)!=="svelte-18v04la"&&(ro.innerHTML=HT),Pa=n(e),uo=d(e,"P",{"data-svelte-h":!0}),r(uo)!=="svelte-16ws0dc"&&(uo.innerHTML=LT),Ra=n(e),ao=d(e,"TABLE",{"data-svelte-h":!0}),r(ao)!=="svelte-14k2n4x"&&(ao.innerHTML=wT),Ua=n(e),Ea=d(e,"HR",{}),ka=n(e),mo=d(e,"A",{id:!0,class:!0}),h(mo).forEach(l),ja=n(e),m(po.$$.fragment,e),Ja=n(e),co=d(e,"P",{"data-svelte-h":!0}),r(co)!=="svelte-1yvow13"&&(co.innerHTML=AT),Da=n(e),fo=d(e,"P",{"data-svelte-h":!0}),r(fo)!=="svelte-13n2k7m"&&(fo.innerHTML=zT),qa=n(e),To=d(e,"TABLE",{"data-svelte-h":!0}),r(To)!=="svelte-1ha3siw"&&(To.innerHTML=gT),Ia=n(e),Ka=d(e,"HR",{}),Ba=n(e),ho=d(e,"A",{id:!0,class:!0}),h(ho).forEach(l),Na=n(e),m(_o.$$.fragment,e),Va=n(e),$o=d(e,"P",{"data-svelte-h":!0}),r($o)!=="svelte-19dtamh"&&($o.innerHTML=PT),Qa=n(e),vo=d(e,"P",{"data-svelte-h":!0}),r(vo)!=="svelte-1nr5iz8"&&(vo.innerHTML=RT),Sa=n(e),bo=d(e,"TABLE",{"data-svelte-h":!0}),r(bo)!=="svelte-1hw4pq9"&&(bo.innerHTML=UT),Oa=n(e),Fa=d(e,"HR",{}),Ya=n(e),yo=d(e,"A",{id:!0,class:!0}),h(yo).forEach(l),Wa=n(e),m(Mo.$$.fragment,e),Ga=n(e),xo=d(e,"P",{"data-svelte-h":!0}),r(xo)!=="svelte-bd7moq"&&(xo.innerHTML=ET),Xa=n(e),Co=d(e,"P",{"data-svelte-h":!0}),r(Co)!=="svelte-jyg3bg"&&(Co.innerHTML=kT),Za=n(e),Ho=d(e,"TABLE",{"data-svelte-h":!0}),r(Ho)!=="svelte-1sdadnq"&&(Ho.innerHTML=jT),em=n(e),tm=d(e,"HR",{}),lm=n(e),Lo=d(e,"A",{id:!0,class:!0}),h(Lo).forEach(l),om=n(e),m(wo.$$.fragment,e),sm=n(e),Ao=d(e,"P",{"data-svelte-h":!0}),r(Ao)!=="svelte-11ei68w"&&(Ao.textContent=JT),nm=n(e),zo=d(e,"P",{"data-svelte-h":!0}),r(zo)!=="svelte-1p3llh"&&(zo.innerHTML=DT),im=n(e),go=d(e,"TABLE",{"data-svelte-h":!0}),r(go)!=="svelte-1xe0vb8"&&(go.innerHTML=qT),dm=n(e),rm=d(e,"HR",{}),um=n(e),Po=d(e,"A",{id:!0,class:!0}),h(Po).forEach(l),am=n(e),m(Ro.$$.fragment,e),mm=n(e),Uo=d(e,"P",{"data-svelte-h":!0}),r(Uo)!=="svelte-7ivim4"&&(Uo.textContent=IT),pm=n(e),Eo=d(e,"P",{"data-svelte-h":!0}),r(Eo)!=="svelte-151n4qz"&&(Eo.innerHTML=KT),cm=n(e),ko=d(e,"TABLE",{"data-svelte-h":!0}),r(ko)!=="svelte-iprxta"&&(ko.innerHTML=BT),fm=n(e),Tm=d(e,"HR",{}),hm=n(e),jo=d(e,"A",{id:!0,class:!0}),h(jo).forEach(l),_m=n(e),m(Jo.$$.fragment,e),$m=n(e),Do=d(e,"P",{"data-svelte-h":!0}),r(Do)!=="svelte-k6p1db"&&(Do.textContent=NT),vm=n(e),qo=d(e,"P",{"data-svelte-h":!0}),r(qo)!=="svelte-1o30xnd"&&(qo.innerHTML=VT),bm=n(e),Io=d(e,"TABLE",{"data-svelte-h":!0}),r(Io)!=="svelte-101obk2"&&(Io.innerHTML=QT),ym=n(e),Mm=d(e,"HR",{}),xm=n(e),Ko=d(e,"A",{id:!0,class:!0}),h(Ko).forEach(l),Cm=n(e),m(Bo.$$.fragment,e),Hm=n(e),No=d(e,"P",{"data-svelte-h":!0}),r(No)!=="svelte-8afo9v"&&(No.textContent=ST),Lm=n(e),Vo=d(e,"P",{"data-svelte-h":!0}),r(Vo)!=="svelte-1vvmhgz"&&(Vo.innerHTML=OT),wm=n(e),Qo=d(e,"TABLE",{"data-svelte-h":!0}),r(Qo)!=="svelte-wz2jkw"&&(Qo.innerHTML=FT),Am=n(e),zm=d(e,"HR",{}),gm=n(e),So=d(e,"A",{id:!0,class:!0}),h(So).forEach(l),Pm=n(e),m(Oo.$$.fragment,e),Rm=n(e),Fo=d(e,"P",{"data-svelte-h":!0}),r(Fo)!=="svelte-11plveb"&&(Fo.innerHTML=YT),Um=n(e),Yo=d(e,"P",{"data-svelte-h":!0}),r(Yo)!=="svelte-1wu8g4g"&&(Yo.innerHTML=WT),Em=n(e),Wo=d(e,"TABLE",{"data-svelte-h":!0}),r(Wo)!=="svelte-1vsvca3"&&(Wo.innerHTML=GT),km=n(e),jm=d(e,"HR",{}),Jm=n(e),Go=d(e,"A",{id:!0,class:!0}),h(Go).forEach(l),Dm=n(e),m(Xo.$$.fragment,e),qm=n(e),Zo=d(e,"P",{"data-svelte-h":!0}),r(Zo)!=="svelte-17f4oxi"&&(Zo.textContent=XT),Im=n(e),es=d(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-2yq8vx"&&(es.innerHTML=ZT),Km=n(e),ts=d(e,"TABLE",{"data-svelte-h":!0}),r(ts)!=="svelte-m4z8c4"&&(ts.innerHTML=eh),Bm=n(e),Nm=d(e,"HR",{}),Vm=n(e),ls=d(e,"A",{id:!0,class:!0}),h(ls).forEach(l),Qm=n(e),m(os.$$.fragment,e),Sm=n(e),ss=d(e,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-10qu7f7"&&(ss.textContent=th),Om=n(e),ns=d(e,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-14iug9a"&&(ns.innerHTML=lh),Fm=n(e),is=d(e,"TABLE",{"data-svelte-h":!0}),r(is)!=="svelte-stphn2"&&(is.innerHTML=oh),Ym=n(e),Wm=d(e,"HR",{}),Gm=n(e),ds=d(e,"A",{id:!0,class:!0}),h(ds).forEach(l),Xm=n(e),m(rs.$$.fragment,e),Zm=n(e),us=d(e,"P",{"data-svelte-h":!0}),r(us)!=="svelte-1ayje0f"&&(us.textContent=sh),ep=n(e),as=d(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-1ywifoz"&&(as.innerHTML=nh),tp=n(e),ms=d(e,"TABLE",{"data-svelte-h":!0}),r(ms)!=="svelte-gyxne1"&&(ms.innerHTML=ih),lp=n(e),op=d(e,"HR",{}),sp=n(e),ps=d(e,"A",{id:!0,class:!0}),h(ps).forEach(l),np=n(e),m(cs.$$.fragment,e),ip=n(e),fs=d(e,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-1wvb8sq"&&(fs.textContent=dh),dp=n(e),Ts=d(e,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-1ywifoz"&&(Ts.innerHTML=rh),rp=n(e),hs=d(e,"TABLE",{"data-svelte-h":!0}),r(hs)!=="svelte-1fk5fng"&&(hs.innerHTML=uh),up=n(e),ap=d(e,"HR",{}),mp=n(e),_s=d(e,"A",{id:!0,class:!0}),h(_s).forEach(l),pp=n(e),m($s.$$.fragment,e),cp=n(e),vs=d(e,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-1798kaw"&&(vs.textContent=ah),fp=n(e),bs=d(e,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-11aypax"&&(bs.innerHTML=mh),Tp=n(e),ys=d(e,"TABLE",{"data-svelte-h":!0}),r(ys)!=="svelte-gyxne1"&&(ys.innerHTML=ph),hp=n(e),_p=d(e,"HR",{}),$p=n(e),Ms=d(e,"A",{id:!0,class:!0}),h(Ms).forEach(l),vp=n(e),m(xs.$$.fragment,e),bp=n(e),Cs=d(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-9nnpip"&&(Cs.textContent=ch),yp=n(e),Hs=d(e,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-11aypax"&&(Hs.innerHTML=fh),Mp=n(e),Ls=d(e,"TABLE",{"data-svelte-h":!0}),r(Ls)!=="svelte-1fk5fng"&&(Ls.innerHTML=Th),xp=n(e),Cp=d(e,"HR",{}),Hp=n(e),ws=d(e,"A",{id:!0,class:!0}),h(ws).forEach(l),Lp=n(e),m(As.$$.fragment,e),wp=n(e),zs=d(e,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-185sm1b"&&(zs.textContent=hh),Ap=n(e),gs=d(e,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-1y8qzzr"&&(gs.innerHTML=_h),zp=n(e),Ps=d(e,"TABLE",{"data-svelte-h":!0}),r(Ps)!=="svelte-1v01t7k"&&(Ps.innerHTML=$h),gp=n(e),Pp=d(e,"HR",{}),Rp=n(e),Rs=d(e,"A",{id:!0,class:!0}),h(Rs).forEach(l),Up=n(e),m(Us.$$.fragment,e),Ep=n(e),Es=d(e,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-12loz97"&&(Es.innerHTML=vh),kp=n(e),jp=d(e,"HR",{}),Jp=n(e),ks=d(e,"A",{id:!0,class:!0}),h(ks).forEach(l),Dp=n(e),m(js.$$.fragment,e),qp=n(e),Js=d(e,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-40isdg"&&(Js.textContent=bh),Ip=n(e),Ds=d(e,"P",{"data-svelte-h":!0}),r(Ds)!=="svelte-tlsa2h"&&(Ds.innerHTML=yh),Kp=n(e),qs=d(e,"TABLE",{"data-svelte-h":!0}),r(qs)!=="svelte-17343p6"&&(qs.innerHTML=Mh),Bp=n(e),Is=d(e,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-1aswmub"&&(Is.innerHTML=xh),Np=n(e),m(Ks.$$.fragment,e),Vp=n(e),Qp=d(e,"HR",{}),Sp=n(e),Bs=d(e,"A",{id:!0,class:!0}),h(Bs).forEach(l),Op=n(e),m(Ns.$$.fragment,e),Fp=n(e),Vs=d(e,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-kp31r8"&&(Vs.innerHTML=Ch),Yp=n(e),Wp=d(e,"HR",{}),Gp=n(e),Qs=d(e,"A",{id:!0,class:!0}),h(Qs).forEach(l),Xp=n(e),m(Ss.$$.fragment,e),Zp=n(e),Os=d(e,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-1fs9no9"&&(Os.innerHTML=Hh),ec=n(e),tc=d(e,"HR",{}),lc=n(e),Fs=d(e,"A",{id:!0,class:!0}),h(Fs).forEach(l),oc=n(e),m(Ys.$$.fragment,e),sc=n(e),Ws=d(e,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-2mif9c"&&(Ws.textContent=Lh),nc=n(e),Gs=d(e,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-1jas2kw"&&(Gs.innerHTML=wh),ic=n(e),m(Xs.$$.fragment,e),dc=n(e),Zs=d(e,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-1aswmub"&&(Zs.innerHTML=Ah),rc=n(e),m(en.$$.fragment,e),uc=n(e),tn=d(e,"P",{"data-svelte-h":!0}),r(tn)!=="svelte-1aswmub"&&(tn.innerHTML=zh),ac=n(e),m(ln.$$.fragment,e),mc=n(e),pc=d(e,"HR",{}),cc=n(e),m(on.$$.fragment,e),fc=n(e),nn=d(e,"P",{}),h(nn).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",qh),u(v,"id","module_utils/tensor"),u(v,"class","group"),u(C,"id","module_utils/tensor.Tensor"),u(C,"class","group"),u(A,"id","new_module_utils/tensor.Tensor_new"),u(A,"class","group"),u(R,"id","module_utils/tensor.Tensor+dims"),u(R,"class","group"),u(j,"id","module_utils/tensor.Tensor+type"),u(j,"class","group"),u(I,"id","module_utils/tensor.Tensor+data"),u(I,"class","group"),u(V,"id","module_utils/tensor.Tensor+size"),u(V,"class","group"),u(F,"id","module_utils/tensor.Tensor+location"),u(F,"class","group"),u(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),u(X,"class","group"),u(le,"id","module_utils/tensor.Tensor+_getitem"),u(le,"class","group"),u(de,"id","module_utils/tensor.Tensor+indexOf"),u(de,"class","group"),u(me,"id","module_utils/tensor.Tensor+_subarray"),u(me,"class","group"),u(Te,"id","module_utils/tensor.Tensor+item"),u(Te,"class","group"),u(be,"id","module_utils/tensor.Tensor+tolist"),u(be,"class","group"),u(Ce,"id","module_utils/tensor.Tensor+sigmoid"),u(Ce,"class","group"),u(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),u(Ae,"class","group"),u(Re,"id","module_utils/tensor.Tensor+mul"),u(Re,"class","group"),u(Je,"id","module_utils/tensor.Tensor+mul_"),u(Je,"class","group"),u(Be,"id","module_utils/tensor.Tensor+div"),u(Be,"class","group"),u(Oe,"id","module_utils/tensor.Tensor+div_"),u(Oe,"class","group"),u(Xe,"id","module_utils/tensor.Tensor+add"),u(Xe,"class","group"),u(ot,"id","module_utils/tensor.Tensor+add_"),u(ot,"class","group"),u(rt,"id","module_utils/tensor.Tensor+sub"),u(rt,"class","group"),u(ct,"id","module_utils/tensor.Tensor+sub_"),u(ct,"class","group"),u($t,"id","module_utils/tensor.Tensor+permute"),u($t,"class","group"),u(xt,"id","module_utils/tensor.Tensor+sum"),u(xt,"class","group"),u(At,"id","module_utils/tensor.Tensor+norm"),u(At,"class","group"),u(Ut,"id","module_utils/tensor.Tensor+normalize_"),u(Ut,"class","group"),u(Dt,"id","module_utils/tensor.Tensor+normalize"),u(Dt,"class","group"),u(Nt,"id","module_utils/tensor.Tensor+stride"),u(Nt,"class","group"),u(Ot,"id","module_utils/tensor.Tensor+squeeze"),u(Ot,"class","group"),u(Zt,"id","module_utils/tensor.Tensor+squeeze_"),u(Zt,"class","group"),u(ol,"id","module_utils/tensor.Tensor+unsqueeze"),u(ol,"class","group"),u(ul,"id","module_utils/tensor.Tensor+unsqueeze_"),u(ul,"class","group"),u(cl,"id","module_utils/tensor.Tensor+flatten_"),u(cl,"class","group"),u(_l,"id","module_utils/tensor.Tensor+flatten"),u(_l,"class","group"),u(Ml,"id","module_utils/tensor.Tensor+view"),u(Ml,"class","group"),u(wl,"id","module_utils/tensor.Tensor+clamp_"),u(wl,"class","group"),u(Pl,"id","module_utils/tensor.Tensor+clamp"),u(Pl,"class","group"),u(jl,"id","module_utils/tensor.Tensor+round_"),u(jl,"class","group"),u(Il,"id","module_utils/tensor.Tensor+round"),u(Il,"class","group"),u(Vl,"id","module_utils/tensor.Tensor+to"),u(Vl,"class","group"),u(Yl,"id","module_utils/tensor.permute"),u(Yl,"class","group"),u(eo,"id","module_utils/tensor.interpolate"),u(eo,"class","group"),u(no,"id","module_utils/tensor.interpolate_4d"),u(no,"class","group"),u(mo,"id","module_utils/tensor.matmul"),u(mo,"class","group"),u(ho,"id","module_utils/tensor.rfft"),u(ho,"class","group"),u(yo,"id","module_utils/tensor.topk"),u(yo,"class","group"),u(Lo,"id","module_utils/tensor.mean_pooling"),u(Lo,"class","group"),u(Po,"id","module_utils/tensor.layer_norm"),u(Po,"class","group"),u(jo,"id","module_utils/tensor.cat"),u(jo,"class","group"),u(Ko,"id","module_utils/tensor.stack"),u(Ko,"class","group"),u(So,"id","module_utils/tensor.std_mean"),u(So,"class","group"),u(Go,"id","module_utils/tensor.mean"),u(Go,"class","group"),u(ls,"id","module_utils/tensor.full"),u(ls,"class","group"),u(ds,"id","module_utils/tensor.ones"),u(ds,"class","group"),u(ps,"id","module_utils/tensor.ones_like"),u(ps,"class","group"),u(_s,"id","module_utils/tensor.zeros"),u(_s,"class","group"),u(Ms,"id","module_utils/tensor.zeros_like"),u(Ms,"class","group"),u(ws,"id","module_utils/tensor.quantize_embeddings"),u(ws,"class","group"),u(Rs,"id","module_utils/tensor..args[0]"),u(Rs,"class","group"),u(ks,"id","module_utils/tensor..reshape"),u(ks,"class","group"),u(Bs,"id","module_utils/tensor..reshape..reshapedArray"),u(Bs,"class","group"),u(Qs,"id","module_utils/tensor..DataArray"),u(Qs,"class","group"),u(Fs,"id","module_utils/tensor..NestArray"),u(Fs,"class","group")},m(e,t){jh(document.head,$),o(e,dn,t),o(e,sn,t),o(e,rn,t),o(e,v,t),o(e,un,t),p(b,e,t),o(e,an,t),o(e,y,t),o(e,mn,t),o(e,M,t),o(e,pn,t),o(e,x,t),o(e,cn,t),o(e,fn,t),o(e,Tn,t),o(e,C,t),o(e,hn,t),p(H,e,t),o(e,_n,t),o(e,L,t),o(e,$n,t),o(e,w,t),o(e,vn,t),o(e,bn,t),o(e,yn,t),o(e,A,t),o(e,Mn,t),p(z,e,t),o(e,xn,t),o(e,g,t),o(e,Cn,t),o(e,P,t),o(e,Hn,t),o(e,Ln,t),o(e,wn,t),o(e,R,t),o(e,An,t),p(U,e,t),o(e,zn,t),o(e,E,t),o(e,gn,t),o(e,k,t),o(e,Pn,t),o(e,Rn,t),o(e,Un,t),o(e,j,t),o(e,En,t),p(J,e,t),o(e,kn,t),o(e,D,t),o(e,jn,t),o(e,q,t),o(e,Jn,t),o(e,Dn,t),o(e,qn,t),o(e,I,t),o(e,In,t),p(K,e,t),o(e,Kn,t),o(e,B,t),o(e,Bn,t),o(e,N,t),o(e,Nn,t),o(e,Vn,t),o(e,Qn,t),o(e,V,t),o(e,Sn,t),p(Q,e,t),o(e,On,t),o(e,S,t),o(e,Fn,t),o(e,O,t),o(e,Yn,t),o(e,Wn,t),o(e,Gn,t),o(e,F,t),o(e,Xn,t),p(Y,e,t),o(e,Zn,t),o(e,W,t),o(e,ei,t),o(e,G,t),o(e,ti,t),o(e,li,t),o(e,oi,t),o(e,X,t),o(e,si,t),p(Z,e,t),o(e,ni,t),o(e,ee,t),o(e,ii,t),o(e,te,t),o(e,di,t),o(e,ri,t),o(e,ui,t),o(e,le,t),o(e,ai,t),p(oe,e,t),o(e,mi,t),o(e,se,t),o(e,pi,t),o(e,ne,t),o(e,ci,t),o(e,ie,t),o(e,fi,t),o(e,Ti,t),o(e,hi,t),o(e,de,t),o(e,_i,t),p(re,e,t),o(e,$i,t),o(e,ue,t),o(e,vi,t),o(e,ae,t),o(e,bi,t),o(e,yi,t),o(e,Mi,t),o(e,me,t),o(e,xi,t),p(pe,e,t),o(e,Ci,t),o(e,ce,t),o(e,Hi,t),o(e,fe,t),o(e,Li,t),o(e,wi,t),o(e,Ai,t),o(e,Te,t),o(e,zi,t),p(he,e,t),o(e,gi,t),o(e,_e,t),o(e,Pi,t),o(e,$e,t),o(e,Ri,t),o(e,ve,t),o(e,Ui,t),o(e,Ei,t),o(e,ki,t),o(e,be,t),o(e,ji,t),p(ye,e,t),o(e,Ji,t),o(e,Me,t),o(e,Di,t),o(e,xe,t),o(e,qi,t),o(e,Ii,t),o(e,Ki,t),o(e,Ce,t),o(e,Bi,t),p(He,e,t),o(e,Ni,t),o(e,Le,t),o(e,Vi,t),o(e,we,t),o(e,Qi,t),o(e,Si,t),o(e,Oi,t),o(e,Ae,t),o(e,Fi,t),p(ze,e,t),o(e,Yi,t),o(e,ge,t),o(e,Wi,t),o(e,Pe,t),o(e,Gi,t),o(e,Xi,t),o(e,Zi,t),o(e,Re,t),o(e,ed,t),p(Ue,e,t),o(e,td,t),o(e,Ee,t),o(e,ld,t),o(e,ke,t),o(e,od,t),o(e,je,t),o(e,sd,t),o(e,nd,t),o(e,id,t),o(e,Je,t),o(e,dd,t),p(De,e,t),o(e,rd,t),o(e,qe,t),o(e,ud,t),o(e,Ie,t),o(e,ad,t),o(e,Ke,t),o(e,md,t),o(e,pd,t),o(e,cd,t),o(e,Be,t),o(e,fd,t),p(Ne,e,t),o(e,Td,t),o(e,Ve,t),o(e,hd,t),o(e,Qe,t),o(e,_d,t),o(e,Se,t),o(e,$d,t),o(e,vd,t),o(e,bd,t),o(e,Oe,t),o(e,yd,t),p(Fe,e,t),o(e,Md,t),o(e,Ye,t),o(e,xd,t),o(e,We,t),o(e,Cd,t),o(e,Ge,t),o(e,Hd,t),o(e,Ld,t),o(e,wd,t),o(e,Xe,t),o(e,Ad,t),p(Ze,e,t),o(e,zd,t),o(e,et,t),o(e,gd,t),o(e,tt,t),o(e,Pd,t),o(e,lt,t),o(e,Rd,t),o(e,Ud,t),o(e,Ed,t),o(e,ot,t),o(e,kd,t),p(st,e,t),o(e,jd,t),o(e,nt,t),o(e,Jd,t),o(e,it,t),o(e,Dd,t),o(e,dt,t),o(e,qd,t),o(e,Id,t),o(e,Kd,t),o(e,rt,t),o(e,Bd,t),p(ut,e,t),o(e,Nd,t),o(e,at,t),o(e,Vd,t),o(e,mt,t),o(e,Qd,t),o(e,pt,t),o(e,Sd,t),o(e,Od,t),o(e,Fd,t),o(e,ct,t),o(e,Yd,t),p(ft,e,t),o(e,Wd,t),o(e,Tt,t),o(e,Gd,t),o(e,ht,t),o(e,Xd,t),o(e,_t,t),o(e,Zd,t),o(e,er,t),o(e,tr,t),o(e,$t,t),o(e,lr,t),p(vt,e,t),o(e,or,t),o(e,bt,t),o(e,sr,t),o(e,yt,t),o(e,nr,t),o(e,Mt,t),o(e,ir,t),o(e,dr,t),o(e,rr,t),o(e,xt,t),o(e,ur,t),p(Ct,e,t),o(e,ar,t),o(e,Ht,t),o(e,mr,t),o(e,Lt,t),o(e,pr,t),o(e,wt,t),o(e,cr,t),o(e,fr,t),o(e,Tr,t),o(e,At,t),o(e,hr,t),p(zt,e,t),o(e,_r,t),o(e,gt,t),o(e,$r,t),o(e,Pt,t),o(e,vr,t),o(e,Rt,t),o(e,br,t),o(e,yr,t),o(e,Mr,t),o(e,Ut,t),o(e,xr,t),p(Et,e,t),o(e,Cr,t),o(e,kt,t),o(e,Hr,t),o(e,jt,t),o(e,Lr,t),o(e,Jt,t),o(e,wr,t),o(e,Ar,t),o(e,zr,t),o(e,Dt,t),o(e,gr,t),p(qt,e,t),o(e,Pr,t),o(e,It,t),o(e,Rr,t),o(e,Kt,t),o(e,Ur,t),o(e,Bt,t),o(e,Er,t),o(e,kr,t),o(e,jr,t),o(e,Nt,t),o(e,Jr,t),p(Vt,e,t),o(e,Dr,t),o(e,Qt,t),o(e,qr,t),o(e,St,t),o(e,Ir,t),o(e,Kr,t),o(e,Br,t),o(e,Ot,t),o(e,Nr,t),p(Ft,e,t),o(e,Vr,t),o(e,Yt,t),o(e,Qr,t),o(e,Wt,t),o(e,Sr,t),o(e,Gt,t),o(e,Or,t),o(e,Xt,t),o(e,Fr,t),o(e,Yr,t),o(e,Wr,t),o(e,Zt,t),o(e,Gr,t),p(el,e,t),o(e,Xr,t),o(e,tl,t),o(e,Zr,t),o(e,ll,t),o(e,eu,t),o(e,tu,t),o(e,lu,t),o(e,ol,t),o(e,ou,t),p(sl,e,t),o(e,su,t),o(e,nl,t),o(e,nu,t),o(e,il,t),o(e,iu,t),o(e,dl,t),o(e,du,t),o(e,rl,t),o(e,ru,t),o(e,uu,t),o(e,au,t),o(e,ul,t),o(e,mu,t),p(al,e,t),o(e,pu,t),o(e,ml,t),o(e,cu,t),o(e,pl,t),o(e,fu,t),o(e,Tu,t),o(e,hu,t),o(e,cl,t),o(e,_u,t),p(fl,e,t),o(e,$u,t),o(e,Tl,t),o(e,vu,t),o(e,hl,t),o(e,bu,t),o(e,yu,t),o(e,Mu,t),o(e,_l,t),o(e,xu,t),p($l,e,t),o(e,Cu,t),o(e,vl,t),o(e,Hu,t),o(e,bl,t),o(e,Lu,t),o(e,yl,t),o(e,wu,t),o(e,Au,t),o(e,zu,t),o(e,Ml,t),o(e,gu,t),p(xl,e,t),o(e,Pu,t),o(e,Cl,t),o(e,Ru,t),o(e,Hl,t),o(e,Uu,t),o(e,Ll,t),o(e,Eu,t),o(e,ku,t),o(e,ju,t),o(e,wl,t),o(e,Ju,t),p(Al,e,t),o(e,Du,t),o(e,zl,t),o(e,qu,t),o(e,gl,t),o(e,Iu,t),o(e,Ku,t),o(e,Bu,t),o(e,Pl,t),o(e,Nu,t),p(Rl,e,t),o(e,Vu,t),o(e,Ul,t),o(e,Qu,t),o(e,El,t),o(e,Su,t),o(e,kl,t),o(e,Ou,t),o(e,Fu,t),o(e,Yu,t),o(e,jl,t),o(e,Wu,t),p(Jl,e,t),o(e,Gu,t),o(e,Dl,t),o(e,Xu,t),o(e,ql,t),o(e,Zu,t),o(e,ea,t),o(e,ta,t),o(e,Il,t),o(e,la,t),p(Kl,e,t),o(e,oa,t),o(e,Bl,t),o(e,sa,t),o(e,Nl,t),o(e,na,t),o(e,ia,t),o(e,da,t),o(e,Vl,t),o(e,ra,t),p(Ql,e,t),o(e,ua,t),o(e,Sl,t),o(e,aa,t),o(e,Ol,t),o(e,ma,t),o(e,Fl,t),o(e,pa,t),o(e,ca,t),o(e,fa,t),o(e,Yl,t),o(e,Ta,t),p(Wl,e,t),o(e,ha,t),o(e,Gl,t),o(e,_a,t),o(e,Xl,t),o(e,$a,t),o(e,Zl,t),o(e,va,t),o(e,ba,t),o(e,ya,t),o(e,eo,t),o(e,Ma,t),p(to,e,t),o(e,xa,t),o(e,lo,t),o(e,Ca,t),o(e,oo,t),o(e,Ha,t),o(e,so,t),o(e,La,t),o(e,wa,t),o(e,Aa,t),o(e,no,t),o(e,za,t),p(io,e,t),o(e,ga,t),o(e,ro,t),o(e,Pa,t),o(e,uo,t),o(e,Ra,t),o(e,ao,t),o(e,Ua,t),o(e,Ea,t),o(e,ka,t),o(e,mo,t),o(e,ja,t),p(po,e,t),o(e,Ja,t),o(e,co,t),o(e,Da,t),o(e,fo,t),o(e,qa,t),o(e,To,t),o(e,Ia,t),o(e,Ka,t),o(e,Ba,t),o(e,ho,t),o(e,Na,t),p(_o,e,t),o(e,Va,t),o(e,$o,t),o(e,Qa,t),o(e,vo,t),o(e,Sa,t),o(e,bo,t),o(e,Oa,t),o(e,Fa,t),o(e,Ya,t),o(e,yo,t),o(e,Wa,t),p(Mo,e,t),o(e,Ga,t),o(e,xo,t),o(e,Xa,t),o(e,Co,t),o(e,Za,t),o(e,Ho,t),o(e,em,t),o(e,tm,t),o(e,lm,t),o(e,Lo,t),o(e,om,t),p(wo,e,t),o(e,sm,t),o(e,Ao,t),o(e,nm,t),o(e,zo,t),o(e,im,t),o(e,go,t),o(e,dm,t),o(e,rm,t),o(e,um,t),o(e,Po,t),o(e,am,t),p(Ro,e,t),o(e,mm,t),o(e,Uo,t),o(e,pm,t),o(e,Eo,t),o(e,cm,t),o(e,ko,t),o(e,fm,t),o(e,Tm,t),o(e,hm,t),o(e,jo,t),o(e,_m,t),p(Jo,e,t),o(e,$m,t),o(e,Do,t),o(e,vm,t),o(e,qo,t),o(e,bm,t),o(e,Io,t),o(e,ym,t),o(e,Mm,t),o(e,xm,t),o(e,Ko,t),o(e,Cm,t),p(Bo,e,t),o(e,Hm,t),o(e,No,t),o(e,Lm,t),o(e,Vo,t),o(e,wm,t),o(e,Qo,t),o(e,Am,t),o(e,zm,t),o(e,gm,t),o(e,So,t),o(e,Pm,t),p(Oo,e,t),o(e,Rm,t),o(e,Fo,t),o(e,Um,t),o(e,Yo,t),o(e,Em,t),o(e,Wo,t),o(e,km,t),o(e,jm,t),o(e,Jm,t),o(e,Go,t),o(e,Dm,t),p(Xo,e,t),o(e,qm,t),o(e,Zo,t),o(e,Im,t),o(e,es,t),o(e,Km,t),o(e,ts,t),o(e,Bm,t),o(e,Nm,t),o(e,Vm,t),o(e,ls,t),o(e,Qm,t),p(os,e,t),o(e,Sm,t),o(e,ss,t),o(e,Om,t),o(e,ns,t),o(e,Fm,t),o(e,is,t),o(e,Ym,t),o(e,Wm,t),o(e,Gm,t),o(e,ds,t),o(e,Xm,t),p(rs,e,t),o(e,Zm,t),o(e,us,t),o(e,ep,t),o(e,as,t),o(e,tp,t),o(e,ms,t),o(e,lp,t),o(e,op,t),o(e,sp,t),o(e,ps,t),o(e,np,t),p(cs,e,t),o(e,ip,t),o(e,fs,t),o(e,dp,t),o(e,Ts,t),o(e,rp,t),o(e,hs,t),o(e,up,t),o(e,ap,t),o(e,mp,t),o(e,_s,t),o(e,pp,t),p($s,e,t),o(e,cp,t),o(e,vs,t),o(e,fp,t),o(e,bs,t),o(e,Tp,t),o(e,ys,t),o(e,hp,t),o(e,_p,t),o(e,$p,t),o(e,Ms,t),o(e,vp,t),p(xs,e,t),o(e,bp,t),o(e,Cs,t),o(e,yp,t),o(e,Hs,t),o(e,Mp,t),o(e,Ls,t),o(e,xp,t),o(e,Cp,t),o(e,Hp,t),o(e,ws,t),o(e,Lp,t),p(As,e,t),o(e,wp,t),o(e,zs,t),o(e,Ap,t),o(e,gs,t),o(e,zp,t),o(e,Ps,t),o(e,gp,t),o(e,Pp,t),o(e,Rp,t),o(e,Rs,t),o(e,Up,t),p(Us,e,t),o(e,Ep,t),o(e,Es,t),o(e,kp,t),o(e,jp,t),o(e,Jp,t),o(e,ks,t),o(e,Dp,t),p(js,e,t),o(e,qp,t),o(e,Js,t),o(e,Ip,t),o(e,Ds,t),o(e,Kp,t),o(e,qs,t),o(e,Bp,t),o(e,Is,t),o(e,Np,t),p(Ks,e,t),o(e,Vp,t),o(e,Qp,t),o(e,Sp,t),o(e,Bs,t),o(e,Op,t),p(Ns,e,t),o(e,Fp,t),o(e,Vs,t),o(e,Yp,t),o(e,Wp,t),o(e,Gp,t),o(e,Qs,t),o(e,Xp,t),p(Ss,e,t),o(e,Zp,t),o(e,Os,t),o(e,ec,t),o(e,tc,t),o(e,lc,t),o(e,Fs,t),o(e,oc,t),p(Ys,e,t),o(e,sc,t),o(e,Ws,t),o(e,nc,t),o(e,Gs,t),o(e,ic,t),p(Xs,e,t),o(e,dc,t),o(e,Zs,t),o(e,rc,t),p(en,e,t),o(e,uc,t),o(e,tn,t),o(e,ac,t),p(ln,e,t),o(e,mc,t),o(e,pc,t),o(e,cc,t),p(on,e,t),o(e,fc,t),o(e,nn,t),Tc=!0},p:Ph,i(e){Tc||(c(b.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(U.$$.fragment,e),c(J.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(He.$$.fragment,e),c(ze.$$.fragment,e),c(Ue.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(st.$$.fragment,e),c(ut.$$.fragment,e),c(ft.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(zt.$$.fragment,e),c(Et.$$.fragment,e),c(qt.$$.fragment,e),c(Vt.$$.fragment,e),c(Ft.$$.fragment,e),c(el.$$.fragment,e),c(sl.$$.fragment,e),c(al.$$.fragment,e),c(fl.$$.fragment,e),c($l.$$.fragment,e),c(xl.$$.fragment,e),c(Al.$$.fragment,e),c(Rl.$$.fragment,e),c(Jl.$$.fragment,e),c(Kl.$$.fragment,e),c(Ql.$$.fragment,e),c(Wl.$$.fragment,e),c(to.$$.fragment,e),c(io.$$.fragment,e),c(po.$$.fragment,e),c(_o.$$.fragment,e),c(Mo.$$.fragment,e),c(wo.$$.fragment,e),c(Ro.$$.fragment,e),c(Jo.$$.fragment,e),c(Bo.$$.fragment,e),c(Oo.$$.fragment,e),c(Xo.$$.fragment,e),c(os.$$.fragment,e),c(rs.$$.fragment,e),c(cs.$$.fragment,e),c($s.$$.fragment,e),c(xs.$$.fragment,e),c(As.$$.fragment,e),c(Us.$$.fragment,e),c(js.$$.fragment,e),c(Ks.$$.fragment,e),c(Ns.$$.fragment,e),c(Ss.$$.fragment,e),c(Ys.$$.fragment,e),c(Xs.$$.fragment,e),c(en.$$.fragment,e),c(ln.$$.fragment,e),c(on.$$.fragment,e),Tc=!0)},o(e){f(b.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(U.$$.fragment,e),f(J.$$.fragment,e),f(K.$$.fragment,e),f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(Z.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(He.$$.fragment,e),f(ze.$$.fragment,e),f(Ue.$$.fragment,e),f(De.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Ze.$$.fragment,e),f(st.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(vt.$$.fragment,e),f(Ct.$$.fragment,e),f(zt.$$.fragment,e),f(Et.$$.fragment,e),f(qt.$$.fragment,e),f(Vt.$$.fragment,e),f(Ft.$$.fragment,e),f(el.$$.fragment,e),f(sl.$$.fragment,e),f(al.$$.fragment,e),f(fl.$$.fragment,e),f($l.$$.fragment,e),f(xl.$$.fragment,e),f(Al.$$.fragment,e),f(Rl.$$.fragment,e),f(Jl.$$.fragment,e),f(Kl.$$.fragment,e),f(Ql.$$.fragment,e),f(Wl.$$.fragment,e),f(to.$$.fragment,e),f(io.$$.fragment,e),f(po.$$.fragment,e),f(_o.$$.fragment,e),f(Mo.$$.fragment,e),f(wo.$$.fragment,e),f(Ro.$$.fragment,e),f(Jo.$$.fragment,e),f(Bo.$$.fragment,e),f(Oo.$$.fragment,e),f(Xo.$$.fragment,e),f(os.$$.fragment,e),f(rs.$$.fragment,e),f(cs.$$.fragment,e),f($s.$$.fragment,e),f(xs.$$.fragment,e),f(As.$$.fragment,e),f(Us.$$.fragment,e),f(js.$$.fragment,e),f(Ks.$$.fragment,e),f(Ns.$$.fragment,e),f(Ss.$$.fragment,e),f(Ys.$$.fragment,e),f(Xs.$$.fragment,e),f(en.$$.fragment,e),f(ln.$$.fragment,e),f(on.$$.fragment,e),Tc=!1},d(e){e&&(l(dn),l(sn),l(rn),l(v),l(un),l(an),l(y),l(mn),l(M),l(pn),l(x),l(cn),l(fn),l(Tn),l(C),l(hn),l(_n),l(L),l($n),l(w),l(vn),l(bn),l(yn),l(A),l(Mn),l(xn),l(g),l(Cn),l(P),l(Hn),l(Ln),l(wn),l(R),l(An),l(zn),l(E),l(gn),l(k),l(Pn),l(Rn),l(Un),l(j),l(En),l(kn),l(D),l(jn),l(q),l(Jn),l(Dn),l(qn),l(I),l(In),l(Kn),l(B),l(Bn),l(N),l(Nn),l(Vn),l(Qn),l(V),l(Sn),l(On),l(S),l(Fn),l(O),l(Yn),l(Wn),l(Gn),l(F),l(Xn),l(Zn),l(W),l(ei),l(G),l(ti),l(li),l(oi),l(X),l(si),l(ni),l(ee),l(ii),l(te),l(di),l(ri),l(ui),l(le),l(ai),l(mi),l(se),l(pi),l(ne),l(ci),l(ie),l(fi),l(Ti),l(hi),l(de),l(_i),l($i),l(ue),l(vi),l(ae),l(bi),l(yi),l(Mi),l(me),l(xi),l(Ci),l(ce),l(Hi),l(fe),l(Li),l(wi),l(Ai),l(Te),l(zi),l(gi),l(_e),l(Pi),l($e),l(Ri),l(ve),l(Ui),l(Ei),l(ki),l(be),l(ji),l(Ji),l(Me),l(Di),l(xe),l(qi),l(Ii),l(Ki),l(Ce),l(Bi),l(Ni),l(Le),l(Vi),l(we),l(Qi),l(Si),l(Oi),l(Ae),l(Fi),l(Yi),l(ge),l(Wi),l(Pe),l(Gi),l(Xi),l(Zi),l(Re),l(ed),l(td),l(Ee),l(ld),l(ke),l(od),l(je),l(sd),l(nd),l(id),l(Je),l(dd),l(rd),l(qe),l(ud),l(Ie),l(ad),l(Ke),l(md),l(pd),l(cd),l(Be),l(fd),l(Td),l(Ve),l(hd),l(Qe),l(_d),l(Se),l($d),l(vd),l(bd),l(Oe),l(yd),l(Md),l(Ye),l(xd),l(We),l(Cd),l(Ge),l(Hd),l(Ld),l(wd),l(Xe),l(Ad),l(zd),l(et),l(gd),l(tt),l(Pd),l(lt),l(Rd),l(Ud),l(Ed),l(ot),l(kd),l(jd),l(nt),l(Jd),l(it),l(Dd),l(dt),l(qd),l(Id),l(Kd),l(rt),l(Bd),l(Nd),l(at),l(Vd),l(mt),l(Qd),l(pt),l(Sd),l(Od),l(Fd),l(ct),l(Yd),l(Wd),l(Tt),l(Gd),l(ht),l(Xd),l(_t),l(Zd),l(er),l(tr),l($t),l(lr),l(or),l(bt),l(sr),l(yt),l(nr),l(Mt),l(ir),l(dr),l(rr),l(xt),l(ur),l(ar),l(Ht),l(mr),l(Lt),l(pr),l(wt),l(cr),l(fr),l(Tr),l(At),l(hr),l(_r),l(gt),l($r),l(Pt),l(vr),l(Rt),l(br),l(yr),l(Mr),l(Ut),l(xr),l(Cr),l(kt),l(Hr),l(jt),l(Lr),l(Jt),l(wr),l(Ar),l(zr),l(Dt),l(gr),l(Pr),l(It),l(Rr),l(Kt),l(Ur),l(Bt),l(Er),l(kr),l(jr),l(Nt),l(Jr),l(Dr),l(Qt),l(qr),l(St),l(Ir),l(Kr),l(Br),l(Ot),l(Nr),l(Vr),l(Yt),l(Qr),l(Wt),l(Sr),l(Gt),l(Or),l(Xt),l(Fr),l(Yr),l(Wr),l(Zt),l(Gr),l(Xr),l(tl),l(Zr),l(ll),l(eu),l(tu),l(lu),l(ol),l(ou),l(su),l(nl),l(nu),l(il),l(iu),l(dl),l(du),l(rl),l(ru),l(uu),l(au),l(ul),l(mu),l(pu),l(ml),l(cu),l(pl),l(fu),l(Tu),l(hu),l(cl),l(_u),l($u),l(Tl),l(vu),l(hl),l(bu),l(yu),l(Mu),l(_l),l(xu),l(Cu),l(vl),l(Hu),l(bl),l(Lu),l(yl),l(wu),l(Au),l(zu),l(Ml),l(gu),l(Pu),l(Cl),l(Ru),l(Hl),l(Uu),l(Ll),l(Eu),l(ku),l(ju),l(wl),l(Ju),l(Du),l(zl),l(qu),l(gl),l(Iu),l(Ku),l(Bu),l(Pl),l(Nu),l(Vu),l(Ul),l(Qu),l(El),l(Su),l(kl),l(Ou),l(Fu),l(Yu),l(jl),l(Wu),l(Gu),l(Dl),l(Xu),l(ql),l(Zu),l(ea),l(ta),l(Il),l(la),l(oa),l(Bl),l(sa),l(Nl),l(na),l(ia),l(da),l(Vl),l(ra),l(ua),l(Sl),l(aa),l(Ol),l(ma),l(Fl),l(pa),l(ca),l(fa),l(Yl),l(Ta),l(ha),l(Gl),l(_a),l(Xl),l($a),l(Zl),l(va),l(ba),l(ya),l(eo),l(Ma),l(xa),l(lo),l(Ca),l(oo),l(Ha),l(so),l(La),l(wa),l(Aa),l(no),l(za),l(ga),l(ro),l(Pa),l(uo),l(Ra),l(ao),l(Ua),l(Ea),l(ka),l(mo),l(ja),l(Ja),l(co),l(Da),l(fo),l(qa),l(To),l(Ia),l(Ka),l(Ba),l(ho),l(Na),l(Va),l($o),l(Qa),l(vo),l(Sa),l(bo),l(Oa),l(Fa),l(Ya),l(yo),l(Wa),l(Ga),l(xo),l(Xa),l(Co),l(Za),l(Ho),l(em),l(tm),l(lm),l(Lo),l(om),l(sm),l(Ao),l(nm),l(zo),l(im),l(go),l(dm),l(rm),l(um),l(Po),l(am),l(mm),l(Uo),l(pm),l(Eo),l(cm),l(ko),l(fm),l(Tm),l(hm),l(jo),l(_m),l($m),l(Do),l(vm),l(qo),l(bm),l(Io),l(ym),l(Mm),l(xm),l(Ko),l(Cm),l(Hm),l(No),l(Lm),l(Vo),l(wm),l(Qo),l(Am),l(zm),l(gm),l(So),l(Pm),l(Rm),l(Fo),l(Um),l(Yo),l(Em),l(Wo),l(km),l(jm),l(Jm),l(Go),l(Dm),l(qm),l(Zo),l(Im),l(es),l(Km),l(ts),l(Bm),l(Nm),l(Vm),l(ls),l(Qm),l(Sm),l(ss),l(Om),l(ns),l(Fm),l(is),l(Ym),l(Wm),l(Gm),l(ds),l(Xm),l(Zm),l(us),l(ep),l(as),l(tp),l(ms),l(lp),l(op),l(sp),l(ps),l(np),l(ip),l(fs),l(dp),l(Ts),l(rp),l(hs),l(up),l(ap),l(mp),l(_s),l(pp),l(cp),l(vs),l(fp),l(bs),l(Tp),l(ys),l(hp),l(_p),l($p),l(Ms),l(vp),l(bp),l(Cs),l(yp),l(Hs),l(Mp),l(Ls),l(xp),l(Cp),l(Hp),l(ws),l(Lp),l(wp),l(zs),l(Ap),l(gs),l(zp),l(Ps),l(gp),l(Pp),l(Rp),l(Rs),l(Up),l(Ep),l(Es),l(kp),l(jp),l(Jp),l(ks),l(Dp),l(qp),l(Js),l(Ip),l(Ds),l(Kp),l(qs),l(Bp),l(Is),l(Np),l(Vp),l(Qp),l(Sp),l(Bs),l(Op),l(Fp),l(Vs),l(Yp),l(Wp),l(Gp),l(Qs),l(Xp),l(Zp),l(Os),l(ec),l(tc),l(lc),l(Fs),l(oc),l(sc),l(Ws),l(nc),l(Gs),l(ic),l(dc),l(Zs),l(rc),l(uc),l(tn),l(ac),l(mc),l(pc),l(cc),l(fc),l(nn)),l($),T(b,e),T(H,e),T(z,e),T(U,e),T(J,e),T(K,e),T(Q,e),T(Y,e),T(Z,e),T(oe,e),T(re,e),T(pe,e),T(he,e),T(ye,e),T(He,e),T(ze,e),T(Ue,e),T(De,e),T(Ne,e),T(Fe,e),T(Ze,e),T(st,e),T(ut,e),T(ft,e),T(vt,e),T(Ct,e),T(zt,e),T(Et,e),T(qt,e),T(Vt,e),T(Ft,e),T(el,e),T(sl,e),T(al,e),T(fl,e),T($l,e),T(xl,e),T(Al,e),T(Rl,e),T(Jl,e),T(Kl,e),T(Ql,e),T(Wl,e),T(to,e),T(io,e),T(po,e),T(_o,e),T(Mo,e),T(wo,e),T(Ro,e),T(Jo,e),T(Bo,e),T(Oo,e),T(Xo,e),T(os,e),T(rs,e),T(cs,e),T($s,e),T(xs,e),T(As,e),T(Us,e),T(js,e),T(Ks,e),T(Ns,e),T(Ss,e),T(Ys,e),T(Xs,e),T(en,e),T(ln,e),T(on,e)}}}const qh='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub_(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, k) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function Ih(_c){return Rh(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qh extends Uh{constructor($){super(),Eh(this,$,Ih,Dh,gh,{})}}export{Qh as component};
