import{s as ri,o as ii,n as wt}from"../chunks/scheduler.37c15a92.js";import{S as pi,i as ui,g as r,s as n,r as u,A as oi,h as i,f as t,c as a,j as ni,u as o,x as p,k as ai,y as mi,a as l,v as m,d,t as c,w as M}from"../chunks/index.2bf4358c.js";import{T as Tt}from"../chunks/Tip.363c041f.js";import{Y as di}from"../chunks/Youtube.1e50a667.js";import{C as J}from"../chunks/CodeBlock.4e987730.js";import{C as ci}from"../chunks/CourseFloatingBanner.6add7356.js";import{F as Mi}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as w,E as yi}from"../chunks/getInferenceSnippets.00b99042.js";function Ji(T){let y,j="✏️ <em>A votre tour !</em> Vérifiez que tout semble correct avec le deuxième élément du jeu de données d’entraînement.";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-a5jmf7"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:wt,d(b){b&&t(y)}}}function bi(T){let y,j="Dans la prochaine partie du cours, nous examinerons des techniques plus avancées qui peuvent vous aider à réduire votre empreinte mémoire et vous permettre de <i>finetuner</i> les plus grands modèles.";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1fy93ej"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:wt,d(b){b&&t(y)}}}function ji(T){let y,j="💡 Vous devriez toujours vous assurer que vous pouvez exécuter <code>trainer.evaluate()</code> avant de lancer <code>trainer.train()</code>, pour éviter de gaspiller beaucoup de ressources de calcul avant de tomber sur une erreur.";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-m749no"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:wt,d(b){b&&t(y)}}}function fi(T){let y,j="💡 Si vous utilisez une boucle d’entraînement manuelle, les mêmes étapes s’appliquent pour déboguer votre pipeline d’entraînement, mais il est plus facile de les séparer. Assurez-vous cependant de ne pas avoir oublié le <code>model.eval()</code> ou le <code>model.train()</code> aux bons endroits, ou le <code>zero_grad()</code> à chaque étape !";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-5w1gdq"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:wt,d(b){b&&t(y)}}}function Ti(T){let y,j="⚠️ Si vous effectuez un entraînement distribué, imprimez des échantillons de votre ensemble de données dans chaque processus et vérifiez par trois fois que vous obtenez la même chose. Un bug courant consiste à avoir une source d’aléa dans la création des données qui fait que chaque processus a une version différente du jeu de données.";return{c(){y=r("p"),y.textContent=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-hopuap"&&(y.textContent=j)},m(b,f){l(b,y,f)},p:wt,d(b){b&&t(y)}}}function wi(T){let y,j="💡 Si vos données d’entraînement ne sont pas équilibrées, veillez à créer un batch de données d’entraînement contenant toutes les étiquettes.";return{c(){y=r("p"),y.textContent=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-3aiowm"&&(y.textContent=j)},m(b,f){l(b,y,f)},p:wt,d(b){b&&t(y)}}}function hi(T){let y,j="⚠️ Vous devrez recréer votre modèle et votre <code>Trainer</code> après ce test, car le modèle obtenu ne sera probablement pas capable de récupérer et d’apprendre quelque chose d’utile sur votre jeu de données complet.";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-u1whl2"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:wt,d(b){b&&t(y)}}}function Ui(T){let y,j,b,f,h,Ut,g,vt,B,$t,X,Ua='Vous avez écrit un magnifique script pour entraîner ou <em>finetuner</em> un modèle sur une tâche donnée en suivant consciencieusement les conseils du <a href="/course/fr/chapter7">chapitre 7</a>. Mais lorsque vous lancez la commande <code>model.fit()</code>, quelque chose d’horrible se produit : vous obtenez une erreur 😱 ! Ou pire, tout semble aller bien et l’entraînement se déroule sans erreur mais le modèle résultant est mauvais. Dans cette section, nous allons vous montrer ce que vous pouvez faire pour déboguer ce genre de problèmes.',Ct,W,Zt,R,It,G,va="Le problème lorsque vous rencontrez une erreur dans <code>trainer.train()</code> est qu’elle peut provenir de plusieurs sources, car la fonction <code>Trainer</code> assemble généralement des batchs de choses. Elle convertit les jeux de données en chargeurs de données donc le problème pourrait être quelque chose d’erroné dans votre jeu de données, ou un problème en essayant de regrouper les éléments des jeux de données ensemble. Ensuite, elle prend un batch de données et le transmet au modèle, le problème peut donc se situer dans le code du modèle. Après cela, elle calcule les gradients et effectue l’étape d’optimisation, le problème peut donc également se situer dans votre optimiseur. Et même si tout se passe bien pendant l’entraînement, quelque chose peut encore mal tourner pendant l’évaluation si votre métrique pose problème.",kt,V,$a="La meilleure façon de déboguer une erreur qui survient dans <code>trainer.train()</code> est de passer manuellement en revue tout le pipeline pour voir où les choses se sont mal passées. L’erreur est alors souvent très facile à résoudre.",gt,z,Ca='Pour le démontrer, nous utiliserons le script suivant qui tente de <em>finetuner</em> un modèle DistilBERT sur le <a href="https://huggingface.co/datasets/glue" rel="nofollow">jeu de données MNLI</a> :',Bt,q,Xt,x,Za="Si vous essayez de l’exécuter, vous serez confronté à une erreur plutôt cryptique :",Wt,_,Rt,Y,Gt,A,Ia="Cela va sans dire, mais si vos données sont corrompues, le <code>Trainer</code> ne sera pas capable de former des batchs et encore moins d’entraîner votre modèle. Donc, tout d’abord, vous devez jeter un coup d’oeil à ce qui se trouve dans votre jeu d’entraînement.",Vt,F,ka="Pour éviter d’innombrables heures passées à essayer de corriger quelque chose qui n’est pas la source du bug, nous vous recommandons d’utiliser <code>trainer.train_dataset</code> pour vos vérifications et rien d’autre. Faisons donc cela ici :",zt,H,qt,N,xt,E,ga="Vous remarquez quelque chose d’anormal ? Ceci, en conjonction avec le message d’erreur sur les <code>input_ids</code> manquants, devrait vous faire réaliser que ce sont des textes et non des nombres que le modèle peut comprendre. Ici, l’erreur originale est très trompeuse parce que le <code>Trainer</code> enlève automatiquement les colonnes qui ne correspondent pas à la signature du modèle (c’est-à-dire, les arguments attendus par le modèle). Cela signifie qu’ici, tout, sauf les étiquettes, a été éliminé. Il n’y avait donc aucun problème à créer des batchs et à les envoyer ensuite au modèle, qui s’est plaint à son tour de ne pas avoir reçu les bons arguments.",_t,Q,Ba="Pourquoi les données n’ont-elles pas été traitées ? Nous avons utilisé la méthode <code>Dataset.map()</code> sur les jeux de données pour appliquer le <em>tokenizer</em> sur chaque échantillon. Mais si vous regardez attentivement le code, vous verrez que nous avons fait une erreur en passant les ensembles d’entraînement et d’évaluation au <code>Trainer</code>. Au lieu d’utiliser <code>tokenized_datasets</code> ici, nous avons utilisé <code>raw_datasets</code> 🤦. Alors corrigeons ça !",Yt,S,At,L,Xa="Ce nouveau code donnera maintenant une erreur différente (c’est un progrès !) :",Ft,D,Ht,P,Wa="En regardant le <em>traceback</em>, nous pouvons voir que l’erreur se produit dans l’étape de collationnement des données :",Nt,K,Et,O,Ra="Donc, nous devrions passer à cela. Mais avant finissons d’inspecter nos données, pour être sûrs à 100% qu’elles sont correctes.",Qt,ee,Ga="Une chose que vous devriez toujours faire lorsque vous déboguez une session d’entraînement est de jeter un coup d’oeil aux entrées décodées de votre modèle. Nous ne pouvons pas donner un sens aux chiffres que nous lui fournissons directement, nous devons donc examiner ce que ces chiffres représentent. Dans le domaine de la vision par ordinateur cela signifie regarder les images décodées des pixels que vous passez, dans le domaine de la parole cela signifie écouter les échantillons audio décodés, et pour notre exemple de NLP cela signifie utiliser notre <em>tokenizer</em> pour décoder les entrées :",St,se,Lt,te,Dt,le,Va="Cela semble correct. Vous devriez faire cela pour toutes les clés dans les entrées :",Pt,ne,Kt,ae,Ot,re,za="Notez que les clés qui ne correspondent pas à des entrées acceptées par le modèle seront automatiquement écartées, donc ici nous ne garderons que <code>input_ids</code>, <code>attention_mask</code>, et <code>label</code> (qui sera renommé <code>labels</code>). Pour revérifier la signature du modèle, vous pouvez imprimer la classe de votre modèle, puis aller consulter sa documentation :",el,ie,sl,pe,tl,ue,qa='Donc dans notre cas, nous pouvons vérifier les paramètres acceptés sur <a href="https://huggingface.co/transformers/model_doc/distilbert.html#distilbertforsequenceclassification" rel="nofollow">cette page</a>. Le <code>Trainer</code> va également enregistrer les colonnes qu’il rejette.',ll,oe,xa="Nous avons vérifié que les identifiants d’entrée sont corrects en les décodant. Ensuite, il y a le <code>attention_mask</code> :",nl,me,al,de,rl,ce,_a="Comme nous n’avons pas appliqué de <em>padding</em> dans notre prétraitement, cela semble parfaitement naturel. Pour être sûr qu’il n’y a pas de problème avec ce masque d’attention, vérifions qu’il est de la même longueur que nos identifiants d’entrée :",il,Me,pl,ye,ul,Je,Ya="C’est bien ! Enfin, vérifions notre étiquette :",ol,be,ml,je,dl,fe,Aa="Comme les identifiants d’entrée, c’est un nombre qui n’a pas vraiment de sens en soi. Comme nous l’avons vu précédemment, la correspondance entre les entiers et les noms d’étiquettes est stockée dans l’attribut <code>names</code> de la <em>caractéristique</em> correspondante du jeu de données :",cl,Te,Ml,we,yl,he,Fa="Donc <code>1</code> signifie <code>neutral</code>, ce qui signifie que les deux phrases que nous avons vues ci-dessus ne sont pas en contradiction : la première n’implique pas la seconde. Cela semble correct !",Jl,Ue,Ha="Nous n’avons pas de <em>token</em> de type identifiant ici puisque DistilBERT ne les attend pas. Si vous en avez dans votre modèle, vous devriez également vous assurer qu’ils correspondent correctement à l’endroit où se trouvent la première et la deuxième phrase dans l’entrée.",bl,U,jl,ve,Na="Ici nous ne vérifions que le jeu d’entraînement. Vous devez bien sûr vérifier de la même façon les jeux de validation et de test.",fl,$e,Ea="Maintenant que nous savons que nos jeux de données sont bons, il est temps de vérifier l’étape suivante du pipeline d’entraînement.",Tl,Ce,wl,Ze,Qa="La prochaine chose qui peut mal tourner dans le pipeline d’entraînement est lorsque le <code>Trainer</code> essaie de former des batchs à partir du jeu d’entraînement ou de validation. Une fois que vous êtes sûr que les jeux de données du <code>Trainer</code> sont corrects, vous pouvez essayer de former manuellement un batch en exécutant ce qui suit (remplacez <code>train</code> par <code>eval</code> pour le <em>dataloader</em> de validation) :",hl,Ie,Ul,ke,Sa="Ce code crée le <em>dataloader</em> d’entraînement puis le parcourt en s’arrêtant à la première itération. Si le code s’exécute sans erreur, vous avez le premier batch d’entraînement que vous pouvez inspecter, et si le code se trompe, vous êtes sûr que le problème se situe dans le <em>dataloader</em>, comme c’est le cas ici :",vl,ge,$l,Be,La="L’inspection de la dernière image du <em>traceback</em> devrait suffire à vous donner un indice mais creusons un peu plus. La plupart des problèmes lors de la création d’un batch sont dus à l’assemblage des exemples en un seul batch. La première chose à vérifier en cas de doute est le <code>collate_fn</code> utilisé par votre <code>DataLoader</code> :",Cl,Xe,Zl,We,Il,Re,Da="C’est donc <code>default_data_collator</code>, mais ce n’est pas ce que nous voulons dans ce cas. Nous voulons rembourrer nos exemples à la phrase la plus longue du batch, ce qui est fait par <code>DataCollatorWithPadding</code>. Et cette assembleur de données est censé être utilisé par défaut par le <code>Trainer</code>, alors pourquoi n’est-il pas utilisé ici ?",kl,Ge,Pa="La réponse est que nous n’avons pas passé le <code>tokenizer</code> au <code>Trainer</code>, donc il ne pouvait pas créer le <code>DataCollatorWithPadding</code> que nous voulons. En pratique, il ne faut jamais hésiter à transmettre explicitement l’assembleur de données que l’on veut utiliser pour être sûr d’éviter ce genre d’erreurs. Adaptons notre code pour faire exactement cela :",gl,Ve,Bl,ze,Ka="La bonne nouvelle ? Nous n’avons plus la même erreur qu’avant, ce qui est un progrès certain. La mauvaise nouvelle ? Nous obtenons une erreur CUDA infâme à la place :",Xl,qe,Wl,xe,Oa="C’est une mauvaise chose car les erreurs CUDA sont extrêmement difficiles à déboguer en général. Nous verrons dans une minute comment résoudre ce problème mais terminons d’abord notre analyse de la création de batchs.",Rl,_e,er="Si vous êtes sûr que votre collecteur de données est le bon, vous devriez essayer de l’appliquer sur quelques échantillons de votre jeu de données :",Gl,Ye,Vl,Ae,sr="Ce code échouera parce que le <code>train_dataset</code> contient des colonnes de type <em>string</em> que le <code>Trainer</code> supprime habituellement. Vous pouvez les supprimer manuellement ou si vous voulez reproduire exactement ce que le <code>Trainer</code> fait en coulisse, vous pouvez appeler la méthode <code>Trainer._remove_unused_columns()</code> qui fait cela :",zl,Fe,ql,He,tr="Vous devriez alors être en mesure de déboguer manuellement ce qui se passe dans le collecteur de données si l’erreur persiste.",xl,Ne,lr="Maintenant que nous avons débogué le processus de création de batch, il est temps d’en passer un dans le modèle !",_l,Ee,Yl,Qe,nr="Vous devriez être en mesure d’obtenir un batch en exécutant la commande suivante :",Al,Se,Fl,Le,ar="Si vous exécutez ce code dans un <em>notebook</em>, vous risquez d’obtenir une erreur CUDA similaire à celle que nous avons vue précédemment, auquel cas vous devrez redémarrer votre <em>notebook</em> et réexécuter le dernier extrait sans la ligne <code>trainer.train()</code>. C’est la deuxième chose la plus ennuyeuse à propos des erreurs CUDA : elles cassent irrémédiablement votre noyau. La première plus ennuyeuse est le fait qu’elles sont difficiles à déboguer.",Hl,De,rr="Comment cela se fait-il ? Cela tient à la façon dont les GPUs fonctionnent. Ils sont extrêmement efficaces pour exécuter un batch d’opérations en parallèle, mais l’inconvénient est que lorsque l’une de ces instructions entraîne une erreur, vous ne le savez pas immédiatement. Ce n’est que lorsque le programme appelle une synchronisation des multiples processus sur le GPU qu’il réalise que quelque chose s’est mal passé, de sorte que l’erreur est en fait mentionnée à un endroit qui n’a rien à voir avec ce qui l’a créée. Par exemple, si nous regardons notre <em>traceback</em> précédent, l’erreur a été soulevée pendant la passe arrière, mais nous verrons dans une minute qu’elle provient en fait de quelque chose dans la passe avant.",Nl,Pe,ir="Alors comment déboguer ces erreurs ? La réponse est simple : nous ne le faisons pas. À moins que votre erreur CUDA ne soit une erreur <em>out-of-memory</em> (ce qui signifie qu’il n’y a pas assez de mémoire dans votre GPU), vous devez toujours revenir au CPU pour la déboguer.",El,Ke,pr="Pour faire cela dans notre cas, nous devons juste remettre le modèle sur le CPU et l’appeler sur notre batch. Le batch retourné par le <code>DataLoader</code> n’a pas encore été déplacé sur le GPU :",Ql,Oe,Sl,es,Ll,ss,ur="L’image devient plus claire. Au lieu d’avoir une erreur CUDA, nous avons maintenant une <code>IndexError</code> dans le calcul de la perte (donc rien à voir avec la passe arrière comme nous l’avons dit plus tôt). Plus précisément, nous pouvons voir que c’est la cible 2 qui crée l’erreur, donc c’est un bon moment pour vérifier le nombre de labels de notre modèle :",Dl,ts,Pl,ls,Kl,ns,or="Avec deux étiquettes, seuls les 0 et les 1 sont autorisés comme cibles, mais d’après le message d’erreur, nous avons obtenu un 2. Obtenir un 2 est en fait normal : si nous nous souvenons des noms des étiquettes que nous avons extraits plus tôt, il y en avait trois, donc nous avons les indices 0, 1 et 2 dans notre jeu de données. Le problème est que nous n’avons pas indiqué cela à notre modèle, qui aurait dû être créé avec trois étiquettes. Alors, corrigeons cela !",Ol,as,en,rs,mr="Nous n’incluons pas encore la ligne <code>trainer.train()</code> pour prendre le temps de vérifier que tout se passe bien. Si nous passons un batch à notre modèle, il fonctionne maintenant sans erreur !",sn,is,tn,ps,dr="L’étape suivante consiste alors à revenir au GPU et à vérifier que tout fonctionne encore :",ln,us,nn,os,cr="Si vous obtenez toujours une erreur, assurez-vous de redémarrer votre <em>notebook</em> et d’exécuter uniquement la dernière version du script.",an,ms,rn,ds,Mr="Maintenant que nous savons que nous pouvons construire des batchs qui passent réellement par le modèle, nous sommes prêts pour l’étape suivante du pipeline d’entraînement : calculer les gradients et effectuer une étape d’optimisation.",pn,cs,yr="La première partie est juste une question d’appel de la méthode <code>backward()</code> sur la perte :",un,Ms,on,ys,Jr="Il est plutôt rare d’obtenir une erreur à ce stade, mais si vous en obtenez une, assurez-vous de retourner au CPU pour obtenir un message d’erreur utile.",mn,Js,br="Pour effectuer l’étape d’optimisation, il suffit de créer le <code>optimizer</code> et d’appeler sa méthode <code>step()</code> :",dn,bs,cn,js,jr="Encore une fois, si vous utilisez l’optimiseur par défaut dans le <code>Trainer</code>, vous ne devriez pas avoir d’erreur à ce stade, mais si vous avez un optimiseur personnalisé, il pourrait y avoir quelques problèmes à déboguer ici. N’oubliez pas de revenir au CPU si vous obtenez une erreur CUDA bizarre à ce stade. En parlant d’erreurs CUDA, nous avons mentionné précédemment un cas particulier. Voyons cela maintenant.",Mn,fs,yn,Ts,fr="Chaque fois que vous obtenez un message d’erreur qui commence par <code>RuntimeError : CUDA out of memory</code>, cela indique que vous êtes à court de mémoire GPU. Cela n’est pas directement lié à votre code et peut arriver avec un script qui fonctionne parfaitement bien. Cette erreur signifie que vous avez essayé de mettre trop de choses dans la mémoire interne de votre GPU et que cela a entraîné une erreur. Comme pour d’autres erreurs CUDA, vous devrez redémarrer votre noyau pour être en mesure d’exécuter à nouveau votre entraînement.",Jn,ws,Tr="Pour résoudre ce problème, il suffit d’utiliser moins d’espace GPU, ce qui est souvent plus facile à dire qu’à faire. Tout d’abord, assurez-vous que vous n’avez pas deux modèles sur le GPU en même temps (sauf si cela est nécessaire pour votre problème, bien sûr). Ensuite, vous devriez probablement réduire la taille de votre batch car elle affecte directement les tailles de toutes les sorties intermédiaires du modèle et leurs gradients. Si le problème persiste, envisagez d’utiliser une version plus petite de votre modèle.",bn,v,jn,hs,fn,Us,wr="Maintenant que nous avons résolu tous les problèmes liés à notre code, tout est parfait et l’entraînement devrait se dérouler sans problème, n’est-ce pas ? Pas si vite ! Si vous exécutez la commande <code>trainer.train()</code>, tout aura l’air bien au début, mais après un moment vous obtiendrez ce qui suit :",Tn,vs,wn,$s,hn,Cs,hr="Vous réaliserez que cette erreur apparaît pendant la phase d’évaluation, donc c’est la dernière chose que nous aurons besoin de déboguer.",Un,Zs,Ur="Vous pouvez exécuter la boucle d’évaluation du <code>Trainer</code> indépendamment de l’entraînement comme ceci :",vn,Is,$n,ks,Cn,$,Zn,gs,vr="Avant de tenter de déboguer un problème dans la boucle d’évaluation, vous devez d’abord vous assurer que vous avez examiné les données, que vous êtes en mesure de former un batch correctement et que vous pouvez exécuter votre modèle sur ces données. Nous avons effectué toutes ces étapes, et le code suivant peut donc être exécuté sans erreur :",In,Bs,kn,Xs,$r="L’erreur survient plus tard, à la fin de la phase d’évaluation, et si nous regardons le <em>traceback</em>, nous voyons ceci :",gn,Ws,Bn,Rs,Cr="Cela nous indique que l’erreur provient du module <code>datasets/metric.py</code> donc c’est un problème avec notre fonction <code>compute_metrics()</code>. Elle prend un <em>tuple</em> avec les logits et les labels sous forme de tableaux NumPy, alors essayons de lui fournir cela :",Xn,Gs,Wn,Vs,Rn,zs,Zr="Nous obtenons la même erreur, donc le problème vient bien de cette fonction. Si on regarde son code, on voit qu’elle transmet simplement les <code>predictions</code> et les <code>labels</code> à <code>metric.compute()</code>. Y a-t-il donc un problème avec cette méthode ? Pas vraiment. Jetons un coup d’oeil rapide aux formes :",Gn,qs,Vn,xs,zn,_s,Ir="Nos prédictions sont toujours des logits et non les prédictions réelles, c’est pourquoi la métrique retourne cette erreur (quelque peu obscure). La correction est assez simple, il suffit d’ajouter un argmax dans la fonction <code>compute_metrics()</code> :",qn,Ys,xn,As,_n,Fs,kr="Maintenant notre erreur est corrigée ! C’était la dernière, donc notre script va maintenant entraîner un modèle correctement.",Yn,Hs,gr="Pour référence, voici le script complètement corrigé :",An,Ns,Fn,Es,Br="Dans ce cas, il n’y a plus de problème, et notre script va <em>finetuner</em> un modèle qui devrait donner des résultats raisonnables. Mais que faire lorsque l’entraînement se déroule sans erreur et que le modèle entraîné n’est pas du tout performant ? C’est la partie la plus difficile de l’apprentissage automatique et nous allons vous montrer quelques techniques qui peuvent vous aider.",Hn,C,Nn,Qs,En,Ss,Xr="Que peut-on faire pour déboguer un entraînement qui se termine sans erreur mais qui ne donne pas de bons résultats ? Nous allons vous donner quelques pistes ici, mais sachez que ce type de débogage est la partie la plus difficile de l’apprentissage automatique et qu’il n’y a pas de réponse magique.",Qn,Ls,Sn,Ds,Wr="Votre modèle n’apprendra quelque chose que s’il est réellement possible d’apprendre quelque chose de vos données. Si un <em>bug</em> corrompt les données ou si les étiquettes sont attribuées de manière aléatoire, il est très probable que vous n’obtiendrez aucun entraînement de modèle sur votre jeu de données. Commencez donc toujours par revérifier vos entrées et étiquettes décodées, et posez-vous les questions suivantes :",Ln,Ps,Rr="<li>les données décodées sont-elles compréhensibles ?</li> <li>êtes-vous d’accord avec les étiquettes ?</li> <li>y a-t-il une étiquette qui est plus courante que les autres ?</li> <li>quelle devrait être la perte/métrique si le modèle prédisait une réponse aléatoire/toujours la même réponse ?</li>",Dn,Z,Pn,Ks,Gr="Après avoir examiné vos données, examinez quelques-unes des prédictions du modèle. Si votre modèle produit des <em>tokens</em>, essayez aussi de les décoder ! Si le modèle prédit toujours la même chose, cela peut être dû au fait que votre jeu de données est biaisé en faveur d’une catégorie (pour les problèmes de classification). Des techniques telles que le suréchantillonnage des classes rares peuvent aider. D’autre part, cela peut également être dû à des problèmes d’entraînement tels que de mauvais réglages des hyperparamètres.",Kn,Os,Vr="Si la perte/la métrique que vous obtenez sur votre modèle initial avant entraînement est très différente de la perte/la métrique à laquelle vous vous attendez pour des prédictions aléatoires, vérifiez la façon dont votre perte ou votre métrique est calculée. Il y a probablement un bug. Si vous utilisez plusieurs pertes que vous ajoutez à la fin, assurez-vous qu’elles sont de la même échelle.",On,et,zr="Lorsque vous êtes sûr que vos données sont parfaites, vous pouvez voir si le modèle est capable de s’entraîner sur elles grâce à un test simple.",ea,st,sa,tt,qr="Le surentraînement est généralement une chose que nous essayons d’éviter lors de l’entraînement car cela signifie que le modèle n’apprend pas à reconnaître les caractéristiques générales que nous voulons qu’il reconnaisse et se contente de mémoriser les échantillons d’entraînement. Cependant, essayer d’entraîner votre modèle sur un batch encore et encore est un bon test pour vérifier si le problème tel que vous l’avez formulé peut être résolu par le modèle que vous essayez d’entraîner. Cela vous aidera également à voir si votre taux d’apprentissage initial est trop élevé.",ta,lt,xr="Une fois que vous avez défini votre <code>modèle</code>, c’est très facile. Il suffit de prendre un batch de données d’entraînement, puis de le traiter comme votre jeu de données entier que vous <em>finetunez</em> sur un grand nombre d’époques :",la,nt,na,I,aa,at,_r="Le modèle résultant devrait avoir des résultats proches de la perfection sur le même <code>batch</code>. Calculons la métrique sur les prédictions résultantes :",ra,rt,ia,it,pa,pt,Yr="100% de précision, voilà un bel exemple de surentraînement (ce qui signifie que si vous essayez votre modèle sur n’importe quelle autre phrase, il vous donnera très probablement une mauvaise réponse) !",ua,ut,Ar="Si vous ne parvenez pas à ce que votre modèle obtienne des résultats parfaits comme celui-ci, cela signifie qu’il y a quelque chose qui ne va pas dans la façon dont vous avez formulé le problème ou dans vos données. Vous devez donc y remédier. Ce n’est que lorsque vous parviendrez à passer le test de surentraînement que vous pourrez être sûr que votre modèle peut réellement apprendre quelque chose.",oa,k,ma,ot,da,mt,Fr="Le réglage des hyperparamètres est toujours considéré comme la partie la plus difficile de l’apprentissage automatique mais c’est juste la dernière étape pour vous aider à gagner un peu sur la métrique. La plupart du temps, les hyperparamètres par défaut du <code>Trainer</code> fonctionneront très bien pour vous donner de bons résultats. Donc ne vous lancez pas dans une recherche d’hyperparamètres longue et coûteuse jusqu’à ce que vous ayez quelque chose qui batte la ligne de base que vous avez sur votre jeu de données.",ca,dt,Hr="Une fois que vous avez un modèle suffisamment bon, vous pouvez commencer à le <em>finetuner</em> un peu. N’essayez pas de lancer un millier d’exécutions avec différents hyperparamètres mais comparez quelques exécutions avec différentes valeurs pour un hyperparamètre afin de vous faire une idée de celui qui a le plus d’impact.",Ma,ct,Nr="Si vous modifiez le modèle lui-même, restez simple et n’essayez rien que vous ne puissiez raisonnablement justifier. Veillez toujours à revenir au test de surentraînement pour vérifier que votre modification n’a pas eu de conséquences inattendues.",ya,Mt,Ja,yt,Er='Nous espérons que vous avez trouvé dans cette section des conseils qui vous ont aidé à résoudre votre problème. Si ce n’est pas le cas, n’oubliez pas que vous pouvez toujours demander de l’aide à la communauté sur le <a href="https://discuss.huggingface.co/" rel="nofollow">forum</a>.',ba,Jt,Qr="Voici quelques ressources (en anglais) supplémentaires qui peuvent s’avérer utiles :",ja,bt,Sr='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">La reproductibilité comme vecteur des meilleures pratiques d’ingénierie</a> par Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">Liste de contrôle pour le débogage des réseaux de neurones</a> par Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">Comment tester unitairement le code d’apprentissage automatique</a> par Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">Une recette pour entraîner les réseaux de neurones</a> par Andrej Karpathy</li>',fa,jt,Lr="Bien sûr, tous les problèmes rencontrés lors de l’entraînement ne sont pas forcément de votre faute ! Si vous rencontrez quelque chose dans la bibliothèque 🤗 <em>Transformers</em> ou 🤗 <em>Datasets</em> qui ne semble pas correct, vous avez peut-être trouver un <em>bug</em>. Vous devez absolument nous en parler pour qu’on puisse le corriger. Dans la section suivante, nous allons vous expliquer exactement comment faire.",Ta,ft,wa,ht,ha;return h=new Mi({props:{fw:T[0]}}),g=new w({props:{title:"Débogage du pipeline d’entraînement",local:"débogage-du-pipeline-dentraînement",headingTag:"h1"}}),B=new ci({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter8/section4.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter8/section4.ipynb"}]}}),W=new w({props:{title:"Déboguer le pipeline d’entraînement",local:"déboguer-le-pipeline-dentraînement",headingTag:"h2"}}),R=new di({props:{id:"L-WSwUWde1U"}}),q=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=raw_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=raw_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),_=new J({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBZb3UlMjBoYXZlJTIwdG8lMjBzcGVjaWZ5JTIwZWl0aGVyJTIwaW5wdXRfaWRzJTIwb3IlMjBpbnB1dHNfZW1iZWRzJw==",highlighted:'<span class="hljs-string">&#x27;ValueError: You have to specify either input_ids or inputs_embeds&#x27;</span>',wrap:!1}}),Y=new w({props:{title:"Vérifiez vos données",local:"vérifiez-vos-données",headingTag:"h3"}}),H=new J({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RA==",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),N=new J({props:{code:"JTdCJ2h5cG90aGVzaXMnJTNBJTIwJ1Byb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHklMjBhcmUlMjB3aGF0JTIwbWFrZSUyMGNyZWFtJTIwc2tpbW1pbmclMjB3b3JrLiUyMCclMkMlMEElMjAnaWR4JyUzQSUyMDAlMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCdwcmVtaXNlJyUzQSUyMCdDb25jZXB0dWFsbHklMjBjcmVhbSUyMHNraW1taW5nJTIwaGFzJTIwdHdvJTIwYmFzaWMlMjBkaW1lbnNpb25zJTIwLSUyMHByb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHkuJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;hypothesis&#x27;</span>: <span class="hljs-string">&#x27;Product and geography are what make cream skimming work. &#x27;</span>,
 <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;premise&#x27;</span>: <span class="hljs-string">&#x27;Conceptually cream skimming has two basic dimensions - product and geography.&#x27;</span>}`,wrap:!1}}),S=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),D=new J({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0MyUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjAzNykn",highlighted:'<span class="hljs-string">&#x27;ValueError: expected sequence of length 43 at dim 1 (got 37)&#x27;</span>',wrap:!1}}),K=new J({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaA==",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch`,wrap:!1}}),se=new J({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),te=new J({props:{code:"JyU1QkNMUyU1RCUyMGNvbmNlcHR1YWxseSUyMGNyZWFtJTIwc2tpbW1pbmclMjBoYXMlMjB0d28lMjBiYXNpYyUyMGRpbWVuc2lvbnMlMjAtJTIwcHJvZHVjdCUyMGFuZCUyMGdlb2dyYXBoeS4lMjAlNUJTRVAlNUQlMjBwcm9kdWN0JTIwYW5kJTIwZ2VvZ3JhcGh5JTIwYXJlJTIwd2hhdCUyMG1ha2UlMjBjcmVhbSUyMHNraW1taW5nJTIwd29yay4lMjAlNUJTRVAlNUQn",highlighted:'<span class="hljs-string">&#x27;[CLS] conceptually cream skimming has two basic dimensions - product and geography. [SEP] product and geography are what make cream skimming work. [SEP]&#x27;</span>',wrap:!1}}),ne=new J({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RC5rZXlzKCk=",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>].keys()',wrap:!1}}),ae=new J({props:{code:"ZGljdF9rZXlzKCU1QidhdHRlbnRpb25fbWFzayclMkMlMjAnaHlwb3RoZXNpcyclMkMlMjAnaWR4JyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ2xhYmVsJyUyQyUyMCdwcmVtaXNlJyU1RCk=",highlighted:'dict_keys([<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;hypothesis&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;premise&#x27;</span>])',wrap:!1}}),ie=new J({props:{code:"dHlwZSh0cmFpbmVyLm1vZGVsKQ==",highlighted:'<span class="hljs-built_in">type</span>(trainer.model)',wrap:!1}}),pe=new J({props:{code:"dHJhbnNmb3JtZXJzLm1vZGVscy5kaXN0aWxiZXJ0Lm1vZGVsaW5nX2Rpc3RpbGJlcnQuRGlzdGlsQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24=",highlighted:"transformers.models.distilbert.modeling_distilbert.DistilBertForSequenceClassification",wrap:!1}}),me=new J({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQp",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>])',wrap:!1}}),de=new J({props:{code:"JTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RA==",highlighted:'[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]',wrap:!1}}),Me=new J({props:{code:"bGVuKHRyYWluZXIudHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCklMjAlM0QlM0QlMjBsZW4oJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-built_in">len</span>(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]) == <span class="hljs-built_in">len</span>(
    trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>]
)`,wrap:!1}}),ye=new J({props:{code:"VHJ1ZQ==",highlighted:'<span class="hljs-literal">True</span>',wrap:!1}}),be=new J({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmxhYmVsJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]',wrap:!1}}),je=new J({props:{code:"MQ==",highlighted:'<span class="hljs-number">1</span>',wrap:!1}}),Te=new J({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXM=",highlighted:'trainer.train_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names',wrap:!1}}),we=new J({props:{code:"JTVCJ2VudGFpbG1lbnQnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ2NvbnRyYWRpY3Rpb24nJTVE",highlighted:'[<span class="hljs-string">&#x27;entailment&#x27;</span>, <span class="hljs-string">&#x27;neutral&#x27;</span>, <span class="hljs-string">&#x27;contradiction&#x27;</span>]',wrap:!1}}),U=new Tt({props:{$$slots:{default:[Ji]},$$scope:{ctx:T}}}),Ce=new w({props:{title:"Des jeux de données aux chargeurs de données",local:"des-jeux-de-données-aux-chargeurs-de-données",headingTag:"h3"}}),Ie=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),ge=new J({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQVZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0NSUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjA3Nik=",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch

ValueError: expected sequence of length <span class="hljs-number">45</span> at dim <span class="hljs-number">1</span> (got <span class="hljs-number">76</span>)`,wrap:!1}}),Xe=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBZGF0YV9jb2xsYXRvcg==",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
data_collator`,wrap:!1}}),We=new J({props:{code:"JTNDZnVuY3Rpb24lMjB0cmFuc2Zvcm1lcnMuZGF0YS5kYXRhX2NvbGxhdG9yLmRlZmF1bHRfZGF0YV9jb2xsYXRvcihmZWF0dXJlcyUzQSUyMExpc3QlNUJJbnB1dERhdGFDbGFzcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUzRQ==",highlighted:'&lt;function transformers.data.data_collator.default_data_collator(features: <span class="hljs-type">List</span>[InputDataClass], return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]&gt;',wrap:!1}}),Ve=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),qe=new J({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMGVycm9yJTNBJTIwQ1VCTEFTX1NUQVRVU19BTExPQ19GQUlMRUQlMjB3aGVuJTIwY2FsbGluZyUyMCU2MGN1Ymxhc0NyZWF0ZShoYW5kbGUpJTYw",highlighted:"RuntimeError: CUDA error: CUBLAS_STATUS_ALLOC_FAILED when calling `cublasCreate(handle)`",wrap:!1}}),Ye=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QnRyYWluZXIudHJhaW5fZGF0YXNldCU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSg0KSU1RCk=",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
batch = data_collator([trainer.train_dataset[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Fe=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYWN0dWFsX3RyYWluX3NldCUyMCUzRCUyMHRyYWluZXIuX3JlbW92ZV91bnVzZWRfY29sdW1ucyh0cmFpbmVyLnRyYWluX2RhdGFzZXQpJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QmFjdHVhbF90cmFpbl9zZXQlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQp",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
actual_train_set = trainer._remove_unused_columns(trainer.train_dataset)
batch = data_collator([actual_train_set[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Ee=new w({props:{title:"Passage par le modèle",local:"passage-par-le-modèle",headingTag:"h3"}}),Se=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Oe=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:"outputs = trainer.model.cpu()(**batch)",wrap:!1}}),es=new J({props:{code:"fiUyRi5weWVudiUyRnZlcnNpb25zJTJGMy43LjklMkZlbnZzJTJGYmFzZSUyRmxpYiUyRnB5dGhvbjMuNyUyRnNpdGUtcGFja2FnZXMlMkZ0b3JjaCUyRm5uJTJGZnVuY3Rpb25hbC5weSUyMGluJTIwbmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBzaXplX2F2ZXJhZ2UlMkMlMjBpZ25vcmVfaW5kZXglMkMlMjByZWR1Y2UlMkMlMjByZWR1Y3Rpb24pJTBBJTIwJTIwJTIwMjM4NiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAyMzg3JTIwJTIwJTIwJTIwJTIwaWYlMjBkaW0lMjAlM0QlM0QlMjAyJTNBJTBBLSUzRSUyMDIzODglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXQlMjAlM0QlMjB0b3JjaC5fQy5fbm4ubmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBfUmVkdWN0aW9uLmdldF9lbnVtKHJlZHVjdGlvbiklMkMlMjBpZ25vcmVfaW5kZXgpJTBBJTIwJTIwJTIwMjM4OSUyMCUyMCUyMCUyMCUyMGVsaWYlMjBkaW0lMjAlM0QlM0QlMjA0JTNBJTBBJTIwJTIwJTIwMjM5MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyMCUzRCUyMHRvcmNoLl9DLl9ubi5ubGxfbG9zczJkKGlucHV0JTJDJTIwdGFyZ2V0JTJDJTIwd2VpZ2h0JTJDJTIwX1JlZHVjdGlvbi5nZXRfZW51bShyZWR1Y3Rpb24pJTJDJTIwaWdub3JlX2luZGV4KSUwQSUwQUluZGV4RXJyb3IlM0ElMjBUYXJnZXQlMjAyJTIwaXMlMjBvdXQlMjBvZiUyMGJvdW5kcy4=",highlighted:`~/.pyenv/versions/<span class="hljs-number">3.7</span><span class="hljs-number">.9</span>/envs/base/lib/python3<span class="hljs-number">.7</span>/site-packages/torch/nn/functional.py <span class="hljs-keyword">in</span> nll_loss(<span class="hljs-built_in">input</span>, target, weight, size_average, ignore_index, reduce, reduction)
   <span class="hljs-number">2386</span>         )
   <span class="hljs-number">2387</span>     <span class="hljs-keyword">if</span> dim == <span class="hljs-number">2</span>:
-&gt; <span class="hljs-number">2388</span>         ret = torch._C._nn.nll_loss(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)
   <span class="hljs-number">2389</span>     <span class="hljs-keyword">elif</span> dim == <span class="hljs-number">4</span>:
   <span class="hljs-number">2390</span>         ret = torch._C._nn.nll_loss2d(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)

IndexError: Target <span class="hljs-number">2</span> <span class="hljs-keyword">is</span> out of bounds.`,wrap:!1}}),ts=new J({props:{code:"dHJhaW5lci5tb2RlbC5jb25maWcubnVtX2xhYmVscw==",highlighted:"trainer.model.config.num_labels",wrap:!1}}),ls=new J({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),as=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),is=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

outputs = trainer.model.cpu()(**batch)`,wrap:!1}}),us=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQW91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsLnRvKGRldmljZSkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

outputs = trainer.model.to(device)(**batch)`,wrap:!1}}),ms=new w({props:{title:"Exécution d’une étape d’optimisation",local:"exécution-dune-étape-doptimisation",headingTag:"h3"}}),Ms=new J({props:{code:"bG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvc3MuYmFja3dhcmQoKQ==",highlighted:`loss = outputs.loss
loss.backward()`,wrap:!1}}),bs=new J({props:{code:"dHJhaW5lci5jcmVhdGVfb3B0aW1pemVyKCklMEF0cmFpbmVyLm9wdGltaXplci5zdGVwKCk=",highlighted:`trainer.create_optimizer()
trainer.optimizer.step()`,wrap:!1}}),fs=new w({props:{title:"Gérer les erreurs <i> CUDA out of memory </i>",local:"gérer-les-erreurs-i-cuda-out-of-memory-i",headingTag:"h3"}}),v=new Tt({props:{$$slots:{default:[bi]},$$scope:{ctx:T}}}),hs=new w({props:{title:"Évaluation du modèle",local:"évaluation-du-modèle",headingTag:"h3"}}),vs=new J({props:{code:"JTIzJTIwQ2VsYSUyMHByZW5kcmElMjBiZWF1Y291cCUyMGRlJTIwdGVtcHMlMjBldCUyMHNlJTIwc29sZGVyYSUyMHBhciUyMHVuZSUyMGVycmV1ciUyQyUyMHZvdXMlMjBuZSUyMGRldnJpZXolMjBkb25jJTIwcGFzJTIwdXRpbGlzZXIlMjBjZXR0ZSUyMGNlbGx1bGUuJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># Cela prendra beaucoup de temps et se soldera par une erreur, vous ne devriez donc pas utiliser cette cellule.</span>
trainer.train()`,wrap:!1}}),$s=new J({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),Is=new J({props:{code:"dHJhaW5lci5ldmFsdWF0ZSgp",highlighted:"trainer.evaluate()",wrap:!1}}),ks=new J({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),$=new Tt({props:{$$slots:{default:[ji]},$$scope:{ctx:T}}}),Bs=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X2V2YWxfZGF0YWxvYWRlcigpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWslMEElMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwdHJhaW5lci5tb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_eval_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)`,wrap:!1}}),Ws=new J({props:{code:"fiUyRmdpdCUyRmRhdGFzZXRzJTJGc3JjJTJGZGF0YXNldHMlMkZtZXRyaWMucHklMjBpbiUyMGFkZF9iYXRjaChzZWxmJTJDJTIwcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzKSUwQSUyMCUyMCUyMCUyMDQzMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMDQzMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCJTIycHJlZGljdGlvbnMlMjIlM0ElMjBwcmVkaWN0aW9ucyUyQyUyMCUyMnJlZmVyZW5jZXMlMjIlM0ElMjByZWZlcmVuY2VzJTdEJTBBLS0lM0UlMjA0MzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYuaW5mby5mZWF0dXJlcy5lbmNvZGVfYmF0Y2goYmF0Y2gpJTBBJTIwJTIwJTIwJTIwNDM0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLndyaXRlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQzNSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX2luaXRfd3JpdGVyKCk=",highlighted:`~/git/datasets/src/datasets/metric.py <span class="hljs-keyword">in</span> add_batch(self, predictions, references)
    <span class="hljs-number">431</span>         <span class="hljs-string">&quot;&quot;&quot;
    432         batch = {&quot;predictions&quot;: predictions, &quot;references&quot;: references}
--&gt; 433         batch = self.info.features.encode_batch(batch)
    434         if self.writer is None:
    435             self._init_writer()</span>`,wrap:!1}}),Gs=new J({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKS5udW1weSgpJTBBbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQuY3B1KCkubnVtcHkoKSUwQSUwQWNvbXB1dGVfbWV0cmljcygocHJlZGljdGlvbnMlMkMlMjBsYWJlbHMpKQ==",highlighted:`predictions = outputs.logits.cpu().numpy()
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()

compute_metrics((predictions, labels))`,wrap:!1}}),Vs=new J({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),qs=new J({props:{code:"cHJlZGljdGlvbnMuc2hhcGUlMkMlMjBsYWJlbHMuc2hhcGU=",highlighted:"predictions.shape, labels.shape",wrap:!1}}),xs=new J({props:{code:"KCg4JTJDJTIwMyklMkMlMjAoOCUyQykp",highlighted:'((<span class="hljs-number">8</span>, <span class="hljs-number">3</span>), (<span class="hljs-number">8</span>,))',wrap:!1}}),Ys=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMpJTBBJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkaWN0aW9ucyUyQyUyMGxhYmVscykp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


compute_metrics((predictions, labels))`,wrap:!1}}),As=new J({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjI1JTdE",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.625</span>}',wrap:!1}}),Ns=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),C=new Tt({props:{$$slots:{default:[fi]},$$scope:{ctx:T}}}),Qs=new w({props:{title:"Déboguer les erreurs silencieuses pendant l’entraînement",local:"déboguer-les-erreurs-silencieuses-pendant-lentraînement",headingTag:"h2"}}),Ls=new w({props:{title:"Vérifiez vos données (encore !)",local:"vérifiez-vos-données-encore-",headingTag:"h3"}}),Z=new Tt({props:{warning:!0,$$slots:{default:[Ti]},$$scope:{ctx:T}}}),st=new w({props:{title:"Surentraînement du modèle sur un seul batch",local:"surentraînement-du-modèle-sur-un-seul-batch",headingTag:"h3"}}),nt=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEF0cmFpbmVyLmNyZWF0ZV9vcHRpbWl6ZXIoKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDIwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
trainer.create_optimizer()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    outputs = trainer.model(**batch)
    loss = outputs.loss
    loss.backward()
    trainer.optimizer.step()
    trainer.optimizer.zero_grad()`,wrap:!1}}),I=new Tt({props:{$$slots:{default:[wi]},$$scope:{ctx:T}}}),rt=new J({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBcHJlZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxhYmVscyUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkcy5jcHUoKS5udW1weSgpJTJDJTIwbGFiZWxzLmNwdSgpLm51bXB5KCkpKQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)
preds = outputs.logits
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]

compute_metrics((preds.cpu().numpy(), labels.cpu().numpy()))`,wrap:!1}}),it=new J({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDEuMCU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">1.0</span>}',wrap:!1}}),k=new Tt({props:{warning:!0,$$slots:{default:[hi]},$$scope:{ctx:T}}}),ot=new w({props:{title:"Ne réglez rien tant que vous n’avez pas une première ligne de base",local:"ne-réglez-rien-tant-que-vous-navez-pas-une-première-ligne-de-base",headingTag:"h3"}}),Mt=new w({props:{title:"Demander de l’aide",local:"demander-de-laide",headingTag:"h3"}}),ft=new yi({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter8/4.mdx"}}),{c(){y=r("meta"),j=n(),b=r("p"),f=n(),u(h.$$.fragment),Ut=n(),u(g.$$.fragment),vt=n(),u(B.$$.fragment),$t=n(),X=r("p"),X.innerHTML=Ua,Ct=n(),u(W.$$.fragment),Zt=n(),u(R.$$.fragment),It=n(),G=r("p"),G.innerHTML=va,kt=n(),V=r("p"),V.innerHTML=$a,gt=n(),z=r("p"),z.innerHTML=Ca,Bt=n(),u(q.$$.fragment),Xt=n(),x=r("p"),x.textContent=Za,Wt=n(),u(_.$$.fragment),Rt=n(),u(Y.$$.fragment),Gt=n(),A=r("p"),A.innerHTML=Ia,Vt=n(),F=r("p"),F.innerHTML=ka,zt=n(),u(H.$$.fragment),qt=n(),u(N.$$.fragment),xt=n(),E=r("p"),E.innerHTML=ga,_t=n(),Q=r("p"),Q.innerHTML=Ba,Yt=n(),u(S.$$.fragment),At=n(),L=r("p"),L.textContent=Xa,Ft=n(),u(D.$$.fragment),Ht=n(),P=r("p"),P.innerHTML=Wa,Nt=n(),u(K.$$.fragment),Et=n(),O=r("p"),O.textContent=Ra,Qt=n(),ee=r("p"),ee.innerHTML=Ga,St=n(),u(se.$$.fragment),Lt=n(),u(te.$$.fragment),Dt=n(),le=r("p"),le.textContent=Va,Pt=n(),u(ne.$$.fragment),Kt=n(),u(ae.$$.fragment),Ot=n(),re=r("p"),re.innerHTML=za,el=n(),u(ie.$$.fragment),sl=n(),u(pe.$$.fragment),tl=n(),ue=r("p"),ue.innerHTML=qa,ll=n(),oe=r("p"),oe.innerHTML=xa,nl=n(),u(me.$$.fragment),al=n(),u(de.$$.fragment),rl=n(),ce=r("p"),ce.innerHTML=_a,il=n(),u(Me.$$.fragment),pl=n(),u(ye.$$.fragment),ul=n(),Je=r("p"),Je.textContent=Ya,ol=n(),u(be.$$.fragment),ml=n(),u(je.$$.fragment),dl=n(),fe=r("p"),fe.innerHTML=Aa,cl=n(),u(Te.$$.fragment),Ml=n(),u(we.$$.fragment),yl=n(),he=r("p"),he.innerHTML=Fa,Jl=n(),Ue=r("p"),Ue.innerHTML=Ha,bl=n(),u(U.$$.fragment),jl=n(),ve=r("p"),ve.textContent=Na,fl=n(),$e=r("p"),$e.textContent=Ea,Tl=n(),u(Ce.$$.fragment),wl=n(),Ze=r("p"),Ze.innerHTML=Qa,hl=n(),u(Ie.$$.fragment),Ul=n(),ke=r("p"),ke.innerHTML=Sa,vl=n(),u(ge.$$.fragment),$l=n(),Be=r("p"),Be.innerHTML=La,Cl=n(),u(Xe.$$.fragment),Zl=n(),u(We.$$.fragment),Il=n(),Re=r("p"),Re.innerHTML=Da,kl=n(),Ge=r("p"),Ge.innerHTML=Pa,gl=n(),u(Ve.$$.fragment),Bl=n(),ze=r("p"),ze.textContent=Ka,Xl=n(),u(qe.$$.fragment),Wl=n(),xe=r("p"),xe.textContent=Oa,Rl=n(),_e=r("p"),_e.textContent=er,Gl=n(),u(Ye.$$.fragment),Vl=n(),Ae=r("p"),Ae.innerHTML=sr,zl=n(),u(Fe.$$.fragment),ql=n(),He=r("p"),He.textContent=tr,xl=n(),Ne=r("p"),Ne.textContent=lr,_l=n(),u(Ee.$$.fragment),Yl=n(),Qe=r("p"),Qe.textContent=nr,Al=n(),u(Se.$$.fragment),Fl=n(),Le=r("p"),Le.innerHTML=ar,Hl=n(),De=r("p"),De.innerHTML=rr,Nl=n(),Pe=r("p"),Pe.innerHTML=ir,El=n(),Ke=r("p"),Ke.innerHTML=pr,Ql=n(),u(Oe.$$.fragment),Sl=n(),u(es.$$.fragment),Ll=n(),ss=r("p"),ss.innerHTML=ur,Dl=n(),u(ts.$$.fragment),Pl=n(),u(ls.$$.fragment),Kl=n(),ns=r("p"),ns.textContent=or,Ol=n(),u(as.$$.fragment),en=n(),rs=r("p"),rs.innerHTML=mr,sn=n(),u(is.$$.fragment),tn=n(),ps=r("p"),ps.textContent=dr,ln=n(),u(us.$$.fragment),nn=n(),os=r("p"),os.innerHTML=cr,an=n(),u(ms.$$.fragment),rn=n(),ds=r("p"),ds.textContent=Mr,pn=n(),cs=r("p"),cs.innerHTML=yr,un=n(),u(Ms.$$.fragment),on=n(),ys=r("p"),ys.textContent=Jr,mn=n(),Js=r("p"),Js.innerHTML=br,dn=n(),u(bs.$$.fragment),cn=n(),js=r("p"),js.innerHTML=jr,Mn=n(),u(fs.$$.fragment),yn=n(),Ts=r("p"),Ts.innerHTML=fr,Jn=n(),ws=r("p"),ws.textContent=Tr,bn=n(),u(v.$$.fragment),jn=n(),u(hs.$$.fragment),fn=n(),Us=r("p"),Us.innerHTML=wr,Tn=n(),u(vs.$$.fragment),wn=n(),u($s.$$.fragment),hn=n(),Cs=r("p"),Cs.textContent=hr,Un=n(),Zs=r("p"),Zs.innerHTML=Ur,vn=n(),u(Is.$$.fragment),$n=n(),u(ks.$$.fragment),Cn=n(),u($.$$.fragment),Zn=n(),gs=r("p"),gs.textContent=vr,In=n(),u(Bs.$$.fragment),kn=n(),Xs=r("p"),Xs.innerHTML=$r,gn=n(),u(Ws.$$.fragment),Bn=n(),Rs=r("p"),Rs.innerHTML=Cr,Xn=n(),u(Gs.$$.fragment),Wn=n(),u(Vs.$$.fragment),Rn=n(),zs=r("p"),zs.innerHTML=Zr,Gn=n(),u(qs.$$.fragment),Vn=n(),u(xs.$$.fragment),zn=n(),_s=r("p"),_s.innerHTML=Ir,qn=n(),u(Ys.$$.fragment),xn=n(),u(As.$$.fragment),_n=n(),Fs=r("p"),Fs.textContent=kr,Yn=n(),Hs=r("p"),Hs.textContent=gr,An=n(),u(Ns.$$.fragment),Fn=n(),Es=r("p"),Es.innerHTML=Br,Hn=n(),u(C.$$.fragment),Nn=n(),u(Qs.$$.fragment),En=n(),Ss=r("p"),Ss.textContent=Xr,Qn=n(),u(Ls.$$.fragment),Sn=n(),Ds=r("p"),Ds.innerHTML=Wr,Ln=n(),Ps=r("ul"),Ps.innerHTML=Rr,Dn=n(),u(Z.$$.fragment),Pn=n(),Ks=r("p"),Ks.innerHTML=Gr,Kn=n(),Os=r("p"),Os.textContent=Vr,On=n(),et=r("p"),et.textContent=zr,ea=n(),u(st.$$.fragment),sa=n(),tt=r("p"),tt.textContent=qr,ta=n(),lt=r("p"),lt.innerHTML=xr,la=n(),u(nt.$$.fragment),na=n(),u(I.$$.fragment),aa=n(),at=r("p"),at.innerHTML=_r,ra=n(),u(rt.$$.fragment),ia=n(),u(it.$$.fragment),pa=n(),pt=r("p"),pt.textContent=Yr,ua=n(),ut=r("p"),ut.textContent=Ar,oa=n(),u(k.$$.fragment),ma=n(),u(ot.$$.fragment),da=n(),mt=r("p"),mt.innerHTML=Fr,ca=n(),dt=r("p"),dt.innerHTML=Hr,Ma=n(),ct=r("p"),ct.textContent=Nr,ya=n(),u(Mt.$$.fragment),Ja=n(),yt=r("p"),yt.innerHTML=Er,ba=n(),Jt=r("p"),Jt.textContent=Qr,ja=n(),bt=r("ul"),bt.innerHTML=Sr,fa=n(),jt=r("p"),jt.innerHTML=Lr,Ta=n(),u(ft.$$.fragment),wa=n(),ht=r("p"),this.h()},l(e){const s=oi("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(t),j=a(e),b=i(e,"P",{}),ni(b).forEach(t),f=a(e),o(h.$$.fragment,e),Ut=a(e),o(g.$$.fragment,e),vt=a(e),o(B.$$.fragment,e),$t=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1mau680"&&(X.innerHTML=Ua),Ct=a(e),o(W.$$.fragment,e),Zt=a(e),o(R.$$.fragment,e),It=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1wti6n9"&&(G.innerHTML=va),kt=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-12hq778"&&(V.innerHTML=$a),gt=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-uhthe0"&&(z.innerHTML=Ca),Bt=a(e),o(q.$$.fragment,e),Xt=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-9ibmas"&&(x.textContent=Za),Wt=a(e),o(_.$$.fragment,e),Rt=a(e),o(Y.$$.fragment,e),Gt=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-oi18eq"&&(A.innerHTML=Ia),Vt=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-46r3cm"&&(F.innerHTML=ka),zt=a(e),o(H.$$.fragment,e),qt=a(e),o(N.$$.fragment,e),xt=a(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-sjsxpf"&&(E.innerHTML=ga),_t=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-b15f21"&&(Q.innerHTML=Ba),Yt=a(e),o(S.$$.fragment,e),At=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1vu0r5b"&&(L.textContent=Xa),Ft=a(e),o(D.$$.fragment,e),Ht=a(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-o8enin"&&(P.innerHTML=Wa),Nt=a(e),o(K.$$.fragment,e),Et=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-114xf28"&&(O.textContent=Ra),Qt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-3bqdic"&&(ee.innerHTML=Ga),St=a(e),o(se.$$.fragment,e),Lt=a(e),o(te.$$.fragment,e),Dt=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-ilu6no"&&(le.textContent=Va),Pt=a(e),o(ne.$$.fragment,e),Kt=a(e),o(ae.$$.fragment,e),Ot=a(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-29fifm"&&(re.innerHTML=za),el=a(e),o(ie.$$.fragment,e),sl=a(e),o(pe.$$.fragment,e),tl=a(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-6x2ske"&&(ue.innerHTML=qa),ll=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-cshwr2"&&(oe.innerHTML=xa),nl=a(e),o(me.$$.fragment,e),al=a(e),o(de.$$.fragment,e),rl=a(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-13m88xy"&&(ce.innerHTML=_a),il=a(e),o(Me.$$.fragment,e),pl=a(e),o(ye.$$.fragment,e),ul=a(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-rg6vo0"&&(Je.textContent=Ya),ol=a(e),o(be.$$.fragment,e),ml=a(e),o(je.$$.fragment,e),dl=a(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-8bectx"&&(fe.innerHTML=Aa),cl=a(e),o(Te.$$.fragment,e),Ml=a(e),o(we.$$.fragment,e),yl=a(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-ta3je7"&&(he.innerHTML=Fa),Jl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1xp357l"&&(Ue.innerHTML=Ha),bl=a(e),o(U.$$.fragment,e),jl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-z6tupj"&&(ve.textContent=Na),fl=a(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-10me0ea"&&($e.textContent=Ea),Tl=a(e),o(Ce.$$.fragment,e),wl=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-9nhifg"&&(Ze.innerHTML=Qa),hl=a(e),o(Ie.$$.fragment,e),Ul=a(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-ctw32m"&&(ke.innerHTML=Sa),vl=a(e),o(ge.$$.fragment,e),$l=a(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1809u5i"&&(Be.innerHTML=La),Cl=a(e),o(Xe.$$.fragment,e),Zl=a(e),o(We.$$.fragment,e),Il=a(e),Re=i(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-hcqtmu"&&(Re.innerHTML=Da),kl=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1uspi9s"&&(Ge.innerHTML=Pa),gl=a(e),o(Ve.$$.fragment,e),Bl=a(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-iaknwn"&&(ze.textContent=Ka),Xl=a(e),o(qe.$$.fragment,e),Wl=a(e),xe=i(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-qjorjg"&&(xe.textContent=Oa),Rl=a(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1vv48a3"&&(_e.textContent=er),Gl=a(e),o(Ye.$$.fragment,e),Vl=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1khajlq"&&(Ae.innerHTML=sr),zl=a(e),o(Fe.$$.fragment,e),ql=a(e),He=i(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1b50lld"&&(He.textContent=tr),xl=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1xenmq2"&&(Ne.textContent=lr),_l=a(e),o(Ee.$$.fragment,e),Yl=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1pmcz88"&&(Qe.textContent=nr),Al=a(e),o(Se.$$.fragment,e),Fl=a(e),Le=i(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-gz9b75"&&(Le.innerHTML=ar),Hl=a(e),De=i(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1oan8k6"&&(De.innerHTML=rr),Nl=a(e),Pe=i(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-sv8dgy"&&(Pe.innerHTML=ir),El=a(e),Ke=i(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-rc8lae"&&(Ke.innerHTML=pr),Ql=a(e),o(Oe.$$.fragment,e),Sl=a(e),o(es.$$.fragment,e),Ll=a(e),ss=i(e,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-1t4pvd5"&&(ss.innerHTML=ur),Dl=a(e),o(ts.$$.fragment,e),Pl=a(e),o(ls.$$.fragment,e),Kl=a(e),ns=i(e,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-7wz3hh"&&(ns.textContent=or),Ol=a(e),o(as.$$.fragment,e),en=a(e),rs=i(e,"P",{"data-svelte-h":!0}),p(rs)!=="svelte-1lb6fke"&&(rs.innerHTML=mr),sn=a(e),o(is.$$.fragment,e),tn=a(e),ps=i(e,"P",{"data-svelte-h":!0}),p(ps)!=="svelte-1b3mtla"&&(ps.textContent=dr),ln=a(e),o(us.$$.fragment,e),nn=a(e),os=i(e,"P",{"data-svelte-h":!0}),p(os)!=="svelte-185tg89"&&(os.innerHTML=cr),an=a(e),o(ms.$$.fragment,e),rn=a(e),ds=i(e,"P",{"data-svelte-h":!0}),p(ds)!=="svelte-x8sg8f"&&(ds.textContent=Mr),pn=a(e),cs=i(e,"P",{"data-svelte-h":!0}),p(cs)!=="svelte-7qfszy"&&(cs.innerHTML=yr),un=a(e),o(Ms.$$.fragment,e),on=a(e),ys=i(e,"P",{"data-svelte-h":!0}),p(ys)!=="svelte-du8k11"&&(ys.textContent=Jr),mn=a(e),Js=i(e,"P",{"data-svelte-h":!0}),p(Js)!=="svelte-6dm9x0"&&(Js.innerHTML=br),dn=a(e),o(bs.$$.fragment,e),cn=a(e),js=i(e,"P",{"data-svelte-h":!0}),p(js)!=="svelte-o5dcv1"&&(js.innerHTML=jr),Mn=a(e),o(fs.$$.fragment,e),yn=a(e),Ts=i(e,"P",{"data-svelte-h":!0}),p(Ts)!=="svelte-epc4wu"&&(Ts.innerHTML=fr),Jn=a(e),ws=i(e,"P",{"data-svelte-h":!0}),p(ws)!=="svelte-vju543"&&(ws.textContent=Tr),bn=a(e),o(v.$$.fragment,e),jn=a(e),o(hs.$$.fragment,e),fn=a(e),Us=i(e,"P",{"data-svelte-h":!0}),p(Us)!=="svelte-1bun12"&&(Us.innerHTML=wr),Tn=a(e),o(vs.$$.fragment,e),wn=a(e),o($s.$$.fragment,e),hn=a(e),Cs=i(e,"P",{"data-svelte-h":!0}),p(Cs)!=="svelte-1vlknu0"&&(Cs.textContent=hr),Un=a(e),Zs=i(e,"P",{"data-svelte-h":!0}),p(Zs)!=="svelte-zojrsj"&&(Zs.innerHTML=Ur),vn=a(e),o(Is.$$.fragment,e),$n=a(e),o(ks.$$.fragment,e),Cn=a(e),o($.$$.fragment,e),Zn=a(e),gs=i(e,"P",{"data-svelte-h":!0}),p(gs)!=="svelte-1qybf2m"&&(gs.textContent=vr),In=a(e),o(Bs.$$.fragment,e),kn=a(e),Xs=i(e,"P",{"data-svelte-h":!0}),p(Xs)!=="svelte-uqezsf"&&(Xs.innerHTML=$r),gn=a(e),o(Ws.$$.fragment,e),Bn=a(e),Rs=i(e,"P",{"data-svelte-h":!0}),p(Rs)!=="svelte-1ww5yfm"&&(Rs.innerHTML=Cr),Xn=a(e),o(Gs.$$.fragment,e),Wn=a(e),o(Vs.$$.fragment,e),Rn=a(e),zs=i(e,"P",{"data-svelte-h":!0}),p(zs)!=="svelte-1r96wcf"&&(zs.innerHTML=Zr),Gn=a(e),o(qs.$$.fragment,e),Vn=a(e),o(xs.$$.fragment,e),zn=a(e),_s=i(e,"P",{"data-svelte-h":!0}),p(_s)!=="svelte-1bjjyjz"&&(_s.innerHTML=Ir),qn=a(e),o(Ys.$$.fragment,e),xn=a(e),o(As.$$.fragment,e),_n=a(e),Fs=i(e,"P",{"data-svelte-h":!0}),p(Fs)!=="svelte-1nw2iup"&&(Fs.textContent=kr),Yn=a(e),Hs=i(e,"P",{"data-svelte-h":!0}),p(Hs)!=="svelte-14xtsxo"&&(Hs.textContent=gr),An=a(e),o(Ns.$$.fragment,e),Fn=a(e),Es=i(e,"P",{"data-svelte-h":!0}),p(Es)!=="svelte-rk8392"&&(Es.innerHTML=Br),Hn=a(e),o(C.$$.fragment,e),Nn=a(e),o(Qs.$$.fragment,e),En=a(e),Ss=i(e,"P",{"data-svelte-h":!0}),p(Ss)!=="svelte-84a3qr"&&(Ss.textContent=Xr),Qn=a(e),o(Ls.$$.fragment,e),Sn=a(e),Ds=i(e,"P",{"data-svelte-h":!0}),p(Ds)!=="svelte-1hg9m7"&&(Ds.innerHTML=Wr),Ln=a(e),Ps=i(e,"UL",{"data-svelte-h":!0}),p(Ps)!=="svelte-13wjueb"&&(Ps.innerHTML=Rr),Dn=a(e),o(Z.$$.fragment,e),Pn=a(e),Ks=i(e,"P",{"data-svelte-h":!0}),p(Ks)!=="svelte-1y5bokj"&&(Ks.innerHTML=Gr),Kn=a(e),Os=i(e,"P",{"data-svelte-h":!0}),p(Os)!=="svelte-1l0bmht"&&(Os.textContent=Vr),On=a(e),et=i(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-zy23ex"&&(et.textContent=zr),ea=a(e),o(st.$$.fragment,e),sa=a(e),tt=i(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-17ha5bs"&&(tt.textContent=qr),ta=a(e),lt=i(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-6gk117"&&(lt.innerHTML=xr),la=a(e),o(nt.$$.fragment,e),na=a(e),o(I.$$.fragment,e),aa=a(e),at=i(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1cl2cti"&&(at.innerHTML=_r),ra=a(e),o(rt.$$.fragment,e),ia=a(e),o(it.$$.fragment,e),pa=a(e),pt=i(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-8w843y"&&(pt.textContent=Yr),ua=a(e),ut=i(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-1i6p5e8"&&(ut.textContent=Ar),oa=a(e),o(k.$$.fragment,e),ma=a(e),o(ot.$$.fragment,e),da=a(e),mt=i(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1rugqlt"&&(mt.innerHTML=Fr),ca=a(e),dt=i(e,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1wbne1l"&&(dt.innerHTML=Hr),Ma=a(e),ct=i(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1a5bda8"&&(ct.textContent=Nr),ya=a(e),o(Mt.$$.fragment,e),Ja=a(e),yt=i(e,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-wtra40"&&(yt.innerHTML=Er),ba=a(e),Jt=i(e,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-n3ix2i"&&(Jt.textContent=Qr),ja=a(e),bt=i(e,"UL",{"data-svelte-h":!0}),p(bt)!=="svelte-18a5uom"&&(bt.innerHTML=Sr),fa=a(e),jt=i(e,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-9x6bwk"&&(jt.innerHTML=Lr),Ta=a(e),o(ft.$$.fragment,e),wa=a(e),ht=i(e,"P",{}),ni(ht).forEach(t),this.h()},h(){ai(y,"name","hf:doc:metadata"),ai(y,"content",vi)},m(e,s){mi(document.head,y),l(e,j,s),l(e,b,s),l(e,f,s),m(h,e,s),l(e,Ut,s),m(g,e,s),l(e,vt,s),m(B,e,s),l(e,$t,s),l(e,X,s),l(e,Ct,s),m(W,e,s),l(e,Zt,s),m(R,e,s),l(e,It,s),l(e,G,s),l(e,kt,s),l(e,V,s),l(e,gt,s),l(e,z,s),l(e,Bt,s),m(q,e,s),l(e,Xt,s),l(e,x,s),l(e,Wt,s),m(_,e,s),l(e,Rt,s),m(Y,e,s),l(e,Gt,s),l(e,A,s),l(e,Vt,s),l(e,F,s),l(e,zt,s),m(H,e,s),l(e,qt,s),m(N,e,s),l(e,xt,s),l(e,E,s),l(e,_t,s),l(e,Q,s),l(e,Yt,s),m(S,e,s),l(e,At,s),l(e,L,s),l(e,Ft,s),m(D,e,s),l(e,Ht,s),l(e,P,s),l(e,Nt,s),m(K,e,s),l(e,Et,s),l(e,O,s),l(e,Qt,s),l(e,ee,s),l(e,St,s),m(se,e,s),l(e,Lt,s),m(te,e,s),l(e,Dt,s),l(e,le,s),l(e,Pt,s),m(ne,e,s),l(e,Kt,s),m(ae,e,s),l(e,Ot,s),l(e,re,s),l(e,el,s),m(ie,e,s),l(e,sl,s),m(pe,e,s),l(e,tl,s),l(e,ue,s),l(e,ll,s),l(e,oe,s),l(e,nl,s),m(me,e,s),l(e,al,s),m(de,e,s),l(e,rl,s),l(e,ce,s),l(e,il,s),m(Me,e,s),l(e,pl,s),m(ye,e,s),l(e,ul,s),l(e,Je,s),l(e,ol,s),m(be,e,s),l(e,ml,s),m(je,e,s),l(e,dl,s),l(e,fe,s),l(e,cl,s),m(Te,e,s),l(e,Ml,s),m(we,e,s),l(e,yl,s),l(e,he,s),l(e,Jl,s),l(e,Ue,s),l(e,bl,s),m(U,e,s),l(e,jl,s),l(e,ve,s),l(e,fl,s),l(e,$e,s),l(e,Tl,s),m(Ce,e,s),l(e,wl,s),l(e,Ze,s),l(e,hl,s),m(Ie,e,s),l(e,Ul,s),l(e,ke,s),l(e,vl,s),m(ge,e,s),l(e,$l,s),l(e,Be,s),l(e,Cl,s),m(Xe,e,s),l(e,Zl,s),m(We,e,s),l(e,Il,s),l(e,Re,s),l(e,kl,s),l(e,Ge,s),l(e,gl,s),m(Ve,e,s),l(e,Bl,s),l(e,ze,s),l(e,Xl,s),m(qe,e,s),l(e,Wl,s),l(e,xe,s),l(e,Rl,s),l(e,_e,s),l(e,Gl,s),m(Ye,e,s),l(e,Vl,s),l(e,Ae,s),l(e,zl,s),m(Fe,e,s),l(e,ql,s),l(e,He,s),l(e,xl,s),l(e,Ne,s),l(e,_l,s),m(Ee,e,s),l(e,Yl,s),l(e,Qe,s),l(e,Al,s),m(Se,e,s),l(e,Fl,s),l(e,Le,s),l(e,Hl,s),l(e,De,s),l(e,Nl,s),l(e,Pe,s),l(e,El,s),l(e,Ke,s),l(e,Ql,s),m(Oe,e,s),l(e,Sl,s),m(es,e,s),l(e,Ll,s),l(e,ss,s),l(e,Dl,s),m(ts,e,s),l(e,Pl,s),m(ls,e,s),l(e,Kl,s),l(e,ns,s),l(e,Ol,s),m(as,e,s),l(e,en,s),l(e,rs,s),l(e,sn,s),m(is,e,s),l(e,tn,s),l(e,ps,s),l(e,ln,s),m(us,e,s),l(e,nn,s),l(e,os,s),l(e,an,s),m(ms,e,s),l(e,rn,s),l(e,ds,s),l(e,pn,s),l(e,cs,s),l(e,un,s),m(Ms,e,s),l(e,on,s),l(e,ys,s),l(e,mn,s),l(e,Js,s),l(e,dn,s),m(bs,e,s),l(e,cn,s),l(e,js,s),l(e,Mn,s),m(fs,e,s),l(e,yn,s),l(e,Ts,s),l(e,Jn,s),l(e,ws,s),l(e,bn,s),m(v,e,s),l(e,jn,s),m(hs,e,s),l(e,fn,s),l(e,Us,s),l(e,Tn,s),m(vs,e,s),l(e,wn,s),m($s,e,s),l(e,hn,s),l(e,Cs,s),l(e,Un,s),l(e,Zs,s),l(e,vn,s),m(Is,e,s),l(e,$n,s),m(ks,e,s),l(e,Cn,s),m($,e,s),l(e,Zn,s),l(e,gs,s),l(e,In,s),m(Bs,e,s),l(e,kn,s),l(e,Xs,s),l(e,gn,s),m(Ws,e,s),l(e,Bn,s),l(e,Rs,s),l(e,Xn,s),m(Gs,e,s),l(e,Wn,s),m(Vs,e,s),l(e,Rn,s),l(e,zs,s),l(e,Gn,s),m(qs,e,s),l(e,Vn,s),m(xs,e,s),l(e,zn,s),l(e,_s,s),l(e,qn,s),m(Ys,e,s),l(e,xn,s),m(As,e,s),l(e,_n,s),l(e,Fs,s),l(e,Yn,s),l(e,Hs,s),l(e,An,s),m(Ns,e,s),l(e,Fn,s),l(e,Es,s),l(e,Hn,s),m(C,e,s),l(e,Nn,s),m(Qs,e,s),l(e,En,s),l(e,Ss,s),l(e,Qn,s),m(Ls,e,s),l(e,Sn,s),l(e,Ds,s),l(e,Ln,s),l(e,Ps,s),l(e,Dn,s),m(Z,e,s),l(e,Pn,s),l(e,Ks,s),l(e,Kn,s),l(e,Os,s),l(e,On,s),l(e,et,s),l(e,ea,s),m(st,e,s),l(e,sa,s),l(e,tt,s),l(e,ta,s),l(e,lt,s),l(e,la,s),m(nt,e,s),l(e,na,s),m(I,e,s),l(e,aa,s),l(e,at,s),l(e,ra,s),m(rt,e,s),l(e,ia,s),m(it,e,s),l(e,pa,s),l(e,pt,s),l(e,ua,s),l(e,ut,s),l(e,oa,s),m(k,e,s),l(e,ma,s),m(ot,e,s),l(e,da,s),l(e,mt,s),l(e,ca,s),l(e,dt,s),l(e,Ma,s),l(e,ct,s),l(e,ya,s),m(Mt,e,s),l(e,Ja,s),l(e,yt,s),l(e,ba,s),l(e,Jt,s),l(e,ja,s),l(e,bt,s),l(e,fa,s),l(e,jt,s),l(e,Ta,s),m(ft,e,s),l(e,wa,s),l(e,ht,s),ha=!0},p(e,[s]){const Dr={};s&1&&(Dr.fw=e[0]),h.$set(Dr);const Pr={};s&2&&(Pr.$$scope={dirty:s,ctx:e}),U.$set(Pr);const Kr={};s&2&&(Kr.$$scope={dirty:s,ctx:e}),v.$set(Kr);const Or={};s&2&&(Or.$$scope={dirty:s,ctx:e}),$.$set(Or);const ei={};s&2&&(ei.$$scope={dirty:s,ctx:e}),C.$set(ei);const si={};s&2&&(si.$$scope={dirty:s,ctx:e}),Z.$set(si);const ti={};s&2&&(ti.$$scope={dirty:s,ctx:e}),I.$set(ti);const li={};s&2&&(li.$$scope={dirty:s,ctx:e}),k.$set(li)},i(e){ha||(d(h.$$.fragment,e),d(g.$$.fragment,e),d(B.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(q.$$.fragment,e),d(_.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d(we.$$.fragment,e),d(U.$$.fragment,e),d(Ce.$$.fragment,e),d(Ie.$$.fragment,e),d(ge.$$.fragment,e),d(Xe.$$.fragment,e),d(We.$$.fragment,e),d(Ve.$$.fragment,e),d(qe.$$.fragment,e),d(Ye.$$.fragment,e),d(Fe.$$.fragment,e),d(Ee.$$.fragment,e),d(Se.$$.fragment,e),d(Oe.$$.fragment,e),d(es.$$.fragment,e),d(ts.$$.fragment,e),d(ls.$$.fragment,e),d(as.$$.fragment,e),d(is.$$.fragment,e),d(us.$$.fragment,e),d(ms.$$.fragment,e),d(Ms.$$.fragment,e),d(bs.$$.fragment,e),d(fs.$$.fragment,e),d(v.$$.fragment,e),d(hs.$$.fragment,e),d(vs.$$.fragment,e),d($s.$$.fragment,e),d(Is.$$.fragment,e),d(ks.$$.fragment,e),d($.$$.fragment,e),d(Bs.$$.fragment,e),d(Ws.$$.fragment,e),d(Gs.$$.fragment,e),d(Vs.$$.fragment,e),d(qs.$$.fragment,e),d(xs.$$.fragment,e),d(Ys.$$.fragment,e),d(As.$$.fragment,e),d(Ns.$$.fragment,e),d(C.$$.fragment,e),d(Qs.$$.fragment,e),d(Ls.$$.fragment,e),d(Z.$$.fragment,e),d(st.$$.fragment,e),d(nt.$$.fragment,e),d(I.$$.fragment,e),d(rt.$$.fragment,e),d(it.$$.fragment,e),d(k.$$.fragment,e),d(ot.$$.fragment,e),d(Mt.$$.fragment,e),d(ft.$$.fragment,e),ha=!0)},o(e){c(h.$$.fragment,e),c(g.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(q.$$.fragment,e),c(_.$$.fragment,e),c(Y.$$.fragment,e),c(H.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(se.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(de.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(be.$$.fragment,e),c(je.$$.fragment,e),c(Te.$$.fragment,e),c(we.$$.fragment,e),c(U.$$.fragment,e),c(Ce.$$.fragment,e),c(Ie.$$.fragment,e),c(ge.$$.fragment,e),c(Xe.$$.fragment,e),c(We.$$.fragment,e),c(Ve.$$.fragment,e),c(qe.$$.fragment,e),c(Ye.$$.fragment,e),c(Fe.$$.fragment,e),c(Ee.$$.fragment,e),c(Se.$$.fragment,e),c(Oe.$$.fragment,e),c(es.$$.fragment,e),c(ts.$$.fragment,e),c(ls.$$.fragment,e),c(as.$$.fragment,e),c(is.$$.fragment,e),c(us.$$.fragment,e),c(ms.$$.fragment,e),c(Ms.$$.fragment,e),c(bs.$$.fragment,e),c(fs.$$.fragment,e),c(v.$$.fragment,e),c(hs.$$.fragment,e),c(vs.$$.fragment,e),c($s.$$.fragment,e),c(Is.$$.fragment,e),c(ks.$$.fragment,e),c($.$$.fragment,e),c(Bs.$$.fragment,e),c(Ws.$$.fragment,e),c(Gs.$$.fragment,e),c(Vs.$$.fragment,e),c(qs.$$.fragment,e),c(xs.$$.fragment,e),c(Ys.$$.fragment,e),c(As.$$.fragment,e),c(Ns.$$.fragment,e),c(C.$$.fragment,e),c(Qs.$$.fragment,e),c(Ls.$$.fragment,e),c(Z.$$.fragment,e),c(st.$$.fragment,e),c(nt.$$.fragment,e),c(I.$$.fragment,e),c(rt.$$.fragment,e),c(it.$$.fragment,e),c(k.$$.fragment,e),c(ot.$$.fragment,e),c(Mt.$$.fragment,e),c(ft.$$.fragment,e),ha=!1},d(e){e&&(t(j),t(b),t(f),t(Ut),t(vt),t($t),t(X),t(Ct),t(Zt),t(It),t(G),t(kt),t(V),t(gt),t(z),t(Bt),t(Xt),t(x),t(Wt),t(Rt),t(Gt),t(A),t(Vt),t(F),t(zt),t(qt),t(xt),t(E),t(_t),t(Q),t(Yt),t(At),t(L),t(Ft),t(Ht),t(P),t(Nt),t(Et),t(O),t(Qt),t(ee),t(St),t(Lt),t(Dt),t(le),t(Pt),t(Kt),t(Ot),t(re),t(el),t(sl),t(tl),t(ue),t(ll),t(oe),t(nl),t(al),t(rl),t(ce),t(il),t(pl),t(ul),t(Je),t(ol),t(ml),t(dl),t(fe),t(cl),t(Ml),t(yl),t(he),t(Jl),t(Ue),t(bl),t(jl),t(ve),t(fl),t($e),t(Tl),t(wl),t(Ze),t(hl),t(Ul),t(ke),t(vl),t($l),t(Be),t(Cl),t(Zl),t(Il),t(Re),t(kl),t(Ge),t(gl),t(Bl),t(ze),t(Xl),t(Wl),t(xe),t(Rl),t(_e),t(Gl),t(Vl),t(Ae),t(zl),t(ql),t(He),t(xl),t(Ne),t(_l),t(Yl),t(Qe),t(Al),t(Fl),t(Le),t(Hl),t(De),t(Nl),t(Pe),t(El),t(Ke),t(Ql),t(Sl),t(Ll),t(ss),t(Dl),t(Pl),t(Kl),t(ns),t(Ol),t(en),t(rs),t(sn),t(tn),t(ps),t(ln),t(nn),t(os),t(an),t(rn),t(ds),t(pn),t(cs),t(un),t(on),t(ys),t(mn),t(Js),t(dn),t(cn),t(js),t(Mn),t(yn),t(Ts),t(Jn),t(ws),t(bn),t(jn),t(fn),t(Us),t(Tn),t(wn),t(hn),t(Cs),t(Un),t(Zs),t(vn),t($n),t(Cn),t(Zn),t(gs),t(In),t(kn),t(Xs),t(gn),t(Bn),t(Rs),t(Xn),t(Wn),t(Rn),t(zs),t(Gn),t(Vn),t(zn),t(_s),t(qn),t(xn),t(_n),t(Fs),t(Yn),t(Hs),t(An),t(Fn),t(Es),t(Hn),t(Nn),t(En),t(Ss),t(Qn),t(Sn),t(Ds),t(Ln),t(Ps),t(Dn),t(Pn),t(Ks),t(Kn),t(Os),t(On),t(et),t(ea),t(sa),t(tt),t(ta),t(lt),t(la),t(na),t(aa),t(at),t(ra),t(ia),t(pa),t(pt),t(ua),t(ut),t(oa),t(ma),t(da),t(mt),t(ca),t(dt),t(Ma),t(ct),t(ya),t(Ja),t(yt),t(ba),t(Jt),t(ja),t(bt),t(fa),t(jt),t(Ta),t(wa),t(ht)),t(y),M(h,e),M(g,e),M(B,e),M(W,e),M(R,e),M(q,e),M(_,e),M(Y,e),M(H,e),M(N,e),M(S,e),M(D,e),M(K,e),M(se,e),M(te,e),M(ne,e),M(ae,e),M(ie,e),M(pe,e),M(me,e),M(de,e),M(Me,e),M(ye,e),M(be,e),M(je,e),M(Te,e),M(we,e),M(U,e),M(Ce,e),M(Ie,e),M(ge,e),M(Xe,e),M(We,e),M(Ve,e),M(qe,e),M(Ye,e),M(Fe,e),M(Ee,e),M(Se,e),M(Oe,e),M(es,e),M(ts,e),M(ls,e),M(as,e),M(is,e),M(us,e),M(ms,e),M(Ms,e),M(bs,e),M(fs,e),M(v,e),M(hs,e),M(vs,e),M($s,e),M(Is,e),M(ks,e),M($,e),M(Bs,e),M(Ws,e),M(Gs,e),M(Vs,e),M(qs,e),M(xs,e),M(Ys,e),M(As,e),M(Ns,e),M(C,e),M(Qs,e),M(Ls,e),M(Z,e),M(st,e),M(nt,e),M(I,e),M(rt,e),M(it,e),M(k,e),M(ot,e),M(Mt,e),M(ft,e)}}}const vi='{"title":"Débogage du pipeline d’entraînement","local":"débogage-du-pipeline-dentraînement","sections":[{"title":"Déboguer le pipeline d’entraînement","local":"déboguer-le-pipeline-dentraînement","sections":[{"title":"Vérifiez vos données","local":"vérifiez-vos-données","sections":[],"depth":3},{"title":"Des jeux de données aux chargeurs de données","local":"des-jeux-de-données-aux-chargeurs-de-données","sections":[],"depth":3},{"title":"Passage par le modèle","local":"passage-par-le-modèle","sections":[],"depth":3},{"title":"Exécution d’une étape d’optimisation","local":"exécution-dune-étape-doptimisation","sections":[],"depth":3},{"title":"Gérer les erreurs <i> CUDA out of memory </i>","local":"gérer-les-erreurs-i-cuda-out-of-memory-i","sections":[],"depth":3},{"title":"Évaluation du modèle","local":"évaluation-du-modèle","sections":[],"depth":3}],"depth":2},{"title":"Déboguer les erreurs silencieuses pendant l’entraînement","local":"déboguer-les-erreurs-silencieuses-pendant-lentraînement","sections":[{"title":"Vérifiez vos données (encore !)","local":"vérifiez-vos-données-encore-","sections":[],"depth":3},{"title":"Surentraînement du modèle sur un seul batch","local":"surentraînement-du-modèle-sur-un-seul-batch","sections":[],"depth":3},{"title":"Ne réglez rien tant que vous n’avez pas une première ligne de base","local":"ne-réglez-rien-tant-que-vous-navez-pas-une-première-ligne-de-base","sections":[],"depth":3},{"title":"Demander de l’aide","local":"demander-de-laide","sections":[],"depth":3}],"depth":2}],"depth":1}';function $i(T,y,j){let b="pt";return ii(()=>{const f=new URLSearchParams(window.location.search);j(0,b=f.get("fw")||"pt")}),[b]}class Ri extends pi{constructor(y){super(),ui(this,y,$i,Ui,ri,{})}}export{Ri as component};
