import{s as Cs,o as Ls,n as Jl}from"../chunks/scheduler.c57aa7ef.js";import{S as Rs,i as Bs,g as i,s,r as p,A as Is,h as o,f as a,c as n,j as Us,u as d,x as r,k as bl,y as Ws,a as l,v as m,d as f,t as h,w as u}from"../chunks/index.394f8801.js";import{T as Tl}from"../chunks/Tip.23dfb1a9.js";import{C as M}from"../chunks/CodeBlock.5228ed01.js";import{H as y,E as As}from"../chunks/EditOnGithub.157fddbf.js";function Gs(T){let c,g='For further instructions on using EVA, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/eva_finetuning" rel="nofollow">documentation</a>.';return{c(){c=i("p"),c.innerHTML=g},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-9hfq4t"&&(c.innerHTML=g)},m(w,b){l(w,c,b)},p:Jl,d(w){w&&a(c)}}}function Vs(T){let c,g='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=g},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=g)},m(w,b){l(w,c,b)},p:Jl,d(w){w&&a(c)}}}function Qs(T){let c,g='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=g},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=g)},m(w,b){l(w,c,b)},p:Jl,d(w){w&&a(c)}}}function Hs(T){let c,g,w,b,Z,Tt,j,_l='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/pr_1324/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/pr_1324/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Jt,k,$l="This guide explores in more detail other options and features for using LoRA.",_t,U,$t,C,vl='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',vt,L,Zl='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Zt,R,jt,B,jl="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",kt,I,Ut,W,Ct,A,kl='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',Lt,G,Ul="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",Rt,V,Bt,Q,Cl="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",It,H,Wt,x,Ll='For detailed instruction on using PiSSA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',At,z,Gt,X,Rl='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',Vt,q,Bl="You just need to pass a single additional option to use OLoRA:",Qt,E,Ht,F,Il='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',xt,Y,zt,N,Wl='<a href="https://arxiv.org/pdf/2410.07170" rel="nofollow">EVA</a> performs SVD on the input activations of each layer and uses the right-singular vectors to initialize LoRA weights. It is therefore a data-driven initialization scheme. Furthermore EVA adaptively allocates ranks across layers based on their “explained variance ratio” - a metric derived from the SVD analysis.',Xt,S,Al='You can use EVA by setting <code>init_lora_weights=&quot;eva&quot;</code> and defining <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.EvaConfig">EvaConfig</a> in <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>:',qt,P,Et,D,Gl="The parameter <code>rho</code> (≥ 1.0) determines how much redistribution is allowed. When <code>rho=1.0</code> and <code>r=16</code>, LoRA adapters are limited to exactly 16 ranks, preventing any redistribution from occurring. A recommended value for EVA with redistribution is 2.0, meaning the maximum rank allowed for a layer is 2r.",Ft,K,Vl='It is recommended to perform EVA initialization on a GPU as it is much faster. To optimize the amount of available memory for EVA, you can use the <code>low_cpu_mem_usage</code> flag in <a href="/docs/peft/pr_1324/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>:',Yt,O,Nt,ee,Ql='Then, call <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> to initialize the EVA weights (in most cases the dataloader used for eva initialization can be the same as the one used for finetuning):',St,te,Pt,ae,Hl='EVA works out of the box with bitsandbytes. Simply initialize the model with <code>quantization_config</code> and call <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> as usual.',Dt,J,Kt,le,Ot,se,ea,ne,xl='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',ta,ie,zl="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",aa,oe,la,re,Xl="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",sa,pe,na,de,ql='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',ia,me,El="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",oa,fe,Fl="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",ra,he,Yl="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",pa,_,da,ue,ma,ce,Nl='Another way to initialize <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',fa,Me,ha,we,ua,ye,Sl='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',ca,ge,Ma,be,Pl="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",wa,Te,ya,Je,Dl="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",ga,_e,ba,$e,Kl=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,Ta,ve,Ol='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',Ja,Ze,_a,je,es='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',$a,ke,va,Ue,ts='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Za,Ce,ja,Le,ka,Re,as='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Ua,Be,Ca,Ie,ls='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',La,We,ss=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,Ra,Ae,Ba,Ge,ns="LoRA training can optionally include special purpose optimizers. Currently the only such optimizer is LoRA+.",Ia,Ve,Wa,Qe,is='LoRA training can be optimized using <a href="https://arxiv.org/abs/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',Aa,He,Ga,xe,Va,ze,os='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Qa,Xe,rs="Below is a diagram that explains the intuition of LoRA adapter merging:",Ha,$,ps='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',xa,qe,ds="We show in the snippets below how to run that using PEFT.",za,Ee,Xa,Fe,ms='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/pr_1324/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/pr_1324/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',qa,Ye,Ea,Ne,fs='The <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',Fa,Se,hs="First load the base model:",Ya,Pe,Na,De,us="Then we load the first adapter:",Sa,Ke,Pa,Oe,cs="Then load a different adapter and merge it with the first one:",Da,et,Ka,v,Oa,tt,Ms="Now, perform inference:",el,at,tl,lt,al,st,ws='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/pr_1324/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',ll,nt,sl,it,ys='To return the base model, you could use <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/pr_1324/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',nl,ot,il,rt,ol,pt,gs="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",rl,dt,bs="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",pl,mt,dl,ft,Ts="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",ml,ht,fl,ut,Js="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",hl,ct,_s="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",ul,Mt,cl,wt,$s="Using this features has some drawbacks, namely:",Ml,yt,vs='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',wl,gt,yl,bt,gl;return Z=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),U=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),R=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),I=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),W=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),V=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),H=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLiklMjA=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...) ',wrap:!1}}),z=new y({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),E=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),Y=new y({props:{title:"EVA",local:"eva",headingTag:"h3"}}),P=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwRXZhQ29uZmlnJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTIwJTNEJTIwJTIyZXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhX2NvbmZpZyUyMCUzRCUyMEV2YUNvbmZpZyhyaG8lMjAlM0QlMjAyLjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, EvaConfig
peft_config = LoraConfig(
    init_lora_weights = <span class="hljs-string">&quot;eva&quot;</span>,
    eva_config = EvaConfig(rho = <span class="hljs-number">2.0</span>),
    ...
)`,wrap:!1}}),O=new M({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWclMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:'peft_model = get_peft_model(model, peft_config, low_cpu_mem_usage=<span class="hljs-literal">True</span>)',wrap:!1}}),te=new M({props:{code:"aW5pdGlhbGl6ZV9sb3JhX2V2YV93ZWlnaHRzKHBlZnRfbW9kZWwlMkMlMjBkYXRhbG9hZGVyKQ==",highlighted:"initialize_lora_eva_weights(peft_model, dataloader)",wrap:!1}}),J=new Tl({props:{$$slots:{default:[Gs]},$$scope:{ctx:T}}}),le=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),se=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),oe=new y({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),pe=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),_=new Tl({props:{$$slots:{default:[Vs]},$$scope:{ctx:T}}}),ue=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),Me=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),we=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),ge=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),Te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),_e=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ze=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),ke=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),Ce=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),Le=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),Be=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),Ae=new y({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),Ve=new y({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),He=new M({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),xe=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),Ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),Ye=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),Pe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Ke=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),et=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),v=new Tl({props:{$$slots:{default:[Qs]},$$scope:{ctx:T}}}),at=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),lt=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),nt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ot=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),rt=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),mt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),ht=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Mt=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),gt=new As({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),g=s(),w=i("p"),b=s(),p(Z.$$.fragment),Tt=s(),j=i("p"),j.innerHTML=_l,Jt=s(),k=i("p"),k.textContent=$l,_t=s(),p(U.$$.fragment),$t=s(),C=i("p"),C.innerHTML=vl,vt=s(),L=i("p"),L.innerHTML=Zl,Zt=s(),p(R.$$.fragment),jt=s(),B=i("p"),B.innerHTML=jl,kt=s(),p(I.$$.fragment),Ut=s(),p(W.$$.fragment),Ct=s(),A=i("p"),A.innerHTML=kl,Lt=s(),G=i("p"),G.textContent=Ul,Rt=s(),p(V.$$.fragment),Bt=s(),Q=i("p"),Q.textContent=Cl,It=s(),p(H.$$.fragment),Wt=s(),x=i("p"),x.innerHTML=Ll,At=s(),p(z.$$.fragment),Gt=s(),X=i("p"),X.innerHTML=Rl,Vt=s(),q=i("p"),q.textContent=Bl,Qt=s(),p(E.$$.fragment),Ht=s(),F=i("p"),F.innerHTML=Il,xt=s(),p(Y.$$.fragment),zt=s(),N=i("p"),N.innerHTML=Wl,Xt=s(),S=i("p"),S.innerHTML=Al,qt=s(),p(P.$$.fragment),Et=s(),D=i("p"),D.innerHTML=Gl,Ft=s(),K=i("p"),K.innerHTML=Vl,Yt=s(),p(O.$$.fragment),Nt=s(),ee=i("p"),ee.innerHTML=Ql,St=s(),p(te.$$.fragment),Pt=s(),ae=i("p"),ae.innerHTML=Hl,Dt=s(),p(J.$$.fragment),Kt=s(),p(le.$$.fragment),Ot=s(),p(se.$$.fragment),ea=s(),ne=i("p"),ne.innerHTML=xl,ta=s(),ie=i("p"),ie.innerHTML=zl,aa=s(),p(oe.$$.fragment),la=s(),re=i("p"),re.innerHTML=Xl,sa=s(),p(pe.$$.fragment),na=s(),de=i("p"),de.innerHTML=ql,ia=s(),me=i("p"),me.innerHTML=El,oa=s(),fe=i("p"),fe.innerHTML=Fl,ra=s(),he=i("ul"),he.innerHTML=Yl,pa=s(),p(_.$$.fragment),da=s(),p(ue.$$.fragment),ma=s(),ce=i("p"),ce.innerHTML=Nl,fa=s(),p(Me.$$.fragment),ha=s(),p(we.$$.fragment),ua=s(),ye=i("p"),ye.innerHTML=Sl,ca=s(),p(ge.$$.fragment),Ma=s(),be=i("p"),be.innerHTML=Pl,wa=s(),p(Te.$$.fragment),ya=s(),Je=i("p"),Je.innerHTML=Dl,ga=s(),p(_e.$$.fragment),ba=s(),$e=i("p"),$e.innerHTML=Kl,Ta=s(),ve=i("table"),ve.innerHTML=Ol,Ja=s(),p(Ze.$$.fragment),_a=s(),je=i("ul"),je.innerHTML=es,$a=s(),p(ke.$$.fragment),va=s(),Ue=i("p"),Ue.innerHTML=ts,Za=s(),p(Ce.$$.fragment),ja=s(),p(Le.$$.fragment),ka=s(),Re=i("p"),Re.innerHTML=as,Ua=s(),p(Be.$$.fragment),Ca=s(),Ie=i("p"),Ie.innerHTML=ls,La=s(),We=i("p"),We.innerHTML=ss,Ra=s(),p(Ae.$$.fragment),Ba=s(),Ge=i("p"),Ge.textContent=ns,Ia=s(),p(Ve.$$.fragment),Wa=s(),Qe=i("p"),Qe.innerHTML=is,Aa=s(),p(He.$$.fragment),Ga=s(),p(xe.$$.fragment),Va=s(),ze=i("p"),ze.innerHTML=os,Qa=s(),Xe=i("p"),Xe.textContent=rs,Ha=s(),$=i("div"),$.innerHTML=ps,xa=s(),qe=i("p"),qe.textContent=ds,za=s(),p(Ee.$$.fragment),Xa=s(),Fe=i("p"),Fe.innerHTML=ms,qa=s(),p(Ye.$$.fragment),Ea=s(),Ne=i("p"),Ne.innerHTML=fs,Fa=s(),Se=i("p"),Se.textContent=hs,Ya=s(),p(Pe.$$.fragment),Na=s(),De=i("p"),De.textContent=us,Sa=s(),p(Ke.$$.fragment),Pa=s(),Oe=i("p"),Oe.textContent=cs,Da=s(),p(et.$$.fragment),Ka=s(),p(v.$$.fragment),Oa=s(),tt=i("p"),tt.textContent=Ms,el=s(),p(at.$$.fragment),tl=s(),p(lt.$$.fragment),al=s(),st=i("p"),st.innerHTML=ws,ll=s(),p(nt.$$.fragment),sl=s(),it=i("p"),it.innerHTML=ys,nl=s(),p(ot.$$.fragment),il=s(),p(rt.$$.fragment),ol=s(),pt=i("p"),pt.textContent=gs,rl=s(),dt=i("p"),dt.innerHTML=bs,pl=s(),p(mt.$$.fragment),dl=s(),ft=i("p"),ft.innerHTML=Ts,ml=s(),p(ht.$$.fragment),fl=s(),ut=i("p"),ut.innerHTML=Js,hl=s(),ct=i("p"),ct.innerHTML=_s,ul=s(),p(Mt.$$.fragment),cl=s(),wt=i("p"),wt.textContent=$s,Ml=s(),yt=i("ul"),yt.innerHTML=vs,wl=s(),p(gt.$$.fragment),yl=s(),bt=i("p"),this.h()},l(e){const t=Is("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),g=n(e),w=o(e,"P",{}),Us(w).forEach(a),b=n(e),d(Z.$$.fragment,e),Tt=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-p00je4"&&(j.innerHTML=_l),Jt=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ovsn32"&&(k.textContent=$l),_t=n(e),d(U.$$.fragment,e),$t=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-17lw2fr"&&(C.innerHTML=vl),vt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1fujb7a"&&(L.innerHTML=Zl),Zt=n(e),d(R.$$.fragment,e),jt=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-mwvui1"&&(B.innerHTML=jl),kt=n(e),d(I.$$.fragment,e),Ut=n(e),d(W.$$.fragment,e),Ct=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1skluc"&&(A.innerHTML=kl),Lt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1hy0lgx"&&(G.textContent=Ul),Rt=n(e),d(V.$$.fragment,e),Bt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-auzrbb"&&(Q.textContent=Cl),It=n(e),d(H.$$.fragment,e),Wt=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-16k39wq"&&(x.innerHTML=Ll),At=n(e),d(z.$$.fragment,e),Gt=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-17kc0j8"&&(X.innerHTML=Rl),Vt=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1j9g8qn"&&(q.textContent=Bl),Qt=n(e),d(E.$$.fragment,e),Ht=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-sulxp4"&&(F.innerHTML=Il),xt=n(e),d(Y.$$.fragment,e),zt=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-jrbt6r"&&(N.innerHTML=Wl),Xt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1pf31q8"&&(S.innerHTML=Al),qt=n(e),d(P.$$.fragment,e),Et=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-168zxvb"&&(D.innerHTML=Gl),Ft=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-lbwrph"&&(K.innerHTML=Vl),Yt=n(e),d(O.$$.fragment,e),Nt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-9mytae"&&(ee.innerHTML=Ql),St=n(e),d(te.$$.fragment,e),Pt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-ku7xgt"&&(ae.innerHTML=Hl),Dt=n(e),d(J.$$.fragment,e),Kt=n(e),d(le.$$.fragment,e),Ot=n(e),d(se.$$.fragment,e),ea=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1ts8vpq"&&(ne.innerHTML=xl),ta=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-7f0aai"&&(ie.innerHTML=zl),aa=n(e),d(oe.$$.fragment,e),la=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-14vtcq9"&&(re.innerHTML=Xl),sa=n(e),d(pe.$$.fragment,e),na=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1nywyxh"&&(de.innerHTML=ql),ia=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1d2jix1"&&(me.innerHTML=El),oa=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-yl8kok"&&(fe.innerHTML=Fl),ra=n(e),he=o(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-12tl4fy"&&(he.innerHTML=Yl),pa=n(e),d(_.$$.fragment,e),da=n(e),d(ue.$$.fragment,e),ma=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-n4u4ov"&&(ce.innerHTML=Nl),fa=n(e),d(Me.$$.fragment,e),ha=n(e),d(we.$$.fragment,e),ua=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1ukfkwt"&&(ye.innerHTML=Sl),ca=n(e),d(ge.$$.fragment,e),Ma=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-8wzhde"&&(be.innerHTML=Pl),wa=n(e),d(Te.$$.fragment,e),ya=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-16lyt50"&&(Je.innerHTML=Dl),ga=n(e),d(_e.$$.fragment,e),ba=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-zr3cxq"&&($e.innerHTML=Kl),Ta=n(e),ve=o(e,"TABLE",{"data-svelte-h":!0}),r(ve)!=="svelte-1iyfgt7"&&(ve.innerHTML=Ol),Ja=n(e),d(Ze.$$.fragment,e),_a=n(e),je=o(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-6zi1s1"&&(je.innerHTML=es),$a=n(e),d(ke.$$.fragment,e),va=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-15vxux2"&&(Ue.innerHTML=ts),Za=n(e),d(Ce.$$.fragment,e),ja=n(e),d(Le.$$.fragment,e),ka=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1mosto0"&&(Re.innerHTML=as),Ua=n(e),d(Be.$$.fragment,e),Ca=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1ttqqw0"&&(Ie.innerHTML=ls),La=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-foj0wd"&&(We.innerHTML=ss),Ra=n(e),d(Ae.$$.fragment,e),Ba=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-rkzqzi"&&(Ge.textContent=ns),Ia=n(e),d(Ve.$$.fragment,e),Wa=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-9dmo2s"&&(Qe.innerHTML=is),Aa=n(e),d(He.$$.fragment,e),Ga=n(e),d(xe.$$.fragment,e),Va=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-7m1f0a"&&(ze.innerHTML=os),Qa=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1wwmf5r"&&(Xe.textContent=rs),Ha=n(e),$=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r($)!=="svelte-1f6iuw5"&&($.innerHTML=ps),xa=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-hlzwis"&&(qe.textContent=ds),za=n(e),d(Ee.$$.fragment,e),Xa=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-ftdov9"&&(Fe.innerHTML=ms),qa=n(e),d(Ye.$$.fragment,e),Ea=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1n4a8sh"&&(Ne.innerHTML=fs),Fa=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1mwdwt1"&&(Se.textContent=hs),Ya=n(e),d(Pe.$$.fragment,e),Na=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-nuhu05"&&(De.textContent=us),Sa=n(e),d(Ke.$$.fragment,e),Pa=n(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1n53hd9"&&(Oe.textContent=cs),Da=n(e),d(et.$$.fragment,e),Ka=n(e),d(v.$$.fragment,e),Oa=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-qwbdkg"&&(tt.textContent=Ms),el=n(e),d(at.$$.fragment,e),tl=n(e),d(lt.$$.fragment,e),al=n(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1pigtsk"&&(st.innerHTML=ws),ll=n(e),d(nt.$$.fragment,e),sl=n(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1u4sd22"&&(it.innerHTML=ys),nl=n(e),d(ot.$$.fragment,e),il=n(e),d(rt.$$.fragment,e),ol=n(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1fq5tpu"&&(pt.textContent=gs),rl=n(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-lcywla"&&(dt.innerHTML=bs),pl=n(e),d(mt.$$.fragment,e),dl=n(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-6wkyom"&&(ft.innerHTML=Ts),ml=n(e),d(ht.$$.fragment,e),fl=n(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1o40ch6"&&(ut.innerHTML=Js),hl=n(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-13py9hk"&&(ct.innerHTML=_s),ul=n(e),d(Mt.$$.fragment,e),cl=n(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-fpz5mj"&&(wt.textContent=$s),Ml=n(e),yt=o(e,"UL",{"data-svelte-h":!0}),r(yt)!=="svelte-150o10n"&&(yt.innerHTML=vs),wl=n(e),d(gt.$$.fragment,e),yl=n(e),bt=o(e,"P",{}),Us(bt).forEach(a),this.h()},h(){bl(c,"name","hf:doc:metadata"),bl(c,"content",xs),bl($,"class","flex justify-center")},m(e,t){Ws(document.head,c),l(e,g,t),l(e,w,t),l(e,b,t),m(Z,e,t),l(e,Tt,t),l(e,j,t),l(e,Jt,t),l(e,k,t),l(e,_t,t),m(U,e,t),l(e,$t,t),l(e,C,t),l(e,vt,t),l(e,L,t),l(e,Zt,t),m(R,e,t),l(e,jt,t),l(e,B,t),l(e,kt,t),m(I,e,t),l(e,Ut,t),m(W,e,t),l(e,Ct,t),l(e,A,t),l(e,Lt,t),l(e,G,t),l(e,Rt,t),m(V,e,t),l(e,Bt,t),l(e,Q,t),l(e,It,t),m(H,e,t),l(e,Wt,t),l(e,x,t),l(e,At,t),m(z,e,t),l(e,Gt,t),l(e,X,t),l(e,Vt,t),l(e,q,t),l(e,Qt,t),m(E,e,t),l(e,Ht,t),l(e,F,t),l(e,xt,t),m(Y,e,t),l(e,zt,t),l(e,N,t),l(e,Xt,t),l(e,S,t),l(e,qt,t),m(P,e,t),l(e,Et,t),l(e,D,t),l(e,Ft,t),l(e,K,t),l(e,Yt,t),m(O,e,t),l(e,Nt,t),l(e,ee,t),l(e,St,t),m(te,e,t),l(e,Pt,t),l(e,ae,t),l(e,Dt,t),m(J,e,t),l(e,Kt,t),m(le,e,t),l(e,Ot,t),m(se,e,t),l(e,ea,t),l(e,ne,t),l(e,ta,t),l(e,ie,t),l(e,aa,t),m(oe,e,t),l(e,la,t),l(e,re,t),l(e,sa,t),m(pe,e,t),l(e,na,t),l(e,de,t),l(e,ia,t),l(e,me,t),l(e,oa,t),l(e,fe,t),l(e,ra,t),l(e,he,t),l(e,pa,t),m(_,e,t),l(e,da,t),m(ue,e,t),l(e,ma,t),l(e,ce,t),l(e,fa,t),m(Me,e,t),l(e,ha,t),m(we,e,t),l(e,ua,t),l(e,ye,t),l(e,ca,t),m(ge,e,t),l(e,Ma,t),l(e,be,t),l(e,wa,t),m(Te,e,t),l(e,ya,t),l(e,Je,t),l(e,ga,t),m(_e,e,t),l(e,ba,t),l(e,$e,t),l(e,Ta,t),l(e,ve,t),l(e,Ja,t),m(Ze,e,t),l(e,_a,t),l(e,je,t),l(e,$a,t),m(ke,e,t),l(e,va,t),l(e,Ue,t),l(e,Za,t),m(Ce,e,t),l(e,ja,t),m(Le,e,t),l(e,ka,t),l(e,Re,t),l(e,Ua,t),m(Be,e,t),l(e,Ca,t),l(e,Ie,t),l(e,La,t),l(e,We,t),l(e,Ra,t),m(Ae,e,t),l(e,Ba,t),l(e,Ge,t),l(e,Ia,t),m(Ve,e,t),l(e,Wa,t),l(e,Qe,t),l(e,Aa,t),m(He,e,t),l(e,Ga,t),m(xe,e,t),l(e,Va,t),l(e,ze,t),l(e,Qa,t),l(e,Xe,t),l(e,Ha,t),l(e,$,t),l(e,xa,t),l(e,qe,t),l(e,za,t),m(Ee,e,t),l(e,Xa,t),l(e,Fe,t),l(e,qa,t),m(Ye,e,t),l(e,Ea,t),l(e,Ne,t),l(e,Fa,t),l(e,Se,t),l(e,Ya,t),m(Pe,e,t),l(e,Na,t),l(e,De,t),l(e,Sa,t),m(Ke,e,t),l(e,Pa,t),l(e,Oe,t),l(e,Da,t),m(et,e,t),l(e,Ka,t),m(v,e,t),l(e,Oa,t),l(e,tt,t),l(e,el,t),m(at,e,t),l(e,tl,t),m(lt,e,t),l(e,al,t),l(e,st,t),l(e,ll,t),m(nt,e,t),l(e,sl,t),l(e,it,t),l(e,nl,t),m(ot,e,t),l(e,il,t),m(rt,e,t),l(e,ol,t),l(e,pt,t),l(e,rl,t),l(e,dt,t),l(e,pl,t),m(mt,e,t),l(e,dl,t),l(e,ft,t),l(e,ml,t),m(ht,e,t),l(e,fl,t),l(e,ut,t),l(e,hl,t),l(e,ct,t),l(e,ul,t),m(Mt,e,t),l(e,cl,t),l(e,wt,t),l(e,Ml,t),l(e,yt,t),l(e,wl,t),m(gt,e,t),l(e,yl,t),l(e,bt,t),gl=!0},p(e,[t]){const Zs={};t&2&&(Zs.$$scope={dirty:t,ctx:e}),J.$set(Zs);const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),_.$set(js);const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),v.$set(ks)},i(e){gl||(f(Z.$$.fragment,e),f(U.$$.fragment,e),f(R.$$.fragment,e),f(I.$$.fragment,e),f(W.$$.fragment,e),f(V.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(J.$$.fragment,e),f(le.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(_.$$.fragment,e),f(ue.$$.fragment,e),f(Me.$$.fragment,e),f(we.$$.fragment,e),f(ge.$$.fragment,e),f(Te.$$.fragment,e),f(_e.$$.fragment,e),f(Ze.$$.fragment,e),f(ke.$$.fragment,e),f(Ce.$$.fragment,e),f(Le.$$.fragment,e),f(Be.$$.fragment,e),f(Ae.$$.fragment,e),f(Ve.$$.fragment,e),f(He.$$.fragment,e),f(xe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(Pe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(v.$$.fragment,e),f(at.$$.fragment,e),f(lt.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(rt.$$.fragment,e),f(mt.$$.fragment,e),f(ht.$$.fragment,e),f(Mt.$$.fragment,e),f(gt.$$.fragment,e),gl=!0)},o(e){h(Z.$$.fragment,e),h(U.$$.fragment,e),h(R.$$.fragment,e),h(I.$$.fragment,e),h(W.$$.fragment,e),h(V.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(J.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(_.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),h(ge.$$.fragment,e),h(Te.$$.fragment,e),h(_e.$$.fragment,e),h(Ze.$$.fragment,e),h(ke.$$.fragment,e),h(Ce.$$.fragment,e),h(Le.$$.fragment,e),h(Be.$$.fragment,e),h(Ae.$$.fragment,e),h(Ve.$$.fragment,e),h(He.$$.fragment,e),h(xe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ye.$$.fragment,e),h(Pe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(v.$$.fragment,e),h(at.$$.fragment,e),h(lt.$$.fragment,e),h(nt.$$.fragment,e),h(ot.$$.fragment,e),h(rt.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),h(Mt.$$.fragment,e),h(gt.$$.fragment,e),gl=!1},d(e){e&&(a(g),a(w),a(b),a(Tt),a(j),a(Jt),a(k),a(_t),a($t),a(C),a(vt),a(L),a(Zt),a(jt),a(B),a(kt),a(Ut),a(Ct),a(A),a(Lt),a(G),a(Rt),a(Bt),a(Q),a(It),a(Wt),a(x),a(At),a(Gt),a(X),a(Vt),a(q),a(Qt),a(Ht),a(F),a(xt),a(zt),a(N),a(Xt),a(S),a(qt),a(Et),a(D),a(Ft),a(K),a(Yt),a(Nt),a(ee),a(St),a(Pt),a(ae),a(Dt),a(Kt),a(Ot),a(ea),a(ne),a(ta),a(ie),a(aa),a(la),a(re),a(sa),a(na),a(de),a(ia),a(me),a(oa),a(fe),a(ra),a(he),a(pa),a(da),a(ma),a(ce),a(fa),a(ha),a(ua),a(ye),a(ca),a(Ma),a(be),a(wa),a(ya),a(Je),a(ga),a(ba),a($e),a(Ta),a(ve),a(Ja),a(_a),a(je),a($a),a(va),a(Ue),a(Za),a(ja),a(ka),a(Re),a(Ua),a(Ca),a(Ie),a(La),a(We),a(Ra),a(Ba),a(Ge),a(Ia),a(Wa),a(Qe),a(Aa),a(Ga),a(Va),a(ze),a(Qa),a(Xe),a(Ha),a($),a(xa),a(qe),a(za),a(Xa),a(Fe),a(qa),a(Ea),a(Ne),a(Fa),a(Se),a(Ya),a(Na),a(De),a(Sa),a(Pa),a(Oe),a(Da),a(Ka),a(Oa),a(tt),a(el),a(tl),a(al),a(st),a(ll),a(sl),a(it),a(nl),a(il),a(ol),a(pt),a(rl),a(dt),a(pl),a(dl),a(ft),a(ml),a(fl),a(ut),a(hl),a(ct),a(ul),a(cl),a(wt),a(Ml),a(yt),a(wl),a(yl),a(bt)),a(c),u(Z,e),u(U,e),u(R,e),u(I,e),u(W,e),u(V,e),u(H,e),u(z,e),u(E,e),u(Y,e),u(P,e),u(O,e),u(te,e),u(J,e),u(le,e),u(se,e),u(oe,e),u(pe,e),u(_,e),u(ue,e),u(Me,e),u(we,e),u(ge,e),u(Te,e),u(_e,e),u(Ze,e),u(ke,e),u(Ce,e),u(Le,e),u(Be,e),u(Ae,e),u(Ve,e),u(He,e),u(xe,e),u(Ee,e),u(Ye,e),u(Pe,e),u(Ke,e),u(et,e),u(v,e),u(at,e),u(lt,e),u(nt,e),u(ot,e),u(rt,e),u(mt,e),u(ht,e),u(Mt,e),u(gt,e)}}}const xs='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"EVA","local":"eva","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function zs(T){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends Rs{constructor(c){super(),Bs(this,c,zs,Hs,Cs,{})}}export{Ns as component};
