import{s as Fe,n as Ve,o as Re}from"../chunks/scheduler.56725da7.js";import{S as ke,i as Ee,e as m,s as l,c as s,h as ze,a as u,d as n,b as a,f as we,g as r,j as y,k as A,l as M,m as o,n as i,t as p,o as c,p as d}from"../chunks/index.18a26576.js";import{C as qe}from"../chunks/CopyLLMTxtMenu.991ec59d.js";import{D as xe}from"../chunks/Docstring.03df4faf.js";import{C as Je}from"../chunks/CodeBlock.efda84be.js";import{H as g}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ff98b565.js";function Ye(Ue){let f,L,S,P,T,D,j,O,_,K,W,$e='<a href="https://hf.co/papers/2212.04356" rel="nofollow">Whisper</a> is a encoder-decoder (sequence-to-sequence) transformer pretrained on 680,000 hours of labeled audio data. This amount of pretraining data enables zero-shot performance on audio tasks in English and many other languages. The decoder allows Whisper to map the encoders learned speech representations to useful outputs, such as text, without additional fine-tuning. Whisper just works out of the box.',ee,U,Ge='You can find all the original Whisper checkpoints under the <a href="https://huggingface.co/collections/openai/whisper-release-6501bba2cf999715fd953013" rel="nofollow">Whisper</a> collection.',te,$,ne,G,Xe='To deploy 🤗 <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> models on Neuron devices, you first need to compile the models and export them to a serialized format for inference. Below are two approaches to compile the model, you can choose the one that best suits your needs:',oe,X,le,Z,Ze="You can export the model using the Optimum command-line interface as follows:",ae,v,se,b,ve="<p>Execute <code>optimum-cli export neuron --help</code> to display all command line options and their description.</p>",re,I,ie,N,pe,C,ce,B,Ie='To use the model that we just exported, there are two options. We can eithe use the <a href="/docs/optimum.neuron/pr_1001/en/model_doc/transformers/whisper#optimum.neuron.NeuronWhisperForConditionalGeneration">NeuronWhisperForConditionalGeneration</a> class or use the <code>Pipeline</code>. The example below demonstrates how to automatically transcribe speech into text these two approaches.',de,x,me,F,ue,V,he,R,fe,k,ye,h,E,Te,q,Ne="Whisper Neuron model with a language modeling head that can be used for automatic speech recognition.",je,Y,Ce=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,_e,w,z,We,H,Be="The <code>NeuronWhisperForConditionalGeneration</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Me,Q,ge;return T=new qe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new g({props:{title:"Whisper",local:"whisper",headingTag:"h1"}}),_=new g({props:{title:"Overview",local:"overview",headingTag:"h2"}}),$=new g({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h2"}}),X=new g({props:{title:"Option 1: CLI",local:"option-1-cli",headingTag:"h3"}}),v=new Je({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwb3BlbmFpJTJGd2hpc3Blci10aW55JTIwLS10YXNrJTIwYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLXNlcXVlbmNlX2xlbmd0aCUyMDEyOCUyMC0tYXV0b19jYXN0JTIwYWxsJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjB3aGlzcGVyX3RpbnlfbmV1cm9ueCUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model openai/whisper-tiny --task automatic-speech-recognition --batch_size 1 --sequence_length 128 --auto_cast all --auto_cast_type bf16 whisper_tiny_neuronx/',wrap:!1}}),I=new g({props:{title:"Option 2: Python API",local:"option-2-python-api",headingTag:"h3"}}),N=new Je({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJhbGwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEFpbnB1dF9zaGFwZXMlMjAlM0QlMjAlN0IlMjJiYXRjaF9zaXplJTIyJTNBJTIwMSUyQyUyMCUyMnNlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDEyOCU3RCUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvbldoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm9wZW5haSUyRndoaXNwZXItdGlueSUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBpbmxpbmVfd2VpZ2h0c190b19uZWZmJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSklMEElMjMlMjBTYXZlJTIwbG9jYWxseSUwQW5ldXJvbl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyd2hpc3Blcl90aW55X25ldXJvbnglMjIpJTBBJTBBJTIzJTIwVXBsb2FkJTIwdG8lMjB0aGUlMjBIdWdnaW5nRmFjZSUyMEh1YiUwQW5ldXJvbl9tb2RlbC5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjAlMjJ3aGlzcGVyX3RpbnlfbmV1cm9ueCUyMiUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMHJlcG8lMjBpZCUyQyUyMGVnLiUyMCUyMkppbmd5YSUyRndoaXNwZXJfdGlueV9uZXVyb254JTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronWhisperForConditionalGeneration

compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;all&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">128</span>}
neuron_model = NeuronWhisperForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;openai/whisper-tiny&quot;</span>,
    export=<span class="hljs-literal">True</span>,
    inline_weights_to_neff=<span class="hljs-literal">False</span>,
    **compiler_args,
    **input_shapes,
)
<span class="hljs-comment"># Save locally</span>
neuron_model.save_pretrained(<span class="hljs-string">&quot;whisper_tiny_neuronx&quot;</span>)

<span class="hljs-comment"># Upload to the HuggingFace Hub</span>
neuron_model.push_to_hub(
    <span class="hljs-string">&quot;whisper_tiny_neuronx&quot;</span>, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>  <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/whisper_tiny_neuronx&quot;</span>
)`,wrap:!1}}),C=new g({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),x=new g({props:{title:"With NeuronWhisperForConditionalGeneration",local:"with-neuronwhisperforconditionalgeneration",headingTag:"h3"}}),F=new Je({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25XaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBJTIzJTIwU2VsZWN0JTIwYW4lMjBhdWRpbyUyMGZpbGUlMjBhbmQlMjByZWFkJTIwaXQlM0ElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBYXVkaW9fc2FtcGxlJTIwJTNEJTIwZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjBVc2UlMjB0aGUlMjBtb2RlbCUyMGFuZCUyMHByb2Nlc3NvciUyMHRvJTIwdHJhbnNjcmliZSUyMHRoZSUyMGF1ZGlvJTNBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGd2hpc3Blcl90aW55X25ldXJvbnglMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwYXVkaW9fc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW9fc2FtcGxlJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2ZlYXR1cmVzJTBBJTBBJTIzJTIwSW5mZXJlbmNlJTBBbmV1cm9uX21vZGVsJTIwJTNEJTIwTmV1cm9uV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGd2hpc3Blcl90aW55X25ldXJvbnglMjIpJTBBcHJlZGljdGVkX2lkcyUyMCUzRCUyMG5ldXJvbl9tb2RlbC5nZW5lcmF0ZShpbnB1dF9mZWF0dXJlcyklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkaWN0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTIzJTIwJTIwTXIuJTIwUXVpbHRlciUyMGlzJTIwdGhlJTIwYXBvc3RsZSUyMG9mJTIwdGhlJTIwbWlkZGxlJTIwY2xhc3NlcyUyMGFuZCUyMHdlJTIwYXJlJTIwZ2xhZCUyMHRvJTIwd2VsY29tZSUyMGhpcyUyMGdvc3BlbC4=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronWhisperForConditionalGeneration

<span class="hljs-comment"># Select an audio file and read it:</span>
ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
audio_sample = ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-comment"># Use the model and processor to transcribe the audio:</span>
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/whisper_tiny_neuronx&quot;</span>)
input_features = processor(
    audio_sample[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio_sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).input_features

<span class="hljs-comment"># Inference</span>
neuron_model = NeuronWhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Jingya/whisper_tiny_neuronx&quot;</span>)
predicted_ids = neuron_model.generate(input_features)
transcription = processor.batch_decode(predicted_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-comment">#  Mr. Quilter is the apostle of the middle classes and we are glad to welcome his gospel.</span>`,wrap:!1}}),V=new g({props:{title:"With pipeline",local:"with-pipeline",headingTag:"h3"}}),R=new Je({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25XaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwcGlwZWxpbmUlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZ3aGlzcGVyX3RpbnlfbmV1cm9ueCUyMiklMEFuZXVyb25fbW9kZWwlMjAlM0QlMjBOZXVyb25XaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZ3aGlzcGVyX3RpbnlfbmV1cm9ueCUyMiklMEElMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RuZXVyb25fbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IudG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0Rwcm9jZXNzb3IuZmVhdHVyZV9leHRyYWN0b3IlMkMlMEEpJTBBcGlwZWxpbmUoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMiklMEElMjMlMjAlMjBJJTIwaGF2ZSUyMGElMjBkcmVhbS4lMjBHb29kJTIwb25lJTIwZGF5LiUyMFRoaXMlMjBuYXRpb24lMjB3aWxsJTIwcmlzZSUyMHVwLiUyMExpdmUlMjBvdXQlMjB0aGUlMjB0cnVlJTIwbWVhbmluZyUyMG9mJTIwaXRzJTIwZHJlYW0u",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronWhisperForConditionalGeneration, pipeline

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/whisper_tiny_neuronx&quot;</span>)
neuron_model = NeuronWhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Jingya/whisper_tiny_neuronx&quot;</span>)

pipeline = pipeline(
    task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
    model=neuron_model,
    tokenizer=processor.tokenizer,
    feature_extractor=processor.feature_extractor,
)
pipeline(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-comment">#  I have a dream. Good one day. This nation will rise up. Live out the true meaning of its dream.</span>`,wrap:!1}}),k=new g({props:{title:"NeuronWhisperForConditionalGeneration",local:"optimum.neuron.NeuronWhisperForConditionalGeneration",headingTag:"h2"}}),E=new xe({props:{name:"class optimum.neuron.NeuronWhisperForConditionalGeneration",anchor:"optimum.neuron.NeuronWhisperForConditionalGeneration",parameters:[{name:"encoder",val:": ScriptModule"},{name:"decoder",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"encoder_file_name",val:": str | None = 'model.neuron'"},{name:"decoder_file_name",val:": str | None = 'model.neuron'"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig'] | None = None"},{name:"configs",val:": dict[str, 'PretrainedConfig'] | None = None"},{name:"generation_config",val:": transformers.generation.configuration_utils.GenerationConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronWhisperForConditionalGeneration.encoder",description:'<strong>encoder</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module of the encoder with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"encoder"},{anchor:"optimum.neuron.NeuronWhisperForConditionalGeneration.decoder",description:'<strong>decoder</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module of the decoder with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"decoder"},{anchor:"optimum.neuron.NeuronWhisperForConditionalGeneration.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_1001/optimum/neuron/models/inference/whisper/modeling_whisper.py#L132"}}),z=new xe({props:{name:"forward",anchor:"optimum.neuron.NeuronWhisperForConditionalGeneration.forward",parameters:[{name:"input_features",val:": torch.FloatTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"encoder_outputs",val:": tuple[torch.FloatTensor] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronWhisperForConditionalGeneration.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor | None</code> of shape <code>(batch_size, feature_size, sequence_length)</code>) &#x2014;
Float values mel features extracted from the raw speech waveform. Raw speech waveform can be obtained by
loading a <code>.flac</code> or <code>.wav</code> audio file into an array of type <code>list[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via
the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_features</code>, the
<code>AutoFeatureExtractor</code> should be used for extracting the mel features, padding and conversion into a
tensor of type <code>torch.FloatTensor</code>. See <code>~WhisperFeatureExtractor.__call__</code>`,name:"input_features"},{anchor:"optimum.neuron.NeuronWhisperForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor | None</code> of shape <code>(batch_size, max_sequence_length)</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary. Indices can be obtained using <code>WhisperTokenizer</code>.
See <code>PreTrainedTokenizer.encode</code> and <code>PreTrainedTokenizer.__call__</code> for details. Since the cache is not yet
supported for Whisper, it needs to be padded to the <code>sequence_length</code> used for the compilation.`,name:"decoder_input_ids"},{anchor:"optimum.neuron.NeuronWhisperForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple[torch.FloatTensor | None]</code>) &#x2014;
Tuple consists of <code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_1001/optimum/neuron/models/inference/whisper/modeling_whisper.py#L190"}}),{c(){f=m("meta"),L=l(),S=m("p"),P=l(),s(T.$$.fragment),D=l(),s(j.$$.fragment),O=l(),s(_.$$.fragment),K=l(),W=m("p"),W.innerHTML=$e,ee=l(),U=m("p"),U.innerHTML=Ge,te=l(),s($.$$.fragment),ne=l(),G=m("p"),G.innerHTML=Xe,oe=l(),s(X.$$.fragment),le=l(),Z=m("p"),Z.textContent=Ze,ae=l(),s(v.$$.fragment),se=l(),b=m("blockquote"),b.innerHTML=ve,re=l(),s(I.$$.fragment),ie=l(),s(N.$$.fragment),pe=l(),s(C.$$.fragment),ce=l(),B=m("p"),B.innerHTML=Ie,de=l(),s(x.$$.fragment),me=l(),s(F.$$.fragment),ue=l(),s(V.$$.fragment),he=l(),s(R.$$.fragment),fe=l(),s(k.$$.fragment),ye=l(),h=m("div"),s(E.$$.fragment),Te=l(),q=m("p"),q.textContent=Ne,je=l(),Y=m("p"),Y.innerHTML=Ce,_e=l(),w=m("div"),s(z.$$.fragment),We=l(),H=m("p"),H.innerHTML=Be,Me=l(),Q=m("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);f=u(t,"META",{name:!0,content:!0}),t.forEach(n),L=a(e),S=u(e,"P",{}),we(S).forEach(n),P=a(e),r(T.$$.fragment,e),D=a(e),r(j.$$.fragment,e),O=a(e),r(_.$$.fragment,e),K=a(e),W=u(e,"P",{"data-svelte-h":!0}),y(W)!=="svelte-ol5v1p"&&(W.innerHTML=$e),ee=a(e),U=u(e,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1gesilh"&&(U.innerHTML=Ge),te=a(e),r($.$$.fragment,e),ne=a(e),G=u(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1dzuv4l"&&(G.innerHTML=Xe),oe=a(e),r(X.$$.fragment,e),le=a(e),Z=u(e,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-87nkn2"&&(Z.textContent=Ze),ae=a(e),r(v.$$.fragment,e),se=a(e),b=u(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(b)!=="svelte-13x1ycp"&&(b.innerHTML=ve),re=a(e),r(I.$$.fragment,e),ie=a(e),r(N.$$.fragment,e),pe=a(e),r(C.$$.fragment,e),ce=a(e),B=u(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-19cxrkj"&&(B.innerHTML=Ie),de=a(e),r(x.$$.fragment,e),me=a(e),r(F.$$.fragment,e),ue=a(e),r(V.$$.fragment,e),he=a(e),r(R.$$.fragment,e),fe=a(e),r(k.$$.fragment,e),ye=a(e),h=u(e,"DIV",{class:!0});var J=we(h);r(E.$$.fragment,J),Te=a(J),q=u(J,"P",{"data-svelte-h":!0}),y(q)!=="svelte-194xg64"&&(q.textContent=Ne),je=a(J),Y=u(J,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-t21i2g"&&(Y.innerHTML=Ce),_e=a(J),w=u(J,"DIV",{class:!0});var be=we(w);r(z.$$.fragment,be),We=a(be),H=u(be,"P",{"data-svelte-h":!0}),y(H)!=="svelte-zrj3de"&&(H.innerHTML=Be),be.forEach(n),J.forEach(n),Me=a(e),Q=u(e,"P",{}),we(Q).forEach(n),this.h()},h(){A(f,"name","hf:doc:metadata"),A(f,"content",He),A(b,"class","tip"),A(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){M(document.head,f),o(e,L,t),o(e,S,t),o(e,P,t),i(T,e,t),o(e,D,t),i(j,e,t),o(e,O,t),i(_,e,t),o(e,K,t),o(e,W,t),o(e,ee,t),o(e,U,t),o(e,te,t),i($,e,t),o(e,ne,t),o(e,G,t),o(e,oe,t),i(X,e,t),o(e,le,t),o(e,Z,t),o(e,ae,t),i(v,e,t),o(e,se,t),o(e,b,t),o(e,re,t),i(I,e,t),o(e,ie,t),i(N,e,t),o(e,pe,t),i(C,e,t),o(e,ce,t),o(e,B,t),o(e,de,t),i(x,e,t),o(e,me,t),i(F,e,t),o(e,ue,t),i(V,e,t),o(e,he,t),i(R,e,t),o(e,fe,t),i(k,e,t),o(e,ye,t),o(e,h,t),i(E,h,null),M(h,Te),M(h,q),M(h,je),M(h,Y),M(h,_e),M(h,w),i(z,w,null),M(w,We),M(w,H),o(e,Me,t),o(e,Q,t),ge=!0},p:Ve,i(e){ge||(p(T.$$.fragment,e),p(j.$$.fragment,e),p(_.$$.fragment,e),p($.$$.fragment,e),p(X.$$.fragment,e),p(v.$$.fragment,e),p(I.$$.fragment,e),p(N.$$.fragment,e),p(C.$$.fragment,e),p(x.$$.fragment,e),p(F.$$.fragment,e),p(V.$$.fragment,e),p(R.$$.fragment,e),p(k.$$.fragment,e),p(E.$$.fragment,e),p(z.$$.fragment,e),ge=!0)},o(e){c(T.$$.fragment,e),c(j.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(X.$$.fragment,e),c(v.$$.fragment,e),c(I.$$.fragment,e),c(N.$$.fragment,e),c(C.$$.fragment,e),c(x.$$.fragment,e),c(F.$$.fragment,e),c(V.$$.fragment,e),c(R.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(z.$$.fragment,e),ge=!1},d(e){e&&(n(L),n(S),n(P),n(D),n(O),n(K),n(W),n(ee),n(U),n(te),n(ne),n(G),n(oe),n(le),n(Z),n(ae),n(se),n(b),n(re),n(ie),n(pe),n(ce),n(B),n(de),n(me),n(ue),n(he),n(fe),n(ye),n(h),n(Me),n(Q)),n(f),d(T,e),d(j,e),d(_,e),d($,e),d(X,e),d(v,e),d(I,e),d(N,e),d(C,e),d(x,e),d(F,e),d(V,e),d(R,e),d(k,e),d(E),d(z)}}}const He='{"title":"Whisper","local":"whisper","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Export to Neuron","local":"export-to-neuron","sections":[{"title":"Option 1: CLI","local":"option-1-cli","sections":[],"depth":3},{"title":"Option 2: Python API","local":"option-2-python-api","sections":[],"depth":3}],"depth":2},{"title":"Usage Example","local":"usage-example","sections":[{"title":"With NeuronWhisperForConditionalGeneration","local":"with-neuronwhisperforconditionalgeneration","sections":[],"depth":3},{"title":"With pipeline","local":"with-pipeline","sections":[],"depth":3}],"depth":2},{"title":"NeuronWhisperForConditionalGeneration","local":"optimum.neuron.NeuronWhisperForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Se(Ue){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends ke{constructor(f){super(),Ee(this,f,Se,Ye,Fe,{})}}export{Ke as component};
