import{s as _l,n as Xl,o as Vl}from"../chunks/scheduler.3e37077e.js";import{S as xl,i as El,g as i,s as n,r as M,A as Rl,h as p,f as l,c as a,j as vl,u as r,x as o,k as Gl,y as $l,a as s,v as h,d as c,t as y,w as u}from"../chunks/index.263272b0.js";import{C as w}from"../chunks/CodeBlock.76c31e3c.js";import{H as j,E as Wl}from"../chunks/getInferenceSnippets.932de0ac.js";function Nl(St){let d,ve,Ae,Ge,m,_e,T,zt=`Processor pipelines can be complex, especially when chaining multiple transformation steps.
Unlike simple function calls, pipelines lack natural observability, you can’t easily see what happens
between each step or where things go wrong.
This guide provides debugging tools and techniques specifically designed to address these challenges
and help you understand data flow through your pipelines.`,Xe,J,Ft="We’ll explore three complementary debugging approaches: <strong>hooks</strong> for runtime monitoring, <strong>step-through debugging</strong> for detailed inspection, and <strong>feature validation</strong> for catching structural mismatches. Each serves a different purpose and together they provide complete visibility into your pipeline’s behavior.",Ve,U,xe,f,qt=`Hooks are functions that get called at specific points during pipeline execution.
They provide a way to inspect, monitor, or modify data without changing your pipeline code.
Think of them as “event listeners” for your pipeline.`,Ee,b,Re,I,Lt=`A hook is a callback function that gets automatically invoked at specific moments during pipeline execution.
The concept comes from event-driven programming, imagine you could “hook into” the pipeline’s execution flow to observe or react to what’s happening.`,$e,C,Pt="Think of hooks like inserting checkpoints into your pipeline. Every time the pipeline reaches one of these checkpoints, it pauses briefly to call your hook function, giving you a chance to inspect the current state, log information, and validate data.",We,g,Dt="A hook is simply a function that accepts two parameters:",Ne,Z,Kt="<li><code>step_idx: int</code> - The index of the current processing step (0, 1, 2, etc.)</li> <li><code>transition: EnvTransition</code> - The data transition at that point in the pipeline</li>",Qe,k,Ot="The beauty of hooks is their non-invasive nature: you can add monitoring, validation, or debugging logic without changing a single line of your pipeline code. The pipeline remains clean and focused on its core logic, while hooks handle the cross-cutting concerns like logging, monitoring, and debugging.",He,A,Ye,B,el="The pipeline supports two types of hooks:",Se,v,tl="<li><strong>Before hooks</strong> (<code>register_before_step_hook</code>) - Called before each step executes</li> <li><strong>After hooks</strong> (<code>register_after_step_hook</code>) - Called after each step completes</li>",ze,G,Fe,_,qe,X,ll="Here’s a practical example of a hook that detects NaN values:",Le,V,Pe,x,De,E,sl="Understanding the internal mechanism helps you use hooks more effectively. The pipeline maintains two separate lists: one for before-step hooks and another for after-step hooks. When you register a hook, it’s simply appended to the appropriate list.",Ke,R,nl="During execution, the pipeline follows a strict sequence: for each processing step, it first calls all before-hooks in registration order, then executes the actual step transformation, and finally calls all after-hooks in registration order. This creates a predictable, sandwich-like structure around each step.",Oe,$,al="The key insight is that hooks don’t change the core pipeline logic—they’re purely additive. The pipeline’s <code>_forward</code> method orchestrates this dance between hooks and processing steps, ensuring that your debugging or monitoring code runs at exactly the right moments without interfering with the main data flow.",et,W,il="Here’s a simplified view of how the pipeline executes hooks:",tt,N,lt,Q,st,H,pl="The execution flow looks like this:",nt,Y,at,S,ol="For example, with 3 steps and both hook types:",it,z,pt,F,ot,q,Ml="You can register multiple hooks of the same type - they execute in the order registered:",Mt,L,rt,P,rl="While hooks are excellent for monitoring specific issues (like NaN detection) or gathering metrics during normal pipeline execution, sometimes you need to dive deeper. When you want to understand exactly what happens at each step or debug complex transformation logic, step-through debugging provides the detailed inspection you need.",ht,D,ct,K,hl="Step-through debugging is like having a slow-motion replay for your pipeline. Instead of watching your data get transformed in one quick blur from input to output, you can pause and examine what happens after each individual step.",yt,O,cl="This approach is particularly valuable when you’re trying to understand a complex pipeline, debug unexpected behavior, or verify that each transformation is working as expected. Unlike hooks, which are great for automated monitoring, step-through debugging gives you manual, interactive control over the inspection process.",ut,ee,yl="The <code>step_through()</code> method is a generator that yields the transition state after each processing step, allowing you to inspect intermediate results. Think of it as creating a series of snapshots of your data as it flows through the pipeline—each snapshot shows you exactly what your data looks like after one more transformation has been applied.",jt,te,wt,le,ul="The <code>step_through()</code> method fundamentally changes how the pipeline executes. Instead of running all steps in sequence and only returning the final result, it transforms the pipeline into an iterator that yields intermediate results.",dt,se,jl="Here’s what happens internally: the method starts by converting your input data into the pipeline’s internal transition format, then yields this initial state. Next, it applies the first processing step and yields the result. Then it applies the second step to that result and yields again, and so on. Each <code>yield</code> gives you a complete snapshot of the transition at that point.",mt,ne,wl="This generator pattern is powerful because it’s lazy—the pipeline only computes the next step when you ask for it. This means you can stop at any point, inspect the current state thoroughly, and decide whether to continue. You’re not forced to run the entire pipeline just to debug one problematic step.",Tt,ae,dl="Instead of running the entire pipeline and only seeing the final result, <code>step_through()</code> pauses after each step and gives you the intermediate transition:",Jt,ie,Ut,pe,ft,oe,ml="You can add breakpoints in the step-through loop to interactively debug:",bt,Me,It,re,Tl="During the debugger session, you can:",Ct,he,Jl="<li>Examine <code>intermediate[TransitionKey.OBSERVATION]</code> to see observation data</li> <li>Check <code>intermediate[TransitionKey.ACTION]</code> for action transformations</li> <li>Inspect any part of the transition to understand what each step does</li>",gt,ce,Ul="Step-through debugging is perfect for understanding the <em>data</em> transformations, but what about the <em>structure</em> of that data? While hooks and step-through help you debug runtime behavior, you also need to ensure your pipeline produces data in the format expected by downstream components. This is where feature contract validation comes in.",Zt,ye,kt,ue,fl=`Feature contracts define what data structure your pipeline expects as input and produces as output.
Validating these contracts helps catch mismatches early.`,At,je,Bt,we,bl="Each processor step has a <code>transform_features()</code> method that describes how it changes the data structure:",vt,de,Gt,me,_t,Te,Il="Check that your pipeline produces the features you expect:",Xt,Je,Vt,Ue,Cl="This validation helps ensure your pipeline will work correctly with downstream components that expect specific data structures.",xt,fe,Et,be,gl="Now that you understand the three debugging approaches, you can tackle any pipeline issue systematically:",Rt,Ie,Zl="<li><strong>Hooks</strong> - For runtime monitoring and validation without modifying pipeline code</li> <li><strong>Step-through</strong> - For inspecting intermediate states and understanding transformations</li> <li><strong>Feature validation</strong> - For ensuring data structure contracts are met</li>",$t,Ce,kl="<strong>When to use each approach:</strong>",Wt,ge,Al="<li>Start with <strong>step-through debugging</strong> when you need to understand what your pipeline does or when something unexpected happens</li> <li>Add <strong>hooks</strong> for continuous monitoring during development and production to catch issues automatically</li> <li>Use <strong>feature validation</strong> before deployment to ensure your pipeline works with downstream components</li>",Nt,Ze,Bl="These three tools work together to give you the complete observability that complex pipelines naturally lack. With hooks watching for issues, step-through helping you understand behavior, and feature validation ensuring compatibility, you’ll be able to debug any pipeline confidently and efficiently.",Qt,ke,Ht,Be,Yt;return m=new j({props:{title:"Debug Your Processor Pipeline",local:"debug-your-processor-pipeline",headingTag:"h1"}}),U=new j({props:{title:"Understanding Hooks",local:"understanding-hooks",headingTag:"h2"}}),b=new j({props:{title:"What is a Hook?",local:"what-is-a-hook",headingTag:"h3"}}),A=new j({props:{title:"Before vs After Hooks",local:"before-vs-after-hooks",headingTag:"h3"}}),G=new w({props:{code:"ZGVmJTIwYmVmb3JlX2hvb2soc3RlcF9pZHglM0ElMjBpbnQlMkMlMjB0cmFuc2l0aW9uJTNBJTIwRW52VHJhbnNpdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDYWxsZWQlMjBiZWZvcmUlMjBzdGVwJTIwcHJvY2Vzc2VzJTIwdGhlJTIwdHJhbnNpdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwcmludChmJTIyQWJvdXQlMjB0byUyMGV4ZWN1dGUlMjBzdGVwJTIwJTdCc3RlcF9pZHglN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlZnVsJTIwZm9yJTNBJTIwbG9nZ2luZyUyQyUyMHZhbGlkYXRpb24lMkMlMjBzZXR1cCUwQSUwQWRlZiUyMGFmdGVyX2hvb2soc3RlcF9pZHglM0ElMjBpbnQlMkMlMjB0cmFuc2l0aW9uJTNBJTIwRW52VHJhbnNpdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDYWxsZWQlMjBhZnRlciUyMHN0ZXAlMjBoYXMlMjBwcm9jZXNzZWQlMjB0aGUlMjB0cmFuc2l0aW9uLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJDb21wbGV0ZWQlMjBzdGVwJTIwJTdCc3RlcF9pZHglN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlZnVsJTIwZm9yJTNBJTIwbW9uaXRvcmluZyUyMHJlc3VsdHMlMkMlMjBjbGVhbnVwJTJDJTIwZGVidWdnaW5nJTBBJTBBcHJvY2Vzc29yLnJlZ2lzdGVyX2JlZm9yZV9zdGVwX2hvb2soYmVmb3JlX2hvb2spJTBBcHJvY2Vzc29yLnJlZ2lzdGVyX2FmdGVyX3N0ZXBfaG9vayhhZnRlcl9ob29rKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">before_hook</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Called before step processes the transition.&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;About to execute step <span class="hljs-subst">{step_idx}</span>&quot;</span>)
    <span class="hljs-comment"># Useful for: logging, validation, setup</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">after_hook</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Called after step has processed the transition.&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Completed step <span class="hljs-subst">{step_idx}</span>&quot;</span>)
    <span class="hljs-comment"># Useful for: monitoring results, cleanup, debugging</span>

processor.register_before_step_hook(before_hook)
processor.register_after_step_hook(after_hook)`,wrap:!1}}),_=new j({props:{title:"Implementing a NaN Detection Hook",local:"implementing-a-nan-detection-hook",headingTag:"h3"}}),V=new w({props:{code:"ZGVmJTIwY2hlY2tfbmFucyhzdGVwX2lkeCUzQSUyMGludCUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNoZWNrJTIwZm9yJTIwTmFOJTIwdmFsdWVzJTIwaW4lMjBvYnNlcnZhdGlvbnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwb2JzJTIwJTNEJTIwdHJhbnNpdGlvbi5nZXQoVHJhbnNpdGlvbktleS5PQlNFUlZBVElPTiklMEElMjAlMjAlMjAlMjBpZiUyMG9icyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGtleSUyQyUyMHZhbHVlJTIwaW4lMjBvYnMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZSh2YWx1ZSUyQyUyMHRvcmNoLlRlbnNvciklMjBhbmQlMjB0b3JjaC5pc25hbih2YWx1ZSkuYW55KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyTmFOJTIwZGV0ZWN0ZWQlMjBpbiUyMCU3QmtleSU3RCUyMGF0JTIwc3RlcCUyMCU3QnN0ZXBfaWR4JTdEJTIyKSUwQSUwQSUyMyUyMFJlZ2lzdGVyJTIwdGhlJTIwaG9vayUyMHRvJTIwcnVuJTIwYWZ0ZXIlMjBlYWNoJTIwc3RlcCUwQXByb2Nlc3Nvci5yZWdpc3Rlcl9hZnRlcl9zdGVwX2hvb2soY2hlY2tfbmFucyklMEElMEElMjMlMjBQcm9jZXNzJTIweW91ciUyMGRhdGElMjAtJTIwdGhlJTIwaG9vayUyMHdpbGwlMjBiZSUyMGNhbGxlZCUyMGF1dG9tYXRpY2FsbHklMEFvdXRwdXQlMjAlM0QlMjBwcm9jZXNzb3IoaW5wdXRfZGF0YSklMEElMEElMjMlMjBSZW1vdmUlMjB0aGUlMjBob29rJTIwd2hlbiUyMGRvbmUlMjBkZWJ1Z2dpbmclMEFwcm9jZXNzb3IudW5yZWdpc3Rlcl9hZnRlcl9zdGVwX2hvb2soY2hlY2tfbmFucyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_nans</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Check for NaN values in observations.&quot;&quot;&quot;</span>
    obs = transition.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor) <span class="hljs-keyword">and</span> torch.isnan(value).<span class="hljs-built_in">any</span>():
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;NaN detected in <span class="hljs-subst">{key}</span> at step <span class="hljs-subst">{step_idx}</span>&quot;</span>)

<span class="hljs-comment"># Register the hook to run after each step</span>
processor.register_after_step_hook(check_nans)

<span class="hljs-comment"># Process your data - the hook will be called automatically</span>
output = processor(input_data)

<span class="hljs-comment"># Remove the hook when done debugging</span>
processor.unregister_after_step_hook(check_nans)`,wrap:!1}}),x=new j({props:{title:"How Hooks Work Internally",local:"how-hooks-work-internally",headingTag:"h3"}}),N=new w({props:{code:"Y2xhc3MlMjBEYXRhUHJvY2Vzc29yUGlwZWxpbmUlM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc3RlcHMlMjAlM0QlMjAlNUIuLi4lNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJlZm9yZV9zdGVwX2hvb2tzJTIwJTNEJTIwJTVCJTVEJTIwJTIwJTIzJTIwTGlzdCUyMG9mJTIwYmVmb3JlJTIwaG9va3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmFmdGVyX3N0ZXBfaG9va3MlMjAlM0QlMjAlNUIlNUQlMjAlMjAlMjAlMjMlMjBMaXN0JTIwb2YlMjBhZnRlciUyMGhvb2tzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX2ZvcndhcmQoc2VsZiUyQyUyMHRyYW5zaXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIySW50ZXJuYWwlMjBtZXRob2QlMjB0aGF0JTIwcHJvY2Vzc2VzJTIwdGhlJTIwdHJhbnNpdGlvbiUyMHRocm91Z2glMjBhbGwlMjBzdGVwcy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBzdGVwX2lkeCUyQyUyMHByb2Nlc3Nvcl9zdGVwJTIwaW4lMjBlbnVtZXJhdGUoc2VsZi5zdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAxLiUyMENhbGwlMjBhbGwlMjBCRUZPUkUlMjBob29rcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGhvb2slMjBpbiUyMHNlbGYuYmVmb3JlX3N0ZXBfaG9va3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBob29rKHN0ZXBfaWR4JTJDJTIwdHJhbnNpdGlvbiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAyLiUyMEV4ZWN1dGUlMjB0aGUlMjBhY3R1YWwlMjBwcm9jZXNzaW5nJTIwc3RlcCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zaXRpb24lMjAlM0QlMjBwcm9jZXNzb3Jfc3RlcCh0cmFuc2l0aW9uKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDMuJTIwQ2FsbCUyMGFsbCUyMEFGVEVSJTIwaG9va3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBob29rJTIwaW4lMjBzZWxmLmFmdGVyX3N0ZXBfaG9va3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBob29rKHN0ZXBfaWR4JTJDJTIwdHJhbnNpdGlvbiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFuc2l0aW9uJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcmVnaXN0ZXJfYmVmb3JlX3N0ZXBfaG9vayhzZWxmJTJDJTIwaG9va19mbiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJlZm9yZV9zdGVwX2hvb2tzLmFwcGVuZChob29rX2ZuKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHJlZ2lzdGVyX2FmdGVyX3N0ZXBfaG9vayhzZWxmJTJDJTIwaG9va19mbiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmFmdGVyX3N0ZXBfaG9va3MuYXBwZW5kKGhvb2tfZm4p",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataProcessorPipeline</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.steps = [...]
        self.before_step_hooks = []  <span class="hljs-comment"># List of before hooks</span>
        self.after_step_hooks = []   <span class="hljs-comment"># List of after hooks</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, transition</span>):
        <span class="hljs-string">&quot;&quot;&quot;Internal method that processes the transition through all steps.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">for</span> step_idx, processor_step <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(self.steps):
            <span class="hljs-comment"># 1. Call all BEFORE hooks</span>
            <span class="hljs-keyword">for</span> hook <span class="hljs-keyword">in</span> self.before_step_hooks:
                hook(step_idx, transition)

            <span class="hljs-comment"># 2. Execute the actual processing step</span>
            transition = processor_step(transition)

            <span class="hljs-comment"># 3. Call all AFTER hooks</span>
            <span class="hljs-keyword">for</span> hook <span class="hljs-keyword">in</span> self.after_step_hooks:
                hook(step_idx, transition)

        <span class="hljs-keyword">return</span> transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">register_before_step_hook</span>(<span class="hljs-params">self, hook_fn</span>):
        self.before_step_hooks.append(hook_fn)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">register_after_step_hook</span>(<span class="hljs-params">self, hook_fn</span>):
        self.after_step_hooks.append(hook_fn)`,wrap:!1}}),Q=new j({props:{title:"Execution Flow",local:"execution-flow",headingTag:"h3"}}),Y=new w({props:{code:"SW5wdXQlMjAlRTIlODYlOTIlMjBCZWZvcmUlMjBIb29rJTIwJUUyJTg2JTkyJTIwU3RlcCUyMDAlMjAlRTIlODYlOTIlMjBBZnRlciUyMEhvb2slMjAlRTIlODYlOTIlMjBCZWZvcmUlMjBIb29rJTIwJUUyJTg2JTkyJTIwU3RlcCUyMDElMjAlRTIlODYlOTIlMjBBZnRlciUyMEhvb2slMjAlRTIlODYlOTIlMjAuLi4lMjAlRTIlODYlOTIlMjBPdXRwdXQ=",highlighted:'<span class="hljs-built_in">Input</span> → <span class="hljs-built_in">Before</span> <span class="hljs-variable">Hook</span> → <span class="hljs-variable">Step</span> <span class="hljs-number">0</span> → <span class="hljs-built_in">After</span> <span class="hljs-variable">Hook</span> → <span class="hljs-built_in">Before</span> <span class="hljs-variable">Hook</span> → <span class="hljs-variable">Step</span> <span class="hljs-number">1</span> → <span class="hljs-built_in">After</span> <span class="hljs-variable">Hook</span> → <span class="hljs-operator">...</span> → <span class="hljs-variable">Output</span>',wrap:!1}}),z=new w({props:{code:"ZGVmJTIwdGltaW5nX2JlZm9yZShzdGVwX2lkeCUyQyUyMHRyYW5zaXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU4RiVCMSVFRiVCOCU4RiUyMCUyMFN0YXJ0aW5nJTIwc3RlcCUyMCU3QnN0ZXBfaWR4JTdEJTIyKSUwQSUwQWRlZiUyMHZhbGlkYXRpb25fYWZ0ZXIoc3RlcF9pZHglMkMlMjB0cmFuc2l0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlRTIlOUMlODUlMjBDb21wbGV0ZWQlMjBzdGVwJTIwJTdCc3RlcF9pZHglN0QlMjIpJTBBJTBBcHJvY2Vzc29yLnJlZ2lzdGVyX2JlZm9yZV9zdGVwX2hvb2sodGltaW5nX2JlZm9yZSklMEFwcm9jZXNzb3IucmVnaXN0ZXJfYWZ0ZXJfc3RlcF9ob29rKHZhbGlkYXRpb25fYWZ0ZXIpJTBBJTBBJTIzJTIwVGhpcyUyMHdpbGwlMjBvdXRwdXQlM0ElMEElMjMlMjAlRTIlOEYlQjElRUYlQjglOEYlMjAlMjBTdGFydGluZyUyMHN0ZXAlMjAwJTBBJTIzJTIwJUUyJTlDJTg1JTIwQ29tcGxldGVkJTIwc3RlcCUyMDAlMEElMjMlMjAlRTIlOEYlQjElRUYlQjglOEYlMjAlMjBTdGFydGluZyUyMHN0ZXAlMjAxJTBBJTIzJTIwJUUyJTlDJTg1JTIwQ29tcGxldGVkJTIwc3RlcCUyMDElMEElMjMlMjAlRTIlOEYlQjElRUYlQjglOEYlMjAlMjBTdGFydGluZyUyMHN0ZXAlMjAyJTBBJTIzJTIwJUUyJTlDJTg1JTIwQ29tcGxldGVkJTIwc3RlcCUyMDI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">timing_before</span>(<span class="hljs-params">step_idx, transition</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;⏱️  Starting step <span class="hljs-subst">{step_idx}</span>&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">validation_after</span>(<span class="hljs-params">step_idx, transition</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Completed step <span class="hljs-subst">{step_idx}</span>&quot;</span>)

processor.register_before_step_hook(timing_before)
processor.register_after_step_hook(validation_after)

<span class="hljs-comment"># This will output:</span>
<span class="hljs-comment"># ⏱️  Starting step 0</span>
<span class="hljs-comment"># ✅ Completed step 0</span>
<span class="hljs-comment"># ⏱️  Starting step 1</span>
<span class="hljs-comment"># ✅ Completed step 1</span>
<span class="hljs-comment"># ⏱️  Starting step 2</span>
<span class="hljs-comment"># ✅ Completed step 2</span>`,wrap:!1}}),F=new j({props:{title:"Multiple Hooks",local:"multiple-hooks",headingTag:"h3"}}),L=new w({props:{code:"ZGVmJTIwbG9nX3NoYXBlcyhzdGVwX2lkeCUzQSUyMGludCUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMG9icyUyMCUzRCUyMHRyYW5zaXRpb24uZ2V0KFRyYW5zaXRpb25LZXkuT0JTRVJWQVRJT04pJTBBJTIwJTIwJTIwJTIwaWYlMjBvYnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyU3RlcCUyMCU3QnN0ZXBfaWR4JTdEJTIwb2JzZXJ2YXRpb24lMjBzaGFwZXMlM0ElMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTJDJTIwdmFsdWUlMjBpbiUyMG9icy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKHZhbHVlJTJDJTIwdG9yY2guVGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlN0JrZXklN0QlM0ElMjAlN0J2YWx1ZS5zaGFwZSU3RCUyMiklMEElMEFwcm9jZXNzb3IucmVnaXN0ZXJfYWZ0ZXJfc3RlcF9ob29rKGNoZWNrX25hbnMpJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRXhlY3V0ZXMlMjBmaXJzdCUwQXByb2Nlc3Nvci5yZWdpc3Rlcl9hZnRlcl9zdGVwX2hvb2sobG9nX3NoYXBlcyklMjAlMjAlMjAlMjAlMjAlMjMlMjBFeGVjdXRlcyUyMHNlY29uZCUwQSUwQSUyMyUyMEJvdGglMjBob29rcyUyMHdpbGwlMjBiZSUyMGNhbGxlZCUyMGFmdGVyJTIwZWFjaCUyMHN0ZXAlMjBpbiUyMHJlZ2lzdHJhdGlvbiUyMG9yZGVyJTBBb3V0cHV0JTIwJTNEJTIwcHJvY2Vzc29yKGlucHV0X2RhdGEp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">log_shapes</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    obs = transition.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{step_idx}</span> observation shapes:&quot;</span>)
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{key}</span>: <span class="hljs-subst">{value.shape}</span>&quot;</span>)

processor.register_after_step_hook(check_nans)      <span class="hljs-comment"># Executes first</span>
processor.register_after_step_hook(log_shapes)     <span class="hljs-comment"># Executes second</span>

<span class="hljs-comment"># Both hooks will be called after each step in registration order</span>
output = processor(input_data)`,wrap:!1}}),D=new j({props:{title:"Step-Through Debugging",local:"step-through-debugging",headingTag:"h2"}}),te=new j({props:{title:"How Step-Through Works",local:"how-step-through-works",headingTag:"h3"}}),ie=new w({props:{code:"JTIzJTIwVGhpcyUyMGNyZWF0ZXMlMjBhJTIwZ2VuZXJhdG9yJTIwdGhhdCUyMHlpZWxkcyUyMGludGVybWVkaWF0ZSUyMHN0YXRlcyUwQWZvciUyMGklMkMlMjBpbnRlcm1lZGlhdGVfcmVzdWx0JTIwaW4lMjBlbnVtZXJhdGUocHJvY2Vzc29yLnN0ZXBfdGhyb3VnaChpbnB1dF9kYXRhKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTNEJTNEJTNEJTIwQWZ0ZXIlMjBzdGVwJTIwJTdCaSU3RCUyMCUzRCUzRCUzRCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnNwZWN0JTIwdGhlJTIwb2JzZXJ2YXRpb24lMjBhdCUyMHRoaXMlMjBzdGFnZSUwQSUyMCUyMCUyMCUyMG9icyUyMCUzRCUyMGludGVybWVkaWF0ZV9yZXN1bHQuZ2V0KFRyYW5zaXRpb25LZXkuT0JTRVJWQVRJT04pJTBBJTIwJTIwJTIwJTIwaWYlMjBvYnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBrZXklMkMlMjB2YWx1ZSUyMGluJTIwb2JzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2UodmFsdWUlMkMlMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU3QmtleSU3RCUzQSUyMHNoYXBlJTNEJTdCdmFsdWUuc2hhcGUlN0QlMkMlMjBkdHlwZSUzRCU3QnZhbHVlLmR0eXBlJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># This creates a generator that yields intermediate states</span>
<span class="hljs-keyword">for</span> i, intermediate_result <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(processor.step_through(input_data)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;=== After step <span class="hljs-subst">{i}</span> ===&quot;</span>)

    <span class="hljs-comment"># Inspect the observation at this stage</span>
    obs = intermediate_result.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: shape=<span class="hljs-subst">{value.shape}</span>, dtype=<span class="hljs-subst">{value.dtype}</span>&quot;</span>)`,wrap:!1}}),pe=new j({props:{title:"Interactive Debugging with Breakpoints",local:"interactive-debugging-with-breakpoints",headingTag:"h3"}}),Me=new w({props:{code:"JTIzJTIwU3RlcCUyMHRocm91Z2glMjB0aGUlMjBwaXBlbGluZSUyMHdpdGglMjBkZWJ1Z2dpbmclMEFmb3IlMjBpJTJDJTIwaW50ZXJtZWRpYXRlJTIwaW4lMjBlbnVtZXJhdGUocHJvY2Vzc29yLnN0ZXBfdGhyb3VnaChkYXRhKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyU3RlcCUyMCU3QmklN0QlM0ElMjAlN0Jwcm9jZXNzb3Iuc3RlcHMlNUJpJTVELl9fY2xhc3NfXy5fX25hbWVfXyU3RCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTZXQlMjBhJTIwYnJlYWtwb2ludCUyMHRvJTIwaW5zcGVjdCUyMHRoZSUyMGN1cnJlbnQlMjBzdGF0ZSUwQSUyMCUyMCUyMCUyMGJyZWFrcG9pbnQoKSUyMCUyMCUyMyUyMERlYnVnZ2VyJTIwd2lsbCUyMHBhdXNlJTIwaGVyZSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFlvdSUyMGNhbiUyMG5vdyUyMGluc3BlY3QlMjAnaW50ZXJtZWRpYXRlJyUyMGluJTIwdGhlJTIwZGVidWdnZXIlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAtJTIwQ2hlY2slMjB0ZW5zb3IlMjBzaGFwZXMlMjBhbmQlMjB2YWx1ZXMlMEElMjAlMjAlMjAlMjAlMjMlMjAtJTIwVmVyaWZ5JTIwZXhwZWN0ZWQlMjB0cmFuc2Zvcm1hdGlvbnMlMEElMjAlMjAlMjAlMjAlMjMlMjAtJTIwTG9vayUyMGZvciUyMHVuZXhwZWN0ZWQlMjBjaGFuZ2Vz",highlighted:`<span class="hljs-comment"># Step through the pipeline with debugging</span>
<span class="hljs-keyword">for</span> i, intermediate <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(processor.step_through(data)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{i}</span>: <span class="hljs-subst">{processor.steps[i].__class__.__name__}</span>&quot;</span>)

    <span class="hljs-comment"># Set a breakpoint to inspect the current state</span>
    <span class="hljs-built_in">breakpoint</span>()  <span class="hljs-comment"># Debugger will pause here</span>

    <span class="hljs-comment"># You can now inspect &#x27;intermediate&#x27; in the debugger:</span>
    <span class="hljs-comment"># - Check tensor shapes and values</span>
    <span class="hljs-comment"># - Verify expected transformations</span>
    <span class="hljs-comment"># - Look for unexpected changes</span>`,wrap:!1}}),ye=new j({props:{title:"Validating Feature Contracts",local:"validating-feature-contracts",headingTag:"h2"}}),je=new j({props:{title:"Understanding Feature Contracts",local:"understanding-feature-contracts",headingTag:"h3"}}),de=new w({props:{code:"JTIzJTIwR2V0JTIwdGhlJTIwZXhwZWN0ZWQlMjBvdXRwdXQlMjBmZWF0dXJlcyUyMGZyb20lMjB5b3VyJTIwcGlwZWxpbmUlMEFpbml0aWFsX2ZlYXR1cmVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwUGlwZWxpbmVGZWF0dXJlVHlwZS5PQlNFUlZBVElPTiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLnN0YXRlJTIyJTNBJTIwUG9saWN5RmVhdHVyZSh0eXBlJTNERmVhdHVyZVR5cGUuU1RBVEUlMkMlMjBzaGFwZSUzRCg3JTJDKSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZSUyMiUzQSUyMFBvbGljeUZlYXR1cmUodHlwZSUzREZlYXR1cmVUeXBlLklNQUdFJTJDJTIwc2hhcGUlM0QoMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwUGlwZWxpbmVGZWF0dXJlVHlwZS5BQ1RJT04lM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjBQb2xpY3lGZWF0dXJlKHR5cGUlM0RGZWF0dXJlVHlwZS5BQ1RJT04lMkMlMjBzaGFwZSUzRCg0JTJDKSklMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEElMjMlMjBDaGVjayUyMHdoYXQlMjB5b3VyJTIwcGlwZWxpbmUlMjB3aWxsJTIwb3V0cHV0JTBBb3V0cHV0X2ZlYXR1cmVzJTIwJTNEJTIwcHJvY2Vzc29yLnRyYW5zZm9ybV9mZWF0dXJlcyhpbml0aWFsX2ZlYXR1cmVzKSUwQSUwQXByaW50KCUyMklucHV0JTIwZmVhdHVyZXMlM0ElMjIpJTBBZm9yJTIwZmVhdHVyZV90eXBlJTJDJTIwZmVhdHVyZXMlMjBpbiUyMGluaXRpYWxfZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlN0JmZWF0dXJlX3R5cGUlN0QlM0ElMjIpJTBBJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTJDJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlMjAlMjAlN0JrZXklN0QlM0ElMjAlN0JmZWF0dXJlLnR5cGUudmFsdWUlN0QlMkMlMjBzaGFwZSUzRCU3QmZlYXR1cmUuc2hhcGUlN0QlMjIpJTBBJTBBcHJpbnQoJTIyJTVDbk91dHB1dCUyMGZlYXR1cmVzJTNBJTIyKSUwQWZvciUyMGZlYXR1cmVfdHlwZSUyQyUyMGZlYXR1cmVzJTIwaW4lMjBvdXRwdXRfZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlN0JmZWF0dXJlX3R5cGUlN0QlM0ElMjIpJTBBJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTJDJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlMjAlMjAlN0JrZXklN0QlM0ElMjAlN0JmZWF0dXJlLnR5cGUudmFsdWUlN0QlMkMlMjBzaGFwZSUzRCU3QmZlYXR1cmUuc2hhcGUlN0QlMjIp",highlighted:`<span class="hljs-comment"># Get the expected output features from your pipeline</span>
initial_features = {
    PipelineFeatureType.OBSERVATION: {
        <span class="hljs-string">&quot;observation.state&quot;</span>: PolicyFeature(<span class="hljs-built_in">type</span>=FeatureType.STATE, shape=(<span class="hljs-number">7</span>,)),
        <span class="hljs-string">&quot;observation.image&quot;</span>: PolicyFeature(<span class="hljs-built_in">type</span>=FeatureType.IMAGE, shape=(<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
    },
    PipelineFeatureType.ACTION: {
        <span class="hljs-string">&quot;action&quot;</span>: PolicyFeature(<span class="hljs-built_in">type</span>=FeatureType.ACTION, shape=(<span class="hljs-number">4</span>,))
    }
}

<span class="hljs-comment"># Check what your pipeline will output</span>
output_features = processor.transform_features(initial_features)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input features:&quot;</span>)
<span class="hljs-keyword">for</span> feature_type, features <span class="hljs-keyword">in</span> initial_features.items():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{feature_type}</span>:&quot;</span>)
    <span class="hljs-keyword">for</span> key, feature <span class="hljs-keyword">in</span> features.items():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;    <span class="hljs-subst">{key}</span>: <span class="hljs-subst">{feature.<span class="hljs-built_in">type</span>.value}</span>, shape=<span class="hljs-subst">{feature.shape}</span>&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nOutput features:&quot;</span>)
<span class="hljs-keyword">for</span> feature_type, features <span class="hljs-keyword">in</span> output_features.items():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{feature_type}</span>:&quot;</span>)
    <span class="hljs-keyword">for</span> key, feature <span class="hljs-keyword">in</span> features.items():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;    <span class="hljs-subst">{key}</span>: <span class="hljs-subst">{feature.<span class="hljs-built_in">type</span>.value}</span>, shape=<span class="hljs-subst">{feature.shape}</span>&quot;</span>)`,wrap:!1}}),me=new j({props:{title:"Verifying Expected Features",local:"verifying-expected-features",headingTag:"h3"}}),Je=new w({props:{code:"JTIzJTIwRGVmaW5lJTIwd2hhdCUyMGZlYXR1cmVzJTIweW91JTIwZXhwZWN0JTIwdGhlJTIwcGlwZWxpbmUlMjB0byUyMHByb2R1Y2UlMEFleHBlY3RlZF9rZXlzJTIwJTNEJTIwJTVCJTIyb2JzZXJ2YXRpb24uc3RhdGUlMjIlMkMlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZSUyMiUyQyUyMCUyMmFjdGlvbiUyMiU1RCUwQSUwQXByaW50KCUyMlZhbGlkYXRpbmclMjBmZWF0dXJlJTIwY29udHJhY3QuLi4lMjIpJTBBZm9yJTIwZXhwZWN0ZWRfa2V5JTIwaW4lMjBleHBlY3RlZF9rZXlzJTNBJTBBJTIwJTIwJTIwJTIwZm91bmQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMGZvciUyMGZlYXR1cmVfdHlwZSUyQyUyMGZlYXR1cmVzJTIwaW4lMjBvdXRwdXRfZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwZXhwZWN0ZWRfa2V5JTIwaW4lMjBmZWF0dXJlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmUlMjAlM0QlMjBmZWF0dXJlcyU1QmV4cGVjdGVkX2tleSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRTIlOUMlODUlMjAlN0JleHBlY3RlZF9rZXklN0QlM0ElMjAlN0JmZWF0dXJlLnR5cGUudmFsdWUlN0QlMkMlMjBzaGFwZSUzRCU3QmZlYXR1cmUuc2hhcGUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm91bmQlMjAlM0QlMjBUcnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMGZvdW5kJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyME1pc3NpbmclMjBleHBlY3RlZCUyMGZlYXR1cmUlM0ElMjAlN0JleHBlY3RlZF9rZXklN0QlMjIp",highlighted:`<span class="hljs-comment"># Define what features you expect the pipeline to produce</span>
expected_keys = [<span class="hljs-string">&quot;observation.state&quot;</span>, <span class="hljs-string">&quot;observation.image&quot;</span>, <span class="hljs-string">&quot;action&quot;</span>]

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Validating feature contract...&quot;</span>)
<span class="hljs-keyword">for</span> expected_key <span class="hljs-keyword">in</span> expected_keys:
    found = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> feature_type, features <span class="hljs-keyword">in</span> output_features.items():
        <span class="hljs-keyword">if</span> expected_key <span class="hljs-keyword">in</span> features:
            feature = features[expected_key]
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ <span class="hljs-subst">{expected_key}</span>: <span class="hljs-subst">{feature.<span class="hljs-built_in">type</span>.value}</span>, shape=<span class="hljs-subst">{feature.shape}</span>&quot;</span>)
            found = <span class="hljs-literal">True</span>
            <span class="hljs-keyword">break</span>

    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> found:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Missing expected feature: <span class="hljs-subst">{expected_key}</span>&quot;</span>)`,wrap:!1}}),fe=new j({props:{title:"Summary",local:"summary",headingTag:"h2"}}),ke=new Wl({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/debug_processor_pipeline.mdx"}}),{c(){d=i("meta"),ve=n(),Ae=i("p"),Ge=n(),M(m.$$.fragment),_e=n(),T=i("p"),T.textContent=zt,Xe=n(),J=i("p"),J.innerHTML=Ft,Ve=n(),M(U.$$.fragment),xe=n(),f=i("p"),f.textContent=qt,Ee=n(),M(b.$$.fragment),Re=n(),I=i("p"),I.textContent=Lt,$e=n(),C=i("p"),C.textContent=Pt,We=n(),g=i("p"),g.textContent=Dt,Ne=n(),Z=i("ul"),Z.innerHTML=Kt,Qe=n(),k=i("p"),k.textContent=Ot,He=n(),M(A.$$.fragment),Ye=n(),B=i("p"),B.textContent=el,Se=n(),v=i("ul"),v.innerHTML=tl,ze=n(),M(G.$$.fragment),Fe=n(),M(_.$$.fragment),qe=n(),X=i("p"),X.textContent=ll,Le=n(),M(V.$$.fragment),Pe=n(),M(x.$$.fragment),De=n(),E=i("p"),E.textContent=sl,Ke=n(),R=i("p"),R.textContent=nl,Oe=n(),$=i("p"),$.innerHTML=al,et=n(),W=i("p"),W.textContent=il,tt=n(),M(N.$$.fragment),lt=n(),M(Q.$$.fragment),st=n(),H=i("p"),H.textContent=pl,nt=n(),M(Y.$$.fragment),at=n(),S=i("p"),S.textContent=ol,it=n(),M(z.$$.fragment),pt=n(),M(F.$$.fragment),ot=n(),q=i("p"),q.textContent=Ml,Mt=n(),M(L.$$.fragment),rt=n(),P=i("p"),P.textContent=rl,ht=n(),M(D.$$.fragment),ct=n(),K=i("p"),K.textContent=hl,yt=n(),O=i("p"),O.textContent=cl,ut=n(),ee=i("p"),ee.innerHTML=yl,jt=n(),M(te.$$.fragment),wt=n(),le=i("p"),le.innerHTML=ul,dt=n(),se=i("p"),se.innerHTML=jl,mt=n(),ne=i("p"),ne.textContent=wl,Tt=n(),ae=i("p"),ae.innerHTML=dl,Jt=n(),M(ie.$$.fragment),Ut=n(),M(pe.$$.fragment),ft=n(),oe=i("p"),oe.textContent=ml,bt=n(),M(Me.$$.fragment),It=n(),re=i("p"),re.textContent=Tl,Ct=n(),he=i("ul"),he.innerHTML=Jl,gt=n(),ce=i("p"),ce.innerHTML=Ul,Zt=n(),M(ye.$$.fragment),kt=n(),ue=i("p"),ue.textContent=fl,At=n(),M(je.$$.fragment),Bt=n(),we=i("p"),we.innerHTML=bl,vt=n(),M(de.$$.fragment),Gt=n(),M(me.$$.fragment),_t=n(),Te=i("p"),Te.textContent=Il,Xt=n(),M(Je.$$.fragment),Vt=n(),Ue=i("p"),Ue.textContent=Cl,xt=n(),M(fe.$$.fragment),Et=n(),be=i("p"),be.textContent=gl,Rt=n(),Ie=i("ol"),Ie.innerHTML=Zl,$t=n(),Ce=i("p"),Ce.innerHTML=kl,Wt=n(),ge=i("ul"),ge.innerHTML=Al,Nt=n(),Ze=i("p"),Ze.textContent=Bl,Qt=n(),M(ke.$$.fragment),Ht=n(),Be=i("p"),this.h()},l(e){const t=Rl("svelte-u9bgzb",document.head);d=p(t,"META",{name:!0,content:!0}),t.forEach(l),ve=a(e),Ae=p(e,"P",{}),vl(Ae).forEach(l),Ge=a(e),r(m.$$.fragment,e),_e=a(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1q65nk3"&&(T.textContent=zt),Xe=a(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-u8e3wb"&&(J.innerHTML=Ft),Ve=a(e),r(U.$$.fragment,e),xe=a(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1d4nxx9"&&(f.textContent=qt),Ee=a(e),r(b.$$.fragment,e),Re=a(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1tl8qwt"&&(I.textContent=Lt),$e=a(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-g73lwr"&&(C.textContent=Pt),We=a(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-74gmv5"&&(g.textContent=Dt),Ne=a(e),Z=p(e,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-6outgx"&&(Z.innerHTML=Kt),Qe=a(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-mbtl9h"&&(k.textContent=Ot),He=a(e),r(A.$$.fragment,e),Ye=a(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1fbouur"&&(B.textContent=el),Se=a(e),v=p(e,"UL",{"data-svelte-h":!0}),o(v)!=="svelte-xsrxoj"&&(v.innerHTML=tl),ze=a(e),r(G.$$.fragment,e),Fe=a(e),r(_.$$.fragment,e),qe=a(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1ks2c33"&&(X.textContent=ll),Le=a(e),r(V.$$.fragment,e),Pe=a(e),r(x.$$.fragment,e),De=a(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-7f17pf"&&(E.textContent=sl),Ke=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1nvp99m"&&(R.textContent=nl),Oe=a(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-bpn8qt"&&($.innerHTML=al),et=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1h7hqy"&&(W.textContent=il),tt=a(e),r(N.$$.fragment,e),lt=a(e),r(Q.$$.fragment,e),st=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-ufigjs"&&(H.textContent=pl),nt=a(e),r(Y.$$.fragment,e),at=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-c4zafn"&&(S.textContent=ol),it=a(e),r(z.$$.fragment,e),pt=a(e),r(F.$$.fragment,e),ot=a(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-oullvg"&&(q.textContent=Ml),Mt=a(e),r(L.$$.fragment,e),rt=a(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1kb9xte"&&(P.textContent=rl),ht=a(e),r(D.$$.fragment,e),ct=a(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1ovynfp"&&(K.textContent=hl),yt=a(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-oaf05p"&&(O.textContent=cl),ut=a(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-v29wbq"&&(ee.innerHTML=yl),jt=a(e),r(te.$$.fragment,e),wt=a(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1r8d1yr"&&(le.innerHTML=ul),dt=a(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-10upnqa"&&(se.innerHTML=jl),mt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-14bs306"&&(ne.textContent=wl),Tt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1lcc4zd"&&(ae.innerHTML=dl),Jt=a(e),r(ie.$$.fragment,e),Ut=a(e),r(pe.$$.fragment,e),ft=a(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1j32u21"&&(oe.textContent=ml),bt=a(e),r(Me.$$.fragment,e),It=a(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-c4rq6s"&&(re.textContent=Tl),Ct=a(e),he=p(e,"UL",{"data-svelte-h":!0}),o(he)!=="svelte-5yml2w"&&(he.innerHTML=Jl),gt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-9kdrli"&&(ce.innerHTML=Ul),Zt=a(e),r(ye.$$.fragment,e),kt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1i8k9ls"&&(ue.textContent=fl),At=a(e),r(je.$$.fragment,e),Bt=a(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1tmoeus"&&(we.innerHTML=bl),vt=a(e),r(de.$$.fragment,e),Gt=a(e),r(me.$$.fragment,e),_t=a(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1n7eymf"&&(Te.textContent=Il),Xt=a(e),r(Je.$$.fragment,e),Vt=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-duvvy"&&(Ue.textContent=Cl),xt=a(e),r(fe.$$.fragment,e),Et=a(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1klespr"&&(be.textContent=gl),Rt=a(e),Ie=p(e,"OL",{"data-svelte-h":!0}),o(Ie)!=="svelte-14jg3j9"&&(Ie.innerHTML=Zl),$t=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1s8mdv6"&&(Ce.innerHTML=kl),Wt=a(e),ge=p(e,"UL",{"data-svelte-h":!0}),o(ge)!=="svelte-6ucjs5"&&(ge.innerHTML=Al),Nt=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-dgojim"&&(Ze.textContent=Bl),Qt=a(e),r(ke.$$.fragment,e),Ht=a(e),Be=p(e,"P",{}),vl(Be).forEach(l),this.h()},h(){Gl(d,"name","hf:doc:metadata"),Gl(d,"content",Ql)},m(e,t){$l(document.head,d),s(e,ve,t),s(e,Ae,t),s(e,Ge,t),h(m,e,t),s(e,_e,t),s(e,T,t),s(e,Xe,t),s(e,J,t),s(e,Ve,t),h(U,e,t),s(e,xe,t),s(e,f,t),s(e,Ee,t),h(b,e,t),s(e,Re,t),s(e,I,t),s(e,$e,t),s(e,C,t),s(e,We,t),s(e,g,t),s(e,Ne,t),s(e,Z,t),s(e,Qe,t),s(e,k,t),s(e,He,t),h(A,e,t),s(e,Ye,t),s(e,B,t),s(e,Se,t),s(e,v,t),s(e,ze,t),h(G,e,t),s(e,Fe,t),h(_,e,t),s(e,qe,t),s(e,X,t),s(e,Le,t),h(V,e,t),s(e,Pe,t),h(x,e,t),s(e,De,t),s(e,E,t),s(e,Ke,t),s(e,R,t),s(e,Oe,t),s(e,$,t),s(e,et,t),s(e,W,t),s(e,tt,t),h(N,e,t),s(e,lt,t),h(Q,e,t),s(e,st,t),s(e,H,t),s(e,nt,t),h(Y,e,t),s(e,at,t),s(e,S,t),s(e,it,t),h(z,e,t),s(e,pt,t),h(F,e,t),s(e,ot,t),s(e,q,t),s(e,Mt,t),h(L,e,t),s(e,rt,t),s(e,P,t),s(e,ht,t),h(D,e,t),s(e,ct,t),s(e,K,t),s(e,yt,t),s(e,O,t),s(e,ut,t),s(e,ee,t),s(e,jt,t),h(te,e,t),s(e,wt,t),s(e,le,t),s(e,dt,t),s(e,se,t),s(e,mt,t),s(e,ne,t),s(e,Tt,t),s(e,ae,t),s(e,Jt,t),h(ie,e,t),s(e,Ut,t),h(pe,e,t),s(e,ft,t),s(e,oe,t),s(e,bt,t),h(Me,e,t),s(e,It,t),s(e,re,t),s(e,Ct,t),s(e,he,t),s(e,gt,t),s(e,ce,t),s(e,Zt,t),h(ye,e,t),s(e,kt,t),s(e,ue,t),s(e,At,t),h(je,e,t),s(e,Bt,t),s(e,we,t),s(e,vt,t),h(de,e,t),s(e,Gt,t),h(me,e,t),s(e,_t,t),s(e,Te,t),s(e,Xt,t),h(Je,e,t),s(e,Vt,t),s(e,Ue,t),s(e,xt,t),h(fe,e,t),s(e,Et,t),s(e,be,t),s(e,Rt,t),s(e,Ie,t),s(e,$t,t),s(e,Ce,t),s(e,Wt,t),s(e,ge,t),s(e,Nt,t),s(e,Ze,t),s(e,Qt,t),h(ke,e,t),s(e,Ht,t),s(e,Be,t),Yt=!0},p:Xl,i(e){Yt||(c(m.$$.fragment,e),c(U.$$.fragment,e),c(b.$$.fragment,e),c(A.$$.fragment,e),c(G.$$.fragment,e),c(_.$$.fragment,e),c(V.$$.fragment,e),c(x.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(Y.$$.fragment,e),c(z.$$.fragment,e),c(F.$$.fragment,e),c(L.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(je.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(Je.$$.fragment,e),c(fe.$$.fragment,e),c(ke.$$.fragment,e),Yt=!0)},o(e){y(m.$$.fragment,e),y(U.$$.fragment,e),y(b.$$.fragment,e),y(A.$$.fragment,e),y(G.$$.fragment,e),y(_.$$.fragment,e),y(V.$$.fragment,e),y(x.$$.fragment,e),y(N.$$.fragment,e),y(Q.$$.fragment,e),y(Y.$$.fragment,e),y(z.$$.fragment,e),y(F.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(te.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),y(ye.$$.fragment,e),y(je.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(Je.$$.fragment,e),y(fe.$$.fragment,e),y(ke.$$.fragment,e),Yt=!1},d(e){e&&(l(ve),l(Ae),l(Ge),l(_e),l(T),l(Xe),l(J),l(Ve),l(xe),l(f),l(Ee),l(Re),l(I),l($e),l(C),l(We),l(g),l(Ne),l(Z),l(Qe),l(k),l(He),l(Ye),l(B),l(Se),l(v),l(ze),l(Fe),l(qe),l(X),l(Le),l(Pe),l(De),l(E),l(Ke),l(R),l(Oe),l($),l(et),l(W),l(tt),l(lt),l(st),l(H),l(nt),l(at),l(S),l(it),l(pt),l(ot),l(q),l(Mt),l(rt),l(P),l(ht),l(ct),l(K),l(yt),l(O),l(ut),l(ee),l(jt),l(wt),l(le),l(dt),l(se),l(mt),l(ne),l(Tt),l(ae),l(Jt),l(Ut),l(ft),l(oe),l(bt),l(It),l(re),l(Ct),l(he),l(gt),l(ce),l(Zt),l(kt),l(ue),l(At),l(Bt),l(we),l(vt),l(Gt),l(_t),l(Te),l(Xt),l(Vt),l(Ue),l(xt),l(Et),l(be),l(Rt),l(Ie),l($t),l(Ce),l(Wt),l(ge),l(Nt),l(Ze),l(Qt),l(Ht),l(Be)),l(d),u(m,e),u(U,e),u(b,e),u(A,e),u(G,e),u(_,e),u(V,e),u(x,e),u(N,e),u(Q,e),u(Y,e),u(z,e),u(F,e),u(L,e),u(D,e),u(te,e),u(ie,e),u(pe,e),u(Me,e),u(ye,e),u(je,e),u(de,e),u(me,e),u(Je,e),u(fe,e),u(ke,e)}}}const Ql='{"title":"Debug Your Processor Pipeline","local":"debug-your-processor-pipeline","sections":[{"title":"Understanding Hooks","local":"understanding-hooks","sections":[{"title":"What is a Hook?","local":"what-is-a-hook","sections":[],"depth":3},{"title":"Before vs After Hooks","local":"before-vs-after-hooks","sections":[],"depth":3},{"title":"Implementing a NaN Detection Hook","local":"implementing-a-nan-detection-hook","sections":[],"depth":3},{"title":"How Hooks Work Internally","local":"how-hooks-work-internally","sections":[],"depth":3},{"title":"Execution Flow","local":"execution-flow","sections":[],"depth":3},{"title":"Multiple Hooks","local":"multiple-hooks","sections":[],"depth":3}],"depth":2},{"title":"Step-Through Debugging","local":"step-through-debugging","sections":[{"title":"How Step-Through Works","local":"how-step-through-works","sections":[],"depth":3},{"title":"Interactive Debugging with Breakpoints","local":"interactive-debugging-with-breakpoints","sections":[],"depth":3}],"depth":2},{"title":"Validating Feature Contracts","local":"validating-feature-contracts","sections":[{"title":"Understanding Feature Contracts","local":"understanding-feature-contracts","sections":[],"depth":3},{"title":"Verifying Expected Features","local":"verifying-expected-features","sections":[],"depth":3}],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function Hl(St){return Vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends xl{constructor(d){super(),El(this,d,Hl,Nl,_l,{})}}export{ql as component};
