import{s as bl,n as fl,o as Cl}from"../chunks/scheduler.3e37077e.js";import{S as Il,i as Rl,g as i,s as a,r as p,A as gl,h as o,f as l,c as n,j as At,u as r,x as M,k as jl,y as Qt,a as s,v as c,d as y,t as J,w as U}from"../chunks/index.263272b0.js";import{C as T}from"../chunks/CodeBlock.76c31e3c.js";import{H as h,E as Zl}from"../chunks/getInferenceSnippets.932de0ac.js";function $l(Wt){let m,$e,ge,_e,d,ve,u,kt=`Reachy 2 is an open-source humanoid robot made by Pollen Robotics, specifically designed for the development of embodied AI and real-world applications.
Check out <a href="https://www.pollen-robotics.com/reachy/" rel="nofollow">Pollen Robotics website</a>, or access <a href="https://docs.pollen-robotics.com/" rel="nofollow">Reachy 2 documentation</a> for more information on the platform!`,Ve,j,Be,b,xt="Currently, there are two ways to teleoperate Reachy 2:",Se,f,Ht="<li>Pollen Robotics’ VR teleoperation (not included in LeRobot).</li> <li>Robot-to-robot teleoperation (use one Reachy 2 to control another).</li>",Ge,C,Xe,I,Ft='<strong>(Linux only)</strong> You can run Reachy 2 in simulation (Gazebo or MuJoCo) using the provided <a href="https://hub.docker.com/r/pollenrobotics/reachy2_core" rel="nofollow">Docker image</a>.',Le,R,zt='<li>Install <a href="https://docs.docker.com/engine/" rel="nofollow">Docker Engine</a>.</li> <li>Run (for MuJoCo):</li>',Ye,g,Ne,w,Re,qt="If MuJoCo runs slowly (low simulation frequency), append <code>-e LD_LIBRARY_PATH=&quot;/opt/host-libs:$LD_LIBRARY_PATH&quot; \\</code> to the previous command to improve performance:",Et,Z,Ee,$,Ae,_,Qe,v,Dt="<li>On your robot, check the <strong>service images</strong> meet the minimum versions:<ul><li><strong>reachy2-core &gt;= 1.7.5.2</strong></li> <li><strong>webrtc &gt;= 2.0.1.1</strong></li></ul></li>",We,V,Pt="Then, if you want to use VR teleoperation:",ke,B,Ot=`<li>Install the <a href="https://docs.pollen-robotics.com/teleoperation/teleoperation-introduction/discover-teleoperation/" rel="nofollow">Reachy 2 teleoperation application</a>.
Use version <strong>&gt;=v1.2.0</strong></li>`,xe,S,Kt="We recommend using two computers: one for teleoperation (Windows required) and another for recording with LeRobot.",He,G,Fe,X,el='Follow the <a href="https://github.com/huggingface/lerobot#installation" rel="nofollow">installation instructions</a> to install LeRobot.',ze,L,tl="Install LeRobot with Reachy 2 dependencies:",qe,Y,De,N,Pe,E,ll="How you manage Reachy 2 recording sessions is up to you, but the <strong>easiest</strong> way is to use this server so you can control sessions directly from the VR teleoperation app.",Oe,A,sl="<p><strong>Note:</strong> Currently, only the VR teleoperation application works as a client for this server, so this step primarily targets teleoperation. You’re free to develop custom clients to manage sessions to your needs.</p>",Ke,Q,al="In your LeRobot environment, install the server from source:",et,W,tt,k,nl='Find the <a href="https://github.com/pollen-robotics/pollen_data_acquisition_server" rel="nofollow">pollen_data_acquisition_server documentation here</a>.',lt,x,st,H,at,F,il=`Before starting teleoperation and data recording, find the <a href="https://docs.pollen-robotics.com/getting-started/setup-reachy2/connect-reachy2/" rel="nofollow">robot’s IP address</a>.
We strongly recommend connecting all devices (PC and robot) via <strong>Ethernet</strong>.`,nt,z,it,q,ol="There are two ways to manage recording sessions when using the Reachy 2 VR teleoperation application:",ot,D,pl="<li><strong>Using the data acquisition server (recommended for VR teleop)</strong>: The VR app orchestrates sessions (via the server it tells LeRobot when to create datasets, start/stop episodes) while also controlling the robot’s motions.</li> <li><strong>Using LeRobot’s record script</strong>: LeRobot owns session control and decides when to start/stop episodes. If you also use the VR teleop app, it’s only for motion control.</li>",pt,P,rt,O,rl="Make sure you have installed pollen_data_acquisition_server, as explained in the Setup section.",Mt,K,Ml="Launch the data acquisition server to be able to manage your session directly from the teleoperation application:",ct,ee,yt,te,cl=`Then get into the teleoperation application and choose “Data acquisition session”.
You can finally setup your session by following the screens displayed.`,Jt,le,yl="<p>Even without the VR app, you can use the <code>pollen_data_acquisition_server</code> with your own client implementation.</p>",Ut,se,ht,ae,Jl=`Reachy 2 is fully supported by LeRobot’s recording features.
If you choose this option but still want to use the VR teleoperation application, select “Standard session” in the app.`,Tt,ne,Ul=`<strong>Example: start a recording without the mobile base:</strong>
First add reachy2 and reachy2_teleoperator to the imports of the record script. Then you can use the following command:`,mt,ie,wt,oe,dt,pe,hl="<strong>Extended setup overview (all options included):</strong>",ut,re,jt,Me,bt,ce,Tl=`Determine whether LeRobot robot.send_action() sends commands to the robot.
<strong>Must</strong> be set to false while using the VR teleoperation application, as the app already sends commands.`,ft,ye,Ct,Je,ml=`Determine whether the teleoperator reads the goal or present position of the robot.
Must be set to true if a compliant Reachy 2 is used to control another one.`,It,Ue,Rt,he,wl=`From our initial tests, recording <strong>all</strong> joints when only some are moving can reduce model quality with certain policies.
To avoid this, you can exclude specific parts from recording and replay using:`,gt,Te,Zt,me,dl="—teleop.with_<part>",$t,we,_t,de,ul=`—robot.with_left_teleop_camera=<true|false>
—robot.with_right_teleop_camera=<true|false>
—robot.with_torso_camera=<true|false>`,vt,ue,Vt,je,Bt,be,St,fe,Gt,Ce,Xt,Ie,Lt,Ze,Yt;return d=new h({props:{title:"Reachy 2",local:"reachy-2",headingTag:"h1"}}),j=new h({props:{title:"Teleoperate Reachy 2",local:"teleoperate-reachy-2",headingTag:"h2"}}),C=new h({props:{title:"Reachy 2 Simulation",local:"reachy-2-simulation",headingTag:"h2"}}),g=new T({props:{code:"ZG9ja2VyJTIwcnVuJTIwLS1ybSUyMC1pdCUyMCU1QyUwQSUyMCUyMC0tbmFtZSUyMHJlYWNoeSUyMCU1QyUwQSUyMCUyMC0tcHJpdmlsZWdlZCUyMCU1QyUwQSUyMCUyMC0tbmV0d29yayUyMGhvc3QlMjAlNUMlMEElMjAlMjAtLWlwYyUyMGhvc3QlMjAlNUMlMEElMjAlMjAtLWRldmljZS1jZ3JvdXAtcnVsZSUzRCdjJTIwMTg5JTNBKiUyMHJ3bSclMjAlNUMlMEElMjAlMjAtLWdyb3VwLWFkZCUyMGF1ZGlvJTIwJTVDJTBBJTIwJTIwLWUlMjBST1NfRE9NQUlOX0lEJTNEJTIyJTI0Uk9TX0RPTUFJTl9JRCUyMiUyMCU1QyUwQSUyMCUyMC1lJTIwRElTUExBWSUzRCUyMiUyNERJU1BMQVklMjIlMjAlNUMlMEElMjAlMjAtZSUyMFJDVVRJTFNfQ09OU09MRV9PVVRQVVRfRk9STUFUJTNEJTIyJTVCJTdCc2V2ZXJpdHklN0QlNUQlM0ElMjAlN0JtZXNzYWdlJTdEJTIyJTIwJTVDJTBBJTIwJTIwLWUlMjBSRUFDSFkyX0NPUkVfU0VSVklDRV9GQUtFJTNEJTIyJTI0JTdCUkVBQ0hZMl9DT1JFX1NFUlZJQ0VfRkFLRSUzQS10cnVlJTdEJTIyJTIwJTVDJTBBJTIwJTIwLXYlMjAlMkZkZXYlM0ElMkZkZXYlMjAlNUMlMEElMjAlMjAtdiUyMCUyMiUyNEhPTUUlMkYucmVhY2h5X2NvbmZpZyUyMiUzQSUyRmhvbWUlMkZyZWFjaHklMkYucmVhY2h5X2NvbmZpZ19vdmVycmlkZSUyMCU1QyUwQSUyMCUyMC12JTIwJTIyJTI0SE9NRSUyRi5yZWFjaHkubG9nJTIyJTNBJTJGaG9tZSUyRnJlYWNoeSUyRi5yb3MlMkZsb2clMjAlNUMlMEElMjAlMjAtdiUyMCUyRnVzciUyRmxpYiUyRng4Nl82NC1saW51eC1nbnUlM0ElMkZvcHQlMkZob3N0LWxpYnMlMjAlNUMlMEElMjAlMjAtLWVudHJ5cG9pbnQlMjAlMkZwYWNrYWdlJTJGbGF1bmNoLnNoJTIwJTVDJTBBJTIwJTIwcG9sbGVucm9ib3RpY3MlMkZyZWFjaHkyX2NvcmUlM0ExLjcuNS45X2RlcGxveSUyMCU1QyUwQSUyMCUyMHN0YXJ0X3J2aXolM0ElM0R0cnVlJTIwc3RhcnRfc2RrX3NlcnZlciUzQSUzRHRydWUlMjBtdWpvY28lM0ElM0R0cnVl",highlighted:`docker run --rm -<span class="hljs-literal">it</span> <span class="hljs-string">\\</span>
  --name reachy <span class="hljs-string">\\</span>
  --privileged <span class="hljs-string">\\</span>
  --network host <span class="hljs-string">\\</span>
  --ipc host <span class="hljs-string">\\</span>
  --device-cgroup-rule=<span class="hljs-string">&#x27;c 189:* rwm&#x27;</span> <span class="hljs-string">\\</span>
  --group-add audio <span class="hljs-string">\\</span>
  -e ROS_DOMAIN_ID=<span class="hljs-string">&quot;$ROS_DOMAIN_ID&quot;</span> <span class="hljs-string">\\</span>
  -e DISPLAY=<span class="hljs-string">&quot;$DISPLAY&quot;</span> <span class="hljs-string">\\</span>
  -e RCUTILS_CONSOLE_OUTPUT_FORMAT=<span class="hljs-string">&quot;[{severity}]: {message}&quot;</span> <span class="hljs-string">\\</span>
  -e REACHY2_CORE_SERVICE_FAKE=<span class="hljs-string">&quot;\${REACHY2_CORE_SERVICE_FAKE:-true}&quot;</span> <span class="hljs-string">\\</span>
  -v /dev:/dev <span class="hljs-string">\\</span>
  -v <span class="hljs-string">&quot;$HOME/.reachy_config&quot;</span>:<span class="hljs-regexp">/home/reachy/</span>.reachy_config_override <span class="hljs-string">\\</span>
  -v <span class="hljs-string">&quot;$HOME/.reachy.log&quot;</span>:<span class="hljs-regexp">/home/reachy/</span>.ros/log <span class="hljs-string">\\</span>
  -v /usr/lib/x86_64-linux-gnu:/opt/host-libs <span class="hljs-string">\\</span>
  --entrypoint /package/launch.sh <span class="hljs-string">\\</span>
  pollenrobotics/reachy2_core:<span class="hljs-number">1.7</span>.<span class="hljs-number">5.9_deploy</span> <span class="hljs-string">\\</span>
  start_rviz:=<span class="hljs-literal">true</span> start_sdk_server:=<span class="hljs-literal">true</span> mujoco:=<span class="hljs-literal">true</span>`,wrap:!1}}),Z=new T({props:{code:"ZG9ja2VyJTIwcnVuJTIwLS1ybSUyMC1pdCUyMCU1QyUwQSUyMCUyMC0tbmFtZSUyMHJlYWNoeSUyMCU1QyUwQSUyMCUyMC0tcHJpdmlsZWdlZCUyMCU1QyUwQSUyMCUyMC0tbmV0d29yayUyMGhvc3QlMjAlNUMlMEElMjAlMjAtLWlwYyUyMGhvc3QlMjAlNUMlMEElMjAlMjAtLWRldmljZS1jZ3JvdXAtcnVsZSUzRCdjJTIwMTg5JTNBKiUyMHJ3bSclMjAlNUMlMEElMjAlMjAtLWdyb3VwLWFkZCUyMGF1ZGlvJTIwJTVDJTBBJTIwJTIwLWUlMjBST1NfRE9NQUlOX0lEJTNEJTIyJTI0Uk9TX0RPTUFJTl9JRCUyMiUyMCU1QyUwQSUyMCUyMC1lJTIwRElTUExBWSUzRCUyMiUyNERJU1BMQVklMjIlMjAlNUMlMEElMjAlMjAtZSUyMFJDVVRJTFNfQ09OU09MRV9PVVRQVVRfRk9STUFUJTNEJTIyJTVCJTdCc2V2ZXJpdHklN0QlNUQlM0ElMjAlN0JtZXNzYWdlJTdEJTIyJTIwJTVDJTBBJTIwJTIwLWUlMjBSRUFDSFkyX0NPUkVfU0VSVklDRV9GQUtFJTNEJTIyJTI0JTdCUkVBQ0hZMl9DT1JFX1NFUlZJQ0VfRkFLRSUzQS10cnVlJTdEJTIyJTIwJTVDJTBBJTIwJTIwLWUlMjBMRF9MSUJSQVJZX1BBVEglM0QlMjIlMkZvcHQlMkZob3N0LWxpYnMlM0ElMjRMRF9MSUJSQVJZX1BBVEglMjIlMjAlNUMlMEElMjAlMjAtdiUyMCUyRmRldiUzQSUyRmRldiUyMCU1QyUwQSUyMCUyMC12JTIwJTIyJTI0SE9NRSUyRi5yZWFjaHlfY29uZmlnJTIyJTNBJTJGaG9tZSUyRnJlYWNoeSUyRi5yZWFjaHlfY29uZmlnX292ZXJyaWRlJTIwJTVDJTBBJTIwJTIwLXYlMjAlMjIlMjRIT01FJTJGLnJlYWNoeS5sb2clMjIlM0ElMkZob21lJTJGcmVhY2h5JTJGLnJvcyUyRmxvZyUyMCU1QyUwQSUyMCUyMC12JTIwJTJGdXNyJTJGbGliJTJGeDg2XzY0LWxpbnV4LWdudSUzQSUyRm9wdCUyRmhvc3QtbGlicyUyMCU1QyUwQSUyMCUyMC0tZW50cnlwb2ludCUyMCUyRnBhY2thZ2UlMkZsYXVuY2guc2glMjAlNUMlMEElMjAlMjBwb2xsZW5yb2JvdGljcyUyRnJlYWNoeTJfY29yZSUzQTEuNy41LjlfZGVwbG95JTIwJTVDJTBBJTIwJTIwc3RhcnRfcnZpeiUzQSUzRHRydWUlMjBzdGFydF9zZGtfc2VydmVyJTNBJTNEdHJ1ZSUyMG11am9jbyUzQSUzRHRydWU=",highlighted:`docker run --rm -<span class="hljs-literal">it</span> <span class="hljs-string">\\</span>
  --name reachy <span class="hljs-string">\\</span>
  --privileged <span class="hljs-string">\\</span>
  --network host <span class="hljs-string">\\</span>
  --ipc host <span class="hljs-string">\\</span>
  --device-cgroup-rule=<span class="hljs-string">&#x27;c 189:* rwm&#x27;</span> <span class="hljs-string">\\</span>
  --group-add audio <span class="hljs-string">\\</span>
  -e ROS_DOMAIN_ID=<span class="hljs-string">&quot;$ROS_DOMAIN_ID&quot;</span> <span class="hljs-string">\\</span>
  -e DISPLAY=<span class="hljs-string">&quot;$DISPLAY&quot;</span> <span class="hljs-string">\\</span>
  -e RCUTILS_CONSOLE_OUTPUT_FORMAT=<span class="hljs-string">&quot;[{severity}]: {message}&quot;</span> <span class="hljs-string">\\</span>
  -e REACHY2_CORE_SERVICE_FAKE=<span class="hljs-string">&quot;\${REACHY2_CORE_SERVICE_FAKE:-true}&quot;</span> <span class="hljs-string">\\</span>
  -e LD_LIBRARY_PATH=<span class="hljs-string">&quot;/opt/host-libs:$LD_LIBRARY_PATH&quot;</span> <span class="hljs-string">\\</span>
  -v /dev:/dev <span class="hljs-string">\\</span>
  -v <span class="hljs-string">&quot;$HOME/.reachy_config&quot;</span>:<span class="hljs-regexp">/home/reachy/</span>.reachy_config_override <span class="hljs-string">\\</span>
  -v <span class="hljs-string">&quot;$HOME/.reachy.log&quot;</span>:<span class="hljs-regexp">/home/reachy/</span>.ros/log <span class="hljs-string">\\</span>
  -v /usr/lib/x86_64-linux-gnu:/opt/host-libs <span class="hljs-string">\\</span>
  --entrypoint /package/launch.sh <span class="hljs-string">\\</span>
  pollenrobotics/reachy2_core:<span class="hljs-number">1.7</span>.<span class="hljs-number">5.9_deploy</span> <span class="hljs-string">\\</span>
  start_rviz:=<span class="hljs-literal">true</span> start_sdk_server:=<span class="hljs-literal">true</span> mujoco:=<span class="hljs-literal">true</span>`,wrap:!1}}),$=new h({props:{title:"Setup",local:"setup",headingTag:"h2"}}),_=new h({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h3"}}),G=new h({props:{title:"Install LeRobot",local:"install-lerobot",headingTag:"h3"}}),Y=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnJlYWNoeTIlNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[reachy2]&quot;</span>',wrap:!1}}),N=new h({props:{title:"(Optional but recommended) Install pollen_data_acquisition_server",local:"optional-but-recommended-install-pollendataacquisitionserver",headingTag:"h3"}}),W=new T({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZwb2xsZW4tcm9ib3RpY3MlMkZwb2xsZW5fZGF0YV9hY3F1aXNpdGlvbl9zZXJ2ZXIuZ2l0JTBBY2QlMjBwb2xsZW5fZGF0YV9hY3F1aXNpdGlvbl9zZXJ2ZXIlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/pollen-robotics/pollen_data_acquisition_server.git
<span class="hljs-built_in">cd</span> pollen_data_acquisition_server
pip install -e .`,wrap:!1}}),x=new h({props:{title:"Step 1: Recording",local:"step-1-recording",headingTag:"h2"}}),H=new h({props:{title:"Get Reachy 2 IP address",local:"get-reachy-2-ip-address",headingTag:"h3"}}),z=new h({props:{title:"Launch recording",local:"launch-recording",headingTag:"h3"}}),P=new h({props:{title:"Option 1: Using Pollen data acquisition server (recommended for VR teleop)",local:"option-1-using-pollen-data-acquisition-server-recommended-for-vr-teleop",headingTag:"h3"}}),ee=new T({props:{code:"cHl0aG9uJTIwLW0lMjBwb2xsZW5fZGF0YV9hY3F1aXNpdGlvbl9zZXJ2ZXIuc2VydmVy",highlighted:"python -m pollen_data_acquisition_server.server",wrap:!1}}),se=new h({props:{title:"Option 2: Using lerobot.record",local:"option-2-using-lerobotrecord",headingTag:"h3"}}),ie=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJlY29yZCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9ib3QudHlwZSUzRHJlYWNoeTIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJvYm90LmlwX2FkZHJlc3MlM0QxOTIuMTY4LjAuMjAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yb2JvdC5pZCUzRHIyLTAwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJvYm90LnVzZV9leHRlcm5hbF9jb21tYW5kcyUzRHRydWUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJvYm90LndpdGhfbW9iaWxlX2Jhc2UlM0RmYWxzZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLnR5cGUlM0RyZWFjaHkyX3RlbGVvcGVyYXRvciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLmlwX2FkZHJlc3MlM0QxOTIuMTY4LjAuMjAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZWxlb3Aud2l0aF9tb2JpbGVfYmFzZSUzRGZhbHNlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0LnJlcG9faWQlM0Rwb2xsZW5fcm9ib3RpY3MlMkZyZWNvcmRfdGVzdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldC5zaW5nbGVfdGFzayUzRCUyMlJlYWNoeSUyMDIlMjByZWNvcmRpbmclMjB0ZXN0JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0Lm51bV9lcGlzb2RlcyUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXQuZXBpc29kZV90aW1lX3MlM0Q1JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0LmZwcyUzRDE1JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0LnB1c2hfdG9faHViJTNEdHJ1ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldC5wcml2YXRlJTNEdHJ1ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGlzcGxheV9kYXRhJTNEdHJ1ZQ==",highlighted:`python -m lerobot.record \\
    --robot.type=reachy2 \\
    --robot.ip_address=192.168.0.200 \\
    --robot.id=r2-0000 \\
    --robot.use_external_commands=<span class="hljs-literal">true</span> \\
    --robot.with_mobile_base=<span class="hljs-literal">false</span> \\
    --teleop.type=reachy2_teleoperator \\
    --teleop.ip_address=192.168.0.200 \\
    --teleop.with_mobile_base=<span class="hljs-literal">false</span> \\
    --dataset.repo_id=pollen_robotics/record_test \\
    --dataset.single_task=<span class="hljs-string">&quot;Reachy 2 recording test&quot;</span> \\
    --dataset.num_episodes=1 \\
    --dataset.episode_time_s=5 \\
    --dataset.fps=15 \\
    --dataset.push_to_hub=<span class="hljs-literal">true</span> \\
    --dataset.private=<span class="hljs-literal">true</span> \\
    --display_data=<span class="hljs-literal">true</span>`,wrap:!1}}),oe=new h({props:{title:"Specific Options",local:"specific-options",headingTag:"h4"}}),re=new T({props:{code:"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",highlighted:`python -m lerobot.record \\
    --robot.type=reachy2 \\
    --robot.ip_address=192.168.0.200 \\
    --robot.use_external_commands=<span class="hljs-literal">true</span> \\
    --robot.with_mobile_base=<span class="hljs-literal">true</span> \\
    --robot.with_l_arm=<span class="hljs-literal">true</span> \\
    --robot.with_r_arm=<span class="hljs-literal">true</span> \\
    --robot.with_neck=<span class="hljs-literal">true</span> \\
    --robot.with_antennas=<span class="hljs-literal">true</span> \\
    --robot.with_left_teleop_camera=<span class="hljs-literal">true</span> \\
    --robot.with_right_teleop_camera=<span class="hljs-literal">true</span> \\
    --robot.with_torso_camera=<span class="hljs-literal">false</span> \\
    --robot.disable_torque_on_disconnect=<span class="hljs-literal">false</span> \\
    --robot.max_relative_target=5.0 \\
    --teleop.type=reachy2_teleoperator \\
    --teleop.ip_address=192.168.0.200 \\
    --teleop.use_present_position=<span class="hljs-literal">false</span> \\
    --teleop.with_mobile_base=<span class="hljs-literal">false</span> \\
    --teleop.with_l_arm=<span class="hljs-literal">true</span> \\
    --teleop.with_r_arm=<span class="hljs-literal">true</span> \\
    --teleop.with_neck=<span class="hljs-literal">true</span> \\
    --teleop.with_antennas=<span class="hljs-literal">true</span> \\
    --dataset.repo_id=pollen_robotics/record_test \\
    --dataset.single_task=<span class="hljs-string">&quot;Reachy 2 recording test&quot;</span> \\
    --dataset.num_episodes=1 \\
    --dataset.episode_time_s=5 \\
    --dataset.fps=15 \\
    --dataset.push_to_hub=<span class="hljs-literal">true</span> \\
    --dataset.private=<span class="hljs-literal">true</span> \\
    --display_data=<span class="hljs-literal">true</span>`,wrap:!1}}),Me=new h({props:{title:"--robot.use_external_commands",local:"--robotuseexternalcommands",headingTag:"h5"}}),ye=new h({props:{title:"--teleop.use_present_position",local:"--teleopusepresentposition",headingTag:"h5"}}),Ue=new h({props:{title:"Use the relevant parts",local:"use-the-relevant-parts",headingTag:"h5"}}),Te=new T({props:{code:"LS1yb2JvdC53aXRoXyUzQ3BhcnQlM0UlM0RmYWxzZSUwQSU2MCU2MCU2MCUyQyUwQXdpdGglMjAlNjAlM0NwYXJ0JTNFJTYwJTIwYmVpbmclMjBvbmUlMjBvZiUyMCUzQSUyMCU2MG1vYmlsZV9iYXNlJTYwJTJDJTIwJTYwbF9hcm0lNjAlMkMlMjAlNjByX2FybSUyMiUyQyUyMCU2MG5lY2slNjAlMkMlMjAlNjBhbnRlbm5hcyU2MC4lMEFJdCUyMGRldGVybWluZSUyMHdoZXRoZXIlMjB0aGUlMjBjb3JyZXNwb25kaW5nJTIwcGFydCUyMGlzJTIwcmVjb3JkZWQlMjBpbiUyMHRoZSUyMG9ic2VydmF0aW9ucy4lMjBUcnVlJTIwaWYlMjBub3QlMjBzZXQuJTBBJTBBQnklMjBkZWZhdWx0JTJDJTIwKiphbGwlMjBwYXJ0cyUyMGFyZSUyMHJlY29yZGVkKiouJTBBJTBBVGhlJTIwc2FtZSUyMHBlci1wYXJ0JTIwbWVjaGFuaXNtJTIwaXMlMjBhdmFpbGFibGUlMjBpbiUyMCU2MHJlYWNoeTJfdGVsZW9wZXJhdG9yJTYwJTIwYXMlMjB3ZWxsLiUwQQ==",highlighted:'--robot.with_&lt;part&gt;=<span class="hljs-literal">false</span>\n```<span class="language-javascript">,\n<span class="hljs-keyword">with</span> <span class="hljs-string">`&lt;part&gt;`</span> being one <span class="hljs-keyword">of</span> : <span class="hljs-string">`mobile_base`</span>, <span class="hljs-string">`l_arm`</span>, <span class="hljs-string">`r_arm&quot;, `</span>neck<span class="hljs-string">`, `</span>antennas<span class="hljs-string">`.\nIt determine whether the corresponding part is recorded in the observations. True if not set.\n\nBy default, **all parts are recorded**.\n\nThe same per-part mechanism is available in `</span>reachy2_teleoperator<span class="hljs-string">` as well.\n</span></span>',wrap:!1}}),we=new T({props:{code:"d2l0aCUyMCU2MCUzQ3BhcnQlM0UlNjAlMjBiZWluZyUyMG9uZSUyMG9mJTIwJTNBJTIwJTYwbW9iaWxlX2Jhc2UlNjAlMkMlMjAlNjBsX2FybSU2MCUyQyUyMCU2MHJfYXJtJTIyJTJDJTIwJTYwbmVjayU2MCUyQyUyMCU2MGFudGVubmFzJTYwLiUwQURldGVybWluZSUyMHdoZXRoZXIlMjB0aGUlMjBjb3JyZXNwb25kaW5nJTIwcGFydCUyMGlzJTIwcmVjb3JkZWQlMjBpbiUyMHRoZSUyMGFjdGlvbnMuJTIwVHJ1ZSUyMGlmJTIwbm90JTIwc2V0LiUwQSUwQSUzRSUyMCoqSW1wb3J0YW50JTNBKiolMjBJbiUyMGElMjBnaXZlbiUyMHNlc3Npb24lMkMlMjB0aGUlMjAqKmVuYWJsZWQlMjBwYXJ0cyUyMG11c3QlMjBtYXRjaCoqJTIwb24lMjBib3RoJTIwdGhlJTIwcm9ib3QlMjBhbmQlMjB0aGUlMjB0ZWxlb3BlcmF0b3IuJTBBRm9yJTIwZXhhbXBsZSUyQyUyMGlmJTIwdGhlJTIwcm9ib3QlMjBydW5zJTIwd2l0aCUyMCU2MC0tcm9ib3Qud2l0aF9tb2JpbGVfYmFzZSUzRGZhbHNlJTYwJTJDJTIwdGhlJTIwdGVsZW9wZXJhdG9yJTIwbXVzdCUyMGRpc2FibGUlMjB0aGUlMjBzYW1lJTIwcGFydCUyMCU2MC0tdGVsZW9wZXJhdG9yLndpdGhfbW9iaWxlX2Jhc2UlM0RmYWxzZSU2MC4lMEElMEElMjMlMjMlMjMlMjMlMjMlMjBVc2UlMjB0aGUlMjByZWxldmFudCUyMGNhbWVyYXMlMEElMEFZb3UlMjBjYW4lMjBkbyUyMHRoZSUyMHNhbWUlMjBmb3IlMjAqKmNhbWVyYXMqKi4lMjBCeSUyMGRlZmF1bHQlMkMlMjBvbmx5JTIwdGhlJTIwKip0ZWxlb3BlcmF0aW9uJTIwY2FtZXJhcyoqJTIwYXJlJTIwcmVjb3JkZWQlMjAoYm90aCUyMCU2MGxlZnRfdGVsZW9wX2NhbWVyYSU2MCUyMGFuZCUyMCU2MHJpZ2h0X3RlbGVvcF9jYW1lcmElNjApLiUyMEVuYWJsZSUyMG9yJTIwZGlzYWJsZSUyMGVhY2glMjBjYW1lcmElMjB3aXRoJTNBJTBB",highlighted:'with <span class="hljs-code">`&lt;part&gt;`</span> being one of : <span class="hljs-code">`mobile_base`</span>, <span class="hljs-code">`l_arm`</span>, <span class="hljs-code">`r_arm&quot;, `</span>neck<span class="hljs-code">`, `</span>antennas`.\nDetermine whether the corresponding part is recorded in the actions. True if not set.\n\n<span class="hljs-quote">&gt; <span class="hljs-strong">**Important:**</span> In a given session, the <span class="hljs-strong">**enabled parts must match**</span> on both the robot and the teleoperator.</span>\nFor example, if the robot runs with <span class="hljs-code">`--robot.with_mobile_base=false`</span>, the teleoperator must disable the same part <span class="hljs-code">`--teleoperator.with_mobile_base=false`</span>.\n\n<span class="hljs-section">##### Use the relevant cameras</span>\n\nYou can do the same for <span class="hljs-strong">**cameras**</span>. By default, only the <span class="hljs-strong">**teleoperation cameras**</span> are recorded (both <span class="hljs-code">`left_teleop_camera`</span> and <span class="hljs-code">`right_teleop_camera`</span>). Enable or disable each camera with:\n',wrap:!1}}),ue=new T({props:{code:"JTBBJTBBJTIzJTIzJTIwU3RlcCUyMDIlM0ElMjBSZXBsYXklMEElMEFNYWtlJTIwc3VyZSUyMHRoZSUyMHJvYm90JTIwaXMlMjBjb25maWd1cmVkJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBwYXJ0cyUyMGFzJTIwdGhlJTIwZGF0YXNldCUzQSUwQSUwQSU2MCU2MCU2MGJhc2glMEFweXRob24lMjAtbSUyMGxlcm9ib3QucmVwbGF5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yb2JvdC50eXBlJTNEcmVhY2h5MiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9ib3QuaXBfYWRkcmVzcyUzRDE5Mi4xNjguMC4yMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJvYm90LnVzZV9leHRlcm5hbF9jb21tYW5kcyUzRGZhbHNlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yb2JvdC53aXRoX21vYmlsZV9iYXNlJTNEZmFsc2UlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXQucmVwb19pZCUzRHBvbGxlbl9yb2JvdGljcyUyRnJlY29yZF90ZXN0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0LmVwaXNvZGUlM0QwJTBBJTIwJTIwJTIwJTIwLS1kaXNwbGF5X2RhdGElM0R0cnVl",highlighted:`

<span class="hljs-comment">## Step 2: Replay</span>

Make sure the robot is configured with the same parts as the dataset:

\`\`\`bash
python -m lerobot.replay \\
    --robot.<span class="hljs-attribute">type</span>=reachy2 \\
    --robot.<span class="hljs-attribute">ip_address</span>=192.168.0.200 \\
    --robot.<span class="hljs-attribute">use_external_commands</span>=<span class="hljs-literal">false</span> \\
    --robot.<span class="hljs-attribute">with_mobile_base</span>=<span class="hljs-literal">false</span> \\
    --dataset.<span class="hljs-attribute">repo_id</span>=pollen_robotics/record_test \\
    --dataset.<span class="hljs-attribute">episode</span>=0
    <span class="hljs-attribute">--display_data</span>=<span class="hljs-literal">true</span>`,wrap:!1}}),je=new h({props:{title:"Step 3: Train",local:"step-3-train",headingTag:"h2"}}),be=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMudHJhaW4lMjAlNUMlMEElMjAlMjAtLWRhdGFzZXQucmVwb19pZCUzRHBvbGxlbl9yb2JvdGljcyUyRnJlY29yZF90ZXN0JTIwJTVDJTBBJTIwJTIwLS1wb2xpY3kudHlwZSUzRGFjdCUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRG91dHB1dHMlMkZ0cmFpbiUyRnJlYWNoeTJfdGVzdCUyMCU1QyUwQSUyMCUyMC0tam9iX25hbWUlM0RyZWFjaHkyJTIwJTVDJTBBJTIwJTIwLS1wb2xpY3kuZGV2aWNlJTNEbXBzJTIwJTVDJTBBJTIwJTIwLS13YW5kYi5lbmFibGUlM0R0cnVlJTIwJTVDJTBBJTIwJTIwLS1wb2xpY3kucmVwb19pZCUzRHBvbGxlbl9yb2JvdGljcyUyRnJlY29yZF90ZXN0X3BvbGljeQ==",highlighted:`python -m lerobot.scripts.train \\
  --dataset.repo_id=pollen_robotics/record_test \\
  --policy.type=act \\
  --output_dir=outputs/train/reachy2_test \\
  --job_name=reachy2 \\
  --policy.device=mps \\
  --wandb.enable=<span class="hljs-literal">true</span> \\
  --policy.repo_id=pollen_robotics/record_test_policy`,wrap:!1}}),fe=new h({props:{title:"Step 4: Evaluate",local:"step-4-evaluate",headingTag:"h2"}}),Ce=new T({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJlY29yZCUyMCU1QyUwQSUyMCUyMC0tcm9ib3QudHlwZSUzRHJlYWNoeTIlMjAlNUMlMEElMjAlMjAtLXJvYm90LmlwX2FkZHJlc3MlM0QxOTIuMTY4LjAuMjAwJTIwJTVDJTBBJTIwJTIwLS1kaXNwbGF5X2RhdGElM0RmYWxzZSUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldC5yZXBvX2lkJTNEcG9sbGVuX3JvYm90aWNzJTJGZXZhbF9yZWNvcmRfdGVzdCUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldC5zaW5nbGVfdGFzayUzRCUyMkV2YWx1YXRlJTIwcmVhY2h5MiUyMHBvbGljeSUyMiUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldC5udW1fZXBpc29kZXMlM0QxMCUyMCU1QyUwQSUyMCUyMC0tcG9saWN5LnBhdGglM0RvdXRwdXRzJTJGdHJhaW4lMkZyZWFjaHkyX3Rlc3QlMkZjaGVja3BvaW50cyUyRmxhc3QlMkZwcmV0cmFpbmVkX21vZGVs",highlighted:`python -m lerobot.record \\
  --robot.type=reachy2 \\
  --robot.ip_address=192.168.0.200 \\
  --display_data=<span class="hljs-literal">false</span> \\
  --dataset.repo_id=pollen_robotics/eval_record_test \\
  --dataset.single_task=<span class="hljs-string">&quot;Evaluate reachy2 policy&quot;</span> \\
  --dataset.num_episodes=10 \\
  --policy.path=outputs/train/reachy2_test/checkpoints/last/pretrained_model`,wrap:!1}}),Ie=new Zl({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/reachy2.mdx"}}),{c(){m=i("meta"),$e=a(),ge=i("p"),_e=a(),p(d.$$.fragment),ve=a(),u=i("p"),u.innerHTML=kt,Ve=a(),p(j.$$.fragment),Be=a(),b=i("p"),b.textContent=xt,Se=a(),f=i("ul"),f.innerHTML=Ht,Ge=a(),p(C.$$.fragment),Xe=a(),I=i("p"),I.innerHTML=Ft,Le=a(),R=i("ol"),R.innerHTML=zt,Ye=a(),p(g.$$.fragment),Ne=a(),w=i("blockquote"),Re=i("p"),Re.innerHTML=qt,Et=a(),p(Z.$$.fragment),Ee=a(),p($.$$.fragment),Ae=a(),p(_.$$.fragment),Qe=a(),v=i("ul"),v.innerHTML=Dt,We=a(),V=i("p"),V.textContent=Pt,ke=a(),B=i("ul"),B.innerHTML=Ot,xe=a(),S=i("p"),S.textContent=Kt,He=a(),p(G.$$.fragment),Fe=a(),X=i("p"),X.innerHTML=el,ze=a(),L=i("p"),L.textContent=tl,qe=a(),p(Y.$$.fragment),De=a(),p(N.$$.fragment),Pe=a(),E=i("p"),E.innerHTML=ll,Oe=a(),A=i("blockquote"),A.innerHTML=sl,Ke=a(),Q=i("p"),Q.textContent=al,et=a(),p(W.$$.fragment),tt=a(),k=i("p"),k.innerHTML=nl,lt=a(),p(x.$$.fragment),st=a(),p(H.$$.fragment),at=a(),F=i("p"),F.innerHTML=il,nt=a(),p(z.$$.fragment),it=a(),q=i("p"),q.textContent=ol,ot=a(),D=i("ul"),D.innerHTML=pl,pt=a(),p(P.$$.fragment),rt=a(),O=i("p"),O.textContent=rl,Mt=a(),K=i("p"),K.textContent=Ml,ct=a(),p(ee.$$.fragment),yt=a(),te=i("p"),te.textContent=cl,Jt=a(),le=i("blockquote"),le.innerHTML=yl,Ut=a(),p(se.$$.fragment),ht=a(),ae=i("p"),ae.textContent=Jl,Tt=a(),ne=i("p"),ne.innerHTML=Ul,mt=a(),p(ie.$$.fragment),wt=a(),p(oe.$$.fragment),dt=a(),pe=i("p"),pe.innerHTML=hl,ut=a(),p(re.$$.fragment),jt=a(),p(Me.$$.fragment),bt=a(),ce=i("p"),ce.innerHTML=Tl,ft=a(),p(ye.$$.fragment),Ct=a(),Je=i("p"),Je.textContent=ml,It=a(),p(Ue.$$.fragment),Rt=a(),he=i("p"),he.innerHTML=wl,gt=a(),p(Te.$$.fragment),Zt=a(),me=i("p"),me.textContent=dl,$t=a(),p(we.$$.fragment),_t=a(),de=i("p"),de.textContent=ul,vt=a(),p(ue.$$.fragment),Vt=a(),p(je.$$.fragment),Bt=a(),p(be.$$.fragment),St=a(),p(fe.$$.fragment),Gt=a(),p(Ce.$$.fragment),Xt=a(),p(Ie.$$.fragment),Lt=a(),Ze=i("p"),this.h()},l(e){const t=gl("svelte-u9bgzb",document.head);m=o(t,"META",{name:!0,content:!0}),t.forEach(l),$e=n(e),ge=o(e,"P",{}),At(ge).forEach(l),_e=n(e),r(d.$$.fragment,e),ve=n(e),u=o(e,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1xdnuz6"&&(u.innerHTML=kt),Ve=n(e),r(j.$$.fragment,e),Be=n(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1ojqvg1"&&(b.textContent=xt),Se=n(e),f=o(e,"UL",{"data-svelte-h":!0}),M(f)!=="svelte-1ggvo7o"&&(f.innerHTML=Ht),Ge=n(e),r(C.$$.fragment,e),Xe=n(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1dog53k"&&(I.innerHTML=Ft),Le=n(e),R=o(e,"OL",{"data-svelte-h":!0}),M(R)!=="svelte-156hqyr"&&(R.innerHTML=zt),Ye=n(e),r(g.$$.fragment,e),Ne=n(e),w=o(e,"BLOCKQUOTE",{});var Nt=At(w);Re=o(Nt,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-kr41dh"&&(Re.innerHTML=qt),Et=n(Nt),r(Z.$$.fragment,Nt),Nt.forEach(l),Ee=n(e),r($.$$.fragment,e),Ae=n(e),r(_.$$.fragment,e),Qe=n(e),v=o(e,"UL",{"data-svelte-h":!0}),M(v)!=="svelte-1lqfzb6"&&(v.innerHTML=Dt),We=n(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-w8lpge"&&(V.textContent=Pt),ke=n(e),B=o(e,"UL",{"data-svelte-h":!0}),M(B)!=="svelte-vlq1xy"&&(B.innerHTML=Ot),xe=n(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-bssrcw"&&(S.textContent=Kt),He=n(e),r(G.$$.fragment,e),Fe=n(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1smiryk"&&(X.innerHTML=el),ze=n(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-pzjrtr"&&(L.textContent=tl),qe=n(e),r(Y.$$.fragment,e),De=n(e),r(N.$$.fragment,e),Pe=n(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1a4w6qg"&&(E.innerHTML=ll),Oe=n(e),A=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(A)!=="svelte-qn2ame"&&(A.innerHTML=sl),Ke=n(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1d48kde"&&(Q.textContent=al),et=n(e),r(W.$$.fragment,e),tt=n(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-8g2vrm"&&(k.innerHTML=nl),lt=n(e),r(x.$$.fragment,e),st=n(e),r(H.$$.fragment,e),at=n(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1qas93h"&&(F.innerHTML=il),nt=n(e),r(z.$$.fragment,e),it=n(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-182f064"&&(q.textContent=ol),ot=n(e),D=o(e,"UL",{"data-svelte-h":!0}),M(D)!=="svelte-v2es0o"&&(D.innerHTML=pl),pt=n(e),r(P.$$.fragment,e),rt=n(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-dkxq35"&&(O.textContent=rl),Mt=n(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-n8f1lt"&&(K.textContent=Ml),ct=n(e),r(ee.$$.fragment,e),yt=n(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-14vis0y"&&(te.textContent=cl),Jt=n(e),le=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(le)!=="svelte-12ihg6i"&&(le.innerHTML=yl),Ut=n(e),r(se.$$.fragment,e),ht=n(e),ae=o(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1q05r0g"&&(ae.textContent=Jl),Tt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-13igkbi"&&(ne.innerHTML=Ul),mt=n(e),r(ie.$$.fragment,e),wt=n(e),r(oe.$$.fragment,e),dt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-cf4c7q"&&(pe.innerHTML=hl),ut=n(e),r(re.$$.fragment,e),jt=n(e),r(Me.$$.fragment,e),bt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-18zqixh"&&(ce.innerHTML=Tl),ft=n(e),r(ye.$$.fragment,e),Ct=n(e),Je=o(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-cyhye1"&&(Je.textContent=ml),It=n(e),r(Ue.$$.fragment,e),Rt=n(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-wfg4kf"&&(he.innerHTML=wl),gt=n(e),r(Te.$$.fragment,e),Zt=n(e),me=o(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1skg537"&&(me.textContent=dl),$t=n(e),r(we.$$.fragment,e),_t=n(e),de=o(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-4owi8b"&&(de.textContent=ul),vt=n(e),r(ue.$$.fragment,e),Vt=n(e),r(je.$$.fragment,e),Bt=n(e),r(be.$$.fragment,e),St=n(e),r(fe.$$.fragment,e),Gt=n(e),r(Ce.$$.fragment,e),Xt=n(e),r(Ie.$$.fragment,e),Lt=n(e),Ze=o(e,"P",{}),At(Ze).forEach(l),this.h()},h(){jl(m,"name","hf:doc:metadata"),jl(m,"content",_l)},m(e,t){Qt(document.head,m),s(e,$e,t),s(e,ge,t),s(e,_e,t),c(d,e,t),s(e,ve,t),s(e,u,t),s(e,Ve,t),c(j,e,t),s(e,Be,t),s(e,b,t),s(e,Se,t),s(e,f,t),s(e,Ge,t),c(C,e,t),s(e,Xe,t),s(e,I,t),s(e,Le,t),s(e,R,t),s(e,Ye,t),c(g,e,t),s(e,Ne,t),s(e,w,t),Qt(w,Re),Qt(w,Et),c(Z,w,null),s(e,Ee,t),c($,e,t),s(e,Ae,t),c(_,e,t),s(e,Qe,t),s(e,v,t),s(e,We,t),s(e,V,t),s(e,ke,t),s(e,B,t),s(e,xe,t),s(e,S,t),s(e,He,t),c(G,e,t),s(e,Fe,t),s(e,X,t),s(e,ze,t),s(e,L,t),s(e,qe,t),c(Y,e,t),s(e,De,t),c(N,e,t),s(e,Pe,t),s(e,E,t),s(e,Oe,t),s(e,A,t),s(e,Ke,t),s(e,Q,t),s(e,et,t),c(W,e,t),s(e,tt,t),s(e,k,t),s(e,lt,t),c(x,e,t),s(e,st,t),c(H,e,t),s(e,at,t),s(e,F,t),s(e,nt,t),c(z,e,t),s(e,it,t),s(e,q,t),s(e,ot,t),s(e,D,t),s(e,pt,t),c(P,e,t),s(e,rt,t),s(e,O,t),s(e,Mt,t),s(e,K,t),s(e,ct,t),c(ee,e,t),s(e,yt,t),s(e,te,t),s(e,Jt,t),s(e,le,t),s(e,Ut,t),c(se,e,t),s(e,ht,t),s(e,ae,t),s(e,Tt,t),s(e,ne,t),s(e,mt,t),c(ie,e,t),s(e,wt,t),c(oe,e,t),s(e,dt,t),s(e,pe,t),s(e,ut,t),c(re,e,t),s(e,jt,t),c(Me,e,t),s(e,bt,t),s(e,ce,t),s(e,ft,t),c(ye,e,t),s(e,Ct,t),s(e,Je,t),s(e,It,t),c(Ue,e,t),s(e,Rt,t),s(e,he,t),s(e,gt,t),c(Te,e,t),s(e,Zt,t),s(e,me,t),s(e,$t,t),c(we,e,t),s(e,_t,t),s(e,de,t),s(e,vt,t),c(ue,e,t),s(e,Vt,t),c(je,e,t),s(e,Bt,t),c(be,e,t),s(e,St,t),c(fe,e,t),s(e,Gt,t),c(Ce,e,t),s(e,Xt,t),c(Ie,e,t),s(e,Lt,t),s(e,Ze,t),Yt=!0},p:fl,i(e){Yt||(y(d.$$.fragment,e),y(j.$$.fragment,e),y(C.$$.fragment,e),y(g.$$.fragment,e),y(Z.$$.fragment,e),y($.$$.fragment,e),y(_.$$.fragment,e),y(G.$$.fragment,e),y(Y.$$.fragment,e),y(N.$$.fragment,e),y(W.$$.fragment,e),y(x.$$.fragment,e),y(H.$$.fragment,e),y(z.$$.fragment,e),y(P.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(Me.$$.fragment,e),y(ye.$$.fragment,e),y(Ue.$$.fragment,e),y(Te.$$.fragment,e),y(we.$$.fragment,e),y(ue.$$.fragment,e),y(je.$$.fragment,e),y(be.$$.fragment,e),y(fe.$$.fragment,e),y(Ce.$$.fragment,e),y(Ie.$$.fragment,e),Yt=!0)},o(e){J(d.$$.fragment,e),J(j.$$.fragment,e),J(C.$$.fragment,e),J(g.$$.fragment,e),J(Z.$$.fragment,e),J($.$$.fragment,e),J(_.$$.fragment,e),J(G.$$.fragment,e),J(Y.$$.fragment,e),J(N.$$.fragment,e),J(W.$$.fragment,e),J(x.$$.fragment,e),J(H.$$.fragment,e),J(z.$$.fragment,e),J(P.$$.fragment,e),J(ee.$$.fragment,e),J(se.$$.fragment,e),J(ie.$$.fragment,e),J(oe.$$.fragment,e),J(re.$$.fragment,e),J(Me.$$.fragment,e),J(ye.$$.fragment,e),J(Ue.$$.fragment,e),J(Te.$$.fragment,e),J(we.$$.fragment,e),J(ue.$$.fragment,e),J(je.$$.fragment,e),J(be.$$.fragment,e),J(fe.$$.fragment,e),J(Ce.$$.fragment,e),J(Ie.$$.fragment,e),Yt=!1},d(e){e&&(l($e),l(ge),l(_e),l(ve),l(u),l(Ve),l(Be),l(b),l(Se),l(f),l(Ge),l(Xe),l(I),l(Le),l(R),l(Ye),l(Ne),l(w),l(Ee),l(Ae),l(Qe),l(v),l(We),l(V),l(ke),l(B),l(xe),l(S),l(He),l(Fe),l(X),l(ze),l(L),l(qe),l(De),l(Pe),l(E),l(Oe),l(A),l(Ke),l(Q),l(et),l(tt),l(k),l(lt),l(st),l(at),l(F),l(nt),l(it),l(q),l(ot),l(D),l(pt),l(rt),l(O),l(Mt),l(K),l(ct),l(yt),l(te),l(Jt),l(le),l(Ut),l(ht),l(ae),l(Tt),l(ne),l(mt),l(wt),l(dt),l(pe),l(ut),l(jt),l(bt),l(ce),l(ft),l(Ct),l(Je),l(It),l(Rt),l(he),l(gt),l(Zt),l(me),l($t),l(_t),l(de),l(vt),l(Vt),l(Bt),l(St),l(Gt),l(Xt),l(Lt),l(Ze)),l(m),U(d,e),U(j,e),U(C,e),U(g,e),U(Z),U($,e),U(_,e),U(G,e),U(Y,e),U(N,e),U(W,e),U(x,e),U(H,e),U(z,e),U(P,e),U(ee,e),U(se,e),U(ie,e),U(oe,e),U(re,e),U(Me,e),U(ye,e),U(Ue,e),U(Te,e),U(we,e),U(ue,e),U(je,e),U(be,e),U(fe,e),U(Ce,e),U(Ie,e)}}}const _l='{"title":"Reachy 2","local":"reachy-2","sections":[{"title":"Teleoperate Reachy 2","local":"teleoperate-reachy-2","sections":[],"depth":2},{"title":"Reachy 2 Simulation","local":"reachy-2-simulation","sections":[],"depth":2},{"title":"Setup","local":"setup","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":3},{"title":"Install LeRobot","local":"install-lerobot","sections":[],"depth":3},{"title":"(Optional but recommended) Install pollen_data_acquisition_server","local":"optional-but-recommended-install-pollendataacquisitionserver","sections":[],"depth":3}],"depth":2},{"title":"Step 1: Recording","local":"step-1-recording","sections":[{"title":"Get Reachy 2 IP address","local":"get-reachy-2-ip-address","sections":[],"depth":3},{"title":"Launch recording","local":"launch-recording","sections":[],"depth":3},{"title":"Option 1: Using Pollen data acquisition server (recommended for VR teleop)","local":"option-1-using-pollen-data-acquisition-server-recommended-for-vr-teleop","sections":[],"depth":3},{"title":"Option 2: Using lerobot.record","local":"option-2-using-lerobotrecord","sections":[{"title":"Specific Options","local":"specific-options","sections":[{"title":"--robot.use_external_commands","local":"--robotuseexternalcommands","sections":[],"depth":5},{"title":"--teleop.use_present_position","local":"--teleopusepresentposition","sections":[],"depth":5},{"title":"Use the relevant parts","local":"use-the-relevant-parts","sections":[],"depth":5}],"depth":4}],"depth":3}],"depth":2},{"title":"Step 3: Train","local":"step-3-train","sections":[],"depth":2},{"title":"Step 4: Evaluate","local":"step-4-evaluate","sections":[],"depth":2}],"depth":1}';function vl(Wt){return Cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xl extends Il{constructor(m){super(),Rl(this,m,vl,$l,bl,{})}}export{Xl as component};
