import{s as ot,n as rt,o as dt}from"../chunks/scheduler.3e37077e.js";import{S as pt,i as mt,g as i,s as l,r as d,A as ct,h as o,f as s,c as n,j as nt,u as p,x as r,k as it,l as T,y as Mt,a,v as m,d as c,t as M,w as y}from"../chunks/index.263272b0.js";import{C as We}from"../chunks/CodeBlock.76c31e3c.js";import{H as J,E as yt}from"../chunks/getInferenceSnippets.932de0ac.js";function ft(Ye){let u,ee,K,te,g,se,w,xe="<code>LeRobotDataset v3.0</code> is a standardized format for robot learning data. It provides unified access to multi-modal time-series data, sensorimotor signals and multi‑camera video, as well as rich metadata for indexing, search, and visualization on the Hugging Face Hub.",ae,b,_e="This docs will guide you to:",le,U,Ne="<li>Understand the v3.0 design and directory layout</li> <li>Record a dataset and push it to the Hub</li> <li>Load datasets for training with <code>LeRobotDataset</code></li> <li>Stream datasets without downloading using <code>StreamingLeRobotDataset</code></li> <li>Migrate existing <code>v2.1</code> datasets to <code>v3.0</code></li>",ne,v,ie,j,He="<li><strong>File-based storage</strong>: Many episodes per Parquet/MP4 file (v2 used one file per episode).</li> <li><strong>Relational metadata</strong>: Episode boundaries and lookups are resolved through metadata, not filenames.</li> <li><strong>Hub-native streaming</strong>: Consume datasets directly from the Hub with <code>StreamingLeRobotDataset</code>.</li> <li><strong>Lower file-system pressure</strong>: Fewer, larger files ⇒ faster initialization and fewer issues at scale.</li> <li><strong>Unified organization</strong>: Clean directory layout with consistent path templates across data and videos.</li>",oe,C,re,I,Ve="<code>LeRobotDataset v3.0</code> will be included in <code>lerobot &gt;= 0.4.0</code>.",de,R,Fe='Until that stable release, you can use the main branch by following the <a href="./installation#from-source">build from source instructions</a>.',pe,Z,me,$,Se="Run the command below to record a dataset with the SO-101 and push to the Hub:",ce,G,Me,X,ke='See the <a href="./il_robots#record-a-dataset">recording guide</a> for more details.',ye,L,fe,B,Ee="A core v3 principle is <strong>decoupling storage from the user API</strong>: data is stored efficiently (few large files), while the public API exposes intuitive episode-level access.",he,Q,Ae="<code>v3</code> has three pillars:",ue,z,De="<li><strong>Tabular data</strong>: Low‑dimensional, high‑frequency signals (states, actions, timestamps) stored in <strong>Apache Parquet</strong>. Access is memory‑mapped or streamed via the <code>datasets</code> stack.</li> <li><strong>Visual data</strong>: Camera frames concatenated and encoded into <strong>MP4</strong>. Frames from the same episode are grouped; videos are sharded per camera for practical sizes.</li> <li><strong>Metadata</strong>: JSON/Parquet records describing schema (feature names, dtypes, shapes), frame rates, normalization stats, and <strong>episode segmentation</strong> (start/end offsets into shared Parquet/MP4 files).</li>",Je,W,qe="<p>To scale to millions of episodes, tabular rows and video frames from multiple episodes are <strong>concatenated</strong> into larger files. Episode‑specific views are reconstructed <strong>via metadata</strong>, not file boundaries.</p>",Te,f,Pe='<figure style="margin:0; text-align:center;"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobotdataset-v3/asset1datasetv3.png" alt="LeRobotDataset v3 diagram" width="220"/> <figcaption style="font-size:0.9em; color:#666;">From episode‑based to file‑based datasets</figcaption></figure>',ge,Y,we,x,Ke="<li><strong><code>meta/info.json</code></strong>: canonical schema (features, shapes/dtypes), FPS, codebase version, and <strong>path templates</strong> to locate data/video shards.</li> <li><strong><code>meta/stats.json</code></strong>: global feature statistics (mean/std/min/max) used for normalization; exposed as <code>dataset.meta.stats</code>.</li> <li><strong><code>meta/tasks.jsonl</code></strong>: natural‑language task descriptions mapped to integer IDs for task‑conditioned policies.</li> <li><strong><code>meta/episodes/</code></strong>: per‑episode records (lengths, tasks, offsets) stored as <strong>chunked Parquet</strong> for scalability.</li> <li><strong><code>data/</code></strong>: frame‑by‑frame <strong>Parquet</strong> shards; each file typically contains <strong>many episodes</strong>.</li> <li><strong><code>videos/</code></strong>: <strong>MP4</strong> shards per camera; each file typically contains <strong>many episodes</strong>.</li>",be,_,Ue,N,Oe="<code>LeRobotDataset</code> returns Python dictionaries of PyTorch tensors and integrates with <code>torch.utils.data.DataLoader</code>. Here is a code example showing its use:",ve,H,je,V,Ce,F,et="Use <code>StreamingLeRobotDataset</code> to iterate directly from the Hub without local copies. This allows to stream large datasets without the need to downloading them onto disk or loading them onto memory, and is a key feature of the new dataset format.",Ie,S,Re,h,tt='<figure style="margin:0; text-align:center;"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobotdataset-v3/streaming-lerobot.png" alt="StreamingLeRobotDataset" width="520"/> <figcaption style="font-size:0.9em; color:#666;">Stream directly from the Hub for on‑the‑fly training.</figcaption></figure>',Ze,k,$e,E,st="A converter aggregates per‑episode files into larger shards and writes episode offsets/metadata. Convert your dataset using the instructions below.",Ge,A,Xe,D,at="<strong>What it does</strong>",Le,q,lt="<li>Aggregates parquet files: <code>episode-0000.parquet</code>, <code>episode-0001.parquet</code>, … → <strong><code>file-0000.parquet</code></strong>, …</li> <li>Aggregates mp4 files: <code>episode-0000.mp4</code>, <code>episode-0001.mp4</code>, … → <strong><code>file-0000.mp4</code></strong>, …</li> <li>Updates <code>meta/episodes/*</code> (chunked Parquet) with per‑episode lengths, tasks, and byte/frame offsets.</li>",Be,P,Qe,O,ze;return g=new J({props:{title:"LeRobotDataset v3.0",local:"lerobotdataset-v30",headingTag:"h1"}}),v=new J({props:{title:"What’s new in v3",local:"whats-new-in-v3",headingTag:"h2"}}),C=new J({props:{title:"Installation",local:"installation",headingTag:"h2"}}),Z=new J({props:{title:"Record a dataset",local:"record-a-dataset",headingTag:"h2"}}),G=new We({props:{code:"bGVyb2JvdC1yZWNvcmQlMjAlNUMlMEElMjAlMjAtLXJvYm90LnR5cGUlM0RzbzEwMV9mb2xsb3dlciUyMCU1QyUwQSUyMCUyMC0tcm9ib3QucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NUEwMDc2ODQxJTIwJTVDJTBBJTIwJTIwLS1yb2JvdC5pZCUzRG15X2F3ZXNvbWVfZm9sbG93ZXJfYXJtJTIwJTVDJTBBJTIwJTIwLS1yb2JvdC5jYW1lcmFzJTNEJTIyJTdCJTIwZnJvbnQlM0ElMjAlN0J0eXBlJTNBJTIwb3BlbmN2JTJDJTIwaW5kZXhfb3JfcGF0aCUzQSUyMDAlMkMlMjB3aWR0aCUzQSUyMDE5MjAlMkMlMjBoZWlnaHQlM0ElMjAxMDgwJTJDJTIwZnBzJTNBJTIwMzAlN0QlN0QlMjIlMjAlNUMlMEElMjAlMjAtLXRlbGVvcC50eXBlJTNEc28xMDFfbGVhZGVyJTIwJTVDJTBBJTIwJTIwLS10ZWxlb3AucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NzYwNDMxNTUxJTIwJTVDJTBBJTIwJTIwLS10ZWxlb3AuaWQlM0RteV9hd2Vzb21lX2xlYWRlcl9hcm0lMjAlNUMlMEElMjAlMjAtLWRpc3BsYXlfZGF0YSUzRHRydWUlMjAlNUMlMEElMjAlMjAtLWRhdGFzZXQucmVwb19pZCUzRCUyNCU3QkhGX1VTRVIlN0QlMkZyZWNvcmQtdGVzdCUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldC5udW1fZXBpc29kZXMlM0Q1JTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0LnNpbmdsZV90YXNrJTNEJTIyR3JhYiUyMHRoZSUyMGJsYWNrJTIwY3ViZSUyMg==",highlighted:`lerobot-record \\
  --robot.type=so101_follower \\
  --robot.port=/dev/tty.usbmodem585A0076841 \\
  --robot.id=my_awesome_follower_arm \\
  --robot.cameras=<span class="hljs-string">&quot;{ front: {type: opencv, index_or_path: 0, width: 1920, height: 1080, fps: 30}}&quot;</span> \\
  --teleop.type=so101_leader \\
  --teleop.port=/dev/tty.usbmodem58760431551 \\
  --teleop.id=my_awesome_leader_arm \\
  --display_data=<span class="hljs-literal">true</span> \\
  --dataset.repo_id=<span class="hljs-variable">\${HF_USER}</span>/record-test \\
  --dataset.num_episodes=5 \\
  --dataset.single_task=<span class="hljs-string">&quot;Grab the black cube&quot;</span>`,wrap:!1}}),L=new J({props:{title:"Format design",local:"format-design",headingTag:"h2"}}),Y=new J({props:{title:"Directory layout (simplified)",local:"directory-layout-simplified",headingTag:"h3"}}),_=new J({props:{title:"Load a dataset for training",local:"load-a-dataset-for-training",headingTag:"h2"}}),H=new We({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset

repo_id = <span class="hljs-string">&quot;yaak-ai/L2D-v3&quot;</span>

<span class="hljs-comment"># 1) Load from the Hub (cached locally)</span>
dataset = LeRobotDataset(repo_id)

<span class="hljs-comment"># 2) Random access by index</span>
sample = dataset[<span class="hljs-number">100</span>]
<span class="hljs-built_in">print</span>(sample)
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#   &#x27;observation.state&#x27;: tensor([...]),</span>
<span class="hljs-comment">#   &#x27;action&#x27;: tensor([...]),</span>
<span class="hljs-comment">#   &#x27;observation.images.front_left&#x27;: tensor([C, H, W]),</span>
<span class="hljs-comment">#   &#x27;timestamp&#x27;: tensor(1.234),</span>
<span class="hljs-comment">#   ...</span>
<span class="hljs-comment"># }</span>

<span class="hljs-comment"># 3) Temporal windows via delta_timestamps (seconds relative to t)</span>
delta_timestamps = {
    <span class="hljs-string">&quot;observation.images.front_left&quot;</span>: [-<span class="hljs-number">0.2</span>, -<span class="hljs-number">0.1</span>, <span class="hljs-number">0.0</span>]  <span class="hljs-comment"># 0.2s and 0.1s before current frame</span>
}

dataset = LeRobotDataset(repo_id, delta_timestamps=delta_timestamps)

<span class="hljs-comment"># Accessing an index now returns a stack for the specified key(s)</span>
sample = dataset[<span class="hljs-number">100</span>]
<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;observation.images.front_left&quot;</span>].shape)  <span class="hljs-comment"># [T, C, H, W], where T=3</span>

<span class="hljs-comment"># 4) Wrap with a DataLoader for training</span>
batch_size = <span class="hljs-number">16</span>
data_loader = torch.utils.data.DataLoader(dataset, batch_size=batch_size)

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> data_loader:
    observations = batch[<span class="hljs-string">&quot;observation.state&quot;</span>].to(device)
    actions = batch[<span class="hljs-string">&quot;action&quot;</span>].to(device)
    images = batch[<span class="hljs-string">&quot;observation.images.front_left&quot;</span>].to(device)
    <span class="hljs-comment"># model.forward(batch)</span>`,wrap:!1}}),V=new J({props:{title:"Stream a dataset (no downloads)",local:"stream-a-dataset-no-downloads",headingTag:"h2"}}),S=new We({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMuc3RyZWFtaW5nX2RhdGFzZXQlMjBpbXBvcnQlMjBTdHJlYW1pbmdMZVJvYm90RGF0YXNldCUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJ5YWFrLWFpJTJGTDJELXYzJTIyJTBBZGF0YXNldCUyMCUzRCUyMFN0cmVhbWluZ0xlUm9ib3REYXRhc2V0KHJlcG9faWQpJTIwJTIwJTIzJTIwc3RyZWFtcyUyMGRpcmVjdGx5JTIwZnJvbSUyMHRoZSUyMEh1Yg==",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.streaming_dataset <span class="hljs-keyword">import</span> StreamingLeRobotDataset

repo_id = <span class="hljs-string">&quot;yaak-ai/L2D-v3&quot;</span>
dataset = StreamingLeRobotDataset(repo_id)  <span class="hljs-comment"># streams directly from the Hub</span>`,wrap:!1}}),k=new J({props:{title:"Migrate v2.1 → v3.0",local:"migrate-v21--v30",headingTag:"h2"}}),A=new We({props:{code:"JTIzJTIwUHJlLXJlbGVhc2UlMjBidWlsZCUyMHdpdGglMjB2MyUyMHN1cHBvcnQlM0ElMEFwaXAlMjBpbnN0YWxsJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZsZXJvYm90JTJGYXJjaGl2ZSUyRjMzY2FkMzcwNTRjMmI1OTRjZWJhNTc0NjNlOGYxMWVlMzc0ZmE5M2MuemlwJTIyJTBBJTBBJTIzJTIwQ29udmVydCUyMGFuJTIwZXhpc3RpbmclMjB2Mi4xJTIwZGF0YXNldCUyMGhvc3RlZCUyMG9uJTIwdGhlJTIwSHViJTNBJTBBcHl0aG9uJTIwLW0lMjBsZXJvYm90LmRhdGFzZXRzLnYzMC5jb252ZXJ0X2RhdGFzZXRfdjIxX3RvX3YzMCUyMC0tcmVwby1pZCUzRCUzQ0hGX1VTRVIlMkZEQVRBU0VUX0lEJTNF",highlighted:`<span class="hljs-comment"># Pre-release build with v3 support:</span>
pip install <span class="hljs-string">&quot;https://github.com/huggingface/lerobot/archive/33cad37054c2b594ceba57463e8f11ee374fa93c.zip&quot;</span>

<span class="hljs-comment"># Convert an existing v2.1 dataset hosted on the Hub:</span>
python -m lerobot.datasets.v30.convert_dataset_v21_to_v30 --repo-id=&lt;HF_USER/DATASET_ID&gt;`,wrap:!1}}),P=new yt({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/lerobot-dataset-v3.mdx"}}),{c(){u=i("meta"),ee=l(),K=i("p"),te=l(),d(g.$$.fragment),se=l(),w=i("p"),w.innerHTML=xe,ae=l(),b=i("p"),b.textContent=_e,le=l(),U=i("ul"),U.innerHTML=Ne,ne=l(),d(v.$$.fragment),ie=l(),j=i("ul"),j.innerHTML=He,oe=l(),d(C.$$.fragment),re=l(),I=i("p"),I.innerHTML=Ve,de=l(),R=i("p"),R.innerHTML=Fe,pe=l(),d(Z.$$.fragment),me=l(),$=i("p"),$.textContent=Se,ce=l(),d(G.$$.fragment),Me=l(),X=i("p"),X.innerHTML=ke,ye=l(),d(L.$$.fragment),fe=l(),B=i("p"),B.innerHTML=Ee,he=l(),Q=i("p"),Q.innerHTML=Ae,ue=l(),z=i("ol"),z.innerHTML=De,Je=l(),W=i("blockquote"),W.innerHTML=qe,Te=l(),f=i("div"),f.innerHTML=Pe,ge=l(),d(Y.$$.fragment),we=l(),x=i("ul"),x.innerHTML=Ke,be=l(),d(_.$$.fragment),Ue=l(),N=i("p"),N.innerHTML=Oe,ve=l(),d(H.$$.fragment),je=l(),d(V.$$.fragment),Ce=l(),F=i("p"),F.innerHTML=et,Ie=l(),d(S.$$.fragment),Re=l(),h=i("div"),h.innerHTML=tt,Ze=l(),d(k.$$.fragment),$e=l(),E=i("p"),E.textContent=st,Ge=l(),d(A.$$.fragment),Xe=l(),D=i("p"),D.innerHTML=at,Le=l(),q=i("ul"),q.innerHTML=lt,Be=l(),d(P.$$.fragment),Qe=l(),O=i("p"),this.h()},l(e){const t=ct("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(s),ee=n(e),K=o(e,"P",{}),nt(K).forEach(s),te=n(e),p(g.$$.fragment,e),se=n(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-3itfuv"&&(w.innerHTML=xe),ae=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1xhddzp"&&(b.textContent=_e),le=n(e),U=o(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1mng0hr"&&(U.innerHTML=Ne),ne=n(e),p(v.$$.fragment,e),ie=n(e),j=o(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-yef82f"&&(j.innerHTML=He),oe=n(e),p(C.$$.fragment,e),re=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-eavsve"&&(I.innerHTML=Ve),de=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-r2q19"&&(R.innerHTML=Fe),pe=n(e),p(Z.$$.fragment,e),me=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1p8f7kn"&&($.textContent=Se),ce=n(e),p(G.$$.fragment,e),Me=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-3lpf0d"&&(X.innerHTML=ke),ye=n(e),p(L.$$.fragment,e),fe=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1n657sm"&&(B.innerHTML=Ee),he=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qbaryr"&&(Q.innerHTML=Ae),ue=n(e),z=o(e,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-1a0he5b"&&(z.innerHTML=De),Je=n(e),W=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(W)!=="svelte-krhs8x"&&(W.innerHTML=qe),Te=n(e),f=o(e,"DIV",{style:!0,"data-svelte-h":!0}),r(f)!=="svelte-y0whhl"&&(f.innerHTML=Pe),ge=n(e),p(Y.$$.fragment,e),we=n(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1j4kpyj"&&(x.innerHTML=Ke),be=n(e),p(_.$$.fragment,e),Ue=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-z0zvcd"&&(N.innerHTML=Oe),ve=n(e),p(H.$$.fragment,e),je=n(e),p(V.$$.fragment,e),Ce=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-gwwmls"&&(F.innerHTML=et),Ie=n(e),p(S.$$.fragment,e),Re=n(e),h=o(e,"DIV",{style:!0,"data-svelte-h":!0}),r(h)!=="svelte-1vmyhrf"&&(h.innerHTML=tt),Ze=n(e),p(k.$$.fragment,e),$e=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-15s3b8u"&&(E.textContent=st),Ge=n(e),p(A.$$.fragment,e),Xe=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1z0frgp"&&(D.innerHTML=at),Le=n(e),q=o(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1dwwoyp"&&(q.innerHTML=lt),Be=n(e),p(P.$$.fragment,e),Qe=n(e),O=o(e,"P",{}),nt(O).forEach(s),this.h()},h(){it(u,"name","hf:doc:metadata"),it(u,"content",ht),T(f,"display","flex"),T(f,"justify-content","center"),T(f,"gap","12px"),T(f,"flex-wrap","wrap"),T(h,"display","flex"),T(h,"justify-content","center"),T(h,"gap","12px"),T(h,"flex-wrap","wrap")},m(e,t){Mt(document.head,u),a(e,ee,t),a(e,K,t),a(e,te,t),m(g,e,t),a(e,se,t),a(e,w,t),a(e,ae,t),a(e,b,t),a(e,le,t),a(e,U,t),a(e,ne,t),m(v,e,t),a(e,ie,t),a(e,j,t),a(e,oe,t),m(C,e,t),a(e,re,t),a(e,I,t),a(e,de,t),a(e,R,t),a(e,pe,t),m(Z,e,t),a(e,me,t),a(e,$,t),a(e,ce,t),m(G,e,t),a(e,Me,t),a(e,X,t),a(e,ye,t),m(L,e,t),a(e,fe,t),a(e,B,t),a(e,he,t),a(e,Q,t),a(e,ue,t),a(e,z,t),a(e,Je,t),a(e,W,t),a(e,Te,t),a(e,f,t),a(e,ge,t),m(Y,e,t),a(e,we,t),a(e,x,t),a(e,be,t),m(_,e,t),a(e,Ue,t),a(e,N,t),a(e,ve,t),m(H,e,t),a(e,je,t),m(V,e,t),a(e,Ce,t),a(e,F,t),a(e,Ie,t),m(S,e,t),a(e,Re,t),a(e,h,t),a(e,Ze,t),m(k,e,t),a(e,$e,t),a(e,E,t),a(e,Ge,t),m(A,e,t),a(e,Xe,t),a(e,D,t),a(e,Le,t),a(e,q,t),a(e,Be,t),m(P,e,t),a(e,Qe,t),a(e,O,t),ze=!0},p:rt,i(e){ze||(c(g.$$.fragment,e),c(v.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(L.$$.fragment,e),c(Y.$$.fragment,e),c(_.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(S.$$.fragment,e),c(k.$$.fragment,e),c(A.$$.fragment,e),c(P.$$.fragment,e),ze=!0)},o(e){M(g.$$.fragment,e),M(v.$$.fragment,e),M(C.$$.fragment,e),M(Z.$$.fragment,e),M(G.$$.fragment,e),M(L.$$.fragment,e),M(Y.$$.fragment,e),M(_.$$.fragment,e),M(H.$$.fragment,e),M(V.$$.fragment,e),M(S.$$.fragment,e),M(k.$$.fragment,e),M(A.$$.fragment,e),M(P.$$.fragment,e),ze=!1},d(e){e&&(s(ee),s(K),s(te),s(se),s(w),s(ae),s(b),s(le),s(U),s(ne),s(ie),s(j),s(oe),s(re),s(I),s(de),s(R),s(pe),s(me),s($),s(ce),s(Me),s(X),s(ye),s(fe),s(B),s(he),s(Q),s(ue),s(z),s(Je),s(W),s(Te),s(f),s(ge),s(we),s(x),s(be),s(Ue),s(N),s(ve),s(je),s(Ce),s(F),s(Ie),s(Re),s(h),s(Ze),s($e),s(E),s(Ge),s(Xe),s(D),s(Le),s(q),s(Be),s(Qe),s(O)),s(u),y(g,e),y(v,e),y(C,e),y(Z,e),y(G,e),y(L,e),y(Y,e),y(_,e),y(H,e),y(V,e),y(S,e),y(k,e),y(A,e),y(P,e)}}}const ht='{"title":"LeRobotDataset v3.0","local":"lerobotdataset-v30","sections":[{"title":"What’s new in v3","local":"whats-new-in-v3","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Record a dataset","local":"record-a-dataset","sections":[],"depth":2},{"title":"Format design","local":"format-design","sections":[{"title":"Directory layout (simplified)","local":"directory-layout-simplified","sections":[],"depth":3}],"depth":2},{"title":"Load a dataset for training","local":"load-a-dataset-for-training","sections":[],"depth":2},{"title":"Stream a dataset (no downloads)","local":"stream-a-dataset-no-downloads","sections":[],"depth":2},{"title":"Migrate v2.1 → v3.0","local":"migrate-v21--v30","sections":[],"depth":2}],"depth":1}';function ut(Ye){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bt extends pt{constructor(u){super(),mt(this,u,ut,ft,ot,{})}}export{bt as component};
