import{s as _t,o as Vt,n as vt}from"../chunks/scheduler.37c15a92.js";import{S as At,i as Bt,g as i,s as l,r,A as Zt,h as o,f as t,c as a,j as It,u as p,x as J,k as zt,y as Xt,a as n,v as c,d as h,t as y,w as M}from"../chunks/index.7cb9c9b8.js";import{T as Wt}from"../chunks/Tip.d10b3fc9.js";import{Y as Nt}from"../chunks/Youtube.8666c400.js";import{C as u}from"../chunks/CodeBlock.abae2786.js";import{C as Gt}from"../chunks/CourseFloatingBanner.df82c153.js";import{H as Fe,E as Et}from"../chunks/index.71125d44.js";function Dt(vs){let w,f="⚠️ Training a tokenizer is not the same as training a model! Model training uses stochastic gradient descent to make the loss a little bit smaller for each batch. It’s randomized by nature (meaning you have to set some seeds to get the same results when doing the same training twice). Training a tokenizer is a statistical process that tries to identify which subwords are the best to pick for a given corpus, and the exact rules used to pick them depend on the tokenization algorithm. It’s deterministic, meaning you always get the same results when training with the same algorithm on the same corpus.";return{c(){w=i("p"),w.textContent=f},l(m){w=o(m,"P",{"data-svelte-h":!0}),J(w)!=="svelte-1w10tsl"&&(w.textContent=f)},m(m,_s){n(m,w,_s)},p:vt,d(m){m&&t(w)}}}function Ht(vs){let w,f,m,_s,T,As,g,Bs,j,Le='If a language model is not available in the language you are interested in, or if your corpus is very different from the one your language model was trained on, you will most likely want to retrain the model from scratch using a tokenizer adapted to your data. That will require training a new tokenizer on your dataset. But what exactly does that mean? When we first looked at tokenizers in <a href="/course/chapter2">Chapter 2</a>, we saw that most Transformer models use a <em>subword tokenization algorithm</em>. To identify which subwords are of interest and occur most frequently in the corpus at hand, the tokenizer needs to take a hard look at all the texts in the corpus — a process we call <em>training</em>. The exact rules that govern this training depend on the type of tokenizer used, and we’ll go over the three main algorithms later in this chapter.',Zs,x,Xs,d,Ws,U,Ns,b,Pe="There’s a very simple API in 🤗 Transformers that you can use to train a new tokenizer with the same characteristics as an existing one: <code>AutoTokenizer.train_new_from_iterator()</code>. To see this in action, let’s say we want to train GPT-2 from scratch, but in a language other than English. Our first task will be to gather lots of data in that language in a training corpus. To provide examples everyone will be able to understand, we won’t use a language like Russian or Chinese here, but rather a specialized English language: Python code.",Gs,k,Ke='The <a href="https://github.com/huggingface/datasets" rel="nofollow">🤗 Datasets</a> library can help us assemble a corpus of Python source code. We’ll use the usual <code>load_dataset()</code> function to download and cache the <a href="https://huggingface.co/datasets/code_search_net" rel="nofollow">CodeSearchNet</a> dataset. This dataset was created for the <a href="https://wandb.ai/github/CodeSearchNet/benchmark" rel="nofollow">CodeSearchNet challenge</a> and contains millions of functions from open source libraries on GitHub in several programming languages. Here, we will load the Python part of this dataset:',Es,C,Ds,Q,Oe="We can have a look at the training split to see which columns we have access to:",Hs,$,Rs,I,Ys,z,st="We can see the dataset separates docstrings from code and suggests a tokenization of both. Here. we’ll just use the <code>whole_func_string</code> column to train our tokenizer. We can look at an example of one these functions by indexing into the <code>train</code> split:",Ss,_,qs,V,et="which should print the following:",Fs,v,Ls,A,tt="The first thing we need to do is transform the dataset into an <em>iterator</em> of lists of texts — for instance, a list of list of texts. Using lists of texts will enable our tokenizer to go faster (training on batches of texts instead of processing individual texts one by one), and it should be an iterator if we want to avoid having everything in memory at once. If your corpus is huge, you will want to take advantage of the fact that 🤗 Datasets does not load everything into RAM but stores the elements of the dataset on disk.",Ps,B,nt="Doing the following would create a list of lists of 1,000 texts each, but would load everything in memory:",Ks,Z,Os,X,lt="Using a Python generator, we can avoid Python loading anything into memory until it’s actually necessary. To create such a generator, you just to need to replace the brackets with parentheses:",se,W,ee,N,at="This line of code doesn’t fetch any elements of the dataset; it just creates an object you can use in a Python <code>for</code> loop. The texts will only be loaded when you need them (that is, when you’re at the step of the <code>for</code> loop that requires them), and only 1,000 texts at a time will be loaded. This way you won’t exhaust all your memory even if you are processing a huge dataset.",te,G,it="The problem with a generator object is that it can only be used once. So, instead of this giving us the list of the first 10 digits twice:",ne,E,le,D,ot="we get them once and then an empty list:",ae,H,ie,R,rt="That’s why we define a function that returns a generator instead:",oe,Y,re,S,pt="You can also define your generator inside a <code>for</code> loop by using the <code>yield</code> statement:",pe,q,ce,F,ct="which will produce the exact same generator as before, but allows you to use more complex logic than you can in a list comprehension.",he,L,ye,P,ht="Now that we have our corpus in the form of an iterator of batches of texts, we are ready to train a new tokenizer. To do this, we first need to load the tokenizer we want to pair with our model (here, GPT-2):",Me,K,Je,O,yt="Even though we are going to train a new tokenizer, it’s a good idea to do this to avoid starting entirely from scratch. This way, we won’t have to specify anything about the tokenization algorithm or the special tokens we want to use; our new tokenizer will be exactly the same as GPT-2, and the only thing that will change is the vocabulary, which will be determined by the training on our corpus.",ue,ss,Mt="First let’s have a look at how this tokenizer would treat an example function:",we,es,me,ts,de,ns,Jt="This tokenizer has a few special symbols, like <code>Ġ</code> and <code>Ċ</code>, which denote spaces and newlines, respectively. As we can see, this is not too efficient: the tokenizer returns individual tokens for each space, when it could group together indentation levels (since having sets of four or eight spaces is going to be very common in code). It also split the function name a bit weirdly, not being used to seeing words with the <code>_</code> character.",fe,ls,ut="Let’s train a new tokenizer and see if it solves those issues. For this, we’ll use the method <code>train_new_from_iterator()</code>:",Te,as,ge,is,wt="This command might take a bit of time if your corpus is very large, but for this dataset of 1.6 GB of texts it’s  blazing fast (1 minute 16 seconds on an AMD Ryzen 9 3900X CPU with 12 cores).",je,os,mt='Note that <code>AutoTokenizer.train_new_from_iterator()</code> only works if the tokenizer you are using is a “fast” tokenizer. As you’ll see in the next section, the 🤗 Transformers library contains two types of tokenizers: some are written purely in Python and others (the fast ones) are backed by the 🤗 Tokenizers library, which is written in the <a href="https://www.rust-lang.org" rel="nofollow">Rust</a> programming language. Python is the language most often used for data science and deep learning applications, but when anything needs to be parallelized to be fast, it has to be written in another language. For instance, the matrix multiplications that are at the core of the model computation are written in CUDA, an optimized C library for GPUs.',xe,rs,dt='Training a brand new tokenizer in pure Python would be excruciatingly slow, which is why we developed the 🤗 Tokenizers library. Note that just as you didn’t have to learn the CUDA language to be able to execute your model on a batch of inputs on a GPU, you won’t need to learn Rust to use a fast tokenizer. The 🤗 Tokenizers library provides Python bindings for many methods that internally call some piece of code in Rust; for example, to parallelize the training of your new tokenizer or, as we saw in <a href="/course/chapter3">Chapter 3</a>, the tokenization of a batch of inputs.',Ue,ps,ft='Most of the Transformer models have a fast tokenizer available (there are some exceptions that you can check <a href="https://huggingface.co/transformers/#supported-frameworks" rel="nofollow">here</a>), and the <code>AutoTokenizer</code> API always selects the fast tokenizer for you if it’s available. In the next section we’ll take a look at some of the other special features fast tokenizers have, which will be really useful for tasks like token classification and question answering. Before diving into that, however, let’s try our brand new tokenizer on the previous example:',be,cs,ke,hs,Ce,ys,Tt="Here we again see the special symbols <code>Ġ</code> and <code>Ċ</code> that denote spaces and newlines, but we can also see that our tokenizer learned some tokens that are highly specific to a corpus of Python functions: for example, there is a <code>ĊĠĠĠ</code> token that represents an indentation, and a <code>Ġ&quot;&quot;&quot;</code> token that represents the three quotes that start a docstring. The tokenizer also correctly split the function name on <code>_</code>. This is quite a compact representation; comparatively, using the plain English tokenizer on the same example will give us a longer sentence:",Qe,Ms,$e,Js,Ie,us,gt="Let’s look at another example:",ze,ws,_e,ms,Ve,ds,jt="In addition to the token corresponding to an indentation, here we can also see a token for a double indentation: <code>ĊĠĠĠĠĠĠĠ</code>. The special Python words like <code>class</code>, <code>init</code>, <code>call</code>, <code>self</code>, and <code>return</code> are each tokenized as one token, and we can see that as well as splitting on <code>_</code> and <code>.</code> the tokenizer correctly splits even camel-cased names: <code>LinearLayer</code> is tokenized as <code>[&quot;ĠLinear&quot;, &quot;Layer&quot;]</code>.",ve,fs,Ae,Ts,xt="To make sure we can use it later, we need to save our new tokenizer. Like for models, this is done with the <code>save_pretrained()</code> method:",Be,gs,Ze,js,Ut="This will create a new folder named <em>code-search-net-tokenizer</em>, which will contain all the files the tokenizer needs to be reloaded. If you want to share this tokenizer with your colleagues and friends, you can upload it to the Hub by logging into your account. If you’re working in a notebook, there’s a convenience function to help you with this:",Xe,xs,We,Us,bt="This will display a widget where you can enter your Hugging Face login credentials. If you aren’t working in a notebook, just type the following line in your terminal:",Ne,bs,Ge,ks,kt="Once you’ve logged in, you can push your tokenizer by executing the following command:",Ee,Cs,De,Qs,Ct="This will create a new repository in your namespace with the name <code>code-search-net-tokenizer</code>, containing the tokenizer file. You can then load the tokenizer from anywhere with the <code>from_pretrained()</code> method:",He,$s,Re,Is,Qt='You’re now all set for training a language model from scratch and fine-tuning it on your task at hand! We’ll get to that in <a href="/course/chapter7">Chapter 7</a>, but first, in the rest of this chapter we’ll take a closer look at fast tokenizers and explore in detail what actually happens when we call the method <code>train_new_from_iterator()</code>.',Ye,zs,Se,Vs,qe;return T=new Fe({props:{title:"Training a new tokenizer from an old one",local:"training-a-new-tokenizer-from-an-old-one",headingTag:"h1"}}),g=new Gt({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"}]}}),x=new Nt({props:{id:"DJimQynXZsQ"}}),d=new Wt({props:{warning:!0,$$slots:{default:[Dt]},$$scope:{ctx:vs}}}),U=new Fe({props:{title:"Assembling a corpus",local:"assembling-a-corpus",headingTag:"h2"}}),C=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwVGhpcyUyMGNhbiUyMHRha2UlMjBhJTIwZmV3JTIwbWludXRlcyUyMHRvJTIwbG9hZCUyQyUyMHNvJTIwZ3JhYiUyMGElMjBjb2ZmZWUlMjBvciUyMHRlYSUyMHdoaWxlJTIweW91JTIwd2FpdCElMEFyYXdfZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY29kZV9zZWFyY2hfbmV0JTIyJTJDJTIwJTIycHl0aG9uJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># This can take a few minutes to load, so grab a coffee or tea while you wait!</span>
raw_datasets = load_dataset(<span class="hljs-string">&quot;code_search_net&quot;</span>, <span class="hljs-string">&quot;python&quot;</span>)`,wrap:!1}}),$=new u({props:{code:"cmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),I=new u({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidyZXBvc2l0b3J5X25hbWUnJTJDJTIwJ2Z1bmNfcGF0aF9pbl9yZXBvc2l0b3J5JyUyQyUyMCdmdW5jX25hbWUnJTJDJTIwJ3dob2xlX2Z1bmNfc3RyaW5nJyUyQyUyMCdsYW5ndWFnZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3N0cmluZyclMkMlMjAnZnVuY19jb2RlX3Rva2VucyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3N0cmluZyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3Rva2VucyclMkMlMjAnc3BsaXRfbmFtZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3VybCclMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQxMjE3OCUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;repository_name&#x27;</span>, <span class="hljs-string">&#x27;func_path_in_repository&#x27;</span>, <span class="hljs-string">&#x27;func_name&#x27;</span>, <span class="hljs-string">&#x27;whole_func_string&#x27;</span>, <span class="hljs-string">&#x27;language&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_string&#x27;</span>, <span class="hljs-string">&#x27;func_code_tokens&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_string&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_tokens&#x27;</span>, <span class="hljs-string">&#x27;split_name&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_url&#x27;</span>
    ],
    num_rows: <span class="hljs-number">412178</span>
})`,wrap:!1}}),_=new u({props:{code:"cHJpbnQocmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlNUIxMjM0NTYlNUQlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">123456</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>])',wrap:!1}}),v=new u({props:{code:"ZGVmJTIwaGFuZGxlX3NpbXBsZV9yZXNwb25zZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUyMHRpbWVvdXRfbXMlM0ROb25lJTJDJTIwaW5mb19jYiUzRERFRkFVTFRfTUVTU0FHRV9DQUxMQkFDSyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBY2NlcHRzJTIwbm9ybWFsJTIwcmVzcG9uc2VzJTIwZnJvbSUyMHRoZSUyMGRldmljZS4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGltZW91dF9tcyUzQSUyMFRpbWVvdXQlMjBpbiUyMG1pbGxpc2Vjb25kcyUyMHRvJTIwd2FpdCUyMGZvciUyMGVhY2glMjByZXNwb25zZS4lMEElMjAlMjAlMjAlMjAlMjAlMjBpbmZvX2NiJTNBJTIwT3B0aW9uYWwlMjBjYWxsYmFjayUyMGZvciUyMHRleHQlMjBzZW50JTIwZnJvbSUyMHRoZSUyMGJvb3Rsb2FkZXIuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyME9LQVklMjBwYWNrZXQncyUyMG1lc3NhZ2UuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5fYWNjZXB0X3Jlc3BvbnNlcygnT0tBWSclMkMlMjBpbmZvX2NiJTJDJTIwdGltZW91dF9tcyUzRHRpbWVvdXRfbXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_simple_responses</span>(<span class="hljs-params">
      self, timeout_ms=<span class="hljs-literal">None</span>, info_cb=DEFAULT_MESSAGE_CALLBACK</span>):
    <span class="hljs-string">&quot;&quot;&quot;Accepts normal responses from the device.

    Args:
      timeout_ms: Timeout in milliseconds to wait for each response.
      info_cb: Optional callback for text sent from the bootloader.

    Returns:
      OKAY packet&#x27;s message.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> self._accept_responses(<span class="hljs-string">&#x27;OKAY&#x27;</span>, info_cb, timeout_ms=timeout_ms)`,wrap:!1}}),Z=new u({props:{code:"JTIzJTIwRG9uJ3QlMjB1bmNvbW1lbnQlMjB0aGUlMjBmb2xsb3dpbmclMjBsaW5lJTIwdW5sZXNzJTIweW91ciUyMGRhdGFzZXQlMjBpcyUyMHNtYWxsISUwQSUyMyUyMHRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMCU1QnJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTVE",highlighted:`<span class="hljs-comment"># Don&#x27;t uncomment the following line unless your dataset is small!</span>
<span class="hljs-comment"># training_corpus = [raw_datasets[&quot;train&quot;][i: i + 1000][&quot;whole_func_string&quot;] for i in range(0, len(raw_datasets[&quot;train&quot;]), 1000)]</span>`,wrap:!1}}),W=new u({props:{code:"dHJhaW5pbmdfY29ycHVzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBKQ==",highlighted:`training_corpus = (
    raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
)`,wrap:!1}}),E=new u({props:{code:"Z2VuJTIwJTNEJTIwKGklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCkpJTBBcHJpbnQobGlzdChnZW4pKSUwQXByaW50KGxpc3QoZ2VuKSk=",highlighted:`gen = (i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))`,wrap:!1}}),H=new u({props:{code:"JTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUwQSU1QiU1RA==",highlighted:`[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]
[]`,wrap:!1}}),Y=new u({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUwQXRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMGdldF90cmFpbmluZ19jb3JwdXMoKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">return</span> (
        raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
    )


training_corpus = get_training_corpus()`,wrap:!1}}),q=new u({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RhcnRfaWR4JTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKGRhdGFzZXQpJTJDJTIwMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwZGF0YXNldCU1QnN0YXJ0X2lkeCUyMCUzQSUyMHN0YXJ0X2lkeCUyMCUyQiUyMDEwMDAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMHNhbXBsZXMlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    dataset = raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        samples = dataset[start_idx : start_idx + <span class="hljs-number">1000</span>]
        <span class="hljs-keyword">yield</span> samples[<span class="hljs-string">&quot;whole_func_string&quot;</span>]`,wrap:!1}}),L=new Fe({props:{title:"Training a new tokenizer",local:"training-a-new-tokenizer",headingTag:"h2"}}),K=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFvbGRfdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

old_tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),es=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCcnJ2RlZiUyMGFkZF9udW1iZXJzKGElMkMlMjBiKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFkZCUyMHRoZSUyMHR3byUyMG51bWJlcnMlMjAlNjBhJTYwJTIwYW5kJTIwJTYwYiU2MC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwJTJCJTIwYicnJyUwQSUwQXRva2VucyUyMCUzRCUyMG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSklMEF0b2tlbnM=",highlighted:`example = <span class="hljs-string">&#x27;&#x27;&#x27;def add_numbers(a, b):
    &quot;&quot;&quot;Add the two numbers \`a\` and \`b\`.&quot;&quot;&quot;
    return a + b&#x27;&#x27;&#x27;</span>

tokens = old_tokenizer.tokenize(example)
tokens`,wrap:!1}}),ts=new u({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCduJyUyQyUyMCd1bWJlcnMnJTJDJTIwJygnJTJDJTIwJ2EnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwYiclMkMlMjAnKSUzQSclMkMlMjAnJUM0JThBJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAlMjIlMjIlMjInJTJDJTIwJ0FkZCclMkMlMjAnJUM0JUEwdGhlJyUyQyUyMCclQzQlQTB0d28nJTJDJTBBJTIwJyVDNCVBMG51bWJlcnMnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYSclMkMlMjAnJTYwJyUyQyUyMCclQzQlQTBhbmQnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYiclMkMlMjAnJTYwJyUyQyUyMCcuJTIyJyUyQyUyMCclMjIlMjInJTJDJTIwJyVDNCU4QSclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;umbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>,\n <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;.&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),as=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwb2xkX3Rva2VuaXplci50cmFpbl9uZXdfZnJvbV9pdGVyYXRvcih0cmFpbmluZ19jb3JwdXMlMkMlMjA1MjAwMCk=",highlighted:'tokenizer = old_tokenizer.train_new_from_iterator(training_corpus, <span class="hljs-number">52000</span>)',wrap:!1}}),cs=new u({props:{code:"dG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKGV4YW1wbGUpJTBBdG9rZW5z",highlighted:`tokens = tokenizer.tokenize(example)
tokens`,wrap:!1}}),hs=new u({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCdudW1iZXJzJyUyQyUyMCcoJyUyQyUyMCdhJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMGInJTJDJTIwJyklM0EnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwJTIyJTIyJTIyJyUyQyUyMCdBZGQnJTJDJTIwJyVDNCVBMHRoZSclMkMlMjAnJUM0JUEwdHdvJyUyQyUyMCclQzQlQTBudW1iZXJzJyUyQyUyMCclQzQlQTAlNjAnJTJDJTBBJTIwJ2EnJTJDJTIwJyU2MCclMkMlMjAnJUM0JUEwYW5kJyUyQyUyMCclQzQlQTAlNjAnJTJDJTIwJ2InJTJDJTIwJyU2MC4lMjIlMjIlMjInJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;numbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>, <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>,\n <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`.&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),Ms=new u({props:{code:"cHJpbnQobGVuKHRva2VucykpJTBBcHJpbnQobGVuKG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSkpKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(tokens))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(old_tokenizer.tokenize(example)))`,wrap:!1}}),Js=new u({props:{code:"MjclMEEzNg==",highlighted:`<span class="hljs-number">27</span>
<span class="hljs-number">36</span>`,wrap:!1}}),ws=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCUyMiUyMiUyMmNsYXNzJTIwTGluZWFyTGF5ZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53ZWlnaHQlMjAlM0QlMjB0b3JjaC5yYW5kbihpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iaWFzJTIwJTNEJTIwdG9yY2guemVyb3Mob3V0cHV0X3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIweCUyMCU0MCUyMHNlbGYud2VpZ2h0cyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQXRva2VuaXplci50b2tlbml6ZShleGFtcGxlKQ==",highlighted:`example = <span class="hljs-string">&quot;&quot;&quot;class LinearLayer():
    def __init__(self, input_size, output_size):
        self.weight = torch.randn(input_size, output_size)
        self.bias = torch.zeros(output_size)

    def __call__(self, x):
        return x @ self.weights + self.bias
    &quot;&quot;&quot;</span>
tokenizer.tokenize(example)`,wrap:!1}}),ms=new u({props:{code:"JTVCJ2NsYXNzJyUyQyUyMCclQzQlQTBMaW5lYXInJTJDJTIwJ0xheWVyJyUyQyUyMCcoKSUzQSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBkZWYnJTJDJTIwJyVDNCVBMF9fJyUyQyUyMCdpbml0JyUyQyUyMCdfXygnJTJDJTIwJ3NlbGYnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwaW5wdXQnJTJDJTIwJ18nJTJDJTIwJ3NpemUnJTJDJTIwJyUyQyclMkMlMEElMjAnJUM0JUEwb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ3dlaWdodCclMkMlMjAnJUM0JUEwJTNEJyUyQyUyMCclQzQlQTB0b3JjaCclMkMlMjAnLiclMkMlMjAncmFuZG4nJTJDJTIwJygnJTJDJTIwJ2lucHV0JyUyQyUyMCdfJyUyQyUwQSUyMCdzaXplJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMG91dHB1dCclMkMlMjAnXyclMkMlMjAnc2l6ZSclMkMlMjAnKSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCdiaWFzJyUyQyUyMCclQzQlQTAlM0QnJTJDJTIwJyVDNCVBMHRvcmNoJyUyQyUyMCcuJyUyQyUyMCd6ZXJvcyclMkMlMjAnKCclMkMlMEElMjAnb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJyUyQyUyMCclQzQlOEElQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMGRlZiclMkMlMjAnJUM0JUEwX18nJTJDJTIwJ2NhbGwnJTJDJTIwJ19fKCclMkMlMjAnc2VsZiclMkMlMjAnJTJDJyUyQyUyMCclQzQlQTB4JyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTBBJTIwJyVDNCVBMHJldHVybiclMkMlMjAnJUM0JUEweCclMkMlMjAnJUM0JUEwJTQwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCd3ZWlnaHRzJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ2JpYXMnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCVDNCVBMCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;class&#x27;</span>, <span class="hljs-string">&#x27;ĠLinear&#x27;</span>, <span class="hljs-string">&#x27;Layer&#x27;</span>, <span class="hljs-string">&#x27;():&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;init&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġinput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>,
 <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;randn&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;input&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>,
 <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;zeros&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>,
 <span class="hljs-string">&#x27;output&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;call&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>,
 <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;Ġ@&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weights&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠ&#x27;</span>]`,wrap:!1}}),fs=new Fe({props:{title:"Saving the tokenizer",local:"saving-the-tokenizer",headingTag:"h2"}}),gs=new u({props:{code:"dG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:'tokenizer.save_pretrained(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),xs=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),bs=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Cs=new u({props:{code:"dG9rZW5pemVyLnB1c2hfdG9faHViKCUyMmNvZGUtc2VhcmNoLW5ldC10b2tlbml6ZXIlMjIp",highlighted:'tokenizer.push_to_hub(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),$s=new u({props:{code:"JTIzJTIwUmVwbGFjZSUyMCUyMmh1Z2dpbmdmYWNlLWNvdXJzZSUyMiUyMGJlbG93JTIwd2l0aCUyMHlvdXIlMjBhY3R1YWwlMjBuYW1lc3BhY2UlMjB0byUyMHVzZSUyMHlvdXIlMjBvd24lMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJodWdnaW5nZmFjZS1jb3Vyc2UlMkZjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:`<span class="hljs-comment"># Replace &quot;huggingface-course&quot; below with your actual namespace to use your own tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggingface-course/code-search-net-tokenizer&quot;</span>)`,wrap:!1}}),zs=new Et({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter6/2.mdx"}}),{c(){w=i("meta"),f=l(),m=i("p"),_s=l(),r(T.$$.fragment),As=l(),r(g.$$.fragment),Bs=l(),j=i("p"),j.innerHTML=Le,Zs=l(),r(x.$$.fragment),Xs=l(),r(d.$$.fragment),Ws=l(),r(U.$$.fragment),Ns=l(),b=i("p"),b.innerHTML=Pe,Gs=l(),k=i("p"),k.innerHTML=Ke,Es=l(),r(C.$$.fragment),Ds=l(),Q=i("p"),Q.textContent=Oe,Hs=l(),r($.$$.fragment),Rs=l(),r(I.$$.fragment),Ys=l(),z=i("p"),z.innerHTML=st,Ss=l(),r(_.$$.fragment),qs=l(),V=i("p"),V.textContent=et,Fs=l(),r(v.$$.fragment),Ls=l(),A=i("p"),A.innerHTML=tt,Ps=l(),B=i("p"),B.textContent=nt,Ks=l(),r(Z.$$.fragment),Os=l(),X=i("p"),X.textContent=lt,se=l(),r(W.$$.fragment),ee=l(),N=i("p"),N.innerHTML=at,te=l(),G=i("p"),G.textContent=it,ne=l(),r(E.$$.fragment),le=l(),D=i("p"),D.textContent=ot,ae=l(),r(H.$$.fragment),ie=l(),R=i("p"),R.textContent=rt,oe=l(),r(Y.$$.fragment),re=l(),S=i("p"),S.innerHTML=pt,pe=l(),r(q.$$.fragment),ce=l(),F=i("p"),F.textContent=ct,he=l(),r(L.$$.fragment),ye=l(),P=i("p"),P.textContent=ht,Me=l(),r(K.$$.fragment),Je=l(),O=i("p"),O.textContent=yt,ue=l(),ss=i("p"),ss.textContent=Mt,we=l(),r(es.$$.fragment),me=l(),r(ts.$$.fragment),de=l(),ns=i("p"),ns.innerHTML=Jt,fe=l(),ls=i("p"),ls.innerHTML=ut,Te=l(),r(as.$$.fragment),ge=l(),is=i("p"),is.textContent=wt,je=l(),os=i("p"),os.innerHTML=mt,xe=l(),rs=i("p"),rs.innerHTML=dt,Ue=l(),ps=i("p"),ps.innerHTML=ft,be=l(),r(cs.$$.fragment),ke=l(),r(hs.$$.fragment),Ce=l(),ys=i("p"),ys.innerHTML=Tt,Qe=l(),r(Ms.$$.fragment),$e=l(),r(Js.$$.fragment),Ie=l(),us=i("p"),us.textContent=gt,ze=l(),r(ws.$$.fragment),_e=l(),r(ms.$$.fragment),Ve=l(),ds=i("p"),ds.innerHTML=jt,ve=l(),r(fs.$$.fragment),Ae=l(),Ts=i("p"),Ts.innerHTML=xt,Be=l(),r(gs.$$.fragment),Ze=l(),js=i("p"),js.innerHTML=Ut,Xe=l(),r(xs.$$.fragment),We=l(),Us=i("p"),Us.textContent=bt,Ne=l(),r(bs.$$.fragment),Ge=l(),ks=i("p"),ks.textContent=kt,Ee=l(),r(Cs.$$.fragment),De=l(),Qs=i("p"),Qs.innerHTML=Ct,He=l(),r($s.$$.fragment),Re=l(),Is=i("p"),Is.innerHTML=Qt,Ye=l(),r(zs.$$.fragment),Se=l(),Vs=i("p"),this.h()},l(s){const e=Zt("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(t),f=a(s),m=o(s,"P",{}),It(m).forEach(t),_s=a(s),p(T.$$.fragment,s),As=a(s),p(g.$$.fragment,s),Bs=a(s),j=o(s,"P",{"data-svelte-h":!0}),J(j)!=="svelte-ge9o4k"&&(j.innerHTML=Le),Zs=a(s),p(x.$$.fragment,s),Xs=a(s),p(d.$$.fragment,s),Ws=a(s),p(U.$$.fragment,s),Ns=a(s),b=o(s,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1h1d1jb"&&(b.innerHTML=Pe),Gs=a(s),k=o(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-d4p7ba"&&(k.innerHTML=Ke),Es=a(s),p(C.$$.fragment,s),Ds=a(s),Q=o(s,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-12bpn2p"&&(Q.textContent=Oe),Hs=a(s),p($.$$.fragment,s),Rs=a(s),p(I.$$.fragment,s),Ys=a(s),z=o(s,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1ttcdha"&&(z.innerHTML=st),Ss=a(s),p(_.$$.fragment,s),qs=a(s),V=o(s,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1go55zn"&&(V.textContent=et),Fs=a(s),p(v.$$.fragment,s),Ls=a(s),A=o(s,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1w4rq2j"&&(A.innerHTML=tt),Ps=a(s),B=o(s,"P",{"data-svelte-h":!0}),J(B)!=="svelte-n3iewp"&&(B.textContent=nt),Ks=a(s),p(Z.$$.fragment,s),Os=a(s),X=o(s,"P",{"data-svelte-h":!0}),J(X)!=="svelte-z3gyd6"&&(X.textContent=lt),se=a(s),p(W.$$.fragment,s),ee=a(s),N=o(s,"P",{"data-svelte-h":!0}),J(N)!=="svelte-1m62zsw"&&(N.innerHTML=at),te=a(s),G=o(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-y43dl1"&&(G.textContent=it),ne=a(s),p(E.$$.fragment,s),le=a(s),D=o(s,"P",{"data-svelte-h":!0}),J(D)!=="svelte-nyttr1"&&(D.textContent=ot),ae=a(s),p(H.$$.fragment,s),ie=a(s),R=o(s,"P",{"data-svelte-h":!0}),J(R)!=="svelte-1ja5i79"&&(R.textContent=rt),oe=a(s),p(Y.$$.fragment,s),re=a(s),S=o(s,"P",{"data-svelte-h":!0}),J(S)!=="svelte-1ujnh8r"&&(S.innerHTML=pt),pe=a(s),p(q.$$.fragment,s),ce=a(s),F=o(s,"P",{"data-svelte-h":!0}),J(F)!=="svelte-15t5zhk"&&(F.textContent=ct),he=a(s),p(L.$$.fragment,s),ye=a(s),P=o(s,"P",{"data-svelte-h":!0}),J(P)!=="svelte-1if3zzd"&&(P.textContent=ht),Me=a(s),p(K.$$.fragment,s),Je=a(s),O=o(s,"P",{"data-svelte-h":!0}),J(O)!=="svelte-gfsdsz"&&(O.textContent=yt),ue=a(s),ss=o(s,"P",{"data-svelte-h":!0}),J(ss)!=="svelte-1whi783"&&(ss.textContent=Mt),we=a(s),p(es.$$.fragment,s),me=a(s),p(ts.$$.fragment,s),de=a(s),ns=o(s,"P",{"data-svelte-h":!0}),J(ns)!=="svelte-1n6ojb6"&&(ns.innerHTML=Jt),fe=a(s),ls=o(s,"P",{"data-svelte-h":!0}),J(ls)!=="svelte-1wg3w1a"&&(ls.innerHTML=ut),Te=a(s),p(as.$$.fragment,s),ge=a(s),is=o(s,"P",{"data-svelte-h":!0}),J(is)!=="svelte-1s55tci"&&(is.textContent=wt),je=a(s),os=o(s,"P",{"data-svelte-h":!0}),J(os)!=="svelte-1cil686"&&(os.innerHTML=mt),xe=a(s),rs=o(s,"P",{"data-svelte-h":!0}),J(rs)!=="svelte-9eiphm"&&(rs.innerHTML=dt),Ue=a(s),ps=o(s,"P",{"data-svelte-h":!0}),J(ps)!=="svelte-kzj4vn"&&(ps.innerHTML=ft),be=a(s),p(cs.$$.fragment,s),ke=a(s),p(hs.$$.fragment,s),Ce=a(s),ys=o(s,"P",{"data-svelte-h":!0}),J(ys)!=="svelte-1si8jb2"&&(ys.innerHTML=Tt),Qe=a(s),p(Ms.$$.fragment,s),$e=a(s),p(Js.$$.fragment,s),Ie=a(s),us=o(s,"P",{"data-svelte-h":!0}),J(us)!=="svelte-1hvz582"&&(us.textContent=gt),ze=a(s),p(ws.$$.fragment,s),_e=a(s),p(ms.$$.fragment,s),Ve=a(s),ds=o(s,"P",{"data-svelte-h":!0}),J(ds)!=="svelte-1anhj7k"&&(ds.innerHTML=jt),ve=a(s),p(fs.$$.fragment,s),Ae=a(s),Ts=o(s,"P",{"data-svelte-h":!0}),J(Ts)!=="svelte-ot264x"&&(Ts.innerHTML=xt),Be=a(s),p(gs.$$.fragment,s),Ze=a(s),js=o(s,"P",{"data-svelte-h":!0}),J(js)!=="svelte-1oaabmx"&&(js.innerHTML=Ut),Xe=a(s),p(xs.$$.fragment,s),We=a(s),Us=o(s,"P",{"data-svelte-h":!0}),J(Us)!=="svelte-mgkzhm"&&(Us.textContent=bt),Ne=a(s),p(bs.$$.fragment,s),Ge=a(s),ks=o(s,"P",{"data-svelte-h":!0}),J(ks)!=="svelte-gbhb1u"&&(ks.textContent=kt),Ee=a(s),p(Cs.$$.fragment,s),De=a(s),Qs=o(s,"P",{"data-svelte-h":!0}),J(Qs)!=="svelte-eipxyz"&&(Qs.innerHTML=Ct),He=a(s),p($s.$$.fragment,s),Re=a(s),Is=o(s,"P",{"data-svelte-h":!0}),J(Is)!=="svelte-1r3xq8e"&&(Is.innerHTML=Qt),Ye=a(s),p(zs.$$.fragment,s),Se=a(s),Vs=o(s,"P",{}),It(Vs).forEach(t),this.h()},h(){zt(w,"name","hf:doc:metadata"),zt(w,"content",Rt)},m(s,e){Xt(document.head,w),n(s,f,e),n(s,m,e),n(s,_s,e),c(T,s,e),n(s,As,e),c(g,s,e),n(s,Bs,e),n(s,j,e),n(s,Zs,e),c(x,s,e),n(s,Xs,e),c(d,s,e),n(s,Ws,e),c(U,s,e),n(s,Ns,e),n(s,b,e),n(s,Gs,e),n(s,k,e),n(s,Es,e),c(C,s,e),n(s,Ds,e),n(s,Q,e),n(s,Hs,e),c($,s,e),n(s,Rs,e),c(I,s,e),n(s,Ys,e),n(s,z,e),n(s,Ss,e),c(_,s,e),n(s,qs,e),n(s,V,e),n(s,Fs,e),c(v,s,e),n(s,Ls,e),n(s,A,e),n(s,Ps,e),n(s,B,e),n(s,Ks,e),c(Z,s,e),n(s,Os,e),n(s,X,e),n(s,se,e),c(W,s,e),n(s,ee,e),n(s,N,e),n(s,te,e),n(s,G,e),n(s,ne,e),c(E,s,e),n(s,le,e),n(s,D,e),n(s,ae,e),c(H,s,e),n(s,ie,e),n(s,R,e),n(s,oe,e),c(Y,s,e),n(s,re,e),n(s,S,e),n(s,pe,e),c(q,s,e),n(s,ce,e),n(s,F,e),n(s,he,e),c(L,s,e),n(s,ye,e),n(s,P,e),n(s,Me,e),c(K,s,e),n(s,Je,e),n(s,O,e),n(s,ue,e),n(s,ss,e),n(s,we,e),c(es,s,e),n(s,me,e),c(ts,s,e),n(s,de,e),n(s,ns,e),n(s,fe,e),n(s,ls,e),n(s,Te,e),c(as,s,e),n(s,ge,e),n(s,is,e),n(s,je,e),n(s,os,e),n(s,xe,e),n(s,rs,e),n(s,Ue,e),n(s,ps,e),n(s,be,e),c(cs,s,e),n(s,ke,e),c(hs,s,e),n(s,Ce,e),n(s,ys,e),n(s,Qe,e),c(Ms,s,e),n(s,$e,e),c(Js,s,e),n(s,Ie,e),n(s,us,e),n(s,ze,e),c(ws,s,e),n(s,_e,e),c(ms,s,e),n(s,Ve,e),n(s,ds,e),n(s,ve,e),c(fs,s,e),n(s,Ae,e),n(s,Ts,e),n(s,Be,e),c(gs,s,e),n(s,Ze,e),n(s,js,e),n(s,Xe,e),c(xs,s,e),n(s,We,e),n(s,Us,e),n(s,Ne,e),c(bs,s,e),n(s,Ge,e),n(s,ks,e),n(s,Ee,e),c(Cs,s,e),n(s,De,e),n(s,Qs,e),n(s,He,e),c($s,s,e),n(s,Re,e),n(s,Is,e),n(s,Ye,e),c(zs,s,e),n(s,Se,e),n(s,Vs,e),qe=!0},p(s,[e]){const $t={};e&2&&($t.$$scope={dirty:e,ctx:s}),d.$set($t)},i(s){qe||(h(T.$$.fragment,s),h(g.$$.fragment,s),h(x.$$.fragment,s),h(d.$$.fragment,s),h(U.$$.fragment,s),h(C.$$.fragment,s),h($.$$.fragment,s),h(I.$$.fragment,s),h(_.$$.fragment,s),h(v.$$.fragment,s),h(Z.$$.fragment,s),h(W.$$.fragment,s),h(E.$$.fragment,s),h(H.$$.fragment,s),h(Y.$$.fragment,s),h(q.$$.fragment,s),h(L.$$.fragment,s),h(K.$$.fragment,s),h(es.$$.fragment,s),h(ts.$$.fragment,s),h(as.$$.fragment,s),h(cs.$$.fragment,s),h(hs.$$.fragment,s),h(Ms.$$.fragment,s),h(Js.$$.fragment,s),h(ws.$$.fragment,s),h(ms.$$.fragment,s),h(fs.$$.fragment,s),h(gs.$$.fragment,s),h(xs.$$.fragment,s),h(bs.$$.fragment,s),h(Cs.$$.fragment,s),h($s.$$.fragment,s),h(zs.$$.fragment,s),qe=!0)},o(s){y(T.$$.fragment,s),y(g.$$.fragment,s),y(x.$$.fragment,s),y(d.$$.fragment,s),y(U.$$.fragment,s),y(C.$$.fragment,s),y($.$$.fragment,s),y(I.$$.fragment,s),y(_.$$.fragment,s),y(v.$$.fragment,s),y(Z.$$.fragment,s),y(W.$$.fragment,s),y(E.$$.fragment,s),y(H.$$.fragment,s),y(Y.$$.fragment,s),y(q.$$.fragment,s),y(L.$$.fragment,s),y(K.$$.fragment,s),y(es.$$.fragment,s),y(ts.$$.fragment,s),y(as.$$.fragment,s),y(cs.$$.fragment,s),y(hs.$$.fragment,s),y(Ms.$$.fragment,s),y(Js.$$.fragment,s),y(ws.$$.fragment,s),y(ms.$$.fragment,s),y(fs.$$.fragment,s),y(gs.$$.fragment,s),y(xs.$$.fragment,s),y(bs.$$.fragment,s),y(Cs.$$.fragment,s),y($s.$$.fragment,s),y(zs.$$.fragment,s),qe=!1},d(s){s&&(t(f),t(m),t(_s),t(As),t(Bs),t(j),t(Zs),t(Xs),t(Ws),t(Ns),t(b),t(Gs),t(k),t(Es),t(Ds),t(Q),t(Hs),t(Rs),t(Ys),t(z),t(Ss),t(qs),t(V),t(Fs),t(Ls),t(A),t(Ps),t(B),t(Ks),t(Os),t(X),t(se),t(ee),t(N),t(te),t(G),t(ne),t(le),t(D),t(ae),t(ie),t(R),t(oe),t(re),t(S),t(pe),t(ce),t(F),t(he),t(ye),t(P),t(Me),t(Je),t(O),t(ue),t(ss),t(we),t(me),t(de),t(ns),t(fe),t(ls),t(Te),t(ge),t(is),t(je),t(os),t(xe),t(rs),t(Ue),t(ps),t(be),t(ke),t(Ce),t(ys),t(Qe),t($e),t(Ie),t(us),t(ze),t(_e),t(Ve),t(ds),t(ve),t(Ae),t(Ts),t(Be),t(Ze),t(js),t(Xe),t(We),t(Us),t(Ne),t(Ge),t(ks),t(Ee),t(De),t(Qs),t(He),t(Re),t(Is),t(Ye),t(Se),t(Vs)),t(w),M(T,s),M(g,s),M(x,s),M(d,s),M(U,s),M(C,s),M($,s),M(I,s),M(_,s),M(v,s),M(Z,s),M(W,s),M(E,s),M(H,s),M(Y,s),M(q,s),M(L,s),M(K,s),M(es,s),M(ts,s),M(as,s),M(cs,s),M(hs,s),M(Ms,s),M(Js,s),M(ws,s),M(ms,s),M(fs,s),M(gs,s),M(xs,s),M(bs,s),M(Cs,s),M($s,s),M(zs,s)}}}const Rt='{"title":"Training a new tokenizer from an old one","local":"training-a-new-tokenizer-from-an-old-one","sections":[{"title":"Assembling a corpus","local":"assembling-a-corpus","sections":[],"depth":2},{"title":"Training a new tokenizer","local":"training-a-new-tokenizer","sections":[],"depth":2},{"title":"Saving the tokenizer","local":"saving-the-tokenizer","sections":[],"depth":2}],"depth":1}';function Yt(vs){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sn extends At{constructor(w){super(),Bt(this,w,Yt,Ht,_t,{})}}export{sn as component};
