import{s as ke,n as xe,o as Pe}from"../chunks/scheduler.85c25b89.js";import{S as Ce,i as $e,g as a,s as l,r as O,A as Le,h as r,f as o,c as n,j as _e,u as H,x as s,k as Te,y as Me,a as i,v as z,d as q,t as U,w as A}from"../chunks/index.c9bcf812.js";import{C as je}from"../chunks/CodeBlock.94efc595.js";import{H as ne,E as Oe}from"../chunks/EditOnGithub.ec73e7c7.js";function He(ae){let c,K,M,E,d,I,p,re=`As reinforcement learning algorithms are historically challenging to debug, it’s important to pay careful attention to logging.
By default, the TRL <a href="/docs/trl/pr_1628/en/trainer#trl.PPOTrainer">PPOTrainer</a> saves a lot of relevant information to <code>wandb</code> or <code>tensorboard</code>.`,J,h,se='Upon initialization, pass one of these two options to the <a href="/docs/trl/pr_1628/en/trainer#trl.PPOConfig">PPOConfig</a>:',S,m,G,f,ce="If you want to log with tensorboard, add the kwarg <code>project_kwargs={&quot;logging_dir&quot;: PATH_TO_LOGS}</code> to the PPOConfig.",Z,u,B,g,de="Here’s a brief explanation for the logged metrics provided in the data:",R,v,pe="Key metrics to monitor. We want to maximize the reward, maintain a low KL divergence, and maximize entropy:",D,b,he="<li><code>env/reward_mean</code>: The average reward obtained from the environment. Alias <code>ppo/mean_scores</code>, which is sed to specifically monitor the reward model.</li> <li><code>env/reward_std</code>: The standard deviation of the reward obtained from the environment. Alias `<code>ppo/std_scores</code>, which is sed to specifically monitor the reward model.</li> <li><code>env/reward_dist</code>: The histogram distribution of the reward obtained from the environment.</li> <li><code>objective/kl</code>: The mean Kullback-Leibler (KL) divergence between the old and new policies. It measures how much the new policy deviates from the old policy. The KL divergence is used to compute the KL penalty in the objective function.</li> <li><code>objective/kl_dist</code>: The histogram distribution of the <code>objective/kl</code>.</li> <li><code>objective/kl_coef</code>: The coefficient for Kullback-Leibler (KL) divergence in the objective function.</li> <li><code>ppo/mean_non_score_reward</code>: The <strong>KL penalty</strong> calculated by <code>objective/kl * objective/kl_coef</code> as the total reward for optimization to prevent the new policy from deviating too far from the old policy.</li> <li><code>objective/entropy</code>: The entropy of the model’s policy, calculated by <code>-logprobs.sum(-1).mean()</code>. High entropy means the model’s actions are more random, which can be beneficial for exploration.</li>",N,w,me="Training stats:",W,y,fe='<li><code>ppo/learning_rate</code>: The learning rate for the PPO algorithm.</li> <li><code>ppo/policy/entropy</code>: The entropy of the model’s policy, calculated by <code>pd = torch.nn.functional.softmax(logits, dim=-1); entropy = torch.logsumexp(logits, dim=-1) - torch.sum(pd * logits, dim=-1)</code>. It measures the randomness of the policy.</li> <li><code>ppo/policy/clipfrac</code>: The fraction of probability ratios (old policy / new policy) that fell outside the clipping range in the PPO objective. This can be used to monitor the optimization process.</li> <li><code>ppo/policy/approxkl</code>: The approximate KL divergence between the old and new policies, measured by <code>0.5 * masked_mean((logprobs - old_logprobs) ** 2, mask)</code>, corresponding to the <code>k2</code> estimator in <a href="http://joschu.net/blog/kl-approx.html" rel="nofollow">http://joschu.net/blog/kl-approx.html</a></li> <li><code>ppo/policy/policykl</code>: Similar to <code>ppo/policy/approxkl</code>, but measured by <code>masked_mean(old_logprobs - logprobs, mask)</code>, corresponding to the <code>k1</code> estimator in <a href="http://joschu.net/blog/kl-approx.html" rel="nofollow">http://joschu.net/blog/kl-approx.html</a></li> <li><code>ppo/policy/ratio</code>:  The histogram distribution of the ratio between the new and old policies, used to compute the PPO objective.</li> <li><code>ppo/policy/advantages_mean</code>: The average of the GAE (Generalized Advantage Estimation) advantage estimates. The advantage function measures how much better an action is compared to the average action at a state.</li> <li><code>ppo/policy/advantages</code>: The histogram distribution of <code>ppo/policy/advantages_mean</code>.</li> <li><code>ppo/returns/mean</code>: The mean of the TD(λ) returns, calculated by <code>returns = advantage + values</code>, another indicator of model performance. See <a href="https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/" rel="nofollow">https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/</a> for more details.</li> <li><code>ppo/returns/var</code>: The variance of the TD(λ) returns, calculated by <code>returns = advantage + values</code>, another indicator of model performance.</li> <li><code>ppo/val/mean</code>: The mean of the values, used to monitor the value function’s performance.</li> <li><code>ppo/val/var</code> : The variance of the values, used to monitor the value function’s performance.</li> <li><code>ppo/val/var_explained</code>: The explained variance for the value function, used to monitor the value function’s performance.</li> <li><code>ppo/val/clipfrac</code>: The fraction of the value function’s predicted values that are clipped.</li> <li><code>ppo/val/vpred</code>: The predicted values from the value function.</li> <li><code>ppo/val/error</code>: The mean squared error between the <code>ppo/val/vpred</code> and returns, used to monitor the value function’s performance.</li> <li><code>ppo/loss/policy</code>: The policy loss for the Proximal Policy Optimization (PPO) algorithm.</li> <li><code>ppo/loss/value</code>: The loss for the value function in the PPO algorithm. This value quantifies how well the function estimates the expected future rewards.</li> <li><code>ppo/loss/total</code>: The total loss for the PPO algorithm. It is the sum of the policy loss and the value function loss.</li>',Q,_,ue="Stats on queries, responses, and logprobs:",F,T,ge="<li><code>tokens/queries_len_mean</code>: The average length of the queries tokens.</li> <li><code>tokens/queries_len_std</code>: The standard deviation of the length of the queries tokens.</li> <li><code>tokens/queries_dist</code>: The histogram distribution of the length of the queries tokens.</li> <li><code>tokens/responses_len_mean</code>: The average length of the responses tokens.</li> <li><code>tokens/responses_len_std</code>: The standard deviation of the length of the responses tokens.</li> <li><code>tokens/responses_dist</code>: The histogram distribution of the length of the responses tokens. (Costa: inconsistent naming, should be <code>tokens/responses_len_dist</code>)</li> <li><code>objective/logprobs</code>: The histogram distribution of the log probabilities of the actions taken by the model.</li> <li><code>objective/ref_logprobs</code>: The histogram distribution of the log probabilities of the actions taken by the reference model.</li>",V,k,X,x,ve="During training, many values are logged, here are the most important ones:",Y,P,be="<li><code>env/reward_mean</code>,<code>env/reward_std</code>, <code>env/reward_dist</code>: the properties of the reward distribution from the “environment” /  reward model</li> <li><code>ppo/mean_non_score_reward</code>: The mean negated KL penalty during training (shows the delta between the reference model and the new policy over the batch in the step)</li>",ee,C,we="Here are some parameters that are useful to monitor for stability (when these diverge or collapse to 0, try tuning variables):",te,$,ye="<li><code>ppo/loss/value</code>: it will spike / NaN when not going well.</li> <li><code>ppo/policy/ratio</code>: <code>ratio</code> being 1 is a baseline value, meaning that the probability of sampling a token is the same under the new and old policy. If the ratio is too high like 200, it means the probability of sampling a token is 200 times higher under the new policy than the old policy. This is a sign that the new policy is too different from the old policy, which will likely cause overoptimization and collapse training later on.</li> <li><code>ppo/policy/clipfrac</code> and <code>ppo/policy/approxkl</code>: if <code>ratio</code> is too high, the <code>ratio</code> is going to get clipped, resulting in high <code>clipfrac</code> and high <code>approxkl</code> as well.</li> <li><code>objective/kl</code>: it should stay positive so that the policy is not too far away from the reference policy.</li> <li><code>objective/kl_coef</code>: The target coefficient with <code>AdaptiveKLController</code>. Often increases before numerical instabilities.</li>",oe,L,ie,j,le;return d=new ne({props:{title:"Logging",local:"logging",headingTag:"h1"}}),m=new je({props:{code:"Y29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RhcmdzLm1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBsb2dfd2l0aCUzRCU2MHdhbmRiJTYwJTJDJTIwJTIzJTIwb3IlMjAlNjB0ZW5zb3Jib2FyZCU2MCUwQSk=",highlighted:'config = PPOConfig(\n    model_name=args.model_name,\n    log_with=`wandb`, # <span class="hljs-literal">or</span> `tensorboard`\n)',wrap:!1}}),u=new ne({props:{title:"PPO Logging",local:"ppo-logging",headingTag:"h2"}}),k=new ne({props:{title:"Crucial values",local:"crucial-values",headingTag:"h3"}}),L=new Oe({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/logging.mdx"}}),{c(){c=a("meta"),K=l(),M=a("p"),E=l(),O(d.$$.fragment),I=l(),p=a("p"),p.innerHTML=re,J=l(),h=a("p"),h.innerHTML=se,S=l(),O(m.$$.fragment),G=l(),f=a("p"),f.innerHTML=ce,Z=l(),O(u.$$.fragment),B=l(),g=a("p"),g.textContent=de,R=l(),v=a("p"),v.textContent=pe,D=l(),b=a("ol"),b.innerHTML=he,N=l(),w=a("p"),w.textContent=me,W=l(),y=a("ol"),y.innerHTML=fe,Q=l(),_=a("p"),_.textContent=ue,F=l(),T=a("ol"),T.innerHTML=ge,V=l(),O(k.$$.fragment),X=l(),x=a("p"),x.textContent=ve,Y=l(),P=a("ol"),P.innerHTML=be,ee=l(),C=a("p"),C.textContent=we,te=l(),$=a("ol"),$.innerHTML=ye,oe=l(),O(L.$$.fragment),ie=l(),j=a("p"),this.h()},l(e){const t=Le("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(o),K=n(e),M=r(e,"P",{}),_e(M).forEach(o),E=n(e),H(d.$$.fragment,e),I=n(e),p=r(e,"P",{"data-svelte-h":!0}),s(p)!=="svelte-gc7vva"&&(p.innerHTML=re),J=n(e),h=r(e,"P",{"data-svelte-h":!0}),s(h)!=="svelte-heluzr"&&(h.innerHTML=se),S=n(e),H(m.$$.fragment,e),G=n(e),f=r(e,"P",{"data-svelte-h":!0}),s(f)!=="svelte-9gqjy4"&&(f.innerHTML=ce),Z=n(e),H(u.$$.fragment,e),B=n(e),g=r(e,"P",{"data-svelte-h":!0}),s(g)!=="svelte-50qxhy"&&(g.textContent=de),R=n(e),v=r(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1oysg7j"&&(v.textContent=pe),D=n(e),b=r(e,"OL",{"data-svelte-h":!0}),s(b)!=="svelte-1c10na6"&&(b.innerHTML=he),N=n(e),w=r(e,"P",{"data-svelte-h":!0}),s(w)!=="svelte-ma4ajt"&&(w.textContent=me),W=n(e),y=r(e,"OL",{"data-svelte-h":!0}),s(y)!=="svelte-1eo0hbb"&&(y.innerHTML=fe),Q=n(e),_=r(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-1csidm3"&&(_.textContent=ue),F=n(e),T=r(e,"OL",{"data-svelte-h":!0}),s(T)!=="svelte-pvawsw"&&(T.innerHTML=ge),V=n(e),H(k.$$.fragment,e),X=n(e),x=r(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-189bxez"&&(x.textContent=ve),Y=n(e),P=r(e,"OL",{"data-svelte-h":!0}),s(P)!=="svelte-wjaroo"&&(P.innerHTML=be),ee=n(e),C=r(e,"P",{"data-svelte-h":!0}),s(C)!=="svelte-1yomxw6"&&(C.textContent=we),te=n(e),$=r(e,"OL",{"data-svelte-h":!0}),s($)!=="svelte-zapvl9"&&($.innerHTML=ye),oe=n(e),H(L.$$.fragment,e),ie=n(e),j=r(e,"P",{}),_e(j).forEach(o),this.h()},h(){Te(c,"name","hf:doc:metadata"),Te(c,"content",ze)},m(e,t){Me(document.head,c),i(e,K,t),i(e,M,t),i(e,E,t),z(d,e,t),i(e,I,t),i(e,p,t),i(e,J,t),i(e,h,t),i(e,S,t),z(m,e,t),i(e,G,t),i(e,f,t),i(e,Z,t),z(u,e,t),i(e,B,t),i(e,g,t),i(e,R,t),i(e,v,t),i(e,D,t),i(e,b,t),i(e,N,t),i(e,w,t),i(e,W,t),i(e,y,t),i(e,Q,t),i(e,_,t),i(e,F,t),i(e,T,t),i(e,V,t),z(k,e,t),i(e,X,t),i(e,x,t),i(e,Y,t),i(e,P,t),i(e,ee,t),i(e,C,t),i(e,te,t),i(e,$,t),i(e,oe,t),z(L,e,t),i(e,ie,t),i(e,j,t),le=!0},p:xe,i(e){le||(q(d.$$.fragment,e),q(m.$$.fragment,e),q(u.$$.fragment,e),q(k.$$.fragment,e),q(L.$$.fragment,e),le=!0)},o(e){U(d.$$.fragment,e),U(m.$$.fragment,e),U(u.$$.fragment,e),U(k.$$.fragment,e),U(L.$$.fragment,e),le=!1},d(e){e&&(o(K),o(M),o(E),o(I),o(p),o(J),o(h),o(S),o(G),o(f),o(Z),o(B),o(g),o(R),o(v),o(D),o(b),o(N),o(w),o(W),o(y),o(Q),o(_),o(F),o(T),o(V),o(X),o(x),o(Y),o(P),o(ee),o(C),o(te),o($),o(oe),o(ie),o(j)),o(c),A(d,e),A(m,e),A(u,e),A(k,e),A(L,e)}}}const ze='{"title":"Logging","local":"logging","sections":[{"title":"PPO Logging","local":"ppo-logging","sections":[{"title":"Crucial values","local":"crucial-values","sections":[],"depth":3}],"depth":2}],"depth":1}';function qe(ae){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends Ce{constructor(c){super(),$e(this,c,qe,He,ke,{})}}export{Ie as component};
