import{s as Tl,o as hl}from"../chunks/scheduler.defa9a21.js";import{S as bl,i as fl,g as r,s,r as c,A as Ul,h as i,f as t,c as n,j as wl,u as o,x as p,k as Jl,y as Il,a,v as M,d as m,t as d,w as y,m as gl,n as _l}from"../chunks/index.fe795e71.js";import{T as Cl}from"../chunks/Tip.179eb360.js";import{C as j}from"../chunks/CodeBlock.42404125.js";import{H as re,E as kl}from"../chunks/EditOnGithub.0f575778.js";function Bl(ie){let u;return{c(){u=gl(`Trackers built in Accelerate will automatically execute on the correct process, 
  so if a tracker is only meant to be ran on the main process it will do so 
  automatically.`)},l(w){u=_l(w,`Trackers built in Accelerate will automatically execute on the correct process, 
  so if a tracker is only meant to be ran on the main process it will do so 
  automatically.`)},m(w,T){a(w,u,T)},d(w){w&&t(u)}}}function $l(ie){let u,w,T,ce,h,oe,b,Ke=`There are a large number of experiment tracking API’s available, however getting them all to work with in a multi-processing environment can oftentimes be complex.
🤗 Accelerate provides a general tracking API that can be used to log useful items during your script through <code>Accelerator.log()</code>`,pe,f,Me,U,Pe="Currently <code>Accelerate</code> supports seven trackers out-of-the-box:",me,I,De="<li>TensorBoard</li> <li>WandB</li> <li>CometML</li> <li>Aim</li> <li>MLFlow</li> <li>ClearML</li> <li>DVCLive</li>",de,g,Oe="To use any of them, pass in the selected type(s) to the <code>log_with</code> parameter in <code>Accelerate</code>:",ye,_,ue,C,el="At the start of your experiment <code>Accelerator.init_trackers()</code> should be used to setup your project, and potentially add any experiment hyperparameters to be logged:",je,k,we,B,ll=`When you are ready to log any data, <code>Accelerator.log()</code> should be used.
A <code>step</code> can also be passed in to correlate the data with a particular step in the training loop.`,Je,$,Te,A,tl="Once you’ve finished training, make sure to run <code>Accelerator.end_training()</code> so that all the trackers can run their finish functionalities if they have any.",he,v,be,Z,al="A full example is below:",fe,W,Ue,G,sl=`If a tracker requires a directory to save data to, such as <code>TensorBoard</code>, then pass the directory path to <code>project_dir</code>. The <code>project_dir</code> parameter is useful
when there are other configurations to be combined with in the <a href="/docs/accelerate/pr_2841/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> data class. For example, you can save the TensorBoard data to <code>project_dir</code> and everything else can be logged in the <code>logging_dir</code> parameter of [<code>~utils.ProjectConfiguration</code>:`,Ie,X,ge,Y,_e,R,nl=`To implement a new tracker to be used in <code>Accelerator</code>, a new one can be made through implementing the <code>GeneralTracker</code> class.
Every tracker must implement three functions and have three properties:`,Ce,V,rl="<li><p><code>__init__</code>:</p> <ul><li>Should store a <code>run_name</code> and initialize the tracker API of the integrated library.</li> <li>If a tracker stores their data locally (such as TensorBoard), a <code>logging_dir</code> parameter can be added.</li></ul></li> <li><p><code>store_init_configuration</code>:</p> <ul><li>Should take in a <code>values</code> dictionary and store them as a one-time experiment configuration</li></ul></li> <li><p><code>log</code>:</p> <ul><li>Should take in a <code>values</code> dictionary and a <code>step</code>, and should log them to the run</li></ul></li> <li><p><code>name</code> (<code>str</code>):</p> <ul><li>A unique string name for the tracker, such as <code>&quot;wandb&quot;</code> for the wandb tracker.</li> <li>This will be used for interacting with this tracker specifically</li></ul></li> <li><p><code>requires_logging_directory</code> (<code>bool</code>):</p> <ul><li>Whether a <code>logging_dir</code> is needed for this particular tracker and if it uses one.</li></ul></li> <li><p><code>tracker</code>:</p> <ul><li>This should be implemented as a <code>@property</code> function</li> <li>Should return the internal tracking mechanism the library uses, such as the <code>run</code> object for <code>wandb</code>.</li></ul></li>",ke,H,il='Each method should also utilize the <a href="/docs/accelerate/pr_2841/en/package_reference/state#accelerate.PartialState">state.PartialState</a> class if the logger should only be executed on the main process for instance.',Be,Q,cl=`A brief example can be seen below with an integration with Weights and Biases, containing only the relevant information and logging just on
the main process:`,$e,N,Ae,x,ol=`When you are ready to build your <code>Accelerator</code> object, pass in an <strong>instance</strong> of your tracker to <code>Accelerator.log_with</code> to have it automatically
be used with the API:`,ve,F,Ze,E,pl="These also can be mixed with existing trackers, including with <code>&quot;all&quot;</code>:",We,z,Ge,q,Xe,S,Ml=`If some custom interactions with a tracker might be wanted directly, you can quickly access one using the
<a href="/docs/accelerate/pr_2841/en/package_reference/accelerator#accelerate.Accelerator.get_tracker">Accelerator.get_tracker()</a> method. Just pass in the string corresponding to a tracker’s <code>.name</code> attribute
and it will return that tracker on the main process.`,Ye,L,ml="This example shows doing so with wandb:",Re,K,Ve,P,dl="From there you can interact with <code>wandb</code>’s <code>run</code> object like normal:",He,D,Qe,J,Ne,O,yl=`If you want to truly remove Accelerate’s wrapping entirely, you can
achieve the same outcome with:`,xe,ee,Fe,le,Ee,te,ul="If a library has an API that does not follow a strict <code>.log</code> with an overall dictionary such as Neptune.AI, logging can be done manually under an <code>if accelerator.is_main_process</code> statement:",ze,ae,qe,se,Se,ne,Le;return h=new re({props:{title:"Tracking",local:"tracking",headingTag:"h1"}}),f=new re({props:{title:"Integrated Trackers",local:"integrated-trackers",headingTag:"h2"}}),_=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwTG9nZ2VyVHlwZSUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlMjJhbGwlMjIpJTIwJTIwJTIzJTIwRm9yJTIwYWxsJTIwYXZhaWxhYmxlJTIwdHJhY2tlcnMlMjBpbiUyMHRoZSUyMGVudmlyb25tZW50JTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihsb2dfd2l0aCUzRCUyMndhbmRiJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlNUIlMjJ3YW5kYiUyMiUyQyUyMExvZ2dlclR5cGUuVEVOU09SQk9BUkQlNUQp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> LoggerType

accelerator = Accelerator(log_with=<span class="hljs-string">&quot;all&quot;</span>)  <span class="hljs-comment"># For all available trackers in the environment</span>
accelerator = Accelerator(log_with=<span class="hljs-string">&quot;wandb&quot;</span>)
accelerator = Accelerator(log_with=[<span class="hljs-string">&quot;wandb&quot;</span>, LoggerType.TENSORBOARD])`,wrap:!1}}),k=new j({props:{code:"aHBzJTIwJTNEJTIwJTdCJTIybnVtX2l0ZXJhdGlvbnMlMjIlM0ElMjA1JTJDJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTIlN0QlMEFhY2NlbGVyYXRvci5pbml0X3RyYWNrZXJzKCUyMm15X3Byb2plY3QlMjIlMkMlMjBjb25maWclM0RocHMp",highlighted:`hps = {<span class="hljs-string">&quot;num_iterations&quot;</span>: <span class="hljs-number">5</span>, <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">1e-2</span>}
accelerator.init_trackers(<span class="hljs-string">&quot;my_project&quot;</span>, config=hps)`,wrap:!1}}),$=new j({props:{code:"YWNjZWxlcmF0b3IubG9nKCU3QiUyMnRyYWluX2xvc3MlMjIlM0ElMjAxLjEyJTJDJTIwJTIydmFsaWRfbG9zcyUyMiUzQSUyMDAuOCU3RCUyQyUyMHN0ZXAlM0QxKQ==",highlighted:'accelerator.log({<span class="hljs-string">&quot;train_loss&quot;</span>: <span class="hljs-number">1.12</span>, <span class="hljs-string">&quot;valid_loss&quot;</span>: <span class="hljs-number">0.8</span>}, step=<span class="hljs-number">1</span>)',wrap:!1}}),v=new j({props:{code:"YWNjZWxlcmF0b3IuZW5kX3RyYWluaW5nKCk=",highlighted:"accelerator.end_training()",wrap:!1}}),W=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlMjJhbGwlMjIpJTBBY29uZmlnJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIybnVtX2l0ZXJhdGlvbnMlMjIlM0ElMjA1JTJDJTBBJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTIlMkMlMEElMjAlMjAlMjAlMjAlMjJsb3NzX2Z1bmN0aW9uJTIyJTNBJTIwc3RyKG15X2xvc3NfZnVuY3Rpb24pJTJDJTBBJTdEJTBBJTBBYWNjZWxlcmF0b3IuaW5pdF90cmFja2VycyglMjJleGFtcGxlX3Byb2plY3QlMjIlMkMlMjBjb25maWclM0Rjb25maWcpJTBBJTBBbXlfbW9kZWwlMkMlMjBteV9vcHRpbWl6ZXIlMkMlMjBteV90cmFpbmluZ19kYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0ZS5wcmVwYXJlKG15X21vZGVsJTJDJTIwbXlfb3B0aW1pemVyJTJDJTIwbXlfdHJhaW5pbmdfZGF0YWxvYWRlciklMEFkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEFteV9tb2RlbC50byhkZXZpY2UpJTBBJTBBZm9yJTIwaXRlcmF0aW9uJTIwaW4lMjBjb25maWclNUIlMjJudW1faXRlcmF0aW9ucyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMHN0ZXAlMkMlMjBiYXRjaCUyMGluJTIwbXlfdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG15X29wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBteV9tb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG15X2xvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IubG9nKCU3QiUyMnRyYWluaW5nX2xvc3MlMjIlM0ElMjBsb3NzJTdEJTJDJTIwc3RlcCUzRHN0ZXApJTBBYWNjZWxlcmF0b3IuZW5kX3RyYWluaW5nKCk=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator(log_with=<span class="hljs-string">&quot;all&quot;</span>)
config = {
    <span class="hljs-string">&quot;num_iterations&quot;</span>: <span class="hljs-number">5</span>,
    <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">1e-2</span>,
    <span class="hljs-string">&quot;loss_function&quot;</span>: <span class="hljs-built_in">str</span>(my_loss_function),
}

accelerator.init_trackers(<span class="hljs-string">&quot;example_project&quot;</span>, config=config)

my_model, my_optimizer, my_training_dataloader = accelerate.prepare(my_model, my_optimizer, my_training_dataloader)
device = accelerator.device
my_model.to(device)

<span class="hljs-keyword">for</span> iteration <span class="hljs-keyword">in</span> config[<span class="hljs-string">&quot;num_iterations&quot;</span>]:
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> my_training_dataloader:
        my_optimizer.zero_grad()
        inputs, targets = batch
        inputs = inputs.to(device)
        targets = targets.to(device)
        outputs = my_model(inputs)
        loss = my_loss_function(outputs, targets)
        accelerator.backward(loss)
        my_optimizer.step()
        accelerator.log({<span class="hljs-string">&quot;training_loss&quot;</span>: loss}, step=step)
accelerator.end_training()`,wrap:!1}}),X=new j({props:{code:"YWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihsb2dfd2l0aCUzRCUyMnRlbnNvcmJvYXJkJTIyJTJDJTIwcHJvamVjdF9kaXIlM0QlMjIuJTIyKSUwQSUwQSUyMyUyMHVzZSUyMHdpdGglMjBQcm9qZWN0Q29uZmlndXJhdGlvbiUwQWNvbmZpZyUyMCUzRCUyMFByb2plY3RDb25maWd1cmF0aW9uKHByb2plY3RfZGlyJTNEJTIyLiUyMiUyQyUyMGxvZ2dpbmdfZGlyJTNEJTIyYW5vdGhlciUyRmRpcmVjdG9yeSUyMiklMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKGxvZ193aXRoJTNEJTIydGVuc29yYm9hcmQlMjIlMkMlMjBwcm9qZWN0X2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`accelerator = Accelerator(log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>, project_dir=<span class="hljs-string">&quot;.&quot;</span>)

<span class="hljs-comment"># use with ProjectConfiguration</span>
config = ProjectConfiguration(project_dir=<span class="hljs-string">&quot;.&quot;</span>, logging_dir=<span class="hljs-string">&quot;another/directory&quot;</span>)
accelerator = Accelerator(log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>, project_config=config)`,wrap:!1}}),Y=new re({props:{title:"Implementing Custom Trackers",local:"implementing-custom-trackers",headingTag:"h2"}}),N=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudHJhY2tpbmclMjBpbXBvcnQlMjBHZW5lcmFsVHJhY2tlciUyQyUyMG9uX21haW5fcHJvY2VzcyUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUwQSUwQWltcG9ydCUyMHdhbmRiJTBBJTBBJTBBY2xhc3MlMjBNeUN1c3RvbVRyYWNrZXIoR2VuZXJhbFRyYWNrZXIpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMndhbmRiJTIyJTBBJTIwJTIwJTIwJTIwcmVxdWlyZXNfbG9nZ2luZ19kaXJlY3RvcnklMjAlM0QlMjBGYWxzZSUwQSUwQSUyMCUyMCUyMCUyMCU0MG9uX21haW5fcHJvY2VzcyUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBydW5fbmFtZSUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnJ1bl9uYW1lJTIwJTNEJTIwcnVuX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBydW4lMjAlM0QlMjB3YW5kYi5pbml0KHNlbGYucnVuX25hbWUpJTBBJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjB0cmFja2VyKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5ydW4ucnVuJTBBJTBBJTIwJTIwJTIwJTIwJTQwb25fbWFpbl9wcm9jZXNzJTBBJTIwJTIwJTIwJTIwZGVmJTIwc3RvcmVfaW5pdF9jb25maWd1cmF0aW9uKHNlbGYlMkMlMjB2YWx1ZXMlM0ElMjBkaWN0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdhbmRiLmNvbmZpZyh2YWx1ZXMpJTBBJTBBJTIwJTIwJTIwJTIwJTQwb25fbWFpbl9wcm9jZXNzJTBBJTIwJTIwJTIwJTIwZGVmJTIwbG9nKHNlbGYlMkMlMjB2YWx1ZXMlM0ElMjBkaWN0JTJDJTIwc3RlcCUzQSUyME9wdGlvbmFsJTVCaW50JTVEJTIwJTNEJTIwTm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3YW5kYi5sb2codmFsdWVzJTJDJTIwc3RlcCUzRHN0ZXAp",highlighted:`<span class="hljs-keyword">from</span> accelerate.tracking <span class="hljs-keyword">import</span> GeneralTracker, on_main_process
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">import</span> wandb


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomTracker</span>(<span class="hljs-title class_ inherited__">GeneralTracker</span>):
    name = <span class="hljs-string">&quot;wandb&quot;</span>
    requires_logging_directory = <span class="hljs-literal">False</span>

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, run_name: <span class="hljs-built_in">str</span></span>):
        self.run_name = run_name
        run = wandb.init(self.run_name)

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">tracker</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> self.run.run

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">store_init_configuration</span>(<span class="hljs-params">self, values: <span class="hljs-built_in">dict</span></span>):
        wandb.config(values)

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">log</span>(<span class="hljs-params">self, values: <span class="hljs-built_in">dict</span>, step: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>):
        wandb.log(values, step=step)`,wrap:!1}}),F=new j({props:{code:"dHJhY2tlciUyMCUzRCUyME15Q3VzdG9tVHJhY2tlciglMjJzb21lX3J1bl9uYW1lJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0R0cmFja2VyKQ==",highlighted:`tracker = MyCustomTracker(<span class="hljs-string">&quot;some_run_name&quot;</span>)
accelerator = Accelerator(log_with=tracker)`,wrap:!1}}),z=new j({props:{code:"dHJhY2tlciUyMCUzRCUyME15Q3VzdG9tVHJhY2tlciglMjJzb21lX3J1bl9uYW1lJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlNUJ0cmFja2VyJTJDJTIwJTIyYWxsJTIyJTVEKQ==",highlighted:`tracker = MyCustomTracker(<span class="hljs-string">&quot;some_run_name&quot;</span>)
accelerator = Accelerator(log_with=[tracker, <span class="hljs-string">&quot;all&quot;</span>])`,wrap:!1}}),q=new re({props:{title:"Accessing the internal tracker",local:"accessing-the-internal-tracker",headingTag:"h2"}}),K=new j({props:{code:"d2FuZGJfdHJhY2tlciUyMCUzRCUyMGFjY2VsZXJhdG9yLmdldF90cmFja2VyKCUyMndhbmRiJTIyKQ==",highlighted:'wandb_tracker = accelerator.get_tracker(<span class="hljs-string">&quot;wandb&quot;</span>)',wrap:!1}}),D=new j({props:{code:"d2FuZGJfcnVuLmxvZ19hcnRpZmFjdChzb21lX2FydGlmYWN0X3RvX2xvZyk=",highlighted:"wandb_run.log_artifact(some_artifact_to_log)",wrap:!1}}),J=new Cl({props:{$$slots:{default:[Bl]},$$scope:{ctx:ie}}}),ee=new j({props:{code:"d2FuZGJfdHJhY2tlciUyMCUzRCUyMGFjY2VsZXJhdG9yLmdldF90cmFja2VyKCUyMndhbmRiJTIyJTJDJTIwdW53cmFwJTNEVHJ1ZSklMEFpZiUyMGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUzQSUwQSUyMCUyMCUyMCUyMHdhbmRiX3RyYWNrZXIubG9nX2FydGlmYWN0KHNvbWVfYXJ0aWZhY3RfdG9fbG9nKQ==",highlighted:`wandb_tracker = accelerator.get_tracker(<span class="hljs-string">&quot;wandb&quot;</span>, unwrap=<span class="hljs-literal">True</span>)
<span class="hljs-keyword">if</span> accelerator.is_main_process:
    wandb_tracker.log_artifact(some_artifact_to_log)`,wrap:!1}}),le=new re({props:{title:"When a wrapper cannot work",local:"when-a-wrapper-cannot-work",headingTag:"h2"}}),ae=new j({props:{code:"JTIwJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGltcG9ydCUyMG5lcHR1bmUubmV3JTIwYXMlMjBuZXB0dW5lJTBBJTBBJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTJCJTIwcnVuJTIwJTNEJTIwbmVwdHVuZS5pbml0KC4uLiklMEElMEElMjAlMjBteV9tb2RlbCUyQyUyMG15X29wdGltaXplciUyQyUyMG15X3RyYWluaW5nX2RhdGFsb2FkZXIlMjAlM0QlMjBhY2NlbGVyYXRlLnByZXBhcmUobXlfbW9kZWwlMkMlMjBteV9vcHRpbWl6ZXIlMkMlMjBteV90cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUyMCUyMGRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQSUyMCUyMG15X21vZGVsLnRvKGRldmljZSklMEElMEElMjAlMjBmb3IlMjBpdGVyYXRpb24lMjBpbiUyMGNvbmZpZyU1QiUyMm51bV9pdGVyYXRpb25zJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMG15X3RyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMkMlMjB0YXJnZXRzJTIwJTNEJTIwYmF0Y2glMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbXlfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBteV9sb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvdGFsX2xvc3MlMjAlMkIlM0QlMjBsb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuc3RlcCgpJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBydW4lNUIlMjJsb2dzJTJGdHJhaW5pbmclMkZiYXRjaCUyRmxvc3MlMjIlNUQubG9nKGxvc3Mp",highlighted:`  from accelerate import Accelerator
<span class="hljs-addition">+ import neptune.new as neptune</span>

  accelerator = Accelerator()
<span class="hljs-addition">+ run = neptune.init(...)</span>

  my_model, my_optimizer, my_training_dataloader = accelerate.prepare(my_model, my_optimizer, my_training_dataloader)
  device = accelerator.device
  my_model.to(device)

  for iteration in config[&quot;num_iterations&quot;]:
      for batch in my_training_dataloader:
          my_optimizer.zero_grad()
          inputs, targets = batch
          inputs = inputs.to(device)
          targets = targets.to(device)
          outputs = my_model(inputs)
          loss = my_loss_function(outputs, targets)
          total_loss += loss
          accelerator.backward(loss)
          my_optimizer.step()
<span class="hljs-addition">+         if accelerator.is_main_process:</span>
<span class="hljs-addition">+             run[&quot;logs/training/batch/loss&quot;].log(loss)</span>`,wrap:!1}}),se=new kl({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/tracking.md"}}),{c(){u=r("meta"),w=s(),T=r("p"),ce=s(),c(h.$$.fragment),oe=s(),b=r("p"),b.innerHTML=Ke,pe=s(),c(f.$$.fragment),Me=s(),U=r("p"),U.innerHTML=Pe,me=s(),I=r("ul"),I.innerHTML=De,de=s(),g=r("p"),g.innerHTML=Oe,ye=s(),c(_.$$.fragment),ue=s(),C=r("p"),C.innerHTML=el,je=s(),c(k.$$.fragment),we=s(),B=r("p"),B.innerHTML=ll,Je=s(),c($.$$.fragment),Te=s(),A=r("p"),A.innerHTML=tl,he=s(),c(v.$$.fragment),be=s(),Z=r("p"),Z.textContent=al,fe=s(),c(W.$$.fragment),Ue=s(),G=r("p"),G.innerHTML=sl,Ie=s(),c(X.$$.fragment),ge=s(),c(Y.$$.fragment),_e=s(),R=r("p"),R.innerHTML=nl,Ce=s(),V=r("ul"),V.innerHTML=rl,ke=s(),H=r("p"),H.innerHTML=il,Be=s(),Q=r("p"),Q.textContent=cl,$e=s(),c(N.$$.fragment),Ae=s(),x=r("p"),x.innerHTML=ol,ve=s(),c(F.$$.fragment),Ze=s(),E=r("p"),E.innerHTML=pl,We=s(),c(z.$$.fragment),Ge=s(),c(q.$$.fragment),Xe=s(),S=r("p"),S.innerHTML=Ml,Ye=s(),L=r("p"),L.textContent=ml,Re=s(),c(K.$$.fragment),Ve=s(),P=r("p"),P.innerHTML=dl,He=s(),c(D.$$.fragment),Qe=s(),c(J.$$.fragment),Ne=s(),O=r("p"),O.textContent=yl,xe=s(),c(ee.$$.fragment),Fe=s(),c(le.$$.fragment),Ee=s(),te=r("p"),te.innerHTML=ul,ze=s(),c(ae.$$.fragment),qe=s(),c(se.$$.fragment),Se=s(),ne=r("p"),this.h()},l(e){const l=Ul("svelte-u9bgzb",document.head);u=i(l,"META",{name:!0,content:!0}),l.forEach(t),w=n(e),T=i(e,"P",{}),wl(T).forEach(t),ce=n(e),o(h.$$.fragment,e),oe=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1f9d4ma"&&(b.innerHTML=Ke),pe=n(e),o(f.$$.fragment,e),Me=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1v5ew94"&&(U.innerHTML=Pe),me=n(e),I=i(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-1q091fw"&&(I.innerHTML=De),de=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1s812u7"&&(g.innerHTML=Oe),ye=n(e),o(_.$$.fragment,e),ue=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1myr0m3"&&(C.innerHTML=el),je=n(e),o(k.$$.fragment,e),we=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1eivltl"&&(B.innerHTML=ll),Je=n(e),o($.$$.fragment,e),Te=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-2gut8k"&&(A.innerHTML=tl),he=n(e),o(v.$$.fragment,e),be=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-14biqpt"&&(Z.textContent=al),fe=n(e),o(W.$$.fragment,e),Ue=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-q1rwgx"&&(G.innerHTML=sl),Ie=n(e),o(X.$$.fragment,e),ge=n(e),o(Y.$$.fragment,e),_e=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-rvhb9m"&&(R.innerHTML=nl),Ce=n(e),V=i(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-bz1vgf"&&(V.innerHTML=rl),ke=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-gpz3wc"&&(H.innerHTML=il),Be=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1e80qmi"&&(Q.textContent=cl),$e=n(e),o(N.$$.fragment,e),Ae=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-19lwbk8"&&(x.innerHTML=ol),ve=n(e),o(F.$$.fragment,e),Ze=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-13imq9d"&&(E.innerHTML=pl),We=n(e),o(z.$$.fragment,e),Ge=n(e),o(q.$$.fragment,e),Xe=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-159v824"&&(S.innerHTML=Ml),Ye=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-bsc6i9"&&(L.textContent=ml),Re=n(e),o(K.$$.fragment,e),Ve=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-gdcdqr"&&(P.innerHTML=dl),He=n(e),o(D.$$.fragment,e),Qe=n(e),o(J.$$.fragment,e),Ne=n(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-8mhpnh"&&(O.textContent=yl),xe=n(e),o(ee.$$.fragment,e),Fe=n(e),o(le.$$.fragment,e),Ee=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-e74pz9"&&(te.innerHTML=ul),ze=n(e),o(ae.$$.fragment,e),qe=n(e),o(se.$$.fragment,e),Se=n(e),ne=i(e,"P",{}),wl(ne).forEach(t),this.h()},h(){Jl(u,"name","hf:doc:metadata"),Jl(u,"content",Al)},m(e,l){Il(document.head,u),a(e,w,l),a(e,T,l),a(e,ce,l),M(h,e,l),a(e,oe,l),a(e,b,l),a(e,pe,l),M(f,e,l),a(e,Me,l),a(e,U,l),a(e,me,l),a(e,I,l),a(e,de,l),a(e,g,l),a(e,ye,l),M(_,e,l),a(e,ue,l),a(e,C,l),a(e,je,l),M(k,e,l),a(e,we,l),a(e,B,l),a(e,Je,l),M($,e,l),a(e,Te,l),a(e,A,l),a(e,he,l),M(v,e,l),a(e,be,l),a(e,Z,l),a(e,fe,l),M(W,e,l),a(e,Ue,l),a(e,G,l),a(e,Ie,l),M(X,e,l),a(e,ge,l),M(Y,e,l),a(e,_e,l),a(e,R,l),a(e,Ce,l),a(e,V,l),a(e,ke,l),a(e,H,l),a(e,Be,l),a(e,Q,l),a(e,$e,l),M(N,e,l),a(e,Ae,l),a(e,x,l),a(e,ve,l),M(F,e,l),a(e,Ze,l),a(e,E,l),a(e,We,l),M(z,e,l),a(e,Ge,l),M(q,e,l),a(e,Xe,l),a(e,S,l),a(e,Ye,l),a(e,L,l),a(e,Re,l),M(K,e,l),a(e,Ve,l),a(e,P,l),a(e,He,l),M(D,e,l),a(e,Qe,l),M(J,e,l),a(e,Ne,l),a(e,O,l),a(e,xe,l),M(ee,e,l),a(e,Fe,l),M(le,e,l),a(e,Ee,l),a(e,te,l),a(e,ze,l),M(ae,e,l),a(e,qe,l),M(se,e,l),a(e,Se,l),a(e,ne,l),Le=!0},p(e,[l]){const jl={};l&2&&(jl.$$scope={dirty:l,ctx:e}),J.$set(jl)},i(e){Le||(m(h.$$.fragment,e),m(f.$$.fragment,e),m(_.$$.fragment,e),m(k.$$.fragment,e),m($.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(F.$$.fragment,e),m(z.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(D.$$.fragment,e),m(J.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(se.$$.fragment,e),Le=!0)},o(e){d(h.$$.fragment,e),d(f.$$.fragment,e),d(_.$$.fragment,e),d(k.$$.fragment,e),d($.$$.fragment,e),d(v.$$.fragment,e),d(W.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(D.$$.fragment,e),d(J.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),Le=!1},d(e){e&&(t(w),t(T),t(ce),t(oe),t(b),t(pe),t(Me),t(U),t(me),t(I),t(de),t(g),t(ye),t(ue),t(C),t(je),t(we),t(B),t(Je),t(Te),t(A),t(he),t(be),t(Z),t(fe),t(Ue),t(G),t(Ie),t(ge),t(_e),t(R),t(Ce),t(V),t(ke),t(H),t(Be),t(Q),t($e),t(Ae),t(x),t(ve),t(Ze),t(E),t(We),t(Ge),t(Xe),t(S),t(Ye),t(L),t(Re),t(Ve),t(P),t(He),t(Qe),t(Ne),t(O),t(xe),t(Fe),t(Ee),t(te),t(ze),t(qe),t(Se),t(ne)),t(u),y(h,e),y(f,e),y(_,e),y(k,e),y($,e),y(v,e),y(W,e),y(X,e),y(Y,e),y(N,e),y(F,e),y(z,e),y(q,e),y(K,e),y(D,e),y(J,e),y(ee,e),y(le,e),y(ae,e),y(se,e)}}}const Al='{"title":"Tracking","local":"tracking","sections":[{"title":"Integrated Trackers","local":"integrated-trackers","sections":[],"depth":2},{"title":"Implementing Custom Trackers","local":"implementing-custom-trackers","sections":[],"depth":2},{"title":"Accessing the internal tracker","local":"accessing-the-internal-tracker","sections":[],"depth":2},{"title":"When a wrapper cannot work","local":"when-a-wrapper-cannot-work","sections":[],"depth":2}],"depth":1}';function vl(ie){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends bl{constructor(u){super(),fl(this,u,vl,$l,Tl,{})}}export{Rl as component};
