import{s as Bl,f as Gl,n as Al,o as $l}from"../chunks/scheduler.889ebb13.js";import{S as Vl,i as Xl,g as o,s as n,r as M,A as xl,h as i,f as l,c as a,j as Zl,u as p,x as r,k as Ce,y as Hl,a as s,v as h,d as c,t as u,w as y}from"../chunks/index.ca18042b.js";import{C as Ie}from"../chunks/CodeBlock.1db71023.js";import{C as Wl}from"../chunks/CourseFloatingBanner.bff79cca.js";import{H as d}from"../chunks/Heading.3daa581c.js";import{E as Rl}from"../chunks/EditOnGithub.2e95618d.js";function _l(St){let m,Ze,ve,Be,g,Ae,T,$e,w,kt='As we explored in <a href="https://huggingface.co/learn/agents-course/unit1/tools" rel="nofollow">unit 1</a>, agents use tools to perform various actions. In <code>smolagents</code>, tools are treated as <strong>functions that an LLM can call within an agent system</strong>.',Ve,J,Qt="To interact with a tool, the LLM needs an <strong>interface description</strong> with these key components:",Xe,f,Et="<li><strong>Name</strong>: What the tool is called</li> <li><strong>Tool description</strong>: What the tool does</li> <li><strong>Input types and descriptions</strong>: What arguments the tool accepts</li> <li><strong>Output type</strong>: What the tool returns</li>",xe,U,Nt="For instance, while preparing for a party at Wayne Manor, Alfred needs various tools to gather information - from searching for catering services to finding party theme ideas. Here’s how a simple search tool interface might look:",He,j,Ft="<li><strong>Name:</strong> <code>web_search</code></li> <li><strong>Tool description:</strong> Searches the web for specific queries</li> <li><strong>Input:</strong> <code>query</code> (string) - The search term to look up</li> <li><strong>Output:</strong> String containing the search results</li>",We,b,Lt="By using these tools, Alfred can make informed decisions and gather all the information needed for planning the perfect party.",Re,C,Yt="Below, you can see an animation illustrating how a tool call is managed:",_e,I,qt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Agentic pipeline from https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',Se,v,ke,G,zt="In <code>smolagents</code>, tools can be defined in two ways:",Qe,Z,Pt="<li><strong>Using the <code>@tool</code> decorator</strong> for simple function-based tools</li> <li><strong>Creating a subclass of <code>Tool</code></strong> for more complex functionality</li>",Ee,B,Ne,A,Dt="The <code>@tool</code> decorator is the <strong>recommended way to define simple tools</strong>. Under the hood, smolagents will parse basic information about the function from Python. So if you name you function clearly and a good docstring, it will be easier for the LLM to use.",Fe,$,Kt="Using this approach, we define a function with:",Le,V,Ot="<li><strong>A clear and descriptive function name</strong> that helps the LLM understand its purpose.</li> <li><strong>Type hints for both inputs and outputs</strong> to ensure proper usage.</li> <li><strong>A detailed description</strong>, including an <code>Args:</code> section where each argument is explicitly described. These descriptions provide valuable context for the LLM, so it’s important to write them carefully.</li>",Ye,X,qe,x,el,ze,H,tl="Let’s imagine that Alfred has already decided on the menu for the party, but now he needs help preparing food for such a large number of guests. To do so, he would like to hire a catering service and needs to identify the highest-rated options available. Alfred can leverage a tool to search for the best catering services in his area.",Pe,W,ll="Below is an example of how Alfred can use the <code>@tool</code> decorator to make this happen:",De,R,Ke,_,Oe,S,sl='This approach involves creating a subclass of <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>.  For complex tools, we can implement a class instead of a Python function. The class wraps the function with metadata that helps the LLM understand how to use it effectively. In this class, we define:',et,k,nl="<li><code>name</code>: The tool’s name.</li> <li><code>description</code>: A description used to populate the agent’s system prompt.</li> <li><code>inputs</code>: A dictionary with keys <code>type</code> and <code>description</code>, providing information to help the Python interpreter process inputs.</li> <li><code>output_type</code>: Specifies the expected output type.</li> <li><code>forward</code>: The method containing the inference logic to execute.</li>",tt,Q,al="Below, we can see an example of a tool built using <code>Tool</code> and to integrate it within a <code>CodeAgent</code>.",lt,E,st,N,ol="Alfred’s party at the mansion is a <strong>superhero-themed event</strong>, but he needs some creative ideas to make it truly special. As a fantastic host, he wants to surprise the guests with a unique theme.",nt,F,il="To do this, he can use an agent that generates superhero-themed party ideas based on a given category. This way, Alfred can find the perfect party theme to wow his guests.",at,L,ot,Y,rl="With this tool, Alfred will be the ultimate super host, impressing his guests with a superhero-themed party they won’t forget! 🦸‍♂️🦸‍♀️",it,q,rt,z,Ml='<code>smolagents</code> comes with a set of pre-built tools that can be directly injected into your agent. The <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">default toolbox</a> includes:',Mt,P,pl="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",pt,D,hl="Alfred could use various tools to ensure a flawless party at Wayne Manor:",ht,K,cl="<li><p>First, he could use the <code>DuckDuckGoSearchTool</code> to find creative superhero-themed party ideas.</p></li> <li><p>For catering, he’d rely on the <code>GoogleSearchTool</code> to find the highest-rated services in Gotham.</p></li> <li><p>To manage seating arrangements, Alfred could run calculations with the <code>PythonInterpreterTool</code>.</p></li> <li><p>Once everything is gathered, he’d compile the plan using the <code>FinalAnswerTool</code>.</p></li> <li><p>Lastly, the <code>VisitWebpageTool</code> would keep him updated on any changes, ensuring a smooth event.</p></li>",ct,O,ul="With these tools, Alfred guarantees the party is both exceptional and seamless. 🦇💡",ut,ee,yl,yt,te,dt,le,dl="One of the most powerful features of <strong>smolagents</strong> is its ability to share custom tools on the Hub and seamlessly integrate tools created by the community. This includes connecting with <strong>HF Spaces</strong> and <strong>LangChain tools</strong>, significantly enhancing Alfred’s ability to orchestrate an unforgettable party at Wayne Manor. 🎭",mt,se,ml="With these integrations, Alfred can tap into advanced event-planning tools—whether it’s adjusting the lighting for the perfect ambiance, curating the ideal playlist for the party, or coordinating with Gotham’s finest caterers.",gt,ne,gl="Here are examples showcasing how these functionalities can elevate the party experience:",Tt,ae,wt,oe,Tl="Sharing your custom tool with the community is easy! Simply upload it to your Hugging Face account using the <code>push_to_hub()</code> method.",Jt,ie,wl="For instance, Alfred can share his <code>catering_service_tool</code> to help others find the best catering services in Gotham. Here’s how to do it:",ft,re,Ut,Me,jt,pe,Jl="You can easily import tools created by other users using the <code>load_tool()</code> function. For example, Alfred might want to generate a promotional image for the party using AI. Instead of building a tool from scratch, he can leverage a predefined one from the community:",bt,he,Ct,ce,It,ue,fl="You can also import a HF Space as a tool using <code>Tool.from_space()</code>. This opens up possibilities for integrating with thousands of spaces from the community for tasks from image generation to data analysis.",vt,ye,Ul="The tool will connect with the spaces Gradio backend using the <code>gradio_client</code>, so make sure to install it via <code>pip</code> if you don’t have it already. For the party, Alfred can also use a HF Space directly for the generation of the previous annoucement AI-generated image. Let’s build it!",Gt,de,Zt,me,Bt,ge,jl="You can easily load LangChain tools using the <code>Tool.from_langchain()</code> method. Alfred, ever the perfectionist, is preparing for a spectacular superhero night at Wayne Manor while the Waynes are away. To make sure every detail exceeds expectations, he taps into LangChain tools to find top-tier entertainment ideas.",At,Te,bl="By using <code>Tool.from_langchain()</code>, Alfred effortlessly adds advanced search functionalities to his smolagent, enabling him to discover exclusive party ideas and services with just a few commands.",$t,we,Cl="Here’s how he does it:",Vt,Je,Xt,fe,Il="With this setup, Alfred can quickly discover luxurious entertainment options, ensuring Gotham’s elite guests have an unforgettable experience. This tool helps him curate the perfect superhero-themed event for Wayne Manor! 🎉",xt,Ue,Ht,je,vl='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tools Tutorial</a> - Explore this tutorial to learn how to work with tools effectively.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Tools Documentation</a> - Comprehensive reference documentation on tools.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Tools Guided Tour</a> - A step-by-step guided tour to help you build and utilize tools efficiently.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Building Effective Agents</a> - A detailed guide on best practices for developing reliable and high-performance custom function agents.</li>',Wt,be,Rt,Ge,_t;return g=new Wl({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/unit2/smolagents/smolagents_tools.ipynb"}]}}),T=new d({props:{title:"Tools",local:"tools",headingTag:"h1"}}),v=new d({props:{title:"Tool Creation Methods",local:"tool-creation-methods",headingTag:"h2"}}),B=new d({props:{title:"The @tool Decorator",local:"the-tool-decorator",headingTag:"h3"}}),X=new d({props:{title:"Generating a tool that retrieves the highest-rated catering",local:"generating-a-tool-that-retrieves-the-highest-rated-catering",headingTag:"h4"}}),R=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, tool

<span class="hljs-comment"># Let&#x27;s pretend we have a function that fetches the highest-rated catering services.</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.
    
    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=HfApiModel())

<span class="hljs-comment"># Run the agent to find the best catering service</span>
result = agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the highest-rated catering service in Gotham City?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Output: Gotham Catering Co.</span>`,wrap:!1}}),_=new d({props:{title:"Defining a Tool as a Python Class",local:"defining-a-tool-as-a-python-class",headingTag:"h3"}}),E=new d({props:{title:"Generating a tool to generate ideas about the superhero-themed party",local:"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party",headingTag:"h4"}}),L=new Ie({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTJDJTIwQ29kZUFnZW50JTJDJTIwSGZBcGlNb2RlbCUwQSUwQWNsYXNzJTIwU3VwZXJoZXJvUGFydHlUaGVtZVRvb2woVG9vbCklM0ElMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwJTIyc3VwZXJoZXJvX3BhcnR5X3RoZW1lX2dlbmVyYXRvciUyMiUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwVGhpcyUyMHRvb2wlMjBzdWdnZXN0cyUyMGNyZWF0aXZlJTIwc3VwZXJoZXJvLXRoZW1lZCUyMHBhcnR5JTIwaWRlYXMlMjBiYXNlZCUyMG9uJTIwYSUyMGNhdGVnb3J5LiUwQSUyMCUyMCUyMCUyMEl0JTIwcmV0dXJucyUyMGElMjB1bmlxdWUlMjBwYXJ0eSUyMHRoZW1lJTIwaWRlYS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMlRoZSUyMHR5cGUlMjBvZiUyMHN1cGVyaGVybyUyMHBhcnR5JTIwKGUuZy4lMkMlMjAnY2xhc3NpYyUyMGhlcm9lcyclMkMlMjAndmlsbGFpbiUyMG1hc3F1ZXJhZGUnJTJDJTIwJ2Z1dHVyaXN0aWMlMjBHb3RoYW0nKS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUyMCUzRCUyMCUyMnN0cmluZyUyMiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGNhdGVnb3J5JTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRoZW1lcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNsYXNzaWMlMjBoZXJvZXMlMjIlM0ElMjAlMjJKdXN0aWNlJTIwTGVhZ3VlJTIwR2FsYSUzQSUyMEd1ZXN0cyUyMGNvbWUlMjBkcmVzc2VkJTIwYXMlMjB0aGVpciUyMGZhdm9yaXRlJTIwREMlMjBoZXJvZXMlMjB3aXRoJTIwdGhlbWVkJTIwY29ja3RhaWxzJTIwbGlrZSUyMCdUaGUlMjBLcnlwdG9uaXRlJTIwUHVuY2gnLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpbGxhaW4lMjBtYXNxdWVyYWRlJTIyJTNBJTIwJTIyR290aGFtJTIwUm9ndWVzJyUyMEJhbGwlM0ElMjBBJTIwbXlzdGVyaW91cyUyMG1hc3F1ZXJhZGUlMjB3aGVyZSUyMGd1ZXN0cyUyMGRyZXNzJTIwYXMlMjBjbGFzc2ljJTIwQmF0bWFuJTIwdmlsbGFpbnMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZnV0dXJpc3RpYyUyMEdvdGhhbSUyMiUzQSUyMCUyMk5lby1Hb3RoYW0lMjBOaWdodCUzQSUyMEElMjBjeWJlcnB1bmstc3R5bGUlMjBwYXJ0eSUyMGluc3BpcmVkJTIwYnklMjBCYXRtYW4lMjBCZXlvbmQlMkMlMjB3aXRoJTIwbmVvbiUyMGRlY29yYXRpb25zJTIwYW5kJTIwZnV0dXJpc3RpYyUyMGdhZGdldHMuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGhlbWVzLmdldChjYXRlZ29yeS5sb3dlcigpJTJDJTIwJTIyVGhlbWVkJTIwcGFydHklMjBpZGVhJTIwbm90JTIwZm91bmQuJTIwVHJ5JTIwJ2NsYXNzaWMlMjBoZXJvZXMnJTJDJTIwJ3ZpbGxhaW4lMjBtYXNxdWVyYWRlJyUyQyUyMG9yJTIwJ2Z1dHVyaXN0aWMlMjBHb3RoYW0nLiUyMiklMEElMEElMjMlMjBJbnN0YW50aWF0ZSUyMHRoZSUyMHRvb2wlMEFwYXJ0eV90aGVtZV90b29sJTIwJTNEJTIwU3VwZXJoZXJvUGFydHlUaGVtZVRvb2woKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCcGFydHlfdGhlbWVfdG9vbCU1RCUyQyUyMG1vZGVsJTNESGZBcGlNb2RlbCgpKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGFnZW50JTIwdG8lMjBnZW5lcmF0ZSUyMGElMjBwYXJ0eSUyMHRoZW1lJTIwaWRlYSUwQXJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwd291bGQlMjBiZSUyMGElMjBnb29kJTIwc3VwZXJoZXJvJTIwcGFydHklMjBpZGVhJTIwZm9yJTIwYSUyMCd2aWxsYWluJTIwbWFzcXVlcmFkZSclMjB0aGVtZSUzRiUyMiUwQSklMEElMEFwcmludChyZXN1bHQpJTIwJTIwJTIzJTIwT3V0cHV0JTNBJTIwJTIyR290aGFtJTIwUm9ndWVzJyUyMEJhbGwlM0ElMjBBJTIwbXlzdGVyaW91cyUyMG1hc3F1ZXJhZGUlMjB3aGVyZSUyMGd1ZXN0cyUyMGRyZXNzJTIwYXMlMjBjbGFzc2ljJTIwQmF0bWFuJTIwdmlsbGFpbnMuJTIy",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, HfApiModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)

<span class="hljs-comment"># Instantiate the tool</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=HfApiModel())

<span class="hljs-comment"># Run the agent to generate a party theme idea</span>
result = agent.run(
    <span class="hljs-string">&quot;What would be a good superhero party idea for a &#x27;villain masquerade&#x27; theme?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Output: &quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>`,wrap:!1}}),q=new d({props:{title:"Default Toolbox",local:"default-toolbox",headingTag:"h2"}}),te=new d({props:{title:"Sharing and Importing Tools",local:"sharing-and-importing-tools",headingTag:"h2"}}),ae=new d({props:{title:"Sharing a Tool to the Hub",local:"sharing-a-tool-to-the-hub",headingTag:"h3"}}),re=new Ie({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGY2F0ZXJpbmdfc2VydmljZV90b29sJTIyJTJDJTIwdG9rZW4lM0QlMjIlM0NZT1VSX0hVR0dJTkdGQUNFSFVCX0FQSV9UT0tFTiUzRSUyMik=",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/catering_service_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),Me=new d({props:{title:"Importing a Tool from the Hub",local:"importing-a-tool-from-the-hub",headingTag:"h3"}}),he=new Ie({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMm0tcmljJTJGdGV4dC10by1pbWFnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUwQSklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESGZBcGlNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGElMjBsdXh1cmlvdXMlMjBzdXBlcmhlcm8tdGhlbWVkJTIwcGFydHklMjBhdCUyMFdheW5lJTIwTWFub3IlMjB3aXRoJTIwbWFkZS11cCUyMHN1cGVyaGVyb3MuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, HfApiModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=HfApiModel()
)

agent.run(<span class="hljs-string">&quot;Generate an image of a luxurious superhero-themed party at Wayne Manor with made-up superheros.&quot;</span>)`,wrap:!1}}),ce=new d({props:{title:"Importing a Hugging Face Space as a Tool",local:"importing-a-hugging-face-space-as-a-tool",headingTag:"h3"}}),de=new Ie({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwVG9vbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9zcGFjZSglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmltYWdlX2dlbmVyYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyR2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwZnJvbSUyMGElMjBwcm9tcHQlMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hcmdzJTNEJTdCJ3VzZXJfcHJvbXB0JyUzQSUyMCdBJTIwZ3JhbmQlMjBzdXBlcmhlcm8tdGhlbWVkJTIwcGFydHklMjBhdCUyMFdheW5lJTIwTWFub3IlMkMlMjB3aXRoJTIwQWxmcmVkJTIwb3ZlcnNlZWluZyUyMGElMjBsdXh1cmlvdXMlMjBnYWxhJyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, 
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A grand superhero-themed party at Wayne Manor, with Alfred overseeing a luxurious gala&#x27;</span>}
)`,wrap:!1}}),me=new d({props:{title:"Importing a LangChain Tool",local:"importing-a-langchain-tool",headingTag:"h3"}}),Je=new Ie({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwVG9vbCUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwVG9vbC5mcm9tX2xhbmdjaGFpbihsb2FkX3Rvb2xzKCU1QiUyMnNlcnBhcGklMjIlNUQpJTVCMCU1RCklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTIyU2VhcmNoJTIwZm9yJTIwbHV4dXJ5JTIwZW50ZXJ0YWlubWVudCUyMGlkZWFzJTIwZm9yJTIwYSUyMHN1cGVyaGVyby10aGVtZWQlMjBldmVudCUyQyUyMHN1Y2glMjBhcyUyMGxpdmUlMjBwZXJmb3JtYW5jZXMlMjBhbmQlMjBpbnRlcmFjdGl2ZSUyMGV4cGVyaWVuY2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Search for luxury entertainment ideas for a superhero-themed event, such as live performances and interactive experiences.&quot;</span>)`,wrap:!1}}),Ue=new d({props:{title:"Resources",local:"resources",headingTag:"h2"}}),be=new Rl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/tools.mdx"}}),{c(){m=o("meta"),Ze=n(),ve=o("p"),Be=n(),M(g.$$.fragment),Ae=n(),M(T.$$.fragment),$e=n(),w=o("p"),w.innerHTML=kt,Ve=n(),J=o("p"),J.innerHTML=Qt,Xe=n(),f=o("ul"),f.innerHTML=Et,xe=n(),U=o("p"),U.textContent=Nt,He=n(),j=o("ul"),j.innerHTML=Ft,We=n(),b=o("p"),b.textContent=Lt,Re=n(),C=o("p"),C.textContent=Yt,_e=n(),I=o("p"),I.innerHTML=qt,Se=n(),M(v.$$.fragment),ke=n(),G=o("p"),G.innerHTML=zt,Qe=n(),Z=o("ol"),Z.innerHTML=Pt,Ee=n(),M(B.$$.fragment),Ne=n(),A=o("p"),A.innerHTML=Dt,Fe=n(),$=o("p"),$.textContent=Kt,Le=n(),V=o("ul"),V.innerHTML=Ot,Ye=n(),M(X.$$.fragment),qe=n(),x=o("img"),ze=n(),H=o("p"),H.textContent=tl,Pe=n(),W=o("p"),W.innerHTML=ll,De=n(),M(R.$$.fragment),Ke=n(),M(_.$$.fragment),Oe=n(),S=o("p"),S.innerHTML=sl,et=n(),k=o("ul"),k.innerHTML=nl,tt=n(),Q=o("p"),Q.innerHTML=al,lt=n(),M(E.$$.fragment),st=n(),N=o("p"),N.innerHTML=ol,nt=n(),F=o("p"),F.textContent=il,at=n(),M(L.$$.fragment),ot=n(),Y=o("p"),Y.textContent=rl,it=n(),M(q.$$.fragment),rt=n(),z=o("p"),z.innerHTML=Ml,Mt=n(),P=o("ul"),P.innerHTML=pl,pt=n(),D=o("p"),D.textContent=hl,ht=n(),K=o("ul"),K.innerHTML=cl,ct=n(),O=o("p"),O.textContent=ul,ut=n(),ee=o("img"),yt=n(),M(te.$$.fragment),dt=n(),le=o("p"),le.innerHTML=dl,mt=n(),se=o("p"),se.textContent=ml,gt=n(),ne=o("p"),ne.textContent=gl,Tt=n(),M(ae.$$.fragment),wt=n(),oe=o("p"),oe.innerHTML=Tl,Jt=n(),ie=o("p"),ie.innerHTML=wl,ft=n(),M(re.$$.fragment),Ut=n(),M(Me.$$.fragment),jt=n(),pe=o("p"),pe.innerHTML=Jl,bt=n(),M(he.$$.fragment),Ct=n(),M(ce.$$.fragment),It=n(),ue=o("p"),ue.innerHTML=fl,vt=n(),ye=o("p"),ye.innerHTML=Ul,Gt=n(),M(de.$$.fragment),Zt=n(),M(me.$$.fragment),Bt=n(),ge=o("p"),ge.innerHTML=jl,At=n(),Te=o("p"),Te.innerHTML=bl,$t=n(),we=o("p"),we.textContent=Cl,Vt=n(),M(Je.$$.fragment),Xt=n(),fe=o("p"),fe.textContent=Il,xt=n(),M(Ue.$$.fragment),Ht=n(),je=o("ul"),je.innerHTML=vl,Wt=n(),M(be.$$.fragment),Rt=n(),Ge=o("p"),this.h()},l(e){const t=xl("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ze=a(e),ve=i(e,"P",{}),Zl(ve).forEach(l),Be=a(e),p(g.$$.fragment,e),Ae=a(e),p(T.$$.fragment,e),$e=a(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1jitbbr"&&(w.innerHTML=kt),Ve=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1d4nuf8"&&(J.innerHTML=Qt),Xe=a(e),f=i(e,"UL",{"data-svelte-h":!0}),r(f)!=="svelte-dlnk8z"&&(f.innerHTML=Et),xe=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-xxdm5o"&&(U.textContent=Nt),He=a(e),j=i(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1y8sxu4"&&(j.innerHTML=Ft),We=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1s1gqsf"&&(b.textContent=Lt),Re=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-gwhed0"&&(C.textContent=Yt),_e=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1j9zfgm"&&(I.innerHTML=qt),Se=a(e),p(v.$$.fragment,e),ke=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1yodl19"&&(G.innerHTML=zt),Qe=a(e),Z=i(e,"OL",{"data-svelte-h":!0}),r(Z)!=="svelte-1idspfm"&&(Z.innerHTML=Pt),Ee=a(e),p(B.$$.fragment,e),Ne=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1pvs615"&&(A.innerHTML=Dt),Fe=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1u61w3i"&&($.textContent=Kt),Le=a(e),V=i(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-r6zbcf"&&(V.innerHTML=Ot),Ye=a(e),p(X.$$.fragment,e),qe=a(e),x=i(e,"IMG",{src:!0,alt:!0}),ze=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-18bbge7"&&(H.textContent=tl),Pe=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1f9djim"&&(W.innerHTML=ll),De=a(e),p(R.$$.fragment,e),Ke=a(e),p(_.$$.fragment,e),Oe=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-cmtwcn"&&(S.innerHTML=sl),et=a(e),k=i(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-17z09hb"&&(k.innerHTML=nl),tt=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-i76vwl"&&(Q.innerHTML=al),lt=a(e),p(E.$$.fragment,e),st=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1nm801i"&&(N.innerHTML=ol),nt=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1t4n8j6"&&(F.textContent=il),at=a(e),p(L.$$.fragment,e),ot=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-148a819"&&(Y.textContent=rl),it=a(e),p(q.$$.fragment,e),rt=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-10xt16w"&&(z.innerHTML=Ml),Mt=a(e),P=i(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-1pasg00"&&(P.innerHTML=pl),pt=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-13b0t4l"&&(D.textContent=hl),ht=a(e),K=i(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-8qy5vh"&&(K.innerHTML=cl),ct=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-13o2uyy"&&(O.textContent=ul),ut=a(e),ee=i(e,"IMG",{src:!0,alt:!0}),yt=a(e),p(te.$$.fragment,e),dt=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1xcpx7t"&&(le.innerHTML=dl),mt=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-xc6zmk"&&(se.textContent=ml),gt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-fsw72s"&&(ne.textContent=gl),Tt=a(e),p(ae.$$.fragment,e),wt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1cmmx6"&&(oe.innerHTML=Tl),Jt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-zedixg"&&(ie.innerHTML=wl),ft=a(e),p(re.$$.fragment,e),Ut=a(e),p(Me.$$.fragment,e),jt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1v2b8b8"&&(pe.innerHTML=Jl),bt=a(e),p(he.$$.fragment,e),Ct=a(e),p(ce.$$.fragment,e),It=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-11vtciu"&&(ue.innerHTML=fl),vt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-qhg02p"&&(ye.innerHTML=Ul),Gt=a(e),p(de.$$.fragment,e),Zt=a(e),p(me.$$.fragment,e),Bt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-n7r7ow"&&(ge.innerHTML=jl),At=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-sjrzcz"&&(Te.innerHTML=bl),$t=a(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-154co1f"&&(we.textContent=Cl),Vt=a(e),p(Je.$$.fragment,e),Xt=a(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1yv1f1"&&(fe.textContent=Il),xt=a(e),p(Ue.$$.fragment,e),Ht=a(e),je=i(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-1gwl39i"&&(je.innerHTML=vl),Wt=a(e),p(be.$$.fragment,e),Rt=a(e),Ge=i(e,"P",{}),Zl(Ge).forEach(l),this.h()},h(){Ce(m,"name","hf:doc:metadata"),Ce(m,"content",Sl),Gl(x.src,el="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-catering.jpg")||Ce(x,"src",el),Ce(x,"alt","Alfred Catering"),Gl(ee.src,yl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-plan.jpg")||Ce(ee,"src",yl),Ce(ee,"alt","Alfred plan")},m(e,t){Hl(document.head,m),s(e,Ze,t),s(e,ve,t),s(e,Be,t),h(g,e,t),s(e,Ae,t),h(T,e,t),s(e,$e,t),s(e,w,t),s(e,Ve,t),s(e,J,t),s(e,Xe,t),s(e,f,t),s(e,xe,t),s(e,U,t),s(e,He,t),s(e,j,t),s(e,We,t),s(e,b,t),s(e,Re,t),s(e,C,t),s(e,_e,t),s(e,I,t),s(e,Se,t),h(v,e,t),s(e,ke,t),s(e,G,t),s(e,Qe,t),s(e,Z,t),s(e,Ee,t),h(B,e,t),s(e,Ne,t),s(e,A,t),s(e,Fe,t),s(e,$,t),s(e,Le,t),s(e,V,t),s(e,Ye,t),h(X,e,t),s(e,qe,t),s(e,x,t),s(e,ze,t),s(e,H,t),s(e,Pe,t),s(e,W,t),s(e,De,t),h(R,e,t),s(e,Ke,t),h(_,e,t),s(e,Oe,t),s(e,S,t),s(e,et,t),s(e,k,t),s(e,tt,t),s(e,Q,t),s(e,lt,t),h(E,e,t),s(e,st,t),s(e,N,t),s(e,nt,t),s(e,F,t),s(e,at,t),h(L,e,t),s(e,ot,t),s(e,Y,t),s(e,it,t),h(q,e,t),s(e,rt,t),s(e,z,t),s(e,Mt,t),s(e,P,t),s(e,pt,t),s(e,D,t),s(e,ht,t),s(e,K,t),s(e,ct,t),s(e,O,t),s(e,ut,t),s(e,ee,t),s(e,yt,t),h(te,e,t),s(e,dt,t),s(e,le,t),s(e,mt,t),s(e,se,t),s(e,gt,t),s(e,ne,t),s(e,Tt,t),h(ae,e,t),s(e,wt,t),s(e,oe,t),s(e,Jt,t),s(e,ie,t),s(e,ft,t),h(re,e,t),s(e,Ut,t),h(Me,e,t),s(e,jt,t),s(e,pe,t),s(e,bt,t),h(he,e,t),s(e,Ct,t),h(ce,e,t),s(e,It,t),s(e,ue,t),s(e,vt,t),s(e,ye,t),s(e,Gt,t),h(de,e,t),s(e,Zt,t),h(me,e,t),s(e,Bt,t),s(e,ge,t),s(e,At,t),s(e,Te,t),s(e,$t,t),s(e,we,t),s(e,Vt,t),h(Je,e,t),s(e,Xt,t),s(e,fe,t),s(e,xt,t),h(Ue,e,t),s(e,Ht,t),s(e,je,t),s(e,Wt,t),h(be,e,t),s(e,Rt,t),s(e,Ge,t),_t=!0},p:Al,i(e){_t||(c(g.$$.fragment,e),c(T.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c(X.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(E.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(Me.$$.fragment,e),c(he.$$.fragment,e),c(ce.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(be.$$.fragment,e),_t=!0)},o(e){u(g.$$.fragment,e),u(T.$$.fragment,e),u(v.$$.fragment,e),u(B.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(_.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(Me.$$.fragment,e),u(he.$$.fragment,e),u(ce.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(be.$$.fragment,e),_t=!1},d(e){e&&(l(Ze),l(ve),l(Be),l(Ae),l($e),l(w),l(Ve),l(J),l(Xe),l(f),l(xe),l(U),l(He),l(j),l(We),l(b),l(Re),l(C),l(_e),l(I),l(Se),l(ke),l(G),l(Qe),l(Z),l(Ee),l(Ne),l(A),l(Fe),l($),l(Le),l(V),l(Ye),l(qe),l(x),l(ze),l(H),l(Pe),l(W),l(De),l(Ke),l(Oe),l(S),l(et),l(k),l(tt),l(Q),l(lt),l(st),l(N),l(nt),l(F),l(at),l(ot),l(Y),l(it),l(rt),l(z),l(Mt),l(P),l(pt),l(D),l(ht),l(K),l(ct),l(O),l(ut),l(ee),l(yt),l(dt),l(le),l(mt),l(se),l(gt),l(ne),l(Tt),l(wt),l(oe),l(Jt),l(ie),l(ft),l(Ut),l(jt),l(pe),l(bt),l(Ct),l(It),l(ue),l(vt),l(ye),l(Gt),l(Zt),l(Bt),l(ge),l(At),l(Te),l($t),l(we),l(Vt),l(Xt),l(fe),l(xt),l(Ht),l(je),l(Wt),l(Rt),l(Ge)),l(m),y(g,e),y(T,e),y(v,e),y(B,e),y(X,e),y(R,e),y(_,e),y(E,e),y(L,e),y(q,e),y(te,e),y(ae,e),y(re,e),y(Me,e),y(he,e),y(ce,e),y(de,e),y(me,e),y(Je,e),y(Ue,e),y(be,e)}}}const Sl='{"title":"Tools","local":"tools","sections":[{"title":"Tool Creation Methods","local":"tool-creation-methods","sections":[{"title":"The @tool Decorator","local":"the-tool-decorator","sections":[{"title":"Generating a tool that retrieves the highest-rated catering","local":"generating-a-tool-that-retrieves-the-highest-rated-catering","sections":[],"depth":4}],"depth":3},{"title":"Defining a Tool as a Python Class","local":"defining-a-tool-as-a-python-class","sections":[{"title":"Generating a tool to generate ideas about the superhero-themed party","local":"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Default Toolbox","local":"default-toolbox","sections":[],"depth":2},{"title":"Sharing and Importing Tools","local":"sharing-and-importing-tools","sections":[{"title":"Sharing a Tool to the Hub","local":"sharing-a-tool-to-the-hub","sections":[],"depth":3},{"title":"Importing a Tool from the Hub","local":"importing-a-tool-from-the-hub","sections":[],"depth":3},{"title":"Importing a Hugging Face Space as a Tool","local":"importing-a-hugging-face-space-as-a-tool","sections":[],"depth":3},{"title":"Importing a LangChain Tool","local":"importing-a-langchain-tool","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function kl(St){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends Vl{constructor(m){super(),Xl(this,m,kl,_l,Bl,{})}}export{ql as component};
