import{s as ms,n as ys,o as us}from"../chunks/scheduler.65852ee5.js";import{S as ds,i as ws,g as i,s as n,r,A as Js,h as o,f as s,c as a,j as fe,u as c,x as p,k as Ie,y as js,a as l,v as M,d as h,t as m,w as y}from"../chunks/index.aa74147d.js";import{D as Ts,C as u}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as d,E as Us}from"../chunks/EditOnGithub.4eda6a96.js";function bs(_t){let w,Be,be,Ce,J,Ze,j,Ge,T,Rt='<em>Authored by: <a href="https://huggingface.co/andrewrreed" rel="nofollow">Andrew Reed</a></em>',ve,U,Et="This notebook demonstrates how you can easily transition from OpenAI models to Open LLMs without needing to refactor any existing code.",We,b,At='<a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a> now offers a <a href="https://huggingface.co/blog/tgi-messages-api" rel="nofollow">Messages API</a>, making it directly compatible with the OpenAI Chat Completion API. This means that any existing scripts that use OpenAI models (via the OpenAI client library or third-party tools like LangChain or LlamaIndex) can be directly swapped out to use any open LLM running on a TGI endpoint!',ke,g,Nt="This allows you to quickly test out and benefit from the numerous advantages offered by open models. Things like:",_e,f,xt="<li>Complete control and transparency over models and data</li> <li>No more worrying about rate limits</li> <li>The ability to fully customize systems according to your specific needs</li>",Re,I,Vt="In this notebook, we’ll show you how to:",Ee,B,Xt='<li><a href="#section_1">Create Inference Endpoint to Deploy a Model with TGI</a></li> <li><a href="#section_2">Query the Inference Endpoint with OpenAI Client Libraries</a></li> <li><a href="#section_3">Integrate the Endpoint with LangChain and LlamaIndex Workflows</a></li>',Ae,C,$t="<strong>Let’s dive in!</strong>",Ne,Z,xe,G,Qt="First we need to install dependencies and set an HF API key.",Ve,v,Xe,W,$e,je,Qe,k,Se,_,St='To get started, let’s deploy <a href="https://huggingface.co/NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO" rel="nofollow">Nous-Hermes-2-Mixtral-8x7B-DPO</a>, a fine-tuned Mixtral model, to Inference Endpoints using TGI.',Fe,R,Ft='We can deploy the model in just <a href="https://ui.endpoints.huggingface.co/new?vendor=aws&amp;repository=NousResearch%2FNous-Hermes-2-Mixtral-8x7B-DPO&amp;tgi_max_total_tokens=32000&amp;tgi=true&amp;tgi_max_input_length=1024&amp;task=text-generation&amp;instance_size=2xlarge&amp;tgi_max_batch_prefill_tokens=2048&amp;tgi_max_batch_total_tokens=1024000&amp;no_suggested_compute=true&amp;accelerator=gpu&amp;region=us-east-1" rel="nofollow">a few clicks from the UI</a>, or take advantage of the <code>huggingface_hub</code> Python library to programmatically create and manage Inference Endpoints.',Ye,E,Yt='We’ll use the Hub library here by specifing an endpoint name and model repository, along with the task of <code>text-generation</code>. In this example, we use a <code>protected</code> type so access to the deployed model will require a valid Hugging Face token. We also need to configure the hardware requirements like vendor, region, accelerator, instance type, and size. You can check out the list of available resource options <a href="https://api.endpoints.huggingface.cloud/#get-/v2/provider" rel="nofollow">using this API call</a>, and view recommended configurations for select models in the catalog <a href="https://ui.endpoints.huggingface.co/catalog" rel="nofollow">here</a>.',qe,A,qt='<em>Note: You may need to request a quota upgrade by sending an email to <a href="mailto:api-enterprise@huggingface.co">api-enterprise@huggingface.co</a></em>',He,N,Le,x,Ht=`running
`,ze,V,Lt="It will take a few minutes for our deployment to spin up. We can use the <code>.wait()</code> utility to block the running thread until the endpoint reaches a final “running” state. Once running, we can confirm its status and take it for a spin via the UI Playground:",Pe,X,zt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/messages-api/endpoint-overview.png" alt="IE UI Overview"/>',Oe,$,Pt="Great, we now have a working endpoint!",De,Q,Ot='<em>Note: When deploying with <code>huggingface_hub</code>, your endpoint will scale-to-zero after 15 minutes of idle time by default to optimize cost during periods of inactivity. Check out <a href="https://huggingface.co/docs/huggingface_hub/guides/inference_endpoints" rel="nofollow">the Hub Python Library documentation</a> to see all the functionality available for managing your endpoint lifecycle.</em>',Ke,Te,et,S,tt,F,Dt="As mentioned above, since our model is hosted with TGI it now supports a Messages API meaning we can query it directly using the familiar OpenAI client libraries.",st,Y,lt,q,Kt='The example below shows how to make this transition using the <a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI Python Library</a>. Simply replace the <code>&lt;ENDPOINT_URL&gt;</code> with your endpoint URL (be sure to include the <code>v1/</code> the suffix) and populate the <code>&lt;HF_API_KEY&gt;</code> field with a valid Hugging Face user token. The <code>&lt;ENDPOINT_URL&gt;</code> can be gathered from Inference Endpoints UI, or from the endpoint object we created above with <code>endpoint.url</code>.',nt,H,es="We can then use the client as usual, passing a list of messages to stream responses from our Inference Endpoint.",at,L,it,z,ts=`Open-source software is important due to a number of reasons, including:

1. Collaboration: The collaborative nature of open-source software allows developers from around the world to work together, share their ideas and improve the code. This often results in faster progress and better software.

2. Transparency: With open-source software, the code is publicly available, making it easy to see exactly how the software functions, and allowing users to determine if there are any security vulnerabilities.

3. Customization: Being able to access the code also allows users to customize the software to better suit their needs. This makes open-source software incredibly versatile, as users can tweak it to suit their specific use case.

4. Quality: Open-source software is often developed by large communities of dedicated developers, who work together to improve the software. This results in a higher level of quality than might be found in proprietary software.

5. Cost: Open-source software is often provided free of charge, which makes it accessible to a wider range of users. This can be especially important for organizations with limited budgets for software.

6. Shared Benefit: By sharing the code of open-source software, everyone can benefit from the hard work of the developers. This contributes to the overall advancement of technology, as users and developers work together to improve and build upon the software.

In summary, open-source software provides a collaborative platform that leads to high-quality, customizable, and transparent software, all available at little or no cost, benefiting both individuals and the technology community as a whole.<|im_end|>
`,ot,P,ss='Behind the scenes, TGI’s Messages API automatically converts the list of messages into the model’s required instruction format using its <a href="https://huggingface.co/docs/transformers/chat_templating" rel="nofollow">chat template</a>.',pt,O,ls="<em>Note: Certain OpenAI features, like function calling, are not compatible with TGI. Currently, the Messages API supports the following chat completion parameters: <code>stream</code>, <code>max_new_tokens</code>, <code>frequency_penalty</code>, <code>logprobs</code>, <code>seed</code>, <code>temperature</code>, and <code>top_p</code>.</em>",rt,D,ct,K,ns='Here’s the same streaming example above, but using the <a href="https://github.com/openai/openai-node" rel="nofollow">OpenAI Javascript/Typescript Library</a>.',Mt,ee,ht,Ue,mt,te,yt,se,as="Now, let’s see how to use this newly created endpoint with popular RAG frameworks like LangChain and LlamaIndex.",ut,le,dt,ne,is='To use it in <a href="https://python.langchain.com/docs/get_started/introduction" rel="nofollow">LangChain</a>, simply create an instance of <code>ChatOpenAI</code> and pass your <code>&lt;ENDPOINT_URL&gt;</code> and <code>&lt;HF_API_TOKEN&gt;</code> as follows:',wt,ae,Jt,ie,os="We’re able to directly leverage the same <code>ChatOpenAI</code> class that we would have used with the OpenAI models. This allows all previous code to work with our endpoint by changing just one line of code.",jt,oe,ps="Let’s now use our Mixtral model in a simple RAG pipeline to answer a question over the contents of a HF blog post.",Tt,pe,Ut,re,bt,ce,rs='Similarly, you can also use a TGI endpoint in <a href="https://www.llamaindex.ai/" rel="nofollow">LlamaIndex</a>. We’ll use the <code>OpenAILike</code> class, and instantiate it by configuring some additional arguments (i.e. <code>is_local</code>, <code>is_function_calling_model</code>, <code>is_chat_model</code>, <code>context_window</code>).',gt,Me,cs="<em>Note: that the context window argument should match the value previously set for <code>MAX_TOTAL_TOKENS</code> of your endpoint.</em>",ft,he,It,me,Ms="We can now use it in a similar RAG pipeline. Keep in mind that the previous choice of <code>MAX_INPUT_LENGTH</code> in your Inference Endpoint will directly influence the number of retrieved chunk (<code>similarity_top_k</code>) the model can process.",Bt,ye,Ct,ue,Zt,de,hs="After you are done with your endpoint, you can either pause or delete it. This step can be completed via the UI, or programmatically like follows.",Gt,we,vt,Je,Wt,ge,kt;return J=new Ts({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/ko-advanced-rag/notebooks/en/tgi_messages_api_demo.ipynb"}]}}),j=new d({props:{title:"Migrating from OpenAI to Open LLMs Using TGI’s Messages API",local:"migrating-from-openai-to-open-llms-using-tgis-messages-api",headingTag:"h1"}}),Z=new d({props:{title:"Setup",local:"setup",headingTag:"h2"}}),v=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtcSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjBsYW5nY2hhaW5odWIlMjBsYW5nY2hhaW4tb3BlbmFpJTIwbGxhbWEtaW5kZXglMjBjaHJvbWFkYiUyMGJzNCUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMHRvcmNoJTIwdG9yY2h2aXNpb24lMjB0b3JjaGF1ZGlvJTIwbGxhbWEtaW5kZXgtbGxtcy1vcGVuYWktbGlrZSUyMGxsYW1hLWluZGV4LWVtYmVkZGluZ3MtaHVnZ2luZ2ZhY2U=",highlighted:"!pip install --upgrade -q huggingface_hub langchain langchain-community langchainhub langchain-openai llama-index chromadb bs4 sentence_transformers torch torchvision torchaudio llama-index-llms-openai-like llama-index-embeddings-huggingface",wrap:!1}}),W=new u({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBnZXRwYXNzJTBBJTBBJTIzJTIwZW50ZXIlMjBBUEklMjBrZXklMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlMjAlM0QlMjBIRl9BUElfS0VZJTIwJTNEJTIwZ2V0cGFzcy5nZXRwYXNzKCk=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> getpass

<span class="hljs-comment"># enter API key</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = HF_API_KEY = getpass.getpass()`,wrap:!1}}),k=new d({props:{title:"1. Create an Inference Endpoint",local:"1-create-an-inference-endpoint",headingTag:"h2"}}),N=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybm91cy1oZXJtZXMtMi1taXh0cmFsLTh4N2ItZGVtbyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJOb3VzUmVzZWFyY2glMkZOb3VzLUhlcm1lcy0yLU1peHRyYWwtOHg3Qi1EUE8lMjIlMkMlMEElMjAlMjAlMjAlMjBmcmFtZXdvcmslM0QlMjJweXRvcmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yJTNEJTIyZ3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVuZG9yJTNEJTIyYXdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVnaW9uJTNEJTIydXMtZWFzdC0xJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnByb3RlY3RlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QlMjJwNGRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMjJ4bGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfSU5QVVRfTEVOR1RIJTIyJTNBJTIwJTIyNDA5NiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9CQVRDSF9QUkVGSUxMX1RPS0VOUyUyMiUzQSUyMCUyMjQwOTYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMzIwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTAyNDAwMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0FzaGEtMTczNDU0MCUyMiUyQyUyMCUyMCUyMyUyMG11c3QlMjBiZSUyMCUzRSUzRCUyMDEuNC4wJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKSUwQSUwQWVuZHBvaW50LndhaXQoKSUwQXByaW50KGVuZHBvaW50LnN0YXR1cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;nous-hermes-2-mixtral-8x7b-demo&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;p4de&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;2xlarge&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;32000&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024000&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:sha-1734540&quot;</span>,  <span class="hljs-comment"># must be &gt;= 1.4.0</span>
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(endpoint.status)`,wrap:!1}}),S=new d({props:{title:"2. Query the Inference Endpoint with OpenAI Client Libraries",local:"2-query-the-inference-endpoint-with-openai-client-libraries",headingTag:"h2"}}),Y=new d({props:{title:"With the Python client",local:"with-the-python-client",headingTag:"h3"}}),L=new u({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQUJBU0VfVVJMJTIwJTNEJTIwZW5kcG9pbnQudXJsJTBBJTBBJTIzJTIwaW5pdCUyMHRoZSUyMGNsaWVudCUyMGJ1dCUyMHBvaW50JTIwaXQlMjB0byUyMFRHSSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRG9zLnBhdGguam9pbihCQVNFX1VSTCUyQyUyMCUyMnYxJTJGJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBKSUwQWNoYXRfY29tcGxldGlvbiUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaHklMjBpcyUyMG9wZW4tc291cmNlJTIwc29mdHdhcmUlMjBpbXBvcnRhbnQlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDUwMCUyQyUwQSklMEElMEElMjMlMjBpdGVyYXRlJTIwYW5kJTIwcHJpbnQlMjBzdHJlYW0lMEFmb3IlMjBtZXNzYWdlJTIwaW4lMjBjaGF0X2NvbXBsZXRpb24lM0ElMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMkMlMjBlbmQlM0QlMjIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-meta">&gt;&gt;&gt; </span>BASE_URL = endpoint.url

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init the client but point it to TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = OpenAI(
<span class="hljs-meta">... </span>    base_url=os.path.join(BASE_URL, <span class="hljs-string">&quot;v1/&quot;</span>),
<span class="hljs-meta">... </span>    api_key=HF_API_KEY,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>chat_completion = client.chat.completions.create(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tgi&quot;</span>,
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Why is open-source software important?&quot;</span>},
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    stream=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(message.choices[<span class="hljs-number">0</span>].delta.content, end=<span class="hljs-string">&quot;&quot;</span>)`,wrap:!1}}),D=new d({props:{title:"With the JavaScript client",local:"with-the-javascript-client",headingTag:"h3"}}),ee=new u({props:{code:"aW1wb3J0JTIwT3BlbkFJJTIwZnJvbSUyMCUyMm9wZW5haSUyMiUzQiUwQSUwQWNvbnN0JTIwb3BlbmFpJTIwJTNEJTIwbmV3JTIwT3BlbkFJKCU3QiUwQSUyMCUyMGJhc2VVUkwlM0ElMjAlMjIlM0NFTkRQT0lOVF9VUkwlM0UlMjIlMjAlMkIlMjAlMjIlMkZ2MSUyRiUyMiUyQyUyMCUyRiUyRiUyMHJlcGxhY2UlMjB3aXRoJTIweW91ciUyMGVuZHBvaW50JTIwdXJsJTBBJTIwJTIwYXBpS2V5JTNBJTIwJTIyJTNDSEZfQVBJX1RPS0VOJTNFJTIyJTJDJTIwJTJGJTJGJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwdG9rZW4lMEElN0QpJTNCJTBBJTBBYXN5bmMlMjBmdW5jdGlvbiUyMG1haW4oKSUyMCU3QiUwQSUyMCUyMGNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwYXdhaXQlMjBvcGVuYWkuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTdCJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMHJvbGUlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyV2h5JTIwaXMlMjBvcGVuLXNvdXJjZSUyMHNvZnR3YXJlJTIwaW1wb3J0YW50JTNGJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0ElMjA1MDAlMkMlMEElMjAlMjAlN0QpJTNCJTBBJTIwJTIwZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMCUyMCUyMHByb2Nlc3Muc3Rkb3V0LndyaXRlKGNodW5rLmNob2ljZXMlNUIwJTVEJTNGLmRlbHRhJTNGLmNvbnRlbnQlMjAlN0MlN0MlMjAlMjIlMjIpJTNCJTBBJTIwJTIwJTdEJTBBJTdEJTBBJTBBbWFpbigpJTNC",highlighted:`<span class="hljs-keyword">import</span> <span class="hljs-title class_">OpenAI</span> <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;openai&quot;</span>;

<span class="hljs-keyword">const</span> openai = <span class="hljs-keyword">new</span> <span class="hljs-title class_">OpenAI</span>({
  <span class="hljs-attr">baseURL</span>: <span class="hljs-string">&quot;&lt;ENDPOINT_URL&gt;&quot;</span> + <span class="hljs-string">&quot;/v1/&quot;</span>, <span class="hljs-comment">// replace with your endpoint url</span>
  <span class="hljs-attr">apiKey</span>: <span class="hljs-string">&quot;&lt;HF_API_TOKEN&gt;&quot;</span>, <span class="hljs-comment">// replace with your token</span>
});

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">main</span>(<span class="hljs-params"></span>) {
  <span class="hljs-keyword">const</span> stream = <span class="hljs-keyword">await</span> openai.<span class="hljs-property">chat</span>.<span class="hljs-property">completions</span>.<span class="hljs-title function_">create</span>({
    <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
    <span class="hljs-attr">messages</span>: [
      { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
      { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Why is open-source software important?&quot;</span> },
    ],
    <span class="hljs-attr">stream</span>: <span class="hljs-literal">true</span>,
    <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  });
  <span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
    process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>]?.<span class="hljs-property">delta</span>?.<span class="hljs-property">content</span> || <span class="hljs-string">&quot;&quot;</span>);
  }
}

<span class="hljs-title function_">main</span>();`,wrap:!1}}),te=new d({props:{title:"3. Integrate with LangChain and LlamaIndex",local:"3-integrate-with-langchain-and-llamaindex",headingTag:"h2"}}),le=new d({props:{title:"How to use with LangChain",local:"how-to-use-with-langchain",headingTag:"h3"}}),ae=new u({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBJTBBbGxtJTIwJTNEJTIwQ2hhdE9wZW5BSSglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3BlbmFpX2FwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwb3BlbmFpX2FwaV9iYXNlJTNEb3MucGF0aC5qb2luKEJBU0VfVVJMJTJDJTIwJTIydjElMkYlMjIpJTJDJTBBKSUwQWxsbS5pbnZva2UoJTIyV2h5JTIwaXMlMjBvcGVuLXNvdXJjZSUyMHNvZnR3YXJlJTIwaW1wb3J0YW50JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

llm = ChatOpenAI(
    model_name=<span class="hljs-string">&quot;tgi&quot;</span>,
    openai_api_key=HF_API_KEY,
    openai_api_base=os.path.join(BASE_URL, <span class="hljs-string">&quot;v1/&quot;</span>),
)
llm.invoke(<span class="hljs-string">&quot;Why is open-source software important?&quot;</span>)`,wrap:!1}}),pe=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain <span class="hljs-keyword">import</span> hub
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.document_loaders <span class="hljs-keyword">import</span> WebBaseLoader
<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Chroma
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser
<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough
<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnableParallel
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

<span class="hljs-comment"># Load, chunk and index the contents of the blog</span>
loader = WebBaseLoader(
    web_paths=(<span class="hljs-string">&quot;https://huggingface.co/blog/open-source-llms-as-agents&quot;</span>,),
)
docs = loader.load()

<span class="hljs-comment"># declare an HF embedding model</span>
hf_embeddings = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>)

text_splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">200</span>)
splits = text_splitter.split_documents(docs)
vectorstore = Chroma.from_documents(documents=splits, embedding=hf_embeddings)

<span class="hljs-comment"># Retrieve and generate using the relevant snippets of the blog</span>
retriever = vectorstore.as_retriever()
prompt = hub.pull(<span class="hljs-string">&quot;rlm/rag-prompt&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_docs</span>(<span class="hljs-params">docs</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join(doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs)


rag_chain_from_docs = (
    RunnablePassthrough.assign(context=(<span class="hljs-keyword">lambda</span> x: format_docs(x[<span class="hljs-string">&quot;context&quot;</span>]))) | prompt | llm | StrOutputParser()
)

rag_chain_with_source = RunnableParallel({<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()}).assign(
    answer=rag_chain_from_docs
)

rag_chain_with_source.invoke(<span class="hljs-string">&quot;According to this article which open-source model is the best for an agent behaviour?&quot;</span>)`,wrap:!1}}),re=new d({props:{title:"How to use with LlamaIndex",local:"how-to-use-with-llamaindex",headingTag:"h3"}}),he=new u({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMub3BlbmFpX2xpa2UlMjBpbXBvcnQlMjBPcGVuQUlMaWtlJTBBJTBBbGxtJTIwJTNEJTIwT3BlbkFJTGlrZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2Jhc2UlM0RCQVNFX1VSTCUyMCUyQiUyMCUyMiUyRnYxJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfY2hhdF9tb2RlbCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBpc19sb2NhbCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwaXNfZnVuY3Rpb25fY2FsbGluZ19tb2RlbCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF93aW5kb3clM0Q0MDk2JTJDJTBBKSUwQSUwQWxsbS5jb21wbGV0ZSglMjJXaHklMjBpcyUyMG9wZW4tc291cmNlJTIwc29mdHdhcmUlMjBpbXBvcnRhbnQlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.openai_like <span class="hljs-keyword">import</span> OpenAILike

llm = OpenAILike(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    api_key=HF_API_KEY,
    api_base=BASE_URL + <span class="hljs-string">&quot;/v1/&quot;</span>,
    is_chat_model=<span class="hljs-literal">True</span>,
    is_local=<span class="hljs-literal">False</span>,
    is_function_calling_model=<span class="hljs-literal">False</span>,
    context_window=<span class="hljs-number">4096</span>,
)

llm.complete(<span class="hljs-string">&quot;Why is open-source software important?&quot;</span>)`,wrap:!1}}),ye=new u({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTJDJTIwZG93bmxvYWRfbG9hZGVyJTBBZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyUwQWZyb20lMjBsbGFtYV9pbmRleC5jb3JlLnF1ZXJ5X2VuZ2luZSUyMGltcG9ydCUyMENpdGF0aW9uUXVlcnlFbmdpbmUlMEElMEFTaW1wbGVXZWJQYWdlUmVhZGVyJTIwJTNEJTIwZG93bmxvYWRfbG9hZGVyKCUyMlNpbXBsZVdlYlBhZ2VSZWFkZXIlMjIpJTBBJTBBZG9jdW1lbnRzJTIwJTNEJTIwU2ltcGxlV2ViUGFnZVJlYWRlcihodG1sX3RvX3RleHQlM0RUcnVlKS5sb2FkX2RhdGEoJTBBJTIwJTIwJTIwJTIwJTVCJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmJsb2clMkZvcGVuLXNvdXJjZS1sbG1zLWFzLWFnZW50cyUyMiU1RCUwQSklMEElMEElMjMlMjBMb2FkJTIwZW1iZWRkaW5nJTIwbW9kZWwlMEFlbWJlZF9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWxhcmdlLWVuLXYxLjUlMjIpJTBBJTBBJTIzJTIwUGFzcyUyMExMTSUyMHRvJTIwcGlwZWxpbmUlMEFpbmRleCUyMCUzRCUyMFZlY3RvclN0b3JlSW5kZXguZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTJDJTIwZW1iZWRfbW9kZWwlM0RlbWJlZF9tb2RlbCUyQyUyMHNob3dfcHJvZ3Jlc3MlM0RUcnVlKSUwQSUwQSUyMyUyMFF1ZXJ5JTIwdGhlJTIwaW5kZXglMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBDaXRhdGlvblF1ZXJ5RW5naW5lLmZyb21fYXJncyglMEElMjAlMjAlMjAlMjBpbmRleCUyQyUwQSUyMCUyMCUyMCUyMHNpbWlsYXJpdHlfdG9wX2slM0QyJTJDJTBBKSUwQXJlc3BvbnNlJTIwJTNEJTIwcXVlcnlfZW5naW5lLnF1ZXJ5KCUyMkFjY29yZGluZyUyMHRvJTIwdGhpcyUyMGFydGljbGUlMjB3aGljaCUyMG9wZW4tc291cmNlJTIwbW9kZWwlMjBpcyUyMHRoZSUyMGJlc3QlMjBmb3IlMjBhbiUyMGFnZW50JTIwYmVoYXZpb3VyJTNGJTIyKSUwQSUwQXJlc3BvbnNlLnJlc3BvbnNl",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex, download_loader
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.core.query_engine <span class="hljs-keyword">import</span> CitationQueryEngine

SimpleWebPageReader = download_loader(<span class="hljs-string">&quot;SimpleWebPageReader&quot;</span>)

documents = SimpleWebPageReader(html_to_text=<span class="hljs-literal">True</span>).load_data(
    [<span class="hljs-string">&quot;https://huggingface.co/blog/open-source-llms-as-agents&quot;</span>]
)

<span class="hljs-comment"># Load embedding model</span>
embed_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>)

<span class="hljs-comment"># Pass LLM to pipeline</span>
index = VectorStoreIndex.from_documents(documents, embed_model=embed_model, show_progress=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Query the index</span>
query_engine = CitationQueryEngine.from_args(
    index,
    similarity_top_k=<span class="hljs-number">2</span>,
)
response = query_engine.query(<span class="hljs-string">&quot;According to this article which open-source model is the best for an agent behaviour?&quot;</span>)

response.response`,wrap:!1}}),ue=new d({props:{title:"Wrap up",local:"wrap-up",headingTag:"h2"}}),we=new u({props:{code:"JTIzJTIwcGF1c2UlMjBvdXIlMjBydW5uaW5nJTIwZW5kcG9pbnQlMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBJTIzJTIwb3B0aW9uYWxseSUyMGRlbGV0ZSUwQSUyMyUyMGVuZHBvaW50LmRlbGV0ZSgp",highlighted:`<span class="hljs-comment"># pause our running endpoint</span>
endpoint.pause()

<span class="hljs-comment"># optionally delete</span>
<span class="hljs-comment"># endpoint.delete()</span>`,wrap:!1}}),Je=new Us({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/tgi_messages_api_demo.md"}}),{c(){w=i("meta"),Be=n(),be=i("p"),Ce=n(),r(J.$$.fragment),Ze=n(),r(j.$$.fragment),Ge=n(),T=i("p"),T.innerHTML=Rt,ve=n(),U=i("p"),U.textContent=Et,We=n(),b=i("p"),b.innerHTML=At,ke=n(),g=i("p"),g.textContent=Nt,_e=n(),f=i("ul"),f.innerHTML=xt,Re=n(),I=i("p"),I.textContent=Vt,Ee=n(),B=i("ol"),B.innerHTML=Xt,Ae=n(),C=i("p"),C.innerHTML=$t,Ne=n(),r(Z.$$.fragment),xe=n(),G=i("p"),G.textContent=Qt,Ve=n(),r(v.$$.fragment),Xe=n(),r(W.$$.fragment),$e=n(),je=i("a"),Qe=n(),r(k.$$.fragment),Se=n(),_=i("p"),_.innerHTML=St,Fe=n(),R=i("p"),R.innerHTML=Ft,Ye=n(),E=i("p"),E.innerHTML=Yt,qe=n(),A=i("p"),A.innerHTML=qt,He=n(),r(N.$$.fragment),Le=n(),x=i("pre"),x.textContent=Ht,ze=n(),V=i("p"),V.innerHTML=Lt,Pe=n(),X=i("p"),X.innerHTML=zt,Oe=n(),$=i("p"),$.textContent=Pt,De=n(),Q=i("p"),Q.innerHTML=Ot,Ke=n(),Te=i("a"),et=n(),r(S.$$.fragment),tt=n(),F=i("p"),F.textContent=Dt,st=n(),r(Y.$$.fragment),lt=n(),q=i("p"),q.innerHTML=Kt,nt=n(),H=i("p"),H.textContent=es,at=n(),r(L.$$.fragment),it=n(),z=i("pre"),z.textContent=ts,ot=n(),P=i("p"),P.innerHTML=ss,pt=n(),O=i("p"),O.innerHTML=ls,rt=n(),r(D.$$.fragment),ct=n(),K=i("p"),K.innerHTML=ns,Mt=n(),r(ee.$$.fragment),ht=n(),Ue=i("a"),mt=n(),r(te.$$.fragment),yt=n(),se=i("p"),se.textContent=as,ut=n(),r(le.$$.fragment),dt=n(),ne=i("p"),ne.innerHTML=is,wt=n(),r(ae.$$.fragment),Jt=n(),ie=i("p"),ie.innerHTML=os,jt=n(),oe=i("p"),oe.textContent=ps,Tt=n(),r(pe.$$.fragment),Ut=n(),r(re.$$.fragment),bt=n(),ce=i("p"),ce.innerHTML=rs,gt=n(),Me=i("p"),Me.innerHTML=cs,ft=n(),r(he.$$.fragment),It=n(),me=i("p"),me.innerHTML=Ms,Bt=n(),r(ye.$$.fragment),Ct=n(),r(ue.$$.fragment),Zt=n(),de=i("p"),de.textContent=hs,Gt=n(),r(we.$$.fragment),vt=n(),r(Je.$$.fragment),Wt=n(),ge=i("p"),this.h()},l(e){const t=Js("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),Be=a(e),be=o(e,"P",{}),fe(be).forEach(s),Ce=a(e),c(J.$$.fragment,e),Ze=a(e),c(j.$$.fragment,e),Ge=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-15bmh6z"&&(T.innerHTML=Rt),ve=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-ifj9j3"&&(U.textContent=Et),We=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-19stfnn"&&(b.innerHTML=At),ke=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1h5h72d"&&(g.textContent=Nt),_e=a(e),f=o(e,"UL",{"data-svelte-h":!0}),p(f)!=="svelte-o7yv73"&&(f.innerHTML=xt),Re=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-i15w4q"&&(I.textContent=Vt),Ee=a(e),B=o(e,"OL",{"data-svelte-h":!0}),p(B)!=="svelte-dmuq8i"&&(B.innerHTML=Xt),Ae=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1yaed00"&&(C.innerHTML=$t),Ne=a(e),c(Z.$$.fragment,e),xe=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1mbafnu"&&(G.textContent=Qt),Ve=a(e),c(v.$$.fragment,e),Xe=a(e),c(W.$$.fragment,e),$e=a(e),je=o(e,"A",{id:!0}),fe(je).forEach(s),Qe=a(e),c(k.$$.fragment,e),Se=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1srz11y"&&(_.innerHTML=St),Fe=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1nafhc7"&&(R.innerHTML=Ft),Ye=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1qq4fhb"&&(E.innerHTML=Yt),qe=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1vrlf2e"&&(A.innerHTML=qt),He=a(e),c(N.$$.fragment,e),Le=a(e),x=o(e,"PRE",{"data-svelte-h":!0}),p(x)!=="svelte-105t8kl"&&(x.textContent=Ht),ze=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-13u8bul"&&(V.innerHTML=Lt),Pe=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-8mpmx4"&&(X.innerHTML=zt),Oe=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1hh5tjb"&&($.textContent=Pt),De=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1nk8k00"&&(Q.innerHTML=Ot),Ke=a(e),Te=o(e,"A",{id:!0}),fe(Te).forEach(s),et=a(e),c(S.$$.fragment,e),tt=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-m2ihxo"&&(F.textContent=Dt),st=a(e),c(Y.$$.fragment,e),lt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1vvrp5u"&&(q.innerHTML=Kt),nt=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-5sa4me"&&(H.textContent=es),at=a(e),c(L.$$.fragment,e),it=a(e),z=o(e,"PRE",{"data-svelte-h":!0}),p(z)!=="svelte-1gevisn"&&(z.textContent=ts),ot=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-9ab64r"&&(P.innerHTML=ss),pt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-15i27pe"&&(O.innerHTML=ls),rt=a(e),c(D.$$.fragment,e),ct=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-a5y7nz"&&(K.innerHTML=ns),Mt=a(e),c(ee.$$.fragment,e),ht=a(e),Ue=o(e,"A",{id:!0}),fe(Ue).forEach(s),mt=a(e),c(te.$$.fragment,e),yt=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1i9oels"&&(se.textContent=as),ut=a(e),c(le.$$.fragment,e),dt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1qdzd81"&&(ne.innerHTML=is),wt=a(e),c(ae.$$.fragment,e),Jt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-4flxc0"&&(ie.innerHTML=os),jt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-c9m7s5"&&(oe.textContent=ps),Tt=a(e),c(pe.$$.fragment,e),Ut=a(e),c(re.$$.fragment,e),bt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-gt52es"&&(ce.innerHTML=rs),gt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1oxfz4m"&&(Me.innerHTML=cs),ft=a(e),c(he.$$.fragment,e),It=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1yqegdk"&&(me.innerHTML=Ms),Bt=a(e),c(ye.$$.fragment,e),Ct=a(e),c(ue.$$.fragment,e),Zt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-132npwv"&&(de.textContent=hs),Gt=a(e),c(we.$$.fragment,e),vt=a(e),c(Je.$$.fragment,e),Wt=a(e),ge=o(e,"P",{}),fe(ge).forEach(s),this.h()},h(){Ie(w,"name","hf:doc:metadata"),Ie(w,"content",gs),Ie(je,"id","section_1"),Ie(Te,"id","section_2"),Ie(Ue,"id","section_3")},m(e,t){js(document.head,w),l(e,Be,t),l(e,be,t),l(e,Ce,t),M(J,e,t),l(e,Ze,t),M(j,e,t),l(e,Ge,t),l(e,T,t),l(e,ve,t),l(e,U,t),l(e,We,t),l(e,b,t),l(e,ke,t),l(e,g,t),l(e,_e,t),l(e,f,t),l(e,Re,t),l(e,I,t),l(e,Ee,t),l(e,B,t),l(e,Ae,t),l(e,C,t),l(e,Ne,t),M(Z,e,t),l(e,xe,t),l(e,G,t),l(e,Ve,t),M(v,e,t),l(e,Xe,t),M(W,e,t),l(e,$e,t),l(e,je,t),l(e,Qe,t),M(k,e,t),l(e,Se,t),l(e,_,t),l(e,Fe,t),l(e,R,t),l(e,Ye,t),l(e,E,t),l(e,qe,t),l(e,A,t),l(e,He,t),M(N,e,t),l(e,Le,t),l(e,x,t),l(e,ze,t),l(e,V,t),l(e,Pe,t),l(e,X,t),l(e,Oe,t),l(e,$,t),l(e,De,t),l(e,Q,t),l(e,Ke,t),l(e,Te,t),l(e,et,t),M(S,e,t),l(e,tt,t),l(e,F,t),l(e,st,t),M(Y,e,t),l(e,lt,t),l(e,q,t),l(e,nt,t),l(e,H,t),l(e,at,t),M(L,e,t),l(e,it,t),l(e,z,t),l(e,ot,t),l(e,P,t),l(e,pt,t),l(e,O,t),l(e,rt,t),M(D,e,t),l(e,ct,t),l(e,K,t),l(e,Mt,t),M(ee,e,t),l(e,ht,t),l(e,Ue,t),l(e,mt,t),M(te,e,t),l(e,yt,t),l(e,se,t),l(e,ut,t),M(le,e,t),l(e,dt,t),l(e,ne,t),l(e,wt,t),M(ae,e,t),l(e,Jt,t),l(e,ie,t),l(e,jt,t),l(e,oe,t),l(e,Tt,t),M(pe,e,t),l(e,Ut,t),M(re,e,t),l(e,bt,t),l(e,ce,t),l(e,gt,t),l(e,Me,t),l(e,ft,t),M(he,e,t),l(e,It,t),l(e,me,t),l(e,Bt,t),M(ye,e,t),l(e,Ct,t),M(ue,e,t),l(e,Zt,t),l(e,de,t),l(e,Gt,t),M(we,e,t),l(e,vt,t),M(Je,e,t),l(e,Wt,t),l(e,ge,t),kt=!0},p:ys,i(e){kt||(h(J.$$.fragment,e),h(j.$$.fragment,e),h(Z.$$.fragment,e),h(v.$$.fragment,e),h(W.$$.fragment,e),h(k.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(Y.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),kt=!0)},o(e){m(J.$$.fragment,e),m(j.$$.fragment,e),m(Z.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(k.$$.fragment,e),m(N.$$.fragment,e),m(S.$$.fragment,e),m(Y.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(he.$$.fragment,e),m(ye.$$.fragment,e),m(ue.$$.fragment,e),m(we.$$.fragment,e),m(Je.$$.fragment,e),kt=!1},d(e){e&&(s(Be),s(be),s(Ce),s(Ze),s(Ge),s(T),s(ve),s(U),s(We),s(b),s(ke),s(g),s(_e),s(f),s(Re),s(I),s(Ee),s(B),s(Ae),s(C),s(Ne),s(xe),s(G),s(Ve),s(Xe),s($e),s(je),s(Qe),s(Se),s(_),s(Fe),s(R),s(Ye),s(E),s(qe),s(A),s(He),s(Le),s(x),s(ze),s(V),s(Pe),s(X),s(Oe),s($),s(De),s(Q),s(Ke),s(Te),s(et),s(tt),s(F),s(st),s(lt),s(q),s(nt),s(H),s(at),s(it),s(z),s(ot),s(P),s(pt),s(O),s(rt),s(ct),s(K),s(Mt),s(ht),s(Ue),s(mt),s(yt),s(se),s(ut),s(dt),s(ne),s(wt),s(Jt),s(ie),s(jt),s(oe),s(Tt),s(Ut),s(bt),s(ce),s(gt),s(Me),s(ft),s(It),s(me),s(Bt),s(Ct),s(Zt),s(de),s(Gt),s(vt),s(Wt),s(ge)),s(w),y(J,e),y(j,e),y(Z,e),y(v,e),y(W,e),y(k,e),y(N,e),y(S,e),y(Y,e),y(L,e),y(D,e),y(ee,e),y(te,e),y(le,e),y(ae,e),y(pe,e),y(re,e),y(he,e),y(ye,e),y(ue,e),y(we,e),y(Je,e)}}}const gs='{"title":"Migrating from OpenAI to Open LLMs Using TGI’s Messages API","local":"migrating-from-openai-to-open-llms-using-tgis-messages-api","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"1. Create an Inference Endpoint","local":"1-create-an-inference-endpoint","sections":[],"depth":2},{"title":"2. Query the Inference Endpoint with OpenAI Client Libraries","local":"2-query-the-inference-endpoint-with-openai-client-libraries","sections":[{"title":"With the Python client","local":"with-the-python-client","sections":[],"depth":3},{"title":"With the JavaScript client","local":"with-the-javascript-client","sections":[],"depth":3}],"depth":2},{"title":"3. Integrate with LangChain and LlamaIndex","local":"3-integrate-with-langchain-and-llamaindex","sections":[{"title":"How to use with LangChain","local":"how-to-use-with-langchain","sections":[],"depth":3},{"title":"How to use with LlamaIndex","local":"how-to-use-with-llamaindex","sections":[],"depth":3}],"depth":2},{"title":"Wrap up","local":"wrap-up","sections":[],"depth":2}],"depth":1}';function fs(_t){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends ds{constructor(w){super(),ws(this,w,fs,bs,ms,{})}}export{Gs as component};
