import{s as us,f as os,o as cs,n as rs}from"../chunks/scheduler.f6319a2a.js";import{S as ys,i as Js,g as i,s as n,r as p,A as ws,h as o,f as l,c as a,j as Ms,u as r,x as M,k as ze,y as Ts,a as s,v as u,d as c,t as y,w as J}from"../chunks/index.85aa684c.js";import{T as ps}from"../chunks/Tip.3d397a88.js";import{C as x}from"../chunks/CodeBlock.3400fc53.js";import{D as ds}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as d,E as ms}from"../chunks/getInferenceSnippets.4ff3f544.js";function Us(Ye){let w,j='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){w=i("p"),w.innerHTML=j},l(m){w=o(m,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1p1d9vw"&&(w.innerHTML=j)},m(m,h){s(m,w,h)},p:rs,d(m){m&&l(w)}}}function hs(Ye){let w,j="It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.",m,h,I="For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.",g,U,v="Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.";return{c(){w=i("p"),w.textContent=j,m=n(),h=i("p"),h.innerHTML=I,g=n(),U=i("p"),U.textContent=v},l(T){w=o(T,"P",{"data-svelte-h":!0}),M(w)!=="svelte-13ohzr"&&(w.textContent=j),m=a(T),h=o(T,"P",{"data-svelte-h":!0}),M(h)!=="svelte-1wfid17"&&(h.innerHTML=I),g=a(T),U=o(T,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1zo76k"&&(U.textContent=v)},m(T,b){s(T,w,b),s(T,m,b),s(T,h,b),s(T,g,b),s(T,U,b)},p:rs,d(T){T&&(l(w),l(m),l(h),l(g),l(U))}}}function js(Ye){let w,j,m,h,I,g,U,v,T,b,B,qe,Z,yl='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',Le,k,Jl="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",Pe,W,wl="Code is just a better way to express actions on a computer. It has better:",De,A,Tl="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",Ke,G,dl='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',Oe,He,ml,et,E,Ul="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",tt,$,lt,V,hl="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",st,R,jl="This is inherently risky, LLM-generated code could be harmful to your environment.",nt,S,Il="Malicious code execution can occur in several ways:",at,N,bl=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,it,_,gl='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',ot,Q,Cl="So you need to be very mindful of security.",Mt,Y,fl="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",pt,H,xl="We advise you to keep in mind that no solution will be 100% safe.",rt,Xe,vl,ut,X,ct,F,Bl=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,yt,z,Zl="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",Jt,q,kl="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",wt,L,Wl="You could try these safeguards as follows:",Tt,P,dt,D,Al=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,mt,C,Ut,K,Gl=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,ht,O,jt,ee,El="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",It,te,$l='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/remote_execution.png" alt="Sandbox approaches comparison"/>',bt,le,Vl="<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>",gt,se,Rl="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",Ct,ne,ft,ae,xt,ie,Sl='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',vt,oe,Bt,Me,Zt,pe,Nl="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",kt,re,Wt,ue,_l=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,At,ce,Ql="This is illustrated in the figure below.",Gt,f,Yl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',Et,ye,Hl=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,$t,Je,Vt,we,Xl="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",Rt,Te,Fl="Here is how to do it:",St,de,Nt,me,_t,Ue,Qt,he,zl='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',Yt,je,Ht,Ie,Xt,be,ql="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",Ft,ge,zt,Ce,qt,fe,Ll="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",Lt,xe,Pl="Here is how to setup the a Dockerfile:",Pt,ve,Dt,Be,Dl="Create a sandbox manager to run code:",Kt,Ze,Ot,ke,el,We,Kl="These key practices apply to both E2B and Docker sandboxes:",tl,Ae,Ol="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",ll,Ge,es="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",sl,Ee,nl,$e,ts="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",al,Ve,il,Re,ls="<li><strong>Pros</strong>: <ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>",ol,Se,Ml,Ne,ss="<li><strong>Pros</strong>:<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>",pl,_e,ns="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",rl,Qe,ul,Fe,cl;return I=new d({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),U=new ds({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),T=new ps({props:{warning:!1,$$slots:{default:[Us]},$$scope:{ctx:Ye}}}),B=new d({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),$=new d({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),X=new d({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),P=new x({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&quot;</span>echo Bad command<span class="hljs-string">&quot;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),C=new ps({props:{warning:!0,$$slots:{default:[hs]},$$scope:{ctx:Ye}}}),O=new d({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),ne=new d({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),ae=new d({props:{title:"Installation",local:"installation",headingTag:"h4"}}),oe=new x({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),Me=new d({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),re=new x({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMmUyYiUyMiklMEElMEFhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Je=new d({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),de=new x({props:{code:"ZnJvbSUyMGUyYl9jb2RlX2ludGVycHJldGVyJTIwaW1wb3J0JTIwU2FuZGJveCUwQWltcG9ydCUyMG9zJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwc2FuZGJveCUwQXNhbmRib3glMjAlM0QlMjBTYW5kYm94KCklMEElMEElMjMlMjBJbnN0YWxsJTIwcmVxdWlyZWQlMjBwYWNrYWdlcyUwQXNhbmRib3guY29tbWFuZHMucnVuKCUyMnBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIyKSUwQSUwQWRlZiUyMHJ1bl9jb2RlX3JhaXNlX2Vycm9ycyhzYW5kYm94JTJDJTIwY29kZSUzQSUyMHN0ciUyQyUyMHZlcmJvc2UlM0ElMjBib29sJTIwJTNEJTIwRmFsc2UpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMGV4ZWN1dGlvbiUyMCUzRCUyMHNhbmRib3gucnVuX2NvZGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29kZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudnMlM0QlN0InSEZfVE9LRU4nJTNBJTIwb3MuZ2V0ZW52KCdIRl9UT0tFTicpJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGlmJTIwZXhlY3V0aW9uLmVycm9yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhlY3V0aW9uX2xvZ3MlMjAlM0QlMjAlMjIlNUNuJTIyLmpvaW4oJTVCc3RyKGxvZyklMjBmb3IlMjBsb2clMjBpbiUyMGV4ZWN1dGlvbi5sb2dzLnN0ZG91dCU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dzJTIwJTNEJTIwZXhlY3V0aW9uX2xvZ3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dzJTIwJTJCJTNEJTIwZXhlY3V0aW9uLmVycm9yLnRyYWNlYmFjayUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihsb2dzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMiU1Q24lMjIuam9pbiglNUJzdHIobG9nKSUyMGZvciUyMGxvZyUyMGluJTIwZXhlY3V0aW9uLmxvZ3Muc3Rkb3V0JTVEKSUwQSUwQSUyMyUyMERlZmluZSUyMHlvdXIlMjBhZ2VudCUyMGFwcGxpY2F0aW9uJTBBYWdlbnRfY29kZSUyMCUzRCUyMCUyMiUyMiUyMiUwQWltcG9ydCUyMG9zJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudHMlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKHRva2VuJTNEb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSUyQyUyMHByb3ZpZGVyJTNEJTIydG9nZXRoZXIlMjIpJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyY29kZXJfYWdlbnQlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBhZ2VudCUyMHRha2VzJTIwY2FyZSUyMG9mJTIweW91ciUyMGRpZmZpY3VsdCUyMGFsZ29yaXRobWljJTIwcHJvYmxlbXMlMjB1c2luZyUyMGNvZGUuJTIyJTBBKSUwQSUwQW1hbmFnZXJfYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCh0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWFuYWdlZF9hZ2VudHMlM0QlNUJhZ2VudCU1RCUyQyUwQSklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUwQXJlc3BvbnNlJTIwJTNEJTIwbWFuYWdlcl9hZ2VudC5ydW4oJTIyV2hhdCdzJTIwdGhlJTIwMjB0aCUyMEZpYm9uYWNjaSUyMG51bWJlciUzRiUyMiklMEFwcmludChyZXNwb25zZSklMEElMjIlMjIlMjIlMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMGNvZGUlMjBpbiUyMHRoZSUyMHNhbmRib3glMEFleGVjdXRpb25fbG9ncyUyMCUzRCUyMHJ1bl9jb2RlX3JhaXNlX2Vycm9ycyhzYW5kYm94JTJDJTIwYWdlbnRfY29kZSklMEFwcmludChleGVjdXRpb25fbG9ncyk=",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),me=new d({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),Ue=new d({props:{title:"Installation",local:"installation",headingTag:"h4"}}),je=new x({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),Ie=new d({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),ge=new x({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMmRvY2tlciUyMiklMEElMEFhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Ce=new d({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),ve=new x({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),Ze=new x({props:{code:"aW1wb3J0JTIwZG9ja2VyJTBBaW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwT3B0aW9uYWwlMEElMEFjbGFzcyUyMERvY2tlclNhbmRib3glM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwZG9ja2VyLmZyb21fZW52KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbnRhaW5lciUyMCUzRCUyME5vbmUlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBjcmVhdGVfY29udGFpbmVyKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMkMlMjBidWlsZF9sb2dzJTIwJTNEJTIwc2VsZi5jbGllbnQuaW1hZ2VzLmJ1aWxkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhdGglM0QlMjIuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFnJTNEJTIyYWdlbnQtc2FuZGJveCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcmNlcm0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGRhcmdzJTNEJTdCJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVjb2RlJTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleGNlcHQlMjBkb2NrZXIuZXJyb3JzLkJ1aWxkRXJyb3IlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJCdWlsZCUyMGVycm9yJTIwbG9ncyUzQSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBsb2clMjBpbiUyMGUuYnVpbGRfbG9nJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAnc3RyZWFtJyUyMGluJTIwbG9nJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQobG9nJTVCJ3N0cmVhbSclNUQuc3RyaXAoKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMGNvbnRhaW5lciUyMHdpdGglMjBzZWN1cml0eSUyMGNvbnN0cmFpbnRzJTIwYW5kJTIwcHJvcGVyJTIwbG9nZ2luZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY29udGFpbmVyJTIwJTNEJTIwc2VsZi5jbGllbnQuY29udGFpbmVycy5ydW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWdlbnQtc2FuZGJveCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ0YWlsJTIwLWYlMjAlMkZkZXYlMkZudWxsJTIyJTJDJTIwJTIwJTIzJTIwS2VlcCUyMGNvbnRhaW5lciUyMHJ1bm5pbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXRhY2glM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHR5JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lbV9saW1pdCUzRCUyMjUxMm0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjcHVfcXVvdGElM0Q1MDAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpZHNfbGltaXQlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWN1cml0eV9vcHQlM0QlNUIlMjJuby1uZXctcHJpdmlsZWdlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcF9kcm9wJTNEJTVCJTIyQUxMJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW52aXJvbm1lbnQlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIRl9UT0tFTiUyMiUzQSUyMG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcnVuX2NvZGUoc2VsZiUyQyUyMGNvZGUlM0ElMjBzdHIpJTIwLSUzRSUyME9wdGlvbmFsJTVCc3RyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBzZWxmLmNvbnRhaW5lciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY3JlYXRlX2NvbnRhaW5lcigpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRXhlY3V0ZSUyMGNvZGUlMjBpbiUyMGNvbnRhaW5lciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4ZWNfcmVzdWx0JTIwJTNEJTIwc2VsZi5jb250YWluZXIuZXhlY19ydW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY21kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjBjb2RlJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlciUzRCUyMm5vYm9keSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDb2xsZWN0JTIwYWxsJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhlY19yZXN1bHQub3V0cHV0LmRlY29kZSgpJTIwaWYlMjBleGVjX3Jlc3VsdC5vdXRwdXQlMjBlbHNlJTIwTm9uZSUwQSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGNsZWFudXAoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYuY29udGFpbmVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5jb250YWluZXIuc3RvcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTIwZG9ja2VyLmVycm9ycy5Ob3RGb3VuZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENvbnRhaW5lciUyMGFscmVhZHklMjByZW1vdmVkJTJDJTIwdGhpcyUyMGlzJTIwZXhwZWN0ZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkVycm9yJTIwZHVyaW5nJTIwY2xlYW51cCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmluYWxseSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY29udGFpbmVyJTIwJTNEJTIwTm9uZSUyMCUyMCUyMyUyMENsZWFyJTIwdGhlJTIwcmVmZXJlbmNlJTBBJTBBJTIzJTIwRXhhbXBsZSUyMHVzYWdlJTNBJTBBc2FuZGJveCUyMCUzRCUyMERvY2tlclNhbmRib3goKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMERlZmluZSUyMHlvdXIlMjBhZ2VudCUyMGNvZGUlMEElMjAlMjAlMjAlMjBhZ2VudF9jb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBaW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCh0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTBBKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGFnZW50JTBBcmVzcG9uc2UlMjAlM0QlMjBhZ2VudC5ydW4oJTIyV2hhdCdzJTIwdGhlJTIwMjB0aCUyMEZpYm9uYWNjaSUyMG51bWJlciUzRiUyMiklMEFwcmludChyZXNwb25zZSklMEElMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBSdW4lMjB0aGUlMjBjb2RlJTIwaW4lMjB0aGUlMjBzYW5kYm94JTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwc2FuZGJveC5ydW5fY29kZShhZ2VudF9jb2RlKSUwQSUyMCUyMCUyMCUyMHByaW50KG91dHB1dCklMEElMEFmaW5hbGx5JTNBJTBBJTIwJTIwJTIwJTIwc2FuZGJveC5jbGVhbnVwKCk=",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),ke=new d({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),Ee=new d({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),Ve=new d({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),Se=new d({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),Qe=new ms({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.mdx"}}),{c(){w=i("meta"),j=n(),m=i("p"),h=n(),p(I.$$.fragment),g=n(),p(U.$$.fragment),v=n(),p(T.$$.fragment),b=n(),p(B.$$.fragment),qe=n(),Z=i("p"),Z.innerHTML=yl,Le=n(),k=i("p"),k.textContent=Jl,Pe=n(),W=i("p"),W.textContent=wl,De=n(),A=i("ul"),A.innerHTML=Tl,Ke=n(),G=i("p"),G.innerHTML=dl,Oe=n(),He=i("img"),et=n(),E=i("p"),E.textContent=Ul,tt=n(),p($.$$.fragment),lt=n(),V=i("p"),V.innerHTML=hl,st=n(),R=i("p"),R.textContent=jl,nt=n(),S=i("p"),S.textContent=Il,at=n(),N=i("ul"),N.innerHTML=bl,it=n(),_=i("p"),_.innerHTML=gl,ot=n(),Q=i("p"),Q.textContent=Cl,Mt=n(),Y=i("p"),Y.textContent=fl,pt=n(),H=i("p"),H.textContent=xl,rt=n(),Xe=i("img"),ut=n(),p(X.$$.fragment),ct=n(),F=i("p"),F.innerHTML=Bl,yt=n(),z=i("p"),z.textContent=Zl,Jt=n(),q=i("ul"),q.innerHTML=kl,wt=n(),L=i("p"),L.textContent=Wl,Tt=n(),p(P.$$.fragment),dt=n(),D=i("p"),D.textContent=Al,mt=n(),p(C.$$.fragment),Ut=n(),K=i("p"),K.textContent=Gl,ht=n(),p(O.$$.fragment),jt=n(),ee=i("p"),ee.textContent=El,It=n(),te=i("p"),te.innerHTML=$l,bt=n(),le=i("ol"),le.innerHTML=Vl,gt=n(),se=i("p"),se.textContent=Rl,Ct=n(),p(ne.$$.fragment),ft=n(),p(ae.$$.fragment),xt=n(),ie=i("ol"),ie.innerHTML=Sl,vt=n(),p(oe.$$.fragment),Bt=n(),p(Me.$$.fragment),Zt=n(),pe=i("p"),pe.innerHTML=Nl,kt=n(),p(re.$$.fragment),Wt=n(),ue=i("p"),ue.innerHTML=_l,At=n(),ce=i("p"),ce.textContent=Ql,Gt=n(),f=i("p"),f.innerHTML=Yl,Et=n(),ye=i("p"),ye.innerHTML=Hl,$t=n(),p(Je.$$.fragment),Vt=n(),we=i("p"),we.textContent=Xl,Rt=n(),Te=i("p"),Te.textContent=Fl,St=n(),p(de.$$.fragment),Nt=n(),p(me.$$.fragment),_t=n(),p(Ue.$$.fragment),Qt=n(),he=i("ol"),he.innerHTML=zl,Yt=n(),p(je.$$.fragment),Ht=n(),p(Ie.$$.fragment),Xt=n(),be=i("p"),be.innerHTML=ql,Ft=n(),p(ge.$$.fragment),zt=n(),p(Ce.$$.fragment),qt=n(),fe=i("p"),fe.textContent=Ll,Lt=n(),xe=i("p"),xe.textContent=Pl,Pt=n(),p(ve.$$.fragment),Dt=n(),Be=i("p"),Be.textContent=Dl,Kt=n(),p(Ze.$$.fragment),Ot=n(),p(ke.$$.fragment),el=n(),We=i("p"),We.textContent=Kl,tl=n(),Ae=i("ul"),Ae.innerHTML=Ol,ll=n(),Ge=i("p"),Ge.textContent=es,sl=n(),p(Ee.$$.fragment),nl=n(),$e=i("p"),$e.textContent=ts,al=n(),p(Ve.$$.fragment),il=n(),Re=i("ul"),Re.innerHTML=ls,ol=n(),p(Se.$$.fragment),Ml=n(),Ne=i("ul"),Ne.innerHTML=ss,pl=n(),_e=i("p"),_e.textContent=ns,rl=n(),p(Qe.$$.fragment),ul=n(),Fe=i("p"),this.h()},l(e){const t=ws("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),j=a(e),m=o(e,"P",{}),Ms(m).forEach(l),h=a(e),r(I.$$.fragment,e),g=a(e),r(U.$$.fragment,e),v=a(e),r(T.$$.fragment,e),b=a(e),r(B.$$.fragment,e),qe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1nor5c0"&&(Z.innerHTML=yl),Le=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1b2f48c"&&(k.textContent=Jl),Pe=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1jp5kiv"&&(W.textContent=wl),De=a(e),A=o(e,"UL",{"data-svelte-h":!0}),M(A)!=="svelte-a7ou7n"&&(A.innerHTML=Tl),Ke=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1ugtxvn"&&(G.innerHTML=dl),Oe=a(e),He=o(e,"IMG",{src:!0}),et=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1lbgv3o"&&(E.textContent=Ul),tt=a(e),r($.$$.fragment,e),lt=a(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-19p3p3d"&&(V.innerHTML=hl),st=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-y55i8i"&&(R.textContent=jl),nt=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-y4kupg"&&(S.textContent=Il),at=a(e),N=o(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-1b6z7ic"&&(N.innerHTML=bl),it=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-uopq3c"&&(_.innerHTML=gl),ot=a(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-gfolx1"&&(Q.textContent=Cl),Mt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1j1i1cv"&&(Y.textContent=fl),pt=a(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1ghwkh9"&&(H.textContent=xl),rt=a(e),Xe=o(e,"IMG",{src:!0}),ut=a(e),r(X.$$.fragment,e),ct=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-845rka"&&(F.innerHTML=Bl),yt=a(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-180snho"&&(z.textContent=Zl),Jt=a(e),q=o(e,"UL",{"data-svelte-h":!0}),M(q)!=="svelte-19qb8ke"&&(q.innerHTML=kl),wt=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1wz8jbt"&&(L.textContent=Wl),Tt=a(e),r(P.$$.fragment,e),dt=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1gk7uki"&&(D.textContent=Al),mt=a(e),r(C.$$.fragment,e),Ut=a(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-whkli4"&&(K.textContent=Gl),ht=a(e),r(O.$$.fragment,e),jt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-grnb59"&&(ee.textContent=El),It=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-ahtq0i"&&(te.innerHTML=$l),bt=a(e),le=o(e,"OL",{"data-svelte-h":!0}),M(le)!=="svelte-1vlvy45"&&(le.innerHTML=Vl),gt=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1h3g1zs"&&(se.textContent=Rl),Ct=a(e),r(ne.$$.fragment,e),ft=a(e),r(ae.$$.fragment,e),xt=a(e),ie=o(e,"OL",{"data-svelte-h":!0}),M(ie)!=="svelte-uvtwg2"&&(ie.innerHTML=Sl),vt=a(e),r(oe.$$.fragment,e),Bt=a(e),r(Me.$$.fragment,e),Zt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-r3242t"&&(pe.innerHTML=Nl),kt=a(e),r(re.$$.fragment,e),Wt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-jrgx8f"&&(ue.innerHTML=_l),At=a(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-8sir7q"&&(ce.textContent=Ql),Gt=a(e),f=o(e,"P",{align:!0,"data-svelte-h":!0}),M(f)!=="svelte-11rtdvt"&&(f.innerHTML=Yl),Et=a(e),ye=o(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-ofpo9r"&&(ye.innerHTML=Hl),$t=a(e),r(Je.$$.fragment,e),Vt=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-geglm0"&&(we.textContent=Xl),Rt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1iycphr"&&(Te.textContent=Fl),St=a(e),r(de.$$.fragment,e),Nt=a(e),r(me.$$.fragment,e),_t=a(e),r(Ue.$$.fragment,e),Qt=a(e),he=o(e,"OL",{"data-svelte-h":!0}),M(he)!=="svelte-19h0avy"&&(he.innerHTML=zl),Yt=a(e),r(je.$$.fragment,e),Ht=a(e),r(Ie.$$.fragment,e),Xt=a(e),be=o(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1j9zoi1"&&(be.innerHTML=ql),Ft=a(e),r(ge.$$.fragment,e),zt=a(e),r(Ce.$$.fragment,e),qt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-t1it0d"&&(fe.textContent=Ll),Lt=a(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-1lygj8"&&(xe.textContent=Pl),Pt=a(e),r(ve.$$.fragment,e),Dt=a(e),Be=o(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-8mtm8c"&&(Be.textContent=Dl),Kt=a(e),r(Ze.$$.fragment,e),Ot=a(e),r(ke.$$.fragment,e),el=a(e),We=o(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-5fyo5r"&&(We.textContent=Kl),tl=a(e),Ae=o(e,"UL",{"data-svelte-h":!0}),M(Ae)!=="svelte-162p62u"&&(Ae.innerHTML=Ol),ll=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1hbg2e4"&&(Ge.textContent=es),sl=a(e),r(Ee.$$.fragment,e),nl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-i4top7"&&($e.textContent=ts),al=a(e),r(Ve.$$.fragment,e),il=a(e),Re=o(e,"UL",{"data-svelte-h":!0}),M(Re)!=="svelte-8oe7h4"&&(Re.innerHTML=ls),ol=a(e),r(Se.$$.fragment,e),Ml=a(e),Ne=o(e,"UL",{"data-svelte-h":!0}),M(Ne)!=="svelte-1nt0hab"&&(Ne.innerHTML=ss),pl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-l1ns7z"&&(_e.textContent=ns),rl=a(e),r(Qe.$$.fragment,e),ul=a(e),Fe=o(e,"P",{}),Ms(Fe).forEach(l),this.h()},h(){ze(w,"name","hf:doc:metadata"),ze(w,"content",Is),os(He.src,ml="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||ze(He,"src",ml),os(Xe.src,vl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||ze(Xe,"src",vl),ze(f,"align","center")},m(e,t){Ts(document.head,w),s(e,j,t),s(e,m,t),s(e,h,t),u(I,e,t),s(e,g,t),u(U,e,t),s(e,v,t),u(T,e,t),s(e,b,t),u(B,e,t),s(e,qe,t),s(e,Z,t),s(e,Le,t),s(e,k,t),s(e,Pe,t),s(e,W,t),s(e,De,t),s(e,A,t),s(e,Ke,t),s(e,G,t),s(e,Oe,t),s(e,He,t),s(e,et,t),s(e,E,t),s(e,tt,t),u($,e,t),s(e,lt,t),s(e,V,t),s(e,st,t),s(e,R,t),s(e,nt,t),s(e,S,t),s(e,at,t),s(e,N,t),s(e,it,t),s(e,_,t),s(e,ot,t),s(e,Q,t),s(e,Mt,t),s(e,Y,t),s(e,pt,t),s(e,H,t),s(e,rt,t),s(e,Xe,t),s(e,ut,t),u(X,e,t),s(e,ct,t),s(e,F,t),s(e,yt,t),s(e,z,t),s(e,Jt,t),s(e,q,t),s(e,wt,t),s(e,L,t),s(e,Tt,t),u(P,e,t),s(e,dt,t),s(e,D,t),s(e,mt,t),u(C,e,t),s(e,Ut,t),s(e,K,t),s(e,ht,t),u(O,e,t),s(e,jt,t),s(e,ee,t),s(e,It,t),s(e,te,t),s(e,bt,t),s(e,le,t),s(e,gt,t),s(e,se,t),s(e,Ct,t),u(ne,e,t),s(e,ft,t),u(ae,e,t),s(e,xt,t),s(e,ie,t),s(e,vt,t),u(oe,e,t),s(e,Bt,t),u(Me,e,t),s(e,Zt,t),s(e,pe,t),s(e,kt,t),u(re,e,t),s(e,Wt,t),s(e,ue,t),s(e,At,t),s(e,ce,t),s(e,Gt,t),s(e,f,t),s(e,Et,t),s(e,ye,t),s(e,$t,t),u(Je,e,t),s(e,Vt,t),s(e,we,t),s(e,Rt,t),s(e,Te,t),s(e,St,t),u(de,e,t),s(e,Nt,t),u(me,e,t),s(e,_t,t),u(Ue,e,t),s(e,Qt,t),s(e,he,t),s(e,Yt,t),u(je,e,t),s(e,Ht,t),u(Ie,e,t),s(e,Xt,t),s(e,be,t),s(e,Ft,t),u(ge,e,t),s(e,zt,t),u(Ce,e,t),s(e,qt,t),s(e,fe,t),s(e,Lt,t),s(e,xe,t),s(e,Pt,t),u(ve,e,t),s(e,Dt,t),s(e,Be,t),s(e,Kt,t),u(Ze,e,t),s(e,Ot,t),u(ke,e,t),s(e,el,t),s(e,We,t),s(e,tl,t),s(e,Ae,t),s(e,ll,t),s(e,Ge,t),s(e,sl,t),u(Ee,e,t),s(e,nl,t),s(e,$e,t),s(e,al,t),u(Ve,e,t),s(e,il,t),s(e,Re,t),s(e,ol,t),u(Se,e,t),s(e,Ml,t),s(e,Ne,t),s(e,pl,t),s(e,_e,t),s(e,rl,t),u(Qe,e,t),s(e,ul,t),s(e,Fe,t),cl=!0},p(e,[t]){const as={};t&2&&(as.$$scope={dirty:t,ctx:e}),T.$set(as);const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),C.$set(is)},i(e){cl||(c(I.$$.fragment,e),c(U.$$.fragment,e),c(T.$$.fragment,e),c(B.$$.fragment,e),c($.$$.fragment,e),c(X.$$.fragment,e),c(P.$$.fragment,e),c(C.$$.fragment,e),c(O.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),c(Je.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(Ie.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(ve.$$.fragment,e),c(Ze.$$.fragment,e),c(ke.$$.fragment,e),c(Ee.$$.fragment,e),c(Ve.$$.fragment,e),c(Se.$$.fragment,e),c(Qe.$$.fragment,e),cl=!0)},o(e){y(I.$$.fragment,e),y(U.$$.fragment,e),y(T.$$.fragment,e),y(B.$$.fragment,e),y($.$$.fragment,e),y(X.$$.fragment,e),y(P.$$.fragment,e),y(C.$$.fragment,e),y(O.$$.fragment,e),y(ne.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(re.$$.fragment,e),y(Je.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(Ie.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(Ze.$$.fragment,e),y(ke.$$.fragment,e),y(Ee.$$.fragment,e),y(Ve.$$.fragment,e),y(Se.$$.fragment,e),y(Qe.$$.fragment,e),cl=!1},d(e){e&&(l(j),l(m),l(h),l(g),l(v),l(b),l(qe),l(Z),l(Le),l(k),l(Pe),l(W),l(De),l(A),l(Ke),l(G),l(Oe),l(He),l(et),l(E),l(tt),l(lt),l(V),l(st),l(R),l(nt),l(S),l(at),l(N),l(it),l(_),l(ot),l(Q),l(Mt),l(Y),l(pt),l(H),l(rt),l(Xe),l(ut),l(ct),l(F),l(yt),l(z),l(Jt),l(q),l(wt),l(L),l(Tt),l(dt),l(D),l(mt),l(Ut),l(K),l(ht),l(jt),l(ee),l(It),l(te),l(bt),l(le),l(gt),l(se),l(Ct),l(ft),l(xt),l(ie),l(vt),l(Bt),l(Zt),l(pe),l(kt),l(Wt),l(ue),l(At),l(ce),l(Gt),l(f),l(Et),l(ye),l($t),l(Vt),l(we),l(Rt),l(Te),l(St),l(Nt),l(_t),l(Qt),l(he),l(Yt),l(Ht),l(Xt),l(be),l(Ft),l(zt),l(qt),l(fe),l(Lt),l(xe),l(Pt),l(Dt),l(Be),l(Kt),l(Ot),l(el),l(We),l(tl),l(Ae),l(ll),l(Ge),l(sl),l(nl),l($e),l(al),l(il),l(Re),l(ol),l(Ml),l(Ne),l(pl),l(_e),l(rl),l(ul),l(Fe)),l(w),J(I,e),J(U,e),J(T,e),J(B,e),J($,e),J(X,e),J(P,e),J(C,e),J(O,e),J(ne,e),J(ae,e),J(oe,e),J(Me,e),J(re,e),J(Je,e),J(de,e),J(me,e),J(Ue,e),J(je,e),J(Ie,e),J(ge,e),J(Ce,e),J(ve,e),J(Ze,e),J(ke,e),J(Ee,e),J(Ve,e),J(Se,e),J(Qe,e)}}}const Is='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function bs(Ye){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends ys{constructor(w){super(),Js(this,w,bs,js,us,{})}}export{Zs as component};
