import{s as Re,n as He,o as ze}from"../chunks/scheduler.f6319a2a.js";import{S as Ye,i as Se,g as o,s as n,r as i,A as xe,h as p,f as t,c as a,j as Ae,u as M,x as m,k as Ee,y as Fe,a as l,v as c,d as y,t as r,w as b}from"../chunks/index.85aa684c.js";import{C as z}from"../chunks/CodeBlock.3400fc53.js";import{D as Le}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as Ue,E as De}from"../chunks/index.9e1e6fd7.js";function Pe(ge){let w,x,Y,F,u,L,J,D,h,fe=`In the end, an agent can be defined by simple components: it has tools, prompts.
And most importantly, it has a memory of past steps, drawing a history of planning, execution, and errors.`,P,d,q,T,Be="We propose several features to inspect a past agent run.",K,j,Ie='You can instrument the agent’s run to display it in a great UI that lets you zoom in/out on specific steps, as highlighted in the <a href="./inspect_runs">instrumentation guide</a>.',O,U,Ce="You can also use <code>agent.replay()</code>, as follows:",ee,g,Ze="After the agent has run:",se,f,te,B,ve="If you want to replay this last run, just use:",le,I,ne,C,ae,Z,_e="Many advanced use cases require dynamic modification of the agent’s memory.",oe,v,ke="You can access the agent’s memory using:",pe,_,me,k,We="Use <code>agent.memory.get_full_steps()</code> to get full steps as dictionaries.",ie,W,Ve="You can also use step callbacks to dynamically change the agent’s memory.",Me,V,Ne="Step callbacks can access the <code>agent</code> itself in their arguments, so they can access any memory step as highlighted above, and change it if needed. For instance, let’s say you are observing screenshots of each step performed by a web browser agent. You want to log the newest screenshot, and remove the images from ancient steps to save on token costs.",ce,N,Xe=`You could run something like the following.
<em>Note: this code is incomplete, some imports and object definitions have been removed for the sake of concision, visit <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">the original script</a> to get the full working code.</em>`,ye,X,re,Q,Qe="Then you should pass this function in the <code>step_callbacks</code> argument upon initialization of your agent:",be,$,we,G,$e='Head to our <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">vision web browser code</a> to see the full working example.',ue,A,Je,E,Ge=`This can be useful in case you have tool calls that take days: you can just run your agents step by step.
This will also let you update the memory on each step.`,he,R,de,H,Te,S,je;return u=new Ue({props:{title:"📚 Manage your agent’s memory",local:"-manage-your-agents-memory",headingTag:"h1"}}),J=new Le({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/memory.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/memory.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/memory.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/memory.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/memory.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/memory.ipynb"}]}}),d=new Ue({props:{title:"Replay your agent’s memory",local:"replay-your-agents-memory",headingTag:"h3"}}),f=new z({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSUyQyUyMHZlcmJvc2l0eV9sZXZlbCUzRDApJTBBJTBBcmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKCUyMldoYXQncyUyMHRoZSUyMDIwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(tools=[], model=HfApiModel(), verbosity_level=<span class="hljs-number">0</span>)

result = agent.run(<span class="hljs-string">&quot;What&#x27;s the 20th Fibonacci number?&quot;</span>)`,wrap:!1}}),I=new z({props:{code:"YWdlbnQucmVwbGF5KCk=",highlighted:"agent.replay()",wrap:!1}}),C=new Ue({props:{title:"Dynamically change the agent’s memory",local:"dynamically-change-the-agents-memory",headingTag:"h3"}}),_=new z({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBBY3Rpb25TdGVwJTBBJTBBc3lzdGVtX3Byb21wdF9zdGVwJTIwJTNEJTIwYWdlbnQubWVtb3J5LnN5c3RlbV9wcm9tcHQlMEFwcmludCglMjJUaGUlMjBzeXN0ZW0lMjBwcm9tcHQlMjBnaXZlbiUyMHRvJTIwdGhlJTIwYWdlbnQlMjB3YXMlM0ElMjIpJTBBcHJpbnQoc3lzdGVtX3Byb21wdF9zdGVwLnN5c3RlbV9wcm9tcHQpJTBBJTBBdGFza19zdGVwJTIwJTNEJTIwYWdlbnQubWVtb3J5LnN0ZXBzJTVCMCU1RCUwQXByaW50KCUyMiU1Q24lNUNuVGhlJTIwZmlyc3QlMjB0YXNrJTIwc3RlcCUyMHdhcyUzQSUyMiklMEFwcmludCh0YXNrX3N0ZXAudGFzayklMEElMEFmb3IlMjBzdGVwJTIwaW4lMjBhZ2VudC5tZW1vcnkuc3RlcHMlM0ElMEElMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2Uoc3RlcCUyQyUyMEFjdGlvblN0ZXApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzdGVwLmVycm9yJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25TdGVwJTIwJTdCc3RlcC5zdGVwX251bWJlciU3RCUyMGdvdCUyMHRoaXMlMjBlcnJvciUzQSU1Q24lN0JzdGVwLmVycm9yJTdEJTVDbiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25TdGVwJTIwJTdCc3RlcC5zdGVwX251bWJlciU3RCUyMGdvdCUyMHRoZXNlJTIwb2JzZXJ2YXRpb25zJTNBJTVDbiU3QnN0ZXAub2JzZXJ2YXRpb25zJTdEJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ActionStep

system_prompt_step = agent.memory.system_prompt
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The system prompt given to the agent was:&quot;</span>)
<span class="hljs-built_in">print</span>(system_prompt_step.system_prompt)

task_step = agent.memory.steps[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n\\nThe first task step was:&quot;</span>)
<span class="hljs-built_in">print</span>(task_step.task)

<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> agent.memory.steps:
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step, ActionStep):
        <span class="hljs-keyword">if</span> step.error <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStep <span class="hljs-subst">{step.step_number}</span> got this error:\\n<span class="hljs-subst">{step.error}</span>\\n&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStep <span class="hljs-subst">{step.step_number}</span> got these observations:\\n<span class="hljs-subst">{step.observations}</span>\\n&quot;</span>)`,wrap:!1}}),X=new z({props:{code:"aW1wb3J0JTIwaGVsaXVtJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWZyb20lMjB0aW1lJTIwaW1wb3J0JTIwc2xlZXAlMEElMEFkZWYlMjB1cGRhdGVfc2NyZWVuc2hvdChtZW1vcnlfc3RlcCUzQSUyMEFjdGlvblN0ZXAlMkMlMjBhZ2VudCUzQSUyMENvZGVBZ2VudCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMHNsZWVwKDEuMCklMjAlMjAlMjMlMjBMZXQlMjBKYXZhU2NyaXB0JTIwYW5pbWF0aW9ucyUyMGhhcHBlbiUyMGJlZm9yZSUyMHRha2luZyUyMHRoZSUyMHNjcmVlbnNob3QlMEElMjAlMjAlMjAlMjBkcml2ZXIlMjAlM0QlMjBoZWxpdW0uZ2V0X2RyaXZlcigpJTBBJTIwJTIwJTIwJTIwbGF0ZXN0X3N0ZXAlMjAlM0QlMjBtZW1vcnlfc3RlcC5zdGVwX251bWJlciUwQSUyMCUyMCUyMCUyMGZvciUyMHByZXZpb3VzX21lbW9yeV9zdGVwJTIwaW4lMjBhZ2VudC5tZW1vcnkuc3RlcHMlM0ElMjAlMjAlMjMlMjBSZW1vdmUlMjBwcmV2aW91cyUyMHNjcmVlbnNob3RzJTIwZnJvbSUyMGxvZ3MlMjBmb3IlMjBsZWFuJTIwcHJvY2Vzc2luZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZShwcmV2aW91c19tZW1vcnlfc3RlcCUyQyUyMEFjdGlvblN0ZXApJTIwYW5kJTIwcHJldmlvdXNfbWVtb3J5X3N0ZXAuc3RlcF9udW1iZXIlMjAlM0MlM0QlMjBsYXRlc3Rfc3RlcCUyMC0lMjAyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJldmlvdXNfbWVtb3J5X3N0ZXAub2JzZXJ2YXRpb25zX2ltYWdlcyUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBwbmdfYnl0ZXMlMjAlM0QlMjBkcml2ZXIuZ2V0X3NjcmVlbnNob3RfYXNfcG5nKCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhwbmdfYnl0ZXMpKSUwQSUyMCUyMCUyMCUyMG1lbW9yeV9zdGVwLm9ic2VydmF0aW9uc19pbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb3B5KCklNUQ=",highlighted:`<span class="hljs-keyword">import</span> helium
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> time <span class="hljs-keyword">import</span> sleep

<span class="hljs-keyword">def</span> <span class="hljs-title function_">update_screenshot</span>(<span class="hljs-params">memory_step: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Let JavaScript animations happen before taking the screenshot</span>
    driver = helium.get_driver()
    latest_step = memory_step.step_number
    <span class="hljs-keyword">for</span> previous_memory_step <span class="hljs-keyword">in</span> agent.memory.steps:  <span class="hljs-comment"># Remove previous screenshots from logs for lean processing</span>
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(previous_memory_step, ActionStep) <span class="hljs-keyword">and</span> previous_memory_step.step_number &lt;= latest_step - <span class="hljs-number">2</span>:
            previous_memory_step.observations_images = <span class="hljs-literal">None</span>
    png_bytes = driver.get_screenshot_as_png()
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
    memory_step.observations_images = [image.copy()]`,wrap:!1}}),$=new z({props:{code:"Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUyQyUyMGdvX2JhY2slMkMlMjBjbG9zZV9wb3B1cHMlMkMlMjBzZWFyY2hfaXRlbV9jdHJsX2YlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJoZWxpdW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBzdGVwX2NhbGxiYWNrcyUzRCU1QnVwZGF0ZV9zY3JlZW5zaG90JTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QyJTJDJTBBKQ==",highlighted:`CodeAgent(
    tools=[DuckDuckGoSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[update_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),A=new Ue({props:{title:"Run agents one step at a time",local:"run-agents-one-step-at-a-time",headingTag:"h3"}}),R=new z({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTJDJTIwQWN0aW9uU3RlcCUyQyUyMFRhc2tTdGVwJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSUyQyUyMHZlcmJvc2l0eV9sZXZlbCUzRDEpJTBBYWdlbnQucHl0aG9uX2V4ZWN1dG9yLnNlbmRfdG9vbHMoJTdCKiphZ2VudC50b29scyU3RCklMEFwcmludChhZ2VudC5tZW1vcnkuc3lzdGVtX3Byb21wdCklMEElMEF0YXNrJTIwJTNEJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwMjB0aCUyMEZpYm9uYWNjaSUyMG51bWJlciUzRiUyMiUwQSUwQSUyMyUyMFlvdSUyMGNvdWxkJTIwbW9kaWZ5JTIwdGhlJTIwbWVtb3J5JTIwYXMlMjBuZWVkZWQlMjBoZXJlJTIwYnklMjBpbnB1dHRpbmclMjB0aGUlMjBtZW1vcnklMjBvZiUyMGFub3RoZXIlMjBhZ2VudC4lMEElMjMlMjBhZ2VudC5tZW1vcnkuc3RlcHMlMjAlM0QlMjBwcmV2aW91c19hZ2VudC5tZW1vcnkuc3RlcHMlMEElMEElMjMlMjBMZXQncyUyMHN0YXJ0JTIwYSUyMG5ldyUyMHRhc2shJTBBYWdlbnQubWVtb3J5LnN0ZXBzLmFwcGVuZChUYXNrU3RlcCh0YXNrJTNEdGFzayUyQyUyMHRhc2tfaW1hZ2VzJTNEJTVCJTVEKSklMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBOb25lJTBBc3RlcF9udW1iZXIlMjAlM0QlMjAxJTBBd2hpbGUlMjBmaW5hbF9hbnN3ZXIlMjBpcyUyME5vbmUlMjBhbmQlMjBzdGVwX251bWJlciUyMCUzQyUzRCUyMDEwJTNBJTBBJTIwJTIwJTIwJTIwbWVtb3J5X3N0ZXAlMjAlM0QlMjBBY3Rpb25TdGVwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0ZXBfbnVtYmVyJTNEc3RlcF9udW1iZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvYnNlcnZhdGlvbnNfaW1hZ2VzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJ1biUyMG9uZSUyMHN0ZXAuJTBBJTIwJTIwJTIwJTIwZmluYWxfYW5zd2VyJTIwJTNEJTIwYWdlbnQuc3RlcChtZW1vcnlfc3RlcCklMEElMjAlMjAlMjAlMjBhZ2VudC5tZW1vcnkuc3RlcHMuYXBwZW5kKG1lbW9yeV9zdGVwKSUwQSUyMCUyMCUyMCUyMHN0ZXBfbnVtYmVyJTIwJTJCJTNEJTIwMSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENoYW5nZSUyMHRoZSUyMG1lbW9yeSUyMGFzJTIweW91JTIwcGxlYXNlISUwQSUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMGluc3RhbmNlJTIwdG8lMjB1cGRhdGUlMjB0aGUlMjBsYXRlc3QlMjBzdGVwJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwYWdlbnQubWVtb3J5LnN0ZXBzJTVCLTElNUQlMjAlM0QlMjAuLi4lMEElMEFwcmludCglMjJUaGUlMjBmaW5hbCUyMGFuc3dlciUyMGlzJTNBJTIyJTJDJTIwZmluYWxfYW5zd2VyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent, ActionStep, TaskStep

agent = CodeAgent(tools=[], model=HfApiModel(), verbosity_level=<span class="hljs-number">1</span>)
agent.python_executor.send_tools({**agent.tools})
<span class="hljs-built_in">print</span>(agent.memory.system_prompt)

task = <span class="hljs-string">&quot;What is the 20th Fibonacci number?&quot;</span>

<span class="hljs-comment"># You could modify the memory as needed here by inputting the memory of another agent.</span>
<span class="hljs-comment"># agent.memory.steps = previous_agent.memory.steps</span>

<span class="hljs-comment"># Let&#x27;s start a new task!</span>
agent.memory.steps.append(TaskStep(task=task, task_images=[]))

final_answer = <span class="hljs-literal">None</span>
step_number = <span class="hljs-number">1</span>
<span class="hljs-keyword">while</span> final_answer <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> step_number &lt;= <span class="hljs-number">10</span>:
    memory_step = ActionStep(
        step_number=step_number,
        observations_images=[],
    )
    <span class="hljs-comment"># Run one step.</span>
    final_answer = agent.step(memory_step)
    agent.memory.steps.append(memory_step)
    step_number += <span class="hljs-number">1</span>

    <span class="hljs-comment"># Change the memory as you please!</span>
    <span class="hljs-comment"># For instance to update the latest step:</span>
    <span class="hljs-comment"># agent.memory.steps[-1] = ...</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The final answer is:&quot;</span>, final_answer)`,wrap:!1}}),H=new De({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/memory.mdx"}}),{c(){w=o("meta"),x=n(),Y=o("p"),F=n(),i(u.$$.fragment),L=n(),i(J.$$.fragment),D=n(),h=o("p"),h.textContent=fe,P=n(),i(d.$$.fragment),q=n(),T=o("p"),T.textContent=Be,K=n(),j=o("p"),j.innerHTML=Ie,O=n(),U=o("p"),U.innerHTML=Ce,ee=n(),g=o("p"),g.textContent=Ze,se=n(),i(f.$$.fragment),te=n(),B=o("p"),B.textContent=ve,le=n(),i(I.$$.fragment),ne=n(),i(C.$$.fragment),ae=n(),Z=o("p"),Z.textContent=_e,oe=n(),v=o("p"),v.textContent=ke,pe=n(),i(_.$$.fragment),me=n(),k=o("p"),k.innerHTML=We,ie=n(),W=o("p"),W.textContent=Ve,Me=n(),V=o("p"),V.innerHTML=Ne,ce=n(),N=o("p"),N.innerHTML=Xe,ye=n(),i(X.$$.fragment),re=n(),Q=o("p"),Q.innerHTML=Qe,be=n(),i($.$$.fragment),we=n(),G=o("p"),G.innerHTML=$e,ue=n(),i(A.$$.fragment),Je=n(),E=o("p"),E.textContent=Ge,he=n(),i(R.$$.fragment),de=n(),i(H.$$.fragment),Te=n(),S=o("p"),this.h()},l(e){const s=xe("svelte-u9bgzb",document.head);w=p(s,"META",{name:!0,content:!0}),s.forEach(t),x=a(e),Y=p(e,"P",{}),Ae(Y).forEach(t),F=a(e),M(u.$$.fragment,e),L=a(e),M(J.$$.fragment,e),D=a(e),h=p(e,"P",{"data-svelte-h":!0}),m(h)!=="svelte-102p4os"&&(h.textContent=fe),P=a(e),M(d.$$.fragment,e),q=a(e),T=p(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-p9bsvd"&&(T.textContent=Be),K=a(e),j=p(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-cyladv"&&(j.innerHTML=Ie),O=a(e),U=p(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1j5hyq7"&&(U.innerHTML=Ce),ee=a(e),g=p(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-kdqcx3"&&(g.textContent=Ze),se=a(e),M(f.$$.fragment,e),te=a(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-16cln5c"&&(B.textContent=ve),le=a(e),M(I.$$.fragment,e),ne=a(e),M(C.$$.fragment,e),ae=a(e),Z=p(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-8gbd4j"&&(Z.textContent=_e),oe=a(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-dw95g"&&(v.textContent=ke),pe=a(e),M(_.$$.fragment,e),me=a(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-oqerv4"&&(k.innerHTML=We),ie=a(e),W=p(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-2c0lec"&&(W.textContent=Ve),Me=a(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1g68dq6"&&(V.innerHTML=Ne),ce=a(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1g8132p"&&(N.innerHTML=Xe),ye=a(e),M(X.$$.fragment,e),re=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1s6pldm"&&(Q.innerHTML=Qe),be=a(e),M($.$$.fragment,e),we=a(e),G=p(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1c9b7q3"&&(G.innerHTML=$e),ue=a(e),M(A.$$.fragment,e),Je=a(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1jw480t"&&(E.textContent=Ge),he=a(e),M(R.$$.fragment,e),de=a(e),M(H.$$.fragment,e),Te=a(e),S=p(e,"P",{}),Ae(S).forEach(t),this.h()},h(){Ee(w,"name","hf:doc:metadata"),Ee(w,"content",qe)},m(e,s){Fe(document.head,w),l(e,x,s),l(e,Y,s),l(e,F,s),c(u,e,s),l(e,L,s),c(J,e,s),l(e,D,s),l(e,h,s),l(e,P,s),c(d,e,s),l(e,q,s),l(e,T,s),l(e,K,s),l(e,j,s),l(e,O,s),l(e,U,s),l(e,ee,s),l(e,g,s),l(e,se,s),c(f,e,s),l(e,te,s),l(e,B,s),l(e,le,s),c(I,e,s),l(e,ne,s),c(C,e,s),l(e,ae,s),l(e,Z,s),l(e,oe,s),l(e,v,s),l(e,pe,s),c(_,e,s),l(e,me,s),l(e,k,s),l(e,ie,s),l(e,W,s),l(e,Me,s),l(e,V,s),l(e,ce,s),l(e,N,s),l(e,ye,s),c(X,e,s),l(e,re,s),l(e,Q,s),l(e,be,s),c($,e,s),l(e,we,s),l(e,G,s),l(e,ue,s),c(A,e,s),l(e,Je,s),l(e,E,s),l(e,he,s),c(R,e,s),l(e,de,s),c(H,e,s),l(e,Te,s),l(e,S,s),je=!0},p:He,i(e){je||(y(u.$$.fragment,e),y(J.$$.fragment,e),y(d.$$.fragment,e),y(f.$$.fragment,e),y(I.$$.fragment,e),y(C.$$.fragment,e),y(_.$$.fragment,e),y(X.$$.fragment,e),y($.$$.fragment,e),y(A.$$.fragment,e),y(R.$$.fragment,e),y(H.$$.fragment,e),je=!0)},o(e){r(u.$$.fragment,e),r(J.$$.fragment,e),r(d.$$.fragment,e),r(f.$$.fragment,e),r(I.$$.fragment,e),r(C.$$.fragment,e),r(_.$$.fragment,e),r(X.$$.fragment,e),r($.$$.fragment,e),r(A.$$.fragment,e),r(R.$$.fragment,e),r(H.$$.fragment,e),je=!1},d(e){e&&(t(x),t(Y),t(F),t(L),t(D),t(h),t(P),t(q),t(T),t(K),t(j),t(O),t(U),t(ee),t(g),t(se),t(te),t(B),t(le),t(ne),t(ae),t(Z),t(oe),t(v),t(pe),t(me),t(k),t(ie),t(W),t(Me),t(V),t(ce),t(N),t(ye),t(re),t(Q),t(be),t(we),t(G),t(ue),t(Je),t(E),t(he),t(de),t(Te),t(S)),t(w),b(u,e),b(J,e),b(d,e),b(f,e),b(I,e),b(C,e),b(_,e),b(X,e),b($,e),b(A,e),b(R,e),b(H,e)}}}const qe='{"title":"📚 Manage your agent’s memory","local":"-manage-your-agents-memory","sections":[{"title":"Replay your agent’s memory","local":"replay-your-agents-memory","sections":[],"depth":3},{"title":"Dynamically change the agent’s memory","local":"dynamically-change-the-agents-memory","sections":[],"depth":3},{"title":"Run agents one step at a time","local":"run-agents-one-step-at-a-time","sections":[],"depth":3}],"depth":1}';function Ke(ge){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Ye{constructor(w){super(),Se(this,w,Ke,Pe,Re,{})}}export{ns as component};
