# スモールコース

これは、特定のユースケースに合わせて言語モデルを調整するための実践的なコースです。ほとんどのローカルマシンで実行できるため、言語モデルの調整を始めるのに便利です。GPUの要件は最小限で、有料サービスは必要ありません。このコースは[SmolLM2](https://github.com/huggingface/smollm/tree/main)シリーズのモデルに基づいていますが、ここで学んだスキルを大規模なモデルや他の小型言語モデルに転用することができます。

<a href="http://hf.co/join/discord">
<img src="https://img.shields.io/badge/Discord-7289DA?&logo=discord&logoColor=white"/>
</a>

<div style="background: linear-gradient(to right, #e0f7fa, #e1bee7, orange); padding: 20px; border-radius: 5px; margin-bottom: 20px; color: purple;">
    <h2>参加は無料で、今すぐ始められます！</h2>
    <p>このコースはオープンでピアレビューされています。コースに参加するには、<strong>プルリクエストを開く</strong>ことで、あなたの作業をレビューに提出してください。以下の手順に従ってください：</p>
    <ol>
        <li>リポジトリをフォークします <a href="https://github.com/huggingface/smol-course/fork">こちら</a></li>
        <li>資料を読み、変更を加え、演習を行い、自分の例を追加します。</li>
        <li>december_2024ブランチでプルリクエストを開きます</li>
        <li>レビューを受けてマージされます</li>
    </ol>
    <p>これにより、学習を助け、常に改善されるコミュニティ主導のコースを構築することができます。</p>
</div>

このプロセスについては、この[ディスカッションスレッド](https://github.com/huggingface/smol-course/discussions/2#discussion-7602932)で議論できます。

## コース概要

このコースは、小型言語モデルを使用した実践的なアプローチを提供し、初期のトレーニングから本番展開までをカバーします。

| モジュール | 説明 | ステータス | リリース日 |
|--------|-------------|---------|--------------|
| [インストラクションチューニング](./1_instruction_tuning) | 教師あり微調整、チャットテンプレート、および基本的な指示に従う方法を学びます | ✅ 準備完了 | 2024年12月3日 |
| [選好整合](./2_preference_alignment) | DPOおよびORPO技術を探求し、人間の選好にモデルを整合させる方法を学びます | ✅ 準備完了  | 2024年12月6日 |
| [パラメータ効率の良い微調整](./3_parameter_efficient_finetuning) | LoRA、プロンプトチューニング、および効率的な適応方法を学びます | ✅ 準備完了 | 2024年12月9日 |
| [評価](./4_evaluation) | 自動ベンチマークを使用し、カスタムドメイン評価を作成する方法を学びます | ✅ 準備完了 | 2024年12月13日 |
| [ビジョン言語モデル](./5_vision_language_models) | マルチモーダルモデルをビジョン言語タスクに適応させる方法を学びます | ✅ 準備完了 | 2024年12月16日 |
| [合成データセット](./6_synthetic_datasets) | トレーニング用の合成データセットを作成し、検証する方法を学びます | ✅ 準備完了 | 2024年12月20日 |
| [推論](./7_inference) | モデルを効率的に推論する方法を学びます | [🚧 作業中](https://github.com/huggingface/smol-course/pull/150) | 2025年1月8日 |
| [エージェント](./8_agents) | 自分のエージェントAIを構築する方法を学びます | ✅ 準備完了 | 2025年1月13日 ||
| キャップストーンプロジェクト | 学んだことを使ってリーダーボードを登りましょう！ | [🚧 作業中](https://github.com/huggingface/smol-course/pull/97) | 2025年1月10日 |

## なぜ小型言語モデルなのか？

大規模な言語モデルは印象的な能力を示していますが、しばしば多くの計算リソースを必要とし、特定のアプリケーションには過剰な場合があります。小型言語モデルは、ドメイン固有のアプリケーションに対していくつかの利点を提供します：

- **効率性**：トレーニングと展開に必要な計算リソースが大幅に少ない
- **カスタマイズ**：特定のドメインに簡単に微調整および適応可能
- **制御**：モデルの動作をよりよく理解し、制御できる
- **コスト**：トレーニングと推論の運用コストが低い
- **プライバシー**：データを外部APIに送信せずにローカルで実行可能
- **グリーンテクノロジー**：リソースの効率的な使用を推進し、炭素排出量を削減
- **学術研究の容易さ**：最先端のLLMを使用した学術研究のための簡単なスターターを提供し、物流の制約を減らす

## 前提条件

開始する前に、以下を確認してください：
- 機械学習と自然言語処理の基本的な理解
- Python、PyTorch、および`transformers`ライブラリに精通していること
- 事前学習された言語モデルとラベル付きデータセットへのアクセス

## インストール

コースをパッケージとして維持しているため、パッケージマネージャーを使用して依存関係を簡単にインストールできます。`uv`をお勧めしますが、`pip`や`pdm`などの代替手段も使用できます。

### `uv`を使用する場合

`uv`がインストールされている場合、次のようにしてコースをインストールできます：

```bash
uv venv --python 3.11.0
uv sync
```

### `pip`を使用する場合

すべての例は**python 3.11**環境で実行されるため、次のように環境を作成し、依存関係をインストールします：

```bash
# python -m venv .venv
# source .venv/bin/activate
pip install -r requirements.txt
```

### Google Colab

**Google Colabから**は、使用するハードウェアに基づいて柔軟に依存関係をインストールする必要があります。次のようにします：

```bash
pip install transformers trl datasets huggingface_hub
```



<EditOnGithub source="https://github.com/huggingface/smol-course/blob/main/units/ja/README.md" />