import{s as hl,n as Ul,o as dl}from"../chunks/scheduler.19cc4639.js";import{S as Jl,i as bl,e as a,s,c as M,h as jl,a as o,d as l,b as i,f as Be,g as m,j as r,k as Ze,l as bt,m as n,n as p,t as u,o as c,p as T}from"../chunks/index.6703add8.js";import{C as wl,H as y,E as Cl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3db827b3.js";import{C as jt}from"../chunks/CodeBlock.321a03bc.js";function vl(He){let g,vt,wt,$t,d,_t,J,It,b,Ae="<strong>Hugging Face Jobs</strong> provides fully managed cloud infrastructure for training models without the hassle of setting up GPUs, managing dependencies, or configuring environments locally. This is particularly valuable for SFT training, which can be resource-intensive and time-consuming.",Lt,j,Et,w,Fe="<li><strong>Scalable Infrastructure</strong>: Access to high-end GPUs (A100, L4, etc.) without hardware investment</li> <li><strong>Zero Setup</strong>: No need to manage CUDA drivers, Docker containers, or environment configurations</li> <li><strong>Cost Effective</strong>: Pay only for compute time used, with automatic shutdown after completion</li> <li><strong>Integrated Workflow</strong>: Seamless integration with Hugging Face Hub for model storage and sharing</li> <li><strong>Monitoring</strong>: Built-in logging and progress tracking through the Hub interface</li>",Bt,C,Zt,v,ke="To use Hugging Face Jobs, you need:",Ht,$,Ge='<li>A <strong>Pro, Team, or Enterprise</strong> Hugging Face plan which you can get <a href="https://huggingface.co/pricing" rel="nofollow">here</a></li> <li>Authentication via <code>hf auth login</code></li>',At,_,Ft,I,Re="The best way to run TRL with HF jobs is using the built-in scripts. They take advantage of <code>uv</code> to manage dependencies and <code>hf jobs</code> to run the training job.",kt,L,xe="This guide will walk you through using TRL’s built-in scripts to train a model with Hugging Face Jobs. If you want to use a custom script, you can implement <code>uv</code> dependencies and run the script with <code>hf jobs run</code>.",Gt,f,dt,Ve="Create a custom training script with inline dependencies",Ie,E,Le,Jt,We="Then run with the Jobs CLI:",Ee,B,Rt,Z,xt,H,Xe="Choose the right hardware flavor based on your model size and training requirements:",Vt,A,Se="<strong>For SmolLM3-3B (Recommended)</strong>:",Wt,F,Qe="<li><code>a10g-large</code>: 24GB GPU memory, cost-effective for most SFT tasks</li> <li><code>a100-large</code>: 40GB GPU memory, fastest training with larger batch sizes</li> <li><code>l4x1</code>: 24GB GPU memory, multi-GPU setup for distributed training</li>",Xt,k,Ne="<strong>For Larger Models (7B+)</strong>:",St,G,Ye="<li><code>a100-large</code>: Required for 7B+ models</li> <li><code>l4x4</code>: Multi-GPU setup for distributed training</li>",Qt,R,ze="<strong>Budget Options</strong>:",Nt,x,Pe="<li><code>t4-small</code>: 16GB GPU memory, slower but economical for experimentation</li> <li><code>l4x1</code>: 24GB GPU memory, good balance of cost and performance</li>",Yt,h,qe='<p>For a detailed comparison of the different hardware flavors, you can check out the <a href="https://huggingface.co/pricing" rel="nofollow">Pricing Page</a> page.</p>',zt,V,Pt,W,qt,X,De="<strong>Environment Variables and Secrets</strong>:",Dt,S,Oe="If you’re working with a custom script, you can use the <code>--secrets</code> flag to pass in environment variables.",Ot,Q,Kt,N,te,Y,Ke='To check you training job, you can use the <code>hf jobs</code> command or you can go to <a href="https://huggingface.co/settings/jobs" rel="nofollow">Job Settings</a> on the Hub.',ee,z,tl="<strong>Check Job Status</strong>:",le,P,ne,q,se,D,el="Enable LoRA when using TRL’s maintained SFT script by passing PEFT flags. See the script for authoritative flags and defaults: <code>https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py</code>.",ie,O,ae,K,ll="Notes:",oe,tt,nl="<li>Confirm flag names in the TRL SFT script before running: <code>https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py</code>.</li> <li>LoRA trains small adapters, which you can keep separate or merge later for deployment.</li>",re,et,Me,lt,sl="You can monitor your training job with Trackio.",me,nt,il='<img src="https://github.com/user-attachments/assets/f3eac49e-d8ee-4fc0-b1ca-aedfc6d6fae1" alt="Trackio Monitoring"/>',pe,st,ue,it,al="Approximate costs for SmolLM3-3B SFT training (1000 steps):",ce,at,ol="<li>l4x1: ~$3-4 per hour (24GB GPU memory)</li> <li>a10g-large: ~$4-6 per hour (24GB GPU memory)</li> <li>a100-large: ~$8-12 per hour (40GB GPU memory)</li>",Te,ot,rl="Training typically takes 30-90 minutes for 1000 steps depending on hardware and configuration, making Jobs cost-effective compared to local GPU rental or cloud instances.",fe,rt,Ml="<strong>Cost-Saving Tips</strong>:",ye,Mt,ml="<li>Use smaller batch sizes with gradient accumulation to fit on cheaper GPUs</li> <li>Start with shorter training runs (500 steps) to validate your setup</li> <li>Use <code>l4x1</code> for initial experiments, then scale to faster GPUs for production</li> <li>Set appropriate timeouts to avoid unexpected charges</li>",ge,mt,he,pt,pl="<strong>Out of Memory Errors</strong>:",Ue,ut,ul="<li>Reduce <code>per_device_train_batch_size</code></li> <li>Enable gradient checkpointing</li> <li>Use smaller <code>max_length</code></li>",de,ct,cl="<strong>Timeout Issues</strong>:",Je,Tt,Tl="<li>Increase timeout parameter</li> <li>Reduce training steps or use more powerful hardware</li> <li>Optimize data loading and preprocessing</li>",be,ft,fl="<strong>Authentication Errors</strong>:",je,yt,yl="<li>Ensure HF_TOKEN is correctly set as a secret</li> <li>Verify your Hugging Face account has the required plan</li> <li>Check token permissions for model uploads</li>",we,gt,Ce,ht,gl='<li><a href="https://huggingface.co/docs/huggingface_hub/guides/jobs" rel="nofollow">Hugging Face Jobs Documentation</a> - Complete Jobs guide</li> <li><a href="https://huggingface.co/docs/trl/main/en/jobs_training" rel="nofollow">TRL Jobs Training Guide</a> - TRL-specific Jobs examples</li> <li><a href="https://huggingface.co/pricing" rel="nofollow">Jobs Pricing</a> - Current pricing for different hardware flavors</li> <li><a href="https://huggingface.co/docs/huggingface_hub/guides/cli#hf-jobs" rel="nofollow">Jobs CLI Reference</a> - Command-line interface details</li>',ve,Ut,$e,Ct,_e;return d=new wl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new y({props:{title:"Training with Hugging Face Jobs",local:"training-with-hugging-face-jobs",headingTag:"h1"}}),j=new y({props:{title:"Why Use Jobs for SFT Training?",local:"why-use-jobs-for-sft-training",headingTag:"h2"}}),C=new y({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),_=new y({props:{title:"Running SFT with Jobs: Two Approaches",local:"running-sft-with-jobs-two-approaches",headingTag:"h2"}}),E=new jt({props:{code:"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",highlighted:`<span class="hljs-comment"># sft_training.py</span>
<span class="hljs-comment"># /// script</span>
<span class="hljs-comment"># dependencies = [</span>
<span class="hljs-comment">#     &quot;trl[sft]&gt;=0.7.0&quot;,</span>
<span class="hljs-comment">#     &quot;transformers&gt;=4.36.0&quot;, </span>
<span class="hljs-comment">#     &quot;datasets&gt;=2.14.0&quot;,</span>
<span class="hljs-comment">#     &quot;accelerate&gt;=0.24.0&quot;,</span>
<span class="hljs-comment">#     &quot;peft&gt;=0.7.0&quot;</span>
<span class="hljs-comment"># ]</span>
<span class="hljs-comment"># ///</span>

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Base&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Base&quot;</span>)

<span class="hljs-comment"># Load dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceTB/smoltalk2&quot;</span>, <span class="hljs-string">&quot;SFT&quot;</span>)

<span class="hljs-comment"># Configure training</span>
config = SFTConfig(
    output_dir=<span class="hljs-string">&quot;./smollm3-jobs-sft&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">5e-5</span>,
    max_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">50</span>,
    save_steps=<span class="hljs-number">200</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_model_id=<span class="hljs-string">&quot;your-username/smollm3-jobs-sft&quot;</span>
)

<span class="hljs-comment"># Train</span>
trainer = SFTTrainer(
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;smoltalk_everyday_convs_reasoning_Qwen3_32B_think&quot;</span>],
    args=config,
)
trainer.train()`,wrap:!1}}),B=new jt({props:{code:"JTIzJTIwUnVuJTIwdGhlJTIwVVYlMjBzY3JpcHQlMjBvbiUyMEpvYnMlMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjBzZnRfdHJhaW5pbmcucHk=",highlighted:`<span class="hljs-comment"># Run the UV script on Jobs</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    sft_training.py`,wrap:!1}}),Z=new y({props:{title:"Hardware Selection for SFT",local:"hardware-selection-for-sft",headingTag:"h2"}}),V=new y({props:{title:"Advanced Jobs Configuration",local:"advanced-jobs-configuration",headingTag:"h2"}}),W=new jt({props:{code:"JTIzJTIwVXNlJTIwVFJMJ3MlMjBtYWludGFpbmVkJTIwU0ZUJTIwc2NyaXB0JTIwZGlyZWN0bHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQi1CYXNlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjBIdWdnaW5nRmFjZVRCJTJGc21vbHRhbGsyX2V2ZXJ5ZGF5X2NvbnZzX3RoaW5rJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwNWUtNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X3N0ZXBzJTIwMTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHNtb2xsbTMtc2Z0LWpvYnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1odWJfbW9kZWxfaWQlMjB5b3VyLXVzZXJuYW1lJTJGc21vbGxtMy1zZnQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlcG9ydF90byUyMHRyYWNraW8=",highlighted:`<span class="hljs-comment"># Use TRL&#x27;s maintained SFT script directly</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
    --model_name_or_path HuggingFaceTB/SmolLM3-3B-Base \\
    --dataset_name HuggingFaceTB/smoltalk2_everyday_convs_think \\
    --learning_rate 5e-5 \\
    --per_device_train_batch_size 4 \\
    --max_steps 1000 \\
    --output_dir smollm3-sft-jobs \\
    --push_to_hub \\
    --hub_model_id your-username/smollm3-sft \\
    --report_to trackio`,wrap:!1}}),Q=new jt({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLWZsYXZvciUyMGExMGctbGFyZ2UlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRpbWVvdXQlMjAzaCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VjcmV0cyUyMEhGX1RPS0VOJTNEeW91cl90b2tlbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VjcmV0cyUyMFdBTkRCX0FQSV9LRVklM0R5b3VyX3dhbmRiX2tleSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW52JTIwV0FOREJfUFJPSkVDVCUzRHNtb2xsbTMtc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1lbnYlMjBDVURBX1ZJU0lCTEVfREVWSUNFUyUzRDAlMjAlNUMlMEElMjAlMjAlMjAlMjBteV9zZnRfdHJhaW5pbmcucHk=",highlighted:`hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 3h \\
    --secrets HF_TOKEN=your_token \\
    --secrets WANDB_API_KEY=your_wandb_key \\
    --<span class="hljs-built_in">env</span> WANDB_PROJECT=smollm3-sft \\
    --<span class="hljs-built_in">env</span> CUDA_VISIBLE_DEVICES=0 \\
    my_sft_training.py`,wrap:!1}}),N=new y({props:{title:"Monitoring Your Training Job",local:"monitoring-your-training-job",headingTag:"h2"}}),P=new jt({props:{code:"JTIzJTIwTGlzdCUyMGFsbCUyMGpvYnMlMEFoZiUyMGpvYnMlMjBwcyUyMC1hJTBBJTBBJTIzJTIwR2V0JTIwZGV0YWlsZWQlMjBqb2IlMjBpbmZvcm1hdGlvbiUyMCUyMCUwQWhmJTIwam9icyUyMGluc3BlY3QlMjAlM0Nqb2JfaWQlM0UlMEElMEElMjMlMjBTdHJlYW0lMjBqb2IlMjBsb2dzJTIwaW4lMjByZWFsLXRpbWUlMEFoZiUyMGpvYnMlMjBsb2dzJTIwJTNDam9iX2lkJTNFJTIwLS1mb2xsb3clMEElMEElMjMlMjBDYW5jZWwlMjBhJTIwcnVubmluZyUyMGpvYiUyMGlmJTIwbmVlZGVkJTBBaGYlMjBqb2JzJTIwY2FuY2VsJTIwJTNDam9iX2lkJTNF",highlighted:`<span class="hljs-comment"># List all jobs</span>
hf <span class="hljs-built_in">jobs</span> ps -a

<span class="hljs-comment"># Get detailed job information  </span>
hf <span class="hljs-built_in">jobs</span> inspect &lt;job_id&gt;

<span class="hljs-comment"># Stream job logs in real-time</span>
hf <span class="hljs-built_in">jobs</span> logs &lt;job_id&gt; --follow

<span class="hljs-comment"># Cancel a running job if needed</span>
hf <span class="hljs-built_in">jobs</span> cancel &lt;job_id&gt;`,wrap:!1}}),q=new y({props:{title:"LoRA/PEFT on Jobs (optional)",local:"lorapeft-on-jobs-optional",headingTag:"h2"}}),O=new jt({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAlMjAtLWZsYXZvciUyMGExMGctbGFyZ2UlMjAlNUMlMEElMjAlMjAtLXRpbWVvdXQlMjAyaCUyMCU1QyUwQSUyMCUyMC0tc2VjcmV0cyUyMEhGX1RPS0VOJTIwJTVDJTBBJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmwlMkZtYWluJTJGdHJsJTJGc2NyaXB0cyUyRnNmdC5weSUyMiUyMCU1QyUwQSUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwSHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0ItQmFzZSUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldF9uYW1lJTIwSHVnZ2luZ0ZhY2VUQiUyRnNtb2x0YWxrMl9ldmVyeWRheV9jb252c190aGluayUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUyMHNtb2xsbTMtbG9yYS1zZnQtam9icyUyMCU1QyUwQSUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAlMjAtLW1heF9zdGVwcyUyMDEwMDAlMjAlNUMlMEElMjAlMjAtLXJlcG9ydF90byUyMHRyYWNraW8lMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwLS1odWJfbW9kZWxfaWQlMjB5b3VyLXVzZXJuYW1lJTJGc21vbGxtMy1sb3JhLXNmdCUyMCU1QyUwQSUyMCUyMC0tdXNlX3BlZnQlMjAlNUMlMEElMjAlMjAtLWxvcmFfciUyMDglMjAlNUMlMEElMjAlMjAtLWxvcmFfYWxwaGElMjAxNiUyMCU1QyUwQSUyMCUyMC0tbG9yYV9kcm9wb3V0JTIwMC4wNSUyMCU1QyUwQSUyMCUyMC0tbG9yYV90YXJnZXRfbW9kdWxlcyUyMGFsbC1saW5lYXI=",highlighted:`hf <span class="hljs-built_in">jobs</span> uv run \\
  --flavor a10g-large \\
  --<span class="hljs-built_in">timeout</span> 2h \\
  --secrets HF_TOKEN \\
  <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
  --model_name_or_path HuggingFaceTB/SmolLM3-3B-Base \\
  --dataset_name HuggingFaceTB/smoltalk2_everyday_convs_think \\
  --output_dir smollm3-lora-sft-jobs \\
  --per_device_train_batch_size 4 \\
  --learning_rate 5e-5 \\
  --max_steps 1000 \\
  --report_to trackio \\
  --push_to_hub \\
  --hub_model_id your-username/smollm3-lora-sft \\
  --use_peft \\
  --lora_r 8 \\
  --lora_alpha 16 \\
  --lora_dropout 0.05 \\
  --lora_target_modules all-linear`,wrap:!1}}),et=new y({props:{title:"Monitoring with Trackio",local:"monitoring-with-trackio",headingTag:"h2"}}),st=new y({props:{title:"Cost Estimation",local:"cost-estimation",headingTag:"h2"}}),mt=new y({props:{title:"Troubleshooting Common Issues",local:"troubleshooting-common-issues",headingTag:"h2"}}),gt=new y({props:{title:"Resources and Further Reading",local:"resources-and-further-reading",headingTag:"h2"}}),Ut=new Cl({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/5.md"}}),{c(){g=a("meta"),vt=s(),wt=a("p"),$t=s(),M(d.$$.fragment),_t=s(),M(J.$$.fragment),It=s(),b=a("p"),b.innerHTML=Ae,Lt=s(),M(j.$$.fragment),Et=s(),w=a("ul"),w.innerHTML=Fe,Bt=s(),M(C.$$.fragment),Zt=s(),v=a("p"),v.textContent=ke,Ht=s(),$=a("ul"),$.innerHTML=Ge,At=s(),M(_.$$.fragment),Ft=s(),I=a("p"),I.innerHTML=Re,kt=s(),L=a("p"),L.innerHTML=xe,Gt=s(),f=a("details"),dt=a("summary"),dt.textContent=Ve,Ie=s(),M(E.$$.fragment),Le=s(),Jt=a("p"),Jt.textContent=We,Ee=s(),M(B.$$.fragment),Rt=s(),M(Z.$$.fragment),xt=s(),H=a("p"),H.textContent=Xe,Vt=s(),A=a("p"),A.innerHTML=Se,Wt=s(),F=a("ul"),F.innerHTML=Qe,Xt=s(),k=a("p"),k.innerHTML=Ne,St=s(),G=a("ul"),G.innerHTML=Ye,Qt=s(),R=a("p"),R.innerHTML=ze,Nt=s(),x=a("ul"),x.innerHTML=Pe,Yt=s(),h=a("blockquote"),h.innerHTML=qe,zt=s(),M(V.$$.fragment),Pt=s(),M(W.$$.fragment),qt=s(),X=a("p"),X.innerHTML=De,Dt=s(),S=a("p"),S.innerHTML=Oe,Ot=s(),M(Q.$$.fragment),Kt=s(),M(N.$$.fragment),te=s(),Y=a("p"),Y.innerHTML=Ke,ee=s(),z=a("p"),z.innerHTML=tl,le=s(),M(P.$$.fragment),ne=s(),M(q.$$.fragment),se=s(),D=a("p"),D.innerHTML=el,ie=s(),M(O.$$.fragment),ae=s(),K=a("p"),K.textContent=ll,oe=s(),tt=a("ul"),tt.innerHTML=nl,re=s(),M(et.$$.fragment),Me=s(),lt=a("p"),lt.textContent=sl,me=s(),nt=a("p"),nt.innerHTML=il,pe=s(),M(st.$$.fragment),ue=s(),it=a("p"),it.textContent=al,ce=s(),at=a("ul"),at.innerHTML=ol,Te=s(),ot=a("p"),ot.textContent=rl,fe=s(),rt=a("p"),rt.innerHTML=Ml,ye=s(),Mt=a("ul"),Mt.innerHTML=ml,ge=s(),M(mt.$$.fragment),he=s(),pt=a("p"),pt.innerHTML=pl,Ue=s(),ut=a("ul"),ut.innerHTML=ul,de=s(),ct=a("p"),ct.innerHTML=cl,Je=s(),Tt=a("ul"),Tt.innerHTML=Tl,be=s(),ft=a("p"),ft.innerHTML=fl,je=s(),yt=a("ul"),yt.innerHTML=yl,we=s(),M(gt.$$.fragment),Ce=s(),ht=a("ul"),ht.innerHTML=gl,ve=s(),M(Ut.$$.fragment),$e=s(),Ct=a("p"),this.h()},l(t){const e=jl("svelte-u9bgzb",document.head);g=o(e,"META",{name:!0,content:!0}),e.forEach(l),vt=i(t),wt=o(t,"P",{}),Be(wt).forEach(l),$t=i(t),m(d.$$.fragment,t),_t=i(t),m(J.$$.fragment,t),It=i(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1romi1a"&&(b.innerHTML=Ae),Lt=i(t),m(j.$$.fragment,t),Et=i(t),w=o(t,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-hq0r4s"&&(w.innerHTML=Fe),Bt=i(t),m(C.$$.fragment,t),Zt=i(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1m87417"&&(v.textContent=ke),Ht=i(t),$=o(t,"UL",{"data-svelte-h":!0}),r($)!=="svelte-jk9mxc"&&($.innerHTML=Ge),At=i(t),m(_.$$.fragment,t),Ft=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1md3sw3"&&(I.innerHTML=Re),kt=i(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-186flx0"&&(L.innerHTML=xe),Gt=i(t),f=o(t,"DETAILS",{});var U=Be(f);dt=o(U,"SUMMARY",{"data-svelte-h":!0}),r(dt)!=="svelte-3ojvyd"&&(dt.textContent=Ve),Ie=i(U),m(E.$$.fragment,U),Le=i(U),Jt=o(U,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-14xyf0t"&&(Jt.textContent=We),Ee=i(U),m(B.$$.fragment,U),U.forEach(l),Rt=i(t),m(Z.$$.fragment,t),xt=i(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-uvhb8e"&&(H.textContent=Xe),Vt=i(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1wmskg9"&&(A.innerHTML=Se),Wt=i(t),F=o(t,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1sswzc8"&&(F.innerHTML=Qe),Xt=i(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1dojeau"&&(k.innerHTML=Ne),St=i(t),G=o(t,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-v8ek3l"&&(G.innerHTML=Ye),Qt=i(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-rwb6vm"&&(R.innerHTML=ze),Nt=i(t),x=o(t,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1gcm4iq"&&(x.innerHTML=Pe),Yt=i(t),h=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1bie0ph"&&(h.innerHTML=qe),zt=i(t),m(V.$$.fragment,t),Pt=i(t),m(W.$$.fragment,t),qt=i(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-9exkfb"&&(X.innerHTML=De),Dt=i(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1t7coxe"&&(S.innerHTML=Oe),Ot=i(t),m(Q.$$.fragment,t),Kt=i(t),m(N.$$.fragment,t),te=i(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-z7hljb"&&(Y.innerHTML=Ke),ee=i(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1gp7ih6"&&(z.innerHTML=tl),le=i(t),m(P.$$.fragment,t),ne=i(t),m(q.$$.fragment,t),se=i(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-w7eu5t"&&(D.innerHTML=el),ie=i(t),m(O.$$.fragment,t),ae=i(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1biq3pv"&&(K.textContent=ll),oe=i(t),tt=o(t,"UL",{"data-svelte-h":!0}),r(tt)!=="svelte-1cfpqte"&&(tt.innerHTML=nl),re=i(t),m(et.$$.fragment,t),Me=i(t),lt=o(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-dlsnzk"&&(lt.textContent=sl),me=i(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1qwosyu"&&(nt.innerHTML=il),pe=i(t),m(st.$$.fragment,t),ue=i(t),it=o(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-bqeor6"&&(it.textContent=al),ce=i(t),at=o(t,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-1keptmg"&&(at.innerHTML=ol),Te=i(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-15zzqy3"&&(ot.textContent=rl),fe=i(t),rt=o(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-10khssf"&&(rt.innerHTML=Ml),ye=i(t),Mt=o(t,"UL",{"data-svelte-h":!0}),r(Mt)!=="svelte-16wbhfu"&&(Mt.innerHTML=ml),ge=i(t),m(mt.$$.fragment,t),he=i(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-gw1iva"&&(pt.innerHTML=pl),Ue=i(t),ut=o(t,"UL",{"data-svelte-h":!0}),r(ut)!=="svelte-1xnq70w"&&(ut.innerHTML=ul),de=i(t),ct=o(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1mihp6k"&&(ct.innerHTML=cl),Je=i(t),Tt=o(t,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-6iw3pz"&&(Tt.innerHTML=Tl),be=i(t),ft=o(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-ah43vs"&&(ft.innerHTML=fl),je=i(t),yt=o(t,"UL",{"data-svelte-h":!0}),r(yt)!=="svelte-1f6kf7m"&&(yt.innerHTML=yl),we=i(t),m(gt.$$.fragment,t),Ce=i(t),ht=o(t,"UL",{"data-svelte-h":!0}),r(ht)!=="svelte-1y75b5h"&&(ht.innerHTML=gl),ve=i(t),m(Ut.$$.fragment,t),$e=i(t),Ct=o(t,"P",{}),Be(Ct).forEach(l),this.h()},h(){Ze(g,"name","hf:doc:metadata"),Ze(g,"content",$l),Ze(h,"class","tip")},m(t,e){bt(document.head,g),n(t,vt,e),n(t,wt,e),n(t,$t,e),p(d,t,e),n(t,_t,e),p(J,t,e),n(t,It,e),n(t,b,e),n(t,Lt,e),p(j,t,e),n(t,Et,e),n(t,w,e),n(t,Bt,e),p(C,t,e),n(t,Zt,e),n(t,v,e),n(t,Ht,e),n(t,$,e),n(t,At,e),p(_,t,e),n(t,Ft,e),n(t,I,e),n(t,kt,e),n(t,L,e),n(t,Gt,e),n(t,f,e),bt(f,dt),bt(f,Ie),p(E,f,null),bt(f,Le),bt(f,Jt),bt(f,Ee),p(B,f,null),n(t,Rt,e),p(Z,t,e),n(t,xt,e),n(t,H,e),n(t,Vt,e),n(t,A,e),n(t,Wt,e),n(t,F,e),n(t,Xt,e),n(t,k,e),n(t,St,e),n(t,G,e),n(t,Qt,e),n(t,R,e),n(t,Nt,e),n(t,x,e),n(t,Yt,e),n(t,h,e),n(t,zt,e),p(V,t,e),n(t,Pt,e),p(W,t,e),n(t,qt,e),n(t,X,e),n(t,Dt,e),n(t,S,e),n(t,Ot,e),p(Q,t,e),n(t,Kt,e),p(N,t,e),n(t,te,e),n(t,Y,e),n(t,ee,e),n(t,z,e),n(t,le,e),p(P,t,e),n(t,ne,e),p(q,t,e),n(t,se,e),n(t,D,e),n(t,ie,e),p(O,t,e),n(t,ae,e),n(t,K,e),n(t,oe,e),n(t,tt,e),n(t,re,e),p(et,t,e),n(t,Me,e),n(t,lt,e),n(t,me,e),n(t,nt,e),n(t,pe,e),p(st,t,e),n(t,ue,e),n(t,it,e),n(t,ce,e),n(t,at,e),n(t,Te,e),n(t,ot,e),n(t,fe,e),n(t,rt,e),n(t,ye,e),n(t,Mt,e),n(t,ge,e),p(mt,t,e),n(t,he,e),n(t,pt,e),n(t,Ue,e),n(t,ut,e),n(t,de,e),n(t,ct,e),n(t,Je,e),n(t,Tt,e),n(t,be,e),n(t,ft,e),n(t,je,e),n(t,yt,e),n(t,we,e),p(gt,t,e),n(t,Ce,e),n(t,ht,e),n(t,ve,e),p(Ut,t,e),n(t,$e,e),n(t,Ct,e),_e=!0},p:Ul,i(t){_e||(u(d.$$.fragment,t),u(J.$$.fragment,t),u(j.$$.fragment,t),u(C.$$.fragment,t),u(_.$$.fragment,t),u(E.$$.fragment,t),u(B.$$.fragment,t),u(Z.$$.fragment,t),u(V.$$.fragment,t),u(W.$$.fragment,t),u(Q.$$.fragment,t),u(N.$$.fragment,t),u(P.$$.fragment,t),u(q.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(st.$$.fragment,t),u(mt.$$.fragment,t),u(gt.$$.fragment,t),u(Ut.$$.fragment,t),_e=!0)},o(t){c(d.$$.fragment,t),c(J.$$.fragment,t),c(j.$$.fragment,t),c(C.$$.fragment,t),c(_.$$.fragment,t),c(E.$$.fragment,t),c(B.$$.fragment,t),c(Z.$$.fragment,t),c(V.$$.fragment,t),c(W.$$.fragment,t),c(Q.$$.fragment,t),c(N.$$.fragment,t),c(P.$$.fragment,t),c(q.$$.fragment,t),c(O.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(mt.$$.fragment,t),c(gt.$$.fragment,t),c(Ut.$$.fragment,t),_e=!1},d(t){t&&(l(vt),l(wt),l($t),l(_t),l(It),l(b),l(Lt),l(Et),l(w),l(Bt),l(Zt),l(v),l(Ht),l($),l(At),l(Ft),l(I),l(kt),l(L),l(Gt),l(f),l(Rt),l(xt),l(H),l(Vt),l(A),l(Wt),l(F),l(Xt),l(k),l(St),l(G),l(Qt),l(R),l(Nt),l(x),l(Yt),l(h),l(zt),l(Pt),l(qt),l(X),l(Dt),l(S),l(Ot),l(Kt),l(te),l(Y),l(ee),l(z),l(le),l(ne),l(se),l(D),l(ie),l(ae),l(K),l(oe),l(tt),l(re),l(Me),l(lt),l(me),l(nt),l(pe),l(ue),l(it),l(ce),l(at),l(Te),l(ot),l(fe),l(rt),l(ye),l(Mt),l(ge),l(he),l(pt),l(Ue),l(ut),l(de),l(ct),l(Je),l(Tt),l(be),l(ft),l(je),l(yt),l(we),l(Ce),l(ht),l(ve),l($e),l(Ct)),l(g),T(d,t),T(J,t),T(j,t),T(C,t),T(_,t),T(E),T(B),T(Z,t),T(V,t),T(W,t),T(Q,t),T(N,t),T(P,t),T(q,t),T(O,t),T(et,t),T(st,t),T(mt,t),T(gt,t),T(Ut,t)}}}const $l='{"title":"Training with Hugging Face Jobs","local":"training-with-hugging-face-jobs","sections":[{"title":"Why Use Jobs for SFT Training?","local":"why-use-jobs-for-sft-training","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Running SFT with Jobs: Two Approaches","local":"running-sft-with-jobs-two-approaches","sections":[],"depth":2},{"title":"Hardware Selection for SFT","local":"hardware-selection-for-sft","sections":[],"depth":2},{"title":"Advanced Jobs Configuration","local":"advanced-jobs-configuration","sections":[],"depth":2},{"title":"Monitoring Your Training Job","local":"monitoring-your-training-job","sections":[],"depth":2},{"title":"LoRA/PEFT on Jobs (optional)","local":"lorapeft-on-jobs-optional","sections":[],"depth":2},{"title":"Monitoring with Trackio","local":"monitoring-with-trackio","sections":[],"depth":2},{"title":"Cost Estimation","local":"cost-estimation","sections":[],"depth":2},{"title":"Troubleshooting Common Issues","local":"troubleshooting-common-issues","sections":[],"depth":2},{"title":"Resources and Further Reading","local":"resources-and-further-reading","sections":[],"depth":2}],"depth":1}';function _l(He){return dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends Jl{constructor(g){super(),bl(this,g,_l,vl,hl,{})}}export{Zl as component};
