import{s as gt,n as wt,o as Ct}from"../chunks/scheduler.19cc4639.js";import{S as It,i as ft,e as i,s as a,c as o,h as bt,a as p,d as l,b as n,f as _s,g as u,j as M,k as Ds,l as is,m as e,n as r,t as y,o as c,p as U}from"../chunks/index.6703add8.js";import{C as Zt,H as j,E as Bt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3db827b3.js";import{C as es}from"../chunks/CodeBlock.321a03bc.js";function vt(Ks){let m,ps,as,Ms,d,os,g,us,w,Os="Visual Language Models (VLMs) process <strong>images and text simultaneously</strong>, enabling advanced tasks like generating captions, answering visual questions, or reasoning across modalities. In this section, we focus on <strong>how VLMs work and how to use them practically</strong>.",rs,C,ys,I,st='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/VLM_Architecture.png" alt="VLM Architecture"/>',cs,f,tt="VLMs combine image-processing and text-generation components for a unified multimodal understanding. The main elements are:",Us,b,lt="<li><strong>Image/Vision Encoder</strong>: Converts images into compact numerical representations. Examples: CLIP, SigLIP.</li> <li><strong>Embedding Projector</strong>: Aligns image features with text embeddings (often a small MLP or linear layer fine-tuned for the multimodal task).</li> <li><strong>Multimodal Projector / Fusion Module</strong>: Fuses and enhances connections between visual and textual representations. This step goes beyond alignment, enabling rich cross-modal interaction.representations.</li> <li><strong>Text Decoder</strong>: Generates text (or other outputs) from the fused multimodal representations.</li>",ms,Z,et="Most VLMs leverage <strong>pretrained image encoders and text decoders</strong>, then fine-tune on paired image-text datasets for efficient training and generalization.",hs,B,Ts,v,at="VLMs can be applied to tasks such as:",Js,G,nt="<li><strong>Image Captioning:</strong> generating descriptions for images</li> <li><strong>Visual Question Answering (VQA):</strong> answering questions about an image</li> <li><strong>Cross-Modal Retrieval:</strong> matching images with text and vice versa</li> <li><strong>Creative Applications:</strong> design, art generation, multimedia content</li>",js,W,it="High-quality paired datasets are key, and 🤗 transformers provide pretrained models and streamlined fine-tuning workflows.",ds,q,pt='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/VLM_Usage.png" alt="VLM Usage"/>',gs,$,ws,R,Mt="Many VLMs support <strong>chat-like interactions</strong>, with messages structured as:",Cs,V,ot="<li><strong>System message:</strong> sets context: <code>&quot;You are an assistant analyzing visual data.&quot;</code></li> <li><strong>User queries:</strong> combine text and images.</li> <li><strong>Assistant responses:</strong> generated text based on multimodal analysis.</li>",Is,x,ut="Example:",fs,Q,bs,N,rt="VLMs can also handle <strong>multiple images or video frames</strong> as input by passing sequences of images through the same chat template.",Zs,H,Bs,S,yt='As we saw in <a href="../unit1/2">Unit 1</a>, the easiest way to use a VLM is through the 🤗 <code>pipeline</code> abstraction:',vs,k,Gs,h,ts,ct="Output",As,E,Ws,X,qs,Y,Ut=`For advanced use, you can access a VLM directly via 🤗 Transformers, giving you <strong>full control over each component</strong>.<br/>
To reduce memory usage and speed up inference, we can apply <strong>4-bit quantization</strong> using <code>bitsandbytes</code>.`,$s,F,mt="Unlike standard LLM usage, VLMs require a <strong>processor</strong> instead of just a tokenizer. The processor handles both <strong>text tokenization</strong> and <strong>image preprocessing</strong>, streamlining the workflow for multimodal inputs.",Rs,z,Vs,L,xs,_,ht="We can use the <strong>chat template</strong> to describe images. Each image is represented as <code>{&quot;type&quot;: &quot;image&quot;}</code> in the message, and the actual image data is passed to the processor via the <code>images</code> argument. The processor handles both text and visual inputs seamlessly.",Qs,A,Ns,T,ls,Tt="Output",Ps,P,Hs,D,Jt="The processor combines the text and image inputs, so the model can generate coherent multimodal outputs.",Ss,J,jt="<p>Similar templates can handle multiple images, OCR tasks, or even video frames, making VLMs highly versatile.</p>",ks,K,Es,O,dt='<li><a href="https://huggingface.co/blog/vlms-2025" rel="nofollow">Vision Language Models (Better, Faster, Stronger)</a></li> <li><a href="https://huggingface.co/blog/vlms" rel="nofollow">Vision Language Models Explained</a></li> <li><a href="https://huggingface.co/blog/smolvlm" rel="nofollow">SmolVLM - small yet mighty Vision Language Model</a></li>',Xs,ss,Ys,ns,Fs;return d=new Zt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new j({props:{title:"Using Pretrained VLMs",local:"using-pretrained-vlms",headingTag:"h1"}}),C=new j({props:{title:"Architecture Overview",local:"architecture-overview",headingTag:"h2"}}),B=new j({props:{title:"Practical Usage",local:"practical-usage",headingTag:"h2"}}),$=new j({props:{title:"Chat Format",local:"chat-format",headingTag:"h3"}}),Q=new es({props:{code:"JTVCJTBBJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwVkxNJTIwc3BlY2lhbGl6ZWQlMjBpbiUyMGNoYXJ0cy4lMjIlN0QlNUQlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJpbWFnZSUyMiUzQSUyMCUyMiUzQ2ltYWdlX2RhdGElM0UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBoaWdoZXN0JTIwdmFsdWUlMjBpbiUyMHRoaXMlMjBjaGFydCUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyNDIlMjIlN0QlNUQlMEElMjAlMjAlN0QlMEElNUQ=",highlighted:`<span class="hljs-punctuation">[</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are a VLM specialized in charts.&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
      <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;image&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;image_data&gt;&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is the highest value in this chart?&quot;</span><span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;42&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">]</span>`,wrap:!1}}),H=new j({props:{title:"Using a VLM via pipeline",local:"using-a-vlm-via-pipeline",headingTag:"h2"}}),k=new es({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHBpcGVsaW5lJTIwd2l0aCUyMGElMjBWTE0lMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2UtdGV4dC10by10ZXh0JTIyJTJDJTIwJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xWTE0yLTIuMkItSW5zdHJ1Y3QlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEElMEElMjMlMjBEZWZpbmUlMjB5b3VyJTIwY29udmVyc2F0aW9uJTIwd2l0aCUyMGFuJTIwaW1hZ2UlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCU1RCUwQSUwQW91dHB1dHMlMjAlM0QlMjBwaXBlKHRleHQlM0RtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjAlMkMlMjByZXR1cm5fZnVsbF90ZXh0JTNERmFsc2UpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjByZXNwb25zZSUyMC0lMjBwaXBlbGluZSUyMGhhbmRsZXMlMjBtdWx0aW1vZGFsJTIwaW5wdXRzJTIwYXV0b21hdGljYWxseSUwQXJlc3BvbnNlJTIwJTNEJTIwcGlwZShtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTIwdGVtcGVyYXR1cmUlM0QwLjcpJTBBJTBBcHJpbnQocmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEJTVCJ2NvbnRlbnQnJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwbW9kZWwncyUyMGRlc2NyaXB0aW9u",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Initialize the pipeline with a VLM</span>
pipe = pipeline(<span class="hljs-string">&quot;image-text-to-text&quot;</span>, <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

<span class="hljs-comment"># Define your conversation with an image</span>
messages = [
     {
         <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
         <span class="hljs-string">&quot;content&quot;</span>: [
             {
                 <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                 <span class="hljs-string">&quot;image&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>,
             },
             {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image.&quot;</span>},
         ],
     }
 ]

outputs = pipe(text=messages, max_new_tokens=<span class="hljs-number">60</span>, return_full_text=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Generate response - pipeline handles multimodal inputs automatically</span>
response = pipe(messages, max_new_tokens=<span class="hljs-number">128</span>, temperature=<span class="hljs-number">0.7</span>)

<span class="hljs-built_in">print</span>(response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>][<span class="hljs-string">&#x27;content&#x27;</span>])  <span class="hljs-comment"># Print the model&#x27;s description</span>`,wrap:!1}}),E=new es({props:{code:"VGhlJTIwaW1hZ2UlMjBkZXBpY3RzJTIwYSUyMGNsb3NlLXVwJTIwdmlldyUyMG9mJTIwYSUyMGZsb3dlciUyMGdhcmRlbiUyQyUyMHNwZWNpZmljYWxseSUyMGZvY3VzaW5nJTIwb24lMjBhJTIwcGluayUyMGZsb3dlci4lMjBUaGUlMjBmbG93ZXIlMjBpcyUyMHRoZSUyMGNlbnRyYWwlMjBzdWJqZWN0JTIwb2YlMjB0aGUlMjBpbWFnZSUyQyUyMGFuZCUyMGl0JTIwaXMlMjBhJTIwcHJvbWluZW50JTIwZmVhdHVyZSUyMGR1ZSUyMHRvJTIwaXRzJTIwdmlicmFudCUyMGNvbG9yJTIwYW5kJTIwaW50cmljYXRlJTIwZGV0YWlscy4lMjBUaGUlMjBmbG93ZXIlMjBoYXMlMjBhJTIwY2lyY3VsYXIlMjBzaGFwZSUyQyUyMHdpdGglMjBwZXRhbHMlMjB0aGF0JTIwYXJlJTIwc2xpZ2h0bHklMjBjdXJsZWQlMjBhbmQlMjBoYXZlJTIwYSUyMGdyYWRpZW50JTIwZnJvbSUyMGxpZ2h0JTIwdG8lMjBkYXJrJTIwcGluay4lMjBUaGUlMjBwZXRhbHMlMjBhcmUlMjBhcnJhbmdlZCUyMHN5bW1ldHJpY2FsbHklMjBhcm91bmQlMjB0aGUlMjBjZW50cmFsJTIwcGlzdGlsJTJDJTIwd2hpY2glMjBpcyUyMHZpc2libGUlMjBpbiUyMHRoZSUyMGNlbnRlciUyMG9mJTIwdGhlJTIwZmxvd2VyLiUyMFRoZSUyMHBpc3RpbCUyMGlzJTIwYSUyMHNtYWxsJTJDJTIweWVsbG93JTIwc3RydWN0dXJlJTIwdGhhdCUyMGlzJTIwc3Vycm91bmRlZCUyMGJ5JTIwYSUyMGNsdXN0ZXIlMjBvZiUyMHN0YW1lbnMlMkMlMjB3aGljaCUyMGFyZSUyMHZpc2libGUlMjBhcyUyMHNtYWxsJTJDJTIweWVsbG93JTIwc3RydWN0dXJlcy4lMjBUaGUlMjBmbG93ZXIlMjBhbHNvJTIwaGFzJTIwYSUyMHNtYWxsJTJDJTIwYmxhY2s=",highlighted:"The image depicts a close-up view of a flower garden, specifically focusing on a pink flower. The flower is the central subject of the image, and it is a prominent feature due to its vibrant color and intricate details. The flower has a circular shape, with petals that are slightly curled and have a gradient from light to dark pink. The petals are arranged symmetrically around the central pistil, which is visible in the center of the flower. The pistil is a small, yellow structure that is surrounded by a cluster of stamens, which are visible as small, yellow structures. The flower also has a small, black",wrap:!1}}),X=new j({props:{title:"Using a VLM via Transformers (Full Control)",local:"using-a-vlm-via-transformers-full-control",headingTag:"h2"}}),z=new es({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMuaW1hZ2VfdXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEElMjMlMjBRdWFudGl6YXRpb24lMjBmb3IlMjBlZmZpY2llbmN5JTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNMi0yLjJCLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText, BitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

<span class="hljs-comment"># Quantization for efficiency</span>
quant_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)
model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>
model = AutoModelForImageTextToText.from_pretrained(model_name, quantization_config=quant_config).to(device)
processor = AutoProcessor.from_pretrained(model_name)`,wrap:!1}}),L=new j({props:{title:"Example: Describe an Image",local:"example-describe-an-image",headingTag:"h3"}}),A=new es({props:{code:"JTIzJTIwTG9hZCUyMGltYWdlJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwaW5wdXQlMjBtZXNzYWdlcyUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyQ2FuJTIweW91JTIwZGVzY3JpYmUlMjB0aGUlMjBpbWFnZSUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RCUwQSUwQSUyMyUyMFByZXBhcmUlMjBpbnB1dHMlMEFwcm9tcHQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjBpbWFnZXMlM0QlNUJpbWFnZSU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwaW5wdXRzLnRvKGRldmljZSklMEElMEElMjMlMjBHZW5lcmF0ZSUyMG91dHB1dHMlMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwMCklMEFnZW5lcmF0ZWRfdGV4dHMlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9pZHMlMkMlMEElMjAlMjAlMjAlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUwQSklNUIwJTVEJTBBJTBBJTIzJTIwRXh0cmFjdCUyMG9ubHklMjB0aGUlMjBhc3Npc3RhbnQlMjByZXNwb25zZSUwQWFzc2lzdGFudF9yZXNwb25zZSUyMCUzRCUyMGdlbmVyYXRlZF90ZXh0cy5zcGxpdCglMjJBc3Npc3RhbnQlM0ElMjIpJTVCLTElNUQuc3RyaXAoKSUwQSUwQXByaW50KGFzc2lzdGFudF9yZXNwb25zZSk=",highlighted:`<span class="hljs-comment"># Load image</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
image = load_image(image_url)

<span class="hljs-comment"># Create input messages</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Can you describe the image?&quot;</span>}
        ]
    },
]

<span class="hljs-comment"># Prepare inputs</span>
prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(text=prompt, images=[image], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = inputs.to(device)

<span class="hljs-comment"># Generate outputs</span>
generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">500</span>)
generated_texts = processor.batch_decode(
    generated_ids,
    skip_special_tokens=<span class="hljs-literal">True</span>,
)[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Extract only the assistant response</span>
assistant_response = generated_texts.split(<span class="hljs-string">&quot;Assistant:&quot;</span>)[-<span class="hljs-number">1</span>].strip()

<span class="hljs-built_in">print</span>(assistant_response)`,wrap:!1}}),P=new es({props:{code:"VGhlJTIwaW1hZ2UlMjBpcyUyMG9mJTIwYSUyMGJlZSUyMG9uJTIwYSUyMGZsb3dlci4=",highlighted:"The image is of a bee on a flower.",wrap:!1}}),K=new j({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ss=new Bt({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit3/2.md"}}),{c(){m=i("meta"),ps=a(),as=i("p"),Ms=a(),o(d.$$.fragment),os=a(),o(g.$$.fragment),us=a(),w=i("p"),w.innerHTML=Os,rs=a(),o(C.$$.fragment),ys=a(),I=i("p"),I.innerHTML=st,cs=a(),f=i("p"),f.textContent=tt,Us=a(),b=i("ul"),b.innerHTML=lt,ms=a(),Z=i("p"),Z.innerHTML=et,hs=a(),o(B.$$.fragment),Ts=a(),v=i("p"),v.textContent=at,Js=a(),G=i("ul"),G.innerHTML=nt,js=a(),W=i("p"),W.textContent=it,ds=a(),q=i("p"),q.innerHTML=pt,gs=a(),o($.$$.fragment),ws=a(),R=i("p"),R.innerHTML=Mt,Cs=a(),V=i("ol"),V.innerHTML=ot,Is=a(),x=i("p"),x.textContent=ut,fs=a(),o(Q.$$.fragment),bs=a(),N=i("p"),N.innerHTML=rt,Zs=a(),o(H.$$.fragment),Bs=a(),S=i("p"),S.innerHTML=yt,vs=a(),o(k.$$.fragment),Gs=a(),h=i("details"),ts=i("summary"),ts.textContent=ct,As=a(),o(E.$$.fragment),Ws=a(),o(X.$$.fragment),qs=a(),Y=i("p"),Y.innerHTML=Ut,$s=a(),F=i("p"),F.innerHTML=mt,Rs=a(),o(z.$$.fragment),Vs=a(),o(L.$$.fragment),xs=a(),_=i("p"),_.innerHTML=ht,Qs=a(),o(A.$$.fragment),Ns=a(),T=i("details"),ls=i("summary"),ls.textContent=Tt,Ps=a(),o(P.$$.fragment),Hs=a(),D=i("p"),D.textContent=Jt,Ss=a(),J=i("blockquote"),J.innerHTML=jt,ks=a(),o(K.$$.fragment),Es=a(),O=i("ul"),O.innerHTML=dt,Xs=a(),o(ss.$$.fragment),Ys=a(),ns=i("p"),this.h()},l(s){const t=bt("svelte-u9bgzb",document.head);m=p(t,"META",{name:!0,content:!0}),t.forEach(l),ps=n(s),as=p(s,"P",{}),_s(as).forEach(l),Ms=n(s),u(d.$$.fragment,s),os=n(s),u(g.$$.fragment,s),us=n(s),w=p(s,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1x3y1qf"&&(w.innerHTML=Os),rs=n(s),u(C.$$.fragment,s),ys=n(s),I=p(s,"P",{"data-svelte-h":!0}),M(I)!=="svelte-vvc5qe"&&(I.innerHTML=st),cs=n(s),f=p(s,"P",{"data-svelte-h":!0}),M(f)!=="svelte-adkga0"&&(f.textContent=tt),Us=n(s),b=p(s,"UL",{"data-svelte-h":!0}),M(b)!=="svelte-1s27o17"&&(b.innerHTML=lt),ms=n(s),Z=p(s,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-unkaqn"&&(Z.innerHTML=et),hs=n(s),u(B.$$.fragment,s),Ts=n(s),v=p(s,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1jrkij4"&&(v.textContent=at),Js=n(s),G=p(s,"UL",{"data-svelte-h":!0}),M(G)!=="svelte-d0zug6"&&(G.innerHTML=nt),js=n(s),W=p(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1pcr0l7"&&(W.textContent=it),ds=n(s),q=p(s,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1s12bgo"&&(q.innerHTML=pt),gs=n(s),u($.$$.fragment,s),ws=n(s),R=p(s,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1qfbv65"&&(R.innerHTML=Mt),Cs=n(s),V=p(s,"OL",{"data-svelte-h":!0}),M(V)!=="svelte-1i8rfc0"&&(V.innerHTML=ot),Is=n(s),x=p(s,"P",{"data-svelte-h":!0}),M(x)!=="svelte-11lpom8"&&(x.textContent=ut),fs=n(s),u(Q.$$.fragment,s),bs=n(s),N=p(s,"P",{"data-svelte-h":!0}),M(N)!=="svelte-wso7db"&&(N.innerHTML=rt),Zs=n(s),u(H.$$.fragment,s),Bs=n(s),S=p(s,"P",{"data-svelte-h":!0}),M(S)!=="svelte-siuzhz"&&(S.innerHTML=yt),vs=n(s),u(k.$$.fragment,s),Gs=n(s),h=p(s,"DETAILS",{});var zs=_s(h);ts=p(zs,"SUMMARY",{"data-svelte-h":!0}),M(ts)!=="svelte-nfzy3j"&&(ts.textContent=ct),As=n(zs),u(E.$$.fragment,zs),zs.forEach(l),Ws=n(s),u(X.$$.fragment,s),qs=n(s),Y=p(s,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-5cbqik"&&(Y.innerHTML=Ut),$s=n(s),F=p(s,"P",{"data-svelte-h":!0}),M(F)!=="svelte-imt3e1"&&(F.innerHTML=mt),Rs=n(s),u(z.$$.fragment,s),Vs=n(s),u(L.$$.fragment,s),xs=n(s),_=p(s,"P",{"data-svelte-h":!0}),M(_)!=="svelte-q4e8ot"&&(_.innerHTML=ht),Qs=n(s),u(A.$$.fragment,s),Ns=n(s),T=p(s,"DETAILS",{});var Ls=_s(T);ls=p(Ls,"SUMMARY",{"data-svelte-h":!0}),M(ls)!=="svelte-nfzy3j"&&(ls.textContent=Tt),Ps=n(Ls),u(P.$$.fragment,Ls),Ls.forEach(l),Hs=n(s),D=p(s,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1v039s9"&&(D.textContent=Jt),Ss=n(s),J=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(J)!=="svelte-hq4ukg"&&(J.innerHTML=jt),ks=n(s),u(K.$$.fragment,s),Es=n(s),O=p(s,"UL",{"data-svelte-h":!0}),M(O)!=="svelte-uziv6c"&&(O.innerHTML=dt),Xs=n(s),u(ss.$$.fragment,s),Ys=n(s),ns=p(s,"P",{}),_s(ns).forEach(l),this.h()},h(){Ds(m,"name","hf:doc:metadata"),Ds(m,"content",Gt),Ds(J,"class","tip")},m(s,t){is(document.head,m),e(s,ps,t),e(s,as,t),e(s,Ms,t),r(d,s,t),e(s,os,t),r(g,s,t),e(s,us,t),e(s,w,t),e(s,rs,t),r(C,s,t),e(s,ys,t),e(s,I,t),e(s,cs,t),e(s,f,t),e(s,Us,t),e(s,b,t),e(s,ms,t),e(s,Z,t),e(s,hs,t),r(B,s,t),e(s,Ts,t),e(s,v,t),e(s,Js,t),e(s,G,t),e(s,js,t),e(s,W,t),e(s,ds,t),e(s,q,t),e(s,gs,t),r($,s,t),e(s,ws,t),e(s,R,t),e(s,Cs,t),e(s,V,t),e(s,Is,t),e(s,x,t),e(s,fs,t),r(Q,s,t),e(s,bs,t),e(s,N,t),e(s,Zs,t),r(H,s,t),e(s,Bs,t),e(s,S,t),e(s,vs,t),r(k,s,t),e(s,Gs,t),e(s,h,t),is(h,ts),is(h,As),r(E,h,null),e(s,Ws,t),r(X,s,t),e(s,qs,t),e(s,Y,t),e(s,$s,t),e(s,F,t),e(s,Rs,t),r(z,s,t),e(s,Vs,t),r(L,s,t),e(s,xs,t),e(s,_,t),e(s,Qs,t),r(A,s,t),e(s,Ns,t),e(s,T,t),is(T,ls),is(T,Ps),r(P,T,null),e(s,Hs,t),e(s,D,t),e(s,Ss,t),e(s,J,t),e(s,ks,t),r(K,s,t),e(s,Es,t),e(s,O,t),e(s,Xs,t),r(ss,s,t),e(s,Ys,t),e(s,ns,t),Fs=!0},p:wt,i(s){Fs||(y(d.$$.fragment,s),y(g.$$.fragment,s),y(C.$$.fragment,s),y(B.$$.fragment,s),y($.$$.fragment,s),y(Q.$$.fragment,s),y(H.$$.fragment,s),y(k.$$.fragment,s),y(E.$$.fragment,s),y(X.$$.fragment,s),y(z.$$.fragment,s),y(L.$$.fragment,s),y(A.$$.fragment,s),y(P.$$.fragment,s),y(K.$$.fragment,s),y(ss.$$.fragment,s),Fs=!0)},o(s){c(d.$$.fragment,s),c(g.$$.fragment,s),c(C.$$.fragment,s),c(B.$$.fragment,s),c($.$$.fragment,s),c(Q.$$.fragment,s),c(H.$$.fragment,s),c(k.$$.fragment,s),c(E.$$.fragment,s),c(X.$$.fragment,s),c(z.$$.fragment,s),c(L.$$.fragment,s),c(A.$$.fragment,s),c(P.$$.fragment,s),c(K.$$.fragment,s),c(ss.$$.fragment,s),Fs=!1},d(s){s&&(l(ps),l(as),l(Ms),l(os),l(us),l(w),l(rs),l(ys),l(I),l(cs),l(f),l(Us),l(b),l(ms),l(Z),l(hs),l(Ts),l(v),l(Js),l(G),l(js),l(W),l(ds),l(q),l(gs),l(ws),l(R),l(Cs),l(V),l(Is),l(x),l(fs),l(bs),l(N),l(Zs),l(Bs),l(S),l(vs),l(Gs),l(h),l(Ws),l(qs),l(Y),l($s),l(F),l(Rs),l(Vs),l(xs),l(_),l(Qs),l(Ns),l(T),l(Hs),l(D),l(Ss),l(J),l(ks),l(Es),l(O),l(Xs),l(Ys),l(ns)),l(m),U(d,s),U(g,s),U(C,s),U(B,s),U($,s),U(Q,s),U(H,s),U(k,s),U(E),U(X,s),U(z,s),U(L,s),U(A,s),U(P),U(K,s),U(ss,s)}}}const Gt='{"title":"Using Pretrained VLMs","local":"using-pretrained-vlms","sections":[{"title":"Architecture Overview","local":"architecture-overview","sections":[],"depth":2},{"title":"Practical Usage","local":"practical-usage","sections":[{"title":"Chat Format","local":"chat-format","sections":[],"depth":3}],"depth":2},{"title":"Using a VLM via pipeline","local":"using-a-vlm-via-pipeline","sections":[],"depth":2},{"title":"Using a VLM via Transformers (Full Control)","local":"using-a-vlm-via-transformers-full-control","sections":[{"title":"Example: Describe an Image","local":"example-describe-an-image","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Wt(Ks){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends It{constructor(m){super(),ft(this,m,Wt,vt,gt,{})}}export{xt as component};
