import{s as Tt,o as jt,n as dt}from"../chunks/scheduler.3e4cb221.js";import{S as gt,i as wt,g as i,s as a,r as u,A as Ct,h as p,f as e,c as n,j as _s,u as r,x as M,k as Jt,y as Ms,a as l,v as y,d as c,t as U,w as m}from"../chunks/index.bc693fcb.js";import{T as It}from"../chunks/Tip.26bcdf6b.js";import{C as is}from"../chunks/CodeBlock.4d312707.js";import{H as d,E as ft}from"../chunks/getInferenceSnippets.322ff9ba.js";function bt(os){let o,g="Similar templates can handle multiple images, OCR tasks, or even video frames, making VLMs highly versatile.";return{c(){o=i("p"),o.textContent=g},l(h){o=p(h,"P",{"data-svelte-h":!0}),M(o)!=="svelte-d96uj"&&(o.textContent=g)},m(h,ls){l(h,o,ls)},p:dt,d(h){h&&e(o)}}}function Zt(os){let o,g,h,ls,w,us,C,Ps="Visual Language Models (VLMs) process <strong>images and text simultaneously</strong>, enabling advanced tasks like generating captions, answering visual questions, or reasoning across modalities. In this section, we focus on <strong>how VLMs work and how to use them practically</strong>.",rs,I,ys,f,Ds='<img src="./images/VLM_Architecture.png" alt="VLM Architecture"/>',cs,b,Ks="VLMs combine image-processing and text-generation components for a unified multimodal understanding. The main elements are:",Us,Z,Os="<li><strong>Image/Vision Encoder</strong>: Converts images into compact numerical representations. Examples: CLIP, SigLIP.</li> <li><strong>Embedding Projector</strong>: Aligns image features with text embeddings (often a small MLP or linear layer fine-tuned for the multimodal task).</li> <li><strong>Multimodal Projector / Fusion Module</strong>: Fuses and enhances connections between visual and textual representations. This step goes beyond alignment, enabling rich cross-modal interaction.representations.</li> <li><strong>Text Decoder</strong>: Generates text (or other outputs) from the fused multimodal representations.</li>",ms,B,st="Most VLMs leverage <strong>pretrained image encoders and text decoders</strong>, then fine-tune on paired image-text datasets for efficient training and generalization.",hs,G,Js,W,tt="VLMs can be applied to tasks such as:",Ts,v,et="<li><strong>Image Captioning:</strong> generating descriptions for images</li> <li><strong>Visual Question Answering (VQA):</strong> answering questions about an image</li> <li><strong>Cross-Modal Retrieval:</strong> matching images with text and vice versa</li> <li><strong>Creative Applications:</strong> design, art generation, multimedia content</li>",js,$,lt="High-quality paired datasets are key, and 🤗 transformers provide pretrained models and streamlined fine-tuning workflows.",ds,q,at='<img src="./images/VLM_Usage.png" alt="VLM Usage"/>',gs,R,ws,V,nt="Many VLMs support <strong>chat-like interactions</strong>, with messages structured as:",Cs,x,it="<li><strong>System message:</strong> sets context: <code>&quot;You are an assistant analyzing visual data.&quot;</code></li> <li><strong>User queries:</strong> combine text and images.</li> <li><strong>Assistant responses:</strong> generated text based on multimodal analysis.</li>",Is,Q,pt="Example:",fs,N,bs,H,Mt="VLMs can also handle <strong>multiple images or video frames</strong> as input by passing sequences of images through the same chat template.",Zs,S,Bs,E,ot='As we saw in <a href="../unit1/2">Unit 1</a>, the easiest way to use a VLM is through the 🤗 <code>pipeline</code> abstraction:',Gs,X,Ws,J,as,ut="Output",Ls,Y,vs,k,$s,F,rt=`For advanced use, you can access a VLM directly via 🤗 Transformers, giving you <strong>full control over each component</strong>.<br/>
To reduce memory usage and speed up inference, we can apply <strong>4-bit quantization</strong> using <code>bitsandbytes</code>.`,qs,z,yt="Unlike standard LLM usage, VLMs require a <strong>processor</strong> instead of just a tokenizer. The processor handles both <strong>text tokenization</strong> and <strong>image preprocessing</strong>, streamlining the workflow for multimodal inputs.",Rs,_,Vs,L,xs,A,ct="We can use the <strong>chat template</strong> to describe images. Each image is represented as <code>{&quot;type&quot;: &quot;image&quot;}</code> in the message, and the actual image data is passed to the processor via the <code>images</code> argument. The processor handles both text and visual inputs seamlessly.",Qs,P,Ns,T,ns,Ut="Output",As,D,Hs,K,mt="The processor combines the text and image inputs, so the model can generate coherent multimodal outputs.",Ss,j,Es,O,Xs,ss,ht='<li><a href="https://huggingface.co/blog/vlms-2025" rel="nofollow">Vision Language Models (Better, Faster, Stronger)</a></li> <li><a href="https://huggingface.co/blog/vlms" rel="nofollow">Vision Language Models Explained</a></li> <li><a href="https://huggingface.co/blog/smolvlm" rel="nofollow">SmolVLM - small yet mighty Vision Language Model</a></li>',Ys,ts,ks,ps,Fs;return w=new d({props:{title:"Using Pretrained VLMs",local:"using-pretrained-vlms",headingTag:"h1"}}),I=new d({props:{title:"Architecture Overview",local:"architecture-overview",headingTag:"h2"}}),G=new d({props:{title:"Practical Usage",local:"practical-usage",headingTag:"h2"}}),R=new d({props:{title:"Chat Format",local:"chat-format",headingTag:"h3"}}),N=new is({props:{code:"JTVCJTBBJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwVkxNJTIwc3BlY2lhbGl6ZWQlMjBpbiUyMGNoYXJ0cy4lMjIlN0QlNUQlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJpbWFnZSUyMiUzQSUyMCUyMiUzQ2ltYWdlX2RhdGElM0UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBoaWdoZXN0JTIwdmFsdWUlMjBpbiUyMHRoaXMlMjBjaGFydCUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyNDIlMjIlN0QlNUQlMEElMjAlMjAlN0QlMEElNUQ=",highlighted:`<span class="hljs-punctuation">[</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are a VLM specialized in charts.&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
      <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;image&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;image_data&gt;&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is the highest value in this chart?&quot;</span><span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;42&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">]</span>`,wrap:!1}}),S=new d({props:{title:"Using a VLM via pipeline",local:"using-a-vlm-via-pipeline",headingTag:"h2"}}),X=new is({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHBpcGVsaW5lJTIwd2l0aCUyMGElMjBWTE0lMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2UtdGV4dC10by10ZXh0JTIyJTJDJTIwJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xWTE0yLTIuMkItSW5zdHJ1Y3QlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEElMEElMjMlMjBEZWZpbmUlMjB5b3VyJTIwY29udmVyc2F0aW9uJTIwd2l0aCUyMGFuJTIwaW1hZ2UlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCU1RCUwQSUwQW91dHB1dHMlMjAlM0QlMjBwaXBlKHRleHQlM0RtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjAlMkMlMjByZXR1cm5fZnVsbF90ZXh0JTNERmFsc2UpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjByZXNwb25zZSUyMC0lMjBwaXBlbGluZSUyMGhhbmRsZXMlMjBtdWx0aW1vZGFsJTIwaW5wdXRzJTIwYXV0b21hdGljYWxseSUwQXJlc3BvbnNlJTIwJTNEJTIwcGlwZShtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTIwdGVtcGVyYXR1cmUlM0QwLjcpJTBBJTBBcHJpbnQocmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEJTVCJ2NvbnRlbnQnJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwbW9kZWwncyUyMGRlc2NyaXB0aW9u",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Initialize the pipeline with a VLM</span>
pipe = pipeline(<span class="hljs-string">&quot;image-text-to-text&quot;</span>, <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

<span class="hljs-comment"># Define your conversation with an image</span>
messages = [
     {
         <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
         <span class="hljs-string">&quot;content&quot;</span>: [
             {
                 <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                 <span class="hljs-string">&quot;image&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>,
             },
             {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image.&quot;</span>},
         ],
     }
 ]

outputs = pipe(text=messages, max_new_tokens=<span class="hljs-number">60</span>, return_full_text=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Generate response - pipeline handles multimodal inputs automatically</span>
response = pipe(messages, max_new_tokens=<span class="hljs-number">128</span>, temperature=<span class="hljs-number">0.7</span>)

<span class="hljs-built_in">print</span>(response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>][<span class="hljs-string">&#x27;content&#x27;</span>])  <span class="hljs-comment"># Print the model&#x27;s description</span>`,wrap:!1}}),Y=new is({props:{code:"VGhlJTIwaW1hZ2UlMjBkZXBpY3RzJTIwYSUyMGNsb3NlLXVwJTIwdmlldyUyMG9mJTIwYSUyMGZsb3dlciUyMGdhcmRlbiUyQyUyMHNwZWNpZmljYWxseSUyMGZvY3VzaW5nJTIwb24lMjBhJTIwcGluayUyMGZsb3dlci4lMjBUaGUlMjBmbG93ZXIlMjBpcyUyMHRoZSUyMGNlbnRyYWwlMjBzdWJqZWN0JTIwb2YlMjB0aGUlMjBpbWFnZSUyQyUyMGFuZCUyMGl0JTIwaXMlMjBhJTIwcHJvbWluZW50JTIwZmVhdHVyZSUyMGR1ZSUyMHRvJTIwaXRzJTIwdmlicmFudCUyMGNvbG9yJTIwYW5kJTIwaW50cmljYXRlJTIwZGV0YWlscy4lMjBUaGUlMjBmbG93ZXIlMjBoYXMlMjBhJTIwY2lyY3VsYXIlMjBzaGFwZSUyQyUyMHdpdGglMjBwZXRhbHMlMjB0aGF0JTIwYXJlJTIwc2xpZ2h0bHklMjBjdXJsZWQlMjBhbmQlMjBoYXZlJTIwYSUyMGdyYWRpZW50JTIwZnJvbSUyMGxpZ2h0JTIwdG8lMjBkYXJrJTIwcGluay4lMjBUaGUlMjBwZXRhbHMlMjBhcmUlMjBhcnJhbmdlZCUyMHN5bW1ldHJpY2FsbHklMjBhcm91bmQlMjB0aGUlMjBjZW50cmFsJTIwcGlzdGlsJTJDJTIwd2hpY2glMjBpcyUyMHZpc2libGUlMjBpbiUyMHRoZSUyMGNlbnRlciUyMG9mJTIwdGhlJTIwZmxvd2VyLiUyMFRoZSUyMHBpc3RpbCUyMGlzJTIwYSUyMHNtYWxsJTJDJTIweWVsbG93JTIwc3RydWN0dXJlJTIwdGhhdCUyMGlzJTIwc3Vycm91bmRlZCUyMGJ5JTIwYSUyMGNsdXN0ZXIlMjBvZiUyMHN0YW1lbnMlMkMlMjB3aGljaCUyMGFyZSUyMHZpc2libGUlMjBhcyUyMHNtYWxsJTJDJTIweWVsbG93JTIwc3RydWN0dXJlcy4lMjBUaGUlMjBmbG93ZXIlMjBhbHNvJTIwaGFzJTIwYSUyMHNtYWxsJTJDJTIwYmxhY2s=",highlighted:"The image depicts a close-up view of a flower garden, specifically focusing on a pink flower. The flower is the central subject of the image, and it is a prominent feature due to its vibrant color and intricate details. The flower has a circular shape, with petals that are slightly curled and have a gradient from light to dark pink. The petals are arranged symmetrically around the central pistil, which is visible in the center of the flower. The pistil is a small, yellow structure that is surrounded by a cluster of stamens, which are visible as small, yellow structures. The flower also has a small, black",wrap:!1}}),k=new d({props:{title:"Using a VLM via Transformers (Full Control)",local:"using-a-vlm-via-transformers-full-control",headingTag:"h2"}}),_=new is({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMuaW1hZ2VfdXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEElMjMlMjBRdWFudGl6YXRpb24lMjBmb3IlMjBlZmZpY2llbmN5JTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNMi0yLjJCLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText, BitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

<span class="hljs-comment"># Quantization for efficiency</span>
quant_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)
model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>
model = AutoModelForImageTextToText.from_pretrained(model_name, quantization_config=quant_config).to(device)
processor = AutoProcessor.from_pretrained(model_name)`,wrap:!1}}),L=new d({props:{title:"Example: Describe an Image",local:"example-describe-an-image",headingTag:"h3"}}),P=new is({props:{code:"JTIzJTIwTG9hZCUyMGltYWdlJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwaW5wdXQlMjBtZXNzYWdlcyUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyQ2FuJTIweW91JTIwZGVzY3JpYmUlMjB0aGUlMjBpbWFnZSUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RCUwQSUwQSUyMyUyMFByZXBhcmUlMjBpbnB1dHMlMEFwcm9tcHQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjBpbWFnZXMlM0QlNUJpbWFnZSU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwaW5wdXRzLnRvKGRldmljZSklMEElMEElMjMlMjBHZW5lcmF0ZSUyMG91dHB1dHMlMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwMCklMEFnZW5lcmF0ZWRfdGV4dHMlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9pZHMlMkMlMEElMjAlMjAlMjAlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUwQSklNUIwJTVEJTBBJTBBJTIzJTIwRXh0cmFjdCUyMG9ubHklMjB0aGUlMjBhc3Npc3RhbnQlMjByZXNwb25zZSUwQWFzc2lzdGFudF9yZXNwb25zZSUyMCUzRCUyMGdlbmVyYXRlZF90ZXh0cy5zcGxpdCglMjJBc3Npc3RhbnQlM0ElMjIpJTVCLTElNUQuc3RyaXAoKSUwQSUwQXByaW50KGFzc2lzdGFudF9yZXNwb25zZSk=",highlighted:`<span class="hljs-comment"># Load image</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
image = load_image(image_url)

<span class="hljs-comment"># Create input messages</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Can you describe the image?&quot;</span>}
        ]
    },
]

<span class="hljs-comment"># Prepare inputs</span>
prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(text=prompt, images=[image], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = inputs.to(device)

<span class="hljs-comment"># Generate outputs</span>
generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">500</span>)
generated_texts = processor.batch_decode(
    generated_ids,
    skip_special_tokens=<span class="hljs-literal">True</span>,
)[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Extract only the assistant response</span>
assistant_response = generated_texts.split(<span class="hljs-string">&quot;Assistant:&quot;</span>)[-<span class="hljs-number">1</span>].strip()

<span class="hljs-built_in">print</span>(assistant_response)`,wrap:!1}}),D=new is({props:{code:"VGhlJTIwaW1hZ2UlMjBpcyUyMG9mJTIwYSUyMGJlZSUyMG9uJTIwYSUyMGZsb3dlci4=",highlighted:"The image is of a bee on a flower.",wrap:!1}}),j=new It({props:{$$slots:{default:[bt]},$$scope:{ctx:os}}}),O=new d({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ts=new ft({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit4/2.md"}}),{c(){o=i("meta"),g=a(),h=i("p"),ls=a(),u(w.$$.fragment),us=a(),C=i("p"),C.innerHTML=Ps,rs=a(),u(I.$$.fragment),ys=a(),f=i("p"),f.innerHTML=Ds,cs=a(),b=i("p"),b.textContent=Ks,Us=a(),Z=i("ul"),Z.innerHTML=Os,ms=a(),B=i("p"),B.innerHTML=st,hs=a(),u(G.$$.fragment),Js=a(),W=i("p"),W.textContent=tt,Ts=a(),v=i("ul"),v.innerHTML=et,js=a(),$=i("p"),$.textContent=lt,ds=a(),q=i("p"),q.innerHTML=at,gs=a(),u(R.$$.fragment),ws=a(),V=i("p"),V.innerHTML=nt,Cs=a(),x=i("ol"),x.innerHTML=it,Is=a(),Q=i("p"),Q.textContent=pt,fs=a(),u(N.$$.fragment),bs=a(),H=i("p"),H.innerHTML=Mt,Zs=a(),u(S.$$.fragment),Bs=a(),E=i("p"),E.innerHTML=ot,Gs=a(),u(X.$$.fragment),Ws=a(),J=i("details"),as=i("summary"),as.textContent=ut,Ls=a(),u(Y.$$.fragment),vs=a(),u(k.$$.fragment),$s=a(),F=i("p"),F.innerHTML=rt,qs=a(),z=i("p"),z.innerHTML=yt,Rs=a(),u(_.$$.fragment),Vs=a(),u(L.$$.fragment),xs=a(),A=i("p"),A.innerHTML=ct,Qs=a(),u(P.$$.fragment),Ns=a(),T=i("details"),ns=i("summary"),ns.textContent=Ut,As=a(),u(D.$$.fragment),Hs=a(),K=i("p"),K.textContent=mt,Ss=a(),u(j.$$.fragment),Es=a(),u(O.$$.fragment),Xs=a(),ss=i("ul"),ss.innerHTML=ht,Ys=a(),u(ts.$$.fragment),ks=a(),ps=i("p"),this.h()},l(s){const t=Ct("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(e),g=n(s),h=p(s,"P",{}),_s(h).forEach(e),ls=n(s),r(w.$$.fragment,s),us=n(s),C=p(s,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1x3y1qf"&&(C.innerHTML=Ps),rs=n(s),r(I.$$.fragment,s),ys=n(s),f=p(s,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1dh85sm"&&(f.innerHTML=Ds),cs=n(s),b=p(s,"P",{"data-svelte-h":!0}),M(b)!=="svelte-adkga0"&&(b.textContent=Ks),Us=n(s),Z=p(s,"UL",{"data-svelte-h":!0}),M(Z)!=="svelte-1s27o17"&&(Z.innerHTML=Os),ms=n(s),B=p(s,"P",{"data-svelte-h":!0}),M(B)!=="svelte-unkaqn"&&(B.innerHTML=st),hs=n(s),r(G.$$.fragment,s),Js=n(s),W=p(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1jrkij4"&&(W.textContent=tt),Ts=n(s),v=p(s,"UL",{"data-svelte-h":!0}),M(v)!=="svelte-d0zug6"&&(v.innerHTML=et),js=n(s),$=p(s,"P",{"data-svelte-h":!0}),M($)!=="svelte-1pcr0l7"&&($.textContent=lt),ds=n(s),q=p(s,"P",{"data-svelte-h":!0}),M(q)!=="svelte-7gzl70"&&(q.innerHTML=at),gs=n(s),r(R.$$.fragment,s),ws=n(s),V=p(s,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1qfbv65"&&(V.innerHTML=nt),Cs=n(s),x=p(s,"OL",{"data-svelte-h":!0}),M(x)!=="svelte-1i8rfc0"&&(x.innerHTML=it),Is=n(s),Q=p(s,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-11lpom8"&&(Q.textContent=pt),fs=n(s),r(N.$$.fragment,s),bs=n(s),H=p(s,"P",{"data-svelte-h":!0}),M(H)!=="svelte-wso7db"&&(H.innerHTML=Mt),Zs=n(s),r(S.$$.fragment,s),Bs=n(s),E=p(s,"P",{"data-svelte-h":!0}),M(E)!=="svelte-siuzhz"&&(E.innerHTML=ot),Gs=n(s),r(X.$$.fragment,s),Ws=n(s),J=p(s,"DETAILS",{});var es=_s(J);as=p(es,"SUMMARY",{"data-svelte-h":!0}),M(as)!=="svelte-nfzy3j"&&(as.textContent=ut),Ls=n(es),r(Y.$$.fragment,es),es.forEach(e),vs=n(s),r(k.$$.fragment,s),$s=n(s),F=p(s,"P",{"data-svelte-h":!0}),M(F)!=="svelte-5cbqik"&&(F.innerHTML=rt),qs=n(s),z=p(s,"P",{"data-svelte-h":!0}),M(z)!=="svelte-imt3e1"&&(z.innerHTML=yt),Rs=n(s),r(_.$$.fragment,s),Vs=n(s),r(L.$$.fragment,s),xs=n(s),A=p(s,"P",{"data-svelte-h":!0}),M(A)!=="svelte-q4e8ot"&&(A.innerHTML=ct),Qs=n(s),r(P.$$.fragment,s),Ns=n(s),T=p(s,"DETAILS",{});var zs=_s(T);ns=p(zs,"SUMMARY",{"data-svelte-h":!0}),M(ns)!=="svelte-nfzy3j"&&(ns.textContent=Ut),As=n(zs),r(D.$$.fragment,zs),zs.forEach(e),Hs=n(s),K=p(s,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1v039s9"&&(K.textContent=mt),Ss=n(s),r(j.$$.fragment,s),Es=n(s),r(O.$$.fragment,s),Xs=n(s),ss=p(s,"UL",{"data-svelte-h":!0}),M(ss)!=="svelte-uziv6c"&&(ss.innerHTML=ht),Ys=n(s),r(ts.$$.fragment,s),ks=n(s),ps=p(s,"P",{}),_s(ps).forEach(e),this.h()},h(){Jt(o,"name","hf:doc:metadata"),Jt(o,"content",Bt)},m(s,t){Ms(document.head,o),l(s,g,t),l(s,h,t),l(s,ls,t),y(w,s,t),l(s,us,t),l(s,C,t),l(s,rs,t),y(I,s,t),l(s,ys,t),l(s,f,t),l(s,cs,t),l(s,b,t),l(s,Us,t),l(s,Z,t),l(s,ms,t),l(s,B,t),l(s,hs,t),y(G,s,t),l(s,Js,t),l(s,W,t),l(s,Ts,t),l(s,v,t),l(s,js,t),l(s,$,t),l(s,ds,t),l(s,q,t),l(s,gs,t),y(R,s,t),l(s,ws,t),l(s,V,t),l(s,Cs,t),l(s,x,t),l(s,Is,t),l(s,Q,t),l(s,fs,t),y(N,s,t),l(s,bs,t),l(s,H,t),l(s,Zs,t),y(S,s,t),l(s,Bs,t),l(s,E,t),l(s,Gs,t),y(X,s,t),l(s,Ws,t),l(s,J,t),Ms(J,as),Ms(J,Ls),y(Y,J,null),l(s,vs,t),y(k,s,t),l(s,$s,t),l(s,F,t),l(s,qs,t),l(s,z,t),l(s,Rs,t),y(_,s,t),l(s,Vs,t),y(L,s,t),l(s,xs,t),l(s,A,t),l(s,Qs,t),y(P,s,t),l(s,Ns,t),l(s,T,t),Ms(T,ns),Ms(T,As),y(D,T,null),l(s,Hs,t),l(s,K,t),l(s,Ss,t),y(j,s,t),l(s,Es,t),y(O,s,t),l(s,Xs,t),l(s,ss,t),l(s,Ys,t),y(ts,s,t),l(s,ks,t),l(s,ps,t),Fs=!0},p(s,[t]){const es={};t&2&&(es.$$scope={dirty:t,ctx:s}),j.$set(es)},i(s){Fs||(c(w.$$.fragment,s),c(I.$$.fragment,s),c(G.$$.fragment,s),c(R.$$.fragment,s),c(N.$$.fragment,s),c(S.$$.fragment,s),c(X.$$.fragment,s),c(Y.$$.fragment,s),c(k.$$.fragment,s),c(_.$$.fragment,s),c(L.$$.fragment,s),c(P.$$.fragment,s),c(D.$$.fragment,s),c(j.$$.fragment,s),c(O.$$.fragment,s),c(ts.$$.fragment,s),Fs=!0)},o(s){U(w.$$.fragment,s),U(I.$$.fragment,s),U(G.$$.fragment,s),U(R.$$.fragment,s),U(N.$$.fragment,s),U(S.$$.fragment,s),U(X.$$.fragment,s),U(Y.$$.fragment,s),U(k.$$.fragment,s),U(_.$$.fragment,s),U(L.$$.fragment,s),U(P.$$.fragment,s),U(D.$$.fragment,s),U(j.$$.fragment,s),U(O.$$.fragment,s),U(ts.$$.fragment,s),Fs=!1},d(s){s&&(e(g),e(h),e(ls),e(us),e(C),e(rs),e(ys),e(f),e(cs),e(b),e(Us),e(Z),e(ms),e(B),e(hs),e(Js),e(W),e(Ts),e(v),e(js),e($),e(ds),e(q),e(gs),e(ws),e(V),e(Cs),e(x),e(Is),e(Q),e(fs),e(bs),e(H),e(Zs),e(Bs),e(E),e(Gs),e(Ws),e(J),e(vs),e($s),e(F),e(qs),e(z),e(Rs),e(Vs),e(xs),e(A),e(Qs),e(Ns),e(T),e(Hs),e(K),e(Ss),e(Es),e(Xs),e(ss),e(Ys),e(ks),e(ps)),e(o),m(w,s),m(I,s),m(G,s),m(R,s),m(N,s),m(S,s),m(X,s),m(Y),m(k,s),m(_,s),m(L,s),m(P,s),m(D),m(j,s),m(O,s),m(ts,s)}}}const Bt='{"title":"Using Pretrained VLMs","local":"using-pretrained-vlms","sections":[{"title":"Architecture Overview","local":"architecture-overview","sections":[],"depth":2},{"title":"Practical Usage","local":"practical-usage","sections":[{"title":"Chat Format","local":"chat-format","sections":[],"depth":3}],"depth":2},{"title":"Using a VLM via pipeline","local":"using-a-vlm-via-pipeline","sections":[],"depth":2},{"title":"Using a VLM via Transformers (Full Control)","local":"using-a-vlm-via-transformers-full-control","sections":[{"title":"Example: Describe an Image","local":"example-describe-an-image","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Gt(os){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends gt{constructor(o){super(),wt(this,o,Gt,Zt,Tt,{})}}export{Vt as component};
