import{s as je,n as _e,o as ve}from"../chunks/scheduler.412302f6.js";import{S as be,i as Ze,g as c,s,r as i,A as Ce,h as M,f as l,c as n,j as Ue,u as r,x as u,k as Je,y as Be,a,v as p,d as m,t as o,w as f}from"../chunks/index.f36f02f5.js";import{C as ce}from"../chunks/CodeBlock.f4a4ce81.js";import{H as d}from"../chunks/Heading.41d80af4.js";function xe(Me){let y,E,X,P,T,L,w,z,g,de="When fine-tuning Large Language Models (LLMs) on TPUs, model sharding across devices becomes essential for memory efficiency and improved training performance. The <code>optimum.tpu.fsdp_v2</code> module provides utilities for implementing Fully Sharded Data Parallel training using SPMD (Single Program Multiple Data) specifically optimized for TPU devices.",G,$,H,h,ye="<li>Model weight sharding across TPU devices</li> <li>Gradient checkpointing support</li> <li>Automatic configuration for common model architectures</li> <li>Integration with PyTorch/XLA’s SPMD implementation</li>",Y,U,V,J,ue="Here’s how to enable and configure FSDP_v2 for your training:",D,j,N,_,q,v,Te="The <code>get_fsdp_training_args()</code> function returns a dictionary with a model-specific configuration such as:",K,b,O,Z,ee,C,we="<li><code>transformer_layer_cls_to_wrap</code>: Specifies which model layers to wrap with FSDP</li> <li><code>xla</code>: Enables XLA optimization</li> <li><code>xla_fsdp_v2</code>: Activates FSDP_v2 implementation</li> <li><code>xla_fsdp_grad_ckpt</code>: Enables gradient checkpointing for memory efficiency</li>",te,B,le,x,ae,F,ge="You can customize which layers get wrapped with FSDP:",se,W,ne,I,ie,S,$e="FSDP_v2 configuration can be directly used with the Transformers Trainer:",re,k,pe,A,me,R,he='<li>You can look our <a href="../howto/more_examples">example notebooks</a> for best practice on training with optimum-tpu</li> <li>For more details on PyTorch/XLA’s FSDP implementation, refer to the <a href="https://pytorch.org/xla/master/#fully-sharded-data-parallel-via-spmd" rel="nofollow">official documentation</a>.</li>',oe,Q,fe;return T=new d({props:{title:"Fully Sharded Data Parallel (FSDP) v2",local:"fully-sharded-data-parallel-fsdp-v2",headingTag:"h1"}}),w=new d({props:{title:"Overview",local:"overview",headingTag:"h2"}}),$=new d({props:{title:"FSDP_v2 Features",local:"fsdpv2-features",headingTag:"h2"}}),U=new d({props:{title:"Basic Usage",local:"basic-usage",headingTag:"h2"}}),j=new ce({props:{code:"ZnJvbSUyMG9wdGltdW0udHB1JTIwaW1wb3J0JTIwZnNkcF92MiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMEVuYWJsZSUyMEZTRFBfdjIlMEFmc2RwX3YyLnVzZV9mc2RwX3YyKCklMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMjBhbmQlMjB0b2tlbml6ZXIlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQSUyMyUyMEdldCUyMEZTRFAlMjB0cmFpbmluZyUyMGNvbmZpZ3VyYXRpb24lMEFmc2RwX2FyZ3MlMjAlM0QlMjBmc2RwX3YyLmdldF9mc2RwX3RyYWluaW5nX2FyZ3MobW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> optimum.tpu <span class="hljs-keyword">import</span> fsdp_v2
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># Enable FSDP_v2</span>
fsdp_v2.use_fsdp_v2()

<span class="hljs-comment"># Load model and tokenizer</span>
model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(
    model_id, 
    torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># Get FSDP training configuration</span>
fsdp_args = fsdp_v2.get_fsdp_training_args(model)`,wrap:!1}}),_=new d({props:{title:"Configuration Options",local:"configuration-options",headingTag:"h2"}}),b=new ce({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ2ZzZHAnJTNBJTIwJ2Z1bGxfc2hhcmQnJTJDJTBBJTIwJTIwJTIwJTIwJ2ZzZHBfY29uZmlnJyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCd0cmFuc2Zvcm1lcl9sYXllcl9jbHNfdG9fd3JhcCclM0ElMjAlNUInTGxhbWFEZWNvZGVyTGF5ZXInJTVEJTJDJTIwJTIwJTIzJTIwTW9kZWwtc3BlY2lmaWMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAneGxhJyUzQSUyMFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAneGxhX2ZzZHBfdjInJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCd4bGFfZnNkcF9ncmFkX2NrcHQnJTNBJTIwVHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`{
    <span class="hljs-string">&#x27;fsdp&#x27;</span>: <span class="hljs-string">&#x27;full_shard&#x27;</span>,
    <span class="hljs-string">&#x27;fsdp_config&#x27;</span>: {
        <span class="hljs-string">&#x27;transformer_layer_cls_to_wrap&#x27;</span>: [<span class="hljs-string">&#x27;LlamaDecoderLayer&#x27;</span>],  <span class="hljs-comment"># Model-specific</span>
        <span class="hljs-string">&#x27;xla&#x27;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&#x27;xla_fsdp_v2&#x27;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&#x27;xla_fsdp_grad_ckpt&#x27;</span>: <span class="hljs-literal">True</span>
    }
}`,wrap:!1}}),Z=new d({props:{title:"Key Parameters",local:"key-parameters",headingTag:"h3"}}),B=new d({props:{title:"Advanced Usage",local:"advanced-usage",headingTag:"h2"}}),x=new d({props:{title:"Custom Layer Wrapping",local:"custom-layer-wrapping",headingTag:"h3"}}),W=new ce({props:{code:"Y3VzdG9tX2ZzZHBfYXJncyUyMCUzRCUyMGZzZHBfdjIuZ2V0X2ZzZHBfdHJhaW5pbmdfYXJncyglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGxheWVyX2Nsc190b193cmFwJTNEJTVCJ0N1c3RvbVRyYW5zZm9ybWVyTGF5ZXInJTVEJTBBKQ==",highlighted:`custom_fsdp_args = fsdp_v2.get_fsdp_training_args(
    model,
    layer_cls_to_wrap=[<span class="hljs-string">&#x27;CustomTransformerLayer&#x27;</span>]
)`,wrap:!1}}),I=new d({props:{title:"Integration with Transformers Trainer",local:"integration-with-transformers-trainer",headingTag:"h3"}}),k=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUwQSUyMyUyME9yJTIwZm9yJTIwaW5zdHJ1Y3Rpb24lMjBmaW5lLXR1bmluZyUzQSUwQSUyMyUyMGZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTIwJTIwJTIzJTIwb3IlMjBTRlRUcmFpbmVyJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RUcmFpbmluZ0FyZ3VtZW50cygqKmZzZHBfYXJncyklMkMlMjAlMjAlMjMlMjBVbnBhY2slMjBGU0RQJTIwY29uZmlndXJhdGlvbiUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, TrainingArguments
<span class="hljs-comment"># Or for instruction fine-tuning:</span>
<span class="hljs-comment"># from trl import SFTTrainer</span>

trainer = Trainer(  <span class="hljs-comment"># or SFTTrainer</span>
    model=model,
    args=TrainingArguments(**fsdp_args),  <span class="hljs-comment"># Unpack FSDP configuration</span>
    train_dataset=dataset,
    ...
)`,wrap:!1}}),A=new d({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){y=c("meta"),E=s(),X=c("p"),P=s(),i(T.$$.fragment),L=s(),i(w.$$.fragment),z=s(),g=c("p"),g.innerHTML=de,G=s(),i($.$$.fragment),H=s(),h=c("ul"),h.innerHTML=ye,Y=s(),i(U.$$.fragment),V=s(),J=c("p"),J.textContent=ue,D=s(),i(j.$$.fragment),N=s(),i(_.$$.fragment),q=s(),v=c("p"),v.innerHTML=Te,K=s(),i(b.$$.fragment),O=s(),i(Z.$$.fragment),ee=s(),C=c("ul"),C.innerHTML=we,te=s(),i(B.$$.fragment),le=s(),i(x.$$.fragment),ae=s(),F=c("p"),F.textContent=ge,se=s(),i(W.$$.fragment),ne=s(),i(I.$$.fragment),ie=s(),S=c("p"),S.textContent=$e,re=s(),i(k.$$.fragment),pe=s(),i(A.$$.fragment),me=s(),R=c("ul"),R.innerHTML=he,oe=s(),Q=c("p"),this.h()},l(e){const t=Ce("svelte-u9bgzb",document.head);y=M(t,"META",{name:!0,content:!0}),t.forEach(l),E=n(e),X=M(e,"P",{}),Ue(X).forEach(l),P=n(e),r(T.$$.fragment,e),L=n(e),r(w.$$.fragment,e),z=n(e),g=M(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-9gxvdp"&&(g.innerHTML=de),G=n(e),r($.$$.fragment,e),H=n(e),h=M(e,"UL",{"data-svelte-h":!0}),u(h)!=="svelte-jiwz3k"&&(h.innerHTML=ye),Y=n(e),r(U.$$.fragment,e),V=n(e),J=M(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-qcoe45"&&(J.textContent=ue),D=n(e),r(j.$$.fragment,e),N=n(e),r(_.$$.fragment,e),q=n(e),v=M(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-6xeqve"&&(v.innerHTML=Te),K=n(e),r(b.$$.fragment,e),O=n(e),r(Z.$$.fragment,e),ee=n(e),C=M(e,"UL",{"data-svelte-h":!0}),u(C)!=="svelte-ohjv5j"&&(C.innerHTML=we),te=n(e),r(B.$$.fragment,e),le=n(e),r(x.$$.fragment,e),ae=n(e),F=M(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-dpqjbp"&&(F.textContent=ge),se=n(e),r(W.$$.fragment,e),ne=n(e),r(I.$$.fragment,e),ie=n(e),S=M(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-cp5i4o"&&(S.textContent=$e),re=n(e),r(k.$$.fragment,e),pe=n(e),r(A.$$.fragment,e),me=n(e),R=M(e,"UL",{"data-svelte-h":!0}),u(R)!=="svelte-uoiu9s"&&(R.innerHTML=he),oe=n(e),Q=M(e,"P",{}),Ue(Q).forEach(l),this.h()},h(){Je(y,"name","hf:doc:metadata"),Je(y,"content",Fe)},m(e,t){Be(document.head,y),a(e,E,t),a(e,X,t),a(e,P,t),p(T,e,t),a(e,L,t),p(w,e,t),a(e,z,t),a(e,g,t),a(e,G,t),p($,e,t),a(e,H,t),a(e,h,t),a(e,Y,t),p(U,e,t),a(e,V,t),a(e,J,t),a(e,D,t),p(j,e,t),a(e,N,t),p(_,e,t),a(e,q,t),a(e,v,t),a(e,K,t),p(b,e,t),a(e,O,t),p(Z,e,t),a(e,ee,t),a(e,C,t),a(e,te,t),p(B,e,t),a(e,le,t),p(x,e,t),a(e,ae,t),a(e,F,t),a(e,se,t),p(W,e,t),a(e,ne,t),p(I,e,t),a(e,ie,t),a(e,S,t),a(e,re,t),p(k,e,t),a(e,pe,t),p(A,e,t),a(e,me,t),a(e,R,t),a(e,oe,t),a(e,Q,t),fe=!0},p:_e,i(e){fe||(m(T.$$.fragment,e),m(w.$$.fragment,e),m($.$$.fragment,e),m(U.$$.fragment,e),m(j.$$.fragment,e),m(_.$$.fragment,e),m(b.$$.fragment,e),m(Z.$$.fragment,e),m(B.$$.fragment,e),m(x.$$.fragment,e),m(W.$$.fragment,e),m(I.$$.fragment,e),m(k.$$.fragment,e),m(A.$$.fragment,e),fe=!0)},o(e){o(T.$$.fragment,e),o(w.$$.fragment,e),o($.$$.fragment,e),o(U.$$.fragment,e),o(j.$$.fragment,e),o(_.$$.fragment,e),o(b.$$.fragment,e),o(Z.$$.fragment,e),o(B.$$.fragment,e),o(x.$$.fragment,e),o(W.$$.fragment,e),o(I.$$.fragment,e),o(k.$$.fragment,e),o(A.$$.fragment,e),fe=!1},d(e){e&&(l(E),l(X),l(P),l(L),l(z),l(g),l(G),l(H),l(h),l(Y),l(V),l(J),l(D),l(N),l(q),l(v),l(K),l(O),l(ee),l(C),l(te),l(le),l(ae),l(F),l(se),l(ne),l(ie),l(S),l(re),l(pe),l(me),l(R),l(oe),l(Q)),l(y),f(T,e),f(w,e),f($,e),f(U,e),f(j,e),f(_,e),f(b,e),f(Z,e),f(B,e),f(x,e),f(W,e),f(I,e),f(k,e),f(A,e)}}}const Fe='{"title":"Fully Sharded Data Parallel (FSDP) v2","local":"fully-sharded-data-parallel-fsdp-v2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"FSDP_v2 Features","local":"fsdpv2-features","sections":[],"depth":2},{"title":"Basic Usage","local":"basic-usage","sections":[],"depth":2},{"title":"Configuration Options","local":"configuration-options","sections":[{"title":"Key Parameters","local":"key-parameters","sections":[],"depth":3}],"depth":2},{"title":"Advanced Usage","local":"advanced-usage","sections":[{"title":"Custom Layer Wrapping","local":"custom-layer-wrapping","sections":[],"depth":3},{"title":"Integration with Transformers Trainer","local":"integration-with-transformers-trainer","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function We(Me){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Re extends be{constructor(y){super(),Ze(this,y,We,xe,je,{})}}export{Re as component};
