import{s as Vn,o as qn,n as Ee}from"../chunks/scheduler.37c15a92.js";import{S as Ln,i as Nn,g as h,s as i,r as o,A as Pn,h as f,f as n,c as s,j as An,u as p,x as g,k as Bn,y as Sn,a,v as c,d,t as u,w as m}from"../chunks/index.7cb9c9b8.js";import{T as Ye}from"../chunks/Tip.d10b3fc9.js";import{Y as Dn}from"../chunks/Youtube.8666c400.js";import{C as y}from"../chunks/CodeBlock.abae2786.js";import{C as Kn}from"../chunks/CourseFloatingBanner.df82c153.js";import{Q as Qe}from"../chunks/Question.7e41e492.js";import{F as On}from"../chunks/FrameworkSwitchCourse.97630871.js";import{H as J,E as ea}from"../chunks/getInferenceSnippets.50ff7b37.js";function ta(M){let l,$='📚 <strong>Training Resources</strong>: Before diving into training, familiarize yourself with the comprehensive <a href="https://huggingface.co/docs/transformers/main/en/training" rel="nofollow">🤗 Transformers training guide</a> and explore practical examples in the <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">fine-tuning cookbook</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-vqxqic"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Ee,d(r){r&&n(l)}}}function na(M){let l,$='🚀 <strong>Advanced Configuration</strong>: For detailed information on all available training arguments and optimization strategies, check out the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments documentation</a> and the <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">training configuration cookbook</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1ygyaam"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Ee,d(r){r&&n(l)}}}function aa(M){let l,$='📖 <strong>Learn More</strong>: For comprehensive details on the Trainer class and its parameters, visit the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer" rel="nofollow">Trainer API documentation</a> and explore advanced usage patterns in the <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">training cookbook recipes</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-9voy91"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Ee,d(r){r&&n(l)}}}function ia(M){let l,$='Learn about different evaluation metrics and strategies in the <a href="https://huggingface.co/docs/evaluate/" rel="nofollow">🤗 Evaluate documentation</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-q6q1ak"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Ee,d(r){r&&n(l)}}}function sa(M){let l,$='🎯 <strong>Performance Optimization</strong>: For more advanced training techniques including distributed training, memory optimization, and hardware-specific optimizations, explore the <a href="https://huggingface.co/docs/transformers/main/en/performance" rel="nofollow">🤗 Transformers performance guide</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-lxa5df"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Ee,d(r){r&&n(l)}}}function la(M){let l,$='📝 <strong>More Examples</strong>: Check out the comprehensive collection of <a href="https://huggingface.co/docs/transformers/main/en/notebooks" rel="nofollow">🤗 Transformers notebooks</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1i8p502"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Ee,d(r){r&&n(l)}}}function ra(M){let l,$="💡 <strong>Key Takeaways:</strong>",r,w,b="<li>The <code>Trainer</code> API provides a high-level interface that handles most training complexity</li> <li>Use <code>processing_class</code> to specify your tokenizer for proper data handling</li> <li><code>TrainingArguments</code> controls all aspects of training: learning rate, batch size, evaluation strategy, and optimizations</li> <li><code>compute_metrics</code> enables custom evaluation metrics beyond just training loss</li> <li>Modern features like mixed precision (<code>fp16=True</code>) and gradient accumulation can significantly improve training efficiency</li>";return{c(){l=h("p"),l.innerHTML=$,r=i(),w=h("ul"),w.innerHTML=b},l(T){l=f(T,"P",{"data-svelte-h":!0}),g(l)!=="svelte-l314m0"&&(l.innerHTML=$),r=s(T),w=f(T,"UL",{"data-svelte-h":!0}),g(w)!=="svelte-1pp57h2"&&(w.innerHTML=b)},m(T,v){a(T,l,v),a(T,r,v),a(T,w,v)},p:Ee,d(T){T&&(n(l),n(r),n(w))}}}function oa(M){let l,$,r,w,b,T,v,Be,H,Ve,R,qe,Z,on='🤗 Transformers provides a <code>Trainer</code> class to help you fine-tune any of the pretrained models it provides on your dataset with modern best practices. Once you’ve done all the data preprocessing work in the last section, you have just a few steps left to define the <code>Trainer</code>. The hardest part is likely to be preparing the environment to run <code>Trainer.train()</code>, as it will run very slowly on a CPU. If you don’t have a GPU set up, you can get access to free GPUs or TPUs on <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',Le,j,Ne,G,pn="The code examples below assume you have already executed the examples in the previous section. Here is a short summary recapping what you need:",Pe,I,Se,z,De,X,cn="The first step before we can define our <code>Trainer</code> is to define a <code>TrainingArguments</code> class that will contain all the hyperparameters the <code>Trainer</code> will use for training and evaluation. The only argument you have to provide is a directory where the trained model will be saved, as well as the checkpoints along the way. For all the rest, you can leave the defaults, which should work pretty well for a basic fine-tuning.",Ke,F,Oe,Y,dn='If you want to automatically upload your model to the Hub during training, pass along <code>push_to_hub=True</code> in the <code>TrainingArguments</code>. We will learn more about this in <a href="/course/chapter4/3">Chapter 4</a>',et,_,tt,E,un='The second step is to define our model. As in the <a href="/course/chapter2">previous chapter</a>, we will use the <code>AutoModelForSequenceClassification</code> class, with two labels:',nt,Q,at,A,mn='You will notice that unlike in <a href="/course/chapter2">Chapter 2</a>, you get a warning after instantiating this pretrained model. This is because BERT has not been pretrained on classifying pairs of sentences, so the head of the pretrained model has been discarded and a new head suitable for sequence classification has been added instead. The warnings indicate that some weights were not used (the ones corresponding to the dropped pretraining head) and that some others were randomly initialized (the ones for the new head). It concludes by encouraging you to train the model, which is exactly what we are going to do now.',it,B,hn="Once we have our model, we can define a <code>Trainer</code> by passing it all the objects constructed up to now — the <code>model</code>, the <code>training_args</code>, the training and validation datasets, our <code>data_collator</code>, and our <code>processing_class</code>. The <code>processing_class</code> parameter is a newer addition that tells the Trainer which tokenizer to use for processing:",st,V,lt,q,fn="When you pass a tokenizer as the <code>processing_class</code>, the default <code>data_collator</code> used by the <code>Trainer</code> will be a <code>DataCollatorWithPadding</code>. You can skip the <code>data_collator=data_collator</code> line in this case, but we included it here to show you this important part of the processing pipeline.",rt,U,ot,L,gn="To fine-tune the model on our dataset, we just have to call the <code>train()</code> method of our <code>Trainer</code>:",pt,N,ct,P,$n="This will start the fine-tuning (which should take a couple of minutes on a GPU) and report the training loss every 500 steps. It won’t, however, tell you how well (or badly) your model is performing. This is because:",dt,S,wn="<li>We didn’t tell the <code>Trainer</code> to evaluate during training by setting <code>eval_strategy</code> in <code>TrainingArguments</code> to either <code>&quot;steps&quot;</code> (evaluate every <code>eval_steps</code>) or <code>&quot;epoch&quot;</code> (evaluate at the end of each epoch).</li> <li>We didn’t provide the <code>Trainer</code> with a <code>compute_metrics()</code> function to calculate a metric during said evaluation (otherwise the evaluation would just have printed the loss, which is not a very intuitive number).</li>",ut,D,mt,K,Mn="Let’s see how we can build a useful <code>compute_metrics()</code> function and use it the next time we train. The function must take an <code>EvalPrediction</code> object (which is a named tuple with a <code>predictions</code> field and a <code>label_ids</code> field) and will return a dictionary mapping strings to floats (the strings being the names of the metrics returned, and the floats their values). To get some predictions from our model, we can use the <code>Trainer.predict()</code> command:",ht,O,ft,ee,gt,te,yn="The output of the <code>predict()</code> method is another named tuple with three fields: <code>predictions</code>, <code>label_ids</code>, and <code>metrics</code>. The <code>metrics</code> field will just contain the loss on the dataset passed, as well as some time metrics (how long it took to predict, in total and on average). Once we complete our <code>compute_metrics()</code> function and pass it to the <code>Trainer</code>, that field will also contain the metrics returned by <code>compute_metrics()</code>.",$t,ne,Tn='As you can see, <code>predictions</code> is a two-dimensional array with shape 408 x 2 (408 being the number of elements in the dataset we used). Those are the logits for each element of the dataset we passed to <code>predict()</code> (as you saw in the <a href="/course/chapter2">previous chapter</a>, all Transformer models return logits). To transform them into predictions that we can compare to our labels, we need to take the index with the maximum value on the second axis:',wt,ae,Mt,ie,bn='We can now compare those <code>preds</code> to the labels. To build our <code>compute_metric()</code> function, we will rely on the metrics from the 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> library. We can load the metrics associated with the MRPC dataset as easily as we loaded the dataset, this time with the <code>evaluate.load()</code> function. The object returned has a <code>compute()</code> method we can use to do the metric calculation:',yt,se,Tt,le,bt,k,vt,re,vn='The exact results you get may vary, as the random initialization of the model head might change the metrics it achieved. Here, we can see our model has an accuracy of 85.78% on the validation set and an F1 score of 89.97. Those are the two metrics used to evaluate results on the MRPC dataset for the GLUE benchmark. The table in the <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT paper</a> reported an F1 score of 88.9 for the base model. That was the <code>uncased</code> model while we are currently using the <code>cased</code> model, which explains the better result.',Jt,oe,Jn="Wrapping everything together, we get our <code>compute_metrics()</code> function:",jt,pe,_t,ce,jn="And to see it used in action to report metrics at the end of each epoch, here is how we define a new <code>Trainer</code> with this <code>compute_metrics()</code> function:",Ut,de,kt,ue,_n="Note that we create a new <code>TrainingArguments</code> with its <code>eval_strategy</code> set to <code>&quot;epoch&quot;</code> and a new model — otherwise, we would just be continuing the training of the model we have already trained. To launch a new training run, we execute:",Ct,me,xt,he,Un="This time, it will report the validation loss and metrics at the end of each epoch on top of the training loss. Again, the exact accuracy/F1 score you reach might be a bit different from what we found, because of the random head initialization of the model, but it should be in the same ballpark.",Wt,fe,Ht,ge,kn="The <code>Trainer</code> comes with many built-in features that make modern deep learning best practices accessible:",Rt,$e,Cn="<strong>Mixed Precision Training</strong>: Use <code>fp16=True</code> in your training arguments for faster training and reduced memory usage:",Zt,we,Gt,Me,xn="<strong>Gradient Accumulation</strong>: For effective larger batch sizes when GPU memory is limited:",It,ye,zt,Te,Wn="<strong>Learning Rate Scheduling</strong>: The Trainer uses linear decay by default, but you can customize this:",Xt,be,Ft,C,Yt,ve,Hn="The <code>Trainer</code> will work out of the box on multiple GPUs or TPUs and provides lots of options for distributed training. We will go over everything it supports in Chapter 10.",Et,Je,Rn='This concludes the introduction to fine-tuning using the <code>Trainer</code> API. An example of doing this for most common NLP tasks will be given in <a href="/course/chapter7">Chapter 7</a>, but for now let’s look at how to do the same thing with a pure PyTorch training loop.',Qt,x,At,je,Bt,_e,Zn="Test your understanding of the Trainer API and fine-tuning concepts:",Vt,Ue,qt,ke,Lt,Ce,Nt,xe,Pt,We,St,He,Dt,Re,Kt,Ze,Ot,Ge,en,Ie,tn,ze,nn,Xe,an,W,sn,Fe,ln,Ae,rn;return b=new On({props:{fw:M[0]}}),v=new J({props:{title:"Fine-tuning a model with the Trainer API",local:"fine-tuning-a-model-with-the-trainer-api",headingTag:"h1"}}),H=new Kn({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"}]}}),R=new Dn({props:{id:"nvBXf7s7vTI"}}),j=new Ye({props:{$$slots:{default:[ta]},$$scope:{ctx:M}}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),z=new J({props:{title:"Training",local:"training",headingTag:"h3"}}),F=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),_=new Ye({props:{$$slots:{default:[na]},$$scope:{ctx:M}}}),Q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),V=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=tokenizer,
)`,wrap:!1}}),U=new Ye({props:{$$slots:{default:[aa]},$$scope:{ctx:M}}}),N=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),D=new J({props:{title:"Evaluation",local:"evaluation",headingTag:"h3"}}),O=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),ee=new y({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),ae=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),se=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),le=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),k=new Ye({props:{$$slots:{default:[ia]},$$scope:{ctx:M}}}),pe=new y({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),de=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),me=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),fe=new J({props:{title:"Advanced Training Features",local:"advanced-training-features",headingTag:"h3"}}),we=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTIwJTIwJTIzJTIwRW5hYmxlJTIwbWl4ZWQlMjBwcmVjaXNpb24lMEEp",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    fp16=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable mixed precision</span>
)`,wrap:!1}}),ye=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwJTIwJTIzJTIwRWZmZWN0aXZlJTIwYmF0Y2glMjBzaXplJTIwJTNEJTIwNCUyMColMjA0JTIwJTNEJTIwMTYlMEEp",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Effective batch size = 4 * 4 = 16</span>
)`,wrap:!1}}),be=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QyZS01JTJDJTBBJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyX3R5cGUlM0QlMjJjb3NpbmUlMjIlMkMlMjAlMjAlMjMlMjBUcnklMjBkaWZmZXJlbnQlMjBzY2hlZHVsZXJzJTBBKQ==",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,  <span class="hljs-comment"># Try different schedulers</span>
)`,wrap:!1}}),C=new Ye({props:{$$slots:{default:[sa]},$$scope:{ctx:M}}}),x=new Ye({props:{$$slots:{default:[la]},$$scope:{ctx:M}}}),je=new J({props:{title:"Section Quiz",local:"section-quiz",headingTag:"h2"}}),Ue=new J({props:{title:"1. What is the purpose of the <code> processing_class </code> parameter in the Trainer?",local:"1-what-is-the-purpose-of-the-code-processingclass-code-parameter-in-the-trainer",headingTag:"h3"}}),ke=new Qe({props:{choices:[{text:"It specifies which model architecture to use.",explain:"Model architecture is specified when loading the model, not in the Trainer."},{text:"It tells the Trainer which tokenizer to use for processing data.",explain:"The processing_class parameter is a modern addition that helps the Trainer know which tokenizer to use.",correct:!0},{text:"It determines the batch size for training.",explain:"Batch size is set in TrainingArguments, not through processing_class."},{text:"It controls the evaluation frequency.",explain:"Evaluation frequency is controlled by eval_strategy in TrainingArguments."}]}}),Ce=new J({props:{title:"2. Which TrainingArguments parameter controls how often evaluation occurs during training?",local:"2-which-trainingarguments-parameter-controls-how-often-evaluation-occurs-during-training",headingTag:"h3"}}),xe=new Qe({props:{choices:[{text:"eval_frequency",explain:"There's no eval_frequency parameter in TrainingArguments."},{text:"eval_strategy",explain:"eval_strategy can be set to 'epoch', 'steps', or 'no' to control evaluation timing.",correct:!0},{text:"evaluation_steps",explain:"eval_steps sets the number of steps between evaluations, but eval_strategy determines if/when evaluation happens."},{text:"do_eval",explain:"There's no do_eval parameter in modern TrainingArguments."}]}}),We=new J({props:{title:"3. What does <code> fp16=True </code> in TrainingArguments enable?",local:"3-what-does-code-fp16true-code-in-trainingarguments-enable",headingTag:"h3"}}),He=new Qe({props:{choices:[{text:"16-bit integer precision for faster training.",explain:"fp16 refers to floating-point precision, not integer precision."},{text:"Mixed precision training with 16-bit floating-point numbers for faster training and reduced memory usage.",explain:"Mixed precision training uses 16-bit floats for forward pass and 32-bit for gradients, improving speed and reducing memory usage.",correct:!0},{text:"Training for exactly 16 epochs.",explain:"fp16 has nothing to do with the number of epochs."},{text:"Using 16 GPUs for distributed training.",explain:"The number of GPUs is not controlled by the fp16 parameter."}]}}),Re=new J({props:{title:"4. What is the role of the <code> compute_metrics </code> function in the Trainer?",local:"4-what-is-the-role-of-the-code-computemetrics-code-function-in-the-trainer",headingTag:"h3"}}),Ze=new Qe({props:{choices:[{text:"It calculates the loss during training.",explain:"Loss calculation is handled automatically by the model, not by compute_metrics."},{text:"It converts logits to predictions and calculates evaluation metrics like accuracy and F1.",explain:"compute_metrics takes predictions and labels, then returns metrics for evaluation.",correct:!0},{text:"It determines which optimizer to use.",explain:"Optimizer selection is not handled by compute_metrics."},{text:"It preprocesses the training data.",explain:"Data preprocessing is done before training, not by compute_metrics during evaluation."}]}}),Ge=new J({props:{title:"5. What happens when you don’t provide an <code> eval_dataset </code> to the Trainer?",local:"5-what-happens-when-you-dont-provide-an-code-evaldataset-code-to-the-trainer",headingTag:"h3"}}),Ie=new Qe({props:{choices:[{text:"Training will fail with an error.",explain:"Training can proceed without an eval_dataset, though you won't get evaluation metrics."},{text:"The Trainer will automatically split the training data for evaluation.",explain:"The Trainer doesn't automatically create validation splits."},{text:"You won't get evaluation metrics during training, but training will still work.",explain:"Evaluation is optional - you can train without it, but you won't see validation metrics.",correct:!0},{text:"The model will use the training data for evaluation.",explain:"The Trainer won't automatically use training data for evaluation - it simply won't evaluate."}]}}),ze=new J({props:{title:"6. What is gradient accumulation and how do you enable it?",local:"6-what-is-gradient-accumulation-and-how-do-you-enable-it",headingTag:"h3"}}),Xe=new Qe({props:{choices:[{text:"It saves gradients to disk, enabled with save_gradients=True.",explain:"Gradient accumulation doesn't involve saving gradients to disk."},{text:"It accumulates gradients over multiple batches before updating, enabled with gradient_accumulation_steps.",explain:"This allows you to simulate larger batch sizes by accumulating gradients over multiple forward passes.",correct:!0},{text:"It speeds up gradient computation, enabled automatically with fp16.",explain:"While fp16 can speed up training, gradient accumulation is a separate technique."},{text:"It prevents gradient overflow, enabled with gradient_clipping=True.",explain:"That describes gradient clipping, not gradient accumulation."}]}}),W=new Ye({props:{$$slots:{default:[ra]},$$scope:{ctx:M}}}),Fe=new ea({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter3/3.mdx"}}),{c(){l=h("meta"),$=i(),r=h("p"),w=i(),o(b.$$.fragment),T=i(),o(v.$$.fragment),Be=i(),o(H.$$.fragment),Ve=i(),o(R.$$.fragment),qe=i(),Z=h("p"),Z.innerHTML=on,Le=i(),o(j.$$.fragment),Ne=i(),G=h("p"),G.textContent=pn,Pe=i(),o(I.$$.fragment),Se=i(),o(z.$$.fragment),De=i(),X=h("p"),X.innerHTML=cn,Ke=i(),o(F.$$.fragment),Oe=i(),Y=h("p"),Y.innerHTML=dn,et=i(),o(_.$$.fragment),tt=i(),E=h("p"),E.innerHTML=un,nt=i(),o(Q.$$.fragment),at=i(),A=h("p"),A.innerHTML=mn,it=i(),B=h("p"),B.innerHTML=hn,st=i(),o(V.$$.fragment),lt=i(),q=h("p"),q.innerHTML=fn,rt=i(),o(U.$$.fragment),ot=i(),L=h("p"),L.innerHTML=gn,pt=i(),o(N.$$.fragment),ct=i(),P=h("p"),P.textContent=$n,dt=i(),S=h("ol"),S.innerHTML=wn,ut=i(),o(D.$$.fragment),mt=i(),K=h("p"),K.innerHTML=Mn,ht=i(),o(O.$$.fragment),ft=i(),o(ee.$$.fragment),gt=i(),te=h("p"),te.innerHTML=yn,$t=i(),ne=h("p"),ne.innerHTML=Tn,wt=i(),o(ae.$$.fragment),Mt=i(),ie=h("p"),ie.innerHTML=bn,yt=i(),o(se.$$.fragment),Tt=i(),o(le.$$.fragment),bt=i(),o(k.$$.fragment),vt=i(),re=h("p"),re.innerHTML=vn,Jt=i(),oe=h("p"),oe.innerHTML=Jn,jt=i(),o(pe.$$.fragment),_t=i(),ce=h("p"),ce.innerHTML=jn,Ut=i(),o(de.$$.fragment),kt=i(),ue=h("p"),ue.innerHTML=_n,Ct=i(),o(me.$$.fragment),xt=i(),he=h("p"),he.textContent=Un,Wt=i(),o(fe.$$.fragment),Ht=i(),ge=h("p"),ge.innerHTML=kn,Rt=i(),$e=h("p"),$e.innerHTML=Cn,Zt=i(),o(we.$$.fragment),Gt=i(),Me=h("p"),Me.innerHTML=xn,It=i(),o(ye.$$.fragment),zt=i(),Te=h("p"),Te.innerHTML=Wn,Xt=i(),o(be.$$.fragment),Ft=i(),o(C.$$.fragment),Yt=i(),ve=h("p"),ve.innerHTML=Hn,Et=i(),Je=h("p"),Je.innerHTML=Rn,Qt=i(),o(x.$$.fragment),At=i(),o(je.$$.fragment),Bt=i(),_e=h("p"),_e.textContent=Zn,Vt=i(),o(Ue.$$.fragment),qt=i(),o(ke.$$.fragment),Lt=i(),o(Ce.$$.fragment),Nt=i(),o(xe.$$.fragment),Pt=i(),o(We.$$.fragment),St=i(),o(He.$$.fragment),Dt=i(),o(Re.$$.fragment),Kt=i(),o(Ze.$$.fragment),Ot=i(),o(Ge.$$.fragment),en=i(),o(Ie.$$.fragment),tn=i(),o(ze.$$.fragment),nn=i(),o(Xe.$$.fragment),an=i(),o(W.$$.fragment),sn=i(),o(Fe.$$.fragment),ln=i(),Ae=h("p"),this.h()},l(e){const t=Pn("svelte-u9bgzb",document.head);l=f(t,"META",{name:!0,content:!0}),t.forEach(n),$=s(e),r=f(e,"P",{}),An(r).forEach(n),w=s(e),p(b.$$.fragment,e),T=s(e),p(v.$$.fragment,e),Be=s(e),p(H.$$.fragment,e),Ve=s(e),p(R.$$.fragment,e),qe=s(e),Z=f(e,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-u2oltp"&&(Z.innerHTML=on),Le=s(e),p(j.$$.fragment,e),Ne=s(e),G=f(e,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1r8y7hl"&&(G.textContent=pn),Pe=s(e),p(I.$$.fragment,e),Se=s(e),p(z.$$.fragment,e),De=s(e),X=f(e,"P",{"data-svelte-h":!0}),g(X)!=="svelte-bcd3tt"&&(X.innerHTML=cn),Ke=s(e),p(F.$$.fragment,e),Oe=s(e),Y=f(e,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-ttdfe5"&&(Y.innerHTML=dn),et=s(e),p(_.$$.fragment,e),tt=s(e),E=f(e,"P",{"data-svelte-h":!0}),g(E)!=="svelte-14s2mi5"&&(E.innerHTML=un),nt=s(e),p(Q.$$.fragment,e),at=s(e),A=f(e,"P",{"data-svelte-h":!0}),g(A)!=="svelte-1q6lkxd"&&(A.innerHTML=mn),it=s(e),B=f(e,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1qyk6v2"&&(B.innerHTML=hn),st=s(e),p(V.$$.fragment,e),lt=s(e),q=f(e,"P",{"data-svelte-h":!0}),g(q)!=="svelte-10qhbiy"&&(q.innerHTML=fn),rt=s(e),p(U.$$.fragment,e),ot=s(e),L=f(e,"P",{"data-svelte-h":!0}),g(L)!=="svelte-2dkplj"&&(L.innerHTML=gn),pt=s(e),p(N.$$.fragment,e),ct=s(e),P=f(e,"P",{"data-svelte-h":!0}),g(P)!=="svelte-1u04gyz"&&(P.textContent=$n),dt=s(e),S=f(e,"OL",{"data-svelte-h":!0}),g(S)!=="svelte-18ht4gg"&&(S.innerHTML=wn),ut=s(e),p(D.$$.fragment,e),mt=s(e),K=f(e,"P",{"data-svelte-h":!0}),g(K)!=="svelte-h6pdaj"&&(K.innerHTML=Mn),ht=s(e),p(O.$$.fragment,e),ft=s(e),p(ee.$$.fragment,e),gt=s(e),te=f(e,"P",{"data-svelte-h":!0}),g(te)!=="svelte-1jbqb9m"&&(te.innerHTML=yn),$t=s(e),ne=f(e,"P",{"data-svelte-h":!0}),g(ne)!=="svelte-w5buv0"&&(ne.innerHTML=Tn),wt=s(e),p(ae.$$.fragment,e),Mt=s(e),ie=f(e,"P",{"data-svelte-h":!0}),g(ie)!=="svelte-1xta58a"&&(ie.innerHTML=bn),yt=s(e),p(se.$$.fragment,e),Tt=s(e),p(le.$$.fragment,e),bt=s(e),p(k.$$.fragment,e),vt=s(e),re=f(e,"P",{"data-svelte-h":!0}),g(re)!=="svelte-59ywn7"&&(re.innerHTML=vn),Jt=s(e),oe=f(e,"P",{"data-svelte-h":!0}),g(oe)!=="svelte-1ti0nhg"&&(oe.innerHTML=Jn),jt=s(e),p(pe.$$.fragment,e),_t=s(e),ce=f(e,"P",{"data-svelte-h":!0}),g(ce)!=="svelte-yza6x"&&(ce.innerHTML=jn),Ut=s(e),p(de.$$.fragment,e),kt=s(e),ue=f(e,"P",{"data-svelte-h":!0}),g(ue)!=="svelte-pb8m1o"&&(ue.innerHTML=_n),Ct=s(e),p(me.$$.fragment,e),xt=s(e),he=f(e,"P",{"data-svelte-h":!0}),g(he)!=="svelte-18ebo35"&&(he.textContent=Un),Wt=s(e),p(fe.$$.fragment,e),Ht=s(e),ge=f(e,"P",{"data-svelte-h":!0}),g(ge)!=="svelte-90oj6s"&&(ge.innerHTML=kn),Rt=s(e),$e=f(e,"P",{"data-svelte-h":!0}),g($e)!=="svelte-11y4jet"&&($e.innerHTML=Cn),Zt=s(e),p(we.$$.fragment,e),Gt=s(e),Me=f(e,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-1c925vq"&&(Me.innerHTML=xn),It=s(e),p(ye.$$.fragment,e),zt=s(e),Te=f(e,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-1fryuer"&&(Te.innerHTML=Wn),Xt=s(e),p(be.$$.fragment,e),Ft=s(e),p(C.$$.fragment,e),Yt=s(e),ve=f(e,"P",{"data-svelte-h":!0}),g(ve)!=="svelte-kdn0bx"&&(ve.innerHTML=Hn),Et=s(e),Je=f(e,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-1vddj28"&&(Je.innerHTML=Rn),Qt=s(e),p(x.$$.fragment,e),At=s(e),p(je.$$.fragment,e),Bt=s(e),_e=f(e,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-kgoru6"&&(_e.textContent=Zn),Vt=s(e),p(Ue.$$.fragment,e),qt=s(e),p(ke.$$.fragment,e),Lt=s(e),p(Ce.$$.fragment,e),Nt=s(e),p(xe.$$.fragment,e),Pt=s(e),p(We.$$.fragment,e),St=s(e),p(He.$$.fragment,e),Dt=s(e),p(Re.$$.fragment,e),Kt=s(e),p(Ze.$$.fragment,e),Ot=s(e),p(Ge.$$.fragment,e),en=s(e),p(Ie.$$.fragment,e),tn=s(e),p(ze.$$.fragment,e),nn=s(e),p(Xe.$$.fragment,e),an=s(e),p(W.$$.fragment,e),sn=s(e),p(Fe.$$.fragment,e),ln=s(e),Ae=f(e,"P",{}),An(Ae).forEach(n),this.h()},h(){Bn(l,"name","hf:doc:metadata"),Bn(l,"content",pa)},m(e,t){Sn(document.head,l),a(e,$,t),a(e,r,t),a(e,w,t),c(b,e,t),a(e,T,t),c(v,e,t),a(e,Be,t),c(H,e,t),a(e,Ve,t),c(R,e,t),a(e,qe,t),a(e,Z,t),a(e,Le,t),c(j,e,t),a(e,Ne,t),a(e,G,t),a(e,Pe,t),c(I,e,t),a(e,Se,t),c(z,e,t),a(e,De,t),a(e,X,t),a(e,Ke,t),c(F,e,t),a(e,Oe,t),a(e,Y,t),a(e,et,t),c(_,e,t),a(e,tt,t),a(e,E,t),a(e,nt,t),c(Q,e,t),a(e,at,t),a(e,A,t),a(e,it,t),a(e,B,t),a(e,st,t),c(V,e,t),a(e,lt,t),a(e,q,t),a(e,rt,t),c(U,e,t),a(e,ot,t),a(e,L,t),a(e,pt,t),c(N,e,t),a(e,ct,t),a(e,P,t),a(e,dt,t),a(e,S,t),a(e,ut,t),c(D,e,t),a(e,mt,t),a(e,K,t),a(e,ht,t),c(O,e,t),a(e,ft,t),c(ee,e,t),a(e,gt,t),a(e,te,t),a(e,$t,t),a(e,ne,t),a(e,wt,t),c(ae,e,t),a(e,Mt,t),a(e,ie,t),a(e,yt,t),c(se,e,t),a(e,Tt,t),c(le,e,t),a(e,bt,t),c(k,e,t),a(e,vt,t),a(e,re,t),a(e,Jt,t),a(e,oe,t),a(e,jt,t),c(pe,e,t),a(e,_t,t),a(e,ce,t),a(e,Ut,t),c(de,e,t),a(e,kt,t),a(e,ue,t),a(e,Ct,t),c(me,e,t),a(e,xt,t),a(e,he,t),a(e,Wt,t),c(fe,e,t),a(e,Ht,t),a(e,ge,t),a(e,Rt,t),a(e,$e,t),a(e,Zt,t),c(we,e,t),a(e,Gt,t),a(e,Me,t),a(e,It,t),c(ye,e,t),a(e,zt,t),a(e,Te,t),a(e,Xt,t),c(be,e,t),a(e,Ft,t),c(C,e,t),a(e,Yt,t),a(e,ve,t),a(e,Et,t),a(e,Je,t),a(e,Qt,t),c(x,e,t),a(e,At,t),c(je,e,t),a(e,Bt,t),a(e,_e,t),a(e,Vt,t),c(Ue,e,t),a(e,qt,t),c(ke,e,t),a(e,Lt,t),c(Ce,e,t),a(e,Nt,t),c(xe,e,t),a(e,Pt,t),c(We,e,t),a(e,St,t),c(He,e,t),a(e,Dt,t),c(Re,e,t),a(e,Kt,t),c(Ze,e,t),a(e,Ot,t),c(Ge,e,t),a(e,en,t),c(Ie,e,t),a(e,tn,t),c(ze,e,t),a(e,nn,t),c(Xe,e,t),a(e,an,t),c(W,e,t),a(e,sn,t),c(Fe,e,t),a(e,ln,t),a(e,Ae,t),rn=!0},p(e,[t]){const Gn={};t&1&&(Gn.fw=e[0]),b.$set(Gn);const In={};t&2&&(In.$$scope={dirty:t,ctx:e}),j.$set(In);const zn={};t&2&&(zn.$$scope={dirty:t,ctx:e}),_.$set(zn);const Xn={};t&2&&(Xn.$$scope={dirty:t,ctx:e}),U.$set(Xn);const Fn={};t&2&&(Fn.$$scope={dirty:t,ctx:e}),k.$set(Fn);const Yn={};t&2&&(Yn.$$scope={dirty:t,ctx:e}),C.$set(Yn);const En={};t&2&&(En.$$scope={dirty:t,ctx:e}),x.$set(En);const Qn={};t&2&&(Qn.$$scope={dirty:t,ctx:e}),W.$set(Qn)},i(e){rn||(d(b.$$.fragment,e),d(v.$$.fragment,e),d(H.$$.fragment,e),d(R.$$.fragment,e),d(j.$$.fragment,e),d(I.$$.fragment,e),d(z.$$.fragment,e),d(F.$$.fragment,e),d(_.$$.fragment,e),d(Q.$$.fragment,e),d(V.$$.fragment,e),d(U.$$.fragment,e),d(N.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(k.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(fe.$$.fragment,e),d(we.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),d(ke.$$.fragment,e),d(Ce.$$.fragment,e),d(xe.$$.fragment,e),d(We.$$.fragment,e),d(He.$$.fragment,e),d(Re.$$.fragment,e),d(Ze.$$.fragment,e),d(Ge.$$.fragment,e),d(Ie.$$.fragment,e),d(ze.$$.fragment,e),d(Xe.$$.fragment,e),d(W.$$.fragment,e),d(Fe.$$.fragment,e),rn=!0)},o(e){u(b.$$.fragment,e),u(v.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(j.$$.fragment,e),u(I.$$.fragment,e),u(z.$$.fragment,e),u(F.$$.fragment,e),u(_.$$.fragment,e),u(Q.$$.fragment,e),u(V.$$.fragment,e),u(U.$$.fragment,e),u(N.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(k.$$.fragment,e),u(pe.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(we.$$.fragment,e),u(ye.$$.fragment,e),u(be.$$.fragment,e),u(C.$$.fragment,e),u(x.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(Ce.$$.fragment,e),u(xe.$$.fragment,e),u(We.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u(Ie.$$.fragment,e),u(ze.$$.fragment,e),u(Xe.$$.fragment,e),u(W.$$.fragment,e),u(Fe.$$.fragment,e),rn=!1},d(e){e&&(n($),n(r),n(w),n(T),n(Be),n(Ve),n(qe),n(Z),n(Le),n(Ne),n(G),n(Pe),n(Se),n(De),n(X),n(Ke),n(Oe),n(Y),n(et),n(tt),n(E),n(nt),n(at),n(A),n(it),n(B),n(st),n(lt),n(q),n(rt),n(ot),n(L),n(pt),n(ct),n(P),n(dt),n(S),n(ut),n(mt),n(K),n(ht),n(ft),n(gt),n(te),n($t),n(ne),n(wt),n(Mt),n(ie),n(yt),n(Tt),n(bt),n(vt),n(re),n(Jt),n(oe),n(jt),n(_t),n(ce),n(Ut),n(kt),n(ue),n(Ct),n(xt),n(he),n(Wt),n(Ht),n(ge),n(Rt),n($e),n(Zt),n(Gt),n(Me),n(It),n(zt),n(Te),n(Xt),n(Ft),n(Yt),n(ve),n(Et),n(Je),n(Qt),n(At),n(Bt),n(_e),n(Vt),n(qt),n(Lt),n(Nt),n(Pt),n(St),n(Dt),n(Kt),n(Ot),n(en),n(tn),n(nn),n(an),n(sn),n(ln),n(Ae)),n(l),m(b,e),m(v,e),m(H,e),m(R,e),m(j,e),m(I,e),m(z,e),m(F,e),m(_,e),m(Q,e),m(V,e),m(U,e),m(N,e),m(D,e),m(O,e),m(ee,e),m(ae,e),m(se,e),m(le,e),m(k,e),m(pe,e),m(de,e),m(me,e),m(fe,e),m(we,e),m(ye,e),m(be,e),m(C,e),m(x,e),m(je,e),m(Ue,e),m(ke,e),m(Ce,e),m(xe,e),m(We,e),m(He,e),m(Re,e),m(Ze,e),m(Ge,e),m(Ie,e),m(ze,e),m(Xe,e),m(W,e),m(Fe,e)}}}const pa='{"title":"Fine-tuning a model with the Trainer API","local":"fine-tuning-a-model-with-the-trainer-api","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Evaluation","local":"evaluation","sections":[],"depth":3},{"title":"Advanced Training Features","local":"advanced-training-features","sections":[],"depth":3},{"title":"Section Quiz","local":"section-quiz","sections":[{"title":"1. What is the purpose of the <code> processing_class </code> parameter in the Trainer?","local":"1-what-is-the-purpose-of-the-code-processingclass-code-parameter-in-the-trainer","sections":[],"depth":3},{"title":"2. Which TrainingArguments parameter controls how often evaluation occurs during training?","local":"2-which-trainingarguments-parameter-controls-how-often-evaluation-occurs-during-training","sections":[],"depth":3},{"title":"3. What does <code> fp16=True </code> in TrainingArguments enable?","local":"3-what-does-code-fp16true-code-in-trainingarguments-enable","sections":[],"depth":3},{"title":"4. What is the role of the <code> compute_metrics </code> function in the Trainer?","local":"4-what-is-the-role-of-the-code-computemetrics-code-function-in-the-trainer","sections":[],"depth":3},{"title":"5. What happens when you don’t provide an <code> eval_dataset </code> to the Trainer?","local":"5-what-happens-when-you-dont-provide-an-code-evaldataset-code-to-the-trainer","sections":[],"depth":3},{"title":"6. What is gradient accumulation and how do you enable it?","local":"6-what-is-gradient-accumulation-and-how-do-you-enable-it","sections":[],"depth":3}],"depth":2}],"depth":1}';function ca(M,l,$){let r="pt";return qn(()=>{const w=new URLSearchParams(window.location.search);$(0,r=w.get("fw")||"pt")}),[r]}class ya extends Ln{constructor(l){super(),Nn(this,l,ca,oa,Vn,{})}}export{ya as component};
