import{s as Vl,o as Nl}from"../chunks/scheduler.cd324960.js";import{S as Yl,i as El,e as M,s as a,c as m,h as Ql,a as p,d as e,b as n,f as Hl,g as r,j as i,k as rl,l as ql,m as s,n as j,t as y,o as u,p as o,q as Fl,r as Sl}from"../chunks/index.b5b48820.js";import{T as Ll}from"../chunks/Tip.c8436081.js";import{C as Dl,H as ml,E as Pl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9c246ae6.js";import{C as J}from"../chunks/CodeBlock.f5b9cb98.js";function Ol(ut){let c;return{c(){c=Fl("💡 리샘플링에 대한 배경 정보: 만약 오디오 신호가 8 kHz로 샘플링 되었다면(즉, 초당 8000개의 샘플이 있다면) 4 kHz보다 높은 주파수는 없음을 알 수 있습니다. 나이퀴스트 샘플링 정리(Nyquist sampling theorem)에 의해서 말이죠. 이 덕분에 우린 샘플링 지점들간의 원래의 연속적인 신호는 항상 부드러운 커브임을 확신할 수 있는 것입니다. 더 높은 샘플링 속도로의 업샘플링은 이 커브를 근사하여 기존 점들 사이의 값을 찾아내면 됩니다. 그러나 다운샘플링 같은 경우, 새로운 샘플을 결정하기전에 새로운 나이퀴스트 한계보다 높은 주파수를 먼저 걸러내는 작업이 필요할 겁니다. 다시 말해, 2배의 다운샘플링 같은 경우 이에 맞춰 단순히 샘플들을 버리는 것으로는 왜곡이 생길 수 있습니다. 이 왜곡을 alias라고 합니다. 이렇듯 리샘플링을 올바르게 하기란 꽤 까다로우므로 librosa나 🤗 Datasets같은 잘 테스트된 라이브러리를 쓰는편이 낫습니다.")},l(T){c=Sl(T,"💡 리샘플링에 대한 배경 정보: 만약 오디오 신호가 8 kHz로 샘플링 되었다면(즉, 초당 8000개의 샘플이 있다면) 4 kHz보다 높은 주파수는 없음을 알 수 있습니다. 나이퀴스트 샘플링 정리(Nyquist sampling theorem)에 의해서 말이죠. 이 덕분에 우린 샘플링 지점들간의 원래의 연속적인 신호는 항상 부드러운 커브임을 확신할 수 있는 것입니다. 더 높은 샘플링 속도로의 업샘플링은 이 커브를 근사하여 기존 점들 사이의 값을 찾아내면 됩니다. 그러나 다운샘플링 같은 경우, 새로운 샘플을 결정하기전에 새로운 나이퀴스트 한계보다 높은 주파수를 먼저 걸러내는 작업이 필요할 겁니다. 다시 말해, 2배의 다운샘플링 같은 경우 이에 맞춰 단순히 샘플들을 버리는 것으로는 왜곡이 생길 수 있습니다. 이 왜곡을 alias라고 합니다. 이렇듯 리샘플링을 올바르게 하기란 꽤 까다로우므로 librosa나 🤗 Datasets같은 잘 테스트된 라이브러리를 쓰는편이 낫습니다.")},m(T,d){s(T,c,d)},d(T){T&&e(c)}}}function Kl(ut){let c,T,d,ot,w,ct,h,Jt,C,jl="🤗 Datasets을 이용하여 데이터셋을 불러오는건 재미의 반에 불과합니다. 모델을 학습시키거나 추론(inference)을 실행하기 위해선 먼저 데이터를 전처리해야할 것입니다. 일반적으로 이는 다음의 단계를 거칩니다:",Tt,I,yl="<li>오디오 데이터 리샘플링</li> <li>데이터셋 필터링</li> <li>오디오 데이터를 모델의 입력에 맞게 변환</li>",Ut,A,ft,$,ul="<code>load_dataset</code> 함수는 오디오 데이터를 게시된(published) 샘플링 속도에 맞춰 다운로드합니다. 이 샘플링 속도는 여러분이 계획한 학습 혹은 추론을 위한 샘플링 속도가 아닐 수 있습니다. 이렇게 샘플링 속도간 불일치가 있다면, 모델이 기대하는 샘플링 속도에 맞춰 리샘플링을 할 수 있습니다.",dt,b,ol=`대부분의 사전 학습된 모델들은 16 kHz의 샘플링 속도를 가진 오디오 데이터셋에 대하여 사전학습이 이뤄져있습니다.
여러분이 MINDS-14 데이터셋을 살펴보신다면 8 kHz로 샘플링된것을 알 수 있을겁니다. 업샘플링이 필요하다는 뜻이죠.`,wt,x,cl="이를 위해, 🤗 Datasets의 <code>cast_column</code> 메소드를 써봅시다. 이 연산은 오디오를 in-place로 변경하는 것이 아니라 오디오 데이터들이 불러와질때 즉석에서 리샘플링되도록 데이터셋에 신호를 보냅니다. 다음의 코드는 샘플링 속도를 16 kHz로 설정합니다:",ht,_,Ct,B,Jl="MINDS-14 데이터셋의 첫번째 오디오 예제를 다시 불러와 원하는 <code>sampling_rate</code>으로 리샘플링 되었는지 확인해 보겠습니다:",It,g,At,k,Tl="<strong>Output:</strong>",$t,Z,bt,v,Ul="여러분은 아마 배열의 값들 역시 달라졌음을 눈치채셨을 겁니다. 이는 기존에 비해 진폭값들의 갯수가 전부 두배로 늘어났기 때문입니다.",xt,U,_t,R,Bt,G,fl="여러분은 데이터를 어떤 기준에 맞춰 필터링해야할 때도 있을겁니다. 흔한 경우로는 오디오 데이터를 특정 길이에 맞춰 제한하는 경우가 있을 수 있습니다. 예를 들어, 모델 학습시 out-of-memory 에러를 피하기 위해 20초 보다 긴 모든 데이터를 필터링하길 원할 수도 있습니다.",gt,W,dl="🤗 Datasets의 <code>filter</code> 메소드에 필터링 로직을 짠 함수를 집어넣어 쓴다면 이를 수행할 수 있습니다. 한번 어떤 데이터를 쓸지 또는 버릴지를 알려주는 함수를 작성해 이를 써봅시다. 함수 <code>is_audio_length_in_range</code>는 만약 샘플이 20초보다 짧다면 <code>True</code>를 그렇지 않다면 <code>False</code>를 반환합니다.",kt,X,Zt,z,wl="필터링 함수는 데이터셋의 컬럼에 적용될 수 있지만 이 데이터셋엔 오디오 트랙 길이가 없습니다. 그러나 우린 새로 이런 컬럼을 만들 수 있으니 새로 만든 후 이 컬럼의 값에 필터를 적용하고 최종적으로는 다시 지워봅시다.",vt,H,Rt,V,hl="<strong>Output:</strong>",Gt,N,Wt,Y,Cl="데이터셋의 숫자가 654개에서 624개로 감소한것을 확인하실 수 있습니다.",Xt,E,zt,Q,Il="오디오 데이터셋을 준비할 때 가장 어려운점 중 하나는 모델 학습에 맞는 형식을 갖추는 것입니다. 여러분이 앞서 보셧듯, 원시 오디오 데이터는 샘플값들의 배열로 제공됩니다. 그러나, 사전 학습된 모델같은 경우(이를 추론을 위해 쓰든 파인튜닝을 위해 쓰든) 이런 원시 데이터를 입력 feature에 맞춰야합니다. 이런 입력 feature의 요구사항은 모델마다 다를 수 있습니다. 이는 모델의 구조와 어떤 데이터로 사전학습이 이뤄졌는지에 달려있습니다. 좋은 소식은 🤗 Transformers는 지원하는 모든 모델에 대해 원시 데이터를 모델이 원하는 입력 feature로 바꿔주는 feature extractor 클래스를 제공한다는 것입니다.",Ht,q,Al='이 feature extractor는 그럼 원시 데이터로 무엇을 하는 걸까요? 일반적인 feature extraction 변환을 이해하기 위해 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper</a>의 feature extractor를 살펴보겠습니다. Whisper는 자동 음성 인식(ASR)을 위해 사전 학습된 모델로 2022년 9월에 OpenAI의 Alec Radford와 공동 연구자들이 발표했습니다.',Vt,F,$l=`첫번째로, Whisper의 feature extractor는 모든 데이터가 30초의 길이를 갖도록 덧붙이거나(pad) 자릅니다(truncate). 30초 보다 짧은 데이터는 시퀀스의 끝에 0을 붙여 길이를 늘립니다(오디오 신호에서 0은 신호 없음 혹은 무음과 같습니다). 30초 보다 긴 데이터는 30초가 되도록 자릅니다.
배치의 모든 요소가 input space의 최대 길이에 맞춰 덧붙여지거나 잘렸으므로 별도의 attention mask는 필요 없습니다. 이런 점에서 Whisper는 특별한데, 대부분의 다른 오디오 모델들은 self-attention 메커니즘에서 어느 부분을 무시해야하는지를 알려주기 위해 시퀀스의 어디가 덧붙여졌는지 알려주는 attention mask가 필요하기 때문입니다. Whisper는 attention mask 없이 작동하도록 훈련되어 음성 신호에서 직접 입력의 어느 부분을 무시해야 하는지를 추론합니다.`,Nt,S,bl="Whisper feature extractor가 수행하는 두번째 작업은 덧붙여진 오디오 배열들을 로그-멜 스펙트로그램으로 바꾸는 것입니다. 아시다시피, 이 스펙트로그램은 신호의 주파수가 시간에 따라 어떻게 변하는지를 멜 스케일에 맞춰 데시벨(로그 부분)로 측정하여 주파수와 진폭이 사람의 청각 시스템을 더 잘 표현하도록 합니다.",Yt,L,xl="이 모든 변환은 몇 줄의 코드로 여러분의 원시 데이터에 적용될 수 있습니다. 사전 학습된 Whisper의 체크포인트에서 feature extractor를 불러와 오디오 데이터에 사용할 준비를 해봅시다:",Et,D,Qt,P,_l="다음으로, <code>feature_extractor</code>를 통해 각각의 오디오 데이터를 전처리할 함수를 작성할 수 있습니다.",qt,O,Ft,K,Bl="🤗 Datasets의 <code>map</code> 메소드를 이용하여 모든 학습 데이터에 적용시킬 수 있습니다:",St,tt,Lt,lt,gl="<strong>Output:</strong>",Dt,et,Pt,st,kl="이렇게 간단히, 로그-멜 스펙트로그램을 데이터셋의 <code>input_features</code>에 저장할 수 있습니다.",Ot,at,Zl="<code>minds</code> 데이터셋 중 하나를 시각화해봅시다:",Kt,nt,tl,f,vl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',ll,Mt,Rl="이제 전처리 후 Whisper 모델에 대한 오디오 입력이 어떻게 보이는지 확인하실 수 있습니다.",el,pt,Gl='모델의 feature extractor 클래스는 원시 데이터를 모델이 원하는 포맷으로 변경하는 작업을 처리합니다. 그러나, 대개의 오디오 작업은(예를 들어, 음성 인식) multimodal입니다. 이런 경우 🤗 Transformers는 텍스트 입력을 처리하기 위해 모델별 토크나이저(tokenizer)를 제공합니다. 토크나이저에 대해 더 자세히 알고 싶으시다면 <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">NLP 코스</a>를 참고하세요.',sl,it,Wl="Whisper와 다른 multimodal 모델에 대해 각각의 feature extractor와 토크나이저를 별도로 불러오거나, 이른바 processor를 통해 한번에 불러올 수도 있습니다. 더 간단히 다음의 코드처럼 <code>AutoProcessor</code>로 체크포인트에서 모델의 feature extractor와 processor를 불러올 수도 있습니다:",al,mt,nl,rt,Xl=`여기에서는 기본적인 데이터 준비 단계를 설명했습니다. 물론 커스텀 데이터는 더 복잡한 전처리가 필요할 수도 있습니다.
이 경우, 여러분은 어떤 종류의 커스텀 데이터도 변환이 가능하도록 <code>prepare_dataset</code> 함수를 확장할 수 있습니다. 🤗 Datasets과 함께라면, 여러분은 파이썬 함수로 작성 할 수만 있다면 여러분의 데이터에 이를 적용시킬 수 있을겁니다!`,Ml,jt,pl,yt,il;return w=new Dl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new ml({props:{title:"오디오 데이터셋 전처리하기",local:"preprocessing-an-audio-dataset",headingTag:"h1"}}),A=new ml({props:{title:"오디오 데이터 리샘플링하기",local:"resampling-the-audio-data",headingTag:"h2"}}),_=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),g=new J({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),Z=new J({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`,wrap:!1}}),U=new Ll({props:{$$slots:{default:[Ol]},$$scope:{ctx:ut}}}),R=new ml({props:{title:"데이터셋 필터링하기",local:"filtering-the-dataset",headingTag:"h2"}}),X=new J({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),H=new J({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHRvJTIwZ2V0JTIwZXhhbXBsZSdzJTIwZHVyYXRpb24lMjBmcm9tJTIwdGhlJTIwYXVkaW8lMjBmaWxlJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKGZpbGVuYW1lJTNEeCklMjBmb3IlMjB4JTIwaW4lMjBtaW5kcyU1QiUyMnBhdGglMjIlNUQlNUQlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmFkZF9jb2x1bW4oJTIyZHVyYXRpb24lMjIlMkMlMjBuZXdfY29sdW1uKSUwQSUwQSUyMyUyMHVzZSUyMCVGMCU5RiVBNCU5NyUyMERhdGFzZXRzJyUyMCU2MGZpbHRlciU2MCUyMG1ldGhvZCUyMHRvJTIwYXBwbHklMjB0aGUlMjBmaWx0ZXJpbmclMjBmdW5jdGlvbiUwQW1pbmRzJTIwJTNEJTIwbWluZHMuZmlsdGVyKGlzX2F1ZGlvX2xlbmd0aF9pbl9yYW5nZSUyQyUyMGlucHV0X2NvbHVtbnMlM0QlNUIlMjJkdXJhdGlvbiUyMiU1RCklMEElMEElMjMlMjByZW1vdmUlMjB0aGUlMjB0ZW1wb3JhcnklMjBoZWxwZXIlMjBjb2x1bW4lMEFtaW5kcyUyMCUzRCUyMG1pbmRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQW1pbmRz",highlighted:`<span class="hljs-comment"># use librosa to get example&#x27;s duration from the audio file</span>
new_column = [librosa.get_duration(filename=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use 🤗 Datasets&#x27; \`filter\` method to apply the filtering function</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remove the temporary helper column</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),N=new J({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),E=new ml({props:{title:"오디오 데이터 전처리하기",local:"pre-processing-audio-data",headingTag:"h2"}}),D=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),O=new J({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),tt=new J({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),et=new J({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),nt=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),mt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),jt=new Pl({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ko/chapter1/preprocessing.mdx"}}),{c(){c=M("meta"),T=a(),d=M("p"),ot=a(),m(w.$$.fragment),ct=a(),m(h.$$.fragment),Jt=a(),C=M("p"),C.textContent=jl,Tt=a(),I=M("ul"),I.innerHTML=yl,Ut=a(),m(A.$$.fragment),ft=a(),$=M("p"),$.innerHTML=ul,dt=a(),b=M("p"),b.textContent=ol,wt=a(),x=M("p"),x.innerHTML=cl,ht=a(),m(_.$$.fragment),Ct=a(),B=M("p"),B.innerHTML=Jl,It=a(),m(g.$$.fragment),At=a(),k=M("p"),k.innerHTML=Tl,$t=a(),m(Z.$$.fragment),bt=a(),v=M("p"),v.textContent=Ul,xt=a(),m(U.$$.fragment),_t=a(),m(R.$$.fragment),Bt=a(),G=M("p"),G.textContent=fl,gt=a(),W=M("p"),W.innerHTML=dl,kt=a(),m(X.$$.fragment),Zt=a(),z=M("p"),z.textContent=wl,vt=a(),m(H.$$.fragment),Rt=a(),V=M("p"),V.innerHTML=hl,Gt=a(),m(N.$$.fragment),Wt=a(),Y=M("p"),Y.textContent=Cl,Xt=a(),m(E.$$.fragment),zt=a(),Q=M("p"),Q.textContent=Il,Ht=a(),q=M("p"),q.innerHTML=Al,Vt=a(),F=M("p"),F.textContent=$l,Nt=a(),S=M("p"),S.textContent=bl,Yt=a(),L=M("p"),L.textContent=xl,Et=a(),m(D.$$.fragment),Qt=a(),P=M("p"),P.innerHTML=_l,qt=a(),m(O.$$.fragment),Ft=a(),K=M("p"),K.innerHTML=Bl,St=a(),m(tt.$$.fragment),Lt=a(),lt=M("p"),lt.innerHTML=gl,Dt=a(),m(et.$$.fragment),Pt=a(),st=M("p"),st.innerHTML=kl,Ot=a(),at=M("p"),at.innerHTML=Zl,Kt=a(),m(nt.$$.fragment),tl=a(),f=M("div"),f.innerHTML=vl,ll=a(),Mt=M("p"),Mt.textContent=Rl,el=a(),pt=M("p"),pt.innerHTML=Gl,sl=a(),it=M("p"),it.innerHTML=Wl,al=a(),m(mt.$$.fragment),nl=a(),rt=M("p"),rt.innerHTML=Xl,Ml=a(),m(jt.$$.fragment),pl=a(),yt=M("p"),this.h()},l(t){const l=Ql("svelte-u9bgzb",document.head);c=p(l,"META",{name:!0,content:!0}),l.forEach(e),T=n(t),d=p(t,"P",{}),Hl(d).forEach(e),ot=n(t),r(w.$$.fragment,t),ct=n(t),r(h.$$.fragment,t),Jt=n(t),C=p(t,"P",{"data-svelte-h":!0}),i(C)!=="svelte-ya88xm"&&(C.textContent=jl),Tt=n(t),I=p(t,"UL",{"data-svelte-h":!0}),i(I)!=="svelte-olz9v0"&&(I.innerHTML=yl),Ut=n(t),r(A.$$.fragment,t),ft=n(t),$=p(t,"P",{"data-svelte-h":!0}),i($)!=="svelte-zodz6y"&&($.innerHTML=ul),dt=n(t),b=p(t,"P",{"data-svelte-h":!0}),i(b)!=="svelte-11vzx2x"&&(b.textContent=ol),wt=n(t),x=p(t,"P",{"data-svelte-h":!0}),i(x)!=="svelte-10xsk1v"&&(x.innerHTML=cl),ht=n(t),r(_.$$.fragment,t),Ct=n(t),B=p(t,"P",{"data-svelte-h":!0}),i(B)!=="svelte-g9ssah"&&(B.innerHTML=Jl),It=n(t),r(g.$$.fragment,t),At=n(t),k=p(t,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1mvdyro"&&(k.innerHTML=Tl),$t=n(t),r(Z.$$.fragment,t),bt=n(t),v=p(t,"P",{"data-svelte-h":!0}),i(v)!=="svelte-d80rar"&&(v.textContent=Ul),xt=n(t),r(U.$$.fragment,t),_t=n(t),r(R.$$.fragment,t),Bt=n(t),G=p(t,"P",{"data-svelte-h":!0}),i(G)!=="svelte-13lalkv"&&(G.textContent=fl),gt=n(t),W=p(t,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1b59bty"&&(W.innerHTML=dl),kt=n(t),r(X.$$.fragment,t),Zt=n(t),z=p(t,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1sl3hyy"&&(z.textContent=wl),vt=n(t),r(H.$$.fragment,t),Rt=n(t),V=p(t,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1mvdyro"&&(V.innerHTML=hl),Gt=n(t),r(N.$$.fragment,t),Wt=n(t),Y=p(t,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1h3nix2"&&(Y.textContent=Cl),Xt=n(t),r(E.$$.fragment,t),zt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1n8hncz"&&(Q.textContent=Il),Ht=n(t),q=p(t,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1eslxg3"&&(q.innerHTML=Al),Vt=n(t),F=p(t,"P",{"data-svelte-h":!0}),i(F)!=="svelte-19412bd"&&(F.textContent=$l),Nt=n(t),S=p(t,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1lpqin1"&&(S.textContent=bl),Yt=n(t),L=p(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1pdcnlk"&&(L.textContent=xl),Et=n(t),r(D.$$.fragment,t),Qt=n(t),P=p(t,"P",{"data-svelte-h":!0}),i(P)!=="svelte-snr1i6"&&(P.innerHTML=_l),qt=n(t),r(O.$$.fragment,t),Ft=n(t),K=p(t,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1y4bo99"&&(K.innerHTML=Bl),St=n(t),r(tt.$$.fragment,t),Lt=n(t),lt=p(t,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-1mvdyro"&&(lt.innerHTML=gl),Dt=n(t),r(et.$$.fragment,t),Pt=n(t),st=p(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1qmv2tx"&&(st.innerHTML=kl),Ot=n(t),at=p(t,"P",{"data-svelte-h":!0}),i(at)!=="svelte-d4dgla"&&(at.innerHTML=Zl),Kt=n(t),r(nt.$$.fragment,t),tl=n(t),f=p(t,"DIV",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-csckl"&&(f.innerHTML=vl),ll=n(t),Mt=p(t,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-538kx9"&&(Mt.textContent=Rl),el=n(t),pt=p(t,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-15c8axx"&&(pt.innerHTML=Gl),sl=n(t),it=p(t,"P",{"data-svelte-h":!0}),i(it)!=="svelte-15pli7h"&&(it.innerHTML=Wl),al=n(t),r(mt.$$.fragment,t),nl=n(t),rt=p(t,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-1t0u2ng"&&(rt.innerHTML=Xl),Ml=n(t),r(jt.$$.fragment,t),pl=n(t),yt=p(t,"P",{}),Hl(yt).forEach(e),this.h()},h(){rl(c,"name","hf:doc:metadata"),rl(c,"content",te),rl(f,"class","flex justify-center")},m(t,l){ql(document.head,c),s(t,T,l),s(t,d,l),s(t,ot,l),j(w,t,l),s(t,ct,l),j(h,t,l),s(t,Jt,l),s(t,C,l),s(t,Tt,l),s(t,I,l),s(t,Ut,l),j(A,t,l),s(t,ft,l),s(t,$,l),s(t,dt,l),s(t,b,l),s(t,wt,l),s(t,x,l),s(t,ht,l),j(_,t,l),s(t,Ct,l),s(t,B,l),s(t,It,l),j(g,t,l),s(t,At,l),s(t,k,l),s(t,$t,l),j(Z,t,l),s(t,bt,l),s(t,v,l),s(t,xt,l),j(U,t,l),s(t,_t,l),j(R,t,l),s(t,Bt,l),s(t,G,l),s(t,gt,l),s(t,W,l),s(t,kt,l),j(X,t,l),s(t,Zt,l),s(t,z,l),s(t,vt,l),j(H,t,l),s(t,Rt,l),s(t,V,l),s(t,Gt,l),j(N,t,l),s(t,Wt,l),s(t,Y,l),s(t,Xt,l),j(E,t,l),s(t,zt,l),s(t,Q,l),s(t,Ht,l),s(t,q,l),s(t,Vt,l),s(t,F,l),s(t,Nt,l),s(t,S,l),s(t,Yt,l),s(t,L,l),s(t,Et,l),j(D,t,l),s(t,Qt,l),s(t,P,l),s(t,qt,l),j(O,t,l),s(t,Ft,l),s(t,K,l),s(t,St,l),j(tt,t,l),s(t,Lt,l),s(t,lt,l),s(t,Dt,l),j(et,t,l),s(t,Pt,l),s(t,st,l),s(t,Ot,l),s(t,at,l),s(t,Kt,l),j(nt,t,l),s(t,tl,l),s(t,f,l),s(t,ll,l),s(t,Mt,l),s(t,el,l),s(t,pt,l),s(t,sl,l),s(t,it,l),s(t,al,l),j(mt,t,l),s(t,nl,l),s(t,rt,l),s(t,Ml,l),j(jt,t,l),s(t,pl,l),s(t,yt,l),il=!0},p(t,[l]){const zl={};l&2&&(zl.$$scope={dirty:l,ctx:t}),U.$set(zl)},i(t){il||(y(w.$$.fragment,t),y(h.$$.fragment,t),y(A.$$.fragment,t),y(_.$$.fragment,t),y(g.$$.fragment,t),y(Z.$$.fragment,t),y(U.$$.fragment,t),y(R.$$.fragment,t),y(X.$$.fragment,t),y(H.$$.fragment,t),y(N.$$.fragment,t),y(E.$$.fragment,t),y(D.$$.fragment,t),y(O.$$.fragment,t),y(tt.$$.fragment,t),y(et.$$.fragment,t),y(nt.$$.fragment,t),y(mt.$$.fragment,t),y(jt.$$.fragment,t),il=!0)},o(t){u(w.$$.fragment,t),u(h.$$.fragment,t),u(A.$$.fragment,t),u(_.$$.fragment,t),u(g.$$.fragment,t),u(Z.$$.fragment,t),u(U.$$.fragment,t),u(R.$$.fragment,t),u(X.$$.fragment,t),u(H.$$.fragment,t),u(N.$$.fragment,t),u(E.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(et.$$.fragment,t),u(nt.$$.fragment,t),u(mt.$$.fragment,t),u(jt.$$.fragment,t),il=!1},d(t){t&&(e(T),e(d),e(ot),e(ct),e(Jt),e(C),e(Tt),e(I),e(Ut),e(ft),e($),e(dt),e(b),e(wt),e(x),e(ht),e(Ct),e(B),e(It),e(At),e(k),e($t),e(bt),e(v),e(xt),e(_t),e(Bt),e(G),e(gt),e(W),e(kt),e(Zt),e(z),e(vt),e(Rt),e(V),e(Gt),e(Wt),e(Y),e(Xt),e(zt),e(Q),e(Ht),e(q),e(Vt),e(F),e(Nt),e(S),e(Yt),e(L),e(Et),e(Qt),e(P),e(qt),e(Ft),e(K),e(St),e(Lt),e(lt),e(Dt),e(Pt),e(st),e(Ot),e(at),e(Kt),e(tl),e(f),e(ll),e(Mt),e(el),e(pt),e(sl),e(it),e(al),e(nl),e(rt),e(Ml),e(pl),e(yt)),e(c),o(w,t),o(h,t),o(A,t),o(_,t),o(g,t),o(Z,t),o(U,t),o(R,t),o(X,t),o(H,t),o(N,t),o(E,t),o(D,t),o(O,t),o(tt,t),o(et,t),o(nt,t),o(mt,t),o(jt,t)}}}const te='{"title":"오디오 데이터셋 전처리하기","local":"preprocessing-an-audio-dataset","sections":[{"title":"오디오 데이터 리샘플링하기","local":"resampling-the-audio-data","sections":[],"depth":2},{"title":"데이터셋 필터링하기","local":"filtering-the-dataset","sections":[],"depth":2},{"title":"오디오 데이터 전처리하기","local":"pre-processing-audio-data","sections":[],"depth":2}],"depth":1}';function le(ut){return Nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pe extends Yl{constructor(c){super(),El(this,c,le,Kl,Vl,{})}}export{pe as component};
