# Exercice pratique

Dans cette unité, nous avons consolidé le matériel couvert dans les six unités précédentes du cours pour créer trois applications audio. Comme vous l'avez constaté, il est tout à fait possible de créer des outils audio plus complexes en utilisant les compétences fondamentales que vous avez acquises dans ce cours.

L'exercice pratique prend l'une des applications couvertes dans cette unité, et l'étend avec quelques modifications multilingues 🌍 Votre objectif est de prendre la [démo Gradio de traduction vocale en deux étapes](https://huggingface.co/spaces/course-demos/speech-to-speech-translation) de la première section de cette unité, et de la mettre à jour pour la traduire dans n'importe quelle langue **non-anglaise**. En d'autres termes, la démo doit prendre un discours dans une langue X, et le traduire en un discours dans une langue Y, où la langue cible Y n'est pas l'anglais. Vous devriez commencer par [dupliquer](https://huggingface.co/spaces/course-demos/speech-to-speech-translation?duplicate=true) le modèle sous votre espace Hugging Face. Il n'est pas néce

Des conseils pour mettre à jour la fonction de traduction vocale afin d'effectuer une traduction vocale multilingue sont fournis dans la section sur la [traduction parole-parole](speech-to-speech). En suivant ces instructions, vous devriez être en mesure de mettre à jour la démo pour traduire de la parole dans la langue X vers du texte dans la langue Y, ce qui représente la moitié de la tâche !

Pour synthétiser du texte dans la langue Y vers la parole dans la langue Y, où Y est une langue multilingue, vous devrez utiliser un *checkpoint* TTS multilingue. Pour cela, vous pouvez utiliser soit celui de SpeechT5 TTS que vous avez *finetuné* dans l'exercice pratique précédent, soit un un *checkpoint* TTS multilingue pré-entraîné. Il y a alors deux options pour ce dernier cas : soit le *checkpoint* [sanchit-gandhi/speecht5_tts_vox_nl](https://huggingface.co/sanchit-gandhi/speecht5_tts_vox_nl), qui est un SpeechT5 *finetuné* sur la partie néerlandaise de [VoxPopuli](https://huggingface.co/datasets/facebook/voxpopuli), soit un *checkpoint* MMS TTS (voir la section [modèles pretrainés pour TTS](../chapter6/pre-trained_models)).

<Tip>
D'après notre expérience avec le néerlandais, l'utilisation d'un *checkpoint* MMS TTS permet d'obtenir de meilleures performances qu'un *checkpoint* SpeechT5 *finetuné* mais il se peut que votre *checkpoint* TTS *fientuné* soit préférable dans votre langue.
</Tip>


Votre démo doit prendre en entrée un fichier audio, et retourner en sortie un autre fichier audio, correspondant à la signature de la fonction [`speech_to_speech_translation`](https://huggingface.co/spaces/course-demos/speech-to-speech-translation/blob/3946ba6705a6632a63de8672ac52a482ab74b3fc/app.py#L35). Par conséquent, nous vous recommandons de laisser la fonction principale `speech_to_speech_translation` telle quelle, et de ne mettre à jour les fonctions [`translate`](https://huggingface.co/spaces/course-demos/speech-to-speech-translation/blob/a03175878f522df7445290d5508bfb5c5178f787/app.py#L24) et [`synthesise`](https://huggingface.co/spaces/course-demos/speech-to-speech-translation/blob/a03175878f522df7445290d5508bfb5c5178f787/app.py#L29) que si nécessaire.

Une fois que vous avez construit votre démo sur le *Hub*, vous pouvez la soumettre pour évaluation. Rendez-vous dans le *Space* [audio-course-u7-assessment](https://huggingface.co/spaces/huggingface-course/audio-course-u7-assessment) et indiquez l'identifiant de dépôt de votre démo. Ce *Space* vérifiera que votre démo a été construite correctement en envoyant un échantillon de fichier audio à votre démo et en vérifiant que le fichier audio renvoyé n'est pas en anglais. Si votre démo fonctionne correctement, vous obtiendrez une coche verte à côté de votre nom sur le [*Space* de progression](https://huggingface.co/spaces/MariaK/Check-my-progress-Audio-Course) ✅

<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter7/hands-on.mdx" />