# Bienvenue dans le cours d'audio d'Hugging Face !

Cher apprenant, bienvenue dans ce cours sur l'utilisation des *transformers* pour l'audio, À maintes reprises, les *transformers* se sont révélés être l'une des architectures d'apprentissage profond les plus puissantes et les plus polyvalentes, capables d'obtenir des résultats de pointe dans un large éventail de tâches, y compris le traitement du langage naturel, la vision par ordinateur et, plus récemment, le traitement audio.

Dans ce cours, nous allons explorer comment ces modèles peuvent être appliqués à une série de tâches et de données audio. Que vous soyez intéressé par la reconnaissance vocale, la classification audio ou la synthèse vocale, les *transformers* et ce cours vous le permettront.

Pour vous donner un avant-goût de ce que ces modèles peuvent faire, prononcez quelques mots dans la démo ci-dessous et regardez le modèle les transcrire en temps réel !
 
<iframe
	src="https://openai-whisper.hf.space"
	frameborder="0"
	width="850"
	height="450">
</iframe>

Tout au long du cours, vous comprendrez les spécificités du travail avec des données audio, vous découvrirez différentes architectures de *transformers*, et *finetunerez* vos propres modèles audio en tirant parti de puissants modèles pré-entraînés.

Ce cours est conçu pour les personnes ayant des connaissances en apprentissage profond et une connaissance générale des *transformers*.
Aucune expertise en traitement de données audio n'est requise. Si vous avez besoin de rafraîchir vos connaissances sur les *transformers*, consultez notre [cours de NLP](https://huggingface.co/course/fr/chapter1/1) qui aborde en détail les principes de base de cette architecture.

## Rencontrer l'équipe du cours

**Sanchit Gandhi, ingénieur de recherche en apprentissage automatique chez Hugging Face**

Bonjour, je m'appelle Sanchit et je suis ingénieur de recherche en apprentissage automatique pour l'audio dans l'équipe *open-source* de Hugging Face 🤗.
Je me concentre principalement sur la reconnaissance automatique de la parole et la traduction, avec l'objectif actuel de rendre les modèles de parole plus rapides, plus légers et plus faciles à utiliser.

**Matthijs Hollemans, ingénieur en apprentissage automatique chez Hugging Face**.

Je m'appelle Matthijs et je suis ingénieur en apprentissage automatique en audio dans l'équipe *open source* de Hugging Face. Je suis également l'auteur d'un livre sur l'écriture de sons de synthétiseurs, et je crée des *plugins* audio pendant mon temps libre.

**Maria Khalusova, Documentation et cours chez Hugging Face**.

Je m'appelle Maria et je crée du contenu éducatif et de la documentation pour rendre *Transformers* et d'autres outils *open-source* encore plus accessibles. Je décompose des concepts techniques complexes et j'aide les gens à démarrer avec des technologies de pointe.

**Vaibhav Srivastav, ingénieur *advocate* et développeur en apprentissage automatique chez Hugging Face**.

Je m'appelle Vaibhav (VB) et je suis ingénieur *advocate* en audio au sein de l'équipe *open source* de Hugging Face. Je fais des recherches sur la synthèse vocale sur els lagnues à faibles ressources et j'aide à mettre l'état de l'art de la recherche sur la parole à la portée du plus grand nombre.

## Structure du cours

Le cours est structuré en plusieurs unités qui couvrent différents sujets en profondeur :

* Unité 1 : apprendre les spécificités du travail avec des données audio, y compris les techniques de traitement audio et la préparation des données.
* Unité 2 : connaître les applications audio et apprendre comment utiliser les pipelines de 🤗 *Transformers* pour différentes tâches, telles que la classification audio et la reconnaissance vocale.
* Unité 3 : explorer les architectures de *transformers* audio, apprendre comment ils diffèrent, et quelles sont les tâches pour lesquelles ils sont les mieux adaptés.
* Unité 4 : Apprenez à construire votre propre classifieur de genre musical.
* Unité 5 : approfondissement de la reconnaissance vocale
* Unité 6 : apprendre à générer de la parole à partir d'un texte.
* Unité 7 : apprendre à construire des applications audio réelles (traducteur parole-à-parole, assistant vocal et transcription de réunions).

Chaque unité comprend un volet théorique qui vous permettra d'acquérir une compréhension approfondie des concepts et des techniques sous-jacents. Tout au long du cours, des quiz vous permettent de tester vos connaissances et de renforcer votre apprentissage.
Certains chapitres comprennent également des exercices pratiques qui vous permettront d'appliquer ce que vous avez appris.

À la fin du cours, vous aurez acquis de solides bases dans l'utilisation des *transformers* pour les données audio et serez bien équipé pour appliquer ces techniques à un large éventail de tâches.

## Parcours d'apprentissage

Il n'y a pas de bonne ou de mauvaise façon de suivre ce cours. Tout le matériel contenu dans ce cours est 100% gratuit, public et *open-source*.
Vous pouvez le suivre à votre propre rythme, mais nous vous recommandons de suivre les unités dans l'ordre.

Bon cours !


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter0/introduction.mdx" />