import{s as ca,o as da,n as Ja}from"../chunks/scheduler.a045fce0.js";import{S as ya,i as Ta,e as p,s as n,c as u,h as wa,a as r,d as l,b as a,f as ma,g as M,j as i,k as en,l as ja,m as t,n as o,t as m,o as c,p as d}from"../chunks/index.5135b896.js";import{T as Ua}from"../chunks/Tip.872c1b89.js";import{C as fa,H as w,E as ha}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.addd93af.js";import{C as J}from"../chunks/CodeBlock.b49b7225.js";function ba(zs){let y,h="Dans notre exemple, nous utiliserons environ 40 heures de données d’entraînement. Si vous souhaitez suivre en utilisant la version gratuite de Google Colab, vous devrez réduire la quantité de données d’entraînement à environ 10-15 heures, ainsi que réduire le nombre d’étapes d’entraînement.";return{c(){y=p("p"),y.textContent=h},l(T){y=r(T,"P",{"data-svelte-h":!0}),i(y)!=="svelte-6yku8n"&&(y.textContent=h)},m(T,Gs){t(T,y,Gs)},p:Ja,d(T){T&&l(y)}}}function Ia(zs){let y,h,T,Gs,b,Xs,I,Ns,C,sn="Maintenant que vous êtes familiarisé avec la tâche de synthèse vocale et le fonctionnement interne du SpeechT5 qui a été entraîné sur des données en langue anglaise, voyons comment nous pouvons le <em>finetuner</em> à une autre langue.",Ys,$,Qs,Z,ln="Assurez-vous de disposer d’un GPU si vous souhaitez reproduire cet exemple. Dans un <em>notebook</em>, vous pouvez vérifier avec la commande suivante :",Rs,v,qs,j,As,g,tn="Vous aurez également besoin de quelques dépendances supplémentaires :",Es,x,Hs,k,nn="Enfin, n’oubliez pas de vous connecter à votre compte Hugging Face pour pouvoir télécharger et partager votre modèle avec la communauté :",Fs,V,Ss,B,Ls,W,an=`Pour cet exemple, nous prendrons le sous-ensemble en néerlandais (<code>nl</code>) du jeu de données <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a>.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> est un corpus de parole multilingue à grande échelle composé de données provenant d’enregistrements d’événements du Parlement européen de 2009 à 2020.
Il contient des données de transcription audio étiquetées pour 15 langues européennes. Nous utiliserons le sous-ensemble néerlandais, mais vous pouvez choisir un autre sous-ensemble.`,Ds,G,pn="Il s’agit d’un jeu de données de reconnaissance automatique de la parole, donc comme mentionné précédemment, ce n’est pas l’option la plus appropriée pour entraîner des modèles TTS. Cependant, il sera suffisant pour cet exercice.",Ps,_,rn="Chargeons les données :",Ks,z,Os,X,un="<strong>Sortie :</strong>",el,N,sl,Y,Mn="20968 exemples devraient suffire pour un <em>finetuning</em>. SpeechT5 s’attend à ce que les données audio aient une fréquence d’échantillonnage de 16 kHz, assurez-vous donc que les exemples du jeu de données répondent à cette exigence :",ll,Q,tl,R,nl,q,on="Commençons par définir le <em>checkpoint</em> du modèle à utiliser et par charger le processeur approprié qui contient à la fois le <em>tokenizer</em> et l’extracteur de caractéristiques dont nous aurons besoin pour préparer les données en vue de l’entraînement :",al,A,pl,E,rl,H,mn="Tout d’abord, pour préparer le texte, nous aurons besoin de la partie <em>tokenizer</em> du processeur, alors allons-y :",il,F,ul,S,cn="Prenons un exemple :",Ml,L,ol,D,dn="<strong>Sortie :</strong>",ml,P,cl,K,Jn="Vous remarquerez que les exemples du jeu de données contiennent les caractéristiques <code>raw_text</code> et <code>normalized_text</code>. Lorsque vous décidez quelle caractéristique utiliser comme entrée de texte, il est important de savoir que le <em>tokenizer</em> de SpeechT5 n’a pas de <em>tokens</em> pour les nombres. Dans <code>normalized_text</code>, les nombres sont écrits sous forme textuel. Il s’agit donc d’une meilleure option, et nous devrions utiliser <code>normalized_text</code> comme texte d’entrée.",dl,O,yn=`Comme SpeechT5 a été entraîné sur la langue anglaise, il se peut qu’il ne reconnaisse pas certains caractères dans le jeu de données néerlandais.
S’ils sont laissés tels quels, ces caractères seront convertis en tokens <code>&lt;unk&gt;</code>. Cependant, en néerlandais, certains caractères comme <code>à</code> sont utilisés pour souligner les syllabes. Afin de préserver le sens du texte, nous pouvons remplacer ce caractère par un <code>a</code> normal.`,Jl,ee,Tn=`Pour identifier les <em>tokens</em> non supportés, extrayez tous les caractères uniques du jeu de données en utilisant le <code>SpeechT5Tokenizer</code> qui fonctionne avec les caractères comme des <em>tokens</em>.
Pour ce faire, nous allons écrire la fonction <code>extract_all_chars</code> qui concatène les transcriptions de tous les exemples en une chaîne et la convertit en un ensemble de caractères.
Assurez-vous de mettre <code>batched=True</code> et <code>batch_size=-1</code> dans <code>dataset.map()</code> afin que toutes les transcriptions soient disponibles en même temps pour la fonction de <em>mapping</em>.`,yl,se,Tl,le,wn=`Vous disposez à présent de deux ensembles de caractères : l’un avec le vocabulaire du jeu de données et l’autre avec le vocabulaire du <em>tokenizer</em>.
Pour identifier les caractères non pris en charge dans le jeu de données, vous pouvez prendre la différence entre ces deux ensembles. L’ensemble résultant contiendra les caractères qui se trouvent dans le jeu de données mais pas dans le <em>tokenizer</em>.`,wl,te,jl,ne,jn="<strong>Sortie :</strong>",Ul,ae,fl,pe,Un="Pour gérer les caractères non supportés identifiés dans l’étape précédente, nous pouvons définir une fonction qui fait correspondre ces caractères à des <em>tokens</em> valides. Notez que les espaces sont déjà remplacés par <code>▁</code> dans le <em>tokenizer</em> et n’ont pas besoin d’être gérés séparément.",hl,re,bl,ie,fn="Maintenant que nous avons traité les caractères spéciaux dans le texte, il est temps de se concentrer sur les données audio.",Il,ue,Cl,Me,hn=`Le jeu de données VoxPopuli comprend la parole de plusieurs locuteurs, mais combien de locuteurs sont représentés dans le jeu de données ? Pour le savoir, nous pouvons compter le nombre de locuteurs uniques et le nombre d’exemples que chaque locuteur apporte au jeu de données.
Avec un total de 20 968 exemples dans le jeu de données, cette information nous permettra de mieux comprendre la distribution des locuteurs et des exemples dans les données.`,$l,oe,Zl,me,bn="En traçant un histogramme, vous pouvez vous faire une idée de la quantité de données pour chaque locuteur.",vl,ce,gl,U,In='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',xl,de,Cn="L’histogramme révèle qu’environ un tiers des locuteurs du jeu de données ont moins de 100 exemples, tandis qu’une dizaine de locuteurs ont plus de 500 exemples. Pour améliorer l’efficacité de l’entraînement et équilibrer le jeu de données, nous pouvons limiter les données aux locuteurs ayant entre 100 et 400 exemples.",kl,Je,Vl,ye,$n="Vérifions le nombre de locuteurs restants :",Bl,Te,Wl,we,Zn="<strong>Sortie :</strong>",Gl,je,_l,Ue,vn="Voyons combien d’exemples il reste :",zl,fe,Xl,he,gn="<strong>Sortie :</strong>",Nl,be,Yl,Ie,xn="Vous vous retrouvez avec un peu moins de 10 000 exemples provenant d’environ 40 locuteurs uniques, ce qui devrait être suffisant.",Ql,Ce,kn="Notez que certains locuteurs ayant peu d’exemples peuvent en fait avoir plus d’audio disponible si les exemples sont longs. Cependant, pour déterminer la quantité totale d’audio pour chaque locuteur, il faut parcourir l’ensemble des données, ce qui est un processus long qui implique le chargement et le décodage de chaque fichier audio. C’est pourquoi nous avons choisi de sauter cette étape.",Rl,$e,ql,Ze,Vn=`Pour permettre au modèle TTS de différencier plusieurs locuteurs, vous devrez créer un enchâssement de locuteur pour chaque exemple.
C’est est une entrée supplémentaire dans le modèle qui capture les caractéristiques de la voix d’un locuteur particulier.
Pour générer ces enchâssements, utilisez le modèle pré-entraîné <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a> de SpeechBrain.`,Al,ve,Bn="Créez une fonction <code>create_speaker_embedding()</code> qui prend une forme d’onde audio en entrée et produit un vecteur de 512 éléments contenant l’enchâssement du locuteur correspondant.",El,ge,Hl,xe,Wn="Il est important de noter que le modèle <code>speechbrain/spkrec-xvect-voxceleb</code> a été entraîné sur de l’anglais provenant du jeu de données VoxCeleb, alors que les exemples d’entraînement dans ce guide sont en néerlandais. Bien que nous pensions que ce modèle génèrerait toujours des enchâssements de locuteurs raisonnables pour notre jeu de données néerlandais, cette hypothèse peut ne pas être vraie dans tous les cas.",Fl,ke,Gn='Pour obtenir des résultats optimaux, nous devrions d’abord entraîner un modèle de vecteur X sur le discours cible. Ainsi, le modèle sera mieux à même de capturer les caractéristiques vocales uniques présentes dans la langue néerlandaise. Si vous souhaitez entraîner votre propre modèle X-vector, vous pouvez utiliser <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">ce script</a> comme exemple.',Sl,Ve,Ll,Be,_n=`Enfin, traitons les données dans le format attendu par le modèle. Créez une fonction <code>prepare_dataset</code> qui prend un seul exemple et utilise l’objet <code>SpeechT5Processor</code> pour tokeniser le texte d’entrée et charger l’audio cible dans un spectrogramme log-mel.
Elle devrait également ajouter les enchâssements de locuteur en tant qu’entrée supplémentaire.`,Dl,We,Pl,Ge,zn="Vérifiez que le traitement est correct en examinant un seul exemple :",Kl,_e,Ol,ze,Xn="<strong>Sortie :</strong>",et,Xe,st,Ne,Nn="Les enchâssements de locuteurs doivent être un vecteur de 512 éléments :",lt,Ye,tt,Qe,Yn="<strong>Sortie :</strong>",nt,Re,at,qe,Qn="Les étiquettes doivent être un spectrogramme log-mel avec 80 bins mel.",pt,Ae,rt,f,Rn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',it,Ee,qn=`Remarque : si vous trouvez ce spectrogramme déroutant, c’est peut-être parce que vous êtes familier avec la convention qui consiste à placer les basses fréquences en bas et les hautes fréquences en haut d’un graphique.
Cependant, lorsque l’on trace des spectrogrammes sous forme d’image à l’aide de la bibliothèque matplotlib, l’axe des ordonnées est inversé et les spectrogrammes apparaissent à l’envers.`,ut,He,An="Nous devons maintenant appliquer la fonction de traitement à l’ensemble du jeu de données. Cela prendra entre 5 et 10 minutes.",Mt,Fe,ot,Se,En=`Vous verrez un avertissement indiquant que certains exemples du jeu de données sont plus longs que la longueur d’entrée maximale que le modèle peut traiter (600 <em>tokens</em>).
Supprimez ces exemples du jeu de données. Ici, nous allons encore plus loin et, pour tenir compte de la taille des batchs, nous supprimons tout ce qui dépasse 200 <em>tokens</em>.`,mt,Le,ct,De,Hn="<strong>Sortie :</strong>",dt,Pe,Jt,Ke,Fn="Next, create a basic train/test split:",yt,Oe,Tt,es,wt,ss,Sn="Afin de combiner plusieurs exemples dans un batch, vous devez définir un assembleur de données personnalisé. Il remplacera les séquences les plus courtes par des <em>tokens</em> de rembourrage, afin de s’assurer que tous les exemples ont la même longueur. Pour les étiquettes des spectrogrammes, les parties rembourrées sont remplacées par la valeur spéciale <code>-100</code>. Cette valeur spéciale indique au modèle d’ignorer cette partie du spectrogramme lors du calcul de la perte de spectrogramme.",jt,ls,Ut,ts,Ln="Dans SpeechT5, l’entrée de la partie décodeur du modèle est réduite d’un facteur 2. En d’autres termes, il élimine un pas de temps sur deux de la séquence cible. Le décodeur prédit alors une séquence deux fois plus longue. Étant donné que la longueur de la séquence cible d’origine peut être impaire, l’assembleur de données veille à arrondir la longueur maximale du batch à un multiple de 2.",ft,ns,ht,as,bt,ps,Dn="Chargez le modèle pré-entraîné à partir du même <em>checkpoint</em> que celui utilisé pour le chargement du processeur :",It,rs,Ct,is,Pn="L’option <code>use_cache=True</code> est incompatible avec le <em>checkingpointing</em> du gradient. Désactivez-la pour l’entraînement, et réactivez le cache pour la génération afin d’accélérer le temps d’inférence :",$t,us,Zt,Ms,Kn="Définir les arguments d’entraînement. Ici, nous ne calculons aucune métrique d’évaluation pendant le processus d’entraînement, nous parlerons d’évaluation plus tard dans ce chapitre. Au lieu de cela, nous ne nous intéresserons qu’à la perte :",vt,os,gt,ms,On="Instancie l’objet <code>Trainer</code> et lui passe le modèle, le jeu de données et l’assembleur de données.",xt,cs,kt,ds,ea="Et voilà, nous sommes prêts à commencer l’entraînement ! Il prendra plusieurs heures. En fonction de votre GPU, il est possible que vous rencontriez une erreur CUDA “out-of-memory” lorsque vous commencez l’entraînement. Dans ce cas, vous pouvez réduire la taille de <code>per_device_train_batch_size</code> par incréments d’un facteur 2 et augmenter <code>gradient_accumulation_steps</code> par 2 pour compenser.",Vt,Js,Bt,ys,sa="Pousser le modèle final sur le <em>Hub</em> :",Wt,Ts,Gt,ws,_t,js,la="Une fois que vous avez <em>finetuné</em> un modèle, vous pouvez l’utiliser pour l’inférence ! Chargez le modèle à partir du <em>Hub</em> (assurez-vous d’utiliser votre nom de compte dans l’extrait de code suivant) :",zt,Us,Xt,fs,ta="Choisissez un exemple, ici nous en prendrons un du jeu de données de test. Obtenez un enchâssement du locuteur.",Nt,hs,Yt,bs,na="Définir un texte d’entrée et le <em>tokeniser</em>.",Qt,Is,Rt,Cs,aa="Prétraiter le texte d’entrée :",qt,$s,At,Zs,pa="Installez un vocodeur et générez de la parole :",Et,vs,Ht,gs,ra="On écoute le résultat ?",Ft,xs,St,ks,ia="Il peut être difficile d’obtenir des résultats satisfaisants avec ce modèle dans une nouvelle langue. La qualité de l’enchâssement du locuteur peut être un facteur important. Comme SpeechT5 a été entraîné avec des X-vectors anglais, il donne de meilleurs résultats lorsqu’il utilise des enchâssements de locuteurs anglais. Si la synthèse vocale semble médiocre, essayez d’utiliser un autre enchâssement de locuteur.",Lt,Vs,ua=`L’augmentation de la durée d’entraînement est également susceptible d’améliorer la qualité des résultats. Malgré cela, le discours est clairement néerlandais et non anglais, et il capture les caractéristiques vocales du locuteur (comparez avec l’audio original dans l’exemple).
Une autre chose à expérimenter est la configuration du modèle. Par exemple, essayez d’utiliser <code>config.reduction_factor = 1</code> pour voir si cela améliore les résultats.`,Dt,Bs,Ma="Dans la section suivante, nous verrons comment nous évaluons les modèles de synthèse vocale.",Pt,Ws,Kt,_s,Ot;return b=new fa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new w({props:{title:"Finetuning du SpeechT5",local:"finetuning-du-speecht5",headingTag:"h1"}}),$=new w({props:{title:"Préparation",local:"préparation",headingTag:"h2"}}),v=new J({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),j=new Ua({props:{warning:!0,$$slots:{default:[ba]},$$scope:{ctx:zs}}}),x=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),V=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),B=new w({props:{title:"Le jeu de données",local:"le-jeu-de-données",headingTag:"h2"}}),z=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),N=new J({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),Q=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),R=new w({props:{title:"Prétraitement des données",local:"prétraitement-des-données",headingTag:"h2"}}),A=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),E=new w({props:{title:"Nettoyage du texte pour la tokenisation de SpeechT5",local:"nettoyage-du-texte-pour-la-tokenisation-de-speecht5",headingTag:"h3"}}),F=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),L=new J({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),P=new J({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),se=new J({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),te=new J({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),ae=new J({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),re=new J({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),ue=new w({props:{title:"Les locuteurs",local:"les-locuteurs",headingTag:"h3"}}),oe=new J({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),ce=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),Je=new J({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),Te=new J({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),je=new J({props:{code:"NDI=",highlighted:"42",wrap:!1}}),fe=new J({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),be=new J({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),$e=new w({props:{title:"Enchâssement des locuteurs",local:"enchâssement-des-locuteurs",headingTag:"h3"}}),ge=new J({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),Ve=new w({props:{title:"Traitement du jeu de données",local:"traitement-du-jeu-de-données",headingTag:"h3"}}),We=new J({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),_e=new J({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Xe=new J({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),Ye=new J({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),Re=new J({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),Ae=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),Fe=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Le=new J({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Pe=new J({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Oe=new J({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),es=new w({props:{title:"Assembleur de données",local:"assembleur-de-données",headingTag:"h3"}}),ls=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># assembler les données d&#x27;entrée et les cibles dans un batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># remplacer le rembourrage par -100 pour ignorer correctement les pertes</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># non utilisé pendant le finetuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># arrondir les longueurs cibles au multiple du facteur de réduction</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># ajoutez également les enchâssements de locuteur</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ns=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),as=new w({props:{title:"Entraîner le modèle",local:"entraîner-le-modèle",headingTag:"h2"}}),rs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),us=new J({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkJUMzJUE5c2FjdGl2ZXIlMjBsZSUyMGNhY2hlJTIwcGVuZGFudCUyMGwnZW50cmElQzMlQUVuZW1lbnQlMjBjYXIlMjBpbCUyMGVzdCUyMGluY29tcGF0aWJsZSUyMGF2ZWMlMjBsZSUyMGNoZWNrcG9pbnRpbmclMjBkdSUyMGdyYWRpZW50JTBBbW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwZCVDMyVBOWZpbmlyJTIwbGElMjBsYW5ndWUlMjBldCUyMGxhJTIwdCVDMyVBMmNoZSUyMHBvdXIlMjBsYSUyMGclQzMlQTluJUMzJUE5cmF0aW9uJTIwZXQlMjByJUMzJUE5YWN0aXZlciUyMGxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># désactiver le cache pendant l&#x27;entraînement car il est incompatible avec le checkpointing du gradient</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># définir la langue et la tâche pour la génération et réactiver le cache</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),os=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2VyJTIwcG91ciUyMHVuJTIwbm9tJTIwZGUlMjBkJUMzJUE5cCVDMyVCNHQlMjBkZSUyMHZvdHJlJTIwY2hvaXglMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENDAwMCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># changer pour un nom de dépôt de votre choix</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),cs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),Js=new J({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),Ts=new J({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),ws=new w({props:{title:"Inférence",local:"inférence",headingTag:"h2"}}),Us=new J({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),hs=new J({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Is=new J({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),$s=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),vs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),xs=new J({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Ws=new ha({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter6/fine-tuning.mdx"}}),{c(){y=p("meta"),h=n(),T=p("p"),Gs=n(),u(b.$$.fragment),Xs=n(),u(I.$$.fragment),Ns=n(),C=p("p"),C.innerHTML=sn,Ys=n(),u($.$$.fragment),Qs=n(),Z=p("p"),Z.innerHTML=ln,Rs=n(),u(v.$$.fragment),qs=n(),u(j.$$.fragment),As=n(),g=p("p"),g.textContent=tn,Es=n(),u(x.$$.fragment),Hs=n(),k=p("p"),k.textContent=nn,Fs=n(),u(V.$$.fragment),Ss=n(),u(B.$$.fragment),Ls=n(),W=p("p"),W.innerHTML=an,Ds=n(),G=p("p"),G.textContent=pn,Ps=n(),_=p("p"),_.textContent=rn,Ks=n(),u(z.$$.fragment),Os=n(),X=p("p"),X.innerHTML=un,el=n(),u(N.$$.fragment),sl=n(),Y=p("p"),Y.innerHTML=Mn,ll=n(),u(Q.$$.fragment),tl=n(),u(R.$$.fragment),nl=n(),q=p("p"),q.innerHTML=on,al=n(),u(A.$$.fragment),pl=n(),u(E.$$.fragment),rl=n(),H=p("p"),H.innerHTML=mn,il=n(),u(F.$$.fragment),ul=n(),S=p("p"),S.textContent=cn,Ml=n(),u(L.$$.fragment),ol=n(),D=p("p"),D.innerHTML=dn,ml=n(),u(P.$$.fragment),cl=n(),K=p("p"),K.innerHTML=Jn,dl=n(),O=p("p"),O.innerHTML=yn,Jl=n(),ee=p("p"),ee.innerHTML=Tn,yl=n(),u(se.$$.fragment),Tl=n(),le=p("p"),le.innerHTML=wn,wl=n(),u(te.$$.fragment),jl=n(),ne=p("p"),ne.innerHTML=jn,Ul=n(),u(ae.$$.fragment),fl=n(),pe=p("p"),pe.innerHTML=Un,hl=n(),u(re.$$.fragment),bl=n(),ie=p("p"),ie.textContent=fn,Il=n(),u(ue.$$.fragment),Cl=n(),Me=p("p"),Me.textContent=hn,$l=n(),u(oe.$$.fragment),Zl=n(),me=p("p"),me.textContent=bn,vl=n(),u(ce.$$.fragment),gl=n(),U=p("div"),U.innerHTML=In,xl=n(),de=p("p"),de.textContent=Cn,kl=n(),u(Je.$$.fragment),Vl=n(),ye=p("p"),ye.textContent=$n,Bl=n(),u(Te.$$.fragment),Wl=n(),we=p("p"),we.innerHTML=Zn,Gl=n(),u(je.$$.fragment),_l=n(),Ue=p("p"),Ue.textContent=vn,zl=n(),u(fe.$$.fragment),Xl=n(),he=p("p"),he.innerHTML=gn,Nl=n(),u(be.$$.fragment),Yl=n(),Ie=p("p"),Ie.textContent=xn,Ql=n(),Ce=p("p"),Ce.textContent=kn,Rl=n(),u($e.$$.fragment),ql=n(),Ze=p("p"),Ze.innerHTML=Vn,Al=n(),ve=p("p"),ve.innerHTML=Bn,El=n(),u(ge.$$.fragment),Hl=n(),xe=p("p"),xe.innerHTML=Wn,Fl=n(),ke=p("p"),ke.innerHTML=Gn,Sl=n(),u(Ve.$$.fragment),Ll=n(),Be=p("p"),Be.innerHTML=_n,Dl=n(),u(We.$$.fragment),Pl=n(),Ge=p("p"),Ge.textContent=zn,Kl=n(),u(_e.$$.fragment),Ol=n(),ze=p("p"),ze.innerHTML=Xn,et=n(),u(Xe.$$.fragment),st=n(),Ne=p("p"),Ne.textContent=Nn,lt=n(),u(Ye.$$.fragment),tt=n(),Qe=p("p"),Qe.innerHTML=Yn,nt=n(),u(Re.$$.fragment),at=n(),qe=p("p"),qe.textContent=Qn,pt=n(),u(Ae.$$.fragment),rt=n(),f=p("div"),f.innerHTML=Rn,it=n(),Ee=p("p"),Ee.textContent=qn,ut=n(),He=p("p"),He.textContent=An,Mt=n(),u(Fe.$$.fragment),ot=n(),Se=p("p"),Se.innerHTML=En,mt=n(),u(Le.$$.fragment),ct=n(),De=p("p"),De.innerHTML=Hn,dt=n(),u(Pe.$$.fragment),Jt=n(),Ke=p("p"),Ke.textContent=Fn,yt=n(),u(Oe.$$.fragment),Tt=n(),u(es.$$.fragment),wt=n(),ss=p("p"),ss.innerHTML=Sn,jt=n(),u(ls.$$.fragment),Ut=n(),ts=p("p"),ts.textContent=Ln,ft=n(),u(ns.$$.fragment),ht=n(),u(as.$$.fragment),bt=n(),ps=p("p"),ps.innerHTML=Dn,It=n(),u(rs.$$.fragment),Ct=n(),is=p("p"),is.innerHTML=Pn,$t=n(),u(us.$$.fragment),Zt=n(),Ms=p("p"),Ms.textContent=Kn,vt=n(),u(os.$$.fragment),gt=n(),ms=p("p"),ms.innerHTML=On,xt=n(),u(cs.$$.fragment),kt=n(),ds=p("p"),ds.innerHTML=ea,Vt=n(),u(Js.$$.fragment),Bt=n(),ys=p("p"),ys.innerHTML=sa,Wt=n(),u(Ts.$$.fragment),Gt=n(),u(ws.$$.fragment),_t=n(),js=p("p"),js.innerHTML=la,zt=n(),u(Us.$$.fragment),Xt=n(),fs=p("p"),fs.textContent=ta,Nt=n(),u(hs.$$.fragment),Yt=n(),bs=p("p"),bs.innerHTML=na,Qt=n(),u(Is.$$.fragment),Rt=n(),Cs=p("p"),Cs.textContent=aa,qt=n(),u($s.$$.fragment),At=n(),Zs=p("p"),Zs.textContent=pa,Et=n(),u(vs.$$.fragment),Ht=n(),gs=p("p"),gs.textContent=ra,Ft=n(),u(xs.$$.fragment),St=n(),ks=p("p"),ks.textContent=ia,Lt=n(),Vs=p("p"),Vs.innerHTML=ua,Dt=n(),Bs=p("p"),Bs.textContent=Ma,Pt=n(),u(Ws.$$.fragment),Kt=n(),_s=p("p"),this.h()},l(e){const s=wa("svelte-u9bgzb",document.head);y=r(s,"META",{name:!0,content:!0}),s.forEach(l),h=a(e),T=r(e,"P",{}),ma(T).forEach(l),Gs=a(e),M(b.$$.fragment,e),Xs=a(e),M(I.$$.fragment,e),Ns=a(e),C=r(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1odglk1"&&(C.innerHTML=sn),Ys=a(e),M($.$$.fragment,e),Qs=a(e),Z=r(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1xtit6n"&&(Z.innerHTML=ln),Rs=a(e),M(v.$$.fragment,e),qs=a(e),M(j.$$.fragment,e),As=a(e),g=r(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-zql47t"&&(g.textContent=tn),Es=a(e),M(x.$$.fragment,e),Hs=a(e),k=r(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-182tg48"&&(k.textContent=nn),Fs=a(e),M(V.$$.fragment,e),Ss=a(e),M(B.$$.fragment,e),Ls=a(e),W=r(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-649ds4"&&(W.innerHTML=an),Ds=a(e),G=r(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-r0igd1"&&(G.textContent=pn),Ps=a(e),_=r(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-gwah4k"&&(_.textContent=rn),Ks=a(e),M(z.$$.fragment,e),Os=a(e),X=r(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-dbzevp"&&(X.innerHTML=un),el=a(e),M(N.$$.fragment,e),sl=a(e),Y=r(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-iud575"&&(Y.innerHTML=Mn),ll=a(e),M(Q.$$.fragment,e),tl=a(e),M(R.$$.fragment,e),nl=a(e),q=r(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1xkg4b0"&&(q.innerHTML=on),al=a(e),M(A.$$.fragment,e),pl=a(e),M(E.$$.fragment,e),rl=a(e),H=r(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1hwlbv"&&(H.innerHTML=mn),il=a(e),M(F.$$.fragment,e),ul=a(e),S=r(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1ma4sp4"&&(S.textContent=cn),Ml=a(e),M(L.$$.fragment,e),ol=a(e),D=r(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-dbzevp"&&(D.innerHTML=dn),ml=a(e),M(P.$$.fragment,e),cl=a(e),K=r(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1fh07v6"&&(K.innerHTML=Jn),dl=a(e),O=r(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-bjt1cp"&&(O.innerHTML=yn),Jl=a(e),ee=r(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-1y8jaor"&&(ee.innerHTML=Tn),yl=a(e),M(se.$$.fragment,e),Tl=a(e),le=r(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-1xmdue5"&&(le.innerHTML=wn),wl=a(e),M(te.$$.fragment,e),jl=a(e),ne=r(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-dbzevp"&&(ne.innerHTML=jn),Ul=a(e),M(ae.$$.fragment,e),fl=a(e),pe=r(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-8zji7u"&&(pe.innerHTML=Un),hl=a(e),M(re.$$.fragment,e),bl=a(e),ie=r(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-19enlau"&&(ie.textContent=fn),Il=a(e),M(ue.$$.fragment,e),Cl=a(e),Me=r(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-18ycs8t"&&(Me.textContent=hn),$l=a(e),M(oe.$$.fragment,e),Zl=a(e),me=r(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-nwfji0"&&(me.textContent=bn),vl=a(e),M(ce.$$.fragment,e),gl=a(e),U=r(e,"DIV",{class:!0,"data-svelte-h":!0}),i(U)!=="svelte-1uufiik"&&(U.innerHTML=In),xl=a(e),de=r(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1rtsrif"&&(de.textContent=Cn),kl=a(e),M(Je.$$.fragment,e),Vl=a(e),ye=r(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-16v30mk"&&(ye.textContent=$n),Bl=a(e),M(Te.$$.fragment,e),Wl=a(e),we=r(e,"P",{"data-svelte-h":!0}),i(we)!=="svelte-dbzevp"&&(we.innerHTML=Zn),Gl=a(e),M(je.$$.fragment,e),_l=a(e),Ue=r(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-zuw53j"&&(Ue.textContent=vn),zl=a(e),M(fe.$$.fragment,e),Xl=a(e),he=r(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-dbzevp"&&(he.innerHTML=gn),Nl=a(e),M(be.$$.fragment,e),Yl=a(e),Ie=r(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-31x8kk"&&(Ie.textContent=xn),Ql=a(e),Ce=r(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-1w6hl2u"&&(Ce.textContent=kn),Rl=a(e),M($e.$$.fragment,e),ql=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-17z7cpr"&&(Ze.innerHTML=Vn),Al=a(e),ve=r(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-4hmwow"&&(ve.innerHTML=Bn),El=a(e),M(ge.$$.fragment,e),Hl=a(e),xe=r(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-xw8jh1"&&(xe.innerHTML=Wn),Fl=a(e),ke=r(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-6lbev2"&&(ke.innerHTML=Gn),Sl=a(e),M(Ve.$$.fragment,e),Ll=a(e),Be=r(e,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-1oc1ikt"&&(Be.innerHTML=_n),Dl=a(e),M(We.$$.fragment,e),Pl=a(e),Ge=r(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-56wyab"&&(Ge.textContent=zn),Kl=a(e),M(_e.$$.fragment,e),Ol=a(e),ze=r(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-dbzevp"&&(ze.innerHTML=Xn),et=a(e),M(Xe.$$.fragment,e),st=a(e),Ne=r(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-8c0crw"&&(Ne.textContent=Nn),lt=a(e),M(Ye.$$.fragment,e),tt=a(e),Qe=r(e,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-dbzevp"&&(Qe.innerHTML=Yn),nt=a(e),M(Re.$$.fragment,e),at=a(e),qe=r(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-33k1kn"&&(qe.textContent=Qn),pt=a(e),M(Ae.$$.fragment,e),rt=a(e),f=r(e,"DIV",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-j4o1b8"&&(f.innerHTML=Rn),it=a(e),Ee=r(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-dra6ot"&&(Ee.textContent=qn),ut=a(e),He=r(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-6d8mq6"&&(He.textContent=An),Mt=a(e),M(Fe.$$.fragment,e),ot=a(e),Se=r(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-ezcn9z"&&(Se.innerHTML=En),mt=a(e),M(Le.$$.fragment,e),ct=a(e),De=r(e,"P",{"data-svelte-h":!0}),i(De)!=="svelte-dbzevp"&&(De.innerHTML=Hn),dt=a(e),M(Pe.$$.fragment,e),Jt=a(e),Ke=r(e,"P",{"data-svelte-h":!0}),i(Ke)!=="svelte-12gx63x"&&(Ke.textContent=Fn),yt=a(e),M(Oe.$$.fragment,e),Tt=a(e),M(es.$$.fragment,e),wt=a(e),ss=r(e,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-zdglne"&&(ss.innerHTML=Sn),jt=a(e),M(ls.$$.fragment,e),Ut=a(e),ts=r(e,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1g1h6a2"&&(ts.textContent=Ln),ft=a(e),M(ns.$$.fragment,e),ht=a(e),M(as.$$.fragment,e),bt=a(e),ps=r(e,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-kop7ev"&&(ps.innerHTML=Dn),It=a(e),M(rs.$$.fragment,e),Ct=a(e),is=r(e,"P",{"data-svelte-h":!0}),i(is)!=="svelte-1wpgu2u"&&(is.innerHTML=Pn),$t=a(e),M(us.$$.fragment,e),Zt=a(e),Ms=r(e,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-14u91wl"&&(Ms.textContent=Kn),vt=a(e),M(os.$$.fragment,e),gt=a(e),ms=r(e,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-15wpyyc"&&(ms.innerHTML=On),xt=a(e),M(cs.$$.fragment,e),kt=a(e),ds=r(e,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-c07opw"&&(ds.innerHTML=ea),Vt=a(e),M(Js.$$.fragment,e),Bt=a(e),ys=r(e,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-mr5xro"&&(ys.innerHTML=sa),Wt=a(e),M(Ts.$$.fragment,e),Gt=a(e),M(ws.$$.fragment,e),_t=a(e),js=r(e,"P",{"data-svelte-h":!0}),i(js)!=="svelte-7v0yj3"&&(js.innerHTML=la),zt=a(e),M(Us.$$.fragment,e),Xt=a(e),fs=r(e,"P",{"data-svelte-h":!0}),i(fs)!=="svelte-qm5zo2"&&(fs.textContent=ta),Nt=a(e),M(hs.$$.fragment,e),Yt=a(e),bs=r(e,"P",{"data-svelte-h":!0}),i(bs)!=="svelte-1atngeh"&&(bs.innerHTML=na),Qt=a(e),M(Is.$$.fragment,e),Rt=a(e),Cs=r(e,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-11n0rrj"&&(Cs.textContent=aa),qt=a(e),M($s.$$.fragment,e),At=a(e),Zs=r(e,"P",{"data-svelte-h":!0}),i(Zs)!=="svelte-671fhq"&&(Zs.textContent=pa),Et=a(e),M(vs.$$.fragment,e),Ht=a(e),gs=r(e,"P",{"data-svelte-h":!0}),i(gs)!=="svelte-7kkl40"&&(gs.textContent=ra),Ft=a(e),M(xs.$$.fragment,e),St=a(e),ks=r(e,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-d3yvzd"&&(ks.textContent=ia),Lt=a(e),Vs=r(e,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-1i751j2"&&(Vs.innerHTML=ua),Dt=a(e),Bs=r(e,"P",{"data-svelte-h":!0}),i(Bs)!=="svelte-y5achn"&&(Bs.textContent=Ma),Pt=a(e),M(Ws.$$.fragment,e),Kt=a(e),_s=r(e,"P",{}),ma(_s).forEach(l),this.h()},h(){en(y,"name","hf:doc:metadata"),en(y,"content",Ca),en(U,"class","flex justify-center"),en(f,"class","flex justify-center")},m(e,s){ja(document.head,y),t(e,h,s),t(e,T,s),t(e,Gs,s),o(b,e,s),t(e,Xs,s),o(I,e,s),t(e,Ns,s),t(e,C,s),t(e,Ys,s),o($,e,s),t(e,Qs,s),t(e,Z,s),t(e,Rs,s),o(v,e,s),t(e,qs,s),o(j,e,s),t(e,As,s),t(e,g,s),t(e,Es,s),o(x,e,s),t(e,Hs,s),t(e,k,s),t(e,Fs,s),o(V,e,s),t(e,Ss,s),o(B,e,s),t(e,Ls,s),t(e,W,s),t(e,Ds,s),t(e,G,s),t(e,Ps,s),t(e,_,s),t(e,Ks,s),o(z,e,s),t(e,Os,s),t(e,X,s),t(e,el,s),o(N,e,s),t(e,sl,s),t(e,Y,s),t(e,ll,s),o(Q,e,s),t(e,tl,s),o(R,e,s),t(e,nl,s),t(e,q,s),t(e,al,s),o(A,e,s),t(e,pl,s),o(E,e,s),t(e,rl,s),t(e,H,s),t(e,il,s),o(F,e,s),t(e,ul,s),t(e,S,s),t(e,Ml,s),o(L,e,s),t(e,ol,s),t(e,D,s),t(e,ml,s),o(P,e,s),t(e,cl,s),t(e,K,s),t(e,dl,s),t(e,O,s),t(e,Jl,s),t(e,ee,s),t(e,yl,s),o(se,e,s),t(e,Tl,s),t(e,le,s),t(e,wl,s),o(te,e,s),t(e,jl,s),t(e,ne,s),t(e,Ul,s),o(ae,e,s),t(e,fl,s),t(e,pe,s),t(e,hl,s),o(re,e,s),t(e,bl,s),t(e,ie,s),t(e,Il,s),o(ue,e,s),t(e,Cl,s),t(e,Me,s),t(e,$l,s),o(oe,e,s),t(e,Zl,s),t(e,me,s),t(e,vl,s),o(ce,e,s),t(e,gl,s),t(e,U,s),t(e,xl,s),t(e,de,s),t(e,kl,s),o(Je,e,s),t(e,Vl,s),t(e,ye,s),t(e,Bl,s),o(Te,e,s),t(e,Wl,s),t(e,we,s),t(e,Gl,s),o(je,e,s),t(e,_l,s),t(e,Ue,s),t(e,zl,s),o(fe,e,s),t(e,Xl,s),t(e,he,s),t(e,Nl,s),o(be,e,s),t(e,Yl,s),t(e,Ie,s),t(e,Ql,s),t(e,Ce,s),t(e,Rl,s),o($e,e,s),t(e,ql,s),t(e,Ze,s),t(e,Al,s),t(e,ve,s),t(e,El,s),o(ge,e,s),t(e,Hl,s),t(e,xe,s),t(e,Fl,s),t(e,ke,s),t(e,Sl,s),o(Ve,e,s),t(e,Ll,s),t(e,Be,s),t(e,Dl,s),o(We,e,s),t(e,Pl,s),t(e,Ge,s),t(e,Kl,s),o(_e,e,s),t(e,Ol,s),t(e,ze,s),t(e,et,s),o(Xe,e,s),t(e,st,s),t(e,Ne,s),t(e,lt,s),o(Ye,e,s),t(e,tt,s),t(e,Qe,s),t(e,nt,s),o(Re,e,s),t(e,at,s),t(e,qe,s),t(e,pt,s),o(Ae,e,s),t(e,rt,s),t(e,f,s),t(e,it,s),t(e,Ee,s),t(e,ut,s),t(e,He,s),t(e,Mt,s),o(Fe,e,s),t(e,ot,s),t(e,Se,s),t(e,mt,s),o(Le,e,s),t(e,ct,s),t(e,De,s),t(e,dt,s),o(Pe,e,s),t(e,Jt,s),t(e,Ke,s),t(e,yt,s),o(Oe,e,s),t(e,Tt,s),o(es,e,s),t(e,wt,s),t(e,ss,s),t(e,jt,s),o(ls,e,s),t(e,Ut,s),t(e,ts,s),t(e,ft,s),o(ns,e,s),t(e,ht,s),o(as,e,s),t(e,bt,s),t(e,ps,s),t(e,It,s),o(rs,e,s),t(e,Ct,s),t(e,is,s),t(e,$t,s),o(us,e,s),t(e,Zt,s),t(e,Ms,s),t(e,vt,s),o(os,e,s),t(e,gt,s),t(e,ms,s),t(e,xt,s),o(cs,e,s),t(e,kt,s),t(e,ds,s),t(e,Vt,s),o(Js,e,s),t(e,Bt,s),t(e,ys,s),t(e,Wt,s),o(Ts,e,s),t(e,Gt,s),o(ws,e,s),t(e,_t,s),t(e,js,s),t(e,zt,s),o(Us,e,s),t(e,Xt,s),t(e,fs,s),t(e,Nt,s),o(hs,e,s),t(e,Yt,s),t(e,bs,s),t(e,Qt,s),o(Is,e,s),t(e,Rt,s),t(e,Cs,s),t(e,qt,s),o($s,e,s),t(e,At,s),t(e,Zs,s),t(e,Et,s),o(vs,e,s),t(e,Ht,s),t(e,gs,s),t(e,Ft,s),o(xs,e,s),t(e,St,s),t(e,ks,s),t(e,Lt,s),t(e,Vs,s),t(e,Dt,s),t(e,Bs,s),t(e,Pt,s),o(Ws,e,s),t(e,Kt,s),t(e,_s,s),Ot=!0},p(e,[s]){const oa={};s&2&&(oa.$$scope={dirty:s,ctx:e}),j.$set(oa)},i(e){Ot||(m(b.$$.fragment,e),m(I.$$.fragment,e),m($.$$.fragment,e),m(v.$$.fragment,e),m(j.$$.fragment,e),m(x.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(z.$$.fragment,e),m(N.$$.fragment,e),m(Q.$$.fragment,e),m(R.$$.fragment,e),m(A.$$.fragment,e),m(E.$$.fragment,e),m(F.$$.fragment,e),m(L.$$.fragment,e),m(P.$$.fragment,e),m(se.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(ue.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(Je.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m($e.$$.fragment,e),m(ge.$$.fragment,e),m(Ve.$$.fragment,e),m(We.$$.fragment,e),m(_e.$$.fragment,e),m(Xe.$$.fragment,e),m(Ye.$$.fragment,e),m(Re.$$.fragment,e),m(Ae.$$.fragment,e),m(Fe.$$.fragment,e),m(Le.$$.fragment,e),m(Pe.$$.fragment,e),m(Oe.$$.fragment,e),m(es.$$.fragment,e),m(ls.$$.fragment,e),m(ns.$$.fragment,e),m(as.$$.fragment,e),m(rs.$$.fragment,e),m(us.$$.fragment,e),m(os.$$.fragment,e),m(cs.$$.fragment,e),m(Js.$$.fragment,e),m(Ts.$$.fragment,e),m(ws.$$.fragment,e),m(Us.$$.fragment,e),m(hs.$$.fragment,e),m(Is.$$.fragment,e),m($s.$$.fragment,e),m(vs.$$.fragment,e),m(xs.$$.fragment,e),m(Ws.$$.fragment,e),Ot=!0)},o(e){c(b.$$.fragment,e),c(I.$$.fragment,e),c($.$$.fragment,e),c(v.$$.fragment,e),c(j.$$.fragment,e),c(x.$$.fragment,e),c(V.$$.fragment,e),c(B.$$.fragment,e),c(z.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(R.$$.fragment,e),c(A.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(se.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(ue.$$.fragment,e),c(oe.$$.fragment,e),c(ce.$$.fragment,e),c(Je.$$.fragment,e),c(Te.$$.fragment,e),c(je.$$.fragment,e),c(fe.$$.fragment,e),c(be.$$.fragment,e),c($e.$$.fragment,e),c(ge.$$.fragment,e),c(Ve.$$.fragment,e),c(We.$$.fragment,e),c(_e.$$.fragment,e),c(Xe.$$.fragment,e),c(Ye.$$.fragment,e),c(Re.$$.fragment,e),c(Ae.$$.fragment,e),c(Fe.$$.fragment,e),c(Le.$$.fragment,e),c(Pe.$$.fragment,e),c(Oe.$$.fragment,e),c(es.$$.fragment,e),c(ls.$$.fragment,e),c(ns.$$.fragment,e),c(as.$$.fragment,e),c(rs.$$.fragment,e),c(us.$$.fragment,e),c(os.$$.fragment,e),c(cs.$$.fragment,e),c(Js.$$.fragment,e),c(Ts.$$.fragment,e),c(ws.$$.fragment,e),c(Us.$$.fragment,e),c(hs.$$.fragment,e),c(Is.$$.fragment,e),c($s.$$.fragment,e),c(vs.$$.fragment,e),c(xs.$$.fragment,e),c(Ws.$$.fragment,e),Ot=!1},d(e){e&&(l(h),l(T),l(Gs),l(Xs),l(Ns),l(C),l(Ys),l(Qs),l(Z),l(Rs),l(qs),l(As),l(g),l(Es),l(Hs),l(k),l(Fs),l(Ss),l(Ls),l(W),l(Ds),l(G),l(Ps),l(_),l(Ks),l(Os),l(X),l(el),l(sl),l(Y),l(ll),l(tl),l(nl),l(q),l(al),l(pl),l(rl),l(H),l(il),l(ul),l(S),l(Ml),l(ol),l(D),l(ml),l(cl),l(K),l(dl),l(O),l(Jl),l(ee),l(yl),l(Tl),l(le),l(wl),l(jl),l(ne),l(Ul),l(fl),l(pe),l(hl),l(bl),l(ie),l(Il),l(Cl),l(Me),l($l),l(Zl),l(me),l(vl),l(gl),l(U),l(xl),l(de),l(kl),l(Vl),l(ye),l(Bl),l(Wl),l(we),l(Gl),l(_l),l(Ue),l(zl),l(Xl),l(he),l(Nl),l(Yl),l(Ie),l(Ql),l(Ce),l(Rl),l(ql),l(Ze),l(Al),l(ve),l(El),l(Hl),l(xe),l(Fl),l(ke),l(Sl),l(Ll),l(Be),l(Dl),l(Pl),l(Ge),l(Kl),l(Ol),l(ze),l(et),l(st),l(Ne),l(lt),l(tt),l(Qe),l(nt),l(at),l(qe),l(pt),l(rt),l(f),l(it),l(Ee),l(ut),l(He),l(Mt),l(ot),l(Se),l(mt),l(ct),l(De),l(dt),l(Jt),l(Ke),l(yt),l(Tt),l(wt),l(ss),l(jt),l(Ut),l(ts),l(ft),l(ht),l(bt),l(ps),l(It),l(Ct),l(is),l($t),l(Zt),l(Ms),l(vt),l(gt),l(ms),l(xt),l(kt),l(ds),l(Vt),l(Bt),l(ys),l(Wt),l(Gt),l(_t),l(js),l(zt),l(Xt),l(fs),l(Nt),l(Yt),l(bs),l(Qt),l(Rt),l(Cs),l(qt),l(At),l(Zs),l(Et),l(Ht),l(gs),l(Ft),l(St),l(ks),l(Lt),l(Vs),l(Dt),l(Bs),l(Pt),l(Kt),l(_s)),l(y),d(b,e),d(I,e),d($,e),d(v,e),d(j,e),d(x,e),d(V,e),d(B,e),d(z,e),d(N,e),d(Q,e),d(R,e),d(A,e),d(E,e),d(F,e),d(L,e),d(P,e),d(se,e),d(te,e),d(ae,e),d(re,e),d(ue,e),d(oe,e),d(ce,e),d(Je,e),d(Te,e),d(je,e),d(fe,e),d(be,e),d($e,e),d(ge,e),d(Ve,e),d(We,e),d(_e,e),d(Xe,e),d(Ye,e),d(Re,e),d(Ae,e),d(Fe,e),d(Le,e),d(Pe,e),d(Oe,e),d(es,e),d(ls,e),d(ns,e),d(as,e),d(rs,e),d(us,e),d(os,e),d(cs,e),d(Js,e),d(Ts,e),d(ws,e),d(Us,e),d(hs,e),d(Is,e),d($s,e),d(vs,e),d(xs,e),d(Ws,e)}}}const Ca='{"title":"Finetuning du SpeechT5","local":"finetuning-du-speecht5","sections":[{"title":"Préparation","local":"préparation","sections":[],"depth":2},{"title":"Le jeu de données","local":"le-jeu-de-données","sections":[],"depth":2},{"title":"Prétraitement des données","local":"prétraitement-des-données","sections":[{"title":"Nettoyage du texte pour la tokenisation de SpeechT5","local":"nettoyage-du-texte-pour-la-tokenisation-de-speecht5","sections":[],"depth":3},{"title":"Les locuteurs","local":"les-locuteurs","sections":[],"depth":3},{"title":"Enchâssement des locuteurs","local":"enchâssement-des-locuteurs","sections":[],"depth":3},{"title":"Traitement du jeu de données","local":"traitement-du-jeu-de-données","sections":[],"depth":3},{"title":"Assembleur de données","local":"assembleur-de-données","sections":[],"depth":3}],"depth":2},{"title":"Entraîner le modèle","local":"entraîner-le-modèle","sections":[],"depth":2},{"title":"Inférence","local":"inférence","sections":[],"depth":2}],"depth":1}';function $a(zs){return da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Va extends ya{constructor(y){super(),Ta(this,y,$a,Ia,ca,{})}}export{Va as component};
