import{s as ne,n as Me,o as ie}from"../chunks/scheduler.cd324960.js";import{S as oe,i as pe,e as M,s as a,c as p,h as ue,a as i,d as t,b as n,f as ae,g as u,j as o,k as Wl,l as ye,m as s,n as y,t as r,o as d,p as j}from"../chunks/index.d5c3adcc.js";import{C as re,H as de,E as je}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.7d44181b.js";import{C as c}from"../chunks/CodeBlock.f16d02bc.js";function ce(Bl){let m,K,P,ll,U,el,w,tl,f,_l=`In this course we will use the 🤗 Datasets library to work with audio datasets. 🤗 Datasets is an open-source library for
downloading and preparing datasets from all modalities including audio. The library offers easy access to an unparalleled
selection of machine learning datasets publicly available on Hugging Face Hub. Moreover, 🤗 Datasets includes multiple
features tailored to audio datasets that simplify working with such datasets for both researchers and practitioners.`,sl,J,Ql="To begin working with audio datasets, make sure you have the 🤗 Datasets library installed:",al,T,nl,b,Rl=`One of the key defining features of 🤗 Datasets is the ability to download and prepare a dataset in just one line of
Python code using the <code>load_dataset()</code> function.`,Ml,A,Fl=`Let’s load and explore and audio dataset called <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, which contains
recordings of people asking an e-banking system questions in several languages and dialects.`,il,C,Yl=`To load the MINDS-14 dataset, we need to copy the dataset’s identifier on the Hub (<code>PolyAI/minds14</code>) and pass it
to the <code>load_dataset</code> function. We’ll also specify that we’re only interested in the Australian subset (<code>en-AU</code>) of
the data, and limit it to the training split:`,ol,I,pl,g,Hl="<strong>Output:</strong>",ul,$,yl,k,zl=`The dataset contains 654 audio files, each of which is accompanied by a transcription, an English translation, and a label
indicating the intent behind the person’s query. The audio column contains the raw audio data. Let’s take a closer look
at one of the examples:`,rl,v,dl,G,Nl="<strong>Output:</strong>",jl,x,cl,Z,Sl="You may notice that the audio column contains several features. Here’s what they are:",ml,E,Xl="<li><code>path</code>: the path to the audio file (<code>*.wav</code> in this case).</li> <li><code>array</code>: The decoded audio data, represented as a 1-dimensional NumPy array.</li> <li><code>sampling_rate</code>. The sampling rate of the audio file (8,000 Hz in this example).</li>",hl,q,Ll=`The <code>intent_class</code> is a classification category of the audio recording. To convert this number into a meaningful string,
we can use the <code>int2str()</code> method:`,Ul,W,wl,B,Vl="<strong>Output:</strong>",fl,_,Jl,Q,Dl=`If you look at the transcription feature, you can see that the audio file indeed has recorded a person asking a question
about paying a bill.`,Tl,R,Pl=`If you plan to train an audio classifier on this subset of data, you may not necessarily need all of the features. For example,
the <code>lang_id</code> is going to have the same value for all examples, and won’t be useful. The <code>english_transcription</code> will likely
duplicate the <code>transcription</code> in this subset, so we can safely remove them.`,bl,F,Ol="You can easily remove irrelevant features using 🤗 Datasets’ <code>remove_columns</code> method:",Al,Y,Cl,H,Kl="<strong>Output:</strong>",Il,z,gl,N,le=`Now that we’ve loaded and inspected the raw contents of the dataset, let’s listen to a few examples! We’ll use the <code>Blocks</code>
and <code>Audio</code> features from <code>Gradio</code> to decode a few random samples from the dataset:`,$l,S,kl,X,ee="If you’d like to, you can also visualize some of the examples. Let’s plot the waveform for the first example.",vl,L,Gl,h,te='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',xl,V,se=`Try it out! Download another dialect or language of the MINDS-14 dataset, listen and visualize some examples to get a sense
of the variation in the whole dataset. You can find the full list of available languages <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">here</a>.`,Zl,D,El,O,ql;return U=new re({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new de({props:{title:"Load and explore an audio dataset",local:"load-and-explore-an-audio-dataset",headingTag:"h1"}}),T=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),I=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),$=new c({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),v=new c({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),x=new c({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),W=new c({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),_=new c({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),Y=new c({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),z=new c({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),S=new c({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new c({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),D=new je({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/load_and_explore.mdx"}}),{c(){m=M("meta"),K=a(),P=M("p"),ll=a(),p(U.$$.fragment),el=a(),p(w.$$.fragment),tl=a(),f=M("p"),f.textContent=_l,sl=a(),J=M("p"),J.textContent=Ql,al=a(),p(T.$$.fragment),nl=a(),b=M("p"),b.innerHTML=Rl,Ml=a(),A=M("p"),A.innerHTML=Fl,il=a(),C=M("p"),C.innerHTML=Yl,ol=a(),p(I.$$.fragment),pl=a(),g=M("p"),g.innerHTML=Hl,ul=a(),p($.$$.fragment),yl=a(),k=M("p"),k.textContent=zl,rl=a(),p(v.$$.fragment),dl=a(),G=M("p"),G.innerHTML=Nl,jl=a(),p(x.$$.fragment),cl=a(),Z=M("p"),Z.textContent=Sl,ml=a(),E=M("ul"),E.innerHTML=Xl,hl=a(),q=M("p"),q.innerHTML=Ll,Ul=a(),p(W.$$.fragment),wl=a(),B=M("p"),B.innerHTML=Vl,fl=a(),p(_.$$.fragment),Jl=a(),Q=M("p"),Q.textContent=Dl,Tl=a(),R=M("p"),R.innerHTML=Pl,bl=a(),F=M("p"),F.innerHTML=Ol,Al=a(),p(Y.$$.fragment),Cl=a(),H=M("p"),H.innerHTML=Kl,Il=a(),p(z.$$.fragment),gl=a(),N=M("p"),N.innerHTML=le,$l=a(),p(S.$$.fragment),kl=a(),X=M("p"),X.textContent=ee,vl=a(),p(L.$$.fragment),Gl=a(),h=M("div"),h.innerHTML=te,xl=a(),V=M("p"),V.innerHTML=se,Zl=a(),p(D.$$.fragment),El=a(),O=M("p"),this.h()},l(l){const e=ue("svelte-u9bgzb",document.head);m=i(e,"META",{name:!0,content:!0}),e.forEach(t),K=n(l),P=i(l,"P",{}),ae(P).forEach(t),ll=n(l),u(U.$$.fragment,l),el=n(l),u(w.$$.fragment,l),tl=n(l),f=i(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-14tdruz"&&(f.textContent=_l),sl=n(l),J=i(l,"P",{"data-svelte-h":!0}),o(J)!=="svelte-16weaia"&&(J.textContent=Ql),al=n(l),u(T.$$.fragment,l),nl=n(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-vy8pv5"&&(b.innerHTML=Rl),Ml=n(l),A=i(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1ibmxou"&&(A.innerHTML=Fl),il=n(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-11xjat8"&&(C.innerHTML=Yl),ol=n(l),u(I.$$.fragment,l),pl=n(l),g=i(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1mvdyro"&&(g.innerHTML=Hl),ul=n(l),u($.$$.fragment,l),yl=n(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-7t6f49"&&(k.textContent=zl),rl=n(l),u(v.$$.fragment,l),dl=n(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1mvdyro"&&(G.innerHTML=Nl),jl=n(l),u(x.$$.fragment,l),cl=n(l),Z=i(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1xpct0w"&&(Z.textContent=Sl),ml=n(l),E=i(l,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-n6enht"&&(E.innerHTML=Xl),hl=n(l),q=i(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1wz2ihr"&&(q.innerHTML=Ll),Ul=n(l),u(W.$$.fragment,l),wl=n(l),B=i(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1mvdyro"&&(B.innerHTML=Vl),fl=n(l),u(_.$$.fragment,l),Jl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1a1ybip"&&(Q.textContent=Dl),Tl=n(l),R=i(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-11cpnca"&&(R.innerHTML=Pl),bl=n(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-gmqz2q"&&(F.innerHTML=Ol),Al=n(l),u(Y.$$.fragment,l),Cl=n(l),H=i(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1mvdyro"&&(H.innerHTML=Kl),Il=n(l),u(z.$$.fragment,l),gl=n(l),N=i(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1iz3f0u"&&(N.innerHTML=le),$l=n(l),u(S.$$.fragment,l),kl=n(l),X=i(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-14zloga"&&(X.textContent=ee),vl=n(l),u(L.$$.fragment,l),Gl=n(l),h=i(l,"DIV",{class:!0,"data-svelte-h":!0}),o(h)!=="svelte-1ym6zda"&&(h.innerHTML=te),xl=n(l),V=i(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1frcml4"&&(V.innerHTML=se),Zl=n(l),u(D.$$.fragment,l),El=n(l),O=i(l,"P",{}),ae(O).forEach(t),this.h()},h(){Wl(m,"name","hf:doc:metadata"),Wl(m,"content",me),Wl(h,"class","flex justify-center")},m(l,e){ye(document.head,m),s(l,K,e),s(l,P,e),s(l,ll,e),y(U,l,e),s(l,el,e),y(w,l,e),s(l,tl,e),s(l,f,e),s(l,sl,e),s(l,J,e),s(l,al,e),y(T,l,e),s(l,nl,e),s(l,b,e),s(l,Ml,e),s(l,A,e),s(l,il,e),s(l,C,e),s(l,ol,e),y(I,l,e),s(l,pl,e),s(l,g,e),s(l,ul,e),y($,l,e),s(l,yl,e),s(l,k,e),s(l,rl,e),y(v,l,e),s(l,dl,e),s(l,G,e),s(l,jl,e),y(x,l,e),s(l,cl,e),s(l,Z,e),s(l,ml,e),s(l,E,e),s(l,hl,e),s(l,q,e),s(l,Ul,e),y(W,l,e),s(l,wl,e),s(l,B,e),s(l,fl,e),y(_,l,e),s(l,Jl,e),s(l,Q,e),s(l,Tl,e),s(l,R,e),s(l,bl,e),s(l,F,e),s(l,Al,e),y(Y,l,e),s(l,Cl,e),s(l,H,e),s(l,Il,e),y(z,l,e),s(l,gl,e),s(l,N,e),s(l,$l,e),y(S,l,e),s(l,kl,e),s(l,X,e),s(l,vl,e),y(L,l,e),s(l,Gl,e),s(l,h,e),s(l,xl,e),s(l,V,e),s(l,Zl,e),y(D,l,e),s(l,El,e),s(l,O,e),ql=!0},p:Me,i(l){ql||(r(U.$$.fragment,l),r(w.$$.fragment,l),r(T.$$.fragment,l),r(I.$$.fragment,l),r($.$$.fragment,l),r(v.$$.fragment,l),r(x.$$.fragment,l),r(W.$$.fragment,l),r(_.$$.fragment,l),r(Y.$$.fragment,l),r(z.$$.fragment,l),r(S.$$.fragment,l),r(L.$$.fragment,l),r(D.$$.fragment,l),ql=!0)},o(l){d(U.$$.fragment,l),d(w.$$.fragment,l),d(T.$$.fragment,l),d(I.$$.fragment,l),d($.$$.fragment,l),d(v.$$.fragment,l),d(x.$$.fragment,l),d(W.$$.fragment,l),d(_.$$.fragment,l),d(Y.$$.fragment,l),d(z.$$.fragment,l),d(S.$$.fragment,l),d(L.$$.fragment,l),d(D.$$.fragment,l),ql=!1},d(l){l&&(t(K),t(P),t(ll),t(el),t(tl),t(f),t(sl),t(J),t(al),t(nl),t(b),t(Ml),t(A),t(il),t(C),t(ol),t(pl),t(g),t(ul),t(yl),t(k),t(rl),t(dl),t(G),t(jl),t(cl),t(Z),t(ml),t(E),t(hl),t(q),t(Ul),t(wl),t(B),t(fl),t(Jl),t(Q),t(Tl),t(R),t(bl),t(F),t(Al),t(Cl),t(H),t(Il),t(gl),t(N),t($l),t(kl),t(X),t(vl),t(Gl),t(h),t(xl),t(V),t(Zl),t(El),t(O)),t(m),j(U,l),j(w,l),j(T,l),j(I,l),j($,l),j(v,l),j(x,l),j(W,l),j(_,l),j(Y,l),j(z,l),j(S,l),j(L,l),j(D,l)}}}const me='{"title":"Load and explore an audio dataset","local":"load-and-explore-an-audio-dataset","sections":[],"depth":1}';function he(Bl){return ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends oe{constructor(m){super(),pe(this,m,he,ce,ne,{})}}export{Te as component};
