import{s as Ks,o as Ds,n as Ps}from"../chunks/scheduler.889ebb13.js";import{S as Os,i as te,g as o,s as n,r as M,m as ft,A as se,h as p,f as e,c as a,j as js,u,x as i,n as Tt,k as Jt,y as bt,a as l,v as m,d,t as y,w as h}from"../chunks/index.ca18042b.js";import{T as Ys}from"../chunks/Tip.b8116e3c.js";import{C as g}from"../chunks/CodeBlock.1db71023.js";import{H as I}from"../chunks/Heading.3daa581c.js";import{E as ee}from"../chunks/EditOnGithub.2e95618d.js";function le(ht){let r,c,f="this notebook",j;return{c(){r=ft("You can follow the code in "),c=o("a"),c.textContent=f,j=ft(" that you can run using Google Colab."),this.h()},l(w){r=Tt(w,"You can follow the code in "),c=p(w,"A",{href:!0,target:!0,"data-svelte-h":!0}),i(c)!=="svelte-1g92vyy"&&(c.textContent=f),j=Tt(w," that you can run using Google Colab."),this.h()},h(){Jt(c,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb"),Jt(c,"target","_blank")},m(w,J){l(w,r,J),l(w,c,J),l(w,j,J)},p:Ps,d(w){w&&(e(r),e(c),e(j))}}}function ne(ht){let r,c,f="the LlamaIndex documentation",j;return{c(){r=ft("There are some more complex nuances to workflows, which you can learn about in "),c=o("a"),c.textContent=f,j=ft("."),this.h()},l(w){r=Tt(w,"There are some more complex nuances to workflows, which you can learn about in "),c=p(w,"A",{href:!0,"data-svelte-h":!0}),i(c)!=="svelte-3nnrtm"&&(c.textContent=f),j=Tt(w,"."),this.h()},h(){Jt(c,"href","https://docs.llamaindex.ai/en/stable/understanding/workflows/")},m(w,J){l(w,r,J),l(w,c,J),l(w,j,J)},p:Ps,d(w){w&&(e(r),e(c),e(j))}}}function ae(ht){let r,c,f,j,w,J,k,Js="A workflow in LlamaIndex provides a structured way to organize your code into sequential and manageable steps.",Ct,B,fs=`Such a workflow is created by defining <code>Steps</code> which are triggered by <code>Events</code>, and themselves emit <code>Events</code> to trigger further steps.
Let’s take a look at Alfred showing a LlamaIndex workflow for a RAG task.`,gt,v,Ts='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflow Schematic"/>',It,Z,Us="<strong>Workflows offer several key benefits:</strong>",kt,_,bs="<li>Clear organization of code into discrete steps</li> <li>Event-driven architecture for flexible control flow</li> <li>Type-safe communication between steps</li> <li>Built-in state management</li> <li>Support for both simple and complex agent interactions</li>",Bt,G,Cs="As you might have guessed, <strong>workflows strike a great balance between the autonomy of agents while maintaining control over the overall workflow.</strong>",vt,x,gs="So, let’s learn how to create a workflow ourselves!",Zt,$,_t,b,Gt,E,xt,T,jt,Is="Install the Workflow package",ys,W,ks="section on the LlamaHub",hs,V,$t,Q,Bs=`We can create a single-step workflow by defining a class that inherits from <code>Workflow</code> and decorating your functions with <code>@step</code>.
We will also need to add <code>StartEvent</code> and <code>StopEvent</code>, which are special events that are used to indicate the start and end of the workflow.`,Et,S,Wt,H,vs="As you can see, we can now run the workflow by calling <code>w.run()</code>.",Vt,A,Qt,F,Zs=`To connect multiple steps, we <strong>create custom events that carry data between steps.</strong>
To do so, we need to add an <code>Event</code> that is passed between the steps and transfers the output of the first step to the second step.`,St,X,Ht,R,_s="The type hinting is important here, as it ensures that the workflow is executed correctly. Let’s complicate things a bit more!",At,q,Ft,N,Gs="The type hinting is the most powerful part of workflows because it allows us to create branches, loops, and joins to facilitate more complex workflows.",Xt,z,xs=`Let’s show an example of <strong>creating a loop</strong> by using the union operator <code>|</code>.
In the example below, we see that the <code>LoopEvent</code> is taken as input for the step and can also be returned as output.`,Rt,L,qt,Y,Nt,P,$s="We can also draw workflows. Let’s use the <code>draw_all_possible_flows</code> function to draw the workflow. This stores the workflow in an HTML file.",zt,K,Lt,D,Es='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="workflow drawing"/>',Yt,O,Ws="There is one last cool trick that we will cover in the course, which is the ability to add state to the workflow.",Pt,tt,Kt,st,Vs=`State management is useful when you want to keep track of the state of the workflow, so that every step has access to the same state.
We can do this by using the <code>Context</code> type hint on top of a parameter in the step function.`,Dt,et,Ot,lt,Qs="Great! Now you know how to create basic workflows in LlamaIndex!",ts,C,ss,nt,Ss="However, there is another way to create workflows, which relies on the <code>AgentWorkflow</code> class. Let’s take a look at how we can use this to create a multi-agent workflow.",es,at,ls,ot,Hs=`Instead of manual workflow creation, we can use the <strong><code>AgentWorkflow</code> class to create a multi-agent workflow</strong>.
The <code>AgentWorkflow</code> uses Workflow Agents to allow you to create a system of one or more agents that can collaborate and hand off tasks to each other based on their specialized capabilities.
This enables building complex agent systems where different agents handle different aspects of a task.
Instead of importing classes from <code>llama_index.core.agent</code>, we will import the agent classes from <code>llama_index.core.agent.workflow</code>.
One agent must be designated as the root agent in the <code>AgentWorkflow</code> constructor.
When a user message comes in, it is first routed to the root agent.`,ns,pt,As="Each agent can then:",as,it,Fs="<li>Handle the request directly using their tools</li> <li>Handoff to another agent better suited for the task</li> <li>Return a response to the user</li>",os,wt,Xs="Let’s see how to create a multi-agent workflow.",ps,ct,is,rt,Rs=`Agent tools can also modify the workflow state we mentioned earlier. Before starting the workflow, we can provide an initial state dict that will be available to all agents.
The state is stored in the state key of the workflow context. It will be injected into the state_prompt which augments each new user message.`,ws,Mt,qs="Let’s inject a counter to count function calls by modifying the previous example:",cs,ut,rs,mt,Ns="Congratulations! You have now mastered the basics of Agents in LlamaIndex! 🎉",Ms,dt,zs="Let’s continue with one final quiz to solidify your knowledge! 🚀",us,yt,ms,Ut,ds;return w=new I({props:{title:"Creating agentic workflows in LlamaIndex",local:"creating-agentic-workflows-in-llamaindex",headingTag:"h1"}}),$=new I({props:{title:"Creating Workflows",local:"creating-workflows",headingTag:"h2"}}),b=new Ys({props:{$$slots:{default:[le]},$$scope:{ctx:ht}}}),E=new I({props:{title:"Basic Workflow Creation",local:"basic-workflow-creation",headingTag:"h3"}}),V=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),S=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),A=new I({props:{title:"Connecting Multiple Steps",local:"connecting-multiple-steps",headingTag:"h3"}}),X=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbml0aWFsJTIwZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyU3RlcCUyMDElMjBjb21wbGV0ZSUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMGludGVybWVkaWF0ZSUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Process initial data</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),q=new I({props:{title:"Loops and Branches",local:"loops-and-branches",headingTag:"h3"}}),L=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBpbnRlcm1lZGlhdGUlMjByZXN1bHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyRmluaXNoZWQlMjBwcm9jZXNzaW5nJTNBJTIwJTdCZXYuaW50ZXJtZWRpYXRlX3Jlc3VsdCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0RmaW5hbF9yZXN1bHQpJTBBJTBBJTBBdyUyMCUzRCUyME11bHRpU3RlcFdvcmtmbG93KHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCklMEFyZXN1bHQ=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),Y=new I({props:{title:"Drawing Workflows",local:"drawing-workflows",headingTag:"h3"}}),K=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwYXMlMjBkZWZpbmVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFkcmF3X2FsbF9wb3NzaWJsZV9mbG93cyh3JTJDJTIwJTIyZmxvdy5odG1sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># as defined in the previous section</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),tt=new I({props:{title:"State Management",local:"state-management",headingTag:"h3"}}),et=new g({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9yZSUyMHF1ZXJ5JTIwaW4lMjB0aGUlMjBjb250ZXh0JTBBJTIwJTIwJTIwJTIwYXdhaXQlMjBjdHguc2V0KCUyMnF1ZXJ5JTIyJTJDJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwc29tZXRoaW5nJTIwd2l0aCUyMGNvbnRleHQlMjBhbmQlMjBldmVudCUwQSUyMCUyMCUyMCUyMHZhbCUyMCUzRCUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJldHJpZXZlJTIwcXVlcnklMjBmcm9tJTIwdGhlJTIwY29udGV4dCUwQSUyMCUyMCUyMCUyMHF1ZXJ5JTIwJTNEJTIwYXdhaXQlMjBjdHguZ2V0KCUyMnF1ZXJ5JTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0R2YWwp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># store query in the context</span>
    <span class="hljs-keyword">await</span> ctx.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># do something with context and event</span>
    val = ...

    <span class="hljs-comment"># retrieve query from the context</span>
    query = <span class="hljs-keyword">await</span> ctx.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=val)`,wrap:!1}}),C=new Ys({props:{$$slots:{default:[ne]},$$scope:{ctx:ht}}}),at=new I({props:{title:"Automating workflows with Multi-Agent Workflows",local:"automating-workflows-with-multi-agent-workflows",headingTag:"h2"}}),ct=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># we can pass functions directly without FunctionTool -- the fn/docstring are parsed for the name/description</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Create the workflow</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Run the system</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),ut=new g({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># run the workflow with context</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># pull out and inspect the state</span>
state = <span class="hljs-keyword">await</span> ctx.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),yt=new ee({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/workflows.mdx"}}),{c(){r=o("meta"),c=n(),f=o("p"),j=n(),M(w.$$.fragment),J=n(),k=o("p"),k.textContent=Js,Ct=n(),B=o("p"),B.innerHTML=fs,gt=n(),v=o("p"),v.innerHTML=Ts,It=n(),Z=o("p"),Z.innerHTML=Us,kt=n(),_=o("ul"),_.innerHTML=bs,Bt=n(),G=o("p"),G.innerHTML=Cs,vt=n(),x=o("p"),x.textContent=gs,Zt=n(),M($.$$.fragment),_t=n(),M(b.$$.fragment),Gt=n(),M(E.$$.fragment),xt=n(),T=o("details"),jt=o("summary"),jt.textContent=Is,ys=ft(`
As introduced in the `),W=o("a"),W.textContent=ks,hs=ft(`, we can install the Workflow package with the following command:

	`),M(V.$$.fragment),$t=n(),Q=o("p"),Q.innerHTML=Bs,Et=n(),M(S.$$.fragment),Wt=n(),H=o("p"),H.innerHTML=vs,Vt=n(),M(A.$$.fragment),Qt=n(),F=o("p"),F.innerHTML=Zs,St=n(),M(X.$$.fragment),Ht=n(),R=o("p"),R.textContent=_s,At=n(),M(q.$$.fragment),Ft=n(),N=o("p"),N.textContent=Gs,Xt=n(),z=o("p"),z.innerHTML=xs,Rt=n(),M(L.$$.fragment),qt=n(),M(Y.$$.fragment),Nt=n(),P=o("p"),P.innerHTML=$s,zt=n(),M(K.$$.fragment),Lt=n(),D=o("p"),D.innerHTML=Es,Yt=n(),O=o("p"),O.textContent=Ws,Pt=n(),M(tt.$$.fragment),Kt=n(),st=o("p"),st.innerHTML=Vs,Dt=n(),M(et.$$.fragment),Ot=n(),lt=o("p"),lt.textContent=Qs,ts=n(),M(C.$$.fragment),ss=n(),nt=o("p"),nt.innerHTML=Ss,es=n(),M(at.$$.fragment),ls=n(),ot=o("p"),ot.innerHTML=Hs,ns=n(),pt=o("p"),pt.textContent=As,as=n(),it=o("ul"),it.innerHTML=Fs,os=n(),wt=o("p"),wt.textContent=Xs,ps=n(),M(ct.$$.fragment),is=n(),rt=o("p"),rt.textContent=Rs,ws=n(),Mt=o("p"),Mt.textContent=qs,cs=n(),M(ut.$$.fragment),rs=n(),mt=o("p"),mt.textContent=Ns,Ms=n(),dt=o("p"),dt.textContent=zs,us=n(),M(yt.$$.fragment),ms=n(),Ut=o("p"),this.h()},l(t){const s=se("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(e),c=a(t),f=p(t,"P",{}),js(f).forEach(e),j=a(t),u(w.$$.fragment,t),J=a(t),k=p(t,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1kssncf"&&(k.textContent=Js),Ct=a(t),B=p(t,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1ogtysv"&&(B.innerHTML=fs),gt=a(t),v=p(t,"P",{"data-svelte-h":!0}),i(v)!=="svelte-whmuha"&&(v.innerHTML=Ts),It=a(t),Z=p(t,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1ff8id8"&&(Z.innerHTML=Us),kt=a(t),_=p(t,"UL",{"data-svelte-h":!0}),i(_)!=="svelte-14kaj17"&&(_.innerHTML=bs),Bt=a(t),G=p(t,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1cddxrt"&&(G.innerHTML=Cs),vt=a(t),x=p(t,"P",{"data-svelte-h":!0}),i(x)!=="svelte-i0dazf"&&(x.textContent=gs),Zt=a(t),u($.$$.fragment,t),_t=a(t),u(b.$$.fragment,t),Gt=a(t),u(E.$$.fragment,t),xt=a(t),T=p(t,"DETAILS",{});var U=js(T);jt=p(U,"SUMMARY",{"data-svelte-h":!0}),i(jt)!=="svelte-1vs5sev"&&(jt.textContent=Is),ys=Tt(U,`
As introduced in the `),W=p(U,"A",{href:!0,"data-svelte-h":!0}),i(W)!=="svelte-16phayx"&&(W.textContent=ks),hs=Tt(U,`, we can install the Workflow package with the following command:

	`),u(V.$$.fragment,U),U.forEach(e),$t=a(t),Q=p(t,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1wc9dhn"&&(Q.innerHTML=Bs),Et=a(t),u(S.$$.fragment,t),Wt=a(t),H=p(t,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1x5qg2q"&&(H.innerHTML=vs),Vt=a(t),u(A.$$.fragment,t),Qt=a(t),F=p(t,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1gl1q10"&&(F.innerHTML=Zs),St=a(t),u(X.$$.fragment,t),Ht=a(t),R=p(t,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1ssz2vu"&&(R.textContent=_s),At=a(t),u(q.$$.fragment,t),Ft=a(t),N=p(t,"P",{"data-svelte-h":!0}),i(N)!=="svelte-7kgjbz"&&(N.textContent=Gs),Xt=a(t),z=p(t,"P",{"data-svelte-h":!0}),i(z)!=="svelte-19z56vc"&&(z.innerHTML=xs),Rt=a(t),u(L.$$.fragment,t),qt=a(t),u(Y.$$.fragment,t),Nt=a(t),P=p(t,"P",{"data-svelte-h":!0}),i(P)!=="svelte-gq4idr"&&(P.innerHTML=$s),zt=a(t),u(K.$$.fragment,t),Lt=a(t),D=p(t,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1j5vf43"&&(D.innerHTML=Es),Yt=a(t),O=p(t,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1nn9pf"&&(O.textContent=Ws),Pt=a(t),u(tt.$$.fragment,t),Kt=a(t),st=p(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1a42m1e"&&(st.innerHTML=Vs),Dt=a(t),u(et.$$.fragment,t),Ot=a(t),lt=p(t,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-ayh2hg"&&(lt.textContent=Qs),ts=a(t),u(C.$$.fragment,t),ss=a(t),nt=p(t,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-1f8yr21"&&(nt.innerHTML=Ss),es=a(t),u(at.$$.fragment,t),ls=a(t),ot=p(t,"P",{"data-svelte-h":!0}),i(ot)!=="svelte-64dk7s"&&(ot.innerHTML=Hs),ns=a(t),pt=p(t,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-1b9i7pj"&&(pt.textContent=As),as=a(t),it=p(t,"UL",{"data-svelte-h":!0}),i(it)!=="svelte-bg3pcb"&&(it.innerHTML=Fs),os=a(t),wt=p(t,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-193z3j0"&&(wt.textContent=Xs),ps=a(t),u(ct.$$.fragment,t),is=a(t),rt=p(t,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-y63ydc"&&(rt.textContent=Rs),ws=a(t),Mt=p(t,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-k4pfxh"&&(Mt.textContent=qs),cs=a(t),u(ut.$$.fragment,t),rs=a(t),mt=p(t,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-1rveoqn"&&(mt.textContent=Ns),Ms=a(t),dt=p(t,"P",{"data-svelte-h":!0}),i(dt)!=="svelte-u1alm2"&&(dt.textContent=zs),us=a(t),u(yt.$$.fragment,t),ms=a(t),Ut=p(t,"P",{}),js(Ut).forEach(e),this.h()},h(){Jt(r,"name","hf:doc:metadata"),Jt(r,"content",oe),Jt(W,"href","./llama-hub")},m(t,s){bt(document.head,r),l(t,c,s),l(t,f,s),l(t,j,s),m(w,t,s),l(t,J,s),l(t,k,s),l(t,Ct,s),l(t,B,s),l(t,gt,s),l(t,v,s),l(t,It,s),l(t,Z,s),l(t,kt,s),l(t,_,s),l(t,Bt,s),l(t,G,s),l(t,vt,s),l(t,x,s),l(t,Zt,s),m($,t,s),l(t,_t,s),m(b,t,s),l(t,Gt,s),m(E,t,s),l(t,xt,s),l(t,T,s),bt(T,jt),bt(T,ys),bt(T,W),bt(T,hs),m(V,T,null),l(t,$t,s),l(t,Q,s),l(t,Et,s),m(S,t,s),l(t,Wt,s),l(t,H,s),l(t,Vt,s),m(A,t,s),l(t,Qt,s),l(t,F,s),l(t,St,s),m(X,t,s),l(t,Ht,s),l(t,R,s),l(t,At,s),m(q,t,s),l(t,Ft,s),l(t,N,s),l(t,Xt,s),l(t,z,s),l(t,Rt,s),m(L,t,s),l(t,qt,s),m(Y,t,s),l(t,Nt,s),l(t,P,s),l(t,zt,s),m(K,t,s),l(t,Lt,s),l(t,D,s),l(t,Yt,s),l(t,O,s),l(t,Pt,s),m(tt,t,s),l(t,Kt,s),l(t,st,s),l(t,Dt,s),m(et,t,s),l(t,Ot,s),l(t,lt,s),l(t,ts,s),m(C,t,s),l(t,ss,s),l(t,nt,s),l(t,es,s),m(at,t,s),l(t,ls,s),l(t,ot,s),l(t,ns,s),l(t,pt,s),l(t,as,s),l(t,it,s),l(t,os,s),l(t,wt,s),l(t,ps,s),m(ct,t,s),l(t,is,s),l(t,rt,s),l(t,ws,s),l(t,Mt,s),l(t,cs,s),m(ut,t,s),l(t,rs,s),l(t,mt,s),l(t,Ms,s),l(t,dt,s),l(t,us,s),m(yt,t,s),l(t,ms,s),l(t,Ut,s),ds=!0},p(t,[s]){const U={};s&2&&(U.$$scope={dirty:s,ctx:t}),b.$set(U);const Ls={};s&2&&(Ls.$$scope={dirty:s,ctx:t}),C.$set(Ls)},i(t){ds||(d(w.$$.fragment,t),d($.$$.fragment,t),d(b.$$.fragment,t),d(E.$$.fragment,t),d(V.$$.fragment,t),d(S.$$.fragment,t),d(A.$$.fragment,t),d(X.$$.fragment,t),d(q.$$.fragment,t),d(L.$$.fragment,t),d(Y.$$.fragment,t),d(K.$$.fragment,t),d(tt.$$.fragment,t),d(et.$$.fragment,t),d(C.$$.fragment,t),d(at.$$.fragment,t),d(ct.$$.fragment,t),d(ut.$$.fragment,t),d(yt.$$.fragment,t),ds=!0)},o(t){y(w.$$.fragment,t),y($.$$.fragment,t),y(b.$$.fragment,t),y(E.$$.fragment,t),y(V.$$.fragment,t),y(S.$$.fragment,t),y(A.$$.fragment,t),y(X.$$.fragment,t),y(q.$$.fragment,t),y(L.$$.fragment,t),y(Y.$$.fragment,t),y(K.$$.fragment,t),y(tt.$$.fragment,t),y(et.$$.fragment,t),y(C.$$.fragment,t),y(at.$$.fragment,t),y(ct.$$.fragment,t),y(ut.$$.fragment,t),y(yt.$$.fragment,t),ds=!1},d(t){t&&(e(c),e(f),e(j),e(J),e(k),e(Ct),e(B),e(gt),e(v),e(It),e(Z),e(kt),e(_),e(Bt),e(G),e(vt),e(x),e(Zt),e(_t),e(Gt),e(xt),e(T),e($t),e(Q),e(Et),e(Wt),e(H),e(Vt),e(Qt),e(F),e(St),e(Ht),e(R),e(At),e(Ft),e(N),e(Xt),e(z),e(Rt),e(qt),e(Nt),e(P),e(zt),e(Lt),e(D),e(Yt),e(O),e(Pt),e(Kt),e(st),e(Dt),e(Ot),e(lt),e(ts),e(ss),e(nt),e(es),e(ls),e(ot),e(ns),e(pt),e(as),e(it),e(os),e(wt),e(ps),e(is),e(rt),e(ws),e(Mt),e(cs),e(rs),e(mt),e(Ms),e(dt),e(us),e(ms),e(Ut)),e(r),h(w,t),h($,t),h(b,t),h(E,t),h(V),h(S,t),h(A,t),h(X,t),h(q,t),h(L,t),h(Y,t),h(K,t),h(tt,t),h(et,t),h(C,t),h(at,t),h(ct,t),h(ut,t),h(yt,t)}}}const oe='{"title":"Creating agentic workflows in LlamaIndex","local":"creating-agentic-workflows-in-llamaindex","sections":[{"title":"Creating Workflows","local":"creating-workflows","sections":[{"title":"Basic Workflow Creation","local":"basic-workflow-creation","sections":[],"depth":3},{"title":"Connecting Multiple Steps","local":"connecting-multiple-steps","sections":[],"depth":3},{"title":"Loops and Branches","local":"loops-and-branches","sections":[],"depth":3},{"title":"Drawing Workflows","local":"drawing-workflows","sections":[],"depth":3},{"title":"State Management","local":"state-management","sections":[],"depth":3}],"depth":2},{"title":"Automating workflows with Multi-Agent Workflows","local":"automating-workflows-with-multi-agent-workflows","sections":[],"depth":2}],"depth":1}';function pe(ht){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class me extends Os{constructor(r){super(),te(this,r,pe,ae,Ks,{})}}export{me as component};
