import{s as z,n as Q,o as D}from"../chunks/scheduler.b108d059.js";import{S as O,i as L,g as d,s as n,r as f,A as q,h as w,f as t,c as a,j as S,u as U,x as N,k as P,y as K,a as s,v as _,d as T,t as g,w as C}from"../chunks/index.008de539.js";import{C as ll}from"../chunks/CodeBlock.3968c746.js";import{H as x,E as el}from"../chunks/EditOnGithub.d1c48e3d.js";function tl(F){let i,J,h,v,o,I,c,A,M,H="To calculate <code>CO₂ Emissions for Evaluation (kg)</code> value, we use the following function. You can try to reproduce it yourself:",W,p,$,m,E,r,Z="The <code>calculate_co2_emissions()</code> function estimates CO₂ emissions in kilograms for a given evaluation time in seconds, assuming the workload is running on 8 NVIDIA H100 SXM GPUs in Northern Virginia.",B,u,Y="Here’s how it works:",k,y,R='<li><p>If <code>total_evaluation_time_seconds</code> is <code>None</code> or non-positive, the function returns <code>-1</code>, indicating invalid input.</p> <blockquote><p>Each result file have a <code>total_evaluation_time_seconds</code> field.</p></blockquote></li> <li><p>Assumes 8 NVIDIA H100 SXM GPUs with a combined power usage of 5.6 kilowatts (kW), based on each GPU’s maximum 0.7 kW consumption (<a href="https://www.techpowerup.com/gpu-specs/h100-sxm5-80-gb.c3900" rel="nofollow">source</a>).</p></li> <li><p>Uses an average of 269.8 grams of CO₂ per kilowatt-hour (g CO₂/kWh) for electricity in Virginia, based on U.S. Energy Information Administration data (<a href="https://www.eia.gov/electricity/state/virginia/" rel="nofollow">source</a>).</p></li> <li><p>Converts the evaluation time from seconds to hours, then calculates total energy usage in kWh.</p></li> <li><p>Calculates emissions in grams by multiplying energy use (kWh) by the carbon intensity.</p></li> <li><p>Finally, divides the total grams by 1,000 to convert to kilograms.</p></li>',G,j,X,b,V;return o=new x({props:{title:"Emissions Calculation",local:"emissions-calculation",headingTag:"h1"}}),c=new x({props:{title:"Function for C02 calculation",local:"function-for-c02-calculation",headingTag:"h2"}}),p=new ll({props:{code:"ZGVmJTIwY2FsY3VsYXRlX2NvMl9lbWlzc2lvbnModG90YWxfZXZhbHVhdGlvbl90aW1lX3NlY29uZHMlM0ElMjBmbG9hdCUyMCU3QyUyME5vbmUpJTIwLSUzRSUyMGZsb2F0JTNBJTBBJTIwJTIwJTIwJTIwaWYlMjB0b3RhbF9ldmFsdWF0aW9uX3RpbWVfc2Vjb25kcyUyMGlzJTIwTm9uZSUyMG9yJTIwdG90YWxfZXZhbHVhdGlvbl90aW1lX3NlY29uZHMlMjAlM0MlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwLTElMEElMEElMjAlMjAlMjAlMjAlMjMlMjBQb3dlciUyMGNvbnN1bXB0aW9uJTIwZm9yJTIwOCUyMEgxMDAlMjBTWE0lMjBHUFVzJTIwaW4lMjBraWxvd2F0dHMlMjAoa1cpJTBBJTIwJTIwJTIwJTIwcG93ZXJfY29uc3VtcHRpb25fa1clMjAlM0QlMjA1LjYlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDYXJib24lMjBpbnRlbnNpdHklMjBpbiUyMGdyYW1zJTIwQ08lRTIlODIlODIlMjBwZXIlMjBrV2glMjBpbiUyMFZpcmdpbmlhJTBBJTIwJTIwJTIwJTIwY2FyYm9uX2ludGVuc2l0eV9nX3Blcl9rV2glMjAlM0QlMjAyNjkuOCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMENvbnZlcnQlMjBldmFsdWF0aW9uJTIwdGltZSUyMHRvJTIwaG91cnMlMEElMjAlMjAlMjAlMjB0b3RhbF9ldmFsdWF0aW9uX3RpbWVfaG91cnMlMjAlM0QlMjB0b3RhbF9ldmFsdWF0aW9uX3RpbWVfc2Vjb25kcyUyMCUyRiUyMDM2MDAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDYWxjdWxhdGUlMjBlbmVyZ3klMjBjb25zdW1wdGlvbiUyMGluJTIwa1doJTBBJTIwJTIwJTIwJTIwZW5lcmd5X2NvbnN1bXB0aW9uX2tXaCUyMCUzRCUyMHBvd2VyX2NvbnN1bXB0aW9uX2tXJTIwKiUyMHRvdGFsX2V2YWx1YXRpb25fdGltZV9ob3VycyUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMENhbGN1bGF0ZSUyMENPJUUyJTgyJTgyJTIwZW1pc3Npb25zJTIwaW4lMjBncmFtcyUwQSUyMCUyMCUyMCUyMGNvMl9lbWlzc2lvbnNfZyUyMCUzRCUyMGVuZXJneV9jb25zdW1wdGlvbl9rV2glMjAqJTIwY2FyYm9uX2ludGVuc2l0eV9nX3Blcl9rV2glMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDb252ZXJ0JTIwZ3JhbXMlMjB0byUyMGtpbG9ncmFtcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNvMl9lbWlzc2lvbnNfZyUyMCUyRiUyMDEwMDA=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_co2_emissions</span>(<span class="hljs-params">total_evaluation_time_seconds: <span class="hljs-built_in">float</span> | <span class="hljs-literal">None</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-keyword">if</span> total_evaluation_time_seconds <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> total_evaluation_time_seconds &lt;= <span class="hljs-number">0</span>:
        <span class="hljs-keyword">return</span> -<span class="hljs-number">1</span>

    <span class="hljs-comment"># Power consumption for 8 H100 SXM GPUs in kilowatts (kW)</span>
    power_consumption_kW = <span class="hljs-number">5.6</span>
    
    <span class="hljs-comment"># Carbon intensity in grams CO₂ per kWh in Virginia</span>
    carbon_intensity_g_per_kWh = <span class="hljs-number">269.8</span>
    
    <span class="hljs-comment"># Convert evaluation time to hours</span>
    total_evaluation_time_hours = total_evaluation_time_seconds / <span class="hljs-number">3600</span>
    
    <span class="hljs-comment"># Calculate energy consumption in kWh</span>
    energy_consumption_kWh = power_consumption_kW * total_evaluation_time_hours
    
    <span class="hljs-comment"># Calculate CO₂ emissions in grams</span>
    co2_emissions_g = energy_consumption_kWh * carbon_intensity_g_per_kWh
    
    <span class="hljs-comment"># Convert grams to kilograms</span>
    <span class="hljs-keyword">return</span> co2_emissions_g / <span class="hljs-number">1000</span>`,wrap:!1}}),m=new x({props:{title:"Explanation",local:"explanation",headingTag:"h2"}}),j=new el({props:{source:"https://github.com/huggingface/leaderboards/blob/main/docs/source/en/open_llm_leaderboard/emissions.md"}}),{c(){i=d("meta"),J=n(),h=d("p"),v=n(),f(o.$$.fragment),I=n(),f(c.$$.fragment),A=n(),M=d("p"),M.innerHTML=H,W=n(),f(p.$$.fragment),$=n(),f(m.$$.fragment),E=n(),r=d("p"),r.innerHTML=Z,B=n(),u=d("p"),u.textContent=Y,k=n(),y=d("ol"),y.innerHTML=R,G=n(),f(j.$$.fragment),X=n(),b=d("p"),this.h()},l(l){const e=q("svelte-u9bgzb",document.head);i=w(e,"META",{name:!0,content:!0}),e.forEach(t),J=a(l),h=w(l,"P",{}),S(h).forEach(t),v=a(l),U(o.$$.fragment,l),I=a(l),U(c.$$.fragment,l),A=a(l),M=w(l,"P",{"data-svelte-h":!0}),N(M)!=="svelte-wx33qa"&&(M.innerHTML=H),W=a(l),U(p.$$.fragment,l),$=a(l),U(m.$$.fragment,l),E=a(l),r=w(l,"P",{"data-svelte-h":!0}),N(r)!=="svelte-iq4iqw"&&(r.innerHTML=Z),B=a(l),u=w(l,"P",{"data-svelte-h":!0}),N(u)!=="svelte-zmv561"&&(u.textContent=Y),k=a(l),y=w(l,"OL",{"data-svelte-h":!0}),N(y)!=="svelte-xlbplb"&&(y.innerHTML=R),G=a(l),U(j.$$.fragment,l),X=a(l),b=w(l,"P",{}),S(b).forEach(t),this.h()},h(){P(i,"name","hf:doc:metadata"),P(i,"content",sl)},m(l,e){K(document.head,i),s(l,J,e),s(l,h,e),s(l,v,e),_(o,l,e),s(l,I,e),_(c,l,e),s(l,A,e),s(l,M,e),s(l,W,e),_(p,l,e),s(l,$,e),_(m,l,e),s(l,E,e),s(l,r,e),s(l,B,e),s(l,u,e),s(l,k,e),s(l,y,e),s(l,G,e),_(j,l,e),s(l,X,e),s(l,b,e),V=!0},p:Q,i(l){V||(T(o.$$.fragment,l),T(c.$$.fragment,l),T(p.$$.fragment,l),T(m.$$.fragment,l),T(j.$$.fragment,l),V=!0)},o(l){g(o.$$.fragment,l),g(c.$$.fragment,l),g(p.$$.fragment,l),g(m.$$.fragment,l),g(j.$$.fragment,l),V=!1},d(l){l&&(t(J),t(h),t(v),t(I),t(A),t(M),t(W),t($),t(E),t(r),t(B),t(u),t(k),t(y),t(G),t(X),t(b)),t(i),C(o,l),C(c,l),C(p,l),C(m,l),C(j,l)}}}const sl='{"title":"Emissions Calculation","local":"emissions-calculation","sections":[{"title":"Function for C02 calculation","local":"function-for-c02-calculation","sections":[],"depth":2},{"title":"Explanation","local":"explanation","sections":[],"depth":2}],"depth":1}';function nl(F){return D(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends O{constructor(i){super(),L(this,i,nl,tl,z,{})}}export{Ml as component};
