import{s as oo,n as ro,o as po}from"../chunks/scheduler.f7e1785c.js";import{S as ho,i as co,g as i,s as n,r as p,m as J,H as ea,A as mo,h as o,f as s,c as a,j as ia,u as h,x as r,n as j,E as ta,k as os,y as f,a as l,v as d,d as c,t as m,w as u}from"../chunks/index.9f8f0838.js";import{C as M}from"../chunks/CodeBlock.4baef5d7.js";import{H as w,E as uo}from"../chunks/getInferenceSnippets.ad8e59bc.js";function Mo(oa){let g,rs,as,ps,v,hs,I,ra=`In this section, we’ll cover how to use the <code>pipeline()</code> to leverage pre-trained models for speech recognition. In <a href="../chapter2/asr_pipeline">Unit 2</a>,
we introduced the <code>pipeline()</code> as an easy way of running speech recognition tasks, with all pre- and post-processing handled under-the-hood
and the flexibility to quickly experiment with any pre-trained checkpoint on the Hugging Face Hub. In this Unit, we’ll go a
level deeper and explore the different attributes of speech recognition models and how we can use them to tackle a range
of different tasks.`,ds,k,pa="As detailed in Unit 3, speech recognition model broadly fall into one of two categories:",cs,C,ha="<li>Connectionist Temporal Classification (CTC): <em>encoder-only</em> models with a linear classification (CTC) head on top</li> <li>Sequence-to-sequence (Seq2Seq): <em>encoder-decoder</em> models, with a cross-attention mechanism between the encoder and decoder</li>",ms,S,da=`Prior to 2022, CTC was the more popular of the two architectures, with encoder-only models such as Wav2Vec2, HuBERT and XLSR achieving
breakthoughs in the pre-training / fine-tuning paradigm for speech. Big corporations, such as Meta and Microsoft, pre-trained
the encoder on vast amounts of unlabelled audio data for many days or weeks. Users could then take a pre-trained checkpoint, and
fine-tune it with a CTC head on as little as <strong>10 minutes</strong> of labelled speech data to achieve strong performance on a downstream
speech recognition task.`,us,B,ca=`However, CTC models have their shortcomings. Appending a simple linear layer to an encoder gives a small, fast overall model, but can
be prone to phonetic spelling errors. We’ll demonstrate this for the Wav2Vec2 model below.`,Ms,x,ys,R,ma=`Let’s load a small excerpt of the <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> dataset to demonstrate
Wav2Vec2’s speech transcription capabilities:`,Ts,G,ws,E,ua="<strong>Output:</strong>",fs,H,gs,$,Ma="We can pick one of the 73 audio samples and inspect the audio sample as well as the transcription:",Us,V,bs,W,ya="<strong>Output:</strong>",Js,Z,js,F,Ta=`Alright! Christmas and roast beef, sounds great! 🎄 Having chosen a data sample, we now load a fine-tuned checkpoint into
the <code>pipeline()</code>. For this, we’ll use the official <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a> checkpoint fine-tuned on
100 hours of LibriSpeech data:`,vs,L,Is,_,wa=`Next, we’ll take an example from the dataset and pass its raw data to the pipeline. Since the <code>pipeline</code> <em>consumes</em> any
dictionary that we pass it (meaning it cannot be re-used), we’ll pass a copy of the data. This way, we can safely re-use
the same audio sample in the following examples:`,ks,N,Cs,Y,fa="<strong>Output:</strong>",Ss,Q,Bs,X,ga=`We can see that the Wav2Vec2 model does a pretty good job at transcribing this sample - at a first glance it looks generally correct.
Let’s put the target and prediction side-by-side and highlight the differences:`,xs,z,Rs,A,Ua="Comparing the target text to the predicted transcription, we can see that all words <em>sound</em> correct, but some are not spelled accurately. For example:",Gs,q,ba="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",Es,P,Ja=`This highlights the shortcoming of a CTC model. A CTC model is essentially an ‘acoustic-only’ model: it consists of an encoder
which forms hidden-state representations from the audio inputs, and a linear layer which maps the hidden-states to characters:`,Hs,O,ja=`This means that the system almost entirely bases its prediction on the acoustic input it was given (the phonetic sounds of the audio),
and so has a tendency to transcribe the audio in a phonetic way (e.g. <em>CHRISTMAUS</em>). It gives less importance to the
language modelling context of previous and successive letters, and so is prone to phonetic spelling errors. A more intelligent model
would identify that <em>CHRISTMAUS</em> is not a valid word in the English vocabulary, and correct it to <em>CHRISTMAS</em> when making
its predictions. We’re also missing two big features in our prediction - casing and punctuation - which limits the usefulness of
the model’s transcriptions to real-world applications.`,$s,D,Vs,K,va=`Cue Seq2Seq models! As outlined in Unit 3, Seq2Seq models are formed of an encoder and decoder linked via a cross-attention
mechanism. The encoder plays the same role as before, computing hidden-state representations of the audio inputs, while the decoder
plays the role of a <strong>language model</strong>. The decoder processes the entire sequence of hidden-state representations
from the encoder and generates the corresponding text transcriptions. With global context of the audio input, the decoder
is able to use language modelling context as it makes its predictions, correcting for spelling mistakes on-the-fly and thus
circumventing the issue of phonetic predictions.`,Ws,ee,Ia="There are two downsides to Seq2Seq models:",Zs,te,ka="<li>They are inherently slower at decoding, since the decoding process happens one step at a time, rather than all at once</li> <li>They are more data hungry, requiring significantly more training data to reach convergence</li>",Fs,se,Ca=`In particular, the need for large amounts of training data has been a bottleneck in the advancement of Seq2Seq architectures for
speech. Labelled speech data is difficult to come by, with the largest annotated datasets at the time clocking in at just
10,000 hours. This all changed in 2022 upon the release of <strong>Whisper</strong>. Whisper is a pre-trained model for speech recognition
published in <a href="https://openai.com/blog/whisper/" rel="nofollow">September 2022</a> by the authors Alec Radford et al. from OpenAI. Unlike
its CTC predecessors, which were pre-trained entirely on <strong>un-labelled</strong> audio data, Whisper is pre-trained on a vast quantity of
<strong>labelled</strong> audio-transcription data, 680,000 hours to be precise.`,Ls,le,Sa=`This is an order of magnitude more data than the un-labelled audio data used to train Wav2Vec 2.0 (60,000 hours). What is
more, 117,000 hours of this pre-training data is multilingual (or “non-English”) data. This results in checkpoints that can be applied to
over 96 languages, many of which are considered <em>low-resource</em>, meaning the language lacks a large corpus of data suitable for training.`,_s,ne,Ba=`When scaled to 680,000 hours of labelled pre-training data, Whisper models demonstrate a strong ability to generalise to
many datasets and domains. The pre-trained checkpoints achieve competitive results to state-of-the-art pipe systems, with
near 3% word error rate (WER) on the test-clean subset of LibriSpeech pipe and a new state-of-the-art on TED-LIUM with
4.7% WER (<em>c.f.</em> Table 8 of the <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,Ns,ae,xa=`Of particular importance is Whisper’s ability to handle long-form audio samples, its robustness to input noise and ability
to predict cased and punctuated transcriptions. This makes it a viable candidate for real-world speech recognition systems.`,Ys,ie,Ra=`The remainder of this section will show you how to use the pre-trained Whisper models for speech recognition using 🤗
Transformers. In many situations, the pre-trained Whisper checkpoints are extremely performant and give great results,
thus we encourage you to try using the pre-trained checkpoints as a first step to solving any speech recognition problem.
Through fine-tuning, the pre-trained checkpoints can be adapted for specific datasets and languages to further improve
upon these results. We’ll demonstrate how to do this in the upcoming subsection on <a href="fine-tuning">fine-tuning</a>.`,Qs,oe,Ga=`The Whisper checkpoints come in five configurations of varying model sizes. The smallest four are trained on either
English-only or multilingual data. The largest checkpoint is multilingual only. All nine of the pre-trained checkpoints
are available on the <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. The checkpoints are
summarised in the following table with links to the models on the Hub. “VRAM” denotes the required GPU memory to run the
model with the minimum batch size of 1. “Rel Speed” is the relative speed of a checkpoint compared to the largest model.
Based on this information, you can select a checkpoint that is best suited to your hardware.`,Xs,re,Ea='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v3" rel="nofollow">✓</a></td></tr></tbody>',zs,pe,As,he,Ha="In addition to Whisper, several other modern ASR models are available with different optimization focuses:",qs,de,$a='<thead><tr><th>Model</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Key Feature</th> <th>Languages</th> <th>Link</th></tr></thead> <tbody><tr><td>Moonshine Tiny</td> <td>27 M</td> <td>0.5</td> <td>5x faster for short audio</td> <td>English</td> <td><a href="https://huggingface.co/UsefulSensors/moonshine-tiny" rel="nofollow">✓</a></td></tr> <tr><td>Moonshine Base</td> <td>61 M</td> <td>1.0</td> <td>Edge-optimized</td> <td>English</td> <td><a href="https://huggingface.co/UsefulSensors/moonshine-base" rel="nofollow">✓</a></td></tr> <tr><td>Kyutai STT 1B</td> <td>1000 M</td> <td>3.0</td> <td>Real-time streaming</td> <td>English, French</td> <td><a href="https://huggingface.co/kyutai/stt-1b-en_fr" rel="nofollow">✓</a></td></tr> <tr><td>Kyutai STT 2.6B</td> <td>2600 M</td> <td>6.0</td> <td>Low-latency streaming</td> <td>English</td> <td><a href="https://huggingface.co/kyutai/stt-2.6b-en" rel="nofollow">✓</a></td></tr></tbody>',Ps,ce,Va=`Let’s load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which is of comparable size to the
Wav2Vec2 checkpoint we used previously. Preempting our move to multilingual speech recognition, we’ll load the multilingual
variant of the base checkpoint. We’ll also load the model on the GPU if available, or CPU otherwise. The <code>pipeline()</code> will
subsequently take care of moving all inputs / outputs from the CPU to the GPU as required:`,Os,me,Ds,ue,Wa=`Great! Now let’s transcribe the audio as before. The only change we make is passing an extra argument, <code>max_new_tokens</code>,
which tells the model the maximum number of tokens to generate when making its prediction:`,Ks,Me,el,ye,Za="<strong>Output:</strong>",tl,Te,sl,we,Fa=`Easy enough! The first thing you’ll notice is the presence of both casing and punctuation. Immediately this makes the
transcription easier to read compared to the un-cased and un-punctuated transcription from Wav2Vec2. Let’s put the transcription
side-by-side with the target:`,ll,fe,nl,ge,La=`Whisper has done a great job at correcting the phonetic errors we saw from Wav2Vec2 - both <em>Christmas</em> and <em>roast</em> are
spelled correctly. We see that the model still struggles with <em>SIMILES</em>, being incorrectly transcribed as <em>similarly</em>, but
this time the prediction is a valid word from the English vocabulary. Using a larger Whisper checkpoint can help further
reduce transcription errors, at the expense of requiring more compute and a longer transcription time.`,al,Ue,_a=`We’ve been promised a model that can handle 96 languages, so lets leave English speech recognition for now and go global 🌎!
The <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) dataset is
the multilingual equivalent of the LibriSpeech dataset, with labelled audio data in six languages. We’ll load one sample
from the Spanish split of the MLS dataset, making use of <em>streaming</em> mode so that we don’t have to download the entire dataset:`,il,be,ol,Je,Na="Again, we’ll inspect the text transcription and take a listen to the audio segment:",rl,je,pl,ve,Ya="<strong>Output:</strong>",hl,Ie,dl,ke,Qa=`This is the target text that we’re aiming for with our Whisper transcription. Although we now know that we can
probably do better this, since our model is also going to predict punctuation and casing, neither of which are present in the
reference. Let’s forward the audio sample to the pipeline to get our text prediction. One thing to note is that the
pipeline <em>consumes</em> the dictionary of audio inputs that we input, meaning the dictionary can’t be re-used. To circumvent
this, we’ll pass a <em>copy</em> of the audio sample, so that we can re-use the same audio sample in the proceeding code examples:`,cl,Ce,ml,Se,Xa="<strong>Output:</strong>",ul,Be,Ml,xe,za=`Great - this looks very similar to our reference text (arguably better since it has punctuation and casing!). You’ll notice
that we forwarded the <code>&quot;task&quot;</code> as a <em>generate key-word argument</em> (generate kwarg). Setting the <code>&quot;task&quot;</code> to <code>&quot;transcribe&quot;</code>
forces Whisper to perform the task of <em>speech recognition</em>, where the audio is transcribed in the same language that the
speech was spoken in. Whisper is also capable of performing the closely related task of <em>speech translation</em>, where the
audio in Spanish can be translated to text in English. To achieve this, we set the <code>&quot;task&quot;</code> to <code>&quot;translate&quot;</code>:`,yl,Re,Tl,Ge,Aa="<strong>Output:</strong>",wl,Ee,fl,He,qa=`Now that we know we can toggle between speech recognition and speech translation, we can pick our task depending on our
needs. Either we recognise from audio in language X to text in the same language X (e.g. Spanish audio to Spanish text),
or we translate from audio in any language X to text in English (e.g. Spanish audio to English text).`,gl,$e,Pa=`To read more about how the <code>&quot;task&quot;</code> argument is used to control the properties of the generated text, refer to the
<a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">model card</a> for the Whisper base model.`,Ul,Ve,bl,We,Oa=`So far, we’ve focussed on transcribing short audio samples of less than 30 seconds. We mentioned that one of the appeals
of Whisper was its ability to work on long audio samples. We’ll tackle this task here!`,Jl,Ze,Da=`Let’s create a long audio file by concatenating sequential samples from the MLS dataset. Since the MLS dataset is
curated by splitting long audiobook recordings into shorter segments, concatenating samples is one way of reconstructing
longer audiobook passages. Consequently, the resulting audio should be coherent across the entire sample.`,jl,Fe,Ka="We’ll set our target audio length to 5 minutes, and stop concatenating samples once we hit this value:",vl,Le,Il,_e,ei="<strong>Output:</strong>",kl,Ne,Cl,Ye,ti=`Alright! 5 minutes and 17 seconds of audio to transcribe. There are two problems with forwarding this long audio sample
directly to the model:`,Sl,Qe,si="<li>Whisper is inherently designed to work with 30 second samples: anything shorter than 30s is padded to 30s with silence, anything longer than 30s is truncated to 30s by cutting of the extra audio, so if we pass our audio directly we’ll only get the transcription for the first 30s</li> <li>Memory in a transformer network scales with the sequence length squared: doubling the input length quadruples the memory requirement, so passing super long audio files is bound to lead to an out-of-memory (OOM) error</li>",Bl,Xe,li=`The way long-form transcription works in 🤗 Transformers is by <em>chunking</em> the input audio into smaller, more manageable segments.
Each segment has a small amount of overlap with the previous one. This allows us to accurately stitch the segments back together
at the boundaries, since we can find the overlap between segments and merge the transcriptions accordingly:`,xl,U,ni='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',Rl,y,sa,Gl,lo='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',El,Hl,no='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',$l,ls,ai="stateless",la,Vl,ao='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Wl,Zl,io='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Fl,ns,ii="batch",na,b,oi="blog post",aa,Ll,ze,ri=`To activate long-form transcriptions, we have to add one additional argument when we call the pipeline. This argument,
<code>chunk_length_s</code>, controls the length of the chunked segments in seconds. For Whisper, 30 second chunks are optimal,
since this matches the input length Whisper expects.`,_l,Ae,pi=`To activate batching, we need to pass the argument <code>batch_size</code> to the pipeline. Putting it all together, we can transcribe the
long audio sample with chunking and batching as follows:`,Nl,qe,Yl,Pe,hi="<strong>Output:</strong>",Ql,Oe,Xl,De,di=`We won’t print the entire output here since it’s pretty long (312 words total)! On a 16GB V100 GPU, you can expect the above
line to take approximately 3.45 seconds to run, which is pretty good for a 317 second audio sample. On a CPU, expect
closer to 30 seconds.`,zl,Ke,ci=`Whisper is also able to predict segment-level <em>timestamps</em> for the audio data. These timestamps indicate the start and end
time for a short passage of audio, and are particularly useful for aligning a transcription with the input audio. Suppose
we want to provide closed captions for a video - we need these timestamps to know which part of the transcription corresponds
to a certain segment of video, in order to display the correct transcription for that time.`,Al,et,mi=`Activating timestamp prediction is straightforward, we just need to set the argument <code>return_timestamps=True</code>. Timestamps
are compatible with both the chunking and batching methods we used previously, so we can simply append the timestamp
argument to our previous call:`,ql,tt,Pl,st,ui="<strong>Output:</strong>",Ol,lt,Dl,nt,Mi="And voila! We have our predicted text as well as corresponding timestamps.",Kl,at,en,it,yi="While Whisper has been a game-changer for speech recognition, the field continues to evolve with new architectures designed to address specific limitations and use cases. Let’s explore two notable recent developments: <strong>Moonshine</strong> and <strong>Kyutai STT</strong>, which offer different approaches to improving upon Whisper’s capabilities.",tn,ot,sn,rt,Ti='<a href="https://huggingface.co/UsefulSensors/moonshine-base" rel="nofollow">Moonshine</a> is a family of speech recognition models developed by Useful Sensors specifically for <strong>edge computing</strong> and <strong>real-time applications</strong>. Released in October 2024, it represents a significant advancement in efficient ASR.',ln,pt,nn,ht,wi="<strong>1. Variable-Length Processing:</strong>",an,dt,fi="<li><strong>Whisper</strong>: Processes all audio in fixed 30-second chunks</li> <li><strong>Moonshine</strong>: Processes audio in variable-length segments, making it <strong>5x faster</strong> for shorter audio clips</li>",on,ct,gi="<strong>2. Model Size and Efficiency:</strong>",rn,mt,Ui="<li><strong>Moonshine Tiny</strong>: 27M parameters (~190MB)</li> <li><strong>Moonshine Base</strong>: 61M parameters (~400MB)</li> <li><strong>Whisper Small</strong>: 244M parameters (~2.3GB)</li>",pn,ut,bi="<strong>3. Training Data:</strong>",hn,Mt,Ji="<li><strong>Moonshine</strong>: 200,000 hours of audio data</li> <li><strong>Whisper</strong>: 680,000 hours of audio data</li>",dn,yt,ji="Let’s see Moonshine in action:",cn,Tt,mn,wt,vi="<strong>Performance Characteristics:</strong>",un,ft,Ii="<li><strong>Speed</strong>: 5x faster than Whisper for short audio clips</li> <li><strong>Accuracy</strong>: Comparable to Whisper on English ASR tasks</li> <li><strong>Memory</strong>: Significantly lower memory footprint</li> <li><strong>Language Support</strong>: English-only (currently)</li>",Mn,gt,yn,Ut,ki='<a href="https://huggingface.co/kyutai/stt-2.6b-en" rel="nofollow">Kyutai STT</a> represents a different approach to ASR, focusing on <strong>streaming capabilities</strong> and <strong>real-time transcription</strong>. Developed by Kyutai Labs, it’s based on the <strong>Delayed Streams Modeling (DSM)</strong> framework.',Tn,bt,wn,Jt,Ci="<strong>1. Streaming Architecture:</strong>",fn,jt,Si="<li><strong>Whisper</strong>: Offline processing, requires complete audio</li> <li><strong>Kyutai STT</strong>: Streaming processing, transcribes audio as it arrives</li>",gn,vt,Bi="<strong>2. Audio Tokenization:</strong>",Un,It,xi="<li><strong>Whisper</strong>: Log-mel spectrograms</li> <li><strong>Kyutai STT</strong>: Audio tokenized using <strong>Mimi codec</strong> at 12.5 Hz</li>",bn,kt,Ri="<strong>3. Model Variants:</strong>",Jn,Ct,Gi="<li><strong>kyutai/stt-1b-en_fr</strong>: 1B parameters, English/French, 0.5s delay</li> <li><strong>kyutai/stt-2.6b-en</strong>: 2.6B parameters, English-only, 2.5s delay</li>",jn,St,Ei="<strong>4. Training Scale:</strong>",vn,Bt,Hi="<li><strong>Kyutai STT</strong>: 2.5 million hours of public audio</li> <li><strong>Whisper</strong>: 680,000 hours of labeled audio</li>",In,xt,$i="Let’s try Kyutai STT (requires transformers >= 4.53.0):",kn,Rt,Cn,Gt,Vi="<strong>Performance Characteristics:</strong>",Sn,Et,Wi="<li><strong>Latency</strong>: Ultra-low latency (0.5-2.5s depending on model)</li> <li><strong>Robustness</strong>: Handles noisy conditions well</li> <li><strong>Audio Length</strong>: Can process up to 2 hours of audio</li> <li><strong>Punctuation</strong>: Includes capitalization and punctuation</li>",Bn,Ht,xn,$t,Zi="<thead><tr><th>Feature</th> <th>Whisper</th> <th>Moonshine</th> <th>Kyutai STT</th></tr></thead> <tbody><tr><td><strong>Processing</strong></td> <td>Fixed 30s chunks</td> <td>Variable-length</td> <td>Streaming</td></tr> <tr><td><strong>Best Use Case</strong></td> <td>General-purpose ASR</td> <td>Edge/Mobile devices</td> <td>Real-time applications</td></tr> <tr><td><strong>Model Size</strong></td> <td>39M - 1.5B params</td> <td>27M - 61M params</td> <td>1B - 2.6B params</td></tr> <tr><td><strong>Speed</strong></td> <td>Baseline</td> <td>5x faster (short audio)</td> <td>Ultra-low latency</td></tr> <tr><td><strong>Languages</strong></td> <td>96+ languages</td> <td>English only</td> <td>English (+French)</td></tr> <tr><td><strong>Punctuation</strong></td> <td>Yes</td> <td>Yes</td> <td>Yes</td></tr> <tr><td><strong>Memory Usage</strong></td> <td>High</td> <td>Low</td> <td>Medium</td></tr> <tr><td><strong>Training Data</strong></td> <td>680k hours</td> <td>200k hours</td> <td>2.5M hours</td></tr></tbody>",Rn,Vt,Gn,Wt,Fi="<strong>Choose Whisper when:</strong>",En,Zt,Li="<li>You need multilingual support (96+ languages)</li> <li>Accuracy is more important than speed</li> <li>You’re working with diverse audio domains</li> <li>You need translation capabilities</li>",Hn,Ft,_i="<strong>Choose Moonshine when:</strong>",$n,Lt,Ni="<li>You’re deploying on edge devices or mobile</li> <li>You need fast processing for short audio clips</li> <li>Memory efficiency is crucial</li> <li>You’re working with English-only content</li>",Vn,_t,Yi="<strong>Choose Kyutai STT when:</strong>",Wn,Nt,Qi="<li>You need real-time transcription</li> <li>Low latency is critical</li> <li>You’re building streaming applications</li> <li>You need robust handling of long audio files</li>",Zn,Yt,Xi="The choice between these models depends on your specific use case, computational constraints, and performance requirements. Each represents a different optimization point in the trade-off between accuracy, speed, memory usage, and feature set.",Fn,Qt,Ln,Xt,zi="The landscape of automatic speech recognition has expanded significantly beyond the groundbreaking Whisper model. While Whisper remains a strong pre-trained model for speech recognition and translation with support for 96+ languages, we now have specialized alternatives that excel in specific use cases.",_n,zt,Ai="<strong>Whisper</strong> excels at general-purpose ASR with multilingual support, high accuracy, and translation capabilities. However, it requires complete audio input and has higher computational requirements.",Nn,At,qi="<strong>Moonshine</strong> represents the next generation of efficient ASR, optimized for edge computing and real-time applications. With 5x faster processing for short audio clips and significantly lower memory usage, it’s ideal for mobile and embedded applications, though currently limited to English.",Yn,qt,Pi="<strong>Kyutai STT</strong> pushes the boundaries of real-time ASR with streaming capabilities and ultra-low latency. Its ability to transcribe audio as it arrives makes it perfect for live applications, though it’s currently limited to English and French.",Qn,Pt,Oi="Each model represents different optimization trade-offs:",Xn,Ot,Di="<li><strong>Whisper</strong>: Accuracy and multilingual support</li> <li><strong>Moonshine</strong>: Efficiency and edge deployment</li> <li><strong>Kyutai STT</strong>: Real-time processing and streaming</li>",zn,Dt,Ki="The choice depends on your specific requirements: language support, computational constraints, latency requirements, and deployment environment. All three models support punctuation and casing, and are available through the 🤗 Transformers library with <code>pipeline()</code> support for easy inference.",An,Kt,eo="For applications requiring fine-tuning, the same principles apply across all models.",qn,es,to='While transformers-based models offer excellent out-of-the-box performance, you might also want to explore <a href="alternative_implementations">alternative ASR implementations</a> that provide different optimization trade-offs, including whisper.cpp for edge deployment, faster-whisper for server applications, and platform-specific optimizations like MLX-Whisper for Apple Silicon.',Pn,ts,so="In the next section, we’ll explore dataset selection strategies that can be adapted for any of these ASR architectures.",On,ss,Dn,is,Kn;return v=new w({props:{title:"Pre-trained models for automatic speech recognition",local:"pre-trained-models-for-automatic-speech-recognition",headingTag:"h1"}}),x=new w({props:{title:"Probing CTC Models",local:"probing-ctc-models",headingTag:"h2"}}),G=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),H=new M({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),V=new M({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Z=new M({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),L=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),N=new M({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),Q=new M({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),z=new M({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),D=new w({props:{title:"Graduation to Seq2Seq",local:"graduation-to-seq2seq",headingTag:"h2"}}),pe=new w({props:{title:"Alternative ASR Models",local:"alternative-asr-models",headingTag:"h3"}}),me=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),Me=new M({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),Te=new M({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),fe=new M({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),be=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),je=new M({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Ie=new M({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),Ce=new M({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),Be=new M({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),Re=new M({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),Ee=new M({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),Ve=new w({props:{title:"Long-Form Transcription and Timestamps",local:"long-form-transcription-and-timestamps",headingTag:"h2"}}),Le=new M({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBmcm9tJTIwbWludXRlcyUyMHRvJTIwc2Vjb25kcyUyMCgqJTIwNjApJTIwdG8lMjBudW0lMjBzYW1wbGVzJTIwKColMjBzYW1wbGluZyUyMHJhdGUpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMHBpcGUuZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUwQXRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUyMCUzRCUyMHRhcmdldF9sZW5ndGhfaW5fbSUyMColMjA2MCUyMColMjBzYW1wbGluZ19yYXRlJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMG92ZXIlMjBvdXIlMjBzdHJlYW1pbmclMjBkYXRhc2V0JTJDJTIwY29uY2F0ZW5hdGluZyUyMHNhbXBsZXMlMjB1bnRpbCUyMHdlJTIwaGl0JTIwb3VyJTIwdGFyZ2V0JTBBbG9uZ19hdWRpbyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMHNhbXBsZSUyMGluJTIwZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMGxvbmdfYXVkaW8uZXh0ZW5kKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4obG9uZ19hdWRpbyklMjAlM0UlMjB0YXJnZXRfbGVuZ3RoX2luX3NhbXBsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUwQWxvbmdfYXVkaW8lMjAlM0QlMjBucC5hc2FycmF5KGxvbmdfYXVkaW8pJTBBJTBBJTIzJTIwaG93JTIwZGlkJTIwd2UlMjBkbyUzRiUwQXNlY29uZHMlMjAlM0QlMjBsZW4obG9uZ19hdWRpbyklMjAlMkYlMjAxNjAwMCUwQW1pbnV0ZXMlMkMlMjBzZWNvbmRzJTIwJTNEJTIwZGl2bW9kKHNlY29uZHMlMkMlMjA2MCklMEFwcmludChmJTIyTGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwJTdCbWludXRlcyU3RCUyMG1pbnV0ZXMlMjAlN0JzZWNvbmRzJTNBLjJmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># convert from minutes to seconds (* 60) to num samples (* sampling rate)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># iterate over our streaming dataset, concatenating samples until we hit our target</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># how did we do?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Ne=new M({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),qe=new M({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),Oe=new M({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),tt=new M({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),lt=new M({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),at=new w({props:{title:"Modern ASR Architectures: Beyond Whisper",local:"modern-asr-architectures-beyond-whisper",headingTag:"h2"}}),ot=new w({props:{title:"Moonshine: Efficient Edge Computing ASR",local:"moonshine-efficient-edge-computing-asr",headingTag:"h3"}}),pt=new w({props:{title:"Key Architecture Differences from Whisper:",local:"key-architecture-differences-from-whisper",headingTag:"h4"}}),Tt=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME1vb25zaGluZUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBwcm9jZXNzb3IlMjBhbmQlMjBtb2RlbCUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlVzZWZ1bFNlbnNvcnMlMkZtb29uc2hpbmUtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyME1vb25zaGluZUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyVXNlZnVsU2Vuc29ycyUyRm1vb25zaGluZS1iYXNlJTIyKSUwQSUwQSUyMyUyMExvYWQlMjBzYW1wbGUlMjBhdWRpbyUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTBBKSUwQXNhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjBQcm9jZXNzJTIwdGhlJTIwYXVkaW8lMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxlJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjB0cmFuc2NyaXB0aW9uJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9sZW5ndGglM0QyNTYpJTBBJTBBJTIzJTIwRGVjb2RlJTIwdGhlJTIwcmVzdWx0JTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEFwcmludChmJTIyTW9vbnNoaW5lJTNBJTIwJTdCdHJhbnNjcmlwdGlvbiU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MoonshineForConditionalGeneration
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load the processor and model</span>
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-base&quot;</span>)
model = MoonshineForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-base&quot;</span>)

<span class="hljs-comment"># Load sample audio</span>
dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
sample = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-comment"># Process the audio</span>
inputs = processor(
    sample[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
)

<span class="hljs-comment"># Generate transcription</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(**inputs, max_length=<span class="hljs-number">256</span>)

<span class="hljs-comment"># Decode the result</span>
transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Moonshine: <span class="hljs-subst">{transcription}</span>&quot;</span>)`,wrap:!1}}),gt=new w({props:{title:"Kyutai STT: Streaming ASR with Real-Time Capabilities",local:"kyutai-stt-streaming-asr-with-real-time-capabilities",headingTag:"h3"}}),bt=new w({props:{title:"Key Architecture Differences from Whisper:",local:"key-architecture-differences-from-whisper",headingTag:"h4"}}),Rt=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEt5dXRhaVNUVEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBwcm9jZXNzb3IlMjBhbmQlMjBtb2RlbCUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmt5dXRhaSUyRnN0dC0yLjZiLWVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwS3l1dGFpU1RURm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJreXV0YWklMkZzdHQtMi42Yi1lbiUyMiklMEElMEElMjMlMjBMb2FkJTIwc2FtcGxlJTIwYXVkaW8lMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUwQSklMEFzYW1wbGUlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTBBJTBBJTIzJTIwUHJvY2VzcyUyMHRoZSUyMGF1ZGlvJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwdHJhbnNjcmlwdGlvbiUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMjU2KSUwQSUwQSUyMyUyMERlY29kZSUyMHRoZSUyMHJlc3VsdCUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBcHJpbnQoZiUyMkt5dXRhaSUyMFNUVCUzQSUyMCU3QnRyYW5zY3JpcHRpb24lN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, KyutaiSTTForConditionalGeneration
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load the processor and model</span>
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;kyutai/stt-2.6b-en&quot;</span>)
model = KyutaiSTTForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kyutai/stt-2.6b-en&quot;</span>)

<span class="hljs-comment"># Load sample audio</span>
dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
sample = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-comment"># Process the audio</span>
inputs = processor(
    sample[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
)

<span class="hljs-comment"># Generate transcription</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(**inputs, max_length=<span class="hljs-number">256</span>)

<span class="hljs-comment"># Decode the result</span>
transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Kyutai STT: <span class="hljs-subst">{transcription}</span>&quot;</span>)`,wrap:!1}}),Ht=new w({props:{title:"Architecture Comparison Summary",local:"architecture-comparison-summary",headingTag:"h3"}}),Vt=new w({props:{title:"When to Choose Each Model:",local:"when-to-choose-each-model",headingTag:"h3"}}),Qt=new w({props:{title:"Summary",local:"summary",headingTag:"h2"}}),ss=new uo({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/asr_models.mdx"}}),{c(){g=i("meta"),rs=n(),as=i("p"),ps=n(),p(v.$$.fragment),hs=n(),I=i("p"),I.innerHTML=ra,ds=n(),k=i("p"),k.textContent=pa,cs=n(),C=i("ol"),C.innerHTML=ha,ms=n(),S=i("p"),S.innerHTML=da,us=n(),B=i("p"),B.textContent=ca,Ms=n(),p(x.$$.fragment),ys=n(),R=i("p"),R.innerHTML=ma,Ts=n(),p(G.$$.fragment),ws=n(),E=i("p"),E.innerHTML=ua,fs=n(),p(H.$$.fragment),gs=n(),$=i("p"),$.textContent=Ma,Us=n(),p(V.$$.fragment),bs=n(),W=i("p"),W.innerHTML=ya,Js=n(),p(Z.$$.fragment),js=n(),F=i("p"),F.innerHTML=Ta,vs=n(),p(L.$$.fragment),Is=n(),_=i("p"),_.innerHTML=wa,ks=n(),p(N.$$.fragment),Cs=n(),Y=i("p"),Y.innerHTML=fa,Ss=n(),p(Q.$$.fragment),Bs=n(),X=i("p"),X.textContent=ga,xs=n(),p(z.$$.fragment),Rs=n(),A=i("p"),A.innerHTML=Ua,Gs=n(),q=i("ul"),q.innerHTML=ba,Es=n(),P=i("p"),P.textContent=Ja,Hs=n(),O=i("p"),O.innerHTML=ja,$s=n(),p(D.$$.fragment),Vs=n(),K=i("p"),K.innerHTML=va,Ws=n(),ee=i("p"),ee.textContent=Ia,Zs=n(),te=i("ol"),te.innerHTML=ka,Fs=n(),se=i("p"),se.innerHTML=Ca,Ls=n(),le=i("p"),le.innerHTML=Sa,_s=n(),ne=i("p"),ne.innerHTML=Ba,Ns=n(),ae=i("p"),ae.textContent=xa,Ys=n(),ie=i("p"),ie.innerHTML=Ra,Qs=n(),oe=i("p"),oe.innerHTML=Ga,Xs=n(),re=i("table"),re.innerHTML=Ea,zs=n(),p(pe.$$.fragment),As=n(),he=i("p"),he.textContent=Ha,qs=n(),de=i("table"),de.innerHTML=$a,Ps=n(),ce=i("p"),ce.innerHTML=Va,Os=n(),p(me.$$.fragment),Ds=n(),ue=i("p"),ue.innerHTML=Wa,Ks=n(),p(Me.$$.fragment),el=n(),ye=i("p"),ye.innerHTML=Za,tl=n(),p(Te.$$.fragment),sl=n(),we=i("p"),we.textContent=Fa,ll=n(),p(fe.$$.fragment),nl=n(),ge=i("p"),ge.innerHTML=La,al=n(),Ue=i("p"),Ue.innerHTML=_a,il=n(),p(be.$$.fragment),ol=n(),Je=i("p"),Je.textContent=Na,rl=n(),p(je.$$.fragment),pl=n(),ve=i("p"),ve.innerHTML=Ya,hl=n(),p(Ie.$$.fragment),dl=n(),ke=i("p"),ke.innerHTML=Qa,cl=n(),p(Ce.$$.fragment),ml=n(),Se=i("p"),Se.innerHTML=Xa,ul=n(),p(Be.$$.fragment),Ml=n(),xe=i("p"),xe.innerHTML=za,yl=n(),p(Re.$$.fragment),Tl=n(),Ge=i("p"),Ge.innerHTML=Aa,wl=n(),p(Ee.$$.fragment),fl=n(),He=i("p"),He.textContent=qa,gl=n(),$e=i("p"),$e.innerHTML=Pa,Ul=n(),p(Ve.$$.fragment),bl=n(),We=i("p"),We.textContent=Oa,Jl=n(),Ze=i("p"),Ze.textContent=Da,jl=n(),Fe=i("p"),Fe.textContent=Ka,vl=n(),p(Le.$$.fragment),Il=n(),_e=i("p"),_e.innerHTML=ei,kl=n(),p(Ne.$$.fragment),Cl=n(),Ye=i("p"),Ye.textContent=ti,Sl=n(),Qe=i("ol"),Qe.innerHTML=si,Bl=n(),Xe=i("p"),Xe.innerHTML=li,xl=n(),U=i("div"),U.innerHTML=ni,Rl=n(),y=i("p"),sa=J("The advantage of chunking the samples is that we don’t need the result of chunk"),Gl=new ea(!1),El=J(` to transcribe the subsequent
chunk`),Hl=new ea(!1),$l=J(`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),ls=i("strong"),ls.textContent=ai,la=J(", so we can even do chunk"),Vl=new ea(!1),Wl=J(`
at the same time as chunk`),Zl=new ea(!1),Fl=J("! This allows us to "),ns=i("em"),ns.textContent=ii,na=J(` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),b=i("a"),b.textContent=oi,aa=J("."),Ll=n(),ze=i("p"),ze.innerHTML=ri,_l=n(),Ae=i("p"),Ae.innerHTML=pi,Nl=n(),p(qe.$$.fragment),Yl=n(),Pe=i("p"),Pe.innerHTML=hi,Ql=n(),p(Oe.$$.fragment),Xl=n(),De=i("p"),De.textContent=di,zl=n(),Ke=i("p"),Ke.innerHTML=ci,Al=n(),et=i("p"),et.innerHTML=mi,ql=n(),p(tt.$$.fragment),Pl=n(),st=i("p"),st.innerHTML=ui,Ol=n(),p(lt.$$.fragment),Dl=n(),nt=i("p"),nt.textContent=Mi,Kl=n(),p(at.$$.fragment),en=n(),it=i("p"),it.innerHTML=yi,tn=n(),p(ot.$$.fragment),sn=n(),rt=i("p"),rt.innerHTML=Ti,ln=n(),p(pt.$$.fragment),nn=n(),ht=i("p"),ht.innerHTML=wi,an=n(),dt=i("ul"),dt.innerHTML=fi,on=n(),ct=i("p"),ct.innerHTML=gi,rn=n(),mt=i("ul"),mt.innerHTML=Ui,pn=n(),ut=i("p"),ut.innerHTML=bi,hn=n(),Mt=i("ul"),Mt.innerHTML=Ji,dn=n(),yt=i("p"),yt.textContent=ji,cn=n(),p(Tt.$$.fragment),mn=n(),wt=i("p"),wt.innerHTML=vi,un=n(),ft=i("ul"),ft.innerHTML=Ii,Mn=n(),p(gt.$$.fragment),yn=n(),Ut=i("p"),Ut.innerHTML=ki,Tn=n(),p(bt.$$.fragment),wn=n(),Jt=i("p"),Jt.innerHTML=Ci,fn=n(),jt=i("ul"),jt.innerHTML=Si,gn=n(),vt=i("p"),vt.innerHTML=Bi,Un=n(),It=i("ul"),It.innerHTML=xi,bn=n(),kt=i("p"),kt.innerHTML=Ri,Jn=n(),Ct=i("ul"),Ct.innerHTML=Gi,jn=n(),St=i("p"),St.innerHTML=Ei,vn=n(),Bt=i("ul"),Bt.innerHTML=Hi,In=n(),xt=i("p"),xt.textContent=$i,kn=n(),p(Rt.$$.fragment),Cn=n(),Gt=i("p"),Gt.innerHTML=Vi,Sn=n(),Et=i("ul"),Et.innerHTML=Wi,Bn=n(),p(Ht.$$.fragment),xn=n(),$t=i("table"),$t.innerHTML=Zi,Rn=n(),p(Vt.$$.fragment),Gn=n(),Wt=i("p"),Wt.innerHTML=Fi,En=n(),Zt=i("ul"),Zt.innerHTML=Li,Hn=n(),Ft=i("p"),Ft.innerHTML=_i,$n=n(),Lt=i("ul"),Lt.innerHTML=Ni,Vn=n(),_t=i("p"),_t.innerHTML=Yi,Wn=n(),Nt=i("ul"),Nt.innerHTML=Qi,Zn=n(),Yt=i("p"),Yt.textContent=Xi,Fn=n(),p(Qt.$$.fragment),Ln=n(),Xt=i("p"),Xt.textContent=zi,_n=n(),zt=i("p"),zt.innerHTML=Ai,Nn=n(),At=i("p"),At.innerHTML=qi,Yn=n(),qt=i("p"),qt.innerHTML=Pi,Qn=n(),Pt=i("p"),Pt.textContent=Oi,Xn=n(),Ot=i("ul"),Ot.innerHTML=Di,zn=n(),Dt=i("p"),Dt.innerHTML=Ki,An=n(),Kt=i("p"),Kt.textContent=eo,qn=n(),es=i("p"),es.innerHTML=to,Pn=n(),ts=i("p"),ts.textContent=so,On=n(),p(ss.$$.fragment),Dn=n(),is=i("p"),this.h()},l(e){const t=mo("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),rs=a(e),as=o(e,"P",{}),ia(as).forEach(s),ps=a(e),h(v.$$.fragment,e),hs=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-qu6ugv"&&(I.innerHTML=ra),ds=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1lo7cg7"&&(k.textContent=pa),cs=a(e),C=o(e,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-4r9go5"&&(C.innerHTML=ha),ms=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-7bh989"&&(S.innerHTML=da),us=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1y7wlps"&&(B.textContent=ca),Ms=a(e),h(x.$$.fragment,e),ys=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-6p3rx4"&&(R.innerHTML=ma),Ts=a(e),h(G.$$.fragment,e),ws=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1mvdyro"&&(E.innerHTML=ua),fs=a(e),h(H.$$.fragment,e),gs=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1f14qa5"&&($.textContent=Ma),Us=a(e),h(V.$$.fragment,e),bs=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1mvdyro"&&(W.innerHTML=ya),Js=a(e),h(Z.$$.fragment,e),js=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-zwb92k"&&(F.innerHTML=Ta),vs=a(e),h(L.$$.fragment,e),Is=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-160y70r"&&(_.innerHTML=wa),ks=a(e),h(N.$$.fragment,e),Cs=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=fa),Ss=a(e),h(Q.$$.fragment,e),Bs=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1n1tyml"&&(X.textContent=ga),xs=a(e),h(z.$$.fragment,e),Rs=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-fjdtrw"&&(A.innerHTML=Ua),Gs=a(e),q=o(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-11mc7qy"&&(q.innerHTML=ba),Es=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-18hr596"&&(P.textContent=Ja),Hs=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-mwf7be"&&(O.innerHTML=ja),$s=a(e),h(D.$$.fragment,e),Vs=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-55oy83"&&(K.innerHTML=va),Ws=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-969zyv"&&(ee.textContent=Ia),Zs=a(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-osi73t"&&(te.innerHTML=ka),Fs=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1bn96on"&&(se.innerHTML=Ca),Ls=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-zyrdbw"&&(le.innerHTML=Sa),_s=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-em8jox"&&(ne.innerHTML=Ba),Ns=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1g5392c"&&(ae.textContent=xa),Ys=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-5h4os6"&&(ie.innerHTML=Ra),Qs=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-uy2cuy"&&(oe.innerHTML=Ga),Xs=a(e),re=o(e,"TABLE",{"data-svelte-h":!0}),r(re)!=="svelte-15414sk"&&(re.innerHTML=Ea),zs=a(e),h(pe.$$.fragment,e),As=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-nzixym"&&(he.textContent=Ha),qs=a(e),de=o(e,"TABLE",{"data-svelte-h":!0}),r(de)!=="svelte-1dfp2by"&&(de.innerHTML=$a),Ps=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-efpzbz"&&(ce.innerHTML=Va),Os=a(e),h(me.$$.fragment,e),Ds=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1feq0tt"&&(ue.innerHTML=Wa),Ks=a(e),h(Me.$$.fragment,e),el=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1mvdyro"&&(ye.innerHTML=Za),tl=a(e),h(Te.$$.fragment,e),sl=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-18db65j"&&(we.textContent=Fa),ll=a(e),h(fe.$$.fragment,e),nl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-mm1pes"&&(ge.innerHTML=La),al=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1ol57p5"&&(Ue.innerHTML=_a),il=a(e),h(be.$$.fragment,e),ol=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1f9nh4o"&&(Je.textContent=Na),rl=a(e),h(je.$$.fragment,e),pl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1mvdyro"&&(ve.innerHTML=Ya),hl=a(e),h(Ie.$$.fragment,e),dl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-75q7fw"&&(ke.innerHTML=Qa),cl=a(e),h(Ce.$$.fragment,e),ml=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1mvdyro"&&(Se.innerHTML=Xa),ul=a(e),h(Be.$$.fragment,e),Ml=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-uzlabu"&&(xe.innerHTML=za),yl=a(e),h(Re.$$.fragment,e),Tl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1mvdyro"&&(Ge.innerHTML=Aa),wl=a(e),h(Ee.$$.fragment,e),fl=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-joibr"&&(He.textContent=qa),gl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1aecqb1"&&($e.innerHTML=Pa),Ul=a(e),h(Ve.$$.fragment,e),bl=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-ad6ien"&&(We.textContent=Oa),Jl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1atykwj"&&(Ze.textContent=Da),jl=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-8fkb86"&&(Fe.textContent=Ka),vl=a(e),h(Le.$$.fragment,e),Il=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1mvdyro"&&(_e.innerHTML=ei),kl=a(e),h(Ne.$$.fragment,e),Cl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-rlobar"&&(Ye.textContent=ti),Sl=a(e),Qe=o(e,"OL",{"data-svelte-h":!0}),r(Qe)!=="svelte-xow7at"&&(Qe.innerHTML=si),Bl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1kl6cah"&&(Xe.innerHTML=li),xl=a(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-dbmn5s"&&(U.innerHTML=ni),Rl=a(e),y=o(e,"P",{});var T=ia(y);sa=j(T,"The advantage of chunking the samples is that we don’t need the result of chunk"),Gl=ta(T,!1),El=j(T,` to transcribe the subsequent
chunk`),Hl=ta(T,!1),$l=j(T,`. The stitching is done after we have transcribed all the chunks at the chunk boundaries, so it doesn’t
matter which order we transcribe chunks in. The algorithm is entirely `),ls=o(T,"STRONG",{"data-svelte-h":!0}),r(ls)!=="svelte-1caf2ri"&&(ls.textContent=ai),la=j(T,", so we can even do chunk"),Vl=ta(T,!1),Wl=j(T,`
at the same time as chunk`),Zl=ta(T,!1),Fl=j(T,"! This allows us to "),ns=o(T,"EM",{"data-svelte-h":!0}),r(ns)!=="svelte-1swb9sm"&&(ns.textContent=ii),na=j(T,` the chunks and run them through the model in parallel,
providing a large computational speed-up compared to transcribing them sequentially. To read more about chunking in 🤗 Transformers,
you can refer to this `),b=o(T,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(b)!=="svelte-1d46t8h"&&(b.textContent=oi),aa=j(T,"."),T.forEach(s),Ll=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1bfrg8c"&&(ze.innerHTML=ri),_l=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1ldveni"&&(Ae.innerHTML=pi),Nl=a(e),h(qe.$$.fragment,e),Yl=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1mvdyro"&&(Pe.innerHTML=hi),Ql=a(e),h(Oe.$$.fragment,e),Xl=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-wy7qyj"&&(De.textContent=di),zl=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1pdqzp1"&&(Ke.innerHTML=ci),Al=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1kodbk1"&&(et.innerHTML=mi),ql=a(e),h(tt.$$.fragment,e),Pl=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1mvdyro"&&(st.innerHTML=ui),Ol=a(e),h(lt.$$.fragment,e),Dl=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-7n3xc4"&&(nt.textContent=Mi),Kl=a(e),h(at.$$.fragment,e),en=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-m1xa7l"&&(it.innerHTML=yi),tn=a(e),h(ot.$$.fragment,e),sn=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-bejyj8"&&(rt.innerHTML=Ti),ln=a(e),h(pt.$$.fragment,e),nn=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-lxct6w"&&(ht.innerHTML=wi),an=a(e),dt=o(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-tw4w42"&&(dt.innerHTML=fi),on=a(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-11ep667"&&(ct.innerHTML=gi),rn=a(e),mt=o(e,"UL",{"data-svelte-h":!0}),r(mt)!=="svelte-1o6iy4w"&&(mt.innerHTML=Ui),pn=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-wuizc2"&&(ut.innerHTML=bi),hn=a(e),Mt=o(e,"UL",{"data-svelte-h":!0}),r(Mt)!=="svelte-173zl7i"&&(Mt.innerHTML=Ji),dn=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-ealia3"&&(yt.textContent=ji),cn=a(e),h(Tt.$$.fragment,e),mn=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-j0fknz"&&(wt.innerHTML=vi),un=a(e),ft=o(e,"UL",{"data-svelte-h":!0}),r(ft)!=="svelte-1e67w46"&&(ft.innerHTML=Ii),Mn=a(e),h(gt.$$.fragment,e),yn=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1khwjjz"&&(Ut.innerHTML=ki),Tn=a(e),h(bt.$$.fragment,e),wn=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-bihym9"&&(Jt.innerHTML=Ci),fn=a(e),jt=o(e,"UL",{"data-svelte-h":!0}),r(jt)!=="svelte-5qta8j"&&(jt.innerHTML=Si),gn=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1pakabu"&&(vt.innerHTML=Bi),Un=a(e),It=o(e,"UL",{"data-svelte-h":!0}),r(It)!=="svelte-17rjszy"&&(It.innerHTML=xi),bn=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-hit09p"&&(kt.innerHTML=Ri),Jn=a(e),Ct=o(e,"UL",{"data-svelte-h":!0}),r(Ct)!=="svelte-jv8emf"&&(Ct.innerHTML=Gi),jn=a(e),St=o(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1xuklmd"&&(St.innerHTML=Ei),vn=a(e),Bt=o(e,"UL",{"data-svelte-h":!0}),r(Bt)!=="svelte-w3bdph"&&(Bt.innerHTML=Hi),In=a(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-64hiiq"&&(xt.textContent=$i),kn=a(e),h(Rt.$$.fragment,e),Cn=a(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-j0fknz"&&(Gt.innerHTML=Vi),Sn=a(e),Et=o(e,"UL",{"data-svelte-h":!0}),r(Et)!=="svelte-1gxo9bq"&&(Et.innerHTML=Wi),Bn=a(e),h(Ht.$$.fragment,e),xn=a(e),$t=o(e,"TABLE",{"data-svelte-h":!0}),r($t)!=="svelte-16inhrf"&&($t.innerHTML=Zi),Rn=a(e),h(Vt.$$.fragment,e),Gn=a(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-rvmlfy"&&(Wt.innerHTML=Fi),En=a(e),Zt=o(e,"UL",{"data-svelte-h":!0}),r(Zt)!=="svelte-11kejhm"&&(Zt.innerHTML=Li),Hn=a(e),Ft=o(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-19awltc"&&(Ft.innerHTML=_i),$n=a(e),Lt=o(e,"UL",{"data-svelte-h":!0}),r(Lt)!=="svelte-1yjj7pl"&&(Lt.innerHTML=Ni),Vn=a(e),_t=o(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1cr6avy"&&(_t.innerHTML=Yi),Wn=a(e),Nt=o(e,"UL",{"data-svelte-h":!0}),r(Nt)!=="svelte-3qlqvl"&&(Nt.innerHTML=Qi),Zn=a(e),Yt=o(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-xhje04"&&(Yt.textContent=Xi),Fn=a(e),h(Qt.$$.fragment,e),Ln=a(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1mhxr5y"&&(Xt.textContent=zi),_n=a(e),zt=o(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-2hump4"&&(zt.innerHTML=Ai),Nn=a(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-tvoepx"&&(At.innerHTML=qi),Yn=a(e),qt=o(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-14srx2d"&&(qt.innerHTML=Pi),Qn=a(e),Pt=o(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-a6jdou"&&(Pt.textContent=Oi),Xn=a(e),Ot=o(e,"UL",{"data-svelte-h":!0}),r(Ot)!=="svelte-pjnoc2"&&(Ot.innerHTML=Di),zn=a(e),Dt=o(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-13uymxs"&&(Dt.innerHTML=Ki),An=a(e),Kt=o(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-49ta2u"&&(Kt.textContent=eo),qn=a(e),es=o(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-12g4vw9"&&(es.innerHTML=to),Pn=a(e),ts=o(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-eyyn3r"&&(ts.textContent=so),On=a(e),h(ss.$$.fragment,e),Dn=a(e),is=o(e,"P",{}),ia(is).forEach(s),this.h()},h(){os(g,"name","hf:doc:metadata"),os(g,"content",yo),os(U,"class","flex justify-center"),Gl.a=El,Hl.a=$l,Vl.a=Wl,Zl.a=Fl,os(b,"href","https://huggingface.co/blog/asr-chunking"),os(b,"rel","nofollow")},m(e,t){f(document.head,g),l(e,rs,t),l(e,as,t),l(e,ps,t),d(v,e,t),l(e,hs,t),l(e,I,t),l(e,ds,t),l(e,k,t),l(e,cs,t),l(e,C,t),l(e,ms,t),l(e,S,t),l(e,us,t),l(e,B,t),l(e,Ms,t),d(x,e,t),l(e,ys,t),l(e,R,t),l(e,Ts,t),d(G,e,t),l(e,ws,t),l(e,E,t),l(e,fs,t),d(H,e,t),l(e,gs,t),l(e,$,t),l(e,Us,t),d(V,e,t),l(e,bs,t),l(e,W,t),l(e,Js,t),d(Z,e,t),l(e,js,t),l(e,F,t),l(e,vs,t),d(L,e,t),l(e,Is,t),l(e,_,t),l(e,ks,t),d(N,e,t),l(e,Cs,t),l(e,Y,t),l(e,Ss,t),d(Q,e,t),l(e,Bs,t),l(e,X,t),l(e,xs,t),d(z,e,t),l(e,Rs,t),l(e,A,t),l(e,Gs,t),l(e,q,t),l(e,Es,t),l(e,P,t),l(e,Hs,t),l(e,O,t),l(e,$s,t),d(D,e,t),l(e,Vs,t),l(e,K,t),l(e,Ws,t),l(e,ee,t),l(e,Zs,t),l(e,te,t),l(e,Fs,t),l(e,se,t),l(e,Ls,t),l(e,le,t),l(e,_s,t),l(e,ne,t),l(e,Ns,t),l(e,ae,t),l(e,Ys,t),l(e,ie,t),l(e,Qs,t),l(e,oe,t),l(e,Xs,t),l(e,re,t),l(e,zs,t),d(pe,e,t),l(e,As,t),l(e,he,t),l(e,qs,t),l(e,de,t),l(e,Ps,t),l(e,ce,t),l(e,Os,t),d(me,e,t),l(e,Ds,t),l(e,ue,t),l(e,Ks,t),d(Me,e,t),l(e,el,t),l(e,ye,t),l(e,tl,t),d(Te,e,t),l(e,sl,t),l(e,we,t),l(e,ll,t),d(fe,e,t),l(e,nl,t),l(e,ge,t),l(e,al,t),l(e,Ue,t),l(e,il,t),d(be,e,t),l(e,ol,t),l(e,Je,t),l(e,rl,t),d(je,e,t),l(e,pl,t),l(e,ve,t),l(e,hl,t),d(Ie,e,t),l(e,dl,t),l(e,ke,t),l(e,cl,t),d(Ce,e,t),l(e,ml,t),l(e,Se,t),l(e,ul,t),d(Be,e,t),l(e,Ml,t),l(e,xe,t),l(e,yl,t),d(Re,e,t),l(e,Tl,t),l(e,Ge,t),l(e,wl,t),d(Ee,e,t),l(e,fl,t),l(e,He,t),l(e,gl,t),l(e,$e,t),l(e,Ul,t),d(Ve,e,t),l(e,bl,t),l(e,We,t),l(e,Jl,t),l(e,Ze,t),l(e,jl,t),l(e,Fe,t),l(e,vl,t),d(Le,e,t),l(e,Il,t),l(e,_e,t),l(e,kl,t),d(Ne,e,t),l(e,Cl,t),l(e,Ye,t),l(e,Sl,t),l(e,Qe,t),l(e,Bl,t),l(e,Xe,t),l(e,xl,t),l(e,U,t),l(e,Rl,t),l(e,y,t),f(y,sa),Gl.m(lo,y),f(y,El),Hl.m(no,y),f(y,$l),f(y,ls),f(y,la),Vl.m(ao,y),f(y,Wl),Zl.m(io,y),f(y,Fl),f(y,ns),f(y,na),f(y,b),f(y,aa),l(e,Ll,t),l(e,ze,t),l(e,_l,t),l(e,Ae,t),l(e,Nl,t),d(qe,e,t),l(e,Yl,t),l(e,Pe,t),l(e,Ql,t),d(Oe,e,t),l(e,Xl,t),l(e,De,t),l(e,zl,t),l(e,Ke,t),l(e,Al,t),l(e,et,t),l(e,ql,t),d(tt,e,t),l(e,Pl,t),l(e,st,t),l(e,Ol,t),d(lt,e,t),l(e,Dl,t),l(e,nt,t),l(e,Kl,t),d(at,e,t),l(e,en,t),l(e,it,t),l(e,tn,t),d(ot,e,t),l(e,sn,t),l(e,rt,t),l(e,ln,t),d(pt,e,t),l(e,nn,t),l(e,ht,t),l(e,an,t),l(e,dt,t),l(e,on,t),l(e,ct,t),l(e,rn,t),l(e,mt,t),l(e,pn,t),l(e,ut,t),l(e,hn,t),l(e,Mt,t),l(e,dn,t),l(e,yt,t),l(e,cn,t),d(Tt,e,t),l(e,mn,t),l(e,wt,t),l(e,un,t),l(e,ft,t),l(e,Mn,t),d(gt,e,t),l(e,yn,t),l(e,Ut,t),l(e,Tn,t),d(bt,e,t),l(e,wn,t),l(e,Jt,t),l(e,fn,t),l(e,jt,t),l(e,gn,t),l(e,vt,t),l(e,Un,t),l(e,It,t),l(e,bn,t),l(e,kt,t),l(e,Jn,t),l(e,Ct,t),l(e,jn,t),l(e,St,t),l(e,vn,t),l(e,Bt,t),l(e,In,t),l(e,xt,t),l(e,kn,t),d(Rt,e,t),l(e,Cn,t),l(e,Gt,t),l(e,Sn,t),l(e,Et,t),l(e,Bn,t),d(Ht,e,t),l(e,xn,t),l(e,$t,t),l(e,Rn,t),d(Vt,e,t),l(e,Gn,t),l(e,Wt,t),l(e,En,t),l(e,Zt,t),l(e,Hn,t),l(e,Ft,t),l(e,$n,t),l(e,Lt,t),l(e,Vn,t),l(e,_t,t),l(e,Wn,t),l(e,Nt,t),l(e,Zn,t),l(e,Yt,t),l(e,Fn,t),d(Qt,e,t),l(e,Ln,t),l(e,Xt,t),l(e,_n,t),l(e,zt,t),l(e,Nn,t),l(e,At,t),l(e,Yn,t),l(e,qt,t),l(e,Qn,t),l(e,Pt,t),l(e,Xn,t),l(e,Ot,t),l(e,zn,t),l(e,Dt,t),l(e,An,t),l(e,Kt,t),l(e,qn,t),l(e,es,t),l(e,Pn,t),l(e,ts,t),l(e,On,t),d(ss,e,t),l(e,Dn,t),l(e,is,t),Kn=!0},p:ro,i(e){Kn||(c(v.$$.fragment,e),c(x.$$.fragment,e),c(G.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(Z.$$.fragment,e),c(L.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(Me.$$.fragment,e),c(Te.$$.fragment,e),c(fe.$$.fragment,e),c(be.$$.fragment,e),c(je.$$.fragment,e),c(Ie.$$.fragment,e),c(Ce.$$.fragment,e),c(Be.$$.fragment,e),c(Re.$$.fragment,e),c(Ee.$$.fragment,e),c(Ve.$$.fragment,e),c(Le.$$.fragment,e),c(Ne.$$.fragment,e),c(qe.$$.fragment,e),c(Oe.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(at.$$.fragment,e),c(ot.$$.fragment,e),c(pt.$$.fragment,e),c(Tt.$$.fragment,e),c(gt.$$.fragment,e),c(bt.$$.fragment,e),c(Rt.$$.fragment,e),c(Ht.$$.fragment,e),c(Vt.$$.fragment,e),c(Qt.$$.fragment,e),c(ss.$$.fragment,e),Kn=!0)},o(e){m(v.$$.fragment,e),m(x.$$.fragment,e),m(G.$$.fragment,e),m(H.$$.fragment,e),m(V.$$.fragment,e),m(Z.$$.fragment,e),m(L.$$.fragment,e),m(N.$$.fragment,e),m(Q.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(Ce.$$.fragment,e),m(Be.$$.fragment,e),m(Re.$$.fragment,e),m(Ee.$$.fragment,e),m(Ve.$$.fragment,e),m(Le.$$.fragment,e),m(Ne.$$.fragment,e),m(qe.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(lt.$$.fragment,e),m(at.$$.fragment,e),m(ot.$$.fragment,e),m(pt.$$.fragment,e),m(Tt.$$.fragment,e),m(gt.$$.fragment,e),m(bt.$$.fragment,e),m(Rt.$$.fragment,e),m(Ht.$$.fragment,e),m(Vt.$$.fragment,e),m(Qt.$$.fragment,e),m(ss.$$.fragment,e),Kn=!1},d(e){e&&(s(rs),s(as),s(ps),s(hs),s(I),s(ds),s(k),s(cs),s(C),s(ms),s(S),s(us),s(B),s(Ms),s(ys),s(R),s(Ts),s(ws),s(E),s(fs),s(gs),s($),s(Us),s(bs),s(W),s(Js),s(js),s(F),s(vs),s(Is),s(_),s(ks),s(Cs),s(Y),s(Ss),s(Bs),s(X),s(xs),s(Rs),s(A),s(Gs),s(q),s(Es),s(P),s(Hs),s(O),s($s),s(Vs),s(K),s(Ws),s(ee),s(Zs),s(te),s(Fs),s(se),s(Ls),s(le),s(_s),s(ne),s(Ns),s(ae),s(Ys),s(ie),s(Qs),s(oe),s(Xs),s(re),s(zs),s(As),s(he),s(qs),s(de),s(Ps),s(ce),s(Os),s(Ds),s(ue),s(Ks),s(el),s(ye),s(tl),s(sl),s(we),s(ll),s(nl),s(ge),s(al),s(Ue),s(il),s(ol),s(Je),s(rl),s(pl),s(ve),s(hl),s(dl),s(ke),s(cl),s(ml),s(Se),s(ul),s(Ml),s(xe),s(yl),s(Tl),s(Ge),s(wl),s(fl),s(He),s(gl),s($e),s(Ul),s(bl),s(We),s(Jl),s(Ze),s(jl),s(Fe),s(vl),s(Il),s(_e),s(kl),s(Cl),s(Ye),s(Sl),s(Qe),s(Bl),s(Xe),s(xl),s(U),s(Rl),s(y),s(Ll),s(ze),s(_l),s(Ae),s(Nl),s(Yl),s(Pe),s(Ql),s(Xl),s(De),s(zl),s(Ke),s(Al),s(et),s(ql),s(Pl),s(st),s(Ol),s(Dl),s(nt),s(Kl),s(en),s(it),s(tn),s(sn),s(rt),s(ln),s(nn),s(ht),s(an),s(dt),s(on),s(ct),s(rn),s(mt),s(pn),s(ut),s(hn),s(Mt),s(dn),s(yt),s(cn),s(mn),s(wt),s(un),s(ft),s(Mn),s(yn),s(Ut),s(Tn),s(wn),s(Jt),s(fn),s(jt),s(gn),s(vt),s(Un),s(It),s(bn),s(kt),s(Jn),s(Ct),s(jn),s(St),s(vn),s(Bt),s(In),s(xt),s(kn),s(Cn),s(Gt),s(Sn),s(Et),s(Bn),s(xn),s($t),s(Rn),s(Gn),s(Wt),s(En),s(Zt),s(Hn),s(Ft),s($n),s(Lt),s(Vn),s(_t),s(Wn),s(Nt),s(Zn),s(Yt),s(Fn),s(Ln),s(Xt),s(_n),s(zt),s(Nn),s(At),s(Yn),s(qt),s(Qn),s(Pt),s(Xn),s(Ot),s(zn),s(Dt),s(An),s(Kt),s(qn),s(es),s(Pn),s(ts),s(On),s(Dn),s(is)),s(g),u(v,e),u(x,e),u(G,e),u(H,e),u(V,e),u(Z,e),u(L,e),u(N,e),u(Q,e),u(z,e),u(D,e),u(pe,e),u(me,e),u(Me,e),u(Te,e),u(fe,e),u(be,e),u(je,e),u(Ie,e),u(Ce,e),u(Be,e),u(Re,e),u(Ee,e),u(Ve,e),u(Le,e),u(Ne,e),u(qe,e),u(Oe,e),u(tt,e),u(lt,e),u(at,e),u(ot,e),u(pt,e),u(Tt,e),u(gt,e),u(bt,e),u(Rt,e),u(Ht,e),u(Vt,e),u(Qt,e),u(ss,e)}}}const yo='{"title":"Pre-trained models for automatic speech recognition","local":"pre-trained-models-for-automatic-speech-recognition","sections":[{"title":"Probing CTC Models","local":"probing-ctc-models","sections":[],"depth":2},{"title":"Graduation to Seq2Seq","local":"graduation-to-seq2seq","sections":[{"title":"Alternative ASR Models","local":"alternative-asr-models","sections":[],"depth":3}],"depth":2},{"title":"Long-Form Transcription and Timestamps","local":"long-form-transcription-and-timestamps","sections":[],"depth":2},{"title":"Modern ASR Architectures: Beyond Whisper","local":"modern-asr-architectures-beyond-whisper","sections":[{"title":"Moonshine: Efficient Edge Computing ASR","local":"moonshine-efficient-edge-computing-asr","sections":[{"title":"Key Architecture Differences from Whisper:","local":"key-architecture-differences-from-whisper","sections":[],"depth":4}],"depth":3},{"title":"Kyutai STT: Streaming ASR with Real-Time Capabilities","local":"kyutai-stt-streaming-asr-with-real-time-capabilities","sections":[{"title":"Key Architecture Differences from Whisper:","local":"key-architecture-differences-from-whisper","sections":[],"depth":4}],"depth":3},{"title":"Architecture Comparison Summary","local":"architecture-comparison-summary","sections":[],"depth":3},{"title":"When to Choose Each Model:","local":"when-to-choose-each-model","sections":[],"depth":3}],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function To(oa){return po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bo extends ho{constructor(g){super(),co(this,g,To,Mo,oo,{})}}export{bo as component};
