import{s as ul,n as Tl,o as Ul}from"../chunks/scheduler.f7e1785c.js";import{S as jl,i as $l,g as d,s as n,r as i,A as bl,h as y,f as s,c as a,j as gl,u as p,x as w,k as Jl,y as Il,a as l,v as r,d as m,t as o,w as M}from"../chunks/index.9f8f0838.js";import{C as h}from"../chunks/CodeBlock.4baef5d7.js";import{H as c,E as Cl}from"../chunks/getInferenceSnippets.ad8e59bc.js";function Wl(Ns){let f,lt,tt,nt,g,at,J,Hs="While 🤗 Transformers provides an excellent foundation for ASR with models like Whisper, Moonshine, and Kyutai STT, the broader ASR ecosystem offers numerous optimized implementations that can significantly improve performance, reduce resource usage, and enable deployment in resource-constrained environments.",it,u,_s="This section explores high-performance alternatives, platform-specific optimizations, and specialized architectures that complement the transformers ecosystem while offering different trade-offs for speed, memory usage, and deployment scenarios.",pt,T,rt,U,mt,j,Fs='<a href="https://github.com/ggml-org/whisper.cpp" rel="nofollow">whisper.cpp</a> is a C++ port of OpenAI’s Whisper model that delivers exceptional performance improvements, particularly for CPU-based inference and edge deployment.',ot,$,Mt,b,Ys="<li><strong>10x faster inference</strong> on CPU compared to the original Python implementation</li> <li><strong>Extremely low memory usage</strong> - runs on devices with limited RAM</li> <li><strong>Cross-platform support</strong> - works on macOS, Linux, Windows, iOS, Android</li> <li><strong>Apple Silicon optimization</strong> - leverages Apple Neural Engine (ANE) for 3x additional speedup</li> <li><strong>No dependencies</strong> - self-contained C++ implementation</li>",ct,I,dt,C,qs="<li><strong>Memory</strong>: Lowest VRAM consumption among all implementations</li> <li><strong>Speed</strong>: Excellent CPU performance, especially on Apple Silicon</li> <li><strong>Accuracy</strong>: ~75% transcription accuracy (some degradation from original)</li> <li><strong>Deployment</strong>: Ideal for edge devices and mobile applications</li>",yt,W,wt,B,ht,G,ft,Z,gt,v,Jt,A,Ls="<li><strong>Edge computing</strong> and IoT devices</li> <li><strong>Mobile applications</strong> requiring offline processing</li> <li><strong>CPU-only environments</strong> without GPU acceleration</li> <li><strong>Memory-constrained</strong> systems</li> <li><strong>Real-time processing</strong> on low-power hardware</li>",ut,k,Tt,S,Ps='<a href="https://github.com/SYSTRAN/faster-whisper" rel="nofollow">faster-whisper</a> is a reimplementation of Whisper using CTranslate2, delivering significant performance improvements while maintaining full accuracy.',Ut,V,jt,z,Ks="<li><strong>4x faster inference</strong> than the original Whisper</li> <li><strong>Same accuracy</strong> as the original implementation</li> <li><strong>Lower memory usage</strong> through optimized memory management</li> <li><strong>GPU and CPU support</strong> with automatic optimization</li> <li><strong>Streaming support</strong> for real-time applications</li>",$t,x,bt,X,Ds="<li><strong>Speed</strong>: 4x faster than original, excellent GPU utilization</li> <li><strong>Memory</strong>: Reduced memory footprint</li> <li><strong>Accuracy</strong>: 100% accuracy preservation</li> <li><strong>Deployment</strong>: Ideal for server-based applications</li>",It,R,Ct,E,Wt,Q,Bt,N,Gt,H,Zt,_,vt,F,Os='<a href="https://github.com/Vaibhavs10/insanely-fast-whisper" rel="nofollow">insanely-fast-whisper</a> pushes the boundaries of inference speed, achieving up to 9x faster processing than faster-whisper for real-time applications.',At,Y,kt,q,el="<li><strong>9x faster</strong> than faster-whisper</li> <li><strong>Real-time transcription</strong> capabilities</li> <li><strong>Optimized for streaming</strong> applications</li> <li><strong>Flash Attention</strong> integration for efficiency</li> <li><strong>Batch processing</strong> support</li>",St,L,Vt,P,tl="<li><strong>Speed</strong>: Fastest among all implementations</li> <li><strong>Memory</strong>: Higher memory usage due to optimizations</li> <li><strong>Accuracy</strong>: Slight accuracy trade-off for speed</li> <li><strong>Deployment</strong>: Perfect for real-time applications</li>",zt,K,xt,D,Xt,O,Rt,ee,Et,te,Qt,se,sl='<a href="https://github.com/ml-explore/mlx-examples/tree/main/whisper" rel="nofollow">MLX-Whisper</a> leverages Apple’s MLX framework for optimal performance on Apple Silicon devices.',Nt,le,Ht,ne,ll="<li><strong>50% faster</strong> than standard Whisper on Apple Silicon</li> <li><strong>Native Metal performance</strong> shading language integration</li> <li><strong>Memory efficient</strong> unified memory architecture utilization</li> <li><strong>Energy efficient</strong> for mobile and laptop deployment</li>",_t,ae,Ft,ie,nl="<li><strong>Speed</strong>: 2x faster on Apple Silicon devices</li> <li><strong>Memory</strong>: Optimized for unified memory architecture</li> <li><strong>Accuracy</strong>: Full accuracy preservation</li> <li><strong>Deployment</strong>: Exclusive to Apple Silicon (M1, M2, M3, M4)</li>",Yt,pe,qt,re,Lt,me,Pt,oe,Kt,Me,Dt,ce,Ot,de,al='<a href="https://github.com/argmaxinc/WhisperKit" rel="nofollow">WhisperKit</a> provides production-ready on-device speech recognition for Apple platforms.',es,ye,ts,we,il="<li><strong>On-device processing</strong> with privacy guarantees</li> <li><strong>Core ML integration</strong> for optimal performance</li> <li><strong>iOS and macOS support</strong> with native Swift APIs</li> <li><strong>Real-time transcription</strong> capabilities</li>",ss,he,ls,fe,ns,ge,pl="Conformer architectures offer competitive performance with significantly lower computational requirements, making them ideal for edge deployment.",as,Je,is,ue,rl="<li><strong>5.26x faster than real-time</strong> on wearable devices</li> <li><strong>Low power consumption</strong> optimized for battery-powered devices</li> <li><strong>Depthwise separable convolutions</strong> reducing computational complexity from 32.8% to 4.0%</li> <li><strong>Streaming capabilities</strong> for real-time applications</li>",ps,Te,rs,Ue,ml="<thead><tr><th>Implementation</th> <th>Speed vs Original</th> <th>Memory Usage</th> <th>Platform Focus</th> <th>Accuracy vs Original</th> <th>Use Case</th></tr></thead> <tbody><tr><td><strong>whisper.cpp</strong></td> <td>10x faster (CPU)</td> <td>Very Low</td> <td>Cross-platform</td> <td>~75%</td> <td>Edge/Mobile</td></tr> <tr><td><strong>faster-whisper</strong></td> <td>4x faster</td> <td>Low</td> <td>GPU/CPU</td> <td>100%</td> <td>Server/Cloud</td></tr> <tr><td><strong>insanely-fast-whisper</strong></td> <td>36x faster</td> <td>High</td> <td>GPU</td> <td>~95%</td> <td>Real-time</td></tr> <tr><td><strong>MLX-Whisper</strong></td> <td>2x faster</td> <td>Medium</td> <td>Apple Silicon</td> <td>100%</td> <td>Apple devices</td></tr> <tr><td><strong>Lightning-Whisper-MLX</strong></td> <td>10x faster</td> <td>Medium</td> <td>Apple Silicon</td> <td>~98%</td> <td>Apple real-time</td></tr> <tr><td><strong>WhisperKit</strong></td> <td>3x faster</td> <td>Low</td> <td>Apple Mobile</td> <td>100%</td> <td>iOS/macOS apps</td></tr> <tr><td><strong>Conformer</strong></td> <td>5.26x realtime</td> <td>Very Low</td> <td>Edge devices</td> <td>Competitive</td> <td>Wearables</td></tr></tbody>",ms,je,os,$e,Ms,be,cs,Ie,ol="<li><strong>Minimum RAM</strong>: 1GB for small models, 4GB for medium models</li> <li><strong>CPU</strong>: ARM Cortex-A78 or equivalent x86_64</li> <li><strong>GPU</strong>: Optional but recommended for real-time applications</li> <li><strong>Storage</strong>: 200MB for tiny models, 1GB for small models</li>",ds,Ce,ys,We,Ml="<li><strong>Model Quantization</strong>: Reduce model size by 75% with minimal accuracy loss</li> <li><strong>Pruning</strong>: Remove unnecessary parameters for faster inference</li> <li><strong>Knowledge Distillation</strong>: Create smaller models that maintain accuracy</li> <li><strong>Memory Mapping</strong>: Load models efficiently on resource-constrained devices</li>",ws,Be,hs,Ge,fs,Ze,gs,ve,Js,Ae,us,ke,Ts,Se,Us,Ve,js,ze,$s,xe,bs,Xe,Is,Re,Cs,Ee,Ws,Qe,Bs,Ne,Gs,He,cl="<li><strong>For Production Servers</strong>: Use <strong>faster-whisper</strong> for the best balance of speed and accuracy</li> <li><strong>For Real-Time Applications</strong>: Use <strong>insanely-fast-whisper</strong> or <strong>Lightning-Whisper-MLX</strong></li> <li><strong>For Edge/Mobile Devices</strong>: Use <strong>whisper.cpp</strong> or <strong>WhisperKit</strong> (Apple)</li> <li><strong>For Apple Silicon</strong>: Use <strong>MLX-Whisper</strong> or <strong>Lightning-Whisper-MLX</strong></li> <li><strong>For Wearables</strong>: Use <strong>Conformer-based</strong> models</li>",Zs,_e,vs,Fe,dl="<li><strong>Model Selection</strong>: Choose the smallest model that meets your accuracy requirements</li> <li><strong>Quantization</strong>: Use INT8 quantization for 4x speed improvement with minimal accuracy loss</li> <li><strong>Batching</strong>: Process multiple audio files simultaneously when possible</li> <li><strong>Memory Management</strong>: Use memory mapping for large models on resource-constrained devices</li> <li><strong>Preprocessing</strong>: Ensure audio is properly formatted (16kHz, mono) before transcription</li>",As,Ye,ks,qe,Ss,Le,Vs,Pe,yl="The ASR ecosystem extends far beyond transformers-based implementations, offering specialized solutions for different deployment scenarios:",zs,Ke,wl="<li><strong>whisper.cpp</strong> excels in edge computing and mobile deployment with minimal resource usage</li> <li><strong>faster-whisper</strong> provides the best balance of speed and accuracy for server deployments</li> <li><strong>insanely-fast-whisper</strong> enables real-time applications with ultra-low latency</li> <li><strong>MLX-Whisper</strong> optimizes performance specifically for Apple Silicon devices</li> <li><strong>Conformer-based models</strong> offer efficient alternatives for resource-constrained environments</li>",xs,De,hl="The choice between these implementations depends on your specific requirements for speed, accuracy, memory usage, and deployment environment. Many applications benefit from using multiple implementations in combination, leveraging the strengths of each for different components of the speech recognition pipeline.",Xs,Oe,fl="In the next section, we’ll explore how to evaluate these different implementations and choose the right metrics for your specific use case.",Rs,et,Es,st,Qs;return g=new c({props:{title:"Alternative ASR Implementations: Beyond Transformers",local:"alternative-asr-implementations-beyond-transformers",headingTag:"h1"}}),T=new c({props:{title:"High-Performance Optimized Implementations",local:"high-performance-optimized-implementations",headingTag:"h2"}}),U=new c({props:{title:"whisper.cpp: C++ Port for Maximum Efficiency",local:"whispercpp-c-port-for-maximum-efficiency",headingTag:"h3"}}),$=new c({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),I=new c({props:{title:"Performance Characteristics:",local:"performance-characteristics",headingTag:"h4"}}),W=new c({props:{title:"Installation and Usage:",local:"installation-and-usage",headingTag:"h4"}}),B=new h({props:{code:"JTIzJTIwQ2xvbmUlMjBhbmQlMjBidWlsZCUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGZ2dtbC1vcmclMkZ3aGlzcGVyLmNwcC5naXQlMEFjZCUyMHdoaXNwZXIuY3BwJTBBbWFrZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwYSUyMG1vZGVsJTIwKGUuZy4lMkMlMjBzbWFsbCUyMG1vZGVsKSUwQWJhc2glMjAuJTJGbW9kZWxzJTJGZG93bmxvYWQtZ2dtbC1tb2RlbC5zaCUyMHNtYWxsJTBBJTBBJTIzJTIwQmFzaWMlMjB1c2FnZSUwQS4lMkZtYWluJTIwLW0lMjBtb2RlbHMlMkZnZ21sLXNtYWxsLmJpbiUyMC1mJTIwYXVkaW8ud2F2",highlighted:`<span class="hljs-comment"># Clone and build</span>
git <span class="hljs-built_in">clone</span> https://github.com/ggml-org/whisper.cpp.git
<span class="hljs-built_in">cd</span> whisper.cpp
make

<span class="hljs-comment"># Download a model (e.g., small model)</span>
bash ./models/download-ggml-model.sh small

<span class="hljs-comment"># Basic usage</span>
./main -m models/ggml-small.bin -f audio.wav`,wrap:!1}}),G=new c({props:{title:"Python Bindings:",local:"python-bindings",headingTag:"h4"}}),Z=new h({props:{code:"aW1wb3J0JTIwd2hpc3Blcl9jcHAlMEElMEElMjMlMjBJbml0aWFsaXplJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMHdoaXNwZXJfY3BwLldoaXNwZXIoJTIybW9kZWxzJTJGZ2dtbC1zbWFsbC5iaW4lMjIpJTBBJTBBJTIzJTIwVHJhbnNjcmliZSUyMGF1ZGlvJTBBcmVzdWx0JTIwJTNEJTIwbW9kZWwudHJhbnNjcmliZSglMjJhdWRpby53YXYlMjIpJTBBcHJpbnQoZiUyMlRyYW5zY3JpcHRpb24lM0ElMjAlN0JyZXN1bHQlNUIndGV4dCclNUQlN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> whisper_cpp

<span class="hljs-comment"># Initialize model</span>
model = whisper_cpp.Whisper(<span class="hljs-string">&quot;models/ggml-small.bin&quot;</span>)

<span class="hljs-comment"># Transcribe audio</span>
result = model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Transcription: <span class="hljs-subst">{result[<span class="hljs-string">&#x27;text&#x27;</span>]}</span>&quot;</span>)`,wrap:!1}}),v=new c({props:{title:"When to Use whisper.cpp:",local:"when-to-use-whispercpp",headingTag:"h4"}}),k=new c({props:{title:"faster-whisper: GPU-Accelerated Performance",local:"faster-whisper-gpu-accelerated-performance",headingTag:"h3"}}),V=new c({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),x=new c({props:{title:"Performance Characteristics:",local:"performance-characteristics",headingTag:"h4"}}),R=new c({props:{title:"Installation and Usage:",local:"installation-and-usage",headingTag:"h4"}}),E=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGZhc3Rlci13aGlzcGVy",highlighted:"pip install faster-whisper",wrap:!1}}),Q=new h({props:{code:"ZnJvbSUyMGZhc3Rlcl93aGlzcGVyJTIwaW1wb3J0JTIwV2hpc3Blck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMG1vZGVsJTIwd2l0aCUyMEdQVSUyMHN1cHBvcnQlMEFtb2RlbCUyMCUzRCUyMFdoaXNwZXJNb2RlbCglMjJzbWFsbCUyMiUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBjb21wdXRlX3R5cGUlM0QlMjJmbG9hdDE2JTIyKSUwQSUwQSUyMyUyMFRyYW5zY3JpYmUlMjBhdWRpbyUwQXNlZ21lbnRzJTJDJTIwaW5mbyUyMCUzRCUyMG1vZGVsLnRyYW5zY3JpYmUoJTIyYXVkaW8ud2F2JTIyJTJDJTIwYmVhbV9zaXplJTNENSklMEElMEFwcmludChmJTIyRGV0ZWN0ZWQlMjBsYW5ndWFnZSUyMCclN0JpbmZvLmxhbmd1YWdlJTdEJyUyMHdpdGglMjBwcm9iYWJpbGl0eSUyMCU3QmluZm8ubGFuZ3VhZ2VfcHJvYmFiaWxpdHklN0QlMjIpJTBBJTBBZm9yJTIwc2VnbWVudCUyMGluJTIwc2VnbWVudHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTVCJTdCc2VnbWVudC5zdGFydCUzQS4yZiU3RHMlMjAtJTNFJTIwJTdCc2VnbWVudC5lbmQlM0EuMmYlN0RzJTVEJTIwJTdCc2VnbWVudC50ZXh0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> faster_whisper <span class="hljs-keyword">import</span> WhisperModel

<span class="hljs-comment"># Initialize model with GPU support</span>
model = WhisperModel(<span class="hljs-string">&quot;small&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, compute_type=<span class="hljs-string">&quot;float16&quot;</span>)

<span class="hljs-comment"># Transcribe audio</span>
segments, info = model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>, beam_size=<span class="hljs-number">5</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected language &#x27;<span class="hljs-subst">{info.language}</span>&#x27; with probability <span class="hljs-subst">{info.language_probability}</span>&quot;</span>)

<span class="hljs-keyword">for</span> segment <span class="hljs-keyword">in</span> segments:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;[<span class="hljs-subst">{segment.start:<span class="hljs-number">.2</span>f}</span>s -&gt; <span class="hljs-subst">{segment.end:<span class="hljs-number">.2</span>f}</span>s] <span class="hljs-subst">{segment.text}</span>&quot;</span>)`,wrap:!1}}),N=new c({props:{title:"Advanced Features:",local:"advanced-features",headingTag:"h4"}}),H=new h({props:{code:"JTIzJTIwU3RyZWFtaW5nJTIwdHJhbnNjcmlwdGlvbiUwQXNlZ21lbnRzJTJDJTIwaW5mbyUyMCUzRCUyMG1vZGVsLnRyYW5zY3JpYmUoJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8ud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwYmVhbV9zaXplJTNENSUyQyUwQSUyMCUyMCUyMCUyMGxhbmd1YWdlJTNEJTIyZW4lMjIlMkMlMEElMjAlMjAlMjAlMjBjb25kaXRpb25fb25fcHJldmlvdXNfdGV4dCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjAlMkMlMEElMjAlMjAlMjAlMjBjb21wcmVzc2lvbl9yYXRpb190aHJlc2hvbGQlM0QyLjQlMkMlMEElMjAlMjAlMjAlMjBsb2dfcHJvYl90aHJlc2hvbGQlM0QtMS4wJTJDJTBBJTIwJTIwJTIwJTIwbm9fc3BlZWNoX3RocmVzaG9sZCUzRDAuNiUyQyUwQSUyMCUyMCUyMCUyMHdvcmRfdGltZXN0YW1wcyUzRFRydWUlMkMlMEEpJTBBJTBBJTIzJTIwVm9pY2UlMjBBY3Rpdml0eSUyMERldGVjdGlvbiUyMChWQUQpJTBBc2VnbWVudHMlMkMlMjBpbmZvJTIwJTNEJTIwbW9kZWwudHJhbnNjcmliZSglMEElMjAlMjAlMjAlMjAlMjJhdWRpby53YXYlMjIlMkMlMjB2YWRfZmlsdGVyJTNEVHJ1ZSUyQyUyMHZhZF9wYXJhbWV0ZXJzJTNEZGljdChtaW5fc2lsZW5jZV9kdXJhdGlvbl9tcyUzRDUwMCklMEEp",highlighted:`<span class="hljs-comment"># Streaming transcription</span>
segments, info = model.transcribe(
    <span class="hljs-string">&quot;audio.wav&quot;</span>,
    beam_size=<span class="hljs-number">5</span>,
    language=<span class="hljs-string">&quot;en&quot;</span>,
    condition_on_previous_text=<span class="hljs-literal">False</span>,
    temperature=<span class="hljs-number">0.0</span>,
    compression_ratio_threshold=<span class="hljs-number">2.4</span>,
    log_prob_threshold=-<span class="hljs-number">1.0</span>,
    no_speech_threshold=<span class="hljs-number">0.6</span>,
    word_timestamps=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Voice Activity Detection (VAD)</span>
segments, info = model.transcribe(
    <span class="hljs-string">&quot;audio.wav&quot;</span>, vad_filter=<span class="hljs-literal">True</span>, vad_parameters=<span class="hljs-built_in">dict</span>(min_silence_duration_ms=<span class="hljs-number">500</span>)
)`,wrap:!1}}),_=new c({props:{title:"insanely-fast-whisper: Ultra-Low Latency",local:"insanely-fast-whisper-ultra-low-latency",headingTag:"h3"}}),Y=new c({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),L=new c({props:{title:"Performance Characteristics:",local:"performance-characteristics",headingTag:"h4"}}),K=new c({props:{title:"Installation and Usage:",local:"installation-and-usage",headingTag:"h4"}}),D=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGluc2FuZWx5LWZhc3Qtd2hpc3Blcg==",highlighted:"pip install insanely-fast-whisper",wrap:!1}}),O=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEElMjMlMjBJbml0aWFsaXplJTIwd2l0aCUyMGZsYXNoJTIwYXR0ZW50aW9uJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfa3dhcmdzJTNEJTdCJTIyYXR0bl9pbXBsZW1lbnRhdGlvbiUyMiUzQSUyMCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTdEJTJDJTBBKSUwQSUwQSUyMyUyMFVsdHJhLWZhc3QlMjB0cmFuc2NyaXB0aW9uJTBBcmVzdWx0JTIwJTNEJTIwcGlwZSglMjJhdWRpby53YXYlMjIlMkMlMjBjaHVua19sZW5ndGhfcyUzRDMwJTJDJTIwYmF0Y2hfc2l6ZSUzRDI0KSUwQXByaW50KHJlc3VsdCU1QiUyMnRleHQlMjIlNUQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Initialize with flash attention</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
    model=<span class="hljs-string">&quot;openai/whisper-large-v3&quot;</span>,
    torch_dtype=torch.float16,
    device=<span class="hljs-string">&quot;cuda&quot;</span>,
    model_kwargs={<span class="hljs-string">&quot;attn_implementation&quot;</span>: <span class="hljs-string">&quot;flash_attention_2&quot;</span>},
)

<span class="hljs-comment"># Ultra-fast transcription</span>
result = pipe(<span class="hljs-string">&quot;audio.wav&quot;</span>, chunk_length_s=<span class="hljs-number">30</span>, batch_size=<span class="hljs-number">24</span>)
<span class="hljs-built_in">print</span>(result[<span class="hljs-string">&quot;text&quot;</span>])`,wrap:!1}}),ee=new c({props:{title:"Platform-Specific Optimizations",local:"platform-specific-optimizations",headingTag:"h2"}}),te=new c({props:{title:"MLX-Whisper: Apple Silicon Native Performance",local:"mlx-whisper-apple-silicon-native-performance",headingTag:"h3"}}),le=new c({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),ae=new c({props:{title:"Performance Characteristics:",local:"performance-characteristics",headingTag:"h4"}}),pe=new c({props:{title:"Installation and Usage:",local:"installation-and-usage",headingTag:"h4"}}),re=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMG1seC13aGlzcGVy",highlighted:"pip install mlx-whisper",wrap:!1}}),me=new h({props:{code:"aW1wb3J0JTIwbWx4X3doaXNwZXIlMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMjBvcHRpbWl6ZWQlMjBmb3IlMjBBcHBsZSUyMFNpbGljb24lMEFtb2RlbCUyMCUzRCUyMG1seF93aGlzcGVyLmxvYWRfbW9kZWwoJTIyc21hbGwlMjIpJTBBJTBBJTIzJTIwVHJhbnNjcmliZSUyMHdpdGglMjBNZXRhbCUyMGFjY2VsZXJhdGlvbiUwQXJlc3VsdCUyMCUzRCUyMG1vZGVsLnRyYW5zY3JpYmUoJTIyYXVkaW8ud2F2JTIyKSUwQXByaW50KHJlc3VsdCU1QiUyMnRleHQlMjIlNUQp",highlighted:`<span class="hljs-keyword">import</span> mlx_whisper

<span class="hljs-comment"># Load model optimized for Apple Silicon</span>
model = mlx_whisper.load_model(<span class="hljs-string">&quot;small&quot;</span>)

<span class="hljs-comment"># Transcribe with Metal acceleration</span>
result = model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>)
<span class="hljs-built_in">print</span>(result[<span class="hljs-string">&quot;text&quot;</span>])`,wrap:!1}}),oe=new c({props:{title:"Lightning-Whisper-MLX: Maximum Apple Silicon Speed",local:"lightning-whisper-mlx-maximum-apple-silicon-speed",headingTag:"h4"}}),Me=new h({props:{code:"JTIzJTIwRXZlbiUyMGZhc3RlciUyME1MWCUyMGltcGxlbWVudGF0aW9uJTBBZnJvbSUyMGxpZ2h0bmluZ193aGlzcGVyX21seCUyMGltcG9ydCUyMExpZ2h0bmluZ1doaXNwZXJNTFglMEElMEFtb2RlbCUyMCUzRCUyMExpZ2h0bmluZ1doaXNwZXJNTFgobW9kZWxfbmFtZSUzRCUyMnNtYWxsJTIyJTJDJTIwYmF0Y2hfc2l6ZSUzRDEyJTJDJTIwcXVhbnQlM0ROb25lKSUwQXJlc3VsdCUyMCUzRCUyMG1vZGVsLnRyYW5zY3JpYmUoJTIyYXVkaW8ud2F2JTIyKSUwQXByaW50KHJlc3VsdCU1QiUyMnRleHQlMjIlNUQp",highlighted:`<span class="hljs-comment"># Even faster MLX implementation</span>
<span class="hljs-keyword">from</span> lightning_whisper_mlx <span class="hljs-keyword">import</span> LightningWhisperMLX

model = LightningWhisperMLX(model_name=<span class="hljs-string">&quot;small&quot;</span>, batch_size=<span class="hljs-number">12</span>, quant=<span class="hljs-literal">None</span>)
result = model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>)
<span class="hljs-built_in">print</span>(result[<span class="hljs-string">&quot;text&quot;</span>])`,wrap:!1}}),ce=new c({props:{title:"WhisperKit: On-Device Apple Deployment",local:"whisperkit-on-device-apple-deployment",headingTag:"h3"}}),ye=new c({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),he=new c({props:{title:"Alternative Architectures",local:"alternative-architectures",headingTag:"h2"}}),fe=new c({props:{title:"Conformer-Based Models: Edge Computing Focus",local:"conformer-based-models-edge-computing-focus",headingTag:"h3"}}),Je=new c({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),Te=new c({props:{title:"Comprehensive Performance Comparison",local:"comprehensive-performance-comparison",headingTag:"h2"}}),je=new c({props:{title:"Deployment Strategies",local:"deployment-strategies",headingTag:"h2"}}),$e=new c({props:{title:"Edge Computing Deployment",local:"edge-computing-deployment",headingTag:"h3"}}),be=new c({props:{title:"Hardware Requirements:",local:"hardware-requirements",headingTag:"h4"}}),Ce=new c({props:{title:"Optimization Techniques:",local:"optimization-techniques",headingTag:"h4"}}),Be=new c({props:{title:"Mobile Deployment",local:"mobile-deployment",headingTag:"h3"}}),Ge=new c({props:{title:"iOS/macOS with WhisperKit:",local:"iosmacos-with-whisperkit",headingTag:"h4"}}),Ze=new h({props:{code:"aW1wb3J0JTIwV2hpc3BlcktpdCUwQSUwQWxldCUyMHdoaXNwZXJLaXQlMjAlM0QlMjB0cnklMjBhd2FpdCUyMFdoaXNwZXJLaXQobW9kZWwlM0ElMjAlMjJzbWFsbCUyMiklMEFsZXQlMjB0cmFuc2NyaXB0aW9uJTIwJTNEJTIwdHJ5JTIwYXdhaXQlMjB3aGlzcGVyS2l0LnRyYW5zY3JpYmUoYXVkaW9QYXRoJTNBJTIwJTIyYXVkaW8ud2F2JTIyKSUwQXByaW50KHRyYW5zY3JpcHRpb24udGV4dCk=",highlighted:`<span class="hljs-keyword">import</span> WhisperKit

<span class="hljs-keyword">let</span> whisperKit <span class="hljs-operator">=</span> <span class="hljs-keyword">try</span> <span class="hljs-keyword">await</span> <span class="hljs-type">WhisperKit</span>(model: <span class="hljs-string">&quot;small&quot;</span>)
<span class="hljs-keyword">let</span> transcription <span class="hljs-operator">=</span> <span class="hljs-keyword">try</span> <span class="hljs-keyword">await</span> whisperKit.transcribe(audioPath: <span class="hljs-string">&quot;audio.wav&quot;</span>)
<span class="hljs-built_in">print</span>(transcription.text)`,wrap:!1}}),ve=new c({props:{title:"Android with whisper.cpp:",local:"android-with-whispercpp",headingTag:"h4"}}),Ae=new h({props:{code:"cHVibGljJTIwY2xhc3MlMjBXaGlzcGVyQW5kcm9pZCUyMCU3QiUwQSUyMCUyMCUyMCUyMHN0YXRpYyUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFN5c3RlbS5sb2FkTGlicmFyeSglMjJ3aGlzcGVyX2FuZHJvaWQlMjIpJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHVibGljJTIwbmF0aXZlJTIwU3RyaW5nJTIwdHJhbnNjcmliZShTdHJpbmclMjBhdWRpb1BhdGglMkMlMjBTdHJpbmclMjBtb2RlbFBhdGgpJTNCJTBBJTdE",highlighted:`<span class="hljs-keyword">public</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">WhisperAndroid</span> {
    <span class="hljs-keyword">static</span> {
        System.loadLibrary(<span class="hljs-string">&quot;whisper_android&quot;</span>);
    }
    
    <span class="hljs-keyword">public</span> <span class="hljs-keyword">native</span> String <span class="hljs-title function_">transcribe</span><span class="hljs-params">(String audioPath, String modelPath)</span>;
}`,wrap:!1}}),ke=new c({props:{title:"Real-Time Streaming",local:"real-time-streaming",headingTag:"h3"}}),Se=new c({props:{title:"Streaming with faster-whisper:",local:"streaming-with-faster-whisper",headingTag:"h4"}}),Ve=new h({props:{code:"ZnJvbSUyMGZhc3Rlcl93aGlzcGVyJTIwaW1wb3J0JTIwV2hpc3Blck1vZGVsJTBBaW1wb3J0JTIwcHlhdWRpbyUwQWltcG9ydCUyMHRocmVhZGluZyUwQWltcG9ydCUyMHF1ZXVlJTBBJTBBJTBBY2xhc3MlMjBTdHJlYW1pbmdXaGlzcGVyJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG1vZGVsX25hbWUlM0QlMjJzbWFsbCUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1vZGVsJTIwJTNEJTIwV2hpc3Blck1vZGVsKG1vZGVsX25hbWUlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwY29tcHV0ZV90eXBlJTNEJTIyZmxvYXQxNiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmF1ZGlvX3F1ZXVlJTIwJTNEJTIwcXVldWUuUXVldWUoKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHN0cmVhbV90cmFuc2NyaWJlKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBzZWxmLmF1ZGlvX3F1ZXVlLmVtcHR5KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpb19kYXRhJTIwJTNEJTIwc2VsZi5hdWRpb19xdWV1ZS5nZXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlZ21lbnRzJTJDJTIwaW5mbyUyMCUzRCUyMHNlbGYubW9kZWwudHJhbnNjcmliZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpb19kYXRhJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVhbV9zaXplJTNENSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhbmd1YWdlJTNEJTIyZW4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25kaXRpb25fb25fcHJldmlvdXNfdGV4dCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHNlZ21lbnQlMjBpbiUyMHNlZ21lbnRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1QiU3QnNlZ21lbnQuc3RhcnQlM0EuMmYlN0RzJTIwLSUzRSUyMCU3QnNlZ21lbnQuZW5kJTNBLjJmJTdEcyU1RCUyMCU3QnNlZ21lbnQudGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> faster_whisper <span class="hljs-keyword">import</span> WhisperModel
<span class="hljs-keyword">import</span> pyaudio
<span class="hljs-keyword">import</span> threading
<span class="hljs-keyword">import</span> queue


<span class="hljs-keyword">class</span> <span class="hljs-title class_">StreamingWhisper</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;small&quot;</span></span>):
        self.model = WhisperModel(model_name, device=<span class="hljs-string">&quot;cuda&quot;</span>, compute_type=<span class="hljs-string">&quot;float16&quot;</span>)
        self.audio_queue = queue.Queue()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">stream_transcribe</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.audio_queue.empty():
                audio_data = self.audio_queue.get()
                segments, info = self.model.transcribe(
                    audio_data,
                    beam_size=<span class="hljs-number">5</span>,
                    language=<span class="hljs-string">&quot;en&quot;</span>,
                    condition_on_previous_text=<span class="hljs-literal">False</span>,
                )

                <span class="hljs-keyword">for</span> segment <span class="hljs-keyword">in</span> segments:
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;[<span class="hljs-subst">{segment.start:<span class="hljs-number">.2</span>f}</span>s -&gt; <span class="hljs-subst">{segment.end:<span class="hljs-number">.2</span>f}</span>s] <span class="hljs-subst">{segment.text}</span>&quot;</span>)`,wrap:!1}}),ze=new c({props:{title:"Integration with Existing Workflows",local:"integration-with-existing-workflows",headingTag:"h2"}}),xe=new c({props:{title:"Combining with 🤗 Transformers:",local:"combining-with--transformers",headingTag:"h3"}}),Xe=new h({props:{code:"JTIzJTIwVXNlJTIwZmFzdGVyLXdoaXNwZXIlMjBmb3IlMjB0cmFuc2NyaXB0aW9uJTJDJTIwdHJhbnNmb3JtZXJzJTIwZm9yJTIwcG9zdC1wcm9jZXNzaW5nJTBBZnJvbSUyMGZhc3Rlcl93aGlzcGVyJTIwaW1wb3J0JTIwV2hpc3Blck1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwRmFzdCUyMHRyYW5zY3JpcHRpb24lMEF3aGlzcGVyX21vZGVsJTIwJTNEJTIwV2hpc3Blck1vZGVsKCUyMnNtYWxsJTIyJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiklMEFzZWdtZW50cyUyQyUyMGluZm8lMjAlM0QlMjB3aGlzcGVyX21vZGVsLnRyYW5zY3JpYmUoJTIyYXVkaW8ud2F2JTIyKSUwQSUwQSUyMyUyMFBvc3QtcHJvY2Vzc2luZyUyMHdpdGglMjB0cmFuc2Zvcm1lcnMlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBZm9yJTIwc2VnbWVudCUyMGluJTIwc2VnbWVudHMlM0ElMEElMjAlMjAlMjAlMjBlbW90aW9uJTIwJTNEJTIwY2xhc3NpZmllcihzZWdtZW50LnRleHQpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlRleHQlM0ElMjAlN0JzZWdtZW50LnRleHQlN0QlMkMlMjBFbW90aW9uJTNBJTIwJTdCZW1vdGlvbiU3RCUyMik=",highlighted:`<span class="hljs-comment"># Use faster-whisper for transcription, transformers for post-processing</span>
<span class="hljs-keyword">from</span> faster_whisper <span class="hljs-keyword">import</span> WhisperModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Fast transcription</span>
whisper_model = WhisperModel(<span class="hljs-string">&quot;small&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>)
segments, info = whisper_model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>)

<span class="hljs-comment"># Post-processing with transformers</span>
classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
<span class="hljs-keyword">for</span> segment <span class="hljs-keyword">in</span> segments:
    emotion = classifier(segment.text)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Text: <span class="hljs-subst">{segment.text}</span>, Emotion: <span class="hljs-subst">{emotion}</span>&quot;</span>)`,wrap:!1}}),Re=new c({props:{title:"Benchmarking Different Implementations:",local:"benchmarking-different-implementations",headingTag:"h3"}}),Ee=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_implementation</span>(<span class="hljs-params">model_func, audio_path, num_runs=<span class="hljs-number">5</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;Benchmark an ASR implementation&quot;&quot;&quot;</span>
    times = []
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_runs):
        start_time = time.time()
        result = model_func(audio_path)
        end_time = time.time()
        times.append(end_time - start_time)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;mean_time&quot;</span>: np.mean(times),
        <span class="hljs-string">&quot;std_time&quot;</span>: np.std(times),
        <span class="hljs-string">&quot;transcription&quot;</span>: result,
    }


<span class="hljs-comment"># Compare implementations</span>
implementations = {
    <span class="hljs-string">&quot;whisper.cpp&quot;</span>: <span class="hljs-keyword">lambda</span> path: whisper_cpp_transcribe(path),
    <span class="hljs-string">&quot;faster-whisper&quot;</span>: <span class="hljs-keyword">lambda</span> path: faster_whisper_transcribe(path),
    <span class="hljs-string">&quot;insanely-fast-whisper&quot;</span>: <span class="hljs-keyword">lambda</span> path: insanely_fast_transcribe(path),
    <span class="hljs-string">&quot;mlx-whisper&quot;</span>: <span class="hljs-keyword">lambda</span> path: mlx_whisper_transcribe(path),
}

results = {}
<span class="hljs-keyword">for</span> name, func <span class="hljs-keyword">in</span> implementations.items():
    results[name] = benchmark_implementation(func, <span class="hljs-string">&quot;test_audio.wav&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{name}</span>: <span class="hljs-subst">{results[name][<span class="hljs-string">&#x27;mean_time&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>s ± <span class="hljs-subst">{results[name][<span class="hljs-string">&#x27;std_time&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>s&quot;</span>)`,wrap:!1}}),Qe=new c({props:{title:"Best Practices and Recommendations",local:"best-practices-and-recommendations",headingTag:"h2"}}),Ne=new c({props:{title:"Choosing the Right Implementation:",local:"choosing-the-right-implementation",headingTag:"h3"}}),_e=new c({props:{title:"Performance Optimization Tips:",local:"performance-optimization-tips",headingTag:"h3"}}),Ye=new c({props:{title:"Error Handling and Robustness:",local:"error-handling-and-robustness",headingTag:"h3"}}),qe=new h({props:{code:"ZGVmJTIwcm9idXN0X3RyYW5zY3JpYmUoYXVkaW9fcGF0aCUyQyUyMGZhbGxiYWNrX2ltcGxlbWVudGF0aW9ucyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUm9idXN0JTIwdHJhbnNjcmlwdGlvbiUyMHdpdGglMjBmYWxsYmFjayUyMGltcGxlbWVudGF0aW9ucyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwZmFsbGJhY2tfaW1wbGVtZW50YXRpb25zJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmFsbGJhY2tfaW1wbGVtZW50YXRpb25zJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmFzdGVyX3doaXNwZXJfdHJhbnNjcmliZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaXNwZXJfY3BwX3RyYW5zY3JpYmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lcnNfd2hpc3Blcl90cmFuc2NyaWJlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGltcGxlbWVudGF0aW9uJTIwaW4lMjBlbnVtZXJhdGUoZmFsbGJhY2tfaW1wbGVtZW50YXRpb25zKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGltcGxlbWVudGF0aW9uKGF1ZGlvX3BhdGgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByZXN1bHQlMjBhbmQlMjBsZW4ocmVzdWx0LnN0cmlwKCkpJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJJbXBsZW1lbnRhdGlvbiUyMCU3QmklMkIxJTdEJTIwZmFpbGVkJTNBJTIwJTdCZSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250aW51ZSUwQSUwQSUyMCUyMCUyMCUyMHJhaXNlJTIwUnVudGltZUVycm9yKCUyMkFsbCUyMGltcGxlbWVudGF0aW9ucyUyMGZhaWxlZCUyMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">robust_transcribe</span>(<span class="hljs-params">audio_path, fallback_implementations=<span class="hljs-literal">None</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;Robust transcription with fallback implementations&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> fallback_implementations <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        fallback_implementations = [
            faster_whisper_transcribe,
            whisper_cpp_transcribe,
            transformers_whisper_transcribe,
        ]

    <span class="hljs-keyword">for</span> i, implementation <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(fallback_implementations):
        <span class="hljs-keyword">try</span>:
            result = implementation(audio_path)
            <span class="hljs-keyword">if</span> result <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(result.strip()) &gt; <span class="hljs-number">0</span>:
                <span class="hljs-keyword">return</span> result
        <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Implementation <span class="hljs-subst">{i+<span class="hljs-number">1</span>}</span> failed: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">continue</span>

    <span class="hljs-keyword">raise</span> RuntimeError(<span class="hljs-string">&quot;All implementations failed&quot;</span>)`,wrap:!1}}),Le=new c({props:{title:"Summary",local:"summary",headingTag:"h2"}}),et=new Cl({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/alternative_implementations.mdx"}}),{c(){f=d("meta"),lt=n(),tt=d("p"),nt=n(),i(g.$$.fragment),at=n(),J=d("p"),J.textContent=Hs,it=n(),u=d("p"),u.textContent=_s,pt=n(),i(T.$$.fragment),rt=n(),i(U.$$.fragment),mt=n(),j=d("p"),j.innerHTML=Fs,ot=n(),i($.$$.fragment),Mt=n(),b=d("ul"),b.innerHTML=Ys,ct=n(),i(I.$$.fragment),dt=n(),C=d("ul"),C.innerHTML=qs,yt=n(),i(W.$$.fragment),wt=n(),i(B.$$.fragment),ht=n(),i(G.$$.fragment),ft=n(),i(Z.$$.fragment),gt=n(),i(v.$$.fragment),Jt=n(),A=d("ul"),A.innerHTML=Ls,ut=n(),i(k.$$.fragment),Tt=n(),S=d("p"),S.innerHTML=Ps,Ut=n(),i(V.$$.fragment),jt=n(),z=d("ul"),z.innerHTML=Ks,$t=n(),i(x.$$.fragment),bt=n(),X=d("ul"),X.innerHTML=Ds,It=n(),i(R.$$.fragment),Ct=n(),i(E.$$.fragment),Wt=n(),i(Q.$$.fragment),Bt=n(),i(N.$$.fragment),Gt=n(),i(H.$$.fragment),Zt=n(),i(_.$$.fragment),vt=n(),F=d("p"),F.innerHTML=Os,At=n(),i(Y.$$.fragment),kt=n(),q=d("ul"),q.innerHTML=el,St=n(),i(L.$$.fragment),Vt=n(),P=d("ul"),P.innerHTML=tl,zt=n(),i(K.$$.fragment),xt=n(),i(D.$$.fragment),Xt=n(),i(O.$$.fragment),Rt=n(),i(ee.$$.fragment),Et=n(),i(te.$$.fragment),Qt=n(),se=d("p"),se.innerHTML=sl,Nt=n(),i(le.$$.fragment),Ht=n(),ne=d("ul"),ne.innerHTML=ll,_t=n(),i(ae.$$.fragment),Ft=n(),ie=d("ul"),ie.innerHTML=nl,Yt=n(),i(pe.$$.fragment),qt=n(),i(re.$$.fragment),Lt=n(),i(me.$$.fragment),Pt=n(),i(oe.$$.fragment),Kt=n(),i(Me.$$.fragment),Dt=n(),i(ce.$$.fragment),Ot=n(),de=d("p"),de.innerHTML=al,es=n(),i(ye.$$.fragment),ts=n(),we=d("ul"),we.innerHTML=il,ss=n(),i(he.$$.fragment),ls=n(),i(fe.$$.fragment),ns=n(),ge=d("p"),ge.textContent=pl,as=n(),i(Je.$$.fragment),is=n(),ue=d("ul"),ue.innerHTML=rl,ps=n(),i(Te.$$.fragment),rs=n(),Ue=d("table"),Ue.innerHTML=ml,ms=n(),i(je.$$.fragment),os=n(),i($e.$$.fragment),Ms=n(),i(be.$$.fragment),cs=n(),Ie=d("ul"),Ie.innerHTML=ol,ds=n(),i(Ce.$$.fragment),ys=n(),We=d("ol"),We.innerHTML=Ml,ws=n(),i(Be.$$.fragment),hs=n(),i(Ge.$$.fragment),fs=n(),i(Ze.$$.fragment),gs=n(),i(ve.$$.fragment),Js=n(),i(Ae.$$.fragment),us=n(),i(ke.$$.fragment),Ts=n(),i(Se.$$.fragment),Us=n(),i(Ve.$$.fragment),js=n(),i(ze.$$.fragment),$s=n(),i(xe.$$.fragment),bs=n(),i(Xe.$$.fragment),Is=n(),i(Re.$$.fragment),Cs=n(),i(Ee.$$.fragment),Ws=n(),i(Qe.$$.fragment),Bs=n(),i(Ne.$$.fragment),Gs=n(),He=d("ol"),He.innerHTML=cl,Zs=n(),i(_e.$$.fragment),vs=n(),Fe=d("ol"),Fe.innerHTML=dl,As=n(),i(Ye.$$.fragment),ks=n(),i(qe.$$.fragment),Ss=n(),i(Le.$$.fragment),Vs=n(),Pe=d("p"),Pe.textContent=yl,zs=n(),Ke=d("ul"),Ke.innerHTML=wl,xs=n(),De=d("p"),De.textContent=hl,Xs=n(),Oe=d("p"),Oe.textContent=fl,Rs=n(),i(et.$$.fragment),Es=n(),st=d("p"),this.h()},l(e){const t=bl("svelte-u9bgzb",document.head);f=y(t,"META",{name:!0,content:!0}),t.forEach(s),lt=a(e),tt=y(e,"P",{}),gl(tt).forEach(s),nt=a(e),p(g.$$.fragment,e),at=a(e),J=y(e,"P",{"data-svelte-h":!0}),w(J)!=="svelte-1tyh4bp"&&(J.textContent=Hs),it=a(e),u=y(e,"P",{"data-svelte-h":!0}),w(u)!=="svelte-1e9xdbq"&&(u.textContent=_s),pt=a(e),p(T.$$.fragment,e),rt=a(e),p(U.$$.fragment,e),mt=a(e),j=y(e,"P",{"data-svelte-h":!0}),w(j)!=="svelte-1ncmokw"&&(j.innerHTML=Fs),ot=a(e),p($.$$.fragment,e),Mt=a(e),b=y(e,"UL",{"data-svelte-h":!0}),w(b)!=="svelte-13drr5p"&&(b.innerHTML=Ys),ct=a(e),p(I.$$.fragment,e),dt=a(e),C=y(e,"UL",{"data-svelte-h":!0}),w(C)!=="svelte-16s4uuk"&&(C.innerHTML=qs),yt=a(e),p(W.$$.fragment,e),wt=a(e),p(B.$$.fragment,e),ht=a(e),p(G.$$.fragment,e),ft=a(e),p(Z.$$.fragment,e),gt=a(e),p(v.$$.fragment,e),Jt=a(e),A=y(e,"UL",{"data-svelte-h":!0}),w(A)!=="svelte-13siu0x"&&(A.innerHTML=Ls),ut=a(e),p(k.$$.fragment,e),Tt=a(e),S=y(e,"P",{"data-svelte-h":!0}),w(S)!=="svelte-qzfp0v"&&(S.innerHTML=Ps),Ut=a(e),p(V.$$.fragment,e),jt=a(e),z=y(e,"UL",{"data-svelte-h":!0}),w(z)!=="svelte-1d03qfu"&&(z.innerHTML=Ks),$t=a(e),p(x.$$.fragment,e),bt=a(e),X=y(e,"UL",{"data-svelte-h":!0}),w(X)!=="svelte-8bdcxs"&&(X.innerHTML=Ds),It=a(e),p(R.$$.fragment,e),Ct=a(e),p(E.$$.fragment,e),Wt=a(e),p(Q.$$.fragment,e),Bt=a(e),p(N.$$.fragment,e),Gt=a(e),p(H.$$.fragment,e),Zt=a(e),p(_.$$.fragment,e),vt=a(e),F=y(e,"P",{"data-svelte-h":!0}),w(F)!=="svelte-1xvsa7z"&&(F.innerHTML=Os),At=a(e),p(Y.$$.fragment,e),kt=a(e),q=y(e,"UL",{"data-svelte-h":!0}),w(q)!=="svelte-1a7715e"&&(q.innerHTML=el),St=a(e),p(L.$$.fragment,e),Vt=a(e),P=y(e,"UL",{"data-svelte-h":!0}),w(P)!=="svelte-14tuzjp"&&(P.innerHTML=tl),zt=a(e),p(K.$$.fragment,e),xt=a(e),p(D.$$.fragment,e),Xt=a(e),p(O.$$.fragment,e),Rt=a(e),p(ee.$$.fragment,e),Et=a(e),p(te.$$.fragment,e),Qt=a(e),se=y(e,"P",{"data-svelte-h":!0}),w(se)!=="svelte-1nmuo4d"&&(se.innerHTML=sl),Nt=a(e),p(le.$$.fragment,e),Ht=a(e),ne=y(e,"UL",{"data-svelte-h":!0}),w(ne)!=="svelte-1x0ax2x"&&(ne.innerHTML=ll),_t=a(e),p(ae.$$.fragment,e),Ft=a(e),ie=y(e,"UL",{"data-svelte-h":!0}),w(ie)!=="svelte-1m0jpy3"&&(ie.innerHTML=nl),Yt=a(e),p(pe.$$.fragment,e),qt=a(e),p(re.$$.fragment,e),Lt=a(e),p(me.$$.fragment,e),Pt=a(e),p(oe.$$.fragment,e),Kt=a(e),p(Me.$$.fragment,e),Dt=a(e),p(ce.$$.fragment,e),Ot=a(e),de=y(e,"P",{"data-svelte-h":!0}),w(de)!=="svelte-yrp1m9"&&(de.innerHTML=al),es=a(e),p(ye.$$.fragment,e),ts=a(e),we=y(e,"UL",{"data-svelte-h":!0}),w(we)!=="svelte-tg6v2i"&&(we.innerHTML=il),ss=a(e),p(he.$$.fragment,e),ls=a(e),p(fe.$$.fragment,e),ns=a(e),ge=y(e,"P",{"data-svelte-h":!0}),w(ge)!=="svelte-1oeqjh8"&&(ge.textContent=pl),as=a(e),p(Je.$$.fragment,e),is=a(e),ue=y(e,"UL",{"data-svelte-h":!0}),w(ue)!=="svelte-1kv2wf9"&&(ue.innerHTML=rl),ps=a(e),p(Te.$$.fragment,e),rs=a(e),Ue=y(e,"TABLE",{"data-svelte-h":!0}),w(Ue)!=="svelte-1rinq7d"&&(Ue.innerHTML=ml),ms=a(e),p(je.$$.fragment,e),os=a(e),p($e.$$.fragment,e),Ms=a(e),p(be.$$.fragment,e),cs=a(e),Ie=y(e,"UL",{"data-svelte-h":!0}),w(Ie)!=="svelte-kkvih6"&&(Ie.innerHTML=ol),ds=a(e),p(Ce.$$.fragment,e),ys=a(e),We=y(e,"OL",{"data-svelte-h":!0}),w(We)!=="svelte-mt0lyc"&&(We.innerHTML=Ml),ws=a(e),p(Be.$$.fragment,e),hs=a(e),p(Ge.$$.fragment,e),fs=a(e),p(Ze.$$.fragment,e),gs=a(e),p(ve.$$.fragment,e),Js=a(e),p(Ae.$$.fragment,e),us=a(e),p(ke.$$.fragment,e),Ts=a(e),p(Se.$$.fragment,e),Us=a(e),p(Ve.$$.fragment,e),js=a(e),p(ze.$$.fragment,e),$s=a(e),p(xe.$$.fragment,e),bs=a(e),p(Xe.$$.fragment,e),Is=a(e),p(Re.$$.fragment,e),Cs=a(e),p(Ee.$$.fragment,e),Ws=a(e),p(Qe.$$.fragment,e),Bs=a(e),p(Ne.$$.fragment,e),Gs=a(e),He=y(e,"OL",{"data-svelte-h":!0}),w(He)!=="svelte-1r3ml7v"&&(He.innerHTML=cl),Zs=a(e),p(_e.$$.fragment,e),vs=a(e),Fe=y(e,"OL",{"data-svelte-h":!0}),w(Fe)!=="svelte-l1b4r9"&&(Fe.innerHTML=dl),As=a(e),p(Ye.$$.fragment,e),ks=a(e),p(qe.$$.fragment,e),Ss=a(e),p(Le.$$.fragment,e),Vs=a(e),Pe=y(e,"P",{"data-svelte-h":!0}),w(Pe)!=="svelte-11xe3vy"&&(Pe.textContent=yl),zs=a(e),Ke=y(e,"UL",{"data-svelte-h":!0}),w(Ke)!=="svelte-1cdyx9q"&&(Ke.innerHTML=wl),xs=a(e),De=y(e,"P",{"data-svelte-h":!0}),w(De)!=="svelte-1ndvy6z"&&(De.textContent=hl),Xs=a(e),Oe=y(e,"P",{"data-svelte-h":!0}),w(Oe)!=="svelte-161m7eq"&&(Oe.textContent=fl),Rs=a(e),p(et.$$.fragment,e),Es=a(e),st=y(e,"P",{}),gl(st).forEach(s),this.h()},h(){Jl(f,"name","hf:doc:metadata"),Jl(f,"content",Bl)},m(e,t){Il(document.head,f),l(e,lt,t),l(e,tt,t),l(e,nt,t),r(g,e,t),l(e,at,t),l(e,J,t),l(e,it,t),l(e,u,t),l(e,pt,t),r(T,e,t),l(e,rt,t),r(U,e,t),l(e,mt,t),l(e,j,t),l(e,ot,t),r($,e,t),l(e,Mt,t),l(e,b,t),l(e,ct,t),r(I,e,t),l(e,dt,t),l(e,C,t),l(e,yt,t),r(W,e,t),l(e,wt,t),r(B,e,t),l(e,ht,t),r(G,e,t),l(e,ft,t),r(Z,e,t),l(e,gt,t),r(v,e,t),l(e,Jt,t),l(e,A,t),l(e,ut,t),r(k,e,t),l(e,Tt,t),l(e,S,t),l(e,Ut,t),r(V,e,t),l(e,jt,t),l(e,z,t),l(e,$t,t),r(x,e,t),l(e,bt,t),l(e,X,t),l(e,It,t),r(R,e,t),l(e,Ct,t),r(E,e,t),l(e,Wt,t),r(Q,e,t),l(e,Bt,t),r(N,e,t),l(e,Gt,t),r(H,e,t),l(e,Zt,t),r(_,e,t),l(e,vt,t),l(e,F,t),l(e,At,t),r(Y,e,t),l(e,kt,t),l(e,q,t),l(e,St,t),r(L,e,t),l(e,Vt,t),l(e,P,t),l(e,zt,t),r(K,e,t),l(e,xt,t),r(D,e,t),l(e,Xt,t),r(O,e,t),l(e,Rt,t),r(ee,e,t),l(e,Et,t),r(te,e,t),l(e,Qt,t),l(e,se,t),l(e,Nt,t),r(le,e,t),l(e,Ht,t),l(e,ne,t),l(e,_t,t),r(ae,e,t),l(e,Ft,t),l(e,ie,t),l(e,Yt,t),r(pe,e,t),l(e,qt,t),r(re,e,t),l(e,Lt,t),r(me,e,t),l(e,Pt,t),r(oe,e,t),l(e,Kt,t),r(Me,e,t),l(e,Dt,t),r(ce,e,t),l(e,Ot,t),l(e,de,t),l(e,es,t),r(ye,e,t),l(e,ts,t),l(e,we,t),l(e,ss,t),r(he,e,t),l(e,ls,t),r(fe,e,t),l(e,ns,t),l(e,ge,t),l(e,as,t),r(Je,e,t),l(e,is,t),l(e,ue,t),l(e,ps,t),r(Te,e,t),l(e,rs,t),l(e,Ue,t),l(e,ms,t),r(je,e,t),l(e,os,t),r($e,e,t),l(e,Ms,t),r(be,e,t),l(e,cs,t),l(e,Ie,t),l(e,ds,t),r(Ce,e,t),l(e,ys,t),l(e,We,t),l(e,ws,t),r(Be,e,t),l(e,hs,t),r(Ge,e,t),l(e,fs,t),r(Ze,e,t),l(e,gs,t),r(ve,e,t),l(e,Js,t),r(Ae,e,t),l(e,us,t),r(ke,e,t),l(e,Ts,t),r(Se,e,t),l(e,Us,t),r(Ve,e,t),l(e,js,t),r(ze,e,t),l(e,$s,t),r(xe,e,t),l(e,bs,t),r(Xe,e,t),l(e,Is,t),r(Re,e,t),l(e,Cs,t),r(Ee,e,t),l(e,Ws,t),r(Qe,e,t),l(e,Bs,t),r(Ne,e,t),l(e,Gs,t),l(e,He,t),l(e,Zs,t),r(_e,e,t),l(e,vs,t),l(e,Fe,t),l(e,As,t),r(Ye,e,t),l(e,ks,t),r(qe,e,t),l(e,Ss,t),r(Le,e,t),l(e,Vs,t),l(e,Pe,t),l(e,zs,t),l(e,Ke,t),l(e,xs,t),l(e,De,t),l(e,Xs,t),l(e,Oe,t),l(e,Rs,t),r(et,e,t),l(e,Es,t),l(e,st,t),Qs=!0},p:Tl,i(e){Qs||(m(g.$$.fragment,e),m(T.$$.fragment,e),m(U.$$.fragment,e),m($.$$.fragment,e),m(I.$$.fragment,e),m(W.$$.fragment,e),m(B.$$.fragment,e),m(G.$$.fragment,e),m(Z.$$.fragment,e),m(v.$$.fragment,e),m(k.$$.fragment,e),m(V.$$.fragment,e),m(x.$$.fragment,e),m(R.$$.fragment,e),m(E.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(H.$$.fragment,e),m(_.$$.fragment,e),m(Y.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(oe.$$.fragment,e),m(Me.$$.fragment,e),m(ce.$$.fragment,e),m(ye.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),m(Je.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m($e.$$.fragment,e),m(be.$$.fragment,e),m(Ce.$$.fragment,e),m(Be.$$.fragment,e),m(Ge.$$.fragment,e),m(Ze.$$.fragment,e),m(ve.$$.fragment,e),m(Ae.$$.fragment,e),m(ke.$$.fragment,e),m(Se.$$.fragment,e),m(Ve.$$.fragment,e),m(ze.$$.fragment,e),m(xe.$$.fragment,e),m(Xe.$$.fragment,e),m(Re.$$.fragment,e),m(Ee.$$.fragment,e),m(Qe.$$.fragment,e),m(Ne.$$.fragment,e),m(_e.$$.fragment,e),m(Ye.$$.fragment,e),m(qe.$$.fragment,e),m(Le.$$.fragment,e),m(et.$$.fragment,e),Qs=!0)},o(e){o(g.$$.fragment,e),o(T.$$.fragment,e),o(U.$$.fragment,e),o($.$$.fragment,e),o(I.$$.fragment,e),o(W.$$.fragment,e),o(B.$$.fragment,e),o(G.$$.fragment,e),o(Z.$$.fragment,e),o(v.$$.fragment,e),o(k.$$.fragment,e),o(V.$$.fragment,e),o(x.$$.fragment,e),o(R.$$.fragment,e),o(E.$$.fragment,e),o(Q.$$.fragment,e),o(N.$$.fragment,e),o(H.$$.fragment,e),o(_.$$.fragment,e),o(Y.$$.fragment,e),o(L.$$.fragment,e),o(K.$$.fragment,e),o(D.$$.fragment,e),o(O.$$.fragment,e),o(ee.$$.fragment,e),o(te.$$.fragment,e),o(le.$$.fragment,e),o(ae.$$.fragment,e),o(pe.$$.fragment,e),o(re.$$.fragment,e),o(me.$$.fragment,e),o(oe.$$.fragment,e),o(Me.$$.fragment,e),o(ce.$$.fragment,e),o(ye.$$.fragment,e),o(he.$$.fragment,e),o(fe.$$.fragment,e),o(Je.$$.fragment,e),o(Te.$$.fragment,e),o(je.$$.fragment,e),o($e.$$.fragment,e),o(be.$$.fragment,e),o(Ce.$$.fragment,e),o(Be.$$.fragment,e),o(Ge.$$.fragment,e),o(Ze.$$.fragment,e),o(ve.$$.fragment,e),o(Ae.$$.fragment,e),o(ke.$$.fragment,e),o(Se.$$.fragment,e),o(Ve.$$.fragment,e),o(ze.$$.fragment,e),o(xe.$$.fragment,e),o(Xe.$$.fragment,e),o(Re.$$.fragment,e),o(Ee.$$.fragment,e),o(Qe.$$.fragment,e),o(Ne.$$.fragment,e),o(_e.$$.fragment,e),o(Ye.$$.fragment,e),o(qe.$$.fragment,e),o(Le.$$.fragment,e),o(et.$$.fragment,e),Qs=!1},d(e){e&&(s(lt),s(tt),s(nt),s(at),s(J),s(it),s(u),s(pt),s(rt),s(mt),s(j),s(ot),s(Mt),s(b),s(ct),s(dt),s(C),s(yt),s(wt),s(ht),s(ft),s(gt),s(Jt),s(A),s(ut),s(Tt),s(S),s(Ut),s(jt),s(z),s($t),s(bt),s(X),s(It),s(Ct),s(Wt),s(Bt),s(Gt),s(Zt),s(vt),s(F),s(At),s(kt),s(q),s(St),s(Vt),s(P),s(zt),s(xt),s(Xt),s(Rt),s(Et),s(Qt),s(se),s(Nt),s(Ht),s(ne),s(_t),s(Ft),s(ie),s(Yt),s(qt),s(Lt),s(Pt),s(Kt),s(Dt),s(Ot),s(de),s(es),s(ts),s(we),s(ss),s(ls),s(ns),s(ge),s(as),s(is),s(ue),s(ps),s(rs),s(Ue),s(ms),s(os),s(Ms),s(cs),s(Ie),s(ds),s(ys),s(We),s(ws),s(hs),s(fs),s(gs),s(Js),s(us),s(Ts),s(Us),s(js),s($s),s(bs),s(Is),s(Cs),s(Ws),s(Bs),s(Gs),s(He),s(Zs),s(vs),s(Fe),s(As),s(ks),s(Ss),s(Vs),s(Pe),s(zs),s(Ke),s(xs),s(De),s(Xs),s(Oe),s(Rs),s(Es),s(st)),s(f),M(g,e),M(T,e),M(U,e),M($,e),M(I,e),M(W,e),M(B,e),M(G,e),M(Z,e),M(v,e),M(k,e),M(V,e),M(x,e),M(R,e),M(E,e),M(Q,e),M(N,e),M(H,e),M(_,e),M(Y,e),M(L,e),M(K,e),M(D,e),M(O,e),M(ee,e),M(te,e),M(le,e),M(ae,e),M(pe,e),M(re,e),M(me,e),M(oe,e),M(Me,e),M(ce,e),M(ye,e),M(he,e),M(fe,e),M(Je,e),M(Te,e),M(je,e),M($e,e),M(be,e),M(Ce,e),M(Be,e),M(Ge,e),M(Ze,e),M(ve,e),M(Ae,e),M(ke,e),M(Se,e),M(Ve,e),M(ze,e),M(xe,e),M(Xe,e),M(Re,e),M(Ee,e),M(Qe,e),M(Ne,e),M(_e,e),M(Ye,e),M(qe,e),M(Le,e),M(et,e)}}}const Bl='{"title":"Alternative ASR Implementations: Beyond Transformers","local":"alternative-asr-implementations-beyond-transformers","sections":[{"title":"High-Performance Optimized Implementations","local":"high-performance-optimized-implementations","sections":[{"title":"whisper.cpp: C++ Port for Maximum Efficiency","local":"whispercpp-c-port-for-maximum-efficiency","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4},{"title":"Performance Characteristics:","local":"performance-characteristics","sections":[],"depth":4},{"title":"Installation and Usage:","local":"installation-and-usage","sections":[],"depth":4},{"title":"Python Bindings:","local":"python-bindings","sections":[],"depth":4},{"title":"When to Use whisper.cpp:","local":"when-to-use-whispercpp","sections":[],"depth":4}],"depth":3},{"title":"faster-whisper: GPU-Accelerated Performance","local":"faster-whisper-gpu-accelerated-performance","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4},{"title":"Performance Characteristics:","local":"performance-characteristics","sections":[],"depth":4},{"title":"Installation and Usage:","local":"installation-and-usage","sections":[],"depth":4},{"title":"Advanced Features:","local":"advanced-features","sections":[],"depth":4}],"depth":3},{"title":"insanely-fast-whisper: Ultra-Low Latency","local":"insanely-fast-whisper-ultra-low-latency","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4},{"title":"Performance Characteristics:","local":"performance-characteristics","sections":[],"depth":4},{"title":"Installation and Usage:","local":"installation-and-usage","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Platform-Specific Optimizations","local":"platform-specific-optimizations","sections":[{"title":"MLX-Whisper: Apple Silicon Native Performance","local":"mlx-whisper-apple-silicon-native-performance","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4},{"title":"Performance Characteristics:","local":"performance-characteristics","sections":[],"depth":4},{"title":"Installation and Usage:","local":"installation-and-usage","sections":[],"depth":4},{"title":"Lightning-Whisper-MLX: Maximum Apple Silicon Speed","local":"lightning-whisper-mlx-maximum-apple-silicon-speed","sections":[],"depth":4}],"depth":3},{"title":"WhisperKit: On-Device Apple Deployment","local":"whisperkit-on-device-apple-deployment","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Alternative Architectures","local":"alternative-architectures","sections":[{"title":"Conformer-Based Models: Edge Computing Focus","local":"conformer-based-models-edge-computing-focus","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Comprehensive Performance Comparison","local":"comprehensive-performance-comparison","sections":[],"depth":2},{"title":"Deployment Strategies","local":"deployment-strategies","sections":[{"title":"Edge Computing Deployment","local":"edge-computing-deployment","sections":[{"title":"Hardware Requirements:","local":"hardware-requirements","sections":[],"depth":4},{"title":"Optimization Techniques:","local":"optimization-techniques","sections":[],"depth":4}],"depth":3},{"title":"Mobile Deployment","local":"mobile-deployment","sections":[{"title":"iOS/macOS with WhisperKit:","local":"iosmacos-with-whisperkit","sections":[],"depth":4},{"title":"Android with whisper.cpp:","local":"android-with-whispercpp","sections":[],"depth":4}],"depth":3},{"title":"Real-Time Streaming","local":"real-time-streaming","sections":[{"title":"Streaming with faster-whisper:","local":"streaming-with-faster-whisper","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Integration with Existing Workflows","local":"integration-with-existing-workflows","sections":[{"title":"Combining with 🤗 Transformers:","local":"combining-with--transformers","sections":[],"depth":3},{"title":"Benchmarking Different Implementations:","local":"benchmarking-different-implementations","sections":[],"depth":3}],"depth":2},{"title":"Best Practices and Recommendations","local":"best-practices-and-recommendations","sections":[{"title":"Choosing the Right Implementation:","local":"choosing-the-right-implementation","sections":[],"depth":3},{"title":"Performance Optimization Tips:","local":"performance-optimization-tips","sections":[],"depth":3},{"title":"Error Handling and Robustness:","local":"error-handling-and-robustness","sections":[],"depth":3}],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function Gl(Ns){return Ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends jl{constructor(f){super(),$l(this,f,Gl,Wl,ul,{})}}export{Sl as component};
