import{s as Wt,f as it,n as zt,o as St}from"../chunks/scheduler.37c15a92.js";import{S as Rt,i as Vt,g as s,s as i,r as d,A as Qt,h as r,f as a,c as n,j as pe,u as M,x as o,k as u,y as Xt,a as l,v as f,d as y,t as w,w as T}from"../chunks/index.2bf4358c.js";import{C as nt}from"../chunks/CodeBlock.4e987730.js";import{C as Pt}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as re,E as Yt}from"../chunks/getInferenceSnippets.97a1e124.js";function Nt(st){let h,ce,oe,me,J,de,j,Me,b,rt=`În această secțiune, vom examina mai îndeaproape clasa <code>Interface</code> și vom înțelege
parametrii principali folosiți pentru a crea una.`,fe,v,ye,U,ot="Veți observa că clasa <code>Interface</code> are 3 parametri necesari:",we,C,ut="<code>Interface(fn, inputs, outputs, ...)</code>",Te,I,pt="Acești parametri sunt:",he,g,ct="<li><code>fn</code>: funcția de predicție care este încapsulată de interfața Gradio. Această funcție poate lua unul sau mai mulți parametri și poate returna una sau mai multe valori</li> <li><code>inputs</code>: tipul(tipurile) componentei de intrare. Gradio oferă multe componente pre-construite precum <code>&quot;image&quot;</code> sau <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: tipul(tipurile) componentei de ieșire. Din nou, Gradio oferă multe componente pre-construite de ex. <code>&quot;image&quot;</code> sau <code>&quot;label&quot;</code>.</li>",Je,x,mt='Pentru o listă completă a componentelor, <a href="https://gradio.app/docs" rel="nofollow">consultați documentația Gradio</a>. Fiecare componentă pre-construită poate fi personalizată prin instanțierea clasei corespunzătoare componentei.',je,k,dt=`De exemplu, așa cum am văzut în <a href="/course/chapter9/2">secțiunea anterioară</a>,
în loc să transmiteți <code>&quot;textbox&quot;</code> la parametrul <code>inputs</code>, puteți transmite o componentă <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> pentru a crea o cutie de text cu 7 linii și o etichetă.`,be,$,Mt="Să aruncăm o privire la un alt exemplu, de data aceasta cu o componentă <code>Audio</code>.",ve,q,Ue,_,ft=`Așa cum am menționat mai devreme, Gradio oferă multe intrări și ieșiri diferite.
Deci să construim o <code>Interface</code> care funcționează cu audio.`,Ce,A,yt=`În acest exemplu, vom construi o funcție audio-la-audio care primește un
fișier audio și pur și simplu îl inversează.`,Ie,B,wt=`Vom folosi pentru intrare componenta <code>Audio</code>. Când folosiți componenta <code>Audio</code>,
puteți specifica dacă doriți ca <code>source</code>-ul audio să fie un fișier pe care utilizatorul
îl încarcă sau un microfon cu care utilizatorul își înregistrează vocea. În acest caz, să
o setăm la <code>&quot;microphone&quot;</code>. Doar pentru distracție, vom adăuga o etichetă la <code>Audio</code>-ul nostru care spune
“Vorbiți aici…“.`,ge,H,Tt=`În plus, am dori să primim audio-ul ca un array numpy pentru a putea cu ușurință
să îl “inversăm”. Deci vom seta <code>&quot;type&quot;</code>-ul să fie <code>&quot;numpy&quot;</code>, care transmite datele de intrare
ca un tuplu de (<code>sample_rate</code>, <code>data</code>) în funcția noastră.`,xe,G,ht=`Vom folosi și componenta de ieșire <code>Audio</code> care poate reda automat
un tuplu cu o rată de eșantionare și un array numpy de date ca fișier audio redabil.
În acest caz, nu avem nevoie să facem nicio personalizare, deci vom folosi scurtătura string
<code>&quot;audio&quot;</code>.`,ke,Z,$e,L,Jt=`Codul de mai sus va produce o interfață ca cea de mai jos (dacă browserul dvs. nu
vă cere permisiuni pentru microfon, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">deschideți demo-ul într-o filă separată</a>.)`,qe,p,jt,_e,E,bt="Acum ar trebui să puteți să vă înregistrați vocea și să vă auziți vorbind în sens invers - înfricoșător 👻!",Ae,W,Be,z,vt=`Să spunem că avem o funcție mai complicată, cu intrări și ieșiri multiple.
În exemplul de mai jos, avem o funcție care primește un index dropdown, o valoare slider și un număr,
și returnează un eșantion audio al unui ton muzical.`,He,S,Ut=`Priviți cum transmitem o listă de componente de intrare și ieșire,
și vedeți dacă puteți urmări ce se întâmplă.`,Ge,R,Ct="Cheia aici este că atunci când transmiteți:",Ze,V,It="<li>o listă de componente de intrare, fiecare componentă corespunde unui parametru în ordine.</li> <li>o listă de componente de ieșire, fiecare componentă corespunde unei valori returnate.</li>",Le,Q,gt="Fragmentul de cod de mai jos arată cum trei componente de intrare se aliniază cu cei trei argumente ai funcției <code>generate_tone()</code>:",Ee,X,We,c,xt,ze,P,Se,Y,kt=`Până acum, am folosit metoda <code>launch()</code> pentru a lansa interfața, dar nu
am discutat cu adevărat ce face.`,Re,N,$t=`În mod implicit, metoda <code>launch()</code> va lansa demo-ul într-un server web care
rulează local. Dacă rulați codul într-un notebook Jupyter sau Colab, atunci
Gradio va incorpora interfața GUI demo în notebook pentru a o putea folosi cu ușurință.`,Ve,D,qt="Puteți personaliza comportamentul <code>launch()</code> prin parametri diferiți:",Qe,F,_t="<li><code>inline</code> - dacă să afișeze interfața inline în notebook-urile Python.</li> <li><code>inbrowser</code> - dacă să lanseze automat interfața într-o filă nouă în browserul implicit.</li> <li><code>share</code> - dacă să creeze un link partajabil public de pe calculatorul dvs. pentru interfață. Cam ca un link Google Drive!</li>",Xe,K,At="Vom acoperi parametrul <code>share</code> în mult mai multe detalii în următoarea secțiune!",Pe,O,Ye,ee,Bt=`Să construim o interfață care vă permite să demonstrați un model de <strong>recunoaștere vocală</strong>.
Pentru a o face interesantă, vom accepta <em>fie</em> o intrare de microfon, fie un fișier încărcat.`,Ne,te,Ht=`Ca de obicei, vom încărca modelul nostru de recunoaștere vocală folosind funcția <code>pipeline()</code> din 🤗 Transformers.
Dacă aveți nevoie de o reîmprospătare rapidă, puteți să vă întoarceți la <a href="/course/chapter1/3">acea secțiune din Capitolul 1</a>. Următorul, vom implementa o funcție <code>transcribe_audio()</code> care procesează audio-ul și returnează transcrierea. În final, vom încapsula această funcție într-o <code>Interface</code> cu componentele <code>Audio</code> pentru intrări și doar text pentru ieșire. În ansamblu, codul pentru această aplicație este următorul:`,De,ae,Fe,le,Gt='Dacă browserul dvs. nu vă cere permisiuni pentru microfon, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">deschideți demo-ul într-o filă separată</a>.',Ke,m,Zt,Oe,ie,Lt=`Asta e! Acum puteți folosi această interfață pentru a transcrie audio. Observați aici că
prin transmiterea parametrului <code>optional</code> ca <code>True</code>, permitem utilizatorului să ofere fie
un microfon, fie un fișier audio (sau niciunul, dar asta va returna un mesaj de eroare).`,et,ne,Et="Continuați să vedeți cum să vă partajați interfața cu alții!",tt,se,at,ue,lt;return J=new re({props:{title:"Înțelegerea clasei Interface",local:"understanding-the-interface-class",headingTag:"h1"}}),j=new Pt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),v=new re({props:{title:"Cum să creați o Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),q=new re({props:{title:"Un exemplu simplu cu audio",local:"a-simple-example-with-audio",headingTag:"h2"}}),Z=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlZvcmJpJUM4JTlCaSUyMGFpY2kuLi4lMjIpJTBBZ3IuSW50ZXJmYWNlKHJldmVyc2VfYXVkaW8lMkMlMjBtaWMlMkMlMjAlMjJhdWRpbyUyMikubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Vorbiți aici...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),W=new re({props:{title:"Gestionarea intrărilor și ieșirilor multiple",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),X=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLk51bWJlcih2YWx1ZSUzRDElMkMlMjBsYWJlbCUzRCUyMkR1cmF0YSUyMCVDMyVBRW4lMjBzZWN1bmRlJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTJDJTBBKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Number(value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Durata în secunde&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),P=new re({props:{title:"Metoda launch()",local:"the-launch-method",headingTag:"h3"}}),O=new re({props:{title:"✏️ Să aplicăm!",local:"lets-apply-it",headingTag:"h2"}}),ae=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKGF1ZGlvKSUzQSUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRCUyMnRleHQlMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio</span>):
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),se=new Yt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/rum/chapter9/3.mdx"}}),{c(){h=s("meta"),ce=i(),oe=s("p"),me=i(),d(J.$$.fragment),de=i(),d(j.$$.fragment),Me=i(),b=s("p"),b.innerHTML=rt,fe=i(),d(v.$$.fragment),ye=i(),U=s("p"),U.innerHTML=ot,we=i(),C=s("p"),C.innerHTML=ut,Te=i(),I=s("p"),I.textContent=pt,he=i(),g=s("ul"),g.innerHTML=ct,Je=i(),x=s("p"),x.innerHTML=mt,je=i(),k=s("p"),k.innerHTML=dt,be=i(),$=s("p"),$.innerHTML=Mt,ve=i(),d(q.$$.fragment),Ue=i(),_=s("p"),_.innerHTML=ft,Ce=i(),A=s("p"),A.textContent=yt,Ie=i(),B=s("p"),B.innerHTML=wt,ge=i(),H=s("p"),H.innerHTML=Tt,xe=i(),G=s("p"),G.innerHTML=ht,ke=i(),d(Z.$$.fragment),$e=i(),L=s("p"),L.innerHTML=Jt,qe=i(),p=s("iframe"),_e=i(),E=s("p"),E.textContent=bt,Ae=i(),d(W.$$.fragment),Be=i(),z=s("p"),z.textContent=vt,He=i(),S=s("p"),S.textContent=Ut,Ge=i(),R=s("p"),R.textContent=Ct,Ze=i(),V=s("ul"),V.innerHTML=It,Le=i(),Q=s("p"),Q.innerHTML=gt,Ee=i(),d(X.$$.fragment),We=i(),c=s("iframe"),ze=i(),d(P.$$.fragment),Se=i(),Y=s("p"),Y.innerHTML=kt,Re=i(),N=s("p"),N.innerHTML=$t,Ve=i(),D=s("p"),D.innerHTML=qt,Qe=i(),F=s("ul"),F.innerHTML=_t,Xe=i(),K=s("p"),K.innerHTML=At,Pe=i(),d(O.$$.fragment),Ye=i(),ee=s("p"),ee.innerHTML=Bt,Ne=i(),te=s("p"),te.innerHTML=Ht,De=i(),d(ae.$$.fragment),Fe=i(),le=s("p"),le.innerHTML=Gt,Ke=i(),m=s("iframe"),Oe=i(),ie=s("p"),ie.innerHTML=Lt,et=i(),ne=s("p"),ne.textContent=Et,tt=i(),d(se.$$.fragment),at=i(),ue=s("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(a),ce=n(e),oe=r(e,"P",{}),pe(oe).forEach(a),me=n(e),M(J.$$.fragment,e),de=n(e),M(j.$$.fragment,e),Me=n(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-r1wiui"&&(b.innerHTML=rt),fe=n(e),M(v.$$.fragment,e),ye=n(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1ezgnph"&&(U.innerHTML=ot),we=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-5xxju6"&&(C.innerHTML=ut),Te=n(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-157p8ns"&&(I.textContent=pt),he=n(e),g=r(e,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-1xvsqts"&&(g.innerHTML=ct),Je=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-qb39kw"&&(x.innerHTML=mt),je=n(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1h06mwz"&&(k.innerHTML=dt),be=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1ef0tzf"&&($.innerHTML=Mt),ve=n(e),M(q.$$.fragment,e),Ue=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1ust65o"&&(_.innerHTML=ft),Ce=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-z9d0lu"&&(A.textContent=yt),Ie=n(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-12uaqlg"&&(B.innerHTML=wt),ge=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-wf2al6"&&(H.innerHTML=Tt),xe=n(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1n6q2hn"&&(G.innerHTML=ht),ke=n(e),M(Z.$$.fragment,e),$e=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-yej8wy"&&(L.innerHTML=Jt),qe=n(e),p=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(p).forEach(a),_e=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-14hovvy"&&(E.textContent=bt),Ae=n(e),M(W.$$.fragment,e),Be=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1twskrf"&&(z.textContent=vt),He=n(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-64mj0s"&&(S.textContent=Ut),Ge=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-telr1b"&&(R.textContent=Ct),Ze=n(e),V=r(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-1t2glab"&&(V.innerHTML=It),Le=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-4ygbqe"&&(Q.innerHTML=gt),Ee=n(e),M(X.$$.fragment,e),We=n(e),c=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(c).forEach(a),ze=n(e),M(P.$$.fragment,e),Se=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1ige77d"&&(Y.innerHTML=kt),Re=n(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-q3eb2l"&&(N.innerHTML=$t),Ve=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-8ffzly"&&(D.innerHTML=qt),Qe=n(e),F=r(e,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-1fu5yup"&&(F.innerHTML=_t),Xe=n(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-exgvul"&&(K.innerHTML=At),Pe=n(e),M(O.$$.fragment,e),Ye=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-9whxpr"&&(ee.innerHTML=Bt),Ne=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1p1xjzp"&&(te.innerHTML=Ht),De=n(e),M(ae.$$.fragment,e),Fe=n(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-10rt9lb"&&(le.innerHTML=Gt),Ke=n(e),m=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(m).forEach(a),Oe=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1wka5dp"&&(ie.innerHTML=Lt),et=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-7ctsba"&&(ne.textContent=Et),tt=n(e),M(se.$$.fragment,e),at=n(e),ue=r(e,"P",{}),pe(ue).forEach(a),this.h()},h(){u(h,"name","hf:doc:metadata"),u(h,"content",Dt),it(p.src,jt="https://course-demos-audio-reverse.hf.space")||u(p,"src",jt),u(p,"frameborder","0"),u(p,"height","250"),u(p,"title","Gradio app"),u(p,"class","container p-0 flex-grow space-iframe"),u(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),it(c.src,xt="https://course-demos-generate-tone.hf.space")||u(c,"src",xt),u(c,"frameborder","0"),u(c,"height","450"),u(c,"title","Gradio app"),u(c,"class","container p-0 flex-grow space-iframe"),u(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),it(m.src,Zt="https://course-demos-asr.hf.space")||u(m,"src",Zt),u(m,"frameborder","0"),u(m,"height","550"),u(m,"title","Gradio app"),u(m,"class","container p-0 flex-grow space-iframe"),u(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Xt(document.head,h),l(e,ce,t),l(e,oe,t),l(e,me,t),f(J,e,t),l(e,de,t),f(j,e,t),l(e,Me,t),l(e,b,t),l(e,fe,t),f(v,e,t),l(e,ye,t),l(e,U,t),l(e,we,t),l(e,C,t),l(e,Te,t),l(e,I,t),l(e,he,t),l(e,g,t),l(e,Je,t),l(e,x,t),l(e,je,t),l(e,k,t),l(e,be,t),l(e,$,t),l(e,ve,t),f(q,e,t),l(e,Ue,t),l(e,_,t),l(e,Ce,t),l(e,A,t),l(e,Ie,t),l(e,B,t),l(e,ge,t),l(e,H,t),l(e,xe,t),l(e,G,t),l(e,ke,t),f(Z,e,t),l(e,$e,t),l(e,L,t),l(e,qe,t),l(e,p,t),l(e,_e,t),l(e,E,t),l(e,Ae,t),f(W,e,t),l(e,Be,t),l(e,z,t),l(e,He,t),l(e,S,t),l(e,Ge,t),l(e,R,t),l(e,Ze,t),l(e,V,t),l(e,Le,t),l(e,Q,t),l(e,Ee,t),f(X,e,t),l(e,We,t),l(e,c,t),l(e,ze,t),f(P,e,t),l(e,Se,t),l(e,Y,t),l(e,Re,t),l(e,N,t),l(e,Ve,t),l(e,D,t),l(e,Qe,t),l(e,F,t),l(e,Xe,t),l(e,K,t),l(e,Pe,t),f(O,e,t),l(e,Ye,t),l(e,ee,t),l(e,Ne,t),l(e,te,t),l(e,De,t),f(ae,e,t),l(e,Fe,t),l(e,le,t),l(e,Ke,t),l(e,m,t),l(e,Oe,t),l(e,ie,t),l(e,et,t),l(e,ne,t),l(e,tt,t),f(se,e,t),l(e,at,t),l(e,ue,t),lt=!0},p:zt,i(e){lt||(y(J.$$.fragment,e),y(j.$$.fragment,e),y(v.$$.fragment,e),y(q.$$.fragment,e),y(Z.$$.fragment,e),y(W.$$.fragment,e),y(X.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(ae.$$.fragment,e),y(se.$$.fragment,e),lt=!0)},o(e){w(J.$$.fragment,e),w(j.$$.fragment,e),w(v.$$.fragment,e),w(q.$$.fragment,e),w(Z.$$.fragment,e),w(W.$$.fragment,e),w(X.$$.fragment,e),w(P.$$.fragment,e),w(O.$$.fragment,e),w(ae.$$.fragment,e),w(se.$$.fragment,e),lt=!1},d(e){e&&(a(ce),a(oe),a(me),a(de),a(Me),a(b),a(fe),a(ye),a(U),a(we),a(C),a(Te),a(I),a(he),a(g),a(Je),a(x),a(je),a(k),a(be),a($),a(ve),a(Ue),a(_),a(Ce),a(A),a(Ie),a(B),a(ge),a(H),a(xe),a(G),a(ke),a($e),a(L),a(qe),a(p),a(_e),a(E),a(Ae),a(Be),a(z),a(He),a(S),a(Ge),a(R),a(Ze),a(V),a(Le),a(Q),a(Ee),a(We),a(c),a(ze),a(Se),a(Y),a(Re),a(N),a(Ve),a(D),a(Qe),a(F),a(Xe),a(K),a(Pe),a(Ye),a(ee),a(Ne),a(te),a(De),a(Fe),a(le),a(Ke),a(m),a(Oe),a(ie),a(et),a(ne),a(tt),a(at),a(ue)),a(h),T(J,e),T(j,e),T(v,e),T(q,e),T(Z,e),T(W,e),T(X,e),T(P,e),T(O,e),T(ae,e),T(se,e)}}}const Dt='{"title":"Înțelegerea clasei Interface","local":"understanding-the-interface-class","sections":[{"title":"Cum să creați o Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"Un exemplu simplu cu audio","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Gestionarea intrărilor și ieșirilor multiple","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"Metoda launch()","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Să aplicăm!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function Ft(st){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class la extends Rt{constructor(h){super(),Vt(this,h,Ft,Nt,Wt,{})}}export{la as component};
