# Interface: BaseArgs

## Properties

### accessToken

• `Optional` **accessToken**: `string`

The access token to use. Without it, you'll get rate-limited quickly.

Can be created for free in hf.co/settings/token

You can also pass an external Inference provider's key if you intend to call a compatible provider like Sambanova, Together, Replicate...

#### Defined in[[accesstoken.defined-in]]

[inference/src/types.ts:96](https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/types.ts#L96)

___

### endpointUrl

• `Optional` **endpointUrl**: `string`

The URL of the endpoint to use.

If not specified, will call the default router.huggingface.co Inference Providers endpoint.

#### Defined in[[endpointurl.defined-in]]

[inference/src/types.ts:113](https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/types.ts#L113)

___

### model

• `Optional` **model**: `string`

The HF model to use.

If not specified, will call huggingface.co/api/tasks to get the default model for the task.

/!\ Legacy behavior allows this to be an URL, but this is deprecated and will be removed in the future.
Use the `endpointUrl` parameter instead.

#### Defined in[[model.defined-in]]

[inference/src/types.ts:106](https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/types.ts#L106)

___

### provider

• `Optional` **provider**: ``"baseten"`` \| ``"black-forest-labs"`` \| ``"cerebras"`` \| ``"cohere"`` \| ``"fal-ai"`` \| ``"featherless-ai"`` \| ``"fireworks-ai"`` \| ``"groq"`` \| ``"hf-inference"`` \| ``"hyperbolic"`` \| ``"nebius"`` \| ``"novita"`` \| ``"nscale"`` \| ``"openai"`` \| ``"ovhcloud"`` \| ``"publicai"`` \| ``"replicate"`` \| ``"sambanova"`` \| ``"scaleway"`` \| ``"together"`` \| ``"zai-org"`` \| ``"auto"``

Set an Inference provider to run this model on.

Defaults to "auto" i.e. the first of the providers available for the model, sorted by the user's order in https://hf.co/settings/inference-providers.

#### Defined in[[provider.defined-in]]

[inference/src/types.ts:120](https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/types.ts#L120)


<EditOnGithub source="https://github.com/huggingface/huggingface.js/blob/main/docs/inference/interfaces/BaseArgs.md" />